# -*- coding: utf-8 -*-
#
# This file is part of SENAITE.CORE
#
# Copyright 2018 by it's authors.
# Some rights reserved. See LICENSE.rst, CONTRIBUTORS.rst.

from bika.lims.browser import BrowserView
from operator import itemgetter
import json
import plone

COUNTRIES = [
 {'Area(in sq km)': '468',
  'Capital': 'Andorra la Vella',
  'Continent': 'EU',
  'Country': 'Andorra',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AD',
  'ISO-Numeric': '020',
  'ISO3': 'AND',
  'Languages': 'ca',
  'Phone': '376',
  'Population': '84000',
  'Postal Code Format': 'AD###',
  'Postal Code Regex': '^(?:AD)*(\\d{3})$',
  'fips': 'AN',
  'geonameid': '3041565',
  'neighbours': 'ES,FR',
  'tld': '.ad'},
 {'Area(in sq km)': '82880',
  'Capital': 'Abu Dhabi',
  'Continent': 'AS',
  'Country': 'United Arab Emirates',
  'CurrencyCode': 'AED',
  'CurrencyName': 'Dirham',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AE',
  'ISO-Numeric': '784',
  'ISO3': 'ARE',
  'Languages': 'ar-AE,fa,en,hi,ur',
  'Phone': '971',
  'Population': '4975593',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AE',
  'geonameid': '290557',
  'neighbours': 'SA,OM',
  'tld': '.ae'},
 {'Area(in sq km)': '647500',
  'Capital': 'Kabul',
  'Continent': 'AS',
  'Country': 'Afghanistan',
  'CurrencyCode': 'AFN',
  'CurrencyName': 'Afghani',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AF',
  'ISO-Numeric': '004',
  'ISO3': 'AFG',
  'Languages': 'fa-AF,ps,uz-AF,tk',
  'Phone': '93',
  'Population': '29121286',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AF',
  'geonameid': '1149361',
  'neighbours': 'TM,CN,IR,TJ,PK,UZ',
  'tld': '.af'},
 {'Area(in sq km)': '443',
  'Capital': "St. John's",
  'Continent': 'NA',
  'Country': 'Antigua and Barbuda',
  'CurrencyCode': 'XCD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AG',
  'ISO-Numeric': '028',
  'ISO3': 'ATG',
  'Languages': 'en-AG',
  'Phone': '+1-268',
  'Population': '86754',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AC',
  'geonameid': '3576396',
  'neighbours': '',
  'tld': '.ag'},
 {'Area(in sq km)': '102',
  'Capital': 'The Valley',
  'Continent': 'NA',
  'Country': 'Anguilla',
  'CurrencyCode': 'XCD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AI',
  'ISO-Numeric': '660',
  'ISO3': 'AIA',
  'Languages': 'en-AI',
  'Phone': '+1-264',
  'Population': '13254',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AV',
  'geonameid': '3573511',
  'neighbours': '',
  'tld': '.ai'},
 {'Area(in sq km)': '28748',
  'Capital': 'Tirana',
  'Continent': 'EU',
  'Country': 'Albania',
  'CurrencyCode': 'ALL',
  'CurrencyName': 'Lek',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AL',
  'ISO-Numeric': '008',
  'ISO3': 'ALB',
  'Languages': 'sq,el',
  'Phone': '355',
  'Population': '2986952',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AL',
  'geonameid': '783754',
  'neighbours': 'MK,GR,CS,ME,RS,XK',
  'tld': '.al'},
 {'Area(in sq km)': '29800',
  'Capital': 'Yerevan',
  'Continent': 'AS',
  'Country': 'Armenia',
  'CurrencyCode': 'AMD',
  'CurrencyName': 'Dram',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AM',
  'ISO-Numeric': '051',
  'ISO3': 'ARM',
  'Languages': 'hy',
  'Phone': '374',
  'Population': '2968000',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'AM',
  'geonameid': '174982',
  'neighbours': 'GE,IR,AZ,TR',
  'tld': '.am'},
 {'Area(in sq km)': '1246700',
  'Capital': 'Luanda',
  'Continent': 'AF',
  'Country': 'Angola',
  'CurrencyCode': 'AOA',
  'CurrencyName': 'Kwanza',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AO',
  'ISO-Numeric': '024',
  'ISO3': 'AGO',
  'Languages': 'pt-AO',
  'Phone': '244',
  'Population': '13068161',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AO',
  'geonameid': '3351879',
  'neighbours': 'CD,NA,ZM,CG',
  'tld': '.ao'},
 {'Area(in sq km)': '1.40E+007',
  'Capital': '',
  'Continent': 'AN',
  'Country': 'Antarctica',
  'CurrencyCode': '',
  'CurrencyName': '',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AQ',
  'ISO-Numeric': '010',
  'ISO3': 'ATA',
  'Languages': '',
  'Phone': '',
  'Population': '0',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AY',
  'geonameid': '6697173',
  'neighbours': '',
  'tld': '.aq'},
 {'Area(in sq km)': '2766890',
  'Capital': 'Buenos Aires',
  'Continent': 'SA',
  'Country': 'Argentina',
  'CurrencyCode': 'ARS',
  'CurrencyName': 'Peso',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AR',
  'ISO-Numeric': '032',
  'ISO3': 'ARG',
  'Languages': 'es-AR,en,it,de,fr,gn',
  'Phone': '54',
  'Population': '41343201',
  'Postal Code Format': '@####@@@',
  'Postal Code Regex': '^([A-Z]\\d{4}[A-Z]{3})$',
  'fips': 'AR',
  'geonameid': '3865483',
  'neighbours': 'CL,BO,UY,PY,BR',
  'tld': '.ar'},
 {'Area(in sq km)': '199',
  'Capital': 'Pago Pago',
  'Continent': 'OC',
  'Country': 'American Samoa',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AS',
  'ISO-Numeric': '016',
  'ISO3': 'ASM',
  'Languages': 'en-AS,sm,to',
  'Phone': '+1-684',
  'Population': '57881',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AQ',
  'geonameid': '5880801',
  'neighbours': '',
  'tld': '.as'},
 {'Area(in sq km)': '83858',
  'Capital': 'Vienna',
  'Continent': 'EU',
  'Country': 'Austria',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AT',
  'ISO-Numeric': '040',
  'ISO3': 'AUT',
  'Languages': 'de-AT,hr,hu,sl',
  'Phone': '43',
  'Population': '8205000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'AU',
  'geonameid': '2782113',
  'neighbours': 'CH,DE,HU,SK,CZ,IT,SI,LI',
  'tld': '.at'},
 {'Area(in sq km)': '7686850',
  'Capital': 'Canberra',
  'Continent': 'OC',
  'Country': 'Australia',
  'CurrencyCode': 'AUD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AU',
  'ISO-Numeric': '036',
  'ISO3': 'AUS',
  'Languages': 'en-AU',
  'Phone': '61',
  'Population': '21515754',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'AS',
  'geonameid': '2077456',
  'neighbours': '',
  'tld': '.au'},
 {'Area(in sq km)': '193',
  'Capital': 'Oranjestad',
  'Continent': 'NA',
  'Country': 'Aruba',
  'CurrencyCode': 'AWG',
  'CurrencyName': 'Guilder',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AW',
  'ISO-Numeric': '533',
  'ISO3': 'ABW',
  'Languages': 'nl-AW,es,en',
  'Phone': '297',
  'Population': '71566',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'AA',
  'geonameid': '3577279',
  'neighbours': '',
  'tld': '.aw'},
 {'Area(in sq km)': '',
  'Capital': 'Mariehamn',
  'Continent': 'EU',
  'Country': 'Aland Islands',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': 'FI\n',
  'ISO': 'AX',
  'ISO-Numeric': '248',
  'ISO3': 'ALA',
  'Languages': 'sv-AX',
  'Phone': '+358-18',
  'Population': '26711',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': '',
  'geonameid': '661882',
  'neighbours': '',
  'tld': '.ax'},
 {'Area(in sq km)': '86600',
  'Capital': 'Baku',
  'Continent': 'AS',
  'Country': 'Azerbaijan',
  'CurrencyCode': 'AZN',
  'CurrencyName': 'Manat',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AZ',
  'ISO-Numeric': '031',
  'ISO3': 'AZE',
  'Languages': 'az,ru,hy',
  'Phone': '994',
  'Population': '8303512',
  'Postal Code Format': 'AZ ####',
  'Postal Code Regex': '^(?:AZ)*(\\d{4})$',
  'fips': 'AJ',
  'geonameid': '587116',
  'neighbours': 'GE,IR,AM,TR,RU',
  'tld': '.az'},
 {'Area(in sq km)': '51129',
  'Capital': 'Sarajevo',
  'Continent': 'EU',
  'Country': 'Bosnia and Herzegovina',
  'CurrencyCode': 'BAM',
  'CurrencyName': 'Marka',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BA',
  'ISO-Numeric': '070',
  'ISO3': 'BIH',
  'Languages': 'bs,hr-BA,sr-BA',
  'Phone': '387',
  'Population': '4590000',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'BK',
  'geonameid': '3277605',
  'neighbours': 'CS,HR,ME,RS',
  'tld': '.ba'},
 {'Area(in sq km)': '431',
  'Capital': 'Bridgetown',
  'Continent': 'NA',
  'Country': 'Barbados',
  'CurrencyCode': 'BBD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BB',
  'ISO-Numeric': '052',
  'ISO3': 'BRB',
  'Languages': 'en-BB',
  'Phone': '+1-246',
  'Population': '285653',
  'Postal Code Format': 'BB#####',
  'Postal Code Regex': '^(?:BB)*(\\d{5})$',
  'fips': 'BB',
  'geonameid': '3374084',
  'neighbours': '',
  'tld': '.bb'},
 {'Area(in sq km)': '144000',
  'Capital': 'Dhaka',
  'Continent': 'AS',
  'Country': 'Bangladesh',
  'CurrencyCode': 'BDT',
  'CurrencyName': 'Taka',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BD',
  'ISO-Numeric': '050',
  'ISO3': 'BGD',
  'Languages': 'bn-BD,en',
  'Phone': '880',
  'Population': '156118464',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'BG',
  'geonameid': '1210997',
  'neighbours': 'MM,IN',
  'tld': '.bd'},
 {'Area(in sq km)': '30510',
  'Capital': 'Brussels',
  'Continent': 'EU',
  'Country': 'Belgium',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BE',
  'ISO-Numeric': '056',
  'ISO3': 'BEL',
  'Languages': 'nl-BE,fr-BE,de-BE',
  'Phone': '32',
  'Population': '10403000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'BE',
  'geonameid': '2802361',
  'neighbours': 'DE,NL,LU,FR',
  'tld': '.be'},
 {'Area(in sq km)': '274200',
  'Capital': 'Ouagadougou',
  'Continent': 'AF',
  'Country': 'Burkina Faso',
  'CurrencyCode': 'XOF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BF',
  'ISO-Numeric': '854',
  'ISO3': 'BFA',
  'Languages': 'fr-BF',
  'Phone': '226',
  'Population': '16241811',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'UV',
  'geonameid': '2361809',
  'neighbours': 'NE,BJ,GH,CI,TG,ML',
  'tld': '.bf'},
 {'Area(in sq km)': '110910',
  'Capital': 'Sofia',
  'Continent': 'EU',
  'Country': 'Bulgaria',
  'CurrencyCode': 'BGN',
  'CurrencyName': 'Lev',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BG',
  'ISO-Numeric': '100',
  'ISO3': 'BGR',
  'Languages': 'bg,tr-BG',
  'Phone': '359',
  'Population': '7148785',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'BU',
  'geonameid': '732800',
  'neighbours': 'MK,GR,RO,CS,TR,RS',
  'tld': '.bg'},
 {'Area(in sq km)': '665',
  'Capital': 'Manama',
  'Continent': 'AS',
  'Country': 'Bahrain',
  'CurrencyCode': 'BHD',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BH',
  'ISO-Numeric': '048',
  'ISO3': 'BHR',
  'Languages': 'ar-BH,en,fa,ur',
  'Phone': '973',
  'Population': '738004',
  'Postal Code Format': '####|###',
  'Postal Code Regex': '^(\\d{3}\\d?)$',
  'fips': 'BA',
  'geonameid': '290291',
  'neighbours': '',
  'tld': '.bh'},
 {'Area(in sq km)': '27830',
  'Capital': 'Bujumbura',
  'Continent': 'AF',
  'Country': 'Burundi',
  'CurrencyCode': 'BIF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BI',
  'ISO-Numeric': '108',
  'ISO3': 'BDI',
  'Languages': 'fr-BI,rn',
  'Phone': '257',
  'Population': '9863117',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BY',
  'geonameid': '433561',
  'neighbours': 'TZ,CD,RW',
  'tld': '.bi'},
 {'Area(in sq km)': '112620',
  'Capital': 'Porto-Novo',
  'Continent': 'AF',
  'Country': 'Benin',
  'CurrencyCode': 'XOF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BJ',
  'ISO-Numeric': '204',
  'ISO3': 'BEN',
  'Languages': 'fr-BJ',
  'Phone': '229',
  'Population': '9056010',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BN',
  'geonameid': '2395170',
  'neighbours': 'NE,TG,BF,NG',
  'tld': '.bj'},
 {'Area(in sq km)': '21',
  'Capital': 'Gustavia',
  'Continent': 'NA',
  'Country': 'Saint Barthelemy',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BL',
  'ISO-Numeric': '652',
  'ISO3': 'BLM',
  'Languages': 'fr',
  'Phone': '590',
  'Population': '8450',
  'Postal Code Format': '### ###',
  'Postal Code Regex': '',
  'fips': 'TB',
  'geonameid': '3578476',
  'neighbours': '',
  'tld': '.gp'},
 {'Area(in sq km)': '53',
  'Capital': 'Hamilton',
  'Continent': 'NA',
  'Country': 'Bermuda',
  'CurrencyCode': 'BMD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BM',
  'ISO-Numeric': '060',
  'ISO3': 'BMU',
  'Languages': 'en-BM,pt',
  'Phone': '+1-441',
  'Population': '65365',
  'Postal Code Format': '@@ ##',
  'Postal Code Regex': '^([A-Z]{2}\\d{2})$',
  'fips': 'BD',
  'geonameid': '3573345',
  'neighbours': '',
  'tld': '.bm'},
 {'Area(in sq km)': '5770',
  'Capital': 'Bandar Seri Begawan',
  'Continent': 'AS',
  'Country': 'Brunei',
  'CurrencyCode': 'BND',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BN',
  'ISO-Numeric': '096',
  'ISO3': 'BRN',
  'Languages': 'ms-BN,en-BN',
  'Phone': '673',
  'Population': '395027',
  'Postal Code Format': '@@####',
  'Postal Code Regex': '^([A-Z]{2}\\d{4})$',
  'fips': 'BX',
  'geonameid': '1820814',
  'neighbours': 'MY',
  'tld': '.bn'},
 {'Area(in sq km)': '1098580',
  'Capital': 'Sucre',
  'Continent': 'SA',
  'Country': 'Bolivia',
  'CurrencyCode': 'BOB',
  'CurrencyName': 'Boliviano',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BO',
  'ISO-Numeric': '068',
  'ISO3': 'BOL',
  'Languages': 'es-BO,qu,ay',
  'Phone': '591',
  'Population': '9947418',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BL',
  'geonameid': '3923057',
  'neighbours': 'PE,CL,PY,BR,AR',
  'tld': '.bo'},
 {'Area(in sq km)': '',
  'Capital': '',
  'Continent': 'NA',
  'Country': 'Bonaire, Saint Eustatius and Saba ',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BQ',
  'ISO-Numeric': '535',
  'ISO3': 'BES',
  'Languages': 'nl,pap,en',
  'Phone': '599',
  'Population': '18012',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': '',
  'geonameid': '7626844',
  'neighbours': '',
  'tld': '.bq'},
 {'Area(in sq km)': '8511965',
  'Capital': 'Brasilia',
  'Continent': 'SA',
  'Country': 'Brazil',
  'CurrencyCode': 'BRL',
  'CurrencyName': 'Real',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BR',
  'ISO-Numeric': '076',
  'ISO3': 'BRA',
  'Languages': 'pt-BR,es,en,fr',
  'Phone': '55',
  'Population': '201103330',
  'Postal Code Format': '#####-###',
  'Postal Code Regex': '^(\\d{8})$',
  'fips': 'BR',
  'geonameid': '3469034',
  'neighbours': 'SR,PE,BO,UY,GY,PY,GF,VE,CO,AR',
  'tld': '.br'},
 {'Area(in sq km)': '13940',
  'Capital': 'Nassau',
  'Continent': 'NA',
  'Country': 'Bahamas',
  'CurrencyCode': 'BSD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BS',
  'ISO-Numeric': '044',
  'ISO3': 'BHS',
  'Languages': 'en-BS',
  'Phone': '+1-242',
  'Population': '301790',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BF',
  'geonameid': '3572887',
  'neighbours': '',
  'tld': '.bs'},
 {'Area(in sq km)': '47000',
  'Capital': 'Thimphu',
  'Continent': 'AS',
  'Country': 'Bhutan',
  'CurrencyCode': 'BTN',
  'CurrencyName': 'Ngultrum',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BT',
  'ISO-Numeric': '064',
  'ISO3': 'BTN',
  'Languages': 'dz',
  'Phone': '975',
  'Population': '699847',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BT',
  'geonameid': '1252634',
  'neighbours': 'CN,IN',
  'tld': '.bt'},
 {'Area(in sq km)': '',
  'Capital': '',
  'Continent': 'AN',
  'Country': 'Bouvet Island',
  'CurrencyCode': 'NOK',
  'CurrencyName': 'Krone',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BV',
  'ISO-Numeric': '074',
  'ISO3': 'BVT',
  'Languages': '',
  'Phone': '',
  'Population': '0',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BV',
  'geonameid': '3371123',
  'neighbours': '',
  'tld': '.bv'},
 {'Area(in sq km)': '600370',
  'Capital': 'Gaborone',
  'Continent': 'AF',
  'Country': 'Botswana',
  'CurrencyCode': 'BWP',
  'CurrencyName': 'Pula',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BW',
  'ISO-Numeric': '072',
  'ISO3': 'BWA',
  'Languages': 'en-BW,tn-BW',
  'Phone': '267',
  'Population': '2029307',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BC',
  'geonameid': '933860',
  'neighbours': 'ZW,ZA,NA',
  'tld': '.bw'},
 {'Area(in sq km)': '207600',
  'Capital': 'Minsk',
  'Continent': 'EU',
  'Country': 'Belarus',
  'CurrencyCode': 'BYR',
  'CurrencyName': 'Ruble',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BY',
  'ISO-Numeric': '112',
  'ISO3': 'BLR',
  'Languages': 'be,ru',
  'Phone': '375',
  'Population': '9685000',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'BO',
  'geonameid': '630336',
  'neighbours': 'PL,LT,UA,RU,LV',
  'tld': '.by'},
 {'Area(in sq km)': '22966',
  'Capital': 'Belmopan',
  'Continent': 'NA',
  'Country': 'Belize',
  'CurrencyCode': 'BZD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'BZ',
  'ISO-Numeric': '084',
  'ISO3': 'BLZ',
  'Languages': 'en-BZ,es',
  'Phone': '501',
  'Population': '314522',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BH',
  'geonameid': '3582678',
  'neighbours': 'GT,MX',
  'tld': '.bz'},
 {'Area(in sq km)': '9984670',
  'Capital': 'Ottawa',
  'Continent': 'NA',
  'Country': 'Canada',
  'CurrencyCode': 'CAD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CA',
  'ISO-Numeric': '124',
  'ISO3': 'CAN',
  'Languages': 'en-CA,fr-CA,iu',
  'Phone': '1',
  'Population': '33679000',
  'Postal Code Format': '@#@ #@#',
  'Postal Code Regex': '^([a-zA-Z]\\d[a-zA-Z]\\d[a-zA-Z]\\d)$',
  'fips': 'CA',
  'geonameid': '6251999',
  'neighbours': 'US',
  'tld': '.ca'},
 {'Area(in sq km)': '14',
  'Capital': 'West Island',
  'Continent': 'AS',
  'Country': 'Cocos Islands',
  'CurrencyCode': 'AUD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CC',
  'ISO-Numeric': '166',
  'ISO3': 'CCK',
  'Languages': 'ms-CC,en',
  'Phone': '61',
  'Population': '628',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CK',
  'geonameid': '1547376',
  'neighbours': '',
  'tld': '.cc'},
 {'Area(in sq km)': '2345410',
  'Capital': 'Kinshasa',
  'Continent': 'AF',
  'Country': 'Democratic Republic of the Congo',
  'CurrencyCode': 'CDF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CD',
  'ISO-Numeric': '180',
  'ISO3': 'COD',
  'Languages': 'fr-CD,ln,kg',
  'Phone': '243',
  'Population': '70916439',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CG',
  'geonameid': '203312',
  'neighbours': 'TZ,CF,SS,RW,ZM,BI,UG,CG,AO',
  'tld': '.cd'},
 {'Area(in sq km)': '622984',
  'Capital': 'Bangui',
  'Continent': 'AF',
  'Country': 'Central African Republic',
  'CurrencyCode': 'XAF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CF',
  'ISO-Numeric': '140',
  'ISO3': 'CAF',
  'Languages': 'fr-CF,sg,ln,kg',
  'Phone': '236',
  'Population': '4844927',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CT',
  'geonameid': '239880',
  'neighbours': 'TD,SD,CD,SS,CM,CG',
  'tld': '.cf'},
 {'Area(in sq km)': '342000',
  'Capital': 'Brazzaville',
  'Continent': 'AF',
  'Country': 'Republic of the Congo',
  'CurrencyCode': 'XAF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CG',
  'ISO-Numeric': '178',
  'ISO3': 'COG',
  'Languages': 'fr-CG,kg,ln-CG',
  'Phone': '242',
  'Population': '3039126',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CF',
  'geonameid': '2260494',
  'neighbours': 'CF,GA,CD,CM,AO',
  'tld': '.cg'},
 {'Area(in sq km)': '41290',
  'Capital': 'Berne',
  'Continent': 'EU',
  'Country': 'Switzerland',
  'CurrencyCode': 'CHF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CH',
  'ISO-Numeric': '756',
  'ISO3': 'CHE',
  'Languages': 'de-CH,fr-CH,it-CH,rm',
  'Phone': '41',
  'Population': '7581000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'SZ',
  'geonameid': '2658434',
  'neighbours': 'DE,IT,LI,FR,AT',
  'tld': '.ch'},
 {'Area(in sq km)': '322460',
  'Capital': 'Yamoussoukro',
  'Continent': 'AF',
  'Country': 'Ivory Coast',
  'CurrencyCode': 'XOF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CI',
  'ISO-Numeric': '384',
  'ISO3': 'CIV',
  'Languages': 'fr-CI',
  'Phone': '225',
  'Population': '21058798',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'IV',
  'geonameid': '2287781',
  'neighbours': 'LR,GH,GN,BF,ML',
  'tld': '.ci'},
 {'Area(in sq km)': '240',
  'Capital': 'Avarua',
  'Continent': 'OC',
  'Country': 'Cook Islands',
  'CurrencyCode': 'NZD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CK',
  'ISO-Numeric': '184',
  'ISO3': 'COK',
  'Languages': 'en-CK,mi',
  'Phone': '682',
  'Population': '21388',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CW',
  'geonameid': '1899402',
  'neighbours': '',
  'tld': '.ck'},
 {'Area(in sq km)': '756950',
  'Capital': 'Santiago',
  'Continent': 'SA',
  'Country': 'Chile',
  'CurrencyCode': 'CLP',
  'CurrencyName': 'Peso',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CL',
  'ISO-Numeric': '152',
  'ISO3': 'CHL',
  'Languages': 'es-CL',
  'Phone': '56',
  'Population': '16746491',
  'Postal Code Format': '#######',
  'Postal Code Regex': '^(\\d{7})$',
  'fips': 'CI',
  'geonameid': '3895114',
  'neighbours': 'PE,BO,AR',
  'tld': '.cl'},
 {'Area(in sq km)': '475440',
  'Capital': 'Yaounde',
  'Continent': 'AF',
  'Country': 'Cameroon',
  'CurrencyCode': 'XAF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CM',
  'ISO-Numeric': '120',
  'ISO3': 'CMR',
  'Languages': 'en-CM,fr-CM',
  'Phone': '237',
  'Population': '19294149',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CM',
  'geonameid': '2233387',
  'neighbours': 'TD,CF,GA,GQ,CG,NG',
  'tld': '.cm'},
 {'Area(in sq km)': '9596960',
  'Capital': 'Beijing',
  'Continent': 'AS',
  'Country': 'China',
  'CurrencyCode': 'CNY',
  'CurrencyName': 'Yuan Renminbi',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CN',
  'ISO-Numeric': '156',
  'ISO3': 'CHN',
  'Languages': 'zh-CN,yue,wuu,dta,ug,za',
  'Phone': '86',
  'Population': '1330044000',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'CH',
  'geonameid': '1814991',
  'neighbours': 'LA,BT,TJ,KZ,MN,AF,NP,MM,KG,PK,KP,RU,VN,IN',
  'tld': '.cn'},
 {'Area(in sq km)': '1138910',
  'Capital': 'Bogota',
  'Continent': 'SA',
  'Country': 'Colombia',
  'CurrencyCode': 'COP',
  'CurrencyName': 'Peso',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CO',
  'ISO-Numeric': '170',
  'ISO3': 'COL',
  'Languages': 'es-CO',
  'Phone': '57',
  'Population': '44205293',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CO',
  'geonameid': '3686110',
  'neighbours': 'EC,PE,PA,BR,VE',
  'tld': '.co'},
 {'Area(in sq km)': '51100',
  'Capital': 'San Jose',
  'Continent': 'NA',
  'Country': 'Costa Rica',
  'CurrencyCode': 'CRC',
  'CurrencyName': 'Colon',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CR',
  'ISO-Numeric': '188',
  'ISO3': 'CRI',
  'Languages': 'es-CR,en',
  'Phone': '506',
  'Population': '4516220',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'CS',
  'geonameid': '3624060',
  'neighbours': 'PA,NI',
  'tld': '.cr'},
 {'Area(in sq km)': '110860',
  'Capital': 'Havana',
  'Continent': 'NA',
  'Country': 'Cuba',
  'CurrencyCode': 'CUP',
  'CurrencyName': 'Peso',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CU',
  'ISO-Numeric': '192',
  'ISO3': 'CUB',
  'Languages': 'es-CU',
  'Phone': '53',
  'Population': '11423000',
  'Postal Code Format': 'CP #####',
  'Postal Code Regex': '^(?:CP)*(\\d{5})$',
  'fips': 'CU',
  'geonameid': '3562981',
  'neighbours': 'US',
  'tld': '.cu'},
 {'Area(in sq km)': '4033',
  'Capital': 'Praia',
  'Continent': 'AF',
  'Country': 'Cape Verde',
  'CurrencyCode': 'CVE',
  'CurrencyName': 'Escudo',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CV',
  'ISO-Numeric': '132',
  'ISO3': 'CPV',
  'Languages': 'pt-CV',
  'Phone': '238',
  'Population': '508659',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'CV',
  'geonameid': '3374766',
  'neighbours': '',
  'tld': '.cv'},
 {'Area(in sq km)': '',
  'Capital': ' Willemstad',
  'Continent': 'NA',
  'Country': 'Curacao',
  'CurrencyCode': 'ANG',
  'CurrencyName': 'Guilder',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CW',
  'ISO-Numeric': '531',
  'ISO3': 'CUW',
  'Languages': 'nl,pap',
  'Phone': '599',
  'Population': '141766',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'UC',
  'geonameid': '7626836',
  'neighbours': '',
  'tld': '.cw'},
 {'Area(in sq km)': '135',
  'Capital': 'Flying Fish Cove',
  'Continent': 'AS',
  'Country': 'Christmas Island',
  'CurrencyCode': 'AUD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CX',
  'ISO-Numeric': '162',
  'ISO3': 'CXR',
  'Languages': 'en,zh,ms-CC',
  'Phone': '61',
  'Population': '1500',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'KT',
  'geonameid': '2078138',
  'neighbours': '',
  'tld': '.cx'},
 {'Area(in sq km)': '9250',
  'Capital': 'Nicosia',
  'Continent': 'EU',
  'Country': 'Cyprus',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CY',
  'ISO-Numeric': '196',
  'ISO3': 'CYP',
  'Languages': 'el-CY,tr-CY,en',
  'Phone': '357',
  'Population': '1102677',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'CY',
  'geonameid': '146669',
  'neighbours': '',
  'tld': '.cy'},
 {'Area(in sq km)': '78866',
  'Capital': 'Prague',
  'Continent': 'EU',
  'Country': 'Czech Republic',
  'CurrencyCode': 'CZK',
  'CurrencyName': 'Koruna',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CZ',
  'ISO-Numeric': '203',
  'ISO3': 'CZE',
  'Languages': 'cs,sk',
  'Phone': '420',
  'Population': '10476000',
  'Postal Code Format': '### ##',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'EZ',
  'geonameid': '3077311',
  'neighbours': 'PL,DE,SK,AT',
  'tld': '.cz'},
 {'Area(in sq km)': '357021',
  'Capital': 'Berlin',
  'Continent': 'EU',
  'Country': 'Germany',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'DE',
  'ISO-Numeric': '276',
  'ISO3': 'DEU',
  'Languages': 'de',
  'Phone': '49',
  'Population': '81802257',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'GM',
  'geonameid': '2921044',
  'neighbours': 'CH,PL,NL,DK,BE,CZ,LU,FR,AT',
  'tld': '.de'},
 {'Area(in sq km)': '23000',
  'Capital': 'Djibouti',
  'Continent': 'AF',
  'Country': 'Djibouti',
  'CurrencyCode': 'DJF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'DJ',
  'ISO-Numeric': '262',
  'ISO3': 'DJI',
  'Languages': 'fr-DJ,ar,so-DJ,aa',
  'Phone': '253',
  'Population': '740528',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'DJ',
  'geonameid': '223816',
  'neighbours': 'ER,ET,SO',
  'tld': '.dj'},
 {'Area(in sq km)': '43094',
  'Capital': 'Copenhagen',
  'Continent': 'EU',
  'Country': 'Denmark',
  'CurrencyCode': 'DKK',
  'CurrencyName': 'Krone',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'DK',
  'ISO-Numeric': '208',
  'ISO3': 'DNK',
  'Languages': 'da-DK,en,fo,de-DK',
  'Phone': '45',
  'Population': '5484000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'DA',
  'geonameid': '2623032',
  'neighbours': 'DE',
  'tld': '.dk'},
 {'Area(in sq km)': '754',
  'Capital': 'Roseau',
  'Continent': 'NA',
  'Country': 'Dominica',
  'CurrencyCode': 'XCD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'DM',
  'ISO-Numeric': '212',
  'ISO3': 'DMA',
  'Languages': 'en-DM',
  'Phone': '+1-767',
  'Population': '72813',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'DO',
  'geonameid': '3575830',
  'neighbours': '',
  'tld': '.dm'},
 {'Area(in sq km)': '48730',
  'Capital': 'Santo Domingo',
  'Continent': 'NA',
  'Country': 'Dominican Republic',
  'CurrencyCode': 'DOP',
  'CurrencyName': 'Peso',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'DO',
  'ISO-Numeric': '214',
  'ISO3': 'DOM',
  'Languages': 'es-DO',
  'Phone': '+1-809 and 1-829',
  'Population': '9823821',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'DR',
  'geonameid': '3508796',
  'neighbours': 'HT',
  'tld': '.do'},
 {'Area(in sq km)': '2381740',
  'Capital': 'Algiers',
  'Continent': 'AF',
  'Country': 'Algeria',
  'CurrencyCode': 'DZD',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'DZ',
  'ISO-Numeric': '012',
  'ISO3': 'DZA',
  'Languages': 'ar-DZ',
  'Phone': '213',
  'Population': '34586184',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'AG',
  'geonameid': '2589581',
  'neighbours': 'NE,EH,LY,MR,TN,MA,ML',
  'tld': '.dz'},
 {'Area(in sq km)': '283560',
  'Capital': 'Quito',
  'Continent': 'SA',
  'Country': 'Ecuador',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'EC',
  'ISO-Numeric': '218',
  'ISO3': 'ECU',
  'Languages': 'es-EC',
  'Phone': '593',
  'Population': '14790608',
  'Postal Code Format': '@####@',
  'Postal Code Regex': '^([a-zA-Z]\\d{4}[a-zA-Z])$',
  'fips': 'EC',
  'geonameid': '3658394',
  'neighbours': 'PE,CO',
  'tld': '.ec'},
 {'Area(in sq km)': '45226',
  'Capital': 'Tallinn',
  'Continent': 'EU',
  'Country': 'Estonia',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'EE',
  'ISO-Numeric': '233',
  'ISO3': 'EST',
  'Languages': 'et,ru',
  'Phone': '372',
  'Population': '1291170',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'EN',
  'geonameid': '453733',
  'neighbours': 'RU,LV',
  'tld': '.ee'},
 {'Area(in sq km)': '1001450',
  'Capital': 'Cairo',
  'Continent': 'AF',
  'Country': 'Egypt',
  'CurrencyCode': 'EGP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'EG',
  'ISO-Numeric': '818',
  'ISO3': 'EGY',
  'Languages': 'ar-EG,en,fr',
  'Phone': '20',
  'Population': '80471869',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'EG',
  'geonameid': '357994',
  'neighbours': 'LY,SD,IL',
  'tld': '.eg'},
 {'Area(in sq km)': '266000',
  'Capital': 'El-Aaiun',
  'Continent': 'AF',
  'Country': 'Western Sahara',
  'CurrencyCode': 'MAD',
  'CurrencyName': 'Dirham',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'EH',
  'ISO-Numeric': '732',
  'ISO3': 'ESH',
  'Languages': 'ar,mey',
  'Phone': '212',
  'Population': '273008',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'WI',
  'geonameid': '2461445',
  'neighbours': 'DZ,MR,MA',
  'tld': '.eh'},
 {'Area(in sq km)': '121320',
  'Capital': 'Asmara',
  'Continent': 'AF',
  'Country': 'Eritrea',
  'CurrencyCode': 'ERN',
  'CurrencyName': 'Nakfa',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ER',
  'ISO-Numeric': '232',
  'ISO3': 'ERI',
  'Languages': 'aa-ER,ar,tig,kun,ti-ER',
  'Phone': '291',
  'Population': '5792984',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'ER',
  'geonameid': '338010',
  'neighbours': 'ET,SD,DJ',
  'tld': '.er'},
 {'Area(in sq km)': '504782',
  'Capital': 'Madrid',
  'Continent': 'EU',
  'Country': 'Spain',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ES',
  'ISO-Numeric': '724',
  'ISO3': 'ESP',
  'Languages': 'es-ES,ca,gl,eu,oc',
  'Phone': '34',
  'Population': '46505963',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'SP',
  'geonameid': '2510769',
  'neighbours': 'AD,PT,GI,FR,MA',
  'tld': '.es'},
 {'Area(in sq km)': '1127127',
  'Capital': 'Addis Ababa',
  'Continent': 'AF',
  'Country': 'Ethiopia',
  'CurrencyCode': 'ETB',
  'CurrencyName': 'Birr',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ET',
  'ISO-Numeric': '231',
  'ISO3': 'ETH',
  'Languages': 'am,en-ET,om-ET,ti-ET,so-ET,sid',
  'Phone': '251',
  'Population': '88013491',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'ET',
  'geonameid': '337996',
  'neighbours': 'ER,KE,SD,SS,SO,DJ',
  'tld': '.et'},
 {'Area(in sq km)': '337030',
  'Capital': 'Helsinki',
  'Continent': 'EU',
  'Country': 'Finland',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'FI',
  'ISO-Numeric': '246',
  'ISO3': 'FIN',
  'Languages': 'fi-FI,sv-FI,smn',
  'Phone': '358',
  'Population': '5244000',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(?:FI)*(\\d{5})$',
  'fips': 'FI',
  'geonameid': '660013',
  'neighbours': 'NO,RU,SE',
  'tld': '.fi'},
 {'Area(in sq km)': '18270',
  'Capital': 'Suva',
  'Continent': 'OC',
  'Country': 'Fiji',
  'CurrencyCode': 'FJD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'FJ',
  'ISO-Numeric': '242',
  'ISO3': 'FJI',
  'Languages': 'en-FJ,fj',
  'Phone': '679',
  'Population': '875983',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'FJ',
  'geonameid': '2205218',
  'neighbours': '',
  'tld': '.fj'},
 {'Area(in sq km)': '12173',
  'Capital': 'Stanley',
  'Continent': 'SA',
  'Country': 'Falkland Islands',
  'CurrencyCode': 'FKP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'FK',
  'ISO-Numeric': '238',
  'ISO3': 'FLK',
  'Languages': 'en-FK',
  'Phone': '500',
  'Population': '2638',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'FK',
  'geonameid': '3474414',
  'neighbours': '',
  'tld': '.fk'},
 {'Area(in sq km)': '702',
  'Capital': 'Palikir',
  'Continent': 'OC',
  'Country': 'Micronesia',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'FM',
  'ISO-Numeric': '583',
  'ISO3': 'FSM',
  'Languages': 'en-FM,chk,pon,yap,kos,uli,woe,nkr,kpg',
  'Phone': '691',
  'Population': '107708',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'FM',
  'geonameid': '2081918',
  'neighbours': '',
  'tld': '.fm'},
 {'Area(in sq km)': '1399',
  'Capital': 'Torshavn',
  'Continent': 'EU',
  'Country': 'Faroe Islands',
  'CurrencyCode': 'DKK',
  'CurrencyName': 'Krone',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'FO',
  'ISO-Numeric': '234',
  'ISO3': 'FRO',
  'Languages': 'fo,da-FO',
  'Phone': '298',
  'Population': '48228',
  'Postal Code Format': 'FO-###',
  'Postal Code Regex': '^(?:FO)*(\\d{3})$',
  'fips': 'FO',
  'geonameid': '2622320',
  'neighbours': '',
  'tld': '.fo'},
 {'Area(in sq km)': '547030',
  'Capital': 'Paris',
  'Continent': 'EU',
  'Country': 'France',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'FR',
  'ISO-Numeric': '250',
  'ISO3': 'FRA',
  'Languages': 'fr-FR,frp,br,co,ca,eu,oc',
  'Phone': '33',
  'Population': '64768389',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'FR',
  'geonameid': '3017382',
  'neighbours': 'CH,DE,BE,LU,IT,AD,MC,ES',
  'tld': '.fr'},
 {'Area(in sq km)': '267667',
  'Capital': 'Libreville',
  'Continent': 'AF',
  'Country': 'Gabon',
  'CurrencyCode': 'XAF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GA',
  'ISO-Numeric': '266',
  'ISO3': 'GAB',
  'Languages': 'fr-GA',
  'Phone': '241',
  'Population': '1545255',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'GB',
  'geonameid': '2400553',
  'neighbours': 'CM,GQ,CG',
  'tld': '.ga'},
 {'Area(in sq km)': '244820',
  'Capital': 'London',
  'Continent': 'EU',
  'Country': 'United Kingdom',
  'CurrencyCode': 'GBP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GB',
  'ISO-Numeric': '826',
  'ISO3': 'GBR',
  'Languages': 'en-GB,cy-GB,gd',
  'Phone': '44',
  'Population': '62348447',
  'Postal Code Format': '@# #@@|@## #@@|@@# #@@|@@## #@@|@#@ #@@|@@#@ #@@|GIR0AA',
  'Postal Code Regex': '^(([A-Z]\\d{2}[A-Z]{2})|([A-Z]\\d{3}[A-Z]{2})|([A-Z]{2}\\d{2}[A-Z]{2})|([A-Z]{2}\\d{3}[A-Z]{2})|([A-Z]\\d[A-Z]\\d[A-Z]{2})|([A-Z]{2}\\d[A-Z]\\d[A-Z]{2})|(GIR0AA))$',
  'fips': 'UK',
  'geonameid': '2635167',
  'neighbours': 'IE',
  'tld': '.uk'},
 {'Area(in sq km)': '344',
  'Capital': "St. George's",
  'Continent': 'NA',
  'Country': 'Grenada',
  'CurrencyCode': 'XCD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GD',
  'ISO-Numeric': '308',
  'ISO3': 'GRD',
  'Languages': 'en-GD',
  'Phone': '+1-473',
  'Population': '107818',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'GJ',
  'geonameid': '3580239',
  'neighbours': '',
  'tld': '.gd'},
 {'Area(in sq km)': '69700',
  'Capital': 'Tbilisi',
  'Continent': 'AS',
  'Country': 'Georgia',
  'CurrencyCode': 'GEL',
  'CurrencyName': 'Lari',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GE',
  'ISO-Numeric': '268',
  'ISO3': 'GEO',
  'Languages': 'ka,ru,hy,az',
  'Phone': '995',
  'Population': '4630000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'GG',
  'geonameid': '614540',
  'neighbours': 'AM,AZ,TR,RU',
  'tld': '.ge'},
 {'Area(in sq km)': '91000',
  'Capital': 'Cayenne',
  'Continent': 'SA',
  'Country': 'French Guiana',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GF',
  'ISO-Numeric': '254',
  'ISO3': 'GUF',
  'Languages': 'fr-GF',
  'Phone': '594',
  'Population': '195506',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^((97)|(98)3\\d{2})$',
  'fips': 'FG',
  'geonameid': '3381670',
  'neighbours': 'SR,BR',
  'tld': '.gf'},
 {'Area(in sq km)': '78',
  'Capital': 'St Peter Port',
  'Continent': 'EU',
  'Country': 'Guernsey',
  'CurrencyCode': 'GBP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GG',
  'ISO-Numeric': '831',
  'ISO3': 'GGY',
  'Languages': 'en,fr',
  'Phone': '+44-1481',
  'Population': '65228',
  'Postal Code Format': '@# #@@|@## #@@|@@# #@@|@@## #@@|@#@ #@@|@@#@ #@@|GIR0AA',
  'Postal Code Regex': '^(([A-Z]\\d{2}[A-Z]{2})|([A-Z]\\d{3}[A-Z]{2})|([A-Z]{2}\\d{2}[A-Z]{2})|([A-Z]{2}\\d{3}[A-Z]{2})|([A-Z]\\d[A-Z]\\d[A-Z]{2})|([A-Z]{2}\\d[A-Z]\\d[A-Z]{2})|(GIR0AA))$',
  'fips': 'GK',
  'geonameid': '3042362',
  'neighbours': '',
  'tld': '.gg'},
 {'Area(in sq km)': '239460',
  'Capital': 'Accra',
  'Continent': 'AF',
  'Country': 'Ghana',
  'CurrencyCode': 'GHS',
  'CurrencyName': 'Cedi',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GH',
  'ISO-Numeric': '288',
  'ISO3': 'GHA',
  'Languages': 'en-GH,ak,ee,tw',
  'Phone': '233',
  'Population': '24339838',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'GH',
  'geonameid': '2300660',
  'neighbours': 'CI,TG,BF',
  'tld': '.gh'},
 {'Area(in sq km)': '6.5',
  'Capital': 'Gibraltar',
  'Continent': 'EU',
  'Country': 'Gibraltar',
  'CurrencyCode': 'GIP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GI',
  'ISO-Numeric': '292',
  'ISO3': 'GIB',
  'Languages': 'en-GI,es,it,pt',
  'Phone': '350',
  'Population': '27884',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'GI',
  'geonameid': '2411586',
  'neighbours': 'ES',
  'tld': '.gi'},
 {'Area(in sq km)': '2166086',
  'Capital': 'Nuuk',
  'Continent': 'NA',
  'Country': 'Greenland',
  'CurrencyCode': 'DKK',
  'CurrencyName': 'Krone',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GL',
  'ISO-Numeric': '304',
  'ISO3': 'GRL',
  'Languages': 'kl,da-GL,en',
  'Phone': '299',
  'Population': '56375',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'GL',
  'geonameid': '3425505',
  'neighbours': '',
  'tld': '.gl'},
 {'Area(in sq km)': '11300',
  'Capital': 'Banjul',
  'Continent': 'AF',
  'Country': 'Gambia',
  'CurrencyCode': 'GMD',
  'CurrencyName': 'Dalasi',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GM',
  'ISO-Numeric': '270',
  'ISO3': 'GMB',
  'Languages': 'en-GM,mnk,wof,wo,ff',
  'Phone': '220',
  'Population': '1593256',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'GA',
  'geonameid': '2413451',
  'neighbours': 'SN',
  'tld': '.gm'},
 {'Area(in sq km)': '245857',
  'Capital': 'Conakry',
  'Continent': 'AF',
  'Country': 'Guinea',
  'CurrencyCode': 'GNF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GN',
  'ISO-Numeric': '324',
  'ISO3': 'GIN',
  'Languages': 'fr-GN',
  'Phone': '224',
  'Population': '10324025',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'GV',
  'geonameid': '2420477',
  'neighbours': 'LR,SN,SL,CI,GW,ML',
  'tld': '.gn'},
 {'Area(in sq km)': '1780',
  'Capital': 'Basse-Terre',
  'Continent': 'NA',
  'Country': 'Guadeloupe',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GP',
  'ISO-Numeric': '312',
  'ISO3': 'GLP',
  'Languages': 'fr-GP',
  'Phone': '590',
  'Population': '443000',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^((97)|(98)\\d{3})$',
  'fips': 'GP',
  'geonameid': '3579143',
  'neighbours': 'AN',
  'tld': '.gp'},
 {'Area(in sq km)': '28051',
  'Capital': 'Malabo',
  'Continent': 'AF',
  'Country': 'Equatorial Guinea',
  'CurrencyCode': 'XAF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GQ',
  'ISO-Numeric': '226',
  'ISO3': 'GNQ',
  'Languages': 'es-GQ,fr',
  'Phone': '240',
  'Population': '1014999',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'EK',
  'geonameid': '2309096',
  'neighbours': 'GA,CM',
  'tld': '.gq'},
 {'Area(in sq km)': '131940',
  'Capital': 'Athens',
  'Continent': 'EU',
  'Country': 'Greece',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GR',
  'ISO-Numeric': '300',
  'ISO3': 'GRC',
  'Languages': 'el-GR,en,fr',
  'Phone': '30',
  'Population': '11000000',
  'Postal Code Format': '### ##',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'GR',
  'geonameid': '390903',
  'neighbours': 'AL,MK,TR,BG',
  'tld': '.gr'},
 {'Area(in sq km)': '3903',
  'Capital': 'Grytviken',
  'Continent': 'AN',
  'Country': 'South Georgia and the South Sandwich Islands',
  'CurrencyCode': 'GBP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GS',
  'ISO-Numeric': '239',
  'ISO3': 'SGS',
  'Languages': 'en',
  'Phone': '',
  'Population': '30',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'SX',
  'geonameid': '3474415',
  'neighbours': '',
  'tld': '.gs'},
 {'Area(in sq km)': '108890',
  'Capital': 'Guatemala City',
  'Continent': 'NA',
  'Country': 'Guatemala',
  'CurrencyCode': 'GTQ',
  'CurrencyName': 'Quetzal',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GT',
  'ISO-Numeric': '320',
  'ISO3': 'GTM',
  'Languages': 'es-GT',
  'Phone': '502',
  'Population': '13550440',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'GT',
  'geonameid': '3595528',
  'neighbours': 'MX,HN,BZ,SV',
  'tld': '.gt'},
 {'Area(in sq km)': '549',
  'Capital': 'Hagatna',
  'Continent': 'OC',
  'Country': 'Guam',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GU',
  'ISO-Numeric': '316',
  'ISO3': 'GUM',
  'Languages': 'en-GU,ch-GU',
  'Phone': '+1-671',
  'Population': '159358',
  'Postal Code Format': '969##',
  'Postal Code Regex': '^(969\\d{2})$',
  'fips': 'GQ',
  'geonameid': '4043988',
  'neighbours': '',
  'tld': '.gu'},
 {'Area(in sq km)': '36120',
  'Capital': 'Bissau',
  'Continent': 'AF',
  'Country': 'Guinea-Bissau',
  'CurrencyCode': 'XOF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GW',
  'ISO-Numeric': '624',
  'ISO3': 'GNB',
  'Languages': 'pt-GW,pov',
  'Phone': '245',
  'Population': '1565126',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'PU',
  'geonameid': '2372248',
  'neighbours': 'SN,GN',
  'tld': '.gw'},
 {'Area(in sq km)': '214970',
  'Capital': 'Georgetown',
  'Continent': 'SA',
  'Country': 'Guyana',
  'CurrencyCode': 'GYD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'GY',
  'ISO-Numeric': '328',
  'ISO3': 'GUY',
  'Languages': 'en-GY',
  'Phone': '592',
  'Population': '748486',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'GY',
  'geonameid': '3378535',
  'neighbours': 'SR,BR,VE',
  'tld': '.gy'},
 {'Area(in sq km)': '1092',
  'Capital': 'Hong Kong',
  'Continent': 'AS',
  'Country': 'Hong Kong',
  'CurrencyCode': 'HKD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'HK',
  'ISO-Numeric': '344',
  'ISO3': 'HKG',
  'Languages': 'zh-HK,yue,zh,en',
  'Phone': '852',
  'Population': '6898686',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'HK',
  'geonameid': '1819730',
  'neighbours': '',
  'tld': '.hk'},
 {'Area(in sq km)': '412',
  'Capital': '',
  'Continent': 'AN',
  'Country': 'Heard Island and McDonald Islands',
  'CurrencyCode': 'AUD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'HM',
  'ISO-Numeric': '334',
  'ISO3': 'HMD',
  'Languages': '',
  'Phone': ' ',
  'Population': '0',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'HM',
  'geonameid': '1547314',
  'neighbours': '',
  'tld': '.hm'},
 {'Area(in sq km)': '112090',
  'Capital': 'Tegucigalpa',
  'Continent': 'NA',
  'Country': 'Honduras',
  'CurrencyCode': 'HNL',
  'CurrencyName': 'Lempira',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'HN',
  'ISO-Numeric': '340',
  'ISO3': 'HND',
  'Languages': 'es-HN',
  'Phone': '504',
  'Population': '7989415',
  'Postal Code Format': '@@####',
  'Postal Code Regex': '^([A-Z]{2}\\d{4})$',
  'fips': 'HO',
  'geonameid': '3608932',
  'neighbours': 'GT,NI,SV',
  'tld': '.hn'},
 {'Area(in sq km)': '56542',
  'Capital': 'Zagreb',
  'Continent': 'EU',
  'Country': 'Croatia',
  'CurrencyCode': 'HRK',
  'CurrencyName': 'Kuna',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'HR',
  'ISO-Numeric': '191',
  'ISO3': 'HRV',
  'Languages': 'hr-HR,sr',
  'Phone': '385',
  'Population': '4491000',
  'Postal Code Format': 'HR-#####',
  'Postal Code Regex': '^(?:HR)*(\\d{5})$',
  'fips': 'HR',
  'geonameid': '3202326',
  'neighbours': 'HU,SI,CS,BA,ME,RS',
  'tld': '.hr'},
 {'Area(in sq km)': '27750',
  'Capital': 'Port-au-Prince',
  'Continent': 'NA',
  'Country': 'Haiti',
  'CurrencyCode': 'HTG',
  'CurrencyName': 'Gourde',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'HT',
  'ISO-Numeric': '332',
  'ISO3': 'HTI',
  'Languages': 'ht,fr-HT',
  'Phone': '509',
  'Population': '9648924',
  'Postal Code Format': 'HT####',
  'Postal Code Regex': '^(?:HT)*(\\d{4})$',
  'fips': 'HA',
  'geonameid': '3723988',
  'neighbours': 'DO',
  'tld': '.ht'},
 {'Area(in sq km)': '93030',
  'Capital': 'Budapest',
  'Continent': 'EU',
  'Country': 'Hungary',
  'CurrencyCode': 'HUF',
  'CurrencyName': 'Forint',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'HU',
  'ISO-Numeric': '348',
  'ISO3': 'HUN',
  'Languages': 'hu-HU',
  'Phone': '36',
  'Population': '9930000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'HU',
  'geonameid': '719819',
  'neighbours': 'SK,SI,RO,UA,CS,HR,AT,RS',
  'tld': '.hu'},
 {'Area(in sq km)': '1919440',
  'Capital': 'Jakarta',
  'Continent': 'AS',
  'Country': 'Indonesia',
  'CurrencyCode': 'IDR',
  'CurrencyName': 'Rupiah',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ID',
  'ISO-Numeric': '360',
  'ISO3': 'IDN',
  'Languages': 'id,en,nl,jv',
  'Phone': '62',
  'Population': '242968342',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'ID',
  'geonameid': '1643084',
  'neighbours': 'PG,TL,MY',
  'tld': '.id'},
 {'Area(in sq km)': '70280',
  'Capital': 'Dublin',
  'Continent': 'EU',
  'Country': 'Ireland',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IE',
  'ISO-Numeric': '372',
  'ISO3': 'IRL',
  'Languages': 'en-IE,ga-IE',
  'Phone': '353',
  'Population': '4622917',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'EI',
  'geonameid': '2963597',
  'neighbours': 'GB',
  'tld': '.ie'},
 {'Area(in sq km)': '20770',
  'Capital': 'Jerusalem',
  'Continent': 'AS',
  'Country': 'Israel',
  'CurrencyCode': 'ILS',
  'CurrencyName': 'Shekel',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IL',
  'ISO-Numeric': '376',
  'ISO3': 'ISR',
  'Languages': 'he,ar-IL,en-IL,',
  'Phone': '972',
  'Population': '7353985',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'IS',
  'geonameid': '294640',
  'neighbours': 'SY,JO,LB,EG,PS',
  'tld': '.il'},
 {'Area(in sq km)': '572',
  'Capital': 'Douglas, Isle of Man',
  'Continent': 'EU',
  'Country': 'Isle of Man',
  'CurrencyCode': 'GBP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IM',
  'ISO-Numeric': '833',
  'ISO3': 'IMN',
  'Languages': 'en,gv',
  'Phone': '+44-1624',
  'Population': '75049',
  'Postal Code Format': '@# #@@|@## #@@|@@# #@@|@@## #@@|@#@ #@@|@@#@ #@@|GIR0AA',
  'Postal Code Regex': '^(([A-Z]\\d{2}[A-Z]{2})|([A-Z]\\d{3}[A-Z]{2})|([A-Z]{2}\\d{2}[A-Z]{2})|([A-Z]{2}\\d{3}[A-Z]{2})|([A-Z]\\d[A-Z]\\d[A-Z]{2})|([A-Z]{2}\\d[A-Z]\\d[A-Z]{2})|(GIR0AA))$',
  'fips': 'IM',
  'geonameid': '3042225',
  'neighbours': '',
  'tld': '.im'},
 {'Area(in sq km)': '3287590',
  'Capital': 'New Delhi',
  'Continent': 'AS',
  'Country': 'India',
  'CurrencyCode': 'INR',
  'CurrencyName': 'Rupee',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IN',
  'ISO-Numeric': '356',
  'ISO3': 'IND',
  'Languages': 'en-IN,hi,bn,te,mr,ta,ur,gu,kn,ml,or,pa,as,bh,sat,ks,ne,sd,kok,doi,mni,sit,sa,fr,lus,inc',
  'Phone': '91',
  'Population': '1173108018',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'IN',
  'geonameid': '1269750',
  'neighbours': 'CN,NP,MM,BT,PK,BD',
  'tld': '.in'},
 {'Area(in sq km)': '60',
  'Capital': 'Diego Garcia',
  'Continent': 'AS',
  'Country': 'British Indian Ocean Territory',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IO',
  'ISO-Numeric': '086',
  'ISO3': 'IOT',
  'Languages': 'en-IO',
  'Phone': '246',
  'Population': '4000',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'IO',
  'geonameid': '1282588',
  'neighbours': '',
  'tld': '.io'},
 {'Area(in sq km)': '437072',
  'Capital': 'Baghdad',
  'Continent': 'AS',
  'Country': 'Iraq',
  'CurrencyCode': 'IQD',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IQ',
  'ISO-Numeric': '368',
  'ISO3': 'IRQ',
  'Languages': 'ar-IQ,ku,hy',
  'Phone': '964',
  'Population': '29671605',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'IZ',
  'geonameid': '99237',
  'neighbours': 'SY,SA,IR,JO,TR,KW',
  'tld': '.iq'},
 {'Area(in sq km)': '1648000',
  'Capital': 'Tehran',
  'Continent': 'AS',
  'Country': 'Iran',
  'CurrencyCode': 'IRR',
  'CurrencyName': 'Rial',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IR',
  'ISO-Numeric': '364',
  'ISO3': 'IRN',
  'Languages': 'fa-IR,ku',
  'Phone': '98',
  'Population': '76923300',
  'Postal Code Format': '##########',
  'Postal Code Regex': '^(\\d{10})$',
  'fips': 'IR',
  'geonameid': '130758',
  'neighbours': 'TM,AF,IQ,AM,PK,AZ,TR',
  'tld': '.ir'},
 {'Area(in sq km)': '103000',
  'Capital': 'Reykjavik',
  'Continent': 'EU',
  'Country': 'Iceland',
  'CurrencyCode': 'ISK',
  'CurrencyName': 'Krona',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IS',
  'ISO-Numeric': '352',
  'ISO3': 'ISL',
  'Languages': 'is,en,de,da,sv,no',
  'Phone': '354',
  'Population': '308910',
  'Postal Code Format': '###',
  'Postal Code Regex': '^(\\d{3})$',
  'fips': 'IC',
  'geonameid': '2629691',
  'neighbours': '',
  'tld': '.is'},
 {'Area(in sq km)': '301230',
  'Capital': 'Rome',
  'Continent': 'EU',
  'Country': 'Italy',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'IT',
  'ISO-Numeric': '380',
  'ISO3': 'ITA',
  'Languages': 'it-IT,de-IT,fr-IT,sc,ca,co,sl',
  'Phone': '39',
  'Population': '60340328',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'IT',
  'geonameid': '3175395',
  'neighbours': 'CH,VA,SI,SM,FR,AT',
  'tld': '.it'},
 {'Area(in sq km)': '116',
  'Capital': 'Saint Helier',
  'Continent': 'EU',
  'Country': 'Jersey',
  'CurrencyCode': 'GBP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'JE',
  'ISO-Numeric': '832',
  'ISO3': 'JEY',
  'Languages': 'en,pt',
  'Phone': '+44-1534',
  'Population': '90812',
  'Postal Code Format': '@# #@@|@## #@@|@@# #@@|@@## #@@|@#@ #@@|@@#@ #@@|GIR0AA',
  'Postal Code Regex': '^(([A-Z]\\d{2}[A-Z]{2})|([A-Z]\\d{3}[A-Z]{2})|([A-Z]{2}\\d{2}[A-Z]{2})|([A-Z]{2}\\d{3}[A-Z]{2})|([A-Z]\\d[A-Z]\\d[A-Z]{2})|([A-Z]{2}\\d[A-Z]\\d[A-Z]{2})|(GIR0AA))$',
  'fips': 'JE',
  'geonameid': '3042142',
  'neighbours': '',
  'tld': '.je'},
 {'Area(in sq km)': '10991',
  'Capital': 'Kingston',
  'Continent': 'NA',
  'Country': 'Jamaica',
  'CurrencyCode': 'JMD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'JM',
  'ISO-Numeric': '388',
  'ISO3': 'JAM',
  'Languages': 'en-JM',
  'Phone': '+1-876',
  'Population': '2847232',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'JM',
  'geonameid': '3489940',
  'neighbours': '',
  'tld': '.jm'},
 {'Area(in sq km)': '92300',
  'Capital': 'Amman',
  'Continent': 'AS',
  'Country': 'Jordan',
  'CurrencyCode': 'JOD',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'JO',
  'ISO-Numeric': '400',
  'ISO3': 'JOR',
  'Languages': 'ar-JO,en',
  'Phone': '962',
  'Population': '6407085',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'JO',
  'geonameid': '248816',
  'neighbours': 'SY,SA,IQ,IL,PS',
  'tld': '.jo'},
 {'Area(in sq km)': '377835',
  'Capital': 'Tokyo',
  'Continent': 'AS',
  'Country': 'Japan',
  'CurrencyCode': 'JPY',
  'CurrencyName': 'Yen',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'JP',
  'ISO-Numeric': '392',
  'ISO3': 'JPN',
  'Languages': 'ja',
  'Phone': '81',
  'Population': '127288000',
  'Postal Code Format': '###-####',
  'Postal Code Regex': '^(\\d{7})$',
  'fips': 'JA',
  'geonameid': '1861060',
  'neighbours': '',
  'tld': '.jp'},
 {'Area(in sq km)': '582650',
  'Capital': 'Nairobi',
  'Continent': 'AF',
  'Country': 'Kenya',
  'CurrencyCode': 'KES',
  'CurrencyName': 'Shilling',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KE',
  'ISO-Numeric': '404',
  'ISO3': 'KEN',
  'Languages': 'en-KE,sw-KE',
  'Phone': '254',
  'Population': '40046566',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'KE',
  'geonameid': '192950',
  'neighbours': 'ET,TZ,SS,SO,UG',
  'tld': '.ke'},
 {'Area(in sq km)': '198500',
  'Capital': 'Bishkek',
  'Continent': 'AS',
  'Country': 'Kyrgyzstan',
  'CurrencyCode': 'KGS',
  'CurrencyName': 'Som',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KG',
  'ISO-Numeric': '417',
  'ISO3': 'KGZ',
  'Languages': 'ky,uz,ru',
  'Phone': '996',
  'Population': '5508626',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'KG',
  'geonameid': '1527747',
  'neighbours': 'CN,TJ,UZ,KZ',
  'tld': '.kg'},
 {'Area(in sq km)': '181040',
  'Capital': 'Phnom Penh',
  'Continent': 'AS',
  'Country': 'Cambodia',
  'CurrencyCode': 'KHR',
  'CurrencyName': 'Riels',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KH',
  'ISO-Numeric': '116',
  'ISO3': 'KHM',
  'Languages': 'km,fr,en',
  'Phone': '855',
  'Population': '14453680',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'CB',
  'geonameid': '1831722',
  'neighbours': 'LA,TH,VN',
  'tld': '.kh'},
 {'Area(in sq km)': '811',
  'Capital': 'Tarawa',
  'Continent': 'OC',
  'Country': 'Kiribati',
  'CurrencyCode': 'AUD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KI',
  'ISO-Numeric': '296',
  'ISO3': 'KIR',
  'Languages': 'en-KI,gil',
  'Phone': '686',
  'Population': '92533',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'KR',
  'geonameid': '4030945',
  'neighbours': '',
  'tld': '.ki'},
 {'Area(in sq km)': '2170',
  'Capital': 'Moroni',
  'Continent': 'AF',
  'Country': 'Comoros',
  'CurrencyCode': 'KMF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KM',
  'ISO-Numeric': '174',
  'ISO3': 'COM',
  'Languages': 'ar,fr-KM',
  'Phone': '269',
  'Population': '773407',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CN',
  'geonameid': '921929',
  'neighbours': '',
  'tld': '.km'},
 {'Area(in sq km)': '261',
  'Capital': 'Basseterre',
  'Continent': 'NA',
  'Country': 'Saint Kitts and Nevis',
  'CurrencyCode': 'XCD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KN',
  'ISO-Numeric': '659',
  'ISO3': 'KNA',
  'Languages': 'en-KN',
  'Phone': '+1-869',
  'Population': '49898',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'SC',
  'geonameid': '3575174',
  'neighbours': '',
  'tld': '.kn'},
 {'Area(in sq km)': '120540',
  'Capital': 'Pyongyang',
  'Continent': 'AS',
  'Country': 'North Korea',
  'CurrencyCode': 'KPW',
  'CurrencyName': 'Won',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KP',
  'ISO-Numeric': '408',
  'ISO3': 'PRK',
  'Languages': 'ko-KP',
  'Phone': '850',
  'Population': '22912177',
  'Postal Code Format': '###-###',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'KN',
  'geonameid': '1873107',
  'neighbours': 'CN,KR,RU',
  'tld': '.kp'},
 {'Area(in sq km)': '98480',
  'Capital': 'Seoul',
  'Continent': 'AS',
  'Country': 'South Korea',
  'CurrencyCode': 'KRW',
  'CurrencyName': 'Won',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KR',
  'ISO-Numeric': '410',
  'ISO3': 'KOR',
  'Languages': 'ko-KR,en',
  'Phone': '82',
  'Population': '48422644',
  'Postal Code Format': 'SEOUL ###-###',
  'Postal Code Regex': '^(?:SEOUL)*(\\d{6})$',
  'fips': 'KS',
  'geonameid': '1835841',
  'neighbours': 'KP',
  'tld': '.kr'},
 {'Area(in sq km)': '',
  'Capital': 'Pristina',
  'Continent': 'EU',
  'Country': 'Kosovo',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'XK',
  'ISO-Numeric': '0',
  'ISO3': 'XKX',
  'Languages': 'sq,sr',
  'Phone': '',
  'Population': '1800000',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'KV',
  'geonameid': '831053',
  'neighbours': 'RS,AL,MK,ME',
  'tld': ''},
 {'Area(in sq km)': '17820',
  'Capital': 'Kuwait City',
  'Continent': 'AS',
  'Country': 'Kuwait',
  'CurrencyCode': 'KWD',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KW',
  'ISO-Numeric': '414',
  'ISO3': 'KWT',
  'Languages': 'ar-KW,en',
  'Phone': '965',
  'Population': '2789132',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'KU',
  'geonameid': '285570',
  'neighbours': 'SA,IQ',
  'tld': '.kw'},
 {'Area(in sq km)': '262',
  'Capital': 'George Town',
  'Continent': 'NA',
  'Country': 'Cayman Islands',
  'CurrencyCode': 'KYD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KY',
  'ISO-Numeric': '136',
  'ISO3': 'CYM',
  'Languages': 'en-KY',
  'Phone': '+1-345',
  'Population': '44270',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CJ',
  'geonameid': '3580718',
  'neighbours': '',
  'tld': '.ky'},
 {'Area(in sq km)': '2717300',
  'Capital': 'Astana',
  'Continent': 'AS',
  'Country': 'Kazakhstan',
  'CurrencyCode': 'KZT',
  'CurrencyName': 'Tenge',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'KZ',
  'ISO-Numeric': '398',
  'ISO3': 'KAZ',
  'Languages': 'kk,ru',
  'Phone': '7',
  'Population': '15340000',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'KZ',
  'geonameid': '1522867',
  'neighbours': 'TM,CN,KG,UZ,RU',
  'tld': '.kz'},
 {'Area(in sq km)': '236800',
  'Capital': 'Vientiane',
  'Continent': 'AS',
  'Country': 'Laos',
  'CurrencyCode': 'LAK',
  'CurrencyName': 'Kip',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LA',
  'ISO-Numeric': '418',
  'ISO3': 'LAO',
  'Languages': 'lo,fr,en',
  'Phone': '856',
  'Population': '6368162',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'LA',
  'geonameid': '1655842',
  'neighbours': 'CN,MM,KH,TH,VN',
  'tld': '.la'},
 {'Area(in sq km)': '10400',
  'Capital': 'Beirut',
  'Continent': 'AS',
  'Country': 'Lebanon',
  'CurrencyCode': 'LBP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LB',
  'ISO-Numeric': '422',
  'ISO3': 'LBN',
  'Languages': 'ar-LB,fr-LB,en,hy',
  'Phone': '961',
  'Population': '4125247',
  'Postal Code Format': '#### ####|####',
  'Postal Code Regex': '^(\\d{4}(\\d{4})?)$',
  'fips': 'LE',
  'geonameid': '272103',
  'neighbours': 'SY,IL',
  'tld': '.lb'},
 {'Area(in sq km)': '616',
  'Capital': 'Castries',
  'Continent': 'NA',
  'Country': 'Saint Lucia',
  'CurrencyCode': 'XCD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LC',
  'ISO-Numeric': '662',
  'ISO3': 'LCA',
  'Languages': 'en-LC',
  'Phone': '+1-758',
  'Population': '160922',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'ST',
  'geonameid': '3576468',
  'neighbours': '',
  'tld': '.lc'},
 {'Area(in sq km)': '160',
  'Capital': 'Vaduz',
  'Continent': 'EU',
  'Country': 'Liechtenstein',
  'CurrencyCode': 'CHF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LI',
  'ISO-Numeric': '438',
  'ISO3': 'LIE',
  'Languages': 'de-LI',
  'Phone': '423',
  'Population': '35000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'LS',
  'geonameid': '3042058',
  'neighbours': 'CH,AT',
  'tld': '.li'},
 {'Area(in sq km)': '65610',
  'Capital': 'Colombo',
  'Continent': 'AS',
  'Country': 'Sri Lanka',
  'CurrencyCode': 'LKR',
  'CurrencyName': 'Rupee',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LK',
  'ISO-Numeric': '144',
  'ISO3': 'LKA',
  'Languages': 'si,ta,en',
  'Phone': '94',
  'Population': '21513990',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'CE',
  'geonameid': '1227603',
  'neighbours': '',
  'tld': '.lk'},
 {'Area(in sq km)': '111370',
  'Capital': 'Monrovia',
  'Continent': 'AF',
  'Country': 'Liberia',
  'CurrencyCode': 'LRD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LR',
  'ISO-Numeric': '430',
  'ISO3': 'LBR',
  'Languages': 'en-LR',
  'Phone': '231',
  'Population': '3685076',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'LI',
  'geonameid': '2275384',
  'neighbours': 'SL,CI,GN',
  'tld': '.lr'},
 {'Area(in sq km)': '30355',
  'Capital': 'Maseru',
  'Continent': 'AF',
  'Country': 'Lesotho',
  'CurrencyCode': 'LSL',
  'CurrencyName': 'Loti',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LS',
  'ISO-Numeric': '426',
  'ISO3': 'LSO',
  'Languages': 'en-LS,st,zu,xh',
  'Phone': '266',
  'Population': '1919552',
  'Postal Code Format': '###',
  'Postal Code Regex': '^(\\d{3})$',
  'fips': 'LT',
  'geonameid': '932692',
  'neighbours': 'ZA',
  'tld': '.ls'},
 {'Area(in sq km)': '65200',
  'Capital': 'Vilnius',
  'Continent': 'EU',
  'Country': 'Lithuania',
  'CurrencyCode': 'LTL',
  'CurrencyName': 'Litas',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LT',
  'ISO-Numeric': '440',
  'ISO3': 'LTU',
  'Languages': 'lt,ru,pl',
  'Phone': '370',
  'Population': '3565000',
  'Postal Code Format': 'LT-#####',
  'Postal Code Regex': '^(?:LT)*(\\d{5})$',
  'fips': 'LH',
  'geonameid': '597427',
  'neighbours': 'PL,BY,RU,LV',
  'tld': '.lt'},
 {'Area(in sq km)': '2586',
  'Capital': 'Luxembourg',
  'Continent': 'EU',
  'Country': 'Luxembourg',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LU',
  'ISO-Numeric': '442',
  'ISO3': 'LUX',
  'Languages': 'lb,de-LU,fr-LU',
  'Phone': '352',
  'Population': '497538',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'LU',
  'geonameid': '2960313',
  'neighbours': 'DE,BE,FR',
  'tld': '.lu'},
 {'Area(in sq km)': '64589',
  'Capital': 'Riga',
  'Continent': 'EU',
  'Country': 'Latvia',
  'CurrencyCode': 'LVL',
  'CurrencyName': 'Lat',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LV',
  'ISO-Numeric': '428',
  'ISO3': 'LVA',
  'Languages': 'lv,ru,lt',
  'Phone': '371',
  'Population': '2217969',
  'Postal Code Format': 'LV-####',
  'Postal Code Regex': '^(?:LV)*(\\d{4})$',
  'fips': 'LG',
  'geonameid': '458258',
  'neighbours': 'LT,EE,BY,RU',
  'tld': '.lv'},
 {'Area(in sq km)': '1759540',
  'Capital': 'Tripolis',
  'Continent': 'AF',
  'Country': 'Libya',
  'CurrencyCode': 'LYD',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'LY',
  'ISO-Numeric': '434',
  'ISO3': 'LBY',
  'Languages': 'ar-LY,it,en',
  'Phone': '218',
  'Population': '6461454',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'LY',
  'geonameid': '2215636',
  'neighbours': 'TD,NE,DZ,SD,TN,EG',
  'tld': '.ly'},
 {'Area(in sq km)': '446550',
  'Capital': 'Rabat',
  'Continent': 'AF',
  'Country': 'Morocco',
  'CurrencyCode': 'MAD',
  'CurrencyName': 'Dirham',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MA',
  'ISO-Numeric': '504',
  'ISO3': 'MAR',
  'Languages': 'ar-MA,fr',
  'Phone': '212',
  'Population': '31627428',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'MO',
  'geonameid': '2542007',
  'neighbours': 'DZ,EH,ES',
  'tld': '.ma'},
 {'Area(in sq km)': '1.95',
  'Capital': 'Monaco',
  'Continent': 'EU',
  'Country': 'Monaco',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MC',
  'ISO-Numeric': '492',
  'ISO3': 'MCO',
  'Languages': 'fr-MC,en,it',
  'Phone': '377',
  'Population': '32965',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'MN',
  'geonameid': '2993457',
  'neighbours': 'FR',
  'tld': '.mc'},
 {'Area(in sq km)': '33843',
  'Capital': 'Chisinau',
  'Continent': 'EU',
  'Country': 'Moldova',
  'CurrencyCode': 'MDL',
  'CurrencyName': 'Leu',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MD',
  'ISO-Numeric': '498',
  'ISO3': 'MDA',
  'Languages': 'ro,ru,gag,tr',
  'Phone': '373',
  'Population': '4324000',
  'Postal Code Format': 'MD-####',
  'Postal Code Regex': '^(?:MD)*(\\d{4})$',
  'fips': 'MD',
  'geonameid': '617790',
  'neighbours': 'RO,UA',
  'tld': '.md'},
 {'Area(in sq km)': '14026',
  'Capital': 'Podgorica',
  'Continent': 'EU',
  'Country': 'Montenegro',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ME',
  'ISO-Numeric': '499',
  'ISO3': 'MNE',
  'Languages': 'sr,hu,bs,sq,hr,rom',
  'Phone': '382',
  'Population': '666730',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'MJ',
  'geonameid': '3194884',
  'neighbours': 'AL,HR,BA,RS,XK',
  'tld': '.me'},
 {'Area(in sq km)': '53',
  'Capital': 'Marigot',
  'Continent': 'NA',
  'Country': 'Saint Martin',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MF',
  'ISO-Numeric': '663',
  'ISO3': 'MAF',
  'Languages': 'fr',
  'Phone': '590',
  'Population': '35925',
  'Postal Code Format': '### ###',
  'Postal Code Regex': '',
  'fips': 'RN',
  'geonameid': '3578421',
  'neighbours': 'SX',
  'tld': '.gp'},
 {'Area(in sq km)': '587040',
  'Capital': 'Antananarivo',
  'Continent': 'AF',
  'Country': 'Madagascar',
  'CurrencyCode': 'MGA',
  'CurrencyName': 'Ariary',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MG',
  'ISO-Numeric': '450',
  'ISO3': 'MDG',
  'Languages': 'fr-MG,mg',
  'Phone': '261',
  'Population': '21281844',
  'Postal Code Format': '###',
  'Postal Code Regex': '^(\\d{3})$',
  'fips': 'MA',
  'geonameid': '1062947',
  'neighbours': '',
  'tld': '.mg'},
 {'Area(in sq km)': '181.3',
  'Capital': 'Majuro',
  'Continent': 'OC',
  'Country': 'Marshall Islands',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MH',
  'ISO-Numeric': '584',
  'ISO3': 'MHL',
  'Languages': 'mh,en-MH',
  'Phone': '692',
  'Population': '65859',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'RM',
  'geonameid': '2080185',
  'neighbours': '',
  'tld': '.mh'},
 {'Area(in sq km)': '25333',
  'Capital': 'Skopje',
  'Continent': 'EU',
  'Country': 'Macedonia',
  'CurrencyCode': 'MKD',
  'CurrencyName': 'Denar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MK',
  'ISO-Numeric': '807',
  'ISO3': 'MKD',
  'Languages': 'mk,sq,tr,rmm,sr',
  'Phone': '389',
  'Population': '2061000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'MK',
  'geonameid': '718075',
  'neighbours': 'AL,GR,CS,BG,RS,XK',
  'tld': '.mk'},
 {'Area(in sq km)': '1240000',
  'Capital': 'Bamako',
  'Continent': 'AF',
  'Country': 'Mali',
  'CurrencyCode': 'XOF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ML',
  'ISO-Numeric': '466',
  'ISO3': 'MLI',
  'Languages': 'fr-ML,bm',
  'Phone': '223',
  'Population': '13796354',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'ML',
  'geonameid': '2453866',
  'neighbours': 'SN,NE,DZ,CI,GN,MR,BF',
  'tld': '.ml'},
 {'Area(in sq km)': '678500',
  'Capital': 'Nay Pyi Taw',
  'Continent': 'AS',
  'Country': 'Myanmar',
  'CurrencyCode': 'MMK',
  'CurrencyName': 'Kyat',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MM',
  'ISO-Numeric': '104',
  'ISO3': 'MMR',
  'Languages': 'my',
  'Phone': '95',
  'Population': '53414374',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'BM',
  'geonameid': '1327865',
  'neighbours': 'CN,LA,TH,BD,IN',
  'tld': '.mm'},
 {'Area(in sq km)': '1565000',
  'Capital': 'Ulan Bator',
  'Continent': 'AS',
  'Country': 'Mongolia',
  'CurrencyCode': 'MNT',
  'CurrencyName': 'Tugrik',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MN',
  'ISO-Numeric': '496',
  'ISO3': 'MNG',
  'Languages': 'mn,ru',
  'Phone': '976',
  'Population': '3086918',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'MG',
  'geonameid': '2029969',
  'neighbours': 'CN,RU',
  'tld': '.mn'},
 {'Area(in sq km)': '254',
  'Capital': 'Macao',
  'Continent': 'AS',
  'Country': 'Macao',
  'CurrencyCode': 'MOP',
  'CurrencyName': 'Pataca',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MO',
  'ISO-Numeric': '446',
  'ISO3': 'MAC',
  'Languages': 'zh,zh-MO,pt',
  'Phone': '853',
  'Population': '449198',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'MC',
  'geonameid': '1821275',
  'neighbours': '',
  'tld': '.mo'},
 {'Area(in sq km)': '477',
  'Capital': 'Saipan',
  'Continent': 'OC',
  'Country': 'Northern Mariana Islands',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MP',
  'ISO-Numeric': '580',
  'ISO3': 'MNP',
  'Languages': 'fil,tl,zh,ch-MP,en-MP',
  'Phone': '+1-670',
  'Population': '53883',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CQ',
  'geonameid': '4041468',
  'neighbours': '',
  'tld': '.mp'},
 {'Area(in sq km)': '1100',
  'Capital': 'Fort-de-France',
  'Continent': 'NA',
  'Country': 'Martinique',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MQ',
  'ISO-Numeric': '474',
  'ISO3': 'MTQ',
  'Languages': 'fr-MQ',
  'Phone': '596',
  'Population': '432900',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'MB',
  'geonameid': '3570311',
  'neighbours': '',
  'tld': '.mq'},
 {'Area(in sq km)': '1030700',
  'Capital': 'Nouakchott',
  'Continent': 'AF',
  'Country': 'Mauritania',
  'CurrencyCode': 'MRO',
  'CurrencyName': 'Ouguiya',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MR',
  'ISO-Numeric': '478',
  'ISO3': 'MRT',
  'Languages': 'ar-MR,fuc,snk,fr,mey,wo',
  'Phone': '222',
  'Population': '3205060',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'MR',
  'geonameid': '2378080',
  'neighbours': 'SN,DZ,EH,ML',
  'tld': '.mr'},
 {'Area(in sq km)': '102',
  'Capital': 'Plymouth',
  'Continent': 'NA',
  'Country': 'Montserrat',
  'CurrencyCode': 'XCD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MS',
  'ISO-Numeric': '500',
  'ISO3': 'MSR',
  'Languages': 'en-MS',
  'Phone': '+1-664',
  'Population': '9341',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'MH',
  'geonameid': '3578097',
  'neighbours': '',
  'tld': '.ms'},
 {'Area(in sq km)': '316',
  'Capital': 'Valletta',
  'Continent': 'EU',
  'Country': 'Malta',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MT',
  'ISO-Numeric': '470',
  'ISO3': 'MLT',
  'Languages': 'mt,en-MT',
  'Phone': '356',
  'Population': '403000',
  'Postal Code Format': '@@@ ###|@@@ ##',
  'Postal Code Regex': '^([A-Z]{3}\\d{2}\\d?)$',
  'fips': 'MT',
  'geonameid': '2562770',
  'neighbours': '',
  'tld': '.mt'},
 {'Area(in sq km)': '2040',
  'Capital': 'Port Louis',
  'Continent': 'AF',
  'Country': 'Mauritius',
  'CurrencyCode': 'MUR',
  'CurrencyName': 'Rupee',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MU',
  'ISO-Numeric': '480',
  'ISO3': 'MUS',
  'Languages': 'en-MU,bho,fr',
  'Phone': '230',
  'Population': '1294104',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'MP',
  'geonameid': '934292',
  'neighbours': '',
  'tld': '.mu'},
 {'Area(in sq km)': '300',
  'Capital': 'Male',
  'Continent': 'AS',
  'Country': 'Maldives',
  'CurrencyCode': 'MVR',
  'CurrencyName': 'Rufiyaa',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MV',
  'ISO-Numeric': '462',
  'ISO3': 'MDV',
  'Languages': 'dv,en',
  'Phone': '960',
  'Population': '395650',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'MV',
  'geonameid': '1282028',
  'neighbours': '',
  'tld': '.mv'},
 {'Area(in sq km)': '118480',
  'Capital': 'Lilongwe',
  'Continent': 'AF',
  'Country': 'Malawi',
  'CurrencyCode': 'MWK',
  'CurrencyName': 'Kwacha',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MW',
  'ISO-Numeric': '454',
  'ISO3': 'MWI',
  'Languages': 'ny,yao,tum,swk',
  'Phone': '265',
  'Population': '15447500',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'MI',
  'geonameid': '927384',
  'neighbours': 'TZ,MZ,ZM',
  'tld': '.mw'},
 {'Area(in sq km)': '1972550',
  'Capital': 'Mexico City',
  'Continent': 'NA',
  'Country': 'Mexico',
  'CurrencyCode': 'MXN',
  'CurrencyName': 'Peso',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MX',
  'ISO-Numeric': '484',
  'ISO3': 'MEX',
  'Languages': 'es-MX',
  'Phone': '52',
  'Population': '112468855',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'MX',
  'geonameid': '3996063',
  'neighbours': 'GT,US,BZ',
  'tld': '.mx'},
 {'Area(in sq km)': '329750',
  'Capital': 'Kuala Lumpur',
  'Continent': 'AS',
  'Country': 'Malaysia',
  'CurrencyCode': 'MYR',
  'CurrencyName': 'Ringgit',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MY',
  'ISO-Numeric': '458',
  'ISO3': 'MYS',
  'Languages': 'ms-MY,en,zh,ta,te,ml,pa,th',
  'Phone': '60',
  'Population': '28274729',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'MY',
  'geonameid': '1733045',
  'neighbours': 'BN,TH,ID',
  'tld': '.my'},
 {'Area(in sq km)': '801590',
  'Capital': 'Maputo',
  'Continent': 'AF',
  'Country': 'Mozambique',
  'CurrencyCode': 'MZN',
  'CurrencyName': 'Metical',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'MZ',
  'ISO-Numeric': '508',
  'ISO3': 'MOZ',
  'Languages': 'pt-MZ,vmw',
  'Phone': '258',
  'Population': '22061451',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'MZ',
  'geonameid': '1036973',
  'neighbours': 'ZW,TZ,SZ,ZA,ZM,MW',
  'tld': '.mz'},
 {'Area(in sq km)': '825418',
  'Capital': 'Windhoek',
  'Continent': 'AF',
  'Country': 'Namibia',
  'CurrencyCode': 'NAD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NA',
  'ISO-Numeric': '516',
  'ISO3': 'NAM',
  'Languages': 'en-NA,af,de,hz,naq',
  'Phone': '264',
  'Population': '2128471',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'WA',
  'geonameid': '3355338',
  'neighbours': 'ZA,BW,ZM,AO',
  'tld': '.na'},
 {'Area(in sq km)': '19060',
  'Capital': 'Noumea',
  'Continent': 'OC',
  'Country': 'New Caledonia',
  'CurrencyCode': 'XPF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NC',
  'ISO-Numeric': '540',
  'ISO3': 'NCL',
  'Languages': 'fr-NC',
  'Phone': '687',
  'Population': '216494',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'NC',
  'geonameid': '2139685',
  'neighbours': '',
  'tld': '.nc'},
 {'Area(in sq km)': '1267000',
  'Capital': 'Niamey',
  'Continent': 'AF',
  'Country': 'Niger',
  'CurrencyCode': 'XOF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NE',
  'ISO-Numeric': '562',
  'ISO3': 'NER',
  'Languages': 'fr-NE,ha,kr,dje',
  'Phone': '227',
  'Population': '15878271',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'NG',
  'geonameid': '2440476',
  'neighbours': 'TD,BJ,DZ,LY,BF,NG,ML',
  'tld': '.ne'},
 {'Area(in sq km)': '34.6',
  'Capital': 'Kingston',
  'Continent': 'OC',
  'Country': 'Norfolk Island',
  'CurrencyCode': 'AUD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NF',
  'ISO-Numeric': '574',
  'ISO3': 'NFK',
  'Languages': 'en-NF',
  'Phone': '672',
  'Population': '1828',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'NF',
  'geonameid': '2155115',
  'neighbours': '',
  'tld': '.nf'},
 {'Area(in sq km)': '923768',
  'Capital': 'Abuja',
  'Continent': 'AF',
  'Country': 'Nigeria',
  'CurrencyCode': 'NGN',
  'CurrencyName': 'Naira',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NG',
  'ISO-Numeric': '566',
  'ISO3': 'NGA',
  'Languages': 'en-NG,ha,yo,ig,ff',
  'Phone': '234',
  'Population': '154000000',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'NI',
  'geonameid': '2328926',
  'neighbours': 'TD,NE,BJ,CM',
  'tld': '.ng'},
 {'Area(in sq km)': '129494',
  'Capital': 'Managua',
  'Continent': 'NA',
  'Country': 'Nicaragua',
  'CurrencyCode': 'NIO',
  'CurrencyName': 'Cordoba',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NI',
  'ISO-Numeric': '558',
  'ISO3': 'NIC',
  'Languages': 'es-NI,en',
  'Phone': '505',
  'Population': '5995928',
  'Postal Code Format': '###-###-#',
  'Postal Code Regex': '^(\\d{7})$',
  'fips': 'NU',
  'geonameid': '3617476',
  'neighbours': 'CR,HN',
  'tld': '.ni'},
 {'Area(in sq km)': '41526',
  'Capital': 'Amsterdam',
  'Continent': 'EU',
  'Country': 'Netherlands',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NL',
  'ISO-Numeric': '528',
  'ISO3': 'NLD',
  'Languages': 'nl-NL,fy-NL',
  'Phone': '31',
  'Population': '16645000',
  'Postal Code Format': '#### @@',
  'Postal Code Regex': '^(\\d{4}[A-Z]{2})$',
  'fips': 'NL',
  'geonameid': '2750405',
  'neighbours': 'DE,BE',
  'tld': '.nl'},
 {'Area(in sq km)': '324220',
  'Capital': 'Oslo',
  'Continent': 'EU',
  'Country': 'Norway',
  'CurrencyCode': 'NOK',
  'CurrencyName': 'Krone',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NO',
  'ISO-Numeric': '578',
  'ISO3': 'NOR',
  'Languages': 'no,nb,nn,se,fi',
  'Phone': '47',
  'Population': '4985870',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'NO',
  'geonameid': '3144096',
  'neighbours': 'FI,RU,SE',
  'tld': '.no'},
 {'Area(in sq km)': '140800',
  'Capital': 'Kathmandu',
  'Continent': 'AS',
  'Country': 'Nepal',
  'CurrencyCode': 'NPR',
  'CurrencyName': 'Rupee',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NP',
  'ISO-Numeric': '524',
  'ISO3': 'NPL',
  'Languages': 'ne,en',
  'Phone': '977',
  'Population': '28951852',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'NP',
  'geonameid': '1282988',
  'neighbours': 'CN,IN',
  'tld': '.np'},
 {'Area(in sq km)': '21',
  'Capital': 'Yaren',
  'Continent': 'OC',
  'Country': 'Nauru',
  'CurrencyCode': 'AUD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NR',
  'ISO-Numeric': '520',
  'ISO3': 'NRU',
  'Languages': 'na,en-NR',
  'Phone': '674',
  'Population': '10065',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'NR',
  'geonameid': '2110425',
  'neighbours': '',
  'tld': '.nr'},
 {'Area(in sq km)': '260',
  'Capital': 'Alofi',
  'Continent': 'OC',
  'Country': 'Niue',
  'CurrencyCode': 'NZD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NU',
  'ISO-Numeric': '570',
  'ISO3': 'NIU',
  'Languages': 'niu,en-NU',
  'Phone': '683',
  'Population': '2166',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'NE',
  'geonameid': '4036232',
  'neighbours': '',
  'tld': '.nu'},
 {'Area(in sq km)': '268680',
  'Capital': 'Wellington',
  'Continent': 'OC',
  'Country': 'New Zealand',
  'CurrencyCode': 'NZD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'NZ',
  'ISO-Numeric': '554',
  'ISO3': 'NZL',
  'Languages': 'en-NZ,mi',
  'Phone': '64',
  'Population': '4252277',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'NZ',
  'geonameid': '2186224',
  'neighbours': '',
  'tld': '.nz'},
 {'Area(in sq km)': '212460',
  'Capital': 'Muscat',
  'Continent': 'AS',
  'Country': 'Oman',
  'CurrencyCode': 'OMR',
  'CurrencyName': 'Rial',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'OM',
  'ISO-Numeric': '512',
  'ISO3': 'OMN',
  'Languages': 'ar-OM,en,bal,ur',
  'Phone': '968',
  'Population': '2967717',
  'Postal Code Format': '###',
  'Postal Code Regex': '^(\\d{3})$',
  'fips': 'MU',
  'geonameid': '286963',
  'neighbours': 'SA,YE,AE',
  'tld': '.om'},
 {'Area(in sq km)': '78200',
  'Capital': 'Panama City',
  'Continent': 'NA',
  'Country': 'Panama',
  'CurrencyCode': 'PAB',
  'CurrencyName': 'Balboa',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PA',
  'ISO-Numeric': '591',
  'ISO3': 'PAN',
  'Languages': 'es-PA,en',
  'Phone': '507',
  'Population': '3410676',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'PM',
  'geonameid': '3703430',
  'neighbours': 'CR,CO',
  'tld': '.pa'},
 {'Area(in sq km)': '1285220',
  'Capital': 'Lima',
  'Continent': 'SA',
  'Country': 'Peru',
  'CurrencyCode': 'PEN',
  'CurrencyName': 'Sol',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PE',
  'ISO-Numeric': '604',
  'ISO3': 'PER',
  'Languages': 'es-PE,qu,ay',
  'Phone': '51',
  'Population': '29907003',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'PE',
  'geonameid': '3932488',
  'neighbours': 'EC,CL,BO,BR,CO',
  'tld': '.pe'},
 {'Area(in sq km)': '4167',
  'Capital': 'Papeete',
  'Continent': 'OC',
  'Country': 'French Polynesia',
  'CurrencyCode': 'XPF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PF',
  'ISO-Numeric': '258',
  'ISO3': 'PYF',
  'Languages': 'fr-PF,ty',
  'Phone': '689',
  'Population': '270485',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^((97)|(98)7\\d{2})$',
  'fips': 'FP',
  'geonameid': '4030656',
  'neighbours': '',
  'tld': '.pf'},
 {'Area(in sq km)': '462840',
  'Capital': 'Port Moresby',
  'Continent': 'OC',
  'Country': 'Papua New Guinea',
  'CurrencyCode': 'PGK',
  'CurrencyName': 'Kina',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PG',
  'ISO-Numeric': '598',
  'ISO3': 'PNG',
  'Languages': 'en-PG,ho,meu,tpi',
  'Phone': '675',
  'Population': '6064515',
  'Postal Code Format': '###',
  'Postal Code Regex': '^(\\d{3})$',
  'fips': 'PP',
  'geonameid': '2088628',
  'neighbours': 'ID',
  'tld': '.pg'},
 {'Area(in sq km)': '300000',
  'Capital': 'Manila',
  'Continent': 'AS',
  'Country': 'Philippines',
  'CurrencyCode': 'PHP',
  'CurrencyName': 'Peso',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PH',
  'ISO-Numeric': '608',
  'ISO3': 'PHL',
  'Languages': 'tl,en-PH,fil',
  'Phone': '63',
  'Population': '99900177',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'RP',
  'geonameid': '1694008',
  'neighbours': '',
  'tld': '.ph'},
 {'Area(in sq km)': '803940',
  'Capital': 'Islamabad',
  'Continent': 'AS',
  'Country': 'Pakistan',
  'CurrencyCode': 'PKR',
  'CurrencyName': 'Rupee',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PK',
  'ISO-Numeric': '586',
  'ISO3': 'PAK',
  'Languages': 'ur-PK,en-PK,pa,sd,ps,brh',
  'Phone': '92',
  'Population': '184404791',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'PK',
  'geonameid': '1168579',
  'neighbours': 'CN,AF,IR,IN',
  'tld': '.pk'},
 {'Area(in sq km)': '312685',
  'Capital': 'Warsaw',
  'Continent': 'EU',
  'Country': 'Poland',
  'CurrencyCode': 'PLN',
  'CurrencyName': 'Zloty',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PL',
  'ISO-Numeric': '616',
  'ISO3': 'POL',
  'Languages': 'pl',
  'Phone': '48',
  'Population': '38500000',
  'Postal Code Format': '##-###',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'PL',
  'geonameid': '798544',
  'neighbours': 'DE,LT,SK,CZ,BY,UA,RU',
  'tld': '.pl'},
 {'Area(in sq km)': '242',
  'Capital': 'Saint-Pierre',
  'Continent': 'NA',
  'Country': 'Saint Pierre and Miquelon',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PM',
  'ISO-Numeric': '666',
  'ISO3': 'SPM',
  'Languages': 'fr-PM',
  'Phone': '508',
  'Population': '7012',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(97500)$',
  'fips': 'SB',
  'geonameid': '3424932',
  'neighbours': '',
  'tld': '.pm'},
 {'Area(in sq km)': '47',
  'Capital': 'Adamstown',
  'Continent': 'OC',
  'Country': 'Pitcairn',
  'CurrencyCode': 'NZD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PN',
  'ISO-Numeric': '612',
  'ISO3': 'PCN',
  'Languages': 'en-PN',
  'Phone': '870',
  'Population': '46',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'PC',
  'geonameid': '4030699',
  'neighbours': '',
  'tld': '.pn'},
 {'Area(in sq km)': '9104',
  'Capital': 'San Juan',
  'Continent': 'NA',
  'Country': 'Puerto Rico',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PR',
  'ISO-Numeric': '630',
  'ISO3': 'PRI',
  'Languages': 'en-PR,es-PR',
  'Phone': '+1-787 and 1-939',
  'Population': '3916632',
  'Postal Code Format': '#####-####',
  'Postal Code Regex': '^(\\d{9})$',
  'fips': 'RQ',
  'geonameid': '4566966',
  'neighbours': '',
  'tld': '.pr'},
 {'Area(in sq km)': '5970',
  'Capital': 'East Jerusalem',
  'Continent': 'AS',
  'Country': 'Palestinian Territory',
  'CurrencyCode': 'ILS',
  'CurrencyName': 'Shekel',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PS',
  'ISO-Numeric': '275',
  'ISO3': 'PSE',
  'Languages': 'ar-PS',
  'Phone': '970',
  'Population': '3800000',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'WE',
  'geonameid': '6254930',
  'neighbours': 'JO,IL',
  'tld': '.ps'},
 {'Area(in sq km)': '92391',
  'Capital': 'Lisbon',
  'Continent': 'EU',
  'Country': 'Portugal',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PT',
  'ISO-Numeric': '620',
  'ISO3': 'PRT',
  'Languages': 'pt-PT,mwl',
  'Phone': '351',
  'Population': '10676000',
  'Postal Code Format': '####-###',
  'Postal Code Regex': '^(\\d{7})$',
  'fips': 'PO',
  'geonameid': '2264397',
  'neighbours': 'ES',
  'tld': '.pt'},
 {'Area(in sq km)': '458',
  'Capital': 'Melekeok',
  'Continent': 'OC',
  'Country': 'Palau',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PW',
  'ISO-Numeric': '585',
  'ISO3': 'PLW',
  'Languages': 'pau,sov,en-PW,tox,ja,fil,zh',
  'Phone': '680',
  'Population': '19907',
  'Postal Code Format': '96940',
  'Postal Code Regex': '^(96940)$',
  'fips': 'PS',
  'geonameid': '1559582',
  'neighbours': '',
  'tld': '.pw'},
 {'Area(in sq km)': '406750',
  'Capital': 'Asuncion',
  'Continent': 'SA',
  'Country': 'Paraguay',
  'CurrencyCode': 'PYG',
  'CurrencyName': 'Guarani',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'PY',
  'ISO-Numeric': '600',
  'ISO3': 'PRY',
  'Languages': 'es-PY,gn',
  'Phone': '595',
  'Population': '6375830',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'PA',
  'geonameid': '3437598',
  'neighbours': 'BO,BR,AR',
  'tld': '.py'},
 {'Area(in sq km)': '11437',
  'Capital': 'Doha',
  'Continent': 'AS',
  'Country': 'Qatar',
  'CurrencyCode': 'QAR',
  'CurrencyName': 'Rial',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'QA',
  'ISO-Numeric': '634',
  'ISO3': 'QAT',
  'Languages': 'ar-QA,es',
  'Phone': '974',
  'Population': '840926',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'QA',
  'geonameid': '289688',
  'neighbours': 'SA',
  'tld': '.qa'},
 {'Area(in sq km)': '2517',
  'Capital': 'Saint-Denis',
  'Continent': 'AF',
  'Country': 'Reunion',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'RE',
  'ISO-Numeric': '638',
  'ISO3': 'REU',
  'Languages': 'fr-RE',
  'Phone': '262',
  'Population': '776948',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^((97)|(98)(4|7|8)\\d{2})$',
  'fips': 'RE',
  'geonameid': '935317',
  'neighbours': '',
  'tld': '.re'},
 {'Area(in sq km)': '237500',
  'Capital': 'Bucharest',
  'Continent': 'EU',
  'Country': 'Romania',
  'CurrencyCode': 'RON',
  'CurrencyName': 'Leu',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'RO',
  'ISO-Numeric': '642',
  'ISO3': 'ROU',
  'Languages': 'ro,hu,rom',
  'Phone': '40',
  'Population': '21959278',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'RO',
  'geonameid': '798549',
  'neighbours': 'MD,HU,UA,CS,BG,RS',
  'tld': '.ro'},
 {'Area(in sq km)': '88361',
  'Capital': 'Belgrade',
  'Continent': 'EU',
  'Country': 'Serbia',
  'CurrencyCode': 'RSD',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'RS',
  'ISO-Numeric': '688',
  'ISO3': 'SRB',
  'Languages': 'sr,hu,bs,rom',
  'Phone': '381',
  'Population': '7344847',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'RI',
  'geonameid': '6290252',
  'neighbours': 'AL,HU,MK,RO,HR,BA,BG,ME,XK',
  'tld': '.rs'},
 {'Area(in sq km)': '1.71E+007',
  'Capital': 'Moscow',
  'Continent': 'EU',
  'Country': 'Russia',
  'CurrencyCode': 'RUB',
  'CurrencyName': 'Ruble',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'RU',
  'ISO-Numeric': '643',
  'ISO3': 'RUS',
  'Languages': 'ru,tt,xal,cau,ady,kv,ce,tyv,cv,udm,tut,mns,bua,myv,mdf,chm,ba,inh,tut,kbd,krc,ava,sah,nog',
  'Phone': '7',
  'Population': '140702000',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'RS',
  'geonameid': '2017370',
  'neighbours': 'GE,CN,BY,UA,KZ,LV,PL,EE,LT,FI,MN,NO,AZ,KP',
  'tld': '.ru'},
 {'Area(in sq km)': '26338',
  'Capital': 'Kigali',
  'Continent': 'AF',
  'Country': 'Rwanda',
  'CurrencyCode': 'RWF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'RW',
  'ISO-Numeric': '646',
  'ISO3': 'RWA',
  'Languages': 'rw,en-RW,fr-RW,sw',
  'Phone': '250',
  'Population': '11055976',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'RW',
  'geonameid': '49518',
  'neighbours': 'TZ,CD,BI,UG',
  'tld': '.rw'},
 {'Area(in sq km)': '1960582',
  'Capital': 'Riyadh',
  'Continent': 'AS',
  'Country': 'Saudi Arabia',
  'CurrencyCode': 'SAR',
  'CurrencyName': 'Rial',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SA',
  'ISO-Numeric': '682',
  'ISO3': 'SAU',
  'Languages': 'ar-SA',
  'Phone': '966',
  'Population': '25731776',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'SA',
  'geonameid': '102358',
  'neighbours': 'QA,OM,IQ,YE,JO,AE,KW',
  'tld': '.sa'},
 {'Area(in sq km)': '28450',
  'Capital': 'Honiara',
  'Continent': 'OC',
  'Country': 'Solomon Islands',
  'CurrencyCode': 'SBD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SB',
  'ISO-Numeric': '090',
  'ISO3': 'SLB',
  'Languages': 'en-SB,tpi',
  'Phone': '677',
  'Population': '559198',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'BP',
  'geonameid': '2103350',
  'neighbours': '',
  'tld': '.sb'},
 {'Area(in sq km)': '455',
  'Capital': 'Victoria',
  'Continent': 'AF',
  'Country': 'Seychelles',
  'CurrencyCode': 'SCR',
  'CurrencyName': 'Rupee',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SC',
  'ISO-Numeric': '690',
  'ISO3': 'SYC',
  'Languages': 'en-SC,fr-SC',
  'Phone': '248',
  'Population': '88340',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'SE',
  'geonameid': '241170',
  'neighbours': '',
  'tld': '.sc'},
 {'Area(in sq km)': '1861484',
  'Capital': 'Khartoum',
  'Continent': 'AF',
  'Country': 'Sudan',
  'CurrencyCode': 'SDG',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SD',
  'ISO-Numeric': '729',
  'ISO3': 'SDN',
  'Languages': 'ar-SD,en,fia',
  'Phone': '249',
  'Population': '35000000',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'SU',
  'geonameid': '366755',
  'neighbours': 'SS,TD,EG,ET,ER,LY,CF',
  'tld': '.sd'},
 {'Area(in sq km)': '644329',
  'Capital': 'Juba',
  'Continent': 'AF',
  'Country': 'South Sudan',
  'CurrencyCode': 'SSP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SS',
  'ISO-Numeric': '728',
  'ISO3': 'SSD',
  'Languages': 'en',
  'Phone': '211',
  'Population': '8260490',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'OD',
  'geonameid': '7909807',
  'neighbours': 'CD,CF,ET,KE,SD,UG,',
  'tld': ''},
 {'Area(in sq km)': '449964',
  'Capital': 'Stockholm',
  'Continent': 'EU',
  'Country': 'Sweden',
  'CurrencyCode': 'SEK',
  'CurrencyName': 'Krona',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SE',
  'ISO-Numeric': '752',
  'ISO3': 'SWE',
  'Languages': 'sv-SE,se,sma,fi-SE',
  'Phone': '46',
  'Population': '9045000',
  'Postal Code Format': 'SE-### ##',
  'Postal Code Regex': '^(?:SE)*(\\d{5})$',
  'fips': 'SW',
  'geonameid': '2661886',
  'neighbours': 'NO,FI',
  'tld': '.se'},
 {'Area(in sq km)': '692.7',
  'Capital': 'Singapur',
  'Continent': 'AS',
  'Country': 'Singapore',
  'CurrencyCode': 'SGD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SG',
  'ISO-Numeric': '702',
  'ISO3': 'SGP',
  'Languages': 'cmn,en-SG,ms-SG,ta-SG,zh-SG',
  'Phone': '65',
  'Population': '4701069',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'SN',
  'geonameid': '1880251',
  'neighbours': '',
  'tld': '.sg'},
 {'Area(in sq km)': '410',
  'Capital': 'Jamestown',
  'Continent': 'AF',
  'Country': 'Saint Helena',
  'CurrencyCode': 'SHP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SH',
  'ISO-Numeric': '654',
  'ISO3': 'SHN',
  'Languages': 'en-SH',
  'Phone': '290',
  'Population': '7460',
  'Postal Code Format': 'STHL 1ZZ',
  'Postal Code Regex': '^(STHL1ZZ)$',
  'fips': 'SH',
  'geonameid': '3370751',
  'neighbours': '',
  'tld': '.sh'},
 {'Area(in sq km)': '20273',
  'Capital': 'Ljubljana',
  'Continent': 'EU',
  'Country': 'Slovenia',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SI',
  'ISO-Numeric': '705',
  'ISO3': 'SVN',
  'Languages': 'sl,sh',
  'Phone': '386',
  'Population': '2007000',
  'Postal Code Format': 'SI- ####',
  'Postal Code Regex': '^(?:SI)*(\\d{4})$',
  'fips': 'SI',
  'geonameid': '3190538',
  'neighbours': 'HU,IT,HR,AT',
  'tld': '.si'},
 {'Area(in sq km)': '62049',
  'Capital': 'Longyearbyen',
  'Continent': 'EU',
  'Country': 'Svalbard and Jan Mayen',
  'CurrencyCode': 'NOK',
  'CurrencyName': 'Krone',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SJ',
  'ISO-Numeric': '744',
  'ISO3': 'SJM',
  'Languages': 'no,ru',
  'Phone': '47',
  'Population': '2550',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'SV',
  'geonameid': '607072',
  'neighbours': '',
  'tld': '.sj'},
 {'Area(in sq km)': '48845',
  'Capital': 'Bratislava',
  'Continent': 'EU',
  'Country': 'Slovakia',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SK',
  'ISO-Numeric': '703',
  'ISO3': 'SVK',
  'Languages': 'sk,hu',
  'Phone': '421',
  'Population': '5455000',
  'Postal Code Format': '###  ##',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'LO',
  'geonameid': '3057568',
  'neighbours': 'PL,HU,CZ,UA,AT',
  'tld': '.sk'},
 {'Area(in sq km)': '71740',
  'Capital': 'Freetown',
  'Continent': 'AF',
  'Country': 'Sierra Leone',
  'CurrencyCode': 'SLL',
  'CurrencyName': 'Leone',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SL',
  'ISO-Numeric': '694',
  'ISO3': 'SLE',
  'Languages': 'en-SL,men,tem',
  'Phone': '232',
  'Population': '5245695',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'SL',
  'geonameid': '2403846',
  'neighbours': 'LR,GN',
  'tld': '.sl'},
 {'Area(in sq km)': '61.2',
  'Capital': 'San Marino',
  'Continent': 'EU',
  'Country': 'San Marino',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SM',
  'ISO-Numeric': '674',
  'ISO3': 'SMR',
  'Languages': 'it-SM',
  'Phone': '378',
  'Population': '31477',
  'Postal Code Format': '4789#',
  'Postal Code Regex': '^(4789\\d)$',
  'fips': 'SM',
  'geonameid': '3168068',
  'neighbours': 'IT',
  'tld': '.sm'},
 {'Area(in sq km)': '196190',
  'Capital': 'Dakar',
  'Continent': 'AF',
  'Country': 'Senegal',
  'CurrencyCode': 'XOF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SN',
  'ISO-Numeric': '686',
  'ISO3': 'SEN',
  'Languages': 'fr-SN,wo,fuc,mnk',
  'Phone': '221',
  'Population': '12323252',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'SG',
  'geonameid': '2245662',
  'neighbours': 'GN,MR,GW,GM,ML',
  'tld': '.sn'},
 {'Area(in sq km)': '637657',
  'Capital': 'Mogadishu',
  'Continent': 'AF',
  'Country': 'Somalia',
  'CurrencyCode': 'SOS',
  'CurrencyName': 'Shilling',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SO',
  'ISO-Numeric': '706',
  'ISO3': 'SOM',
  'Languages': 'so-SO,ar-SO,it,en-SO',
  'Phone': '252',
  'Population': '10112453',
  'Postal Code Format': '@@  #####',
  'Postal Code Regex': '^([A-Z]{2}\\d{5})$',
  'fips': 'SO',
  'geonameid': '51537',
  'neighbours': 'ET,KE,DJ',
  'tld': '.so'},
 {'Area(in sq km)': '163270',
  'Capital': 'Paramaribo',
  'Continent': 'SA',
  'Country': 'Suriname',
  'CurrencyCode': 'SRD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SR',
  'ISO-Numeric': '740',
  'ISO3': 'SUR',
  'Languages': 'nl-SR,en,srn,hns,jv',
  'Phone': '597',
  'Population': '492829',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'NS',
  'geonameid': '3382998',
  'neighbours': 'GY,BR,GF',
  'tld': '.sr'},
 {'Area(in sq km)': '1001',
  'Capital': 'Sao Tome',
  'Continent': 'AF',
  'Country': 'Sao Tome and Principe',
  'CurrencyCode': 'STD',
  'CurrencyName': 'Dobra',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ST',
  'ISO-Numeric': '678',
  'ISO3': 'STP',
  'Languages': 'pt-ST',
  'Phone': '239',
  'Population': '175808',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'TP',
  'geonameid': '2410758',
  'neighbours': '',
  'tld': '.st'},
 {'Area(in sq km)': '21040',
  'Capital': 'San Salvador',
  'Continent': 'NA',
  'Country': 'El Salvador',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SV',
  'ISO-Numeric': '222',
  'ISO3': 'SLV',
  'Languages': 'es-SV',
  'Phone': '503',
  'Population': '6052064',
  'Postal Code Format': 'CP ####',
  'Postal Code Regex': '^(?:CP)*(\\d{4})$',
  'fips': 'ES',
  'geonameid': '3585968',
  'neighbours': 'GT,HN',
  'tld': '.sv'},
 {'Area(in sq km)': '',
  'Capital': 'Philipsburg',
  'Continent': 'NA',
  'Country': 'Sint Maarten',
  'CurrencyCode': 'ANG',
  'CurrencyName': 'Guilder',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SX',
  'ISO-Numeric': '534',
  'ISO3': 'SXM',
  'Languages': 'nl,en',
  'Phone': '599',
  'Population': '37429',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'NN',
  'geonameid': '7609695',
  'neighbours': 'MF',
  'tld': '.sx'},
 {'Area(in sq km)': '185180',
  'Capital': 'Damascus',
  'Continent': 'AS',
  'Country': 'Syria',
  'CurrencyCode': 'SYP',
  'CurrencyName': 'Pound',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SY',
  'ISO-Numeric': '760',
  'ISO3': 'SYR',
  'Languages': 'ar-SY,ku,hy,arc,fr,en',
  'Phone': '963',
  'Population': '22198110',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'SY',
  'geonameid': '163843',
  'neighbours': 'IQ,JO,IL,TR,LB',
  'tld': '.sy'},
 {'Area(in sq km)': '17363',
  'Capital': 'Mbabane',
  'Continent': 'AF',
  'Country': 'Swaziland',
  'CurrencyCode': 'SZL',
  'CurrencyName': 'Lilangeni',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'SZ',
  'ISO-Numeric': '748',
  'ISO3': 'SWZ',
  'Languages': 'en-SZ,ss-SZ',
  'Phone': '268',
  'Population': '1354051',
  'Postal Code Format': '@###',
  'Postal Code Regex': '^([A-Z]\\d{3})$',
  'fips': 'WZ',
  'geonameid': '934841',
  'neighbours': 'ZA,MZ',
  'tld': '.sz'},
 {'Area(in sq km)': '430',
  'Capital': 'Cockburn Town',
  'Continent': 'NA',
  'Country': 'Turks and Caicos Islands',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TC',
  'ISO-Numeric': '796',
  'ISO3': 'TCA',
  'Languages': 'en-TC',
  'Phone': '+1-649',
  'Population': '20556',
  'Postal Code Format': 'TKCA 1ZZ',
  'Postal Code Regex': '^(TKCA 1ZZ)$',
  'fips': 'TK',
  'geonameid': '3576916',
  'neighbours': '',
  'tld': '.tc'},
 {'Area(in sq km)': '1284000',
  'Capital': "N'Djamena",
  'Continent': 'AF',
  'Country': 'Chad',
  'CurrencyCode': 'XAF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TD',
  'ISO-Numeric': '148',
  'ISO3': 'TCD',
  'Languages': 'fr-TD,ar-TD,sre',
  'Phone': '235',
  'Population': '10543464',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'CD',
  'geonameid': '2434508',
  'neighbours': 'NE,LY,CF,SD,CM,NG',
  'tld': '.td'},
 {'Area(in sq km)': '7829',
  'Capital': 'Port-aux-Francais',
  'Continent': 'AN',
  'Country': 'French Southern Territories',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro  ',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TF',
  'ISO-Numeric': '260',
  'ISO3': 'ATF',
  'Languages': 'fr',
  'Phone': '',
  'Population': '140',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'FS',
  'geonameid': '1546748',
  'neighbours': '',
  'tld': '.tf'},
 {'Area(in sq km)': '56785',
  'Capital': 'Lome',
  'Continent': 'AF',
  'Country': 'Togo',
  'CurrencyCode': 'XOF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TG',
  'ISO-Numeric': '768',
  'ISO3': 'TGO',
  'Languages': 'fr-TG,ee,hna,kbp,dag,ha',
  'Phone': '228',
  'Population': '6587239',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'TO',
  'geonameid': '2363686',
  'neighbours': 'BJ,GH,BF',
  'tld': '.tg'},
 {'Area(in sq km)': '514000',
  'Capital': 'Bangkok',
  'Continent': 'AS',
  'Country': 'Thailand',
  'CurrencyCode': 'THB',
  'CurrencyName': 'Baht',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TH',
  'ISO-Numeric': '764',
  'ISO3': 'THA',
  'Languages': 'th,en',
  'Phone': '66',
  'Population': '67089500',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'TH',
  'geonameid': '1605651',
  'neighbours': 'LA,MM,KH,MY',
  'tld': '.th'},
 {'Area(in sq km)': '143100',
  'Capital': 'Dushanbe',
  'Continent': 'AS',
  'Country': 'Tajikistan',
  'CurrencyCode': 'TJS',
  'CurrencyName': 'Somoni',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TJ',
  'ISO-Numeric': '762',
  'ISO3': 'TJK',
  'Languages': 'tg,ru',
  'Phone': '992',
  'Population': '7487489',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'TI',
  'geonameid': '1220409',
  'neighbours': 'CN,AF,KG,UZ',
  'tld': '.tj'},
 {'Area(in sq km)': '10',
  'Capital': '',
  'Continent': 'OC',
  'Country': 'Tokelau',
  'CurrencyCode': 'NZD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TK',
  'ISO-Numeric': '772',
  'ISO3': 'TKL',
  'Languages': 'tkl,en-TK',
  'Phone': '690',
  'Population': '1466',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'TL',
  'geonameid': '4031074',
  'neighbours': '',
  'tld': '.tk'},
 {'Area(in sq km)': '15007',
  'Capital': 'Dili',
  'Continent': 'OC',
  'Country': 'East Timor',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TL',
  'ISO-Numeric': '626',
  'ISO3': 'TLS',
  'Languages': 'tet,pt-TL,id,en',
  'Phone': '670',
  'Population': '1154625',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'TT',
  'geonameid': '1966436',
  'neighbours': 'ID',
  'tld': '.tl'},
 {'Area(in sq km)': '488100',
  'Capital': 'Ashgabat',
  'Continent': 'AS',
  'Country': 'Turkmenistan',
  'CurrencyCode': 'TMT',
  'CurrencyName': 'Manat',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TM',
  'ISO-Numeric': '795',
  'ISO3': 'TKM',
  'Languages': 'tk,ru,uz',
  'Phone': '993',
  'Population': '4940916',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'TX',
  'geonameid': '1218197',
  'neighbours': 'AF,IR,UZ,KZ',
  'tld': '.tm'},
 {'Area(in sq km)': '163610',
  'Capital': 'Tunis',
  'Continent': 'AF',
  'Country': 'Tunisia',
  'CurrencyCode': 'TND',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TN',
  'ISO-Numeric': '788',
  'ISO3': 'TUN',
  'Languages': 'ar-TN,fr',
  'Phone': '216',
  'Population': '10589025',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'TS',
  'geonameid': '2464461',
  'neighbours': 'DZ,LY',
  'tld': '.tn'},
 {'Area(in sq km)': '748',
  'Capital': "Nuku'alofa",
  'Continent': 'OC',
  'Country': 'Tonga',
  'CurrencyCode': 'TOP',
  'CurrencyName': "Pa'anga",
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TO',
  'ISO-Numeric': '776',
  'ISO3': 'TON',
  'Languages': 'to,en-TO',
  'Phone': '676',
  'Population': '122580',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'TN',
  'geonameid': '4032283',
  'neighbours': '',
  'tld': '.to'},
 {'Area(in sq km)': '780580',
  'Capital': 'Ankara',
  'Continent': 'AS',
  'Country': 'Turkey',
  'CurrencyCode': 'TRY',
  'CurrencyName': 'Lira',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TR',
  'ISO-Numeric': '792',
  'ISO3': 'TUR',
  'Languages': 'tr-TR,ku,diq,az,av',
  'Phone': '90',
  'Population': '77804122',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'TU',
  'geonameid': '298795',
  'neighbours': 'SY,GE,IQ,IR,GR,AM,AZ,BG',
  'tld': '.tr'},
 {'Area(in sq km)': '5128',
  'Capital': 'Port of Spain',
  'Continent': 'NA',
  'Country': 'Trinidad and Tobago',
  'CurrencyCode': 'TTD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TT',
  'ISO-Numeric': '780',
  'ISO3': 'TTO',
  'Languages': 'en-TT,hns,fr,es,zh',
  'Phone': '+1-868',
  'Population': '1228691',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'TD',
  'geonameid': '3573591',
  'neighbours': '',
  'tld': '.tt'},
 {'Area(in sq km)': '26',
  'Capital': 'Funafuti',
  'Continent': 'OC',
  'Country': 'Tuvalu',
  'CurrencyCode': 'AUD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TV',
  'ISO-Numeric': '798',
  'ISO3': 'TUV',
  'Languages': 'tvl,en,sm,gil',
  'Phone': '688',
  'Population': '10472',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'TV',
  'geonameid': '2110297',
  'neighbours': '',
  'tld': '.tv'},
 {'Area(in sq km)': '35980',
  'Capital': 'Taipei',
  'Continent': 'AS',
  'Country': 'Taiwan',
  'CurrencyCode': 'TWD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TW',
  'ISO-Numeric': '158',
  'ISO3': 'TWN',
  'Languages': 'zh-TW,zh,nan,hak',
  'Phone': '886',
  'Population': '22894384',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'TW',
  'geonameid': '1668284',
  'neighbours': '',
  'tld': '.tw'},
 {'Area(in sq km)': '945087',
  'Capital': 'Dodoma',
  'Continent': 'AF',
  'Country': 'Tanzania',
  'CurrencyCode': 'TZS',
  'CurrencyName': 'Shilling',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'TZ',
  'ISO-Numeric': '834',
  'ISO3': 'TZA',
  'Languages': 'sw-TZ,en,ar',
  'Phone': '255',
  'Population': '41892895',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'TZ',
  'geonameid': '149590',
  'neighbours': 'MZ,KE,CD,RW,ZM,BI,UG,MW',
  'tld': '.tz'},
 {'Area(in sq km)': '603700',
  'Capital': 'Kiev',
  'Continent': 'EU',
  'Country': 'Ukraine',
  'CurrencyCode': 'UAH',
  'CurrencyName': 'Hryvnia',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'UA',
  'ISO-Numeric': '804',
  'ISO3': 'UKR',
  'Languages': 'uk,ru-UA,rom,pl,hu',
  'Phone': '380',
  'Population': '45415596',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'UP',
  'geonameid': '690791',
  'neighbours': 'PL,MD,HU,SK,BY,RO,RU',
  'tld': '.ua'},
 {'Area(in sq km)': '236040',
  'Capital': 'Kampala',
  'Continent': 'AF',
  'Country': 'Uganda',
  'CurrencyCode': 'UGX',
  'CurrencyName': 'Shilling',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'UG',
  'ISO-Numeric': '800',
  'ISO3': 'UGA',
  'Languages': 'en-UG,lg,sw,ar',
  'Phone': '256',
  'Population': '33398682',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'UG',
  'geonameid': '226074',
  'neighbours': 'TZ,KE,SS,CD,RW',
  'tld': '.ug'},
 {'Area(in sq km)': '0',
  'Capital': '',
  'Continent': 'OC',
  'Country': 'United States Minor Outlying Islands',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar ',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'UM',
  'ISO-Numeric': '581',
  'ISO3': 'UMI',
  'Languages': 'en-UM',
  'Phone': '1',
  'Population': '0',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': '',
  'geonameid': '5854968',
  'neighbours': '',
  'tld': '.um'},
 {'Area(in sq km)': '9629091',
  'Capital': 'Washington',
  'Continent': 'NA',
  'Country': 'United States',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'US',
  'ISO-Numeric': '840',
  'ISO3': 'USA',
  'Languages': 'en-US,es-US,haw,fr',
  'Phone': '1',
  'Population': '310232863',
  'Postal Code Format': '#####-####',
  'Postal Code Regex': '^(\\d{9})$',
  'fips': 'US',
  'geonameid': '6252001',
  'neighbours': 'CA,MX,CU',
  'tld': '.us'},
 {'Area(in sq km)': '176220',
  'Capital': 'Montevideo',
  'Continent': 'SA',
  'Country': 'Uruguay',
  'CurrencyCode': 'UYU',
  'CurrencyName': 'Peso',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'UY',
  'ISO-Numeric': '858',
  'ISO3': 'URY',
  'Languages': 'es-UY',
  'Phone': '598',
  'Population': '3477000',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'UY',
  'geonameid': '3439705',
  'neighbours': 'BR,AR',
  'tld': '.uy'},
 {'Area(in sq km)': '447400',
  'Capital': 'Tashkent',
  'Continent': 'AS',
  'Country': 'Uzbekistan',
  'CurrencyCode': 'UZS',
  'CurrencyName': 'Som',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'UZ',
  'ISO-Numeric': '860',
  'ISO3': 'UZB',
  'Languages': 'uz,ru,tg',
  'Phone': '998',
  'Population': '27865738',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'UZ',
  'geonameid': '1512440',
  'neighbours': 'TM,AF,KG,TJ,KZ',
  'tld': '.uz'},
 {'Area(in sq km)': '0.44',
  'Capital': 'Vatican City',
  'Continent': 'EU',
  'Country': 'Vatican',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'VA',
  'ISO-Numeric': '336',
  'ISO3': 'VAT',
  'Languages': 'la,it,fr',
  'Phone': '379',
  'Population': '921',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'VT',
  'geonameid': '3164670',
  'neighbours': 'IT',
  'tld': '.va'},
 {'Area(in sq km)': '389',
  'Capital': 'Kingstown',
  'Continent': 'NA',
  'Country': 'Saint Vincent and the Grenadines',
  'CurrencyCode': 'XCD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'VC',
  'ISO-Numeric': '670',
  'ISO3': 'VCT',
  'Languages': 'en-VC,fr',
  'Phone': '+1-784',
  'Population': '104217',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'VC',
  'geonameid': '3577815',
  'neighbours': '',
  'tld': '.vc'},
 {'Area(in sq km)': '912050',
  'Capital': 'Caracas',
  'Continent': 'SA',
  'Country': 'Venezuela',
  'CurrencyCode': 'VEF',
  'CurrencyName': 'Bolivar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'VE',
  'ISO-Numeric': '862',
  'ISO3': 'VEN',
  'Languages': 'es-VE',
  'Phone': '58',
  'Population': '27223228',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'VE',
  'geonameid': '3625428',
  'neighbours': 'GY,BR,CO',
  'tld': '.ve'},
 {'Area(in sq km)': '153',
  'Capital': 'Road Town',
  'Continent': 'NA',
  'Country': 'British Virgin Islands',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'VG',
  'ISO-Numeric': '092',
  'ISO3': 'VGB',
  'Languages': 'en-VG',
  'Phone': '+1-284',
  'Population': '21730',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'VI',
  'geonameid': '3577718',
  'neighbours': '',
  'tld': '.vg'},
 {'Area(in sq km)': '352',
  'Capital': 'Charlotte Amalie',
  'Continent': 'NA',
  'Country': 'U.S. Virgin Islands',
  'CurrencyCode': 'USD',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'VI',
  'ISO-Numeric': '850',
  'ISO3': 'VIR',
  'Languages': 'en-VI',
  'Phone': '+1-340',
  'Population': '108708',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'VQ',
  'geonameid': '4796775',
  'neighbours': '',
  'tld': '.vi'},
 {'Area(in sq km)': '329560',
  'Capital': 'Hanoi',
  'Continent': 'AS',
  'Country': 'Vietnam',
  'CurrencyCode': 'VND',
  'CurrencyName': 'Dong',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'VN',
  'ISO-Numeric': '704',
  'ISO3': 'VNM',
  'Languages': 'vi,en,fr,zh,km',
  'Phone': '84',
  'Population': '89571130',
  'Postal Code Format': '######',
  'Postal Code Regex': '^(\\d{6})$',
  'fips': 'VM',
  'geonameid': '1562822',
  'neighbours': 'CN,LA,KH',
  'tld': '.vn'},
 {'Area(in sq km)': '12200',
  'Capital': 'Port Vila',
  'Continent': 'OC',
  'Country': 'Vanuatu',
  'CurrencyCode': 'VUV',
  'CurrencyName': 'Vatu',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'VU',
  'ISO-Numeric': '548',
  'ISO3': 'VUT',
  'Languages': 'bi,en-VU,fr-VU',
  'Phone': '678',
  'Population': '221552',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'NH',
  'geonameid': '2134431',
  'neighbours': '',
  'tld': '.vu'},
 {'Area(in sq km)': '274',
  'Capital': 'Mata Utu',
  'Continent': 'OC',
  'Country': 'Wallis and Futuna',
  'CurrencyCode': 'XPF',
  'CurrencyName': 'Franc',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'WF',
  'ISO-Numeric': '876',
  'ISO3': 'WLF',
  'Languages': 'wls,fud,fr-WF',
  'Phone': '681',
  'Population': '16025',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(986\\d{2})$',
  'fips': 'WF',
  'geonameid': '4034749',
  'neighbours': '',
  'tld': '.wf'},
 {'Area(in sq km)': '2944',
  'Capital': 'Apia',
  'Continent': 'OC',
  'Country': 'Samoa',
  'CurrencyCode': 'WST',
  'CurrencyName': 'Tala',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'WS',
  'ISO-Numeric': '882',
  'ISO3': 'WSM',
  'Languages': 'sm,en-WS',
  'Phone': '685',
  'Population': '192001',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'WS',
  'geonameid': '4034894',
  'neighbours': '',
  'tld': '.ws'},
 {'Area(in sq km)': '527970',
  'Capital': 'Sanaa',
  'Continent': 'AS',
  'Country': 'Yemen',
  'CurrencyCode': 'YER',
  'CurrencyName': 'Rial',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'YE',
  'ISO-Numeric': '887',
  'ISO3': 'YEM',
  'Languages': 'ar-YE',
  'Phone': '967',
  'Population': '23495361',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'YM',
  'geonameid': '69543',
  'neighbours': 'SA,OM',
  'tld': '.ye'},
 {'Area(in sq km)': '374',
  'Capital': 'Mamoudzou',
  'Continent': 'AF',
  'Country': 'Mayotte',
  'CurrencyCode': 'EUR',
  'CurrencyName': 'Euro',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'YT',
  'ISO-Numeric': '175',
  'ISO3': 'MYT',
  'Languages': 'fr-YT',
  'Phone': '262',
  'Population': '159042',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'MF',
  'geonameid': '1024031',
  'neighbours': '',
  'tld': '.yt'},
 {'Area(in sq km)': '1219912',
  'Capital': 'Pretoria',
  'Continent': 'AF',
  'Country': 'South Africa',
  'CurrencyCode': 'ZAR',
  'CurrencyName': 'Rand',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ZA',
  'ISO-Numeric': '710',
  'ISO3': 'ZAF',
  'Languages': 'zu,xh,af,nso,en-ZA,tn,st,ts,ss,ve,nr',
  'Phone': '27',
  'Population': '49000000',
  'Postal Code Format': '####',
  'Postal Code Regex': '^(\\d{4})$',
  'fips': 'SF',
  'geonameid': '953987',
  'neighbours': 'ZW,SZ,MZ,BW,NA,LS',
  'tld': '.za'},
 {'Area(in sq km)': '752614',
  'Capital': 'Lusaka',
  'Continent': 'AF',
  'Country': 'Zambia',
  'CurrencyCode': 'ZMK',
  'CurrencyName': 'Kwacha',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ZM',
  'ISO-Numeric': '894',
  'ISO3': 'ZMB',
  'Languages': 'en-ZM,bem,loz,lun,lue,ny,toi',
  'Phone': '260',
  'Population': '13460305',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'ZA',
  'geonameid': '895949',
  'neighbours': 'ZW,TZ,MZ,CD,NA,MW,AO',
  'tld': '.zm'},
 {'Area(in sq km)': '390580',
  'Capital': 'Harare',
  'Continent': 'AF',
  'Country': 'Zimbabwe',
  'CurrencyCode': 'ZWL',
  'CurrencyName': 'Dollar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'ZW',
  'ISO-Numeric': '716',
  'ISO3': 'ZWE',
  'Languages': 'en-ZW,sn,nr,nd',
  'Phone': '263',
  'Population': '11651858',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'ZI',
  'geonameid': '878675',
  'neighbours': 'ZA,MZ,BW,ZM',
  'tld': '.zw'},
 {'Area(in sq km)': '102350',
  'Capital': 'Belgrade',
  'Continent': 'EU',
  'Country': 'Serbia and Montenegro',
  'CurrencyCode': 'RSD',
  'CurrencyName': 'Dinar',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'CS',
  'ISO-Numeric': '891',
  'ISO3': 'SCG',
  'Languages': 'cu,hu,sq,sr',
  'Phone': '381',
  'Population': '10829175',
  'Postal Code Format': '#####',
  'Postal Code Regex': '^(\\d{5})$',
  'fips': 'YI',
  'geonameid': '',
  'neighbours': 'AL,HU,MK,RO,HR,BA,BG',
  'tld': '.cs'},
 {'Area(in sq km)': '960',
  'Capital': 'Willemstad',
  'Continent': 'NA',
  'Country': 'Netherlands Antilles',
  'CurrencyCode': 'ANG',
  'CurrencyName': 'Guilder',
  'EquivalentFipsCode\n': '\n',
  'ISO': 'AN',
  'ISO-Numeric': '530',
  'ISO3': 'ANT',
  'Languages': 'nl-AN,en,es',
  'Phone': '599',
  'Population': '136197',
  'Postal Code Format': '',
  'Postal Code Regex': '',
  'fips': 'NT',
  'geonameid': '',
  'neighbours': 'GP',
  'tld': '.an'}]

STATES = [
 ['AD', '06', 'Parr\xc3\xb2quia de Sant Juli\xc3\xa0 de L\xc3\xb2ria'],
 ['AD', '05', "Parr\xc3\xb2quia d'Ordino"],
 ['AD', '04', 'Parr\xc3\xb2quia de la Massana'],
 ['AD', '03', "Parr\xc3\xb2quia d'Encamp"],
 ['AD', '02', 'Parr\xc3\xb2quia de Canillo'],
 ['AD', '07', "Parr\xc3\xb2quia d'Andorra la Vella"],
 ['AD', '08', "Parr\xc3\xb2quia d'Escaldes-Engordany"],
 ['AE', '07', 'Umm al Qaywayn'],
 ['AE', '05', 'Ra\xca\xbcs al Khaymah'],
 ['AE', '03', 'Dubai'],
 ['AE', '06', 'Ash Sh\xc4\x81riqah'],
 ['AE', '04', 'Al Fujayrah'],
 ['AE', '02', 'Ajman'],
 ['AE', '01', 'Abu Dhabi'],
 ['AF', '28', 'Zabul'],
 ['AF', '27', 'Vardak'],
 ['AF', '26', 'Takh\xc4\x81r'],
 ['AF', '33', 'Sar-e Pol'],
 ['AF', '32', 'Samang\xc4\x81n'],
 ['AF', '40', 'Parv\xc4\x81n'],
 ['AF', '29', 'Pakt\xc4\xabk\xc4\x81'],
 ['AF', '36', 'Paktia'],
 ['AF', '39', 'Or\xc5\xabzg\xc4\x81n'],
 ['AF', '19', 'N\xc4\xabmr\xc5\xabz'],
 ['AF', '18', 'Nangarh\xc4\x81r'],
 ['AF', '17', 'Lowgar'],
 ['AF', '35', 'Laghm\xc4\x81n'],
 ['AF', '24', 'Kunduz'],
 ['AF', '34', 'Konar'],
 ['AF', '14', 'K\xc4\x81p\xc4\xabs\xc4\x81'],
 ['AF', '23', 'Kandah\xc4\x81r'],
 ['AF', '13', 'Kabul'],
 ['AF', '31', 'Jowzj\xc4\x81n'],
 ['AF', '11', 'Herat'],
 ['AF', '10', 'Helmand'],
 ['AF', '09', 'Ghowr'],
 ['AF', '08', 'Ghazn\xc4\xab'],
 ['AF', '07', 'Faryab'],
 ['AF', '06', 'Farah'],
 ['AF', '05', 'B\xc4\x81m\xc4\xab\xc4\x81n'],
 ['AF', '30', 'Balkh'],
 ['AF', '03', 'Baghl\xc4\x81n'],
 ['AF', '02', 'Badghis'],
 ['AF', '01', 'Badakhshan'],
 ['AF', '37', 'Khowst'],
 ['AF', '38', 'N\xc5\xabrest\xc4\x81n'],
 ['AF', '41', 'Wil\xc4\x81yat-e D\xc4\x81ykund\xc4\xab'],
 ['AF', '42', 'Panjshir'],
 ['AG', '08', 'Saint Philip'],
 ['AG', '07', 'Saint Peter'],
 ['AG', '06', 'Saint Paul'],
 ['AG', '05', 'Saint Mary'],
 ['AG', '04', 'Saint John'],
 ['AG', '03', 'Saint George'],
 ['AG', '09', 'Redonda'],
 ['AG', '01', 'Barbuda'],
 ['AL', '40', 'Berat'],
 ['AL', '41', 'Dib\xc3\xabr'],
 ['AL', '43', 'Elbasan'],
 ['AL', '45', 'Gjirokast\xc3\xabr'],
 ['AL', '46', 'Kor\xc3\xa7\xc3\xab'],
 ['AL', '47', 'Kuk\xc3\xabs'],
 ['AL', '42', 'Durr\xc3\xabs'],
 ['AL', '44', 'Fier'],
 ['AL', '48', 'Lezh\xc3\xab'],
 ['AL', '49', 'Shkod\xc3\xabr'],
 ['AL', '50', 'Tiran\xc3\xab'],
 ['AL', '51', 'Vlor\xc3\xab'],
 ['AM', '02', 'Ararat'],
 ['AM', '08', 'Syunik\xca\xbc'],
 ['AM', '10', 'Vayots\xca\xbc Dzor'],
 ['AM', '11', 'Yerevan'],
 ['AM', '01', 'Aragatsotn'],
 ['AM', '03', 'Armavir'],
 ['AM', '04', 'Geghark\xca\xbcunik\xca\xbc'],
 ['AM', '05', 'Kotayk\xca\xbc'],
 ['AM', '06', 'Lorri'],
 ['AM', '07', 'Shirak'],
 ['AM', '09', 'Tavush'],
 ['AO', '18', 'Lunda Sul'],
 ['AO', '17', 'Lunda Norte'],
 ['AO', '14', 'Moxico'],
 ['AO', '04', 'Cuando Cubango'],
 ['AO', '16', 'Zaire'],
 ['AO', '15', 'U\xc3\xadge'],
 ['AO', '12', 'Malanje'],
 ['AO', '20', 'Luanda'],
 ['AO', '05', 'Cuanza Norte'],
 ['AO', '03', 'Cabinda'],
 ['AO', '19', 'Bengo'],
 ['AO', '13', 'Namibe'],
 ['AO', '09', 'Hu\xc3\xadla'],
 ['AO', '08', 'Huambo'],
 ['AO', '07', 'Cunene'],
 ['AO', '06', 'Cuanza Sul'],
 ['AO', '02', 'Bi\xc3\xa9'],
 ['AO', '01', 'Benguela'],
 ['AQ', '00', ''],
 ['AR', '14', 'Misiones'],
 ['AR', '09', 'Formosa'],
 ['AR', '07', 'Buenos Aires F.D.'],
 ['AR', '08', 'Entre R\xc3\xados'],
 ['AR', '06', 'Corrientes'],
 ['AR', '01', 'Buenos Aires'],
 ['AR', '24', 'Tucum\xc3\xa1n'],
 ['AR', '23', 'Tierra del Fuego'],
 ['AR', '22', 'Santiago del Estero'],
 ['AR', '21', 'Santa Fe'],
 ['AR', '20', 'Santa Cruz'],
 ['AR', '19', 'San Luis'],
 ['AR', '18', 'San Juan'],
 ['AR', '17', 'Salta'],
 ['AR', '16', 'R\xc3\xado Negro'],
 ['AR', '15', 'Neuqu\xc3\xa9n'],
 ['AR', '13', 'Mendoza'],
 ['AR', '12', 'La Rioja'],
 ['AR', '11', 'La Pampa'],
 ['AR', '10', 'Jujuy'],
 ['AR', '05', 'C\xc3\xb3rdoba'],
 ['AR', '04', 'Chubut'],
 ['AR', '03', 'Chaco'],
 ['AR', '02', 'Catamarca'],
 ['AS', '050', 'Western District'],
 ['AS', '040', 'Swains Island'],
 ['AS', '010', 'Eastern District'],
 ['AS', '020', "Manu'a"],
 ['AS', '030', 'Rose Atoll'],
 ['AT', '09', 'Vienna'],
 ['AT', '08', 'Vorarlberg'],
 ['AT', '07', 'Tyrol'],
 ['AT', '06', 'Styria'],
 ['AT', '05', 'Salzburg'],
 ['AT', '04', 'Upper Austria'],
 ['AT', '03', 'Lower Austria'],
 ['AT', '02', 'Carinthia'],
 ['AT', '01', 'Burgenland'],
 ['AU', '08', 'Western Australia'],
 ['AU', '05', 'South Australia'],
 ['AU', '03', 'Northern Territory'],
 ['AU', '07', 'Victoria'],
 ['AU', '06', 'Tasmania'],
 ['AU', '04', 'Queensland'],
 ['AU', '02', 'New South Wales'],
 ['AU', '01', 'Canberra'],
 ['AX', '941', 'V\xc3\xa5rd\xc3\xb6'],
 ['AX', '771', 'Sund'],
 ['AX', '766', 'Sottunga'],
 ['AX', '736', 'Saltvik'],
 ['AX', '438', 'Lumparland'],
 ['AX', '417', 'Lemland'],
 ['AX', '295', 'Kumlinge'],
 ['AX', '318', 'K\xc3\xb6kar'],
 ['AX', '062', 'F\xc3\xb6gl\xc3\xb6'],
 ['AX', '035', 'Br\xc3\xa4nd\xc3\xb6'],
 ['AX', '478', 'Mariehamn'],
 ['AX', '170', 'Jomala'],
 ['AX', '076', 'Hammarland'],
 ['AX', '065', 'Geta'],
 ['AX', '060', 'Finstr\xc3\xb6m'],
 ['AX', '043', 'Ecker\xc3\xb6'],
 ['AX', '00', ''],
 ['AZ', '12', 'Beyl\xc9\x99qan'],
 ['AZ', '69', 'Z\xc7\x9dngilan'],
 ['AZ', '66', 'Yard\xc4\xb1ml\xc4\xb1'],
 ['AZ', '55', '\xc5\x9eu\xc5\x9fa'],
 ['AZ', '49', 'Salyan'],
 ['AZ', '46', 'Sabirabad'],
 ['AZ', '45', 'Saatl\xc4\xb1'],
 ['AZ', '13', 'Bil\xc7\x9dsuvar'],
 ['AZ', '36', 'Neft\xc3\xa7ala'],
 ['AZ', '35', 'Nakhichevan'],
 ['AZ', '32', 'Masall\xc4\xb1'],
 ['AZ', '31', 'Lerik'],
 ['AZ', '29', 'L\xc9\x99nk\xc9\x99ran'],
 ['AZ', '28', 'La\xc3\xa7\xc4\xb1n'],
 ['AZ', '43', 'Qubadl\xc4\xb1'],
 ['AZ', '24', '\xc4\xb0mi\xc5\x9fli'],
 ['AZ', '18', 'F\xc3\xbczuli'],
 ['AZ', '14', 'C\xc7\x9dbray\xc4\xb1l'],
 ['AZ', '15', 'C\xc9\x99lilabad'],
 ['AZ', '08', 'Astara'],
 ['AZ', '64', 'Xocal\xc4\xb1'],
 ['AZ', '02', 'A\xc4\x9fcab\xc7\x9ddi'],
 ['AZ', '03', 'A\xc4\x9fdam'],
 ['AZ', '07', '\xc6\x8fli Bayramli'],
 ['AZ', '30', 'L\xc9\x99nk\xc9\x99ran \xc5\x9e\xc9\x99h\xc9\x99ri'],
 ['AZ', '56', '\xc5\x9eu\xc5\x9fa \xc5\x9e\xc9\x99h\xc9\x99ri'],
 ['AZ', '57', 'T\xc7\x9drt\xc7\x9dr'],
 ['AZ', '61', 'Xank\xc7\x9dndi'],
 ['AZ', '65', 'Xocav\xc7\x9dnd'],
 ['AZ', '71', 'Z\xc9\x99rdab'],
 ['AZ', '70', 'Zaqatala'],
 ['AZ', '67', 'Yevlax'],
 ['AZ', '37', 'O\xc4\x9fuz'],
 ['AZ', '59', 'Ucar'],
 ['AZ', '58', 'Tovuz'],
 ['AZ', '50', '\xc5\x9eamax\xc4\xb1'],
 ['AZ', '47', '\xc5\x9e\xc7\x9dki'],
 ['AZ', '51', '\xc5\x9e\xc7\x9dmkir'],
 ['AZ', '27', 'K\xc3\xbcrd\xc7\x9dmir'],
 ['AZ', '38', 'Q\xc7\x9db\xc7\x9dl\xc7\x9d'],
 ['AZ', '44', 'Qusar'],
 ['AZ', '42', 'Quba'],
 ['AZ', '62', 'Goygol Rayon'],
 ['AZ', '60', 'Xa\xc3\xa7maz'],
 ['AZ', '26', 'K\xc7\x9dlb\xc7\x9dc\xc7\x9dr'],
 ['AZ', '40', 'Qazax'],
 ['AZ', '21', 'Goranboy'],
 ['AZ', '39', 'Q\xc7\x9dx'],
 ['AZ', '25', '\xc4\xb0smay\xc4\xb1ll\xc4\xb1'],
 ['AZ', '22', 'G\xc3\xb6y\xc3\xa7ay'],
 ['AZ', '17', 'D\xc7\x9dv\xc7\x9d\xc3\xa7i'],
 ['AZ', '16', 'Da\xc5\x9fk\xc7\x9ds\xc7\x9dn'],
 ['AZ', '10', 'Balak\xc7\x9dn'],
 ['AZ', '11', 'B\xc7\x9drd\xc7\x9d'],
 ['AZ', '09', 'Baki'],
 ['AZ', '01', 'Ab\xc5\x9feron'],
 ['AZ', '06', 'A\xc4\x9fsu'],
 ['AZ', '04', 'A\xc4\x9fda\xc5\x9f'],
 ['AZ', '19', 'G\xc7\x9dd\xc7\x9db\xc7\x9dy'],
 ['AZ', '05', 'A\xc4\x9fstafa'],
 ['AZ', '20', 'G\xc7\x9dnc\xc7\x9d'],
 ['AZ', '33', 'Ming\xc7\x9dcevir'],
 ['AZ', '34', 'Naftalan'],
 ['AZ', '41', 'Qobustan'],
 ['AZ', '52', 'Samux'],
 ['AZ', '48', 'Shaki City'],
 ['AZ', '53', 'Siy\xc7\x9dz\xc7\x9dn'],
 ['AZ', '54', 'Sumqayit'],
 ['AZ', '63', 'X\xc4\xb1z\xc4\xb1'],
 ['AZ', '68', 'Yevlax City'],
 ['AZ', '23', 'Hac\xc4\xb1qabul'],
 ['BA', '01', 'Federation of Bosnia and Herzegovina'],
 ['BA', '02', 'Republika Srpska'],
 ['BA', 'BRC', 'Br\xc4\x8dko'],
 ['BB', '11', 'Saint Thomas'],
 ['BB', '10', 'Saint Philip'],
 ['BB', '09', 'Saint Peter'],
 ['BB', '08', 'Saint Michael'],
 ['BB', '07', 'Saint Lucy'],
 ['BB', '06', 'Saint Joseph'],
 ['BB', '05', 'Saint John'],
 ['BB', '04', 'Saint James'],
 ['BB', '03', 'Saint George'],
 ['BB', '02', 'Saint Andrew'],
 ['BB', '01', 'Christ Church'],
 ['BD', '83', 'R\xc4\x81jsh\xc4\x81hi'],
 ['BD', '81', 'Dhaka'],
 ['BD', '84', 'Chittagong'],
 ['BD', '82', 'Khulna'],
 ['BD', '85', 'Baris\xc4\x81l'],
 ['BD', '86', 'Sylhet'],
 ['BD', '87', 'Rangpur Division'],
 ['BE', 'BRU', 'Brussels Capital Region'],
 ['BE', 'WAL', 'Walloon Region'],
 ['BE', 'VLG', 'Flanders'],
 ['BF', '01', 'Boucle du Mouhoun Region'],
 ['BF', '02', 'Cascades Region'],
 ['BF', '03', 'Centre'],
 ['BF', '04', 'Centre-Est'],
 ['BF', '05', 'Centre-Nord'],
 ['BF', '06', 'Centre-Ouest'],
 ['BF', '07', 'Centre-Sud'],
 ['BF', '08', 'Est'],
 ['BF', '09', 'High-Basins Region'],
 ['BF', '10', 'Nord'],
 ['BF', '11', 'Plateau-Central'],
 ['BF', '12', 'Sahel'],
 ['BF', '13', 'Southwest Region'],
 ['BG', '52', 'Razgrad'],
 ['BG', '47', 'Montana'],
 ['BG', '64', 'Vratsa'],
 ['BG', '61', 'Varna'],
 ['BG', '40', 'Dobrich'],
 ['BG', '58', 'Sofiya'],
 ['BG', '53', 'Ruse'],
 ['BG', '51', 'Plovdiv'],
 ['BG', '50', 'Pleven'],
 ['BG', '49', 'Pernik'],
 ['BG', '48', 'Pazardzhit'],
 ['BG', '46', 'Lovech'],
 ['BG', '43', 'Khaskovo'],
 ['BG', '42', 'Sofia-Capital'],
 ['BG', '39', 'Burgas'],
 ['BG', '38', 'Blagoevgrad'],
 ['BG', '41', 'Gabrovo'],
 ['BG', '44', 'K\xc5\xadrdzhali'],
 ['BG', '45', 'Kyustendil'],
 ['BG', '54', 'Shumen'],
 ['BG', '55', 'Silistra'],
 ['BG', '56', 'Sliven'],
 ['BG', '57', 'Smolyan'],
 ['BG', '59', 'Stara Zagora'],
 ['BG', '60', 'T\xc5\xadrgovishte'],
 ['BG', '62', 'Veliko T\xc5\xadrnovo'],
 ['BG', '63', 'Vidin'],
 ['BG', '65', 'Yambol'],
 ['BH', '15', 'Muharraq'],
 ['BH', '16', 'Capital'],
 ['BH', '17', 'Southern Governorate'],
 ['BH', '18', 'Central Governorate'],
 ['BH', '19', 'Northern'],
 ['BI', '17', 'Makamba'],
 ['BI', '10', 'Bururi'],
 ['BI', '22', 'Muramvya'],
 ['BI', '13', 'Gitega'],
 ['BI', '21', 'Ruyigi'],
 ['BI', '11', 'Cankuzo'],
 ['BI', '14', 'Karuzi'],
 ['BI', '09', 'Bubanza'],
 ['BI', '12', 'Cibitoke'],
 ['BI', '19', 'Ngozi'],
 ['BI', '15', 'Kayanza'],
 ['BI', '18', 'Muyinga'],
 ['BI', '16', 'Kirundo'],
 ['BI', '20', 'Rutana'],
 ['BI', '23', 'Mwaro'],
 ['BI', '24', 'Bujumbura Mairie Province'],
 ['BI', '25', 'Bujumbura Rural Province'],
 ['BJ', '18', 'Zou'],
 ['BJ', '16', 'Qu\xc3\xa9m\xc3\xa9'],
 ['BJ', '15', 'Mono'],
 ['BJ', '10', 'Borgou'],
 ['BJ', '09', 'Atlantique'],
 ['BJ', '08', 'Atakora'],
 ['BJ', '07', 'Alibori'],
 ['BJ', '11', 'Collines'],
 ['BJ', '12', 'Kouffo'],
 ['BJ', '13', 'Donga'],
 ['BJ', '14', 'Littoral'],
 ['BJ', '17', 'Plateau'],
 ['BM', '11', 'Warwick'],
 ['BM', '10', 'Southampton'],
 ['BM', '09', 'Smith\xca\xbcs'],
 ['BM', '08', 'Sandys'],
 ['BM', '07', 'Saint George\xca\xbcs'],
 ['BM', '06', 'Saint George'],
 ['BM', '05', 'Pembroke'],
 ['BM', '04', 'Paget'],
 ['BM', '02', 'Hamilton Parish'],
 ['BM', '03', 'Hamilton city'],
 ['BM', '01', 'Devonshire'],
 ['BN', '04', 'Tutong'],
 ['BN', '03', 'Temburong'],
 ['BN', '02', 'Brunei and Muara'],
 ['BN', '01', 'Belait'],
 ['BO', '09', 'Tarija'],
 ['BO', '08', 'Santa Cruz'],
 ['BO', '07', 'Potos\xc3\xad'],
 ['BO', '06', 'Pando'],
 ['BO', '05', 'Oruro'],
 ['BO', '04', 'La Paz'],
 ['BO', '02', 'Cochabamba'],
 ['BO', '01', 'Chuquisaca'],
 ['BO', '03', 'El Beni'],
 ['BQ', 'BO', 'Bonaire'],
 ['BQ', 'SB', 'Saba'],
 ['BQ', 'SE', 'Sint Eustatius'],
 ['BR', '22', 'Rio Grande do Norte'],
 ['BR', '20', 'Piau\xc3\xad'],
 ['BR', '30', 'Pernambuco'],
 ['BR', '17', 'Para\xc3\xadba'],
 ['BR', '16', 'Par\xc3\xa1'],
 ['BR', '13', 'Maranh\xc3\xa3o'],
 ['BR', '06', 'Cear\xc3\xa1'],
 ['BR', '03', 'Amap\xc3\xa1'],
 ['BR', '02', 'Alagoas'],
 ['BR', '28', 'Sergipe'],
 ['BR', '27', 'S\xc3\xa3o Paulo'],
 ['BR', '26', 'Santa Catarina'],
 ['BR', '23', 'Rio Grande do Sul'],
 ['BR', '21', 'Rio de Janeiro'],
 ['BR', '18', 'Paran\xc3\xa1'],
 ['BR', '15', 'Minas Gerais'],
 ['BR', '11', 'Mato Grosso do Sul'],
 ['BR', '14', 'Mato Grosso'],
 ['BR', '29', 'Goi\xc3\xa1s'],
 ['BR', '07', 'Federal District'],
 ['BR', '08', 'Esp\xc3\xadrito Santo'],
 ['BR', '05', 'Bahia'],
 ['BR', '31', 'Tocantins'],
 ['BR', '25', 'Roraima'],
 ['BR', '04', 'Amazonas'],
 ['BR', '01', 'Acre'],
 ['BR', '24', 'Rond\xc3\xb4nia'],
 ['BS', '35', 'San Salvador'],
 ['BS', '34', 'Sandy Point'],
 ['BS', '33', 'Rock Sound'],
 ['BS', '18', 'Ragged Island'],
 ['BS', '32', 'Berry Islands District'],
 ['BS', '23', 'New Providence'],
 ['BS', '16', 'Mayaguana'],
 ['BS', '31', 'Marsh Harbour'],
 ['BS', '15', 'Long Island'],
 ['BS', '30', 'Kemps Bay'],
 ['BS', '13', 'Inagua'],
 ['BS', '29', 'High Rock'],
 ['BS', '22', 'Harbour Island'],
 ['BS', '28', 'Green Turtle Cay'],
 ['BS', '27', 'Governor\xca\xbcs Harbour'],
 ['BS', '26', 'Fresh Creek'],
 ['BS', '25', 'Freeport'],
 ['BS', '10', 'Exuma'],
 ['BS', '06', 'Cat Island'],
 ['BS', '05', 'Bimini'],
 ['BS', '24', 'Acklins and Crooked Islands'],
 ['BS', '36', 'Black Point'],
 ['BS', '37', 'Central Abaco'],
 ['BS', '38', 'Central Andros'],
 ['BS', '39', 'Central Eleuthera'],
 ['BS', '40', 'Crooked Island and Long Cay'],
 ['BS', '41', 'East Grand Bahama'],
 ['BS', '42', 'Grand Cay'],
 ['BS', '43', 'Hope Town'],
 ['BS', '44', 'Mangrove Cay'],
 ['BS', '45', 'Moore\xe2\x80\x99s Island'],
 ['BS', '46', 'North Abaco'],
 ['BS', '47', 'North Andros'],
 ['BS', '48', 'North Eleuthera'],
 ['BS', '49', 'Rum Cay'],
 ['BS', '50', 'South Abaco'],
 ['BS', '51', 'South Andros'],
 ['BS', '52', 'South Eleuthera'],
 ['BS', '53', 'Spanish Wells'],
 ['BS', '54', 'West Grand Bahama'],
 ['BT', '05', 'Bumthang'],
 ['BT', '06', 'Chhukha'],
 ['BT', '08', 'Daga'],
 ['BT', '07', 'Chirang'],
 ['BT', '09', 'Geylegphug'],
 ['BT', '10', 'Ha'],
 ['BT', '11', 'Lhuntshi'],
 ['BT', '12', 'Mongar'],
 ['BT', '13', 'Paro'],
 ['BT', '14', 'Pemagatsel'],
 ['BT', '15', 'Punakha'],
 ['BT', '16', 'Samchi'],
 ['BT', '17', 'Samdrup Jongkhar'],
 ['BT', '18', 'Shemgang'],
 ['BT', '19', 'Tashigang'],
 ['BT', '20', 'Thimphu'],
 ['BT', '21', 'Tongsa'],
 ['BT', '22', 'Wangdi Phodrang'],
 ['BT', '23', 'Gasa'],
 ['BT', '24', 'Trashi Yangste'],
 ['BV', '00', ''],
 ['BW', '10', 'Southern'],
 ['BW', '09', 'South East'],
 ['BW', '08', 'North East'],
 ['BW', '11', 'North West'],
 ['BW', '06', 'Kweneng'],
 ['BW', '05', 'Kgatleng'],
 ['BW', '04', 'Kgalagadi'],
 ['BW', '03', 'Ghanzi'],
 ['BW', '01', 'Central'],
 ['BY', '07', 'Vitsyebskaya Voblasts\xca\xbc'],
 ['BY', '06', 'Mahilyowskaya Voblasts\xca\xbc'],
 ['BY', '05', 'Minskaya Voblasts\xca\xbc'],
 ['BY', '04', 'Horad Minsk'],
 ['BY', '03', 'Hrodzyenskaya Voblasts\xca\xbc'],
 ['BY', '02', 'Homyel\xca\xbcskaya Voblasts\xca\xbc'],
 ['BY', '01', 'Brestskaya Voblasts\xca\xbc'],
 ['BZ', '06', 'Toledo'],
 ['BZ', '05', 'Stann Creek'],
 ['BZ', '04', 'Orange Walk'],
 ['BZ', '03', 'Corozal'],
 ['BZ', '02', 'Cayo'],
 ['BZ', '01', 'Belize'],
 ['CA', '01', 'Alberta'],
 ['CA', '02', 'British Columbia'],
 ['CA', '03', 'Manitoba'],
 ['CA', '04', 'New Brunswick'],
 ['CA', '13', 'Northwest Territories'],
 ['CA', '07', 'Nova Scotia'],
 ['CA', '14', 'Nunavut'],
 ['CA', '08', 'Ontario'],
 ['CA', '09', 'Prince Edward Island'],
 ['CA', '10', 'Quebec'],
 ['CA', '11', 'Saskatchewan'],
 ['CA', '12', 'Yukon'],
 ['CA', '05', 'Newfoundland and Labrador'],
 ['CD', '12', 'South Kivu'],
 ['CD', '05', 'Katanga'],
 ['CD', '11', 'Nord Kivu'],
 ['CD', '10', 'Maniema'],
 ['CD', '04', 'Kasa\xc3\xaf-Oriental'],
 ['CD', '03', 'Kasa\xc3\xaf-Occidental'],
 ['CD', '09', 'Eastern Province'],
 ['CD', '02', '\xc3\x89quateur'],
 ['CD', '06', 'Kinshasa'],
 ['CD', '08', 'Bas-Congo'],
 ['CD', '01', 'Bandundu'],
 ['CF', '14', 'Vakaga'],
 ['CF', '11', 'Ouaka'],
 ['CF', '08', 'Mbomou'],
 ['CF', '05', 'Haut-Mbomou'],
 ['CF', '03', 'Haute-Kotto'],
 ['CF', '02', 'Basse-Kotto'],
 ['CF', '01', 'Bamingui-Bangoran'],
 ['CF', '16', 'Sangha-Mba\xc3\xa9r\xc3\xa9'],
 ['CF', '13', 'Ouham-Pend\xc3\xa9'],
 ['CF', '12', 'Ouham'],
 ['CF', '17', 'Ombella-Mpoko'],
 ['CF', '09', 'Nana-Mamb\xc3\xa9r\xc3\xa9'],
 ['CF', '07', 'Lobaye'],
 ['CF', '06', 'K\xc3\xa9mo'],
 ['CF', '04', 'Mamb\xc3\xa9r\xc3\xa9-Kad\xc3\xa9\xc3\xaf'],
 ['CF', '15', 'Nana-Gr\xc3\xa9bizi'],
 ['CF', '18', 'Bangui'],
 ['CG', '10', 'Sangha'],
 ['CG', '11', 'Pool'],
 ['CG', '08', 'Plateaux'],
 ['CG', '07', 'Niari'],
 ['CG', '06', 'Likouala'],
 ['CG', '05', 'L\xc3\xa9koumou'],
 ['CG', '04', 'Kouilou'],
 ['CG', '13', 'Cuvette'],
 ['CG', '01', 'Bouenza'],
 ['CG', '12', 'Brazzaville'],
 ['CG', '14', 'Cuvette-Ouest'],
 ['CG', '7280295', 'Pointe-Noire'],
 ['CH', 'ZH', 'Zurich'],
 ['CH', 'ZG', 'Zug'],
 ['CH', 'VD', 'Vaud'],
 ['CH', 'VS', 'Valais'],
 ['CH', 'UR', 'Uri'],
 ['CH', 'TI', 'Ticino'],
 ['CH', 'TG', 'Thurgau'],
 ['CH', 'SO', 'Solothurn'],
 ['CH', 'SZ', 'Schwyz'],
 ['CH', 'SH', 'Schaffhausen'],
 ['CH', 'SG', 'Saint Gallen'],
 ['CH', 'OW', 'Obwalden'],
 ['CH', 'NW', 'Nidwalden'],
 ['CH', 'NE', 'Neuch\xc3\xa2tel'],
 ['CH', 'LU', 'Lucerne'],
 ['CH', 'JU', 'Jura'],
 ['CH', 'GR', 'Grisons'],
 ['CH', 'GL', 'Glarus'],
 ['CH', 'GE', 'Geneva'],
 ['CH', 'FR', 'Fribourg'],
 ['CH', 'BE', 'Bern'],
 ['CH', 'BS', 'Basel-Stadt'],
 ['CH', 'BL', 'B\xc3\xa2le Campagne'],
 ['CH', 'AR', 'Appenzell Ausserrhoden'],
 ['CH', 'AI', "Canton d'Appenzell Rhoden-Int\xc3\xa9rieur"],
 ['CH', 'AG', 'Aargau'],
 ['CI', '82', 'Lagunes'],
 ['CI', '89', 'Sud-Como\xc3\xa9'],
 ['CI', '74', 'Agn\xc3\xa9by'],
 ['CI', '80', 'Haut-Sassandra'],
 ['CI', '87', 'Savanes'],
 ['CI', '90', 'Vall\xc3\xa9e du Bandama'],
 ['CI', '85', 'Moyen-Como\xc3\xa9'],
 ['CI', '78', 'Dix-Huit Montagnes'],
 ['CI', '81', 'Lacs'],
 ['CI', '92', 'Zanzan'],
 ['CI', '76', 'Bas-Sassandra'],
 ['CI', '91', 'Worodougou'],
 ['CI', '77', 'Dengu\xc3\xa9l\xc3\xa9'],
 ['CI', '88', 'Sud-Bandama'],
 ['CI', '79', 'Fromager'],
 ['CI', '86', 'N\xca\xbczi-Como\xc3\xa9'],
 ['CI', '83', 'Marahou\xc3\xa9'],
 ['CI', '84', 'Moyen-Cavally'],
 ['CI', '75', 'Bafing'],
 ['CL', '01', 'Valpara\xc3\xadso'],
 ['CL', '15', 'Tarapac\xc3\xa1'],
 ['CL', '12', 'Santiago'],
 ['CL', '11', 'Maule'],
 ['CL', '14', 'Los Lagos'],
 ['CL', '08', "O'Higgins"],
 ['CL', '07', 'Coquimbo'],
 ['CL', '06', 'Biob\xc3\xado'],
 ['CL', '05', 'Atacama'],
 ['CL', '04', 'Araucan\xc3\xada'],
 ['CL', '03', 'Antofagasta'],
 ['CL', '02', 'Ais\xc3\xa9n'],
 ['CL', '10', 'Magallanes'],
 ['CL', '16', 'Arica y Parinacota'],
 ['CL', '17', 'Los R\xc3\xados'],
 ['CM', '09', 'South-West Region'],
 ['CM', '14', 'South Province'],
 ['CM', '08', 'West Province'],
 ['CM', '07', 'North-West Province'],
 ['CM', '13', 'North Region'],
 ['CM', '05', 'Littoral Region'],
 ['CM', '12', 'Far North Region'],
 ['CM', '04', 'East Province'],
 ['CM', '11', 'Centre Province'],
 ['CM', '10', 'Adamaoua Province'],
 ['CN', '14', 'Tibet Autonomous Region'],
 ['CN', '06', 'Qinghai Sheng'],
 ['CN', '13', 'Xinjiang Uygur Zizhiqu'],
 ['CN', '02', 'Zhejiang Sheng'],
 ['CN', '29', 'Yunnan'],
 ['CN', '28', 'Tianjin Shi'],
 ['CN', '32', 'Sichuan'],
 ['CN', '24', 'Shanxi Sheng'],
 ['CN', '23', 'Shanghai Shi'],
 ['CN', '25', 'Shandong Sheng'],
 ['CN', '26', 'Shaanxi'],
 ['CN', '21', 'Ningxia Huizu Zizhiqu'],
 ['CN', '03', 'Jiangxi'],
 ['CN', '04', 'Jiangsu Sheng'],
 ['CN', '11', 'Hunan'],
 ['CN', '12', 'Hubei'],
 ['CN', '09', 'Henan Sheng'],
 ['CN', '10', 'Hebei'],
 ['CN', '31', 'Hainan'],
 ['CN', '18', 'Guizhou Sheng'],
 ['CN', '16', 'Guangxi Zhuangzu Zizhiqu'],
 ['CN', '30', 'Guangdong Sheng'],
 ['CN', '15', 'Gansu Sheng'],
 ['CN', '07', 'Fujian'],
 ['CN', '33', 'Chongqing Shi'],
 ['CN', '01', 'Anhui Sheng'],
 ['CN', '20', 'Inner Mongolia'],
 ['CN', '19', 'Liaoning'],
 ['CN', '05', 'Jilin Sheng'],
 ['CN', '08', 'Heilongjiang Sheng'],
 ['CN', '22', 'Beijing'],
 ['CO', '31', 'Vichada'],
 ['CO', '30', 'Vaup\xc3\xa9s'],
 ['CO', '29', 'Valle del Cauca'],
 ['CO', '28', 'Tolima'],
 ['CO', '27', 'Sucre'],
 ['CO', '26', 'Santander'],
 ['CO',
  '25',
  'Archipi\xc3\xa9lago de San Andr\xc3\xa9s, Providencia y Santa Catalina'],
 ['CO', '24', 'Risaralda'],
 ['CO', '23', 'Quind\xc3\xado'],
 ['CO', '22', 'Putumayo'],
 ['CO', '21', 'Norte de Santander'],
 ['CO', '20', 'Nari\xc3\xb1o'],
 ['CO', '19', 'Meta'],
 ['CO', '38', 'Magdalena'],
 ['CO', '17', 'La Guajira'],
 ['CO', '16', 'Huila'],
 ['CO', '14', 'Guaviare'],
 ['CO', '15', 'Guain\xc3\xada'],
 ['CO', '33', 'Cundinamarca'],
 ['CO', '12', 'C\xc3\xb3rdoba'],
 ['CO', '11', 'Choc\xc3\xb3'],
 ['CO', '10', 'Cesar'],
 ['CO', '09', 'Cauca'],
 ['CO', '32', 'Casanare'],
 ['CO', '08', 'Caquet\xc3\xa1'],
 ['CO', '37', 'Caldas'],
 ['CO', '36', 'Boyac\xc3\xa1'],
 ['CO', '35', 'Bol\xc3\xadvar'],
 ['CO', '34', 'Bogota D.C.'],
 ['CO', '04', 'Atl\xc3\xa1ntico'],
 ['CO', '03', 'Arauca'],
 ['CO', '02', 'Antioquia'],
 ['CO', '01', 'Amazonas'],
 ['CR', '08', 'San Jos\xc3\xa9'],
 ['CR', '07', 'Puntarenas'],
 ['CR', '06', 'Lim\xc3\xb3n'],
 ['CR', '04', 'Heredia'],
 ['CR', '03', 'Guanacaste'],
 ['CR', '02', 'Cartago'],
 ['CR', '01', 'Alajuela'],
 ['CU', '16', 'Villa Clara'],
 ['CU', '15', 'Santiago de Cuba'],
 ['CU', '14', 'Sancti Sp\xc3\xadritus'],
 ['CU', '01', 'Pinar del R\xc3\xado'],
 ['CU', '03', 'Matanzas'],
 ['CU', '13', 'Las Tunas'],
 ['CU', '04', 'Isla de la Juventud'],
 ['CU', '12', 'Holgu\xc3\xadn'],
 ['CU', '10', 'Guant\xc3\xa1namo'],
 ['CU', '09', 'Granma'],
 ['CU', '02', 'Ciudad de La Habana'],
 ['CU', '08', 'Cienfuegos'],
 ['CU', '07', 'Ciego de \xc3\x81vila'],
 ['CU', '05', 'Camag\xc3\xbcey'],
 ['CU', 'AR', 'Provincia Artemisa'],
 ['CU', 'MA', 'Provincia Mayabeque'],
 ['CV', '20', 'Tarrafal'],
 ['CV', '11', 'S\xc3\xa3o Vicente'],
 ['CV', '15', 'Santa Catarina'],
 ['CV', '08', 'Sal'],
 ['CV', '07', 'Ribeira Grande'],
 ['CV', '14', 'Praia'],
 ['CV', '05', 'Paul'],
 ['CV', '04', 'Maio'],
 ['CV', '02', 'Brava'],
 ['CV', '01', 'Boa Vista'],
 ['CV', '13', 'Mosteiros'],
 ['CV', '16', 'Santa Cruz'],
 ['CV', '17', 'S\xc3\xa3o Domingos'],
 ['CV', '18', 'S\xc3\xa3o Filipe'],
 ['CV', '19', 'S\xc3\xa3o Miguel'],
 ['CV', '21', 'Porto Novo'],
 ['CV', '22', 'Ribeira Brava'],
 ['CV', '24', 'Santa Catarina do Fogo'],
 ['CV', '26', 'S\xc3\xa3o Salvador do Mundo'],
 ['CV', '27', 'Tarrafal de S\xc3\xa3o Nicolau'],
 ['CV', '25', 'S\xc3\xa3o Louren\xc3\xa7o dos Org\xc3\xa3os'],
 ['CV', '23', 'Ribeira Grande de Santiago'],
 ['CY', '06', 'Paphos'],
 ['CY', '04', 'Nicosia'],
 ['CY', '05', 'Limassol'],
 ['CY', '03', 'Larnaca'],
 ['CY', '02', 'Kyrenia'],
 ['CY', '01', 'Famagusta'],
 ['CZ', '52', 'Hlavn\xc3\xad Mesto Praha'],
 ['CZ', '78', 'South Moravian Region'],
 ['CZ', '79', 'Jiho\xc4\x8desk\xc3\xbd Kraj'],
 ['CZ', '80', 'Vyso\xc4\x8dina'],
 ['CZ', '81', 'Karlovarsk\xc3\xbd Kraj'],
 ['CZ', '82', 'Kr\xc3\xa1lov\xc3\xa9hradeck\xc3\xbd'],
 ['CZ', '83', 'Libereck\xc3\xbd Kraj'],
 ['CZ', '84', 'Olomouck\xc3\xbd'],
 ['CZ', '85', 'Moravskoslezsk\xc3\xbd Kraj'],
 ['CZ', '86', 'Pardubick\xc3\xbd Kraj'],
 ['CZ', '87', 'Plze\xc5\x88sk\xc3\xbd Kraj'],
 ['CZ', '88', 'St\xc5\x99edo\xc4\x8desk\xc3\xbd Kraj'],
 ['CZ', '89', '\xc3\x9asteck\xc3\xbd Kraj'],
 ['CZ', '90', 'Zl\xc3\xadnsk\xc3\xbd Kraj'],
 ['DE', '15', 'Thuringia'],
 ['DE', '10', 'Schleswig-Holstein'],
 ['DE', '14', 'Saxony-Anhalt'],
 ['DE', '13', 'Saxony'],
 ['DE', '09', 'Saarland'],
 ['DE', '08', 'Rheinland-Pfalz'],
 ['DE', '07', 'North Rhine-Westphalia'],
 ['DE', '06', 'Lower Saxony'],
 ['DE', '12', 'Mecklenburg-Vorpommern'],
 ['DE', '05', 'Hesse'],
 ['DE', '04', 'Hamburg City'],
 ['DE', '03', 'Bremen'],
 ['DE', '11', 'Brandenburg'],
 ['DE', '16', 'Berlin'],
 ['DE', '02', 'Bavaria'],
 ['DE', '01', 'Baden-W\xc3\xbcrttemberg'],
 ['DJ', '05', 'Tadjourah'],
 ['DJ', '04', 'Obock'],
 ['DJ', '07', 'Djibouti'],
 ['DJ', '06', 'Dikhil'],
 ['DJ', '01', 'Ali Sabieh'],
 ['DJ', '08', 'Arta'],
 ['DK', '17', 'Capital Region'],
 ['DK', '18', 'Central Jutland'],
 ['DK', '19', 'North Jutland'],
 ['DK', '20', 'Zealand'],
 ['DK', '21', 'South Denmark'],
 ['DM', '11', 'Saint Peter'],
 ['DM', '10', 'Saint Paul'],
 ['DM', '09', 'Saint Patrick'],
 ['DM', '08', 'Saint Mark'],
 ['DM', '07', 'Saint Luke'],
 ['DM', '06', 'Saint Joseph'],
 ['DM', '05', 'Saint John'],
 ['DM', '04', 'Saint George'],
 ['DM', '03', 'Saint David'],
 ['DM', '02', 'Saint Andrew'],
 ['DO', '27', 'Valverde'],
 ['DO', '26', 'Santiago Rodr\xc3\xadguez'],
 ['DO', '25', 'Santiago'],
 ['DO', '24', 'San Pedro de Macor\xc3\xads'],
 ['DO', '23', 'San Juan'],
 ['DO', '33', 'San Crist\xc3\xb3bal'],
 ['DO', '21', 'S\xc3\xa1nchez Ram\xc3\xadrez'],
 ['DO', '20', 'Saman\xc3\xa1'],
 ['DO', '19', 'Hermanas Mirabal'],
 ['DO', '18', 'Puerto Plata'],
 ['DO', '35', 'Peravia'],
 ['DO', '16', 'Pedernales'],
 ['DO', '34', 'Distrito Nacional'],
 ['DO', '32', 'Monte Plata'],
 ['DO', '15', 'Monte Cristi'],
 ['DO', '31', 'Monse\xc3\xb1or Nouel'],
 ['DO', '14', 'Mar\xc3\xada Trinidad S\xc3\xa1nchez'],
 ['DO', '30', 'La Vega'],
 ['DO', '12', 'La Romana'],
 ['DO', '10', 'La Altagracia'],
 ['DO', '09', 'Independencia'],
 ['DO', '29', 'Hato Mayor'],
 ['DO', '08', 'Espaillat'],
 ['DO', '28', 'El Se\xc3\xadbo'],
 ['DO', '11', 'El\xc3\xadas Pi\xc3\xb1a'],
 ['DO', '06', 'Duarte'],
 ['DO', '04', 'Dajab\xc3\xb3n'],
 ['DO', '03', 'Barahona'],
 ['DO', '02', 'Baoruco'],
 ['DO', '01', 'Azua'],
 ['DO', '36', 'San Jos\xc3\xa9 de Ocoa'],
 ['DO', '37', 'Santo Domingo'],
 ['DZ', '15', 'Tlemcen'],
 ['DZ', '14', 'Tizi Ouzou'],
 ['DZ', '56', 'Tissemsilt'],
 ['DZ', '55', 'Tipaza'],
 ['DZ', '54', 'Tindouf'],
 ['DZ', '13', 'Tiaret'],
 ['DZ', '33', 'T\xc3\xa9bessa'],
 ['DZ', '53', 'Tamanghasset'],
 ['DZ', '52', 'Souk Ahras'],
 ['DZ', '31', 'Skikda'],
 ['DZ', '30', 'Sidi Bel Abb\xc3\xa8s'],
 ['DZ', '12', 'S\xc3\xa9tif'],
 ['DZ', '10', 'Sa\xc3\xafda'],
 ['DZ', '51', 'Relizane'],
 ['DZ', '29', 'Oum el Bouaghi'],
 ['DZ', '50', 'Ouargla'],
 ['DZ', '09', 'Oran'],
 ['DZ',
  '49',
  'Naama \xd8\xa7\xd9\x84\xd9\x86\xd8\xb9\xd8\xa7\xd9\x85\xd8\xa9'],
 ['DZ', '27', 'M\xca\xbcsila'],
 ['DZ', '07', 'Mostaganem'],
 ['DZ', '48', 'Mila'],
 ['DZ', '06', 'M\xc3\xa9d\xc3\xa9a'],
 ['DZ', '26', 'Mascara'],
 ['DZ', '25', 'Laghouat'],
 ['DZ', '47', 'Khenchela'],
 ['DZ', '24', 'Jijel'],
 ['DZ', '46', 'Illizi'],
 ['DZ', '23', 'Guelma'],
 ['DZ', '45', 'Gharda\xc3\xafa'],
 ['DZ', '44', 'El Tarf'],
 ['DZ', '43', 'El Oued'],
 ['DZ', '42', 'El Bayadh'],
 ['DZ', '22', 'Djelfa'],
 ['DZ', '04', 'Constantine'],
 ['DZ', '41', 'Chlef'],
 ['DZ', '40', 'Boumerdes'],
 ['DZ', '21', 'Bouira'],
 ['DZ', '39', 'Bordj Bou Arr\xc3\xa9ridj'],
 ['DZ', '20', 'Blida'],
 ['DZ', '19', 'Biskra'],
 ['DZ', '18', 'Beja\xc3\xafa'],
 ['DZ', '38', 'B\xc3\xa9char'],
 ['DZ', '03', 'Batna'],
 ['DZ', '37', 'Annaba'],
 ['DZ', '01', 'Alger'],
 ['DZ', '36', 'A\xc3\xafn Temouchent'],
 ['DZ', '35', 'A\xc3\xafn Defla'],
 ['DZ', '34', 'Adrar'],
 ['EC', '20', 'Zamora-Chinchipe'],
 ['EC', '19', 'Tungurahua'],
 ['EC', '18', 'Pichincha'],
 ['EC', '17', 'Pastaza'],
 ['EC', '23', 'Napo'],
 ['EC', '15', 'Morona-Santiago'],
 ['EC', '14', 'Manab\xc3\xad'],
 ['EC', '13', 'Los R\xc3\xados'],
 ['EC', '12', 'Loja'],
 ['EC', '11', 'Imbabura'],
 ['EC', '10', 'Guayas'],
 ['EC', '01', 'Gal\xc3\xa1pagos'],
 ['EC', '09', 'Esmeraldas'],
 ['EC', '08', 'El Oro'],
 ['EC', '07', 'Cotopaxi'],
 ['EC', '06', 'Chimborazo'],
 ['EC', '05', 'Carchi'],
 ['EC', '04', 'Ca\xc3\xb1ar'],
 ['EC', '03', 'Bol\xc3\xadvar'],
 ['EC', '02', 'Azuay'],
 ['EC', '22', 'Sucumbios'],
 ['EC', '24', 'Orellana'],
 ['EC', '26', 'Santo Domingo de los Ts\xc3\xa1chilas'],
 ['EC', '25', 'Santa Elena'],
 ['EE', '21', 'V\xc3\xb5rumaa'],
 ['EE', '20', 'Viljandimaa'],
 ['EE', '19', 'Valgamaa'],
 ['EE', '18', 'Tartumaa'],
 ['EE', '14', 'Saaremaa'],
 ['EE', '13', 'Raplamaa'],
 ['EE', '12', 'P\xc3\xb5lvamaa'],
 ['EE', '11', 'P\xc3\xa4rnumaa'],
 ['EE', '08', 'L\xc3\xa4\xc3\xa4ne-Virumaa'],
 ['EE', '07', 'L\xc3\xa4\xc3\xa4nemaa'],
 ['EE', '05', 'J\xc3\xb5gevamaa'],
 ['EE', '04', 'J\xc3\xa4rvamaa'],
 ['EE', '03', 'Ida-Virumaa'],
 ['EE', '02', 'Hiiumaa'],
 ['EE', '01', 'Harjumaa'],
 ['EG', '24', 'S\xc5\xabh\xc4\x81j'],
 ['EG', '27', 'Sham\xc4\x81l S\xc4\xabn\xc4\x81\xca\xbc'],
 ['EG', '23', 'Qin\xc4\x81'],
 ['EG', '22', 'Ma\xc5\xa3r\xc5\xab\xe1\xb8\xa9'],
 ['EG', '21', 'Kafr ash Shaykh'],
 ['EG', '26', 'Jan\xc5\xabb S\xc4\xabn\xc4\x81\xca\xbc'],
 ['EG', '20', 'Dumy\xc4\x81\xc5\xa3'],
 ['EG', '19', 'B\xc5\xabr Sa\xe2\x80\x98\xc4\xabd'],
 ['EG', '18', 'Ban\xc4\xab Suwayf'],
 ['EG', '17', 'Asy\xc5\xab\xc5\xa3'],
 ['EG', '16', 'Asw\xc4\x81n'],
 ['EG', '15', 'As Suways'],
 ['EG', '14', 'Eastern Province'],
 ['EG', '13', 'Al W\xc4\x81d\xc4\xab al Jad\xc4\xabd'],
 ['EG', '12', 'Al Qaly\xc5\xabb\xc4\xabyah'],
 ['EG', '11', 'Al Q\xc4\x81hirah'],
 ['EG', '10', 'Al Miny\xc4\x81'],
 ['EG', '09', 'Al Min\xc5\xabf\xc4\xabyah'],
 ['EG', '08', 'Al J\xc4\xabzah'],
 ['EG', '07', 'Al Ism\xc4\x81\xe2\x80\x98\xc4\xabl\xc4\xabyah'],
 ['EG', '06', 'Alexandria'],
 ['EG', '05', 'Al Gharb\xc4\xabyah'],
 ['EG', '04', 'Al Fayy\xc5\xabm'],
 ['EG', '03', 'Al Bu\xe1\xb8\xa9ayrah'],
 ['EG', '02', 'Al Ba\xe1\xb8\xa9r al A\xe1\xb8\xa9mar'],
 ['EG', '01', 'Ad Daqahl\xc4\xabyah'],
 ['EG', '28', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at al Uq\xc5\x9fur'],
 ['EH', 'CE', 'Oued Ed-Dahab-Lagouira'],
 ['ER', '01', '\xc4\x80nseba'],
 ['ER', '02', 'Debub'],
 ['ER', '03', 'Debubaw\xc4\xab K\xca\xbceyih Bahr\xc4\xab'],
 ['ER', '04', 'Gash Barka'],
 ['ER', '05', 'Ma\xca\xbc\xc4\x81kel'],
 ['ER', '06', 'Sem\xc4\x93naw\xc4\xab K\xca\xbceyih Bahr\xc4\xab'],
 ['ES', '31', 'Murcia'],
 ['ES', 'CE', 'Ceuta'],
 ['ES', '07', 'Balearic Islands'],
 ['ES', '51', 'Andalusia'],
 ['ES', '53', 'Canary Islands'],
 ['ES', '54', 'Castille-La Mancha'],
 ['ES', '57', 'Extremadura'],
 ['ES', '60', 'Valencia'],
 ['ES', '34', 'Asturias'],
 ['ES', '32', 'Navarre'],
 ['ES', '29', 'Madrid'],
 ['ES', '27', 'La Rioja'],
 ['ES', '39', 'Cantabria'],
 ['ES', '52', 'Aragon'],
 ['ES', '55', 'Castille and Le\xc3\xb3n'],
 ['ES', '56', 'Catalonia'],
 ['ES', '58', 'Galicia'],
 ['ES', '59', 'Basque Country'],
 ['ES', 'ML', 'Melilla'],
 ['ET', '44', '\xc4\x80d\xc4\xabs \xc4\x80beba'],
 ['ET', '45', 'Afar Region'],
 ['ET', '46', 'Amhara Region'],
 ['ET', '47', 'Benishangul-Gumuz Region'],
 ['ET', '48', 'Dire Dawa Region'],
 ['ET', '49', 'Gambela'],
 ['ET', '50', 'Harari Region'],
 ['ET', '51', 'Oromiya Region'],
 ['ET', '52', 'Somali Region'],
 ['ET', '53', 'Tigray Region'],
 ['ET', '54', "Southern Nations, Nationalities, and People's Region"],
 ['FI', '08', 'Oulu'],
 ['FI', '06', 'Lapponia'],
 ['FI', '13', 'Province of Southern Finland'],
 ['FI', '14', 'Eastern Finland'],
 ['FI', '15', 'Western Finland'],
 ['FJ', '05', 'Western'],
 ['FJ', '03', 'Northern'],
 ['FJ', '01', 'Central'],
 ['FJ', '02', 'Eastern'],
 ['FJ', '04', 'Rotuma'],
 ['FM', '04', 'Yap'],
 ['FM', '02', 'Pohnpei'],
 ['FM', '01', 'Kosrae'],
 ['FM', '03', 'Chuuk'],
 ['FO', 'VG', 'V\xc3\xa1gar'],
 ['FO', 'SU', 'Su\xc3\xb0uroy'],
 ['FO', 'ST', 'Streymoy'],
 ['FO', 'SA', 'Sandoy'],
 ['FO', 'NO', 'Nor\xc3\xb0oyar'],
 ['FO', 'OS', 'Eysturoy'],
 ['FR', 'B9', 'Rh\xc3\xb4ne-Alpes'],
 ['FR', 'B8', "Provence-Alpes-C\xc3\xb4te d'Azur"],
 ['FR', 'B7', 'Poitou-Charentes'],
 ['FR', 'B6', 'Picardie'],
 ['FR', 'B5', 'Pays de la Loire'],
 ['FR', 'B4', 'Nord-Pas-de-Calais'],
 ['FR', 'B3', 'Midi-Pyr\xc3\xa9n\xc3\xa9es'],
 ['FR', 'B2', 'Lorraine'],
 ['FR', 'B1', 'Limousin'],
 ['FR', 'A9', 'Languedoc-Roussillon'],
 ['FR', 'A8', '\xc3\x8ele-de-France'],
 ['FR', 'A7', 'Haute-Normandie'],
 ['FR', 'A6', 'Franche-Comt\xc3\xa9'],
 ['FR', 'A5', 'Corsica'],
 ['FR', 'A4', 'Champagne-Ardenne'],
 ['FR', 'A3', 'Centre'],
 ['FR', 'A2', 'Bretagne'],
 ['FR', 'A1', 'Bourgogne'],
 ['FR', '99', 'Basse-Normandie'],
 ['FR', '98', 'Auvergne'],
 ['FR', '97', 'Aquitaine'],
 ['FR', 'C1', 'Alsace'],
 ['GA', '09', 'Woleu-Ntem'],
 ['GA', '08', 'Ogoou\xc3\xa9-Maritime'],
 ['GA', '07', 'Ogoou\xc3\xa9-Lolo'],
 ['GA', '06', 'Ogoou\xc3\xa9-Ivindo'],
 ['GA', '05', 'Nyanga'],
 ['GA', '04', 'Ngouni\xc3\xa9'],
 ['GA', '03', 'Moyen-Ogoou\xc3\xa9'],
 ['GA', '02', 'Haut-Ogoou\xc3\xa9'],
 ['GA', '01', 'Estuaire'],
 ['GB', 'WLS', 'Wales'],
 ['GB', 'SCT', 'Scotland'],
 ['GB', 'NIR', 'N Ireland'],
 ['GB', 'ENG', 'England'],
 ['GD', '06', 'Saint Patrick'],
 ['GD', '05', 'Saint Mark'],
 ['GD', '04', 'Saint John'],
 ['GD', '03', 'Saint George'],
 ['GD', '02', 'Saint David'],
 ['GD', '01', 'Saint Andrew'],
 ['GD', '10', 'Carriacou and Petite Martinique'],
 ['GE', '51', "T'bilisi"],
 ['GE', '04', 'Ajaria'],
 ['GE', '68', 'Kvemo Kartli'],
 ['GE', '67', 'Kakheti'],
 ['GE', '65', 'Guria'],
 ['GE', '66', 'Imereti'],
 ['GE', '73', 'Shida Kartli'],
 ['GE', '69', 'Mtskheta-Mtianeti'],
 ['GE', '70', 'Racha-Lechkhumi and Kvemo Svaneti'],
 ['GE', '71', 'Samegrelo and Zemo Svaneti'],
 ['GE', '72', 'Samtskhe-Javakheti'],
 ['GE', '02', 'Abkhazia'],
 ['GF', 'GF', 'Guyane'],
 ['GG', '00', ''],
 ['GH', '09', 'Western'],
 ['GH', '08', 'Volta'],
 ['GH', '11', 'Upper West'],
 ['GH', '10', 'Upper East'],
 ['GH', '06', 'Northern'],
 ['GH', '01', 'Greater Accra'],
 ['GH', '05', 'Eastern'],
 ['GH', '04', 'Central'],
 ['GH', '03', 'Brong-Ahafo'],
 ['GH', '02', 'Ashanti'],
 ['GL', '05', 'Qaasuitsup'],
 ['GL', '04', 'Kujalleq'],
 ['GL', '06', 'Qeqqata'],
 ['GL', '07', 'Sermersooq'],
 ['GM', '05', 'Western'],
 ['GM', '04', 'Upper River'],
 ['GM', '07', 'North Bank'],
 ['GM', '03', 'Central River'],
 ['GM', '02', 'Lower River'],
 ['GM', '01', 'Banjul'],
 ['GN', '04', 'Conakry'],
 ['GN', 'B', 'Boke Region'],
 ['GN', 'F', 'Faranah Region'],
 ['GN', 'K', 'Kankan Region'],
 ['GN', 'D', 'Kindia Region'],
 ['GN', 'L', 'Lab\xc3\xa9 Region'],
 ['GN', 'M', 'Mamou Region'],
 ['GN', 'N', 'Nzerekore Region'],
 ['GP', 'GP', 'Guadeloupe'],
 ['GQ', '03', 'Annob\xc3\xb3n'],
 ['GQ', '04', 'Bioko Norte'],
 ['GQ', '05', 'Bioko Sur'],
 ['GQ', '06', 'Centro Sur'],
 ['GQ', '07', 'Ki\xc3\xa9-Ntem'],
 ['GQ', '08', 'Litoral'],
 ['GQ', '09', 'Wele-Nzas'],
 ['GR', '736572', 'Mount Athos'],
 ['GR', 'ESYE31', 'Attica'],
 ['GR', 'ESYE24', 'Central Greece'],
 ['GR', 'ESYE12', 'Central Macedonia'],
 ['GR', 'ESYE43', 'Crete'],
 ['GR', 'ESYE11', 'East Macedonia and Thrace'],
 ['GR', 'ESYE21', 'Epirus'],
 ['GR', 'ESYE22', 'Ionian Islands'],
 ['GR', 'ESYE41', 'North Aegean'],
 ['GR', 'ESYE25', 'Peloponnese'],
 ['GR', 'ESYE42', 'South Aegean'],
 ['GR', 'ESYE14', 'Thessaly'],
 ['GR', 'ESYE23', 'West Greece'],
 ['GR', 'ESYE13', 'West Macedonia'],
 ['GT', '22', 'Zacapa'],
 ['GT', '21', 'Totonicap\xc3\xa1n'],
 ['GT', '20', 'Suchitep\xc3\xa9quez'],
 ['GT', '19', 'Solol\xc3\xa1'],
 ['GT', '18', 'Santa Rosa'],
 ['GT', '17', 'San Marcos'],
 ['GT', '16', 'Sacatep\xc3\xa9quez'],
 ['GT', '15', 'Retalhuleu'],
 ['GT', '14', 'Quich\xc3\xa9'],
 ['GT', '13', 'Quetzaltenango'],
 ['GT', '12', 'Pet\xc3\xa9n'],
 ['GT', '11', 'Jutiapa'],
 ['GT', '10', 'Jalapa'],
 ['GT', '09', 'Izabal'],
 ['GT', '08', 'Huehuetenango'],
 ['GT', '07', 'Guatemala'],
 ['GT', '06', 'Escuintla'],
 ['GT', '05', 'El Progreso'],
 ['GT', '04', 'Chiquimula'],
 ['GT', '03', 'Chimaltenango'],
 ['GT', '02', 'Baja Verapaz'],
 ['GT', '01', 'Alta Verapaz'],
 ['GU', 'PI', 'Piti Municipality'],
 ['GU', 'SR', 'Santa Rita Municipality'],
 ['GU', 'SJ', 'Sinajana Municipality'],
 ['GU', 'TF', 'Talofofo Municipality'],
 ['GU', 'TM', 'Tamuning-Tumon-Harmon Municipality'],
 ['GU', 'UM', 'Umatac Municipality'],
 ['GU', 'YG', 'Yigo Municipality'],
 ['GU', 'YN', 'Yona Municipality'],
 ['GU', 'ME', 'Merizo Municipality'],
 ['GU', 'MA', 'Mangilao Municipality'],
 ['GU', 'AH', 'Agana Heights Municipality'],
 ['GU', 'CP', 'Chalan Pago-Ordot Municipality'],
 ['GU', 'AS', 'Asan-Maina Municipality'],
 ['GU', 'AT', 'Agat Municipality'],
 ['GU', 'DD', 'Dededo Municipality'],
 ['GU', 'BA', 'Barrigada Municipality'],
 ['GU', 'AN', 'Hag\xc3\xa5t\xc3\xb1a Municipality'],
 ['GU', 'IN', 'Inarajan Municipality'],
 ['GU', 'MT', 'Mongmong-Toto-Maite Municipality'],
 ['GW', '07', 'Tombali'],
 ['GW', '02', 'Quinara'],
 ['GW', '04', 'Oio'],
 ['GW', '10', 'Gab\xc3\xba'],
 ['GW', '06', 'Cacheu'],
 ['GW', '05', 'Bolama and Bijagos'],
 ['GW', '11', 'Bissau Autonomous Region'],
 ['GW', '12', 'Biombo'],
 ['GW', '01', 'Bafat\xc3\xa1'],
 ['GY', '19', 'Upper Takutu-Upper Essequibo'],
 ['GY', '18', 'Upper Demerara-Berbice'],
 ['GY', '17', 'Potaro-Siparuni'],
 ['GY', '16', 'Pomeroon-Supenaam'],
 ['GY', '15', 'Mahaica-Berbice'],
 ['GY', '14', 'Essequibo Islands-West Demerara'],
 ['GY', '13', 'East Berbice-Corentyne'],
 ['GY', '12', 'Demerara-Mahaica'],
 ['GY', '11', 'Cuyuni-Mazaruni'],
 ['GY', '10', 'Barima-Waini'],
 ['HK', 'NYL', 'Yuen Long'],
 ['HK', 'NTW', 'Tsuen Wan'],
 ['HK', 'NTP', 'Tai Po'],
 ['HK', 'NSK', 'Sai Kung'],
 ['HK', 'NIS', 'Islands'],
 ['HK', 'HCW', 'Central and Western'],
 ['HK', 'HWC', 'Wan Chai'],
 ['HK', 'HEA', 'Eastern'],
 ['HK', 'HSO', 'Southern'],
 ['HK', 'KYT', 'Yau Tsim Mong'],
 ['HK', 'KSS', 'Sham Shui Po'],
 ['HK', 'KKC', 'Kowloon City'],
 ['HK', 'KWT', 'Wong Tai Sin'],
 ['HK', 'KKT', 'Kwon Tong'],
 ['HK', 'NKT', 'Kwai Tsing'],
 ['HK', 'NTM', 'Tuen Mun'],
 ['HK', 'NNO', 'North'],
 ['HK', 'NST', 'Sha Tin'],
 ['HM', '00', ''],
 ['HN', '18', 'Yoro'],
 ['HN', '17', 'Valle'],
 ['HN', '16', 'Santa B\xc3\xa1rbara'],
 ['HN', '15', 'Olancho'],
 ['HN', '14', 'Ocotepeque'],
 ['HN', '13', 'Lempira'],
 ['HN', '12', 'La Paz'],
 ['HN', '11', 'Bay Islands'],
 ['HN', '10', 'Intibuc\xc3\xa1'],
 ['HN', '09', 'Gracias a Dios'],
 ['HN', '08', 'Francisco Moraz\xc3\xa1n'],
 ['HN', '07', 'El Para\xc3\xadso'],
 ['HN', '06', 'Cort\xc3\xa9s'],
 ['HN', '05', 'Cop\xc3\xa1n'],
 ['HN', '04', 'Comayagua'],
 ['HN', '03', 'Col\xc3\xb3n'],
 ['HN', '02', 'Choluteca'],
 ['HN', '01', 'Atl\xc3\xa1ntida'],
 ['HR', '01', 'Bjelovarsko-Bilogorska'],
 ['HR', '02', 'Brodsko-Posavska'],
 ['HR', '03', 'Dubrova\xc4\x8dko-Neretvanska'],
 ['HR', '04', 'Istarska'],
 ['HR', '05', 'Karlova\xc4\x8dka'],
 ['HR', '06', 'Koprivni\xc4\x8dko-Kri\xc5\xbeeva\xc4\x8dka'],
 ['HR', '07', 'Krapinsko-Zagorska'],
 ['HR', '08', 'Li\xc4\x8dko-Senjska'],
 ['HR', '09', 'Me\xc4\x91imurska'],
 ['HR', '10', 'Osje\xc4\x8dko-Baranjska'],
 ['HR', '11', 'Po\xc5\xbee\xc5\xa1ko-Slavonska'],
 ['HR', '12', 'Primorsko-Goranska'],
 ['HR', '13', '\xc5\xa0ibensko-Kniniska'],
 ['HR', '14', 'Sisa\xc4\x8dko-Moslava\xc4\x8dka'],
 ['HR', '15', 'Splitsko-Dalmatinska'],
 ['HR', '16', 'Vara\xc5\xbedinska'],
 ['HR', '18', 'Vukovarsko-Srijemska'],
 ['HR', '19', 'Zadarska'],
 ['HR', '20', 'Zagreba\xc4\x8dka'],
 ['HR', '21', 'Grad Zagreb'],
 ['HR', '17', 'Viroviti\xc4\x8dk-Podravska'],
 ['HT', '13', 'Sud-Est'],
 ['HT', '12', 'Sud'],
 ['HT', '11', 'Ouest'],
 ['HT', '03', 'Nord-Ouest'],
 ['HT', '10', 'Nord-Est'],
 ['HT', '09', 'Nord'],
 ['HT', '14', 'Grand\xca\xbcAnse'],
 ['HT', '07', 'Centre'],
 ['HT', '06', 'Artibonite'],
 ['HT', '15', 'Nippes'],
 ['HU', '18', 'Szabolcs-Szatm\xc3\xa1r-Bereg'],
 ['HU', '20', 'J\xc3\xa1sz-Nagykun-Szolnok'],
 ['HU', '11', 'Heves'],
 ['HU', '10', 'Hajd\xc3\xba-Bihar'],
 ['HU', '06', 'Csongr\xc3\xa1d'],
 ['HU', '04', 'Borsod-Aba\xc3\xbaj-Zempl\xc3\xa9n'],
 ['HU', '03', 'B\xc3\xa9k\xc3\xa9s'],
 ['HU', '24', 'Zala'],
 ['HU', '23', 'Veszpr\xc3\xa9m'],
 ['HU', '22', 'Vas'],
 ['HU', '21', 'Tolna'],
 ['HU', '17', 'Somogy'],
 ['HU', '16', 'Pest'],
 ['HU', '14', 'N\xc3\xb3gr\xc3\xa1d'],
 ['HU', '12', 'Kom\xc3\xa1rom-Esztergom'],
 ['HU', '09', 'Gy\xc5\x91r-Moson-Sopron'],
 ['HU', '08', 'Fej\xc3\xa9r'],
 ['HU', '05', 'Budapest'],
 ['HU', '02', 'Baranya'],
 ['HU', '01', 'B\xc3\xa1cs-Kiskun'],
 ['ID', '26', 'North Sumatra'],
 ['ID', '01', 'Aceh'],
 ['ID', '10', 'Daerah Istimewa Yogyakarta'],
 ['ID', '32', 'South Sumatra'],
 ['ID', '24', 'West Sumatra'],
 ['ID', '31', 'North Sulawesi'],
 ['ID', '22', 'Sulawesi Tenggara'],
 ['ID', '21', 'Central Sulawesi'],
 ['ID', '38', 'South Sulawesi'],
 ['ID', '37', 'Riau'],
 ['ID', '18', 'East Nusa Tenggara'],
 ['ID', '17', 'Nusa Tenggara Barat'],
 ['ID', '28', 'Maluku'],
 ['ID', '15', 'Lampung'],
 ['ID', '14', 'East Kalimantan'],
 ['ID', '13', 'Kalimantan Tengah'],
 ['ID', '12', 'South Kalimantan'],
 ['ID', '11', 'West Kalimantan'],
 ['ID', '08', 'East Java'],
 ['ID', '07', 'Central Java'],
 ['ID', '30', 'West Java'],
 ['ID', '05', 'Jambi'],
 ['ID', '04', 'Jakarta Raya'],
 ['ID', '36', 'Papua'],
 ['ID', '03', 'Bengkulu'],
 ['ID', '02', 'Bali'],
 ['ID', '33', 'Banten'],
 ['ID', '34', 'Gorontalo'],
 ['ID', '35', 'Bangka-Belitung'],
 ['ID', '29', 'Maluku Utara'],
 ['ID', '39', 'West Papua'],
 ['ID', '41', 'Sulawesi Barat'],
 ['ID', '40', 'Riau Islands'],
 ['IE', 'C', 'Connaught'],
 ['IE', 'L', 'Leinster'],
 ['IE', 'M', 'Munster'],
 ['IE', 'U', 'Ulster'],
 ['IL', '06', 'Jerusalem District'],
 ['IL', '05', 'Tel Aviv'],
 ['IL', '04', 'Haifa District'],
 ['IL', '03', 'Northern District'],
 ['IL', '02', 'Central District'],
 ['IL', '01', 'Southern District'],
 ['IM', '00', ''],
 ['IN', '28', 'Bengal'],
 ['IN', '36', 'Uttar Pradesh'],
 ['IN', '26', 'Tripura'],
 ['IN', '25', 'Tamil N\xc4\x81du'],
 ['IN', '29', 'Sikkim'],
 ['IN', '24', 'Rajasthan'],
 ['IN', '23', 'Punjab'],
 ['IN', '22', 'Pondicherry'],
 ['IN', '21', 'Orissa'],
 ['IN', '20', 'N\xc4\x81g\xc4\x81land'],
 ['IN', '31', 'Mizoram'],
 ['IN', '18', 'Megh\xc4\x81laya'],
 ['IN', '17', 'Manipur'],
 ['IN', '16', 'Mah\xc4\x81r\xc4\x81shtra'],
 ['IN', '35', 'Madhya Pradesh'],
 ['IN', '14', 'Laccadives'],
 ['IN', '13', 'Kerala'],
 ['IN', '19', 'Karn\xc4\x81taka'],
 ['IN', '12', 'Kashmir'],
 ['IN', '11', 'Himachal Pradesh'],
 ['IN', '10', 'Haryana'],
 ['IN', '09', 'Gujar\xc4\x81t'],
 ['IN', '32', 'Daman and Diu'],
 ['IN', '33', 'Goa'],
 ['IN', '07', 'NCT'],
 ['IN', '06', 'D\xc4\x81dra and Nagar Haveli'],
 ['IN', '05', 'Chand\xc4\xabgarh'],
 ['IN', '34', 'Bih\xc4\x81r'],
 ['IN', '03', 'Assam'],
 ['IN', '30', 'Arun\xc4\x81chal Pradesh'],
 ['IN', '02', 'Andhra Pradesh'],
 ['IN', '01', 'Andaman and Nicobar Islands'],
 ['IN', '37', 'Chhattisgarh'],
 ['IN', '38', 'Jharkhand'],
 ['IN', '39', 'Uttarakhand'],
 ['IO', '00', ''],
 ['IQ', '02', 'Al Ba\xc5\x9frah'],
 ['IQ', '16', 'W\xc4\x81si\xc5\xa3'],
 ['IQ', '18', '\xc5\x9eal\xc4\x81\xe1\xb8\xa9 ad D\xc4\xabn'],
 ['IQ', '15', 'N\xc4\xabnaw\xc3\xa1'],
 ['IQ', '14', 'Maysan'],
 ['IQ', '12', 'Karbal\xc4\x81\xca\xbc'],
 ['IQ', '11', 'Arb\xc4\xabl'],
 ['IQ', '10', 'Diyala Province'],
 ['IQ', '09', 'Dhi Qar'],
 ['IQ', '08', 'Dah\xc5\xabk'],
 ['IQ', '07', 'Baghd\xc4\x81d'],
 ['IQ', '06', 'B\xc4\x81bil'],
 ['IQ', '13', 'At Ta\xca\xbcm\xc4\xabm'],
 ['IQ', '05', 'As Sulaym\xc4\x81n\xc4\xabyah'],
 ['IQ', '17', 'An Najaf'],
 ['IQ', '04', 'Al Q\xc4\x81dis\xc4\xabyah'],
 ['IQ', '03', 'Al Muthann\xc3\xa1'],
 ['IQ', '01', 'Anbar'],
 ['IR', '26', 'Tehr\xc4\x81n'],
 ['IR', '36', 'Zanjan'],
 ['IR', '40', 'Yazd'],
 ['IR', '25', 'Semn\xc4\x81n'],
 ['IR', '35', 'M\xc4\x81zandar\xc4\x81n'],
 ['IR', '34', 'Markazi'],
 ['IR', '23', 'Lorest\xc4\x81n'],
 ['IR', '16', 'Kordest\xc4\x81n'],
 ['IR', '05', 'Kohg\xc4\xabl\xc5\xabyeh va B\xc5\xabyer A\xe1\xb8\xa9mad'],
 ['IR', '15', 'Kh\xc5\xabzest\xc4\x81n'],
 ['IR', '13', 'Kerm\xc4\x81nsh\xc4\x81h'],
 ['IR', '29', 'Kerm\xc4\x81n'],
 ['IR', '10', '\xc4\xaal\xc4\x81m'],
 ['IR', '11', 'Hormozg\xc4\x81n'],
 ['IR', '09', 'Hamad\xc4\x81n'],
 ['IR', '08', 'G\xc4\xabl\xc4\x81n'],
 ['IR', '07', 'F\xc4\x81rs'],
 ['IR',
  '03',
  'Chah\xc4\x81r Ma\xe1\xb8\xa9\xc4\x81ll va Bakht\xc4\xab\xc4\x81r\xc4\xab'],
 ['IR', '22', 'Bushehr'],
 ['IR', '33', 'East Azarbaijan'],
 ['IR',
  '01',
  '\xc4\x80z\xcc\x84\xc4\x81rb\xc4\x81yj\xc4\x81n-e Gharb\xc4\xab'],
 ['IR', '32', 'Ardab\xc4\xabl'],
 ['IR', '28', 'E\xc5\x9ffah\xc4\x81n'],
 ['IR', '37', 'Golest\xc4\x81n'],
 ['IR', '38', 'Qazv\xc4\xabn'],
 ['IR', '39', 'Qom'],
 ['IR', '04', 'S\xc4\xabst\xc4\x81n va Bal\xc5\xabchest\xc4\x81n'],
 ['IR', '41', 'Khor\xc4\x81s\xc4\x81n-e Jon\xc5\xabb\xc4\xab'],
 ['IR', '42', 'Razavi Khorasan'],
 ['IR', '43', 'Khor\xc4\x81s\xc4\x81n-e Shom\xc4\x81l\xc4\xab'],
 ['IR', '44', 'Ost\xc4\x81n-e Alborz'],
 ['IS', '41', 'Northwest'],
 ['IS', '40', 'Northeast'],
 ['IS', '38', 'East'],
 ['IS', '42', 'South'],
 ['IS', '39', 'Capital Region'],
 ['IS', '43', 'Southern Peninsula'],
 ['IS', '45', 'West'],
 ['IS', '44', 'Westfjords'],
 ['IT', '15', 'Sicily'],
 ['IT', '14', 'Sardinia'],
 ['IT', '03', 'Calabria'],
 ['IT', '20', 'Veneto'],
 ['IT', '19', 'Aosta Valley'],
 ['IT', '18', 'Umbria'],
 ['IT', '17', 'Trentino-Alto Adige'],
 ['IT', '16', 'Tuscany'],
 ['IT', '13', 'Apulia'],
 ['IT', '12', 'Piedmont'],
 ['IT', '11', 'Molise'],
 ['IT', '10', 'The Marches'],
 ['IT', '09', 'Lombardy'],
 ['IT', '08', 'Liguria'],
 ['IT', '07', 'Latium'],
 ['IT', '06', 'Friuli Venezia Giulia'],
 ['IT', '05', 'Emilia-Romagna'],
 ['IT', '04', 'Campania'],
 ['IT', '02', 'Basilicate'],
 ['IT', '01', 'Abruzzo'],
 ['JE', '00', ''],
 ['JM', '16', 'Westmoreland'],
 ['JM', '15', 'Trelawny'],
 ['JM', '14', 'Saint Thomas'],
 ['JM', '13', 'Saint Mary'],
 ['JM', '12', 'Saint James'],
 ['JM', '11', 'St. Elizabeth'],
 ['JM', '10', 'Saint Catherine'],
 ['JM', '09', 'Saint Ann'],
 ['JM', '08', 'Saint Andrew'],
 ['JM', '07', 'Portland'],
 ['JM', '04', 'Manchester'],
 ['JM', '17', 'Kingston'],
 ['JM', '02', 'Hanover Parish'],
 ['JM', '01', 'Clarendon'],
 ['JO', '19', 'Ma\xe2\x80\x99an'],
 ['JO', '18', 'Irbid'],
 ['JO', '17', 'Zarqa'],
 ['JO', '12', 'Tafielah'],
 ['JO', '16', 'Amman'],
 ['JO', '15', 'Mafraq'],
 ['JO', '09', 'Karak'],
 ['JO', '02', 'Balqa'],
 ['JO', '20', 'Ajlun'],
 ['JO', '22', 'Jerash'],
 ['JO', '21', 'Aqaba'],
 ['JO', '23', 'Madaba'],
 ['JP', '46', 'Yamanashi'],
 ['JP', '45', 'Yamaguchi'],
 ['JP', '43', 'Wakayama'],
 ['JP', '42', 'Toyama'],
 ['JP', '41', 'Tottori'],
 ['JP', '40', 'T\xc5\x8dky\xc5\x8d'],
 ['JP', '39', 'Tokushima'],
 ['JP', '38', 'Tochigi'],
 ['JP', '37', 'Shizuoka'],
 ['JP', '36', 'Shimane'],
 ['JP', '35', 'Shiga'],
 ['JP', '34', 'Saitama'],
 ['JP', '33', 'Saga'],
 ['JP', '32', '\xc5\x8csaka'],
 ['JP', '47', 'Okinawa'],
 ['JP', '31', 'Okayama'],
 ['JP', '30', '\xc5\x8cita'],
 ['JP', '29', 'Niigata'],
 ['JP', '28', 'Nara'],
 ['JP', '27', 'Nagasaki'],
 ['JP', '26', 'Nagano'],
 ['JP', '25', 'Miyazaki'],
 ['JP', '23', 'Mie'],
 ['JP', '22', 'Ky\xc5\x8dto'],
 ['JP', '21', 'Kumamoto Prefecture'],
 ['JP', '20', 'K\xc5\x8dchi'],
 ['JP', '19', 'Kanagawa'],
 ['JP', '18', 'Kagoshima'],
 ['JP', '17', 'Kagawa'],
 ['JP', '15', 'Ishikawa'],
 ['JP', '13', 'Hy\xc5\x8dgo'],
 ['JP', '11', 'Hiroshima'],
 ['JP', '10', 'Gunma'],
 ['JP', '09', 'Gifu'],
 ['JP', '07', 'Fukuoka'],
 ['JP', '06', 'Fukui'],
 ['JP', '05', 'Ehime'],
 ['JP', '01', 'Aichi'],
 ['JP', '44', 'Yamagata'],
 ['JP', '24', 'Miyagi'],
 ['JP', '16', 'Iwate'],
 ['JP', '14', 'Ibaraki'],
 ['JP', '08', 'Fukushima'],
 ['JP', '04', 'Chiba'],
 ['JP', '02', 'Akita'],
 ['JP', '12', 'Hokkaid\xc5\x8d'],
 ['JP', '03', 'Aomori'],
 ['KE', '07', 'Nyanza'],
 ['KE', '05', 'Nairobi Area'],
 ['KE', '02', 'Coast Province'],
 ['KE', '03', 'Eastern'],
 ['KE', '01', 'Central'],
 ['KE', '09', 'Western'],
 ['KE', '08', 'Rift Valley'],
 ['KE', '06', 'North-Eastern'],
 ['KG', '08', 'Osh'],
 ['KG', '09', 'Batken'],
 ['KG', '06', 'Talas'],
 ['KG', '04', 'Naryn'],
 ['KG', '07', 'Ysyk-K\xc3\xb6l'],
 ['KG', '01', 'Bishkek'],
 ['KG', '03', 'Jalal-Abad'],
 ['KG', '02', 'Ch\xc3\xbcy'],
 ['KH', '12', 'Po\xc5\xadth\xc4\xads\xc4\x83t'],
 ['KH', '29', 'Kh\xc3\xa9tt B\xc4\x83td\xc3\xa2mb\xc3\xa2ng'],
 ['KH', '19', 'Tak\xc3\xaav'],
 ['KH', '18', 'Svay Ri\xc4\x95ng'],
 ['KH', '17', 'St\xc5\x93\xcc\x86ng Tr\xc3\xaang'],
 ['KH', '27', '\xc5\x8et\xc3\xa2r M\xc3\xa9anchey'],
 ['KH', '24', 'Kh\xc3\xa9tt Si\xc4\x95m R\xc3\xa9ab'],
 ['KH', '23', 'Kh\xc3\xaatt R\xc3\xb4t\xc3\xa2n\xc3\xb4kiri'],
 ['KH', '14', 'Prey V\xc3\xaang'],
 ['KH', '13', 'Pre\xc4\x83h V\xc4\xadh\xc3\xa9ar'],
 ['KH', '22', 'Kr\xc5\x8fng Phnum P\xc3\xa9nh'],
 ['KH', '30', 'Kh\xc3\xa9tt Pail\xc4\xadn'],
 ['KH', '10', 'M\xc3\xb4nd\xc3\xb3l Kiri'],
 ['KH', '09', 'Kr\xc3\xa2ch\xc3\xa9h'],
 ['KH', '26', 'Kh\xc3\xa9tt K\xc3\xaab'],
 ['KH', '08', 'Ka\xc3\xb4h K\xc5\x8fng'],
 ['KH', '07', 'K\xc3\xa2ndal'],
 ['KH', '21', 'Kh\xc3\xa9tt K\xc3\xa2mp\xc3\xb4t'],
 ['KH', '05', 'K\xc3\xa2mp\xc3\xb3ng Thum'],
 ['KH', '04', 'Kh\xc3\xa9tt K\xc3\xa2mp\xc3\xb3ng Sp\xc5\x93'],
 ['KH', '03', 'K\xc3\xa2mp\xc3\xb3ng Chhn\xc4\x83ng'],
 ['KH', '02', 'K\xc3\xa2mp\xc3\xb3ng Cham'],
 ['KH', '28', 'Kh\xc3\xa9tt Pre\xc4\x83h Seih\xc3\xa2n\xc5\xad'],
 ['KH', '25', 'Kh\xc3\xa9tt B\xc3\xa2nt\xc3\xa9ay M\xc3\xa9an Cho\xc4\x83y'],
 ['KI', '01', 'Gilbert Islands'],
 ['KI', '02', 'Line Islands'],
 ['KI', '03', 'Phoenix Islands'],
 ['KM', '03', 'Moh\xc3\xa9li'],
 ['KM', '02', 'Grande Comore'],
 ['KM', '01', 'Anjouan'],
 ['KN', '15', 'Trinity Palmetto Point'],
 ['KN', '13', 'Saint Thomas Middle Island'],
 ['KN', '12', 'Saint Thomas Lowland'],
 ['KN', '11', 'Saint Peter Basseterre'],
 ['KN', '10', 'Saint Paul Charlestown'],
 ['KN', '09', 'Saint Paul Capesterre'],
 ['KN', '08', 'Saint Mary Cayon'],
 ['KN', '07', 'Saint John Figtree'],
 ['KN', '06', 'Saint John Capesterre'],
 ['KN', '05', 'Saint James Windwa'],
 ['KN', '04', 'Saint George Gingerland'],
 ['KN', '03', 'Saint George Basseterre'],
 ['KN', '02', 'Saint Anne Sandy Point'],
 ['KN', '01', 'Christ Church Nichola Town'],
 ['KP', '12', "P'y\xc5\x8fngyang-si"],
 ['KP', '15', "P'y\xc5\x8fngan-namdo"],
 ['KP', '11', "P'y\xc5\x8fngan-bukto"],
 ['KP', '09', 'Gangwon'],
 ['KP', '06', 'Hwanghae-namdo'],
 ['KP', '07', 'Hwanghae-bukto'],
 ['KP', '03', 'Hamgy\xc5\x8fng-namdo'],
 ['KP', '13', 'Yanggang-do'],
 ['KP', '17', 'Hamgy\xc5\x8fng-bukto'],
 ['KP', '01', 'Chagang-do'],
 ['KP', '18', 'Najin S\xc5\x8fnbong-si'],
 ['KR', '21', 'Ulsan'],
 ['KR', '19', 'Daejeon'],
 ['KR', '15', 'Daegu'],
 ['KR', '11', 'Seoul'],
 ['KR', '10', 'Busan'],
 ['KR', '14', 'North Gyeongsang'],
 ['KR', '13', 'Gyeonggi'],
 ['KR', '18', 'Gwangju'],
 ['KR', '06', 'Gangwon'],
 ['KR', '12', 'Incheon'],
 ['KR', '17', 'South Chungcheong'],
 ['KR', '05', 'North Chungcheong'],
 ['KR', '16', 'South Jeolla'],
 ['KR', '03', 'North Jeolla'],
 ['KR', '01', 'Jeju'],
 ['KR', '20', 'South Gyeongsang'],
 ['KR', '22', 'KR.22'],
 ['KW', '08', '\xe1\xb8\xa8awall\xc4\xab'],
 ['KW', '02', 'Al \xe2\x80\x98\xc4\x80\xc5\x9fimah'],
 ['KW', '05', 'Al Jahr\xc4\x81\xca\xbc'],
 ['KW', '07', 'Al Farwaniyah'],
 ['KW', '04', 'Al A\xe1\xb8\xa9mad\xc4\xab'],
 ['KW',
  '09',
  'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at Mub\xc4\x81rak al Kab\xc4\xabr'],
 ['KZ', '07', 'Batys Qazaqstan'],
 ['KZ', '09', 'Mangghysta\xc5\xab'],
 ['KZ', '06', 'Atyra\xc5\xab'],
 ['KZ', '04', 'Aqt\xc3\xb6be'],
 ['KZ', '15', 'East Kazakhstan'],
 ['KZ', '03', 'Aqmola'],
 ['KZ', '16', 'Solt\xc3\xbcstik Qazaqstan'],
 ['KZ', '11', 'Pavlodar'],
 ['KZ', '14', 'Qyzylorda'],
 ['KZ', '13', 'Qostanay'],
 ['KZ', '12', 'Qaraghandy'],
 ['KZ', '17', 'Zhambyl'],
 ['KZ', '10', 'Ongt\xc3\xbcstik Qazaqstan'],
 ['KZ', '02', 'Almaty Qalasy'],
 ['KZ', '01', 'Almaty'],
 ['KZ', '08', 'Bayqongyr Qalasy'],
 ['KZ', '05', 'Astana Qalasy'],
 ['LA', '14', 'Xiangkhoang'],
 ['LA', '13', 'Xiagnabouli'],
 ['LA', '27', 'Khou\xc3\xa8ng Viangchan'],
 ['LA', '20', 'Savannahkh\xc3\xa9t'],
 ['LA', '19', 'Salavan'],
 ['LA', '18', 'Ph\xc3\xb4ngsali'],
 ['LA', '07', 'Oud\xc3\xb4mxai'],
 ['LA', '17', 'Louangphabang'],
 ['LA', '16', 'Loungnamtha'],
 ['LA', '15', 'Khammouan'],
 ['LA', '03', 'Houaphan'],
 ['LA', '02', 'Champasak'],
 ['LA', '01', 'Attapu'],
 ['LA', '26', 'X\xc3\xa9kong'],
 ['LA', '22', 'Bok\xc3\xa8o'],
 ['LA', '23', 'Bolikhamxai'],
 ['LA', '24', 'Viangchan'],
 ['LB', '05', 'Mont-Liban'],
 ['LB', '04', 'Beyrouth'],
 ['LB', '09', 'Liban-Nord'],
 ['LB', '06', 'Liban-Sud'],
 ['LB', '08', 'B\xc3\xa9qaa'],
 ['LB', '07', 'Nabat\xc3\xaey\xc3\xa9'],
 ['LB', '10', 'Aakk\xc3\xa2r'],
 ['LB', '11', 'Baalbek-Hermel'],
 ['LC', '10', 'Vieux-Fort'],
 ['LC', '09', 'Soufri\xc3\xa8re'],
 ['LC', '11', 'Praslin'],
 ['LC', '08', 'Micoud'],
 ['LC', '07', 'Laborie'],
 ['LC', '06', 'Gros-Islet'],
 ['LC', '05', 'Dennery'],
 ['LC', '02', 'Dauphin'],
 ['LC', '04', 'Choiseul'],
 ['LC', '03', 'Castries'],
 ['LC', '01', 'Anse-la-Raye'],
 ['LI', '11', 'Vaduz'],
 ['LI', '10', 'Triesenberg'],
 ['LI', '09', 'Triesen'],
 ['LI', '08', 'Schellenberg'],
 ['LI', '07', 'Schaan'],
 ['LI', '06', 'Ruggell'],
 ['LI', '05', 'Planken'],
 ['LI', '04', 'Mauren'],
 ['LI', '03', 'Gamprin'],
 ['LI', '02', 'Eschen'],
 ['LI', '01', 'Balzers'],
 ['LK', '36', 'Western'],
 ['LK', '35', 'Uva'],
 ['LK', '34', 'Southern'],
 ['LK', '33', 'Sabaragamuwa'],
 ['LK', '32', 'North Western'],
 ['LK', '30', 'North Central'],
 ['LK', '29', 'Central'],
 ['LK', '38', 'Northern Province'],
 ['LK', '37', 'Eastern Province'],
 ['LR', '10', 'Sinoe'],
 ['LR', '09', 'Nimba'],
 ['LR', '14', 'Montserrado'],
 ['LR', '13', 'Maryland'],
 ['LR', '20', 'Lofa'],
 ['LR', '19', 'Grand Gedeh'],
 ['LR', '12', 'Grand Cape Mount'],
 ['LR', '11', 'Grand Bassa'],
 ['LR', '01', 'Bong'],
 ['LR', '15', 'Bomi'],
 ['LR', '16', 'Grand Kru'],
 ['LR', '17', 'Margibi'],
 ['LR', '18', 'River Cess'],
 ['LR', '21', 'Gbarpolu'],
 ['LR', '22', 'River Gee'],
 ['LS', '19', 'Thaba-Tseka'],
 ['LS', '18', 'Quthing'],
 ['LS', '17', 'Qacha\xca\xbcs Nek'],
 ['LS', '16', 'Mokhotlong'],
 ['LS', '15', 'Mohale\xca\xbcs Hoek'],
 ['LS', '14', 'Maseru'],
 ['LS', '13', 'Mafeteng'],
 ['LS', '12', 'Leribe'],
 ['LS', '11', 'Butha-Buthe'],
 ['LS', '10', 'Berea'],
 ['LT', '56', 'Alytaus Apskritis'],
 ['LT', '57', 'Kauno Apskritis'],
 ['LT', '58', 'Klaip\xc4\x97dos Apskritis'],
 ['LT', '59', 'Marijampol\xc4\x97s Apskritis'],
 ['LT', '60', 'Panev\xc4\x97\xc5\xbeio Apskritis'],
 ['LT', '61', '\xc5\xa0iauli\xc5\xb3 Apskritis'],
 ['LT', '62', 'Taurag\xc4\x97s Apskritis'],
 ['LT', '63', 'Tel\xc5\xa1i\xc5\xb3 Apskritis'],
 ['LT', '64', 'Utenos Apskritis'],
 ['LT', '65', 'Vilniaus Apskritis'],
 ['LU', '03', 'Luxembourg'],
 ['LU', '02', 'Grevenmacher'],
 ['LU', '01', 'Diekirch'],
 ['LV', '33', 'Ventspils Rajons'],
 ['LV', '32', 'Ventspils'],
 ['LV', '31', 'Valmieras Rajons'],
 ['LV', '30', 'Valkas Rajons'],
 ['LV', '29', 'Tukuma Rajons'],
 ['LV', '28', 'Talsu Rajons'],
 ['LV', '27', 'Saldus Rajons'],
 ['LV', '25', 'R\xc4\xabga'],
 ['LV', '24', 'R\xc4\x93zeknes Rajons'],
 ['LV', '23', 'R\xc4\x93zekne'],
 ['LV', '22', 'Prei\xc4\xbcu Rajons'],
 ['LV', '21', 'Ogres Rajons'],
 ['LV', '20', 'Madonas Rajons'],
 ['LV', '19', 'Ludzas Rajons'],
 ['LV', '18', 'Limba\xc5\xbeu Rajons'],
 ['LV', '16', 'Liep\xc4\x81ja'],
 ['LV', '15', 'Kuld\xc4\xabgas Rajons'],
 ['LV', '14', 'Kr\xc4\x81slavas Rajons'],
 ['LV', '13', 'J\xc5\xabrmala'],
 ['LV', '12', 'Jelgavas Rajons'],
 ['LV', '11', 'Jelgava'],
 ['LV', '10', 'J\xc4\x93kabpils Rajons'],
 ['LV', '09', 'Gulbenes Rajons'],
 ['LV', '08', 'Dobeles Rajons'],
 ['LV', '07', 'Daugavpils municipality'],
 ['LV', '06', 'Daugavpils'],
 ['LV', '05', 'C\xc4\x93su Rajons'],
 ['LV', '04', 'Bauskas Rajons'],
 ['LV', '03', 'Balvu Rajons'],
 ['LV', '02', 'Al\xc5\xabksnes Rajons'],
 ['LV', '01', 'Aizkraukles Rajons'],
 ['LV', '60', 'Dundagas Novads'],
 ['LV', '40', 'Alsungas Novads'],
 ['LV', 'A5', 'P\xc4\x81vilostas Novads'],
 ['LV', '99', 'N\xc4\xabcas Novads'],
 ['LV', 'B6', 'Rucavas Novads'],
 ['LV', '65', 'Grobi\xc5\x86as Novads'],
 ['LV', '61', 'Durbes Novads'],
 ['LV', '37', 'Aizputes Novads'],
 ['LV', 'A8', 'Priekules Novads'],
 ['LV', 'D7', 'Vai\xc5\x86odes Novads'],
 ['LV', 'C9', 'Skrundas Novads'],
 ['LV', '51', 'Broc\xc4\x93nu Novads'],
 ['LV', 'B4', 'Rojas Novads'],
 ['LV', '77', 'Kandavas Novads'],
 ['LV', '44', 'Auces Novads'],
 ['LV', '73', 'Jaunpils Novads'],
 ['LV', '62', 'Engures Novads'],
 ['LV', 'D5', 'T\xc4\x93rvetes Novads'],
 ['LV', 'A3', 'Ozolnieku Novads'],
 ['LV', 'B9', 'Rund\xc4\x81les Novads'],
 ['LV', '45', 'Bab\xc4\xabtes Novads'],
 ['LV', '95', 'M\xc4\x81rupes Novads'],
 ['LV', 'A2', 'Olaines Novads'],
 ['LV', '67', 'Iecavas Novads'],
 ['LV', '80', '\xc4\xb6ekavas Novads'],
 ['LV', 'C3', 'Salaspils Novads'],
 ['LV', '46', 'Baldones Novads'],
 ['LV', 'D2', 'Stopi\xc5\x86u Novads'],
 ['LV', '53', 'Carnikavas Novads'],
 ['LV', '34', '\xc4\x80da\xc5\xbeu Novads'],
 ['LV', '64', 'Garkalnes Novads'],
 ['LV', 'E4', 'Vecumnieku Novads'],
 ['LV', '79', '\xc4\xb6eguma Novads'],
 ['LV', '87', 'Lielv\xc4\x81rdes Novads'],
 ['LV', 'C8', 'Skr\xc4\xabveru Novads'],
 ['LV', '71', 'Jaunjelgavas Novads'],
 ['LV', '98', 'Neretas Novads'],
 ['LV', 'E6', 'Vies\xc4\xabtes Novads'],
 ['LV', 'C2', 'Salas Novads'],
 ['LV', '74', 'J\xc4\x93kabpils'],
 ['LV', '38', 'Akn\xc4\xabstes Novads'],
 ['LV', '69', 'Il\xc5\xabkstes Novads'],
 ['LV', 'E2', 'V\xc4\x81rkavas Novads'],
 ['LV', '90', 'L\xc4\xabv\xc4\x81nu Novads'],
 ['LV', 'E1', 'Varak\xc4\xbc\xc4\x81nu Novads'],
 ['LV', 'E8', 'Vi\xc4\xbc\xc4\x81nu Novads'],
 ['LV', 'B3', 'Riebi\xc5\x86u Novads'],
 ['LV', '35', 'Aglonas Novads'],
 ['LV', '56', 'Ciblas Novads'],
 ['LV', 'E9', 'Zilupes Novads'],
 ['LV', 'E7', 'Vi\xc4\xbcakas Novads'],
 ['LV', '47', 'Baltinavas Novads'],
 ['LV', '57', 'Dagdas Novads'],
 ['LV', '78', 'K\xc4\x81rsavas Novads'],
 ['LV', 'B7', 'Rug\xc4\x81ju Novads'],
 ['LV', '55', 'Cesvaines Novads'],
 ['LV', '91', 'Lub\xc4\x81nas Novads'],
 ['LV', '85', 'Krustpils Novads'],
 ['LV', 'A6', 'P\xc4\xbcavi\xc5\x86u Novads'],
 ['LV', '82', 'Kokneses Novads'],
 ['LV', '68', 'Ik\xc5\xa1\xc4\xb7iles Novads'],
 ['LV', 'B5', 'Ropa\xc5\xbeu Novads'],
 ['LV', '70', 'In\xc4\x8dukalna Novads'],
 ['LV', '84', 'Krimuldas Novads'],
 ['LV', 'C7', 'Siguldas Novads'],
 ['LV', '88', 'L\xc4\xabgatnes Novads'],
 ['LV', '94', 'M\xc4\x81lpils Novads'],
 ['LV', 'C6', 'S\xc4\x93jas Novads'],
 ['LV', 'C5', 'Saulkrastu Novads'],
 ['LV', 'C1', 'Salacgr\xc4\xabvas Novads'],
 ['LV', '39', 'Alojas Novads'],
 ['LV', '97', 'Nauk\xc5\xa1\xc4\x93nu Novads'],
 ['LV', 'B8', 'R\xc5\xabjienas Novads'],
 ['LV', '96', 'Mazsalacas Novads'],
 ['LV', '52', 'Burtnieku Novads'],
 ['LV', 'A4', 'P\xc4\x81rgaujas Novads'],
 ['LV', '81', 'Koc\xc4\x93nu Novads'],
 ['LV', '42', 'Amatas Novads'],
 ['LV', 'A9', 'Prieku\xc4\xbcu Novads'],
 ['LV', 'B1', 'Raunas Novads'],
 ['LV', 'D3', 'Stren\xc4\x8du Novads'],
 ['LV', '50', 'Bever\xc4\xabnas Novads'],
 ['LV', 'D1', 'Smiltenes Novads'],
 ['LV', '72', 'Jaunpiebalgas Novads'],
 ['LV', '63', '\xc4\x92rg\xc4\xbcu Novads'],
 ['LV', 'E3', 'Vecpiebalgas Novads'],
 ['LV', '43', 'Apes Novads'],
 ['LV', 'F1', 'M\xc4\x93rsraga Novads'],
 ['LY', '70', 'Darnah'],
 ['LY', '69', 'Bangh\xc4\x81z\xc4\xab'],
 ['LY', '66', 'Al Marj'],
 ['LY', '65', 'Al Kufrah'],
 ['LY', '63', 'Al Jabal al Akh\xe1\xb8\x91ar'],
 ['LY', '77', '\xc5\xa2ar\xc4\x81bulus'],
 ['LY', '76', 'Surt'],
 ['LY', '75', 'Sabh\xc4\x81'],
 ['LY', '74', 'N\xc4\x81l\xc5\xabt'],
 ['LY', '73', 'Murzuq'],
 ['LY', '72', 'Mi\xc5\x9fr\xc4\x81tah'],
 ['LY', '71', 'Gh\xc4\x81t'],
 ['LY', '68', 'Az Z\xc4\x81wiyah'],
 ['LY', '78', 'Ash Sh\xc4\x81\xc5\xa3i\xca\xbc'],
 ['LY', '64', 'Al Jufrah'],
 ['LY', '67', 'An Nuq\xc4\x81\xc5\xa3 al Khams'],
 ['LY', '79', 'Sha\xe2\x80\x98b\xc4\xabyat al Bu\xc5\xa3n\xc4\x81n'],
 ['LY', '80', 'Sha\xe2\x80\x98b\xc4\xabyat al Jabal al Gharb\xc4\xab'],
 ['LY', '81', 'Sha\xe2\x80\x98b\xc4\xabyat al Jaf\xc4\x81rah'],
 ['LY', '82', 'Sha\xe2\x80\x98b\xc4\xabyat al Marqab'],
 ['LY', '83', 'Sha\xe2\x80\x98b\xc4\xabyat al W\xc4\x81\xe1\xb8\xa9\xc4\x81t'],
 ['LY',
  '84',
  'Sha\xe2\x80\x98b\xc4\xabyat W\xc4\x81d\xc4\xab al \xe1\xb8\xa8ay\xc4\x81t'],
 ['MA', '49', 'Rabat-Sal\xc3\xa9-Zemmour-Za\xc3\xabr'],
 ['MA', '48', 'Mekn\xc3\xa8s-Tafilalet'],
 ['MA', '47', 'Marrakech-Tensift-Al Haouz'],
 ['MA', '46', 'F\xc3\xa8s-Boulemane'],
 ['MA', '45', 'Grand Casablanca'],
 ['MA', '50', 'Chaouia-Ouardigha'],
 ['MA', '51', 'Doukkala-Abda'],
 ['MA', '52', 'Gharb-Chrarda-Beni Hssen'],
 ['MA', '53', 'Guelmim-Es Smara'],
 ['MA', '54', 'Oriental Region'],
 ['MA', '55', 'Souss-Massa-Dr\xc3\xa2a'],
 ['MA', '56', 'Tadla-Azilal'],
 ['MA', '57', 'Tanger-T\xc3\xa9touan'],
 ['MA', '58', 'Taza-Al Hoceima-Taounate'],
 ['MA', '59', 'La\xc3\xa2youne-Boujdour-Sakia El Hamra'],
 ['MA', 'EH', 'Oued ed Dahab-Lagouira'],
 ['MC', '00', ''],
 ['MD', '73', 'Raionul Edine\xc5\xa3'],
 ['MD', '92', 'Raionul Ungheni'],
 ['MD', '91', 'Raionul Telene\xc5\x9fti'],
 ['MD', '90', 'Raionul Taraclia'],
 ['MD', '88', '\xc5\x9etefan-Vod\xc4\x83'],
 ['MD', '89', 'Raionul Str\xc4\x83\xc5\x9feni'],
 ['MD', '87', 'Raionul Soroca'],
 ['MD', '84', 'Raionul R\xc3\xae\xc5\x9fcani'],
 ['MD', '83', 'Raionul Rezina'],
 ['MD', '82', 'Raionul Orhei'],
 ['MD', '81', 'Raionul Ocni\xc5\xa3a'],
 ['MD', '59', 'Raionul Anenii Noi'],
 ['MD', '80', 'Raionul Nisporeni'],
 ['MD', '79', 'Raionul Leova'],
 ['MD', '85', 'Raionul S\xc3\xaengerei'],
 ['MD', '69', 'Raionul Criuleni'],
 ['MD', '78', 'Raionul Ialoveni'],
 ['MD', '57', 'Chi\xc5\x9fin\xc4\x83u'],
 ['MD', '67', 'C\xc4\x83u\xc5\x9feni'],
 ['MD', '65', 'Raionul Cantemir'],
 ['MD', '66', 'C\xc4\x83l\xc4\x83ra\xc5\x9fi'],
 ['MD', '64', 'Raionul Cahul'],
 ['MD', '76', 'Raionul Glodeni'],
 ['MD', '75', 'Raionul Flore\xc5\x9fti'],
 ['MD', '74', 'Raionul F\xc4\x83le\xc5\x9fti'],
 ['MD', '72', 'Dub\xc4\x83sari'],
 ['MD', '71', 'Raionul Drochia'],
 ['MD', '70', 'Raionul Dondu\xc5\x9feni'],
 ['MD', '68', 'Raionul Cimi\xc5\x9flia'],
 ['MD', '63', 'Raionul Briceni'],
 ['MD', '61', 'Raionul Basarabeasca'],
 ['MD', '77', 'Raionul H\xc3\xaence\xc5\x9fti'],
 ['MD', '86', 'Raionul \xc5\x9eold\xc4\x83ne\xc5\x9fti'],
 ['MD', '58', 'St\xc3\xaenga Nistrului'],
 ['MD', '51', 'G\xc4\x83g\xc4\x83uzia'],
 ['MD', '62', 'Bender'],
 ['MD', '60', 'B\xc4\x83l\xc5\xa3i'],
 ['ME', '17', 'Op\xc5\xa1tina Ro\xc5\xbeaje'],
 ['ME', '21', 'Op\xc5\xa1tina \xc5\xbdabljak'],
 ['ME', '20', 'Op\xc5\xa1tina Ulcinj'],
 ['ME', '19', 'Op\xc5\xa1tina Tivat'],
 ['ME', '16', 'Op\xc5\xa1tina Podgorica'],
 ['ME', '18', 'Op\xc5\xa1tina \xc5\xa0avnik'],
 ['ME', '15', 'Op\xc5\xa1tina Plu\xc5\xbeine'],
 ['ME', '14', 'Op\xc5\xa1tina Pljevlja'],
 ['ME', '13', 'Op\xc5\xa1tina Plav'],
 ['ME', '12', 'Op\xc5\xa1tina Nik\xc5\xa1i\xc4\x87'],
 ['ME', '11', 'Op\xc5\xa1tina Mojkovac'],
 ['ME', '10', 'Op\xc5\xa1tina Kotor'],
 ['ME', '09', 'Op\xc5\xa1tina Kola\xc5\xa1in'],
 ['ME', '03', 'Op\xc5\xa1tina Berane'],
 ['ME', '08', 'Op\xc5\xa1tina Herceg Novi'],
 ['ME', '07', 'Op\xc5\xa1tina Danilovgrad'],
 ['ME', '06', 'Op\xc5\xa1tina Cetinje'],
 ['ME', '05', 'Op\xc5\xa1tina Budva'],
 ['ME', '04', 'Op\xc5\xa1tina Bijelo Polje'],
 ['ME', '02', 'Op\xc5\xa1tina Bar'],
 ['ME', '01', 'Op\xc5\xa1tina Andrijevica'],
 ['MG', '7670842', 'Diana'],
 ['MG', '7670846', 'Sava'],
 ['MG', '7670847', 'Sofia'],
 ['MG', '7670848', 'Analanjirofo'],
 ['MG', '7670849', 'Boeny'],
 ['MG', '7670850', 'Betsiboka'],
 ['MG', '7670851', 'Alaotra Mangoro'],
 ['MG', '7670852', 'Melaky'],
 ['MG', '7670853', 'Bongolava'],
 ['MG', '7670854', 'Vakinankaratra'],
 ['MG', '7670855', 'Itasy'],
 ['MG', '7670856', 'Analamanga'],
 ['MG', '7670857', 'Atsinanana'],
 ['MG', '7670902', 'Menabe'],
 ['MG', '7670904', "Amoron'i Mania"],
 ['MG', '7670905', 'Upper Matsiatra'],
 ['MG', '7670906', 'Vatovavy Fitovinany'],
 ['MG', '7670907', 'Ihorombe'],
 ['MG', '7670908', 'Atsimo-Atsinanana Region'],
 ['MG', '7670910', 'Anosy'],
 ['MG', '7670911', 'Androy'],
 ['MG', '7670913', 'Atsimo-Andrefana'],
 ['MH', '007', 'Ailinginae Atoll'],
 ['MH', '010', 'Ailinglaplap Atoll'],
 ['MH', '030', 'Ailuk Atoll'],
 ['MH', '040', 'Arno Atoll'],
 ['MH', '050', 'Aur Atoll'],
 ['MH', '060', 'Bikar Atoll'],
 ['MH', '070', 'Bikini Atoll'],
 ['MH', '080', 'Ebon Atoll'],
 ['MH', '090', 'Enewetak Atoll'],
 ['MH', '100', 'Erikub Atoll'],
 ['MH', '120', 'Jaluit Atoll'],
 ['MH', '150', 'Kwajalein Atoll'],
 ['MH', '160', 'Lae Atoll'],
 ['MH', '180', 'Likiep Atoll'],
 ['MH', '190', 'Majuro Atoll'],
 ['MH', '300', 'Maloelap Atoll'],
 ['MH', '320', 'Mili Atoll'],
 ['MH', '330', 'Namdrik Atoll'],
 ['MH', '340', 'Namu Atoll'],
 ['MH', '350', 'Rongelap Atoll'],
 ['MH', '360', 'Rongrik Atoll'],
 ['MH', '385', 'Taka Atoll'],
 ['MH', '073', 'Bokak Atoll'],
 ['MH', '390', 'Ujae Atoll'],
 ['MH', '400', 'Ujelang'],
 ['MH', '410', 'Utrik Atoll'],
 ['MH', '420', 'Wotho Atoll'],
 ['MH', '430', 'Wotje Atoll'],
 ['MH', '110', 'Jabat Island'],
 ['MH', '130', 'Jemo Island'],
 ['MH', '140', 'Kili Island'],
 ['MH', '170', 'Lib Island'],
 ['MH', '310', 'Mejit Island'],
 ['MK', 'E9', 'Valandovo'],
 ['MK', '86', 'Resen'],
 ['MK', '51', 'Kratovo'],
 ['MK', '78', 'Peh\xc4\x8devo'],
 ['MK', '72', 'Novo Selo'],
 ['MK', '11', 'Bosilovo'],
 ['MK', 'A9', 'Vasilevo'],
 ['MK', 'E5', 'Dojran'],
 ['MK', '08', 'Bogdanci'],
 ['MK', '47', 'Kon\xc4\x8de'],
 ['MK', '62', 'Makedonska Kamenica'],
 ['MK', 'C6', 'Zrnovci'],
 ['MK', '40', 'Karbinci'],
 ['MK', '25', 'Demir Kapija'],
 ['MK', '87', 'Rosoman'],
 ['MK', '35', 'Gradsko'],
 ['MK', '60', 'Lozovo'],
 ['MK', '19', '\xc4\x8ce\xc5\xa1inovo'],
 ['MK', 'E1', 'Novaci'],
 ['MK', '04', 'Berovo'],
 ['MK', '06', 'Bitola'],
 ['MK', 'D9', 'Mogila'],
 ['MK', '01', 'Ara\xc4\x8dinovo'],
 ['MK', 'C7', 'Bogovinje'],
 ['MK', '12', 'Brvenica'],
 ['MK', 'C8', '\xc4\x8cair'],
 ['MK', 'C9', '\xc4\x8ca\xc5\xa1ka'],
 ['MK', 'D1', 'Centar'],
 ['MK', '18', 'Centar \xc5\xbdupa'],
 ['MK', '20', '\xc4\x8cu\xc4\x8der-Sandevo'],
 ['MK', 'D2', 'Debar'],
 ['MK', '22', 'Del\xc4\x8devo'],
 ['MK', 'D3', 'Demir Hisar'],
 ['MK', '28', 'Dolneni'],
 ['MK', '29', 'Opstina Gjorce Petrov'],
 ['MK', '30', 'Drugovo'],
 ['MK', '32', 'Gazi Baba'],
 ['MK', '33', 'Gevgelija'],
 ['MK', 'D4', 'Gostivar'],
 ['MK', '36', 'Ilinden'],
 ['MK', 'D5', 'Jegunovce'],
 ['MK', '41', 'Karpo\xc5\xa1'],
 ['MK', 'D6', 'Kavadarci'],
 ['MK', '43', 'Ki\xc4\x8devo'],
 ['MK', '44', 'Kisela Voda'],
 ['MK', '46', 'Ko\xc4\x8dani'],
 ['MK', '52', 'Kriva Palanka'],
 ['MK', '53', 'Krivoga\xc5\xa1tani'],
 ['MK', '54', 'Kru\xc5\xa1evo'],
 ['MK', 'D7', 'Kumanovo'],
 ['MK', '59', 'Opstina Lipkovo'],
 ['MK', 'D8', 'Makedonski Brod'],
 ['MK', '69', 'Negotino'],
 ['MK', 'E2', 'Ohrid'],
 ['MK', '77', 'Oslomej'],
 ['MK', '79', 'Petrovec'],
 ['MK', '80', 'Plasnica'],
 ['MK', 'E3', 'Prilep'],
 ['MK', '83', 'Probi\xc5\xa1tip'],
 ['MK', '84', 'Radovi\xc5\xa1'],
 ['MK', '85', 'Opstina Rankovce'],
 ['MK', 'E4', 'Op\xc5\xa1tina Rostu\xc5\xa1a'],
 ['MK', '90', 'Saraj'],
 ['MK', '92', 'Sopi\xc5\xa1te'],
 ['MK', '97', 'Staro Nagori\xc4\x8dane'],
 ['MK', '98', '\xc5\xa0tip'],
 ['MK', 'E6', 'Struga'],
 ['MK', 'E7', 'Strumica'],
 ['MK', 'A2', 'Studeni\xc4\x8dani'],
 ['MK', 'A3', '\xc5\xa0uto Orizari'],
 ['MK', 'A4', 'Sveti Nikole'],
 ['MK', 'A5', 'Tearce'],
 ['MK', 'E8', 'Tetovo'],
 ['MK', 'F1', 'Veles'],
 ['MK', 'B3', 'Vev\xc4\x8dani'],
 ['MK', 'B4', 'Vinica'],
 ['MK', 'B6', 'Vrane\xc5\xa1tica'],
 ['MK', 'B7', 'Vrap\xc4\x8di\xc5\xa1te'],
 ['MK', 'C1', 'Zajas'],
 ['MK', 'C2', 'Zelenikovo'],
 ['MK', 'C3', '\xc5\xbdelino'],
 ['MK', 'F3', 'Op\xc5\xa1tina Aerodrom'],
 ['MK', 'F4', 'Op\xc5\xa1tina Butel'],
 ['MK', 'F5', 'Op\xc5\xa1tina Debarca'],
 ['ML', '08', 'Tombouctou Region'],
 ['ML', '06', 'Sikasso Region'],
 ['ML', '05', 'S\xc3\xa9gou Region'],
 ['ML', '04', 'Mopti Region'],
 ['ML', '07', 'Koulikoro Region'],
 ['ML', '03', 'Kayes Region'],
 ['ML', '09', 'Gao Region'],
 ['ML', '01', 'Bamako'],
 ['ML', '10', 'Kidal Region'],
 ['MM', '12', 'Tanintharyi'],
 ['MM', '11', 'Shan'],
 ['MM', '10', 'Sagain'],
 ['MM', '17', 'Yangon'],
 ['MM', '01', 'Rakhine'],
 ['MM', '16', 'Bago'],
 ['MM', '13', 'Mon'],
 ['MM', '08', 'Mandalay'],
 ['MM', '15', 'Magway'],
 ['MM', '06', 'Kayah'],
 ['MM', '05', 'Kayin'],
 ['MM', '04', 'Kachin'],
 ['MM', '03', 'Ayeyarwady'],
 ['MM', '02', 'Chin'],
 ['MN', '19', 'Uvs'],
 ['MN', '12', 'Hovd'],
 ['MN', '10', 'Gov\xc4\xad-Altay'],
 ['MN', '09', 'Dzavhan'],
 ['MN', '03', 'Bayan-\xc3\x96lgiy'],
 ['MN', '02', 'Bayanhongor'],
 ['MN', '20', 'Ulaanbaatar'],
 ['MN', '18', 'Central Aymag'],
 ['MN', '17', 'S\xc3\xbchbaatar'],
 ['MN', '16', 'Selenge'],
 ['MN', '15', '\xc3\x96v\xc3\xb6rhangay'],
 ['MN', '14', 'South Gobi Aimak'],
 ['MN', '13', 'H\xc3\xb6vsg\xc3\xb6l'],
 ['MN', '11', 'Hentiy'],
 ['MN', '08', 'Middle Gov\xc4\xad'],
 ['MN', '07', 'East Gobi Aymag'],
 ['MN', '06', 'East Aimak'],
 ['MN', '21', 'Bulgan'],
 ['MN', '01', 'Arhangay'],
 ['MN', '23', 'Darhan Uul'],
 ['MN', '24', 'Gov\xc4\xad-Sumber'],
 ['MN', '25', 'Orhon'],
 ['MO', '02', 'Macau'],
 ['MO', '01', 'Ilhas'],
 ['MP', '100', 'Rota Municipality'],
 ['MP', '110', 'Saipan Municipality'],
 ['MP', '120', 'Tinian Municipality'],
 ['MP', '085', 'Northern Islands Municipality'],
 ['MQ', 'MQ', 'Martinique'],
 ['MR', '06', 'Trarza'],
 ['MR', '11', 'Tiris Zemmour'],
 ['MR', '09', 'Tagant'],
 ['MR', 'NKC', 'Nouakchott'],
 ['MR', '12', 'Inchiri'],
 ['MR', '02', 'Wilaya du Hodh el Gharbi'],
 ['MR', '01', 'Hodh ech Chargui'],
 ['MR', '10', 'Guidimaka'],
 ['MR', '04', 'Gorgol'],
 ['MR', '08', 'Dakhlet Nouadhibou'],
 ['MR', '05', 'Brakna'],
 ['MR', '03', 'Assaba'],
 ['MR', '07', 'Adrar'],
 ['MS', '03', 'Saint Peter'],
 ['MS', '02', 'Saint Georges'],
 ['MS', '01', 'Saint Anthony'],
 ['MT', '01', '\xc4\xa6\xe2\x80\x99Attard'],
 ['MT', '02', '\xc4\xa6al Balzan'],
 ['MT', '03', 'Il-Birgu'],
 ['MT', '04', 'Birkirkara'],
 ['MT', '05', 'Bir\xc5\xbcebbu\xc4\xa1a'],
 ['MT', '06', 'Bormla'],
 ['MT', '07', '\xc4\xa6ad-Dingli'],
 ['MT', '08', 'Il-Fgura'],
 ['MT', '09', 'Il-Furjana'],
 ['MT', '10', 'Il-Fontana'],
 ['MT', '11', 'G\xc4\xa7ajnsielem'],
 ['MT', '12', 'L-G\xc4\xa7arb'],
 ['MT', '13', '\xc4\xa6al G\xc4\xa7arg\xc4\xa7ur'],
 ['MT', '14', 'L-G\xc4\xa7asri'],
 ['MT', '15', '\xc4\xa6al G\xc4\xa7axaq'],
 ['MT', '16', 'Il-Gudja'],
 ['MT', '17', 'Il-G\xc5\xbcira'],
 ['MT', '18', 'Il-\xc4\xa6amrun'],
 ['MT', '19', 'L-Iklin'],
 ['MT', '20', 'L-Imdina'],
 ['MT', '21', 'L-Im\xc4\xa1arr'],
 ['MT', '22', 'L-Imqabba'],
 ['MT', '23', 'L-Imsida'],
 ['MT', '24', 'L-Imtarfa'],
 ['MT', '25', 'L-Isla'],
 ['MT', '26', 'Il-Kalkara'],
 ['MT', '27', 'Ta\xe2\x80\x99 Ker\xc4\x8bem'],
 ['MT', '28', '\xc4\xa6al Kirkop'],
 ['MT', '29', '\xc4\xa6al Lija'],
 ['MT', '30', '\xc4\xa6al Luqa'],
 ['MT', '31', 'Il-Marsa'],
 ['MT', '32', 'Marsaskala'],
 ['MT', '33', 'Marsaxlokk'],
 ['MT', '34', 'Il-Mellie\xc4\xa7a'],
 ['MT', '35', 'Il-Mosta'],
 ['MT', '36', 'Il-Munxar'],
 ['MT', '37', 'In-Nadur'],
 ['MT', '38', 'In-Naxxar'],
 ['MT', '39', 'Paola'],
 ['MT', '40', 'Pembroke'],
 ['MT', '41', 'Tal-Piet\xc3\xa0'],
 ['MT', '42', 'Il-Qala'],
 ['MT', '43', '\xc4\xa6al Qormi'],
 ['MT', '44', 'Il-Qrendi'],
 ['MT', '46', 'Ir-Rabat'],
 ['MT', '47', '\xc4\xa6al Safi'],
 ['MT', '48', 'Saint John'],
 ['MT', '49', 'Saint Julian'],
 ['MT', '50', 'Saint Lawrence'],
 ['MT', '51', 'Saint Lucia'],
 ['MT', '52', 'Saint Paul\xe2\x80\x99s Bay'],
 ['MT', '53', 'Saint Venera'],
 ['MT', '54', 'Ta\xe2\x80\x99 Sannat'],
 ['MT', '55', 'Is-Si\xc4\xa1\xc4\xa1iewi'],
 ['MT', '56', 'Tas-Sliema'],
 ['MT', '57', 'Is-Swieqi'],
 ['MT', '58', '\xc4\xa6al Tarxien'],
 ['MT', '59', 'Ta\xe2\x80\x99 Xbiex'],
 ['MT', '61', 'Ix-Xag\xc4\xa7ra'],
 ['MT', '62', 'Ix-Xewkija'],
 ['MT', '63', 'Ix-Xg\xc4\xa7ajra'],
 ['MT', '64', '\xc4\xa6a\xc5\xbc-\xc5\xbbabbar'],
 ['MT', '65', '\xc4\xa6a\xc5\xbc-\xc5\xbbebbu\xc4\xa1'],
 ['MT', '66', 'I\xc5\xbc-\xc5\xbbebbu\xc4\xa1'],
 ['MT', '67', 'I\xc5\xbc-\xc5\xbbejtun'],
 ['MT', '68', 'I\xc5\xbc-\xc5\xbburrieq'],
 ['MT', '60', 'Il-Belt Valletta'],
 ['MU', '21', 'Agalega Islands'],
 ['MU', '20', 'Savanne'],
 ['MU', '19', 'Rivi\xc3\xa8re du Rempart'],
 ['MU', '18', 'Port Louis'],
 ['MU', '17', 'Plaines Wilhems'],
 ['MU', '16', 'Pamplemousses'],
 ['MU', '15', 'Moka'],
 ['MU', '14', 'Grand Port'],
 ['MU', '13', 'Flacq'],
 ['MU', '12', 'Black River'],
 ['MU', '22', 'Cargados Carajos'],
 ['MU', '23', 'Rodrigues'],
 ['MV', '47', 'Vaavu Atholhu'],
 ['MV', '46', 'Thaa Atholhu'],
 ['MV', '45', 'Shaviyani Atholhu'],
 ['MV', '01', 'Seenu'],
 ['MV', '44', 'Raa Atholhu'],
 ['MV', '43', 'Noonu Atoll'],
 ['MV', '42', 'Gnyaviyani Atoll'],
 ['MV', '41', 'Meemu Atholhu'],
 ['MV', '39', 'Lhaviyani Atholhu'],
 ['MV', '05', 'Laamu'],
 ['MV', '38', 'Kaafu Atoll'],
 ['MV', '37', 'Haa Dhaalu Atholhu'],
 ['MV', '36', 'Haa Alifu Atholhu'],
 ['MV', '35', 'Gaafu Dhaalu Atholhu'],
 ['MV', '34', 'Gaafu Alifu Atholhu'],
 ['MV', '33', 'Faafu Atholhu'],
 ['MV', '32', 'Dhaalu Atholhu'],
 ['MV', '31', 'Baa Atholhu'],
 ['MV', '30', 'Northern Ari Atoll'],
 ['MV', '40', 'Maale'],
 ['MV', '48', 'South Province'],
 ['MV', '49', 'Upper South Province'],
 ['MV', '50', 'Upper North Province'],
 ['MV', '51', 'Central Province'],
 ['MV', '52', 'South Central Province'],
 ['MV', '53', 'North Central Province'],
 ['MV', '54', 'North Province'],
 ['MW', 'S', 'Southern Region'],
 ['MW', 'N', 'Northern Region'],
 ['MW', 'C', 'Central Region'],
 ['MX', '31', 'Yucat\xc3\xa1n'],
 ['MX', '30', 'Veracruz-Llave'],
 ['MX', '29', 'Tlaxcala'],
 ['MX', '28', 'Tamaulipas'],
 ['MX', '27', 'Tabasco'],
 ['MX', '23', 'Quintana Roo'],
 ['MX', '22', 'Quer\xc3\xa9taro'],
 ['MX', '21', 'Puebla'],
 ['MX', '20', 'Oaxaca'],
 ['MX', '19', 'Nuevo Le\xc3\xb3n'],
 ['MX', '17', 'Morelos'],
 ['MX', '15', 'M\xc3\xa9xico'],
 ['MX', '13', 'Hidalgo'],
 ['MX', '12', 'Guerrero'],
 ['MX', '09', 'The Federal District'],
 ['MX', '05', 'Chiapas'],
 ['MX', '04', 'Campeche'],
 ['MX', '32', 'Zacatecas'],
 ['MX', '26', 'Sonora'],
 ['MX', '25', 'Sinaloa'],
 ['MX', '24', 'San Luis Potos\xc3\xad'],
 ['MX', '18', 'Nayarit'],
 ['MX', '16', 'Michoac\xc3\xa1n'],
 ['MX', '14', 'Jalisco'],
 ['MX', '11', 'Guanajuato'],
 ['MX', '10', 'Durango'],
 ['MX', '08', 'Colima'],
 ['MX', '07', 'Coahuila'],
 ['MX', '06', 'Chihuahua'],
 ['MX', '03', 'Baja California Sur'],
 ['MX', '02', 'Baja California'],
 ['MX', '01', 'Aguascalientes'],
 ['MY', '04', 'Melaka'],
 ['MY', '13', 'Terengganu'],
 ['MY', '12', 'Selangor'],
 ['MY', '11', 'Sarawak'],
 ['MY', '16', 'Sabah'],
 ['MY', '08', 'Perlis'],
 ['MY', '07', 'Perak'],
 ['MY', '06', 'Pahang'],
 ['MY', '05', 'Negeri Sembilan'],
 ['MY', '03', 'Kelantan'],
 ['MY', '14', 'Kuala Lumpur'],
 ['MY', '09', 'Pulau Pinang'],
 ['MY', '02', 'Kedah'],
 ['MY', '01', 'Johor'],
 ['MY', '15', 'Labuan'],
 ['MY', '17', 'Putrajaya'],
 ['MZ', '09', 'Zamb\xc3\xa9zia'],
 ['MZ', '08', 'Province of Tete'],
 ['MZ', '05', 'Sofala'],
 ['MZ', '07', 'Niassa'],
 ['MZ', '06', 'Nampula'],
 ['MZ', '04', 'Maputo'],
 ['MZ', '10', 'Manica'],
 ['MZ', '03', 'Inhambane'],
 ['MZ', '02', 'Gaza'],
 ['MZ', '01', 'Cabo Delgado'],
 ['MZ', '11', 'Maputo City'],
 ['NA', '28', 'Caprivi'],
 ['NA', '21', 'Khomas'],
 ['NA', '29', 'Erongo'],
 ['NA', '30', 'Hardap'],
 ['NA', '31', 'Karas'],
 ['NA', '32', 'Kunene'],
 ['NA', '33', 'Ohangwena'],
 ['NA', '34', 'Okavango'],
 ['NA', '35', 'Omaheke'],
 ['NA', '36', 'Omusati'],
 ['NA', '37', 'Oshana'],
 ['NA', '38', 'Oshikoto'],
 ['NA', '39', 'Otjozondjupa'],
 ['NC', '02', 'Province Sud'],
 ['NC', '01', 'Province Nord'],
 ['NC', '03', 'Province des \xc3\xaeles Loyaut\xc3\xa9'],
 ['NE', '07', 'Zinder'],
 ['NE', '06', 'Tahoua'],
 ['NE', '04', 'Maradi'],
 ['NE', '03', 'Dosso'],
 ['NE', '02', 'Diffa'],
 ['NE', '01', 'Agadez'],
 ['NE', '09', 'Tillab\xc3\xa9ri'],
 ['NE', '08', 'Niamey'],
 ['NG', '51', 'Sokoto'],
 ['NG', '50', 'Rivers'],
 ['NG', '49', 'Plateau'],
 ['NG', '32', 'Oyo'],
 ['NG', '48', 'Ondo'],
 ['NG', '16', 'Ogun'],
 ['NG', '31', 'Niger'],
 ['NG', '05', 'Lagos'],
 ['NG', '30', 'Kwara'],
 ['NG', '24', 'Katsina'],
 ['NG', '29', 'Kano'],
 ['NG', '23', 'Kaduna'],
 ['NG', '28', 'Imo State'],
 ['NG', '22', 'Cross River'],
 ['NG', '27', 'Borno'],
 ['NG', '26', 'Benue State'],
 ['NG', '46', 'Bauchi'],
 ['NG', '25', 'Udi State'],
 ['NG', '21', 'Akwa Ibom'],
 ['NG', '11', 'Abuja Federal Capital Territory'],
 ['NG', '45', 'Abia'],
 ['NG', '36', 'Delta State'],
 ['NG', '35', 'Adamawa State'],
 ['NG', '37', 'Edo'],
 ['NG', '47', 'Enugu State'],
 ['NG', '39', 'Jigawa State'],
 ['NG', '52', 'Bayelsa'],
 ['NG', '53', 'Ebonyi'],
 ['NG', '54', 'Ekiti'],
 ['NG', '55', 'Gombe'],
 ['NG', '56', 'Nassarawa'],
 ['NG', '57', 'Zamfara'],
 ['NG', '40', 'Kebbi'],
 ['NG', '41', 'Kogi'],
 ['NG', '42', 'Osun'],
 ['NG', '43', 'Taraba State'],
 ['NG', '44', 'Yobe'],
 ['NI', '15', 'Rivas'],
 ['NI', '14', 'R\xc3\xado San Juan'],
 ['NI', '13', 'Nueva Segovia'],
 ['NI', '12', 'Matagalpa'],
 ['NI', '11', 'Masaya'],
 ['NI', '10', 'Managua'],
 ['NI', '09', 'Madriz'],
 ['NI', '08', 'Le\xc3\xb3n'],
 ['NI', '07', 'Jinotega'],
 ['NI', '06', 'Granada'],
 ['NI', '05', 'Estel\xc3\xad'],
 ['NI', '04', 'Chontales'],
 ['NI', '03', 'Chinandega'],
 ['NI', '02', 'Carazo'],
 ['NI', '01', 'Boaco'],
 ['NI', '17', 'Atl\xc3\xa1ntico Norte'],
 ['NI', '18', 'Atl\xc3\xa1ntico Sur'],
 ['NL', '11', 'South Holland'],
 ['NL', '10', 'Zeeland'],
 ['NL', '09', 'Utrecht'],
 ['NL', '15', 'Overijssel'],
 ['NL', '07', 'North Holland'],
 ['NL', '06', 'North Brabant'],
 ['NL', '05', 'Limburg'],
 ['NL', '04', 'Groningen'],
 ['NL', '03', 'Gelderland'],
 ['NL', '02', 'Friesland'],
 ['NL', '01', 'Drenthe'],
 ['NL', '16', 'Flevoland'],
 ['NO', '05', 'Finnmark'],
 ['NO', '20', 'Vestfold county'],
 ['NO', '19', 'Vest-Agder'],
 ['NO', '18', 'Troms'],
 ['NO', '17', 'Telemark county'],
 ['NO', '16', 'S\xc3\xb8r-Tr\xc3\xb8ndelag'],
 ['NO', '15', 'Sogn og Fjordane'],
 ['NO', '14', 'Rogaland'],
 ['NO', '13', '\xc3\x98stfold'],
 ['NO', '12', 'Oslo County'],
 ['NO', '11', 'Oppland county'],
 ['NO', '10', 'Nord-Tr\xc3\xb8ndelag'],
 ['NO', '09', 'Nordland'],
 ['NO', '08', 'M\xc3\xb8re og Romsdal'],
 ['NO', '07', 'Hordaland'],
 ['NO', '06', 'Hedmark county'],
 ['NO', '04', 'Buskerud county'],
 ['NO', '02', 'Aust-Agder county'],
 ['NO', '01', 'Akershus county'],
 ['NP', 'FR', 'Far Western Region'],
 ['NP', 'MR', 'Mid Western Region'],
 ['NP', 'CR', 'Central Region'],
 ['NP', 'ER', 'Eastern Region'],
 ['NP', 'WR', 'Western Region'],
 ['NR', '14', 'Yaren'],
 ['NR', '13', 'Uaboe'],
 ['NR', '12', 'Nibok'],
 ['NR', '11', 'Meneng'],
 ['NR', '10', 'Ijuw'],
 ['NR', '09', 'Ewa'],
 ['NR', '08', 'Denigomodu'],
 ['NR', '07', 'Buada'],
 ['NR', '06', 'Boe'],
 ['NR', '05', 'Baiti'],
 ['NR', '04', 'Anibare'],
 ['NR', '03', 'Anetan'],
 ['NR', '02', 'Anabar'],
 ['NR', '01', 'Aiwo'],
 ['NZ', 'G2', 'Wellington'],
 ['NZ', 'F3', 'Manawatu-Wanganui'],
 ['NZ', 'G1', 'Waikato'],
 ['NZ', 'TAS', 'Tasman'],
 ['NZ', 'F9', 'Taranaki'],
 ['NZ', 'F8', 'Southland'],
 ['NZ', 'E8', 'Bay of Plenty'],
 ['NZ', 'F6', 'Northland'],
 ['NZ', 'F4', 'Marlborough'],
 ['NZ', 'F2', "Hawke's Bay"],
 ['NZ', 'F1', 'Gisborne Region'],
 ['NZ', 'E9', 'Canterbury'],
 ['NZ', 'E7', 'Auckland'],
 ['NZ', '10', 'Chatham Islands'],
 ['NZ', 'F5', 'Nelson'],
 ['NZ', 'F7', 'Otago'],
 ['NZ', 'G3', 'West Coast'],
 ['OM', '01', 'Ad D\xc4\x81khil\xc4\xabyah'],
 ['OM', '02', 'Al B\xc4\x81\xc5\xa3inah'],
 ['OM', '03', 'Al Wus\xc5\xa3\xc3\xa1'],
 ['OM', '04', 'Ash Sharq\xc4\xabyah'],
 ['OM', '09', 'Az\xcc\xa7 Z\xcc\xa7\xc4\x81hirah'],
 ['OM', '06', 'Masqa\xc5\xa3'],
 ['OM', '07', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at Musandam'],
 ['OM', '08', 'Z\xcc\xa7uf\xc4\x81r'],
 ['OM', '10', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at al Buraym\xc4\xab'],
 ['OM', '12', 'OM.12'],
 ['OM', '11', 'OM.11'],
 ['PA', '10', 'Veraguas'],
 ['PA', '09', 'Kuna Yala'],
 ['PA', '08', 'Panam\xc3\xa1'],
 ['PA', '07', 'Los Santos'],
 ['PA', '06', 'Herrera'],
 ['PA', '05', 'Dari\xc3\xa9n'],
 ['PA', '04', 'Col\xc3\xb3n'],
 ['PA', '03', 'Cocl\xc3\xa9'],
 ['PA', '02', 'Chiriqu\xc3\xad'],
 ['PA', '01', 'Bocas del Toro'],
 ['PA', '11', 'Ember\xc3\xa1'],
 ['PA', '12', 'Ng\xc3\xb6be-Bugl\xc3\xa9'],
 ['PE', '25', 'Ucayali'],
 ['PE', '24', 'Tumbes'],
 ['PE', '22', 'San Mart\xc3\xadn'],
 ['PE', '20', 'Piura'],
 ['PE', '16', 'Loreto'],
 ['PE', '14', 'Lambayeque'],
 ['PE', '13', 'La Libertad'],
 ['PE', '10', 'Huanuco'],
 ['PE', '06', 'Cajamarca'],
 ['PE', '02', 'Ancash'],
 ['PE', '01', 'Amazonas'],
 ['PE', '23', 'Tacna'],
 ['PE', '21', 'Puno'],
 ['PE', '19', 'Pasco'],
 ['PE', '18', 'Moquegua'],
 ['PE', '17', 'Madre de Dios'],
 ['PE', 'LMA', 'Provincia de Lima'],
 ['PE', '15', 'Lima'],
 ['PE', '12', 'Jun\xc3\xadn'],
 ['PE', '11', 'Ica'],
 ['PE', '09', 'Huancavelica'],
 ['PE', '08', 'Cusco'],
 ['PE', '07', 'Callao'],
 ['PE', '05', 'Ayacucho'],
 ['PE', '04', 'Arequipa'],
 ['PE', '03', 'Apur\xc3\xadmac'],
 ['PF', '04', '\xc3\x8eles Marquises'],
 ['PF', '03', '\xc3\x8eles Tuamotu-Gambier'],
 ['PF', '02', '\xc3\x8eles Sous-le-Vent'],
 ['PF', '01', '\xc3\x8eles du Vent'],
 ['PF', '05', '\xc3\x8eles Australes'],
 ['PG', '17', 'West New Britain'],
 ['PG', '06', 'Western Province'],
 ['PG', '16', 'Western Highlands'],
 ['PG', '05', 'Southern Highlands'],
 ['PG', '18', 'Sandaun'],
 ['PG', '07', 'Bougainville'],
 ['PG', '04', 'Northern Province'],
 ['PG', '15', 'New Ireland'],
 ['PG', '20', 'National Capital District'],
 ['PG', '14', 'Morobe'],
 ['PG', '13', 'Manus'],
 ['PG', '12', 'Madang'],
 ['PG', '02', 'Gulf'],
 ['PG', '19', 'Enga'],
 ['PG', '11', 'East Sepik'],
 ['PG', '10', 'East New Britain'],
 ['PG', '09', 'Eastern Highlands'],
 ['PG', '08', 'Chimbu'],
 ['PG', '03', 'Milne Bay'],
 ['PG', '01', 'Central Province'],
 ['PH', '14', 'Autonomous Region in Muslim Mindanao'],
 ['PH', '10', 'Northern Mindanao'],
 ['PH', '41', 'Mimaropa'],
 ['PH', '02', 'Cagayan Valley'],
 ['PH', '12', 'Soccsksargen'],
 ['PH', '13', 'Caraga'],
 ['PH', '15', 'Cordillera Administrative Region'],
 ['PH', '01', 'Ilocos'],
 ['PH', '40', 'Calabarzon'],
 ['PH', '06', 'Western Visayas'],
 ['PH', '03', 'Central Luzon'],
 ['PH', '07', 'Central Visayas'],
 ['PH', '08', 'Eastern Visayas'],
 ['PH', '09', 'Zamboanga Peninsula'],
 ['PH', '11', 'Davao'],
 ['PH', '05', 'Bicol'],
 ['PH', 'NCR', 'National Capital Region'],
 ['PK', '08', 'Isl\xc4\x81m\xc4\x81b\xc4\x81d'],
 ['PK', '05', 'Sindh'],
 ['PK', '04', 'Punjab'],
 ['PK', '03', 'North-West Frontier Province'],
 ['PK', '07', 'Gilgit-Baltistan'],
 ['PK', '01', 'Federally Administered Tribal Areas'],
 ['PK', '02', 'Balochist\xc4\x81n'],
 ['PK', '06', 'Azad Kashmir'],
 ['PL', '75', 'Lublin Voivodeship'],
 ['PL', '77', 'Lesser Poland Voivodeship'],
 ['PL', '78', 'Masovian Voivodeship'],
 ['PL', '80', 'Subcarpathian Voivodeship'],
 ['PL', '81', 'Podlasie'],
 ['PL', '84', '\xc5\x9awi\xc4\x99tokrzyskie'],
 ['PL', '85', 'Warmian-Masurian Voivodeship'],
 ['PL', '72', 'Lower Silesian Voivodeship'],
 ['PL', '74', '\xc5\x81\xc3\xb3d\xc5\xba Voivodeship'],
 ['PL', '76', 'Lubusz'],
 ['PL', '79', 'Opole Voivodeship'],
 ['PL', '82', 'Pomeranian Voivodeship'],
 ['PL', '83', 'Silesian Voivodeship'],
 ['PL', '86', 'Greater Poland Voivodeship'],
 ['PL', '87', 'West Pomeranian Voivodeship'],
 ['PL', '73', 'Kujawsko-Pomorskie'],
 ['PM', '97502', 'Saint-Pierre'],
 ['PM', '97501', 'Miquelon-Langlade'],
 ['PR', '001', 'Adjuntas'],
 ['PR', '003', 'Aguada'],
 ['PR', '005', 'Aguadilla'],
 ['PR', '007', 'Aguas Buenas'],
 ['PR', '009', 'Aibonito'],
 ['PR', '011', 'A\xc3\xb1asco'],
 ['PR', '013', 'Arecibo'],
 ['PR', '015', 'Arroyo'],
 ['PR', '017', 'Barceloneta'],
 ['PR', '019', 'Barranquitas'],
 ['PR', '021', 'Bayam\xc3\xb3n'],
 ['PR', '023', 'Cabo Rojo'],
 ['PR', '025', 'Caguas'],
 ['PR', '027', 'Camuy'],
 ['PR', '029', 'Canovanas'],
 ['PR', '031', 'Carolina'],
 ['PR', '033', 'Catano'],
 ['PR', '035', 'Cayey'],
 ['PR', '037', 'Ceiba'],
 ['PR', '039', 'Ciales'],
 ['PR', '041', 'Cidra'],
 ['PR', '043', 'Coamo'],
 ['PR', '045', 'Comerio'],
 ['PR', '047', 'Corozal'],
 ['PR', '049', 'Culebra'],
 ['PR', '051', 'Dorado'],
 ['PR', '053', 'Fajardo'],
 ['PR', '054', 'Florida'],
 ['PR', '055', 'Guanica'],
 ['PR', '057', 'Guayama'],
 ['PR', '059', 'Guayanilla'],
 ['PR', '061', 'Guaynabo'],
 ['PR', '063', 'Gurabo'],
 ['PR', '065', 'Hatillo'],
 ['PR', '067', 'Hormigueros'],
 ['PR', '069', 'Humacao'],
 ['PR', '071', 'Isabela'],
 ['PR', '073', 'Municipio de Jayuya'],
 ['PR', '075', 'Juana Diaz'],
 ['PR', '077', 'Municipio de Juncos'],
 ['PR', '079', 'Lajas'],
 ['PR', '081', 'Lares'],
 ['PR', '083', 'Las Marias'],
 ['PR', '085', 'Las Piedras'],
 ['PR', '087', 'Loiza'],
 ['PR', '089', 'Luquillo'],
 ['PR', '091', 'Manati'],
 ['PR', '093', 'Maricao'],
 ['PR', '095', 'Maunabo'],
 ['PR', '097', 'Mayaguez'],
 ['PR', '099', 'Moca'],
 ['PR', '101', 'Morovis'],
 ['PR', '103', 'Naguabo'],
 ['PR', '105', 'Naranjito'],
 ['PR', '107', 'Orocovis'],
 ['PR', '109', 'Patillas'],
 ['PR', '111', 'Penuelas'],
 ['PR', '113', 'Ponce'],
 ['PR', '117', 'Rincon'],
 ['PR', '115', 'Quebradillas'],
 ['PR', '119', 'Rio Grande'],
 ['PR', '121', 'Sabana Grande'],
 ['PR', '123', 'Salinas'],
 ['PR', '125', 'San German'],
 ['PR', '127', 'San Juan'],
 ['PR', '129', 'San Lorenzo'],
 ['PR', '131', 'San Sebastian'],
 ['PR', '133', 'Santa Isabel Municipio'],
 ['PR', '135', 'Toa Alta'],
 ['PR', '137', 'Toa Baja'],
 ['PR', '139', 'Trujillo Alto'],
 ['PR', '141', 'Utuado'],
 ['PR', '143', 'Vega Alta'],
 ['PR', '145', 'Vega Baja'],
 ['PR', '149', 'Villalba'],
 ['PR', '151', 'Yabucoa'],
 ['PR', '153', 'Yauco'],
 ['PR', '147', 'Vieques'],
 ['PS', 'GZ', 'Gaza Strip'],
 ['PS', 'WE', 'West Bank'],
 ['PT', '19', 'Set\xc3\xbabal'],
 ['PT', '18', 'Santar\xc3\xa9m'],
 ['PT', '16', 'Portalegre'],
 ['PT', '14', 'Lisbon'],
 ['PT', '13', 'Leiria'],
 ['PT', '09', 'Faro'],
 ['PT', '08', '\xc3\x89vora'],
 ['PT', '06', 'Castelo Branco'],
 ['PT', '03', 'Beja'],
 ['PT', '10', 'Madeira'],
 ['PT', '22', 'Viseu'],
 ['PT', '21', 'Vila Real'],
 ['PT', '20', 'Viana do Castelo'],
 ['PT', '17', 'Porto'],
 ['PT', '11', 'Guarda'],
 ['PT', '07', 'Coimbra'],
 ['PT', '05', 'Bragan\xc3\xa7a'],
 ['PT', '04', 'Braga'],
 ['PT', '02', 'Aveiro'],
 ['PT', '23', 'Azores'],
 ['PW', '11', 'Ngatpang'],
 ['PW', '16', 'Sonsorol'],
 ['PW', '05', 'Kayangel'],
 ['PW', '04', 'State of Hatohobei'],
 ['PW', '01', 'Aimeliik'],
 ['PW', '02', 'Airai'],
 ['PW', '03', 'Angaur'],
 ['PW', '06', 'Koror'],
 ['PW', '07', 'Melekeok'],
 ['PW', '08', 'Ngaraard'],
 ['PW', '12', 'Ngchesar'],
 ['PW', '09', 'Ngarchelong'],
 ['PW', '10', 'Ngardmau'],
 ['PW', '13', 'State of Ngeremlengui'],
 ['PW', '14', 'Ngiwal'],
 ['PW', '15', 'Peleliu'],
 ['PY', '17', 'San Pedro'],
 ['PY', '16', 'Presidente Hayes'],
 ['PY', '15', 'Paraguar\xc3\xad'],
 ['PY', '13', '\xc3\x91eembuc\xc3\xba'],
 ['PY', '12', 'Misiones'],
 ['PY', '11', 'Itap\xc3\xbaa'],
 ['PY', '10', 'Guair\xc3\xa1'],
 ['PY', '08', 'Cordillera'],
 ['PY', '07', 'Concepci\xc3\xb3n'],
 ['PY', '06', 'Central'],
 ['PY', '19', 'Canindey\xc3\xba'],
 ['PY', '05', 'Caazap\xc3\xa1'],
 ['PY', '04', 'Caaguaz\xc3\xba'],
 ['PY', '02', 'Amambay'],
 ['PY', '01', 'Alto Paran\xc3\xa1'],
 ['PY', '23', 'Alto Paraguay'],
 ['PY', '22', 'Asunci\xc3\xb3n'],
 ['PY', '24', 'Boquer\xc3\xb3n'],
 ['QA', '08', 'Mad\xc4\xabnat ash Sham\xc4\x81l'],
 ['QA', '02', 'Al Ghuwayr\xc4\xabyah'],
 ['QA', '04', 'Al Khawr'],
 ['QA', '09', 'Umm \xc5\x9eal\xc4\x81l'],
 ['QA', '03', 'Al Jumayl\xc4\xabyah'],
 ['QA', '06', 'Ar Rayy\xc4\x81n'],
 ['QA', '01', 'Ad Daw\xe1\xb8\xa9ah'],
 ['QA', '10', 'Al Wakrah'],
 ['QA', '11', 'Jaray\xc4\x81n al B\xc4\x81\xc5\xa3inah'],
 ['QA', '12', 'Balad\xc4\xabyat Umm Sa\xe2\x80\x98\xc4\xabd'],
 ['QA', '13', 'Balad\xc4\xabyat az\xcc\xa7 Z\xcc\xa7a\xe2\x80\x98\xc4\x81yin'],
 ['RE', 'RE', 'R\xc3\xa9union'],
 ['RO', '40', 'Jude\xc5\xa3ul Vrancea'],
 ['RO', '39', 'V\xc3\xa2lcea'],
 ['RO', '38', 'Vaslui'],
 ['RO', '37', 'Tulcea'],
 ['RO', '36', 'Timi\xc5\x9f'],
 ['RO', '35', 'Teleorman'],
 ['RO', '34', 'Suceava'],
 ['RO', '33', 'Sibiu'],
 ['RO', '32', 'Satu Mare'],
 ['RO', '31', 'S\xc4\x83laj'],
 ['RO', '30', 'Prahova'],
 ['RO', '29', 'Olt'],
 ['RO', '28', 'Neam\xc5\xa3'],
 ['RO', '27', 'Mure\xc5\x9f'],
 ['RO', '26', 'Mehedin\xc5\xa3i'],
 ['RO', '25', 'Maramure\xc5\x9f'],
 ['RO', '23', 'Ia\xc5\x9fi'],
 ['RO', '22', 'Ialomi\xc5\xa3a'],
 ['RO', '21', 'Hunedoara'],
 ['RO', '20', 'Harghita'],
 ['RO', '19', 'Gorj'],
 ['RO', '42', 'Giurgiu'],
 ['RO', '18', 'Gala\xc5\xa3i'],
 ['RO', '17', 'Dolj'],
 ['RO', '16', 'D\xc3\xa2mbovi\xc5\xa3a'],
 ['RO', '15', 'Covasna'],
 ['RO', '14', 'Constan\xc5\xa3a'],
 ['RO', '13', 'Cluj'],
 ['RO', '12', 'Cara\xc5\x9f-Severin'],
 ['RO', '41', 'C\xc4\x83l\xc4\x83ra\xc5\x9fi'],
 ['RO', '11', 'Buz\xc4\x83u'],
 ['RO', '10', 'Bucure\xc5\x9fti'],
 ['RO', '09', 'Bra\xc5\x9fov'],
 ['RO', '08', 'Br\xc4\x83ila'],
 ['RO', '07', 'Boto\xc5\x9fani'],
 ['RO', '06', 'Bistri\xc5\xa3a-N\xc4\x83s\xc4\x83ud'],
 ['RO', '05', 'Bihor'],
 ['RO', '04', 'Bac\xc4\x83u'],
 ['RO', '03', 'Arge\xc5\x9f'],
 ['RO', '02', 'Arad'],
 ['RO', '01', 'Alba'],
 ['RO', '43', 'Ilfov'],
 ['RS', 'VO', 'Autonomna Pokrajina Vojvodina'],
 ['RS', 'SE', 'Central Serbia'],
 ['RU', '88', 'Jaroslavl'],
 ['RU', '86', 'Voronezj'],
 ['RU', '85', 'Vologda'],
 ['RU', '84', 'Volgograd'],
 ['RU', '81', 'Uljanovsk'],
 ['RU', '80', 'Udmurtiya'],
 ['RU', '77', 'Tverskaya'],
 ['RU', '76', 'Tula'],
 ['RU', '73', 'Tatarstan'],
 ['RU', '72', 'Tambov'],
 ['RU', '70', "Stavropol'skiy"],
 ['RU', '69', 'Smolensk'],
 ['RU', '67', 'Saratov'],
 ['RU', '65', 'Samara'],
 ['RU', '62', 'Rjazan'],
 ['RU', '61', 'Rostov'],
 ['RU', '60', 'Pskov'],
 ['RU', '90', 'Perm'],
 ['RU', '57', 'Penza'],
 ['RU', '56', 'Orjol'],
 ['RU', '55', 'Orenburg'],
 ['RU', '52', 'Novgorod'],
 ['RU', '68', 'North Ossetia'],
 ['RU', '50', 'Nenetskiy Avtonomnyy Okrug'],
 ['RU', '49', 'Murmansk'],
 ['RU', '48', 'Moscow'],
 ['RU', '47', 'Moskovskaya'],
 ['RU', '46', 'Mordoviya'],
 ['RU', '45', 'Mariy-El'],
 ['RU', '43', 'Lipetsk'],
 ['RU', '42', 'Leningrad'],
 ['RU', '66', 'St.-Petersburg'],
 ['RU', '41', 'Kursk'],
 ['RU', '38', 'Krasnodarskiy'],
 ['RU', '37', 'Kostroma'],
 ['RU', '34', 'Komi'],
 ['RU', '33', 'Kirov'],
 ['RU', '28', 'Kareliya'],
 ['RU', '27', 'Karachayevo-Cherkesiya'],
 ['RU', '25', 'Kaluga'],
 ['RU', '24', 'Kalmykiya'],
 ['RU', '23', 'Kaliningrad'],
 ['RU', '22', 'Kabardino-Balkariya'],
 ['RU', '21', 'Ivanovo'],
 ['RU', '19', 'Ingushetiya'],
 ['RU', '51', 'Nizjnij Novgorod'],
 ['RU', '17', 'Dagestan'],
 ['RU', '16', 'Chuvashia'],
 ['RU', '12', 'Chechnya'],
 ['RU', '10', 'Brjansk'],
 ['RU', '09', 'Belgorod'],
 ['RU', '08', 'Bashkortostan'],
 ['RU', '07', 'Astrakhan'],
 ['RU', '06', 'Arkhangelskaya'],
 ['RU', '01', 'Adygeya'],
 ['RU', '83', 'Vladimir'],
 ['RU', '87', 'Yamalo-Nenetskiy Avtonomnyy Okrug'],
 ['RU', '78', 'Tjumen'],
 ['RU', '79', 'Tyva'],
 ['RU', '75', 'Tomsk'],
 ['RU', '71', 'Sverdlovsk'],
 ['RU', '54', 'Omsk'],
 ['RU', '53', 'Novosibirsk'],
 ['RU', '40', 'Kurgan'],
 ['RU', '91', 'Krasnoyarskiy'],
 ['RU', '32', 'Khanty-Mansiyskiy Avtonomnyy Okrug'],
 ['RU', '31', 'Khakasiya'],
 ['RU', '29', 'Kemerovo'],
 ['RU', '03', 'Altay'],
 ['RU', '13', 'Chelyabinsk Oblast'],
 ['RU', '04', 'Altayskiy'],
 ['RU', '63', 'Sakha'],
 ['RU', '59', 'Primorskiy'],
 ['RU', '30', 'Khabarovsk Krai'],
 ['RU', '20', 'Irkutsk'],
 ['RU', '89', 'Jewish Autonomous Oblast'],
 ['RU', '05', 'Amur'],
 ['RU', '11', 'Buryatiya'],
 ['RU', '64', 'Sakhalin'],
 ['RU', '44', 'Magadan'],
 ['RU', '92', 'Kamtsjatka'],
 ['RU', '15', 'Chukotskiy Avtonomnyy Okrug'],
 ['RU', '93', 'Zabaykal\xe2\x80\x99skiy Kray'],
 ['RW', '11', 'Eastern Province'],
 ['RW', '12', 'Kigali Province'],
 ['RW', '13', 'Northern Province'],
 ['RW', '14', 'Western Province'],
 ['RW', '15', 'Southern Province'],
 ['SA', '19', 'Tab\xc5\xabk'],
 ['SA', '16', 'Najr\xc4\x81n'],
 ['SA', '14', 'Makkah'],
 ['SA', '17', 'J\xc4\xabz\xc4\x81n'],
 ['SA', '13', '\xe1\xb8\xa8\xc4\x81\xca\xbcil'],
 ['SA', '11', 'Min\xc5\xa3aqat \xe2\x80\x98As\xc4\xabr'],
 ['SA', '06', 'Ash Sharq\xc4\xabyah'],
 ['SA', '10', 'Ar Riy\xc4\x81\xe1\xb8\x91'],
 ['SA', '08', 'Al Qa\xc5\x9f\xc4\xabm'],
 ['SA', '05', 'Al Mad\xc4\xabnah'],
 ['SA', '20', 'Al Jawf'],
 ['SA', '15', 'Northern Borders Region'],
 ['SA', '02', 'Al B\xc4\x81\xe1\xb8\xa9ah'],
 ['SB', '11', 'Western Province'],
 ['SB', '03', 'Malaita'],
 ['SB', '07', 'Isabel'],
 ['SB', '06', 'Guadalcanal'],
 ['SB', '10', 'Central Province'],
 ['SB', '09', 'Temotu'],
 ['SB', '08', 'Makira'],
 ['SB', '12', 'Choiseul'],
 ['SB', '13', 'Rennell and Bellona'],
 ['SC', '23', 'Takamaka'],
 ['SC', '22', 'Saint Louis'],
 ['SC', '27', 'Port Glaud'],
 ['SC', '20', 'Pointe Larue'],
 ['SC', '19', 'Plaisance'],
 ['SC', '18', 'Mont Fleuri'],
 ['SC', '17', 'Mont Buxton'],
 ['SC', '26', 'English River'],
 ['SC', '25', 'Inner Islands'],
 ['SC', '24', 'Grand Anse Mahe'],
 ['SC', '14', 'Grand Anse Praslin'],
 ['SC', '12', 'Glacis'],
 ['SC', '11', 'Cascade'],
 ['SC', '10', 'Bel Ombre'],
 ['SC', '09', 'Bel Air'],
 ['SC', '08', 'Beau Vallon'],
 ['SC', '07', 'Baie Sainte Anne'],
 ['SC', '06', 'Baie Lazare'],
 ['SC', '05', 'Anse Royale'],
 ['SC', '03', 'Anse Etoile'],
 ['SC', '02', 'Anse Boileau'],
 ['SC', '01', 'Anse aux Pins'],
 ['SC', '29', 'Les Mamelles'],
 ['SC', '30', 'Roche Caiman'],
 ['SC', '28', 'Au Cap'],
 ['SD', '43', 'Northern'],
 ['SD', '29', 'Khartoum State'],
 ['SD', '36', 'Red Sea'],
 ['SD', '38', 'Al Jazirah State'],
 ['SD', '39', 'Al Qadarif State'],
 ['SD', '41', 'White Nile State'],
 ['SD', '42', 'Blue Nile'],
 ['SD', '47', 'Western Darfur State'],
 ['SD', '49', 'Southern Darfur State'],
 ['SD', '50', 'Southern Kordofan'],
 ['SD', '52', 'Kassala State'],
 ['SD', '53', 'River Nile'],
 ['SD', '55', 'Northern Darfur'],
 ['SD', '56', 'Northern Kordofan State'],
 ['SD', '58', 'Sinnar State'],
 ['SD', '60', 'Eastern Darfur'],
 ['SD', '61', 'Central Darfur'],
 ['SE', '14', 'Norrbotten'],
 ['SE', '25', 'V\xc3\xa4stmanland'],
 ['SE', '24', 'V\xc3\xa4sternorrland'],
 ['SE', '23', 'V\xc3\xa4sterbotten'],
 ['SE', '22', 'V\xc3\xa4rmland'],
 ['SE', '21', 'Uppsala'],
 ['SE', '26', 'Stockholm'],
 ['SE', '18', 'S\xc3\xb6dermanland'],
 ['SE', '16', '\xc3\x96sterg\xc3\xb6tland'],
 ['SE', '15', '\xc3\x96rebro'],
 ['SE', '12', 'Kronoberg'],
 ['SE', '10', 'Dalarna'],
 ['SE', '09', 'Kalmar'],
 ['SE', '08', 'J\xc3\xb6nk\xc3\xb6ping'],
 ['SE', '07', 'J\xc3\xa4mtland'],
 ['SE', '06', 'Halland'],
 ['SE', '05', 'Gotland'],
 ['SE', '03', 'G\xc3\xa4vleborg'],
 ['SE', '02', 'Blekinge'],
 ['SE', '27', 'Sk\xc3\xa5ne'],
 ['SE', '28', 'V\xc3\xa4stra G\xc3\xb6taland'],
 ['SG', '01', 'Central Singapore'],
 ['SG', '02', 'North East'],
 ['SG', '04', 'South East'],
 ['SG', '05', 'South West'],
 ['SG', '03', 'North West'],
 ['SH', '01', 'Ascension'],
 ['SH', '03', 'Tristan da Cunha'],
 ['SH', '02', 'Saint Helena'],
 ['SI', 'N5', '\xc5\xbdalec'],
 ['SI', 'E7', 'Zagorje ob Savi'],
 ['SI', 'E5', 'Vrhnika'],
 ['SI', 'D5', 'Tr\xc5\xbei\xc4\x8d'],
 ['SI', 'D4', 'Trebnje'],
 ['SI', 'D3', 'Trbovlje'],
 ['SI', 'D2', 'Tolmin'],
 ['SI', 'D7', 'Velenje'],
 ['SI', 'C5', '\xc5\xa0marje pri Jel\xc5\xa1ah'],
 ['SI', 'C4', 'Slovenska Konjice'],
 ['SI', 'L8', 'Slovenska Bistrica'],
 ['SI', 'C2', 'Slovenj Gradec'],
 ['SI', 'B9', '\xc5\xa0kofja Loka'],
 ['SI', 'B7', 'Se\xc5\xbeana'],
 ['SI', 'B6', 'Sevnica'],
 ['SI', 'L7', '\xc5\xa0entjur pri Celju'],
 ['SI', 'L1', 'Ribnica'],
 ['SI', 'A3', 'Radovljica'],
 ['SI', 'A2', 'Radlje ob Dravi'],
 ['SI', 'K7', 'Ptuj'],
 ['SI', '94', 'Postojna'],
 ['SI', 'J9', 'Piran-Pirano'],
 ['SI', '87', 'Ormo\xc5\xbe'],
 ['SI', 'J7', 'Novo Mesto'],
 ['SI', '84', 'Nova Gorica'],
 ['SI', '80', 'Murska Sobota'],
 ['SI', '79', 'Mozirje'],
 ['SI', '73', 'Metlika'],
 ['SI', 'J2', 'Maribor'],
 ['SI', '64', 'Logatec'],
 ['SI', 'I6', 'Ljutomer'],
 ['SI', 'I5', 'Litija'],
 ['SI', 'I3', 'Lenart'],
 ['SI', '57', 'La\xc5\xa1ko'],
 ['SI', '54', 'Kr\xc5\xa1ko'],
 ['SI', '52', 'Kranj'],
 ['SI', '50', 'Koper-Capodistria'],
 ['SI', 'H7', 'Ko\xc4\x8devje'],
 ['SI', 'H6', 'Kamnik'],
 ['SI', 'H4', 'Jesenice'],
 ['SI', '40', 'Izola-Isola'],
 ['SI', '38', 'Ilirska Bistrica'],
 ['SI', '36', 'Idrija'],
 ['SI', '34', 'Hrastnik'],
 ['SI', '32', 'Grosuplje'],
 ['SI', '29', 'Gornja Radgona'],
 ['SI', '25', 'Dravograd'],
 ['SI', 'G7', 'Dom\xc5\xbeale'],
 ['SI', '17', '\xc4\x8crnomelj'],
 ['SI', '13', 'Cerknica'],
 ['SI', '11', 'Celje'],
 ['SI', '08', 'Bre\xc5\xbeice'],
 ['SI', '01', 'Ajdov\xc5\xa1\xc4\x8dina'],
 ['SI', '35', 'Hrpelje-Kozina'],
 ['SI', '19', 'Diva\xc4\x8da'],
 ['SI', '91', 'Pivka'],
 ['SI', 'I7', 'Lo\xc5\xa1ka Dolina'],
 ['SI', '66', 'Lo\xc5\xa1ki Potok'],
 ['SI', '88', 'Osilnica'],
 ['SI', 'D8', 'Velike La\xc5\xa1\xc4\x8de'],
 ['SI', 'C1', '\xc5\xa0kofljica'],
 ['SI', '37', 'Ig'],
 ['SI', '09', 'Brezovica'],
 ['SI', '05', 'Borovnica'],
 ['SI', 'E1', 'Vipava'],
 ['SI', '49', 'Komen'],
 ['SI', 'J5', 'Miren-Kostanjevica'],
 ['SI', '07', 'Brda'],
 ['SI', '44', 'Kanal'],
 ['SI', 'F2', '\xc5\xbdiri'],
 ['SI', '14', 'Cerkno'],
 ['SI', 'F1', '\xc5\xbdelezniki'],
 ['SI', '27', 'Gorenja Vas-Poljane'],
 ['SI', 'G4', 'Dobrova-Horjul-Polhov Gradec'],
 ['SI', '46', 'Kobarid'],
 ['SI', '06', 'Bovec'],
 ['SI', '04', 'Bohinj'],
 ['SI', '03', 'Bled'],
 ['SI', '82', 'Naklo'],
 ['SI', '53', 'Kranjska Gora'],
 ['SI', 'K5', 'Preddvor'],
 ['SI', '12', 'Cerklje Na Gorenjskem'],
 ['SI', 'B2', '\xc5\xa0en\xc4\x8dur'],
 ['SI', 'E3', 'Vodice'],
 ['SI', '71', 'Medvode'],
 ['SI', '72', 'Menge\xc5\xa1'],
 ['SI', '22', 'Dol Pri Ljubljani'],
 ['SI', '77', 'Morav\xc4\x8de'],
 ['SI', '30', 'Gornji Grad'],
 ['SI', 'I9', 'Lu\xc4\x8de'],
 ['SI', 'K8', 'Ravne na Koro\xc5\xa1kem'],
 ['SI', '74', 'Me\xc5\xbeica'],
 ['SI', '81', 'Muta'],
 ['SI', 'E6', 'Vuzenica'],
 ['SI', '16', '\xc4\x8crna na Koro\xc5\xa1kem'],
 ['SI', '62', 'Ljubno'],
 ['SI', 'C7', '\xc5\xa0o\xc5\xa1tanj'],
 ['SI', 'C6', '\xc5\xa0martno ob Paki'],
 ['SI', '68', 'Lukovica'],
 ['SI', '99', 'Rade\xc4\x8de'],
 ['SI', '39', 'Ivan\xc4\x8dna Gorica'],
 ['SI', '20', 'Dobrepolje'],
 ['SI', 'B1', 'Semi\xc4\x8d'],
 ['SI', 'B4', '\xc5\xa0entjernej'],
 ['SI', 'B8', '\xc5\xa0kocjan'],
 ['SI', 'C9', '\xc5\xa0tore'],
 ['SI', 'N3', 'Vojnik'],
 ['SI', 'E2', 'Vitanje'],
 ['SI', 'F3', 'Zre\xc4\x8de'],
 ['SI', '76', 'Mislinja'],
 ['SI', 'L3', 'Ru\xc5\xa1e'],
 ['SI', '55', 'Kungota'],
 ['SI', 'B3', '\xc5\xa0entilj'],
 ['SI', '89', 'Pesnica'],
 ['SI', '26', 'Duplek'],
 ['SI', '98', 'Ra\xc4\x8de-Fram'],
 ['SI', 'C8', 'Star\xc5\xa1e'],
 ['SI', '45', 'Kidri\xc4\x8devo'],
 ['SI', 'J1', 'Maj\xc5\xa1perk'],
 ['SI', 'N2', 'Videm'],
 ['SI', 'A7', 'Roga\xc5\xa1ka Slatina'],
 ['SI', 'A8', 'Rogatec'],
 ['SI', '92', 'Pod\xc4\x8detrtek'],
 ['SI', '51', 'Kozje'],
 ['SI', '28', 'Gori\xc5\xa1nica'],
 ['SI', 'E9', 'Zavr\xc4\x8d'],
 ['SI', '24', 'Dornava'],
 ['SI', '42', 'Jur\xc5\xa1inci'],
 ['SI', 'D1', 'Sveti Jurij'],
 ['SI', 'A1', 'Radenci'],
 ['SI', '97', 'Puconci'],
 ['SI', 'A6', 'Roga\xc5\xa1ovci'],
 ['SI', 'I2', 'Kuzma'],
 ['SI', '31', 'Gornji Petrovci'],
 ['SI', '78', 'Moravske Toplice'],
 ['SI', '47', 'Kobilje'],
 ['SI', '02', 'Beltinci'],
 ['SI', 'D6', 'Turni\xc5\xa1\xc4\x8de'],
 ['SI', '86', 'Odranci'],
 ['SI', '15', '\xc4\x8cren\xc5\xa1ovci'],
 ['SI', '83', 'Nazarje'],
 ['SI', '61', 'Ljubljana'],
 ['SI', 'N7', '\xc5\xbdirovnica'],
 ['SI', 'H5', 'Jezersko'],
 ['SI', 'M2', 'Sol\xc4\x8dava'],
 ['SI', 'H8', 'Komenda'],
 ['SI', 'H3', 'Horjul'],
 ['SI', 'L6', '\xc5\xa0empeter-Vrtojba'],
 ['SI', 'F6', 'Bloke'],
 ['SI', 'M1', 'Sodra\xc5\xbeica'],
 ['SI', 'M8', 'Trzin'],
 ['SI', 'K6', 'Prevalje'],
 ['SI', 'N4', 'Vransko'],
 ['SI', 'M5', 'Tabor'],
 ['SI', 'F7', 'Braslov\xc4\x8de'],
 ['SI', 'K3', 'Polzela'],
 ['SI', 'K4', 'Prebold'],
 ['SI', 'H9', 'Kostel'],
 ['SI', 'N8', '\xc5\xbdu\xc5\xbeemberk'],
 ['SI', 'G6', 'Dolenjske Toplice'],
 ['SI', 'J6', 'Mirna Pe\xc4\x8d'],
 ['SI', 'F5', 'Bistrica ob Sotli'],
 ['SI', 'G2', 'Dobje'],
 ['SI', 'G3', 'Dobrna'],
 ['SI', 'J8', 'Oplotnica'],
 ['SI', 'K2', 'Podvelka'],
 ['SI', 'L2', 'Ribnica na Pohorju'],
 ['SI', 'I8', 'Lovrenc na Pohorju'],
 ['SI', 'L5', 'Selnica ob Dravi'],
 ['SI', 'H1', 'Ho\xc4\x8de-Slivnica'],
 ['SI', 'J4', 'Miklav\xc5\xbe na Dravskem Polju'],
 ['SI', 'G9', 'Hajdina'],
 ['SI', 'N6', '\xc5\xbdetale'],
 ['SI', 'K1', 'Podlehnik'],
 ['SI', 'J3', 'Markovci'],
 ['SI', 'G1', 'Destrnik'],
 ['SI', 'M7', 'Trnovska Vas'],
 ['SI', 'M4', 'Sveti Andra\xc5\xbe v Slovenskih Goricah'],
 ['SI', 'F9', 'Cerkvenjak'],
 ['SI', 'F4', 'Benedikt'],
 ['SI', 'M3', 'Sveta Ana'],
 ['SI', 'I1', 'Kri\xc5\xbeevci'],
 ['SI', 'N1', 'Ver\xc5\xbeej'],
 ['SI', 'M9', 'Velika Polana'],
 ['SI', 'I4', 'Lendava-Lendva'],
 ['SI', 'G5', 'Dobrovnik-Dobronak'],
 ['SI', 'M6', 'Ti\xc5\xa1ina'],
 ['SI', 'F8', 'Cankova'],
 ['SI', 'G8', 'Grad'],
 ['SI', 'H2', 'Hodo\xc5\xa1-Hodos'],
 ['SI', 'K9', 'Razkri\xc5\xbeje'],
 ['SI', 'L9', '\xc5\xa0martno pri Litiji'],
 ['SI', 'L4', '\xc5\xa0alovci'],
 ['SI', 'N9', 'Ob\xc4\x8dina Apa\xc4\x8de'],
 ['SI', 'O1', 'Ob\xc4\x8dina Cirkulane'],
 ['SI', 'O3', 'Ob\xc4\x8dina Kostanjevica na Krki'],
 ['SI', 'O4', 'Ob\xc4\x8dina Log-Dragomer'],
 ['SI', 'O5', 'Ob\xc4\x8dina Makole'],
 ['SI', 'O7', 'Ob\xc4\x8dina Mokronog-Trebelno'],
 ['SI', 'O8', 'Ob\xc4\x8dina Polj\xc4\x8dane'],
 ['SI', 'O9', 'Ob\xc4\x8dina Re\xc4\x8dica ob Savinji'],
 ['SI', 'P1', 'Ob\xc4\x8dina Ren\xc4\x8de-Vogrsko'],
 ['SI', 'P4', 'Ob\xc4\x8dina Sredi\xc5\xa1\xc4\x8de ob Dravi'],
 ['SI', 'P5', 'Ob\xc4\x8dina Stra\xc5\xbea'],
 ['SI', 'P6', 'Ob\xc4\x8dina Sveta Trojica v Slovenskih Goricah'],
 ['SI', 'P8', 'Ob\xc4\x8dina Sveti Toma\xc5\xbe'],
 ['SI', 'P2', 'Ob\xc4\x8dina \xc5\xa0entrupert'],
 ['SI', 'P3', 'Ob\xc4\x8dina \xc5\xa0marje\xc5\xa1ke Toplice'],
 ['SJ', '22', 'Jan Mayen'],
 ['SJ', '21', 'Svalbard'],
 ['SK', '03', 'Ko\xc5\xa1ick\xc3\xbd'],
 ['SK', '05', 'Pre\xc5\xa1ovsk\xc3\xbd'],
 ['SK', '08', '\xc5\xbdilinsk\xc3\xbd'],
 ['SK', '01', 'Banskobystrick\xc3\xbd'],
 ['SK', '02', 'Bratislavsk\xc3\xbd'],
 ['SK', '04', 'Nitriansky'],
 ['SK', '06', 'Tren\xc4\x8diansky'],
 ['SK', '07', 'Trnavsk\xc3\xbd'],
 ['SL', '04', 'Western Area'],
 ['SL', '03', 'Southern Province'],
 ['SL', '02', 'Northern Province'],
 ['SL', '01', 'Eastern Province'],
 ['SM', '09', 'Serravalle'],
 ['SM', '02', 'Chiesanuova'],
 ['SM', '07', 'San Marino'],
 ['SM', '01', 'Acquaviva'],
 ['SM', '06', 'Borgo Maggiore'],
 ['SM', '03', 'Domagnano'],
 ['SM', '04', 'Faetano'],
 ['SM', '05', 'Fiorentino'],
 ['SM', '08', 'Montegiardino'],
 ['SN', '12', 'Ziguinchor'],
 ['SN', '07', 'Thi\xc3\xa8s'],
 ['SN', '05', 'Tambacounda'],
 ['SN', '14', 'Saint-Louis'],
 ['SN', '15', 'Matam'],
 ['SN', '13', 'Louga'],
 ['SN', '11', 'Kolda'],
 ['SN', '10', 'Kaolack'],
 ['SN', '09', 'Fatick'],
 ['SN', '03', 'Diourbel'],
 ['SN', '01', 'Dakar'],
 ['SN', '16', 'Kaffrine'],
 ['SN', '17', 'K\xc3\xa9dougou'],
 ['SN', '18', 'S\xc3\xa9dhiou'],
 ['SO', '20', 'Woqooyi Galbeed'],
 ['SO', '19', 'Togdheer'],
 ['SO', '14', 'Shabeellaha Hoose'],
 ['SO', '13', 'Middle Shabele'],
 ['SO', '12', 'Sanaag'],
 ['SO', '18', 'Nugaal'],
 ['SO', '10', 'Mudug'],
 ['SO', '09', 'Lower Juba'],
 ['SO', '08', 'Middle Juba'],
 ['SO', '07', 'Hiiraan'],
 ['SO', '06', 'Gedo'],
 ['SO', '05', 'Galguduud'],
 ['SO', '04', 'Bay'],
 ['SO', '03', 'Bari'],
 ['SO', '02', 'Banaadir'],
 ['SO', '01', 'Bakool'],
 ['SO', '21', 'Awdal'],
 ['SO', '22', 'Sool'],
 ['SR', '19', 'Wanica'],
 ['SR', '18', 'Sipaliwini'],
 ['SR', '17', 'Saramacca'],
 ['SR', '16', 'Paramaribo'],
 ['SR', '15', 'Para'],
 ['SR', '14', 'Nickerie'],
 ['SR', '13', 'Marowijne'],
 ['SR', '12', 'Coronie'],
 ['SR', '11', 'Commewijne'],
 ['SR', '10', 'Brokopondo'],
 ['SS', '07', 'Upper Nile State'],
 ['SS', '04', 'Lakes'],
 ['SS', '06', 'Unity State'],
 ['SS', '01', 'Central Equatoria State'],
 ['SS', '10', 'Western Equatoria State'],
 ['SS', '09', 'Western Bahr al Ghazal'],
 ['SS', '03', 'Jonglei'],
 ['SS', '05', 'Northern Bahr el Ghazal State'],
 ['SS', '02', 'Eastern Equatoria State'],
 ['SS', '08', 'Warrap State'],
 ['ST', '02', 'S\xc3\xa3o Tom\xc3\xa9 Island'],
 ['ST', '01', 'Pr\xc3\xadncipe'],
 ['SV', '14', 'Usulut\xc3\xa1n'],
 ['SV', '13', 'Sonsonate'],
 ['SV', '12', 'San Vicente'],
 ['SV', '11', 'Santa Ana'],
 ['SV', '10', 'San Salvador'],
 ['SV', '09', 'San Miguel'],
 ['SV', '08', 'Moraz\xc3\xa1n'],
 ['SV', '07', 'La Uni\xc3\xb3n'],
 ['SV', '06', 'La Paz'],
 ['SV', '05', 'La Libertad'],
 ['SV', '04', 'Cuscatl\xc3\xa1n'],
 ['SV', '03', 'Chalatenango'],
 ['SV', '02', 'Caba\xc3\xb1as'],
 ['SV', '01', 'Ahuachap\xc3\xa1n'],
 ['SY', '14', 'Tartus'],
 ['SY', '13', 'Damascus City'],
 ['SY', '12', 'Idlib'],
 ['SY', '11', 'Homs'],
 ['SY', '10', 'Hama'],
 ['SY', '09', 'Aleppo'],
 ['SY', '08', 'Rif-dimashq'],
 ['SY', '07', 'Deir ez-Zor'],
 ['SY', '06', 'Daraa'],
 ['SY', '05', 'As-Suwayda'],
 ['SY', '04', 'Ar-Raqqah'],
 ['SY', '03', 'Quneitra'],
 ['SY', '02', 'Latakia'],
 ['SY', '01', 'Al-Hasakah'],
 ['SZ', '04', 'Shiselweni'],
 ['SZ', '03', 'Manzini'],
 ['SZ', '02', 'Lubombo'],
 ['SZ', '01', 'Hhohho'],
 ['TD', '13', 'Salamat'],
 ['TD', '12', 'Ouadda\xc3\xaf'],
 ['TD', '02', 'Biltine'],
 ['TD', '14', 'Tandjil\xc3\xa9'],
 ['TD', '17', 'Moyen-Chari'],
 ['TD', '16', 'Mayo-Kebbi East Region'],
 ['TD', '09', 'Logone Oriental'],
 ['TD', '08', 'Logone Occidental'],
 ['TD', '07', 'Lac'],
 ['TD', '06', 'Kanem'],
 ['TD', '05', 'Gu\xc3\xa9ra'],
 ['TD', '15', 'Chari-Baguirmi'],
 ['TD', '01', 'Batha'],
 ['TD', '23', 'Borkou Region'],
 ['TD', '18', 'R\xc3\xa9gion du Hadjer-Lamis'],
 ['TD', '19', 'R\xc3\xa9gion du Mandoul'],
 ['TD', '20', 'Mayo-Kebbi West Region'],
 ['TD', '21', "R\xc3\xa9gion de la Ville de N'Djam\xc3\xa9na"],
 ['TD', '22', 'R\xc3\xa9gion du Barh el Gazel'],
 ['TD', '24', 'Ennedi Region'],
 ['TD', '25', 'R\xc3\xa9gion du Sila'],
 ['TD', '26', 'Tibesti Region'],
 ['TF', '02', 'Crozet'],
 ['TF', '03', 'Kerguelen'],
 ['TF', '01', 'Saint-Paul-et-Amsterdam'],
 ['TF', '05', '\xc3\x8eles \xc3\x89parses'],
 ['TF', '04', 'Terre-Ad\xc3\xa9lie'],
 ['TG', '26', 'Savanes'],
 ['TG', '25', 'Plateaux'],
 ['TG', '24', 'Maritime'],
 ['TG', '22', 'Centrale'],
 ['TG', '23', 'Kara'],
 ['TH', '15', 'Uthai Thani'],
 ['TH', '65', 'Trang'],
 ['TH', '08', 'Tak'],
 ['TH', '60', 'Surat Thani'],
 ['TH', '09', 'Sukhothai'],
 ['TH', '52', 'Ratchaburi'],
 ['TH', '59', 'Ranong'],
 ['TH', '57', 'Prachuap Khiri Khan'],
 ['TH', '62', 'Phuket Province'],
 ['TH', '56', 'Phetchaburi'],
 ['TH', '61', 'Phangnga'],
 ['TH', '01', 'Mae Hong Son'],
 ['TH', '05', 'Lamphun'],
 ['TH', '06', 'Lampang'],
 ['TH', '63', 'Krabi'],
 ['TH', '50', 'Kanchanaburi'],
 ['TH', '11', 'Kamphaeng Phet'],
 ['TH', '58', 'Chumphon'],
 ['TH', '03', 'Chiang Rai'],
 ['TH', '02', 'Chiang Mai'],
 ['TH', '72', 'Yasothon'],
 ['TH', '70', 'Yala'],
 ['TH', '10', 'Uttaradit'],
 ['TH', '49', 'Trat'],
 ['TH', '29', 'Surin'],
 ['TH', '51', 'Suphan Buri'],
 ['TH', '68', 'Songkhla'],
 ['TH', '30', 'Sisaket'],
 ['TH', '33', 'Sing Buri'],
 ['TH', '67', 'Satun'],
 ['TH', '37', 'Sara Buri'],
 ['TH', '54', 'Samut Songkhram'],
 ['TH', '55', 'Samut Sakhon'],
 ['TH', '42', 'Samut Prakan'],
 ['TH', '20', 'Sakon Nakhon'],
 ['TH', '25', 'Roi Et'],
 ['TH', '47', 'Rayong'],
 ['TH', '36', 'Phra Nakhon Si Ayutthaya'],
 ['TH', '07', 'Phrae'],
 ['TH', '12', 'Phitsanulok'],
 ['TH', '13', 'Phichit'],
 ['TH', '14', 'Phetchabun'],
 ['TH', '41', 'Phayao'],
 ['TH', '66', 'Phatthalung'],
 ['TH', '69', 'Pattani'],
 ['TH', '39', 'Pathum Thani'],
 ['TH', '38', 'Nonthaburi'],
 ['TH', '17', 'Nong Khai'],
 ['TH', '31', 'Narathiwat'],
 ['TH', '04', 'Nan'],
 ['TH', '64', 'Nakhon Si Thammarat'],
 ['TH', '16', 'Nakhon Sawan'],
 ['TH', '27', 'Nakhon Ratchasima'],
 ['TH', '73', 'Nakhon Phanom'],
 ['TH', '53', 'Nakhon Pathom'],
 ['TH', '43', 'Nakhon Nayok'],
 ['TH', '78', 'Mukdahan'],
 ['TH', '24', 'Maha Sarakham'],
 ['TH', '34', 'Lop Buri'],
 ['TH', '18', 'Loei'],
 ['TH', '40', 'Bangkok'],
 ['TH', '22', 'Khon Kaen'],
 ['TH', '23', 'Kalasin'],
 ['TH', '46', 'Chon Buri'],
 ['TH', '48', 'Chanthaburi'],
 ['TH', '26', 'Chaiyaphum'],
 ['TH', '32', 'Chai Nat'],
 ['TH', '44', 'Chachoengsao'],
 ['TH', '28', 'Buriram'],
 ['TH', '35', 'Ang Thong'],
 ['TH', '76', 'Udon Thani'],
 ['TH', '74', 'Prachin Buri'],
 ['TH', '75', 'Ubon Ratchathani'],
 ['TH', '77', 'Amnat Charoen'],
 ['TH', '79', 'Nong Bua Lamphu'],
 ['TH', '80', 'Sa Kaeo'],
 ['TH', '81', 'Changwat Bueng Kan'],
 ['TJ', '03', 'Sughd'],
 ['TJ', '01', 'Gorno-Badakhshan'],
 ['TJ', '02', 'Khatlon'],
 ['TJ', 'RR', 'Region of Republican Subordination'],
 ['TJ', '7280679', 'Dushanbe'],
 ['TK', 'N', 'Nukunonu'],
 ['TK', 'F', 'Fakaofo'],
 ['TK', 'A', 'Atafu'],
 ['TL', 'VI', 'Distrito Viqueque'],
 ['TL', 'MF', 'Manufahi'],
 ['TL', 'MT', 'Distrito Manatuto'],
 ['TL', 'LI', 'Distrito Liqui\xc3\xa7\xc3\xa1'],
 ['TL', 'LA', 'Distrito Laut\xc3\xa9m'],
 ['TL', 'CO', 'Distrito Cova Lima'],
 ['TL', 'ER', 'Ermera'],
 ['TL', 'DI', 'Distrito D\xc3\xadli'],
 ['TL', 'BO', 'Bobonaro'],
 ['TL', 'BA', 'Distrito Bacau'],
 ['TL', 'OE', 'Distrito Oecussi-Ambeno'],
 ['TL', 'AN', 'Distrito Ainaro'],
 ['TL', 'AL', 'Distrito Aileu'],
 ['TM', '02', 'Balkan'],
 ['TM', '01', 'Ahal'],
 ['TM', '03', 'Da\xc5\x9foguz'],
 ['TM', '05', 'Mary'],
 ['TM', '04', 'Lebap'],
 ['TN', '37', 'Zaghw\xc4\x81n'],
 ['TN', '36', 'T\xc5\xabnis'],
 ['TN', '35', 'Tawzar'],
 ['TN', '34', 'Ta\xc5\xa3\xc4\x81w\xc4\xabn'],
 ['TN', '23', 'S\xc5\xabsah'],
 ['TN', '22', 'Sily\xc4\x81nah'],
 ['TN', '33', 'S\xc4\xabd\xc4\xab B\xc5\xab Zayd'],
 ['TN', '32', '\xc5\x9eaf\xc4\x81qis'],
 ['TN', '31', 'Qibil\xc4\xab'],
 ['TN', '30', 'Qaf\xc5\x9fah'],
 ['TN', '29', 'Q\xc4\x81bis'],
 ['TN', '19', 'N\xc4\x81bul'],
 ['TN', '28', 'Madan\xc4\xabn'],
 ['TN', '06', 'Jund\xc5\xabbah'],
 ['TN', '27', 'Bin \xe2\x80\x98Ar\xc5\xabs'],
 ['TN', '18', 'Banzart'],
 ['TN', '17', 'B\xc4\x81jah'],
 ['TN', '38', 'Ariana'],
 ['TN', '03', 'Al Qayraw\xc4\x81n'],
 ['TN', '02', 'Al Qa\xc5\x9frayn'],
 ['TN', '16', 'Al Munast\xc4\xabr'],
 ['TN', '15', 'Al Mahd\xc4\xabyah'],
 ['TN', '14', 'Kef'],
 ['TN', '39', 'Gouvernorat de la Manouba'],
 ['TO', '03', 'Vava`u'],
 ['TO', '02', 'Tongatapu'],
 ['TO', '01', 'Ha`apai'],
 ['TO', 'EU', 'Eua'],
 ['TO', 'NI', 'Niuas'],
 ['TR', '66', 'Yozgat'],
 ['TR', '65', 'Van'],
 ['TR', '64', 'U\xc5\x9fak'],
 ['TR', '63', '\xc5\x9eanl\xc4\xb1urfa'],
 ['TR', '62', 'Tunceli'],
 ['TR', '58', 'Sivas'],
 ['TR', '74', 'Siirt'],
 ['TR', '73', 'Ni\xc4\x9fde'],
 ['TR', '50', 'Nev\xc5\x9fehir'],
 ['TR', '49', 'Mu\xc5\x9f'],
 ['TR', '48', 'Mu\xc4\x9fla'],
 ['TR', '72', 'Mardin'],
 ['TR', '45', 'Manisa'],
 ['TR', '44', 'Malatya'],
 ['TR', '43', 'K\xc3\xbctahya'],
 ['TR', '71', 'Konya'],
 ['TR', '40', 'K\xc4\xb1r\xc5\x9fehir'],
 ['TR', '38', 'Kayseri'],
 ['TR', '46', 'Kahramanmara\xc5\x9f'],
 ['TR', '35', '\xc4\xb0zmir'],
 ['TR', '33', 'Isparta'],
 ['TR', '32', 'Mersin'],
 ['TR', '31', 'Hatay'],
 ['TR', '70', 'Hakk\xc3\xa2ri'],
 ['TR', '83', 'Gaziantep'],
 ['TR', '26', 'Eski\xc5\x9fehir'],
 ['TR', '25', 'Erzurum'],
 ['TR', '24', 'Erzincan'],
 ['TR', '23', 'Elaz\xc4\xb1\xc4\x9f'],
 ['TR', '21', 'Diyarbak\xc4\xb1r'],
 ['TR', '20', 'Denizli'],
 ['TR', '15', 'Burdur'],
 ['TR', '13', 'Bitlis'],
 ['TR', '12', 'Bing\xc3\xb6l'],
 ['TR', '11', 'Bilecik'],
 ['TR', '10', 'Bal\xc4\xb1kesir'],
 ['TR', '09', 'Ayd\xc4\xb1n'],
 ['TR', '07', 'Antalya'],
 ['TR', '68', 'Ankara'],
 ['TR', '04', 'A\xc4\x9fr\xc4\xb1'],
 ['TR', '03', 'Afyonkarahisar'],
 ['TR', '02', 'Ad\xc4\xb1yaman'],
 ['TR', '81', 'Adana'],
 ['TR', '91', 'Osmaniye'],
 ['TR', '88', 'I\xc4\x9fd\xc4\xb1r'],
 ['TR', '75', 'Aksaray'],
 ['TR', '76', 'Batman'],
 ['TR', '78', 'Karaman'],
 ['TR', '79', 'K\xc4\xb1r\xc4\xb1kkale'],
 ['TR', '80', '\xc5\x9e\xc4\xb1rnak'],
 ['TR', '90', 'Kilis'],
 ['TR', '85', 'Zonguldak'],
 ['TR', '61', 'Trabzon'],
 ['TR', '60', 'Tokat'],
 ['TR', '59', 'Tekirda\xc4\x9f'],
 ['TR', '57', 'Sinop'],
 ['TR', '55', 'Samsun'],
 ['TR', '54', 'Sakarya'],
 ['TR', '53', 'Rize'],
 ['TR', '52', 'Ordu'],
 ['TR', '41', 'Kocaeli'],
 ['TR', '39', 'K\xc4\xb1rklareli'],
 ['TR', '37', 'Kastamonu'],
 ['TR', '84', 'Kars'],
 ['TR', '34', 'Istanbul'],
 ['TR', '69', 'G\xc3\xbcm\xc3\xbc\xc5\x9fhane'],
 ['TR', '28', 'Giresun'],
 ['TR', '22', 'Edirne'],
 ['TR', '19', '\xc3\x87orum'],
 ['TR', '82', '\xc3\x87ank\xc4\xb1r\xc4\xb1'],
 ['TR', '17', '\xc3\x87anakkale'],
 ['TR', '16', 'Bursa'],
 ['TR', '14', 'Bolu'],
 ['TR', '08', 'Artvin'],
 ['TR', '05', 'Amasya'],
 ['TR', '87', 'Bart\xc4\xb1n'],
 ['TR', '89', 'Karab\xc3\xbck'],
 ['TR', '92', 'Yalova'],
 ['TR', '86', 'Ardahan'],
 ['TR', '77', 'Bayburt'],
 ['TR', '93', 'D\xc3\xbczce'],
 ['TT', '11', 'Tobago'],
 ['TT', '10', 'City of San Fernando'],
 ['TT', '05', 'City of Port of Spain'],
 ['TT', '03', 'Mayaro'],
 ['TT', '01', 'Borough of Arima'],
 ['TT', 'CHA', 'Chaguanas'],
 ['TT', 'CTT', 'Couva-Tabaquite-Talparo'],
 ['TT', 'DMN', 'Diego Martin'],
 ['TT', 'ETO', 'Eastern Tobago'],
 ['TT', 'PED', 'Penal/Debe'],
 ['TT', 'PRT', 'Princes Town'],
 ['TT', 'PTF', 'Point Fortin'],
 ['TT', 'SGE', 'Sangre Grande'],
 ['TT', 'SIP', 'Siparia'],
 ['TT', 'SJL', 'San Juan/Laventille'],
 ['TT', 'TUP', 'Tunapuna/Piarco'],
 ['TV', 'NUI', 'Nui'],
 ['TV', 'NMA', 'Nanumea'],
 ['TV', 'FUN', 'Funafuti'],
 ['TV', 'NIT', 'Niutao'],
 ['TV', 'NMG', 'Nanumanga'],
 ['TV', 'VAI', 'Vaitupu'],
 ['TV', 'NKF', 'Nukufetau'],
 ['TV', 'NKL', 'Nukulaelae'],
 ['TW', '01', 'Fukien'],
 ['TW', '02', 'Kaohsiung'],
 ['TW', '03', 'Taipei'],
 ['TW', '04', 'Taiwan'],
 ['TZ', '19', 'Kagera'],
 ['TZ', '25', 'Zanzibar Urban/West'],
 ['TZ', '22', 'Zanzibar North'],
 ['TZ', '21', 'Zanzibar Central/South'],
 ['TZ', '18', 'Tanga'],
 ['TZ', '17', 'Tabora'],
 ['TZ', '16', 'Singida'],
 ['TZ', '15', 'Shinyanga'],
 ['TZ', '24', 'Rukwa Region'],
 ['TZ', '02', 'Pwani'],
 ['TZ', '20', 'Pemba South'],
 ['TZ', '13', 'Pemba North'],
 ['TZ', '12', 'Mwanza'],
 ['TZ', '10', 'Morogoro Region'],
 ['TZ', '09', 'Mbeya'],
 ['TZ', '08', 'Mara'],
 ['TZ', '07', 'Lindi'],
 ['TZ', '06', 'Kilimanjaro'],
 ['TZ', '05', 'Kigoma'],
 ['TZ', '04', 'Iringa'],
 ['TZ', '03', 'Dodoma'],
 ['TZ', '23', 'Dar es Salaam'],
 ['TZ', '26', 'Arusha'],
 ['TZ', '27', 'Manyara'],
 ['TZ', '14', 'Ruvuma'],
 ['TZ', '11', 'Mtwara'],
 ['UA', '27', 'Zhytomyrs\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '26', 'Zaporiz\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '25', 'Zakarpats\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '24', 'Volyns\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '23', "Vinnyts'ka"],
 ['UA', '22', 'Ternopil\xe2\x80\x99s\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '21', 'Sums\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '20', 'Misto Sevastopol\xe2\x80\x99'],
 ['UA', '19', 'Rivnens\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '18', 'Poltavs\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '17', 'Odes\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '16', 'Mykolayivs\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '15', 'L\xe2\x80\x99vivs\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '14', 'Luhans\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '13', 'Kyyivs\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '12', 'Kyiv City'],
 ['UA', '11', 'Avtonomna Respublika Krym'],
 ['UA', '10', 'Kirovohrads\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '09', 'Khmel\xe2\x80\x99nyts\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '08', 'Khersons\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '07', 'Kharkivs\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '06', 'Ivano-Frankivs\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '05', 'Donets\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '04', "Dnipropetrovs'ka Oblast'"],
 ['UA', '03', "Chernivets'ka Oblast'"],
 ['UA', '02', 'Chernihivs\xe2\x80\x99ka Oblast\xe2\x80\x99'],
 ['UA', '01', "Cherkas'ka Oblast'"],
 ['UG', 'C', 'Central Region'],
 ['UG', 'E', 'Easter Region'],
 ['UG', 'N', 'Northern Region'],
 ['UG', 'W', 'Western Region'],
 ['UM', '450', 'Wake Island'],
 ['UM', '350', 'Navassa Island'],
 ['UM', '050', 'Baker Island'],
 ['UM', '100', 'Howland Island'],
 ['UM', '150', 'Jarvis Island'],
 ['UM', '200', 'Johnston Atoll'],
 ['UM', '250', 'Kingman Reef'],
 ['UM', '300', 'Midway Islands'],
 ['UM', '400', 'Palmyra Atoll'],
 ['US', 'AR', 'Arkansas'],
 ['US', 'DC', 'Washington, D.C.'],
 ['US', 'DE', 'Delaware'],
 ['US', 'FL', 'Florida'],
 ['US', 'GA', 'Georgia'],
 ['US', 'KS', 'Kansas'],
 ['US', 'LA', 'Louisiana'],
 ['US', 'MD', 'Maryland'],
 ['US', 'MO', 'Missouri'],
 ['US', 'MS', 'Mississippi'],
 ['US', 'NC', 'North Carolina'],
 ['US', 'OK', 'Oklahoma'],
 ['US', 'SC', 'South Carolina'],
 ['US', 'TN', 'Tennessee'],
 ['US', 'TX', 'Texas'],
 ['US', 'WV', 'West Virginia'],
 ['US', 'AL', 'Alabama'],
 ['US', 'CT', 'Connecticut'],
 ['US', 'IA', 'Iowa'],
 ['US', 'IL', 'Illinois'],
 ['US', 'IN', 'Indiana'],
 ['US', 'ME', 'Maine'],
 ['US', 'MI', 'Michigan'],
 ['US', 'MN', 'Minnesota'],
 ['US', 'NE', 'Nebraska'],
 ['US', 'NH', 'New Hampshire'],
 ['US', 'NJ', 'New Jersey'],
 ['US', 'NY', 'New York'],
 ['US', 'OH', 'Ohio'],
 ['US', 'RI', 'Rhode Island'],
 ['US', 'VT', 'Vermont'],
 ['US', 'WI', 'Wisconsin'],
 ['US', 'CA', 'California'],
 ['US', 'CO', 'Colorado'],
 ['US', 'NM', 'New Mexico'],
 ['US', 'NV', 'Nevada'],
 ['US', 'UT', 'Utah'],
 ['US', 'AZ', 'Arizona'],
 ['US', 'ID', 'Idaho'],
 ['US', 'MT', 'Montana'],
 ['US', 'ND', 'North Dakota'],
 ['US', 'OR', 'Oregon'],
 ['US', 'SD', 'South Dakota'],
 ['US', 'WA', 'Washington'],
 ['US', 'WY', 'Wyoming'],
 ['US', 'HI', 'Hawaii'],
 ['US', 'AK', 'Alaska'],
 ['US', 'KY', 'Kentucky'],
 ['US', 'MA', 'Massachusetts'],
 ['US', 'PA', 'Pennsylvania'],
 ['US', 'VA', 'Virginia'],
 ['UY', '19', 'Treinta y Tres'],
 ['UY', '18', 'Tacuaremb\xc3\xb3'],
 ['UY', '17', 'Soriano'],
 ['UY', '16', 'San Jos\xc3\xa9'],
 ['UY', '15', 'Salto'],
 ['UY', '14', 'Rocha'],
 ['UY', '13', 'Rivera'],
 ['UY', '12', 'R\xc3\xado Negro'],
 ['UY', '11', 'Paysand\xc3\xba'],
 ['UY', '10', 'Montevideo'],
 ['UY', '09', 'Maldonado'],
 ['UY', '08', 'Lavalleja'],
 ['UY', '07', 'Florida'],
 ['UY', '06', 'Flores'],
 ['UY', '05', 'Durazno'],
 ['UY', '04', 'Colonia'],
 ['UY', '03', 'Cerro Largo'],
 ['UY', '02', 'Canelones'],
 ['UY', '01', 'Artigas'],
 ['UZ', '09', 'Karakalpakstan'],
 ['UZ', '12', 'Surxondaryo'],
 ['UZ', '10', 'Samarqand'],
 ['UZ', '08', 'Kashkadarya Province'],
 ['UZ', '02', 'Bukhara'],
 ['UZ', '14', 'Toshkent'],
 ['UZ', '13', 'Toshkent Shahri'],
 ['UZ', '16', 'Sirdaryo'],
 ['UZ', '07', 'Navoiy'],
 ['UZ', '06', 'Namangan Province'],
 ['UZ', '05', 'Xorazm'],
 ['UZ', '15', 'Jizzax'],
 ['UZ', '03', 'Fergana'],
 ['UZ', '01', 'Andijon'],
 ['VC', '05', 'Saint Patrick'],
 ['VC', '04', 'Saint George'],
 ['VC', '03', 'Saint David'],
 ['VC', '02', 'Saint Andrew'],
 ['VC', '06', 'Grenadines'],
 ['VC', '01', 'Charlotte'],
 ['VE', '23', 'Zulia'],
 ['VE', '22', 'Yaracuy'],
 ['VE', '21', 'Trujillo'],
 ['VE', '20', 'T\xc3\xa1chira'],
 ['VE', '19', 'Sucre'],
 ['VE', '18', 'Portuguesa'],
 ['VE', '17', 'Nueva Esparta'],
 ['VE', '16', 'Monagas'],
 ['VE', '15', 'Miranda'],
 ['VE', '14', 'M\xc3\xa9rida'],
 ['VE', '13', 'Lara'],
 ['VE', '12', 'Gu\xc3\xa1rico'],
 ['VE', '24', 'Dependencias Federales'],
 ['VE', '25', 'Distrito Capital'],
 ['VE', '11', 'Falc\xc3\xb3n'],
 ['VE', '09', 'Delta Amacuro'],
 ['VE', '08', 'Cojedes'],
 ['VE', '07', 'Carabobo'],
 ['VE', '06', 'Bol\xc3\xadvar'],
 ['VE', '05', 'Barinas'],
 ['VE', '04', 'Aragua'],
 ['VE', '03', 'Apure'],
 ['VE', '02', 'Anzo\xc3\xa1tegui'],
 ['VE', '01', 'Amazonas'],
 ['VE', '26', 'Vargas'],
 ['VI', '010', 'Saint Croix Island'],
 ['VI', '020', 'Saint John Island'],
 ['VI', '030', 'Saint Thomas Island'],
 ['VN', '58', 'Ngh\xe1\xbb\x87 An'],
 ['VN', '59', 'Ninh B\xc3\xacnh'],
 ['VN', '60', 'Ninh Thu\xe1\xba\xadn'],
 ['VN', '65', 'S\xc3\xb3c Tr\xc4\x83ng'],
 ['VN', '67', 'Tr\xc3\xa0 Vinh'],
 ['VN', '68', 'Tuy\xc3\xaan Quang'],
 ['VN', '69', 'V\xc4\xa9nh Long'],
 ['VN', '70', 'Y\xc3\xaan B\xc3\xa1i'],
 ['VN', '90', 'L\xc3\xa0o Cai'],
 ['VN', '37', 'Ti\xe1\xbb\x81n Giang'],
 ['VN', '66', 'Th\xe1\xbb\xaba Thi\xc3\xaan-Hu\xe1\xba\xbf'],
 ['VN', '55', 'Kon Tum'],
 ['VN', '34', 'Thanh H\xc3\xb3a'],
 ['VN', '35', 'Th\xc3\xa1i B\xc3\xacnh'],
 ['VN', '33', 'T\xc3\xa2y Ninh'],
 ['VN', '32', 'S\xc6\xa1n La'],
 ['VN', '64', 'Qu\xe1\xba\xa3ng Tr\xe1\xbb\x8b'],
 ['VN', '30', 'Qu\xe1\xba\xa3ng Ninh'],
 ['VN', '63', 'Qu\xe1\xba\xa3ng Ng\xc3\xa3i'],
 ['VN', '62', 'Qu\xe1\xba\xa3ng B\xc3\xacnh'],
 ['VN', '61', 'Ph\xc3\xba Y\xc3\xaan'],
 ['VN', '53', 'H\xc3\xb2a B\xc3\xacnh'],
 ['VN', '24', 'Long An'],
 ['VN', '39', 'L\xe1\xba\xa1ng S\xc6\xa1n'],
 ['VN', '23', 'L\xc3\xa2m \xc3\x90\xe1\xbb\x93ng'],
 ['VN', '89', 'Lai Ch\xc3\xa2u'],
 ['VN', '21', 'Ki\xe1\xba\xbfn Giang'],
 ['VN', '54', 'Kh\xc3\xa1nh H\xc3\xb2a'],
 ['VN', '20', 'H\xe1\xbb\x93 Ch\xc3\xad Minh'],
 ['VN', '52', 'H\xc3\xa0 T\xc4\xa9nh'],
 ['VN', '51', 'H\xc3\xa0 T\xc3\xa2y'],
 ['VN', '50', 'H\xc3\xa0 Giang'],
 ['VN', '49', 'Gia Lai'],
 ['VN', '44', 'Ha N\xe1\xbb\x99i'],
 ['VN', '87', 'C\xe1\xba\xa7n Th\xc6\xa1'],
 ['VN', '13', 'H\xe1\xba\xa3i Ph\xc3\xb2ng'],
 ['VN', '47', 'B\xc3\xacnh Thu\xe1\xba\xadn'],
 ['VN', '09', '\xc3\x90\xe1\xbb\x93ng Th\xc3\xa1p'],
 ['VN', '43', '\xc3\x90\xe1\xbb\x93ng Nai'],
 ['VN', '88', '\xc3\x90\xe1\xba\xafc L\xe1\xba\xafk'],
 ['VN', '45', 'B\xc3\xa0 R\xe1\xbb\x8ba-V\xc5\xa9ng T\xc3\xa0u'],
 ['VN', '05', 'Cao B\xe1\xba\xb1ng'],
 ['VN', '46', 'B\xc3\xacnh \xc3\x90\xe1\xbb\x8bnh'],
 ['VN', '03', 'B\xe1\xba\xbfn Tre'],
 ['VN', '01', 'An Giang'],
 ['VN', '91', '\xc3\x90\xe1\xba\xafk N\xc3\xb4ng'],
 ['VN', '92', 'Huy\xe1\xbb\x87n \xc3\x90i\xe1\xbb\x87n Bi\xc3\xaan'],
 ['VN', '74', 'B\xe1\xba\xafc Ninh'],
 ['VN', '71', 'B\xe1\xba\xafc Giang'],
 ['VN', '78', '\xc3\x90\xc3\xa0 N\xe1\xba\xb5ng'],
 ['VN', '75', 'B\xc3\xacnh D\xc6\xb0\xc6\xa1ng'],
 ['VN', '76', 'B\xc3\xacnh Ph\xc6\xb0\xe1\xbb\x9bc'],
 ['VN', '85', 'Th\xc3\xa1i Nguy\xc3\xaan'],
 ['VN', '84', 'Qu\xe1\xba\xa3ng Nam'],
 ['VN', '83', 'Ph\xc3\xba Th\xe1\xbb\x8d'],
 ['VN', '82', 'Nam \xc3\x90\xe1\xbb\x8bnh'],
 ['VN', '80', 'H\xc3\xa0 Nam'],
 ['VN', '72', 'B\xe1\xba\xafc K\xe1\xba\xa1n'],
 ['VN', '73', 'B\xe1\xba\xa1c Li\xc3\xaau'],
 ['VN', '77', 'C\xc3\xa0 Mau'],
 ['VN', '79', 'H\xe1\xba\xa3i D\xc6\xb0\xc6\xa1ng'],
 ['VN', '81', 'H\xc6\xb0ng Y\xc3\xaan'],
 ['VN', '86', 'V\xc4\xa9nh Ph\xc3\xbac'],
 ['VN', '93', 'Hau Giang'],
 ['VU', '15', 'Tafea'],
 ['VU', '13', 'Sanma'],
 ['VU', '07', 'Torba'],
 ['VU', '16', 'Malampa'],
 ['VU', '17', 'Penama'],
 ['VU', '18', 'Shefa'],
 ['WF', '98613', "Circonscription d'Uv\xc3\xa9a"],
 ['WF', '98612', 'Circonscription de Sigav\xc3\xa9'],
 ['WF', '98611', "Circonscription d'Alo"],
 ['WS', '11', 'Vaisigano'],
 ['WS', '06', 'Va`a-o-Fonoti'],
 ['WS', '10', 'Tuamasaga'],
 ['WS', '09', 'Satupa`itea'],
 ['WS', '08', 'Palauli'],
 ['WS', '07', 'Gagaifomauga'],
 ['WS', '05', 'Gaga`emauga'],
 ['WS', '04', 'Fa`asaleleaga'],
 ['WS', '03', 'Atua'],
 ['WS', '02', 'Aiga-i-le-Tai'],
 ['WS', '01', "A'ana"],
 ['XK', '28', 'Op\xc5\xa1tina Vu\xc4\x8ditrn'],
 ['XK', '27', 'Komuna e Vitis\xc3\xab'],
 ['XK', '03', 'Komuna e Ferizajt'],
 ['XK', '15', 'Komuna e Mitrovic\xc3\xabs'],
 ['XK', '26', 'Komuna e Th\xc3\xabrand\xc3\xabs'],
 ['XK', '25', 'Komuna e Skenderajt'],
 ['XK', '21', 'Komuna e Prizrenit'],
 ['XK', '20', 'Komuna e Prishtin\xc3\xabs'],
 ['XK', '19', 'Op\xc5\xa1tina Podujevo'],
 ['XK', '18', 'Komuna e Pej\xc3\xabs'],
 ['XK', '22', 'Komuna e Rahovecit'],
 ['XK', '13', 'Komuna e Lipjanit'],
 ['XK', '12', 'Komuna e Leposaviqit'],
 ['XK', '10', 'Op\xc5\xa1tina Kamenica'],
 ['XK', '11', 'Op\xc5\xa1tina Klina'],
 ['XK', '09', 'Komuna e Ka\xc3\xa7anikut'],
 ['XK', '08', 'Komuna e Istogut'],
 ['XK', '06', 'Komuna e Gjilanit'],
 ['XK', '07', 'Komuna e Drenasit'],
 ['XK', '02', 'Komuna e Dragashit'],
 ['XK', '01', 'Komuna e De\xc3\xa7anit'],
 ['XK', '05', 'Komuna e Gjakov\xc3\xabs'],
 ['XK', '04', 'Op\xc5\xa1tina Kosovo Polje'],
 ['XK', '23', 'Op\xc5\xa1tina \xc5\xa0trpce'],
 ['XK', '24', 'Komuna e Shtimes'],
 ['XK', '16', 'Op\xc5\xa1tina Novo Brdo'],
 ['XK', '17', 'Komuna e Obiliqit'],
 ['XK', '14', 'Komuna e Malisheves'],
 ['XK', '29', 'Komuna e Zubin Potokut'],
 ['XK', '30', 'Op\xc5\xa1tina Zve\xc4\x8dan'],
 ['XK', '31', 'Komuna e Gra\xc3\xa7anic\xc3\xabs'],
 ['XK', '32', 'Komuna e Hanit t\xc3\xab Elezit'],
 ['XK', '33', 'Komuna e Junikut'],
 ['XK', '34', 'Komuna e Kllokotit'],
 ['XK', '35', 'Komuna e Mamush\xc3\xabs'],
 ['XK', '36', 'Komuna e Parteshit'],
 ['XK', '37', 'Komuna e Ranillugut'],
 ['YE', '25', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at Ta\xe2\x80\x98izz'],
 ['YE', '05', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at Shabwah'],
 ['YE', '16', 'Sanaa'],
 ['YE', '15', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at \xc5\x9ea\xe2\x80\x98dah'],
 ['YE', '27', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at Raymah'],
 ['YE', '14', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at Ma\xe2\x80\x99rib'],
 ['YE', '10', 'Al Ma\xe1\xb8\xa9w\xc4\xabt'],
 ['YE', '21', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at al Jawf'],
 ['YE', '04', '\xe1\xb8\xa8a\xe1\xb8\x91ramawt'],
 ['YE', '11', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at Dham\xc4\x81r'],
 ['YE', '03', 'Al Mahrah'],
 ['YE', '08', 'Al \xe1\xb8\xa8udaydah'],
 ['YE', '20', 'Al Bay\xe1\xb8\x91\xc4\x81\xca\xbc'],
 ['YE', '02', 'Aden'],
 ['YE', '01', 'Abyan'],
 ['YE',
  '18',
  'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at a\xe1\xb8\x91 \xe1\xb8\x90\xc4\x81li\xe2\x80\x98'],
 ['YE', '19', 'Omran'],
 ['YE', '22', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at \xe1\xb8\xa8ajjah'],
 ['YE', '23', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at Ibb'],
 ['YE', '24', 'Mu\xe1\xb8\xa9\xc4\x81faz\xcc\xa7at La\xe1\xb8\xa9ij'],
 ['YE', '26', 'Amanat Al Asimah'],
 ['YT', '97601', 'Acoua'],
 ['YT', '97602', 'Bandraboua'],
 ['YT', '97603', 'Bandrele'],
 ['YT', '97604', 'Bou\xc3\xa9ni'],
 ['YT', '97605', 'Chiconi'],
 ['YT', '97606', 'Chirongui'],
 ['YT', '97607', 'Dembeni'],
 ['YT', '97608', 'Dzaoudzi'],
 ['YT', '97609', 'Kani-K\xc3\xa9li'],
 ['YT', '97610', 'Koungou'],
 ['YT', '97611', 'Mamoudzou'],
 ['YT', '97612', 'Mtsamboro'],
 ['YT', '97613', "M'Tsangamouji"],
 ['YT', '97614', 'Ouangani'],
 ['YT', '97615', 'Pamandzi'],
 ['YT', '97616', 'Sada'],
 ['YT', '97617', 'Tsingoni'],
 ['ZA', '03', 'Free State'],
 ['ZA', '02', 'KwaZulu-Natal'],
 ['ZA', '05', 'Eastern Cape'],
 ['ZA', '06', 'Gauteng'],
 ['ZA', '07', 'Mpumalanga'],
 ['ZA', '08', 'Northern Cape'],
 ['ZA', '09', 'Limpopo'],
 ['ZA', '10', 'North-West'],
 ['ZA', '11', 'Western Cape'],
 ['ZM', '01', 'Western'],
 ['ZM', '07', 'Southern'],
 ['ZM', '06', 'North-Western'],
 ['ZM', '05', 'Northern'],
 ['ZM', '09', 'Lusaka'],
 ['ZM', '04', 'Luapula'],
 ['ZM', '03', 'Eastern'],
 ['ZM', '08', 'Copperbelt'],
 ['ZM', '02', 'Central'],
 # https://jira.bikalabs.com/browse/HEALTH-364
 ['ZW', '01', 'Manicaland'],
 ['ZW', '02', 'Midlands'],
 ['ZW', '03', 'Mashonaland Central'],
 ['ZW', '04', 'Mashonaland East'],
 ['ZW', '05', 'Mashonaland West'],
 ['ZW', '06', 'Matabeleland North'],
 ['ZW', '07', 'Matabeleland South'],
 ['ZW', '08', 'Masvingo'],
 ['ZW', '09', 'Bulawayo'],
 ['ZW', '10', 'Harare'],
]

DISTRICTS = [
 ['AF', '08', 'G\xc4\x93l\xc4\x81n'],
 ['AF', '01', 'Arghanj Khw\xc4\x81h'],
 ['AF', '01', 'Arg\xc5\x8d'],
 ['AF', '01', 'Bah\xc4\x81rak'],
 ['AF', '01', 'Dar\xc4\x81yim'],
 ['AF', '01', 'Darw\xc4\x81z-e B\xc4\x81l\xc4\x81'],
 ['AF', '01', 'Darw\xc4\x81z-e P\xc4\x81\xe2\x80\x99\xc4\xabn'],
 ['AF', '01', 'Fa\xc4\xab\xe1\xba\x95\xc4\x81b\xc4\x81d'],
 ['AF', '01', 'Ishk\xc4\x81shim'],
 ['AF', '01', 'Jurm'],
 ['AF', '01', 'Kh\xc4\x81sh'],
 ['AF', '01', 'Khw\xc4\x81h\xc4\x81n'],
 ['AF', '01', 'Kir\xc4\x81n wa Munj\xc4\x81n'],
 ['AF', '01', 'Kishim'],
 ['AF', '01', 'K\xc5\x8dhist\xc4\x81n'],
 ['AF', '01', 'K\xc5\xabf \xc4\x80b'],
 ['AF', '01', 'R\xc4\x81ghist\xc4\x81n'],
 ['AF', '01', 'Shahr-e Buzurg'],
 ['AF', '01', 'Shighn\xc4\x81n'],
 ['AF', '01', 'Shik\xc4\xab'],
 ['AF', '01', 'Shuhad\xc4\x81'],
 ['AF', '01', 'Tag\xc4\x81b'],
 ['AF', '01', 'Tashk\xc4\x81n'],
 ['AF', '01', 'W\xc4\x81kh\xc4\x81n'],
 ['AF', '01', 'Ward\xc5\xabj'],
 ['AF', '01', 'Yaftal-e Sufl\xc3\xa1'],
 ['AF', '01', 'Yamg\xc4\x81n'],
 ['AF', '01', 'Y\xc4\x81w\xc4\x81n'],
 ['AF', '01', 'Zayb\xc4\x81k'],
 ['AF', '02', '\xc4\x80b-e Kamar\xc4\xab'],
 ['AF', '02', 'Gh\xc5\x8drm\xc4\x81ch'],
 ['AF', '02', 'Jowand'],
 ['AF', '02', 'Muqur'],
 ['AF', '02', 'Murgh\xc4\x81b'],
 ['AF', '02', 'Q\xc4\x81dis'],
 ['AF', '02', 'Qal\xe2\x80\x98ah-ye Now'],
 ['AF', '03', 'Andar\xc4\x81b'],
 ['AF', '03', 'Baghl\xc4\x81n-e Jad\xc4\xabd'],
 ['AF', '03', 'B\xc5\xabrkah'],
 ['AF', '03', 'Dahanah-ye Gh\xc5\x8dr\xc4\xab'],
 ['AF', '03', 'Deh-e \xc5\x9eal\xc4\x81\xe1\xb8\xa9'],
 ['AF', '03', 'D\xc5\x8dsh\xc4\xab'],
 ['AF', '03', 'Firing wa Gh\xc4\x81r\xc5\xab'],
 ['AF', '03', 'Guz\xcc\x84arg\xc4\x81h-e N\xc5\xabr'],
 ['AF', '03', 'Khinj\xc4\x81n'],
 ['AF', '03', 'Kh\xc5\x8dst wa Firing'],
 ['AF', '03', 'Khw\xc4\x81jah Hijr\xc4\x81n'],
 ['AF', '03', 'Nahr\xc4\xabn'],
 ['AF', '03', 'Pul-e \xe1\xb8\xa8i\xc5\x9f\xc4\x81r'],
 ['AF', '03', 'T\xc4\x81lah wa Barfak'],
 ['AF', '05', 'Kahmard'],
 ['AF', '05', 'Panj\xc4\x81b'],
 ['AF', '05', 'Saygh\xc4\x81n'],
 ['AF', '05', 'Shaybar'],
 ['AF', '05', 'Waras\xcc\x84'],
 ['AF', '05', 'Yak\xc4\x81wlang'],
 ['AF', '06', 'An\xc4\x81r Darah'],
 ['AF', '06', 'Bakw\xc4\x81h'],
 ['AF', '06', 'B\xc4\x81l\xc4\x81 Bul\xc5\xabk'],
 ['AF', '06', 'Gulist\xc4\x81n'],
 ['AF', '06', 'Kh\xc4\x81k-e Saf\xc4\x93d'],
 ['AF', '06', 'L\xc4\x81sh-e Juwayn'],
 ['AF', '06', 'Pur Chaman'],
 ['AF', '06', 'Pusht-e R\xc5\x8dd'],
 ['AF', '06', 'Qal\xe2\x80\x98ah-ye K\xc4\x81h'],
 ['AF', '06', 'Shayb K\xc5\x8dh'],
 ['AF', '07', 'Kh\xc4\x81n-e Chah\xc4\x81r B\xc4\x81gh'],
 ['AF', '07', 'Alm\xc4\x81r'],
 ['AF', '07', 'Andkh\xc5\x8dy'],
 ['AF', '07', 'Bal Chir\xc4\x81gh'],
 ['AF', '07', 'Dowlat\xc4\x81b\xc4\x81d'],
 ['AF', '07', 'Gurz\xc4\xabw\xc4\x81n'],
 ['AF', '07', 'Khw\xc4\x81jah Sabz P\xc5\x8dsh'],
 ['AF', '07', 'K\xc5\x8dhist\xc4\x81n'],
 ['AF', '07', 'Ma\xc4\xabmanah'],
 ['AF', '07', 'Pas\xcc\xb2h\xcc\xb2t\xc5\xabn K\xc5\x8d\xe1\xb9\xaf'],
 ['AF', '07', 'Qa\xc4\xab\xc5\x9f\xc4\x81r'],
 ['AF', '07', 'Qaram Q\xc5\x8dl'],
 ['AF', '07', 'Qurgh\xc4\x81n'],
 ['AF', '07', 'Sh\xc4\xabr\xc4\xabn Tag\xc4\x81b'],
 ['AF', '08', '\xc4\x80b Band'],
 ['AF', '08', 'Ajrist\xc4\x81n'],
 ['AF', '08', 'Anda\xe1\xb9\x9f'],
 ['AF', '08', 'Bahr\xc4\x81m-e Shah\xc4\xabd'],
 ['AF', '08', 'Deh Yak'],
 ['AF', '08', 'Ghazn\xc4\xab'],
 ['AF', '08', 'G\xc4\xabr\xc5\x8d'],
 ['AF', '08', 'J\xc4\x81gh\xc5\xabr\xc4\xab'],
 ['AF', '08', 'Khw\xc4\x81jah \xe2\x80\x98Omar\xc4\xab'],
 ['AF', '08', 'M\xc4\x81list\xc4\x81n'],
 ['AF', '08', 'Muq\xc3\xaar'],
 ['AF', '08', 'N\xc4\x81wah'],
 ['AF', '08', 'N\xc4\x81wur'],
 ['AF', '08', 'Qarah B\xc4\x81gh'],
 ['AF', '08', 'Rash\xc4\xabd\xc4\x81n'],
 ['AF', '08', 'W\xc4\x81ghaz\xcc\xa7'],
 ['AF',
  '08',
  'Wal\xc4\xab Mu\xe1\xb8\xa9ammad Shah\xc4\xabd Kh\xc5\xabgy\xc4\x81\xe1\xb9\x89\xc4\xab'],
 ['AF', '08', 'Zanakh\xc4\x81n'],
 ['AF', '09', 'Chaghchar\xc4\x81n'],
 ['AF', '09', 'Chah\xc4\x81r \xc5\x9eadah'],
 ['AF', '09', 'D\xc5\xab La\xc4\xabnah'],
 ['AF', '09', 'Dowlaty\xc4\x81r'],
 ['AF', '09', 'La\xe2\x80\x98l wa Sar Jangal'],
 ['AF', '09', 'Pas\xc4\x81band'],
 ['AF', '09', 'S\xc4\x81ghar'],
 ['AF', '09', 'Shahrak'],
 ['AF', '09', 'Taywarah'],
 ['AF', '09', 'T\xc5\xablak'],
 ['AF', '10', 'B\xc4\x81ghr\xc4\x81n'],
 ['AF', '10', 'D\xc4\xabsh\xc5\xab'],
 ['AF', '10', 'Garm S\xc4\x93r'],
 ['AF', '10', 'Kajak\xc4\xab'],
 ['AF', '10', 'Lashkar G\xc4\x81h'],
 ['AF', '10', 'M\xc5\xabs\xc3\xa1 Qal\xe2\x80\x98ah'],
 ['AF', '10', 'N\xc4\x81d \xe2\x80\x98Al\xc4\xab'],
 ['AF', '10', 'Nahr-e Sar\xc4\x81j'],
 ['AF', '10', 'N\xc4\x81wah-ye B\xc4\x81rakza\xc4\xab'],
 ['AF', '10', 'Now Z\xc4\x81d'],
 ['AF', '10', 'R\xc4\x93g-e Kh\xc4\x81n Nesh\xc4\xabn'],
 ['AF', '10', 'Sang\xc4\xabn'],
 ['AF', '10', 'W\xc4\x81sh\xc4\x93r'],
 ['AF', '11', 'Adraskan'],
 ['AF', '11', 'Chisht-e Shar\xc4\xabf'],
 ['AF', '11', 'Fars\xc4\xab'],
 ['AF', '11', 'Gh\xc5\x8driy\xc4\x81n'],
 ['AF', '11', 'Gulr\xc4\x81n'],
 ['AF', '11', 'Inj\xc4\xabl'],
 ['AF', '11', 'Karukh'],
 ['AF', '11', 'Kuhs\xc4\x81n'],
 ['AF', '11', 'Kushk'],
 ['AF', '11', 'Kushk-e Kuhnah'],
 ['AF', '11', 'Guz\xcc\x84arah'],
 ['AF', '11', '\xc5\x8cb\xc3\xaah'],
 ['AF', '11', 'Pas\xcc\xb2h\xcc\xb2t\xc5\xabn Zargh\xc5\xabn'],
 ['AF', '11', 'Sh\xc4\xabn\xe1\xb8\x8fan\xe1\xb8\x8f'],
 ['AF', '11', 'Zindah J\xc4\x81n'],
 ['AF', '13', 'Bagr\xc4\x81m\xc4\xab'],
 ['AF', '13', 'Chah\xc4\x81r \xc4\x80sy\xc4\x81b'],
 ['AF', '13', 'Deh-e Sabz'],
 ['AF', '13', 'Farzah'],
 ['AF', '13', 'Gul Darah'],
 ['AF', '13', 'Ist\xc4\x81lif'],
 ['AF', '13', 'Kalak\xc4\x81n'],
 ['AF', '13', 'Kh\xc4\x81k-e Jab\xc4\x81r'],
 ['AF', '13', 'M\xc4\xabr Bachah K\xc5\x8d\xe1\xb9\xaf'],
 ['AF', '13', 'M\xc5\xabsah\xc4\xab'],
 ['AF', '13', 'Paghm\xc4\x81n'],
 ['AF', '13', 'Qarah B\xc4\x81gh'],
 ['AF', '13', 'Sa\xe1\xb9\x9f\xc5\x8db\xc4\xab'],
 ['AF', '13', 'Shakar Darah'],
 ['AF', '14', 'Alah S\xc4\x81y'],
 ['AF', '14', '\xe1\xb8\xa8i\xc5\x9fah-ye Awal-e K\xc5\x8dhist\xc4\x81n'],
 ['AF', '14', '\xe1\xb8\xa8i\xc5\x9fah-ye Duwum-e K\xc5\x8dhist\xc4\x81n'],
 ['AF', '14', 'K\xc5\x8dh Band'],
 ['AF', '14', 'Ma\xe1\xb8\xa9m\xc5\xabd-e R\xc4\x81q\xc4\xab'],
 ['AF', '14', 'Nijr\xc4\x81b'],
 ['AF', '14', 'Tag\xc4\x81b'],
 ['AF', '23', 'Sh\xc4\x81h Wal\xc4\xab K\xc5\x8d\xe1\xb9\xaf'],
 ['AF', '17', 'Azrah'],
 ['AF', '17', 'Barak\xc4\xab Barak'],
 ['AF', '17', 'Charkh'],
 ['AF', '17', 'Kharw\xc4\x81r'],
 ['AF', '17', 'Kh\xc5\x8dsh\xc4\xab'],
 ['AF', '17', 'Mu\xe1\xb8\xa9ammad \xc4\x80ghah'],
 ['AF', '17', 'Pul-e \xe2\x80\x98Alam'],
 ['AF', '18', 'Ach\xc4\xabn'],
 ['AF', '18', 'Bat\xc4\xab K\xc5\x8d\xe1\xb9\xaf'],
 ['AF', '18', 'Bihs\xc5\xabd'],
 ['AF', '18', 'Chaparh\xc4\x81r'],
 ['AF', '18', 'Darah-ye N\xc5\xabr'],
 ['AF', '18', 'Deh B\xc4\x81l\xc4\x81'],
 ['AF', '18', 'Dur B\xc4\x81b\xc4\x81'],
 ['AF', '18', 'G\xc5\x8dshtah'],
 ['AF', '18', '\xe1\xb8\xa8i\xc5\x9f\xc4\x81rak'],
 ['AF', '18', 'Jal\xc4\x81l\xc4\x81b\xc4\x81d'],
 ['AF', '18', 'K\xc4\x81mah'],
 ['AF', '18', 'Kh\xc5\xabgy\xc4\x81\xe1\xb9\x89\xc4\xab'],
 ['AF', '18', 'K\xc5\x8d\xe1\xb9\xaf'],
 ['AF', '18', 'K\xc5\xabz Kuna\xe1\xb9\x9f'],
 ['AF', '18', 'La\xe2\x80\x98lp\xc5\xabr'],
 ['AF', '18', 'Mohmand Darah'],
 ['AF', '18', 'N\xc4\x81ziy\xc4\x81n'],
 ['AF', '18', 'Pach\xc4\xabr wa \xc4\x80g\xc4\x81m'],
 ['AF', '18', 'R\xc5\x8dd\xc4\x81t'],
 ['AF', '18', 'Sh\xc4\x93rz\xc4\x81d'],
 ['AF', '18', 'Sh\xc4\xabnw\xc4\x81r'],
 ['AF', '18', 'Surkh R\xc5\x8dd'],
 ['AF', '19', 'Chah\xc4\x81r Burjak'],
 ['AF', '19', 'Kang'],
 ['AF', '19', 'Kh\xc4\x81sh R\xc5\x8dd'],
 ['AF', '19', 'Zaranj'],
 ['AF', '23', 'Arghand\xc4\x81b'],
 ['AF', '23', 'Arghist\xc4\x81n'],
 ['AF', '23', 'D\xc4\x81m\xc4\x81n'],
 ['AF', '23', 'Gh\xc5\x8drak'],
 ['AF', '23', 'Kh\xc4\x81kr\xc4\x93z'],
 ['AF', '23', 'Ma\xe2\x80\x98r\xc5\xabf'],
 ['AF', '23', 'Maywand'],
 ['AF', '23', 'My\xc4\x81 Nesh\xc4\xabn'],
 ['AF', '23', 'N\xc4\x93sh'],
 ['AF', '23', 'Panjw\xc4\x81\xe2\x80\x99\xc4\xab'],
 ['AF', '23', 'R\xc4\x93gist\xc4\x81n'],
 ['AF', '23', 'Sh\xc5\x8dr\xc4\x81bak'],
 ['AF', '23', 'Sp\xc4\xabn B\xc5\x8dldak'],
 ['AF', '23', 'Zha\xe1\xb9\x9f\xc3\xaay'],
 ['AF', '24', '\xe2\x80\x98Al\xc4\xab\xc4\x81b\xc4\x81d'],
 ['AF', '24', 'Dasht-e Arch\xc4\xab'],
 ['AF', '24', 'Chah\xc4\x81r Darah'],
 ['AF', '24', 'Im\xc4\x81m \xc5\x9e\xc4\x81\xe1\xb8\xa9ib'],
 ['AF', '24', 'Kh\xc4\x81n\xc4\x81b\xc4\x81d'],
 ['AF', '24', 'Qal\xe2\x80\x98ah-ye Z\xc4\x81l'],
 ['AF', '26', 'Bah\xc4\x81rak'],
 ['AF', '26', 'Bang\xc4\xab'],
 ['AF', '26', 'Ch\xc4\x81h \xc4\x80b'],
 ['AF', '26', 'Ch\xc4\x81l'],
 ['AF', '26', 'Darqad'],
 ['AF', '26', 'Dasht-e Qal\xe2\x80\x98ah'],
 ['AF', '26', 'Farkh\xc4\x81r'],
 ['AF', '26', 'Haz\xc4\x81r Sum\xc5\xabch'],
 ['AF', '26', 'Ishkamish'],
 ['AF', '26', 'Kalafg\xc4\x81n'],
 ['AF', '26', 'Khw\xc4\x81jah Bah\xc4\x81wudd\xc4\xabn'],
 ['AF', '26', 'Khw\xc4\x81jah Gh\xc4\x81r'],
 ['AF', '26', 'Namak \xc4\x80b'],
 ['AF', '26', 'Rust\xc4\x81q'],
 ['AF', '26', 'T\xc4\x81luq\xc4\x81n'],
 ['AF', '26', 'Warsaj'],
 ['AF', '26', 'Yang\xc4\xab Qal\xe2\x80\x98ah'],
 ['AF', '27', 'Chak-e Wardak'],
 ['AF', '27', 'D\xc4\x81ym\xc4\xabrd\xc4\x81d'],
 ['AF', '27', '\xe1\xb8\xa8i\xc5\x9fah-ye Awal-e Bihs\xc5\xabd'],
 ['AF', '27', 'Jaghat\xc5\xab'],
 ['AF', '27', 'Jalrayz'],
 ['AF', '27', 'Ma\xc4\xabd\xc4\x81n Shahr'],
 ['AF', '27', 'Markaz-e Bihs\xc5\xabd'],
 ['AF', '27', 'N\xc3\xaarkh'],
 ['AF', '27', 'Sayyid\xc4\x81b\xc4\x81d'],
 ['AF', '28', 'Arghand\xc4\x81b'],
 ['AF', '28', 'A\xe1\xb9\xafghar'],
 ['AF', '28', 'D\xc4\x81ych\xc5\x8dp\xc4\x81n'],
 ['AF', '28', 'K\xc4\x81kar'],
 ['AF', '28', 'M\xc4\xabz\xc4\x81n'],
 ['AF', '28', 'Now Bah\xc4\x81r'],
 ['AF', '28', 'Sh\xc4\x81h J\xc5\x8dy'],
 ['AF', '28', 'Shamulza\xc4\xab'],
 ['AF', '28', 'Sh\xc4\xabnka\xc4\xab'],
 ['AF', '28', 'Tarn\xc3\xaak wa Jaldak'],
 ['AF', '29', 'B\xc3\xaarmal'],
 ['AF', '29', '\xe1\xb8\x8e\xc4\xablah'],
 ['AF', '29', 'Giy\xc4\x81n'],
 ['AF', '29', 'G\xc5\x8dmal'],
 ['AF', '29', 'J\xc4\x81n\xc4\xab Kh\xc4\x93l'],
 ['AF', '29', 'Mut\xc4\x81 Kh\xc4\x81n'],
 ['AF', '29', 'N\xc4\xabk\xc3\xaah'],
 ['AF', '29', '\xc5\x8cmnah'],
 ['AF', '29', 'Urg\xc5\xabn'],
 ['AF', '29', 'Sar Row\xe1\xba\x95ah'],
 ['AF', '29', 'Sa\xe1\xb9\x9f\xc5\x8db\xc4\xab'],
 ['AF', '29', 'Sharan'],
 ['AF', '29', 'T\xc3\xaarw\xc5\x8d'],
 ['AF', '29', 'W\xc4\x81zah Khw\xc4\x81h'],
 ['AF', '29', 'Wu\xe1\xb9\x9f Mamay'],
 ['AF', '29', 'Ya\xe1\xb8\xa9y\xc3\xa1 Kh\xc4\x93l'],
 ['AF', '29', 'Y\xc5\x8dsuf Kh\xc4\x93l'],
 ['AF', '29', 'Zargh\xc5\xabn Shahr'],
 ['AF', '29', 'Z\xc4\xab\xe1\xb9\x9f\xc5\xabk'],
 ['AF', '30', 'Chah\xc4\x81r B\xc5\x8dlak'],
 ['AF', '30', 'Chah\xc4\x81r Kent'],
 ['AF', '30', 'Chimt\xc4\x81l'],
 ['AF', '30', 'Dehd\xc4\x81d\xc4\xab'],
 ['AF', '30', 'Dowlat\xc4\x81b\xc4\x81d'],
 ['AF', '30', 'Kald\xc4\x81r'],
 ['AF', '30', 'Khulm'],
 ['AF', '30', 'Kishindeh'],
 ['AF', '30', 'M\xc4\x81rmul'],
 ['AF', '30', 'Nahr-e Sh\xc4\x81h\xc4\xab'],
 ['AF', '30', 'Shahrak-e \xe1\xb8\xa8a\xc4\xabrat\xc4\x81n'],
 ['AF', '30', 'Sh\xc5\x8dlgarah'],
 ['AF', '30', 'Sh\xc5\x8dr Tepah'],
 ['AF', '30', 'Z\xc4\x81r\xc4\xab'],
 ['AF', '31', '\xc4\x80qchah'],
 ['AF', '31', 'Darz\xc4\x81b'],
 ['AF', '31', 'Fa\xc4\xab\xe1\xba\x95\xc4\x81b\xc4\x81d'],
 ['AF', '31', 'Khamy\xc4\x81b'],
 ['AF', '31', 'Kh\xc4\x81naq\xc4\x81h'],
 ['AF', '31', 'Khw\xc4\x81jah D\xc5\xab K\xc5\x8dh'],
 ['AF', '31', 'Mard\xc4\xab\xc4\x81n'],
 ['AF', '31', 'Mingajik'],
 ['AF', '31', 'Qarq\xc4\xabn'],
 ['AF', '31', 'Q\xc5\xabsh Tepah'],
 ['AF', '31', 'Shibirgh\xc4\x81n'],
 ['AF', '32', 'A\xc4\xabbak'],
 ['AF', '32', 'Darah-ye \xc5\x9e\xc5\xabf-e B\xc4\x81l\xc4\x81'],
 ['AF', '32', 'Darah-ye \xc5\x9e\xc5\xabf-e P\xc4\x81\xe2\x80\x99\xc4\xabn'],
 ['AF', '32', 'Fayr\xc5\x8dz Nakhch\xc4\xabr'],
 ['AF', '32', '\xe1\xb8\xa8a\xe1\xba\x95rat-e Sul\xc5\xa3\xc4\x81n'],
 ['AF', '32', 'Khuram wa S\xc4\x81r B\xc4\x81gh'],
 ['AF', '32', 'R\xc5\xaby D\xc5\xab\xc4\x81b'],
 ['AF', '33', 'Balkh\xc4\x81b'],
 ['AF', '33', 'G\xc5\x8dsfand\xc4\xab'],
 ['AF', '33', 'K\xc5\x8dhist\xc4\x81n\xc4\x81t'],
 ['AF', '33', 'Sangch\xc4\x81rak'],
 ['AF', '33', 'Sar-e Pul'],
 ['AF', '33', '\xc5\x9eay\xc4\x81d'],
 ['AF', '33', 'S\xc5\x8dzmah Qal\xe2\x80\x98ah'],
 ['AF', '34', 'Asad\xc4\x81b\xc4\x81d'],
 ['AF', '34', 'Bar Kuna\xe1\xb9\x9f'],
 ['AF', '34', 'Chapah Darah'],
 ['AF', '34', 'Tsowk\xc3\xaay'],
 ['AF', '34', 'D\xc4\x81ng\xc4\x81m'],
 ['AF', '34', 'Darah-ye P\xc4\x93ch'],
 ['AF', '34', 'Gh\xc4\x81z\xc4\xab\xc4\x81b\xc4\x81d'],
 ['AF', '34', 'Kh\xc4\x81\xc5\x9f Kuna\xe1\xb9\x9f'],
 ['AF', '34', 'Marawarah'],
 ['AF', '34', 'Narang'],
 ['AF', '34', 'N\xc4\x81\xe1\xb9\x9fay'],
 ['AF', '34', 'N\xc5\xabrgal'],
 ['AF', '34', 'Sar K\xc4\x81\xe1\xb9\x89\xc4\xab'],
 ['AF', '34', 'Sh\xc4\xabgal wa Sh\xc3\xaaltan'],
 ['AF', '34', 'Wu\xe1\xb9\xafahp\xc5\xabr'],
 ['AF', '35', '\xe2\x80\x98Al\xc4\xabng\xc4\x81r'],
 ['AF', '35', '\xe2\x80\x98Al\xc4\xabsheng'],
 ['AF', '35', 'Dowlat Sh\xc4\x81h'],
 ['AF', '35', 'Mehtar L\xc4\x81m'],
 ['AF', '35', 'Qarghah\xe2\x80\x99\xc4\xab'],
 ['AF', '36', 'A\xe1\xb8\xa9mad\xc4\x81b\xc4\x81d'],
 ['AF', '36', 'Tsamkan\xc4\xab'],
 ['AF', '36', '\xe1\xb8\x8ean\xe1\xb8\x8f Pa\xe1\xb9\xaf\xc4\x81n'],
 ['AF', '36', 'Gard\xc4\x93z'],
 ['AF', '36', 'J\xc4\x81j\xc4\xab'],
 ['AF', '36', 'J\xc4\x81n\xc4\xab Kh\xc4\x93l'],
 ['AF', '36', 'Lajah A\xe1\xb8\xa9mad Kh\xc4\x93l'],
 ['AF', '36', 'Sayyid Karam'],
 ['AF', '36', 'Shw\xc4\x81k'],
 ['AF', '36', 'Dzadr\xc4\x81n'],
 ['AF', '36', 'Zurmat'],
 ['AF', '37', 'B\xc4\x81k'],
 ['AF', '37', 'Gurbuz'],
 ['AF', '37', 'J\xc4\x81j\xc4\xab Ma\xc4\xabd\xc4\x81n'],
 ['AF', '37', 'Kh\xc5\x8dst'],
 ['AF', '37', 'Mand\xc5\xabza\xc4\xab'],
 ['AF', '37', 'M\xc5\xabs\xc3\xa1 Kh\xc4\x93l'],
 ['AF', '37', 'N\xc4\x81dir Sh\xc4\x81h K\xc5\x8d\xe1\xb9\xaf'],
 ['AF', '37', 'Qalandar'],
 ['AF', '37', '\xc5\x9eabar\xc4\xab'],
 ['AF', '37', 'Shamul'],
 ['AF', '37', 'Sp\xc4\x93rah'],
 ['AF', '37', 'Ta\xe1\xb9\x89a\xc4\xab'],
 ['AF', '37', 'T\xc3\xaarayza\xc4\xab'],
 ['AF', '38', 'Barg-e Mat\xc4\x81l'],
 ['AF', '38', 'D\xc5\xab \xc4\x80b'],
 ['AF', '38', 'K\xc4\x81md\xc4\x93sh'],
 ['AF', '38', 'Mand\xc5\x8dl'],
 ['AF', '38', 'N\xc5\xabrgar\xc4\x81m'],
 ['AF', '38', 'P\xc4\x81r\xc5\xabn'],
 ['AF', '38', 'W\xc4\x81m\xc4\x81'],
 ['AF', '38', 'W\xc4\x81ygal'],
 ['AF', '39', 'Ch\xc5\x8drah'],
 ['AF', '39', 'Deh R\xc4\x81wud'],
 ['AF', '39', 'Kh\xc4\x81\xc5\x9f Uruzg\xc4\x81n'],
 ['AF', '39', 'Shah\xc4\xabd-e \xe1\xb8\xa8as\xc4\x81s'],
 ['AF', '39', 'Tar\xc4\xabn K\xc5\x8d\xe1\xb9\xaf'],
 ['AF', '40', 'Bagr\xc4\x81m'],
 ['AF', '40', 'Ch\xc4\x81r\xc4\xabk\xc4\x81r'],
 ['AF', '40', 'Jabal us Sar\xc4\x81j'],
 ['AF', '40', 'K\xc5\x8dh-e \xc5\x9e\xc4\x81f\xc4\xab'],
 ['AF', '40', 'S\xc4\x81lang'],
 ['AF', '40', 'Sayyid Kh\xc4\x93l'],
 ['AF', '40', 'Shaykh \xe2\x80\x98Al\xc4\xab'],
 ['AF', '40', 'Sh\xc4\xabnw\xc4\x81r\xc4\xab'],
 ['AF', '40', 'Siy\xc4\x81hgird Gh\xc5\x8drband'],
 ['AF', '40', 'Surkh-e P\xc4\x81rs\xc4\x81'],
 ['AF', '41', 'Gayt\xc4\xab'],
 ['AF', '41', 'G\xc4\xabz\xc4\x81b'],
 ['AF', '41', 'Ishtarlay'],
 ['AF', '41', 'Kajr\xc4\x81n'],
 ['AF', '41', 'Khad\xc4\xabr'],
 ['AF', '41', 'M\xc4\xabr \xc4\x80m\xc5\x8dr'],
 ['AF', '41', 'N\xc4\xabl\xc4\xab'],
 ['AF', '41', 'Sang-e Takht'],
 ['AF', '41', 'Shahrist\xc4\x81n'],
 ['AF', '42', '\xe2\x80\x98Un\xc4\x81bah'],
 ['AF', '42', 'B\xc4\x81z\xc4\x81rak'],
 ['AF', '42', 'Darah'],
 ['AF', '42', 'Khinj'],
 ['AF', '42', 'Par\xc4\xab\xc4\x81n'],
 ['AF', '42', 'Rukhah'],
 ['AF', '42', 'Shutul'],
 ['AF', '35', 'Mihtarlam'],
 ['AF', '32', 'Dara-I-Suf'],
 ['AF', '24', 'Qala-I-Zal'],
 ['AF', '02', 'Qala-i-Naw'],
 ['AF', '01', 'Ragh'],
 ['AF', '13', 'Kabul'],
 ['AF', '14', 'Hisa-I-Awali Panjsher'],
 ['AF', '24', 'Kunduz'],
 ['AF', '23', 'Reg'],
 ['AF', '19', 'Chakhansur'],
 ['AF', '06', 'Farah'],
 ['AF', '05', 'Bamyan'],
 ['AF', '08', 'Bahrami Shahid'],
 ['AF', '03', 'Puli Khumri'],
 ['AF', '13', 'Surobi'],
 ['AF', '28', 'Qal\xc4\x81t'],
 ['AF', '09', 'Shahrak'],
 ['AF', '34', 'Chawkay'],
 ['AF', '01', 'Kuran Wa Munjan'],
 ['AF', '05', 'Shibar'],
 ['AF', '40', 'Surkhi Parsa'],
 ['AF', '18', 'Dih Bala'],
 ['AF', '10', 'Garms\xc4\xabr'],
 ['AF', '10', 'Nawa-i-Barakzayi'],
 ['AF', '30', 'Nahri Shahi'],
 ['AF', '30', 'Sholgara'],
 ['AF', '08', 'Dih Yak'],
 ['AF', '27', 'Day Mirdad'],
 ['AF', '35', 'Alishing'],
 ['AF', '24', 'Chahar Dara'],
 ['AF', '36', 'Tani'],
 ['AF', '17', 'Azra'],
 ['AF', '34', 'Sirkanay'],
 ['AF', '34', 'Marawara'],
 ['AF', '35', 'Qarghayi'],
 ['AF', '02', 'Kushk-e Kuhnah'],
 ['AF', '39', 'D\xc4\x81ykund\xc4\xab'],
 ['AF', '27', 'Markazi Bihsud'],
 ['AF', '27', 'Hisa-I-Awal Bihsud'],
 ['AF', '27', 'Nirkh'],
 ['AF', '23', 'Dand'],
 ['AF', '30', 'Maz\xc4\x81r-e Shar\xc4\xabf'],
 ['AL', '51', 'Rrethi i Sarand\xc3\xabs'],
 ['AL', '51', 'Rrethi i Delvin\xc3\xabs'],
 ['AL', '47', 'Rrethi i Tropoj\xc3\xabs'],
 ['AL', '40', 'Rrethi i Skraparit'],
 ['AL', '49', 'Rrethi i Puk\xc3\xabs'],
 ['AL', '46', 'Rrethi i Pogradecit'],
 ['AL', '45', 'Rrethi i P\xc3\xabrmetit'],
 ['AL', '48', 'Rrethi i Mirdit\xc3\xabs'],
 ['AL', '41', 'Rrethi i Matit'],
 ['AL', '43', 'Rrethi i Librazhdit'],
 ['AL', '47', 'Rrethi i Kuk\xc3\xabsit'],
 ['AL', '46', 'Rrethi i Kor\xc3\xa7\xc3\xabs'],
 ['AL', '46', 'Rrethi i Kolonj\xc3\xabs'],
 ['AL', '43', 'Rrethi i Gramshit'],
 ['AL', '45', 'Rrethi i Gjirokastr\xc3\xabs'],
 ['AL', '43', 'Rrethi i Elbasanit'],
 ['AL', '41', 'Rrethi i Dibr\xc3\xabs'],
 ['AL', '40', 'Rrethi i Beratit'],
 ['AL', '47', 'Rrethi i Hasit'],
 ['AL', '41', 'Rrethi i Bulqiz\xc3\xabs'],
 ['AL', '46', 'Rrethi i Devollit'],
 ['AL', '51', 'Rrethi i Vlor\xc3\xabs'],
 ['AL', '50', 'Rrethi i Tiran\xc3\xabs'],
 ['AL', '45', 'Rrethi i Tepelen\xc3\xabs'],
 ['AL', '49', 'Rrethi i Shkodr\xc3\xabs'],
 ['AL', '44', 'Rrethi i Lushnj\xc3\xabs'],
 ['AL', '48', 'Rrethi i Lezh\xc3\xabs'],
 ['AL', '42', 'Rrethi i Kruj\xc3\xabs'],
 ['AL', '44', 'Rrethi i Fierit'],
 ['AL', '42', 'Rrethi i Durr\xc3\xabsit'],
 ['AL', '50', 'Rrethi i Kavaj\xc3\xabs'],
 ['AL', '40', 'Rrethi i Ku\xc3\xa7ov\xc3\xabs'],
 ['AL', '48', 'Rrethi i Kurbinit'],
 ['AL', '44', 'Rrethi i Mallakastr\xc3\xabs'],
 ['AL', '49', 'Rrethi i Mal\xc3\xabsia e Madhe'],
 ['AL', '43', 'Rrethi i Peqinit'],
 ['AM', '08', 'Sisian'],
 ['AM', '10', "Vayk'i Shrjan"],
 ['AM', '11', 'Spandaryanskiy Rayon'],
 ['AM', '11', 'Arabkir'],
 ['AM', '11', 'Shaumyanskiy Rayon'],
 ['AM', '11', 'Ordzhonikidzevskiy Rayon'],
 ['AM', '04', 'Martuni'],
 ['AM', '11', 'Leninskiy Rayon'],
 ['AM', '11', 'Imeni Dvadtsati Shesti Komissarov Rayon'],
 ['AM', '01', 'Achtarak'],
 ['AO', '18', 'Munic\xc3\xadpio Saurimo'],
 ['AO', '17', 'Munic\xc3\xadpio Lucapa'],
 ['AO', '17', 'Munic\xc3\xadpio Chitato'],
 ['AO', '17', 'Munic\xc3\xadpio Cambulo'],
 ['AO', '14', 'Munic\xc3\xadpio Rivungo'],
 ['AO', '18', 'Munic\xc3\xadpio Muconda'],
 ['AO', '14', 'Munic\xc3\xadpio Moxico'],
 ['AO', '04', 'Munic\xc3\xadpio Mavinga'],
 ['AO', '14', 'Munic\xc3\xadpio Lumege'],
 ['AO', '14', 'Munic\xc3\xadpio Lumbala N\xe2\x80\x99guimbo'],
 ['AO', '14', 'Munic\xc3\xadpio Luau'],
 ['AO', '14', 'Munic\xc3\xadpio Luacano'],
 ['AO', '14', 'Munic\xc3\xadpio L\xc3\xa9ua'],
 ['AO', '04', 'Munic\xc3\xadpio Dirico'],
 ['AO', '18', 'Munic\xc3\xadpio Dala'],
 ['AO', '14', 'Munic\xc3\xadpio Camanongue'],
 ['AO', '14', 'Munic\xc3\xadpio Alto Zambeze'],
 ['AO', '17', 'Munic\xc3\xadpio X\xc3\xa1-Muteba'],
 ['AO', '20', 'Munic\xc3\xadpio Viana'],
 ['AO', '15', 'Uige Municipality'],
 ['AO', '16', 'Munic\xc3\xadpio Tomboco'],
 ['AO', '16', 'Munic\xc3\xadpio Soyo'],
 ['AO', '15', 'Munic\xc3\xadpio Songo'],
 ['AO', '15', 'Munic\xc3\xadpio Sanza Pombo'],
 ['AO', '15', 'Munic\xc3\xadpio Santa Cruz'],
 ['AO', '15', 'Quitexe Municipality'],
 ['AO', '15', 'Munic\xc3\xadpio Quimbele'],
 ['AO', '05', 'Munic\xc3\xadpio Quiculungo'],
 ['AO', '19', 'Munic\xc3\xadpio Quicama'],
 ['AO', '12', 'Munic\xc3\xadpio Quela'],
 ['AO', '15', 'Munic\xc3\xadpio Puri'],
 ['AO', '19', 'Munic\xc3\xadpio Pango Aluqu\xc3\xa9m'],
 ['AO', '16', 'Munic\xc3\xadpio N\xe2\x80\x99zeto'],
 ['AO', '16', 'Munic\xc3\xadpio N\xc3\xb3qui'],
 ['AO', '15', 'Negage Municipality'],
 ['AO', '19', 'Nambuangongo Municipality'],
 ['AO', '12', 'Munic\xc3\xadpio Mucari'],
 ['AO', '15', 'Munic\xc3\xadpio Mucaba'],
 ['AO', '16', 'Munic\xc3\xadpio M\xe2\x80\x99banza Congo'],
 ['AO', '12', 'Munic\xc3\xadpio Massango'],
 ['AO', '12', 'Munic\xc3\xadpio Marimba'],
 ['AO', '15', 'Muni\xc3\xadpio Maquela do Zombo'],
 ['AO', '12', 'Malanje Municipality'],
 ['AO', '05', 'Munic\xc3\xadpio Lucala'],
 ['AO', '17', 'Munic\xc3\xadpio Lubalo'],
 ['AO', '20', 'Luanda Municipality'],
 ['AO', '03', 'Munic\xc3\xadpio L\xc3\xa2ndana'],
 ['AO', '12', 'Munic\xc3\xadpio Kunda-dia-Baze'],
 ['AO', '12', 'Munic\xc3\xadpio Kiwaba N\xe2\x80\x99zogi'],
 ['AO', '19', 'Munic\xc3\xadpio Icoloe Bengo'],
 ['AO', '05', 'Munic\xc3\xadpio Gonguembo'],
 ['AO', '05', 'Munic\xc3\xadpio Golungo Alto'],
 ['AO', '19', 'Munic\xc3\xadpio Dembos'],
 ['AO', '19', 'Dande Municipality'],
 ['AO', '15', 'Munic\xc3\xadpio Damba'],
 ['AO', '16', 'Munic\xc3\xadpio Cuimba'],
 ['AO', '17', 'Munic\xc3\xadpio Cuilo'],
 ['AO', '17', 'Munic\xc3\xadpio Cuango'],
 ['AO', '05', 'Cazengo Municipality'],
 ['AO', '17', 'Munic\xc3\xadpio Caungula'],
 ['AO', '17', 'Munic\xc3\xadpio Capenda-Camulemba'],
 ['AO', '12', 'Munic\xc3\xadpio Caombo'],
 ['AO', '05', 'Munic\xc3\xadpio Cambambe'],
 ['AO', '12', 'Munic\xc3\xadpio Calandula'],
 ['AO', '12', 'Munic\xc3\xadpio Cacuso'],
 ['AO', '20', 'Cacuaco Municipality'],
 ['AO', '03', 'Munic\xc3\xadpio Cabinda'],
 ['AO', '15', 'Munic\xc3\xadpio Bungo'],
 ['AO', '19', 'Munic\xc3\xadpio Bula Atumba'],
 ['AO', '15', 'Munic\xc3\xadpio Buengas'],
 ['AO', '03', 'Munic\xc3\xadpio Buco Zau'],
 ['AO', '05', 'Munic\xc3\xadpio Bolongongo'],
 ['AO', '15', 'Munic\xc3\xadpio Bembe'],
 ['AO', '15', 'Concelho do Bembe'],
 ['AO', '03', 'Munic\xc3\xadpio Belize'],
 ['AO', '05', 'Munic\xc3\xadpio Banga'],
 ['AO', '15', 'Ambuila Municipality'],
 ['AO', '19', 'Munic\xc3\xadpio Ambriz'],
 ['AO', '05', 'Munic\xc3\xadpio Ambaca'],
 ['AO', '15', 'Munic\xc3\xadpio Alto Cauale'],
 ['AO', '06', 'Munic\xc3\xadpio Waku Kungo'],
 ['AO', '13', 'Munic\xc3\xadpio Virei'],
 ['AO', '08', 'Munic\xc3\xadpio Ukuma'],
 ['AO', '13', 'Munic\xc3\xadpio Tombua'],
 ['AO', '08', 'Munic\xc3\xadpio Tchindjenje'],
 ['AO', '08', 'Munic\xc3\xadpio Tchikala-Tcholohanga'],
 ['AO', '06', 'Munic\xc3\xadpio Sumbe'],
 ['AO', '06', 'Munic\xc3\xadpio Seles'],
 ['AO', '12', 'Munic\xc3\xadpio Quirima'],
 ['AO', '09', 'Munic\xc3\xadpio Quipungo'],
 ['AO', '09', 'Munic\xc3\xadpio Quilengues'],
 ['AO', '06', 'Munic\xc3\xadpio Quilenda'],
 ['AO', '06', 'Munic\xc3\xadpio Quibala'],
 ['AO', '06', 'Munic\xc3\xadpio Porto Amboim'],
 ['AO', '07', 'Munic\xc3\xadpio Ombadja'],
 ['AO', '02', 'Munic\xc3\xadpio N\xe2\x80\x99harea'],
 ['AO', '04', 'Munic\xc3\xadpio Nankova'],
 ['AO', '13', 'Munic\xc3\xadpio Namibe'],
 ['AO', '07', 'Munic\xc3\xadpio Namacunde'],
 ['AO', '06', 'Munic\xc3\xadpio Mussende'],
 ['AO', '08', 'Munic\xc3\xadpio Mungo'],
 ['AO', '04', 'Munic\xc3\xadpio Menongue'],
 ['AO', '09', 'Munic\xc3\xadpio Matala'],
 ['AO', '12', 'Munic\xc3\xadpio Luquembo'],
 ['AO', '14', 'Munic\xc3\xadpio Luchazes'],
 ['AO', '09', 'Munic\xc3\xadpio Lubango'],
 ['AO', '08', 'Munic\xc3\xadpio Longonjo'],
 ['AO', '08', 'Munic\xc3\xadpio Londuimbali'],
 ['AO', '01', 'Munic\xc3\xadpio Lobito'],
 ['AO', '06', 'Munic\xc3\xadpio Libolo'],
 ['AO', '09', 'Munic\xc3\xadpio Kuvango'],
 ['AO', '02', 'Munic\xc3\xadpio Kuito'],
 ['AO', '08', 'Munic\xc3\xadpio Katchiungo'],
 ['AO', '09', 'Munic\xc3\xadpio Jamba'],
 ['AO', '09', 'Munic\xc3\xadpio Humpata'],
 ['AO', '08', 'Munic\xc3\xadpio Huambo'],
 ['AO', '01', 'Munic\xc3\xadpio Ganda'],
 ['AO', '08', 'Munic\xc3\xadpio Ekunha'],
 ['AO', '06', 'Munic\xc3\xadpio Ebo'],
 ['AO', '07', 'Munic\xc3\xadpio Cuvelai'],
 ['AO', '07', 'Munic\xc3\xadpio Curoca'],
 ['AO', '02', 'Munic\xc3\xadpio Cunhinga'],
 ['AO', '04', 'Munic\xc3\xadpio Cuito Cuanavale'],
 ['AO', '02', 'Munic\xc3\xadpio Cuemba'],
 ['AO', '04', 'Munic\xc3\xadpio Cuchi'],
 ['AO', '01', 'Munic\xc3\xadpio Cubal'],
 ['AO', '07', 'Munic\xc3\xadpio Cuanhama'],
 ['AO', '04', 'Munic\xc3\xadpio Cuangar'],
 ['AO', '06', 'Munic\xc3\xadpio Conda'],
 ['AO', '01', 'Munic\xc3\xadpio Chongoroi'],
 ['AO', '02', 'Munic\xc3\xadpio Chitembo'],
 ['AO', '09', 'Munic\xc3\xadpio Chipindo'],
 ['AO', '02', 'Munic\xc3\xadpio Chinguar'],
 ['AO', '09', 'Munic\xc3\xadpio Chicomba'],
 ['AO', '09', 'Munic\xc3\xadpio Chibia'],
 ['AO', '09', 'Munic\xc3\xadpio Chiange'],
 ['AO', '02', 'Munic\xc3\xadpio Catabola'],
 ['AO', '06', 'Munic\xc3\xadpio Cassongue'],
 ['AO', '12', 'Munic\xc3\xadpio Cangandala'],
 ['AO', '12', 'Munic\xc3\xadpio Cambundi-Catembo'],
 ['AO', '02', 'Munic\xc3\xadpio Camacupa'],
 ['AO', '02', 'Concelho de Camacupa'],
 ['AO', '13', 'Munic\xc3\xadpio Camacuio'],
 ['AO', '09', 'Munic\xc3\xadpio Caluquembe'],
 ['AO', '04', 'Mnuic\xc3\xadpio Calai'],
 ['AO', '01', 'Munic\xc3\xadpio Caimbambo'],
 ['AO', '07', 'Munic\xc3\xadpio Cahama'],
 ['AO', '09', 'Munic\xc3\xadpio Caconda'],
 ['AO', '18', 'Munic\xc3\xadpio Cacolo'],
 ['AO', '08', 'Munic\xc3\xadpio Ca\xc3\xa1la'],
 ['AO', '01', 'Munic\xc3\xadpio Bocoio'],
 ['AO', '13', 'Munic\xc3\xadpio Bibala'],
 ['AO', '01', 'Munic\xc3\xadpio Benguela'],
 ['AO', '01', 'Munic\xc3\xadpio Balombo'],
 ['AO', '01', 'Munic\xc3\xadpio Balombo'],
 ['AO', '08', 'Munic\xc3\xadpio Bailundo'],
 ['AO', '01', 'Munic\xc3\xadpio Ba\xc3\xada Farta'],
 ['AO', '02', 'Munic\xc3\xadpio Andulo'],
 ['AO', '06', 'Munic\xc3\xadpio Amboim'],
 ['AR', '01', 'Partido de Z\xc3\xa1rate'],
 ['AR', '08', 'Departamento de Villaguay'],
 ['AR', '01', 'Partido de Vicente L\xc3\xb3pez'],
 ['AR', '03', 'Partido de Veinticinco de Mayo'],
 ['AR', '14', 'Departamento de Veinticinco de Mayo'],
 ['AR', '08', 'Departamento de Uruguay'],
 ['AR', '01', 'Partido de Tres de Febrero'],
 ['AR', '01', 'Partido de Tordillo'],
 ['AR', '01', 'Partido de Tigre'],
 ['AR', '03', 'Partido de Tapenag\xc3\xa1'],
 ['AR', '01', 'Partido de Tandil'],
 ['AR', '08', 'Departamento de Tala'],
 ['AR', '01', 'Partido de Suipacha'],
 ['AR', '06', 'Departamento de Sauce'],
 ['AR', '03', 'Partido de Sargento Cabral'],
 ['AR', '01', 'Partido de San Vicente'],
 ['AR', '06', 'Departamento de Santo Tom\xc3\xa9'],
 ['AR', '06', 'Departamento de San Roque'],
 ['AR', '01', 'Partido de San Pedro'],
 ['AR', '14', 'Departamento de San Pedro'],
 ['AR', '06', 'Departamento de San Miguel'],
 ['AR', '06', 'Departamento de San Mart\xc3\xadn'],
 ['AR', '06', 'Departamento de San Luis del Palmar'],
 ['AR', '21', 'Departamento de San Javier'],
 ['AR', '14', 'Departamento de San Javier'],
 ['AR', '01', 'Partido de San Isidro'],
 ['AR', '14', 'Departamento de San Ignacio'],
 ['AR', '01', 'Partido de San Fernando'],
 ['AR', '03', 'Partido de San Fernando'],
 ['AR', '06', 'Departamento de San Cosme'],
 ['AR', '01', 'Partido de San Cayetano'],
 ['AR', '01', 'San Antonio de Areco'],
 ['AR', '01', 'Partido de San Andr\xc3\xa9s de Giles'],
 ['AR', '01', 'Partido de Saladillo'],
 ['AR', '06', 'Departamento de Saladas'],
 ['AR', '01', 'Partido de Roque P\xc3\xa9rez'],
 ['AR', '01', 'Partido de Rauch'],
 ['AR', '01', 'Partido de Quilmes'],
 ['AR', '03', 'Partido Primero de Mayo'],
 ['AR', '03', 'Partido de Presidencia de la Plaza'],
 ['AR', '09', 'Departamento de Piran\xc3\xa9'],
 ['AR', '09', 'Departamento de Pilcomayo'],
 ['AR', '01', 'Partido de Pilar'],
 ['AR', '09', 'Departamento de Pilag\xc3\xa1s'],
 ['AR', '01', 'Partido de Pila'],
 ['AR', '09', 'Departamento de Pati\xc3\xb1o'],
 ['AR', '06', 'Departamento de Paso de los Libres'],
 ['AR', '08', 'Departamento de Paran\xc3\xa1'],
 ['AR', '14', 'Departamento de Ober\xc3\xa1'],
 ['AR', '08', 'Departamento de Nogoy\xc3\xa1'],
 ['AR', '01', 'Partido de Necochea'],
 ['AR', '01', 'Partido de Navarro'],
 ['AR', '01', 'Partido de Mor\xc3\xb3n'],
 ['AR', '01', 'Partido de Moreno'],
 ['AR', '06', 'Departamento de Monte Caseros'],
 ['AR', '14', 'Departamento de Montecarlo'],
 ['AR', '01', 'Partido de Monte'],
 ['AR', '01', 'Partido de Merlo'],
 ['AR', '01', 'Partido de Mercedes'],
 ['AR', '06', 'Departamento de Mercedes'],
 ['AR', '06', 'Departamento de Mburucuy\xc3\xa1'],
 ['AR', '01', 'Partido de La Matanza'],
 ['AR', '01', 'Partido de Presidente Per\xc3\xb3n'],
 ['AR', '01', 'Partido de Pinamar'],
 ['AR', '01', 'Partido de Marcos Paz'],
 ['AR', '01', 'Partido de Mar Chiquita'],
 ['AR', '01', 'Partido de Maip\xc3\xba'],
 ['AR', '01', 'Partido de Magdalena'],
 ['AR', '01', 'Partido de Luj\xc3\xa1n'],
 ['AR', '01', 'Partido de Lomas de Zamora'],
 ['AR', '01', 'Partido de Lobos'],
 ['AR', '01', 'Partido de Lober\xc3\xada'],
 ['AR', '03', 'Partido de Libertador General San Mart\xc3\xadn'],
 ['AR', '14', 'Departamento de Libertador General San Mart\xc3\xadn'],
 ['AR', '03', 'Partido de Libertad'],
 ['AR', '14', 'Departamento de Leandro N. Alem'],
 ['AR', '06', 'Departamento de Lavalle'],
 ['AR', '01', 'Partido de Las Flores'],
 ['AR', '01', 'Partido de La Plata'],
 ['AR', '08', 'Departamento de La Paz'],
 ['AR', '01', 'Partido de Lan\xc3\xbas'],
 ['AR', '09', 'Departamento de Laish\xc3\xad'],
 ['AR', '01', 'Partido de Benito Ju\xc3\xa1rez'],
 ['AR', '01', 'Partido de Jos\xc3\xa9 C. Paz'],
 ['AR', '06', 'Departamento de Ituzaing\xc3\xb3'],
 ['AR', '06', 'Departamento de Itat\xc3\xad'],
 ['AR', '01', 'Partido de Punta Indio'],
 ['AR', '14', 'Departamento de Iguaz\xc3\xba'],
 ['AR', '14', 'Departamento de Guaran\xc3\xad'],
 ['AR', '08', 'Departamento de Gualeguaych\xc3\xba'],
 ['AR', '08', 'Departamento de Gualeguay'],
 ['AR', '06', 'Departamento de Goya'],
 ['AR', '01', 'Partido de General San Mart\xc3\xadn'],
 ['AR', '01', 'Partido de General Rodr\xc3\xadguez'],
 ['AR', '01', 'Partido de General Pueyrred\xc3\xb3n'],
 ['AR', '01', 'Partido de General Paz'],
 ['AR', '06', 'Departamento de General Paz'],
 ['AR', '21', 'Departamento de General Obligado'],
 ['AR', '14', 'Departamento de General Manuel Belgrano'],
 ['AR', '01', 'Partido de General Lavalle'],
 ['AR', '01', 'Partido de General Las Heras'],
 ['AR', '01', 'Partido de General Madariaga'],
 ['AR', '01', 'Partido de General Guido'],
 ['AR', '03', 'Partido de General Donovan'],
 ['AR', '01', 'Partido de General Belgrano'],
 ['AR', '06', 'Departamento de General Alvear'],
 ['AR', '01', 'Partido de General Alvarado'],
 ['AR', '09', 'Departamento de Formosa'],
 ['AR', '01', 'Partido de Florencio Varela'],
 ['AR', '08', 'Departamento de Feliciano'],
 ['AR', '08', 'Departamento de Federaci\xc3\xb3n'],
 ['AR', '01', 'Partido de Exaltaci\xc3\xb3n de la Cruz'],
 ['AR', '01', 'Partido de Esteban Echeverr\xc3\xada'],
 ['AR', '06', 'Departamento de Esquina'],
 ['AR', '01', 'Partido de Escobar'],
 ['AR', '01', 'Partido de Ensenada'],
 ['AR', '06', 'Departamento de Empedrado'],
 ['AR', '14', 'Departamento de Eldorado'],
 ['AR', '01', 'Partido de Dolores'],
 ['AR', '06', 'Departamento de Curuz\xc3\xba Cuati\xc3\xa1'],
 ['AR', '08', 'Departamento de Concordia'],
 ['AR', '06', 'Departamento de Concepci\xc3\xb3n'],
 ['AR', '14', 'Departamento de Concepci\xc3\xb3n de la Sierra'],
 ['AR', '08', 'Departamento de Col\xc3\xb3n'],
 ['AR', '01', 'Partido de Chivilcoy'],
 ['AR', '01', 'Partido de Chascom\xc3\xbas'],
 ['AR', '01', 'Partido de Castelli'],
 ['AR', '01', 'Partido de Carmen de Areco'],
 ['AR', '01', 'Partido de Capit\xc3\xa1n Sarmiento'],
 ['AR', '06', 'Departamento de Capital'],
 ['AR', '14', 'Departamento de Capital'],
 ['AR', '01', 'Partido de Canuelas'],
 ['AR', '14', 'Departamento de Candelaria'],
 ['AR', '01', 'Partido de Campana'],
 ['AR', '14', 'Departamento de Caingu\xc3\xa1s'],
 ['AR', '01', 'Partido de Brandsen'],
 ['AR', '06', 'Departamento de Ber\xc3\xb3n de Astrada'],
 ['AR', '03', 'Partido de Bermejo'],
 ['AR', '01', 'Partido de Berisso'],
 ['AR', '01', 'Partido de Berazategui'],
 ['AR', '06', 'Departamento de Bella Vista'],
 ['AR', '01', 'Partido de Arrecifes'],
 ['AR', '01', 'Partido de Baradero'],
 ['AR', '01', 'Partido de Balcarce'],
 ['AR', '01', 'Partido de Azul'],
 ['AR', '01', 'Partido de Ayacucho'],
 ['AR', '01', 'Partido de Avellaneda'],
 ['AR', '14', 'Departamento de Ap\xc3\xb3stoles'],
 ['AR', '01', 'Partido de Almirante Brown'],
 ['AR', '18', 'Departamento de Zonda'],
 ['AR', '15', 'Departamento de Zapala'],
 ['AR', '10', 'Departamento de Yav\xc3\xad'],
 ['AR', '01', 'Partido de Villarino'],
 ['AR', '08', 'Departamento de Victoria'],
 ['AR', '21', 'Departamento de Vera'],
 ['AR', '12', 'Departamento de V\xc3\xa9lez S\xc3\xa1rsfield'],
 ['AR', '01', 'Partido de Veinticinco de Mayo'],
 ['AR', '16', 'Departamento de Veinticinco de Mayo'],
 ['AR', '18', 'Departamento de Veinticinco de Mayo'],
 ['AR', '02', 'Departamento de Valle Viejo'],
 ['AR', '10', 'Departamento de Valle Grande'],
 ['AR', '18', 'Departamento de Valle F\xc3\xa9rtil'],
 ['AR', '16', 'Departamento de Valcheta'],
 ['AR', '11', 'Departamento de Utrac\xc3\xa1n'],
 ['AR', '23', 'Departamento de Ushuaia'],
 ['AR', '05', 'Departamento de Uni\xc3\xb3n'],
 ['AR', '18', 'Departamento de Ull\xc3\xban'],
 ['AR', '13', 'Departamento de Tupungato'],
 ['AR', '13', 'Departamento de Tunuy\xc3\xa1n'],
 ['AR', '10', 'Departamento de Tumbaya'],
 ['AR', '05', 'Departamento de Tulumba'],
 ['AR', '01', 'Partido de Tres Arroyos'],
 ['AR', '01', 'Partido de Trenque Lauquen'],
 ['AR', '11', 'Departamento de Trenel'],
 ['AR', '24', 'Departamento de Trancas'],
 ['AR', '05', 'Departamento de Totoral'],
 ['AR', '01', 'Partido de Tornquist'],
 ['AR', '11', 'Departamento de Toay'],
 ['AR', '02', 'Departamento de Tinogasta'],
 ['AR', '10', 'Departamento de Tilcara'],
 ['AR', '05', 'Departamento de Tercero Arriba'],
 ['AR', '04', 'Departamento de Telsen'],
 ['AR', '04', 'Departamento de Tehuelches'],
 ['AR', '01', 'Partido de Tapalqu\xc3\xa9'],
 ['AR', '24', 'Departamento de Taf\xc3\xad'],
 ['AR', '10', 'Departamento de Susques'],
 ['AR', '05', 'Departamento de Sobremonte'],
 ['AR', '22', 'Departamento de Sil\xc3\xadpica'],
 ['AR', '04', 'Departamento de Sarmiento'],
 ['AR', '18', 'Departamento de Sarmiento'],
 ['AR', '22', 'Departamento de Sarmiento'],
 ['AR', '17', 'Departamento de Santa Victoria'],
 ['AR', '13', 'Departamento de Santa Rosa'],
 ['AR', '02', 'Departamento de Santa Rosa'],
 ['AR', '05', 'Departamento de Santa Mar\xc3\xada'],
 ['AR', '02', 'Departamento de Santa Mar\xc3\xada'],
 ['AR', '18', 'Departamento de Santa Luc\xc3\xada'],
 ['AR', '10', 'Departamento de Santa Catalina'],
 ['AR', '10', 'Departamento de Santa B\xc3\xa1rbara'],
 ['AR', '23', 'Departamento de San Sebasti\xc3\xa1n'],
 ['AR', '13', 'Departamento de San Rafael'],
 ['AR', '10', 'Departamento de San Pedro'],
 ['AR', '01', 'Partido de San Nicol\xc3\xa1s'],
 ['AR', '13', 'Departamento de San Mart\xc3\xadn'],
 ['AR', '19', 'Departamento de San Mart\xc3\xadn'],
 ['AR', '21', 'Departamento de San Mart\xc3\xadn'],
 ['AR', '18', 'Departamento de San Mart\xc3\xadn'],
 ['AR', '22', 'Departamento de San Mart\xc3\xadn'],
 ['AR', '03', 'Partido de San Lorenzo'],
 ['AR', '21', 'Departamento de San Lorenzo'],
 ['AR', '05', 'Departamento de San Justo'],
 ['AR', '21', 'Departamento de San Justo'],
 ['AR', '21', 'Departamento de San Jer\xc3\xb3nimo'],
 ['AR', '05', 'Departamento de San Javier'],
 ['AR', '21', 'Departamento de San Crist\xc3\xb3bal'],
 ['AR', '13', 'Departamento de San Carlos'],
 ['AR', '17', 'Departamento de San Carlos'],
 ['AR', '12', 'Departamento de San Blas de los Sauces'],
 ['AR', '16', 'Departamento de San Antonio'],
 ['AR', '10', 'Departamento de San Antonio'],
 ['AR', '05', 'Departamento de San Alberto'],
 ['AR', '12', 'Departamento de Sanagasta'],
 ['AR', '01', 'Partido de Salto'],
 ['AR', '01', 'Partido de Salliquel\xc3\xb3'],
 ['AR', '22', 'Departamento de Salavina'],
 ['AR', '01', 'Partido de Saavedra'],
 ['AR', '17', 'Departamento de Rosario de Lerma'],
 ['AR', '17', 'Departamento de Rosario de la Frontera'],
 ['AR', '21', 'Departamento de Rosario'],
 ['AR', '01', 'Partido de Rojas'],
 ['AR', '22', 'Departamento de Robles'],
 ['AR', '01', 'Partido de Rivadavia'],
 ['AR', '13', 'Departamento de Rivadavia'],
 ['AR', '18', 'Departamento de Rivadavia'],
 ['AR', '12', 'Departamento de Rivadavia'],
 ['AR', '22', 'Departamento de Rivadavia'],
 ['AR', '17', 'Departamento de Rivadavia'],
 ['AR', '04', 'Departamento de R\xc3\xado Senguerr'],
 ['AR', '05', 'Departamento de R\xc3\xado Segundo'],
 ['AR', '05', 'Departamento de R\xc3\xado Seco'],
 ['AR', '05', 'Departamento de R\xc3\xado Primero'],
 ['AR', '22', 'Departamento de R\xc3\xado Hondo'],
 ['AR', '05', 'Departamento de R\xc3\xado Cuarto'],
 ['AR', '20', 'Departamento de R\xc3\xado Chico'],
 ['AR', '24', 'Departamento de R\xc3\xado Chico'],
 ['AR', '10', 'Departamento de Rinconada'],
 ['AR', '11', 'Departamento de Realic\xc3\xb3'],
 ['AR', '04', 'Departamento de Rawson'],
 ['AR', '18', 'Departamento de Rawson'],
 ['AR', '11', 'Departamento de Rancul'],
 ['AR', '09', 'Departamento de Ram\xc3\xb3n Lista'],
 ['AR', '01', 'Partido de Ramallo'],
 ['AR', '03', 'Partido de Quitilipi'],
 ['AR', '11', 'Departamento de Quem\xc3\xba Quem\xc3\xba'],
 ['AR', '22', 'Departamento de Quebrachos'],
 ['AR', '05', 'Departamento de Punilla'],
 ['AR', '11', 'Departamento de Puel\xc3\xa9n'],
 ['AR', '01', 'Partido de Puan'],
 ['AR', '19', 'Departamento de Pringles'],
 ['AR', '05', 'Departamento de Presidente Roque S\xc3\xa1enz Pe\xc3\xb1a'],
 ['AR', '02', 'Departamento de Pom\xc3\xa1n'],
 ['AR', '18', 'Departamento de Pocito'],
 ['AR', '05', 'Departamento de Pocho'],
 ['AR', '16', 'Departamento de Pilcaniyeu'],
 ['AR', '15', 'Departamento de Pic\xc3\xban Leuf\xc3\xba'],
 ['AR', '15', 'Departamento de Picunches'],
 ['AR', '16', 'Departamento de Pichi Mahuida'],
 ['AR', '01', 'Partido de Pergamino'],
 ['AR', '01', 'Partido de Pellegrini'],
 ['AR', '22', 'Departamento de Pellegrini'],
 ['AR', '15', 'Departamento de Pehuenches'],
 ['AR', '01', 'Partido de Pehuaj\xc3\xb3'],
 ['AR', '01', 'Partido de Patagones'],
 ['AR', '04', 'Departamento de Paso de Indios'],
 ['AR', '02', 'Departamento de Pacl\xc3\xadn'],
 ['AR', '17', 'Departamento de Or\xc3\xa1n'],
 ['AR', '01', 'Partido de Olavarr\xc3\xada'],
 ['AR', '22', 'Departamento de Ojo de Agua'],
 ['AR', '03', 'Partido de O\xe2\x80\x99Higgins'],
 ['AR', '01', 'Partido de Nueve de Julio'],
 ['AR', '03', 'Partido de Nueve de Julio'],
 ['AR', '16', 'Departamento de Nueve de Julio'],
 ['AR', '18', 'Departamento de Nueve de Julio'],
 ['AR', '21', 'Departamento de Nueve de Julio'],
 ['AR', '16', 'Departamento de \xc3\x91orquinc\xc3\xb3'],
 ['AR', '15', 'Departamento de \xc3\x91orqu\xc3\xadn'],
 ['AR', '22', 'Departamento de Moreno'],
 ['AR', '24', 'Departamento de Monteros'],
 ['AR', '17', 'Departamento de Molinos'],
 ['AR', '22', 'Departamento de Mitre'],
 ['AR', '15', 'Departamento de Minas'],
 ['AR', '05', 'Departamento de Minas'],
 ['AR', '17', 'Departamento de Met\xc3\xa1n'],
 ['AR', '03', 'Partido de Mayor Luis J. Fontana'],
 ['AR', '22', 'Departamento de Matar\xc3\xa1'],
 ['AR', '09', 'Departamento de Matacos'],
 ['AR', '04', 'Departamento de M\xc3\xa1rtires'],
 ['AR', '05', 'Departamento de Marcos Ju\xc3\xa1rez'],
 ['AR', '11', 'Departamento de Marac\xc3\xb3'],
 ['AR', '13', 'Departamento de Malarg\xc3\xbce'],
 ['AR', '03', 'Partido de Maip\xc3\xba'],
 ['AR', '13', 'Departamento de Maip\xc3\xba'],
 ['AR', '20', 'Departamento de Magallanes'],
 ['AR', '13', 'Departamento de Luj\xc3\xa1n'],
 ['AR', '15', 'Departamento de Los Lagos'],
 ['AR', '17', 'Departamento de Los Andes'],
 ['AR', '22', 'Departamento de Loreto'],
 ['AR', '15', 'Departamento de Loncopu\xc3\xa9'],
 ['AR', '01', 'Partido de Lincoln'],
 ['AR', '11', 'Departamento de Limay Mahuida'],
 ['AR', '11', 'Departamento de Lihuel-Calel'],
 ['AR', '11', 'Departamento de Leventu\xc3\xa9'],
 ['AR', '10', 'Departamento de Ledesma'],
 ['AR', '01', 'Partido de Leandro N. Alem'],
 ['AR', '24', 'Departamento de Leales'],
 ['AR', '17', 'Departamento de La Vi\xc3\xb1a'],
 ['AR', '13', 'Departamento de Lavalle'],
 ['AR', '13', 'Departamento de Las Heras'],
 ['AR', '21', 'Departamento de Las Colonias'],
 ['AR', '01', 'Partido de Laprida'],
 ['AR', '17', 'Departamento de La Poma'],
 ['AR', '13', 'Departamento de La Paz'],
 ['AR', '02', 'Departamento de La Paz'],
 ['AR', '04', 'Deparamento de Langui\xc3\xb1eo'],
 ['AR', '20', 'Departamento de Lago Buenos Aires'],
 ['AR', '20', 'Departamento de Lago Argentino'],
 ['AR', '15', 'Departamento de L\xc3\xa1car'],
 ['AR', '19', 'Departamento de La Capital'],
 ['AR', '21', 'Departamento de La Capital'],
 ['AR', '01', 'Partido de Jun\xc3\xadn'],
 ['AR', '13', 'Departamento de Jun\xc3\xadn'],
 ['AR', '19', 'Departamento de Jun\xc3\xadn'],
 ['AR', '05', 'Departamento de Ju\xc3\xa1rez Celman'],
 ['AR', '22', 'Departamento de Jim\xc3\xa9nez'],
 ['AR', '18', 'Departamento de J\xc3\xa1chal'],
 ['AR', '23', 'Departamento de Isla de los Estados'],
 ['AR', '05', 'Departamento de Ischil\xc3\xadn'],
 ['AR', '17', 'Departamento de Iruya'],
 ['AR', '21', 'Departamento de Iriondo'],
 ['AR', '03', 'Partido de Independencia'],
 ['AR', '12', 'Departamento de Independencia'],
 ['AR', '18', 'Departamento de Iglesia'],
 ['AR', '10', 'Departamento de Humahuaca'],
 ['AR', '15', 'Departamento de Huiliches'],
 ['AR', '11', 'Departamento de Hucal'],
 ['AR', '01', 'Partido de Hip\xc3\xb3lito Yrigoyen'],
 ['AR', '20', 'Departamento de G\xc3\xbcer Aike'],
 ['AR', '13', 'Departamento de Guaymall\xc3\xa9n'],
 ['AR', '11', 'Departamento de Guatrach\xc3\xa9'],
 ['AR', '22', 'Departamento de Guasay\xc3\xa1n'],
 ['AR', '01', 'Partido de Guamin\xc3\xad'],
 ['AR', '17', 'Departamento de Guachipas'],
 ['AR', '24', 'Departamento de Graneros'],
 ['AR', '01', 'Partido de Adolfo Gonz\xc3\xa1lez Chaves'],
 ['AR', '13', 'Departamento de Godoy Cruz'],
 ['AR', '19', 'Departamento de Gobernador Vicente Dupuy'],
 ['AR', '12', 'Departamento de Gobernador Gordillo'],
 ['AR', '01', 'Partido de General Villegas'],
 ['AR', '01', 'Partido de General Viamonte'],
 ['AR', '22', 'Departamento de General Taboada'],
 ['AR', '12', 'Departamento de General Sarmiento'],
 ['AR', '05', 'Departamento de General San Mart\xc3\xadn'],
 ['AR', '12', 'Departamento de General San Mart\xc3\xadn'],
 ['AR', '16', 'Departamento de General Roca'],
 ['AR', '05', 'Departamento de General Roca'],
 ['AR', '12', 'Departamento de General Roca'],
 ['AR', '01', 'Partido de General Pinto'],
 ['AR', '19', 'Departamento de General Pedernera'],
 ['AR', '12', 'Departamento de General Ocampo'],
 ['AR', '17', 'Departamento de General Mart\xc3\xadn Miguel de G\xc3\xbcemes'],
 ['AR', '21', 'Departamento de General L\xc3\xb3pez'],
 ['AR', '12', 'Departamento de General Lavalle'],
 ['AR', '01', 'Partido de General La Madrid'],
 ['AR', '12', 'Departamento de General La Madrid'],
 ['AR', '17', 'Departamento de General Jos\xc3\xa9 de San Mart\xc3\xadn'],
 ['AR', '03', 'Partido de General G\xc3\xbcemes'],
 ['AR', '03', 'Partido de General Belgrano'],
 ['AR', '12', 'Departamento de General Belgrano'],
 ['AR', '01', 'Partido de General Arenales'],
 ['AR', '01', 'Partido de General Alvear'],
 ['AR', '13', 'Departamento de General Alvear'],
 ['AR', '04', 'Departamento de Gastre'],
 ['AR', '21', 'Departamento de Garay'],
 ['AR', '04', 'Departamento de Gaim\xc3\xa1n'],
 ['AR', '04', 'Departamento de Futaleuf\xc3\xba'],
 ['AR', '02', 'Departamento de Fray Mamerto Esqui\xc3\xba'],
 ['AR', '03', 'Partido de Fray Justo Santa Mar\xc3\xada de Oro'],
 ['AR', '04', 'Departamento de Florentino Ameghino'],
 ['AR', '22', 'Departamento de Figueroa'],
 ['AR', '12', 'Departamento de Famatina'],
 ['AR', '24', 'Departamento de Famaill\xc3\xa1'],
 ['AR', '04', 'Departamento de Escalante'],
 ['AR', '16', 'Departamento de El Cuy'],
 ['AR', '10', 'Departamento de El Carmen'],
 ['AR', '02', 'Departamento de El Alto'],
 ['AR', '03', 'Partido de Doce de Octubre'],
 ['AR', '08', 'Dapartamento de Diamante'],
 ['AR', '20', 'Departamento de Deseado'],
 ['AR', '04', 'Departamento de Cushamen'],
 ['AR', '11', 'Departamento de Cura-C\xc3\xb3'],
 ['AR', '05', 'Departamento de Cruz del Eje'],
 ['AR', '24', 'Departamento de Cruz Alta'],
 ['AR', '20', 'Departamento de Corpen Aike'],
 ['AR', '01', 'Partido de Coronel Su\xc3\xa1rez'],
 ['AR', '01', 'Partido de Coronel Pringles'],
 ['AR', '01', 'Partido de Coronel Dorrego'],
 ['AR', '01', 'Partido de Coronel Rosales'],
 ['AR', '22', 'Departamento de Copo'],
 ['AR', '21', 'Departamento de Constituci\xc3\xb3n'],
 ['AR', '11', 'Departamento de Conhello'],
 ['AR', '15', 'Departamento de Confluencia'],
 ['AR', '16', 'Departamento de Conesa'],
 ['AR', '03', 'Partido de Comandante Fern\xc3\xa1ndez'],
 ['AR', '01', 'Partido de Col\xc3\xb3n'],
 ['AR', '05', 'Departamento de Col\xc3\xb3n'],
 ['AR', '15', 'Departamento de Coll\xc3\xb3n-Cur\xc3\xa1'],
 ['AR', '10', 'Departamento de Cochinoca'],
 ['AR', '22', 'Departamento de Choya'],
 ['AR', '15', 'Departamento de Chos-Malal'],
 ['AR', '18', 'Departamento de Chimbas'],
 ['AR', '12', 'Departamento de Chilecito'],
 ['AR', '17', 'Departamento de Chicoana'],
 ['AR', '24', 'Departamento de Chicligasta'],
 ['AR', '11', 'Departamento de Chical-C\xc3\xb3'],
 ['AR', '11', 'Departamento de Chapaleuf\xc3\xba'],
 ['AR', '11', 'Departamento de Chalileo'],
 ['AR', '01', 'Partido de Chacabuco'],
 ['AR', '03', 'Partido de Chacabuco'],
 ['AR', '19', 'Departamento de Chacabuco'],
 ['AR', '17', 'Departamento de Cerrillos'],
 ['AR', '18', 'Departamento de Caucete'],
 ['AR', '11', 'Departamento de Catril\xc3\xb3'],
 ['AR', '15', 'Departamento de Cat\xc3\xa1n-Lil'],
 ['AR', '12', 'Departamento de Castro Barros'],
 ['AR', '21', 'Departamento de Castellanos'],
 ['AR', '01', 'Partido de Daireaux'],
 ['AR', '21', 'Departamento de Caseros'],
 ['AR', '01', 'Partido de Carlos Tejedor'],
 ['AR', '01', 'Partido de Carlos Casares'],
 ['AR', '11', 'Departamento de Capital'],
 ['AR', '13', 'Departamento de Capital'],
 ['AR', '18', 'Departamento de Capital'],
 ['AR', '05', 'Departamento de Capital'],
 ['AR', '12', 'Departamento de Capital'],
 ['AR', '02', 'Departamento de Capital'],
 ['AR', '22', 'Departamento de Capital'],
 ['AR', '24', 'Departamento de Capital'],
 ['AR', '17', 'Departamento Capital'],
 ['AR', '10', 'Departamento de Capital'],
 ['AR', '02', 'Departamento de Capay\xc3\xa1n'],
 ['AR', '17', 'Departamento de Candelaria'],
 ['AR', '18', 'Departamento de Calingasta'],
 ['AR', '11', 'Departamento de Caleu-Caleu'],
 ['AR', '17', 'Departamento de Caldera'],
 ['AR', '05', 'Departamento de Calamuchita'],
 ['AR', '17', 'Departamento de Cafayate'],
 ['AR', '17', 'Departamento de Cach\xc3\xad'],
 ['AR', '24', 'Departamento de Burruyac\xc3\xba'],
 ['AR', '01', 'Partido de Bragado'],
 ['AR', '01', 'Partido de Bol\xc3\xadvar'],
 ['AR', '04', 'Departamento de Biedma'],
 ['AR', '09', 'Departamento de Bermejo'],
 ['AR', '19', 'Departamento de Belgrano'],
 ['AR', '21', 'Departamento de Belgrano'],
 ['AR', '22', 'Departamento de Belgrano'],
 ['AR', '02', 'Departamento de Bel\xc3\xa9n'],
 ['AR', '16', 'Departamento de Bariloche'],
 ['AR', '22', 'Departamento de Banda'],
 ['AR', '01', 'Partido de Monte Hermoso'],
 ['AR', '23', 'Departamento de Bah\xc3\xada Thetis'],
 ['AR', '01', 'Partido de Bah\xc3\xada Blanca'],
 ['AR', '19', 'Departamento de Ayacucho'],
 ['AR', '16', 'Departamento de Avellaneda'],
 ['AR', '22', 'Departamento de Avellaneda'],
 ['AR', '11', 'Departamento de Atreuc\xc3\xb3'],
 ['AR', '22', 'Departamento de Atamisqui'],
 ['AR', '12', 'Departamento de Arauco'],
 ['AR', '02', 'Departamento de Antofagasta de la Sierra'],
 ['AR', '17', 'Departamento de Anta'],
 ['AR', '18', 'Departamento de Angaco'],
 ['AR', '15', 'Departamento de A\xc3\xb1elo'],
 ['AR', '02', 'Departamento de Andalgal\xc3\xa1'],
 ['AR', '02', 'Departamento de Ancasti'],
 ['AR', '02', 'Departamento de Ambato'],
 ['AR', '15', 'Departamento de Alumin\xc3\xa9'],
 ['AR', '03', 'Departamento de Almirante Brown'],
 ['AR', '01', 'Partido de Alberti'],
 ['AR', '22', 'Departamento de Alberdi'],
 ['AR', '18', 'Departamento de Albard\xc3\xb3n'],
 ['AR', '22', 'Departamento de Aguirre'],
 ['AR', '01', 'Partido de Adolfo Alsina'],
 ['AR', '16', 'Departamento de Adolfo Alsina'],
 ['AR', '01', 'Partido de Malvinas Argentinas'],
 ['AR', '01', 'Partido de San Miguel'],
 ['AR', '01', 'Partido de La Costa'],
 ['AR', '01', 'Partido de Ezeiza'],
 ['AR', '01', 'Partido de Florentino Ameghino'],
 ['AR', '01', 'Partido de Hurlingham'],
 ['AR', '01', 'Partido de Ituzaing\xc3\xb3'],
 ['AR', '01', 'Partido de Tres Lomas'],
 ['AR', '01', 'Partido de Villa Gesell'],
 ['AS', '010', 'West Vaifanua County'],
 ['AS', '010', 'East Vaifanua County'],
 ['AS', '050', 'Tu\xc3\xa4l\xc3\xa4uta County'],
 ['AS', '050', 'T\xc3\xbcal\xc3\xa4tai County'],
 ['AS', '010', 'S\xc3\xa4`ole County'],
 ['AS', '010', 'Sua County'],
 ['AS', '010', 'Itu`a\xc5\xab County'],
 ['AS', '050', 'Le\xc4\x81l\xc4\x81taua County'],
 ['AS', '050', 'Le\xc4\x81sina County'],
 ['AS', '010', 'Mauputasi County'],
 ['AS', '020', 'Faleasao County'],
 ['AS', '010', 'Vaifanua County'],
 ['AS', '020', 'Fitiuta County'],
 ['AS', '020', "Ta'u County"],
 ['AS', '020', 'Olosega County'],
 ['AS', '020', 'Ofu County'],
 ['AT', '03', 'Politischer Bezirk Zwettl'],
 ['AT', '05', 'Politischer Bezirk Zell am See'],
 ['AT', '02', 'Politischer Bezirk Wolfsberg'],
 ['AT', '03', 'Politischer Bezirk Wien Umgebung'],
 ['AT', '09', 'Politischer Bezirk Wien (Stadt)'],
 ['AT', '03', 'Wiener Neustadt Stadt'],
 ['AT', '03', 'Politischer Bezirk Wiener Neustadt'],
 ['AT', '04', 'Wels-Land'],
 ['AT', '06', 'Politischer Bezirk Weiz'],
 ['AT', '03', 'Politischer Bezirk Waidhofen an der Thaya'],
 ['AT', '02', 'Politischer Bezirk V\xc3\xb6lkermarkt'],
 ['AT', '06', 'Politischer Bezirk Voitsberg'],
 ['AT', '04', 'Politischer Bezirk V\xc3\xb6cklabruck'],
 ['AT', '02', 'Villach Stadt'],
 ['AT', '02', 'Politischer Bezirk Villach Land'],
 ['AT', '04', 'Politischer Bezirk Urfahr Umgebung'],
 ['AT', '03', 'Politischer Bezirk Tulln'],
 ['AT', '05', 'Politischer Bezirk Tamsweg'],
 ['AT', '04', 'Steyr Stadt'],
 ['AT', '04', 'Politischer Bezirk Steyr-Land'],
 ['AT', '02', 'Politischer Bezirk Spittal an der Drau'],
 ['AT', '07', 'Politischer Bezirk Schwaz'],
 ['AT', '03', 'Politischer Bezirk Scheibbs'],
 ['AT', '04', 'Politischer Bezirk Sch\xc3\xa4rding'],
 ['AT', '02', 'Politischer Bezirk Sankt Veit an der Glan'],
 ['AT', '03', 'Sankt P\xc3\xb6lten Stadt'],
 ['AT', '03', 'Politischer Bezirk Sankt P\xc3\xb6lten'],
 ['AT', '05', 'Politischer Bezirk Sankt Johann im Pongau'],
 ['AT', '05', 'Politischer Bezirk Salzburg Umgebung'],
 ['AT', '05', 'Salzburg Stadt'],
 ['AT', '01', 'Rust Stadt'],
 ['AT', '04', 'Politischer Bezirk Rohrbach'],
 ['AT', '04', 'Politischer Bezirk Ried im Innkreis'],
 ['AT', '07', 'Politischer Bezirk Reutte'],
 ['AT', '06', 'Politischer Bezirk Radkersburg'],
 ['AT', '04', 'Politischer Bezirk Perg'],
 ['AT', '01', 'Politischer Bezirk Oberwart'],
 ['AT', '01', 'Politischer Bezirk Oberpullendorf'],
 ['AT', '01', 'Politischer Bezirk Neusiedl am See'],
 ['AT', '03', 'Politischer Bezirk Neunkirchen'],
 ['AT', '06', 'Politischer Bezirk M\xc3\xbcrzzuschlag'],
 ['AT', '06', 'Politischer Bezirk Murau'],
 ['AT', '03', 'Politischer Bezirk M\xc3\xb6dling'],
 ['AT', '03', 'Politischer Bezirk Mistelbach an der Zaya'],
 ['AT', '03', 'Politischer Bezirk Melk'],
 ['AT', '01', 'Politischer Bezirk Mattersburg'],
 ['AT', '04', 'Linz Stadt'],
 ['AT', '04', 'Politischer Bezirk Linz Land'],
 ['AT', '03', 'Politischer Bezirk Lilienfeld'],
 ['AT', '06', 'Politischer Bezirk Liezen'],
 ['AT', '07', 'Politischer Bezirk Lienz'],
 ['AT', '06', 'Politischer Bezirk Leoben'],
 ['AT', '06', 'Politischer Bezirk Leibnitz'],
 ['AT', '07', 'Politischer Bezirk Landeck'],
 ['AT', '07', 'Politischer Bezirk Kufstein'],
 ['AT', '03', 'Krems an der Donau'],
 ['AT', '03', 'Politischer Bezirk Krems an der Donau'],
 ['AT', '03', 'Politischer Bezirk Korneuburg'],
 ['AT', '06', 'Politischer Bezirk Knittelfeld'],
 ['AT', '02', 'Klagenfurt am W\xc3\xb6rthersee'],
 ['AT', '02', 'Politischer Bezirk Klagenfurt Land'],
 ['AT', '07', 'Politischer Bezirk Kitzb\xc3\xbchel'],
 ['AT', '04', 'Politischer Bezirk Kirchdorf an der Krems'],
 ['AT', '06', 'Politischer Bezirk Judenburg'],
 ['AT', '01', 'Politischer Bezirk Jennersdorf'],
 ['AT', '07', 'Innsbruck Stadt'],
 ['AT', '07', 'Politischer Bezirk Innsbruck'],
 ['AT', '07', 'Politischer Bezirk Imst'],
 ['AT', '03', 'Politischer Bezirk Horn'],
 ['AT', '03', 'Politischer Bezirk Hollabrunn'],
 ['AT', '02', 'Politischer Bezirk Hermagor'],
 ['AT', '06', 'Politischer Bezirk Hartberg'],
 ['AT', '05', 'Politischer Bezirk Hallein'],
 ['AT', '01', 'Politischer Bezirk G\xc3\xbcssing'],
 ['AT', '04', 'Politischer Bezirk Grieskirchen'],
 ['AT', '06', 'Politischer Bezirk Graz Umgebung'],
 ['AT', '06', 'Graz Stadt'],
 ['AT', '04', 'Politischer Bezirk Gmunden'],
 ['AT', '03', 'Politischer Bezirk Gm\xc3\xbcnd'],
 ['AT', '03', 'Politischer Bezirk G\xc3\xa4nserndorf'],
 ['AT', '06', 'Politischer Bezirk F\xc3\xbcrstenfeld'],
 ['AT', '04', 'Politischer Bezirk Freistadt'],
 ['AT', '08', 'Politischer Bezirk Feldkirch'],
 ['AT', '06', 'Politischer Bezirk Feldbach'],
 ['AT', '01', 'Eisenstadt Stadt'],
 ['AT', '01', 'Politischer Bezirk Eisenstadt'],
 ['AT', '04', 'Politischer Bezirk Eferding'],
 ['AT', '08', 'Politischer Bezirk Dornbirn'],
 ['AT', '06', 'Politischer Berzirk Deutschlandsberg'],
 ['AT', '06', 'Politischer Bezirk Bruck an der Mur'],
 ['AT', '03', 'Politischer Bezirk Bruck an der Leitha'],
 ['AT', '08', 'Politischer Bezirk Bregenz'],
 ['AT', '04', 'Politischer Bezirk Braunau am Inn'],
 ['AT', '08', 'Politischer Bezirk Bludenz'],
 ['AT', '03', 'Politischer Bezirk Baden'],
 ['AT', '03', 'Politischer Bezirk Amstetten'],
 ['AT', '02', 'Politischer Bezirk Feldkirchen'],
 ['AT', '03', 'Waidhofen an der Ybbs'],
 ['AT', '04', 'Wels(Stadt)'],
 ['AU', '05', 'City of West Torrens'],
 ['AU', '08', 'Plantagenet Shire'],
 ['AU', '08', 'Perth Water'],
 ['AU', '08', 'Kent Shire'],
 ['AU', '08', 'Esperance Shire'],
 ['AU', '08', 'Dumbleyung Shire'],
 ['AU', '05', 'Burnside'],
 ['AU', '08', 'Augusta-Margaret River Shire'],
 ['AU', '07', 'Yarra'],
 ['AU', '02', 'Wyong Shire'],
 ['AU', '02', 'Warren Shire'],
 ['AU', '02', 'Tenterfield Municipality'],
 ['AU', '02', 'Temora Municipality'],
 ['AU', '02', 'Tamworth Municipality'],
 ['AU', '02', 'Shoalhaven Shire'],
 ['AU', '02', 'Randwick'],
 ['AU', '02', 'Port Stephens Shire'],
 ['AU', '02', 'Penrith Municipality'],
 ['AU', '02', 'Orange Municipality'],
 ['AU', '02', 'Nambucca Shire'],
 ['AU', '02', 'Murrumbidgee Shire'],
 ['AU', '02', 'Murray Shire'],
 ['AU', '07', 'Mildura Shire'],
 ['AU', '02', 'Manly Vale'],
 ['AU', '02', 'Maitland Municipality'],
 ['AU', '02', 'Lismore Municipality'],
 ['AU', '02', 'Lake Macquarie Shire'],
 ['AU', '02', 'Hornsby Shire'],
 ['AU', '02', 'Gosford Shire'],
 ['AU', '02', 'Gloucester Shire'],
 ['AU', '02', 'Dubbo Municipality'],
 ['AU', '07', 'Darebin'],
 ['AU', '02', 'Campbelltown Municipality'],
 ['AU', '02', 'Byron Shire'],
 ['AU', '02', 'Broken Hill Municipality'],
 ['AU', '02', 'Blue Mountains Municipality'],
 ['AU', '04', 'Balonne Shire'],
 ['AU', '07', 'Ballarat North'],
 ['AU', '02', 'Armidale Dumaresq'],
 ['AU', '02', 'Albury Municipality'],
 ['AU', '02', 'City of Sydney'],
 ['AU', '04', 'Maranoa'],
 ['AU', '08', 'Broome'],
 ['AU', '08', 'Broomehill-Tambellup'],
 ['AU', '08', 'Bruce Rock'],
 ['AU', '04', 'Cassowary Coast'],
 ['AU', '06', 'Brighton'],
 ['AU', '06', 'Burnie'],
 ['AU', '06', 'Central Coast'],
 ['AU', '06', 'Central Highlands'],
 ['AU', '06', 'Circular Head'],
 ['AU', '06', 'Clarence'],
 ['AU', '06', 'Derwent Valley'],
 ['AU', '02', 'Dungog'],
 ['AU', '02', 'Eurobodalla'],
 ['AU', '02', 'Fairfield'],
 ['AU', '02', 'Forbes'],
 ['AU', '02', 'Gilgandra'],
 ['AU', '02', 'Glen Innes Severn'],
 ['AU', '02', 'Goulburn Mulwaree'],
 ['AU', '02', 'Greater Taree'],
 ['AU', '02', 'Greater Hume Shire'],
 ['AU', '02', 'Tumbarumba'],
 ['AU', '02', 'Tumut Shire'],
 ['AU', '02', 'Tweed'],
 ['AU', '02', 'Upper Hunter Shire'],
 ['AU', '06', 'Waratah/Wynyard'],
 ['AU', '06', 'West Coast'],
 ['AU', '06', 'West Tamar'],
 ['AU', '03', 'Belyuen'],
 ['AU', '03', 'Coomalie'],
 ['AU', '04', 'Moreton Bay'],
 ['AU', '04', 'Mornington'],
 ['AU', '04', 'Mount Isa'],
 ['AU', '04', 'Murweh'],
 ['AU', '04', 'Napranum'],
 ['AU', '04', 'North Burnett'],
 ['AU', '04', 'Northern Peninsula Area'],
 ['AU', '04', 'Palm Island'],
 ['AU', '04', 'Paroo'],
 ['AU', '04', 'Pormpuraaw'],
 ['AU', '04', 'Quilpie'],
 ['AU', '04', 'Redland'],
 ['AU', '04', 'Richmond'],
 ['AU', '04', 'Rockhampton'],
 ['AU', '04', 'Scenic Rim'],
 ['AU', '04', 'Somerset'],
 ['AU', '04', 'South Burnett'],
 ['AU', '04', 'Southern Downs'],
 ['AU', '04', 'Sunshine Coast'],
 ['AU', '04', 'Tablelands'],
 ['AU', '04', 'Toowoomba'],
 ['AU', '04', 'Torres'],
 ['AU', '04', 'Torres Strait Island'],
 ['AU', '04', 'Townsville'],
 ['AU', '04', 'Weipa'],
 ['AU', '04', 'Western Downs'],
 ['AU', '03', 'Darwin'],
 ['AU', '03', 'East Arnhem'],
 ['AU', '03', 'Katherine'],
 ['AU', '03', 'Litchfield'],
 ['AU', '03', 'MacDonnell'],
 ['AU', '03', 'Palmerston'],
 ['AU', '03', 'Roper Gulf'],
 ['AU', '03', 'Tiwi Islands'],
 ['AU', '03', 'Victoria-Daly'],
 ['AU', '03', 'Wagait'],
 ['AU', '03', 'West Arnhem'],
 ['AU', '04', 'Whitsunday'],
 ['AU', '04', 'Winton'],
 ['AU', '04', 'Woorabinda'],
 ['AU', '04', 'Wujal Wujal'],
 ['AU', '04', 'Yarrabah'],
 ['AU', '05', 'Coober Pedy'],
 ['AU', '05', 'Elliston'],
 ['AU', '05', 'Flinders Ranges'],
 ['AU', '05', 'Franklin Harbour'],
 ['AU', '05', 'Gawler'],
 ['AU', '05', 'Goyder'],
 ['AU', '05', 'Grant'],
 ['AU', '05', 'Holdfast Bay'],
 ['AU', '05', 'Kangaroo Island'],
 ['AU', '05', 'Karoonda East Murray'],
 ['AU', '05', 'Kimba'],
 ['AU', '05', 'Kingston'],
 ['AU', '05', 'Wudinna'],
 ['AU', '05', 'Light'],
 ['AU', '05', 'Lower Eyre Peninsula'],
 ['AU', '05', 'Loxton Waikerie'],
 ['AU', '05', 'Mallala'],
 ['AU', '05', 'Maralinga Tjarutja'],
 ['AU', '05', 'Marion'],
 ['AU', '05', 'Mid Murray'],
 ['AU', '05', 'Mitcham'],
 ['AU', '05', 'Mount Barker'],
 ['AU', '05', 'Mount Gambier'],
 ['AU', '05', 'Mount Remarkable'],
 ['AU', '05', 'Murray Bridge'],
 ['AU', '05', 'Naracoorte and Lucindale'],
 ['AU', '05', 'Northern Areas'],
 ['AU', '05', 'Norwood Payneham St Peters'],
 ['AU', '05', 'Onkaparinga'],
 ['AU', '05', 'Orroroo/Carrieton'],
 ['AU', '05', 'Peterborough'],
 ['AU', '05', 'Playford'],
 ['AU', '05', 'Port Adelaide Enfield'],
 ['AU', '05', 'Port Augusta'],
 ['AU', '05', 'Port Lincoln'],
 ['AU', '05', 'Port Pirie City and Dists'],
 ['AU', '05', 'Prospect'],
 ['AU', '05', 'Renmark Paringa'],
 ['AU', '05', 'Robe'],
 ['AU', '05', 'Roxby Downs'],
 ['AU', '05', 'Salisbury'],
 ['AU', '05', 'Southern Mallee'],
 ['AU', '05', 'Streaky Bay'],
 ['AU', '05', 'Tatiara'],
 ['AU', '05', 'Tea Tree Gully'],
 ['AU', '05', 'The Coorong'],
 ['AU', '05', 'Tumby Bay'],
 ['AU', '05', 'Unley'],
 ['AU', '05', 'Victor Harbor'],
 ['AU', '05', 'Wakefield'],
 ['AU', '05', 'Walkerville'],
 ['AU', '05', 'Wattle Range'],
 ['AU', '05', 'Whyalla'],
 ['AU', '05', 'Yankalilla'],
 ['AU', '05', 'Yorke Peninsula'],
 ['AU', '08', 'Boyup Brook'],
 ['AU', '08', 'Bridgetown-Greenbushes'],
 ['AU', '08', 'Brookton'],
 ['AU', '08', 'Bunbury'],
 ['AU', '08', 'Busselton'],
 ['AU', '08', 'Cambridge'],
 ['AU', '08', 'Canning'],
 ['AU', '08', 'Capel'],
 ['AU', '08', 'Carnamah'],
 ['AU', '08', 'Carnarvon'],
 ['AU', '08', 'Chapman Valley'],
 ['AU', '08', 'Chittering'],
 ['AU', '08', 'Claremont'],
 ['AU', '08', 'City of Cockburn'],
 ['AU', '08', 'Collie'],
 ['AU', '08', 'Coolgardie'],
 ['AU', '08', 'Coorow'],
 ['AU', '08', 'Corrigin'],
 ['AU', '08', 'Cottesloe'],
 ['AU', '08', 'Cranbrook'],
 ['AU', '08', 'Cuballing'],
 ['AU', '08', 'Cue'],
 ['AU', '08', 'Cunderdin'],
 ['AU', '08', 'Dalwallinu'],
 ['AU', '08', 'Dandaragan'],
 ['AU', '08', 'Dardanup'],
 ['AU', '08', 'Denmark'],
 ['AU', '08', 'Derby-West Kimberley'],
 ['AU', '08', 'Donnybrook-Balingup'],
 ['AU', '08', 'Dowerin'],
 ['AU', '08', 'Dundas'],
 ['AU', '08', 'East Fremantle'],
 ['AU', '08', 'East Pilbara'],
 ['AU', '08', 'Exmouth'],
 ['AU', '08', 'Fremantle'],
 ['AU', '08', 'Geraldton-Greenough'],
 ['AU', '08', 'Gingin'],
 ['AU', '08', 'Gnowangerup'],
 ['AU', '08', 'Goomalling'],
 ['AU', '08', 'Gosnells'],
 ['AU', '08', 'Halls Creek'],
 ['AU', '08', 'Harvey'],
 ['AU', '08', 'Irwin'],
 ['AU', '08', 'Jerramungup'],
 ['AU', '08', 'Joondalup'],
 ['AU', '08', 'Kalamunda'],
 ['AU', '08', 'Kalgoorlie/Boulder'],
 ['AU', '08', 'Katanning'],
 ['AU', '08', 'Kellerberrin'],
 ['AU', '08', 'Kojonup'],
 ['AU', '08', 'Kondinin'],
 ['AU', '08', 'Koorda'],
 ['AU', '07', 'Alpine'],
 ['AU', '07', 'Ararat'],
 ['AU', '07', 'Banyule'],
 ['AU', '07', 'Bass Coast'],
 ['AU', '07', 'Baw Baw'],
 ['AU', '07', 'Bayside'],
 ['AU', '07', 'Benalla'],
 ['AU', '07', 'Boroondara'],
 ['AU', '07', 'Brimbank'],
 ['AU', '07', 'Buloke'],
 ['AU', '07', 'Campaspe'],
 ['AU', '07', 'Cardinia'],
 ['AU', '07', 'Casey'],
 ['AU', '07', 'Central Goldfields'],
 ['AU', '07', 'Colac-Otway'],
 ['AU', '07', 'Corangamite'],
 ['AU', '07', 'East Gippsland'],
 ['AU', '07', 'Frankston'],
 ['AU', '07', 'Gannawarra'],
 ['AU', '07', 'Glen Eira'],
 ['AU', '07', 'Glenelg'],
 ['AU', '07', 'Golden Plains'],
 ['AU', '07', 'Greater Bendigo'],
 ['AU', '07', 'Greater Dandenong'],
 ['AU', '07', 'Greater Geelong'],
 ['AU', '07', 'Greater Shepparton'],
 ['AU', '07', 'Hepburn'],
 ['AU', '07', 'Hindmarsh'],
 ['AU', '07', 'Hobsons Bay'],
 ['AU', '07', 'Horsham'],
 ['AU', '07', 'Hume'],
 ['AU', '04', 'Aurukun'],
 ['AU', '04', 'Banana'],
 ['AU', '04', 'Barcaldine'],
 ['AU', '04', 'Barcoo'],
 ['AU', '04', 'Blackall Tambo'],
 ['AU', '04', 'Boulia'],
 ['AU', '04', 'Brisbane'],
 ['AU', '04', 'Bulloo'],
 ['AU', '04', 'Bundaberg'],
 ['AU', '04', 'Burdekin'],
 ['AU', '04', 'Burke'],
 ['AU', '04', 'Cairns'],
 ['AU', '04', 'Carpentaria'],
 ['AU', '04', 'Central Highlands'],
 ['AU', '04', 'Charters Towers'],
 ['AU', '04', 'Cherbourg'],
 ['AU', '04', 'Cloncurry'],
 ['AU', '04', 'Cook'],
 ['AU', '04', 'Croydon'],
 ['AU', '04', 'Diamantina'],
 ['AU', '04', 'Doomadgee'],
 ['AU', '04', 'Etheridge'],
 ['AU', '04', 'Flinders'],
 ['AU', '04', 'Fraser Coast'],
 ['AU', '04', 'Gladstone'],
 ['AU', '04', 'Gold Coast'],
 ['AU', '04', 'Goondiwindi'],
 ['AU', '04', 'Gympie Regional Council'],
 ['AU', '04', 'Hinchinbrook'],
 ['AU', '04', 'Hope Vale'],
 ['AU', '04', 'Ipswich'],
 ['AU', '04', 'Isaac'],
 ['AU', '04', 'Kowanyama'],
 ['AU', '04', 'Lockhart River'],
 ['AU', '04', 'Lockyer Valley'],
 ['AU', '04', 'Logan'],
 ['AU', '04', 'Longreach'],
 ['AU', '04', 'Mackay'],
 ['AU', '04', 'McKinlay'],
 ['AU', '04', 'Mapoon'],
 ['AU', '08', 'Kulin'],
 ['AU', '08', 'Kwinana'],
 ['AU', '08', 'Lake Grace'],
 ['AU', '08', 'Laverton'],
 ['AU', '08', 'Leonora'],
 ['AU', '08', 'Mandurah'],
 ['AU', '08', 'Manjimup'],
 ['AU', '08', 'Meekatharra'],
 ['AU', '08', 'Melville'],
 ['AU', '08', 'Menzies'],
 ['AU', '08', 'Merredin'],
 ['AU', '08', 'Mingenew'],
 ['AU', '08', 'Moora'],
 ['AU', '08', 'Morawa'],
 ['AU', '08', 'Mosman Park'],
 ['AU', '08', 'Mount Magnet'],
 ['AU', '08', 'Mount Marshall'],
 ['AU', '08', 'Mukinbudin'],
 ['AU', '08', 'Mullewa'],
 ['AU', '08', 'Mundaring'],
 ['AU', '08', 'Murchison'],
 ['AU', '08', 'Murray'],
 ['AU', '08', 'Nannup'],
 ['AU', '08', 'Narembeen'],
 ['AU', '08', 'Narrogin'],
 ['AU', '08', 'Narrogin'],
 ['AU', '08', 'Nedlands'],
 ['AU', '08', 'Ngaanyatjarraku'],
 ['AU', '08', 'Northam'],
 ['AU', '08', 'Northampton'],
 ['AU', '08', 'Nungarin'],
 ['AU', '08', 'Peppermint Grove'],
 ['AU', '08', 'Perenjori'],
 ['AU', '08', 'Pingelly'],
 ['AU', '08', 'Port Hedland'],
 ['AU', '08', 'Quairading'],
 ['AU', '08', 'Ravensthorpe'],
 ['AU', '08', 'Rockingham'],
 ['AU', '08', 'Roebourne'],
 ['AU', '08', 'Sandstone'],
 ['AU', '08', 'Serpentine-Jarrahdale'],
 ['AU', '08', 'Shark Bay'],
 ['AU', '08', 'South Perth'],
 ['AU', '08', 'Stirling'],
 ['AU', '08', 'Subiaco'],
 ['AU', '08', 'Swan'],
 ['AU', '08', 'Tammin'],
 ['AU', '08', 'Three Springs'],
 ['AU', '05', 'Adelaide'],
 ['AU', '05', 'Adelaide Hills'],
 ['AU', '05', 'Alexandrina'],
 ['AU', '05', 'Anangu Pitjantjatjara'],
 ['AU', '05', 'Barossa'],
 ['AU', '05', 'Barunga West'],
 ['AU', '05', 'Berri and Barmera'],
 ['AU', '05', 'Campbelltown'],
 ['AU', '05', 'Ceduna'],
 ['AU', '05', 'Charles Sturt'],
 ['AU', '05', 'Clare and Gilbert Valleys'],
 ['AU', '05', 'Cleve'],
 ['AU', '05', 'Copper Coast'],
 ['AU', '08', 'Albany'],
 ['AU', '08', 'Armadale'],
 ['AU', '08', 'Ashburton'],
 ['AU', '08', 'Bassendean'],
 ['AU', '08', 'Bayswater'],
 ['AU', '08', 'Belmont'],
 ['AU', '08', 'Beverley'],
 ['AU', '08', 'Boddington'],
 ['AU', '06', "Break O'Day"],
 ['AU', '06', 'Devonport'],
 ['AU', '06', 'Dorset'],
 ['AU', '06', 'Flinders'],
 ['AU', '06', 'George Town'],
 ['AU', '06', 'Glamorgan/Spring Bay'],
 ['AU', '06', 'Glenorchy'],
 ['AU', '06', 'Hobart'],
 ['AU', '06', 'Huon Valley'],
 ['AU', '06', 'Kentish'],
 ['AU', '06', 'King Island'],
 ['AU', '06', 'Kingborough'],
 ['AU', '06', 'Latrobe'],
 ['AU', '06', 'Launceston'],
 ['AU', '06', 'Meander Valley'],
 ['AU', '06', 'Northern Midlands'],
 ['AU', '03', 'Alice Springs'],
 ['AU', '03', 'Barkly'],
 ['AU', '02', 'Ashfield'],
 ['AU', '02', 'Auburn'],
 ['AU', '03', 'Central Desert'],
 ['AU', '02', 'Ballina'],
 ['AU', '02', 'Balranald'],
 ['AU', '02', 'Bankstown'],
 ['AU', '02', 'Bathurst Regional'],
 ['AU', '02', 'The Hills Shire'],
 ['AU', '02', 'Bega Valley'],
 ['AU', '02', 'Bellingen'],
 ['AU', '02', 'Berrigan'],
 ['AU', '02', 'Blacktown'],
 ['AU', '02', 'Bland'],
 ['AU', '02', 'Blayney'],
 ['AU', '02', 'Bogan'],
 ['AU', '02', 'Bombala'],
 ['AU', '02', 'Boorowa'],
 ['AU', '02', 'Botany Bay'],
 ['AU', '02', 'Bourke'],
 ['AU', '02', 'Brewarrina'],
 ['AU', '02', 'Burwood'],
 ['AU', '02', 'Cabonne'],
 ['AU', '02', 'Camden'],
 ['AU', '02', 'Canada Bay'],
 ['AU', '02', 'Canterbury'],
 ['AU', '02', 'Carrathool'],
 ['AU', '02', 'Central Darling'],
 ['AU', '02', 'Cessnock'],
 ['AU', '02', 'Clarence Valley'],
 ['AU', '02', 'Cobar'],
 ['AU', '02', 'Coffs Harbour'],
 ['AU', '02', 'Conargo'],
 ['AU', '02', 'Coolamon'],
 ['AU', '02', 'Cooma-Monaro'],
 ['AU', '02', 'Coonamble'],
 ['AU', '02', 'Cootamundra'],
 ['AU', '02', 'Corowa Shire'],
 ['AU', '02', 'Cowra'],
 ['AU', '02', 'Deniliquin'],
 ['AU', '02', 'Great Lakes'],
 ['AU', '02', 'Griffith'],
 ['AU', '02', 'Gundagai'],
 ['AU', '02', 'Gunnedah'],
 ['AU', '02', 'Guyra'],
 ['AU', '02', 'Gwydir'],
 ['AU', '02', 'Harden'],
 ['AU', '02', 'Hawkesbury'],
 ['AU', '02', 'Hay'],
 ['AU', '02', 'Holroyd'],
 ['AU', '02', 'Hunters Hill'],
 ['AU', '02', 'Hurstville'],
 ['AU', '02', 'Inverell'],
 ['AU', '02', 'Jerilderie'],
 ['AU', '02', 'Junee'],
 ['AU', '02', 'Kempsey'],
 ['AU', '02', 'Kiama'],
 ['AU', '02', 'Kogarah'],
 ['AU', '02', 'Ku-ring-gai'],
 ['AU', '02', 'Kyogle'],
 ['AU', '02', 'Lachlan'],
 ['AU', '02', 'Lane Cove'],
 ['AU', '02', 'Leeton'],
 ['AU', '02', 'Leichhardt'],
 ['AU', '02', 'Lithgow'],
 ['AU', '02', 'Liverpool'],
 ['AU', '02', 'Liverpool Plains'],
 ['AU', '02', 'Lockhart'],
 ['AU', '02', 'Marrickville'],
 ['AU', '02', 'Mid-Western Regional'],
 ['AU', '02', 'Moree Plains'],
 ['AU', '02', 'Mosman'],
 ['AU', '02', 'Muswellbrook'],
 ['AU', '02', 'Narrabri'],
 ['AU', '02', 'Narrandera'],
 ['AU', '02', 'Narromine'],
 ['AU', '02', 'Newcastle'],
 ['AU', '02', 'North Sydney'],
 ['AU', '02', 'Oberon'],
 ['AU', '02', 'Palerang'],
 ['AU', '02', 'Parkes'],
 ['AU', '02', 'Parramatta'],
 ['AU', '02', 'Pittwater'],
 ['AU', '02', 'Port Macquarie-Hastings'],
 ['AU', '02', 'Queanbeyan'],
 ['AU', '02', 'Richmond Valley'],
 ['AU', '02', 'Rockdale'],
 ['AU', '02', 'Ryde'],
 ['AU', '02', 'Shellharbour'],
 ['AU', '02', 'Singleton'],
 ['AU', '02', 'Snowy River'],
 ['AU', '02', 'Strathfield'],
 ['AU', '02', 'Sutherland Shire'],
 ['AU', '02', 'Upper Lachlan Shire'],
 ['AU', '02', 'Uralla'],
 ['AU', '02', 'Urana'],
 ['AU', '02', 'Wagga Wagga'],
 ['AU', '02', 'Wakool'],
 ['AU', '02', 'Walcha'],
 ['AU', '02', 'Walgett'],
 ['AU', '02', 'Warringah'],
 ['AU', '02', 'Warrumbungle Shire'],
 ['AU', '02', 'Waverley'],
 ['AU', '02', 'Weddin'],
 ['AU', '02', 'Wellington'],
 ['AU', '02', 'Wentworth'],
 ['AU', '02', 'Willoughby'],
 ['AU', '02', 'Wingecarribee'],
 ['AU', '02', 'Wollondilly'],
 ['AU', '02', 'Wollongong'],
 ['AU', '02', 'Woollahra'],
 ['AU', '02', 'Yass Valley'],
 ['AU', '02', 'Young'],
 ['AU', '07', 'Indigo'],
 ['AU', '07', 'Kingston'],
 ['AU', '07', 'Knox'],
 ['AU', '07', 'Latrobe'],
 ['AU', '07', 'Loddon'],
 ['AU', '07', 'Macedon Ranges'],
 ['AU', '07', 'Manningham'],
 ['AU', '07', 'Mansfield'],
 ['AU', '07', 'Maribyrnong'],
 ['AU', '07', 'Maroondah'],
 ['AU', '07', 'Melbourne'],
 ['AU', '07', 'Melton'],
 ['AU', '07', 'Mitchell'],
 ['AU', '07', 'Moira'],
 ['AU', '07', 'Monash'],
 ['AU', '07', 'Moonee Valley'],
 ['AU', '07', 'Moorabool'],
 ['AU', '07', 'Moreland'],
 ['AU', '07', 'Mornington Peninsula'],
 ['AU', '07', 'Mount Alexander'],
 ['AU', '07', 'Moyne'],
 ['AU', '07', 'Murrindindi'],
 ['AU', '07', 'Nillumbik'],
 ['AU', '07', 'Northern Grampians'],
 ['AU', '07', 'Port Phillip'],
 ['AU', '07', 'Pyrenees'],
 ['AU', '07', 'Queenscliffe'],
 ['AU', '07', 'South Gippsland'],
 ['AU', '07', 'Southern Grampians'],
 ['AU', '07', 'Stonnington'],
 ['AU', '07', 'Strathbogie'],
 ['AU', '07', 'Surf Coast'],
 ['AU', '07', 'Swan Hill'],
 ['AU', '07', 'Towong'],
 ['AU', '07', 'Wangaratta'],
 ['AU', '07', 'Warrnambool'],
 ['AU', '07', 'Wellington'],
 ['AU', '07', 'West Wimmera'],
 ['AU', '07', 'Whitehorse'],
 ['AU', '07', 'Whittlesea'],
 ['AU', '07', 'Wodonga'],
 ['AU', '07', 'Wyndham'],
 ['AU', '07', 'Yarra Ranges'],
 ['AU', '07', 'Yarriambiack'],
 ['AU', '08', 'Toodyay'],
 ['AU', '08', 'Trayning'],
 ['AU', '08', 'Upper Gascoyne'],
 ['AU', '08', 'Victoria Park'],
 ['AU', '08', 'Victoria Plains'],
 ['AU', '08', 'Vincent'],
 ['AU', '08', 'Wagin'],
 ['AU', '08', 'Wandering'],
 ['AU', '08', 'Wanneroo'],
 ['AU', '08', 'Waroona'],
 ['AU', '08', 'West Arthur'],
 ['AU', '08', 'Westonia'],
 ['AU', '08', 'Wickepin'],
 ['AU', '08', 'Williams'],
 ['AU', '08', 'Wiluna'],
 ['AU', '08', 'Wongan-Ballidu'],
 ['AU', '08', 'Woodanilling'],
 ['AU', '08', 'Wyalkatchem'],
 ['AU', '08', 'Wyndham-East Kimberley'],
 ['AU', '08', 'Yalgoo'],
 ['AU', '08', 'Yilgarn'],
 ['AU', '08', 'York'],
 ['AU', '06', 'Sorell'],
 ['AU', '06', 'Southern Midlands'],
 ['AU', '06', 'Tasman'],
 ['AX', '01', 'Landskapet \xc3\x85land'],
 ['AZ', '35', 'Shahbuz Rayon'],
 ['AZ', '35', 'Ordubad Rayon'],
 ['AZ', '35', 'Sharur Rayon'],
 ['AZ', '35', 'Julfa Rayon'],
 ['AZ', '35', 'Nakhchivan City'],
 ['AZ', '35', 'Sadarak Rayon'],
 ['AZ', '00', 'Shaumyan Rayon'],
 ['AZ', '09', 'Shaumyanovskiy Rayon'],
 ['AZ', '09', 'Ordzhonikidzevskiy Rayon))'],
 ['AZ', '09', "Oktyabr'skiy Rayon"],
 ['AZ', '09', 'Nizaminskiy Rayon'],
 ['AZ', '00', 'Mirb\xc7\x9d\xc5\x9fir Rayonu'],
 ['AZ', '01', 'Leninskiy Rayon'],
 ['AZ', '01', 'Kirovskiy Rayon'],
 ['AZ', '09', 'Qarada\xc4\x9f Rayonu'],
 ['AZ', '09', 'Imeni Dvadtsati Shesti Bakinskikh Komissarov Rayon'],
 ['AZ', '35', 'Babek Rayon'],
 ['AZ', '09', 'X\xc9\x99tai Rayonu'],
 ['AZ', '35', 'Kangarli Rayon'],
 ['BA', '02', 'Modri\xc4\x8da'],
 ['BA', '02', 'Op\xc5\xa1tina Bile\xc4\x87a'],
 ['BA', '02', 'Op\xc5\xa1tina Ljubinje'],
 ['BA', '02', 'Op\xc5\xa1tina Gacko'],
 ['BA', '02', 'Op\xc5\xa1tina Nevesinje'],
 ['BA', '02', 'Op\xc5\xa1tina Kalinovik'],
 ['BA', '02', 'Op\xc5\xa1tina Srbinje'],
 ['BA', '02', 'Op\xc5\xa1tina \xc4\x8cajni\xc4\x8de'],
 ['BA', '02', 'Op\xc5\xa1tina Rudo'],
 ['BA', '02', 'Op\xc5\xa1tina Vi\xc5\xa1egrad'],
 ['BA', '02', 'Op\xc5\xa1tina Pale'],
 ['BA', '02', 'Op\xc5\xa1tina Rogatica'],
 ['BA', '02', 'Op\xc5\xa1tina Srebrenica'],
 ['BA', '02', 'Op\xc5\xa1tina Han Pijesak'],
 ['BA', '02', 'Op\xc5\xa1tina Vlasenica'],
 ['BA', '02', 'Op\xc5\xa1tina Tesli\xc4\x87'],
 ['BA', '02', 'Op\xc5\xa1tina Kotor-Varo\xc5\xa1'],
 ['BA', '02', 'Op\xc5\xa1tina Lopare'],
 ['BA', '02', 'Op\xc5\xa1tina Ugljevik'],
 ['BA', '02', 'Op\xc5\xa1tina \xc4\x8celinac'],
 ['BA', '02', 'Op\xc5\xa1tina Banja Luka'],
 ['BA', '02', 'Op\xc5\xa1tina Doboj'],
 ['BA', '02', 'Op\xc5\xa1tina Bijeljina'],
 ['BA', '02', 'Op\xc5\xa1tina Prnjavor'],
 ['BA', '02', 'Op\xc5\xa1tina Lakta\xc5\xa1i'],
 ['BA', '02', 'Op\xc5\xa1tina Prijedor'],
 ['BA', '02', 'Op\xc5\xa1tina Derventa'],
 ['BA', '02', 'Op\xc5\xa1tina Modri\xc4\x8da'],
 ['BA', '02', 'Op\xc5\xa1tina Srbac'],
 ['BA', '02', 'Op\xc4\x87ina Bosanski Novi'],
 ['BA', '02', 'Op\xc4\x87ina Bosanski \xc5\xa0amac'],
 ['BA', '02', 'Op\xc4\x87ina Bosanska Gradi\xc5\xa1ka'],
 ['BA', '02', 'Op\xc4\x87ina Bosanski Brod'],
 ['BA', '01', 'Unsko-Sanski Kanton'],
 ['BA', '01', 'Posavski Kanton'],
 ['BA', '01', 'Tuzlanski Kanton'],
 ['BA', '01', 'Zeni\xc4\x8dko-Dobojski Kanton'],
 ['BA', '01', 'Bosansko-Podrinjski Kanton'],
 ['BA', '01', 'Srednjobosanski Kanton'],
 ['BA', '01', 'Hercegova\xc4\x8dko-Neretvanski Kanton'],
 ['BA', '01', 'Zapadno-Hercegova\xc4\x8dki Kanton'],
 ['BA', '01', 'Kanton Sarajevo'],
 ['BA', '01', 'Hercegova\xc4\x8dko-Bosanski Kanton'],
 ['BA', '02', 'Op\xc4\x87ina Bosanska Krupa'],
 ['BA', '02', 'Op\xc4\x87ina Bosanska Dubica'],
 ['BA', '02', 'Op\xc4\x87ina Sanski Most'],
 ['BA', '02', 'Op\xc4\x87ina Od\xc5\xbeak'],
 ['BA', '02', 'Op\xc4\x87ina Ora\xc5\xa1je'],
 ['BA', '02', 'Op\xc4\x87ina Grada\xc4\x8dac'],
 ['BA', '02', 'Op\xc4\x87ina Skender Vakuf'],
 ['BA', '02', 'Op\xc5\xa1tina Mrkonji\xc4\x87-Grad'],
 ['BA', '02', 'Op\xc5\xa1tina \xc5\xa0ipovo'],
 ['BA', '02', 'Op\xc4\x87ina Bosanski Petrovac'],
 ['BA', '02', 'Op\xc4\x87ina Drvar'],
 ['BA', '02', 'Op\xc4\x87ina Klju\xc4\x8d'],
 ['BA', '02', 'Mrkonjic Grad Jug Opcina'],
 ['BA', '02', 'Op\xc5\xa1tina Zvornik'],
 ['BA', '02', 'Op\xc4\x87ina Kalesija'],
 ['BA', '02', 'Op\xc5\xa1tina \xc5\xa0ekovi\xc4\x87i'],
 ['BA', '02', 'Op\xc5\xa1tina Bratunac'],
 ['BA', '02', 'Op\xc5\xa1tina Sokolac'],
 ['BA', '02', 'Op\xc4\x87ina Gora\xc5\xbede'],
 ['BA', '02', 'Op\xc4\x87ina Stari Grad'],
 ['BA', '02', 'Op\xc4\x87ina Novo Sarajevo'],
 ['BA', '02', 'Op\xc4\x87ina Ilid\xc5\xbea'],
 ['BA', '02', 'Op\xc5\xa1tina Trnovo'],
 ['BA', '02', 'Op\xc4\x87ina Stolac'],
 ['BA', '02', 'Op\xc4\x87ina Mostar'],
 ['BA', '02', 'Op\xc4\x87ina Jajce'],
 ['BA', '02', 'Op\xc4\x87ina Kupres'],
 ['BA', '02', 'Op\xc5\xa1tina Kostajnica'],
 ['BA', '02', 'Op\xc4\x87ina Gra\xc4\x8danica'],
 ['BA', '02', 'Op\xc5\xa1tina Trebinje'],
 ['BA', '02', 'Op\xc5\xa1tina Mili\xc4\x87i'],
 ['BA', '02', 'Skelani Op\xc5\xa1tina'],
 ['BA', '01', 'Neretvljanski'],
 ['BD', '82', 'Kushtia District'],
 ['BD', '85', 'Parbattya Chattagram District'],
 ['BD', '85', 'Baris\xc4\x81l District'],
 ['BD', '87', 'Panch\xc4\x81garh District'],
 ['BD', '87', 'Th\xc4\x81kurgaon District'],
 ['BD', '87', 'Din\xc4\x81jpur District'],
 ['BD', '87', 'Nilph\xc4\x81m\xc4\x81ri District'],
 ['BD', '87', 'L\xc4\x81lmonirh\xc4\x81t District'],
 ['BD', '87', 'Kur\xc4\xabgr\xc4\x81m District'],
 ['BD', '87', 'Rangpur District'],
 ['BD', '87', 'Gaibandha District'],
 ['BD', '83', 'Naogaon'],
 ['BD', '83', 'Jaipurh\xc4\x81t District'],
 ['BD', '83', 'Bogra District'],
 ['BD', '83', 'Chapai Naw\xc4\x81bganj District'],
 ['BD', '83', 'R\xc4\x81jsh\xc4\x81hi District'],
 ['BD', '83', 'Nator District'],
 ['BD', '83', 'Sir\xc4\x81jganj District'],
 ['BD', '83', 'P\xc4\x81bna District'],
 ['BD', '81', 'Sherpur District'],
 ['BD', '81', 'Netrakona District'],
 ['BD', '81', 'Jam\xc4\x81lpur District'],
 ['BD', '81', 'Mymensingh District'],
 ['BD', '81', 'Tangail District'],
 ['BD', '81', 'G\xc4\x81zipur District'],
 ['BD', '81', 'Kishorganj District'],
 ['BD', '81', 'Narsingdi District'],
 ['BD', '81', 'Dhaka District'],
 ['BD', '81', 'R\xc4\x81jb\xc4\x81ri District'],
 ['BD', '81', 'Far\xc4\xabdpur District'],
 ['BD', '81', 'N\xc4\x81r\xc4\x81yanganj District'],
 ['BD', '81', 'Munshiganj District'],
 ['BD', '81', 'Gop\xc4\x81lganj District'],
 ['BD', '81', 'Shariyatpur District'],
 ['BD', '81', 'M\xc4\x81d\xc4\x81r\xc4\xabpur District'],
 ['BD', '86', 'Sun\xc4\x81mganj District'],
 ['BD', '86', 'Sylhet District'],
 ['BD', '86', 'Moulvib\xc4\x81z\xc4\x81r District'],
 ['BD', '86', 'Habiganj District'],
 ['BD', '84', 'Br\xc4\x81hmanb\xc4\x81ria District'],
 ['BD', '84', 'Comilla District'],
 ['BD', '84', 'Ch\xc4\x81ndpur District'],
 ['BD', '84', 'Lakshmipur District'],
 ['BD', '84', 'No\xc4\x81kh\xc4\x81li District'],
 ['BD', '84', 'Feni District'],
 ['BD', '84', 'Khagr\xc4\x81chari District'],
 ['BD', '84', 'Chittagong District'],
 ['BD', '84', 'B\xc4\x81ndarban District'],
 ['BD', '84', 'Cox\xe2\x80\x99s B\xc4\x81z\xc4\x81r District'],
 ['BD', '82', 'Meherpur District'],
 ['BD', '82', 'Jhenaidah District'],
 ['BD', '82', 'Chu\xc4\x81d\xc4\x81nga District'],
 ['BD', '82', 'M\xc4\x81gura District'],
 ['BD', '82', 'Jessore District'],
 ['BD', '82', 'Narail District'],
 ['BD', '82', 'B\xc4\x81gerh\xc4\x81t District'],
 ['BD', '82', 'Khulna District'],
 ['BD', '82', 'S\xc4\x81tkhira District'],
 ['BD', '82', 'Pirojpur District'],
 ['BD', '85', 'Jh\xc4\x81lak\xc4\x81ti District'],
 ['BD', '85', 'Bhola District'],
 ['BD', '85', 'Patu\xc4\x81kh\xc4\x81li District'],
 ['BD', '85', 'Barguna District'],
 ['BD', '81', 'M\xc4\x81nikganj District'],
 ['BD', '85', 'Pirojpur District'],
 ['BD', '', 'Khagrachhari'],
 ['BD', '', 'Rangamati'],
 ['BD', '', 'Jhalokati District'],
 ['BE', 'VLG', 'Provincie West-Vlaanderen'],
 ['BE', 'VLG', 'Provincie Oost-Vlaanderen'],
 ['BE', 'WAL', 'Province de Namur'],
 ['BE', 'WAL', 'Province du Luxembourg'],
 ['BE', 'VLG', 'Provincie Limburg'],
 ['BE', 'WAL', 'Province de Li\xc3\xa8ge'],
 ['BE', 'WAL', 'Province du Hainaut'],
 ['BE', 'VLG', 'Provincie Antwerpen'],
 ['BE', 'VLG', 'Provincie Vlaams-Brabant'],
 ['BE', 'WAL', 'Province du Brabant Wallon'],
 ['BE', 'BRU', '(Bruxelles-Capitale)'],
 ['BF', '07', 'Zoundweogo Province'],
 ['BF', '10', 'Province du Yatenga'],
 ['BF', '08', 'Province de la Tapoa'],
 ['BF', '01', 'Province du Sourou'],
 ['BF', '12', 'Province du Soum'],
 ['BF', '06', 'Province de la Sissili'],
 ['BF', '12', 'Province du S\xc3\xa9no'],
 ['BF', '05', 'Province du Sanmatenga'],
 ['BF', '06', 'Province du Sangui\xc3\xa9'],
 ['BF', '13', 'Province du Poni'],
 ['BF', '10', 'Province du Passor\xc3\xa9'],
 ['BF', '12', 'Province de l\xe2\x80\x99 Oudalan'],
 ['BF', '11', 'Province d\xe2\x80\x99 Oubritenga'],
 ['BF', '07', 'Nahouri Province'],
 ['BF', '05', 'Province du Namentenga'],
 ['BF', '01', 'Province du Mouhoun'],
 ['BF', '04', 'Kouritenga Province'],
 ['BF', '01', 'Province de la Kossi'],
 ['BF', '02', 'Province de la Como\xc3\xa9'],
 ['BF', '09', 'Province du K\xc3\xa9n\xc3\xa9dougou'],
 ['BF', '03', 'Kadiogo Province'],
 ['BF', '09', 'Province du Houet'],
 ['BF', '08', 'Province du Gourma'],
 ['BF', '08', 'Gnagna Province'],
 ['BF', '11', 'Province du Ganzourgou'],
 ['BF', '06', 'Province du Boulkiemd\xc3\xa9'],
 ['BF', '04', 'Province du Boulgou'],
 ['BF', '13', 'Province de la Bougouriba'],
 ['BF', '07', 'Bazega Province'],
 ['BF', '05', 'Province du Bam'],
 ['BF', '01', 'Province des Bal\xc3\xa9'],
 ['BF', '01', 'Province des Banwa'],
 ['BF', '13', 'Province du Ioba'],
 ['BF', '08', 'Province de la Komandjoari'],
 ['BF', '08', 'Province de la Kompienga'],
 ['BF', '04', 'Province du Koulp\xc3\xa9logo'],
 ['BF', '11', 'Province du Kourw\xc3\xa9ogo'],
 ['BF', '02', 'Province de la L\xc3\xa9raba'],
 ['BF', '10', 'Province du Loroum'],
 ['BF', '01', 'Province du Nayala'],
 ['BF', '13', 'Province du Noumbi\xc3\xa8l'],
 ['BF', '09', 'Province du Tuy'],
 ['BF', '12', 'Province du Yagha'],
 ['BF', '06', 'Province du Ziro'],
 ['BF', '10', 'Province du Zondoma'],
 ['BG', '57', 'Obshtina Zlatograd'],
 ['BG', '62', 'Obshtina Zlataritsa'],
 ['BG', '49', 'Obshtina Zemen'],
 ['BG', '52', 'Obshtina Zavet'],
 ['BG', '65', 'Obshtina Yambol'],
 ['BG', '38', 'Obshtina Yakoruda'],
 ['BG', '47', 'Obshtina Yakimovo'],
 ['BG', '46', 'Obshtina Yablanitsa'],
 ['BG', '47', 'Obshtina V\xc5\xadrshets'],
 ['BG', '54', 'Obshtina V\xc5\xadrbitsa'],
 ['BG', '61', 'Obshtina V\xc5\xadlchidol'],
 ['BG', '47', 'Obshtina V\xc5\xadlchedr\xc5\xadm'],
 ['BG', '64', 'Obshtina Vratsa'],
 ['BG', '63', 'Obshtina Vidin'],
 ['BG', '61', 'Obshtina Vetrino'],
 ['BG', '53', 'Obshtina Vetovo'],
 ['BG', '54', 'Obshtina Venets'],
 ['BG', '48', 'Obshtina Velingrad'],
 ['BG', '62', 'Obshtina Veliko T\xc5\xadrnovo'],
 ['BG', '61', 'Obshtina Varna'],
 ['BG', '46', 'Obshtina Ug\xc5\xadrchin'],
 ['BG', '56', 'Obshtina Tv\xc5\xadrditsa'],
 ['BG', '55', 'Obshtina Tutrakan'],
 ['BG', '60', 'Obshtina T\xc5\xadrgovishte'],
 ['BG', '53', 'Obshtina Tsenovo'],
 ['BG', '41', 'Obshtina Tryavna'],
 ['BG', '49', 'Obshtina Tr\xc5\xadn'],
 ['BG', '46', 'Obshtina Troyan'],
 ['BG', '45', 'Obshtina Treklyano'],
 ['BG', '43', 'Obshtina Topolovgrad'],
 ['BG', '40', 'Obshtina Dobrich'],
 ['BG', '46', 'Obshtina Teteven'],
 ['BG', '40', 'Obshtina Tervel'],
 ['BG', '58', 'Obshtina Svoge'],
 ['BG', '62', 'Obshtina Svishtov'],
 ['BG', '43', 'Obshtina Svilengrad'],
 ['BG', '61', 'Obshtina Suvorovo'],
 ['BG', '39', 'Obshtina Sungurlare'],
 ['BG', '62', 'Obshtina Sukhindol'],
 ['BG', '51', 'Obshtina S\xc5\xadedinenie'],
 ['BG', '38', 'Obshtina Strumyani'],
 ['BG', '48', 'Obshtina Strelcha'],
 ['BG', '62', 'Obshtina Strazhitsa'],
 ['BG', '65', 'Obshtina Straldzha'],
 ['BG', '59', 'Obshtina Stara Zagora'],
 ['BG', '45', 'Obshtina Dupnitsa'],
 ['BG', '43', 'Obshtina Stambolovo'],
 ['BG', '58', 'Obshtina Zlatitsa'],
 ['BG', '39', 'Obshtina Sozopol'],
 ['BG', '54', 'Obshtina Smyadovo'],
 ['BG', '57', 'Obshtina Smolyan'],
 ['BG', '53', 'Obshtina Slivo Pole'],
 ['BG', '58', 'Obshtina Slivnitsa'],
 ['BG', '56', 'Obshtina Sliven'],
 ['BG', '55', 'Obshtina Sitovo'],
 ['BG', '38', 'Obshtina Simitli'],
 ['BG', '43', 'Obshtina Simeonovgrad'],
 ['BG', '55', 'Obshtina Silistra'],
 ['BG', '54', 'Obshtina Shumen'],
 ['BG', '40', 'Obshtina Shabla'],
 ['BG', '41', 'Obshtina Sevlievo'],
 ['BG', '48', 'Obshtina Septemvri'],
 ['BG', '38', 'Obshtina Satovcha'],
 ['BG', '45', 'Obshtina Sapareva Banya'],
 ['BG', '38', 'Obshtina Sandanski'],
 ['BG', '52', 'Obshtina Samuil'],
 ['BG', '58', 'Obshtina Samokov'],
 ['BG', '51', 'Obshtina Sadovo'],
 ['BG', '63', 'Obshtina Ruzhintsi'],
 ['BG', '53', 'Obshtina Ruse'],
 ['BG', '39', 'Obshtina Ruen'],
 ['BG', '57', 'Obshtina Rudozem'],
 ['BG', '64', 'Obshtina Roman'],
 ['BG', '45', 'Obshtina Rila'],
 ['BG', '38', 'Obshtina Razlog'],
 ['BG', '52', 'Obshtina Razgrad'],
 ['BG', '51', 'Obshtina Rakovski'],
 ['BG', '48', 'Obshtina Rakitovo'],
 ['BG', '49', 'Obshtina Radomir'],
 ['BG', '59', 'Obshtina Radnevo'],
 ['BG', '51', 'Obshtina P\xc5\xadrvomay'],
 ['BG', '61', 'Obshtina Provadiya'],
 ['BG', '54', 'Obshtina Veliki Preslav'],
 ['BG', '50', 'Obshtina Pordim'],
 ['BG', '60', 'Obshtina Popovo'],
 ['BG', '39', 'Obshtina Pomorie'],
 ['BG', '62', 'Obshtina Polski Tr\xc5\xadmbesh'],
 ['BG', '51', 'Obshtina Plovdiv'],
 ['BG', '50', 'Obshtina Pleven'],
 ['BG', '38', 'Obshtina Petrich'],
 ['BG', '48', 'Obshtina Peshtera'],
 ['BG', '49', 'Obshtina Pernik'],
 ['BG', '50', 'Obshtina Isk\xc5\xadr'],
 ['BG', '48', 'Obshtina Pazardzhik'],
 ['BG', '62', 'Obshtina Pavlikeni'],
 ['BG', '59', 'Obshtina Pavel Banya'],
 ['BG', '48', 'Obshtina Panagyurishte'],
 ['BG', '64', 'Obshtina Oryakhovo'],
 ['BG', '59', 'Obshtina Opan'],
 ['BG', '60', 'Obshtina Opaka'],
 ['BG', '60', 'Obshtina Omurtag'],
 ['BG', '63', 'Obshtina Novo Selo'],
 ['BG', '54', 'Obshtina Novi Pazar'],
 ['BG', '56', 'Obshtina Nova Zagora'],
 ['BG', '50', 'Obshtina Nikopol'],
 ['BG', '54', 'Obshtina Nikola-Kozlevo'],
 ['BG', '45', 'Obshtina Nevestino'],
 ['BG', '39', 'Obshtina Neseb\xc5\xadr'],
 ['BG', '57', 'Obshtina Nedelino'],
 ['BG', '59', 'Obshtina M\xc5\xadglizh'],
 ['BG', '44', 'Obshtina Momchilgrad'],
 ['BG', '64', 'Obshtina Miziya'],
 ['BG', '43', 'Obshtina Mineralni Bani'],
 ['BG', '47', 'Obshtina Montana'],
 ['BG', '39', 'Obshtina Tsarevo'],
 ['BG', '64', 'Obshtina Mezdra'],
 ['BG', '47', 'Obshtina Medkovets'],
 ['BG', '39', 'Obshtina Malko T\xc5\xadrnovo'],
 ['BG', '63', 'Obshtina Makresh'],
 ['BG', '57', 'Obshtina Madan'],
 ['BG', '43', 'Obshtina Lyubimets'],
 ['BG', '62', 'Obshtina Lyaskovets'],
 ['BG', '46', 'Obshtina Lukovit'],
 ['BG', '51', 'Obshtina L\xc5\xadki'],
 ['BG', '52', 'Obshtina Loznitsa'],
 ['BG', '46', 'Obshtina Lovech'],
 ['BG', '47', 'Obshtina Lom'],
 ['BG', '50', 'Obshtina Levski'],
 ['BG', '46', 'Obshtina Letnitsa'],
 ['BG', '48', 'Obshtina Lesichevo'],
 ['BG', '45', 'Obshtina Kyustendil'],
 ['BG', '44', 'Obshtina K\xc5\xadrdzhali'],
 ['BG', '63', 'Obshtina Kula'],
 ['BG', '52', 'Obshtina Kubrat'],
 ['BG', '40', 'Obshtina Krushari'],
 ['BG', '44', 'Obshtina Krumovgrad'],
 ['BG', '64', 'Obshtina Krivodol'],
 ['BG', '38', 'Obshtina Kresna'],
 ['BG', '64', 'Obshtina Kozloduy'],
 ['BG', '49', 'Obshtina Kovachevtsi'],
 ['BG', '56', 'Obshtina Kotel'],
 ['BG', '58', 'Obshtina Kostinbrod'],
 ['BG', '58', 'Obshtina Kostenets'],
 ['BG', '58', 'Obshtina Koprivshtitsa'],
 ['BG', '45', 'Obshtina Kocherinovo'],
 ['BG', '64', 'Obshtina Knezha'],
 ['BG', '44', 'Obshtina Kirkovo'],
 ['BG', '52', 'Obshtina Tsar Kaloyan'],
 ['BG', '51', 'Obshtina Khisarya'],
 ['BG', '43', 'Obshtina Khaskovo'],
 ['BG', '43', 'Obshtina Kharmanli'],
 ['BG', '38', 'Obshtina Khadzhidimovo'],
 ['BG', '59', 'Obshtina Kazanl\xc5\xadk'],
 ['BG', '55', 'Obshtina Kaynardzha'],
 ['BG', '40', 'Obshtina Kavarna'],
 ['BG', '54', 'Obshtina Kaspichan'],
 ['BG', '39', 'Obshtina Karnobat'],
 ['BG', '51', 'Obshtina Karlovo'],
 ['BG', '54', 'Obshtina Kaolinovo'],
 ['BG', '39', 'Obshtina Kameno'],
 ['BG', '51', 'Obshtina Kaloyanovo'],
 ['BG', '43', 'Obshtina Ivaylovgrad'],
 ['BG', '53', 'Obshtina Ivanovo'],
 ['BG', '52', 'Obshtina Isperikh'],
 ['BG', '58', 'Obshtina Ikhtiman'],
 ['BG', '38', 'Obshtina G\xc5\xadrmen'],
 ['BG', '59', 'Obshtina Gurkovo'],
 ['BG', '50', 'Obshtina Gulyantsi'],
 ['BG', '59', 'Obshtina G\xc5\xadl\xc5\xadbovo'],
 ['BG', '39', 'Obshtina Sredets'],
 ['BG', '63', 'Obshtina Gramada'],
 ['BG', '38', 'Obshtina Gotse Delchev'],
 ['BG', '62', 'Obshtina Gorna Oryakhovitsa'],
 ['BG', '58', 'Obshtina Gorna Malina'],
 ['BG', '58', 'Obshtina Godech'],
 ['BG', '55', 'Obshtina Glavinitsa'],
 ['BG', '61', 'Obshtina Dolni Chiflik'],
 ['BG', '47', 'Obshtina Georgi-Damyanovo'],
 ['BG', '40', 'Obshtina General-Toshevo'],
 ['BG', '54', 'Obshtina Khitrino'],
 ['BG', '41', 'Obshtina Gabrovo'],
 ['BG', '58', 'Obshtina Etropole'],
 ['BG', '65', 'Obshtina Elkhovo'],
 ['BG', '58', 'Obshtina Elin Pelin'],
 ['BG', '62', 'Obshtina Elena'],
 ['BG', '44', 'Obshtina Dzhebel'],
 ['BG', '53', 'Obshtina Dve Mogili'],
 ['BG', '55', 'Obshtina Dulovo'],
 ['BG', '61', 'Obshtina D\xc5\xadlgopol'],
 ['BG', '41', 'Obshtina Dryanovo'],
 ['BG', '58', 'Obshtina Dragoman'],
 ['BG', '57', 'Obshtina Dospat'],
 ['BG', '50', 'Obshtina Dolni D\xc5\xadbnik'],
 ['BG', '50', 'Obshtina Dolna Mitropoliya'],
 ['BG', '58', 'Obshtina Dolna Banya'],
 ['BG', '63', 'Obshtina Dimovo'],
 ['BG', '43', 'Obshtina Dimitrovgrad'],
 ['BG', '61', 'Obshtina Devnya'],
 ['BG', '51', 'Obshtina Devin'],
 ['BG', '63', 'Obshtina Chuprene'],
 ['BG', '59', 'Obshtina Chirpan'],
 ['BG', '47', 'Obshtina Chiprovtsi'],
 ['BG', '50', 'Obshtina Cherven Bryag'],
 ['BG', '44', 'Obshtina Chernoochene'],
 ['BG', '57', 'Obshtina Chepelare'],
 ['BG', '64', 'Obshtina Byala Slatina'],
 ['BG', '61', 'Obshtina Byala'],
 ['BG', '53', 'Obshtina Byala'],
 ['BG', '39', 'Obshtina Burgas'],
 ['BG', '47', 'Obshtina Brusartsi'],
 ['BG', '51', 'Obshtina Brezovo'],
 ['BG', '49', 'Obshtina Breznik'],
 ['BG', '63', 'Obshtina Bregovo'],
 ['BG', '59', 'Obshtina Bratya Daskalovi'],
 ['BG', '48', 'Obshtina Bratsigovo'],
 ['BG', '58', 'Obshtina Bozhurishte'],
 ['BG', '63', 'Obshtina Boynitsa'],
 ['BG', '47', 'Obshtina Boychinovtsi'],
 ['BG', '58', 'Obshtina Botevgrad'],
 ['BG', '53', 'Obshtina Borovo'],
 ['BG', '64', 'Obshtina Borovan'],
 ['BG', '57', 'Obshtina Borino'],
 ['BG', '65', 'Obshtina Bolyarovo'],
 ['BG', '45', 'Obshtina Bobovdol'],
 ['BG', '45', 'Obshtina Boboshevo'],
 ['BG', '38', 'Obshtina Blagoevgrad'],
 ['BG', '47', 'Obshtina Berkovitsa'],
 ['BG', '48', 'Obshtina Belovo'],
 ['BG', '61', 'Obshtina Beloslav'],
 ['BG', '63', 'Obshtina Belogradchik'],
 ['BG', '38', 'Obshtina Belitsa'],
 ['BG', '50', 'Obshtina Belene'],
 ['BG', '48', 'Obshtina Batak'],
 ['BG', '38', 'Obshtina Bansko'],
 ['BG', '57', 'Obshtina Banite'],
 ['BG', '40', 'Obshtina Balchik'],
 ['BG', '39', 'Obshtina Aytos'],
 ['BG', '61', 'Obshtina Avren'],
 ['BG', '51', 'Obshtina Asenovgrad'],
 ['BG', '44', 'Obshtina Ardino'],
 ['BG', '46', 'Obshtina Apriltsi'],
 ['BG', '60', 'Obshtina Antonovo'],
 ['BG', '55', 'Obshtina Alfatar'],
 ['BG', '61', 'Obshtina Aksakovo'],
 ['BG', '39', 'Obshtina Primorsko'],
 ['BG', '40', 'Obshtina Dobrich-Selska'],
 ['BG', '64', 'Obshtina Khayredin'],
 ['BG', '51', 'Obshtina Rodopi'],
 ['BG', '51', 'Obshtina Perushtitsa'],
 ['BG', '51', 'Obshtina Krichim'],
 ['BG', '51', 'Obshtina Stamboliyski'],
 ['BG', '51', 'Obshtina Maritsa'],
 ['BG', '58', 'Obshtina Mirkovo'],
 ['BG', '58', 'Obshtina Chavdar'],
 ['BG', '58', 'Obshtina Chelopech'],
 ['BG', '58', 'Obshtina Pirdop'],
 ['BG', '58', 'Obshtina Anton'],
 ['BG', '58', 'Obshtina Pravets'],
 ['BG', '59', 'Obshtina Nikolaevo'],
 ['BG', '43', 'Obshtina Madzharovo'],
 ['BG', '65', 'Obshtina Tundzha'],
 ['BG', '51', 'Sopot'],
 ['BG', '51', 'Kuklen'],
 ['BG', '42', 'Stolichna Obshtina'],
 ['BI', '09', 'Bubanza'],
 ['BI', '12', 'Bukinanvana'],
 ['BI', '13', 'Buraza'],
 ['BI', '19', 'Busiga'],
 ['BI', '16', 'Busoni'],
 ['BI', '10', 'Buyengero'],
 ['BI', '11', 'Cendajuru'],
 ['BI', '19', 'Gashikanwa'],
 ['BI', '18', 'Gashoho'],
 ['BI', '22', 'Gisozi'],
 ['BI', '13', 'Gitega'],
 ['BI', '18', 'Giteranyi'],
 ['BI', '15', 'Kabarore'],
 ['BI', '15', 'Kayanza'],
 ['BI', '22', 'Kayokwe'],
 ['BI', '22', 'Kiganda'],
 ['BI', '17', 'Mabanda'],
 ['BI', '12', 'Mabayi'],
 ['BI', '10', 'Mugamba'],
 ['BI', '02', 'Muhuta'],
 ['BI', '12', 'Murwi'],
 ['BI', '02', 'Commune of Mutimbuzi'],
 ['BI', '18', 'Muyinga'],
 ['BI', '22', 'Nyabihanga'],
 ['BI', '14', 'Nyabikere'],
 ['BI', '02', 'Commune of Rohero'],
 ['BI', '12', 'Commune of Rugombo'],
 ['BI', '19', 'Ruhororo'],
 ['BI', '22', 'Rutegama'],
 ['BI', '21', 'Ruyigi'],
 ['BI', '19', 'Tangara'],
 ['BI', '16', 'Vumbi'],
 ['BI', '19', 'Ngozi'],
 ['BI', '13', 'Mutaho'],
 ['BI', '02', 'Commune of Buterere'],
 ['BI', '02', 'Kamenge'],
 ['BI', '02', 'Kinama'],
 ['BI', '02', 'Gihosha'],
 ['BI', '02', 'Musaga'],
 ['BI', '13', 'Giheta'],
 ['BI', '13', 'Bugendana'],
 ['BI', '15', 'Murata'],
 ['BI', '13', 'Ryansoro'],
 ['BI', '02', 'Commune of Gihanga'],
 ['BI', '12', 'Commune of Buganda'],
 ['BI', '02', 'Commune of Ngagara'],
 ['BI', '02', 'Commune of Buyenzi'],
 ['BJ', '16', 'Commune of Adjohoun'],
 ['BJ', '16', 'Bonou'],
 ['BJ', '16', 'Dangbo'],
 ['BJ', '18', 'Commune of Cove'],
 ['BJ', '18', 'Commune of Ouinhi'],
 ['BJ', '18', 'Commune of Zangnanado'],
 ['BJ', '08', 'Kouande'],
 ['BJ', '08', 'Pehonko'],
 ['BJ', '08', 'Kerou'],
 ['BJ', '15', 'Lokossa'],
 ['BJ', '15', 'Commune of Athieme'],
 ['BJ', '18', 'Commune of Bohicon'],
 ['BJ', '18', 'Commune of Za-Kpota'],
 ['BJ', '18', 'Commune of Zogbodome'],
 ['BJ', '07', 'Commune of Banikoara'],
 ['BJ', '09', 'Commune of Ouidah'],
 ['BJ', '09', 'Commune of Kpomasse'],
 ['BJ', '09', 'Commune of Tori-Bossito'],
 ['BJ', '16', 'Porto-novo'],
 ['BJ', '16', 'Agu\xc3\xa9gu\xc3\xa9s'],
 ['BJ', '16', 'Seme-kpodji'],
 ['BJ', '13', 'Ouake'],
 ['BJ', '13', 'Djougou Rural'],
 ['BJ', '10', 'Commune of Tchaourou'],
 ['BJ', '10', 'Commune of Parakou'],
 ['BJ', '10', 'Ndali'],
 ['BJ', '10', 'Bembereke'],
 ['BJ', '08', 'Natitingou'],
 ['BJ', '08', 'Kopargo'],
 ['BJ', '10', 'Kalal\xc3\xa8'],
 ['BJ', '10', 'P\xc3\xa8r\xc3\xa8r\xc3\xa8'],
 ['BJ', '10', 'Nikki'],
 ['BJ', '10', 'Sinend\xc3\xa9'],
 ['BJ', '13', 'Djougou Urban'],
 ['BJ', '16', 'Commune of Ketou'],
 ['BJ', '16', 'Commune of Pobe'],
 ['BJ', '09', 'Cotonou'],
 ['BJ', '09', 'Commune of Abomey-Calavi'],
 ['BJ', '09', 'Commune of So-Ava'],
 ['BJ', '10', 'Karimama'],
 ['BJ', '08', 'Tanguieta'],
 ['BJ', '08', 'Toukountouna'],
 ['BJ', '08', 'Materi'],
 ['BJ', '18', 'Commune of Glazoue'],
 ['BJ', '10', 'Malanville'],
 ['BJ', '10', 'Kandi'],
 ['BJ', '18', 'Commune of Bante'],
 ['BJ', '18', 'Commune of Dassa-Zoume'],
 ['BJ', '18', 'Commune of Ouesse'],
 ['BJ', '18', 'Commune of Savalou'],
 ['BJ', '18', 'Commune of Save'],
 ['BJ', '18', 'Commune of Abomey'],
 ['BJ', '18', 'Commune of Agbangnizoun'],
 ['BJ', '18', 'Commune of Djidja'],
 ['BJ', '09', 'Commune of Allada'],
 ['BJ', '09', 'Commune of Toffo'],
 ['BJ', '09', 'Commune of Ze'],
 ['BJ', '08', 'Commune of Djougou'],
 ['BJ', '16', 'Commune of Sakete'],
 ['BJ', '15', 'Commune of Houeyogbe'],
 ['BJ', '15', 'Commune of Bopa'],
 ['BJ', '16', 'Adjaouere'],
 ['BO', '08', 'Provincia Chiquitos'],
 ['BO', '08', 'Provincia \xc3\x81ngel Sandoval'],
 ['BO', '01', 'Provincia Zud\xc3\xa1\xc3\xb1ez'],
 ['BO', '01', 'Provincia Yampar\xc3\xa1ez'],
 ['BO', '03', 'Provincia Yacuma'],
 ['BO', '08', 'Provincia Warnes'],
 ['BO', '08', 'Provincia Velasco'],
 ['BO', '08', 'Provincia Vallegrande'],
 ['BO', '03', 'Provincia Vaca Diez'],
 ['BO', '01', 'Provincia Tomina'],
 ['BO', '07', 'Provincia Tom\xc3\xa1s Fr\xc3\xadas'],
 ['BO', '05', 'Provincia Tom\xc3\xa1s Barron'],
 ['BO', '02', 'Provincia Tapacar\xc3\xad'],
 ['BO', '05', 'Provincia Sur Carangas'],
 ['BO', '04', 'Provincia Sud Yungas'],
 ['BO', '07', 'Provincia Sud L\xc3\xadpez'],
 ['BO', '01', 'Provincia Sud Cinti'],
 ['BO', '07', 'Provincia Sud Chichas'],
 ['BO', '05', 'Provincia Saucari'],
 ['BO', '08', 'Provincia Sara'],
 ['BO', '08', 'Provincia Santiesteban'],
 ['BO', '05', 'Provincia San Pedro de Totora'],
 ['BO', '05', 'Provincia Sajama'],
 ['BO', '07', 'Provincia Saavedra'],
 ['BO', '07', 'Provincia Rafael Bustillos'],
 ['BO', '02', 'Provincia Quillacollo'],
 ['BO', '07', 'Provincia Quijarro'],
 ['BO', '02', 'Provincia Punata'],
 ['BO', '05', 'Provincia Poop\xc3\xb3'],
 ['BO', '05', 'Provincia Pantale\xc3\xb3n Dalence'],
 ['BO', '04', 'Provincia Pacajes'],
 ['BO', '01', 'Provincia Oropeza'],
 ['BO', '04', 'Provincia Omasuyos'],
 ['BO', '09', 'Provincia O\xe2\x80\x99Connor'],
 ['BO', '08', 'Provincia \xc3\x91uflo de Ch\xc3\xa1vez'],
 ['BO', '04', 'Provincia Nor Yungas'],
 ['BO', '07', 'Provincia Nor L\xc3\xadpez'],
 ['BO', '01', 'Provincia Nor Cinti'],
 ['BO', '07', 'Provincia Nor Chichas'],
 ['BO', '06', 'Provincia Nicol\xc3\xa1s Su\xc3\xa1rez'],
 ['BO', '04', 'Provincia Murillo'],
 ['BO', '04', 'Provincia Mu\xc3\xb1ecas'],
 ['BO', '03', 'Provincia Moxos'],
 ['BO', '07', 'Provincia Modesto Omiste'],
 ['BO', '02', 'Provincia Mizque'],
 ['BO', '09', 'Provincia M\xc3\xa9ndez'],
 ['BO', '03', 'Provincia Marb\xc3\xa1n'],
 ['BO', '06', 'Provincia Manuripi'],
 ['BO', '08', 'Provincia Manuel Mar\xc3\xada Caballero'],
 ['BO', '04', 'Provincia Manco Kapac'],
 ['BO', '03', 'Provincia Mamor\xc3\xa9'],
 ['BO', '06', 'Provincia Madre de Dios'],
 ['BO', '01', 'Provincia Luis Calvo'],
 ['BO', '04', 'Provincia Los Andes'],
 ['BO', '04', 'Provincia Loayza'],
 ['BO', '05', 'Provincia Litoral'],
 ['BO', '07', 'Provincia Linares'],
 ['BO', '04', 'Provincia Larecaja'],
 ['BO', '05', 'Provincia Ladislao Cabrera'],
 ['BO', '04', 'Provincia Iturralde'],
 ['BO', '03', 'Provincia It\xc3\xa9nez'],
 ['BO', '04', 'Provincia Inquisivi'],
 ['BO', '04', 'Provincia Ingavi'],
 ['BO', '08', 'Provincia Ichilo'],
 ['BO', '01', 'Provincia Hernando Siles'],
 ['BO', '04', 'Provincia Gualberto Villarroel'],
 ['BO', '09', 'Provincia Gran Chaco'],
 ['BO', '02', 'Provincia Germ\xc3\xa1n Jord\xc3\xa1n'],
 ['BO', '03', 'Provincia General Jos\xc3\xa9 Ballivi\xc3\xa1n'],
 ['BO', '06', 'Provincia General Federico Rom\xc3\xa1n'],
 ['BO', '07', 'Provincia General Bilbao'],
 ['BO', '04', 'Provincia Franz Tamayo'],
 ['BO', '08', 'Provincia Florida'],
 ['BO', '02', 'Provincia Esteban Arce'],
 ['BO', '07', 'Provincia Daniel Campos'],
 ['BO', '08', 'Provincia Cordillera'],
 ['BO', '07', 'Provincia Chayanta'],
 ['BO', '07', 'Provincia Charcas'],
 ['BO', '02', 'Provincia Chapar\xc3\xa9'],
 ['BO', '09', 'Provincia Cercado'],
 ['BO', '05', 'Provincia Cercado'],
 ['BO', '02', 'Provincia Cercado'],
 ['BO', '03', 'Provincia Cercado'],
 ['BO', '02', 'Provincia Carrasco'],
 ['BO', '05', 'Provincia Carangas'],
 ['BO', '02', 'Provincia Capinota'],
 ['BO', '02', 'Provincia Campero'],
 ['BO', '04', 'Provincia Camacho'],
 ['BO', '01', 'Provincia Belisario Boeto'],
 ['BO', '04', 'Provincia Bautista Saavedra'],
 ['BO', '01', 'Provincia Azurduy'],
 ['BO', '02', 'Provincia Ayopaya'],
 ['BO', '09', 'Provincia Avilez'],
 ['BO', '05', 'Provincia Avaroa'],
 ['BO', '05', 'Provincia Atahuallpa'],
 ['BO', '02', 'Provincia Arque'],
 ['BO', '04', 'Provincia Aroma'],
 ['BO', '09', 'Provincia Arce'],
 ['BO', '02', 'Provincia Arani'],
 ['BO', '08', 'Provincia Andr\xc3\xa9s Ib\xc3\xa1\xc3\xb1ez'],
 ['BO', '07', 'Provincia Alonzo de Ib\xc3\xa1\xc3\xb1ez'],
 ['BO', '06', 'Provincia Abun\xc3\xa1'],
 ['BO', '02', 'Bolivar'],
 ['BO', '04', 'Abel Iturralde'],
 ['BO', '02', 'Tiraque Province'],
 ['BR', '06', 'Vi\xc3\xa7osa do Cear\xc3\xa1'],
 ['BR', '06', 'V\xc3\xa1rzea Alegre'],
 ['BR', '06', 'Umari'],
 ['BR', '06', 'Ubajara'],
 ['BR', '13', 'Tut\xc3\xb3ia'],
 ['BR', '02', 'Traipu'],
 ['BR', '30', 'Timba\xc3\xbaba'],
 ['BR', '06', 'Tiangu\xc3\xa1'],
 ['BR', '06', 'Tau\xc3\xa1'],
 ['BR', '06', 'Tamboril'],
 ['BR', '06', 'Solon\xc3\xb3pole'],
 ['BR', '06', 'Sobral'],
 ['BR', '06', 'Senador Pompeu'],
 ['BR', '06', 'S\xc3\xa3o Benedito'],
 ['BR', '06', 'Santa Quit\xc3\xa9ria'],
 ['BR', '02', 'Santana do Ipanema'],
 ['BR', '06', 'Santana do Cariri'],
 ['BR', '06', 'Saboeiro'],
 ['BR', '06', 'Russas'],
 ['BR', '06', 'Reriutaba'],
 ['BR', '06', 'Quixeramobim'],
 ['BR', '06', 'Quixad\xc3\xa1'],
 ['BR', '28', 'Porto da Folha'],
 ['BR', '06', 'Porteiras'],
 ['BR', '28', 'Po\xc3\xa7o Redondo'],
 ['BR', '02', 'Piranhas'],
 ['BR', '06', 'Pereiro'],
 ['BR', '06', 'Pentecoste'],
 ['BR', '06', 'Pedra Branca'],
 ['BR', '06', 'Parambu'],
 ['BR', '02', 'P\xc3\xa3o de A\xc3\xa7\xc3\xbacar'],
 ['BR', '02', 'Palmeira dos \xc3\x8dndios'],
 ['BR', '06', 'Pacoti'],
 ['BR', '06', 'Pacatuba'],
 ['BR', '02', "Olho d'\xc3\x81gua das Flores"],
 ['BR', '06', 'Nova Russas'],
 ['BR', '28', 'Ne\xc3\xb3polis'],
 ['BR', '06', 'Mucambo'],
 ['BR', '17', 'Monteiro'],
 ['BR', '06', 'Monsenhor Tabosa'],
 ['BR', '06', 'Momba\xc3\xa7a'],
 ['BR', '06', 'Miss\xc3\xa3o Velha'],
 ['BR', '06', 'Milagres'],
 ['BR', '06', 'Meruoca'],
 ['BR', '06', 'Mauriti'],
 ['BR', '02', 'Mata Grande'],
 ['BR', '06', 'Massap\xc3\xaa'],
 ['BR', '06', 'Maranguape'],
 ['BR', '02', 'Major Isidoro'],
 ['BR', '06', 'Limoeiro do Norte'],
 ['BR', '02', 'Limoeiro de Anadia'],
 ['BR', '06', 'Lavras da Mangabeira'],
 ['BR', '02', 'Junqueiro'],
 ['BR', '06', 'Juc\xc3\xa1s'],
 ['BR', '06', 'Juazeiro do Norte'],
 ['BR', '06', 'Jati'],
 ['BR', '06', 'Jardim'],
 ['BR', '06', 'Jaguaruana'],
 ['BR', '06', 'Jaguaribe'],
 ['BR', '06', 'Jaguaretama'],
 ['BR', '06', 'Itatira'],
 ['BR', '06', 'Itapag\xc3\xa9'],
 ['BR', '16', 'Itaituba'],
 ['BR', '06', 'Itai\xc3\xa7aba'],
 ['BR', '06', 'Iracema'],
 ['BR', '06', 'Ipueiras'],
 ['BR', '06', 'Ipu'],
 ['BR', '06', 'Ipaumirim'],
 ['BR', '06', 'Independ\xc3\xaancia'],
 ['BR', '06', 'Iguatu'],
 ['BR', '06', 'Ic\xc3\xb3'],
 ['BR', '06', 'Ibiapina'],
 ['BR', '31', 'Guara\xc3\xad'],
 ['BR', '06', 'Guaraciaba do Norte'],
 ['BR', '06', 'Frecheirinha'],
 ['BR', '30', 'Fernando de Noronha'],
 ['BR', '02', 'Feira Grande'],
 ['BR', '06', 'Farias Brito'],
 ['BR', '02', 'Delmiro Gouveia'],
 ['BR', '06', 'Crato'],
 ['BR', '06', 'Crate\xc3\xbas'],
 ['BR', '06', 'Corea\xc3\xba'],
 ['BR', '06', 'Cedro'],
 ['BR', '16', 'Castanhal'],
 ['BR', '06', 'Cari\xc3\xbas'],
 ['BR', '06', 'Cariria\xc3\xa7u'],
 ['BR', '06', 'Carir\xc3\xa9'],
 ['BR', '06', 'Capistrano'],
 ['BR', '06', 'Canind\xc3\xa9'],
 ['BR', '06', 'Campos Sales'],
 ['BR', '06', 'Brejo Santo'],
 ['BR', '16', 'Bragan\xc3\xa7a'],
 ['BR', '06', 'Boa Viagem'],
 ['BR', '06', 'Baturit\xc3\xa9'],
 ['BR', '02', 'Batalha'],
 ['BR', '06', 'Barro'],
 ['BR', '06', 'Barbalha'],
 ['BR', '06', 'Baixio'],
 ['BR', '06', 'Aurora'],
 ['BR', '06', 'Assar\xc3\xa9'],
 ['BR', '17', 'Areia'],
 ['BR', '06', 'Araripe'],
 ['BR', '02', 'Arapiraca'],
 ['BR', '06', 'Aracoiaba'],
 ['BR', '02', 'Anadia'],
 ['BR', '06', 'Aiuaba'],
 ['BR', '02', '\xc3\x81gua Branca'],
 ['BR', '28', 'Tomar do Geru'],
 ['BR', '28', 'Tobias Barreto'],
 ['BR', '27', 'Tejup\xc3\xa1'],
 ['BR', '23', 'Soledade'],
 ['BR', '28', 'Sim\xc3\xa3o Dias'],
 ['BR', '27', 'Sert\xc3\xa3ozinho'],
 ['BR', '27', 'S\xc3\xa3o Vicente'],
 ['BR', '27', 'S\xc3\xa3o Pedro'],
 ['BR', '23', 'S\xc3\xa3o Francisco de Paula'],
 ['BR', '02', 'S\xc3\xa3o Br\xc3\xa1s'],
 ['BR', '23', 'Rio Grande'],
 ['BR', '28', 'Ribeir\xc3\xb3polis'],
 ['BR', '28', 'Riach\xc3\xa3o do Dantas'],
 ['BR', '18', 'Realeza'],
 ['BR', '28', 'Propri\xc3\xa1'],
 ['BR', '02', 'Porto Real do Col\xc3\xa9gio'],
 ['BR', '28', 'Po\xc3\xa7o Verde'],
 ['BR', '28', 'Pinh\xc3\xa3o'],
 ['BR', '02', 'Penedo'],
 ['BR', '23', 'Pelotas'],
 ['BR', '27', 'Patroc\xc3\xadnio Paulista'],
 ['BR', '15', 'Ouro Fino'],
 ['BR', '28', 'Nossa Senhora das Dores'],
 ['BR', '28', 'Nossa Senhora da Gl\xc3\xb3ria'],
 ['BR', '28', 'Monte Alegre de Sergipe'],
 ['BR', '15', 'Matias Barbosa'],
 ['BR', '15', 'Mar de Espanha'],
 ['BR', '28', 'Macambira'],
 ['BR', '14', 'Luci\xc3\xa1ra'],
 ['BR', '27', 'Lind\xc3\xb3ia'],
 ['BR', '23', 'Lagoa Vermelha'],
 ['BR', '28', 'Lagarto'],
 ['BR', '15', 'Juiz de Fora'],
 ['BR', '27', 'Itirapu\xc3\xa3'],
 ['BR', '26', 'Itapema'],
 ['BR', '28', 'Itabi'],
 ['BR', '28', 'Itabaianinha'],
 ['BR', '02', 'Igreja Nova'],
 ['BR', '23', 'Herval'],
 ['BR', '28', 'Gararu'],
 ['BR', '28', 'Frei Paulo'],
 ['BR', '20', 'Curimat\xc3\xa1'],
 ['BR', '28', 'Cumbe'],
 ['BR', '26', 'Conc\xc3\xb3rdia'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o do Mato Dentro'],
 ['BR', '27', 'Charqueada'],
 ['BR', '28', 'Cedro de S\xc3\xa3o Jo\xc3\xa3o'],
 ['BR', '28', 'Carira'],
 ['BR', '23', 'Carazinho'],
 ['BR', '28', 'Canhoba'],
 ['BR', '05', 'Candeias'],
 ['BR', '27', 'Campo Limpo Paulista'],
 ['BR', '28', 'Campo do Brito'],
 ['BR', '23', 'Campo Bom'],
 ['BR', '05', 'Barreiras'],
 ['BR', '28', 'Aquidab\xc3\xa3'],
 ['BR', '23', 'Ant\xc3\xb4nio Prado'],
 ['BR', '27', 'Anal\xc3\xa2ndia'],
 ['BR', '28', 'Amparo de S\xc3\xa3o Francisco'],
 ['BR', '27', 'Amparo'],
 ['BR', '27', 'Am\xc3\xa9rico de Campos'],
 ['BR', '27', 'Americana'],
 ['BR', '27', '\xc3\x81lvaro de Carvalho'],
 ['BR', '27', '\xc3\x81lvares Machado'],
 ['BR', '27', '\xc3\x81lvares Florence'],
 ['BR', '27', 'Alto Alegre'],
 ['BR', '27', 'Altin\xc3\xb3polis'],
 ['BR', '27', 'Alfredo Marcondes'],
 ['BR', '05', 'Alagoinhas'],
 ['BR', '27', 'Agudos'],
 ['BR', '27', '\xc3\x81guas de S\xc3\xa3o Pedro'],
 ['BR', '27', '\xc3\x81guas da Prata'],
 ['BR', '27', 'Agua\xc3\xad'],
 ['BR', '27', 'Adamantina'],
 ['BR', '04', 'L\xc3\xa1brea'],
 ['BR', '24', 'Guajar\xc3\xa1-Mirim'],
 ['BR', '11', 'Figueir\xc3\xa3o'],
 ['BR', '23', 'S\xc3\xa3o Jos\xc3\xa9 do Sul'],
 ['BR', '23', 'Cap\xc3\xa3o do Cip\xc3\xb3'],
 ['BR', '04', 'Santo Ant\xc3\xb4nio do I\xc3\xa7\xc3\xa1'],
 ['BR', '16', 'Reden\xc3\xa7\xc3\xa3o'],
 ['BR', '16', 'Santa Cruz do Arari'],
 ['BR', '16', 'Santa Luzia do Par\xc3\xa1'],
 ['BR', '16', 'S\xc3\xa3o Miguel do Guam\xc3\xa1'],
 ['BR', '31', "Pau d'Arco"],
 ['BR', '31', 'Santa F\xc3\xa9 do Araguaia'],
 ['BR', '31', 'Santa Maria do Tocantins'],
 ['BR', '13', 'A\xc3\xa7ail\xc3\xa2ndia'],
 ['BR', '13', 'Alto Alegre do Pindar\xc3\xa9'],
 ['BR', '13', 'Bar\xc3\xa3o de Graja\xc3\xba'],
 ['BR', '13', 'Chapadinha'],
 ['BR', '13', 'Concei\xc3\xa7\xc3\xa3o do Lago-A\xc3\xa7u'],
 ['BR', '13', 'Governador Archer'],
 ['BR', '13', 'Mon\xc3\xa7\xc3\xa3o'],
 ['BR', '13', 'Nina Rodrigues'],
 ['BR', '13', 'Santa Luzia'],
 ['BR', '13', 'Santa Luzia do Paru\xc3\xa1'],
 ['BR', '13', 'Santa Rita'],
 ['BR', '13', 'S\xc3\xa3o Jo\xc3\xa3o do Para\xc3\xadso'],
 ['BR', '20', 'Beneditinos'],
 ['BR', '20', 'Caridade do Piau\xc3\xad'],
 ['BR', '20', 'Curral Novo do Piau\xc3\xad'],
 ['BR', '20', 'Dirceu Arcoverde'],
 ['BR', '20', 'Fronteiras'],
 ['BR', '20', 'Jatob\xc3\xa1 do Piau\xc3\xad'],
 ['BR', '20', 'Jerumenha'],
 ['BR', '20', 'Parnagu\xc3\xa1'],
 ['BR', '20', 'Pedro Laurentino'],
 ['BR', '20', 'Santa Cruz dos Milagres'],
 ['BR', '20', 'S\xc3\xa3o F\xc3\xa9lix do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Jos\xc3\xa9 do Piau\xc3\xad'],
 ['BR', '20', 'Sim\xc3\xb5es'],
 ['BR', '22', 'Alexandria'],
 ['BR', '22', 'Angicos'],
 ['BR', '22', 'Bom Jesus'],
 ['BR', '22', 'Carna\xc3\xbaba dos Dantas'],
 ['BR', '22', 'Equador'],
 ['BR', '22', 'Ja\xc3\xa7an\xc3\xa3'],
 ['BR', '22', 'Jucurutu'],
 ['BR', '22', 'Maxaranguape'],
 ['BR', '22', 'Mossor\xc3\xb3'],
 ['BR', '22', 'N\xc3\xadsia Floresta'],
 ['BR', '22', 'Para\xc3\xba'],
 ['BR', '22', 'Patu'],
 ['BR', '22', 'Pureza'],
 ['BR', '22', 'S\xc3\xa3o Tom\xc3\xa9'],
 ['BR', '22', 'Touros'],
 ['BR', '17', 'Alhandra'],
 ['BR', '17', 'Aparecida'],
 ['BR', '17', 'Boqueir\xc3\xa3o'],
 ['BR', '17', 'Cachoeira dos \xc3\x8dndios'],
 ['BR', '17', 'Cajazeiras'],
 ['BR', '17', 'Concei\xc3\xa7\xc3\xa3o'],
 ['BR', '17', 'Cruz do Esp\xc3\xadrito Santo'],
 ['BR', '17', 'Curral de Cima'],
 ['BR', '17', 'Frei Martinho'],
 ['BR', '17', 'Ibiara'],
 ['BR', '17', 'Lagoa'],
 ['BR', '17', 'Lagoa Seca'],
 ['BR', '17', 'Mamanguape'],
 ['BR', '17', 'Mataraca'],
 ['BR', '17', 'Pocinhos'],
 ['BR', '17', 'Pombal'],
 ['BR', '17', 'Rio Tinto'],
 ['BR', '17', 'Santa Rita'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 do Bonfim'],
 ['BR', '17', 'Sousa'],
 ['BR', '17', 'Triunfo'],
 ['BR', '17', 'Zabel\xc3\xaa'],
 ['BR', '30', 'Araripina'],
 ['BR', '30', 'Correntes'],
 ['BR', '30', 'S\xc3\xa3o Benedito do Sul'],
 ['BR', '02', 'Barra de Santo Ant\xc3\xb4nio'],
 ['BR', '02', 'Canapi'],
 ['BR', '02', 'S\xc3\xa3o Sebasti\xc3\xa3o'],
 ['BR', '05', 'Belmonte'],
 ['BR', '05', 'Brej\xc3\xb5es'],
 ['BR', '05', "Dias d'\xc3\x81vila"],
 ['BR', '05', 'Dom Bas\xc3\xadlio'],
 ['BR', '05', 'Ia\xc3\xa7u'],
 ['BR', '05', 'Ituber\xc3\xa1'],
 ['BR', '05', 'Lagoa Real'],
 ['BR', '05', 'Muqu\xc3\xa9m de S\xc3\xa3o Francisco'],
 ['BR', '05', 'Nilo Pe\xc3\xa7anha'],
 ['BR', '05', 'Nordestina'],
 ['BR', '05', 'Nova Vi\xc3\xa7osa'],
 ['BR', '05', 'Oliveira dos Brejinhos'],
 ['BR', '05', 'Po\xc3\xa7\xc3\xb5es'],
 ['BR', '05', 'Presidente Tancredo Neves'],
 ['BR', '05', 'Santa Maria da Vit\xc3\xb3ria'],
 ['BR', '05', 'Santana'],
 ['BR', '05', 'Tremedal'],
 ['BR', '05', 'Umburanas'],
 ['BR', '05', 'Una'],
 ['BR', '15', 'Al\xc3\xa9m Para\xc3\xadba'],
 ['BR', '15', 'Ara\xc3\xa7a\xc3\xad'],
 ['BR', '15', 'Consola\xc3\xa7\xc3\xa3o'],
 ['BR', '15', 'Guidoval'],
 ['BR', '15', 'Guimar\xc3\xa2nia'],
 ['BR', '15', 'Patroc\xc3\xadnio do Muria\xc3\xa9'],
 ['BR', '15', 'Santa B\xc3\xa1rbara do Tug\xc3\xbario'],
 ['BR', '15', 'S\xc3\xa3o Br\xc3\xa1s do Sua\xc3\xa7u\xc3\xad'],
 ['BR', '08', 'S\xc3\xa3o Jos\xc3\xa9 do Cal\xc3\xa7ado'],
 ['BR', '21', 'Areal'],
 ['BR', '21', 'Arma\xc3\xa7\xc3\xa3o dos B\xc3\xbazios'],
 ['BR', '21', 'Concei\xc3\xa7\xc3\xa3o de Macabu'],
 ['BR', '27', 'Assis'],
 ['BR', '27', 'Divinol\xc3\xa2ndia'],
 ['BR', '27', 'Guara\xc3\xa7a\xc3\xad'],
 ['BR', '27', 'Igarapava'],
 ['BR', '27', 'Jos\xc3\xa9 Bonif\xc3\xa1cio'],
 ['BR', '27', 'Lu\xc3\xads Ant\xc3\xb4nio'],
 ['BR', '27', 'Lup\xc3\xa9rcio'],
 ['BR', '27', 'Lut\xc3\xa9cia'],
 ['BR', '27', 'Nova Cana\xc3\xa3 Paulista'],
 ['BR', '27', 'Nova Castilho'],
 ['BR', '27', 'Saltinho'],
 ['BR', '18', 'Iva\xc3\xad'],
 ['BR', '18', 'Ivaipor\xc3\xa3'],
 ['BR', '18', 'Lupion\xc3\xb3polis'],
 ['BR', '18', 'Planaltina do Paran\xc3\xa1'],
 ['BR', '18', 'Santa Cec\xc3\xadlia do Pav\xc3\xa3o'],
 ['BR', '18', 'Santa Cruz de Monte Castelo'],
 ['BR', '18', 'Santa F\xc3\xa9'],
 ['BR', '18', 'Santana do Itarar\xc3\xa9'],
 ['BR', '18', 'Santo Ant\xc3\xb4nio do Para\xc3\xadso'],
 ['BR', '18', 'S\xc3\xa3o Jos\xc3\xa9 da Boa Vista'],
 ['BR', '18', 'S\xc3\xa3o Jos\xc3\xa9 das Palmeiras'],
 ['BR', '18', 'Serran\xc3\xb3polis do Igua\xc3\xa7u'],
 ['BR', '18', 'Tr\xc3\xaas Barras do Paran\xc3\xa1'],
 ['BR', '26', 'Campo Er\xc3\xaa'],
 ['BR', '26', 'Correia Pinto'],
 ['BR', '26', 'Crici\xc3\xbama'],
 ['BR', '26', 'Para\xc3\xadso'],
 ['BR', '26', 'Passos Maia'],
 ['BR', '26', 'S\xc3\xa3o Louren\xc3\xa7o do Oeste'],
 ['BR', '23', 'Barros Cassal'],
 ['BR', '23', 'Boqueir\xc3\xa3o do Le\xc3\xa3o'],
 ['BR', '23', 'Cerro Grande'],
 ['BR', '23', 'David Canabarro'],
 ['BR', '23', 'Derrubadas'],
 ['BR', '23', 'Jaguari'],
 ['BR', '23', 'Marques de Souza'],
 ['BR', '23', 'Monte Belo do Sul'],
 ['BR', '23', 'Morma\xc3\xa7o'],
 ['BR', '23', 'Nova Boa Vista'],
 ['BR', '23', 'Nova Candel\xc3\xa1ria'],
 ['BR', '14', 'S\xc3\xa3o Jos\xc3\xa9 do Povo'],
 ['BR', '14', 'Nova Maril\xc3\xa2ndia'],
 ['BR', '14', 'Nova Maring\xc3\xa1'],
 ['BR', '29', '\xc3\x81gua Fria de Goi\xc3\xa1s'],
 ['BR', '29', 'Alto Para\xc3\xadso de Goi\xc3\xa1s'],
 ['BR', '29', 'Auril\xc3\xa2ndia'],
 ['BR', '29', 'Baliza'],
 ['BR', '29', 'Chapad\xc3\xa3o do C\xc3\xa9u'],
 ['BR', '29', 'Divin\xc3\xb3polis de Goi\xc3\xa1s'],
 ['BR', '29', 'Santa B\xc3\xa1rbara de Goi\xc3\xa1s'],
 ['BR', '29', 'Santo Ant\xc3\xb4nio do Descoberto'],
 ['BR', '29', 'S\xc3\xa3o Domingos'],
 ['BR', '29', 'S\xc3\xa3o Francisco de Goi\xc3\xa1s'],
 ['BR', '29', 'Senador Canedo'],
 ['BR', '29', 'Serran\xc3\xb3polis'],
 ['BR', '29', 'Simol\xc3\xa2ndia'],
 ['BR', '14', 'S\xc3\xa3o Jos\xc3\xa9 do Xingu'],
 ['BR', '29', 'Gameleira de Goi\xc3\xa1s'],
 ['BR', '02', 'Coruripe'],
 ['BR', '17', 'Paulista'],
 ['BR', '18', 'S\xc3\xa3o Jo\xc3\xa3o'],
 ['BR', '06', 'Apuiar\xc3\xa9s'],
 ['BR', '06', 'Quixel\xc3\xb4'],
 ['BR', '06', 'Reden\xc3\xa7\xc3\xa3o'],
 ['BR', '28', 'Canind\xc3\xa9 de S\xc3\xa3o Francisco'],
 ['BR', '23', 'S\xc3\xa3o Luiz Gonzaga'],
 ['BR', '23', 'Caibat\xc3\xa9'],
 ['BR', '23', 'Rolador'],
 ['BR', '23', 'Mato Queimado'],
 ['BR', '23', 'Westfalia'],
 ['BR', '23', 'Teut\xc3\xb4nia'],
 ['BR', '23', 'Terra de Areia'],
 ['BR', '23', 'Sobradinho'],
 ['BR', '05', 'Serrinha'],
 ['BR', '14', 'Serra Nova Dourada'],
 ['BR', '23', 'S\xc3\xa3o Pedro das Miss\xc3\xb5es'],
 ['BR', '23', 'S\xc3\xa3o Miguel das Miss\xc3\xb5es'],
 ['BR', '14', 'S\xc3\xa3o F\xc3\xa9lix do Araguaia'],
 ['BR', '23', 'Santiago'],
 ['BR', '23', 'Santa Margarida do Sul'],
 ['BR', '23', 'Salvador do Sul'],
 ['BR', '23', 'Roca Sales'],
 ['BR', '14', 'Ribeir\xc3\xa3o Cascalheira'],
 ['BR', '23', 'Relvado'],
 ['BR', '23', 'Quatro Irm\xc3\xa3os'],
 ['BR', '23', 'Progresso'],
 ['BR', '23', 'Ponte Preta'],
 ['BR', '23', 'Paulo Bento'],
 ['BR', '20', "Pau D'arco do Piau\xc3\xad"],
 ['BR', '23', 'Palmeira das Miss\xc3\xb5es'],
 ['BR', '14', 'Novo Santo Ant\xc3\xb4nio'],
 ['BR', '14', 'Nova Nazar\xc3\xa9'],
 ['BR', '21', 'Nova Igua\xc3\xa7u'],
 ['BR', '23', 'Nova Br\xc3\xa9scia'],
 ['BR', '23', 'Montenegro'],
 ['BR', '21', 'Mesquita'],
 ['BR', '23', 'Marat\xc3\xa1'],
 ['BR', '23', 'Lajeado'],
 ['BR', '23', 'Lagoa Bonita do Sul'],
 ['BR', '02', 'Jequi\xc3\xa1 da Praia'],
 ['BR', '23', 'Jacutinga'],
 ['BR', '23', 'Itati'],
 ['BR', '23', 'Imigrante'],
 ['BR', '23', 'Garibaldi'],
 ['BR', '23', 'Forquetinha'],
 ['BR', '23', 'Erechim'],
 ['BR', '23', 'Cruzaltense'],
 ['BR', '23', 'Coronel Pilar'],
 ['BR', '23', 'Coqueiro Baixo'],
 ['BR', '14', 'Cocalinho'],
 ['BR', '23', 'Canudos do Vale'],
 ['BR', '23', 'Campinas do Sul'],
 ['BR', '14', 'Bom Jesus do Araguaia'],
 ['BR', '23', 'Bento Gon\xc3\xa7alves'],
 ['BR', '05', 'Barrocas'],
 ['BR', '20', 'Altos'],
 ['BR', '14', 'Alto Boa Vista'],
 ['BR', '14', '\xc3\x81gua Boa'],
 ['BR', '23', 'Acegu\xc3\xa1'],
 ['BR', '14', "Mirassol d'Oeste"],
 ['BR', '14', "Lambari d'Oeste"],
 ['BR', '14', 'Curvel\xc3\xa2ndia'],
 ['BR', '14', 'C\xc3\xa1ceres'],
 ['BR', '24', "Alta Floresta d'Oeste"],
 ['BR', '24', 'Ariquemes'],
 ['BR', '24', 'Cabixi'],
 ['BR', '24', 'Cacoal'],
 ['BR', '24', 'Cerejeiras'],
 ['BR', '24', 'Colorado do Oeste'],
 ['BR', '24', 'Corumbiara'],
 ['BR', '24', 'Costa Marques'],
 ['BR', '24', "Espig\xc3\xa3o d'Oeste"],
 ['BR', '24', 'Ji-Paran\xc3\xa1'],
 ['BR', '24', "Machadinho d'Oeste"],
 ['BR', '24', "Nova Brasil\xc3\xa2ndia d'Oeste"],
 ['BR', '24', 'Ouro Preto do Oeste'],
 ['BR', '24', 'Pimenta Bueno'],
 ['BR', '24', 'Porto Velho'],
 ['BR', '24', 'Presidente M\xc3\xa9dici'],
 ['BR', '24', 'Rio Crespo'],
 ['BR', '24', 'Rolim de Moura'],
 ['BR', '24', "Santa Luzia d'Oeste"],
 ['BR', '24', 'Vilhena'],
 ['BR', '24', 'S\xc3\xa3o Miguel do Guapor\xc3\xa9'],
 ['BR', '24', "Alvorada d'Oeste"],
 ['BR', '24', 'Alto Alegre dos Parecis'],
 ['BR', '24', 'Alto Para\xc3\xadso'],
 ['BR', '24', 'Buritis'],
 ['BR', '24', 'Novo Horizonte do Oeste'],
 ['BR', '24', 'Cacaul\xc3\xa2ndia'],
 ['BR', '24', 'Campo Novo de Rond\xc3\xb4nia'],
 ['BR', '24', 'Candeias do Jamari'],
 ['BR', '24', 'Castanheiras'],
 ['BR', '24', 'Chupinguaia'],
 ['BR', '24', 'Cujubim'],
 ['BR', '24', 'Itapu\xc3\xa3 do Oeste'],
 ['BR', '24', 'Ministro Andreazza'],
 ['BR', '24', 'Monte Negro'],
 ['BR', '24', 'Nova Uni\xc3\xa3o'],
 ['BR', '24', 'Parecis'],
 ['BR', '24', 'Pimenteiras do Oeste'],
 ['BR', '24', 'Primavera de Rond\xc3\xb4nia'],
 ['BR', '24', "S\xc3\xa3o Felipe d'Oeste"],
 ['BR', '24', 'S\xc3\xa3o Francisco do Guapor\xc3\xa9'],
 ['BR', '24', 'Seringueiras'],
 ['BR', '24', 'Teixeir\xc3\xb3polis'],
 ['BR', '24', 'Theobroma'],
 ['BR', '24', 'Urup\xc3\xa1'],
 ['BR', '24', 'Vale do Anari'],
 ['BR', '24', 'Vale do Para\xc3\xadso'],
 ['BR', '01', 'Acrel\xc3\xa2ndia'],
 ['BR', '01', 'Assis Brasil'],
 ['BR', '01', 'Brasil\xc3\xa9ia'],
 ['BR', '01', 'Bujari'],
 ['BR', '01', 'Capixaba'],
 ['BR', '01', 'Cruzeiro do Sul'],
 ['BR', '01', 'Epitaciol\xc3\xa2ndia'],
 ['BR', '01', 'Jord\xc3\xa3o'],
 ['BR', '01', 'M\xc3\xa2ncio Lima'],
 ['BR', '01', 'Marechal Thaumaturgo'],
 ['BR', '01', 'Pl\xc3\xa1cido de Castro'],
 ['BR', '01', 'Porto Walter'],
 ['BR', '01', 'Rio Branco'],
 ['BR', '01', 'Rodrigues Alves'],
 ['BR', '01', 'Senador Guiomard'],
 ['BR', '01', 'Tarauac\xc3\xa1'],
 ['BR', '01', 'Xapuri'],
 ['BR', '01', 'Porto Acre'],
 ['BR', '04', 'Alvar\xc3\xa3es'],
 ['BR', '04', 'Amatur\xc3\xa1'],
 ['BR', '04', 'Anam\xc3\xa3'],
 ['BR', '04', 'Anori'],
 ['BR', '04', 'Apu\xc3\xad'],
 ['BR', '04', 'Atalaia do Norte'],
 ['BR', '04', 'Autazes'],
 ['BR', '04', 'Barcelos'],
 ['BR', '04', 'Barreirinha'],
 ['BR', '04', 'Benjamin Constant'],
 ['BR', '04', 'Beruri'],
 ['BR', '04', 'Boa Vista do Ramos'],
 ['BR', '04', 'Boca do Acre'],
 ['BR', '04', 'Borba'],
 ['BR', '04', 'Caapiranga'],
 ['BR', '04', 'Carauari'],
 ['BR', '04', 'Careiro'],
 ['BR', '04', 'Careiro da V\xc3\xa1rzea'],
 ['BR', '04', 'Codaj\xc3\xa1s'],
 ['BR', '04', 'Eirunep\xc3\xa9'],
 ['BR', '04', 'Envira'],
 ['BR', '04', 'Fonte Boa'],
 ['BR', '04', 'Guajar\xc3\xa1'],
 ['BR', '04', 'Humait\xc3\xa1'],
 ['BR', '04', 'Ipixuna'],
 ['BR', '04', 'Iranduba'],
 ['BR', '04', 'Itacoatiara'],
 ['BR', '04', 'Itamarati'],
 ['BR', '04', 'Itapiranga'],
 ['BR', '04', 'Japur\xc3\xa1'],
 ['BR', '04', 'Juru\xc3\xa1'],
 ['BR', '04', 'Juta\xc3\xad'],
 ['BR', '04', 'Manacapuru'],
 ['BR', '04', 'Manaquiri'],
 ['BR', '04', 'Manaus'],
 ['BR', '04', 'Manicor\xc3\xa9'],
 ['BR', '04', 'Mara\xc3\xa3'],
 ['BR', '04', 'Mau\xc3\xa9s'],
 ['BR', '04', 'Nhamund\xc3\xa1'],
 ['BR', '04', 'Nova Olinda do Norte'],
 ['BR', '04', 'Novo Air\xc3\xa3o'],
 ['BR', '04', 'Novo Aripuan\xc3\xa3'],
 ['BR', '04', 'Parintins'],
 ['BR', '04', 'Pauini'],
 ['BR', '04', 'Presidente Figueiredo'],
 ['BR', '04', 'Rio Preto da Eva'],
 ['BR', '04', 'Santa Isabel do Rio Negro'],
 ['BR', '04', 'S\xc3\xa3o Gabriel da Cachoeira'],
 ['BR', '04', 'S\xc3\xa3o Paulo de Oliven\xc3\xa7a'],
 ['BR', '04', 'S\xc3\xa3o Sebasti\xc3\xa3o do Uatum\xc3\xa3'],
 ['BR', '04', 'Silves'],
 ['BR', '04', 'Tabatinga'],
 ['BR', '04', 'Tef\xc3\xa9'],
 ['BR', '04', 'Tonantins'],
 ['BR', '04', 'Uarini'],
 ['BR', '04', 'Urucar\xc3\xa1'],
 ['BR', '04', 'Urucurituba'],
 ['BR', '25', 'Amajari'],
 ['BR', '25', 'Boa Vista'],
 ['BR', '25', 'Bonfim'],
 ['BR', '25', 'Cant\xc3\xa1'],
 ['BR', '25', 'Caroebe'],
 ['BR', '25', 'Mucaja\xc3\xad'],
 ['BR', '25', 'Normandia'],
 ['BR', '25', 'Pacaraima'],
 ['BR', '25', 'S\xc3\xa3o Jo\xc3\xa3o da Baliza'],
 ['BR', '25', 'S\xc3\xa3o Luiz'],
 ['BR', '25', 'Uiramut\xc3\xa3'],
 ['BR', '16', 'Abaetetuba'],
 ['BR', '16', 'Abel Figueiredo'],
 ['BR', '16', 'Acar\xc3\xa1'],
 ['BR', '16', 'Afu\xc3\xa1'],
 ['BR', '16', '\xc3\x81gua Azul do Norte'],
 ['BR', '16', 'Alenquer'],
 ['BR', '16', 'Anaj\xc3\xa1s'],
 ['BR', '16', 'Ananindeua'],
 ['BR', '16', 'Anapu'],
 ['BR', '16', 'Augusto Corr\xc3\xaaa'],
 ['BR', '16', 'Aurora do Par\xc3\xa1'],
 ['BR', '16', 'Bagre'],
 ['BR', '16', 'Bai\xc3\xa3o'],
 ['BR', '16', 'Bannach'],
 ['BR', '16', 'Barcarena'],
 ['BR', '16', 'Bel\xc3\xa9m'],
 ['BR', '16', 'Belterra'],
 ['BR', '16', 'Benevides'],
 ['BR', '16', 'Bom Jesus do Tocantins'],
 ['BR', '16', 'Bonito'],
 ['BR', '16', 'Brasil Novo'],
 ['BR', '16', 'Brejo Grande do Araguaia'],
 ['BR', '16', 'Breu Branco'],
 ['BR', '16', 'Breves'],
 ['BR', '16', 'Bujaru'],
 ['BR', '16', 'Cachoeira do Piri\xc3\xa1'],
 ['BR', '16', 'Cachoeira do Arari'],
 ['BR', '16', 'Camet\xc3\xa1'],
 ['BR', '16', 'Cana\xc3\xa3 dos Caraj\xc3\xa1s'],
 ['BR', '16', 'Capanema'],
 ['BR', '16', 'Capit\xc3\xa3o Po\xc3\xa7o'],
 ['BR', '16', 'Chaves'],
 ['BR', '16', 'Colares'],
 ['BR', '16', 'Concei\xc3\xa7\xc3\xa3o do Araguaia'],
 ['BR', '16', 'Conc\xc3\xb3rdia do Par\xc3\xa1'],
 ['BR', '16', 'Cumaru do Norte'],
 ['BR', '16', 'Curion\xc3\xb3polis'],
 ['BR', '16', 'Curralinho'],
 ['BR', '16', 'Curu\xc3\xa1'],
 ['BR', '16', 'Curu\xc3\xa7\xc3\xa1'],
 ['BR', '16', 'Dom Eliseu'],
 ['BR', '16', 'Eldorado dos Caraj\xc3\xa1s'],
 ['BR', '16', 'Faro'],
 ['BR', '16', 'Floresta do Araguaia'],
 ['BR', '16', 'Garraf\xc3\xa3o do Norte'],
 ['BR', '16', 'Goian\xc3\xa9sia do Par\xc3\xa1'],
 ['BR', '16', 'Gurup\xc3\xa1'],
 ['BR', '16', 'Igarap\xc3\xa9-A\xc3\xa7u'],
 ['BR', '16', 'Igarap\xc3\xa9-Miri'],
 ['BR', '16', 'Ipixuna do Par\xc3\xa1'],
 ['BR', '16', 'Irituia'],
 ['BR', '16', 'Itupiranga'],
 ['BR', '16', 'Jacareacanga'],
 ['BR', '16', 'Jacund\xc3\xa1'],
 ['BR', '16', 'Juruti'],
 ['BR', '16', 'Limoeiro do Ajuru'],
 ['BR', '16', 'M\xc3\xa3e do Rio'],
 ['BR', '16', 'Magalh\xc3\xa3es Barata'],
 ['BR', '16', 'Marab\xc3\xa1'],
 ['BR', '16', 'Maracan\xc3\xa3'],
 ['BR', '16', 'Marapanim'],
 ['BR', '16', 'Marituba'],
 ['BR', '16', 'Medicil\xc3\xa2ndia'],
 ['BR', '16', 'Melga\xc3\xa7o'],
 ['BR', '16', 'Mocajuba'],
 ['BR', '16', 'Moju'],
 ['BR', '16', 'Monte Alegre'],
 ['BR', '16', 'Muan\xc3\xa1'],
 ['BR', '16', 'Nova Esperan\xc3\xa7a do Piri\xc3\xa1'],
 ['BR', '16', 'Nova Ipixuna'],
 ['BR', '16', 'Nova Timboteua'],
 ['BR', '16', 'Novo Progresso'],
 ['BR', '16', 'Novo Repartimento'],
 ['BR', '16', '\xc3\x93bidos'],
 ['BR', '16', 'Oeiras do Par\xc3\xa1'],
 ['BR', '16', 'Oriximin\xc3\xa1'],
 ['BR', '16', 'Our\xc3\xa9m'],
 ['BR', '16', 'Ouril\xc3\xa2ndia do Norte'],
 ['BR', '16', 'Pacaj\xc3\xa1'],
 ['BR', '16', 'Palestina do Par\xc3\xa1'],
 ['BR', '16', 'Paragominas'],
 ['BR', '16', 'Parauapebas'],
 ['BR', '16', "Pau d'Arco"],
 ['BR', '16', 'Peixe-Boi'],
 ['BR', '16', 'Pi\xc3\xa7arra'],
 ['BR', '16', 'Placas'],
 ['BR', '16', 'Ponta de Pedras'],
 ['BR', '16', 'Portel'],
 ['BR', '16', 'Porto de Moz'],
 ['BR', '16', 'Prainha'],
 ['BR', '16', 'Primavera'],
 ['BR', '16', 'Quatipuru'],
 ['BR', '16', 'Rio Maria'],
 ['BR', '16', 'Rondon do Par\xc3\xa1'],
 ['BR', '16', 'Rur\xc3\xb3polis'],
 ['BR', '16', 'Salin\xc3\xb3polis'],
 ['BR', '16', 'Salvaterra'],
 ['BR', '16', 'Santa B\xc3\xa1rbara do Par\xc3\xa1'],
 ['BR', '16', 'Santa Isabel do Par\xc3\xa1'],
 ['BR', '16', 'Santa Maria das Barreiras'],
 ['BR', '16', 'Santa Maria do Par\xc3\xa1'],
 ['BR', '16', 'Santana do Araguaia'],
 ['BR', '16', 'Santar\xc3\xa9m'],
 ['BR', '16', 'Santar\xc3\xa9m Novo'],
 ['BR', '16', 'Santo Ant\xc3\xb4nio do Tau\xc3\xa1'],
 ['BR', '16', 'S\xc3\xa3o Caetano de Odivelas'],
 ['BR', '16', 'S\xc3\xa3o Domingos do Araguaia'],
 ['BR', '16', 'S\xc3\xa3o Domingos do Capim'],
 ['BR', '16', 'S\xc3\xa3o F\xc3\xa9lix do Xingu'],
 ['BR', '16', 'S\xc3\xa3o Francisco do Par\xc3\xa1'],
 ['BR', '16', 'S\xc3\xa3o Geraldo do Araguaia'],
 ['BR', '16', 'S\xc3\xa3o Jo\xc3\xa3o da Ponta'],
 ['BR', '16', 'S\xc3\xa3o Jo\xc3\xa3o de Pirabas'],
 ['BR', '16', 'S\xc3\xa3o Jo\xc3\xa3o do Araguaia'],
 ['BR', '16', 'S\xc3\xa3o Sebasti\xc3\xa3o da Boa Vista'],
 ['BR', '16', 'Sapucaia'],
 ['BR', '16', 'Senador Jos\xc3\xa9 Porf\xc3\xadrio'],
 ['BR', '16', 'Soure'],
 ['BR', '16', 'Tail\xc3\xa2ndia'],
 ['BR', '16', 'Terra Alta'],
 ['BR', '16', 'Terra Santa'],
 ['BR', '16', 'Tom\xc3\xa9-A\xc3\xa7u'],
 ['BR', '16', 'Tracuateua'],
 ['BR', '16', 'Trair\xc3\xa3o'],
 ['BR', '16', 'Tucum\xc3\xa3'],
 ['BR', '16', 'Tucuru\xc3\xad'],
 ['BR', '16', 'Ulian\xc3\xb3polis'],
 ['BR', '16', 'Uruar\xc3\xa1'],
 ['BR', '16', 'Vigia'],
 ['BR', '16', 'Vit\xc3\xb3ria do Xingu'],
 ['BR', '16', 'Xinguara'],
 ['BR', '03', 'Amap\xc3\xa1'],
 ['BR', '03', 'Cal\xc3\xa7oene'],
 ['BR', '03', 'Cutias'],
 ['BR', '03', 'Itaubal'],
 ['BR', '03', 'Vit\xc3\xb3ria do Jari'],
 ['BR', '03', 'Macap\xc3\xa1'],
 ['BR', '03', 'Mazag\xc3\xa3o'],
 ['BR', '03', 'Oiapoque'],
 ['BR', '03', 'Pracu\xc3\xbaba'],
 ['BR', '03', 'Santana'],
 ['BR', '03', 'Tartarugalzinho'],
 ['BR', '31', 'Abreul\xc3\xa2ndia'],
 ['BR', '31', 'Aguiarn\xc3\xb3polis'],
 ['BR', '31', 'Alian\xc3\xa7a do Tocantins'],
 ['BR', '31', 'Almas'],
 ['BR', '31', 'Alvorada'],
 ['BR', '31', 'Anan\xc3\xa1s'],
 ['BR', '31', 'Angico'],
 ['BR', '31', 'Aparecida do Rio Negro'],
 ['BR', '31', 'Aragominas'],
 ['BR', '31', 'Araguacema'],
 ['BR', '31', 'Aragua\xc3\xa7u'],
 ['BR', '31', 'Aragua\xc3\xadna'],
 ['BR', '31', 'Araguan\xc3\xa3'],
 ['BR', '31', 'Araguatins'],
 ['BR', '31', 'Arapoema'],
 ['BR', '31', 'Arraias'],
 ['BR', '31', 'Augustin\xc3\xb3polis'],
 ['BR', '31', 'Aurora do Tocantins'],
 ['BR', '31', 'Axix\xc3\xa1 do Tocantins'],
 ['BR', '31', 'Baba\xc3\xa7ul\xc3\xa2ndia'],
 ['BR', '31', 'Bandeirantes do Tocantins'],
 ['BR', '31', 'Barra do Ouro'],
 ['BR', '31', 'Barrol\xc3\xa2ndia'],
 ['BR', '31', 'Bernardo Say\xc3\xa3o'],
 ['BR', '31', 'Bom Jesus do Tocantins'],
 ['BR', '31', 'Brasil\xc3\xa2ndia do Tocantins'],
 ['BR', '31', 'Brejinho de Nazar\xc3\xa9'],
 ['BR', '31', 'Buriti do Tocantins'],
 ['BR', '31', 'Cachoeirinha'],
 ['BR', '31', 'Campos Lindos'],
 ['BR', '31', 'Cariri do Tocantins'],
 ['BR', '31', 'Carmol\xc3\xa2ndia'],
 ['BR', '31', 'Carrasco Bonito'],
 ['BR', '31', 'Caseara'],
 ['BR', '31', 'Centen\xc3\xa1rio'],
 ['BR', '31', 'Chapada de Areia'],
 ['BR', '31', 'Chapada da Natividade'],
 ['BR', '31', 'Colinas do Tocantins'],
 ['BR', '31', 'Combinado'],
 ['BR', '31', 'Concei\xc3\xa7\xc3\xa3o do Tocantins'],
 ['BR', '31', 'Couto de Magalh\xc3\xa3es'],
 ['BR', '31', 'Cristal\xc3\xa2ndia'],
 ['BR', '31', 'Crix\xc3\xa1s do Tocantins'],
 ['BR', '31', 'Darcin\xc3\xb3polis'],
 ['BR', '31', 'Dian\xc3\xb3polis'],
 ['BR', '31', 'Divin\xc3\xb3polis do Tocantins'],
 ['BR', '31', 'Dois Irm\xc3\xa3os do Tocantins'],
 ['BR', '31', 'Duer\xc3\xa9'],
 ['BR', '31', 'Esperantina'],
 ['BR', '31', 'F\xc3\xa1tima'],
 ['BR', '31', 'Figueir\xc3\xb3polis'],
 ['BR', '31', 'Filad\xc3\xa9lfia'],
 ['BR', '31', 'Formoso do Araguaia'],
 ['BR', '31', 'Fortaleza do Taboc\xc3\xa3o'],
 ['BR', '31', 'Goianorte'],
 ['BR', '31', 'Goiatins'],
 ['BR', '31', 'Gurupi'],
 ['BR', '31', 'Itacaj\xc3\xa1'],
 ['BR', '31', 'Itaguatins'],
 ['BR', '31', 'Itapiratins'],
 ['BR', '31', 'Itapor\xc3\xa3 do Tocantins'],
 ['BR', '31', 'Ja\xc3\xba do Tocantins'],
 ['BR', '31', 'Juarina'],
 ['BR', '31', 'Lagoa do Tocantins'],
 ['BR', '31', 'Lajeado'],
 ['BR', '31', 'Lavandeira'],
 ['BR', '31', 'Lizarda'],
 ['BR', '31', 'Luzin\xc3\xb3polis'],
 ['BR', '31', 'Marian\xc3\xb3polis do Tocantins'],
 ['BR', '31', 'Mateiros'],
 ['BR', '31', 'Mauril\xc3\xa2ndia do Tocantins'],
 ['BR', '31', 'Miracema do Tocantins'],
 ['BR', '31', 'Miranorte'],
 ['BR', '31', 'Monte Santo do Tocantins'],
 ['BR', '31', 'Palmeiras do Tocantins'],
 ['BR', '31', 'Muricil\xc3\xa2ndia'],
 ['BR', '31', 'Nazar\xc3\xa9'],
 ['BR', '31', 'Nova Olinda'],
 ['BR', '31', 'Nova Rosal\xc3\xa2ndia'],
 ['BR', '31', 'Novo Acordo'],
 ['BR', '31', 'Novo Alegre'],
 ['BR', '31', 'Novo Jardim'],
 ['BR', '31', 'Oliveira de F\xc3\xa1tima'],
 ['BR', '31', 'Palmeirante'],
 ['BR', '31', 'Palmeir\xc3\xb3polis'],
 ['BR', '31', 'Para\xc3\xadso do Tocantins'],
 ['BR', '31', 'Paran\xc3\xa3'],
 ['BR', '31', 'Pedro Afonso'],
 ['BR', '31', 'Peixe'],
 ['BR', '31', 'Pequizeiro'],
 ['BR', '31', 'Colm\xc3\xa9ia'],
 ['BR', '31', 'Pindorama do Tocantins'],
 ['BR', '31', 'Piraqu\xc3\xaa'],
 ['BR', '31', 'Pium'],
 ['BR', '31', 'Ponte Alta do Bom Jesus'],
 ['BR', '31', 'Ponte Alta do Tocantins'],
 ['BR', '31', 'Porto Alegre do Tocantins'],
 ['BR', '31', 'Porto Nacional'],
 ['BR', '31', 'Praia Norte'],
 ['BR', '31', 'Pugmil'],
 ['BR', '31', 'Recursol\xc3\xa2ndia'],
 ['BR', '31', 'Riachinho'],
 ['BR', '31', 'Rio da Concei\xc3\xa7\xc3\xa3o'],
 ['BR', '31', 'Rio dos Bois'],
 ['BR', '31', 'Rio Sono'],
 ['BR', '31', 'Sampaio'],
 ['BR', '31', 'Sandol\xc3\xa2ndia'],
 ['BR', '31', 'Santa Rita do Tocantins'],
 ['BR', '31', 'Santa Rosa do Tocantins'],
 ['BR', '31', 'Santa Tereza do Tocantins'],
 ['BR', '31', 'Santa Terezinha do Tocantins'],
 ['BR', '31', 'S\xc3\xa3o Bento do Tocantins'],
 ['BR', '31', 'S\xc3\xa3o F\xc3\xa9lix do Tocantins'],
 ['BR', '31', 'S\xc3\xa3o Miguel do Tocantins'],
 ['BR', '31', 'S\xc3\xa3o Salvador do Tocantins'],
 ['BR', '31', 'S\xc3\xa3o Sebasti\xc3\xa3o do Tocantins'],
 ['BR', '31', 'Silvan\xc3\xb3polis'],
 ['BR', '31', 'S\xc3\xadtio Novo do Tocantins'],
 ['BR', '31', 'Sucupira'],
 ['BR', '31', 'Taguatinga'],
 ['BR', '31', 'Taipas do Tocantins'],
 ['BR', '31', 'Talism\xc3\xa3'],
 ['BR', '31', 'Palmas'],
 ['BR', '31', 'Tocant\xc3\xadnia'],
 ['BR', '31', 'Tocantin\xc3\xb3polis'],
 ['BR', '31', 'Tupirama'],
 ['BR', '31', 'Wanderl\xc3\xa2ndia'],
 ['BR', '31', 'Xambio\xc3\xa1'],
 ['BR', '13', 'Afonso Cunha'],
 ['BR', '13', '\xc3\x81gua Doce do Maranh\xc3\xa3o'],
 ['BR', '13', 'Alc\xc3\xa2ntara'],
 ['BR', '13', 'Aldeias Altas'],
 ['BR', '13', 'Altamira do Maranh\xc3\xa3o'],
 ['BR', '13', 'Alto Alegre do Maranh\xc3\xa3o'],
 ['BR', '13', 'Alto Parna\xc3\xadba'],
 ['BR', '13', 'Amap\xc3\xa1 do Maranh\xc3\xa3o'],
 ['BR', '13', 'Amarante do Maranh\xc3\xa3o'],
 ['BR', '13', 'Anajatuba'],
 ['BR', '13', 'Anapurus'],
 ['BR', '13', 'Apicum-A\xc3\xa7u'],
 ['BR', '13', 'Araguan\xc3\xa3'],
 ['BR', '13', 'Araioses'],
 ['BR', '13', 'Arame'],
 ['BR', '13', 'Arari'],
 ['BR', '13', 'Axix\xc3\xa1'],
 ['BR', '13', 'Bacabal'],
 ['BR', '13', 'Bacabeira'],
 ['BR', '13', 'Bacuri'],
 ['BR', '13', 'Bacurituba'],
 ['BR', '13', 'Balsas'],
 ['BR', '13', 'Barra do Corda'],
 ['BR', '13', 'Barreirinhas'],
 ['BR', '13', 'Bel\xc3\xa1gua'],
 ['BR', '13', 'Bela Vista do Maranh\xc3\xa3o'],
 ['BR', '13', 'Benedito Leite'],
 ['BR', '13', 'Bequim\xc3\xa3o'],
 ['BR', '13', 'Bernardo do Mearim'],
 ['BR', '13', 'Boa Vista do Gurupi'],
 ['BR', '13', 'Bom Jardim'],
 ['BR', '13', 'Bom Jesus das Selvas'],
 ['BR', '13', 'Bom Lugar'],
 ['BR', '13', 'Brejo'],
 ['BR', '13', 'Brejo de Areia'],
 ['BR', '13', 'Buriti'],
 ['BR', '13', 'Buriti Bravo'],
 ['BR', '13', 'Buriticupu'],
 ['BR', '13', 'Buritirana'],
 ['BR', '13', 'Cachoeira Grande'],
 ['BR', '13', 'Cajapi\xc3\xb3'],
 ['BR', '13', 'Cajari'],
 ['BR', '13', 'Campestre do Maranh\xc3\xa3o'],
 ['BR', '13', 'C\xc3\xa2ndido Mendes'],
 ['BR', '13', 'Cantanhede'],
 ['BR', '13', 'Capinzal do Norte'],
 ['BR', '13', 'Carolina'],
 ['BR', '13', 'Carutapera'],
 ['BR', '13', 'Caxias'],
 ['BR', '13', 'Cedral'],
 ['BR', '13', 'Central do Maranh\xc3\xa3o'],
 ['BR', '13', 'Centro do Guilherme'],
 ['BR', '13', 'Centro Novo do Maranh\xc3\xa3o'],
 ['BR', '13', 'Cidel\xc3\xa2ndia'],
 ['BR', '13', 'Cod\xc3\xb3'],
 ['BR', '13', 'Coelho Neto'],
 ['BR', '13', 'Colinas'],
 ['BR', '13', 'Coroat\xc3\xa1'],
 ['BR', '13', 'Cururupu'],
 ['BR', '13', 'Davin\xc3\xb3polis'],
 ['BR', '13', 'Dom Pedro'],
 ['BR', '13', 'Duque Bacelar'],
 ['BR', '13', 'Esperantin\xc3\xb3polis'],
 ['BR', '13', 'Estreito'],
 ['BR', '13', 'Feira Nova do Maranh\xc3\xa3o'],
 ['BR', '13', 'Fernando Falc\xc3\xa3o'],
 ['BR', '13', 'Formosa da Serra Negra'],
 ['BR', '13', 'Fortaleza dos Nogueiras'],
 ['BR', '13', 'Fortuna'],
 ['BR', '13', 'Godofredo Viana'],
 ['BR', '13', 'Gon\xc3\xa7alves Dias'],
 ['BR', '13', 'Governador Edison Lob\xc3\xa3o'],
 ['BR', '13', 'Governador Eug\xc3\xaanio Barros'],
 ['BR', '13', 'Governador Luiz Rocha'],
 ['BR', '13', 'Governador Newton Bello'],
 ['BR', '13', 'Governador Nunes Freire'],
 ['BR', '13', 'Gra\xc3\xa7a Aranha'],
 ['BR', '13', 'Graja\xc3\xba'],
 ['BR', '13', 'Guimar\xc3\xa3es'],
 ['BR', '13', 'Humberto de Campos'],
 ['BR', '13', 'Icatu'],
 ['BR', '13', 'Igarap\xc3\xa9 do Meio'],
 ['BR', '13', 'Igarap\xc3\xa9 Grande'],
 ['BR', '13', 'Imperatriz'],
 ['BR', '13', 'Itaipava do Graja\xc3\xba'],
 ['BR', '13', 'Itapecuru Mirim'],
 ['BR', '13', 'Itinga do Maranh\xc3\xa3o'],
 ['BR', '13', 'Jatob\xc3\xa1'],
 ['BR', '13', 'Jenipapo dos Vieiras'],
 ['BR', '13', 'Jo\xc3\xa3o Lisboa'],
 ['BR', '13', 'Josel\xc3\xa2ndia'],
 ['BR', '13', 'Junco do Maranh\xc3\xa3o'],
 ['BR', '13', 'Lago da Pedra'],
 ['BR', '13', 'Lago do Junco'],
 ['BR', '13', 'Lago Verde'],
 ['BR', '13', 'Lagoa do Mato'],
 ['BR', '13', 'Lago dos Rodrigues'],
 ['BR', '13', 'Lagoa Grande do Maranh\xc3\xa3o'],
 ['BR', '13', 'Lajeado Novo'],
 ['BR', '13', 'Lima Campos'],
 ['BR', '13', 'Loreto'],
 ['BR', '13', 'Lu\xc3\xads Domingues'],
 ['BR', '13', 'Magalh\xc3\xa3es de Almeida'],
 ['BR', '13', 'Maraca\xc3\xa7um\xc3\xa9'],
 ['BR', '13', 'Maraj\xc3\xa1 do Sena'],
 ['BR', '13', 'Maranh\xc3\xa3ozinho'],
 ['BR', '13', 'Mata Roma'],
 ['BR', '13', 'Matinha'],
 ['BR', '13', 'Mat\xc3\xb5es'],
 ['BR', '13', 'Mat\xc3\xb5es do Norte'],
 ['BR', '13', 'Milagres do Maranh\xc3\xa3o'],
 ['BR', '13', 'Mirador'],
 ['BR', '13', 'Miranda do Norte'],
 ['BR', '13', 'Mirinzal'],
 ['BR', '13', 'Montes Altos'],
 ['BR', '13', 'Morros'],
 ['BR', '13', 'Nova Colinas'],
 ['BR', '13', 'Nova Iorque'],
 ['BR', '13', 'Nova Olinda do Maranh\xc3\xa3o'],
 ['BR', '13', "Olho d'\xc3\x81gua das Cunh\xc3\xa3s"],
 ['BR', '13', 'Olinda Nova do Maranh\xc3\xa3o'],
 ['BR', '13', 'Pa\xc3\xa7o do Lumiar'],
 ['BR', '13', 'Palmeir\xc3\xa2ndia'],
 ['BR', '13', 'Paraibano'],
 ['BR', '13', 'Parnarama'],
 ['BR', '13', 'Passagem Franca'],
 ['BR', '13', 'Pastos Bons'],
 ['BR', '13', 'Paulino Neves'],
 ['BR', '13', 'Paulo Ramos'],
 ['BR', '13', 'Pedreiras'],
 ['BR', '13', 'Pedro do Ros\xc3\xa1rio'],
 ['BR', '13', 'Penalva'],
 ['BR', '13', 'Peri Mirim'],
 ['BR', '13', 'Peritor\xc3\xb3'],
 ['BR', '13', 'Pindar\xc3\xa9-Mirim'],
 ['BR', '13', 'Pinheiro'],
 ['BR', '13', 'Pio XII'],
 ['BR', '13', 'Pirapemas'],
 ['BR', '13', 'Po\xc3\xa7\xc3\xa3o de Pedras'],
 ['BR', '13', 'Porto Franco'],
 ['BR', '13', 'Porto Rico do Maranh\xc3\xa3o'],
 ['BR', '13', 'Presidente Dutra'],
 ['BR', '13', 'Presidente Juscelino'],
 ['BR', '13', 'Presidente M\xc3\xa9dici'],
 ['BR', '13', 'Presidente Sarney'],
 ['BR', '13', 'Presidente Vargas'],
 ['BR', '13', 'Primeira Cruz'],
 ['BR', '13', 'Raposa'],
 ['BR', '13', 'Riach\xc3\xa3o'],
 ['BR', '13', 'Ribamar Fiquene'],
 ['BR', '13', 'Ros\xc3\xa1rio'],
 ['BR', '13', 'Samba\xc3\xadba'],
 ['BR', '13', 'Santa Filomena do Maranh\xc3\xa3o'],
 ['BR', '13', 'Santa Helena'],
 ['BR', '13', 'Santa In\xc3\xaas'],
 ['BR', '13', 'Santa Quit\xc3\xa9ria do Maranh\xc3\xa3o'],
 ['BR', '13', 'Santana do Maranh\xc3\xa3o'],
 ['BR', '13', 'Santo Amaro do Maranh\xc3\xa3o'],
 ['BR', '13', 'Santo Ant\xc3\xb4nio dos Lopes'],
 ['BR', '13', 'S\xc3\xa3o Benedito do Rio Preto'],
 ['BR', '13', 'S\xc3\xa3o Bento'],
 ['BR', '13', 'S\xc3\xa3o Bernardo'],
 ['BR', '13', 'S\xc3\xa3o Domingos do Azeit\xc3\xa3o'],
 ['BR', '13', 'S\xc3\xa3o Domingos do Maranh\xc3\xa3o'],
 ['BR', '13', 'S\xc3\xa3o F\xc3\xa9lix de Balsas'],
 ['BR', '13', 'S\xc3\xa3o Francisco do Brej\xc3\xa3o'],
 ['BR', '13', 'S\xc3\xa3o Francisco do Maranh\xc3\xa3o'],
 ['BR', '13', 'S\xc3\xa3o Jo\xc3\xa3o Batista'],
 ['BR', '13', 'S\xc3\xa3o Jo\xc3\xa3o do Car\xc3\xba'],
 ['BR', '13', 'S\xc3\xa3o Jo\xc3\xa3o do Soter'],
 ['BR', '13', 'S\xc3\xa3o Jo\xc3\xa3o dos Patos'],
 ['BR', '13', 'S\xc3\xa3o Jos\xc3\xa9 de Ribamar'],
 ['BR', '13', 'S\xc3\xa3o Jos\xc3\xa9 dos Bas\xc3\xadlios'],
 ['BR', '13', 'S\xc3\xa3o Lu\xc3\xads'],
 ['BR', '13', 'S\xc3\xa3o Lu\xc3\xads Gonzaga do Maranh\xc3\xa3o'],
 ['BR', '13', 'S\xc3\xa3o Mateus do Maranh\xc3\xa3o'],
 ['BR', '13', 'S\xc3\xa3o Pedro da \xc3\x81gua Branca'],
 ['BR', '13', 'S\xc3\xa3o Pedro dos Crentes'],
 ['BR', '13', 'S\xc3\xa3o Raimundo das Mangabeiras'],
 ['BR', '13', 'S\xc3\xa3o Vicente Ferrer'],
 ['BR', '13', 'Satubinha'],
 ['BR', '13', 'Senador Alexandre Costa'],
 ['BR', '13', 'Senador La Rocque'],
 ['BR', '13', 'Serrano do Maranh\xc3\xa3o'],
 ['BR', '13', 'S\xc3\xadtio Novo'],
 ['BR', '13', 'Sucupira do Norte'],
 ['BR', '13', 'Sucupira do Riach\xc3\xa3o'],
 ['BR', '13', 'Tasso Fragoso'],
 ['BR', '13', 'Timbiras'],
 ['BR', '13', 'Timon'],
 ['BR', '13', 'Trizidela do Vale'],
 ['BR', '13', 'Tufil\xc3\xa2ndia'],
 ['BR', '13', 'Tuntum'],
 ['BR', '13', 'Turia\xc3\xa7u'],
 ['BR', '13', 'Turil\xc3\xa2ndia'],
 ['BR', '13', 'Urbano Santos'],
 ['BR', '13', 'Vargem Grande'],
 ['BR', '13', 'Viana'],
 ['BR', '13', 'Vila Nova dos Mart\xc3\xadrios'],
 ['BR', '13', 'Vit\xc3\xb3ria do Mearim'],
 ['BR', '13', 'Vitorino Freire'],
 ['BR', '13', 'Z\xc3\xa9 Doca'],
 ['BR', '20', 'Acau\xc3\xa3'],
 ['BR', '20', 'Agricol\xc3\xa2ndia'],
 ['BR', '20', 'Alagoinha do Piau\xc3\xad'],
 ['BR', '20', 'Alegrete do Piau\xc3\xad'],
 ['BR', '20', 'Alto Long\xc3\xa1'],
 ['BR', '20', 'Alvorada do Gurgu\xc3\xa9ia'],
 ['BR', '20', 'Amarante'],
 ['BR', '20', 'Angical do Piau\xc3\xad'],
 ['BR', '20', 'An\xc3\xadsio de Abreu'],
 ['BR', '20', 'Ant\xc3\xb4nio Almeida'],
 ['BR', '20', 'Aroazes'],
 ['BR', '20', 'Arraial'],
 ['BR', '20', 'Assun\xc3\xa7\xc3\xa3o do Piau\xc3\xad'],
 ['BR', '20', 'Baixa Grande do Ribeiro'],
 ['BR', '20', "Barra d'Alc\xc3\xa2ntara"],
 ['BR', '20', 'Barras'],
 ['BR', '20', 'Barreiras do Piau\xc3\xad'],
 ['BR', '20', 'Barro Duro'],
 ['BR', '20', 'Bela Vista do Piau\xc3\xad'],
 ['BR', '20', 'Bel\xc3\xa9m do Piau\xc3\xad'],
 ['BR', '20', 'Bertol\xc3\xadnia'],
 ['BR', '20', 'Bet\xc3\xa2nia do Piau\xc3\xad'],
 ['BR', '20', 'Boa Hora'],
 ['BR', '20', 'Bocaina'],
 ['BR', '20', 'Bom Jesus'],
 ['BR', '20', 'Bom Princ\xc3\xadpio do Piau\xc3\xad'],
 ['BR', '20', 'Bonfim do Piau\xc3\xad'],
 ['BR', '20', 'Boqueir\xc3\xa3o do Piau\xc3\xad'],
 ['BR', '20', 'Brasileira'],
 ['BR', '20', 'Brejo do Piau\xc3\xad'],
 ['BR', '20', 'Buriti dos Lopes'],
 ['BR', '20', 'Buriti dos Montes'],
 ['BR', '20', 'Cabeceiras do Piau\xc3\xad'],
 ['BR', '20', 'Cajazeiras do Piau\xc3\xad'],
 ['BR', '20', 'Cajueiro da Praia'],
 ['BR', '20', 'Caldeir\xc3\xa3o Grande do Piau\xc3\xad'],
 ['BR', '20', 'Campinas do Piau\xc3\xad'],
 ['BR', '20', 'Campo Alegre do Fidalgo'],
 ['BR', '20', 'Campo Grande do Piau\xc3\xad'],
 ['BR', '20', 'Campo Largo do Piau\xc3\xad'],
 ['BR', '20', 'Campo Maior'],
 ['BR', '20', 'Canavieira'],
 ['BR', '20', 'Canto do Buriti'],
 ['BR', '20', 'Capit\xc3\xa3o de Campos'],
 ['BR', '20', 'Capit\xc3\xa3o Gerv\xc3\xa1sio Oliveira'],
 ['BR', '20', 'Caracol'],
 ['BR', '20', 'Cara\xc3\xbabas do Piau\xc3\xad'],
 ['BR', '20', 'Castelo do Piau\xc3\xad'],
 ['BR', '20', 'Caxing\xc3\xb3'],
 ['BR', '20', 'Cocal'],
 ['BR', '20', 'Cocal de Telha'],
 ['BR', '20', 'Cocal dos Alves'],
 ['BR', '20', 'Coivaras'],
 ['BR', '20', 'Col\xc3\xb4nia do Gurgu\xc3\xa9ia'],
 ['BR', '20', 'Col\xc3\xb4nia do Piau\xc3\xad'],
 ['BR', '20', 'Concei\xc3\xa7\xc3\xa3o do Canind\xc3\xa9'],
 ['BR', '20', 'Coronel Jos\xc3\xa9 Dias'],
 ['BR', '20', 'Corrente'],
 ['BR', '20', 'Cristal\xc3\xa2ndia do Piau\xc3\xad'],
 ['BR', '20', 'Cristino Castro'],
 ['BR', '20', 'Currais'],
 ['BR', '20', 'Curralinhos'],
 ['BR', '20', 'Demerval Lob\xc3\xa3o'],
 ['BR', '20', 'Dom Expedito Lopes'],
 ['BR', '20', 'Domingos Mour\xc3\xa3o'],
 ['BR', '20', 'Dom Inoc\xc3\xaancio'],
 ['BR', '20', 'Elesb\xc3\xa3o Veloso'],
 ['BR', '20', 'Eliseu Martins'],
 ['BR', '20', 'Esperantina'],
 ['BR', '20', 'Fartura do Piau\xc3\xad'],
 ['BR', '20', 'Flores do Piau\xc3\xad'],
 ['BR', '20', 'Floresta do Piau\xc3\xad'],
 ['BR', '20', 'Francin\xc3\xb3polis'],
 ['BR', '20', 'Francisco Ayres'],
 ['BR', '20', 'Francisco Macedo'],
 ['BR', '20', 'Francisco Santos'],
 ['BR', '20', 'Geminiano'],
 ['BR', '20', 'Gilbu\xc3\xa9s'],
 ['BR', '20', 'Guadalupe'],
 ['BR', '20', 'Guaribas'],
 ['BR', '20', 'Hugo Napole\xc3\xa3o'],
 ['BR', '20', 'Ilha Grande'],
 ['BR', '20', 'Inhuma'],
 ['BR', '20', 'Ipiranga do Piau\xc3\xad'],
 ['BR', '20', 'Isa\xc3\xadas Coelho'],
 ['BR', '20', 'Itain\xc3\xb3polis'],
 ['BR', '20', 'Itaueira'],
 ['BR', '20', 'Jacobina do Piau\xc3\xad'],
 ['BR', '20', 'Jaic\xc3\xb3s'],
 ['BR', '20', 'Jardim do Mulato'],
 ['BR', '20', 'Jo\xc3\xa3o Costa'],
 ['BR', '20', 'Joaquim Pires'],
 ['BR', '20', 'Joca Marques'],
 ['BR', '20', 'Jos\xc3\xa9 de Freitas'],
 ['BR', '20', 'Juazeiro do Piau\xc3\xad'],
 ['BR', '20', 'J\xc3\xbalio Borges'],
 ['BR', '20', 'Jurema'],
 ['BR', '20', 'Lagoinha do Piau\xc3\xad'],
 ['BR', '20', 'Lagoa Alegre'],
 ['BR', '20', 'Lagoa do Barro do Piau\xc3\xad'],
 ['BR', '20', 'Lagoa de S\xc3\xa3o Francisco'],
 ['BR', '20', 'Lagoa do Piau\xc3\xad'],
 ['BR', '20', 'Lagoa do S\xc3\xadtio'],
 ['BR', '20', 'Landri Sales'],
 ['BR', '20', 'Lu\xc3\xads Correia'],
 ['BR', '20', 'Luzil\xc3\xa2ndia'],
 ['BR', '20', 'Madeiro'],
 ['BR', '20', 'Manoel Em\xc3\xaddio'],
 ['BR', '20', 'Marcol\xc3\xa2ndia'],
 ['BR', '20', 'Marcos Parente'],
 ['BR', '20', 'Massap\xc3\xaa do Piau\xc3\xad'],
 ['BR', '20', 'Matias Ol\xc3\xadmpio'],
 ['BR', '20', 'Miguel Alves'],
 ['BR', '20', 'Miguel Le\xc3\xa3o'],
 ['BR', '20', 'Milton Brand\xc3\xa3o'],
 ['BR', '20', 'Monsenhor Gil'],
 ['BR', '20', 'Monsenhor Hip\xc3\xb3lito'],
 ['BR', '20', 'Monte Alegre do Piau\xc3\xad'],
 ['BR', '20', 'Morro do Chap\xc3\xa9u do Piau\xc3\xad'],
 ['BR', '20', 'Murici dos Portelas'],
 ['BR', '20', 'Nazar\xc3\xa9 do Piau\xc3\xad'],
 ['BR', '20', 'Nossa Senhora de Nazar\xc3\xa9'],
 ['BR', '20', 'Nossa Senhora dos Rem\xc3\xa9dios'],
 ['BR', '20', 'Novo Oriente do Piau\xc3\xad'],
 ['BR', '20', 'Novo Santo Ant\xc3\xb4nio'],
 ['BR', '20', 'Oeiras'],
 ['BR', '20', "Olho d'\xc3\x81gua do Piau\xc3\xad"],
 ['BR', '20', 'Padre Marcos'],
 ['BR', '20', 'Paes Landim'],
 ['BR', '20', 'Paje\xc3\xba do Piau\xc3\xad'],
 ['BR', '20', 'Palmeira do Piau\xc3\xad'],
 ['BR', '20', 'Palmeirais'],
 ['BR', '20', 'Paquet\xc3\xa1'],
 ['BR', '20', 'Parna\xc3\xadba'],
 ['BR', '20', 'Passagem Franca do Piau\xc3\xad'],
 ['BR', '20', 'Patos do Piau\xc3\xad'],
 ['BR', '20', 'Paulistana'],
 ['BR', '20', 'Pavussu'],
 ['BR', '20', 'Pedro II'],
 ['BR', '20', 'Nova Santa Rita'],
 ['BR', '20', 'Picos'],
 ['BR', '20', 'Pimenteiras'],
 ['BR', '20', 'Pio IX'],
 ['BR', '20', 'Piracuruca'],
 ['BR', '20', 'Piripiri'],
 ['BR', '20', 'Porto'],
 ['BR', '20', 'Porto Alegre do Piau\xc3\xad'],
 ['BR', '20', 'Prata do Piau\xc3\xad'],
 ['BR', '20', 'Queimada Nova'],
 ['BR', '20', 'Reden\xc3\xa7\xc3\xa3o do Gurgu\xc3\xa9ia'],
 ['BR', '20', 'Regenera\xc3\xa7\xc3\xa3o'],
 ['BR', '20', 'Riacho Frio'],
 ['BR', '20', 'Ribeira do Piau\xc3\xad'],
 ['BR', '20', 'Ribeiro Gon\xc3\xa7alves'],
 ['BR', '20', 'Rio Grande do Piau\xc3\xad'],
 ['BR', '20', 'Santa Cruz do Piau\xc3\xad'],
 ['BR', '20', 'Santa Filomena'],
 ['BR', '20', 'Santa Luz'],
 ['BR', '20', 'Santana do Piau\xc3\xad'],
 ['BR', '20', 'Santa Rosa do Piau\xc3\xad'],
 ['BR', '20', 'Santo Ant\xc3\xb4nio de Lisboa'],
 ['BR', '20', 'Santo Ant\xc3\xb4nio dos Milagres'],
 ['BR', '20', 'Santo In\xc3\xa1cio do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Braz do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Francisco de Assis do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Francisco do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Gon\xc3\xa7alo do Gurgu\xc3\xa9ia'],
 ['BR', '20', 'S\xc3\xa3o Gon\xc3\xa7alo do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Jo\xc3\xa3o da Canabrava'],
 ['BR', '20', 'S\xc3\xa3o Jo\xc3\xa3o da Serra'],
 ['BR', '20', 'S\xc3\xa3o Jo\xc3\xa3o da Varjota'],
 ['BR', '20', 'S\xc3\xa3o Jo\xc3\xa3o do Arraial'],
 ['BR', '20', 'S\xc3\xa3o Jo\xc3\xa3o do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Jos\xc3\xa9 do Divino'],
 ['BR', '20', 'S\xc3\xa3o Jos\xc3\xa9 do Peixe'],
 ['BR', '20', 'S\xc3\xa3o Juli\xc3\xa3o'],
 ['BR', '20', 'S\xc3\xa3o Louren\xc3\xa7o do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Luis do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Miguel da Baixa Grande'],
 ['BR', '20', 'S\xc3\xa3o Miguel do Fidalgo'],
 ['BR', '20', 'S\xc3\xa3o Miguel do Tapuio'],
 ['BR', '20', 'S\xc3\xa3o Pedro do Piau\xc3\xad'],
 ['BR', '20', 'S\xc3\xa3o Raimundo Nonato'],
 ['BR', '20', 'Sebasti\xc3\xa3o Barros'],
 ['BR', '20', 'Sebasti\xc3\xa3o Leal'],
 ['BR', '20', 'Sigefredo Pacheco'],
 ['BR', '20', 'Simpl\xc3\xadcio Mendes'],
 ['BR', '20', 'Socorro do Piau\xc3\xad'],
 ['BR', '20', 'Sussuapara'],
 ['BR', '20', 'Tamboril do Piau\xc3\xad'],
 ['BR', '20', 'Tanque do Piau\xc3\xad'],
 ['BR', '20', 'Teresina'],
 ['BR', '20', 'Uni\xc3\xa3o'],
 ['BR', '20', 'Uru\xc3\xa7u\xc3\xad'],
 ['BR', '20', 'Valen\xc3\xa7a do Piau\xc3\xad'],
 ['BR', '20', 'V\xc3\xa1rzea Branca'],
 ['BR', '20', 'V\xc3\xa1rzea Grande'],
 ['BR', '20', 'Vera Mendes'],
 ['BR', '20', 'Vila Nova do Piau\xc3\xad'],
 ['BR', '20', 'Wall Ferraz'],
 ['BR', '06', 'Abaiara'],
 ['BR', '06', 'Acarap\xc3\xa9'],
 ['BR', '06', 'Acara\xc3\xba'],
 ['BR', '06', 'Alc\xc3\xa2ntaras'],
 ['BR', '06', 'Altaneira'],
 ['BR', '06', 'Alto Santo'],
 ['BR', '06', 'Itapipoca'],
 ['BR', '06', 'Antonina do Norte'],
 ['BR', '06', 'Aquiraz'],
 ['BR', '06', 'Aratuba'],
 ['BR', '06', 'Arneiroz'],
 ['BR', '06', 'Barreira'],
 ['BR', '06', 'Barroquinha'],
 ['BR', '06', 'Beberibe'],
 ['BR', '06', 'Bela Cruz'],
 ['BR', '06', 'Camocim'],
 ['BR', '06', 'Caridade'],
 ['BR', '06', 'Carnaubal'],
 ['BR', '06', 'Cascavel'],
 ['BR', '06', 'Catarina'],
 ['BR', '06', 'Catunda'],
 ['BR', '06', 'Caucaia'],
 ['BR', '06', 'Chaval'],
 ['BR', '06', 'Chor\xc3\xb3'],
 ['BR', '06', 'Chorozinho'],
 ['BR', '06', 'Cruz'],
 ['BR', '06', 'Deputado Irapuan Pinheiro'],
 ['BR', '06', 'Eus\xc3\xa9bio'],
 ['BR', '06', 'Fortaleza'],
 ['BR', '06', 'Fortim'],
 ['BR', '06', 'General Sampaio'],
 ['BR', '06', 'Granjeiro'],
 ['BR', '06', 'Groa\xc3\xadras'],
 ['BR', '06', 'Guai\xc3\xbaba'],
 ['BR', '06', 'Guaramiranga'],
 ['BR', '06', 'Horizonte'],
 ['BR', '06', 'Ibaretama'],
 ['BR', '06', 'Ibicuitinga'],
 ['BR', '06', 'Icapu\xc3\xad'],
 ['BR', '06', 'Ipaporanga'],
 ['BR', '06', 'Amontada'],
 ['BR', '06', 'Itarema'],
 ['BR', '06', 'Jijoca de Jericoacoara'],
 ['BR', '06', 'Maracana\xc3\xba'],
 ['BR', '06', 'Marco'],
 ['BR', '06', 'Martin\xc3\xb3pole'],
 ['BR', '06', 'Mira\xc3\xadma'],
 ['BR', '06', 'Morada Nova'],
 ['BR', '06', 'Mora\xc3\xbajo'],
 ['BR', '06', 'Morrinhos'],
 ['BR', '06', 'Mulungu'],
 ['BR', '06', 'Novo Oriente'],
 ['BR', '06', 'Or\xc3\xb3s'],
 ['BR', '06', 'Pacajus'],
 ['BR', '06', 'Pacuj\xc3\xa1'],
 ['BR', '06', 'Palm\xc3\xa1cia'],
 ['BR', '06', 'Paracuru'],
 ['BR', '06', 'Paraipaba'],
 ['BR', '06', 'Paramoti'],
 ['BR', '06', 'Penaforte'],
 ['BR', '06', 'Pindoretama'],
 ['BR', '06', 'Piquet Carneiro'],
 ['BR', '06', 'Pires Ferreira'],
 ['BR', '06', 'Poranga'],
 ['BR', '06', 'Potengi'],
 ['BR', '06', 'Quiterian\xc3\xb3polis'],
 ['BR', '06', 'Quixer\xc3\xa9'],
 ['BR', '06', 'Salitre'],
 ['BR', '06', 'Santana do Acara\xc3\xba'],
 ['BR', '06', 'S\xc3\xa3o Gon\xc3\xa7alo do Amarante'],
 ['BR', '06', 'S\xc3\xa3o Jo\xc3\xa3o do Jaguaribe'],
 ['BR', '06', 'S\xc3\xa3o Lu\xc3\xads do Curu'],
 ['BR', '06', 'Tarrafas'],
 ['BR', '06', 'Teju\xc3\xa7uoca'],
 ['BR', '06', 'Trairi'],
 ['BR', '06', 'Tururu'],
 ['BR', '06', 'Umirim'],
 ['BR', '06', 'Uruburetama'],
 ['BR', '06', 'Uruoca'],
 ['BR', '22', 'Acari'],
 ['BR', '22', 'A\xc3\xa7u'],
 ['BR', '22', 'Afonso Bezerra'],
 ['BR', '22', '\xc3\x81gua Nova'],
 ['BR', '22', 'Almino Afonso'],
 ['BR', '22', 'Alto do Rodrigues'],
 ['BR', '22', 'Ant\xc3\xb4nio Martins'],
 ['BR', '22', 'Apodi'],
 ['BR', '22', 'Areia Branca'],
 ['BR', '22', 'Ar\xc3\xaas'],
 ['BR', '22', 'Augusto Severo'],
 ['BR', '22', 'Ba\xc3\xada Formosa'],
 ['BR', '22', 'Bara\xc3\xbana'],
 ['BR', '22', 'Barcelona'],
 ['BR', '22', 'Bento Fernandes'],
 ['BR', '22', 'Bod\xc3\xb3'],
 ['BR', '22', 'Brejinho'],
 ['BR', '22', 'Cai\xc3\xa7ara do Norte'],
 ['BR', '22', 'Caic\xc3\xb3'],
 ['BR', '22', 'Campo Redondo'],
 ['BR', '22', 'Canguaretama'],
 ['BR', '22', 'Cara\xc3\xbabas'],
 ['BR', '22', 'Carnaubais'],
 ['BR', '22', 'Cear\xc3\xa1-Mirim'],
 ['BR', '22', 'Cerro Cor\xc3\xa1'],
 ['BR', '22', 'Coronel Ezequiel'],
 ['BR', '22', 'Coronel Jo\xc3\xa3o Pessoa'],
 ['BR', '22', 'Cruzeta'],
 ['BR', '22', 'Currais Novos'],
 ['BR', '22', 'Doutor Severiano'],
 ['BR', '22', 'Parnamirim'],
 ['BR', '22', 'Encanto'],
 ['BR', '22', 'Extremoz'],
 ['BR', '22', 'Felipe Guerra'],
 ['BR', '22', 'Fernando Pedroza'],
 ['BR', '22', 'Flor\xc3\xa2nia'],
 ['BR', '22', 'Francisco Dantas'],
 ['BR', '22', 'Frutuoso Gomes'],
 ['BR', '22', 'Galinhos'],
 ['BR', '22', 'Goianinha'],
 ['BR', '22', 'Governador Dix-Sept Rosado'],
 ['BR', '22', 'Grossos'],
 ['BR', '22', 'Guamar\xc3\xa9'],
 ['BR', '22', 'Ielmo Marinho'],
 ['BR', '22', 'Ipangua\xc3\xa7u'],
 ['BR', '22', 'Ipueira'],
 ['BR', '22', 'Itaj\xc3\xa1'],
 ['BR', '22', 'Ita\xc3\xba'],
 ['BR', '22', 'Janda\xc3\xadra'],
 ['BR', '22', 'Jandu\xc3\xads'],
 ['BR', '22', 'Janu\xc3\xa1rio Cicco'],
 ['BR', '22', 'Japi'],
 ['BR', '22', 'Jardim de Angicos'],
 ['BR', '22', 'Jardim de Piranhas'],
 ['BR', '22', 'Jardim do Serid\xc3\xb3'],
 ['BR', '22', 'Jo\xc3\xa3o C\xc3\xa2mara'],
 ['BR', '22', 'Jo\xc3\xa3o Dias'],
 ['BR', '22', 'Jos\xc3\xa9 da Penha'],
 ['BR', '22', "Lagoa d'Anta"],
 ['BR', '22', 'Lagoa de Pedras'],
 ['BR', '22', 'Lagoa de Velhos'],
 ['BR', '22', 'Lagoa Nova'],
 ['BR', '22', 'Lagoa Salgada'],
 ['BR', '22', 'Lajes'],
 ['BR', '22', 'Lajes Pintadas'],
 ['BR', '22', 'Lucr\xc3\xa9cia'],
 ['BR', '22', 'Lu\xc3\xads Gomes'],
 ['BR', '22', 'Maca\xc3\xadba'],
 ['BR', '22', 'Macau'],
 ['BR', '22', 'Major Sales'],
 ['BR', '22', 'Marcelino Vieira'],
 ['BR', '22', 'Martins'],
 ['BR', '22', 'Messias Targino'],
 ['BR', '22', 'Montanhas'],
 ['BR', '22', 'Monte Alegre'],
 ['BR', '22', 'Monte das Gameleiras'],
 ['BR', '22', 'Natal'],
 ['BR', '22', 'Nova Cruz'],
 ['BR', '22', "Olho-d'\xc3\x81gua do Borges"],
 ['BR', '22', 'Ouro Branco'],
 ['BR', '22', 'Paran\xc3\xa1'],
 ['BR', '22', 'Parazinho'],
 ['BR', '22', 'Parelhas'],
 ['BR', '22', 'Rio do Fogo'],
 ['BR', '22', 'Passa e Fica'],
 ['BR', '22', 'Passagem'],
 ['BR', '22', 'Santa Maria'],
 ['BR', '22', 'Pau dos Ferros'],
 ['BR', '22', 'Pedra Grande'],
 ['BR', '22', 'Pedra Preta'],
 ['BR', '22', 'Pedro Avelino'],
 ['BR', '22', 'Pedro Velho'],
 ['BR', '22', 'Pend\xc3\xaancias'],
 ['BR', '22', 'Pil\xc3\xb5es'],
 ['BR', '22', 'Po\xc3\xa7o Branco'],
 ['BR', '22', 'Portalegre'],
 ['BR', '22', 'Porto do Mangue'],
 ['BR', '22', 'Presidente Juscelino'],
 ['BR', '22', 'Rafael Fernandes'],
 ['BR', '22', 'Rafael Godeiro'],
 ['BR', '22', 'Riacho da Cruz'],
 ['BR', '22', 'Riacho de Santana'],
 ['BR', '22', 'Riachuelo'],
 ['BR', '22', 'Rodolfo Fernandes'],
 ['BR', '22', 'Tibau'],
 ['BR', '22', 'Ruy Barbosa'],
 ['BR', '22', 'Santa Cruz'],
 ['BR', '22', 'Santana do Matos'],
 ['BR', '22', 'Santana do Serid\xc3\xb3'],
 ['BR', '22', 'Santo Ant\xc3\xb4nio'],
 ['BR', '22', 'S\xc3\xa3o Bento do Norte'],
 ['BR', '22', 'S\xc3\xa3o Bento do Trair\xc3\xad'],
 ['BR', '22', 'S\xc3\xa3o Fernando'],
 ['BR', '22', 'S\xc3\xa3o Francisco do Oeste'],
 ['BR', '22', 'S\xc3\xa3o Gon\xc3\xa7alo do Amarante'],
 ['BR', '22', 'S\xc3\xa3o Jo\xc3\xa3o do Sabugi'],
 ['BR', '22', 'S\xc3\xa3o Jos\xc3\xa9 de Mipibu'],
 ['BR', '22', 'S\xc3\xa3o Jos\xc3\xa9 do Campestre'],
 ['BR', '22', 'S\xc3\xa3o Jos\xc3\xa9 do Serid\xc3\xb3'],
 ['BR', '22', 'S\xc3\xa3o Miguel'],
 ['BR', '22', 'S\xc3\xa3o Miguel de Touros'],
 ['BR', '22', 'S\xc3\xa3o Paulo do Potengi'],
 ['BR', '22', 'S\xc3\xa3o Rafael'],
 ['BR', '22', 'Senador El\xc3\xb3i de Souza'],
 ['BR', '22', 'Senador Georgino Avelino'],
 ['BR', '22', 'Serra de S\xc3\xa3o Bento'],
 ['BR', '22', 'Serra do Mel'],
 ['BR', '22', 'Serra Negra do Norte'],
 ['BR', '22', 'Serrinha'],
 ['BR', '22', 'Serrinha dos Pintos'],
 ['BR', '22', 'Severiano Melo'],
 ['BR', '22', 'S\xc3\xadtio Novo'],
 ['BR', '22', 'Taboleiro Grande'],
 ['BR', '22', 'Taipu'],
 ['BR', '22', 'Tangar\xc3\xa1'],
 ['BR', '22', 'Tenente Ananias'],
 ['BR', '22', 'Tenente Laurentino Cruz'],
 ['BR', '22', 'Tibau do Sul'],
 ['BR', '22', 'Timba\xc3\xbaba dos Batistas'],
 ['BR', '22', 'Triunfo Potiguar'],
 ['BR', '22', 'Umarizal'],
 ['BR', '22', 'Upanema'],
 ['BR', '22', 'Venha-Ver'],
 ['BR', '22', 'Vera Cruz'],
 ['BR', '22', 'Vi\xc3\xa7osa'],
 ['BR', '22', 'Vila Flor'],
 ['BR', '17', 'Aguiar'],
 ['BR', '17', 'Alagoa Grande'],
 ['BR', '17', 'Alagoa Nova'],
 ['BR', '17', 'Alagoinha'],
 ['BR', '17', 'Alcantil'],
 ['BR', '17', 'Algod\xc3\xa3o de Janda\xc3\xadra'],
 ['BR', '17', 'S\xc3\xa3o Jo\xc3\xa3o do Rio do Peixe'],
 ['BR', '17', 'Ara\xc3\xa7agi'],
 ['BR', '17', 'Arara'],
 ['BR', '17', 'Araruna'],
 ['BR', '17', 'Areia de Bara\xc3\xbanas'],
 ['BR', '17', 'Areial'],
 ['BR', '17', 'Aroeiras'],
 ['BR', '17', 'Assun\xc3\xa7\xc3\xa3o'],
 ['BR', '17', 'Ba\xc3\xada da Trai\xc3\xa7\xc3\xa3o'],
 ['BR', '17', 'Bananeiras'],
 ['BR', '17', 'Bara\xc3\xbana'],
 ['BR', '17', 'Barra de Santana'],
 ['BR', '17', 'Barra de Santa Rosa'],
 ['BR', '17', 'Barra de S\xc3\xa3o Miguel'],
 ['BR', '17', 'Bayeux'],
 ['BR', '17', 'Bel\xc3\xa9m'],
 ['BR', '17', 'Bel\xc3\xa9m do Brejo do Cruz'],
 ['BR', '17', 'Bernardino Batista'],
 ['BR', '17', 'Boa Ventura'],
 ['BR', '17', 'Boa Vista'],
 ['BR', '17', 'Bom Jesus'],
 ['BR', '17', 'Bom Sucesso'],
 ['BR', '17', 'Bonito de Santa F\xc3\xa9'],
 ['BR', '17', 'Igaracy'],
 ['BR', '17', 'Borborema'],
 ['BR', '17', 'Brejo do Cruz'],
 ['BR', '17', 'Brejo dos Santos'],
 ['BR', '17', 'Caapor\xc3\xa3'],
 ['BR', '17', 'Cabaceiras'],
 ['BR', '17', 'Cabedelo'],
 ['BR', '17', 'Cacimba de Areia'],
 ['BR', '17', 'Cacimba de Dentro'],
 ['BR', '17', 'Cacimbas'],
 ['BR', '17', 'Cai\xc3\xa7ara'],
 ['BR', '17', 'Cajazeirinhas'],
 ['BR', '17', 'Caldas Brand\xc3\xa3o'],
 ['BR', '17', 'Camala\xc3\xba'],
 ['BR', '17', 'Campina Grande'],
 ['BR', '17', 'Capim'],
 ['BR', '17', 'Cara\xc3\xbabas'],
 ['BR', '17', 'Carrapateira'],
 ['BR', '17', 'Casserengue'],
 ['BR', '17', 'Catingueira'],
 ['BR', '17', 'Catol\xc3\xa9 do Rocha'],
 ['BR', '17', 'Caturit\xc3\xa9'],
 ['BR', '17', 'Condado'],
 ['BR', '17', 'Conde'],
 ['BR', '17', 'Congo'],
 ['BR', '17', 'Coremas'],
 ['BR', '17', 'Coxixola'],
 ['BR', '17', 'Cubati'],
 ['BR', '17', 'Cuit\xc3\xa9'],
 ['BR', '17', 'Cuitegi'],
 ['BR', '17', 'Cuit\xc3\xa9 de Mamanguape'],
 ['BR', '17', 'Curral Velho'],
 ['BR', '17', 'Dami\xc3\xa3o'],
 ['BR', '17', 'Desterro'],
 ['BR', '17', 'Vista Serrana'],
 ['BR', '17', 'Diamante'],
 ['BR', '17', 'Dona In\xc3\xaas'],
 ['BR', '17', 'Duas Estradas'],
 ['BR', '17', 'Emas'],
 ['BR', '17', 'Esperan\xc3\xa7a'],
 ['BR', '17', 'Fagundes'],
 ['BR', '17', 'Gado Bravo'],
 ['BR', '17', 'Guarabira'],
 ['BR', '17', 'Gurinh\xc3\xa9m'],
 ['BR', '17', 'Imaculada'],
 ['BR', '17', 'Ing\xc3\xa1'],
 ['BR', '17', 'Itabaiana'],
 ['BR', '17', 'Itaporanga'],
 ['BR', '17', 'Itapororoca'],
 ['BR', '17', 'Itatuba'],
 ['BR', '17', 'Jacara\xc3\xba'],
 ['BR', '17', 'Jeric\xc3\xb3'],
 ['BR', '17', 'Jo\xc3\xa3o Pessoa'],
 ['BR', '17', 'Juarez T\xc3\xa1vora'],
 ['BR', '17', 'Juazeirinho'],
 ['BR', '17', 'Junco do Serid\xc3\xb3'],
 ['BR', '17', 'Juripiranga'],
 ['BR', '17', 'Juru'],
 ['BR', '17', 'Lagoa de Dentro'],
 ['BR', '17', 'Lastro'],
 ['BR', '17', 'Livramento'],
 ['BR', '17', 'Logradouro'],
 ['BR', '17', 'Lucena'],
 ['BR', '17', "M\xc3\xa3e d'\xc3\x81gua"],
 ['BR', '17', 'Malta'],
 ['BR', '17', 'Mana\xc3\xadra'],
 ['BR', '17', 'Marca\xc3\xa7\xc3\xa3o'],
 ['BR', '17', 'Mari'],
 ['BR', '17', 'Mariz\xc3\xb3polis'],
 ['BR', '17', 'Massaranduba'],
 ['BR', '17', 'Matinhas'],
 ['BR', '17', 'Mato Grosso'],
 ['BR', '17', 'Matur\xc3\xa9ia'],
 ['BR', '17', 'Mogeiro'],
 ['BR', '17', 'Montadas'],
 ['BR', '17', 'Monte Horebe'],
 ['BR', '17', 'Mulungu'],
 ['BR', '17', 'Natuba'],
 ['BR', '17', 'Nazarezinho'],
 ['BR', '17', 'Nova Floresta'],
 ['BR', '17', 'Nova Olinda'],
 ['BR', '17', 'Nova Palmeira'],
 ['BR', '17', "Olho d'\xc3\x81gua"],
 ['BR', '17', 'Olivedos'],
 ['BR', '17', 'Ouro Velho'],
 ['BR', '17', 'Parari'],
 ['BR', '17', 'Passagem'],
 ['BR', '17', 'Patos'],
 ['BR', '17', 'Pedra Lavrada'],
 ['BR', '17', 'Pedras de Fogo'],
 ['BR', '17', 'Picu\xc3\xad'],
 ['BR', '17', 'Pilar'],
 ['BR', '17', 'Pil\xc3\xb5es'],
 ['BR', '17', 'Pil\xc3\xb5ezinhos'],
 ['BR', '17', 'Pirpirituba'],
 ['BR', '17', 'Pitimbu'],
 ['BR', '17', 'Po\xc3\xa7o Dantas'],
 ['BR', '17', 'Po\xc3\xa7o de Jos\xc3\xa9 de Moura'],
 ['BR', '17', 'Princesa Isabel'],
 ['BR', '17', 'Puxinan\xc3\xa3'],
 ['BR', '17', 'Queimadas'],
 ['BR', '17', 'Quixab\xc3\xa1'],
 ['BR', '17', 'Rem\xc3\xadgio'],
 ['BR', '17', 'Pedro R\xc3\xa9gis'],
 ['BR', '17', 'Riach\xc3\xa3o'],
 ['BR', '17', 'Riach\xc3\xa3o do Bacamarte'],
 ['BR', '17', 'Riach\xc3\xa3o do Po\xc3\xa7o'],
 ['BR', '17', 'Riacho de Santo Ant\xc3\xb4nio'],
 ['BR', '17', 'Riacho dos Cavalos'],
 ['BR', '17', 'Salgadinho'],
 ['BR', '17', 'Salgado de S\xc3\xa3o F\xc3\xa9lix'],
 ['BR', '17', 'Santa Cec\xc3\xadlia'],
 ['BR', '17', 'Santa Cruz'],
 ['BR', '17', 'Santa Helena'],
 ['BR', '17', 'Santa In\xc3\xaas'],
 ['BR', '17', 'Santa Luzia'],
 ['BR', '17', 'Santana de Mangueira'],
 ['BR', '17', 'Santana dos Garrotes'],
 ['BR', '17', 'Santar\xc3\xa9m'],
 ['BR', '17', 'Santa Teresinha'],
 ['BR', '17', 'Santo Andr\xc3\xa9'],
 ['BR', '17', 'S\xc3\xa3o Bento'],
 ['BR', '17', 'S\xc3\xa3o Bentinho'],
 ['BR', '17', 'S\xc3\xa3o Domingos do Cariri'],
 ['BR', '17', 'S\xc3\xa3o Domingos de Pombal'],
 ['BR', '17', 'S\xc3\xa3o Jo\xc3\xa3o do Cariri'],
 ['BR', '17', 'S\xc3\xa3o Jo\xc3\xa3o do Tigre'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 da Lagoa Tapada'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 de Caiana'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 de Espinharas'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 dos Ramos'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 de Piranhas'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 de Princesa'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 do Brejo do Cruz'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 do Sabugi'],
 ['BR', '17', 'S\xc3\xa3o Jos\xc3\xa9 dos Cordeiros'],
 ['BR', '17', 'S\xc3\xa3o Mamede'],
 ['BR', '17', 'S\xc3\xa3o Miguel de Taipu'],
 ['BR', '17', 'S\xc3\xa3o Sebasti\xc3\xa3o de Lagoa de Ro\xc3\xa7a'],
 ['BR', '17', 'S\xc3\xa3o Sebasti\xc3\xa3o do Umbuzeiro'],
 ['BR', '17', 'Sap\xc3\xa9'],
 ['BR', '17', 'Serid\xc3\xb3'],
 ['BR', '17', 'Serra Branca'],
 ['BR', '17', 'Serra da Raiz'],
 ['BR', '17', 'Serra Grande'],
 ['BR', '17', 'Serra Redonda'],
 ['BR', '17', 'Serraria'],
 ['BR', '17', 'Sobrado'],
 ['BR', '17', 'Sol\xc3\xa2nea'],
 ['BR', '17', 'Soss\xc3\xaago'],
 ['BR', '17', 'Sum\xc3\xa9'],
 ['BR', '17', 'Campo de Santana'],
 ['BR', '17', 'Tapero\xc3\xa1'],
 ['BR', '17', 'Tavares'],
 ['BR', '17', 'Teixeira'],
 ['BR', '17', 'Ten\xc3\xb3rio'],
 ['BR', '17', 'Uira\xc3\xbana'],
 ['BR', '17', 'Umbuzeiro'],
 ['BR', '17', 'V\xc3\xa1rzea'],
 ['BR', '17', 'Vieir\xc3\xb3polis'],
 ['BR', '30', 'Abreu e Lima'],
 ['BR', '30', 'Afogados da Ingazeira'],
 ['BR', '30', 'Afr\xc3\xa2nio'],
 ['BR', '30', 'Agrestina'],
 ['BR', '30', '\xc3\x81gua Preta'],
 ['BR', '30', '\xc3\x81guas Belas'],
 ['BR', '30', 'Alagoinha'],
 ['BR', '30', 'Alian\xc3\xa7a'],
 ['BR', '30', 'Altinho'],
 ['BR', '30', 'Amaraji'],
 ['BR', '30', 'Angelim'],
 ['BR', '30', 'Arcoverde'],
 ['BR', '30', 'Barra de Guabiraba'],
 ['BR', '30', 'Barreiros'],
 ['BR', '30', 'Bel\xc3\xa9m de Maria'],
 ['BR', '30', 'Bel\xc3\xa9m de S\xc3\xa3o Francisco'],
 ['BR', '30', 'Belo Jardim'],
 ['BR', '30', 'Bet\xc3\xa2nia'],
 ['BR', '30', 'Bezerros'],
 ['BR', '30', 'Bodoc\xc3\xb3'],
 ['BR', '30', 'Bom Conselho'],
 ['BR', '30', 'Bom Jardim'],
 ['BR', '30', 'Bonito'],
 ['BR', '30', 'Brej\xc3\xa3o'],
 ['BR', '30', 'Brejinho'],
 ['BR', '30', 'Brejo da Madre de Deus'],
 ['BR', '30', 'Bu\xc3\xadque'],
 ['BR', '30', 'Cabo de Santo Agostinho'],
 ['BR', '30', 'Cabrob\xc3\xb3'],
 ['BR', '30', 'Cachoeirinha'],
 ['BR', '30', 'Caet\xc3\xa9s'],
 ['BR', '30', 'Cal\xc3\xa7ado'],
 ['BR', '30', 'Calumbi'],
 ['BR', '30', 'Camaragibe'],
 ['BR', '30', 'Camocim de S\xc3\xa3o F\xc3\xa9lix'],
 ['BR', '30', 'Camutanga'],
 ['BR', '30', 'Canhotinho'],
 ['BR', '30', 'Capoeiras'],
 ['BR', '30', 'Carna\xc3\xadba'],
 ['BR', '30', 'Carnaubeira da Penha'],
 ['BR', '30', 'Carpina'],
 ['BR', '30', 'Caruaru'],
 ['BR', '30', 'Casinhas'],
 ['BR', '30', 'Catende'],
 ['BR', '30', 'Ch\xc3\xa3 de Alegria'],
 ['BR', '30', 'Ch\xc3\xa3 Grande'],
 ['BR', '30', 'Condado'],
 ['BR', '30', 'Cort\xc3\xaas'],
 ['BR', '30', 'Cumaru'],
 ['BR', '30', 'Cupira'],
 ['BR', '30', 'Cust\xc3\xb3dia'],
 ['BR', '30', 'Dormentes'],
 ['BR', '30', 'Escada'],
 ['BR', '30', 'Exu'],
 ['BR', '30', 'Feira Nova'],
 ['BR', '30', 'Floresta'],
 ['BR', '30', 'Frei Miguelinho'],
 ['BR', '30', 'Gameleira'],
 ['BR', '30', 'Garanhuns'],
 ['BR', '30', 'Gl\xc3\xb3ria do Goit\xc3\xa1'],
 ['BR', '30', 'Goiana'],
 ['BR', '30', 'Granito'],
 ['BR', '30', 'Gravat\xc3\xa1'],
 ['BR', '30', 'Iati'],
 ['BR', '30', 'Ibimirim'],
 ['BR', '30', 'Ibirajuba'],
 ['BR', '30', 'Igarassu'],
 ['BR', '30', 'Iguaraci'],
 ['BR', '30', 'Inaj\xc3\xa1'],
 ['BR', '30', 'Ingazeira'],
 ['BR', '30', 'Ipojuca'],
 ['BR', '30', 'Ipubi'],
 ['BR', '30', 'Itacuruba'],
 ['BR', '30', 'Ita\xc3\xadba'],
 ['BR', '30', 'Ilha de Itamarac\xc3\xa1'],
 ['BR', '30', 'Itapetim'],
 ['BR', '30', 'Itapissuma'],
 ['BR', '30', 'Itaquitinga'],
 ['BR', '30', 'Jaboat\xc3\xa3o dos Guararapes'],
 ['BR', '30', 'Jaqueira'],
 ['BR', '30', 'Jata\xc3\xbaba'],
 ['BR', '30', 'Jatob\xc3\xa1'],
 ['BR', '30', 'Jo\xc3\xa3o Alfredo'],
 ['BR', '30', 'Joaquim Nabuco'],
 ['BR', '30', 'Jucati'],
 ['BR', '30', 'Jupi'],
 ['BR', '30', 'Jurema'],
 ['BR', '30', 'Lagoa do Carro'],
 ['BR', '30', 'Lagoa do Itaenga'],
 ['BR', '30', 'Lagoa do Ouro'],
 ['BR', '30', 'Lagoa dos Gatos'],
 ['BR', '30', 'Lagoa Grande'],
 ['BR', '30', 'Lajedo'],
 ['BR', '30', 'Limoeiro'],
 ['BR', '30', 'Macaparana'],
 ['BR', '30', 'Machados'],
 ['BR', '30', 'Manari'],
 ['BR', '30', 'Maraial'],
 ['BR', '30', 'Mirandiba'],
 ['BR', '30', 'Moreno'],
 ['BR', '30', 'Nazar\xc3\xa9 da Mata'],
 ['BR', '30', 'Olinda'],
 ['BR', '30', 'Orob\xc3\xb3'],
 ['BR', '30', 'Oroc\xc3\xb3'],
 ['BR', '30', 'Ouricuri'],
 ['BR', '30', 'Palmares'],
 ['BR', '30', 'Palmeirina'],
 ['BR', '30', 'Panelas'],
 ['BR', '30', 'Paranatama'],
 ['BR', '30', 'Parnamirim'],
 ['BR', '30', 'Passira'],
 ['BR', '30', 'Paudalho'],
 ['BR', '30', 'Pedra'],
 ['BR', '30', 'Pesqueira'],
 ['BR', '30', 'Petrol\xc3\xa2ndia'],
 ['BR', '30', 'Petrolina'],
 ['BR', '30', 'Po\xc3\xa7\xc3\xa3o'],
 ['BR', '30', 'Pombos'],
 ['BR', '30', 'Primavera'],
 ['BR', '30', 'Quipap\xc3\xa1'],
 ['BR', '30', 'Quixaba'],
 ['BR', '30', 'Recife'],
 ['BR', '30', 'Riacho das Almas'],
 ['BR', '30', 'Ribeir\xc3\xa3o'],
 ['BR', '30', 'Rio Formoso'],
 ['BR', '30', 'Sair\xc3\xa9'],
 ['BR', '30', 'Salgadinho'],
 ['BR', '30', 'Salgueiro'],
 ['BR', '30', 'Salo\xc3\xa1'],
 ['BR', '30', 'Sanhar\xc3\xb3'],
 ['BR', '30', 'Santa Cruz'],
 ['BR', '30', 'Santa Cruz da Baixa Verde'],
 ['BR', '30', 'Santa Cruz do Capibaribe'],
 ['BR', '30', 'Santa Filomena'],
 ['BR', '30', 'Santa Maria da Boa Vista'],
 ['BR', '30', 'Santa Maria do Cambuc\xc3\xa1'],
 ['BR', '30', 'Santa Terezinha'],
 ['BR', '30', 'S\xc3\xa3o Bento do Una'],
 ['BR', '30', 'S\xc3\xa3o Caitano'],
 ['BR', '30', 'S\xc3\xa3o Joaquim do Monte'],
 ['BR', '30', 'S\xc3\xa3o Jos\xc3\xa9 da Coroa Grande'],
 ['BR', '30', 'S\xc3\xa3o Jos\xc3\xa9 do Belmonte'],
 ['BR', '30', 'S\xc3\xa3o Jos\xc3\xa9 do Egito'],
 ['BR', '30', 'S\xc3\xa3o Louren\xc3\xa7o da Mata'],
 ['BR', '30', 'S\xc3\xa3o Vicente Ferrer'],
 ['BR', '30', 'Serra Talhada'],
 ['BR', '30', 'Sert\xc3\xa2nia'],
 ['BR', '30', 'Sirinha\xc3\xa9m'],
 ['BR', '30', 'Moreil\xc3\xa2ndia'],
 ['BR', '30', 'Solid\xc3\xa3o'],
 ['BR', '30', 'Surubim'],
 ['BR', '30', 'Tabira'],
 ['BR', '30', 'Tacaimb\xc3\xb3'],
 ['BR', '30', 'Tacaratu'],
 ['BR', '30', 'Tamandar\xc3\xa9'],
 ['BR', '30', 'Taquaritinga do Norte'],
 ['BR', '30', 'Terezinha'],
 ['BR', '30', 'Terra Nova'],
 ['BR', '30', 'Toritama'],
 ['BR', '30', 'Tracunha\xc3\xa9m'],
 ['BR', '30', 'Trindade'],
 ['BR', '30', 'Triunfo'],
 ['BR', '30', 'Tupanatinga'],
 ['BR', '30', 'Tuparetama'],
 ['BR', '30', 'Venturosa'],
 ['BR', '30', 'Verdejante'],
 ['BR', '30', 'Vertente do L\xc3\xa9rio'],
 ['BR', '30', 'Vertentes'],
 ['BR', '30', 'Vic\xc3\xaancia'],
 ['BR', '30', 'Vit\xc3\xb3ria de Santo Ant\xc3\xa3o'],
 ['BR', '30', 'Xex\xc3\xa9u'],
 ['BR', '02', 'Atalaia'],
 ['BR', '02', 'Barra de S\xc3\xa3o Miguel'],
 ['BR', '02', 'Bel\xc3\xa9m'],
 ['BR', '02', 'Boca da Mata'],
 ['BR', '02', 'Branquinha'],
 ['BR', '02', 'Cajueiro'],
 ['BR', '02', 'Campestre'],
 ['BR', '02', 'Campo Alegre'],
 ['BR', '02', 'Capela'],
 ['BR', '02', 'Carneiros'],
 ['BR', '02', 'Ch\xc3\xa3 Preta'],
 ['BR', '02', 'Coit\xc3\xa9 do N\xc3\xb3ia'],
 ['BR', '02', 'Col\xc3\xb4nia Leopoldina'],
 ['BR', '02', 'Coqueiro Seco'],
 ['BR', '02', 'Dois Riachos'],
 ['BR', '02', 'Feliz Deserto'],
 ['BR', '02', 'Flexeiras'],
 ['BR', '02', 'Ibateguara'],
 ['BR', '02', 'Inhapi'],
 ['BR', '02', 'Jacu\xc3\xadpe'],
 ['BR', '02', 'Japaratinga'],
 ['BR', '02', 'Jaramataia'],
 ['BR', '02', 'Joaquim Gomes'],
 ['BR', '02', 'Jundi\xc3\xa1'],
 ['BR', '02', 'Lagoa da Canoa'],
 ['BR', '02', 'Macei\xc3\xb3'],
 ['BR', '02', 'Maragogi'],
 ['BR', '02', 'Maravilha'],
 ['BR', '02', 'Marechal Deodoro'],
 ['BR', '02', 'Mar Vermelho'],
 ['BR', '02', 'Matriz de Camaragibe'],
 ['BR', '02', 'Messias'],
 ['BR', '02', 'Minador do Negr\xc3\xa3o'],
 ['BR', '02', 'Monteir\xc3\xb3polis'],
 ['BR', '02', 'Murici'],
 ['BR', '02', 'Novo Lino'],
 ['BR', '02', "Olho d'\xc3\x81gua Grande"],
 ['BR', '02', 'Oliven\xc3\xa7a'],
 ['BR', '02', 'Ouro Branco'],
 ['BR', '02', 'Palestina'],
 ['BR', '02', 'Pariconha'],
 ['BR', '02', 'Paripueira'],
 ['BR', '02', 'Passo de Camaragibe'],
 ['BR', '02', 'Paulo Jacinto'],
 ['BR', '02', 'Pia\xc3\xa7abu\xc3\xa7u'],
 ['BR', '02', 'Pilar'],
 ['BR', '02', 'Pindoba'],
 ['BR', '02', 'Porto Calvo'],
 ['BR', '02', 'Porto de Pedras'],
 ['BR', '02', 'Quebrangulo'],
 ['BR', '02', 'Rio Largo'],
 ['BR', '02', 'Roteiro'],
 ['BR', '02', 'Santa Luzia do Norte'],
 ['BR', '02', 'Santana do Munda\xc3\xba'],
 ['BR', '02', 'S\xc3\xa3o Lu\xc3\xads do Quitunde'],
 ['BR', '02', 'S\xc3\xa3o Miguel dos Milagres'],
 ['BR', '02', 'Satuba'],
 ['BR', '02', "Tanque d'Arca"],
 ['BR', '02', 'Taquarana'],
 ['BR', '02', 'Teot\xc3\xb4nio Vilela'],
 ['BR', '02', 'Uni\xc3\xa3o dos Palmares'],
 ['BR', '02', 'Vi\xc3\xa7osa'],
 ['BR', '28', 'Aracaju'],
 ['BR', '28', 'Arau\xc3\xa1'],
 ['BR', '28', 'Areia Branca'],
 ['BR', '28', 'Barra dos Coqueiros'],
 ['BR', '28', 'Boquim'],
 ['BR', '28', 'Brejo Grande'],
 ['BR', '28', 'Capela'],
 ['BR', '28', 'Carm\xc3\xb3polis'],
 ['BR', '28', 'Cristin\xc3\xa1polis'],
 ['BR', '28', 'Divina Pastora'],
 ['BR', '28', 'Est\xc3\xa2ncia'],
 ['BR', '28', 'General Maynard'],
 ['BR', '28', 'Ilha das Flores'],
 ['BR', '28', 'Indiaroba'],
 ['BR', '28', 'Itabaiana'],
 ['BR', '28', "Itaporanga d'Ajuda"],
 ['BR', '28', 'Japaratuba'],
 ['BR', '28', 'Laranjeiras'],
 ['BR', '28', 'Malhada dos Bois'],
 ['BR', '28', 'Malhador'],
 ['BR', '28', 'Maruim'],
 ['BR', '28', 'Moita Bonita'],
 ['BR', '28', 'Muribeca'],
 ['BR', '28', 'Nossa Senhora Aparecida'],
 ['BR', '28', 'Nossa Senhora de Lourdes'],
 ['BR', '28', 'Nossa Senhora do Socorro'],
 ['BR', '28', 'Pedrinhas'],
 ['BR', '28', 'Pirambu'],
 ['BR', '28', 'Riachuelo'],
 ['BR', '28', 'Ros\xc3\xa1rio do Catete'],
 ['BR', '28', 'Salgado'],
 ['BR', '28', 'Santa Luzia do Itanhy'],
 ['BR', '28', 'Santana do S\xc3\xa3o Francisco'],
 ['BR', '28', 'Santa Rosa de Lima'],
 ['BR', '28', 'Santo Amaro das Brotas'],
 ['BR', '28', 'S\xc3\xa3o Crist\xc3\xb3v\xc3\xa3o'],
 ['BR', '28', 'Siriri'],
 ['BR', '28', 'Telha'],
 ['BR', '28', 'Umba\xc3\xbaba'],
 ['BR', '05', 'Aba\xc3\xadra'],
 ['BR', '05', 'Abar\xc3\xa9'],
 ['BR', '05', 'Acajutiba'],
 ['BR', '05', 'Adustina'],
 ['BR', '05', '\xc3\x81gua Fria'],
 ['BR', '05', '\xc3\x89rico Cardoso'],
 ['BR', '05', 'Aiquara'],
 ['BR', '05', 'Alcoba\xc3\xa7a'],
 ['BR', '05', 'Almadina'],
 ['BR', '05', 'Amargosa'],
 ['BR', '05', 'Am\xc3\xa9lia Rodrigues'],
 ['BR', '05', 'Am\xc3\xa9rica Dourada'],
 ['BR', '05', 'Anag\xc3\xa9'],
 ['BR', '05', 'Andara\xc3\xad'],
 ['BR', '05', 'Andorinha'],
 ['BR', '05', 'Angical'],
 ['BR', '05', 'Anguera'],
 ['BR', '05', 'Antas'],
 ['BR', '05', 'Ant\xc3\xb4nio Cardoso'],
 ['BR', '05', 'Ant\xc3\xb4nio Gon\xc3\xa7alves'],
 ['BR', '05', 'Apor\xc3\xa1'],
 ['BR', '05', 'Apuarema'],
 ['BR', '05', 'Aracatu'],
 ['BR', '05', 'Ara\xc3\xa7as'],
 ['BR', '05', 'Araci'],
 ['BR', '05', 'Arataca'],
 ['BR', '05', 'Aratu\xc3\xadpe'],
 ['BR', '05', 'Aurelino Leal'],
 ['BR', '05', 'Baian\xc3\xb3polis'],
 ['BR', '05', 'Baixa Grande'],
 ['BR', '05', 'Banza\xc3\xaa'],
 ['BR', '05', 'Barra'],
 ['BR', '05', 'Barra da Estiva'],
 ['BR', '05', 'Barra do Cho\xc3\xa7a'],
 ['BR', '05', 'Barra do Rocha'],
 ['BR', '05', 'Barro Alto'],
 ['BR', '05', 'Governador Lomanto J\xc3\xbanior'],
 ['BR', '05', 'Belo Campo'],
 ['BR', '05', 'Biritinga'],
 ['BR', '05', 'Boa Nova'],
 ['BR', '05', 'Boa Vista do Tupim'],
 ['BR', '05', 'Bom Jesus da Lapa'],
 ['BR', '05', 'Bom Jesus da Serra'],
 ['BR', '05', 'Boninal'],
 ['BR', '05', 'Bonito'],
 ['BR', '05', 'Boquira'],
 ['BR', '05', 'Botupor\xc3\xa3'],
 ['BR', '05', 'Brejol\xc3\xa2ndia'],
 ['BR', '05', 'Brotas de Maca\xc3\xbabas'],
 ['BR', '05', 'Brumado'],
 ['BR', '05', 'Buerarema'],
 ['BR', '05', 'Buritirama'],
 ['BR', '05', 'Caatiba'],
 ['BR', '05', 'Cabaceiras do Paragua\xc3\xa7u'],
 ['BR', '05', 'Cachoeira'],
 ['BR', '05', 'Cacul\xc3\xa9'],
 ['BR', '05', 'Ca\xc3\xa9m'],
 ['BR', '05', 'Caetanos'],
 ['BR', '05', 'Caetit\xc3\xa9'],
 ['BR', '05', 'Cafarnaum'],
 ['BR', '05', 'Cairu'],
 ['BR', '05', 'Caldeir\xc3\xa3o Grande'],
 ['BR', '05', 'Camacan'],
 ['BR', '05', 'Cama\xc3\xa7ari'],
 ['BR', '05', 'Camamu'],
 ['BR', '05', 'Campo Alegre de Lourdes'],
 ['BR', '05', 'Campo Formoso'],
 ['BR', '05', 'Can\xc3\xa1polis'],
 ['BR', '05', 'Canarana'],
 ['BR', '05', 'Canavieiras'],
 ['BR', '05', 'Candeal'],
 ['BR', '05', 'Candiba'],
 ['BR', '05', 'C\xc3\xa2ndido Sales'],
 ['BR', '05', 'Cansan\xc3\xa7\xc3\xa3o'],
 ['BR', '05', 'Canudos'],
 ['BR', '05', 'Capela do Alto Alegre'],
 ['BR', '05', 'Capim Grosso'],
 ['BR', '05', 'Cara\xc3\xadbas'],
 ['BR', '05', 'Caravelas'],
 ['BR', '05', 'Cardeal da Silva'],
 ['BR', '05', 'Carinhanha'],
 ['BR', '05', 'Casa Nova'],
 ['BR', '05', 'Castro Alves'],
 ['BR', '05', 'Catol\xc3\xa2ndia'],
 ['BR', '05', 'Catu'],
 ['BR', '05', 'Caturama'],
 ['BR', '05', 'Central'],
 ['BR', '05', 'C\xc3\xadcero Dantas'],
 ['BR', '05', 'Cip\xc3\xb3'],
 ['BR', '05', 'Coaraci'],
 ['BR', '05', 'Cocos'],
 ['BR', '05', 'Concei\xc3\xa7\xc3\xa3o da Feira'],
 ['BR', '05', 'Concei\xc3\xa7\xc3\xa3o do Almeida'],
 ['BR', '05', 'Concei\xc3\xa7\xc3\xa3o do Coit\xc3\xa9'],
 ['BR', '05', 'Concei\xc3\xa7\xc3\xa3o do Jacu\xc3\xadpe'],
 ['BR', '05', 'Conde'],
 ['BR', '05', 'Conde\xc3\xbaba'],
 ['BR', '05', 'Contendas do Sincor\xc3\xa1'],
 ['BR', '05', 'Cora\xc3\xa7\xc3\xa3o de Maria'],
 ['BR', '05', 'Cordeiros'],
 ['BR', '05', 'Coribe'],
 ['BR', '05', 'Coronel Jo\xc3\xa3o S\xc3\xa1'],
 ['BR', '05', 'Correntina'],
 ['BR', '05', 'Cotegipe'],
 ['BR', '05', 'Cravol\xc3\xa2ndia'],
 ['BR', '05', 'Cris\xc3\xb3polis'],
 ['BR', '05', 'Crist\xc3\xb3polis'],
 ['BR', '05', 'Cruz das Almas'],
 ['BR', '05', 'Cura\xc3\xa7\xc3\xa1'],
 ['BR', '05', 'D\xc3\xa1rio Meira'],
 ['BR', '05', 'Dom Macedo Costa'],
 ['BR', '05', 'El\xc3\xadsio Medrado'],
 ['BR', '05', 'Encruzilhada'],
 ['BR', '05', 'Entre Rios'],
 ['BR', '05', 'Esplanada'],
 ['BR', '05', 'Euclides da Cunha'],
 ['BR', '05', 'Eun\xc3\xa1polis'],
 ['BR', '05', 'F\xc3\xa1tima'],
 ['BR', '05', 'Feira da Mata'],
 ['BR', '05', 'Feira de Santana'],
 ['BR', '05', 'Filad\xc3\xa9lfia'],
 ['BR', '05', 'Firmino Alves'],
 ['BR', '05', 'Floresta Azul'],
 ['BR', '05', 'Formosa do Rio Preto'],
 ['BR', '05', 'Gandu'],
 ['BR', '05', 'Gavi\xc3\xa3o'],
 ['BR', '05', 'Gentio do Ouro'],
 ['BR', '05', 'Gongogi'],
 ['BR', '05', 'Governador Mangabeira'],
 ['BR', '05', 'Guajeru'],
 ['BR', '05', 'Guanambi'],
 ['BR', '05', 'Guaratinga'],
 ['BR', '05', 'Heli\xc3\xb3polis'],
 ['BR', '05', 'Ibiassuc\xc3\xaa'],
 ['BR', '05', 'Ibicara\xc3\xad'],
 ['BR', '05', 'Ibicoara'],
 ['BR', '05', 'Ibicu\xc3\xad'],
 ['BR', '05', 'Ibipeba'],
 ['BR', '05', 'Ibipitanga'],
 ['BR', '05', 'Ibiquera'],
 ['BR', '05', 'Ibirapitanga'],
 ['BR', '05', 'Ibirapu\xc3\xa3'],
 ['BR', '05', 'Ibirataia'],
 ['BR', '05', 'Ibitiara'],
 ['BR', '05', 'Ibitit\xc3\xa1'],
 ['BR', '05', 'Ibotirama'],
 ['BR', '05', 'Ichu'],
 ['BR', '05', 'Igapor\xc3\xa3'],
 ['BR', '05', 'Igrapi\xc3\xbana'],
 ['BR', '05', 'Igua\xc3\xad'],
 ['BR', '05', 'Ilh\xc3\xa9us'],
 ['BR', '05', 'Inhambupe'],
 ['BR', '05', 'Ipecaet\xc3\xa1'],
 ['BR', '05', 'Ipia\xc3\xba'],
 ['BR', '05', 'Ipir\xc3\xa1'],
 ['BR', '05', 'Ipupiara'],
 ['BR', '05', 'Irajuba'],
 ['BR', '05', 'Iramaia'],
 ['BR', '05', 'Iraquara'],
 ['BR', '05', 'Irar\xc3\xa1'],
 ['BR', '05', 'Irec\xc3\xaa'],
 ['BR', '05', 'Itabela'],
 ['BR', '05', 'Itaberaba'],
 ['BR', '05', 'Itabuna'],
 ['BR', '05', 'Itacar\xc3\xa9'],
 ['BR', '05', 'Itaet\xc3\xa9'],
 ['BR', '05', 'Itagi'],
 ['BR', '05', 'Itagib\xc3\xa1'],
 ['BR', '05', 'Itagimirim'],
 ['BR', '05', 'Itagua\xc3\xa7u da Bahia'],
 ['BR', '05', 'Itaju do Col\xc3\xb4nia'],
 ['BR', '05', 'Itaju\xc3\xadpe'],
 ['BR', '05', 'Itamaraju'],
 ['BR', '05', 'Itamari'],
 ['BR', '05', 'Itamb\xc3\xa9'],
 ['BR', '05', 'Itanagra'],
 ['BR', '05', 'Itanh\xc3\xa9m'],
 ['BR', '05', 'Itaparica'],
 ['BR', '05', 'Itap\xc3\xa9'],
 ['BR', '05', 'Itapebi'],
 ['BR', '05', 'Itapetinga'],
 ['BR', '05', 'Itapitanga'],
 ['BR', '05', 'Itaquara'],
 ['BR', '05', 'Itarantim'],
 ['BR', '05', 'Itatim'],
 ['BR', '05', 'Itiru\xc3\xa7u'],
 ['BR', '05', 'Iti\xc3\xbaba'],
 ['BR', '05', 'Itoror\xc3\xb3'],
 ['BR', '05', 'Itua\xc3\xa7u'],
 ['BR', '05', 'Iui\xc3\xba'],
 ['BR', '05', 'Jaborandi'],
 ['BR', '05', 'Jacaraci'],
 ['BR', '05', 'Jacobina'],
 ['BR', '05', 'Jaguaquara'],
 ['BR', '05', 'Jaguarari'],
 ['BR', '05', 'Jaguaripe'],
 ['BR', '05', 'Janda\xc3\xadra'],
 ['BR', '05', 'Jequi\xc3\xa9'],
 ['BR', '05', 'Jeremoabo'],
 ['BR', '05', 'Jiquiri\xc3\xa7\xc3\xa1'],
 ['BR', '05', 'Jita\xc3\xbana'],
 ['BR', '05', 'Jo\xc3\xa3o Dourado'],
 ['BR', '05', 'Juazeiro'],
 ['BR', '05', 'Jucuru\xc3\xa7u'],
 ['BR', '05', 'Jussara'],
 ['BR', '05', 'Jussari'],
 ['BR', '05', 'Jussiape'],
 ['BR', '05', 'Lafaiete Coutinho'],
 ['BR', '05', 'Laje'],
 ['BR', '05', 'Lajed\xc3\xa3o'],
 ['BR', '05', 'Lajedinho'],
 ['BR', '05', 'Lajedo do Tabocal'],
 ['BR', '05', 'Lamar\xc3\xa3o'],
 ['BR', '05', 'Lap\xc3\xa3o'],
 ['BR', '05', 'Lauro de Freitas'],
 ['BR', '05', 'Len\xc3\xa7\xc3\xb3is'],
 ['BR', '05', 'Lic\xc3\xadnio de Almeida'],
 ['BR', '05', 'Livramento de Nossa Senhora'],
 ['BR', '05', 'Macajuba'],
 ['BR', '05', 'Macarani'],
 ['BR', '05', 'Maca\xc3\xbabas'],
 ['BR', '05', 'Madre de Deus'],
 ['BR', '05', 'Maetinga'],
 ['BR', '05', 'Maiquinique'],
 ['BR', '05', 'Mairi'],
 ['BR', '05', 'Malhada'],
 ['BR', '05', 'Malhada de Pedras'],
 ['BR', '05', 'Manoel Vitorino'],
 ['BR', '05', 'Mansid\xc3\xa3o'],
 ['BR', '05', 'Marac\xc3\xa1s'],
 ['BR', '05', 'Maragogipe'],
 ['BR', '05', 'Mara\xc3\xba'],
 ['BR', '05', 'Marcion\xc3\xadlio Souza'],
 ['BR', '05', 'Mascote'],
 ['BR', '05', 'Mata de S\xc3\xa3o Jo\xc3\xa3o'],
 ['BR', '05', 'Matina'],
 ['BR', '05', 'Medeiros Neto'],
 ['BR', '05', 'Miguel Calmon'],
 ['BR', '05', 'Mirangaba'],
 ['BR', '05', 'Mirante'],
 ['BR', '05', 'Monte Santo'],
 ['BR', '05', 'Morpar\xc3\xa1'],
 ['BR', '05', 'Morro do Chap\xc3\xa9u'],
 ['BR', '05', 'Mortugaba'],
 ['BR', '05', 'Mucug\xc3\xaa'],
 ['BR', '05', 'Mucuri'],
 ['BR', '05', 'Mulungu do Morro'],
 ['BR', '05', 'Mundo Novo'],
 ['BR', '05', 'Muniz Ferreira'],
 ['BR', '05', 'Muritiba'],
 ['BR', '05', 'Mutu\xc3\xadpe'],
 ['BR', '05', 'Nazar\xc3\xa9'],
 ['BR', '05', 'Nova Cana\xc3\xa3'],
 ['BR', '05', 'Nova F\xc3\xa1tima'],
 ['BR', '05', 'Nova Ibi\xc3\xa1'],
 ['BR', '05', 'Nova Itarana'],
 ['BR', '05', 'Nova Reden\xc3\xa7\xc3\xa3o'],
 ['BR', '05', 'Nova Soure'],
 ['BR', '05', 'Novo Horizonte'],
 ['BR', '05', 'Novo Triunfo'],
 ['BR', '05', 'Olindina'],
 ['BR', '05', 'Ouri\xc3\xa7angas'],
 ['BR', '05', 'Ourol\xc3\xa2ndia'],
 ['BR', '05', 'Palmas de Monte Alto'],
 ['BR', '05', 'Palmeiras'],
 ['BR', '05', 'Paramirim'],
 ['BR', '05', 'Paratinga'],
 ['BR', '05', 'Paripiranga'],
 ['BR', '05', 'Pau Brasil'],
 ['BR', '05', 'P\xc3\xa9 de Serra'],
 ['BR', '05', 'Pedr\xc3\xa3o'],
 ['BR', '05', 'Pedro Alexandre'],
 ['BR', '05', 'Piat\xc3\xa3'],
 ['BR', '05', 'Pil\xc3\xa3o Arcado'],
 ['BR', '05', 'Pinda\xc3\xad'],
 ['BR', '05', 'Pindoba\xc3\xa7u'],
 ['BR', '05', 'Pintadas'],
 ['BR', '05', 'Pira\xc3\xad do Norte'],
 ['BR', '05', 'Pirip\xc3\xa1'],
 ['BR', '05', 'Piritiba'],
 ['BR', '05', 'Planaltino'],
 ['BR', '05', 'Planalto'],
 ['BR', '05', 'Pojuca'],
 ['BR', '05', 'Ponto Novo'],
 ['BR', '05', 'Porto Seguro'],
 ['BR', '05', 'Potiragu\xc3\xa1'],
 ['BR', '05', 'Presidente Dutra'],
 ['BR', '05', 'Presidente J\xc3\xa2nio Quadros'],
 ['BR', '05', 'Queimadas'],
 ['BR', '05', 'Quijingue'],
 ['BR', '05', 'Quixabeira'],
 ['BR', '05', 'Rafael Jambeiro'],
 ['BR', '05', 'Remanso'],
 ['BR', '05', 'Retirol\xc3\xa2ndia'],
 ['BR', '05', 'Riach\xc3\xa3o das Neves'],
 ['BR', '05', 'Riach\xc3\xa3o do Jacu\xc3\xadpe'],
 ['BR', '05', 'Riacho de Santana'],
 ['BR', '05', 'Ribeira do Amparo'],
 ['BR', '05', 'Ribeira do Pombal'],
 ['BR', '05', 'Ribeir\xc3\xa3o do Largo'],
 ['BR', '05', 'Rio de Contas'],
 ['BR', '05', 'Rio do Ant\xc3\xb4nio'],
 ['BR', '05', 'Rio do Pires'],
 ['BR', '05', 'Ruy Barbosa'],
 ['BR', '05', 'Salinas da Margarida'],
 ['BR', '05', 'Salvador'],
 ['BR', '05', 'Santa B\xc3\xa1rbara'],
 ['BR', '05', 'Santa Br\xc3\xadgida'],
 ['BR', '05', 'Santa Cruz Cabr\xc3\xa1lia'],
 ['BR', '05', 'Santa Cruz da Vit\xc3\xb3ria'],
 ['BR', '05', 'Santa In\xc3\xaas'],
 ['BR', '05', 'Santaluz'],
 ['BR', '05', 'Santa Luzia'],
 ['BR', '05', 'Santan\xc3\xb3polis'],
 ['BR', '05', 'Santa Rita de C\xc3\xa1ssia'],
 ['BR', '05', 'Santa Teresinha'],
 ['BR', '05', 'Santo Amaro'],
 ['BR', '05', 'Santo Ant\xc3\xb4nio de Jesus'],
 ['BR', '05', 'Santo Est\xc3\xaav\xc3\xa3o'],
 ['BR', '05', 'S\xc3\xa3o Desid\xc3\xa9rio'],
 ['BR', '05', 'S\xc3\xa3o Domingos'],
 ['BR', '05', 'S\xc3\xa3o F\xc3\xa9lix'],
 ['BR', '05', 'S\xc3\xa3o F\xc3\xa9lix do Coribe'],
 ['BR', '05', 'S\xc3\xa3o Felipe'],
 ['BR', '05', 'S\xc3\xa3o Francisco do Conde'],
 ['BR', '05', 'S\xc3\xa3o Gabriel'],
 ['BR', '05', 'S\xc3\xa3o Gon\xc3\xa7alo dos Campos'],
 ['BR', '05', 'S\xc3\xa3o Jos\xc3\xa9 da Vit\xc3\xb3ria'],
 ['BR', '05', 'S\xc3\xa3o Jos\xc3\xa9 do Jacu\xc3\xadpe'],
 ['BR', '05', 'S\xc3\xa3o Miguel das Matas'],
 ['BR', '05', 'S\xc3\xa3o Sebasti\xc3\xa3o do Pass\xc3\xa9'],
 ['BR', '05', 'Sapea\xc3\xa7u'],
 ['BR', '05', 'S\xc3\xa1tiro Dias'],
 ['BR', '05', 'Saubara'],
 ['BR', '05', 'Sa\xc3\xbade'],
 ['BR', '05', 'Seabra'],
 ['BR', '05', 'Sebasti\xc3\xa3o Laranjeiras'],
 ['BR', '05', 'Senhor do Bonfim'],
 ['BR', '05', 'Serra do Ramalho'],
 ['BR', '05', 'Sento S\xc3\xa9'],
 ['BR', '05', 'Serra Dourada'],
 ['BR', '05', 'Serra Preta'],
 ['BR', '05', 'Serrol\xc3\xa2ndia'],
 ['BR', '05', 'Sim\xc3\xb5es Filho'],
 ['BR', '05', 'S\xc3\xadtio do Mato'],
 ['BR', '05', 'S\xc3\xadtio do Quinto'],
 ['BR', '05', 'Sobradinho'],
 ['BR', '05', 'Tabocas do Brejo Velho'],
 ['BR', '05', 'Tanha\xc3\xa7u'],
 ['BR', '05', 'Tanque Novo'],
 ['BR', '05', 'Tanquinho'],
 ['BR', '05', 'Tapero\xc3\xa1'],
 ['BR', '05', 'Tapiramut\xc3\xa1'],
 ['BR', '05', 'Teixeira de Freitas'],
 ['BR', '05', 'Teodoro Sampaio'],
 ['BR', '05', 'Teofil\xc3\xa2ndia'],
 ['BR', '05', 'Teol\xc3\xa2ndia'],
 ['BR', '05', 'Terra Nova'],
 ['BR', '05', 'Tucano'],
 ['BR', '05', 'Uau\xc3\xa1'],
 ['BR', '05', 'Uba\xc3\xadra'],
 ['BR', '05', 'Ubaitaba'],
 ['BR', '05', 'Ubat\xc3\xa3'],
 ['BR', '05', 'Uiba\xc3\xad'],
 ['BR', '05', 'Urandi'],
 ['BR', '05', 'Uru\xc3\xa7uca'],
 ['BR', '05', 'Utinga'],
 ['BR', '05', 'Valen\xc3\xa7a'],
 ['BR', '05', 'Valente'],
 ['BR', '05', 'V\xc3\xa1rzea da Ro\xc3\xa7a'],
 ['BR', '05', 'V\xc3\xa1rzea do Po\xc3\xa7o'],
 ['BR', '05', 'V\xc3\xa1rzea Nova'],
 ['BR', '05', 'Varzedo'],
 ['BR', '05', 'Vera Cruz'],
 ['BR', '05', 'Vereda'],
 ['BR', '05', 'Vit\xc3\xb3ria da Conquista'],
 ['BR', '05', 'Wagner'],
 ['BR', '05', 'Wanderley'],
 ['BR', '05', 'Wenceslau Guimar\xc3\xa3es'],
 ['BR', '05', 'Xique-Xique'],
 ['BR', '15', 'Abadia dos Dourados'],
 ['BR', '15', 'Abaet\xc3\xa9'],
 ['BR', '15', 'Abre Campo'],
 ['BR', '15', 'Acaiaca'],
 ['BR', '15', 'A\xc3\xa7ucena'],
 ['BR', '15', '\xc3\x81gua Boa'],
 ['BR', '15', '\xc3\x81gua Comprida'],
 ['BR', '15', 'Aguanil'],
 ['BR', '15', '\xc3\x81guas Formosas'],
 ['BR', '15', '\xc3\x81guas Vermelhas'],
 ['BR', '15', 'Aimor\xc3\xa9s'],
 ['BR', '15', 'Aiuruoca'],
 ['BR', '15', 'Alagoa'],
 ['BR', '15', 'Albertina'],
 ['BR', '15', 'Alfenas'],
 ['BR', '15', 'Alfredo Vasconcelos'],
 ['BR', '15', 'Almenara'],
 ['BR', '15', 'Alpercata'],
 ['BR', '15', 'Alpin\xc3\xb3polis'],
 ['BR', '15', 'Alterosa'],
 ['BR', '15', 'Alto Capara\xc3\xb3'],
 ['BR', '15', 'Alto Rio Doce'],
 ['BR', '15', 'Alvarenga'],
 ['BR', '15', 'Alvin\xc3\xb3polis'],
 ['BR', '15', 'Alvorada de Minas'],
 ['BR', '15', 'Amparo do Serra'],
 ['BR', '15', 'Andradas'],
 ['BR', '15', 'Cachoeira de Paje\xc3\xba'],
 ['BR', '15', 'Andrel\xc3\xa2ndia'],
 ['BR', '15', 'Angel\xc3\xa2ndia'],
 ['BR', '15', 'Ant\xc3\xb4nio Carlos'],
 ['BR', '15', 'Ant\xc3\xb4nio Dias'],
 ['BR', '15', 'Ant\xc3\xb4nio Prado de Minas'],
 ['BR', '15', 'Aracitaba'],
 ['BR', '15', 'Ara\xc3\xa7ua\xc3\xad'],
 ['BR', '15', 'Araguari'],
 ['BR', '15', 'Arantina'],
 ['BR', '15', 'Araponga'],
 ['BR', '15', 'Arapor\xc3\xa3'],
 ['BR', '15', 'Arapu\xc3\xa1'],
 ['BR', '15', 'Ara\xc3\xbajos'],
 ['BR', '15', 'Arax\xc3\xa1'],
 ['BR', '15', 'Arceburgo'],
 ['BR', '15', 'Arcos'],
 ['BR', '15', 'Areado'],
 ['BR', '15', 'Argirita'],
 ['BR', '15', 'Aricanduva'],
 ['BR', '15', 'Arinos'],
 ['BR', '15', 'Astolfo Dutra'],
 ['BR', '15', 'Atal\xc3\xa9ia'],
 ['BR', '15', 'Baependi'],
 ['BR', '15', 'Baldim'],
 ['BR', '15', 'Bambu\xc3\xad'],
 ['BR', '15', 'Bandeira'],
 ['BR', '15', 'Bandeira do Sul'],
 ['BR', '15', 'Bar\xc3\xa3o de Cocais'],
 ['BR', '15', 'Bar\xc3\xa3o de Monte Alto'],
 ['BR', '15', 'Barbacena'],
 ['BR', '15', 'Barra Longa'],
 ['BR', '15', 'Barroso'],
 ['BR', '15', 'Bela Vista de Minas'],
 ['BR', '15', 'Belo Horizonte'],
 ['BR', '15', 'Belo Oriente'],
 ['BR', '15', 'Belo Vale'],
 ['BR', '15', 'Berilo'],
 ['BR', '15', 'Bert\xc3\xb3polis'],
 ['BR', '15', 'Berizal'],
 ['BR', '15', 'Betim'],
 ['BR', '15', 'Bias Fortes'],
 ['BR', '15', 'Bicas'],
 ['BR', '15', 'Biquinhas'],
 ['BR', '15', 'Boa Esperan\xc3\xa7a'],
 ['BR', '15', 'Bocaina de Minas'],
 ['BR', '15', 'Bocai\xc3\xbava'],
 ['BR', '15', 'Bom Despacho'],
 ['BR', '15', 'Bom Jardim de Minas'],
 ['BR', '15', 'Bom Jesus da Penha'],
 ['BR', '15', 'Bom Jesus do Amparo'],
 ['BR', '15', 'Bom Jesus do Galho'],
 ['BR', '15', 'Bom Repouso'],
 ['BR', '15', 'Bom Sucesso'],
 ['BR', '15', 'Bonfim'],
 ['BR', '15', 'Bonfin\xc3\xb3polis de Minas'],
 ['BR', '15', 'Bonito de Minas'],
 ['BR', '15', 'Borda da Mata'],
 ['BR', '15', 'Botelhos'],
 ['BR', '15', 'Botumirim'],
 ['BR', '15', 'Brasil\xc3\xa2ndia de Minas'],
 ['BR', '15', 'Bras\xc3\xadlia de Minas'],
 ['BR', '15', 'Br\xc3\xa1s Pires'],
 ['BR', '15', 'Bra\xc3\xbanas'],
 ['BR', '15', 'Bras\xc3\xb3polis'],
 ['BR', '15', 'Brumadinho'],
 ['BR', '15', 'Bueno Brand\xc3\xa3o'],
 ['BR', '15', 'Bugre'],
 ['BR', '15', 'Buritis'],
 ['BR', '15', 'Buritizeiro'],
 ['BR', '15', 'Cabeceira Grande'],
 ['BR', '15', 'Cabo Verde'],
 ['BR', '15', 'Cachoeira da Prata'],
 ['BR', '15', 'Cachoeira de Minas'],
 ['BR', '15', 'Cachoeira Dourada'],
 ['BR', '15', 'Caetan\xc3\xb3polis'],
 ['BR', '15', 'Caet\xc3\xa9'],
 ['BR', '15', 'Caiana'],
 ['BR', '15', 'Cajuri'],
 ['BR', '15', 'Caldas'],
 ['BR', '15', 'Camacho'],
 ['BR', '15', 'Camanducaia'],
 ['BR', '15', 'Cambu\xc3\xad'],
 ['BR', '15', 'Cambuquira'],
 ['BR', '15', 'Campan\xc3\xa1rio'],
 ['BR', '15', 'Campanha'],
 ['BR', '15', 'Campestre'],
 ['BR', '15', 'Campina Verde'],
 ['BR', '15', 'Campo Azul'],
 ['BR', '15', 'Campo Belo'],
 ['BR', '15', 'Campo do Meio'],
 ['BR', '15', 'Campo Florido'],
 ['BR', '15', 'Campos Altos'],
 ['BR', '15', 'Campos Gerais'],
 ['BR', '15', 'Cana\xc3\xa3'],
 ['BR', '15', 'Can\xc3\xa1polis'],
 ['BR', '15', 'Cana Verde'],
 ['BR', '15', 'Cantagalo'],
 ['BR', '15', 'Capara\xc3\xb3'],
 ['BR', '15', 'Capela Nova'],
 ['BR', '15', 'Capelinha'],
 ['BR', '15', 'Capetinga'],
 ['BR', '15', 'Capim Branco'],
 ['BR', '15', 'Capin\xc3\xb3polis'],
 ['BR', '15', 'Capit\xc3\xa3o Andrade'],
 ['BR', '15', 'Capit\xc3\xa3o En\xc3\xa9as'],
 ['BR', '15', 'Capit\xc3\xb3lio'],
 ['BR', '15', 'Caputira'],
 ['BR', '15', 'Cara\xc3\xad'],
 ['BR', '15', 'Carana\xc3\xadba'],
 ['BR', '15', 'Caranda\xc3\xad'],
 ['BR', '15', 'Carangola'],
 ['BR', '15', 'Caratinga'],
 ['BR', '15', 'Carbonita'],
 ['BR', '15', 'Carea\xc3\xa7u'],
 ['BR', '15', 'Carlos Chagas'],
 ['BR', '15', 'Carm\xc3\xa9sia'],
 ['BR', '15', 'Carmo da Cachoeira'],
 ['BR', '15', 'Carmo da Mata'],
 ['BR', '15', 'Carmo de Minas'],
 ['BR', '15', 'Carmo do Cajuru'],
 ['BR', '15', 'Carmo do Parana\xc3\xadba'],
 ['BR', '15', 'Carmo do Rio Claro'],
 ['BR', '15', 'Carm\xc3\xb3polis de Minas'],
 ['BR', '15', 'Carneirinho'],
 ['BR', '15', 'Carrancas'],
 ['BR', '15', 'Carvalh\xc3\xb3polis'],
 ['BR', '15', 'Carvalhos'],
 ['BR', '15', 'Casa Grande'],
 ['BR', '15', 'Cascalho Rico'],
 ['BR', '15', 'C\xc3\xa1ssia'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o da Barra de Minas'],
 ['BR', '15', 'Cataguases'],
 ['BR', '15', 'Catas Altas'],
 ['BR', '15', 'Catas Altas da Noruega'],
 ['BR', '15', 'Catuji'],
 ['BR', '15', 'Catuti'],
 ['BR', '15', 'Caxambu'],
 ['BR', '15', 'Cedro do Abaet\xc3\xa9'],
 ['BR', '15', 'Central de Minas'],
 ['BR', '15', 'Centralina'],
 ['BR', '15', 'Ch\xc3\xa1cara'],
 ['BR', '15', 'Chal\xc3\xa9'],
 ['BR', '15', 'Chapada do Norte'],
 ['BR', '15', 'Chapada Ga\xc3\xbacha'],
 ['BR', '15', 'Chiador'],
 ['BR', '15', 'Cipot\xc3\xa2nea'],
 ['BR', '15', 'Claraval'],
 ['BR', '15', 'Claro dos Po\xc3\xa7\xc3\xb5es'],
 ['BR', '15', 'Cl\xc3\xa1udio'],
 ['BR', '15', 'Coimbra'],
 ['BR', '15', 'Coluna'],
 ['BR', '15', 'Comendador Gomes'],
 ['BR', '15', 'Comercinho'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o da Aparecida'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o das Pedras'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o das Alagoas'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o de Ipanema'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o do Par\xc3\xa1'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o do Rio Verde'],
 ['BR', '15', 'Concei\xc3\xa7\xc3\xa3o dos Ouros'],
 ['BR', '15', 'C\xc3\xb4nego Marinho'],
 ['BR', '15', 'Confins'],
 ['BR', '15', 'Congonhal'],
 ['BR', '15', 'Congonhas'],
 ['BR', '15', 'Congonhas do Norte'],
 ['BR', '15', 'Conquista'],
 ['BR', '15', 'Conselheiro Lafaiete'],
 ['BR', '15', 'Conselheiro Pena'],
 ['BR', '15', 'Contagem'],
 ['BR', '15', 'Coqueiral'],
 ['BR', '15', 'Cora\xc3\xa7\xc3\xa3o de Jesus'],
 ['BR', '15', 'Cordisburgo'],
 ['BR', '15', 'Cordisl\xc3\xa2ndia'],
 ['BR', '15', 'Corinto'],
 ['BR', '15', 'Coroaci'],
 ['BR', '15', 'Coromandel'],
 ['BR', '15', 'Coronel Fabriciano'],
 ['BR', '15', 'Coronel Murta'],
 ['BR', '15', 'Coronel Pacheco'],
 ['BR', '15', 'Coronel Xavier Chaves'],
 ['BR', '15', 'C\xc3\xb3rrego Danta'],
 ['BR', '15', 'C\xc3\xb3rrego do Bom Jesus'],
 ['BR', '15', 'C\xc3\xb3rrego Fundo'],
 ['BR', '15', 'C\xc3\xb3rrego Novo'],
 ['BR', '15', 'Couto de Magalh\xc3\xa3es de Minas'],
 ['BR', '15', 'Cris\xc3\xb3lita'],
 ['BR', '15', 'Cristais'],
 ['BR', '15', 'Crist\xc3\xa1lia'],
 ['BR', '15', 'Cristiano Otoni'],
 ['BR', '15', 'Cristina'],
 ['BR', '15', 'Crucil\xc3\xa2ndia'],
 ['BR', '15', 'Cruzeiro da Fortaleza'],
 ['BR', '15', 'Cruz\xc3\xadlia'],
 ['BR', '15', 'Cuparaque'],
 ['BR', '15', 'Curral de Dentro'],
 ['BR', '15', 'Curvelo'],
 ['BR', '15', 'Datas'],
 ['BR', '15', 'Delfim Moreira'],
 ['BR', '15', 'Delfin\xc3\xb3polis'],
 ['BR', '15', 'Delta'],
 ['BR', '15', 'Descoberto'],
 ['BR', '15', 'Desterro de Entre Rios'],
 ['BR', '15', 'Desterro do Melo'],
 ['BR', '15', 'Diogo de Vasconcelos'],
 ['BR', '15', 'Dion\xc3\xadsio'],
 ['BR', '15', 'Divin\xc3\xa9sia'],
 ['BR', '15', 'Divino'],
 ['BR', '15', 'Divino das Laranjeiras'],
 ['BR', '15', 'Divinol\xc3\xa2ndia de Minas'],
 ['BR', '15', 'Divin\xc3\xb3polis'],
 ['BR', '15', 'Divisa Alegre'],
 ['BR', '15', 'Divisa Nova'],
 ['BR', '15', 'Divis\xc3\xb3polis'],
 ['BR', '15', 'Dom Bosco'],
 ['BR', '15', 'Dom Cavati'],
 ['BR', '15', 'Dom Joaquim'],
 ['BR', '15', 'Dom Silv\xc3\xa9rio'],
 ['BR', '15', 'Dom Vi\xc3\xa7oso'],
 ['BR', '15', 'Dona Eus\xc3\xa9bia'],
 ['BR', '15', 'Dores de Campos'],
 ['BR', '15', 'Dores de Guanh\xc3\xa3es'],
 ['BR', '15', 'Dores do Indai\xc3\xa1'],
 ['BR', '15', 'Dores do Turvo'],
 ['BR', '15', 'Dores\xc3\xb3polis'],
 ['BR', '15', 'Douradoquara'],
 ['BR', '15', 'Durand\xc3\xa9'],
 ['BR', '15', 'El\xc3\xb3i Mendes'],
 ['BR', '15', 'Engenheiro Caldas'],
 ['BR', '15', 'Engenheiro Navarro'],
 ['BR', '15', 'Entre Folhas'],
 ['BR', '15', 'Entre Rios de Minas'],
 ['BR', '15', 'Erv\xc3\xa1lia'],
 ['BR', '15', 'Esmeraldas'],
 ['BR', '15', 'Espera Feliz'],
 ['BR', '15', 'Espinosa'],
 ['BR', '15', 'Esp\xc3\xadrito Santo do Dourado'],
 ['BR', '15', 'Estiva'],
 ['BR', '15', 'Estrela Dalva'],
 ['BR', '15', 'Estrela do Indai\xc3\xa1'],
 ['BR', '15', 'Estrela do Sul'],
 ['BR', '15', 'Eugen\xc3\xb3polis'],
 ['BR', '15', 'Ewbank da C\xc3\xa2mara'],
 ['BR', '15', 'Extrema'],
 ['BR', '15', 'Fama'],
 ['BR', '15', 'Faria Lemos'],
 ['BR', '15', 'Fel\xc3\xadcio dos Santos'],
 ['BR', '15', 'S\xc3\xa3o Gon\xc3\xa7alo do Rio Preto'],
 ['BR', '15', 'Felisburgo'],
 ['BR', '15', 'Felixl\xc3\xa2ndia'],
 ['BR', '15', 'Fernandes Tourinho'],
 ['BR', '15', 'Ferros'],
 ['BR', '15', 'Fervedouro'],
 ['BR', '15', 'Florestal'],
 ['BR', '15', 'Formiga'],
 ['BR', '15', 'Formoso'],
 ['BR', '15', 'Fortaleza de Minas'],
 ['BR', '15', 'Fortuna de Minas'],
 ['BR', '15', 'Francisco Badar\xc3\xb3'],
 ['BR', '15', 'Francisco Dumont'],
 ['BR', '15', 'Francisco S\xc3\xa1'],
 ['BR', '15', 'Francisc\xc3\xb3polis'],
 ['BR', '15', 'Frei Gaspar'],
 ['BR', '15', 'Frei Inoc\xc3\xaancio'],
 ['BR', '15', 'Frei Lagonegro'],
 ['BR', '15', 'Fronteira'],
 ['BR', '15', 'Fronteira dos Vales'],
 ['BR', '15', 'Fruta de Leite'],
 ['BR', '15', 'Frutal'],
 ['BR', '15', 'Funil\xc3\xa2ndia'],
 ['BR', '15', 'Galil\xc3\xa9ia'],
 ['BR', '15', 'Gameleiras'],
 ['BR', '15', 'Glaucil\xc3\xa2ndia'],
 ['BR', '15', 'Goiabeira'],
 ['BR', '15', 'Goian\xc3\xa1'],
 ['BR', '15', 'Gon\xc3\xa7alves'],
 ['BR', '15', 'Gonzaga'],
 ['BR', '15', 'Governador Valadares'],
 ['BR', '15', 'Gr\xc3\xa3o Mogol'],
 ['BR', '15', 'Grupiara'],
 ['BR', '15', 'Guanh\xc3\xa3es'],
 ['BR', '15', 'Guap\xc3\xa9'],
 ['BR', '15', 'Guaraciaba'],
 ['BR', '15', 'Guaraciama'],
 ['BR', '15', 'Guaran\xc3\xa9sia'],
 ['BR', '15', 'Guarani'],
 ['BR', '15', 'Guarar\xc3\xa1'],
 ['BR', '15', 'Guarda-Mor'],
 ['BR', '15', 'Guaxup\xc3\xa9'],
 ['BR', '15', 'Guiricema'],
 ['BR', '15', 'Gurinhat\xc3\xa3'],
 ['BR', '15', 'Heliodora'],
 ['BR', '15', 'Iapu'],
 ['BR', '15', 'Ibertioga'],
 ['BR', '15', 'Ibi\xc3\xa1'],
 ['BR', '15', 'Ibia\xc3\xad'],
 ['BR', '15', 'Ibiracatu'],
 ['BR', '15', 'Ibiraci'],
 ['BR', '15', 'Ibirit\xc3\xa9'],
 ['BR', '15', 'Ibiti\xc3\xbara de Minas'],
 ['BR', '15', 'Ibituruna'],
 ['BR', '15', 'Icara\xc3\xad de Minas'],
 ['BR', '15', 'Igarap\xc3\xa9'],
 ['BR', '15', 'Igaratinga'],
 ['BR', '15', 'Iguatama'],
 ['BR', '15', 'Ijaci'],
 ['BR', '15', 'Ilic\xc3\xadnea'],
 ['BR', '15', 'Imb\xc3\xa9 de Minas'],
 ['BR', '15', 'Inconfidentes'],
 ['BR', '15', 'Indaiabira'],
 ['BR', '15', 'Indian\xc3\xb3polis'],
 ['BR', '15', 'Inga\xc3\xad'],
 ['BR', '15', 'Inhapim'],
 ['BR', '15', 'Inha\xc3\xbama'],
 ['BR', '15', 'Inimutaba'],
 ['BR', '15', 'Ipaba'],
 ['BR', '15', 'Ipatinga'],
 ['BR', '15', 'Ipia\xc3\xa7u'],
 ['BR', '15', 'Ipui\xc3\xbana'],
 ['BR', '15', 'Ira\xc3\xad de Minas'],
 ['BR', '15', 'Itabira'],
 ['BR', '15', 'Itabirinha de Mantena'],
 ['BR', '15', 'Itabirito'],
 ['BR', '15', 'Itacambira'],
 ['BR', '15', 'Itacarambi'],
 ['BR', '15', 'Itaguara'],
 ['BR', '15', 'Itaip\xc3\xa9'],
 ['BR', '15', 'Itajub\xc3\xa1'],
 ['BR', '15', 'Itamarandiba'],
 ['BR', '15', 'Itamarati de Minas'],
 ['BR', '15', 'Itambacuri'],
 ['BR', '15', 'Itamb\xc3\xa9 do Mato Dentro'],
 ['BR', '15', 'Itamogi'],
 ['BR', '15', 'Itamonte'],
 ['BR', '15', 'Itanhandu'],
 ['BR', '15', 'Itanhomi'],
 ['BR', '15', 'Itaobim'],
 ['BR', '15', 'Itapagipe'],
 ['BR', '15', 'Itapecerica'],
 ['BR', '15', 'Itapeva'],
 ['BR', '15', 'Itatiaiu\xc3\xa7u'],
 ['BR', '15', 'Ita\xc3\xba de Minas'],
 ['BR', '15', 'Ita\xc3\xbana'],
 ['BR', '15', 'Itaverava'],
 ['BR', '15', 'Itinga'],
 ['BR', '15', 'Itueta'],
 ['BR', '15', 'Ituiutaba'],
 ['BR', '15', 'Itumirim'],
 ['BR', '15', 'Iturama'],
 ['BR', '15', 'Itutinga'],
 ['BR', '15', 'Jaboticatubas'],
 ['BR', '15', 'Jacinto'],
 ['BR', '15', 'Jacu\xc3\xad'],
 ['BR', '15', 'Jacutinga'],
 ['BR', '15', 'Jaguara\xc3\xa7u'],
 ['BR', '15', 'Ja\xc3\xadba'],
 ['BR', '15', 'Jampruca'],
 ['BR', '15', 'Jana\xc3\xbaba'],
 ['BR', '15', 'Janu\xc3\xa1ria'],
 ['BR', '15', 'Japara\xc3\xadba'],
 ['BR', '15', 'Japonvar'],
 ['BR', '15', 'Jeceaba'],
 ['BR', '15', 'Jenipapo de Minas'],
 ['BR', '15', 'Jequeri'],
 ['BR', '15', 'Jequita\xc3\xad'],
 ['BR', '15', 'Jequitib\xc3\xa1'],
 ['BR', '15', 'Jequitinhonha'],
 ['BR', '15', 'Jesu\xc3\xa2nia'],
 ['BR', '15', 'Joa\xc3\xadma'],
 ['BR', '15', 'Joan\xc3\xa9sia'],
 ['BR', '15', 'Jo\xc3\xa3o Monlevade'],
 ['BR', '15', 'Jo\xc3\xa3o Pinheiro'],
 ['BR', '15', 'Joaquim Fel\xc3\xadcio'],
 ['BR', '15', 'Jord\xc3\xa2nia'],
 ['BR', '15', 'Jos\xc3\xa9 Gon\xc3\xa7alves de Minas'],
 ['BR', '15', 'Jos\xc3\xa9 Raydan'],
 ['BR', '15', 'Josen\xc3\xb3polis'],
 ['BR', '15', 'Nova Uni\xc3\xa3o'],
 ['BR', '15', 'Juatuba'],
 ['BR', '15', 'Juramento'],
 ['BR', '15', 'Juruaia'],
 ['BR', '15', 'Juven\xc3\xadlia'],
 ['BR', '15', 'Ladainha'],
 ['BR', '15', 'Lagamar'],
 ['BR', '15', 'Lagoa da Prata'],
 ['BR', '15', 'Lagoa dos Patos'],
 ['BR', '15', 'Lagoa Dourada'],
 ['BR', '15', 'Lagoa Formosa'],
 ['BR', '15', 'Lagoa Grande'],
 ['BR', '15', 'Lagoa Santa'],
 ['BR', '15', 'Lajinha'],
 ['BR', '15', 'Lambari'],
 ['BR', '15', 'Lamim'],
 ['BR', '15', 'Laranjal'],
 ['BR', '15', 'Lassance'],
 ['BR', '15', 'Lavras'],
 ['BR', '15', 'Leandro Ferreira'],
 ['BR', '15', 'Leme do Prado'],
 ['BR', '15', 'Leopoldina'],
 ['BR', '15', 'Liberdade'],
 ['BR', '15', 'Lima Duarte'],
 ['BR', '15', 'Limeira do Oeste'],
 ['BR', '15', 'Lontra'],
 ['BR', '15', 'Luisburgo'],
 ['BR', '15', 'Luisl\xc3\xa2ndia'],
 ['BR', '15', 'Lumin\xc3\xa1rias'],
 ['BR', '15', 'Luz'],
 ['BR', '15', 'Machacalis'],
 ['BR', '15', 'Madre de Deus de Minas'],
 ['BR', '15', 'Malacacheta'],
 ['BR', '15', 'Mamonas'],
 ['BR', '15', 'Manga'],
 ['BR', '15', 'Manhua\xc3\xa7u'],
 ['BR', '15', 'Manhumirim'],
 ['BR', '15', 'Mantena'],
 ['BR', '15', 'Maravilhas'],
 ['BR', '15', 'Maria da F\xc3\xa9'],
 ['BR', '15', 'Mariana'],
 ['BR', '15', 'Marilac'],
 ['BR', '15', 'M\xc3\xa1rio Campos'],
 ['BR', '15', 'Marip\xc3\xa1 de Minas'],
 ['BR', '15', 'Marli\xc3\xa9ria'],
 ['BR', '15', 'Marmel\xc3\xb3polis'],
 ['BR', '15', 'Martinho Campos'],
 ['BR', '15', 'Martins Soares'],
 ['BR', '15', 'Mata Verde'],
 ['BR', '15', 'Materl\xc3\xa2ndia'],
 ['BR', '15', 'Mateus Leme'],
 ['BR', '15', 'Matias Cardoso'],
 ['BR', '15', 'Matip\xc3\xb3'],
 ['BR', '15', 'Mato Verde'],
 ['BR', '15', 'Matozinhos'],
 ['BR', '15', 'Matutina'],
 ['BR', '15', 'Medeiros'],
 ['BR', '15', 'Medina'],
 ['BR', '15', 'Mendes Pimentel'],
 ['BR', '15', 'Merc\xc3\xaas'],
 ['BR', '15', 'Mesquita'],
 ['BR', '15', 'Minas Novas'],
 ['BR', '15', 'Minduri'],
 ['BR', '15', 'Mirabela'],
 ['BR', '15', 'Miradouro'],
 ['BR', '15', 'Mira\xc3\xad'],
 ['BR', '15', 'Mirav\xc3\xa2nia'],
 ['BR', '15', 'Moeda'],
 ['BR', '15', 'Moema'],
 ['BR', '15', 'Monjolos'],
 ['BR', '15', 'Monsenhor Paulo'],
 ['BR', '15', 'Montalv\xc3\xa2nia'],
 ['BR', '15', 'Monte Alegre de Minas'],
 ['BR', '15', 'Monte Azul'],
 ['BR', '15', 'Monte Belo'],
 ['BR', '15', 'Monte Carmelo'],
 ['BR', '15', 'Monte Formoso'],
 ['BR', '15', 'Monte Santo de Minas'],
 ['BR', '15', 'Montes Claros'],
 ['BR', '15', 'Montezuma'],
 ['BR', '15', 'Morada Nova de Minas'],
 ['BR', '15', 'Morro da Gar\xc3\xa7a'],
 ['BR', '15', 'Morro do Pilar'],
 ['BR', '15', 'Munhoz'],
 ['BR', '15', 'Muria\xc3\xa9'],
 ['BR', '15', 'Mutum'],
 ['BR', '15', 'Muzambinho'],
 ['BR', '15', 'Nacip Raydan'],
 ['BR', '15', 'Nanuque'],
 ['BR', '15', 'Naque'],
 ['BR', '15', 'Natal\xc3\xa2ndia'],
 ['BR', '15', 'Nat\xc3\xa9rcia'],
 ['BR', '15', 'Nazareno'],
 ['BR', '15', 'Nepomuceno'],
 ['BR', '15', 'Ninheira'],
 ['BR', '15', 'Nova Bel\xc3\xa9m'],
 ['BR', '15', 'Nova Era'],
 ['BR', '15', 'Nova Lima'],
 ['BR', '15', 'Nova M\xc3\xb3dica'],
 ['BR', '15', 'Nova Ponte'],
 ['BR', '15', 'Nova Porteirinha'],
 ['BR', '15', 'Nova Resende'],
 ['BR', '15', 'Nova Serrana'],
 ['BR', '15', 'Novo Cruzeiro'],
 ['BR', '15', 'Novo Oriente de Minas'],
 ['BR', '15', 'Novorizonte'],
 ['BR', '15', 'Olaria'],
 ['BR', '15', "Olhos-d'\xc3\x81gua"],
 ['BR', '15', 'Ol\xc3\xadmpio Noronha'],
 ['BR', '15', 'Oliveira'],
 ['BR', '15', 'Oliveira Fortes'],
 ['BR', '15', 'On\xc3\xa7a de Pitangui'],
 ['BR', '15', 'Orat\xc3\xb3rios'],
 ['BR', '15', 'Oriz\xc3\xa2nia'],
 ['BR', '15', 'Ouro Branco'],
 ['BR', '15', 'Ouro Preto'],
 ['BR', '15', 'Ouro Verde de Minas'],
 ['BR', '15', 'Padre Carvalho'],
 ['BR', '15', 'Padre Para\xc3\xadso'],
 ['BR', '15', 'Paineiras'],
 ['BR', '15', 'Pains'],
 ['BR', '15', 'Pai Pedro'],
 ['BR', '15', 'Paiva'],
 ['BR', '15', 'Palma'],
 ['BR', '15', 'Palm\xc3\xb3polis'],
 ['BR', '15', 'Papagaios'],
 ['BR', '15', 'Paracatu'],
 ['BR', '15', 'Par\xc3\xa1 de Minas'],
 ['BR', '15', 'Paragua\xc3\xa7u'],
 ['BR', '15', 'Parais\xc3\xb3polis'],
 ['BR', '15', 'Paraopeba'],
 ['BR', '15', 'Passab\xc3\xa9m'],
 ['BR', '15', 'Passa Quatro'],
 ['BR', '15', 'Passa Tempo'],
 ['BR', '15', 'Passa-Vinte'],
 ['BR', '15', 'Passos'],
 ['BR', '15', 'Patis'],
 ['BR', '15', 'Patos de Minas'],
 ['BR', '15', 'Patroc\xc3\xadnio'],
 ['BR', '15', 'Paula C\xc3\xa2ndido'],
 ['BR', '15', 'Paulistas'],
 ['BR', '15', 'Pav\xc3\xa3o'],
 ['BR', '15', 'Pe\xc3\xa7anha'],
 ['BR', '15', 'Pedra Azul'],
 ['BR', '15', 'Pedra Bonita'],
 ['BR', '15', 'Pedra do Anta'],
 ['BR', '15', 'Pedra do Indai\xc3\xa1'],
 ['BR', '15', 'Pedra Dourada'],
 ['BR', '15', 'Pedralva'],
 ['BR', '15', 'Pedras de Maria da Cruz'],
 ['BR', '15', 'Pedrin\xc3\xb3polis'],
 ['BR', '15', 'Pedro Leopoldo'],
 ['BR', '15', 'Pedro Teixeira'],
 ['BR', '15', 'Pequeri'],
 ['BR', '15', 'Pequi'],
 ['BR', '15', 'Perdig\xc3\xa3o'],
 ['BR', '15', 'Perdizes'],
 ['BR', '15', 'Perd\xc3\xb5es'],
 ['BR', '15', 'Periquito'],
 ['BR', '15', 'Pescador'],
 ['BR', '15', 'Piau'],
 ['BR', '15', 'Piedade de Caratinga'],
 ['BR', '15', 'Piedade de Ponte Nova'],
 ['BR', '15', 'Piedade do Rio Grande'],
 ['BR', '15', 'Piedade dos Gerais'],
 ['BR', '15', 'Pimenta'],
 ['BR', '15', "Pingo-d'\xc3\x81gua"],
 ['BR', '15', 'Pint\xc3\xb3polis'],
 ['BR', '15', 'Piracema'],
 ['BR', '15', 'Pirajuba'],
 ['BR', '15', 'Piranga'],
 ['BR', '15', 'Pirangu\xc3\xa7u'],
 ['BR', '15', 'Piranguinho'],
 ['BR', '15', 'Pirapetinga'],
 ['BR', '15', 'Pirapora'],
 ['BR', '15', 'Pira\xc3\xbaba'],
 ['BR', '15', 'Pitangui'],
 ['BR', '15', 'Piumhi'],
 ['BR', '15', 'Planura'],
 ['BR', '15', 'Po\xc3\xa7o Fundo'],
 ['BR', '15', 'Po\xc3\xa7os de Caldas'],
 ['BR', '15', 'Pocrane'],
 ['BR', '15', 'Pomp\xc3\xa9u'],
 ['BR', '15', 'Ponte Nova'],
 ['BR', '15', 'Ponto Chique'],
 ['BR', '15', 'Ponto dos Volantes'],
 ['BR', '15', 'Porteirinha'],
 ['BR', '15', 'Porto Firme'],
 ['BR', '15', 'Pot\xc3\xa9'],
 ['BR', '15', 'Pouso Alegre'],
 ['BR', '15', 'Pouso Alto'],
 ['BR', '15', 'Prados'],
 ['BR', '15', 'Prat\xc3\xa1polis'],
 ['BR', '15', 'Pratinha'],
 ['BR', '15', 'Presidente Bernardes'],
 ['BR', '15', 'Presidente Juscelino'],
 ['BR', '15', 'Presidente Kubitschek'],
 ['BR', '15', 'Presidente Oleg\xc3\xa1rio'],
 ['BR', '15', 'Alto Jequitib\xc3\xa1'],
 ['BR', '15', 'Prudente de Morais'],
 ['BR', '15', 'Quartel Geral'],
 ['BR', '15', 'Queluzito'],
 ['BR', '15', 'Raposos'],
 ['BR', '15', 'Raul Soares'],
 ['BR', '15', 'Recreio'],
 ['BR', '15', 'Reduto'],
 ['BR', '15', 'Resende Costa'],
 ['BR', '15', 'Resplendor'],
 ['BR', '15', 'Ressaquinha'],
 ['BR', '15', 'Riachinho'],
 ['BR', '15', 'Riacho dos Machados'],
 ['BR', '15', 'Ribeir\xc3\xa3o das Neves'],
 ['BR', '15', 'Ribeir\xc3\xa3o Vermelho'],
 ['BR', '15', 'Rio Acima'],
 ['BR', '15', 'Rio Casca'],
 ['BR', '15', 'Rio Doce'],
 ['BR', '15', 'Rio do Prado'],
 ['BR', '15', 'Rio Espera'],
 ['BR', '15', 'Rio Manso'],
 ['BR', '15', 'Rio Novo'],
 ['BR', '15', 'Rio Parana\xc3\xadba'],
 ['BR', '15', 'Rio Pardo de Minas'],
 ['BR', '15', 'Rio Piracicaba'],
 ['BR', '15', 'Rio Pomba'],
 ['BR', '15', 'Rio Preto'],
 ['BR', '15', 'Rio Vermelho'],
 ['BR', '15', 'Rit\xc3\xa1polis'],
 ['BR', '15', 'Rochedo de Minas'],
 ['BR', '15', 'Rodeiro'],
 ['BR', '15', 'Romaria'],
 ['BR', '15', 'Ros\xc3\xa1rio da Limeira'],
 ['BR', '15', 'Rubelita'],
 ['BR', '15', 'Rubim'],
 ['BR', '15', 'Sabar\xc3\xa1'],
 ['BR', '15', 'Sabin\xc3\xb3polis'],
 ['BR', '15', 'Sacramento'],
 ['BR', '15', 'Salinas'],
 ['BR', '15', 'Salto da Divisa'],
 ['BR', '15', 'Santa B\xc3\xa1rbara'],
 ['BR', '15', 'Santa B\xc3\xa1rbara do Leste'],
 ['BR', '15', 'Santa B\xc3\xa1rbara do Monte Verde'],
 ['BR', '15', 'Santa Cruz de Minas'],
 ['BR', '15', 'Santa Cruz de Salinas'],
 ['BR', '15', 'Santa Cruz do Escalvado'],
 ['BR', '15', 'Santa Efig\xc3\xaania de Minas'],
 ['BR', '15', 'Santa F\xc3\xa9 de Minas'],
 ['BR', '15', 'Santa Helena de Minas'],
 ['BR', '15', 'Santa Juliana'],
 ['BR', '15', 'Santa Luzia'],
 ['BR', '15', 'Santa Margarida'],
 ['BR', '15', 'Santa Maria de Itabira'],
 ['BR', '15', 'Santa Maria do Salto'],
 ['BR', '15', 'Santa Maria do Sua\xc3\xa7u\xc3\xad'],
 ['BR', '15', 'Santana da Vargem'],
 ['BR', '15', 'Santana de Cataguases'],
 ['BR', '15', 'Santana de Pirapama'],
 ['BR', '15', 'Santana do Deserto'],
 ['BR', '15', 'Santana do Garamb\xc3\xa9u'],
 ['BR', '15', 'Santana do Jacar\xc3\xa9'],
 ['BR', '15', 'Santana do Manhua\xc3\xa7u'],
 ['BR', '15', 'Santana do Para\xc3\xadso'],
 ['BR', '15', 'Santana do Riacho'],
 ['BR', '15', 'Santana dos Montes'],
 ['BR', '15', 'Santa Rita de Caldas'],
 ['BR', '15', 'Santa Rita de Jacutinga'],
 ['BR', '15', 'Santa Rita de Minas'],
 ['BR', '15', 'Santa Rita de Ibitipoca'],
 ['BR', '15', 'Santa Rita do Itueto'],
 ['BR', '15', 'Santa Rita do Sapuca\xc3\xad'],
 ['BR', '15', 'Santa Rosa da Serra'],
 ['BR', '15', 'Santa Vit\xc3\xb3ria'],
 ['BR', '15', 'Santo Ant\xc3\xb4nio do Amparo'],
 ['BR', '15', 'Santo Ant\xc3\xb4nio do Aventureiro'],
 ['BR', '15', 'Santo Ant\xc3\xb4nio do Grama'],
 ['BR', '15', 'Santo Ant\xc3\xb4nio do Itamb\xc3\xa9'],
 ['BR', '15', 'Santo Ant\xc3\xb4nio do Jacinto'],
 ['BR', '15', 'Santo Ant\xc3\xb4nio do Monte'],
 ['BR', '15', 'Santo Ant\xc3\xb4nio do Retiro'],
 ['BR', '15', 'Santo Ant\xc3\xb4nio do Rio Abaixo'],
 ['BR', '15', 'Santo Hip\xc3\xb3lito'],
 ['BR', '15', 'Santos Dumont'],
 ['BR', '15', 'S\xc3\xa3o Bento Abade'],
 ['BR', '15', 'S\xc3\xa3o Domingos das Dores'],
 ['BR', '15', 'S\xc3\xa3o Domingos do Prata'],
 ['BR', '15', 'S\xc3\xa3o F\xc3\xa9lix de Minas'],
 ['BR', '15', 'S\xc3\xa3o Francisco de Sales'],
 ['BR', '15', 'S\xc3\xa3o Francisco do Gl\xc3\xb3ria'],
 ['BR', '15', 'S\xc3\xa3o Geraldo'],
 ['BR', '15', 'S\xc3\xa3o Geraldo da Piedade'],
 ['BR', '15', 'S\xc3\xa3o Geraldo do Baixio'],
 ['BR', '15', 'S\xc3\xa3o Gon\xc3\xa7alo do Abaet\xc3\xa9'],
 ['BR', '15', 'S\xc3\xa3o Gon\xc3\xa7alo do Par\xc3\xa1'],
 ['BR', '15', 'S\xc3\xa3o Gon\xc3\xa7alo do Rio Abaixo'],
 ['BR', '15', 'S\xc3\xa3o Gon\xc3\xa7alo do Sapuca\xc3\xad'],
 ['BR', '15', 'S\xc3\xa3o Gotardo'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o Batista do Gl\xc3\xb3ria'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o da Lagoa'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o da Mata'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o da Ponte'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o das Miss\xc3\xb5es'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o del Rei'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o do Manhua\xc3\xa7u'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o do Manteninha'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o do Oriente'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o do Pacu\xc3\xad'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o do Para\xc3\xadso'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o Evangelista'],
 ['BR', '15', 'S\xc3\xa3o Jo\xc3\xa3o Nepomuceno'],
 ['BR', '15', 'S\xc3\xa3o Joaquim de Bicas'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 da Barra'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 da Lapa'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 da Safira'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 da Varginha'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 do Alegre'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 do Divino'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 do Goiabal'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 do Jacuri'],
 ['BR', '15', 'S\xc3\xa3o Jos\xc3\xa9 do Mantimento'],
 ['BR', '15', 'S\xc3\xa3o Louren\xc3\xa7o'],
 ['BR', '15', 'S\xc3\xa3o Miguel do Anta'],
 ['BR', '15', 'S\xc3\xa3o Pedro da Uni\xc3\xa3o'],
 ['BR', '15', 'S\xc3\xa3o Pedro dos Ferros'],
 ['BR', '15', 'S\xc3\xa3o Pedro do Sua\xc3\xa7u\xc3\xad'],
 ['BR', '15', 'S\xc3\xa3o Rom\xc3\xa3o'],
 ['BR', '15', 'S\xc3\xa3o Roque de Minas'],
 ['BR', '15', 'S\xc3\xa3o Sebasti\xc3\xa3o da Bela Vista'],
 ['BR', '15', 'S\xc3\xa3o Sebasti\xc3\xa3o da Vargem Alegre'],
 ['BR', '15', 'S\xc3\xa3o Sebasti\xc3\xa3o do Anta'],
 ['BR', '15', 'S\xc3\xa3o Sebasti\xc3\xa3o do Maranh\xc3\xa3o'],
 ['BR', '15', 'S\xc3\xa3o Sebasti\xc3\xa3o do Oeste'],
 ['BR', '15', 'S\xc3\xa3o Sebasti\xc3\xa3o do Para\xc3\xadso'],
 ['BR', '15', 'S\xc3\xa3o Sebasti\xc3\xa3o do Rio Preto'],
 ['BR', '15', 'S\xc3\xa3o Sebasti\xc3\xa3o do Rio Verde'],
 ['BR', '15', 'S\xc3\xa3o Tiago'],
 ['BR', '15', 'S\xc3\xa3o Tom\xc3\xa1s de Aquino'],
 ['BR', '15', 'S\xc3\xa3o Thom\xc3\xa9 das Letras'],
 ['BR', '15', 'S\xc3\xa3o Vicente de Minas'],
 ['BR', '15', 'Sapuca\xc3\xad-Mirim'],
 ['BR', '15', 'Sardo\xc3\xa1'],
 ['BR', '15', 'Sarzedo'],
 ['BR', '15', 'Setubinha'],
 ['BR', '15', 'Sem-Peixe'],
 ['BR', '15', 'Senador Amaral'],
 ['BR', '15', 'Senador Cortes'],
 ['BR', '15', 'Senador Firmino'],
 ['BR', '15', 'Senador Jos\xc3\xa9 Bento'],
 ['BR', '15', 'Senador Modestino Gon\xc3\xa7alves'],
 ['BR', '15', 'Senhora de Oliveira'],
 ['BR', '15', 'Senhora do Porto'],
 ['BR', '15', 'Senhora dos Rem\xc3\xa9dios'],
 ['BR', '15', 'Sericita'],
 ['BR', '15', 'Seritinga'],
 ['BR', '15', 'Serra Azul de Minas'],
 ['BR', '15', 'Serra da Saudade'],
 ['BR', '15', 'Serra dos Aimor\xc3\xa9s'],
 ['BR', '15', 'Serra do Salitre'],
 ['BR', '15', 'Serrania'],
 ['BR', '15', 'Serran\xc3\xb3polis de Minas'],
 ['BR', '15', 'Serranos'],
 ['BR', '15', 'Serro'],
 ['BR', '15', 'Sete Lagoas'],
 ['BR', '15', 'Silveir\xc3\xa2nia'],
 ['BR', '15', 'Silvian\xc3\xb3polis'],
 ['BR', '15', 'Sim\xc3\xa3o Pereira'],
 ['BR', '15', 'Simon\xc3\xa9sia'],
 ['BR', '15', 'Sobr\xc3\xa1lia'],
 ['BR', '15', 'Soledade de Minas'],
 ['BR', '15', 'Tabuleiro'],
 ['BR', '15', 'Taiobeiras'],
 ['BR', '15', 'Taparuba'],
 ['BR', '15', 'Tapira'],
 ['BR', '15', 'Tapira\xc3\xad'],
 ['BR', '15', 'Taquara\xc3\xa7u de Minas'],
 ['BR', '15', 'Tarumirim'],
 ['BR', '15', 'Teixeiras'],
 ['BR', '15', 'Te\xc3\xb3filo Otoni'],
 ['BR', '15', 'Tim\xc3\xb3teo'],
 ['BR', '15', 'Tiradentes'],
 ['BR', '15', 'Tiros'],
 ['BR', '15', 'Tocantins'],
 ['BR', '15', 'Tocos do Moji'],
 ['BR', '15', 'Toledo'],
 ['BR', '15', 'Tombos'],
 ['BR', '15', 'Tr\xc3\xaas Cora\xc3\xa7\xc3\xb5es'],
 ['BR', '15', 'Tr\xc3\xaas Marias'],
 ['BR', '15', 'Tr\xc3\xaas Pontas'],
 ['BR', '15', 'Tumiritinga'],
 ['BR', '15', 'Tupaciguara'],
 ['BR', '15', 'Turmalina'],
 ['BR', '15', 'Turvol\xc3\xa2ndia'],
 ['BR', '15', 'Ub\xc3\xa1'],
 ['BR', '15', 'Uba\xc3\xad'],
 ['BR', '15', 'Ubaporanga'],
 ['BR', '15', 'Uberaba'],
 ['BR', '15', 'Uberl\xc3\xa2ndia'],
 ['BR', '15', 'Umburatiba'],
 ['BR', '15', 'Una\xc3\xad'],
 ['BR', '15', 'Uni\xc3\xa3o de Minas'],
 ['BR', '15', 'Uruana de Minas'],
 ['BR', '15', 'Uruc\xc3\xa2nia'],
 ['BR', '15', 'Urucuia'],
 ['BR', '15', 'Vargem Alegre'],
 ['BR', '15', 'Vargem Bonita'],
 ['BR', '15', 'Vargem Grande do Rio Pardo'],
 ['BR', '15', 'Varginha'],
 ['BR', '15', 'Varj\xc3\xa3o de MInas'],
 ['BR', '15', 'V\xc3\xa1rzea da Palma'],
 ['BR', '15', 'Varzel\xc3\xa2ndia'],
 ['BR', '15', 'Vazante'],
 ['BR', '15', 'Verdel\xc3\xa2ndia'],
 ['BR', '15', 'Veredinha'],
 ['BR', '15', 'Ver\xc3\xadssimo'],
 ['BR', '15', 'Vermelho Novo'],
 ['BR', '15', 'Vespasiano'],
 ['BR', '15', 'Vi\xc3\xa7osa'],
 ['BR', '15', 'Vieiras'],
 ['BR', '15', 'Mathias Lobato'],
 ['BR', '15', 'Virgem da Lapa'],
 ['BR', '15', 'Virg\xc3\xadnia'],
 ['BR', '15', 'Virgin\xc3\xb3polis'],
 ['BR', '15', 'Virgol\xc3\xa2ndia'],
 ['BR', '15', 'Visconde do Rio Branco'],
 ['BR', '15', 'Volta Grande'],
 ['BR', '15', 'Wenceslau Braz'],
 ['BR', '08', 'Afonso Cl\xc3\xa1udio'],
 ['BR', '08', '\xc3\x81guia Branca'],
 ['BR', '08', '\xc3\x81gua Doce do Norte'],
 ['BR', '08', 'Alfredo Chaves'],
 ['BR', '08', 'Alto Rio Novo'],
 ['BR', '08', 'Anchieta'],
 ['BR', '08', 'Apiac\xc3\xa1'],
 ['BR', '08', 'Aracruz'],
 ['BR', '08', 'Atilio Vivacqua'],
 ['BR', '08', 'Baixo Guandu'],
 ['BR', '08', 'Barra de S\xc3\xa3o Francisco'],
 ['BR', '08', 'Boa Esperan\xc3\xa7a'],
 ['BR', '08', 'Bom Jesus do Norte'],
 ['BR', '08', 'Brejetuba'],
 ['BR', '08', 'Cachoeiro de Itapemirim'],
 ['BR', '08', 'Cariacica'],
 ['BR', '08', 'Castelo'],
 ['BR', '08', 'Concei\xc3\xa7\xc3\xa3o da Barra'],
 ['BR', '08', 'Concei\xc3\xa7\xc3\xa3o do Castelo'],
 ['BR', '08', 'Divino de S\xc3\xa3o Louren\xc3\xa7o'],
 ['BR', '08', 'Domingos Martins'],
 ['BR', '08', 'Dores do Rio Preto'],
 ['BR', '08', 'Ecoporanga'],
 ['BR', '08', 'Fund\xc3\xa3o'],
 ['BR', '08', 'Gua\xc3\xa7u\xc3\xad'],
 ['BR', '08', 'Guarapari'],
 ['BR', '08', 'Ibatiba'],
 ['BR', '08', 'Ibira\xc3\xa7u'],
 ['BR', '08', 'Ibitirama'],
 ['BR', '08', 'Iconha'],
 ['BR', '08', 'Irupi'],
 ['BR', '08', 'Itagua\xc3\xa7u'],
 ['BR', '08', 'Itapemirim'],
 ['BR', '08', 'Itarana'],
 ['BR', '08', 'I\xc3\xbana'],
 ['BR', '08', 'Jaguar\xc3\xa9'],
 ['BR', '08', 'Jer\xc3\xb4nimo Monteiro'],
 ['BR', '08', 'Jo\xc3\xa3o Neiva'],
 ['BR', '08', 'Laranja da Terra'],
 ['BR', '08', 'Linhares'],
 ['BR', '08', 'Manten\xc3\xb3polis'],
 ['BR', '08', 'Marata\xc3\xadzes'],
 ['BR', '08', 'Marechal Floriano'],
 ['BR', '08', 'Maril\xc3\xa2ndia'],
 ['BR', '08', 'Mimoso do Sul'],
 ['BR', '08', 'Montanha'],
 ['BR', '08', 'Mucurici'],
 ['BR', '08', 'Muniz Freire'],
 ['BR', '08', 'Muqui'],
 ['BR', '08', 'Nova Ven\xc3\xa9cia'],
 ['BR', '08', 'Pancas'],
 ['BR', '08', 'Pedro Can\xc3\xa1rio'],
 ['BR', '08', 'Pinheiros'],
 ['BR', '08', 'Pi\xc3\xbama'],
 ['BR', '08', 'Ponto Belo'],
 ['BR', '08', 'Presidente Kennedy'],
 ['BR', '08', 'Rio Bananal'],
 ['BR', '08', 'Rio Novo do Sul'],
 ['BR', '08', 'Santa Teresa'],
 ['BR', '08', 'S\xc3\xa3o Domingos do Norte'],
 ['BR', '08', 'S\xc3\xa3o Gabriel da Palha'],
 ['BR', '08', 'S\xc3\xa3o Mateus'],
 ['BR', '08', 'S\xc3\xa3o Roque do Cana\xc3\xa3'],
 ['BR', '08', 'Serra'],
 ['BR', '08', 'Sooretama'],
 ['BR', '08', 'Vargem Alta'],
 ['BR', '08', 'Venda Nova do Imigrante'],
 ['BR', '08', 'Viana'],
 ['BR', '08', 'Vila Pav\xc3\xa3o'],
 ['BR', '08', 'Vila Val\xc3\xa9rio'],
 ['BR', '08', 'Vila Velha'],
 ['BR', '08', 'Vit\xc3\xb3ria'],
 ['BR', '21', 'Angra dos Reis'],
 ['BR', '21', 'Aperib\xc3\xa9'],
 ['BR', '21', 'Araruama'],
 ['BR', '21', 'Arraial do Cabo'],
 ['BR', '21', 'Barra do Pira\xc3\xad'],
 ['BR', '21', 'Barra Mansa'],
 ['BR', '21', 'Belford Roxo'],
 ['BR', '21', 'Bom Jardim'],
 ['BR', '21', 'Bom Jesus do Itabapoana'],
 ['BR', '21', 'Cabo Frio'],
 ['BR', '21', 'Cachoeiras de Macacu'],
 ['BR', '21', 'Cambuci'],
 ['BR', '21', 'Carapebus'],
 ['BR', '21', 'Comendador Levy Gasparian'],
 ['BR', '21', 'Campos dos Goytacazes'],
 ['BR', '21', 'Cardoso Moreira'],
 ['BR', '21', 'Casimiro de Abreu'],
 ['BR', '21', 'Cordeiro'],
 ['BR', '21', 'Duque de Caxias'],
 ['BR', '21', 'Engenheiro Paulo de Frontin'],
 ['BR', '21', 'Guapimirim'],
 ['BR', '21', 'Iguaba Grande'],
 ['BR', '21', 'Itabora\xc3\xad'],
 ['BR', '21', 'Itagua\xc3\xad'],
 ['BR', '21', 'Italva'],
 ['BR', '21', 'Itaocara'],
 ['BR', '21', 'Itaperuna'],
 ['BR', '21', 'Itatiaia'],
 ['BR', '21', 'Japeri'],
 ['BR', '21', 'Laje do Muria\xc3\xa9'],
 ['BR', '21', 'Maca\xc3\xa9'],
 ['BR', '21', 'Macuco'],
 ['BR', '21', 'Mag\xc3\xa9'],
 ['BR', '21', 'Mangaratiba'],
 ['BR', '21', 'Maric\xc3\xa1'],
 ['BR', '21', 'Mendes'],
 ['BR', '21', 'Miguel Pereira'],
 ['BR', '21', 'Miracema'],
 ['BR', '21', 'Natividade'],
 ['BR', '21', 'Nil\xc3\xb3polis'],
 ['BR', '21', 'Niter\xc3\xb3i'],
 ['BR', '21', 'Nova Friburgo'],
 ['BR', '21', 'Paracambi'],
 ['BR', '21', 'Para\xc3\xadba do Sul'],
 ['BR', '21', 'Parati'],
 ['BR', '21', 'Paty do Alferes'],
 ['BR', '21', 'Petr\xc3\xb3polis'],
 ['BR', '21', 'Pinheiral'],
 ['BR', '21', 'Pira\xc3\xad'],
 ['BR', '21', 'Porci\xc3\xbancula'],
 ['BR', '21', 'Porto Real'],
 ['BR', '21', 'Quatis'],
 ['BR', '21', 'Queimados'],
 ['BR', '21', 'Quissam\xc3\xa3'],
 ['BR', '21', 'Resende'],
 ['BR', '21', 'Rio Bonito'],
 ['BR', '21', 'Rio Claro'],
 ['BR', '21', 'Rio das Flores'],
 ['BR', '21', 'Rio das Ostras'],
 ['BR', '21', 'Rio de Janeiro'],
 ['BR', '21', 'Santa Maria Madalena'],
 ['BR', '21', 'Santo Ant\xc3\xb4nio de P\xc3\xa1dua'],
 ['BR', '21', 'S\xc3\xa3o Francisco de Itabapoana'],
 ['BR', '21', 'S\xc3\xa3o Fid\xc3\xa9lis'],
 ['BR', '21', 'S\xc3\xa3o Gon\xc3\xa7alo'],
 ['BR', '21', 'S\xc3\xa3o Jo\xc3\xa3o da Barra'],
 ['BR', '21', 'S\xc3\xa3o Jo\xc3\xa3o de Meriti'],
 ['BR', '21', 'S\xc3\xa3o Jos\xc3\xa9 de Ub\xc3\xa1'],
 ['BR', '21', 'S\xc3\xa3o Jos\xc3\xa9 do Vale do Rio Preto'],
 ['BR', '21', 'S\xc3\xa3o Pedro da Aldeia'],
 ['BR', '21', 'S\xc3\xa3o Sebasti\xc3\xa3o do Alto'],
 ['BR', '21', 'Sapucaia'],
 ['BR', '21', 'Saquarema'],
 ['BR', '21', 'Serop\xc3\xa9dica'],
 ['BR', '21', 'Silva Jardim'],
 ['BR', '21', 'Sumidouro'],
 ['BR', '21', 'Tangu\xc3\xa1'],
 ['BR', '21', 'Teres\xc3\xb3polis'],
 ['BR', '21', 'Trajano de Morais'],
 ['BR', '21', 'Tr\xc3\xaas Rios'],
 ['BR', '21', 'Valen\xc3\xa7a'],
 ['BR', '21', 'Varre-Sai'],
 ['BR', '21', 'Vassouras'],
 ['BR', '21', 'Volta Redonda'],
 ['BR', '27', 'Adolfo'],
 ['BR', '27', '\xc3\x81guas de Lind\xc3\xb3ia'],
 ['BR', '27', '\xc3\x81guas de Santa B\xc3\xa1rbara'],
 ['BR', '27', 'Alambari'],
 ['BR', '27', 'Altair'],
 ['BR', '27', 'Alum\xc3\xadnio'],
 ['BR', '27', 'Alvinl\xc3\xa2ndia'],
 ['BR', '27', 'Am\xc3\xa9rico Brasiliense'],
 ['BR', '27', 'Andradina'],
 ['BR', '27', 'Angatuba'],
 ['BR', '27', 'Anhembi'],
 ['BR', '27', 'Aparecida'],
 ['BR', '27', "Aparecida d'Oeste"],
 ['BR', '27', 'Apia\xc3\xad'],
 ['BR', '27', 'Ara\xc3\xa7ariguama'],
 ['BR', '27', 'Ara\xc3\xa7atuba'],
 ['BR', '27', 'Ara\xc3\xa7oiaba da Serra'],
 ['BR', '27', 'Aramina'],
 ['BR', '27', 'Arandu'],
 ['BR', '27', 'Arape\xc3\xad'],
 ['BR', '27', 'Araraquara'],
 ['BR', '27', 'Araras'],
 ['BR', '27', 'Arco-\xc3\x8dris'],
 ['BR', '27', 'Areias'],
 ['BR', '27', 'Arei\xc3\xb3polis'],
 ['BR', '27', 'Ariranha'],
 ['BR', '27', 'Artur Nogueira'],
 ['BR', '27', 'Aruj\xc3\xa1'],
 ['BR', '27', 'Asp\xc3\xa1sia'],
 ['BR', '27', 'Atibaia'],
 ['BR', '27', 'Auriflama'],
 ['BR', '27', 'Ava\xc3\xad'],
 ['BR', '27', 'Avanhandava'],
 ['BR', '27', 'Avar\xc3\xa9'],
 ['BR', '27', 'Bady Bassitt'],
 ['BR', '27', 'Balbinos'],
 ['BR', '27', 'B\xc3\xa1lsamo'],
 ['BR', '27', 'Bananal'],
 ['BR', '27', 'Bar\xc3\xa3o de Antonina'],
 ['BR', '27', 'Bariri'],
 ['BR', '27', 'Barra Bonita'],
 ['BR', '27', 'Barra do Chap\xc3\xa9u'],
 ['BR', '27', 'Barra do Turvo'],
 ['BR', '27', 'Barretos'],
 ['BR', '27', 'Barrinha'],
 ['BR', '27', 'Barueri'],
 ['BR', '27', 'Bastos'],
 ['BR', '27', 'Batatais'],
 ['BR', '27', 'Bauru'],
 ['BR', '27', 'Bebedouro'],
 ['BR', '27', 'Bento de Abreu'],
 ['BR', '27', 'Bernardino de Campos'],
 ['BR', '27', 'Bertioga'],
 ['BR', '27', 'Bilac'],
 ['BR', '27', 'Birigui'],
 ['BR', '27', 'Biritiba-Mirim'],
 ['BR', '27', 'Boa Esperan\xc3\xa7a do Sul'],
 ['BR', '27', 'Bocaina'],
 ['BR', '27', 'Bofete'],
 ['BR', '27', 'Boituva'],
 ['BR', '27', 'Bom Jesus dos Perd\xc3\xb5es'],
 ['BR', '27', 'Bom Sucesso de Itarar\xc3\xa9'],
 ['BR', '27', 'Bor\xc3\xa1'],
 ['BR', '27', 'Borac\xc3\xa9ia'],
 ['BR', '27', 'Borborema'],
 ['BR', '27', 'Borebi'],
 ['BR', '27', 'Botucatu'],
 ['BR', '27', 'Bragan\xc3\xa7a Paulista'],
 ['BR', '27', 'Bra\xc3\xbana'],
 ['BR', '27', 'Brejo Alegre'],
 ['BR', '27', 'Brodowski'],
 ['BR', '27', 'Brotas'],
 ['BR', '27', 'Buri'],
 ['BR', '27', 'Buritama'],
 ['BR', '27', 'Buritizal'],
 ['BR', '27', 'Cabr\xc3\xa1lia Paulista'],
 ['BR', '27', 'Cabre\xc3\xbava'],
 ['BR', '27', 'Ca\xc3\xa7apava'],
 ['BR', '27', 'Cachoeira Paulista'],
 ['BR', '27', 'Caconde'],
 ['BR', '27', 'Cafel\xc3\xa2ndia'],
 ['BR', '27', 'Caiabu'],
 ['BR', '27', 'Caieiras'],
 ['BR', '27', 'Caiu\xc3\xa1'],
 ['BR', '27', 'Cajamar'],
 ['BR', '27', 'Cajati'],
 ['BR', '27', 'Cajobi'],
 ['BR', '27', 'Cajuru'],
 ['BR', '27', 'Campina do Monte Alegre'],
 ['BR', '27', 'Campos do Jord\xc3\xa3o'],
 ['BR', '27', 'Campos Novos Paulista'],
 ['BR', '27', 'Canan\xc3\xa9ia'],
 ['BR', '27', 'Canas'],
 ['BR', '27', 'C\xc3\xa2ndido Mota'],
 ['BR', '27', 'C\xc3\xa2ndido Rodrigues'],
 ['BR', '27', 'Canitar'],
 ['BR', '27', 'Cap\xc3\xa3o Bonito'],
 ['BR', '27', 'Capela do Alto'],
 ['BR', '27', 'Capivari'],
 ['BR', '27', 'Caraguatatuba'],
 ['BR', '27', 'Carapicu\xc3\xadba'],
 ['BR', '27', 'Cardoso'],
 ['BR', '27', 'Casa Branca'],
 ['BR', '27', 'C\xc3\xa1ssia dos Coqueiros'],
 ['BR', '27', 'Castilho'],
 ['BR', '27', 'Catanduva'],
 ['BR', '27', 'Catigu\xc3\xa1'],
 ['BR', '27', 'Cedral'],
 ['BR', '27', 'Cerqueira C\xc3\xa9sar'],
 ['BR', '27', 'Cerquilho'],
 ['BR', '27', 'Ces\xc3\xa1rio Lange'],
 ['BR', '27', 'Clementina'],
 ['BR', '27', 'Colina'],
 ['BR', '27', 'Col\xc3\xb4mbia'],
 ['BR', '27', 'Conchal'],
 ['BR', '27', 'Conchas'],
 ['BR', '27', 'Cordeir\xc3\xb3polis'],
 ['BR', '27', 'Coronel Macedo'],
 ['BR', '27', 'Cosm\xc3\xb3polis'],
 ['BR', '27', 'Cotia'],
 ['BR', '27', 'Cravinhos'],
 ['BR', '27', 'Cristais Paulista'],
 ['BR', '27', 'Cruz\xc3\xa1lia'],
 ['BR', '27', 'Cruzeiro'],
 ['BR', '27', 'Cubat\xc3\xa3o'],
 ['BR', '27', 'Cunha'],
 ['BR', '27', 'Descalvado'],
 ['BR', '27', 'Diadema'],
 ['BR', '27', 'Dirce Reis'],
 ['BR', '27', 'Dobrada'],
 ['BR', '27', 'Dois C\xc3\xb3rregos'],
 ['BR', '27', 'Dolcin\xc3\xb3polis'],
 ['BR', '27', 'Dourado'],
 ['BR', '27', 'Dracena'],
 ['BR', '27', 'Duartina'],
 ['BR', '27', 'Dumont'],
 ['BR', '27', 'Echapor\xc3\xa3'],
 ['BR', '27', 'Eldorado'],
 ['BR', '27', 'Elias Fausto'],
 ['BR', '27', 'Elisi\xc3\xa1rio'],
 ['BR', '27', 'Emba\xc3\xbaba'],
 ['BR', '27', 'Embu'],
 ['BR', '27', 'Embu-Gua\xc3\xa7u'],
 ['BR', '27', 'Emilian\xc3\xb3polis'],
 ['BR', '27', 'Engenheiro Coelho'],
 ['BR', '27', 'Esp\xc3\xadrito Santo do Pinhal'],
 ['BR', '27', 'Esp\xc3\xadrito Santo do Turvo'],
 ['BR', '27', "Estrela d'Oeste"],
 ['BR', '27', 'Estrela do Norte'],
 ['BR', '27', 'Euclides da Cunha Paulista'],
 ['BR', '27', 'Fartura'],
 ['BR', '27', 'Fernand\xc3\xb3polis'],
 ['BR', '27', 'Fernando Prestes'],
 ['BR', '27', 'Fern\xc3\xa3o'],
 ['BR', '27', 'Ferraz de Vasconcelos'],
 ['BR', '27', 'Flora Rica'],
 ['BR', '27', 'Floreal'],
 ['BR', '27', 'Fl\xc3\xb3rida Paulista'],
 ['BR', '27', 'Flor\xc3\xadnia'],
 ['BR', '27', 'Francisco Morato'],
 ['BR', '27', 'Franco da Rocha'],
 ['BR', '27', 'Gabriel Monteiro'],
 ['BR', '27', 'G\xc3\xa1lia'],
 ['BR', '27', 'Gast\xc3\xa3o Vidigal'],
 ['BR', '27', 'Gavi\xc3\xa3o Peixoto'],
 ['BR', '27', 'General Salgado'],
 ['BR', '27', 'Getulina'],
 ['BR', '27', 'Glic\xc3\xa9rio'],
 ['BR', '27', 'Guai\xc3\xa7ara'],
 ['BR', '27', 'Guaimb\xc3\xaa'],
 ['BR', '27', 'Gua\xc3\xadra'],
 ['BR', '27', 'Guapia\xc3\xa7u'],
 ['BR', '27', 'Guapiara'],
 ['BR', '27', 'Guar\xc3\xa1'],
 ['BR', '27', 'Guaraci'],
 ['BR', '27', "Guarani d'Oeste"],
 ['BR', '27', 'Guarant\xc3\xa3'],
 ['BR', '27', 'Guararapes'],
 ['BR', '27', 'Guararema'],
 ['BR', '27', 'Guaratinguet\xc3\xa1'],
 ['BR', '27', 'Guare\xc3\xad'],
 ['BR', '27', 'Guariba'],
 ['BR', '27', 'Guaruj\xc3\xa1'],
 ['BR', '27', 'Guarulhos'],
 ['BR', '27', 'Guatapar\xc3\xa1'],
 ['BR', '27', 'Guzol\xc3\xa2ndia'],
 ['BR', '27', 'Hercul\xc3\xa2ndia'],
 ['BR', '27', 'Holambra'],
 ['BR', '27', 'Hortol\xc3\xa2ndia'],
 ['BR', '27', 'Iacri'],
 ['BR', '27', 'Iaras'],
 ['BR', '27', 'Ibat\xc3\xa9'],
 ['BR', '27', 'Ibir\xc3\xa1'],
 ['BR', '27', 'Ibirarema'],
 ['BR', '27', 'Ibitinga'],
 ['BR', '27', 'Ibi\xc3\xbana'],
 ['BR', '27', 'Ic\xc3\xa9m'],
 ['BR', '27', 'Iep\xc3\xaa'],
 ['BR', '27', 'Igara\xc3\xa7u do Tiet\xc3\xaa'],
 ['BR', '27', 'Igarat\xc3\xa1'],
 ['BR', '27', 'Iguape'],
 ['BR', '27', 'Ilhabela'],
 ['BR', '27', 'Ilha Comprida'],
 ['BR', '27', 'Ilha Solteira'],
 ['BR', '27', 'Indaiatuba'],
 ['BR', '27', 'Indiana'],
 ['BR', '27', 'Indiapor\xc3\xa3'],
 ['BR', '27', 'In\xc3\xbabia Paulista'],
 ['BR', '27', 'Ipaussu'],
 ['BR', '27', 'Iper\xc3\xb3'],
 ['BR', '27', 'Ipe\xc3\xbana'],
 ['BR', '27', 'Ipigu\xc3\xa1'],
 ['BR', '27', 'Ipu\xc3\xa3'],
 ['BR', '27', 'Iracem\xc3\xa1polis'],
 ['BR', '27', 'Irapu\xc3\xa3'],
 ['BR', '27', 'Irapuru'],
 ['BR', '27', 'Itaber\xc3\xa1'],
 ['BR', '27', 'Ita\xc3\xad'],
 ['BR', '27', 'Itajobi'],
 ['BR', '27', 'Itaju'],
 ['BR', '27', 'Itanha\xc3\xa9m'],
 ['BR', '27', 'Ita\xc3\xb3ca'],
 ['BR', '27', 'Itapecerica da Serra'],
 ['BR', '27', 'Itapetininga'],
 ['BR', '27', 'Itapeva'],
 ['BR', '27', 'Itapevi'],
 ['BR', '27', 'Itapirapu\xc3\xa3 Paulista'],
 ['BR', '27', 'It\xc3\xa1polis'],
 ['BR', '27', 'Itaporanga'],
 ['BR', '27', 'Itapu\xc3\xad'],
 ['BR', '27', 'Itapura'],
 ['BR', '27', 'Itaquaquecetuba'],
 ['BR', '27', 'Itarar\xc3\xa9'],
 ['BR', '27', 'Itariri'],
 ['BR', '27', 'Itatiba'],
 ['BR', '27', 'Itatinga'],
 ['BR', '27', 'Itirapina'],
 ['BR', '27', 'Itobi'],
 ['BR', '27', 'Itu'],
 ['BR', '27', 'Itupeva'],
 ['BR', '27', 'Ituverava'],
 ['BR', '27', 'Jaborandi'],
 ['BR', '27', 'Jaboticabal'],
 ['BR', '27', 'Jacare\xc3\xad'],
 ['BR', '27', 'Jaci'],
 ['BR', '27', 'Jacupiranga'],
 ['BR', '27', 'Jaguari\xc3\xbana'],
 ['BR', '27', 'Jales'],
 ['BR', '27', 'Jambeiro'],
 ['BR', '27', 'Jandira'],
 ['BR', '27', 'Ja\xc3\xba'],
 ['BR', '27', 'Jeriquara'],
 ['BR', '27', 'Joan\xc3\xb3polis'],
 ['BR', '27', 'Jo\xc3\xa3o Ramalho'],
 ['BR', '27', 'J\xc3\xbalio Mesquita'],
 ['BR', '27', 'Jumirim'],
 ['BR', '27', 'Jundia\xc3\xad'],
 ['BR', '27', 'Junqueir\xc3\xb3polis'],
 ['BR', '27', 'Juqui\xc3\xa1'],
 ['BR', '27', 'Juquitiba'],
 ['BR', '27', 'Lagoinha'],
 ['BR', '27', 'Laranjal Paulista'],
 ['BR', '27', 'Lav\xc3\xadnia'],
 ['BR', '27', 'Lavrinhas'],
 ['BR', '27', 'Leme'],
 ['BR', '27', 'Len\xc3\xa7\xc3\xb3is Paulista'],
 ['BR', '27', 'Limeira'],
 ['BR', '27', 'Lins'],
 ['BR', '27', 'Lorena'],
 ['BR', '27', 'Lourdes'],
 ['BR', '27', 'Louveira'],
 ['BR', '27', 'Lucian\xc3\xb3polis'],
 ['BR', '27', 'Luizi\xc3\xa2nia'],
 ['BR', '27', 'Macatuba'],
 ['BR', '27', 'Macaubal'],
 ['BR', '27', 'Maced\xc3\xb4nia'],
 ['BR', '27', 'Magda'],
 ['BR', '27', 'Mairinque'],
 ['BR', '27', 'Mairipor\xc3\xa3'],
 ['BR', '27', 'Manduri'],
 ['BR', '27', 'Marab\xc3\xa1 Paulista'],
 ['BR', '27', 'Maraca\xc3\xad'],
 ['BR', '27', 'Marapoama'],
 ['BR', '27', 'Mari\xc3\xa1polis'],
 ['BR', '27', 'Mar\xc3\xadlia'],
 ['BR', '27', 'Marin\xc3\xb3polis'],
 ['BR', '27', 'Martin\xc3\xb3polis'],
 ['BR', '27', 'Mat\xc3\xa3o'],
 ['BR', '27', 'Mau\xc3\xa1'],
 ['BR', '27', 'Mendon\xc3\xa7a'],
 ['BR', '27', 'Meridiano'],
 ['BR', '27', 'Mes\xc3\xb3polis'],
 ['BR', '27', 'Miguel\xc3\xb3polis'],
 ['BR', '27', 'Mineiros do Tiet\xc3\xaa'],
 ['BR', '27', 'Miracatu'],
 ['BR', '27', 'Mira Estrela'],
 ['BR', '27', 'Mirand\xc3\xb3polis'],
 ['BR', '27', 'Mirante do Paranapanema'],
 ['BR', '27', 'Mirassol'],
 ['BR', '27', 'Mirassol\xc3\xa2ndia'],
 ['BR', '27', 'Mococa'],
 ['BR', '27', 'Mogi das Cruzes'],
 ['BR', '27', 'Mogi-Mirim'],
 ['BR', '27', 'Mombuca'],
 ['BR', '27', 'Mon\xc3\xa7\xc3\xb5es'],
 ['BR', '27', 'Mongagu\xc3\xa1'],
 ['BR', '27', 'Monte Alegre do Sul'],
 ['BR', '27', 'Monte Alto'],
 ['BR', '27', 'Monte Apraz\xc3\xadvel'],
 ['BR', '27', 'Monte Azul Paulista'],
 ['BR', '27', 'Monte Castelo'],
 ['BR', '27', 'Monteiro Lobato'],
 ['BR', '27', 'Monte Mor'],
 ['BR', '27', 'Morro Agudo'],
 ['BR', '27', 'Morungaba'],
 ['BR', '27', 'Motuca'],
 ['BR', '27', 'Murutinga do Sul'],
 ['BR', '27', 'Nantes'],
 ['BR', '27', 'Narandiba'],
 ['BR', '27', 'Natividade da Serra'],
 ['BR', '27', 'Nazar\xc3\xa9 Paulista'],
 ['BR', '27', 'Neves Paulista'],
 ['BR', '27', 'Nhandeara'],
 ['BR', '27', 'Nipo\xc3\xa3'],
 ['BR', '27', 'Nova Alian\xc3\xa7a'],
 ['BR', '27', 'Nova Campina'],
 ['BR', '27', 'Nova Europa'],
 ['BR', '27', 'Nova Granada'],
 ['BR', '27', 'Nova Guataporanga'],
 ['BR', '27', 'Nova Independ\xc3\xaancia'],
 ['BR', '27', 'Novais'],
 ['BR', '27', 'Nova Luzit\xc3\xa2nia'],
 ['BR', '27', 'Novo Horizonte'],
 ['BR', '27', 'Nuporanga'],
 ['BR', '27', 'Ocau\xc3\xa7u'],
 ['BR', '27', '\xc3\x93leo'],
 ['BR', '27', 'Ol\xc3\xadmpia'],
 ['BR', '27', 'Onda Verde'],
 ['BR', '27', 'Oriente'],
 ['BR', '27', 'Orindi\xc3\xbava'],
 ['BR', '27', 'Orl\xc3\xa2ndia'],
 ['BR', '27', 'Osasco'],
 ['BR', '27', 'Oscar Bressane'],
 ['BR', '27', 'Osvaldo Cruz'],
 ['BR', '27', 'Ourinhos'],
 ['BR', '27', 'Ouroeste'],
 ['BR', '27', 'Ouro Verde'],
 ['BR', '27', 'Pacaembu'],
 ['BR', '27', 'Palestina'],
 ['BR', '27', 'Palmares Paulista'],
 ['BR', '27', "Palmeira d'Oeste"],
 ['BR', '27', 'Palmital'],
 ['BR', '27', 'Panorama'],
 ['BR', '27', 'Paragua\xc3\xa7u Paulista'],
 ['BR', '27', 'Paraibuna'],
 ['BR', '27', 'Para\xc3\xadso'],
 ['BR', '27', 'Paranapanema'],
 ['BR', '27', 'Paranapu\xc3\xa3'],
 ['BR', '27', 'Parapu\xc3\xa3'],
 ['BR', '27', 'Pardinho'],
 ['BR', '27', 'Pariquera-A\xc3\xa7u'],
 ['BR', '27', 'Parisi'],
 ['BR', '27', 'Paulic\xc3\xa9ia'],
 ['BR', '27', 'Paul\xc3\xadnia'],
 ['BR', '27', 'Paulo de Faria'],
 ['BR', '27', 'Pederneiras'],
 ['BR', '27', 'Pedra Bela'],
 ['BR', '27', 'Pedran\xc3\xb3polis'],
 ['BR', '27', 'Pedregulho'],
 ['BR', '27', 'Pedrinhas Paulista'],
 ['BR', '27', 'Pedro de Toledo'],
 ['BR', '27', 'Pereira Barreto'],
 ['BR', '27', 'Pereiras'],
 ['BR', '27', 'Peru\xc3\xadbe'],
 ['BR', '27', 'Piacatu'],
 ['BR', '27', 'Piedade'],
 ['BR', '27', 'Pilar do Sul'],
 ['BR', '27', 'Pindamonhangaba'],
 ['BR', '27', 'Pindorama'],
 ['BR', '27', 'Pinhalzinho'],
 ['BR', '27', 'Piquerobi'],
 ['BR', '27', 'Piquete'],
 ['BR', '27', 'Piracaia'],
 ['BR', '27', 'Piraju'],
 ['BR', '27', 'Piraju\xc3\xad'],
 ['BR', '27', 'Pirangi'],
 ['BR', '27', 'Pirapora do Bom Jesus'],
 ['BR', '27', 'Pirassununga'],
 ['BR', '27', 'Pitangueiras'],
 ['BR', '27', 'Planalto'],
 ['BR', '27', 'Platina'],
 ['BR', '27', 'Po\xc3\xa1'],
 ['BR', '27', 'Poloni'],
 ['BR', '27', 'Pomp\xc3\xa9ia'],
 ['BR', '27', 'Ponga\xc3\xad'],
 ['BR', '27', 'Pontal'],
 ['BR', '27', 'Pontalinda'],
 ['BR', '27', 'Populina'],
 ['BR', '27', 'Porangaba'],
 ['BR', '27', 'Porto Feliz'],
 ['BR', '27', 'Porto Ferreira'],
 ['BR', '27', 'Potim'],
 ['BR', '27', 'Potirendaba'],
 ['BR', '27', 'Pracinha'],
 ['BR', '27', 'Prad\xc3\xb3polis'],
 ['BR', '27', 'Prat\xc3\xa2nia'],
 ['BR', '27', 'Presidente Alves'],
 ['BR', '27', 'Presidente Epit\xc3\xa1cio'],
 ['BR', '27', 'Presidente Venceslau'],
 ['BR', '27', 'Promiss\xc3\xa3o'],
 ['BR', '27', 'Quadra'],
 ['BR', '27', 'Quat\xc3\xa1'],
 ['BR', '27', 'Queiroz'],
 ['BR', '27', 'Queluz'],
 ['BR', '27', 'Quintana'],
 ['BR', '27', 'Rafard'],
 ['BR', '27', 'Rancharia'],
 ['BR', '27', 'Reden\xc3\xa7\xc3\xa3o da Serra'],
 ['BR', '27', 'Regente Feij\xc3\xb3'],
 ['BR', '27', 'Regin\xc3\xb3polis'],
 ['BR', '27', 'Registro'],
 ['BR', '27', 'Restinga'],
 ['BR', '27', 'Ribeira'],
 ['BR', '27', 'Ribeir\xc3\xa3o Bonito'],
 ['BR', '27', 'Ribeir\xc3\xa3o Branco'],
 ['BR', '27', 'Ribeir\xc3\xa3o Corrente'],
 ['BR', '27', 'Ribeir\xc3\xa3o do Sul'],
 ['BR', '27', 'Ribeir\xc3\xa3o dos \xc3\x8dndios'],
 ['BR', '27', 'Ribeir\xc3\xa3o Grande'],
 ['BR', '27', 'Ribeir\xc3\xa3o Pires'],
 ['BR', '27', 'Ribeir\xc3\xa3o Preto'],
 ['BR', '27', 'Riversul'],
 ['BR', '27', 'Rifaina'],
 ['BR', '27', 'Rinc\xc3\xa3o'],
 ['BR', '27', 'Rin\xc3\xb3polis'],
 ['BR', '27', 'Rio Claro'],
 ['BR', '27', 'Rio das Pedras'],
 ['BR', '27', 'Rio Grande da Serra'],
 ['BR', '27', 'Rosana'],
 ['BR', '27', 'Roseira'],
 ['BR', '27', 'Rubi\xc3\xa1cea'],
 ['BR', '27', 'Rubin\xc3\xa9ia'],
 ['BR', '27', 'Sabino'],
 ['BR', '27', 'Sagres'],
 ['BR', '27', 'Sales Oliveira'],
 ['BR', '27', 'Sales\xc3\xb3polis'],
 ['BR', '27', 'Salmour\xc3\xa3o'],
 ['BR', '27', 'Salto'],
 ['BR', '27', 'Salto de Pirapora'],
 ['BR', '27', 'Salto Grande'],
 ['BR', '27', 'Sandovalina'],
 ['BR', '27', 'Santa Ad\xc3\xa9lia'],
 ['BR', '27', 'Santa Albertina'],
 ['BR', '27', "Santa B\xc3\xa1rbara d'Oeste"],
 ['BR', '27', 'Santa Branca'],
 ['BR', '27', "Santa Clara d'Oeste"],
 ['BR', '27', 'Santa Cruz da Esperan\xc3\xa7a'],
 ['BR', '27', 'Santa Cruz das Palmeiras'],
 ['BR', '27', 'Santa Cruz do Rio Pardo'],
 ['BR', '27', 'Santa Ernestina'],
 ['BR', '27', 'Santa F\xc3\xa9 do Sul'],
 ['BR', '27', 'Santa Gertrudes'],
 ['BR', '27', 'Santa Isabel'],
 ['BR', '27', 'Santa L\xc3\xbacia'],
 ['BR', '27', 'Santa Maria da Serra'],
 ['BR', '27', 'Santa Mercedes'],
 ['BR', '27', 'Santana da Ponte Pensa'],
 ['BR', '27', 'Santana de Parna\xc3\xadba'],
 ['BR', '27', "Santa Rita d'Oeste"],
 ['BR', '27', 'Santa Rita do Passa Quatro'],
 ['BR', '27', 'Santa Rosa de Viterbo'],
 ['BR', '27', 'Santa Salete'],
 ['BR', '27', 'Santo Anast\xc3\xa1cio'],
 ['BR', '27', 'Santo Andr\xc3\xa9'],
 ['BR', '27', 'Santo Ant\xc3\xb4nio da Alegria'],
 ['BR', '27', 'Santo Ant\xc3\xb4nio de Posse'],
 ['BR', '27', 'Santo Ant\xc3\xb4nio do Aracangu\xc3\xa1'],
 ['BR', '27', 'Santo Ant\xc3\xb4nio do Jardim'],
 ['BR', '27', 'Santo Ant\xc3\xb4nio do Pinhal'],
 ['BR', '27', 'Santo Expedito'],
 ['BR', '27', 'Sant\xc3\xb3polis do Aguape\xc3\xad'],
 ['BR', '27', 'Santos'],
 ['BR', '27', 'S\xc3\xa3o Bento do Sapuca\xc3\xad'],
 ['BR', '27', 'S\xc3\xa3o Caetano do Sul'],
 ['BR', '27', 'S\xc3\xa3o Carlos'],
 ['BR', '27', 'S\xc3\xa3o Jo\xc3\xa3o das Duas Pontes'],
 ['BR', '27', 'S\xc3\xa3o Jo\xc3\xa3o de Iracema'],
 ['BR', '27', "S\xc3\xa3o Jo\xc3\xa3o do Pau d'Alho"],
 ['BR', '27', 'S\xc3\xa3o Joaquim da Barra'],
 ['BR', '27', 'S\xc3\xa3o Jos\xc3\xa9 da Bela Vista'],
 ['BR', '27', 'S\xc3\xa3o Jos\xc3\xa9 do Barreiro'],
 ['BR', '27', 'S\xc3\xa3o Jos\xc3\xa9 do Rio Pardo'],
 ['BR', '27', 'S\xc3\xa3o Jos\xc3\xa9 do Rio Preto'],
 ['BR', '27', 'S\xc3\xa3o Jos\xc3\xa9 dos Campos'],
 ['BR', '27', 'S\xc3\xa3o Louren\xc3\xa7o da Serra'],
 ['BR', '27', 'S\xc3\xa3o Lu\xc3\xads do Paraitinga'],
 ['BR', '27', 'S\xc3\xa3o Manuel'],
 ['BR', '27', 'S\xc3\xa3o Miguel Arcanjo'],
 ['BR', '27', 'S\xc3\xa3o Pedro do Turvo'],
 ['BR', '27', 'S\xc3\xa3o Roque'],
 ['BR', '27', 'S\xc3\xa3o Sebasti\xc3\xa3o'],
 ['BR', '27', 'S\xc3\xa3o Sebasti\xc3\xa3o da Grama'],
 ['BR', '27', 'S\xc3\xa3o Sim\xc3\xa3o'],
 ['BR', '27', 'Sarapu\xc3\xad'],
 ['BR', '27', 'Sarutai\xc3\xa1'],
 ['BR', '27', 'Sebastian\xc3\xb3polis do Sul'],
 ['BR', '27', 'Serra Azul'],
 ['BR', '27', 'Serrana'],
 ['BR', '27', 'Serra Negra'],
 ['BR', '27', 'Sete Barras'],
 ['BR', '27', 'Sever\xc3\xadnia'],
 ['BR', '27', 'Silveiras'],
 ['BR', '27', 'Socorro'],
 ['BR', '27', 'Sorocaba'],
 ['BR', '27', 'Sud Mennucci'],
 ['BR', '27', 'Sumar\xc3\xa9'],
 ['BR', '27', 'Suzano'],
 ['BR', '27', 'Suzan\xc3\xa1polis'],
 ['BR', '27', 'Tabapu\xc3\xa3'],
 ['BR', '27', 'Tabatinga'],
 ['BR', '27', 'Tabo\xc3\xa3o da Serra'],
 ['BR', '27', 'Taciba'],
 ['BR', '27', 'Tagua\xc3\xad'],
 ['BR', '27', 'Taia\xc3\xa7u'],
 ['BR', '27', 'Tai\xc3\xbava'],
 ['BR', '27', 'Tamba\xc3\xba'],
 ['BR', '27', 'Tanabi'],
 ['BR', '27', 'Tapira\xc3\xad'],
 ['BR', '27', 'Tapiratiba'],
 ['BR', '27', 'Taquaral'],
 ['BR', '27', 'Taquaritinga'],
 ['BR', '27', 'Taquarituba'],
 ['BR', '27', 'Taquariva\xc3\xad'],
 ['BR', '27', 'Tarabai'],
 ['BR', '27', 'Tarum\xc3\xa3'],
 ['BR', '27', 'Tatu\xc3\xad'],
 ['BR', '27', 'Taubat\xc3\xa9'],
 ['BR', '27', 'Teodoro Sampaio'],
 ['BR', '27', 'Terra Roxa'],
 ['BR', '27', 'Tiet\xc3\xaa'],
 ['BR', '27', 'Timburi'],
 ['BR', '27', 'Torre de Pedra'],
 ['BR', '27', 'Torrinha'],
 ['BR', '27', 'Trabiju'],
 ['BR', '27', 'Trememb\xc3\xa9'],
 ['BR', '27', 'Tr\xc3\xaas Fronteiras'],
 ['BR', '27', 'Tuiuti'],
 ['BR', '27', 'Tup\xc3\xa3'],
 ['BR', '27', 'Tupi Paulista'],
 ['BR', '27', 'Turi\xc3\xbaba'],
 ['BR', '27', 'Turmalina'],
 ['BR', '27', 'Ubarana'],
 ['BR', '27', 'Ubatuba'],
 ['BR', '27', 'Ubirajara'],
 ['BR', '27', 'Uchoa'],
 ['BR', '27', 'Uni\xc3\xa3o Paulista'],
 ['BR', '27', 'Ur\xc3\xa2nia'],
 ['BR', '27', 'Uru'],
 ['BR', '27', 'Urup\xc3\xaas'],
 ['BR', '27', 'Valentim Gentil'],
 ['BR', '27', 'Valinhos'],
 ['BR', '27', 'Valpara\xc3\xadso'],
 ['BR', '27', 'Vargem'],
 ['BR', '27', 'Vargem Grande do Sul'],
 ['BR', '27', 'Vargem Grande Paulista'],
 ['BR', '27', 'V\xc3\xa1rzea Paulista'],
 ['BR', '27', 'Vinhedo'],
 ['BR', '27', 'Viradouro'],
 ['BR', '27', 'Vista Alegre do Alto'],
 ['BR', '27', 'Vit\xc3\xb3ria Brasil'],
 ['BR', '27', 'Votorantim'],
 ['BR', '27', 'Zacarias'],
 ['BR', '27', 'Chavantes'],
 ['BR', '27', 'Estiva Gerbi'],
 ['BR', '18', 'Abati\xc3\xa1'],
 ['BR', '18', 'Adrian\xc3\xb3polis'],
 ['BR', '18', 'Agudos do Sul'],
 ['BR', '18', 'Almirante Tamandar\xc3\xa9'],
 ['BR', '18', 'Altamira do Paran\xc3\xa1'],
 ['BR', '18', 'Alt\xc3\xb4nia'],
 ['BR', '18', 'Alto Paran\xc3\xa1'],
 ['BR', '18', 'Alto Piquiri'],
 ['BR', '18', 'Alvorada do Sul'],
 ['BR', '18', 'Amapor\xc3\xa3'],
 ['BR', '18', 'Amp\xc3\xa9re'],
 ['BR', '18', 'Anahy'],
 ['BR', '18', 'Andir\xc3\xa1'],
 ['BR', '18', '\xc3\x82ngulo'],
 ['BR', '18', 'Antonina'],
 ['BR', '18', 'Ant\xc3\xb4nio Olinto'],
 ['BR', '18', 'Apucarana'],
 ['BR', '18', 'Arapongas'],
 ['BR', '18', 'Arapoti'],
 ['BR', '18', 'Arapu\xc3\xa3'],
 ['BR', '18', 'Araruna'],
 ['BR', '18', 'Arauc\xc3\xa1ria'],
 ['BR', '18', 'Ariranha do Iva\xc3\xad'],
 ['BR', '18', 'Assa\xc3\xad'],
 ['BR', '18', 'Assis Chateaubriand'],
 ['BR', '18', 'Astorga'],
 ['BR', '18', 'Atalaia'],
 ['BR', '18', 'Balsa Nova'],
 ['BR', '18', 'Bandeirantes'],
 ['BR', '18', 'Barbosa Ferraz'],
 ['BR', '18', 'Barrac\xc3\xa3o'],
 ['BR', '18', 'Barra do Jacar\xc3\xa9'],
 ['BR', '18', 'Bela Vista da Caroba'],
 ['BR', '18', 'Bela Vista do Para\xc3\xadso'],
 ['BR', '18', 'Bituruna'],
 ['BR', '18', 'Boa Esperan\xc3\xa7a'],
 ['BR', '18', 'Boa Esperan\xc3\xa7a do Igua\xc3\xa7u'],
 ['BR', '18', 'Boa Ventura de S\xc3\xa3o Roque'],
 ['BR', '18', 'Boa Vista da Aparecida'],
 ['BR', '18', 'Bocai\xc3\xbava do Sul'],
 ['BR', '18', 'Bom Jesus do Sul'],
 ['BR', '18', 'Bom Sucesso'],
 ['BR', '18', 'Bom Sucesso do Sul'],
 ['BR', '18', 'Borraz\xc3\xb3polis'],
 ['BR', '18', 'Braganey'],
 ['BR', '18', 'Brasil\xc3\xa2ndia do Sul'],
 ['BR', '18', 'Cafeara'],
 ['BR', '18', 'Cafel\xc3\xa2ndia'],
 ['BR', '18', 'Cafezal do Sul'],
 ['BR', '18', 'Calif\xc3\xb3rnia'],
 ['BR', '18', 'Cambar\xc3\xa1'],
 ['BR', '18', 'Camb\xc3\xa9'],
 ['BR', '18', 'Cambira'],
 ['BR', '18', 'Campina da Lagoa'],
 ['BR', '18', 'Campina do Sim\xc3\xa3o'],
 ['BR', '18', 'Campina Grande do Sul'],
 ['BR', '18', 'Campo Bonito'],
 ['BR', '18', 'Campo do Tenente'],
 ['BR', '18', 'Campo Largo'],
 ['BR', '18', 'Campo Magro'],
 ['BR', '18', 'Campo Mour\xc3\xa3o'],
 ['BR', '18', 'C\xc3\xa2ndido de Abreu'],
 ['BR', '18', 'Cand\xc3\xb3i'],
 ['BR', '18', 'Cantagalo'],
 ['BR', '18', 'Capanema'],
 ['BR', '18', 'Capit\xc3\xa3o Le\xc3\xb4nidas Marques'],
 ['BR', '18', 'Carambe\xc3\xad'],
 ['BR', '18', 'Carl\xc3\xb3polis'],
 ['BR', '18', 'Cascavel'],
 ['BR', '18', 'Castro'],
 ['BR', '18', 'Catanduvas'],
 ['BR', '18', 'Centen\xc3\xa1rio do Sul'],
 ['BR', '18', 'Cerro Azul'],
 ['BR', '18', 'C\xc3\xa9u Azul'],
 ['BR', '18', 'Chopinzinho'],
 ['BR', '18', 'Cianorte'],
 ['BR', '18', 'Cidade Ga\xc3\xbacha'],
 ['BR', '18', 'Clevel\xc3\xa2ndia'],
 ['BR', '18', 'Colombo'],
 ['BR', '18', 'Colorado'],
 ['BR', '18', 'Congonhinhas'],
 ['BR', '18', 'Conselheiro Mairinck'],
 ['BR', '18', 'Contenda'],
 ['BR', '18', 'Corb\xc3\xa9lia'],
 ['BR', '18', 'Corn\xc3\xa9lio Proc\xc3\xb3pio'],
 ['BR', '18', 'Coronel Domingos Soares'],
 ['BR', '18', 'Coronel Vivida'],
 ['BR', '18', 'Corumbata\xc3\xad do Sul'],
 ['BR', '18', 'Cruzeiro do Igua\xc3\xa7u'],
 ['BR', '18', 'Cruzeiro do Oeste'],
 ['BR', '18', 'Cruzeiro do Sul'],
 ['BR', '18', 'Cruz Machado'],
 ['BR', '18', 'Cruzmaltina'],
 ['BR', '18', 'Curitiba'],
 ['BR', '18', 'Curi\xc3\xbava'],
 ['BR', '18', 'Diamante do Norte'],
 ['BR', '18', 'Diamante do Sul'],
 ['BR', '18', "Diamante d'Oeste"],
 ['BR', '18', 'Dois Vizinhos'],
 ['BR', '18', 'Douradina'],
 ['BR', '18', 'Doutor Camargo'],
 ['BR', '18', 'En\xc3\xa9as Marques'],
 ['BR', '18', 'Engenheiro Beltr\xc3\xa3o'],
 ['BR', '18', 'Esperan\xc3\xa7a Nova'],
 ['BR', '18', 'Entre Rios do Oeste'],
 ['BR', '18', 'Espig\xc3\xa3o Alto do Igua\xc3\xa7u'],
 ['BR', '18', 'Farol'],
 ['BR', '18', 'Faxinal'],
 ['BR', '18', 'Fazenda Rio Grande'],
 ['BR', '18', 'F\xc3\xaanix'],
 ['BR', '18', 'Fernandes Pinheiro'],
 ['BR', '18', 'Figueira'],
 ['BR', '18', 'Flora\xc3\xad'],
 ['BR', '18', 'Flor da Serra do Sul'],
 ['BR', '18', 'Floresta'],
 ['BR', '18', 'Florest\xc3\xb3polis'],
 ['BR', '18', 'Fl\xc3\xb3rida'],
 ['BR', '18', 'Formosa do Oeste'],
 ['BR', '18', 'Foz do Igua\xc3\xa7u'],
 ['BR', '18', 'Francisco Alves'],
 ['BR', '18', 'Francisco Beltr\xc3\xa3o'],
 ['BR', '18', 'Foz do Jord\xc3\xa3o'],
 ['BR', '18', 'General Carneiro'],
 ['BR', '18', 'Godoy Moreira'],
 ['BR', '18', 'Goioer\xc3\xaa'],
 ['BR', '18', 'Goioxim'],
 ['BR', '18', 'Grandes Rios'],
 ['BR', '18', 'Gua\xc3\xadra'],
 ['BR', '18', 'Guaira\xc3\xa7\xc3\xa1'],
 ['BR', '18', 'Guamiranga'],
 ['BR', '18', 'Guapirama'],
 ['BR', '18', 'Guaporema'],
 ['BR', '18', 'Guaraci'],
 ['BR', '18', 'Guarania\xc3\xa7u'],
 ['BR', '18', 'Guarapuava'],
 ['BR', '18', 'Guaraque\xc3\xa7aba'],
 ['BR', '18', 'Guaratuba'],
 ['BR', '18', 'Hon\xc3\xb3rio Serpa'],
 ['BR', '18', 'Ibaiti'],
 ['BR', '18', 'Ibema'],
 ['BR', '18', 'Ibipor\xc3\xa3'],
 ['BR', '18', 'Icara\xc3\xadma'],
 ['BR', '18', 'Iguara\xc3\xa7u'],
 ['BR', '18', 'Imba\xc3\xba'],
 ['BR', '18', 'Imbituva'],
 ['BR', '18', 'In\xc3\xa1cio Martins'],
 ['BR', '18', 'Inaj\xc3\xa1'],
 ['BR', '18', 'Indian\xc3\xb3polis'],
 ['BR', '18', 'Ipiranga'],
 ['BR', '18', 'Ipor\xc3\xa3'],
 ['BR', '18', 'Iracema do Oeste'],
 ['BR', '18', 'Irati'],
 ['BR', '18', 'Iretama'],
 ['BR', '18', 'Itaguaj\xc3\xa9'],
 ['BR', '18', 'Itaipul\xc3\xa2ndia'],
 ['BR', '18', 'Itambarac\xc3\xa1'],
 ['BR', '18', 'Itamb\xc3\xa9'],
 ['BR', '18', "Itapejara d'Oeste"],
 ['BR', '18', 'Itaperu\xc3\xa7u'],
 ['BR', '18', 'Ita\xc3\xbana do Sul'],
 ['BR', '18', 'Ivat\xc3\xa9'],
 ['BR', '18', 'Ivatuba'],
 ['BR', '18', 'Jaboti'],
 ['BR', '18', 'Jacarezinho'],
 ['BR', '18', 'Jaguapit\xc3\xa3'],
 ['BR', '18', 'Jaguaria\xc3\xadva'],
 ['BR', '18', 'Jandaia do Sul'],
 ['BR', '18', 'Jani\xc3\xb3polis'],
 ['BR', '18', 'Japira'],
 ['BR', '18', 'Japur\xc3\xa1'],
 ['BR', '18', 'Jardim Alegre'],
 ['BR', '18', 'Jardim Olinda'],
 ['BR', '18', 'Jataizinho'],
 ['BR', '18', 'Jesu\xc3\xadtas'],
 ['BR', '18', 'Joaquim T\xc3\xa1vora'],
 ['BR', '18', 'Jundia\xc3\xad do Sul'],
 ['BR', '18', 'Juranda'],
 ['BR', '18', 'Jussara'],
 ['BR', '18', 'Kalor\xc3\xa9'],
 ['BR', '18', 'Lapa'],
 ['BR', '18', 'Laranjal'],
 ['BR', '18', 'Laranjeiras do Sul'],
 ['BR', '18', 'Le\xc3\xb3polis'],
 ['BR', '18', 'Lidian\xc3\xb3polis'],
 ['BR', '18', 'Lindoeste'],
 ['BR', '18', 'Loanda'],
 ['BR', '18', 'Lobato'],
 ['BR', '18', 'Londrina'],
 ['BR', '18', 'Luiziana'],
 ['BR', '18', 'Lunardelli'],
 ['BR', '18', 'Mallet'],
 ['BR', '18', 'Mambor\xc3\xaa'],
 ['BR', '18', 'Mandagua\xc3\xa7u'],
 ['BR', '18', 'Mandaguari'],
 ['BR', '18', 'Mandirituba'],
 ['BR', '18', 'Manfrin\xc3\xb3polis'],
 ['BR', '18', 'Mangueirinha'],
 ['BR', '18', 'Manoel Ribas'],
 ['BR', '18', 'Marechal C\xc3\xa2ndido Rondon'],
 ['BR', '18', 'Maria Helena'],
 ['BR', '18', 'Marialva'],
 ['BR', '18', 'Maril\xc3\xa2ndia do Sul'],
 ['BR', '18', 'Marilena'],
 ['BR', '18', 'Mariluz'],
 ['BR', '18', 'Maring\xc3\xa1'],
 ['BR', '18', 'Mari\xc3\xb3polis'],
 ['BR', '18', 'Marip\xc3\xa1'],
 ['BR', '18', 'Marmeleiro'],
 ['BR', '18', 'Marquinho'],
 ['BR', '18', 'Marumbi'],
 ['BR', '18', 'Matel\xc3\xa2ndia'],
 ['BR', '18', 'Matinhos'],
 ['BR', '18', 'Mato Rico'],
 ['BR', '18', 'Mau\xc3\xa1 da Serra'],
 ['BR', '18', 'Medianeira'],
 ['BR', '18', 'Mercedes'],
 ['BR', '18', 'Mirador'],
 ['BR', '18', 'Miraselva'],
 ['BR', '18', 'Missal'],
 ['BR', '18', 'Moreira Sales'],
 ['BR', '18', 'Morretes'],
 ['BR', '18', 'Munhoz de Melo'],
 ['BR', '18', 'Nossa Senhora das Gra\xc3\xa7as'],
 ['BR', '18', 'Nova Alian\xc3\xa7a do Iva\xc3\xad'],
 ['BR', '18', 'Nova Am\xc3\xa9rica da Colina'],
 ['BR', '18', 'Nova Aurora'],
 ['BR', '18', 'Nova Cantu'],
 ['BR', '18', 'Nova Esperan\xc3\xa7a'],
 ['BR', '18', 'Nova Esperan\xc3\xa7a do Sudoeste'],
 ['BR', '18', 'Nova F\xc3\xa1tima'],
 ['BR', '18', 'Nova Laranjeiras'],
 ['BR', '18', 'Nova Londrina'],
 ['BR', '18', 'Nova Ol\xc3\xadmpia'],
 ['BR', '18', 'Nova Santa B\xc3\xa1rbara'],
 ['BR', '18', 'Nova Santa Rosa'],
 ['BR', '18', 'Nova Prata do Igua\xc3\xa7u'],
 ['BR', '18', 'Nova Tebas'],
 ['BR', '18', 'Novo Itacolomi'],
 ['BR', '18', 'Ourizona'],
 ['BR', '18', 'Ouro Verde do Oeste'],
 ['BR', '18', 'Pai\xc3\xa7andu'],
 ['BR', '18', 'Palmas'],
 ['BR', '18', 'Palmeira'],
 ['BR', '18', 'Palmital'],
 ['BR', '18', 'Palotina'],
 ['BR', '18', 'Para\xc3\xadso do Norte'],
 ['BR', '18', 'Paranacity'],
 ['BR', '18', 'Paranagu\xc3\xa1'],
 ['BR', '18', 'Paranapoema'],
 ['BR', '18', 'Paranava\xc3\xad'],
 ['BR', '18', 'Pato Bragado'],
 ['BR', '18', 'Pato Branco'],
 ['BR', '18', 'Paula Freitas'],
 ['BR', '18', 'Paulo Frontin'],
 ['BR', '18', 'Peabiru'],
 ['BR', '18', 'Perobal'],
 ['BR', '18', 'P\xc3\xa9rola'],
 ['BR', '18', "P\xc3\xa9rola d'Oeste"],
 ['BR', '18', 'Pi\xc3\xaan'],
 ['BR', '18', 'Pinhais'],
 ['BR', '18', 'Pinhal\xc3\xa3o'],
 ['BR', '18', 'Pinhal de S\xc3\xa3o Bento'],
 ['BR', '18', 'Pira\xc3\xad do Sul'],
 ['BR', '18', 'Piraquara'],
 ['BR', '18', 'Pitanga'],
 ['BR', '18', 'Pitangueiras'],
 ['BR', '18', 'Planalto'],
 ['BR', '18', 'Ponta Grossa'],
 ['BR', '18', 'Pontal do Paran\xc3\xa1'],
 ['BR', '18', 'Porecatu'],
 ['BR', '18', 'Porto Amazonas'],
 ['BR', '18', 'Porto Barreiro'],
 ['BR', '18', 'Porto Rico'],
 ['BR', '18', 'Porto Vit\xc3\xb3ria'],
 ['BR', '18', 'Prado Ferreira'],
 ['BR', '18', 'Pranchita'],
 ['BR', '18', 'Presidente Castelo Branco'],
 ['BR', '18', 'Primeiro de Maio'],
 ['BR', '18', 'Prudent\xc3\xb3polis'],
 ['BR', '18', 'Quarto Centen\xc3\xa1rio'],
 ['BR', '18', 'Quatigu\xc3\xa1'],
 ['BR', '18', 'Quatro Barras'],
 ['BR', '18', 'Quatro Pontes'],
 ['BR', '18', 'Quedas do Igua\xc3\xa7u'],
 ['BR', '18', 'Quer\xc3\xaancia do Norte'],
 ['BR', '18', 'Quinta do Sol'],
 ['BR', '18', 'Quitandinha'],
 ['BR', '18', 'Ramil\xc3\xa2ndia'],
 ['BR', '18', 'Rancho Alegre'],
 ['BR', '18', "Rancho Alegre d'Oeste"],
 ['BR', '18', 'Rebou\xc3\xa7as'],
 ['BR', '18', 'Renascen\xc3\xa7a'],
 ['BR', '18', 'Reserva'],
 ['BR', '18', 'Reserva do Igua\xc3\xa7u'],
 ['BR', '18', 'Ribeir\xc3\xa3o Claro'],
 ['BR', '18', 'Ribeir\xc3\xa3o do Pinhal'],
 ['BR', '18', 'Rio Azul'],
 ['BR', '18', 'Rio Bom'],
 ['BR', '18', 'Rio Bonito do Igua\xc3\xa7u'],
 ['BR', '18', 'Rio Branco do Iva\xc3\xad'],
 ['BR', '18', 'Rio Branco do Sul'],
 ['BR', '18', 'Rio Negro'],
 ['BR', '18', 'Rol\xc3\xa2ndia'],
 ['BR', '18', 'Roncador'],
 ['BR', '18', 'Rondon'],
 ['BR', '18', 'Ros\xc3\xa1rio do Iva\xc3\xad'],
 ['BR', '18', 'Sab\xc3\xa1udia'],
 ['BR', '18', 'Salgado Filho'],
 ['BR', '18', 'Salto do Itarar\xc3\xa9'],
 ['BR', '18', 'Salto do Lontra'],
 ['BR', '18', 'Santa Am\xc3\xa9lia'],
 ['BR', '18', 'Santa Helena'],
 ['BR', '18', 'Santa In\xc3\xaas'],
 ['BR', '18', 'Santa Isabel do Iva\xc3\xad'],
 ['BR', '18', 'Santa Izabel do Oeste'],
 ['BR', '18', 'Santa L\xc3\xbacia'],
 ['BR', '18', 'Santa Maria do Oeste'],
 ['BR', '18', 'Santa Mariana'],
 ['BR', '18', 'Santa M\xc3\xb4nica'],
 ['BR', '18', 'Santa Tereza do Oeste'],
 ['BR', '18', 'Santa Terezinha de Itaipu'],
 ['BR', '18', 'Santo Ant\xc3\xb4nio da Platina'],
 ['BR', '18', 'Santo Ant\xc3\xb4nio do Caiu\xc3\xa1'],
 ['BR', '18', 'Santo Ant\xc3\xb4nio do Sudoeste'],
 ['BR', '18', 'Santo In\xc3\xa1cio'],
 ['BR', '18', 'S\xc3\xa3o Carlos do Iva\xc3\xad'],
 ['BR', '18', 'S\xc3\xa3o Jer\xc3\xb4nimo da Serra'],
 ['BR', '18', 'S\xc3\xa3o Jo\xc3\xa3o do Caiu\xc3\xa1'],
 ['BR', '18', 'S\xc3\xa3o Jo\xc3\xa3o do Iva\xc3\xad'],
 ['BR', '18', 'S\xc3\xa3o Jo\xc3\xa3o do Triunfo'],
 ['BR', '18', "S\xc3\xa3o Jorge d'Oeste"],
 ['BR', '18', 'S\xc3\xa3o Jorge do Iva\xc3\xad'],
 ['BR', '18', 'S\xc3\xa3o Jorge do Patroc\xc3\xadnio'],
 ['BR', '18', 'S\xc3\xa3o Jos\xc3\xa9 dos Pinhais'],
 ['BR', '18', 'S\xc3\xa3o Manoel do Paran\xc3\xa1'],
 ['BR', '18', 'S\xc3\xa3o Mateus do Sul'],
 ['BR', '18', 'S\xc3\xa3o Miguel do Igua\xc3\xa7u'],
 ['BR', '18', 'S\xc3\xa3o Pedro do Igua\xc3\xa7u'],
 ['BR', '18', 'S\xc3\xa3o Pedro do Iva\xc3\xad'],
 ['BR', '18', 'S\xc3\xa3o Pedro do Paran\xc3\xa1'],
 ['BR', '18', 'S\xc3\xa3o Sebasti\xc3\xa3o da Amoreira'],
 ['BR', '18', 'S\xc3\xa3o Tom\xc3\xa9'],
 ['BR', '18', 'Sapopema'],
 ['BR', '18', 'Sarandi'],
 ['BR', '18', 'Saudade do Igua\xc3\xa7u'],
 ['BR', '18', 'Seng\xc3\xa9s'],
 ['BR', '18', 'Sertaneja'],
 ['BR', '18', 'Sertan\xc3\xb3polis'],
 ['BR', '18', 'Siqueira Campos'],
 ['BR', '18', 'Sulina'],
 ['BR', '18', 'Tamarana'],
 ['BR', '18', 'Tamboara'],
 ['BR', '18', 'Tapejara'],
 ['BR', '18', 'Tapira'],
 ['BR', '18', 'Teixeira Soares'],
 ['BR', '18', 'Terra Boa'],
 ['BR', '18', 'Terra Rica'],
 ['BR', '18', 'Terra Roxa'],
 ['BR', '18', 'Tibagi'],
 ['BR', '18', 'Tijucas do Sul'],
 ['BR', '18', 'Toledo'],
 ['BR', '18', 'Tomazina'],
 ['BR', '18', 'Tunas do Paran\xc3\xa1'],
 ['BR', '18', 'Tuneiras do Oeste'],
 ['BR', '18', 'Tup\xc3\xa3ssi'],
 ['BR', '18', 'Turvo'],
 ['BR', '18', 'Ubirat\xc3\xa3'],
 ['BR', '18', 'Umuarama'],
 ['BR', '18', 'Uni\xc3\xa3o da Vit\xc3\xb3ria'],
 ['BR', '18', 'Uniflor'],
 ['BR', '18', 'Ura\xc3\xad'],
 ['BR', '18', 'Wenceslau Braz'],
 ['BR', '18', 'Ventania'],
 ['BR', '18', 'Vera Cruz do Oeste'],
 ['BR', '18', 'Ver\xc3\xaa'],
 ['BR', '18', 'Vila Alta'],
 ['BR', '18', 'Doutor Ulysses'],
 ['BR', '18', 'Virmond'],
 ['BR', '18', 'Vitorino'],
 ['BR', '18', 'Xambr\xc3\xaa'],
 ['BR', '26', 'Abdon Batista'],
 ['BR', '26', 'Abelardo Luz'],
 ['BR', '26', 'Agrol\xc3\xa2ndia'],
 ['BR', '26', 'Agron\xc3\xb4mica'],
 ['BR', '26', '\xc3\x81gua Doce'],
 ['BR', '26', '\xc3\x81guas de Chapec\xc3\xb3'],
 ['BR', '26', '\xc3\x81guas Frias'],
 ['BR', '26', '\xc3\x81guas Mornas'],
 ['BR', '26', 'Alfredo Wagner'],
 ['BR', '26', 'Alto Bela Vista'],
 ['BR', '26', 'Anchieta'],
 ['BR', '26', 'Angelina'],
 ['BR', '26', 'Anita Garibaldi'],
 ['BR', '26', 'Anit\xc3\xa1polis'],
 ['BR', '26', 'Ant\xc3\xb4nio Carlos'],
 ['BR', '26', 'Api\xc3\xbana'],
 ['BR', '26', 'Arabut\xc3\xa3'],
 ['BR', '26', 'Araquari'],
 ['BR', '26', 'Ararangu\xc3\xa1'],
 ['BR', '26', 'Armaz\xc3\xa9m'],
 ['BR', '26', 'Arroio Trinta'],
 ['BR', '26', 'Arvoredo'],
 ['BR', '26', 'Ascurra'],
 ['BR', '26', 'Atalanta'],
 ['BR', '26', 'Balne\xc3\xa1rio Arroio do Silva'],
 ['BR', '26', 'Balne\xc3\xa1rio Cambori\xc3\xba'],
 ['BR', '26', 'Balne\xc3\xa1rio Barra do Sul'],
 ['BR', '26', 'Balne\xc3\xa1rio Gaivota'],
 ['BR', '26', 'Bandeirante'],
 ['BR', '26', 'Barra Bonita'],
 ['BR', '26', 'Barra Velha'],
 ['BR', '26', 'Bela Vista do Toldo'],
 ['BR', '26', 'Belmonte'],
 ['BR', '26', 'Benedito Novo'],
 ['BR', '26', 'Bigua\xc3\xa7u'],
 ['BR', '26', 'Blumenau'],
 ['BR', '26', 'Bocaina do Sul'],
 ['BR', '26', 'Bombinhas'],
 ['BR', '26', 'Bom Jardim da Serra'],
 ['BR', '26', 'Bom Jesus'],
 ['BR', '26', 'Bom Jesus do Oeste'],
 ['BR', '26', 'Bom Retiro'],
 ['BR', '26', 'Botuver\xc3\xa1'],
 ['BR', '26', 'Bra\xc3\xa7o do Norte'],
 ['BR', '26', 'Bra\xc3\xa7o do Trombudo'],
 ['BR', '26', 'Brun\xc3\xb3polis'],
 ['BR', '26', 'Brusque'],
 ['BR', '26', 'Ca\xc3\xa7ador'],
 ['BR', '26', 'Caibi'],
 ['BR', '26', 'Calmon'],
 ['BR', '26', 'Cambori\xc3\xba'],
 ['BR', '26', 'Cap\xc3\xa3o Alto'],
 ['BR', '26', 'Campo Alegre'],
 ['BR', '26', 'Campo Belo do Sul'],
 ['BR', '26', 'Campos Novos'],
 ['BR', '26', 'Canelinha'],
 ['BR', '26', 'Canoinhas'],
 ['BR', '26', 'Capinzal'],
 ['BR', '26', 'Capivari de Baixo'],
 ['BR', '26', 'Catanduvas'],
 ['BR', '26', 'Caxambu do Sul'],
 ['BR', '26', 'Celso Ramos'],
 ['BR', '26', 'Cerro Negro'],
 ['BR', '26', 'Chapad\xc3\xa3o do Lageado'],
 ['BR', '26', 'Chapec\xc3\xb3'],
 ['BR', '26', 'Cocal do Sul'],
 ['BR', '26', 'Cordilheira Alta'],
 ['BR', '26', 'Coronel Freitas'],
 ['BR', '26', 'Coronel Martins'],
 ['BR', '26', 'Corup\xc3\xa1'],
 ['BR', '26', 'Cunha Por\xc3\xa3'],
 ['BR', '26', 'Cunhata\xc3\xad'],
 ['BR', '26', 'Curitibanos'],
 ['BR', '26', 'Descanso'],
 ['BR', '26', 'Dion\xc3\xadsio Cerqueira'],
 ['BR', '26', 'Dona Emma'],
 ['BR', '26', 'Doutor Pedrinho'],
 ['BR', '26', 'Entre Rios'],
 ['BR', '26', 'Ermo'],
 ['BR', '26', 'Erval Velho'],
 ['BR', '26', 'Faxinal dos Guedes'],
 ['BR', '26', 'Flor do Sert\xc3\xa3o'],
 ['BR', '26', 'Florian\xc3\xb3polis'],
 ['BR', '26', 'Formosa do Sul'],
 ['BR', '26', 'Forquilhinha'],
 ['BR', '26', 'Fraiburgo'],
 ['BR', '26', 'Frei Rog\xc3\xa9rio'],
 ['BR', '26', 'Galv\xc3\xa3o'],
 ['BR', '26', 'Garopaba'],
 ['BR', '26', 'Garuva'],
 ['BR', '26', 'Gaspar'],
 ['BR', '26', 'Governador Celso Ramos'],
 ['BR', '26', 'Gr\xc3\xa3o Par\xc3\xa1'],
 ['BR', '26', 'Gravatal'],
 ['BR', '26', 'Guabiruba'],
 ['BR', '26', 'Guaraciaba'],
 ['BR', '26', 'Guaramirim'],
 ['BR', '26', 'Guaruj\xc3\xa1 do Sul'],
 ['BR', '26', 'Guatamb\xc3\xba'],
 ['BR', '26', "Herval d'Oeste"],
 ['BR', '26', 'Ibiam'],
 ['BR', '26', 'Ibicar\xc3\xa9'],
 ['BR', '26', 'Ibirama'],
 ['BR', '26', 'I\xc3\xa7ara'],
 ['BR', '26', 'Ilhota'],
 ['BR', '26', 'Imaru\xc3\xad'],
 ['BR', '26', 'Imbituba'],
 ['BR', '26', 'Imbuia'],
 ['BR', '26', 'Indaial'],
 ['BR', '26', 'Iomer\xc3\xaa'],
 ['BR', '26', 'Ipira'],
 ['BR', '26', 'Ipor\xc3\xa3 do Oeste'],
 ['BR', '26', 'Ipua\xc3\xa7u'],
 ['BR', '26', 'Ipumirim'],
 ['BR', '26', 'Iraceminha'],
 ['BR', '26', 'Irani'],
 ['BR', '26', 'Irati'],
 ['BR', '26', 'Irine\xc3\xb3polis'],
 ['BR', '26', 'It\xc3\xa1'],
 ['BR', '26', 'Itai\xc3\xb3polis'],
 ['BR', '26', 'Itaja\xc3\xad'],
 ['BR', '26', 'Itapiranga'],
 ['BR', '26', 'Itapo\xc3\xa1'],
 ['BR', '26', 'Ituporanga'],
 ['BR', '26', 'Jabor\xc3\xa1'],
 ['BR', '26', 'Jacinto Machado'],
 ['BR', '26', 'Jaguaruna'],
 ['BR', '26', 'Jaragu\xc3\xa1 do Sul'],
 ['BR', '26', 'Jardin\xc3\xb3polis'],
 ['BR', '26', 'Joa\xc3\xa7aba'],
 ['BR', '26', 'Joinville'],
 ['BR', '26', 'Jos\xc3\xa9 Boiteux'],
 ['BR', '26', 'Jupi\xc3\xa1'],
 ['BR', '26', 'Lacerd\xc3\xb3polis'],
 ['BR', '26', 'Lages'],
 ['BR', '26', 'Laguna'],
 ['BR', '26', 'Lajeado Grande'],
 ['BR', '26', 'Laurentino'],
 ['BR', '26', 'Lauro Muller'],
 ['BR', '26', 'Lebon R\xc3\xa9gis'],
 ['BR', '26', 'Leoberto Leal'],
 ['BR', '26', 'Lind\xc3\xb3ia do Sul'],
 ['BR', '26', 'Lontras'],
 ['BR', '26', 'Luiz Alves'],
 ['BR', '26', 'Luzerna'],
 ['BR', '26', 'Macieira'],
 ['BR', '26', 'Mafra'],
 ['BR', '26', 'Major Gercino'],
 ['BR', '26', 'Major Vieira'],
 ['BR', '26', 'Maracaj\xc3\xa1'],
 ['BR', '26', 'Maravilha'],
 ['BR', '26', 'Marema'],
 ['BR', '26', 'Massaranduba'],
 ['BR', '26', 'Matos Costa'],
 ['BR', '26', 'Meleiro'],
 ['BR', '26', 'Mirim Doce'],
 ['BR', '26', 'Modelo'],
 ['BR', '26', 'Monda\xc3\xad'],
 ['BR', '26', 'Monte Carlo'],
 ['BR', '26', 'Monte Castelo'],
 ['BR', '26', 'Morro da Fuma\xc3\xa7a'],
 ['BR', '26', 'Morro Grande'],
 ['BR', '26', 'Navegantes'],
 ['BR', '26', 'Nova Erechim'],
 ['BR', '26', 'Nova Itaberaba'],
 ['BR', '26', 'Nova Trento'],
 ['BR', '26', 'Nova Veneza'],
 ['BR', '26', 'Novo Horizonte'],
 ['BR', '26', 'Orleans'],
 ['BR', '26', 'Otac\xc3\xadlio Costa'],
 ['BR', '26', 'Ouro'],
 ['BR', '26', 'Ouro Verde'],
 ['BR', '26', 'Paial'],
 ['BR', '26', 'Painel'],
 ['BR', '26', 'Palho\xc3\xa7a'],
 ['BR', '26', 'Palma Sola'],
 ['BR', '26', 'Palmeira'],
 ['BR', '26', 'Palmitos'],
 ['BR', '26', 'Papanduva'],
 ['BR', '26', 'Passo de Torres'],
 ['BR', '26', 'Paulo Lopes'],
 ['BR', '26', 'Pedras Grandes'],
 ['BR', '26', 'Penha'],
 ['BR', '26', 'Peritiba'],
 ['BR', '26', 'Petrol\xc3\xa2ndia'],
 ['BR', '26', 'Pi\xc3\xa7arras'],
 ['BR', '26', 'Pinhalzinho'],
 ['BR', '26', 'Pinheiro Preto'],
 ['BR', '26', 'Piratuba'],
 ['BR', '26', 'Planalto Alegre'],
 ['BR', '26', 'Pomerode'],
 ['BR', '26', 'Ponte Alta'],
 ['BR', '26', 'Ponte Alta do Norte'],
 ['BR', '26', 'Ponte Serrada'],
 ['BR', '26', 'Porto Belo'],
 ['BR', '26', 'Porto Uni\xc3\xa3o'],
 ['BR', '26', 'Pouso Redondo'],
 ['BR', '26', 'Praia Grande'],
 ['BR', '26', 'Presidente Castelo Branco'],
 ['BR', '26', 'Presidente Get\xc3\xbalio'],
 ['BR', '26', 'Presidente Nereu'],
 ['BR', '26', 'Princesa'],
 ['BR', '26', 'Quilombo'],
 ['BR', '26', 'Rancho Queimado'],
 ['BR', '26', 'Rio das Antas'],
 ['BR', '26', 'Rio do Oeste'],
 ['BR', '26', 'Rio dos Cedros'],
 ['BR', '26', 'Rio do Sul'],
 ['BR', '26', 'Rio Fortuna'],
 ['BR', '26', 'Rio Negrinho'],
 ['BR', '26', 'Rio Rufino'],
 ['BR', '26', 'Riqueza'],
 ['BR', '26', 'Rodeio'],
 ['BR', '26', 'Romel\xc3\xa2ndia'],
 ['BR', '26', 'Saltinho'],
 ['BR', '26', 'Salto Veloso'],
 ['BR', '26', 'Sang\xc3\xa3o'],
 ['BR', '26', 'Santa Cec\xc3\xadlia'],
 ['BR', '26', 'Santa Helena'],
 ['BR', '26', 'Santa Rosa de Lima'],
 ['BR', '26', 'Santa Rosa do Sul'],
 ['BR', '26', 'Santa Terezinha'],
 ['BR', '26', 'Santa Terezinha do Progresso'],
 ['BR', '26', 'Santiago do Sul'],
 ['BR', '26', 'Santo Amaro da Imperatriz'],
 ['BR', '26', 'S\xc3\xa3o Bernardino'],
 ['BR', '26', 'S\xc3\xa3o Bento do Sul'],
 ['BR', '26', 'S\xc3\xa3o Bonif\xc3\xa1cio'],
 ['BR', '26', 'S\xc3\xa3o Carlos'],
 ['BR', '26', 'S\xc3\xa3o Cristov\xc3\xa3o do Sul'],
 ['BR', '26', 'S\xc3\xa3o Domingos'],
 ['BR', '26', 'S\xc3\xa3o Francisco do Sul'],
 ['BR', '26', 'S\xc3\xa3o Jo\xc3\xa3o do Oeste'],
 ['BR', '26', 'S\xc3\xa3o Jo\xc3\xa3o Batista'],
 ['BR', '26', 'S\xc3\xa3o Jo\xc3\xa3o do Itaperi\xc3\xba'],
 ['BR', '26', 'S\xc3\xa3o Jo\xc3\xa3o do Sul'],
 ['BR', '26', 'S\xc3\xa3o Joaquim'],
 ['BR', '26', 'S\xc3\xa3o Jos\xc3\xa9'],
 ['BR', '26', 'S\xc3\xa3o Jos\xc3\xa9 do Cedro'],
 ['BR', '26', 'S\xc3\xa3o Jos\xc3\xa9 do Cerrito'],
 ['BR', '26', 'S\xc3\xa3o Ludgero'],
 ['BR', '26', 'S\xc3\xa3o Martinho'],
 ['BR', '26', 'S\xc3\xa3o Miguel da Boa Vista'],
 ['BR', '26', 'S\xc3\xa3o Miguel do Oeste'],
 ['BR', '26', 'S\xc3\xa3o Pedro de Alc\xc3\xa2ntara'],
 ['BR', '26', 'Saudades'],
 ['BR', '26', 'Schroeder'],
 ['BR', '26', 'Seara'],
 ['BR', '26', 'Serra Alta'],
 ['BR', '26', 'Sider\xc3\xb3polis'],
 ['BR', '26', 'Sombrio'],
 ['BR', '26', 'Sul Brasil'],
 ['BR', '26', 'Tangar\xc3\xa1'],
 ['BR', '26', 'Tigrinhos'],
 ['BR', '26', 'Timb\xc3\xa9 do Sul'],
 ['BR', '26', 'Timb\xc3\xb3'],
 ['BR', '26', 'Timb\xc3\xb3 Grande'],
 ['BR', '26', 'Tr\xc3\xaas Barras'],
 ['BR', '26', 'Treviso'],
 ['BR', '26', 'Treze de Maio'],
 ['BR', '26', 'Treze T\xc3\xadlias'],
 ['BR', '26', 'Trombudo Central'],
 ['BR', '26', 'Tubar\xc3\xa3o'],
 ['BR', '26', 'Tun\xc3\xa1polis'],
 ['BR', '26', 'Turvo'],
 ['BR', '26', 'Uni\xc3\xa3o do Oeste'],
 ['BR', '26', 'Urubici'],
 ['BR', '26', 'Urupema'],
 ['BR', '26', 'Urussanga'],
 ['BR', '26', 'Varge\xc3\xa3o'],
 ['BR', '26', 'Vargem'],
 ['BR', '26', 'Vargem Bonita'],
 ['BR', '26', 'Vidal Ramos'],
 ['BR', '26', 'Videira'],
 ['BR', '26', 'Vitor Meireles'],
 ['BR', '26', 'Witmarsum'],
 ['BR', '26', 'Xanxer\xc3\xaa'],
 ['BR', '26', 'Xavantina'],
 ['BR', '26', 'Xaxim'],
 ['BR', '26', 'Zort\xc3\xa9a'],
 ['BR', '23', 'Agudo'],
 ['BR', '23', 'Ajuricaba'],
 ['BR', '23', 'Alecrim'],
 ['BR', '23', 'Alegrete'],
 ['BR', '23', 'Alegria'],
 ['BR', '23', 'Alpestre'],
 ['BR', '23', 'Alto Feliz'],
 ['BR', '23', 'Alvorada'],
 ['BR', '23', 'Amaral Ferrador'],
 ['BR', '23', 'Ametista do Sul'],
 ['BR', '23', 'Andr\xc3\xa9 da Rocha'],
 ['BR', '23', 'Anta Gorda'],
 ['BR', '23', 'Arambar\xc3\xa9'],
 ['BR', '23', 'Araric\xc3\xa1'],
 ['BR', '23', 'Aratiba'],
 ['BR', '23', 'Arroio do Meio'],
 ['BR', '23', 'Arroio do Sal'],
 ['BR', '23', 'Arroio dos Ratos'],
 ['BR', '23', 'Arroio do Tigre'],
 ['BR', '23', 'Arvorezinha'],
 ['BR', '23', '\xc3\x81urea'],
 ['BR', '23', 'Balne\xc3\xa1rio Pinhal'],
 ['BR', '23', 'Bar\xc3\xa3o'],
 ['BR', '23', 'Bar\xc3\xa3o do Triunfo'],
 ['BR', '23', 'Barrac\xc3\xa3o'],
 ['BR', '23', 'Barra do Guarita'],
 ['BR', '23', 'Barra do Quara\xc3\xad'],
 ['BR', '23', 'Barra do Ribeiro'],
 ['BR', '23', 'Barra do Rio Azul'],
 ['BR', '23', 'Barra Funda'],
 ['BR', '23', 'Benjamin Constant do Sul'],
 ['BR', '23', 'Boa Vista das Miss\xc3\xb5es'],
 ['BR', '23', 'Boa Vista do Buric\xc3\xa1'],
 ['BR', '23', 'Boa Vista do Sul'],
 ['BR', '23', 'Bom Jesus'],
 ['BR', '23', 'Bom Princ\xc3\xadpio'],
 ['BR', '23', 'Bom Progresso'],
 ['BR', '23', 'Bom Retiro do Sul'],
 ['BR', '23', 'Bossoroca'],
 ['BR', '23', 'Braga'],
 ['BR', '23', 'Brochier'],
 ['BR', '23', 'Buti\xc3\xa1'],
 ['BR', '23', 'Ca\xc3\xa7apava do Sul'],
 ['BR', '23', 'Cacequi'],
 ['BR', '23', 'Cachoeira do Sul'],
 ['BR', '23', 'Cachoeirinha'],
 ['BR', '23', 'Cacique Doble'],
 ['BR', '23', 'Cai\xc3\xa7ara'],
 ['BR', '23', 'Camaqu\xc3\xa3'],
 ['BR', '23', 'Camargo'],
 ['BR', '23', 'Cambar\xc3\xa1 do Sul'],
 ['BR', '23', 'Campestre da Serra'],
 ['BR', '23', 'Campina das Miss\xc3\xb5es'],
 ['BR', '23', 'Campo Novo'],
 ['BR', '23', 'Campos Borges'],
 ['BR', '23', 'Candel\xc3\xa1ria'],
 ['BR', '23', 'C\xc3\xa2ndido God\xc3\xb3i'],
 ['BR', '23', 'Candiota'],
 ['BR', '23', 'Canela'],
 ['BR', '23', 'Canoas'],
 ['BR', '23', 'Cap\xc3\xa3o da Canoa'],
 ['BR', '23', 'Cap\xc3\xa3o do Le\xc3\xa3o'],
 ['BR', '23', 'Capivari do Sul'],
 ['BR', '23', 'Capela de Santana'],
 ['BR', '23', 'Capit\xc3\xa3o'],
 ['BR', '23', 'Cara\xc3\xa1'],
 ['BR', '23', 'Carlos Gomes'],
 ['BR', '23', 'Casca'],
 ['BR', '23', 'Catu\xc3\xadpe'],
 ['BR', '23', 'Caxias do Sul'],
 ['BR', '23', 'Centen\xc3\xa1rio'],
 ['BR', '23', 'Cerrito'],
 ['BR', '23', 'Cerro Branco'],
 ['BR', '23', 'Cerro Grande do Sul'],
 ['BR', '23', 'Cerro Largo'],
 ['BR', '23', 'Chapada'],
 ['BR', '23', 'Charqueadas'],
 ['BR', '23', 'Charrua'],
 ['BR', '23', 'Chiapetta'],
 ['BR', '23', 'Chu\xc3\xad'],
 ['BR', '23', 'Chuvisca'],
 ['BR', '23', 'Cidreira'],
 ['BR', '23', 'Cir\xc3\xadaco'],
 ['BR', '23', 'Colinas'],
 ['BR', '23', 'Colorado'],
 ['BR', '23', 'Condor'],
 ['BR', '23', 'Coqueiros do Sul'],
 ['BR', '23', 'Coronel Barros'],
 ['BR', '23', 'Coronel Bicaco'],
 ['BR', '23', 'Cotipor\xc3\xa3'],
 ['BR', '23', 'Coxilha'],
 ['BR', '23', 'Crissiumal'],
 ['BR', '23', 'Cristal'],
 ['BR', '23', 'Cristal do Sul'],
 ['BR', '23', 'Cruzeiro do Sul'],
 ['BR', '23', 'Dezesseis de Novembro'],
 ['BR', '23', 'Dilermando de Aguiar'],
 ['BR', '23', 'Dois Irm\xc3\xa3os'],
 ['BR', '23', 'Dois Irm\xc3\xa3os das Miss\xc3\xb5es'],
 ['BR', '23', 'Dois Lajeados'],
 ['BR', '23', 'Dom Feliciano'],
 ['BR', '23', 'Dom Pedro de Alc\xc3\xa2ntara'],
 ['BR', '23', 'Dom Pedrito'],
 ['BR', '23', 'Dona Francisca'],
 ['BR', '23', 'Doutor Maur\xc3\xadcio Cardoso'],
 ['BR', '23', 'Doutor Ricardo'],
 ['BR', '23', 'Eldorado do Sul'],
 ['BR', '23', 'Encantado'],
 ['BR', '23', 'Encruzilhada do Sul'],
 ['BR', '23', 'Engenho Velho'],
 ['BR', '23', 'Entre-Iju\xc3\xads'],
 ['BR', '23', 'Entre Rios do Sul'],
 ['BR', '23', 'Erebango'],
 ['BR', '23', 'Erval Grande'],
 ['BR', '23', 'Erval Seco'],
 ['BR', '23', 'Esperan\xc3\xa7a do Sul'],
 ['BR', '23', 'Esta\xc3\xa7\xc3\xa3o'],
 ['BR', '23', 'Est\xc3\xa2ncia Velha'],
 ['BR', '23', 'Esteio'],
 ['BR', '23', 'Estrela'],
 ['BR', '23', 'Estrela Velha'],
 ['BR', '23', 'Eug\xc3\xaanio de Castro'],
 ['BR', '23', 'Fagundes Varela'],
 ['BR', '23', 'Farroupilha'],
 ['BR', '23', 'Faxinal do Soturno'],
 ['BR', '23', 'Faxinalzinho'],
 ['BR', '23', 'Fazenda Vilanova'],
 ['BR', '23', 'Feliz'],
 ['BR', '23', 'Flores da Cunha'],
 ['BR', '23', 'Floriano Peixoto'],
 ['BR', '23', 'Fontoura Xavier'],
 ['BR', '23', 'Formigueiro'],
 ['BR', '23', 'Frederico Westphalen'],
 ['BR', '23', 'Garruchos'],
 ['BR', '23', 'Gaurama'],
 ['BR', '23', 'General C\xc3\xa2mara'],
 ['BR', '23', 'Gentil'],
 ['BR', '23', 'Get\xc3\xbalio Vargas'],
 ['BR', '23', 'Giru\xc3\xa1'],
 ['BR', '23', 'Glorinha'],
 ['BR', '23', 'Gramado'],
 ['BR', '23', 'Gramado dos Loureiros'],
 ['BR', '23', 'Gramado Xavier'],
 ['BR', '23', 'Gravata\xc3\xad'],
 ['BR', '23', 'Guabiju'],
 ['BR', '23', 'Gua\xc3\xadba'],
 ['BR', '23', 'Guapor\xc3\xa9'],
 ['BR', '23', 'Guarani das Miss\xc3\xb5es'],
 ['BR', '23', 'Harmonia'],
 ['BR', '23', 'Herveiras'],
 ['BR', '23', 'Horizontina'],
 ['BR', '23', 'Hulha Negra'],
 ['BR', '23', 'Humait\xc3\xa1'],
 ['BR', '23', 'Ibarama'],
 ['BR', '23', 'Ibiraiaras'],
 ['BR', '23', 'Ibirub\xc3\xa1'],
 ['BR', '23', 'Igrejinha'],
 ['BR', '23', 'Il\xc3\xb3polis'],
 ['BR', '23', 'Imb\xc3\xa9'],
 ['BR', '23', 'Inhacor\xc3\xa1'],
 ['BR', '23', 'Ip\xc3\xaa'],
 ['BR', '23', 'Ipiranga do Sul'],
 ['BR', '23', 'Ira\xc3\xad'],
 ['BR', '23', 'Itaara'],
 ['BR', '23', 'Itacurubi'],
 ['BR', '23', 'Itapuca'],
 ['BR', '23', 'Itaqui'],
 ['BR', '23', 'Itatiba do Sul'],
 ['BR', '23', 'Ivor\xc3\xa1'],
 ['BR', '23', 'Ivoti'],
 ['BR', '23', 'Jaboticaba'],
 ['BR', '23', 'Jaguar\xc3\xa3o'],
 ['BR', '23', 'Jaquirana'],
 ['BR', '23', 'Jari'],
 ['BR', '23', 'J\xc3\xb3ia'],
 ['BR', '23', 'J\xc3\xbalio de Castilhos'],
 ['BR', '23', 'Lago\xc3\xa3o'],
 ['BR', '23', 'Lagoa dos Tr\xc3\xaas Cantos'],
 ['BR', '23', 'Lajeado do Bugre'],
 ['BR', '23', 'Lavras do Sul'],
 ['BR', '23', 'Liberato Salzano'],
 ['BR', '23', 'Lindolfo Collor'],
 ['BR', '23', 'Linha Nova'],
 ['BR', '23', 'Machadinho'],
 ['BR', '23', 'Ma\xc3\xa7ambara'],
 ['BR', '23', 'Mampituba'],
 ['BR', '23', 'Manoel Viana'],
 ['BR', '23', 'Maquin\xc3\xa9'],
 ['BR', '23', 'Marau'],
 ['BR', '23', 'Marcelino Ramos'],
 ['BR', '23', 'Mariana Pimentel'],
 ['BR', '23', 'Mariano Moro'],
 ['BR', '23', 'Mata'],
 ['BR', '23', 'Mato Castelhano'],
 ['BR', '23', 'Mato Leit\xc3\xa3o'],
 ['BR', '23', 'Maximiliano de Almeida'],
 ['BR', '23', 'Minas do Le\xc3\xa3o'],
 ['BR', '23', 'Miragua\xc3\xad'],
 ['BR', '23', 'Montauri'],
 ['BR', '23', 'Monte Alegre dos Campos'],
 ['BR', '23', 'Morrinhos do Sul'],
 ['BR', '23', 'Morro Redondo'],
 ['BR', '23', 'Morro Reuter'],
 ['BR', '23', 'Mostardas'],
 ['BR', '23', 'Mu\xc3\xa7um'],
 ['BR', '23', 'Muitos Cap\xc3\xb5es'],
 ['BR', '23', 'Muliterno'],
 ['BR', '23', 'N\xc3\xa3o-Me-Toque'],
 ['BR', '23', 'Nicolau Vergueiro'],
 ['BR', '23', 'Nonoai'],
 ['BR', '23', 'Nova Alvorada'],
 ['BR', '23', 'Nova Ara\xc3\xa7\xc3\xa1'],
 ['BR', '23', 'Nova Bassano'],
 ['BR', '23', 'Nova Esperan\xc3\xa7a do Sul'],
 ['BR', '23', 'Nova Hartz'],
 ['BR', '23', 'Nova P\xc3\xa1dua'],
 ['BR', '23', 'Nova Palma'],
 ['BR', '23', 'Nova Petr\xc3\xb3polis'],
 ['BR', '23', 'Nova Prata'],
 ['BR', '23', 'Nova Ramada'],
 ['BR', '23', 'Nova Roma do Sul'],
 ['BR', '23', 'Nova Santa Rita'],
 ['BR', '23', 'Novo Cabrais'],
 ['BR', '23', 'Novo Machado'],
 ['BR', '23', 'Novo Tiradentes'],
 ['BR', '23', 'Novo Barreiro'],
 ['BR', '23', 'Os\xc3\xb3rio'],
 ['BR', '23', 'Paim Filho'],
 ['BR', '23', 'Palmares do Sul'],
 ['BR', '23', 'Palmitinho'],
 ['BR', '23', 'Panambi'],
 ['BR', '23', 'Pantano Grande'],
 ['BR', '23', 'Para\xc3\xad'],
 ['BR', '23', 'Para\xc3\xadso do Sul'],
 ['BR', '23', 'Pareci Novo'],
 ['BR', '23', 'Parob\xc3\xa9'],
 ['BR', '23', 'Passa Sete'],
 ['BR', '23', 'Passo do Sobrado'],
 ['BR', '23', 'Passo Fundo'],
 ['BR', '23', 'Paverama'],
 ['BR', '23', 'Pedro Os\xc3\xb3rio'],
 ['BR', '23', 'Peju\xc3\xa7ara'],
 ['BR', '23', 'Picada Caf\xc3\xa9'],
 ['BR', '23', 'Pinhal'],
 ['BR', '23', 'Pinhal Grande'],
 ['BR', '23', 'Pinheirinho do Vale'],
 ['BR', '23', 'Pirap\xc3\xb3'],
 ['BR', '23', 'Piratini'],
 ['BR', '23', 'Planalto'],
 ['BR', '23', 'Po\xc3\xa7o das Antas'],
 ['BR', '23', 'Pont\xc3\xa3o'],
 ['BR', '23', 'Port\xc3\xa3o'],
 ['BR', '23', 'Porto Alegre'],
 ['BR', '23', 'Porto Lucena'],
 ['BR', '23', 'Porto Mau\xc3\xa1'],
 ['BR', '23', 'Porto Vera Cruz'],
 ['BR', '23', 'Porto Xavier'],
 ['BR', '23', 'Pouso Novo'],
 ['BR', '23', 'Presidente Lucena'],
 ['BR', '23', 'Prot\xc3\xa1sio Alves'],
 ['BR', '23', 'Putinga'],
 ['BR', '23', 'Quara\xc3\xad'],
 ['BR', '23', 'Quevedos'],
 ['BR', '23', 'Quinze de Novembro'],
 ['BR', '23', 'Redentora'],
 ['BR', '23', 'Restinga Seca'],
 ['BR', '23', 'Rio dos \xc3\x8dndios'],
 ['BR', '23', 'Rio Pardo'],
 ['BR', '23', 'Riozinho'],
 ['BR', '23', 'Rodeio Bonito'],
 ['BR', '23', 'Rolante'],
 ['BR', '23', 'Ronda Alta'],
 ['BR', '23', 'Rondinha'],
 ['BR', '23', 'Roque Gonzales'],
 ['BR', '23', 'Ros\xc3\xa1rio do Sul'],
 ['BR', '23', 'Sagrada Fam\xc3\xadlia'],
 ['BR', '23', 'Saldanha Marinho'],
 ['BR', '23', 'Salvador das Miss\xc3\xb5es'],
 ['BR', '23', 'Sananduva'],
 ['BR', '23', 'Santa B\xc3\xa1rbara do Sul'],
 ['BR', '23', 'Santa Clara do Sul'],
 ['BR', '23', 'Santa Cruz do Sul'],
 ['BR', '23', 'Santa Maria do Herval'],
 ['BR', '23', 'Santana da Boa Vista'],
 ['BR', '23', 'Santana do Livramento'],
 ['BR', '23', 'Santa Rosa'],
 ['BR', '23', 'Santa Tereza'],
 ['BR', '23', 'Santa Vit\xc3\xb3ria do Palmar'],
 ['BR', '23', 'Santo \xc3\x82ngelo'],
 ['BR', '23', 'Santo Ant\xc3\xb4nio do Palma'],
 ['BR', '23', 'Santo Ant\xc3\xb4nio da Patrulha'],
 ['BR', '23', 'Santo Ant\xc3\xb4nio das Miss\xc3\xb5es'],
 ['BR', '23', 'Santo Ant\xc3\xb4nio do Planalto'],
 ['BR', '23', 'Santo Augusto'],
 ['BR', '23', 'Santo Cristo'],
 ['BR', '23', 'Santo Expedito do Sul'],
 ['BR', '23', 'S\xc3\xa3o Borja'],
 ['BR', '23', 'S\xc3\xa3o Domingos do Sul'],
 ['BR', '23', 'S\xc3\xa3o Francisco de Assis'],
 ['BR', '23', 'S\xc3\xa3o Jer\xc3\xb4nimo'],
 ['BR', '23', 'S\xc3\xa3o Jo\xc3\xa3o da Urtiga'],
 ['BR', '23', 'S\xc3\xa3o Jo\xc3\xa3o do Pol\xc3\xaasine'],
 ['BR', '23', 'S\xc3\xa3o Jorge'],
 ['BR', '23', 'S\xc3\xa3o Jos\xc3\xa9 das Miss\xc3\xb5es'],
 ['BR', '23', 'S\xc3\xa3o Jos\xc3\xa9 do Herval'],
 ['BR', '23', 'S\xc3\xa3o Jos\xc3\xa9 do Hort\xc3\xaancio'],
 ['BR', '23', 'S\xc3\xa3o Jos\xc3\xa9 do Inhacor\xc3\xa1'],
 ['BR', '23', 'S\xc3\xa3o Jos\xc3\xa9 do Norte'],
 ['BR', '23', 'S\xc3\xa3o Jos\xc3\xa9 do Ouro'],
 ['BR', '23', 'S\xc3\xa3o Jos\xc3\xa9 dos Ausentes'],
 ['BR', '23', 'S\xc3\xa3o Leopoldo'],
 ['BR', '23', 'S\xc3\xa3o Louren\xc3\xa7o do Sul'],
 ['BR', '23', 'S\xc3\xa3o Marcos'],
 ['BR', '23', 'S\xc3\xa3o Martinho'],
 ['BR', '23', 'S\xc3\xa3o Martinho da Serra'],
 ['BR', '23', 'S\xc3\xa3o Nicolau'],
 ['BR', '23', 'S\xc3\xa3o Paulo das Miss\xc3\xb5es'],
 ['BR', '23', 'S\xc3\xa3o Pedro da Serra'],
 ['BR', '23', 'S\xc3\xa3o Pedro do Buti\xc3\xa1'],
 ['BR', '23', 'S\xc3\xa3o Pedro do Sul'],
 ['BR', '23', 'S\xc3\xa3o Sebasti\xc3\xa3o do Ca\xc3\xad'],
 ['BR', '23', 'S\xc3\xa3o Sep\xc3\xa9'],
 ['BR', '23', 'S\xc3\xa3o Valentim'],
 ['BR', '23', 'S\xc3\xa3o Valentim do Sul'],
 ['BR', '23', 'S\xc3\xa3o Val\xc3\xa9rio do Sul'],
 ['BR', '23', 'S\xc3\xa3o Vendelino'],
 ['BR', '23', 'S\xc3\xa3o Vicente do Sul'],
 ['BR', '23', 'Sapiranga'],
 ['BR', '23', 'Sapucaia do Sul'],
 ['BR', '23', 'Sarandi'],
 ['BR', '23', 'Seberi'],
 ['BR', '23', 'Sede Nova'],
 ['BR', '23', 'Segredo'],
 ['BR', '23', 'Selbach'],
 ['BR', '23', 'Senador Salgado Filho'],
 ['BR', '23', 'Sentinela do Sul'],
 ['BR', '23', 'Serafina Corr\xc3\xaaa'],
 ['BR', '23', 'S\xc3\xa9rio'],
 ['BR', '23', 'Sert\xc3\xa3o'],
 ['BR', '23', 'Sert\xc3\xa3o Santana'],
 ['BR', '23', 'Sete de Setembro'],
 ['BR', '23', 'Severiano de Almeida'],
 ['BR', '23', 'Silveira Martins'],
 ['BR', '23', 'Sinimbu'],
 ['BR', '23', 'Taba\xc3\xad'],
 ['BR', '23', 'Tapera'],
 ['BR', '23', 'Tapes'],
 ['BR', '23', 'Taquara'],
 ['BR', '23', 'Taquari'],
 ['BR', '23', 'Taquaru\xc3\xa7u do Sul'],
 ['BR', '23', 'Tavares'],
 ['BR', '23', 'Tenente Portela'],
 ['BR', '23', 'Tiradentes do Sul'],
 ['BR', '23', 'Toropi'],
 ['BR', '23', 'Torres'],
 ['BR', '23', 'Tramanda\xc3\xad'],
 ['BR', '23', 'Travesseiro'],
 ['BR', '23', 'Tr\xc3\xaas Arroios'],
 ['BR', '23', 'Tr\xc3\xaas Cachoeiras'],
 ['BR', '23', 'Tr\xc3\xaas Coroas'],
 ['BR', '23', 'Tr\xc3\xaas de Maio'],
 ['BR', '23', 'Tr\xc3\xaas Forquilhas'],
 ['BR', '23', 'Tr\xc3\xaas Palmeiras'],
 ['BR', '23', 'Tr\xc3\xaas Passos'],
 ['BR', '23', 'Trindade do Sul'],
 ['BR', '23', 'Triunfo'],
 ['BR', '23', 'Tucunduva'],
 ['BR', '23', 'Tunas'],
 ['BR', '23', 'Tupanci do Sul'],
 ['BR', '23', 'Tupanciret\xc3\xa3'],
 ['BR', '23', 'Tupandi'],
 ['BR', '23', 'Tuparendi'],
 ['BR', '23', 'Turu\xc3\xa7u'],
 ['BR', '23', 'Ubiretama'],
 ['BR', '23', 'Uni\xc3\xa3o da Serra'],
 ['BR', '23', 'Unistalda'],
 ['BR', '23', 'Uruguaiana'],
 ['BR', '23', 'Vacaria'],
 ['BR', '23', 'Vale Verde'],
 ['BR', '23', 'Vale do Sol'],
 ['BR', '23', 'Vale Real'],
 ['BR', '23', 'Vanini'],
 ['BR', '23', 'Ven\xc3\xa2ncio Aires'],
 ['BR', '23', 'Vera Cruz'],
 ['BR', '23', 'Veran\xc3\xb3polis'],
 ['BR', '23', 'Vespasiano Correa'],
 ['BR', '23', 'Viadutos'],
 ['BR', '23', 'Viam\xc3\xa3o'],
 ['BR', '23', 'Vicente Dutra'],
 ['BR', '23', 'Vila Flores'],
 ['BR', '23', 'Vila L\xc3\xa2ngaro'],
 ['BR', '23', 'Vila Maria'],
 ['BR', '23', 'Vila Nova do Sul'],
 ['BR', '23', 'Vista Alegre'],
 ['BR', '23', 'Vista Alegre do Prata'],
 ['BR', '23', 'Vista Ga\xc3\xbacha'],
 ['BR', '23', 'Vit\xc3\xb3ria das Miss\xc3\xb5es'],
 ['BR', '23', 'Xangri-l\xc3\xa1'],
 ['BR', '11', '\xc3\x81gua Clara'],
 ['BR', '11', 'Alcin\xc3\xb3polis'],
 ['BR', '11', 'Amamba\xc3\xad'],
 ['BR', '11', 'Anast\xc3\xa1cio'],
 ['BR', '11', 'Anauril\xc3\xa2ndia'],
 ['BR', '11', 'Ang\xc3\xa9lica'],
 ['BR', '11', 'Ant\xc3\xb4nio Jo\xc3\xa3o'],
 ['BR', '11', 'Aparecida do Taboado'],
 ['BR', '11', 'Aquidauana'],
 ['BR', '11', 'Aral Moreira'],
 ['BR', '11', 'Bandeirantes'],
 ['BR', '11', 'Bataguassu'],
 ['BR', '11', 'Bataypor\xc3\xa3'],
 ['BR', '11', 'Bela Vista'],
 ['BR', '11', 'Bodoquena'],
 ['BR', '11', 'Bonito'],
 ['BR', '11', 'Brasil\xc3\xa2ndia'],
 ['BR', '11', 'Caarap\xc3\xb3'],
 ['BR', '11', 'Camapu\xc3\xa3'],
 ['BR', '11', 'Campo Grande'],
 ['BR', '11', 'Caracol'],
 ['BR', '11', 'Cassil\xc3\xa2ndia'],
 ['BR', '11', 'Chapad\xc3\xa3o do Sul'],
 ['BR', '11', 'Corguinho'],
 ['BR', '11', 'Coronel Sapucaia'],
 ['BR', '11', 'Corumb\xc3\xa1'],
 ['BR', '11', 'Costa Rica'],
 ['BR', '11', 'Coxim'],
 ['BR', '11', 'Deod\xc3\xa1polis'],
 ['BR', '11', 'Dois Irm\xc3\xa3os do Buriti'],
 ['BR', '11', 'Douradina'],
 ['BR', '11', 'Dourados'],
 ['BR', '11', 'Eldorado'],
 ['BR', '11', 'F\xc3\xa1tima do Sul'],
 ['BR', '11', 'Gl\xc3\xb3ria de Dourados'],
 ['BR', '11', 'Guia Lopes da Laguna'],
 ['BR', '11', 'Iguatemi'],
 ['BR', '11', 'Inoc\xc3\xaancia'],
 ['BR', '11', 'Itapor\xc3\xa3'],
 ['BR', '11', 'Itaquira\xc3\xad'],
 ['BR', '11', 'Ivinhema'],
 ['BR', '11', 'Japor\xc3\xa3'],
 ['BR', '11', 'Jaraguari'],
 ['BR', '11', 'Jate\xc3\xad'],
 ['BR', '11', 'Juti'],
 ['BR', '11', 'Lad\xc3\xa1rio'],
 ['BR', '11', 'Laguna Carap\xc3\xa3'],
 ['BR', '11', 'Maracaju'],
 ['BR', '11', 'Miranda'],
 ['BR', '11', 'Mundo Novo'],
 ['BR', '11', 'Navira\xc3\xad'],
 ['BR', '11', 'Nioaque'],
 ['BR', '11', 'Nova Alvorada do Sul'],
 ['BR', '11', 'Nova Andradina'],
 ['BR', '11', 'Novo Horizonte do Sul'],
 ['BR', '11', 'Parana\xc3\xadba'],
 ['BR', '11', 'Paranhos'],
 ['BR', '11', 'Pedro Gomes'],
 ['BR', '11', 'Ponta Por\xc3\xa3'],
 ['BR', '11', 'Porto Murtinho'],
 ['BR', '11', 'Ribas do Rio Pardo'],
 ['BR', '11', 'Rio Brilhante'],
 ['BR', '11', 'Rio Negro'],
 ['BR', '11', 'Rio Verde de Mato Grosso'],
 ['BR', '11', 'Rochedo'],
 ['BR', '11', 'Santa Rita do Pardo'],
 ['BR', '11', 'S\xc3\xa3o Gabriel do Oeste'],
 ['BR', '11', 'Sete Quedas'],
 ['BR', '11', 'Selv\xc3\xadria'],
 ['BR', '11', 'Sonora'],
 ['BR', '11', 'Tacuru'],
 ['BR', '11', 'Taquarussu'],
 ['BR', '11', 'Terenos'],
 ['BR', '11', 'Tr\xc3\xaas Lagoas'],
 ['BR', '11', 'Vicentina'],
 ['BR', '14', 'Acorizal'],
 ['BR', '14', 'Alta Floresta'],
 ['BR', '14', 'Alto Araguaia'],
 ['BR', '14', 'Alto Gar\xc3\xa7as'],
 ['BR', '14', 'Alto Paraguai'],
 ['BR', '14', 'Alto Taquari'],
 ['BR', '14', 'Apiac\xc3\xa1s'],
 ['BR', '14', 'Araguaiana'],
 ['BR', '14', 'Araguainha'],
 ['BR', '14', 'Araputanga'],
 ['BR', '14', 'Aren\xc3\xa1polis'],
 ['BR', '14', 'Bar\xc3\xa3o de Melga\xc3\xa7o'],
 ['BR', '14', 'Barra do Bugres'],
 ['BR', '14', 'Barra do Gar\xc3\xa7as'],
 ['BR', '14', 'Brasnorte'],
 ['BR', '14', 'Campin\xc3\xa1polis'],
 ['BR', '14', 'Campo Novo do Parecis'],
 ['BR', '14', 'Campo Verde'],
 ['BR', '14', 'Campos de J\xc3\xbalio'],
 ['BR', '14', 'CanaBrava do Norte'],
 ['BR', '14', 'Canarana'],
 ['BR', '14', 'Castanheira'],
 ['BR', '14', 'Chapada dos Guimar\xc3\xa3es'],
 ['BR', '14', 'Cl\xc3\xa1udia'],
 ['BR', '14', 'Col\xc3\xadder'],
 ['BR', '14', 'Comodoro'],
 ['BR', '14', 'Confresa'],
 ['BR', '14', 'Cotrigua\xc3\xa7u'],
 ['BR', '14', 'Cuiab\xc3\xa1'],
 ['BR', '14', 'Denise'],
 ['BR', '14', 'Diamantino'],
 ['BR', '14', 'Dom Aquino'],
 ['BR', '14', 'Feliz Natal'],
 ['BR', '14', "Figueir\xc3\xb3polis d'Oeste"],
 ['BR', '14', 'Ga\xc3\xbacha do Norte'],
 ['BR', '14', 'General Carneiro'],
 ['BR', '14', "Gl\xc3\xb3ria d'Oeste"],
 ['BR', '14', 'Guiratinga'],
 ['BR', '14', 'Indiava\xc3\xad'],
 ['BR', '14', 'Itiquira'],
 ['BR', '14', 'Jaciara'],
 ['BR', '14', 'Jangada'],
 ['BR', '14', 'Jauru'],
 ['BR', '14', 'Juara'],
 ['BR', '14', 'Ju\xc3\xadna'],
 ['BR', '14', 'Juruena'],
 ['BR', '14', 'Juscimeira'],
 ['BR', '14', 'Vila Bela da Sant\xc3\xadssima Trindade'],
 ['BR', '14', 'Nortel\xc3\xa2ndia'],
 ['BR', '14', 'Nossa Senhora do Livramento'],
 ['BR', '14', 'Nova Bandeirantes'],
 ['BR', '14', 'Nova Lacerda'],
 ['BR', '14', 'Nova Brasil\xc3\xa2ndia'],
 ['BR', '14', 'Nova Cana\xc3\xa3 do Norte'],
 ['BR', '14', 'Nova Ol\xc3\xadmpia'],
 ['BR', '14', 'Nova Ubirat\xc3\xa3'],
 ['BR', '14', 'Nova Xavantina'],
 ['BR', '14', 'Novo Horizonte do Norte'],
 ['BR', '14', 'Parana\xc3\xadta'],
 ['BR', '14', 'Paranatinga'],
 ['BR', '14', 'Pedra Preta'],
 ['BR', '14', 'Planalto da Serra'],
 ['BR', '14', 'Pocon\xc3\xa9'],
 ['BR', '14', 'Pontal do Araguaia'],
 ['BR', '14', 'Ponte Branca'],
 ['BR', '14', 'Porto Alegre do Norte'],
 ['BR', '14', 'Porto dos Ga\xc3\xbachos'],
 ['BR', '14', 'Porto Esperidi\xc3\xa3o'],
 ['BR', '14', 'Porto Estrela'],
 ['BR', '14', 'Poxor\xc3\xa9o'],
 ['BR', '14', 'Primavera do Leste'],
 ['BR', '14', 'Quer\xc3\xaancia'],
 ['BR', '14', 'S\xc3\xa3o Jos\xc3\xa9 dos Quatro Marcos'],
 ['BR', '14', 'Reserva do Caba\xc3\xa7al'],
 ['BR', '14', 'Ribeir\xc3\xa3ozinho'],
 ['BR', '14', 'Rio Branco'],
 ['BR', '14', 'Santa Carmem'],
 ['BR', '14', 'Santo Afonso'],
 ['BR', '14', 'S\xc3\xa3o Jos\xc3\xa9 do Rio Claro'],
 ['BR', '14', 'S\xc3\xa3o Pedro da Cipa'],
 ['BR', '14', 'Rondon\xc3\xb3polis'],
 ['BR', '14', 'Ros\xc3\xa1rio Oeste'],
 ['BR', '14', 'Salto do C\xc3\xa9u'],
 ['BR', '14', 'Santo Ant\xc3\xb4nio do Leverger'],
 ['BR', '14', 'Sapezal'],
 ['BR', '14', 'Sinop'],
 ['BR', '14', 'Tabapor\xc3\xa3'],
 ['BR', '14', 'Tangar\xc3\xa1 da Serra'],
 ['BR', '14', 'Tapurah'],
 ['BR', '14', 'Terra Nova do Norte'],
 ['BR', '14', 'Tesouro'],
 ['BR', '14', 'Torixor\xc3\xa9u'],
 ['BR', '14', 'Uni\xc3\xa3o do Sul'],
 ['BR', '14', 'V\xc3\xa1rzea Grande'],
 ['BR', '14', 'Vera'],
 ['BR', '14', 'Vila Rica'],
 ['BR', '14', 'Nova Guarita'],
 ['BR', '14', 'Nova Monte Verde'],
 ['BR', '29', 'Abadia de Goi\xc3\xa1s'],
 ['BR', '29', 'Abadi\xc3\xa2nia'],
 ['BR', '29', 'Acre\xc3\xbana'],
 ['BR', '29', 'Adel\xc3\xa2ndia'],
 ['BR', '29', '\xc3\x81gua Limpa'],
 ['BR', '29', '\xc3\x81guas Lindas de Goi\xc3\xa1s'],
 ['BR', '29', 'Alex\xc3\xa2nia'],
 ['BR', '29', 'Alo\xc3\xa2ndia'],
 ['BR', '29', 'Alto Horizonte'],
 ['BR', '29', 'Alvorada do Norte'],
 ['BR', '29', 'Amaralina'],
 ['BR', '29', 'Americano do Brasil'],
 ['BR', '29', 'Amorin\xc3\xb3polis'],
 ['BR', '29', 'Anhanguera'],
 ['BR', '29', 'Anicuns'],
 ['BR', '29', 'Aparecida de Goi\xc3\xa2nia'],
 ['BR', '29', 'Aparecida do Rio Doce'],
 ['BR', '29', 'Apor\xc3\xa9'],
 ['BR', '29', 'Ara\xc3\xa7u'],
 ['BR', '29', 'Aragar\xc3\xa7as'],
 ['BR', '29', 'Aragoi\xc3\xa2nia'],
 ['BR', '29', 'Araguapaz'],
 ['BR', '29', 'Aren\xc3\xb3polis'],
 ['BR', '29', 'Aruan\xc3\xa3'],
 ['BR', '29', 'Avelin\xc3\xb3polis'],
 ['BR', '29', 'Barro Alto'],
 ['BR', '29', 'Bela Vista de Goi\xc3\xa1s'],
 ['BR', '29', 'Bom Jardim de Goi\xc3\xa1s'],
 ['BR', '29', 'Bom Jesus de Goi\xc3\xa1s'],
 ['BR', '29', 'Bonfin\xc3\xb3polis'],
 ['BR', '29', 'Bon\xc3\xb3polis'],
 ['BR', '29', 'Brazabrantes'],
 ['BR', '29', 'Brit\xc3\xa2nia'],
 ['BR', '29', 'Buriti Alegre'],
 ['BR', '29', 'Buriti de Goi\xc3\xa1s'],
 ['BR', '29', 'Buritin\xc3\xb3polis'],
 ['BR', '29', 'Cabeceiras'],
 ['BR', '29', 'Cachoeira Alta'],
 ['BR', '29', 'Cachoeira de Goi\xc3\xa1s'],
 ['BR', '29', 'Cachoeira Dourada'],
 ['BR', '29', 'Ca\xc3\xa7u'],
 ['BR', '29', 'Caiap\xc3\xb4nia'],
 ['BR', '29', 'Caldas Novas'],
 ['BR', '29', 'Caldazinha'],
 ['BR', '29', 'Campestre de Goi\xc3\xa1s'],
 ['BR', '29', 'Campina\xc3\xa7u'],
 ['BR', '29', 'Campinorte'],
 ['BR', '29', 'Campo Alegre de Goi\xc3\xa1s'],
 ['BR', '29', 'Campos Belos'],
 ['BR', '29', 'Campos Verdes'],
 ['BR', '29', 'Carmo do Rio Verde'],
 ['BR', '29', 'Castel\xc3\xa2ndia'],
 ['BR', '29', 'Catal\xc3\xa3o'],
 ['BR', '29', 'Catura\xc3\xad'],
 ['BR', '29', 'Cavalcante'],
 ['BR', '29', 'Cezarina'],
 ['BR', '29', 'Cidade Ocidental'],
 ['BR', '29', 'Cocalzinho de Goi\xc3\xa1s'],
 ['BR', '29', 'Colinas do Sul'],
 ['BR', '29', 'C\xc3\xb3rrego do Ouro'],
 ['BR', '29', 'Corumb\xc3\xa1 de Goi\xc3\xa1s'],
 ['BR', '29', 'Corumba\xc3\xadba'],
 ['BR', '29', 'Cristalina'],
 ['BR', '29', 'Cristian\xc3\xb3polis'],
 ['BR', '29', 'Crix\xc3\xa1s'],
 ['BR', '29', 'Crom\xc3\xadnia'],
 ['BR', '29', 'Cumari'],
 ['BR', '29', 'Damian\xc3\xb3polis'],
 ['BR', '29', 'Damol\xc3\xa2ndia'],
 ['BR', '29', 'Davin\xc3\xb3polis'],
 ['BR', '29', 'Diorama'],
 ['BR', '29', 'Doverl\xc3\xa2ndia'],
 ['BR', '29', 'Edealina'],
 ['BR', '29', 'Ed\xc3\xa9ia'],
 ['BR', '29', 'Estrela do Norte'],
 ['BR', '29', 'Faina'],
 ['BR', '29', 'Fazenda Nova'],
 ['BR', '29', 'Firmin\xc3\xb3polis'],
 ['BR', '29', 'Flores de Goi\xc3\xa1s'],
 ['BR', '29', 'Formosa'],
 ['BR', '29', 'Formoso'],
 ['BR', '29', 'Goian\xc3\xa1polis'],
 ['BR', '29', 'Goiandira'],
 ['BR', '29', 'Goian\xc3\xa9sia'],
 ['BR', '29', 'Goi\xc3\xa2nia'],
 ['BR', '29', 'Goianira'],
 ['BR', '29', 'Goi\xc3\xa1s'],
 ['BR', '29', 'Goiatuba'],
 ['BR', '29', 'Gouvel\xc3\xa2ndia'],
 ['BR', '29', 'Guap\xc3\xb3'],
 ['BR', '29', 'Guara\xc3\xadta'],
 ['BR', '29', 'Guarani de Goi\xc3\xa1s'],
 ['BR', '29', 'Guarinos'],
 ['BR', '29', 'Heitora\xc3\xad'],
 ['BR', '29', 'Hidrol\xc3\xa2ndia'],
 ['BR', '29', 'Hidrolina'],
 ['BR', '29', 'Iaciara'],
 ['BR', '29', 'Inaciol\xc3\xa2ndia'],
 ['BR', '29', 'Indiara'],
 ['BR', '29', 'Inhumas'],
 ['BR', '29', 'Ipameri'],
 ['BR', '29', 'Ipor\xc3\xa1'],
 ['BR', '29', 'Israel\xc3\xa2ndia'],
 ['BR', '29', 'Itabera\xc3\xad'],
 ['BR', '29', 'Itaguari'],
 ['BR', '29', 'Itaguaru'],
 ['BR', '29', 'Itapaci'],
 ['BR', '29', 'Itapirapu\xc3\xa3'],
 ['BR', '29', 'Itapuranga'],
 ['BR', '29', 'Itarum\xc3\xa3'],
 ['BR', '29', 'Itau\xc3\xa7u'],
 ['BR', '29', 'Itumbiara'],
 ['BR', '29', 'Ivol\xc3\xa2ndia'],
 ['BR', '29', 'Jandaia'],
 ['BR', '29', 'Jaragu\xc3\xa1'],
 ['BR', '29', 'Jata\xc3\xad'],
 ['BR', '29', 'Jaupaci'],
 ['BR', '29', 'Jes\xc3\xbapolis'],
 ['BR', '29', 'Jovi\xc3\xa2nia'],
 ['BR', '29', 'Jussara'],
 ['BR', '29', 'Leopoldo de Bulh\xc3\xb5es'],
 ['BR', '29', 'Luzi\xc3\xa2nia'],
 ['BR', '29', 'Mairipotaba'],
 ['BR', '29', 'Mamba\xc3\xad'],
 ['BR', '29', 'Mara Rosa'],
 ['BR', '29', 'Marzag\xc3\xa3o'],
 ['BR', '29', 'Matrinch\xc3\xa3'],
 ['BR', '29', 'Mauril\xc3\xa2ndia'],
 ['BR', '29', 'Mimoso de Goi\xc3\xa1s'],
 ['BR', '29', 'Mina\xc3\xa7u'],
 ['BR', '29', 'Mineiros'],
 ['BR', '29', 'Moipor\xc3\xa1'],
 ['BR', '29', 'Monte Alegre de Goi\xc3\xa1s'],
 ['BR', '29', 'Montes Claros de Goi\xc3\xa1s'],
 ['BR', '29', 'Montividiu'],
 ['BR', '29', 'Montividiu do Norte'],
 ['BR', '29', 'Morrinhos'],
 ['BR', '29', 'Morro Agudo de Goi\xc3\xa1s'],
 ['BR', '29', 'Moss\xc3\xa2medes'],
 ['BR', '29', 'Mozarl\xc3\xa2ndia'],
 ['BR', '29', 'Mundo Novo'],
 ['BR', '29', 'Mutun\xc3\xb3polis'],
 ['BR', '29', 'Naz\xc3\xa1rio'],
 ['BR', '29', 'Ner\xc3\xb3polis'],
 ['BR', '29', 'Niquel\xc3\xa2ndia'],
 ['BR', '29', 'Nova Am\xc3\xa9rica'],
 ['BR', '29', 'Nova Aurora'],
 ['BR', '29', 'Nova Crix\xc3\xa1s'],
 ['BR', '29', 'Nova Gl\xc3\xb3ria'],
 ['BR', '29', 'Nova Igua\xc3\xa7u de Goi\xc3\xa1s'],
 ['BR', '29', 'Nova Roma'],
 ['BR', '29', 'Nova Veneza'],
 ['BR', '29', 'Novo Brasil'],
 ['BR', '29', 'Novo Gama'],
 ['BR', '29', 'Novo Planalto'],
 ['BR', '29', 'Orizona'],
 ['BR', '29', 'Ouro Verde de Goi\xc3\xa1s'],
 ['BR', '29', 'Ouvidor'],
 ['BR', '29', 'Padre Bernardo'],
 ['BR', '29', 'Palestina de Goi\xc3\xa1s'],
 ['BR', '29', 'Palmeiras de Goi\xc3\xa1s'],
 ['BR', '29', 'Palmelo'],
 ['BR', '29', 'Palmin\xc3\xb3polis'],
 ['BR', '29', 'Panam\xc3\xa1'],
 ['BR', '29', 'Paranaiguara'],
 ['BR', '29', 'Para\xc3\xbana'],
 ['BR', '29', 'Perol\xc3\xa2ndia'],
 ['BR', '29', 'Petrolina de Goi\xc3\xa1s'],
 ['BR', '29', 'Pilar de Goi\xc3\xa1s'],
 ['BR', '29', 'Piracanjuba'],
 ['BR', '29', 'Piren\xc3\xb3polis'],
 ['BR', '29', 'Pires do Rio'],
 ['BR', '29', 'Planaltina'],
 ['BR', '29', 'Pontalina'],
 ['BR', '29', 'Porangatu'],
 ['BR', '29', 'Porteir\xc3\xa3o'],
 ['BR', '29', 'Portel\xc3\xa2ndia'],
 ['BR', '29', 'Posse'],
 ['BR', '29', 'Professor Jamil'],
 ['BR', '29', 'Quirin\xc3\xb3polis'],
 ['BR', '29', 'Rialma'],
 ['BR', '29', 'Rian\xc3\xa1polis'],
 ['BR', '29', 'Rio Quente'],
 ['BR', '29', 'Rio Verde'],
 ['BR', '29', 'Rubiataba'],
 ['BR', '29', 'Sanclerl\xc3\xa2ndia'],
 ['BR', '29', 'Santa Cruz de Goi\xc3\xa1s'],
 ['BR', '29', 'Santa F\xc3\xa9 de Goi\xc3\xa1s'],
 ['BR', '29', 'Santa Helena de Goi\xc3\xa1s'],
 ['BR', '29', 'Santa Isabel'],
 ['BR', '29', 'Santa Rita do Araguaia'],
 ['BR', '29', 'Santa Rita do Novo Destino'],
 ['BR', '29', 'Santa Rosa de Goi\xc3\xa1s'],
 ['BR', '29', 'Santa Tereza de Goi\xc3\xa1s'],
 ['BR', '29', 'Santa Terezinha de Goi\xc3\xa1s'],
 ['BR', '29', 'Santo Ant\xc3\xb4nio da Barra'],
 ['BR', '29', 'Santo Ant\xc3\xb4nio de Goi\xc3\xa1s'],
 ['BR', '29', "S\xc3\xa3o Jo\xc3\xa3o d'Alian\xc3\xa7a"],
 ['BR', '29', 'S\xc3\xa3o Jo\xc3\xa3o da Para\xc3\xbana'],
 ['BR', '29', 'S\xc3\xa3o Lu\xc3\xads de Montes Belos'],
 ['BR', '29', 'S\xc3\xa3o Lu\xc3\xadz do Norte'],
 ['BR', '29', 'S\xc3\xa3o Miguel do Araguaia'],
 ['BR', '29', 'S\xc3\xa3o Miguel do Passa Quatro'],
 ['BR', '29', 'S\xc3\xa3o Patr\xc3\xadcio'],
 ['BR', '29', 'S\xc3\xa3o Sim\xc3\xa3o'],
 ['BR', '29', "S\xc3\xadtio d'Abadia"],
 ['BR', '29', 'Taquaral de Goi\xc3\xa1s'],
 ['BR', '29', 'Teresina de Goi\xc3\xa1s'],
 ['BR', '29', 'Terez\xc3\xb3polis de Goi\xc3\xa1s'],
 ['BR', '29', 'Tr\xc3\xaas Ranchos'],
 ['BR', '29', 'Trindade'],
 ['BR', '29', 'Trombas'],
 ['BR', '29', 'Turv\xc3\xa2nia'],
 ['BR', '29', 'Turvel\xc3\xa2ndia'],
 ['BR', '29', 'Uirapuru'],
 ['BR', '29', 'Urua\xc3\xa7u'],
 ['BR', '29', 'Uruana'],
 ['BR', '29', 'Uruta\xc3\xad'],
 ['BR', '29', 'Valpara\xc3\xadso de Goi\xc3\xa1s'],
 ['BR', '29', 'Varj\xc3\xa3o'],
 ['BR', '29', 'Vian\xc3\xb3polis'],
 ['BR', '29', 'Vicentin\xc3\xb3polis'],
 ['BR', '29', 'Vila Boa'],
 ['BR', '29', 'Vila Prop\xc3\xadcio'],
 ['BR', '23', 'Novo Xingu'],
 ['BR', '23', 'Constantina'],
 ['BR', '23', 'Bar\xc3\xa3o de Cotegipe'],
 ['BR', '23', 'Arroio do Padre'],
 ['BR', '23', 'Bag\xc3\xa9'],
 ['BR', '23', 'Pedras Altas'],
 ['BR', '23', 'Pinheiro Machado'],
 ['BR', '23', 'Augusto Pestana'],
 ['BR', '23', 'Iju\xc3\xad'],
 ['BR', '23', 'Boa Vista do Cadeado'],
 ['BR', '23', 'Bozano'],
 ['BR', '23', 'Cruz Alta'],
 ['BR', '23', 'Fortaleza dos Valos'],
 ['BR', '23', 'Boa Vista do Incra'],
 ['BR', '23', 'Salto do Jacu\xc3\xad'],
 ['BR', '23', 'Jacuizinho'],
 ['BR', '23', 'Espumoso'],
 ['BR', '23', 'Victor Graeff'],
 ['BR', '23', 'Tio Hugo'],
 ['BR', '23', 'Ibirapuit\xc3\xa3'],
 ['BR', '23', 'Ernestina'],
 ['BR', '23', '\xc3\x81gua Santa'],
 ['BR', '23', 'Tapejara'],
 ['BR', '23', 'Caseiros'],
 ['BR', '23', 'Santa Cec\xc3\xadlia do Sul'],
 ['BR', '23', 'Ibia\xc3\xa7\xc3\xa1'],
 ['BR', '23', 'Esmeralda'],
 ['BR', '23', 'Pinhal da Serra'],
 ['BR', '14', 'Rondol\xc3\xa2ndia'],
 ['BR', '14', 'Aripuan\xc3\xa3'],
 ['BR', '14', 'Colniza'],
 ['BR', '14', 'Pontes e Lacerda'],
 ['BR', '14', 'Vale de S\xc3\xa3o Domingos'],
 ['BR', '14', "Conquista D'oeste"],
 ['BR', '14', 'Santo Ant\xc3\xb4nio do Leste'],
 ['BR', '14', 'Novo S\xc3\xa3o Joaquim'],
 ['BR', '14', 'Santa Cruz do Xingu'],
 ['BR', '05', 'Lu\xc3\xads Eduardo Magalh\xc3\xa3es'],
 ['BR', '08', 'Colatina'],
 ['BR', '08', 'Governador Lindenberg'],
 ['BR', '29', 'Ipiranga de Goi\xc3\xa1s'],
 ['BR', '29', 'Ceres'],
 ['BR', '29', 'Itaj\xc3\xa1'],
 ['BR', '29', 'Lagoa Santa'],
 ['BR', '29', 'An\xc3\xa1polis'],
 ['BR', '29', 'Silv\xc3\xa2nia'],
 ['BR', '29', 'Campo Limpo de Goi\xc3\xa1s'],
 ['BR', '02', 'S\xc3\xa3o Miguel dos Campos'],
 ['BR', '14', 'Nobres'],
 ['BR', '14', 'Santa Rita do Trivelato'],
 ['BR', '14', 'Marcel\xc3\xa2ndia'],
 ['BR', '14', 'Nova Santa Helena'],
 ['BR', '14', 'Ita\xc3\xbaba'],
 ['BR', '22', 'V\xc3\xa1rzea'],
 ['BR', '22', 'Jundi\xc3\xa1'],
 ['BR', '22', 'Esp\xc3\xadrito Santo'],
 ['BR', '15', 'Buen\xc3\xb3polis'],
 ['BR', '23', 'S\xc3\xa3o Gabriel'],
 ['BR', '24', 'Jaru'],
 ['BR', '24', 'Governador Jorge Teixeira'],
 ['BR', '24', 'Mirante da Serra'],
 ['BR', '01', 'Feij\xc3\xb3'],
 ['BR', '01', 'Manoel Urbano'],
 ['BR', '01', 'Santa Rosa do Purus'],
 ['BR', '01', 'Sena Madureira'],
 ['BR', '04', 'Coari'],
 ['BR', '25', 'Caracara\xc3\xad'],
 ['BR', '25', 'Rorain\xc3\xb3polis'],
 ['BR', '16', 'Almeirim'],
 ['BR', '16', 'Altamira'],
 ['BR', '03', 'Serra do Navio'],
 ['BR', '03', 'Pedra Branca do Amapar\xc3\xad'],
 ['BR', '03', 'Ferreira Gomes'],
 ['BR', '03', 'Porto Grande'],
 ['BR', '03', 'Laranjal do Jari'],
 ['BR', '31', 'Monte do Carmo'],
 ['BR', '31', 'Natividade'],
 ['BR', '31', 'S\xc3\xa3o Val\xc3\xa9rio da Natividade'],
 ['BR', '13', 'S\xc3\xa3o Raimundo do Doca Bezerra'],
 ['BR', '13', 'S\xc3\xa3o Roberto'],
 ['BR', '20', 'Floriano'],
 ['BR', '22', 'Cai\xc3\xa7ara do Rio do Vento'],
 ['BR', '17', 'Gurj\xc3\xa3o'],
 ['BR', '02', 'S\xc3\xa3o Jos\xc3\xa9 da Laje'],
 ['BR', '05', 'Barra do Mendes'],
 ['BR', '05', 'Souto Soares'],
 ['BR', '15', 'Augusto de Lima'],
 ['BR', '15', 'Diamantina'],
 ['BR', '08', 'Santa Leopoldina'],
 ['BR', '08', 'Santa Maria de Jetib\xc3\xa1'],
 ['BR', '21', 'Carmo'],
 ['BR', '21', 'Duas Barras'],
 ['BR', '27', 'Arealva'],
 ['BR', '27', 'Iacanga'],
 ['BR', '27', 'Iporanga'],
 ['BR', '18', 'Ortigueira'],
 ['BR', '18', 'Tel\xc3\xaamaco Borba'],
 ['BR', '26', 'Rio do Campo'],
 ['BR', '26', 'Salete'],
 ['BR', '26', 'Tai\xc3\xb3'],
 ['BR', '23', 'Santa Maria'],
 ['BR', '11', 'Sidrol\xc3\xa2ndia'],
 ['BR', '14', 'Guarant\xc3\xa3 do Norte'],
 ['BR', '14', 'Lucas do Rio Verde'],
 ['BR', '14', 'Matup\xc3\xa1'],
 ['BR', '14', 'Nova Mutum'],
 ['BR', '14', 'Peixoto de Azevedo'],
 ['BR', '14', 'Sorriso'],
 ['BR', '07', 'Bras\xc3\xadlia'],
 ['BR', '20', 'S\xc3\xa3o Jo\xc3\xa3o da Fronteira'],
 ['BR', '05', 'Gl\xc3\xb3ria'],
 ['BR', '17', 'Prata'],
 ['BR', '17', 'S\xc3\xa3o Francisco'],
 ['BR', '30', 'Flores'],
 ['BR', '30', 'Paulista'],
 ['BR', '30', 'S\xc3\xa3o Jo\xc3\xa3o'],
 ['BR', '05', 'Prado'],
 ['BR', '15', 'Gouveia'],
 ['BR', '15', 'Ipanema'],
 ['BR', '15', 'Machado'],
 ['BR', '15', 'Prata'],
 ['BR', '15', 'S\xc3\xa3o Francisco'],
 ['BR', '08', 'Alegre'],
 ['BR', '27', 'Barbosa'],
 ['BR', '27', 'Sales'],
 ['BR', '27', 'S\xc3\xa3o Francisco'],
 ['BR', '22', 'S\xc3\xa3o Vicente'],
 ['BR', '15', 'S\xc3\xa3o Francisco de Paula'],
 ['BR', '20', '\xc3\x81gua Branca'],
 ['BR', '22', 'S\xc3\xa3o Pedro'],
 ['BR', '17', '\xc3\x81gua Branca'],
 ['BR', '17', 'Sert\xc3\xa3ozinho'],
 ['BR', '30', 'Ara\xc3\xa7oiaba'],
 ['BR', '18', 'Pinh\xc3\xa3o'],
 ['BR', '23', 'Independ\xc3\xaancia'],
 ['BR', '25', 'Alto Alegre'],
 ['BR', '18', 'Iguatu'],
 ['BR', '25', 'Iracema'],
 ['BR', '31', 'Ipueiras'],
 ['BR', '20', 'Batalha'],
 ['BR', '17', 'Amparo'],
 ['BR', '17', 'Pedra Branca'],
 ['BR', '17', 'Soledade'],
 ['BR', '30', 'Cedro'],
 ['BR', '28', 'Pacatuba'],
 ['BR', '05', 'Milagres'],
 ['BR', '15', 'Candeias'],
 ['BR', '26', 'Aurora'],
 ['BR', '23', 'Alto Alegre'],
 ['BR', '11', 'Jardim'],
 ['BR', '29', 'Piranhas'],
 ['BR', '06', 'Granja'],
 ['BR', '30', 'Itamb\xc3\xa9'],
 ['BR', '30', 'Serrita'],
 ['BR', '02', 'Jacar\xc3\xa9 dos Homens'],
 ['BR', '02', "Olho d'\xc3\x81gua do Casado"],
 ['BR', '06', 'Hidrol\xc3\xa2ndia'],
 ['BR', '06', 'Ocara'],
 ['BR', '02', 'Belo Monte'],
 ['BR', '02', 'Igaci'],
 ['BR', '24', 'Nova Mamor\xc3\xa9'],
 ['BR', '04', 'Canutama'],
 ['BR', '04', 'Tapau\xc3\xa1'],
 ['BR', '16', 'Aveiro'],
 ['BR', '16', 'Inhangapi'],
 ['BR', '16', 'Viseu'],
 ['BR', '31', 'Lagoa da Confus\xc3\xa3o'],
 ['BR', '31', 'Presidente Kennedy'],
 ['BR', '31', 'Tupiratins'],
 ['BR', '20', 'Avelino Lopes'],
 ['BR', '20', 'Morro Cabe\xc3\xa7a no Tempo'],
 ['BR', '06', 'Aracati'],
 ['BR', '06', 'Ararend\xc3\xa1'],
 ['BR', '06', 'Banabui\xc3\xba'],
 ['BR', '06', 'Croat\xc3\xa1'],
 ['BR', '06', 'Erer\xc3\xaa'],
 ['BR', '06', 'Forquilha'],
 ['BR', '06', 'Gra\xc3\xa7a'],
 ['BR', '06', 'Irau\xc3\xa7uba'],
 ['BR', '06', 'Itaitinga'],
 ['BR', '06', 'Itapi\xc3\xbana'],
 ['BR', '06', 'Jaguaribara'],
 ['BR', '06', 'Madalena'],
 ['BR', '06', 'Milh\xc3\xa3'],
 ['BR', '06', 'Nova Olinda'],
 ['BR', '06', 'Palhano'],
 ['BR', '06', 'Potiretama'],
 ['BR', '06', 'Senador S\xc3\xa1'],
 ['BR', '06', 'Tabuleiro do Norte'],
 ['BR', '06', 'Varjota'],
 ['BR', '17', 'Pianc\xc3\xb3'],
 ['BR', '30', 'Ferreiros'],
 ['BR', '02', 'Cacimbinhas'],
 ['BR', '02', 'Campo Grande'],
 ['BR', '02', 'Cra\xc3\xadbas'],
 ['BR', '02', 'Estrela de Alagoas'],
 ['BR', '02', 'Girau do Ponciano'],
 ['BR', '02', 'Maribondo'],
 ['BR', '02', 'Po\xc3\xa7o das Trincheiras'],
 ['BR', '02', 'S\xc3\xa3o Jos\xc3\xa9 da Tapera'],
 ['BR', '02', 'Senador Rui Palmeira'],
 ['BR', '28', 'Feira Nova'],
 ['BR', '28', 'Gracho Cardoso'],
 ['BR', '28', 'Japoat\xc3\xa3'],
 ['BR', '28', 'Pedra Mole'],
 ['BR', '28', 'S\xc3\xa3o Domingos'],
 ['BR', '28', 'S\xc3\xa3o Miguel do Aleixo'],
 ['BR', '05', 'Aramari'],
 ['BR', '05', 'Chorroch\xc3\xb3'],
 ['BR', '05', 'Itapicuru'],
 ['BR', '05', 'Macurur\xc3\xa9'],
 ['BR', '05', 'Paulo Afonso'],
 ['BR', '05', 'Rio Real'],
 ['BR', '05', 'Rodelas'],
 ['BR', '15', 'Belmiro Braga'],
 ['BR', '15', 'Monte Si\xc3\xa3o'],
 ['BR', '21', 'Cantagalo'],
 ['BR', '27', 'Anhumas'],
 ['BR', '27', 'Campinas'],
 ['BR', '27', 'Coroados'],
 ['BR', '27', 'Corumbata\xc3\xad'],
 ['BR', '27', 'Cosmorama'],
 ['BR', '27', 'Franca'],
 ['BR', '27', 'Gar\xc3\xa7a'],
 ['BR', '27', 'Itapira'],
 ['BR', '27', 'Jardin\xc3\xb3polis'],
 ['BR', '27', 'Jarinu'],
 ['BR', '27', 'Luc\xc3\xa9lia'],
 ['BR', '27', 'Mogi Gua\xc3\xa7u'],
 ['BR', '27', 'Nova Odessa'],
 ['BR', '27', 'Paulist\xc3\xa2nia'],
 ['BR', '27', 'Pedreira'],
 ['BR', '27', 'Pen\xc3\xa1polis'],
 ['BR', '27', 'Piracicaba'],
 ['BR', '27', 'Pirapozinho'],
 ['BR', '27', 'Piratininga'],
 ['BR', '27', 'Pontes Gestal'],
 ['BR', '27', 'Praia Grande'],
 ['BR', '27', 'Presidente Bernardes'],
 ['BR', '27', 'Presidente Prudente'],
 ['BR', '27', 'Riol\xc3\xa2ndia'],
 ['BR', '27', 'Santa Cruz da Concei\xc3\xa7\xc3\xa3o'],
 ['BR', '27', 'S\xc3\xa3o Bernardo do Campo'],
 ['BR', '27', 'S\xc3\xa3o Jo\xc3\xa3o da Boa Vista'],
 ['BR', '27', 'S\xc3\xa3o Paulo'],
 ['BR', '27', 'Vera Cruz'],
 ['BR', '27', 'Votuporanga'],
 ['BR', '26', 'Tijucas'],
 ['BR', '23', 'Arroio Grande'],
 ['BR', '23', 'Cangu\xc3\xa7u'],
 ['BR', '23', 'Carlos Barbosa'],
 ['BR', '23', 'Novo Hamburgo'],
 ['BR', '14', 'Carlinda'],
 ['BR', '14', 'Novo Mundo'],
 ['BR', '14', 'Santa Terezinha'],
 ['BR', '23', 'Almirante Tamandar\xc3\xa9 do Sul'],
 ['BR', '23', 'Cap\xc3\xa3o Bonito do Sul'],
 ['BR', '28', 'S\xc3\xa3o Francisco'],
 ['BR', '06', 'Acopiara'],
 ['BR', '14', 'Ipiranga do Norte'],
 ['BR', '14', 'Itanhang\xc3\xa1'],
 ['BR', '30', 'Buenos Aires'],
 ['BR', '20', 'Aroeiras do Itaim'],
 ['BR', '20', 'Naz\xc3\xa1ria'],
 ['BT', '00', 'Tashigang'],
 ['BT', '22', 'Dangchu'],
 ['BT', '08', 'Tsangkha'],
 ['BT', '08', 'Lajab'],
 ['BT', '08', 'Drukgyegang'],
 ['BT', '14', 'Khar'],
 ['BT', '14', 'Chongshing'],
 ['BT', '14', 'Yurung'],
 ['BT', '19', 'Radi'],
 ['BT', '18', 'Nangkor'],
 ['BT', '06', 'Phuentsholing'],
 ['BT', '06', 'Bongo'],
 ['BT', '18', 'Goshing'],
 ['BT', '18', 'Bardo'],
 ['BT', '19', 'Lumang'],
 ['BT', '19', 'Thrimshing'],
 ['BT', '06', 'Chabchha'],
 ['BT', '08', 'Khiphisa'],
 ['BT', '21', 'Nubi'],
 ['BT', '21', 'Bjakteng'],
 ['BT', '07', 'Kikhorthang'],
 ['BT', '07', 'Beteni'],
 ['BT', '22', 'Ruepaisa'],
 ['BT', '22', 'Nahi'],
 ['BT', '18', 'Trong'],
 ['BT', '13', 'Mewang'],
 ['BW', '09', 'Gaborone'],
 ['BW', '05', 'Kgatleng'],
 ['BW', '01', 'Mahalapye'],
 ['BW', '01', 'Machaneng'],
 ['BW', '01', 'Serowe'],
 ['BW', '01', 'Palapye'],
 ['BY', '02', 'Zhlobinski Rayon'],
 ['BY', '02', 'Zhytkavitski Rayon'],
 ['BY', '01', 'Zhabinkawski Rayon'],
 ['BY', '03', 'Zel\xe2\x80\x99vyenski Rayon'],
 ['BY', '04', 'Zavodski Rayon'],
 ['BY', '02', 'Yel\xe2\x80\x99ski Rayon'],
 ['BY', '03', 'Voranawski Rayon'],
 ['BY', '05', 'Valozhynski Rayon'],
 ['BY', '03', 'Vawkavyski Rayon'],
 ['BY', '07', 'Vitsyebski Rayon'],
 ['BY', '05', 'Vilyeyski Rayon'],
 ['BY', '02', 'Vyetkawski Rayon'],
 ['BY', '07', 'Vyerkhnyadzvinski Rayon'],
 ['BY', '05', 'Uzdzyenski Rayon'],
 ['BY', '07', 'Ushatski Rayon'],
 ['BY', '04', 'Tsentral\xe2\x80\x99ny Rayon'],
 ['BY', '07', 'Talachynski Rayon'],
 ['BY', '03', 'Svislatski Rayon'],
 ['BY', '02', 'Svyetlahorski Rayon'],
 ['BY', '01', 'Stolinski Rayon'],
 ['BY', '05', 'Stawbtsowski Rayon'],
 ['BY', '05', 'Staradarozhski Rayon'],
 ['BY', '04', 'Savyetski Rayon'],
 ['BY', '05', 'Salihorski Rayon'],
 ['BY', '03', 'Smarhonski Rayon'],
 ['BY', '05', 'Smalyavitski Rayon'],
 ['BY', '05', 'Slutski Rayon'],
 ['BY', '03', 'Slonimski Rayon'],
 ['BY', '06', 'Slawharadski Rayon'],
 ['BY', '07', 'Shumilinski Rayon'],
 ['BY', '06', 'Shklowski Rayon'],
 ['BY', '03', 'Shchuchynski Rayon'],
 ['BY', '07', 'Sharkawshchynski Rayon'],
 ['BY', '07', 'Syennyenski Rayon'],
 ['BY', '07', 'Rasonski Rayon'],
 ['BY', '02', 'Rahachowski Rayon'],
 ['BY', '02', 'Rechytski Rayon'],
 ['BY', '05', 'Pukhavitski Rayon'],
 ['BY', '01', 'Pruzhanski Rayon'],
 ['BY', '07', 'Pastawski Rayon'],
 ['BY', '07', 'Polatski Rayon'],
 ['BY', '01', 'Pinski Rayon'],
 ['BY', '02', 'Pyetrykawski Rayon'],
 ['BY', '04', 'Pyershamayski Rayon'],
 ['BY', '04', 'Partyzanski Rayon'],
 ['BY', '03', 'Astravyetski Rayon'],
 ['BY', '06', 'Asipovitski Rayon'],
 ['BY', '03', 'Ashmyanski Rayon'],
 ['BY', '07', 'Arshanski Rayon'],
 ['BY', '04', 'Kastrychnitski Rayon'],
 ['BY', '02', 'Aktsyabrski Rayon'],
 ['BY', '03', 'Navahrudski Rayon'],
 ['BY', '05', 'Nyasvizhski Rayon'],
 ['BY', '02', 'Narawlyanski Rayon'],
 ['BY', '05', 'Myadzyel\xe2\x80\x99ski Rayon'],
 ['BY', '06', 'Mstsislawski Rayon'],
 ['BY', '02', 'Mazyrski Rayon'],
 ['BY', '03', 'Mastowski Rayon'],
 ['BY', '04', 'Maskowski Rayon'],
 ['BY', '05', 'Maladzyechanski Rayon'],
 ['BY', '06', 'Mahilyowski Rayon'],
 ['BY', '07', 'Myorski Rayon'],
 ['BY', '05', 'Minski Rayon'],
 ['BY', '01', 'Malarytski Rayon'],
 ['BY', '05', 'Lyubanski Rayon'],
 ['BY', '01', 'Lyakhavitski Rayon'],
 ['BY', '01', 'Luninyetski Rayon'],
 ['BY', '02', 'Loyewski Rayon'],
 ['BY', '05', 'Lahoyski Rayon'],
 ['BY', '07', 'Lyoznyenski Rayon'],
 ['BY', '03', 'Lidski Rayon'],
 ['BY', '07', 'Lyepyel\xe2\x80\x99ski Rayon'],
 ['BY', '04', 'Lyeninski Rayon'],
 ['BY', '02', 'Lyel\xe2\x80\x99chytski Rayon'],
 ['BY', '05', 'Krupski Rayon'],
 ['BY', '06', 'Kruhlyanski Rayon'],
 ['BY', '06', 'Krychawski Rayon'],
 ['BY', '06', 'Krasnapol\xe2\x80\x99ski Rayon'],
 ['BY', '06', 'Kastsyukovitski Rayon'],
 ['BY', '02', 'Karmyanski Rayon'],
 ['BY', '03', 'Karelitski Rayon'],
 ['BY', '05', 'Kapyl\xe2\x80\x99ski Rayon'],
 ['BY', '01', 'Kobrynski Rayon'],
 ['BY', '06', 'Klimavitski Rayon'],
 ['BY', '06', 'Klichawski Rayon'],
 ['BY', '05', 'Klyetski Rayon'],
 ['BY', '06', 'Kirawski Rayon'],
 ['BY', '02', 'Khoynitski Rayon'],
 ['BY', '06', 'Khotsimski Rayon'],
 ['BY', '01', 'Kamyanyetski Rayon'],
 ['BY', '02', 'Kalinkavitski Rayon'],
 ['BY', '03', 'Iwyewski Rayon'],
 ['BY', '01', 'Ivatsevitski Rayon'],
 ['BY', '01', 'Ivanawski Rayon'],
 ['BY', '03', 'Hrodzyenski Rayon'],
 ['BY', '07', 'Haradotski Rayon'],
 ['BY', '06', 'Horatski Rayon'],
 ['BY', '02', 'Homyel\xe2\x80\x99ski Rayon'],
 ['BY', '06', 'Hluski Rayon'],
 ['BY', '07', 'Hlybotski Rayon'],
 ['BY', '01', 'Hantsavitski Rayon'],
 ['BY', '04', 'Frunzyenski Rayon'],
 ['BY', '05', 'Dzyarzhynski Rayon'],
 ['BY', '03', 'Dzyatlawski Rayon'],
 ['BY', '07', 'Dubrovyenski Rayon'],
 ['BY', '01', 'Drahichynski Rayon'],
 ['BY', '07', 'Dokshytski Rayon'],
 ['BY', '02', 'Dobrushski Rayon'],
 ['BY', '05', 'Chervyen\xe2\x80\x99ski Rayon'],
 ['BY', '06', 'Cherykawski Rayon'],
 ['BY', '02', 'Chacherski Rayon'],
 ['BY', '06', 'Chavuski Rayon'],
 ['BY', '07', 'Chashnitski Rayon'],
 ['BY', '06', 'Bykhawski Rayon'],
 ['BY', '02', 'Buda-Kashalyowski Rayon'],
 ['BY', '01', 'Brestski Rayon'],
 ['BY', '07', 'Braslawski Rayon'],
 ['BY', '02', 'Brahinski Rayon'],
 ['BY', '05', 'Barysawski Rayon'],
 ['BY', '06', 'Babruyski Rayon'],
 ['BY', '07', 'Byeshankovitski Rayon'],
 ['BY', '01', 'Byarozawski Rayon'],
 ['BY', '05', 'Byarezinski Rayon'],
 ['BY', '03', 'Byerastavitski Rayon'],
 ['BY', '06', 'Byalynitski Rayon'],
 ['BY', '01', 'Baranavitski Rayon'],
 ['BY', '06', 'Drybinski Rayon'],
 ['BY', '03', 'Horad Hrodna'],
 ['BY', '02', 'Uvarovichskiy Rayon'],
 ['BY', '01', 'Horad Brest'],
 ['BY', '01', 'Horad Baranavichy'],
 ['BY', '07', 'Horad Vitsyebsk'],
 ['BY', '07', 'Horad Lyepyel\xe2\x80\x99'],
 ['BY', '07', 'Horad Navapolatsk'],
 ['BY', '07', 'Horad Polatsk'],
 ['BY', '02', 'Horad Homyel\xe2\x80\x99'],
 ['BY', '02', 'Horad Dobrush'],
 ['BY', '02', 'Horad Zhlobin'],
 ['BY', '02', 'Horad Kalinkavichy'],
 ['BY', '02', 'Horad Mazyr'],
 ['BY', '02', 'Horad Rahachow'],
 ['BY', '02', 'Horad Svyetlahorsk'],
 ['BY', '03', 'Horad Vawkavysk'],
 ['BY', '03', 'Horad Lida'],
 ['BY', '03', 'Horad Navahrudak'],
 ['BY', '03', 'Horad Slonim'],
 ['BY', '03', 'Horad Smarhon\xe2\x80\x99'],
 ['BY', '05', 'Horad Barysaw'],
 ['BY', '05', 'Horad Vilyeyka'],
 ['BY', '05', 'Horad Dzyarzhynsk'],
 ['BY', '05', 'Horad Zaslawye'],
 ['BY', '05', 'Horad Maladzyechna'],
 ['BY', '05', 'Horad Slutsk'],
 ['BY', '05', 'Horad Salihorsk'],
 ['BY', '06', 'Mahilyow'],
 ['BY', '06', 'Babruysk Rayon'],
 ['BY', '06', 'Horad Asipovichy'],
 ['BY', '00', "Molodechnenskaya Oblast'"],
 ['BY', '', 'Puhovichi'],
 ['BY', '', 'Kirovsk'],
 ['BZ', '04', 'Hopelch\xc3\xa9n'],
 ['CA', '10', 'Abitibi-T\xc3\xa9miscamingue'],
 ['CA', '10', 'C\xc3\xb4te-Nord'],
 ['CA', '10', 'Estrie'],
 ['CA', '10', 'Lanaudi\xc3\xa8re'],
 ['CA', '10', 'Laurentides'],
 ['CA', '10', 'Laval'],
 ['CA', '10', 'Mauricie'],
 ['CA', '08', 'Milton'],
 ['CA', '10', 'Mont\xc3\xa9r\xc3\xa9gie'],
 ['CA', '10', 'Montr\xc3\xa9al'],
 ['CA', '10', 'Outaouais'],
 ['CA', '08', 'Peterborough County'],
 ['CA', '10', 'Saguenay/Lac-Saint-Jean'],
 ['CA', '10', 'Bas-Saint-Laurent'],
 ['CA', '10', 'Capitale-Nationale'],
 ['CA', '10', 'Nord-du-Qu\xc3\xa9bec'],
 ['CA', '10', 'Gasp\xc3\xa9sie-\xc3\x8eles-de-la-Madeleine'],
 ['CA', '10', 'Chaudi\xc3\xa8re-Appalaches'],
 ['CA', '08', 'Toronto county'],
 ['CD', '02', 'Tshuapa'],
 ['CD', '09', 'Tshopo'],
 ['CD', '05', 'Tanganika'],
 ['CD', '04', 'Sankuru'],
 ['CD', '02', 'Mongala'],
 ['CD', '00', 'Mbuji-Mayi City'],
 ['CD', '03', 'Lulua District'],
 ['CD', '00', 'Ville de Kisangani'],
 ['CD', '00', 'Sous-R\xc3\xa9gion du Kasai'],
 ['CD', '04', 'Kabinda'],
 ['CD', '09', 'Ituri'],
 ['CD', '09', 'Haut Uele'],
 ['CD', '05', 'Sous-R\xc3\xa9gion du Haut-Lomani'],
 ['CD', '09', 'Bas Uele'],
 ['CD', '05', 'Lualaba'],
 ['CD', '00', 'Kolwezi City'],
 ['CD', '00', 'Sous-R\xc3\xa9gion du Haut-Shaba'],
 ['CD', '00', 'Ville de Zongo'],
 ['CD', '00', 'Ville de Mbandaka'],
 ['CD', '01', 'Mai Ndombe'],
 ['CD', '01', 'Kwilu'],
 ['CD', '01', 'Kwango District'],
 ['CD', '02', 'Equateur'],
 ['CD', '00', 'Sous-R\xc3\xa9gion des Catarates'],
 ['CD', '00', 'Ville de Boma'],
 ['CD', '00', 'Sous-R\xc3\xa9gion du Bas-Fleuve'],
 ['CD', '05', 'Haut Lomami'],
 ['CD', '05', 'Haut Katanga'],
 ['CD', '03', 'Kasai District'],
 ['CD', '02', 'Nord Ubangi'],
 ['CD', '02', 'Sud Ubangi'],
 ['CD', '01', 'Plateaux'],
 ['CD', '08', 'Lukaya'],
 ['CD', '08', 'Cataractes District'],
 ['CD', '08', 'Bas Fleuve District'],
 ['CD', '08', 'Matadi (city)'],
 ['CD', '08', 'Boma (city)'],
 ['CD', '09', 'Tumba'],
 ['CD', '05', 'Kolwezi'],
 ['CD', '11', 'North Kivu'],
 ['CD', '10', 'Maniema'],
 ['CD', '04', 'Tshilenge District'],
 ['CD', '12', 'South Kivu'],
 ['CD', '06', 'Kinshasa rural'],
 ['CD', '06', 'Kinshasa Urban'],
 ['CD', '03', 'Kananga City'],
 ['CD', '03', 'Tshikapa City'],
 ['CF', '00', 'Sous-Pr\xc3\xa9fecture de Carnot'],
 ['CF', '00', 'Baboua Sub-Prefecture'],
 ['CF', '08', 'Ouango'],
 ['CF', '08', 'Gambo'],
 ['CF', '02', 'Kembe'],
 ['CF', '02', 'Mobaye'],
 ['CF', '02', 'Zangba'],
 ['CF', '11', 'Kouango'],
 ['CF', '06', 'Ndjoukou'],
 ['CF', '17', 'Damara'],
 ['CF', '17', 'Bimbo Sub-Prefecture'],
 ['CF', '17', 'Bangui Sub-Prefecture'],
 ['CF', '07', 'Mongoumba'],
 ['CF', '16', 'Nola'],
 ['CF', '16', 'Bayanga'],
 ['CF', '11', 'Bambari'],
 ['CF', '08', 'Bangassou'],
 ['CF', '02', 'Alindao'],
 ['CF', '11', 'Ippy'],
 ['CF', '07', 'Mbaiki'],
 ['CF', '02', 'Mingala'],
 ['CF', '09', 'Bouar Sub-Prefecture'],
 ['CF', '09', 'Baoro Sub-Prefecture'],
 ['CF', '12', 'Bossangoa'],
 ['CF', '17', 'Yaloke Sub-Prefecture'],
 ['CF', '11', 'Grimari'],
 ['CF', '06', 'Sibut'],
 ['CF', '04', 'Berberati'],
 ['CF', '08', 'Bakouma'],
 ['CF', '17', 'Bossembele Sub-Prefecture'],
 ['CF', '04', 'Gamboula'],
 ['CF', '04', 'Gadzi'],
 ['CF', '17', 'Boali Sub-Prefecture'],
 ['CF', '13', 'Bozoum Sub-Prefecture'],
 ['CG', '11', 'Mindouli'],
 ['CG', '11', 'Mayama'],
 ['CG', '10', 'Souanke'],
 ['CG', '10', 'Sembe'],
 ['CG', '10', 'Ouesso'],
 ['CG', '06', 'Dongou'],
 ['CG', '06', 'Impfondo'],
 ['CG', '13', 'Loukela'],
 ['CG', '13', 'Mossaka'],
 ['CG', '08', 'Gamboma'],
 ['CG', '08', 'Djambala'],
 ['CG', '11', 'Ngabe'],
 ['CG', '11', 'Ngamaba (brazzaville)'],
 ['CG', '11', 'Kinkala'],
 ['CG', '11', 'Boko'],
 ['CG', '13', 'Boundji'],
 ['CG', '13', 'Loukolela'],
 ['CG', '13', 'Makoua'],
 ['CG', '13', 'Owando'],
 ['CG', '04', 'Madingo-Kayes'],
 ['CG', '04', 'Kakamoeka'],
 ['CG', '04', 'Mvouti'],
 ['CG', '05', 'Bambama'],
 ['CG', '05', 'Komono'],
 ['CG', '05', 'Sibiti'],
 ['CG', '05', 'Zanaga'],
 ['CG', '07', 'Divenie'],
 ['CG', '07', 'Kibangou'],
 ['CG', '07', 'Kimongo'],
 ['CG', '07', 'Louvakou'],
 ['CG', '07', 'Mayoko'],
 ['CG', '07', 'Mossendjo'],
 ['CG', '08', 'Abala'],
 ['CG', '08', 'Lekana'],
 ['CG', '11', 'Kindamba'],
 ['CG', '13', 'Okoyo'],
 ['CG', '01', 'Mouyondzi'],
 ['CG', '01', 'Madingou'],
 ['CG', '01', 'Nkayi'],
 ['CG', '01', 'Loudima'],
 ['CG', '04', 'Pointe-Noire'],
 ['CH', 'TI', 'Vallemaggia'],
 ['CH', 'SO', 'Bezirk Thierstein'],
 ['CH', 'SG', 'Wahlkreis Sargans'],
 ['CH', 'VS', 'Bezirk Raron'],
 ['CH', 'ZH', 'Bezirk Meilen'],
 ['CH', 'VS', 'Martigny'],
 ['CH', 'FR', 'District de la Gl\xc3\xa2ne'],
 ['CH', 'ZH', 'Bezirk Andelfingen'],
 ['CH', 'SO', 'Bezirk G\xc3\xa4u'],
 ['CH', 'AI', 'Appenzell I.Rh.'],
 ['CH', 'JU', 'District de Del\xc3\xa9mont'],
 ['CH', 'VS', 'District de Sion'],
 ['CH', 'AG', 'Bezirk Zofingen'],
 ['CH', 'GL', 'Glarus'],
 ['CH', 'BL', 'Bezirk Waldenburg'],
 ['CH', 'TI', 'Distretto di Locarno'],
 ['CH', 'ZH', 'Bezirk Uster'],
 ['CH', 'VS', 'Bezirk Leuk'],
 ['CH', 'FR', 'District de la Broye'],
 ['CH', 'TI', 'Distretto di Riviera'],
 ['CH', 'GR', 'Bezirk Hinterrhein'],
 ['CH', 'ZH', 'Bezirk Dietikon'],
 ['CH', 'LU', 'Amt Hochdorf'],
 ['CH', 'NW', 'Nidwalden'],
 ['CH', 'BS', 'Basel-Stadt'],
 ['CH', 'VS', 'Bezirk Goms'],
 ['CH', 'FR', 'District de la Sarine'],
 ['CH', 'VS', "District d'Entremont"],
 ['CH', 'SH', 'Bezirk Schleitheim'],
 ['CH', 'SG', 'Wahlkreis St. Gallen'],
 ['CH', 'TI', 'Distretto di Lugano'],
 ['CH', 'AG', 'Bezirk Kulm'],
 ['CH', 'AG', 'Bezirk Bremgarten'],
 ['CH', 'SZ', 'Bezirk Schwyz'],
 ['CH', 'JU', 'District de Porrentruy'],
 ['CH', 'SO', 'Bezirk Solothurn'],
 ['CH', 'SZ', 'Bezirk March'],
 ['CH', 'GE', 'Geneva'],
 ['CH', 'TI', 'Distretto di Blenio'],
 ['CH', 'AG', 'Bezirk Zurzach'],
 ['CH', 'JU', 'District des Franches-Montagnes'],
 ['CH', 'SH', 'Bezirk Stein'],
 ['CH', 'VS', 'District de Sierre'],
 ['CH', 'FR', 'District de la Gruy\xc3\xa8re'],
 ['CH', 'ZH', 'Bezirk Hinwil'],
 ['CH', 'ZH', 'Bezirk Z\xc3\xbcrich'],
 ['CH', 'UR', 'Uri'],
 ['CH', 'AG', 'Bezirk Lenzburg'],
 ['CH', 'ZG', 'Zug'],
 ['CH', 'ZH', 'Bezirk Winterthur'],
 ['CH', 'NE', 'District du Locle'],
 ['CH', 'SZ', 'Bezirk Gersau'],
 ['CH', 'NE', 'District du Val-de-Ruz'],
 ['CH', 'AG', 'Bezirk Baden'],
 ['CH', 'SH', 'Bezirk Oberklettgau'],
 ['CH', 'OW', 'Obwalden'],
 ['CH', 'ZH', 'Bezirk Affoltern'],
 ['CH', 'FR', 'Bezirk See/District du Lac'],
 ['CH', 'VS', 'Bezirk Brig'],
 ['CH', 'BL', 'Bezirk Sissach'],
 ['CH', 'NE', 'District de Boudry'],
 ['CH', 'AG', 'Bezirk Brugg'],
 ['CH', 'GR', 'Bezirk Albula'],
 ['CH', 'LU', 'Amt Willisau'],
 ['CH', 'SO', 'Bezirk Lebern'],
 ['CH', 'AR', 'Bezirk Mittelland'],
 ['CH', 'NE', 'District de la Chaux-de-Fonds'],
 ['CH', 'VS', 'District de Saint-Maurice'],
 ['CH', 'BL', 'Bezirk Laufen'],
 ['CH', 'NE', 'District du Val-de-Travers'],
 ['CH', 'SH', 'Bezirk Unterklettgau'],
 ['CH', 'AR', 'Bezirk Hinterland'],
 ['CH', 'SG', 'Wahlkreis Rorschach'],
 ['CH', 'SZ', 'Bezirk K\xc3\xbcssnacht'],
 ['CH', 'SG', 'Wahlkreis Wil'],
 ['CH', 'SO', 'Bezirk Bucheggberg'],
 ['CH', 'BL', 'Bezirk Arlesheim'],
 ['CH', 'VS', 'Bezirk Visp'],
 ['CH', 'VS', 'District de Monthey'],
 ['CH', 'AG', 'Bezirk Aarau'],
 ['CH', 'ZH', 'Bezirk Horgen'],
 ['CH', 'SZ', 'Bezirk H\xc3\xb6fe'],
 ['CH', 'VS', 'District de Conthey'],
 ['CH', 'GR', 'Distretto di Bernina'],
 ['CH', 'ZH', 'Bezirk Pf\xc3\xa4ffikon'],
 ['CH', 'AG', 'Bezirk Rheinfelden'],
 ['CH', 'BL', 'Bezirk Liestal'],
 ['CH', 'VD', 'District de Morges'],
 ['CH', 'GR', 'Bezirk Inn'],
 ['CH', 'AG', 'Bezirk Laufenburg'],
 ['CH', 'FR', 'District de la Veveyse'],
 ['CH', 'AR', 'Bezirk Vorderland'],
 ['CH', 'ZH', 'Bezirk Dielsdorf'],
 ['CH', 'VD', 'District de Lausanne'],
 ['CH', 'ZH', 'Bezirk B\xc3\xbclach'],
 ['CH', 'SO', 'Bezirk Thal'],
 ['CH', 'TI', 'Distretto di Bellinzona'],
 ['CH', 'VS', "District d'H\xc3\xa9rens"],
 ['CH', 'SO', 'Bezirk G\xc3\xb6sgen'],
 ['CH', 'LU', 'Amt Luzern'],
 ['CH', 'LU', 'Amt Sursee'],
 ['CH', 'SZ', 'Bezirk Einsiedeln'],
 ['CH', 'SG', 'Wahlkreis Werdenberg'],
 ['CH', 'SH', 'Bezirk Schaffhausen'],
 ['CH', 'SH', 'Bezirk Reiat'],
 ['CH', 'GR', 'Bezirk Plessur'],
 ['CH', 'SO', 'Bezirk Wasseramt'],
 ['CH', 'NE', 'District de Neuch\xc3\xa2tel'],
 ['CH', 'SO', 'Bezirk Olten'],
 ['CH', 'TI', 'Distretto di Mendrisio'],
 ['CH', 'VD', "District d'Aigle"],
 ['CH', 'FR', 'Bezirk Sense'],
 ['CH', 'LU', 'Amt Entlebuch'],
 ['CH', 'AG', 'Bezirk Muri'],
 ['CH', 'TI', 'Distretto di Leventina'],
 ['CH', 'SO', 'Bezirk Dorneck'],
 ['CH', 'GR', 'Bezirk Imboden'],
 ['CH', 'GR', 'Bezirk Landquart'],
 ['CH', 'GR', 'Bezirk Maloja / Distretto di Maloggia'],
 ['CH', 'GR', 'Distretto di Moesa'],
 ['CH', 'GR', 'Bezirk Surselva'],
 ['CH', 'SG', 'Wahlkreis Rheintal'],
 ['CH', 'SG', 'Wahlkreis Toggenburg'],
 ['CH', 'VD', 'District de la Broye-Vully'],
 ['CH', 'VD', 'District du Gros-de-Vaud'],
 ['CH', 'VD', 'District du Jura-Nord vaudois'],
 ['CH', 'VD', 'District de Lavaux-Oron'],
 ['CH', 'VD', 'District de Nyon'],
 ['CH', 'VD', "District de l'Ouest lausannois"],
 ['CH', 'VD', "District de la Riviera-Pays-d'Enhaut"],
 ['CH', 'SG', 'Wahlkreis See-Gaster'],
 ['CH', 'GR', 'Bezirk Pr\xc3\xa4ttigau-Davos'],
 ['CH', 'BE', 'Emmental'],
 ['CH', 'BE', 'Obersimmental-Saanen'],
 ['CH', 'BE', 'Frutigen-Niedersimmental'],
 ['CH', 'BE', 'Biel/Bienne'],
 ['CH', 'BE', 'Seeland'],
 ['CH', 'BE', 'Thun'],
 ['CH', 'BE', 'Interlaken-Oberhasli'],
 ['CH', 'BE', 'Jura bernois'],
 ['CH', 'BE', 'Oberargau'],
 ['CH', 'BE', 'Bern-Mittleland'],
 ['CH', 'TG', 'Frauenfeld'],
 ['CH', 'TG', 'Arbon'],
 ['CH', 'TG', 'M\xc3\xbcnchwilen'],
 ['CH', 'TG', 'Kreuzlingen'],
 ['CH', 'TG', 'Weinfelden'],
 ['CI', '83', 'D\xc3\xa9partement de Zu\xc3\xa9noula'],
 ['CI', '81', 'D\xc3\xa9partement de Yamoussoukro'],
 ['CI', '80', 'D\xc3\xa9partement de Vavoua'],
 ['CI', '81', 'D\xc3\xa9partement de Toumodi'],
 ['CI', '75', 'D\xc3\xa9partement de Touba'],
 ['CI', '87', 'D\xc3\xa9partement de Tingr\xc3\xa9la'],
 ['CI', '82', 'D\xc3\xa9partement de Tiassal\xc3\xa9'],
 ['CI', '92', 'D\xc3\xa9partement de Tanda'],
 ['CI', '76', 'D\xc3\xa9partement de Tabou'],
 ['CI', '76', 'D\xc3\xa9partement de Soubr\xc3\xa9'],
 ['CI', '83', 'D\xc3\xa9partement de Sinfra'],
 ['CI', '77', 'Sous-pr\xc3\xa9fecture de S\xc3\xa9gu\xc3\xa9lon'],
 ['CI', '91', 'D\xc3\xa9partement de S\xc3\xa9gu\xc3\xa9la'],
 ['CI', '76', 'D\xc3\xa9partement de Sassandra'],
 ['CI', '76', 'D\xc3\xa9partement de San-P\xc3\xa9dro'],
 ['CI', '90', 'D\xc3\xa9partement de Sakassou'],
 ['CI', '79', 'D\xc3\xa9partement de Oum\xc3\xa9'],
 ['CI', '77', 'D\xc3\xa9partement d\xe2\x80\x99 Odienn\xc3\xa9'],
 ['CI', '86', 'D\xc3\xa9partement de M\xe2\x80\x99bahiakro'],
 ['CI', '91', 'D\xc3\xa9partement de Mankono'],
 ['CI', '78', 'D\xc3\xa9partement de Man'],
 ['CI', '88', 'D\xc3\xa9partement de Lakota'],
 ['CI', '87', 'D\xc3\xa9partement de Korhogo'],
 ['CI', '90', 'D\xc3\xa9partement de Katiola'],
 ['CI', '80', 'D\xc3\xa9partement de Issia'],
 ['CI', '84', 'D\xc3\xa9partement de Guiglo'],
 ['CI', '82', 'D\xc3\xa9partement de Grand-Lahou'],
 ['CI', '79', 'D\xc3\xa9partement de Gagnoa'],
 ['CI', '87', 'D\xc3\xa9partement de Ferkess\xc3\xa9dougou'],
 ['CI', '84', 'D\xc3\xa9partement de Du\xc3\xa9kou\xc3\xa9'],
 ['CI', '88', 'D\xc3\xa9partement de Divo'],
 ['CI', '86', 'D\xc3\xa9partement de Dimbokro'],
 ['CI', '86', 'D\xc3\xa9partement de Daoukro'],
 ['CI', '78', 'D\xc3\xa9partement de Danan\xc3\xa9'],
 ['CI', '80', 'D\xc3\xa9partement de Daloa'],
 ['CI', '90', 'D\xc3\xa9partement de Dabakala'],
 ['CI', '87', 'D\xc3\xa9partement de Boundiali'],
 ['CI', '92', 'D\xc3\xa9partement de Bouna'],
 ['CI', '90', 'D\xc3\xa9partement de Bouak\xc3\xa9'],
 ['CI', '83', 'D\xc3\xa9partement de Bouafl\xc3\xa9'],
 ['CI', '86', 'D\xc3\xa9partement de Bongouanou'],
 ['CI', '92', 'D\xc3\xa9partement de Bondoukou'],
 ['CI', '78', 'D\xc3\xa9partement de Biankouma'],
 ['CI', '90', 'D\xc3\xa9partement de B\xc3\xa9oumi'],
 ['CI', '78', 'D\xc3\xa9partement de Bangolo'],
 ['CI', '85', 'D\xc3\xa9partement d\xe2\x80\x99 Agnibil\xc3\xa9krou'],
 ['CI', '74', 'D\xc3\xa9partement d\xe2\x80\x99 Agboville'],
 ['CI', '74', 'D\xc3\xa9partement d\xe2\x80\x99 Adzop\xc3\xa9'],
 ['CI', '89', 'D\xc3\xa9partement d\xe2\x80\x99 Aboisso'],
 ['CI', '82', 'D\xc3\xa9partement d\xe2\x80\x99 Abidjan'],
 ['CI', '85', 'D\xc3\xa9partement d\xe2\x80\x99 Abengourou'],
 ['CI', '89', 'D\xc3\xa9partement d\xe2\x80\x99 Adiak\xc3\xa9'],
 ['CI', '82', 'D\xc3\xa9partement d\xe2\x80\x99 Al\xc3\xa9p\xc3\xa9'],
 ['CI', '86', 'D\xc3\xa9partement de Bocanda'],
 ['CI', '82', 'D\xc3\xa9partement de Dabou'],
 ['CI', '82', 'D\xc3\xa9partement de Grand-Bassam'],
 ['CI', '82', 'D\xc3\xa9partement de Jacqueville'],
 ['CI', '81', 'D\xc3\xa9partement de Ti\xc3\xa9bissou'],
 ['CI', '84', 'D\xc3\xa9partement de Toul\xc3\xa9pleu'],
 ['CL', '01', 'Provincia de Valpara\xc3\xadso'],
 ['CL', '17', 'Provincia de Valdivia'],
 ['CL', '10', 'Provincia de \xc3\x9altima Esperanza'],
 ['CL', '03', 'Provincia de Tocopilla'],
 ['CL', '10', 'Provincia de Tierra del Fuego'],
 ['CL', '11', 'Provincia de Talca'],
 ['CL', '12', 'Provincia de Talagante'],
 ['CL', '12', 'Provincia de Santiago'],
 ['CL', '01', 'Provincia de San Felipe'],
 ['CL', '01', 'San Antonio Province'],
 ['CL', '01', 'Provincia de Quillota'],
 ['CL', '01', 'Petorca Province'],
 ['CL', '14', 'Provincia de Osorno'],
 ['CL', '06', 'Provincia de \xc3\x91uble'],
 ['CL', '12', 'Provincia de Melipilla'],
 ['CL', '04', 'Provincia de Malleco'],
 ['CL', '12', 'Provincia de Maipo'],
 ['CL', '10', 'Provincia de Magallanes'],
 ['CL', '01', 'Provincia de Los Andes'],
 ['CL', '14', 'Provincia de Llanquihue'],
 ['CL', '11', 'Provincia de Linares'],
 ['CL', '07', 'Provincia de Limar\xc3\xad'],
 ['CL', '15', 'Provincia de Iquique'],
 ['CL', '05', 'Provincia de Huasco'],
 ['CL', '02', 'Provincia General Carrera'],
 ['CL', '07', 'Provincia de Elqui'],
 ['CL', '03', 'Provincia de El Loa'],
 ['CL', '11', 'Provincia de Curic\xc3\xb3'],
 ['CL', '05', 'Provincia de Copiap\xc3\xb3'],
 ['CL', '06', 'Provincia de Concepci\xc3\xb3n'],
 ['CL', '08', 'Provincia de Colchagua'],
 ['CL', '07', 'Provincia de Choapa'],
 ['CL', '14', 'Provincia de Chilo\xc3\xa9'],
 ['CL', '05', 'Provincia de Cha\xc3\xb1aral'],
 ['CL', '04', 'Provincia de Caut\xc3\xadn'],
 ['CL', '02', 'Provincia Capit\xc3\xa1n Prat'],
 ['CL', '08', 'Provincia de Cachapoal'],
 ['CL', '06', 'Provincia de Biob\xc3\xado'],
 ['CL', '16', 'Provincia de Arica'],
 ['CL', '06', 'Provincia de Arauco'],
 ['CL', '03', 'Provincia de Antofagasta'],
 ['CL', '02', 'Provincia de Ais\xc3\xa9n'],
 ['CL', '01', 'Provincia de Isla de Pascua'],
 ['CL', '10', 'Provincia Ant\xc3\xa1rtica Chilena'],
 ['CL', '17', 'Provincia del Ranco'],
 ['CL', '16', 'Provincia de Parinacota'],
 ['CL', '15', 'Provincia del Tamarugal'],
 ['CL', '01', 'Provincia de Marga Marga'],
 ['CL', '08', 'Provincia de Cardenal Caro'],
 ['CL', '11', 'Provincia de Cauquenes'],
 ['CL', '14', 'Provincia de Palena'],
 ['CL', '02', 'Provincia de Coyhaique'],
 ['CL', '12', 'Provincia de Cordillera'],
 ['CL', '12', 'Provincia de Chacabuco'],
 ['CM', '05', 'D\xc3\xa9partement du Wouri'],
 ['CM', '05', 'D\xc3\xa9partement de la Sanaga-Maritime'],
 ['CM', '11', 'D\xc3\xa9partement du Nyong-et-Soo'],
 ['CM', '11', 'D\xc3\xa9partement du Nyong-et-Mfoumou'],
 ['CM', '11', 'D\xc3\xa9partement du Nyong-et-K\xc3\xa9ll\xc3\xa9'],
 ['CM', '14', 'D\xc3\xa9partement du Ntem'],
 ['CM', '05', 'D\xc3\xa9partement du Nkam'],
 ['CM', '09', 'Ndian Division'],
 ['CM', '08', 'D\xc3\xa9partement du Nd\xc3\xa9'],
 ['CM', '05', 'D\xc3\xa9partement du Mungo'],
 ['CM', '07', 'Momo Division'],
 ['CM', '08', 'D\xc3\xa9partement de Mifi'],
 ['CM', '07', 'Mezam Division'],
 ['CM', '07', 'Metchum Division'],
 ['CM', '08', 'D\xc3\xa9partement de la M\xc3\xa9noua'],
 ['CM', '09', 'Meme Division'],
 ['CM', '11', 'D\xc3\xa9partement de la M\xc3\xa9fou'],
 ['CM', '11', 'D\xc3\xa9partement du Mbam'],
 ['CM', '12', 'D\xc3\xa9partement du Mayo Dana\xc3\xaf'],
 ['CM', '12', 'D\xc3\xa9partement du Margui-Wandala'],
 ['CM', '09', 'Manyu Division'],
 ['CM', '04', 'D\xc3\xa9partement du Lom-et-Kade\xc3\xaf'],
 ['CM', '04', 'D\xc3\xa9partement du Lom-et-Dj\xc3\xa9rem'],
 ['CM', '12', 'D\xc3\xa9partement du Logone-et-Chari'],
 ['CM', '11', 'D\xc3\xa9partement de la L\xc3\xa9ki\xc3\xa9'],
 ['CM', '14', 'D\xc3\xa9partement de Kribi'],
 ['CM', '04', 'D\xc3\xa9partement de la Kade\xc3\xaf'],
 ['CM', '04', 'Departement du Haut-Nyong'],
 ['CM', '08', 'D\xc3\xa9partement du Haut-Nkam'],
 ['CM', '11', 'D\xc3\xa9partement de la Haute-Sanaga'],
 ['CM', '09', 'Fako Division'],
 ['CM', '07', 'Donga and Mantung Division'],
 ['CM', '14', 'D\xc3\xa9partement du Dja-et-Lobo'],
 ['CM', '12', 'D\xc3\xa9partement du Diamar\xc3\xa9'],
 ['CM', '07', 'Bui Division'],
 ['CM', '04', 'D\xc3\xa9partement de la Boumba-Ngoko'],
 ['CM', '13', 'D\xc3\xa9partement de la B\xc3\xa9nou\xc3\xa9'],
 ['CM', '08', 'D\xc3\xa9partement de Bamoun'],
 ['CM', '08', 'D\xc3\xa9partement de Bamboutos'],
 ['CM', '10', 'D\xc3\xa9partement de l\xe2\x80\x99 Adamaoua'],
 ['CM', '10', 'Djerem'],
 ['CM', '10', 'Faro-et-Deo'],
 ['CM', '10', 'Vina'],
 ['CM', '11', 'Mbam-et-Kim'],
 ['CM', '11', "Nyong-et-So'o"],
 ['CM', '11', 'M\xc3\xa9fou-et-Afamba'],
 ['CM', '11', 'Lekie'],
 ['CM', '14', 'Dja-et-Lobo'],
 ['CM', '12', 'Departement du Mayo-Kani'],
 ['CM', '10', 'Mbere Department'],
 ['CN', '06', 'Yushu Zangzu Zizhizhou'],
 ['CN', '14', 'Rikaze Diqu'],
 ['CN', '14', 'Shannan Diqu'],
 ['CN', '14', 'Qamdo Diqu'],
 ['CN', '14', 'Nyingchi Diqu'],
 ['CN', '29', 'Nujiang Lisuzu Zizhizhou'],
 ['CN', '14', 'Ngari Diqu'],
 ['CN', '14', 'Nagqu Diqu'],
 ['CN', '14', 'Lhasa Shi'],
 ['CN', '13', 'Kizilsu Kirgiz Zizhizhou'],
 ['CN', '13', 'Kaxgar Diqu'],
 ['CN', '15', 'Jiuquan Shi'],
 ['CN', '15', 'Jiayuguan Shi'],
 ['CN', '13', 'Hotan Diqu'],
 ['CN', '06', 'Haixi Mongolzu Zangzu Zizhizhou'],
 ['CN', '06', 'Golog Zangzu Zizhizhou'],
 ['CN', '29', 'D\xc3\xaaq\xc3\xaan Zangzu Zizhizhou'],
 ['CN', '29', 'Dehong Daizu Jingpozu Zizhizhou'],
 ['CN', '29', 'Baoshan Shi'],
 ['CN', '13', 'Urumqi Shi'],
 ['CN', '13', 'Turpan Diqu'],
 ['CN', '13', 'Tacheng Diqu'],
 ['CN', '13', 'Karamay Shi'],
 ['CN', '13', 'Ili Kazak Zizhizhou'],
 ['CN', '13', 'Ili Diqu'],
 ['CN', '13', 'Kumul Diqu'],
 ['CN', '13', 'Changji Huizu Zizhizhou'],
 ['CN', '13', 'Bortala Mongol Zizhizhou'],
 ['CN', '13', 'Bayingolin Mongol Zizhizhou'],
 ['CN', '13', 'Altay Diqu'],
 ['CN', '13', 'Aksu Diqu'],
 ['CN', '18', 'Zunyi Shi'],
 ['CN', '32', 'Zigong Shi'],
 ['CN', '25', 'Zibo Shi'],
 ['CN', '11', 'Zhuzhou Shi'],
 ['CN', '09', 'Zhumadian Shi'],
 ['CN', '30', 'Zhuhai Shi'],
 ['CN', '02', 'Zhoushan Shi'],
 ['CN', '09', 'Zhoukou Shi'],
 ['CN', '30', 'Zhongshan Shi'],
 ['CN', '04', 'Zhenjiang Shi'],
 ['CN', '09', 'Zhengzhou Shi'],
 ['CN', '29', 'Zhaotong Shi'],
 ['CN', '29', 'Zhaotong Diqu'],
 ['CN', '30', 'Zhaoqing Shi'],
 ['CN', '30', 'Zhanjiang Shi'],
 ['CN', '07', 'Zhangzhou Shi'],
 ['CN', '15', 'Zhangye Shi'],
 ['CN', '25', 'Zaozhuang Shi'],
 ['CN', '29', 'Yuxi Shi'],
 ['CN', '30', 'Yunfu Shi'],
 ['CN', '24', 'Yuncheng Shi'],
 ['CN', '26', 'Yulin Shi'],
 ['CN', '16', 'Yulin Diqu'],
 ['CN', '11', 'Yueyang Shi'],
 ['CN', '11', 'Yiyang Shi'],
 ['CN', '21', 'Wuzhong Shi'],
 ['CN', '03', 'Yingtan Shi'],
 ['CN', '21', 'Yinchuan Shi'],
 ['CN', '03', 'Yichun Shi'],
 ['CN', '12', 'Yichangshi'],
 ['CN', '32', 'Yibin Shi'],
 ['CN', '25', 'Yantai Shi'],
 ['CN', '04', 'Yangzhou Shi'],
 ['CN', '24', 'Yangquan Shi'],
 ['CN', '30', 'Yangjiang Shi'],
 ['CN', '04', 'Yancheng Shi'],
 ['CN', '26', 'Yan\xe2\x80\x99an Shi'],
 ['CN', '32', 'Ya\xe2\x80\x99an Shi'],
 ['CN', '04', 'Xuzhou Shi'],
 ['CN', '09', 'Xuchang Shi'],
 ['CN', '01', 'Xuancheng Shi'],
 ['CN', '29', 'Xishuangbanna Daizu Zizhizhou'],
 ['CN', '03', 'Xinyu Shi'],
 ['CN', '09', 'Xinyang Shi'],
 ['CN', '09', 'Xinyang Diqu'],
 ['CN', '09', 'Xinxiang Shi'],
 ['CN', '06', 'Xining Shi'],
 ['CN', '10', 'Xingtai Shi'],
 ['CN', '12', 'Xiaogan Shi'],
 ['CN', '26', 'Xianyang Shi'],
 ['CN', '26', 'Xi\xe2\x80\x99an Shi'],
 ['CN', '12', 'Xianning Shi'],
 ['CN', '11', 'Xiangxi Tujiazu Miaozu Zizhizhou'],
 ['CN', '11', 'Xiangtan Shi'],
 ['CN', '12', 'Xiangfan Shi'],
 ['CN', '07', 'Xiamen Shi'],
 ['CN', '16', 'Wuzhou Shi'],
 ['CN', '04', 'Wuxi Shi'],
 ['CN', '15', 'Wuwei Shi'],
 ['CN', '23', 'Wusong Qu'],
 ['CN', '01', 'Wuhu Shi'],
 ['CN', '12', 'Wuhan Shi'],
 ['CN', '20', 'Wuhai Shi'],
 ['CN', '02', 'Wenzhou Shi'],
 ['CN', '29', 'Wenshan Zhuangzu Miaozu Zizhizhou'],
 ['CN', '26', 'Weinan Shi'],
 ['CN', '25', 'Weihai Shi'],
 ['CN', '25', 'Weifang Shi'],
 ['CN', '18', 'Tongren Diqu'],
 ['CN', '01', 'Tongling Shi'],
 ['CN', '26', 'Tongchuan Shi'],
 ['CN', '15', 'Tianshui Shi'],
 ['CN', '10', 'Tangshan Shi'],
 ['CN', '04', 'Taizhou Shi'],
 ['CN', '02', 'Taizhou Shi'],
 ['CN', '24', 'Taiyuan Shi'],
 ['CN', '25', 'Tai\xe2\x80\x99an Shi'],
 ['CN', '01', 'Suzhou Shi'],
 ['CN', '04', 'Suqian Shi'],
 ['CN', '12', 'Suizhou Shi'],
 ['CN', '29', 'Simao Shi'],
 ['CN', '21', 'Shizuishan Shi'],
 ['CN', '12', 'Shiyan Shi'],
 ['CN', '10', 'Shijiazhuang Shi'],
 ['CN', '30', 'Shenzhen'],
 ['CN', '11', 'Shaoyang Shi'],
 ['CN', '02', 'Shaoxing Shi'],
 ['CN', '30', 'Shaoguan Shi'],
 ['CN', '30', 'Shantou Shi'],
 ['CN', '03', 'Shangrao Shi'],
 ['CN', '09', 'Shangqiu Shi'],
 ['CN', '09', 'Shangqiu Diqu'],
 ['CN', '26', 'Shangluo Shi'],
 ['CN', '23', 'Shanghai Xian'],
 ['CN', '31', 'Sanya Shi'],
 ['CN', '07', 'Sanming Shi'],
 ['CN', '09', 'Sanmenxia Shi'],
 ['CN', '25', 'Rizhao Shi'],
 ['CN', '02', 'Quzhou Shi'],
 ['CN', '29', 'Qujing Shi'],
 ['CN', '07', 'Quanzhou Shi'],
 ['CN', '16', 'Qinzhou Shi'],
 ['CN', '10', 'Qinhuangdao Shi'],
 ['CN', '30', 'Qingyuan Shi'],
 ['CN', '15', 'Qingyang Shi'],
 ['CN', '25', 'Qingdao Shi'],
 ['CN', '18', 'Qianxinan Bouyeizu Miaozu Zizhizhou'],
 ['CN', '18', 'Qiannan Bouyeizu Miaozu Zizhizhou'],
 ['CN', '18', 'Qiandongnan Miaozu Dongzu Zizhizhou'],
 ['CN', '07', 'Putian Shi'],
 ['CN', '03', 'Pingxiang Shi'],
 ['CN', '15', 'Pingliang Shi'],
 ['CN', '09', 'Pingdingshan Shi'],
 ['CN', '32', 'Panzhihua Shi'],
 ['CN', '07', 'Ningde Shi'],
 ['CN', '02', 'Ningbo Shi'],
 ['CN', '32', 'Neijiang Shi'],
 ['CN', '09', 'Nanyang Shi'],
 ['CN', '04', 'Nantong Shi'],
 ['CN', '23', 'Nanshi Qu'],
 ['CN', '07', 'Nanping Shi'],
 ['CN', '16', 'Nanning Shi'],
 ['CN', '04', 'Nanjing Shi'],
 ['CN', '32', 'Nanchong Shi'],
 ['CN', '03', 'Nanchang Shi'],
 ['CN', '32', 'Mianyang Shi'],
 ['CN', '30', 'Meizhou Shi'],
 ['CN', '30', 'Maoming Shi'],
 ['CN', '01', 'Ma\xe2\x80\x99anshan Shi'],
 ['CN', '32', 'Luzhou Shi'],
 ['CN', '18', 'Lupanshui Shi'],
 ['CN', '09', 'Luoyang Shi'],
 ['CN', '09', 'Luohe Shi'],
 ['CN', '24', 'L\xc3\xbcliang Shi'],
 ['CN', '01', 'Lu\xe2\x80\x99an Shi'],
 ['CN', '11', 'Loudi Shi'],
 ['CN', '07', 'Longyan Shi'],
 ['CN', '15', 'Longnan Shi'],
 ['CN', '16', 'Liuzhou Shi'],
 ['CN', '02', 'Lishui Shi'],
 ['CN', '25', 'Linyi Shi'],
 ['CN', '15', 'Linxia Huizu Zizhizhou'],
 ['CN', '11', 'Lingling Diqu'],
 ['CN', '24', 'Linfen Shi'],
 ['CN', '29', 'Lincang Shi'],
 ['CN', '29', 'Lijiang Shi'],
 ['CN', '25', 'Liaocheng Shi'],
 ['CN', '04', 'Lianyungang Shi'],
 ['CN', '32', 'Liangshan Yizu Zizhizhou'],
 ['CN', '32', 'Leshan Shi'],
 ['CN', '15', 'Lanzhou Shi'],
 ['CN', '10', 'Langfang Shi'],
 ['CN', '25', 'Laiwu Shi'],
 ['CN', '29', 'Kunming Shi'],
 ['CN', '09', 'Kaifeng Shi'],
 ['CN', '03', 'Jiujiang Shi'],
 ['CN', '24', 'Jinzhong Shi'],
 ['CN', '25', 'Jining Shi'],
 ['CN', '02', 'Jinhua Shi'],
 ['CN', '12', 'Jingzhou Shi'],
 ['CN', '12', 'Jingmen Shi'],
 ['CN', '03', 'Jingdezhen Shi'],
 ['CN', '24', 'Jincheng Shi'],
 ['CN', '15', 'Jinchang Shi'],
 ['CN', '25', 'Jinan Shi'],
 ['CN', '30', 'Jieyang Shi'],
 ['CN', '02', 'Jiaxing Shi'],
 ['CN', '09', 'Jiaozuo Shi'],
 ['CN', '07', 'Jianyang Diqu'],
 ['CN', '30', 'Jiangmen Shi'],
 ['CN', '03', 'Ji\xe2\x80\x99an Shi'],
 ['CN', '20', 'Ordos Shi'],
 ['CN', '02', 'Huzhou Shi'],
 ['CN', '01', 'Huangshan Shi'],
 ['CN', '30', 'Huizhou Shi'],
 ['CN', '25', 'Huimin Diqu'],
 ['CN', '12', 'Huangshi Shi'],
 ['CN', '06', 'Huangnan Zangzu Zizhizhou'],
 ['CN', '12', 'Huanggang Shi'],
 ['CN', '04', 'Huai\xe2\x80\x99an Shi'],
 ['CN', '01', 'Huainan Shi'],
 ['CN', '11', 'Huaihua Shi'],
 ['CN', '01', 'Huaibei Shi'],
 ['CN', '29', 'Honghe Hanizu Yizu Zizhizhou'],
 ['CN', '25', 'Heze Shi'],
 ['CN', '30', 'Heyuan Shi'],
 ['CN', '11', 'Hengyang Shi'],
 ['CN', '10', 'Hengshui Shi'],
 ['CN', '01', 'Hefei Shi'],
 ['CN', '16', 'Hechi Shi'],
 ['CN', '09', 'Hebi Shi'],
 ['CN', '26', 'Hanzhong Shi'],
 ['CN', '02', 'Hangzhou Shi'],
 ['CN', '10', 'Handan Shi'],
 ['CN', '10', 'Handan Diqu'],
 ['CN', '06', 'Hainan Zangzu Zizhizhou'],
 ['CN', '31', 'Haikou Shi'],
 ['CN', '06', 'Haidong Diqu'],
 ['CN', '06', 'Haibei Zangzu Zizhizhou'],
 ['CN', '21', 'Guyuan Shi'],
 ['CN', '18', 'Guiyang Shi'],
 ['CN', '16', 'Guilin Shi'],
 ['CN', '16', 'Guilin Diqu'],
 ['CN', '30', 'Guangzhou Shi'],
 ['CN', '32', 'Garz\xc3\xaa Zangzu Zizhizhou'],
 ['CN', '03', 'Ganzhou Shi'],
 ['CN', '15', 'Gannan Zangzu Zizhizhou'],
 ['CN', '07', 'Fuzhou Shi'],
 ['CN', '03', 'Fuzhou Shi'],
 ['CN', '01', 'Fuyang Shi'],
 ['CN', '30', 'Foshan Shi'],
 ['CN', '12', 'Ezhou Shi'],
 ['CN', '12', 'Enshi Tujiazu Miaozu Zizhizhou'],
 ['CN', '25', 'Dongying Shi'],
 ['CN', '30', 'Dongguan Shi'],
 ['CN', '15', 'Dingxi Shi'],
 ['CN', '25', 'Dezhou Shi'],
 ['CN', '11', 'Zhangjiajie Shi'],
 ['CN', '32', 'Dazhou Shi'],
 ['CN', '29', 'Dali Baizu Zizhizhou'],
 ['CN', '19', 'Dalian Shi'],
 ['CN', '29', 'Chuxiong Yizu Zizhizhou'],
 ['CN', '01', 'Chuzhou Shi'],
 ['CN', '11', 'Chenzhou Shi'],
 ['CN', '32', 'Chengdu Shi'],
 ['CN', '30', 'Chaozhou Shi'],
 ['CN', '01', 'Chaohu Shi'],
 ['CN', '04', 'Changzhou Shi'],
 ['CN', '24', 'Changzhi Shi'],
 ['CN', '11', 'Changsha Shi'],
 ['CN', '11', 'Changde Shi'],
 ['CN', '10', 'Cangzhou Shi'],
 ['CN', '10', 'Cangzhou Diqu'],
 ['CN', '16', 'Baise Shi'],
 ['CN', '25', 'Binzhou Shi'],
 ['CN', '18', 'Bijie Diqu'],
 ['CN', '01', 'Bengbu Shi'],
 ['CN', '16', 'Beihai Shi'],
 ['CN', '26', 'Baoji Shi'],
 ['CN', '10', 'Baoding Shi'],
 ['CN', '10', 'Baoding Diqu'],
 ['CN', '15', 'Baiyin Shi'],
 ['CN', '09', 'Anyang Shi'],
 ['CN', '18', 'Anshun Shi'],
 ['CN', '01', 'Anqing Shi'],
 ['CN', '26', 'Ankang Shi'],
 ['CN', '20', 'Alxa Meng'],
 ['CN', '32', 'Aba Zangzu Qiangzu Zizhizhou'],
 ['CN', '04', 'Suzhou Shi'],
 ['CN', '09', 'Puyang Shi'],
 ['CN', '10', 'Zhangjiakou Shi'],
 ['CN', '08', 'Yichun Shi'],
 ['CN', '05', 'Yanbian Chaoxianzu Zizhizhou'],
 ['CN', '24', 'Yanbei Diqu'],
 ['CN', '20', 'Xilin Gol Meng'],
 ['CN', '20', 'Ulanqab Shi'],
 ['CN', '05', 'Tonghua Shi'],
 ['CN', '19', 'Tieling Shi'],
 ['CN', '08', 'Suihua Shi'],
 ['CN', '08', 'Songhuajiang Diqu'],
 ['CN', '05', 'Siping Shi'],
 ['CN', '08', 'Shuangyashan Shi'],
 ['CN', '19', 'Shenyang Shi'],
 ['CN', '08', 'Qitaihe Shi'],
 ['CN', '08', 'Qiqihar Shi'],
 ['CN', '19', 'Panjin Shi'],
 ['CN', '08', 'Mudanjiang Shi'],
 ['CN', '05', 'Liaoyuan Shi'],
 ['CN', '19', 'Liaoyang Shi'],
 ['CN', '08', 'Jixi Shi'],
 ['CN', '20', 'Tongliao Shi'],
 ['CN', '19', 'Jinzhou Shi'],
 ['CN', '19', 'Huludao Shi'],
 ['CN', '05', 'Jilin Shi'],
 ['CN', '08', 'Jiamusi Shi'],
 ['CN', '05', 'Baishan Shi'],
 ['CN', '20', 'Hulunbuir Shi'],
 ['CN', '20', 'Hohhot Shi'],
 ['CN', '20', 'Hinggan Meng'],
 ['CN', '08', 'Heihe Shi'],
 ['CN', '08', 'Hegang Shi'],
 ['CN', '08', 'Harbin Shi'],
 ['CN', '19', 'Fuxin Shi'],
 ['CN', '19', 'Fushun Shi'],
 ['CN', '24', 'Datong Shi'],
 ['CN', '08', 'Daqing Shi'],
 ['CN', '19', 'Dandong Shi'],
 ['CN', '08', 'Dahingganling Diqu'],
 ['CN', '20', 'Chifeng Shi'],
 ['CN', '10', 'Chengde Shi'],
 ['CN', '10', 'Chengde Diqu'],
 ['CN', '19', 'Chaoyang Shi'],
 ['CN', '05', 'Changchun Shi'],
 ['CN', '19', 'Benxi Shi'],
 ['CN', '20', 'Bayannur Shi'],
 ['CN', '20', 'Baotou Shi'],
 ['CN', '05', 'Baicheng Shi'],
 ['CN', '19', 'Anshan Shi'],
 ['CN', '30', 'Shanwei Shi'],
 ['CN', '05', 'Songyuan Shi'],
 ['CN', '01', 'Chizhou Shi'],
 ['CN', '01', 'Haozhou Shi'],
 ['CN', '24', 'Shuozhou Shi'],
 ['CN', '24', 'Xinzhou Shi'],
 ['CN', '32', 'Deyang Shi'],
 ['CN', '21', 'Zhongwei Shi'],
 ['CN', '21', 'Yinchuan Shi'],
 ['CN', '32', 'Guangyuan Shi'],
 ['CN', '32', 'Guang\xe2\x80\x99an Shi'],
 ['CN', '32', 'Suining Shi'],
 ['CN', '32', 'Bazhong Shi'],
 ['CN', '16', 'Baise'],
 ['CN', '16', 'Guigang Shi'],
 ['CN', '16', 'Chongzuo Shi'],
 ['CN', '16', 'Laibin Shi'],
 ['CN', '16', 'Fangchenggang Shi'],
 ['CN', '16', 'Hezhou Shi'],
 ['CO', '33', 'Zipaquir\xc3\xa1'],
 ['CO', '33', 'Zipac\xc3\xb3n'],
 ['CO', '36', 'Zetaquir\xc3\xa1'],
 ['CO', '29', 'Zarzal'],
 ['CO', '02', 'Zaragoza'],
 ['CO', '26', 'Zapatoca'],
 ['CO', '38', 'Zambrano'],
 ['CO', '29', 'Yotoco'],
 ['CO', '32', 'Yopal'],
 ['CO', '02', 'Yolomb\xc3\xb3'],
 ['CO', '02', 'Yarumal'],
 ['CO', '02', 'Yal\xc3\xad'],
 ['CO', '16', 'Yaguar\xc3\xa1'],
 ['CO', '20', 'Yacuanquer'],
 ['CO', '33', 'Yacop\xc3\xad'],
 ['CO', '37', 'Viterbo'],
 ['CO', '36', 'Viracach\xc3\xa1'],
 ['CO', '33', 'Viot\xc3\xa1'],
 ['CO', '33', 'Villeta'],
 ['CO', '16', 'Villavieja'],
 ['CO', '19', 'Villavicencio'],
 ['CO', '28', 'Villarrica'],
 ['CO', '21', 'Villa Del Rosario'],
 ['CO', '33', 'Villapinz\xc3\xb3n'],
 ['CO', '17', 'Villanueva'],
 ['CO', '35', 'Villanueva'],
 ['CO', '37', 'Villamar\xc3\xada'],
 ['CO', '28', 'Villahermosa'],
 ['CO', '21', 'Villa Caro'],
 ['CO', '29', 'Vijes'],
 ['CO', '37', 'Victoria'],
 ['CO', '33', 'Vian\xc3\xad'],
 ['CO', '29', 'Versalles'],
 ['CO', '33', 'Vergara'],
 ['CO', '36', 'Ventaquemada'],
 ['CO', '02', 'Venecia'],
 ['CO', '28', 'Venadillo'],
 ['CO', '26', 'V\xc3\xa9lez'],
 ['CO', '02', 'Valpara\xc3\xadso'],
 ['CO', '28', 'Valle de San Juan'],
 ['CO', '26', 'Valle de San Jos\xc3\xa9'],
 ['CO', '12', 'Valencia'],
 ['CO', '02', 'Valdivia'],
 ['CO', '33', 'Utica'],
 ['CO', '04', 'Usiacur\xc3\xad'],
 ['CO', '02', 'Urrao'],
 ['CO', '17', 'Uribia'],
 ['CO', '33', 'Une'],
 ['CO', '26', 'Umpal\xc3\xa1'],
 ['CO', '33', 'Umbita'],
 ['CO', '29', 'Ulloa'],
 ['CO', '33', 'Ubat\xc3\xa9'],
 ['CO', '33', 'Ubaque'],
 ['CO', '33', 'Ubal\xc3\xa1'],
 ['CO', '36', 'Tutaz\xc3\xa1'],
 ['CO', '36', 'Tuta'],
 ['CO', '36', 'Turmequ\xc3\xa9'],
 ['CO', '02', 'Turbo'],
 ['CO', '35', 'Turban\xc3\xa1'],
 ['CO', '35', 'Turbaco'],
 ['CO', '20', 'T\xc3\xbaquerres'],
 ['CO', '36', 'Tunja'],
 ['CO', '20', 'Tumaco'],
 ['CO', '29', 'Tulu\xc3\xa1'],
 ['CO', '04', 'Tubar\xc3\xa1'],
 ['CO', '29', 'Trujillo'],
 ['CO', '32', 'Trinidad'],
 ['CO', '09', 'Totor\xc3\xb3'],
 ['CO', '36', 'Tota'],
 ['CO', '29', 'Toro'],
 ['CO', '09', 'Torib\xc3\xado'],
 ['CO', '33', 'Topaip\xc3\xad'],
 ['CO', '36', 'T\xc3\xb3paga'],
 ['CO', '26', 'Tona'],
 ['CO', '27', 'Toluviejo'],
 ['CO', '27', 'Tol\xc3\xba'],
 ['CO', '21', 'Toledo'],
 ['CO', '02', 'Toledo'],
 ['CO', '36', 'Toqui'],
 ['CO', '33', 'Tocancip\xc3\xa1'],
 ['CO', '33', 'Tocaima'],
 ['CO', '36', 'Toca'],
 ['CO', '02', 'Titirib\xc3\xad'],
 ['CO', '36', 'Tinjac\xc3\xa1'],
 ['CO', '09', 'Timbiqu\xc3\xad'],
 ['CO', '09', 'Timb\xc3\xado'],
 ['CO', '16', 'Timan\xc3\xa1'],
 ['CO', '12', 'Tierralta'],
 ['CO', '33', 'Tibirita'],
 ['CO', '36', 'Tibasosa'],
 ['CO', '36', 'Tiban\xc3\xa1'],
 ['CO', '33', 'Tibacuy'],
 ['CO', '16', 'Tesalia'],
 ['CO', '16', 'Teruel'],
 ['CO', '21', 'Teorama'],
 ['CO', '33', 'Tenza'],
 ['CO', '33', 'Tenjo'],
 ['CO', '38', 'Tenerife'],
 ['CO', '33', 'Tena'],
 ['CO', '16', 'Tello'],
 ['CO', '33', 'Tausa'],
 ['CO', '36', 'Tasco'],
 ['CO', '02', 'Tarso'],
 ['CO', '16', 'Tarqui'],
 ['CO', '20', 'Tangua'],
 ['CO', '20', 'Taminango'],
 ['CO', '02', 'T\xc3\xa1mesis'],
 ['CO', '03', 'Tame'],
 ['CO', '32', 'T\xc3\xa1mara'],
 ['CO', '10', 'Tamalameque'],
 ['CO', '11', 'Tad\xc3\xb3'],
 ['CO', '33', 'Tabio'],
 ['CO', '33', 'Sutatenza'],
 ['CO', '33', 'Sutatausa'],
 ['CO', '36', 'Sutamarch\xc3\xa1n'],
 ['CO', '36', 'Susac\xc3\xb3n'],
 ['CO', '33', 'Susa'],
 ['CO', '26', 'Surat\xc3\xa1'],
 ['CO', '37', 'Sup\xc3\xada'],
 ['CO', '33', 'Supat\xc3\xa1'],
 ['CO', '33', 'Suesca'],
 ['CO', '27', 'Sucre'],
 ['CO', '26', 'Sucre'],
 ['CO', '33', 'Subachoque'],
 ['CO', '16', 'Suaza'],
 ['CO', '28', 'Su\xc3\xa1rez'],
 ['CO', '04', 'Suan'],
 ['CO', '26', 'Suaita'],
 ['CO', '09', 'Sotar\xc3\xa1'],
 ['CO', '26', 'Sotaquir\xc3\xa1'],
 ['CO', '33', 'Sop\xc3\xb3'],
 ['CO', '35', 'Soplaviento'],
 ['CO', '02', 'Sopetr\xc3\xa1n'],
 ['CO', '02', 'Sons\xc3\xb3n'],
 ['CO', '04', 'Soledad'],
 ['CO', '11', 'Bah\xc3\xada Solano'],
 ['CO', '36', 'Sogamoso'],
 ['CO', '36', 'Socot\xc3\xa1'],
 ['CO', '26', 'Socorro'],
 ['CO', '36', 'Socha'],
 ['CO', '36', 'Soat\xc3\xa1'],
 ['CO', '33', 'Soacha'],
 ['CO', '38', 'Sitionuevo'],
 ['CO', '11', 'Sip\xc3\xad'],
 ['CO', '27', 'Sincelejo'],
 ['CO', '27', 'Sinc\xc3\xa9'],
 ['CO', '35', 'Simit\xc3\xad'],
 ['CO', '33', 'Simijaca'],
 ['CO', '26', 'Simacota'],
 ['CO', '09', 'Silvia'],
 ['CO', '33', 'Silvania'],
 ['CO', '21', 'Silos'],
 ['CO', '36', 'Siachoque'],
 ['CO', '29', 'Sevilla'],
 ['CO', '33', 'Sesquil\xc3\xa9'],
 ['CO', '02', 'Segovia'],
 ['CO', '36', 'S\xc3\xa1tivasur'],
 ['CO', '36', 'S\xc3\xa1tivanorte'],
 ['CO', '33', 'Sasaima'],
 ['CO', '21', 'Sardinata'],
 ['CO', '03', 'Saravena'],
 ['CO', '20', 'Sapuyes'],
 ['CO', '38', 'San Zen\xc3\xb3n'],
 ['CO', '08', 'San Vicente del Cagu\xc3\xa1n'],
 ['CO', '26', 'San Vicente de Chucur\xc3\xad'],
 ['CO', '02', 'San Vicente'],
 ['CO', '02', 'Santuario'],
 ['CO', '24', 'Santuario'],
 ['CO', '04', 'Santo Tom\xc3\xa1s'],
 ['CO', '21', 'Santiago'],
 ['CO', '36', 'Santa Sof\xc3\xada'],
 ['CO', '36', 'Santa Rosa de Viterbo'],
 ['CO', '02', 'Santa Rosa de Osos'],
 ['CO', '24', 'Santa Rosa de Cabal'],
 ['CO', '35', 'Santa Rosa'],
 ['CO', '09', 'Santa Rosa'],
 ['CO', '09', 'Santander de Quilichao'],
 ['CO', '38', 'Santa Marta'],
 ['CO', '16', 'Santa Mar\xc3\xada'],
 ['CO', '28', 'Santa Isabel'],
 ['CO', '20', 'Santa Cruz'],
 ['CO', '35', 'Santa Catalina'],
 ['CO', '02', 'Santa B\xc3\xa1rbara'],
 ['CO', '20', 'Santa B\xc3\xa1rbara'],
 ['CO', '38', 'Santa Ana'],
 ['CO', '26', 'Santa Ana'],
 ['CO', '38', 'San Sebasti\xc3\xa1n de Buenavista'],
 ['CO', '09', 'San Sebasti\xc3\xa1n'],
 ['CO', '02', 'San Roque'],
 ['CO', '02', 'San Rafael'],
 ['CO', '12', 'San Pelayo'],
 ['CO', '27', 'San Pedro'],
 ['CO', '02', 'San Pedro'],
 ['CO', '29', 'San Pedro'],
 ['CO', '36', 'San Pablo de Borbur'],
 ['CO', '20', 'San Pablo'],
 ['CO', '27', 'San Onofre'],
 ['CO', '36', 'San Miguel de Sema'],
 ['CO', '26', 'San Miguel'],
 ['CO', '36', 'San Mateo'],
 ['CO', '35', 'San Mart\xc3\xadn de Loba'],
 ['CO', '19', 'San Mart\xc3\xadn'],
 ['CO', '27', 'San Marcos'],
 ['CO', '32', 'San Luis de Palenque'],
 ['CO', '32', 'San Luis de Gaceno'],
 ['CO', '02', 'San Luis'],
 ['CO', '28', 'San Luis'],
 ['CO', '20', 'San Lorenzo'],
 ['CO', '35', 'San Juan Nepomuceno'],
 ['CO', '33', 'San Juan de R\xc3\xadoseco'],
 ['CO', '17', 'San Juan del C\xc3\xa9sar'],
 ['CO', '36', 'San Jos\xc3\xa9 de Pare'],
 ['CO', '26', 'San Jos\xc3\xa9 de Miranda'],
 ['CO', '11', 'San Jos\xc3\xa9 del Palmar'],
 ['CO', '16', 'Isnos'],
 ['CO', '26', 'San Joaqu\xc3\xadn'],
 ['CO', '02', 'San Jer\xc3\xb3nimo'],
 ['CO', '35', 'San Jacinto'],
 ['CO', '26', 'San Gil'],
 ['CO', '33', 'San Francisco'],
 ['CO', '35', 'San Fernando'],
 ['CO', '35', 'San Estanislao'],
 ['CO', '20', 'Sandon\xc3\xa1'],
 ['CO', '21', 'San Cayetano'],
 ['CO', '33', 'San Cayetano'],
 ['CO', '12', 'San Carlos'],
 ['CO', '02', 'San Carlos'],
 ['CO', '21', 'San Calixto'],
 ['CO', '12', 'San Bernardo del Viento'],
 ['CO', '33', 'San Bernardo'],
 ['CO', '27', 'San Benito Abad'],
 ['CO', '26', 'San Benito'],
 ['CO', '33', 'San Antonio de Tena'],
 ['CO', '28', 'San Antonio'],
 ['CO', '12', 'San Antero'],
 ['CO', '12', 'San Andr\xc3\xa9s de Sotavento'],
 ['CO', '25', 'San Andr\xc3\xa9s'],
 ['CO', '02', 'San Andr\xc3\xa9s'],
 ['CO', '26', 'San Andr\xc3\xa9s'],
 ['CO', '16', 'San Agust\xc3\xadn'],
 ['CO', '27', 'Sampu\xc3\xa9s'],
 ['CO', '20', 'Samaniego'],
 ['CO', '37', 'Saman\xc3\xa1'],
 ['CO', '36', 'Samac\xc3\xa1'],
 ['CO', '02', 'Salgar'],
 ['CO', '23', 'Salento'],
 ['CO', '21', 'Salazar'],
 ['CO', '38', 'Salamina'],
 ['CO', '37', 'Salamina'],
 ['CO', '16', 'Saladoblanco'],
 ['CO', '12', 'Sahag\xc3\xban'],
 ['CO', '36', 'S\xc3\xa1chica'],
 ['CO', '32', 'S\xc3\xa1cama'],
 ['CO', '36', 'Saboy\xc3\xa1'],
 ['CO', '04', 'Sabanalarga'],
 ['CO', '02', 'Sabanalarga'],
 ['CO', '04', 'Sabanagrande'],
 ['CO', '28', 'Rovira'],
 ['CO', '09', 'Rosas'],
 ['CO', '36', 'Rond\xc3\xb3n'],
 ['CO', '28', 'Roncesvalles'],
 ['CO', '29', 'Roldanillo'],
 ['CO', '10', 'Robles'],
 ['CO', '10', 'La paz'],
 ['CO', '20', 'Roberto Pay\xc3\xa1n'],
 ['CO', '16', 'Rivera'],
 ['CO', '37', 'Risaralda'],
 ['CO', '11', 'R\xc3\xadosucio'],
 ['CO', '37', 'R\xc3\xadosucio'],
 ['CO', '26', 'R\xc3\xadonegro'],
 ['CO', '02', 'R\xc3\xadonegro'],
 ['CO', '17', 'R\xc3\xadohacha'],
 ['CO', '29', 'R\xc3\xadofr\xc3\xado'],
 ['CO', '10', 'R\xc3\xado de Oro'],
 ['CO', '28', 'R\xc3\xadoblanco'],
 ['CO', '27', 'Chal\xc3\xa1n'],
 ['CO', '20', 'Ricaurte'],
 ['CO', '02', 'Retiro'],
 ['CO', '19', 'Restrepo'],
 ['CO', '29', 'Restrepo'],
 ['CO', '04', 'Repel\xc3\xb3n'],
 ['CO', '38', 'Remolino'],
 ['CO', '02', 'Remedios'],
 ['CO', '32', 'Recetor'],
 ['CO', '36', 'R\xc3\xa1quira'],
 ['CO', '36', 'Ramiriqu\xc3\xad'],
 ['CO', '21', 'Ragonvalia'],
 ['CO', '33', 'Apulo'],
 ['CO', '33', 'Quipile'],
 ['CO', '24', 'Quinch\xc3\xada'],
 ['CO', '23', 'Quimbaya'],
 ['CO', '11', 'Quibd\xc3\xb3'],
 ['CO', '33', 'Quetame'],
 ['CO', '33', 'Quebradanegra'],
 ['CO', '12', 'Pur\xc3\xadsima'],
 ['CO', '28', 'Purificaci\xc3\xb3n'],
 ['CO', '09', 'Purac\xc3\xa9'],
 ['CO', '20', 'Pupiales'],
 ['CO', '33', 'Pul\xc3\xad'],
 ['CO', '26', 'Puerto Wilches'],
 ['CO', '09', 'Puerto Tejada'],
 ['CO', '33', 'Puerto Salgar'],
 ['CO', '19', 'Puerto L\xc3\xb3pez'],
 ['CO', '19', 'Puerto Lleras'],
 ['CO', '22', 'Puerto Legu\xc3\xadzamo'],
 ['CO', '12', 'Puerto Escondido'],
 ['CO', '04', 'Puerto Colombia'],
 ['CO', '36', 'Puerto Boyac\xc3\xa1'],
 ['CO', '02', 'Puerto Berr\xc3\xado'],
 ['CO', '20', 'Puerres'],
 ['CO', '26', 'Puente Nacional'],
 ['CO', '38', 'Pueblo Viejo'],
 ['CO', '02', 'Pueblorrico'],
 ['CO', '24', 'Pueblo Rico'],
 ['CO', '12', 'Pueblo Neuvo'],
 ['CO', '25', 'Providencia Y Santa Catalina'],
 ['CO', '28', 'Prado'],
 ['CO', '29', 'Pradera'],
 ['CO', '20', 'Potos\xc3\xad'],
 ['CO', '32', 'Pore'],
 ['CO', '09', 'Popay\xc3\xa1n'],
 ['CO', '04', 'Polonuevo'],
 ['CO', '38', 'Plato'],
 ['CO', '12', 'Planeta Rica'],
 ['CO', '28', 'Planadas'],
 ['CO', '38', 'Pivijay'],
 ['CO', '16', 'Pitalito'],
 ['CO', '16', 'Pital'],
 ['CO', '36', 'Pisba'],
 ['CO', '04', 'Pioj\xc3\xb3'],
 ['CO', '26', 'Pinchote'],
 ['CO', '23', 'Pijao'],
 ['CO', '09', 'Piendam\xc3\xb3'],
 ['CO', '28', 'Piedras'],
 ['CO', '26', 'Piedecuesta'],
 ['CO', '36', 'Pesca'],
 ['CO', '24', 'Pereira'],
 ['CO', '02', 'Peque'],
 ['CO', '37', 'Pensilvania'],
 ['CO', '02', 'Pe\xc3\xb1ol'],
 ['CO', '38', 'Pedraza'],
 ['CO', '36', 'Paz de R\xc3\xado'],
 ['CO', '32', 'Paz de Ariporo'],
 ['CO', '20', 'Magui'],
 ['CO', '36', 'Pay\xc3\xa1'],
 ['CO', '26', 'Pauna'],
 ['CO', '09', 'Pat\xc3\xada'],
 ['CO', '20', 'Pasto'],
 ['CO', '33', 'Pasca'],
 ['CO', '26', 'P\xc3\xa1ramo'],
 ['CO', '36', 'Panqueba'],
 ['CO', '33', 'Pandi'],
 ['CO', '21', 'Pamplonita'],
 ['CO', '21', 'Pamplona'],
 ['CO', '35', 'Pinillos'],
 ['CO', '27', 'Palmito'],
 ['CO', '29', 'Palmira'],
 ['CO', '26', 'Palmas del Socorro'],
 ['CO', '04', 'Palmar de Varela'],
 ['CO', '26', 'Palmar'],
 ['CO', '37', 'Palestina'],
 ['CO', '16', 'Palermo'],
 ['CO', '36', 'Pajarito'],
 ['CO', '36', 'Paipa'],
 ['CO', '33', 'Paime'],
 ['CO', '16', 'Paicol'],
 ['CO', '09', 'P\xc3\xa1ez'],
 ['CO', '09', 'Padilla'],
 ['CO', '37', 'P\xc3\xa1cora'],
 ['CO', '33', 'Pacho'],
 ['CO', '33', 'Pachavita'],
 ['CO', '27', 'Ovejas'],
 ['CO', '36', 'Otanche'],
 ['CO', '33', 'Ospina P\xc3\xa9rez'],
 ['CO', '20', 'Ospina'],
 ['CO', '28', 'Ortega'],
 ['CO', '32', 'Orocu\xc3\xa9'],
 ['CO', '16', 'Oporapa'],
 ['CO', '26', 'Onzaga'],
 ['CO', '02', 'Olaya'],
 ['CO', '26', 'Oiba'],
 ['CO', '21', 'Oca\xc3\xb1a'],
 ['CO', '26', 'Ocamonte'],
 ['CO', '29', 'Obando'],
 ['CO', '11', 'Nuqu\xc3\xad'],
 ['CO', '32', 'Nunch\xc3\xada'],
 ['CO', '36', 'Nuevo Col\xc3\xb3n'],
 ['CO', '11', 'N\xc3\xb3vita'],
 ['CO', '33', 'Nocaima'],
 ['CO', '36', 'Nobsa'],
 ['CO', '33', 'Nimaima'],
 ['CO', '33', 'Nilo'],
 ['CO', '33', 'Nemoc\xc3\xb3n'],
 ['CO', '16', 'Neiva'],
 ['CO', '37', 'Neira'],
 ['CO', '28', 'Natagaima'],
 ['CO', '16', 'N\xc3\xa1taga'],
 ['CO', '02', 'Nari\xc3\xb1o'],
 ['CO', '33', 'Nari\xc3\xb1o'],
 ['CO', '36', 'Muzo'],
 ['CO', '21', 'Mutiscua'],
 ['CO', '02', 'Mutat\xc3\xa1'],
 ['CO', '02', 'Murind\xc3\xb3'],
 ['CO', '33', 'Mosquera'],
 ['CO', '20', 'Mosquera'],
 ['CO', '27', 'Morroa'],
 ['CO', '35', 'Morales'],
 ['CO', '09', 'Morales'],
 ['CO', '32', 'Monterrey'],
 ['CO', '12', 'Monter\xc3\xada'],
 ['CO', '23', 'Montenegro'],
 ['CO', '12', 'Montel\xc3\xadbano'],
 ['CO', '02', 'Montebello'],
 ['CO', '08', 'La Monta\xc3\xb1ita'],
 ['CO', '36', 'Moniquir\xc3\xa1'],
 ['CO', '36', 'Mongu\xc3\xad'],
 ['CO', '36', 'Mongua'],
 ['CO', '35', 'Momp\xc3\xb3s'],
 ['CO', '26', 'Molagavita'],
 ['CO', '26', 'Mogotes'],
 ['CO', '22', 'Mocoa'],
 ['CO', '24', 'Mistrat\xc3\xb3'],
 ['CO', '09', 'Miranda'],
 ['CO', '36', 'Miraflores'],
 ['CO', '09', 'Mercaderes'],
 ['CO', '28', 'Melgar'],
 ['CO', '33', 'Medina'],
 ['CO', '02', 'Medell\xc3\xadn'],
 ['CO', '26', 'Matanza'],
 ['CO', '37', 'Marulanda'],
 ['CO', '24', 'Marsella'],
 ['CO', '37', 'Marquetalia'],
 ['CO', '37', 'Marmato'],
 ['CO', '28', 'Mariquita'],
 ['CO', '36', 'Marip\xc3\xad'],
 ['CO', '02', 'Marinilla'],
 ['CO', '35', 'Mar\xc3\xada La Baja'],
 ['CO', '35', 'Margarita'],
 ['CO', '37', 'Manzanares'],
 ['CO', '33', 'Manta'],
 ['CO', '37', 'Manizales'],
 ['CO', '32', 'Man\xc3\xad'],
 ['CO', '04', 'Manat\xc3\xad'],
 ['CO', '20', 'Mallama'],
 ['CO', '04', 'Malambo'],
 ['CO', '26', 'M\xc3\xa1laga'],
 ['CO', '27', 'Majagual'],
 ['CO', '17', 'Maicao'],
 ['CO', '35', 'Mahates'],
 ['CO', '35', 'Magangu\xc3\xa9'],
 ['CO', '33', 'Madrid'],
 ['CO', '33', 'Machet\xc3\xa1'],
 ['CO', '02', 'Maceo'],
 ['CO', '26', 'Macaravita'],
 ['CO', '36', 'Macanal'],
 ['CO', '04', 'Luruaco'],
 ['CO', '21', 'Lourdes'],
 ['CO', '26', 'Los Santos'],
 ['CO', '20', 'Los Andes'],
 ['CO', '12', 'Lorica'],
 ['CO', '09', 'L\xc3\xb3pez'],
 ['CO', '11', 'Llor\xc3\xb3'],
 ['CO', '20', 'Linares'],
 ['CO', '02', 'Liborina'],
 ['CO', '28', 'L\xc3\xadbano'],
 ['CO', '28', 'L\xc3\xa9rida'],
 ['CO', '33', 'Lenguazaque'],
 ['CO', '36', 'Villa De Leyva'],
 ['CO', '26', 'Lebrija'],
 ['CO', '24', 'La Virginia'],
 ['CO', '33', 'La Vega'],
 ['CO', '09', 'La Vega'],
 ['CO', '36', 'La Uvita'],
 ['CO', '02', 'La Uni\xc3\xb3n'],
 ['CO', '29', 'La Uni\xc3\xb3n'],
 ['CO', '20', 'La Uni\xc3\xb3n'],
 ['CO', '23', 'La Tebaida'],
 ['CO', '09', 'La Sierra'],
 ['CO', '32', 'La Salina'],
 ['CO', '21', 'La Playa'],
 ['CO', '16', 'La Plata'],
 ['CO', '33', 'La Pe\xc3\xb1a'],
 ['CO', '26', 'La Paz'],
 ['CO', '33', 'La Palma'],
 ['CO', '33', 'La Mesa'],
 ['CO', '10', 'La Gloria'],
 ['CO', '20', 'La Florida'],
 ['CO', '02', 'La Estrella'],
 ['CO', '37', 'La Dorada'],
 ['CO', '29', 'La Cumbre'],
 ['CO', '20', 'La Cruz'],
 ['CO', '24', 'La Celia'],
 ['CO', '02', 'La Ceja'],
 ['CO', '36', 'La Capilla'],
 ['CO', '33', 'La Calera'],
 ['CO', '36', 'Labranzagrande'],
 ['CO', '21', 'Labateca'],
 ['CO', '16', 'La Argentina'],
 ['CO', '26', 'Aguada'],
 ['CO', '11', 'Jurad\xc3\xb3'],
 ['CO', '33', 'Jun\xc3\xadn'],
 ['CO', '04', 'Juan de Acosta'],
 ['CO', '26', 'Jord\xc3\xa1n'],
 ['CO', '26', 'Jes\xc3\xbas Mar\xc3\xada'],
 ['CO', '33', 'Jerusal\xc3\xa9n'],
 ['CO', '36', 'Jeric\xc3\xb3'],
 ['CO', '02', 'Jeric\xc3\xb3'],
 ['CO', '36', 'Jenesano'],
 ['CO', '02', 'Jard\xc3\xadn'],
 ['CO', '29', 'Jamund\xc3\xad'],
 ['CO', '09', 'Jambal\xc3\xb3'],
 ['CO', '36', 'Iza'],
 ['CO', '02', 'Ituango'],
 ['CO', '02', 'Itag\xc3\xbc\xc3\xad'],
 ['CO', '11', 'Istmina'],
 ['CO', '16', 'Iquira'],
 ['CO', '20', 'Ipiales'],
 ['CO', '09', 'Inz\xc3\xa1'],
 ['CO', '20', 'Imu\xc3\xa9s'],
 ['CO', '20', 'Iles'],
 ['CO', '28', 'Icononzo'],
 ['CO', '28', 'Ibagu\xc3\xa9'],
 ['CO', '28', 'Honda'],
 ['CO', '16', 'Hobo'],
 ['CO', '21', 'Herr\xc3\xa1n'],
 ['CO', '02', 'Heliconia'],
 ['CO', '32', 'Hato Corozal'],
 ['CO', '26', 'Hato'],
 ['CO', '21', 'Hacar\xc3\xad'],
 ['CO', '33', 'Guti\xc3\xa9rrez'],
 ['CO', '36', 'G\xc3\xbcic\xc3\xa1n'],
 ['CO', '26', 'G\xc3\xbcepsa'],
 ['CO', '36', 'Guayat\xc3\xa1'],
 ['CO', '33', 'Guayabal de S\xc3\xadquima'],
 ['CO', '26', 'Guavat\xc3\xa1'],
 ['CO', '24', 'Gu\xc3\xa1tica'],
 ['CO', '33', 'Guateque'],
 ['CO', '33', 'Guatavita'],
 ['CO', '33', 'Guataqu\xc3\xad'],
 ['CO', '02', 'Guatap\xc3\xa9'],
 ['CO', '33', 'Guasca'],
 ['CO', '02', 'Guarne'],
 ['CO', '26', 'Guapot\xc3\xa1'],
 ['CO', '09', 'Guap\xc3\xad'],
 ['CO', '28', 'Guamo'],
 ['CO', '38', 'Guamal'],
 ['CO', '19', 'Guamal'],
 ['CO', '20', 'Gualmat\xc3\xa1n'],
 ['CO', '20', 'Guaitarilla'],
 ['CO', '33', 'Guaduas'],
 ['CO', '26', 'Guadalupe'],
 ['CO', '16', 'Guadalupe'],
 ['CO', '20', 'Guachucal'],
 ['CO', '33', 'Guachet\xc3\xa1'],
 ['CO', '29', 'Guacar\xc3\xad'],
 ['CO', '36', 'Guacamayas'],
 ['CO', '26', 'Guaca'],
 ['CO', '02', 'Granada'],
 ['CO', '19', 'Granada'],
 ['CO', '21', 'Gramalote'],
 ['CO', '10', 'Gonz\xc3\xa1lez'],
 ['CO', '02', 'G\xc3\xb3mez Plata'],
 ['CO', '26', 'Gir\xc3\xb3n'],
 ['CO', '02', 'Girardota'],
 ['CO', '33', 'Girardot'],
 ['CO', '02', 'Giraldo'],
 ['CO', '29', 'Ginebra'],
 ['CO', '16', 'Gigante'],
 ['CO', '23', 'G\xc3\xa9nova'],
 ['CO', '16', 'Garz\xc3\xb3n'],
 ['CO', '36', 'Garagoa'],
 ['CO', '36', 'G\xc3\xa1meza'],
 ['CO', '26', 'G\xc3\xa1mbita'],
 ['CO', '10', 'Gamarra'],
 ['CO', '33', 'Gama'],
 ['CO', '04', 'Galapa'],
 ['CO', '26', 'Gal\xc3\xa1n'],
 ['CO', '33', 'Gachet\xc3\xa1'],
 ['CO', '36', 'Gachantiv\xc3\xa1'],
 ['CO', '33', 'Gachancip\xc3\xa1'],
 ['CO', '33', 'Gachal\xc3\xa1'],
 ['CO', '33', 'Fusagasug\xc3\xa1'],
 ['CO', '33', 'F\xc3\xbaquene'],
 ['CO', '33', 'Funza'],
 ['CO', '20', 'Funes'],
 ['CO', '38', 'Fundaci\xc3\xb3n'],
 ['CO', '02', 'Frontino'],
 ['CO', '28', 'Fresno'],
 ['CO', '02', 'Fredonia'],
 ['CO', '33', 'Fosca'],
 ['CO', '17', 'Fonseca'],
 ['CO', '33', 'F\xc3\xb3meque'],
 ['CO', '26', 'Floridablanca'],
 ['CO', '29', 'Florida'],
 ['CO', '36', 'Floresta'],
 ['CO', '08', 'Florencia'],
 ['CO', '28', 'Flandes'],
 ['CO', '36', 'Firavitoba'],
 ['CO', '23', 'Filandia'],
 ['CO', '37', 'Filadelfia'],
 ['CO', '28', 'Falan'],
 ['CO', '33', 'Facatativ\xc3\xa1'],
 ['CO', '28', 'Espinal'],
 ['CO', '02', 'Envigado'],
 ['CO', '02', 'Entrerr\xc3\xados'],
 ['CO', '26', 'Enciso'],
 ['CO', '26', 'Encino'],
 ['CO', '21', 'El Zulia'],
 ['CO', '09', 'El Tambo'],
 ['CO', '20', 'El Tambo'],
 ['CO', '22', 'El Tabl\xc3\xb3n'],
 ['CO', '20', 'El Rosario'],
 ['CO', '38', 'El Pi\xc3\xb1\xc3\xb3n'],
 ['CO', '33', 'El Pe\xc3\xb1\xc3\xb3n'],
 ['CO', '16', 'El\xc3\xadas'],
 ['CO', '35', 'El Guamo'],
 ['CO', '26', 'El Guacamayo'],
 ['CO', '36', 'El Espino'],
 ['CO', '29', 'El Dovio'],
 ['CO', '33', 'El Colegio'],
 ['CO', '36', 'El Cocuy'],
 ['CO', '20', 'El Charco'],
 ['CO', '29', 'El Cerrito'],
 ['CO', '35', 'El Carmen de Bol\xc3\xadvar'],
 ['CO', '21', 'El Carmen'],
 ['CO', '11', 'El Carmen De Atrato'],
 ['CO', '19', 'El Calvario'],
 ['CO', '29', 'El Cairo'],
 ['CO', '38', 'El Banco'],
 ['CO', '29', 'El \xc3\x81guila'],
 ['CO', '02', 'Eb\xc3\xa9jico'],
 ['CO', '21', 'Durania'],
 ['CO', '36', 'Duitama'],
 ['CO', '02', 'Don Mat\xc3\xadas'],
 ['CO', '28', 'Dolores'],
 ['CO', '29', 'Dagua'],
 ['CO', '02', 'Dabeiba'],
 ['CO', '26', 'Curit\xc3\xad'],
 ['CO', '28', 'Cunday'],
 ['CO', '20', 'Cumbal'],
 ['CO', '19', 'Cumaral'],
 ['CO', '36', 'Cu\xc3\xadtiva'],
 ['CO', '21', 'Cucutilla'],
 ['CO', '21', 'C\xc3\xbacuta'],
 ['CO', '33', 'Cucunub\xc3\xa1'],
 ['CO', '36', 'Cubar\xc3\xa1'],
 ['CO', '20', 'Cuaspud'],
 ['CO', '28', 'Coyaima'],
 ['CO', '26', 'Covarach\xc3\xada'],
 ['CO', '33', 'Cota'],
 ['CO', '36', 'Corrales'],
 ['CO', '27', 'Corozal'],
 ['CO', '26', 'Coromoro'],
 ['CO', '09', 'Corinto'],
 ['CO', '35', 'C\xc3\xb3rdoba'],
 ['CO', '20', 'C\xc3\xb3rdoba'],
 ['CO', '36', 'Coper'],
 ['CO', '02', 'Copacabana'],
 ['CO', '21', 'Convenci\xc3\xb3n'],
 ['CO', '26', 'Contrataci\xc3\xb3n'],
 ['CO', '20', 'Contadero'],
 ['CO', '20', 'Consac\xc3\xa1'],
 ['CO', '26', 'Confines'],
 ['CO', '11', 'Condoto'],
 ['CO', '02', 'Concordia'],
 ['CO', '26', 'Concepci\xc3\xb3n'],
 ['CO', '02', 'Concepci\xc3\xb3n'],
 ['CO', '36', 'C\xc3\xb3mbita'],
 ['CO', '20', 'Col\xc3\xb3n'],
 ['CO', '16', 'Colombia'],
 ['CO', '33', 'Cogua'],
 ['CO', '28', 'Coello'],
 ['CO', '02', 'Cocorn\xc3\xa1'],
 ['CO', '02', 'Cisneros'],
 ['CO', '23', 'Circasia'],
 ['CO', '12', 'Ci\xc3\xa9naga de Oro'],
 ['CO', '38', 'Ci\xc3\xa9naga'],
 ['CO', '36', 'Ci\xc3\xa9naga'],
 ['CO', '29', 'Caicedonia'],
 ['CO', '33', 'Chocont\xc3\xa1'],
 ['CO', '33', 'Choach\xc3\xad'],
 ['CO', '26', 'Chitaraque'],
 ['CO', '21', 'Chitag\xc3\xa1'],
 ['CO', '36', 'Chita'],
 ['CO', '36', 'Chiscas'],
 ['CO', '10', 'Chiriguan\xc3\xa1'],
 ['CO', '36', 'Chiquinquir\xc3\xa1'],
 ['CO', '26', 'Chipat\xc3\xa1'],
 ['CO', '34', 'Chipaque'],
 ['CO', '12', 'Chin\xc3\xba'],
 ['CO', '37', 'Chinchin\xc3\xa1'],
 ['CO', '36', 'Chinavita'],
 ['CO', '21', 'Chin\xc3\xa1cota'],
 ['CO', '10', 'Chimichagua'],
 ['CO', '12', 'Chim\xc3\xa1'],
 ['CO', '26', 'Chima'],
 ['CO', '02', 'Chigorod\xc3\xb3'],
 ['CO', '33', 'Ch\xc3\xada'],
 ['CO', '26', 'Charta'],
 ['CO', '26', 'Charal\xc3\xa1'],
 ['CO', '28', 'Chaparral'],
 ['CO', '32', 'Ch\xc3\xa1meza'],
 ['CO', '33', 'Chaguan\xc3\xad'],
 ['CO', '38', 'Cerro de San Antonio'],
 ['CO', '26', 'Cerrito'],
 ['CO', '36', 'Cerinza'],
 ['CO', '12', 'Ceret\xc3\xa9'],
 ['CO', '26', 'Cepit\xc3\xa1'],
 ['CO', '02', 'Caucasia'],
 ['CO', '19', 'Castilla La Nueva'],
 ['CO', '28', 'Casabianca'],
 ['CO', '29', 'Cartago'],
 ['CO', '35', 'Cartagena'],
 ['CO', '02', 'Carolina'],
 ['CO', '02', 'Carmen de Viboral'],
 ['CO', '33', 'Carmen de Carupa'],
 ['CO', '28', 'Carmen de Apical\xc3\xa1'],
 ['CO', '26', 'Carcas\xc3\xad'],
 ['CO', '02', 'Caramanta'],
 ['CO', '33', 'C\xc3\xa1queza'],
 ['CO', '26', 'Capitanejo'],
 ['CO', '33', 'Caparrap\xc3\xad'],
 ['CO', '04', 'Candelaria'],
 ['CO', '29', 'Candelaria'],
 ['CO', '02', 'Ca\xc3\xb1asgordas'],
 ['CO', '36', 'Campohermoso'],
 ['CO', '04', 'Campo de la Cruz'],
 ['CO', '16', 'Campoalegre'],
 ['CO', '02', 'Campamento'],
 ['CO', '09', 'Caloto'],
 ['CO', '29', 'Calima'],
 ['CO', '26', 'California'],
 ['CO', '29', 'Cali'],
 ['CO', '09', 'Caldono'],
 ['CO', '02', 'Caldas'],
 ['CO', '36', 'Caldas'],
 ['CO', '23', 'Calarc\xc3\xa1'],
 ['CO', '35', 'Calamar'],
 ['CO', '33', 'Cajic\xc3\xa1'],
 ['CO', '09', 'Cajib\xc3\xado'],
 ['CO', '28', 'Cajamarca'],
 ['CO', '27', 'Caimito'],
 ['CO', '02', 'Caicedo'],
 ['CO', '21', 'C\xc3\xa1cota'],
 ['CO', '21', 'C\xc3\xa1chira'],
 ['CO', '02', 'C\xc3\xa1ceres'],
 ['CO', '26', 'Cabrera'],
 ['CO', '36', 'Busbanz\xc3\xa1'],
 ['CO', '02', 'Buritic\xc3\xa1'],
 ['CO', '29', 'Bugalagrande'],
 ['CO', '29', 'Buga'],
 ['CO', '20', 'Buesaco'],
 ['CO', '09', 'Buenos Aires'],
 ['CO', '36', 'Buenavista'],
 ['CO', '21', 'Bucarasica'],
 ['CO', '26', 'Bucaramanga'],
 ['CO', '36', 'Brice\xc3\xb1o'],
 ['CO', '36', 'Boyac\xc3\xa1'],
 ['CO', '26', 'Bol\xc3\xadvar'],
 ['CO', '02', 'Bol\xc3\xadvar'],
 ['CO', '29', 'Bol\xc3\xadvar'],
 ['CO', '09', 'Bol\xc3\xadvar'],
 ['CO', '11', 'Bojay\xc3\xa1'],
 ['CO', '33', 'Bojac\xc3\xa1'],
 ['CO', '21', 'Bochalema'],
 ['CO', '36', 'Boavita'],
 ['CO', '33', 'Bituima'],
 ['CO', '26', 'Betulia'],
 ['CO', '02', 'Betulia'],
 ['CO', '36', 'Bet\xc3\xa9itiva'],
 ['CO', '02', 'Betania'],
 ['CO', '36', 'Berbeo'],
 ['CO', '33', 'Beltr\xc3\xa1n'],
 ['CO', '02', 'Belmira'],
 ['CO', '02', 'Bello'],
 ['CO', '24', 'Bel\xc3\xa9n de Umbr\xc3\xada'],
 ['CO', '08', 'Bel\xc3\xa9n de los Andaqu\xc3\xades'],
 ['CO', '26', 'Bel\xc3\xa9n'],
 ['CO', '37', 'Belalc\xc3\xa1zar'],
 ['CO', '04', 'Barranquilla'],
 ['CO', '35', 'Barranco de Loba'],
 ['CO', '17', 'Barrancas'],
 ['CO', '26', 'Barrancabermeja'],
 ['CO', '26', 'Barichara'],
 ['CO', '02', 'Barbosa'],
 ['CO', '26', 'Barbosa'],
 ['CO', '20', 'Barbacoas'],
 ['CO', '16', 'Baraya'],
 ['CO', '04', 'Baranoa'],
 ['CO', '24', 'Balboa'],
 ['CO', '09', 'Balboa'],
 ['CO', '11', 'Bajo Baud\xc3\xb3'],
 ['CO', '11', 'Bagad\xc3\xb3'],
 ['CO', '12', 'Ayapel'],
 ['CO', '28', 'Ataco'],
 ['CO', '28', 'Armero'],
 ['CO', '02', 'Armenia'],
 ['CO', '23', 'Armenia'],
 ['CO', '35', 'Arjona'],
 ['CO', '29', 'Argelia'],
 ['CO', '09', 'Argelia'],
 ['CO', '36', 'Arcabuco'],
 ['CO', '02', 'Arboletes'],
 ['CO', '21', 'Arboledas'],
 ['CO', '20', 'Arboleda'],
 ['CO', '33', 'Arbel\xc3\xa1ez'],
 ['CO', '03', 'Arauca'],
 ['CO', '26', 'Aratoca'],
 ['CO', '37', 'Aranzazu'],
 ['CO', '38', 'Aracataca'],
 ['CO', '36', 'Aquitania'],
 ['CO', '24', 'Ap\xc3\xada'],
 ['CO', '28', 'Anzo\xc3\xa1tegui'],
 ['CO', '02', 'Anz\xc3\xa1'],
 ['CO', '02', 'Santaf\xc3\xa9 De Antioquia'],
 ['CO', '29', 'Ansermanuevo'],
 ['CO', '24', 'Anserma'],
 ['CO', '02', 'Anor\xc3\xad'],
 ['CO', '33', 'Anolaima'],
 ['CO', '02', 'Angostura'],
 ['CO', '02', 'Angel\xc3\xb3polis'],
 ['CO', '02', 'Andes'],
 ['CO', '29', 'Andaluc\xc3\xada'],
 ['CO', '20', 'Ancuy\xc3\xa1'],
 ['CO', '33', 'Anapoima'],
 ['CO', '28', 'Ambalema'],
 ['CO', '02', 'Amalfi'],
 ['CO', '02', 'Amag\xc3\xa1'],
 ['CO', '28', 'Alvarado'],
 ['CO', '11', 'Alto Baud\xc3\xb3'],
 ['CO', '16', 'Altamira'],
 ['CO', '28', 'Alpujarra'],
 ['CO', '36', 'Almeida'],
 ['CO', '09', 'Almaguer'],
 ['CO', '16', 'Algeciras'],
 ['CO', '38', 'Algarrobo'],
 ['CO', '02', 'Alejandr\xc3\xada'],
 ['CO', '20', 'Aldana'],
 ['CO', '29', 'Alcal\xc3\xa1'],
 ['CO', '26', 'Albania'],
 ['CO', '33', 'Alb\xc3\xa1n'],
 ['CO', '20', 'Alb\xc3\xa1n'],
 ['CO', '16', 'Aipe'],
 ['CO', '10', 'Agust\xc3\xadn Codazzi'],
 ['CO', '32', 'Aguazul'],
 ['CO', '33', 'Agua de Dios'],
 ['CO', '37', 'Aguadas'],
 ['CO', '10', 'Aguachica'],
 ['CO', '16', 'Agrado'],
 ['CO', '35', 'Ach\xc3\xad'],
 ['CO', '16', 'Acevedo'],
 ['CO', '11', 'Acand\xc3\xad'],
 ['CO', '19', 'Acac\xc3\xadas'],
 ['CO', '02', 'Abriaqu\xc3\xad'],
 ['CO', '21', '\xc3\x81brego'],
 ['CO', '02', 'Abejorral'],
 ['CO', '03', 'Arauquita'],
 ['CO', '03', 'Fortul'],
 ['CO', '03', 'Puerto Rond\xc3\xb3n'],
 ['CO', '03', 'Municipio de Arauca'],
 ['CO', '03', 'Cravo Norte'],
 ['CO', '36', 'G\xc3\xbcic\xc3\xa1n'],
 ['CO', '32', 'La Salina'],
 ['CO', '32', 'Sacama'],
 ['CO', '08', 'Municipio de Puerto Guzm\xc3\xa1n'],
 ['CO', '08', 'Municipio de Solita'],
 ['CO', '14', 'Municipio de Calamar'],
 ['CO', '19', 'Municipio de La Macarena'],
 ['CO', '08', 'Municipio de San Vicente de Cagu\xc3\xa1n'],
 ['CO', '14', 'Municipio San Jos\xc3\xa9 del Guaviare'],
 ['CO', '14', 'Municipio de Miraflores'],
 ['CO', '08', 'Municipio de Mil\xc3\xa1n'],
 ['CO', '08', 'Municipio de Puerto Rico'],
 ['CO', '08', 'Municipio de El Doncello'],
 ['CO', '08', 'Municipio de El Paujil'],
 ['CO', '19', 'Municipio de Mesetas'],
 ['CO', '19', 'Vista Hermosa'],
 ['CO', '14', 'Municipio de Puerto Concordia'],
 ['CO', '', 'Necocl\xc3\xad'],
 ['CO', '08', 'Albania'],
 ['CO', '38', 'Ariguan\xc3\xad'],
 ['CR', '08', 'Cant\xc3\xb3n V\xc3\xa1zquez de Coronado'],
 ['CR', '01', 'Cant\xc3\xb3n de Valverde Vega'],
 ['CR', '01', 'Cant\xc3\xb3n de Upala'],
 ['CR', '08', 'Cant\xc3\xb3n de Turrubares'],
 ['CR', '02', 'Cant\xc3\xb3n de Turrialba'],
 ['CR', '03', 'Cant\xc3\xb3n de Tilar\xc3\xa1n'],
 ['CR', '08', 'Cant\xc3\xb3n de Tib\xc3\xa1s'],
 ['CR', '08', 'Cant\xc3\xb3n de Tarraz\xc3\xba'],
 ['CR', '06', 'Cant\xc3\xb3n de Talamanca'],
 ['CR', '06', 'Cant\xc3\xb3n de Siquirres'],
 ['CR', '04', 'Cant\xc3\xb3n de Sarapiqu\xc3\xad'],
 ['CR', '04', 'Cant\xc3\xb3n de Santo Domingo'],
 ['CR', '03', 'Cant\xc3\xb3n de Santa Cruz'],
 ['CR', '04', 'Cant\xc3\xb3n de Santa B\xc3\xa1rbara'],
 ['CR', '08', 'Cant\xc3\xb3n de Santa Ana'],
 ['CR', '01', 'Cant\xc3\xb3n de San Ram\xc3\xb3n'],
 ['CR', '04', 'Cant\xc3\xb3n de San Rafael'],
 ['CR', '04', 'Cant\xc3\xb3n de San Pablo'],
 ['CR', '01', 'Cant\xc3\xb3n de San Mateo'],
 ['CR', '08', 'Cant\xc3\xb3n Central de San Jos\xc3\xa9'],
 ['CR', '04', 'Cant\xc3\xb3n de San Isidro'],
 ['CR', '01', 'Cant\xc3\xb3n de San Carlos'],
 ['CR', '08', 'Cant\xc3\xb3n de Puriscal'],
 ['CR', '07', 'Cant\xc3\xb3n Central de Puntarenas'],
 ['CR', '06', 'Cant\xc3\xb3n de Pococ\xc3\xad'],
 ['CR', '01', 'Cant\xc3\xb3n de Po\xc3\xa1s'],
 ['CR', '08', 'Cant\xc3\xb3n de P\xc3\xa9rez Zeled\xc3\xb3n'],
 ['CR', '07', 'Cant\xc3\xb3n de Parrita'],
 ['CR', '02', 'Cant\xc3\xb3n de Para\xc3\xadso'],
 ['CR', '01', 'Cant\xc3\xb3n de Palmares'],
 ['CR', '07', 'Cant\xc3\xb3n de Osa'],
 ['CR', '01', 'Cant\xc3\xb3n de Orotina'],
 ['CR', '02', 'Cant\xc3\xb3n de Oreamuno'],
 ['CR', '03', 'Cant\xc3\xb3n de Nicoya'],
 ['CR', '01', 'Cant\xc3\xb3n de Naranjo'],
 ['CR', '03', 'Cant\xc3\xb3n de Nandayure'],
 ['CR', '08', 'Cant\xc3\xb3n de Moravia'],
 ['CR', '08', 'Cant\xc3\xb3n de Mora'],
 ['CR', '07', 'Cant\xc3\xb3n de Montes de Oro'],
 ['CR', '08', 'Cant\xc3\xb3n de Montes de Oca'],
 ['CR', '06', 'Cant\xc3\xb3n de Matina'],
 ['CR', '01', 'Cant\xc3\xb3n de Los Chiles'],
 ['CR', '06', 'Cant\xc3\xb3n Central de Lim\xc3\xb3n'],
 ['CR', '03', 'Cant\xc3\xb3n Central de Liberia'],
 ['CR', '08', 'Cant\xc3\xb3n de Le\xc3\xb3n Cort\xc3\xa9s'],
 ['CR', '02', 'Cant\xc3\xb3n de La Uni\xc3\xb3n'],
 ['CR', '03', 'Cant\xc3\xb3n de La Cruz'],
 ['CR', '02', 'Cant\xc3\xb3n de Jim\xc3\xa9nez'],
 ['CR', '03', 'Cant\xc3\xb3n de Hojancha'],
 ['CR', '04', 'Cant\xc3\xb3n Central de Heredia'],
 ['CR', '01', 'Cant\xc3\xb3n de Guatuso'],
 ['CR', '06', 'Cant\xc3\xb3n de Gu\xc3\xa1cimo'],
 ['CR', '01', 'Cant\xc3\xb3n de Grecia'],
 ['CR', '07', 'Cant\xc3\xb3n de Golfito'],
 ['CR', '08', 'Cant\xc3\xb3n de Goicoechea'],
 ['CR', '04', 'Cant\xc3\xb3n de Flores'],
 ['CR', '07', 'Cant\xc3\xb3n de Esparza'],
 ['CR', '08', 'Cant\xc3\xb3n de Escaz\xc3\xba'],
 ['CR', '02', 'Cant\xc3\xb3n de El Guarco'],
 ['CR', '08', 'Cant\xc3\xb3n de Dota'],
 ['CR', '08', 'Cant\xc3\xb3n de Desamparados'],
 ['CR', '08', 'Cant\xc3\xb3n de Curridabat'],
 ['CR', '07', 'Cant\xc3\xb3n de Coto Brus'],
 ['CR', '07', 'Cant\xc3\xb3n de Corredores'],
 ['CR', '02', 'Cant\xc3\xb3n Central de Cartago'],
 ['CR', '03', 'Cant\xc3\xb3n de Carrillo'],
 ['CR', '03', 'Cant\xc3\xb3n de Ca\xc3\xb1as'],
 ['CR', '07', 'Cant\xc3\xb3n de Buenos Aires'],
 ['CR', '04', 'Cant\xc3\xb3n de Bel\xc3\xa9n'],
 ['CR', '04', 'Cant\xc3\xb3n de Barva'],
 ['CR', '03', 'Cant\xc3\xb3n de Bagaces'],
 ['CR', '01', 'Cant\xc3\xb3n de Atenas'],
 ['CR', '08', 'Cant\xc3\xb3n de Aserr\xc3\xad'],
 ['CR', '02', 'Cant\xc3\xb3n de Alvarado'],
 ['CR', '01', 'Cant\xc3\xb3n de Alfaro Ruiz'],
 ['CR', '08', 'Cant\xc3\xb3n de Alajuelita'],
 ['CR', '01', 'Cant\xc3\xb3n Central de Alajuela'],
 ['CR', '07', 'Cant\xc3\xb3n de Aguirre'],
 ['CR', '08', 'Cant\xc3\xb3n de Acosta'],
 ['CR', '03', 'Cant\xc3\xb3n de Abangares'],
 ['CR', '01', 'Cant\xc3\xb3n de San Ram\xc3\xb3n'],
 ['CU', '16', 'Municipio de Zulueta'],
 ['CU', '10', 'Municipio de Yateras'],
 ['CU', '14', 'Municipio de Yaguajay'],
 ['CU', '01', 'Municipio de Vi\xc3\xb1ales'],
 ['CU', '03', 'Municipio de Uni\xc3\xb3n de Reyes'],
 ['CU', '14', 'Municipio de Trinidad'],
 ['CU', '16', 'Municipio de Santo Domingo'],
 ['CU', '02', 'Municipio de Santiago de las Vegas'],
 ['CU', '15', 'Municipio de Santiago de Cuba'],
 ['CU', '02', 'Municipio de Santa Mar\xc3\xada del Rosario'],
 ['CU', '08', 'Municipio de Santa Isabel de las Lajas'],
 ['CU', '05', 'Municipio de Santa Cruz del Sur'],
 ['CU', 'MA', 'Municipio de Santa Cruz del Norte'],
 ['CU', '16', 'Municipio de Santa Clara'],
 ['CU', '03', 'Municipio de Santa Ana'],
 ['CU', 'MA', 'Municipio de San Nicol\xc3\xa1s'],
 ['CU', '01', 'Municipio de San Luis'],
 ['CU', '15', 'Municipio de San Luis'],
 ['CU', '01', 'Municipio de San Juan y Mart\xc3\xadnez'],
 ['CU', '16', 'Municipio de San Juan de los Yeras'],
 ['CU', '16', 'Municipio de San Juan de los Remedios'],
 ['CU', '03', 'Municipio de San Jos\xc3\xa9 de los Ramos'],
 ['CU', 'MA', 'Municipio de San Jos\xc3\xa9 de las Lajas'],
 ['CU', '08', 'Municipio de San Fernando de Camarones'],
 ['CU', '16', 'Municipio de San Diego del Valle'],
 ['CU', '14', 'Municipio de Sancti Sp\xc3\xadritus'],
 ['CU', 'AR', 'Municipio de San Crist\xc3\xb3bal'],
 ['CU', 'AR', 'Municipio de San Antonio de los Ba\xc3\xb1os'],
 ['CU', '16', 'Municipio de San Antonio de las Vueltas'],
 ['CU', 'MA', 'Municipio de San Antonio de las Vegas'],
 ['CU', 'MA', 'Municipio de San Antonio de Cabezas'],
 ['CU', '16', 'Municipio de Sagua la Grande'],
 ['CU', '12', 'Municipio de Sagua de T\xc3\xa1namo'],
 ['CU', '08', 'Municipio de Rodas'],
 ['CU', '02', 'Municipio de Regla'],
 ['CU', '16', 'Municipio de Ranchuelo'],
 ['CU', '16', 'Municipio de Rancho Veloz'],
 ['CU', 'MA', 'Municipio de Quivic\xc3\xa1n'],
 ['CU', '16', 'Municipio de Quemado de G\xc3\xbcines'],
 ['CU', '13', 'Municipio de Puerto Padre'],
 ['CU', '16', 'Municipio de Placetas'],
 ['CU', '01', 'Municipio de Pinar del R\xc3\xado'],
 ['CU', '03', 'Municipio de Perico'],
 ['CU', '03', 'Municipio de Pedro Betancourt'],
 ['CU', '08', 'Municipio de Palmira'],
 ['CU', '15', 'Municipio de Palma Soriano'],
 ['CU', '05', 'Municipio de Nuevitas'],
 ['CU', 'MA', 'Municipio de Nueva Paz'],
 ['CU', '09', 'Municipio de Niquero'],
 ['CU', '07', 'Municipio de Mor\xc3\xb3n'],
 ['CU', '11', 'Municipio de Melena del Sur'],
 ['CU', '12', 'Municipio de Mayar\xc3\xad'],
 ['CU', '03', 'Municipio de M\xc3\xa1ximo G\xc3\xb3mez'],
 ['CU', '03', 'Municipio de Matanzas'],
 ['CU', '03', 'Municipio de Mart\xc3\xad'],
 ['CU', 'AR', 'Municipio de Mariel'],
 ['CU', '02', 'Municipio de Marianao'],
 ['CU', '09', 'Municipio de Manzanillo'],
 ['CU', '01', 'Municipio de Mantua'],
 ['CU', '03', 'Municipio de Manguito'],
 ['CU', 'MA', 'Municipio de Madruga'],
 ['CU', '01', 'Municipio de Los Palacios'],
 ['CU', '03', 'Municipio de Los Arabos'],
 ['CU', '03', 'Limonar'],
 ['CU', '13', 'Municipio de Las Tunas'],
 ['CU', 'MA', 'Municipio de La Salud'],
 ['CU', '01', 'Municipio de La Palma'],
 ['CU', '16', 'Municipio de La Esperanza'],
 ['CU', '03', 'Municipio de Juan Gualberto G\xc3\xb3mez'],
 ['CU', '03', 'Municipio de Jovellanos'],
 ['CU', '09', 'Municipio de Jiguan\xc3\xad'],
 ['CU', '14', 'Municipio de Jatibonico'],
 ['CU', 'MA', 'Municipio de Jaruco'],
 ['CU', '03', 'Municipio de Jag\xc3\xbcey Grande'],
 ['CU', '12', 'Municipio de Holgu\xc3\xadn'],
 ['CU', 'AR', 'Municipio de G\xc3\xbcira de Melena'],
 ['CU', 'MA', 'Municipio de G\xc3\xbcines'],
 ['CU', '10', 'Municipio de Guant\xc3\xa1namo'],
 ['CU', '01', 'Municipio de Guane'],
 ['CU', 'AR', 'Municipio de Guanajay'],
 ['CU', '02', 'Municipio de Guanabacoa'],
 ['CU', '03', 'Municipio de Guamacaro'],
 ['CU', '05', 'Municipio de Gu\xc3\xa1imaro'],
 ['CU', '12', 'Municipio de Gibara'],
 ['CU', '14', 'Municipio de Fomento'],
 ['CU', '05', 'Municipio de Florida'],
 ['CU', '05', 'Municipio de Esmeralda'],
 ['CU', '16', 'Municipio de Encrucijada'],
 ['CU', '15', 'Municipio de El Cobre'],
 ['CU', '15', 'Municipio de El Caney'],
 ['CU', '08', 'Municipio de Cruces'],
 ['CU', '16', 'Municipio de Corralillo'],
 ['CU', '01', 'Municipio de Consolaci\xc3\xb3n del Sur'],
 ['CU', '03', 'Municipio de Col\xc3\xb3n'],
 ['CU', '16', 'Municipio de Cifuentes'],
 ['CU', '08', 'Municipio de Cienfuegos'],
 ['CU', '07', 'Municipio de Ciego de \xc3\x81vila'],
 ['CU', '03', 'Municipio de Carlos Rojas'],
 ['CU', '03', 'Municipio de C\xc3\xa1rdenas'],
 ['CU', 'AR', 'Municipio de Candelaria'],
 ['CU', '09', 'Municipio de Campechuela'],
 ['CU', '16', 'Municipio de Camajuan\xc3\xad'],
 ['CU', '05', 'Municipio de Camag\xc3\xbcey'],
 ['CU', '16', 'Municipio de Calabazar de Sagua'],
 ['CU', 'AR', 'Municipio de Caimito del Guayabal'],
 ['CU', '16', 'Municipio de Caibari\xc3\xa9n'],
 ['CU', 'AR', 'Municipio de Caba\xc3\xb1as'],
 ['CU', '14', 'Municipio de Cabaigu\xc3\xa1n'],
 ['CU', '03', 'Municipio de Bolondr\xc3\xb3n'],
 ['CU', '02', 'Municipio de Bejucal'],
 ['CU', '09', 'Municipio de Bayamo'],
 ['CU', 'AR', 'Municipio de Bauta'],
 ['CU', 'MA', 'Municipio de Bataban\xc3\xb3'],
 ['CU', '10', 'Municipio de Baracoa'],
 ['CU', '12', 'Municipio de Banes'],
 ['CU', 'AR', 'Municipio de Artemisa'],
 ['CU', 'MA', 'Municipio de Arcos de Canas\xc3\xad'],
 ['CU', '12', 'Municipio de Antilla'],
 ['CU', '15', 'Municipio de Alto Songo'],
 ['CU', 'AR', 'Municipio de Alqu\xc3\xadzar'],
 ['CU', '03', 'Municipio de Alacranes'],
 ['CU', '08', 'Municipio de Aguada de Pasajeros'],
 ['CU', 'MA', 'Municipio de Aguacate'],
 ['CU', '03', 'Municipio de Agramonte'],
 ['CU', '08', 'Municipio de Abreus'],
 ['CV', '04', 'Maio'],
 ['CZ', '78', 'Okres Znojmo'],
 ['CZ', '80', 'Okres \xc5\xbd\xc4\x8f\xc3\xa1r nad S\xc3\xa1zavou'],
 ['CZ', '78', 'Okres Vy\xc5\xa1kov'],
 ['CZ', '90', 'Okres Vset\xc3\xadn'],
 ['CZ', '86', 'Okres \xc3\x9ast\xc3\xad nad Orlic\xc3\xad'],
 ['CZ', '89', 'Okres \xc3\x9ast\xc3\xad nad Labem'],
 ['CZ', '90', 'Okres Uhersk\xc3\xa9 Hradi\xc5\xa1t\xc4\x9b'],
 ['CZ', '82', 'Okres Trutnov'],
 ['CZ', '80', 'Okres T\xc5\x99eb\xc3\xad\xc4\x8d'],
 ['CZ', '89', 'Okres Teplice'],
 ['CZ', '87', 'Okres Tachov'],
 ['CZ', '79', 'Okres T\xc3\xa1bor'],
 ['CZ', '86', 'Okres Svitavy'],
 ['CZ', '84', 'Okres \xc5\xa0umperk'],
 ['CZ', '79', 'Okres Strakonice'],
 ['CZ', '81', 'Okres Sokolov'],
 ['CZ', '83', 'Okres Semily'],
 ['CZ', '82', 'Okres Rychnov nad Kn\xc4\x9b\xc5\xbenou'],
 ['CZ', '87', 'Okres Rokycany'],
 ['CZ', '88', 'Okres Rakovn\xc3\xadk'],
 ['CZ', '84', 'Okres Prost\xc4\x9bjov'],
 ['CZ', '88', 'Okres P\xc5\x99\xc3\xadbram'],
 ['CZ', '84', 'Okres P\xc5\x99erov'],
 ['CZ', '88', 'Okres Praha-Z\xc3\xa1pad'],
 ['CZ', '88', 'Okres Praha-V\xc3\xbdchod'],
 ['CZ', '79', 'Okres Prachatice'],
 ['CZ', '87', 'Okres Plze\xc5\x88-Sever'],
 ['CZ', '87', 'Okres Plze\xc5\x88-M\xc4\x9bsto'],
 ['CZ', '87', 'Okres Plze\xc5\x88-Jih'],
 ['CZ', '79', 'Okres P\xc3\xadsek'],
 ['CZ', '80', 'Okres Pelh\xc5\x99imov'],
 ['CZ', '86', 'Okres Pardubice'],
 ['CZ', '85', 'Okres Ostrava-M\xc4\x9bsto'],
 ['CZ', '85', 'Okres Opava'],
 ['CZ', '84', 'Okres Olomouc'],
 ['CZ', '88', 'Okres Nymburk'],
 ['CZ', '85', 'Okres Nov\xc3\xbd Ji\xc4\x8d\xc3\xadn'],
 ['CZ', '82', 'Okres N\xc3\xa1chod'],
 ['CZ', '89', 'Okres Most'],
 ['CZ', '88', 'Okres Mlad\xc3\xa1 Boleslav'],
 ['CZ', '88', 'Okres M\xc4\x9bln\xc3\xadk'],
 ['CZ', '89', 'Okres Louny'],
 ['CZ', '89', 'Okres Litom\xc4\x9b\xc5\x99ice'],
 ['CZ', '83', 'Okres Liberec'],
 ['CZ', '88', 'Okres Kutn\xc3\xa1 Hora'],
 ['CZ', '90', 'Okres Krom\xc4\x9b\xc5\x99\xc3\xad\xc5\xbe'],
 ['CZ', '88', 'Okres Kol\xc3\xadn'],
 ['CZ', '87', 'Okres Klatovy'],
 ['CZ', '88', 'Okres Kladno'],
 ['CZ', '85', 'Okres Karvin\xc3\xa1'],
 ['CZ', '81', 'Okres Karlovy Vary'],
 ['CZ', '79', 'Okres Jind\xc5\x99ich\xc5\xafv Hradec'],
 ['CZ', '80', 'Okres Jihlava'],
 ['CZ', '82', 'Okres Ji\xc4\x8d\xc3\xadn'],
 ['CZ', '83', 'Okres Jablonec nad Nisou'],
 ['CZ', '82', 'Okres Hradec Kr\xc3\xa1lov\xc3\xa9'],
 ['CZ', '78', 'Okres Hodon\xc3\xadn'],
 ['CZ', '80', 'Okres Havl\xc3\xad\xc4\x8dk\xc5\xafv Brod'],
 ['CZ', '90', 'Okres Zl\xc3\xadn'],
 ['CZ', '85', 'Okres Fr\xc3\xbddek-M\xc3\xadstek'],
 ['CZ', '87', 'Okres Doma\xc5\xbelice'],
 ['CZ', '89', 'Okres D\xc4\x9b\xc4\x8d\xc3\xadn'],
 ['CZ', '86', 'Okres Chrudim'],
 ['CZ', '89', 'Okres Chomutov'],
 ['CZ', '81', 'Okres Cheb'],
 ['CZ', '79', 'Okres \xc4\x8cesk\xc3\xbd Krumlov'],
 ['CZ', '79', 'Okres \xc4\x8cesk\xc3\xa9 Bud\xc4\x9bjovice'],
 ['CZ', '83', 'Okres \xc4\x8cesk\xc3\xa1 L\xc3\xadpa'],
 ['CZ', '85', 'Okres Brunt\xc3\xa1l'],
 ['CZ', '78', 'Okres Brno-Venkov'],
 ['CZ', '78', 'M\xc4\x9bsto Brno'],
 ['CZ', '78', 'Okres B\xc5\x99eclav'],
 ['CZ', '78', 'Okres Blansko'],
 ['CZ', '88', 'Okres Beroun'],
 ['CZ', '88', 'Okres Bene\xc5\xa1ov'],
 ['CZ', '84', 'Okres Jesen\xc3\xadk'],
 ['CZ', '52', 'Okres Praha'],
 ['CZ', '52', 'Praha 1'],
 ['CZ', '52', 'Praha 2'],
 ['CZ', '52', 'Praha 3'],
 ['CZ', '52', 'Praha 4'],
 ['CZ', '52', 'Praha 5'],
 ['CZ', '52', 'Praha 6'],
 ['CZ', '52', 'Praha 7'],
 ['CZ', '52', 'Praha 8'],
 ['CZ', '52', 'Praha 9'],
 ['CZ', '52', 'Praha 10'],
 ['CZ', '52', 'Praha 11'],
 ['CZ', '52', 'Praha 12'],
 ['CZ', '52', 'Praha 13'],
 ['CZ', '52', 'Praha 14'],
 ['CZ', '52', 'Praha 15'],
 ['CZ', '52', 'Praha 16'],
 ['CZ', '52', 'Praha 17'],
 ['CZ', '52', 'Praha 18'],
 ['CZ', '52', 'Praha 19'],
 ['CZ', '52', 'Praha 20'],
 ['CZ', '52', 'Praha 21'],
 ['CZ', '52', 'Praha 22'],
 ['DE', '02', 'Regierungsbezirk Unterfranken'],
 ['DE', '02', 'Regierungsbezirk Schwaben'],
 ['DE', '02', 'Regierungsbezirk Oberpfalz'],
 ['DE', '02', 'Regierungsbezirk Oberfranken'],
 ['DE', '02', 'Regierungsbezirk Oberbayern'],
 ['DE', '02', 'Regierungsbezirk Niederbayern'],
 ['DE', '07', 'Regierungsbezirk M\xc3\xbcnster'],
 ['DE', '02', 'Regierungsbezirk Mittelfranken'],
 ['DE', '07', 'Regierungsbezirk K\xc3\xb6ln'],
 ['DE', '05', 'Regierungsbezirk Kassel'],
 ['DE', '01', 'Regierungsbezirk Freiburg'],
 ['DE', '07', 'Regierungsbezirk D\xc3\xbcsseldorf'],
 ['DE', '07', 'Regierungsbezirk Detmold'],
 ['DE', '05', 'Regierungsbezirk Darmstadt'],
 ['DE', '07', 'Regierungsbezirk Arnsberg'],
 ['DE', '01', 'Regierungsbezirk Karlsruhe'],
 ['DE', '01', 'Regierungsbezirk Stuttgart'],
 ['DE', '01', 'Regierungsbezirk T\xc3\xbcbingen'],
 ['DE', '05', 'Regierungsbezirk Gie\xc3\x9fen'],
 ['DE', '13', 'Direktionsbezirk Dresden'],
 ['DE', '13', 'Direktionsbezirk Leipzig'],
 ['DE', '13', 'Direktionsbezirk Chemnitz'],
 ['DJ', '04', 'Obock'],
 ['DK', '20', 'Vordingborg Kommune'],
 ['DK', '18', 'Viborg Kommune'],
 ['DK', '21', 'Vejle Kommune'],
 ['DK', '21', 'Vejen Kommune'],
 ['DK', '17', 'Vallensb\xc3\xa6k Kommune'],
 ['DK', '21', 'T\xc3\xb8nder Kommune'],
 ['DK', '19', 'Thisted Kommune'],
 ['DK', '17', 'T\xc3\xa5rnby Kommune'],
 ['DK', '21', 'Svendborg Kommune'],
 ['DK', '18', 'Struer Kommune'],
 ['DK', '20', 'Stevns Kommune'],
 ['DK', '20', 'Sor\xc3\xb8 Kommune'],
 ['DK', '21', 'S\xc3\xb8nderborg Kommune'],
 ['DK', '20', 'Solr\xc3\xb8d Kommune'],
 ['DK', '20', 'Slagelse Kommune'],
 ['DK', '18', 'Skive Kommune'],
 ['DK', '18', 'Skanderborg Kommune'],
 ['DK', '18', 'Silkeborg Kommune'],
 ['DK', '18', 'Sams\xc3\xb8 Kommune'],
 ['DK', '20', 'Roskilde Kommune'],
 ['DK', '17', 'R\xc3\xb8dovre Kommune'],
 ['DK', '20', 'Ringsted Kommune'],
 ['DK', '18', 'Randers Kommune'],
 ['DK', '21', 'Odense Kommune'],
 ['DK', '18', 'Odder Kommune'],
 ['DK', '21', 'Nyborg Kommune'],
 ['DK', '20', 'N\xc3\xa6stved Kommune'],
 ['DK', '19', 'Mors\xc3\xb8 Kommune'],
 ['DK', '21', 'Middelfart Kommune'],
 ['DK', '17', 'Lyngby-T\xc3\xa5rb\xc3\xa6k Kommune'],
 ['DK', '19', 'L\xc3\xa6so Kommune'],
 ['DK', '18', 'Lemvig Kommune'],
 ['DK', '20', 'Lejre Kommune'],
 ['DK', '17', 'K\xc3\xb8benhavns Kommune'],
 ['DK', '21', 'Kolding Kommune'],
 ['DK', '20', 'K\xc3\xb8ge Kommune'],
 ['DK', '21', 'Kerteminde Kommune'],
 ['DK', '20', 'Kalundborg Kommune'],
 ['DK', '17', 'Ish\xc3\xb8j Kommune'],
 ['DK', '17', 'Hvidovre Kommune'],
 ['DK', '17', 'H\xc3\xb8rsholm Kommune'],
 ['DK', '18', 'Horsens Kommune'],
 ['DK', '18', 'Holstebro Kommune'],
 ['DK', '20', 'Holb\xc3\xa6k Kommune'],
 ['DK', '19', 'Hj\xc3\xb8rring Kommune'],
 ['DK', '17', 'Hiller\xc3\xb8d Kommune'],
 ['DK', '18', 'Herning Kommune'],
 ['DK', '17', 'Herlev Kommune'],
 ['DK', '17', 'Helsing\xc3\xb8r Kommune'],
 ['DK', '18', 'Hedensted Kommune'],
 ['DK', '21', 'Haderslev Kommune'],
 ['DK', '20', 'Greve Kommune'],
 ['DK', '17', 'Glostrup Kommune'],
 ['DK', '17', 'Gladsakse Kommune'],
 ['DK', '17', 'Gentofte Kommune'],
 ['DK', '17', 'Frederikssund Kommune'],
 ['DK', '19', 'Frederikshavn Kommune'],
 ['DK', '17', 'Frederiksberg Kommune'],
 ['DK', '21', 'Fredericia Kommune'],
 ['DK', '21', 'Fan\xc3\xb8 Kommune'],
 ['DK', '21', 'Varde Kommune'],
 ['DK', '17', 'Drag\xc3\xb8r Kommune'],
 ['DK', '17', 'Christians\xc3\xb8'],
 ['DK', '19', 'Br\xc3\xb8nderslev Kommune'],
 ['DK', '17', 'Br\xc3\xb8ndby Kommune'],
 ['DK', '17', 'Bornholm Kommune'],
 ['DK', '21', 'Billund Kommune'],
 ['DK', '17', 'Ballerup Kommune'],
 ['DK', '21', 'Assens Kommune'],
 ['DK', '18', '\xc3\x85rhus Kommune'],
 ['DK', '17', 'Aller\xc3\xb8d Kommune'],
 ['DK', '17', 'Albertslund Kommune'],
 ['DK', '21', '\xc3\x85benr\xc3\xa5 Kommune'],
 ['DK', '21', 'Esbjerg Kommune'],
 ['DK', '19', 'Jammerbugt Kommune'],
 ['DK', '17', 'Fures\xc3\xb8 Kommune'],
 ['DK', '20', 'Odsherred Kommune'],
 ['DK', '21', 'Nordfyns Kommune'],
 ['DK', '19', 'Mariagerfjord Kommune'],
 ['DK', '20', 'Faxe Kommune'],
 ['DK', '18', 'Ringk\xc3\xb8bing-Skjern Kommune'],
 ['DK', '18', 'Norddjurs Kommune'],
 ['DK', '19', '\xc3\x85lborg Kommune'],
 ['DK', '21', '\xc3\x86r\xc3\xb8 Kommune'],
 ['DK', '21', 'Faaborg-Midtfyn Kommune'],
 ['DK', '19', 'Rebild Kommune'],
 ['DK', '17', 'H\xc3\xb8je-Taastrup Kommune'],
 ['DK', '19', 'Vesthimmerland Kommune'],
 ['DK', '17', 'Fredensborg Kommune'],
 ['DK', '17', 'Halsn\xc3\xa6s Kommune'],
 ['DK', '21', 'Langeland Kommune'],
 ['DK', '17', 'Rudersdal Kommune'],
 ['DK', '18', 'Ikast-Brande Kommune'],
 ['DK', '17', 'Gribskov Kommune'],
 ['DK', '18', 'Favrskov Kommune'],
 ['DK', '18', 'Syddjurs Kommune'],
 ['DK', '17', 'Egedal Kommune'],
 ['DK', '20', 'Guldborgsund Kommune'],
 ['DK', '20', 'Lolland Kommune'],
 ['DO', '32', 'Yamas\xc3\xa1'],
 ['DO', '33', 'Yaguate'],
 ['DO', '15', 'Villa V\xc3\xa1squez'],
 ['DO', '19', 'Villa Tapia'],
 ['DO', '06', 'Villa Riva'],
 ['DO', '02', 'Villa Jaragua'],
 ['DO', '18', 'Villa Isabela'],
 ['DO', '33', 'Villa Altagracia'],
 ['DO', '03', 'Vicente Noble'],
 ['DO', '23', 'Vallejuelo'],
 ['DO', '19', 'Tenares'],
 ['DO', '25', 'Tamboril'],
 ['DO', '02', 'Tamayo'],
 ['DO', '18', 'Sos\xc3\xbaa'],
 ['DO', '37', 'Santo Domingo'],
 ['DO', '25', 'Santiago de los Caballeros'],
 ['DO', '10', 'San Rafael del Yuma'],
 ['DO', '24', 'San Pedro de Macor\xc3\xads'],
 ['DO', '23', 'San Juan de la Maguana'],
 ['DO', '36', 'San Jos\xc3\xa9 de Ocoa'],
 ['DO', '25', 'San Jos\xc3\xa9 de Las Matas'],
 ['DO', '06', 'San Francisco de Macor\xc3\xads'],
 ['DO', '33', 'San Crist\xc3\xb3bal'],
 ['DO', '20', 'S\xc3\xa1nchez'],
 ['DO', '20', 'Saman\xc3\xa1'],
 ['DO', '19', 'Salcedo'],
 ['DO', '26', 'Sabaneta'],
 ['DO', '32', 'Sabana Grande de Boy\xc3\xa1'],
 ['DO', '29', 'Sabana de La Mar'],
 ['DO', '14', 'R\xc3\xado San Juan'],
 ['DO', '04', 'Restauraci\xc3\xb3n'],
 ['DO', '24', 'Ram\xc3\xb3n Santana'],
 ['DO', '18', 'Puerto Plata'],
 ['DO', '09', 'Postrer R\xc3\xado'],
 ['DO', '06', 'Pimentel'],
 ['DO', '01', 'Peralta'],
 ['DO', '15', 'Pepillo Salcedo'],
 ['DO', '11', 'Pedro Santana'],
 ['DO', '16', 'Pedernales'],
 ['DO', '03', 'Para\xc3\xadso'],
 ['DO', '01', 'Padre Las Casas'],
 ['DO', '16', 'Oviedo'],
 ['DO', '35', 'Nizao'],
 ['DO', '02', 'Neiba'],
 ['DO', '14', 'Nagua'],
 ['DO', '32', 'Monte Plata'],
 ['DO', '15', 'Monte Cristi'],
 ['DO', '26', 'Monci\xc3\xb3n'],
 ['DO', '08', 'Moca'],
 ['DO', '28', 'Miches'],
 ['DO', '27', 'Mao'],
 ['DO', '31', 'Maim\xc3\xb3n'],
 ['DO', '18', 'Luper\xc3\xb3n'],
 ['DO', '24', 'Los Llanos'],
 ['DO', '18', 'Los Hidalgos'],
 ['DO', '04', 'Loma de Cabrera'],
 ['DO', '25', 'Licey al Medio'],
 ['DO', '30', 'La Vega'],
 ['DO', '15', 'Las Matas de Santa Cruz'],
 ['DO', '23', 'Las Matas de Farf\xc3\xa1n'],
 ['DO', '12', 'La Romana'],
 ['DO', '27', 'Laguna Salada'],
 ['DO', '09', 'La Descubierta'],
 ['DO', '09', 'Jiman\xc3\xad'],
 ['DO', '30', 'Jarabacoa'],
 ['DO', '25', 'J\xc3\xa1nico'],
 ['DO', '18', 'Imbert'],
 ['DO', '11', 'Hondo Valle'],
 ['DO', '10', 'Hig\xc3\xbcey'],
 ['DO', '29', 'Hato Mayor'],
 ['DO', '15', 'Guayub\xc3\xadn'],
 ['DO', '12', 'Guaymate'],
 ['DO', '08', 'Gaspar Hern\xc3\xa1ndez'],
 ['DO', '21', 'Fantino'],
 ['DO', '27', 'Esperanza'],
 ['DO', '03', 'Enriquillo'],
 ['DO', '29', 'El Valle'],
 ['DO', '28', 'El Seibo'],
 ['DO', '11', 'El Llano'],
 ['DO', '14', 'El Factor'],
 ['DO', '23', 'El Cercado'],
 ['DO', '09', 'Duverg\xc3\xa9'],
 ['DO', '04', 'Dajab\xc3\xb3n'],
 ['DO', '21', 'Cotu\xc3\xad'],
 ['DO', '30', 'Constanza'],
 ['DO', '11', 'Comendador'],
 ['DO', '21', 'Cevicos'],
 ['DO', '08', 'Cayetano Germos\xc3\xa9n'],
 ['DO', '06', 'Castillo'],
 ['DO', '15', 'Casta\xc3\xb1uelas'],
 ['DO', '33', 'Cambita Garabitos'],
 ['DO', '14', 'Cabrera'],
 ['DO', '03', 'Cabral'],
 ['DO', '31', 'Bonao'],
 ['DO', '23', 'Bohech\xc3\xado'],
 ['DO', '25', 'Bison\xc3\xb3'],
 ['DO', '32', 'Bayaguana'],
 ['DO', '03', 'Barahona'],
 ['DO', '11', 'B\xc3\xa1nica'],
 ['DO', '35', 'Ban\xc3\xad'],
 ['DO', '33', 'Bajos de Haina'],
 ['DO', '01', 'Azua'],
 ['DO', '18', 'Altamira'],
 ['DZ', '45', 'Bukombe District'],
 ['EC', '08', 'Cant\xc3\xb3n Zaruma'],
 ['EC', '20', 'Cant\xc3\xb3n Zamora'],
 ['EC', '20', 'Cant\xc3\xb3n Yantzaza'],
 ['EC', '10', 'Cant\xc3\xb3n Yaguachi'],
 ['EC', '20', 'Cant\xc3\xb3n Yacuambi'],
 ['EC', '13', 'Cant\xc3\xb3n Vinces'],
 ['EC', '13', 'Cant\xc3\xb3n Ventanas'],
 ['EC', '14', 'Cant\xc3\xb3n Veinticuatro de Mayo'],
 ['EC', '24', 'Cant\xc3\xb3n Urellana'],
 ['EC', '13', 'Cant\xc3\xb3n Urdaneta'],
 ['EC', '10', 'Cant\xc3\xb3n Urbina Jado'],
 ['EC', '05', 'Cant\xc3\xb3n Tulc\xc3\xa1n'],
 ['EC', '23', 'Cant\xc3\xb3n Tena'],
 ['EC', '22', 'Cant\xc3\xb3n Sucumb\xc3\xados'],
 ['EC', '15', 'Cant\xc3\xb3n Suc\xc3\xbaa'],
 ['EC', '14', 'Cant\xc3\xb3n Sucre'],
 ['EC', '12', 'Cant\xc3\xb3n Sozoranga'],
 ['EC', '02', 'Cant\xc3\xb3n Sigsig'],
 ['EC', '12', 'Cant\xc3\xb3n Saraguro'],
 ['EC', '07', 'Cant\xc3\xb3n Saquisil\xc3\xad'],
 ['EC', '26', 'Cant\xc3\xb3n Santo Domingo de los Colorados'],
 ['EC', '15', 'Cant\xc3\xb3n Santiago'],
 ['EC', '08', 'Cant\xc3\xb3n Santa Rosa'],
 ['EC', '02', 'Cant\xc3\xb3n Santa Isabel'],
 ['EC', '25', 'Cant\xc3\xb3n Santa Elena'],
 ['EC', '01', 'Cant\xc3\xb3n Santa Cruz'],
 ['EC', '14', 'Cant\xc3\xb3n Santa Ana'],
 ['EC', '03', 'Cant\xc3\xb3n San Miguel'],
 ['EC', '09', 'Cant\xc3\xb3n San Lorenzo'],
 ['EC', '01', 'Cant\xc3\xb3n San Crist\xc3\xb3bal'],
 ['EC', '10', 'Cant\xc3\xb3n Samborond\xc3\xb3n'],
 ['EC', '25', 'Cant\xc3\xb3n Salinas'],
 ['EC', '07', 'Cant\xc3\xb3n Salcedo'],
 ['EC', '18', 'Cant\xc3\xb3n Rumi\xc3\xb1ahui'],
 ['EC', '14', 'Cant\xc3\xb3n Rocafuerte'],
 ['EC', '06', 'Cant\xc3\xb3n Riobamba'],
 ['EC', '18', 'Cant\xc3\xb3n Quito'],
 ['EC', '09', 'Cant\xc3\xb3n Quinind\xc3\xa9'],
 ['EC', '23', 'Cant\xc3\xb3n Quijos'],
 ['EC', '13', 'Cant\xc3\xb3n Quevedo'],
 ['EC', '19', 'Cant\xc3\xb3n Quero'],
 ['EC', '12', 'Cant\xc3\xb3n Puyango'],
 ['EC', '22', 'Cant\xc3\xb3n Putumayo'],
 ['EC', '07', 'Cant\xc3\xb3n Pujil\xc3\xad'],
 ['EC', '13', 'Cant\xc3\xb3n Puebloviejo'],
 ['EC', '14', 'Cant\xc3\xb3n Portoviejo'],
 ['EC', '08', 'Cant\xc3\xb3n Portovelo'],
 ['EC', '08', 'Cant\xc3\xb3n Pi\xc3\xb1as'],
 ['EC', '11', 'Cant\xc3\xb3n Pimampiro'],
 ['EC', '19', 'Cant\xc3\xb3n P\xc3\xadllaro'],
 ['EC', '19', 'Cant\xc3\xb3n Pelileo'],
 ['EC', '18', 'Cant\xc3\xb3n Pedro Moncayo'],
 ['EC', '02', 'Cant\xc3\xb3n Paute'],
 ['EC', '19', 'Cant\xc3\xb3n Patate'],
 ['EC', '17', 'Cant\xc3\xb3n Pastaza'],
 ['EC', '08', 'Cant\xc3\xb3n Pasaje'],
 ['EC', '07', 'Cant\xc3\xb3n Pangua'],
 ['EC', '12', 'Cant\xc3\xb3n Paltas'],
 ['EC', '15', 'Cant\xc3\xb3n Palora'],
 ['EC', '14', 'Cant\xc3\xb3n Paj\xc3\xa1n'],
 ['EC', '11', 'Cant\xc3\xb3n Otavalo'],
 ['EC', '10', 'Cant\xc3\xb3n Naranjito'],
 ['EC', '10', 'Cant\xc3\xb3n Naranjal'],
 ['EC', '09', 'Cant\xc3\xb3n Muisne'],
 ['EC', '15', 'Cant\xc3\xb3n Morona'],
 ['EC', '05', 'Cant\xc3\xb3n Mont\xc3\xbafar'],
 ['EC', '14', 'Cant\xc3\xb3n Montecristi'],
 ['EC', '05', 'Cant\xc3\xb3n Mira'],
 ['EC', '10', 'Cant\xc3\xb3n Milagro'],
 ['EC', '17', 'Cant\xc3\xb3n Mera'],
 ['EC', '18', 'Cant\xc3\xb3n Mej\xc3\xada'],
 ['EC', '14', 'Cant\xc3\xb3n Manta'],
 ['EC', '08', 'Cant\xc3\xb3n Machala'],
 ['EC', '12', 'Cant\xc3\xb3n Macar\xc3\xa1'],
 ['EC', '12', 'Cant\xc3\xb3n Loja'],
 ['EC', '15', 'Cant\xc3\xb3n Lim\xc3\xb3n Indanza'],
 ['EC', '07', 'Cant\xc3\xb3n Latacunga'],
 ['EC', '22', 'Cant\xc3\xb3n Lago Agrio'],
 ['EC', '14', 'Cant\xc3\xb3n Jun\xc3\xadn'],
 ['EC', '14', 'Cant\xc3\xb3n Jipijapa'],
 ['EC', '01', 'Cant\xc3\xb3n Isabela'],
 ['EC', '11', 'Cant\xc3\xb3n Ibarra'],
 ['EC', '08', 'Cant\xc3\xb3n Huaquillas'],
 ['EC', '10', 'Cant\xc3\xb3n Guayaquil'],
 ['EC', '03', 'Cant\xc3\xb3n Guaranda'],
 ['EC', '06', 'Cant\xc3\xb3n Guano'],
 ['EC', '06', 'Cant\xc3\xb3n Guamote'],
 ['EC', '15', 'Cant\xc3\xb3n Gualaquiza'],
 ['EC', '02', 'Cant\xc3\xb3n Gualaceo'],
 ['EC', '08', 'Cant\xc3\xb3n Guabo'],
 ['EC', '12', 'Cant\xc3\xb3n Gonzanam\xc3\xa1'],
 ['EC', '02', 'Cant\xc3\xb3n Gir\xc3\xb3n'],
 ['EC', '12', 'Cant\xc3\xb3n Espindola'],
 ['EC', '05', 'Cant\xc3\xb3n Espejo'],
 ['EC', '09', 'Cant\xc3\xb3n Esmeraldas'],
 ['EC', '09', 'Cant\xc3\xb3n Eloy Alfaro'],
 ['EC', '10', 'Cant\xc3\xb3n El Empalme'],
 ['EC', '14', 'Cant\xc3\xb3n El Carmen'],
 ['EC', '10', 'Cant\xc3\xb3n Daule'],
 ['EC', '02', 'Cant\xc3\xb3n Cuenca'],
 ['EC', '11', 'Cant\xc3\xb3n Cotacachi'],
 ['EC', '06', 'Cant\xc3\xb3n Colta'],
 ['EC', '06', 'Cant\xc3\xb3n Chunchi'],
 ['EC', '14', 'Cant\xc3\xb3n Chone'],
 ['EC', '20', 'Cant\xc3\xb3n Chinchipe'],
 ['EC', '03', 'Cant\xc3\xb3n Chimbo'],
 ['EC', '03', 'Cant\xc3\xb3n Chillanes'],
 ['EC', '12', 'Cant\xc3\xb3n Celica'],
 ['EC', '18', 'Cant\xc3\xb3n Cayambe'],
 ['EC', '12', 'Cant\xc3\xb3n Catamayo'],
 ['EC', '04', 'Cant\xc3\xb3n Ca\xc3\xb1ar'],
 ['EC', '12', 'Cant\xc3\xb3n Calvas'],
 ['EC', '14', 'Cant\xc3\xb3n Bol\xc3\xadvar'],
 ['EC', '04', 'Cant\xc3\xb3n Bibli\xc3\xa1n'],
 ['EC', '19', 'Cant\xc3\xb3n Ba\xc3\xb1os'],
 ['EC', '10', 'Cant\xc3\xb3n Balzar'],
 ['EC', '13', 'Cant\xc3\xb3n Babahoyo'],
 ['EC', '13', 'Cant\xc3\xb3n Baba'],
 ['EC', '04', 'Cant\xc3\xb3n Azogues'],
 ['EC', '08', 'Cant\xc3\xb3n Arenillas'],
 ['EC', '23', 'Cant\xc3\xb3n Archidona'],
 ['EC', '11', 'Cant\xc3\xb3n Antonio Ante'],
 ['EC', '19', 'Cant\xc3\xb3n Ambato'],
 ['EC', '06', 'Cant\xc3\xb3n Alaus\xc3\xad'],
 ['EC', '24', 'Cant\xc3\xb3n Aguarico'],
 ['EC', '02', 'Cant\xc3\xb3n San Fernando'],
 ['EC', '02', 'Cant\xc3\xb3n Nab\xc3\xb3n'],
 ['EE', '03', 'Kohtla-J\xc3\xa4rve linn'],
 ['EE', '03', 'Narva linn'],
 ['EE', '11', 'P\xc3\xa4rnu linn'],
 ['EE', '03', 'Sillam\xc3\xa4e linn'],
 ['EE', '01', 'Tallinna linn'],
 ['EE', '18', 'Elva linn'],
 ['EE', '02', 'Emmaste vald'],
 ['EE', '21', 'Haanja vald'],
 ['EE', '07', 'Haapsalu linn'],
 ['EE', '18', 'Haaslava vald'],
 ['EE', '11', 'Halinga vald'],
 ['EE', '08', 'Haljala vald'],
 ['EE', '20', 'Halliste vald'],
 ['EE', '07', 'Hanila vald'],
 ['EE', '01', 'Harku vald'],
 ['EE', '19', 'Helme vald'],
 ['EE', '19', 'Hummuli vald'],
 ['EE', '11', 'H\xc3\xa4\xc3\xa4demeeste vald'],
 ['EE', '03', 'Iisaku vald'],
 ['EE', '03', 'Illuka vald'],
 ['EE', '04', 'Imavere vald'],
 ['EE', '13', 'Juuru vald'],
 ['EE', '01', 'J\xc3\xb5el\xc3\xa4htme vald'],
 ['EE', '05', 'J\xc3\xb5geva vald'],
 ['EE', '05', 'J\xc3\xb5geva linn'],
 ['EE', '03', 'J\xc3\xb5hvi vald'],
 ['EE', '04', 'J\xc3\xa4rva-Jaani vald'],
 ['EE', '13', 'J\xc3\xa4rvakandi vald'],
 ['EE', '14', 'Kaarma vald'],
 ['EE', '08', 'Kadrina vald'],
 ['EE', '11', 'Kaisma vald'],
 ['EE', '13', 'Kaiu vald'],
 ['EE', '18', 'Kallaste linn'],
 ['EE', '18', 'Kambja vald'],
 ['EE', '12', 'Kanepi vald'],
 ['EE', '04', 'Kareda vald'],
 ['EE', '19', 'Karula vald'],
 ['EE', '13', 'Kehtna vald'],
 ['EE', '01', 'Keila vald'],
 ['EE', '01', 'Keila linn'],
 ['EE', '01', 'Kernu vald'],
 ['EE', '14', 'Kihelkonna vald'],
 ['EE', '11', 'Kihnu vald'],
 ['EE', '01', 'Kiili vald'],
 ['EE', '03', 'Kivi\xc3\xb5li linn'],
 ['EE', '04', 'Koeru vald'],
 ['EE', '13', 'Kohila vald'],
 ['EE', '03', 'Kohtla vald'],
 ['EE', '05', 'Tabivere vald'],
 ['EE', '07', 'Taebla vald'],
 ['EE', '19', 'Taheva vald'],
 ['EE', '03', 'Kohtla-N\xc3\xb5mme vald'],
 ['EE', '04', 'Koigi vald'],
 ['EE', '20', 'Kolga-Jaani vald'],
 ['EE', '18', 'Konguta vald'],
 ['EE', '11', 'Koonga vald'],
 ['EE', '01', 'Kose vald'],
 ['EE', '07', 'Kullamaa vald'],
 ['EE', '08', 'Kunda linn'],
 ['EE', '12', 'K\xc3\xb5lleste vald'],
 ['EE', '20', 'K\xc3\xb5o vald'],
 ['EE', '20', 'K\xc3\xb5pu vald'],
 ['EE', '01', 'K\xc3\xb5ue vald'],
 ['EE', '02', 'K\xc3\xa4ina vald'],
 ['EE', '02', 'K\xc3\xa4rdla linn'],
 ['EE', '14', 'K\xc3\xa4rla vald'],
 ['EE', '13', 'K\xc3\xa4ru vald'],
 ['EE', '08', 'Laekvere vald'],
 ['EE', '18', 'Laeva vald'],
 ['EE', '14', 'Leisi vald'],
 ['EE', '07', 'Lihula vald'],
 ['EE', '03', 'Lohusuu vald'],
 ['EE', '01', 'Loksa linn'],
 ['EE', '18', 'Luunja vald'],
 ['EE', '03', 'L\xc3\xbcganuse vald'],
 ['EE', '14', 'L\xc3\xbcmanda vald'],
 ['EE', '01', 'Maardu linn'],
 ['EE', '03', 'Maidla vald'],
 ['EE', '07', 'Martna vald'],
 ['EE', '18', 'Meeksi vald'],
 ['EE', '21', 'Merem\xc3\xa4e vald'],
 ['EE', '12', 'Mikitam\xc3\xa4e vald'],
 ['EE', '21', 'Misso vald'],
 ['EE', '12', 'Mooste vald'],
 ['EE', '14', 'Muhu vald'],
 ['EE', '14', 'Mustjala vald'],
 ['EE', '05', 'Mustvee linn'],
 ['EE', '08', 'Tamsalu vald'],
 ['EE', '21', 'Urvaste vald'],
 ['EE', '11', 'Tahkuranna vald'],
 ['EE', '03', 'Vaivara vald'],
 ['EE', '19', 'Valga linn'],
 ['EE', '20', 'M\xc3\xb5isak\xc3\xbcla linn'],
 ['EE', '21', 'M\xc3\xb5niste vald'],
 ['EE', '03', 'M\xc3\xa4etaguse vald'],
 ['EE', '18', 'M\xc3\xa4ksa vald'],
 ['EE', '13', 'M\xc3\xa4rjamaa vald'],
 ['EE', '03', 'Narva-J\xc3\xb5esuu linn'],
 ['EE', '01', 'Nissi vald'],
 ['EE', '07', 'Noarootsi vald'],
 ['EE', '18', 'N\xc3\xb5o vald'],
 ['EE', '07', 'N\xc3\xb5va vald'],
 ['EE', '12', 'Orava vald'],
 ['EE', '14', 'Orissaare vald'],
 ['EE', '07', 'Oru vald'],
 ['EE', '01', 'Padise vald'],
 ['EE', '04', 'Paide vald'],
 ['EE', '04', 'Paide linn'],
 ['EE', '11', 'Paikuse vald'],
 ['EE', '20', 'Paistu vald'],
 ['EE', '05', 'Pajusi vald'],
 ['EE', '05', 'Pala vald'],
 ['EE', '05', 'Palamuse vald'],
 ['EE', '01', 'Paldiski linn'],
 ['EE', '19', 'Palupera vald'],
 ['EE', '18', 'Peipsi\xc3\xa4\xc3\xa4re vald'],
 ['EE', '14', 'Pihtla vald'],
 ['EE', '18', 'Piirissaare vald'],
 ['EE', '20', 'Karksi vald'],
 ['EE', '18', 'Puhja vald'],
 ['EE', '19', 'Puka vald'],
 ['EE', '05', 'Puurmani vald'],
 ['EE', '19', 'P\xc3\xb5drala vald'],
 ['EE', '05', 'P\xc3\xb5ltsamaa vald'],
 ['EE', '05', 'P\xc3\xb5ltsamaa linn'],
 ['EE', '20', 'P\xc3\xa4rsti vald'],
 ['EE', '14', 'P\xc3\xb6ide vald'],
 ['EE', '19', 'Otep\xc3\xa4\xc3\xa4 vald'],
 ['EE', '02', 'P\xc3\xbchalepa vald'],
 ['EE', '08', 'Tapa vald'],
 ['EE', '18', 'Tartu vald'],
 ['EE', '11', 'Tootsi vald'],
 ['EE', '14', 'Torgu vald'],
 ['EE', '11', 'Tori vald'],
 ['EE', '05', 'Torma vald'],
 ['EE', '03', 'Tudulinna vald'],
 ['EE', '12', 'V\xc3\xa4rska vald'],
 ['EE', '04', 'V\xc3\xa4\xc3\xa4tsa vald'],
 ['EE', '19', '\xc3\x95ru vald'],
 ['EE', '18', '\xc3\x9clenurme vald'],
 ['EE', '13', 'Rapla vald'],
 ['EE', '07', 'Ridala Parish'],
 ['EE', '07', 'Risti vald'],
 ['EE', '04', 'Roosna-Alliku vald'],
 ['EE', '14', 'Ruhnu vald'],
 ['EE', '18', 'R\xc3\xb5ngu vald'],
 ['EE', '21', 'R\xc3\xb5uge vald'],
 ['EE', '08', 'R\xc3\xa4gavere vald'],
 ['EE', '12', 'R\xc3\xa4pina vald'],
 ['EE', '11', 'Saarde vald'],
 ['EE', '05', 'Saare vald'],
 ['EE', '20', 'Saarepeedi vald'],
 ['EE', '01', 'Saku vald'],
 ['EE', '14', 'Salme vald'],
 ['EE', '19', 'Sangaste vald'],
 ['EE', '03', 'P\xc3\xbcssi linn'],
 ['EE', '01', 'Raasiku vald'],
 ['EE', '01', 'Rae vald'],
 ['EE', '13', 'Raikk\xc3\xbcla vald'],
 ['EE', '05', 'Kasep\xc3\xa4\xc3\xa4 vald'],
 ['EE', '08', 'Rakke vald'],
 ['EE', '08', 'Rakvere vald'],
 ['EE', '08', 'Rakvere linn'],
 ['EE', '18', 'Rannu vald'],
 ['EE', '01', 'Saue vald'],
 ['EE', '01', 'Saue linn'],
 ['EE', '14', 'Kuressaare linn'],
 ['EE', '01', 'Kuusalu vald'],
 ['EE', '03', 'Sonda vald'],
 ['EE', '11', 'Surju vald'],
 ['EE', '20', 'Suure-Jaani vald'],
 ['EE', '21', 'S\xc3\xb5merpalu vald'],
 ['EE', '08', 'S\xc3\xb5meru vald'],
 ['EE', '18', 'Tartu linn'],
 ['EE', '20', 'Tarvastu vald'],
 ['EE', '20', 'Abja vald'],
 ['EE', '01', 'Aegviidu vald'],
 ['EE', '12', 'Ahja vald'],
 ['EE', '03', 'Alaj\xc3\xb5e vald'],
 ['EE', '18', 'Alatskivi vald'],
 ['EE', '04', 'Albu vald'],
 ['EE', '04', 'Ambla vald'],
 ['EE', '01', 'Anija vald'],
 ['EE', '21', 'Antsla vald'],
 ['EE', '11', 'Are vald'],
 ['EE', '03', 'Aseri vald'],
 ['EE', '11', 'Audru vald'],
 ['EE', '03', 'Avinurme vald'],
 ['EE', '11', 'Sauga vald'],
 ['EE', '11', 'Sindi linn'],
 ['EE', '18', 'Vara vald'],
 ['EE', '11', 'Varbla vald'],
 ['EE', '21', 'Varstu vald'],
 ['EE', '01', 'Vasalemma vald'],
 ['EE', '12', 'Vastse-Kuuste vald'],
 ['EE', '21', 'Vastseliina vald'],
 ['EE', '12', 'Veriora vald'],
 ['EE', '13', 'Vigala vald'],
 ['EE', '08', 'Vihula vald'],
 ['EE', '01', 'Viimsi vald'],
 ['EE', '20', 'Viiratsi vald'],
 ['EE', '12', 'Laheda vald'],
 ['EE', '14', 'Laimjala vald'],
 ['EE', '21', 'Lasva vald'],
 ['EE', '02', 'K\xc3\xb5rgessaare vald'],
 ['EE', '11', 'Lavassaare vald'],
 ['EE', '12', 'P\xc3\xb5lva vald'],
 ['EE', '12', 'P\xc3\xb5lva linn'],
 ['EE', '03', 'Toila vald'],
 ['EE', '19', 'T\xc3\xb5lliste vald'],
 ['EE', '19', 'T\xc3\xb5rva linn'],
 ['EE', '11', 'T\xc3\xb5stamaa vald'],
 ['EE', '18', 'T\xc3\xa4htvere vald'],
 ['EE', '04', 'T\xc3\xbcri vald'],
 ['EE', '12', 'Valgj\xc3\xa4rve vald'],
 ['EE', '14', 'Valjala vald'],
 ['EE', '20', 'Viljandi linn'],
 ['EE', '08', 'Vinni vald'],
 ['EE', '08', 'Viru-Nigula vald'],
 ['EE', '07', 'Vormsi vald'],
 ['EE', '20', 'V\xc3\xb5hma linn'],
 ['EE', '18', 'V\xc3\xb5nnu vald'],
 ['EE', '21', 'V\xc3\xb5ru vald'],
 ['EE', '21', 'V\xc3\xb5ru linn'],
 ['EE', '08', 'V\xc3\xa4ike-Maarja vald'],
 ['EE', '11', 'V\xc3\xa4ndra vald'],
 ['EE', '11', 'V\xc3\xa4ndra vald (alev)'],
 ['EG', '09', 'Markaz al B\xc4\x81j\xc5\xabr'],
 ['EG', '16', 'Markaz \xe2\x80\x98Unaybah'],
 ['EG', '05', 'Markaz \xc5\xa2an\xc5\xa3\xc4\x81'],
 ['EG', '04', 'Markaz \xc5\xa2\xc4\x81miyah'],
 ['EG', '18', 'Markaz Sumus\xc5\xa3\xc4\x81 al Waqf'],
 ['EG', '24', 'Markaz S\xc5\xabh\xc4\x81j'],
 ['EG', '21', 'Markaz S\xc4\xabd\xc4\xab S\xc4\x81lim'],
 ['EG', '10', 'Markaz Sam\xc4\x81l\xc5\xab\xc5\xa3'],
 ['EG', '03', 'Markaz Rash\xc4\xabd'],
 ['EG', '09', 'Markaz Quwaysin\xc4\x81'],
 ['EG', '05', 'Markaz Qu\xc5\xa3\xc5\xabr'],
 ['EG', '23', 'Markaz Qin\xc4\x81'],
 ['EG', '07', 'Qism al Qan\xc5\xa3arah'],
 ['EG', '12', 'Markaz Qaly\xc5\xabb'],
 ['EG', '21', 'Markaz Qall\xc4\xabn'],
 ['EG', '23', 'Markaz Naj\xe2\x80\x98 \xe1\xb8\xa8amm\xc4\x81d\xc4\xab'],
 ['EG', '01', 'Markaz M\xc4\xabt Ghamr'],
 ['EG', '14', 'Markaz Miny\xc4\x81 al Qam\xe1\xb8\xa9'],
 ['EG', '22', 'Markaz Ma\xc5\xa3r\xc5\xab\xe1\xb8\xa9'],
 ['EG', '10', 'Markaz Ma\xc5\xa3\xc4\x81y'],
 ['EG', '06', 'Markaz Mary\xc5\xab\xc5\xa3'],
 ['EG', '10', 'Markaz Mallaw\xc4\xab'],
 ['EG', '21', 'Markaz Kafr ash Shaykh'],
 ['EG', '03', 'Markaz Kafr ad Daww\xc4\x81r'],
 ['EG', '24', 'Markaz Jirj\xc4\x81'],
 ['EG', '03', 'Markaz Ity\xc4\x81y al B\xc4\x81r\xc5\xabd'],
 ['EG', '04', 'Markaz I\xc5\xa3s\xc4\x81'],
 ['EG', '23', 'Markaz Isn\xc4\x81'],
 ['EG', '08', 'Markaz Imb\xc4\x81bah'],
 ['EG', '18', 'Markaz Ihn\xc4\x81siyat al Mad\xc4\xabnah'],
 ['EG', '16', 'Markaz Idf\xc5\xab'],
 ['EG', '04', 'Markaz Ibshaw\xc4\x81y'],
 ['EG', '14', 'Markaz Hihy\xc4\x81'],
 ['EG', '03', 'Markaz \xe1\xb8\xa8awsh \xe2\x80\x98\xc4\xaas\xc3\xa1'],
 ['EG', '21', 'Markaz Fuwah'],
 ['EG', '20', 'Markaz F\xc4\x81risk\xc5\xabr'],
 ['EG', '14', 'Markaz Diyarb Najm'],
 ['EG', '21', 'Markaz Dis\xc5\xabq'],
 ['EG', '23', 'Markaz Dishn\xc4\x81'],
 ['EG', '01', 'Markaz Dikirnis'],
 ['EG', '17', 'Markaz Dayr\xc5\xab\xc5\xa3'],
 ['EG', '10', 'Markaz Dayr Maw\xc4\x81s'],
 ['EG', '03', 'Markaz Damanh\xc5\xabr'],
 ['EG', '18', 'Markaz B\xc5\xabsh'],
 ['EG', '21', 'Markaz Biyal\xc4\x81'],
 ['EG', '01', 'Markaz Bilq\xc4\x81s'],
 ['EG', '14', 'Markaz Bilbays'],
 ['EG', '18', 'Markaz Bib\xc4\x81'],
 ['EG', '05', 'Markaz Basy\xc5\xabn'],
 ['EG', '18', 'Markaz Ban\xc4\xab Suwayf'],
 ['EG', '10', 'Markaz Ban\xc4\xab Maz\xc4\x81r'],
 ['EG', '12', 'Markaz Banh\xc4\x81'],
 ['EG', '14', 'Markaz az Zaq\xc4\x81z\xc4\xabq'],
 ['EG', '24', 'Markaz Awl\xc4\x81d \xc5\xa2awq Sharq'],
 ['EG', '17', 'Markaz Asy\xc5\xab\xc5\xa3'],
 ['EG', '16', 'Markaz Asw\xc4\x81n'],
 ['EG', '05', 'Markaz as San\xc5\xa3ah'],
 ['EG', '08', 'Markaz a\xc5\x9f \xc5\x9eaff'],
 ['EG', '09', 'Markaz ash Shuhad\xc4\x81\xe2\x80\x99'],
 ['EG', '09', 'Markaz Ashm\xc5\xabn'],
 ['EG', '23', 'Markaz Armant'],
 ['EG', '18', 'Markaz al W\xc4\x81si\xc5\xa3ah'],
 ['EG', '13', 'Markaz al W\xc4\x81\xe1\xb8\xa9\xc4\x81t al Kh\xc4\x81rijah'],
 ['EG', '08', 'Markaz al W\xc4\x81\xe1\xb8\xa9\xc4\x81t al Ba\xe1\xb8\xa9r\xc4\xabyah'],
 ['EG', '13', 'Markaz al W\xc4\x81\xe1\xb8\xa9\xc4\x81t ad D\xc4\x81khilah'],
 ['EG', '23', 'Markaz al Uq\xc5\x9fur'],
 ['EG', '17', 'Markaz al Q\xc5\xab\xc5\x9f\xc4\xabyah'],
 ['EG', '10', 'Markaz al Miny\xc4\x81'],
 ['EG', '24', 'Markaz al Minsh\xc4\x81h'],
 ['EG', '24', 'Markaz al Mar\xc4\x81ghah'],
 ['EG', '01', 'Markaz al Manzilah'],
 ['EG', '01', 'Markaz al Man\xc5\x9f\xc5\xabrah'],
 ['EG', '03', 'Markaz al Ma\xe1\xb8\xa9m\xc5\xabd\xc4\xabyah'],
 ['EG', '05', 'Markaz al Ma\xe1\xb8\xa9allah al Kubr\xc3\xa1'],
 ['EG', '12', 'Markaz al Kh\xc4\x81nkah'],
 ['EG', '08', 'Markaz al J\xc4\xabzah'],
 ['EG', '10', 'Markaz al \xe2\x80\x98Idwah'],
 ['EG', '14', 'Markaz al \xe1\xb8\xa8usayn\xc4\xabyah'],
 ['EG', '04', 'Markaz al Fayy\xc5\xabm'],
 ['EG', '18', 'Markaz al Fashm'],
 ['EG', '21', 'Markaz al Burullus'],
 ['EG', '24', 'Markaz al Balyan\xc4\x81'],
 ['EG', '08', 'Markaz al Badrashayn'],
 ['EG', '17', 'Markaz al Bad\xc4\x81r'],
 ['EG', '08', 'Markaz al \xe2\x80\x98Ayy\xc4\x81\xc5\xa3'],
 ['EG', '24', 'Markaz Akhm\xc4\xabm'],
 ['EG', '01', 'Markaz Aj\xc4\x81'],
 ['EG', '03', 'Markaz ad Dilinj\xc4\x81t'],
 ['EG', '23', 'Markaz Ab\xc5\xab Tisht'],
 ['EG', '17', 'Markaz Ab\xc5\xab T\xc4\xabj'],
 ['EG', '10', 'Markaz Ab\xc5\xab Qurq\xc4\x81\xc5\x9f'],
 ['EG', '14', 'Markaz Ab\xc5\xab Kab\xc4\xabr'],
 ['EG', '03', 'Markaz Ab\xc5\xab \xe1\xb8\xa8ummu\xc5\x9f'],
 ['EG', '14', 'Markaz Ab\xc5\xab \xe1\xb8\xa8amm\xc4\x81d'],
 ['EG', '03', 'Markaz Ab\xc5\xab al Ma\xc5\xa3\xc4\x81m\xc4\xabr'],
 ['EG', '12', 'Mostorod'],
 ['EG', '21', 'Markaz al \xe1\xb8\xa8\xc4\x81m\xc5\xabl'],
 ['EG', '14', 'Bahr El Bakar'],
 ['EG', '', 'El Tabya'],
 ['EG', '01', 'Bahr El Bakr'],
 ['EG', '11', 'Mostafa El Serwy'],
 ['EG', '01', 'Mit Yazid'],
 ['EG', '21', 'Kafr El Sheikh'],
 ['EG', '12', 'Markaz Kafr Shukr'],
 ['EG', '00', 'Markaz Aws\xc4\xabm'],
 ['ER', '00', 'Seray\xc4\x93 \xc4\x80wraja'],
 ['ER', '06', 'Sahil \xc4\x80wraja'],
 ['ER', '00', 'Hamas\xc4\x93n \xc4\x80wraja'],
 ['ER', '00', '\xc4\x80kale Guzay \xc4\x80wraja'],
 ['ER', '04', 'Barka \xc4\x80wraja'],
 ['ER', '03', 'Denkel \xc4\x80wraja'],
 ['ER', '06', 'Semhar \xc4\x80wraja'],
 ['ER', '06', 'Senhit \xc4\x80wraja'],
 ['ES', '60', 'Prov\xc3\xadncia de Val\xc3\xa8ncia'],
 ['ES', '54', 'Province of Toledo'],
 ['ES', '51', 'Provincia de Sevilla'],
 ['ES', '53', 'Provincia de Santa Cruz de Tenerife'],
 ['ES', '51', 'Provincia de M\xc3\xa1laga'],
 ['ES', '53', 'Provincia de Las Palmas'],
 ['ES', '51', 'Provincia de Ja\xc3\xa9n'],
 ['ES', '51', 'Provincia de Huelva'],
 ['ES', '51', 'Provincia de Granada'],
 ['ES', '54', 'Provincia de Cuenca'],
 ['ES', '51', 'Province of C\xc3\xb3rdoba'],
 ['ES', '54', 'Provincia de Ciudad Real'],
 ['ES', '51', 'Provincia de C\xc3\xa1diz'],
 ['ES', '57', 'Provincia de C\xc3\xa1ceres'],
 ['ES', '57', 'Provincia de Badajoz'],
 ['ES', '51', 'Provincia de Almer\xc3\xada'],
 ['ES', '60', 'Provincia de Alicante'],
 ['ES', '54', 'Provincia de Albacete'],
 ['ES', '52', 'Provincia de Zaragoza'],
 ['ES', '55', 'Provincia de Zamora'],
 ['ES', '59', 'Provincia de Vizcaya'],
 ['ES', '55', 'Provincia de Valladolid'],
 ['ES', '52', 'Provincia de Teruel'],
 ['ES', '56', 'Prov\xc3\xadncia de Tarragona'],
 ['ES', '55', 'Provincia de Soria'],
 ['ES', '55', 'Provincia de Segovia'],
 ['ES', '39', 'Provincia de Cantabria'],
 ['ES', '55', 'Provincia de Salamanca'],
 ['ES', '58', 'Provincia de Pontevedra'],
 ['ES', '55', 'Provincia de Palencia'],
 ['ES', '58', 'Provincia de Ourense'],
 ['ES', '58', 'Provincia de Lugo'],
 ['ES', '55', 'Provincia de Le\xc3\xb3n'],
 ['ES', '58', 'Provincia da Coru\xc3\xb1a'],
 ['ES', '52', 'Provincia de Huesca'],
 ['ES', '59', 'Gipuzkoa'],
 ['ES', '54', 'Provincia de Guadalajara'],
 ['ES', '60', 'Prov\xc3\xadncia de Castell\xc3\xb3'],
 ['ES', '55', 'Provincia de Burgos'],
 ['ES', '56', 'Prov\xc3\xadncia de Barcelona'],
 ['ES', '55', 'Provincia de \xc3\x81vila'],
 ['ES', '59', 'Araba / \xc3\x81lava'],
 ['ES', '56', 'Prov\xc3\xadncia de Girona'],
 ['ES', '56', 'Prov\xc3\xadncia de Lleida'],
 ['ES', '27', 'Provincia de La Rioja'],
 ['ES', '29', 'Provincia de Madrid'],
 ['ES', '31', 'Murcia'],
 ['ES', '32', 'Provincia de Navarra'],
 ['ES', '34', 'Provincia de Asturias'],
 ['ES', '07', 'Illes Balears'],
 ['ES', 'CE', 'Ceuta'],
 ['ES', 'ML', 'Melilla'],
 ['ET', '54', 'Wolayita Zone'],
 ['ET', '47', 'Metekel \xc4\x80wraja'],
 ['ET', '54', 'Bench Maji Zone'],
 ['ET', '54', 'Hadiya Zone'],
 ['ET', '54', 'Kaffa Zone'],
 ['ET', '51', 'Jimma Zone'],
 ['ET', '52', 'Dire Dawa Zone'],
 ['ET', '54', 'Guraghe Zone'],
 ['ET', '51', '\xc4\x80rs\xc4\xab Kifle H\xc4\x81ger'],
 ['ET', '37', 'Pemba District'],
 ['ET', '27', 'Misraq Shewa'],
 ['ET', '27', 'Misraq Shewa'],
 ['ET', '37', 'Southern Tigray Zone'],
 ['ET', '54', 'Alaba Special Wereda'],
 ['ET', '54', 'Kembata Alaba Tembaro Zone'],
 ['ET', '51', 'North Shewa Zone'],
 ['ET', '51', 'West Shewa Zone'],
 ['ET', '51', 'South West Shewa'],
 ['ET', '51', 'East Shewa Zone'],
 ['ET', '51', 'East Wellega Zone'],
 ['ET', '46', 'West Gojjam Zone'],
 ['ET', '46', 'East Gojjam Zone'],
 ['ET', '46', 'Awi'],
 ['ET', '46', 'North Gondar Zone'],
 ['ET', '54', 'Siltie Zone'],
 ['ET', '41', 'Dawuro'],
 ['ET', '42', 'Gedeo Zone'],
 ['ET', '19', 'Western Tigray'],
 ['ET', '39', 'South Omo'],
 ['ET', '42', 'Borena Zone'],
 ['ET', '21', 'South Wollo Zone'],
 ['ET', '51', 'Illubabor Zone'],
 ['ET', '51', 'West Wellega Zone'],
 ['ET', '49', 'Administrative Zone 1'],
 ['ET', '45', 'Administrative Zone 3'],
 ['ET', '51', 'West Harerghe Zone'],
 ['ET', '51', 'East Harerghe Zone'],
 ['ET', '52', 'Shinile Zone'],
 ['ET', '54', 'Yem Special Woreda'],
 ['ET', '44', 'Addis Ababa Zone 1'],
 ['ET', '44', 'Addis Ababa Zone 2'],
 ['ET', '44', 'Addis Ababa Zone 3'],
 ['ET', '44', 'Addis Ababa Zone 6'],
 ['ET', '38', 'Bale'],
 ['ET', '19', 'South Gondar Zone'],
 ['ET', '21', 'North Wollo Zone'],
 ['ET', '53', 'Central Tigray Zone'],
 ['ET', '37', 'Northwestern Tigray'],
 ['ET', '37', 'Eastern Tigray Zone'],
 ['ET', '43', 'Asosa'],
 ['ET', '37', 'North Western Tigray'],
 ['ET', '28', 'Metekel'],
 ['ET', '46', 'North Shewa Zone'],
 ['ET', '21', 'Wag Hemra Zone'],
 ['ET', '44', 'Addis Ababa Zone 5'],
 ['ET', '41', 'Keficho Shekicho Zone'],
 ['ET', '42', 'Sidama Zone'],
 ['ET', '42', 'Guji Zone'],
 ['FI', '06', 'Lappland'],
 ['FI', '08', 'Kainuu'],
 ['FI', '08', 'Norra \xc3\x96sterbotten'],
 ['FI', '15', 'Mellersta \xc3\x96sterbotten'],
 ['FI', '15', '\xc3\x96sterbotten'],
 ['FI', '15', 'S\xc3\xb6dra \xc3\x96sterbotten'],
 ['FI', '15', 'Mellersta Finland'],
 ['FI', '14', 'Pohjois-Karjala'],
 ['FI', '14', 'Savo'],
 ['FI', '14', 'Etel\xc3\xa4-Savo'],
 ['FI', '13', 'Etel\xc3\xa4-Karjala'],
 ['FI', '13', 'Kymenlaakso'],
 ['FI', '15', 'Pirkanmaa'],
 ['FI', '13', 'H\xc3\xa4me'],
 ['FI', '15', 'Varsinais-Suomi'],
 ['FI', '13', 'Uusimaa'],
 ['FI', '13', 'P\xc3\xa4ij\xc3\xa4t-H\xc3\xa4me'],
 ['FI', '15', 'Satakunta'],
 ['FM', '02', 'Kapingamarangi Municipality'],
 ['FM', '02', 'Kitti Municipality'],
 ['FM', '02', 'Kolonia Municipality'],
 ['FM', '02', 'Madolenihm Municipality'],
 ['FM', '02', 'Mokil Municipality'],
 ['FM', '02', 'Nett Municipality'],
 ['FM', '02', 'Ngatik Municipality'],
 ['FM', '02', 'Nukuoro Municipality'],
 ['FM', '02', 'Oroluk Municipality'],
 ['FM', '02', 'Pingelap Municipality'],
 ['FM', '02', 'Sokehs Municipality'],
 ['FM', '02', 'U Municipality'],
 ['FM', '01', 'Lelu Municipality'],
 ['FM', '01', 'Malem Municipality'],
 ['FM', '01', 'Tafunsak Municipality'],
 ['FM', '01', 'Utwe Municipality'],
 ['FM', '04', 'Dalipebinaw Municipality'],
 ['FM', '04', 'Eauripik Municipality'],
 ['FM', '04', 'Elato Municipality'],
 ['FM', '04', 'Fais Municipality'],
 ['FM', '04', 'Fanif Municipality'],
 ['FM', '04', 'Faraulep Municipality'],
 ['FM', '04', 'Gaferut Municipality'],
 ['FM', '04', 'Gagil Municipality'],
 ['FM', '04', 'Gilman Municipality'],
 ['FM', '04', 'Ifalik Municipality'],
 ['FM', '04', 'Kanifay Municipality'],
 ['FM', '04', 'Lamotrek Municipality'],
 ['FM', '04', 'Maap Municipality'],
 ['FM', '04', 'Ngulu Municipality'],
 ['FM', '04', 'Rull Municipality'],
 ['FM', '04', 'Rumung Municipality'],
 ['FM', '04', 'Satawal Municipality'],
 ['FM', '04', 'Sorol Municipality'],
 ['FM', '04', 'Tomil Municipality'],
 ['FM', '04', 'Ulithi Municipality'],
 ['FM', '04', 'Weloy Municipality'],
 ['FM', '04', 'Woleai Municipality'],
 ['FM', '03', 'Eot Municipality'],
 ['FM', '03', 'Ettal Municipality'],
 ['FM', '03', 'Fananu Municipality'],
 ['FM', '03', 'Fanapanges Municipality'],
 ['FM', '03', 'Fefen Municipality'],
 ['FM', '03', 'Houk Municipality'],
 ['FM', '03', 'Kuttu Municipality'],
 ['FM', '03', 'Losap Municipality'],
 ['FM', '03', 'Lekinioch Municipality'],
 ['FM', '03', 'Makur Municipality'],
 ['FM', '03', 'Moch Municipality'],
 ['FM', '03', 'Murilo Municipality'],
 ['FM', '03', 'Nema Municipality'],
 ['FM', '03', 'Namoluk Municipality'],
 ['FM', '03', 'Nomwin Municipality'],
 ['FM', '03', 'Oneop Municipality'],
 ['FM', '03', 'Onou Municipality'],
 ['FM', '03', 'Onoun Municipality'],
 ['FM', '03', 'Parem Municipality'],
 ['FM', '03', 'Piherarh Municipality'],
 ['FM', '03', 'Piis-Emwar Municipality'],
 ['FM', '03', 'Pollap Municipality'],
 ['FM', '03', 'Polowat Municipality'],
 ['FM', '03', 'Ramanum Municipality'],
 ['FM', '03', 'Ruo Municipality'],
 ['FM', '03', 'Satowan Municipality'],
 ['FM', '03', 'Ta Municipality'],
 ['FM', '03', 'Tamatam Municipality'],
 ['FM', '03', 'Tolensom Municipality'],
 ['FM', '03', 'Tonoas Municipality'],
 ['FM', '03', 'Siis Municipality'],
 ['FM', '03', 'Udot-Fonuweisom Municipality'],
 ['FM', '03', 'Uman-Fonuweisom Municipality'],
 ['FM', '03', 'Unanu Municipality'],
 ['FM', '03', 'Weno-Choniro Municipality'],
 ['FM', '03', 'Fonoton Municipality'],
 ['FM', '03', 'Paata-Tupunion Municipality'],
 ['FM', '03', 'Piis-Panewu Municipality'],
 ['FM', '03', 'Oneisom Municipality'],
 ['FM', '03', 'Pwene Municipality'],
 ['FO', 'SA', 'Vi\xc3\xb0arei\xc3\xb0i'],
 ['FO', 'ST', 'Vestmanna'],
 ['FO', 'SU', 'V\xc3\xa1gur'],
 ['FO', 'ST', 'T\xc3\xb3rshavn'],
 ['FO', 'SU', 'Sunnb\xc3\xb8ur'],
 ['FO', 'ST', 'S\xc3\xb8rv\xc3\xa1gur'],
 ['FO', 'SU', 'Sk\xc3\xbavoy'],
 ['FO', 'SA', 'Skopun'],
 ['FO', 'SU', 'Sk\xc3\xa1lav\xc3\xadk'],
 ['FO', 'NO', 'Sandur'],
 ['FO', 'ST', 'Runav\xc3\xadk'],
 ['FO', 'SU', 'Porkeri'],
 ['FO', 'SA', 'Nes'],
 ['FO', 'ST', 'Kv\xc3\xadv\xc3\xadk'],
 ['FO', 'SU', 'Kunoy'],
 ['FO', 'SU', 'Klaksvik'],
 ['FO', 'SU', 'Hvannasund'],
 ['FO', 'SU', 'Hvalb\xc3\xb8ur'],
 ['FO', 'SU', 'H\xc3\xbasav\xc3\xadk'],
 ['FO', 'ST', 'H\xc3\xbasar'],
 ['FO', 'SU', 'Hov'],
 ['FO', 'ST', 'Fugloy'],
 ['FO', 'ST', 'Fuglafj\xc3\xb8r\xc3\xb0ur'],
 ['FO', 'SU', 'F\xc3\xa1mjin'],
 ['FO', 'OS', 'Ei\xc3\xb0i'],
 ['FO', 'OS', 'Eystur'],
 ['FO', 'VG', 'Vagar'],
 ['FO', 'SU', 'Tv\xc3\xb8royri'],
 ['FO', 'OS', 'Sunda'],
 ['FO', 'OS', 'Sj\xc3\xb3var'],
 ['FR', 'A8', 'D\xc3\xa9partement des Yvelines'],
 ['FR', 'A1', "D\xc3\xa9partement de l'Yonne"],
 ['FR', 'B2', 'D\xc3\xa9partement des Vosges'],
 ['FR', 'A8', 'Paris'],
 ['FR', 'B7', 'D\xc3\xa9partement de la Vienne'],
 ['FR', 'B5', 'D\xc3\xa9partement de la Vend\xc3\xa9e'],
 ['FR', 'B8', 'D\xc3\xa9partement du Vaucluse'],
 ['FR', 'B8', 'D\xc3\xa9partement du Var'],
 ['FR', 'A8', "D\xc3\xa9partement du Val-d'Oise"],
 ['FR', 'A8', 'D\xc3\xa9partement du Val-de-Marne'],
 ['FR', 'B3', 'D\xc3\xa9partement du Tarn-et-Garonne'],
 ['FR', 'B3', 'D\xc3\xa9partement du Tarn'],
 ['FR', 'B6', 'D\xc3\xa9partement de la Somme'],
 ['FR', 'A8', 'D\xc3\xa9partement de Seine-Saint-Denis'],
 ['FR', 'A7', 'D\xc3\xa9partement de la Seine-Maritime'],
 ['FR', 'A8', 'D\xc3\xa9partement de Seine-et-Marne'],
 ['FR', 'B9', 'D\xc3\xa9partement de la Savoie'],
 ['FR', 'B5', 'D\xc3\xa9partement de la Sarthe'],
 ['FR', 'A1', 'D\xc3\xa9partement de Sa\xc3\xb4ne-et-Loire'],
 ['FR', 'A9', 'D\xc3\xa9partement des Pyr\xc3\xa9n\xc3\xa9es-Orientales'],
 ['FR', '97', 'D\xc3\xa9partement des Pyr\xc3\xa9n\xc3\xa9es-Atlantiques'],
 ['FR', '98', 'D\xc3\xa9partement du Puy-de-D\xc3\xb4me'],
 ['FR', 'B9', 'D\xc3\xa9partement du Rh\xc3\xb4ne'],
 ['FR', 'B4', 'D\xc3\xa9partement du Pas-de-Calais'],
 ['FR', '99', "D\xc3\xa9partement de l'Orne"],
 ['FR', 'B6', "D\xc3\xa9partement de l'Oise"],
 ['FR', 'B4', 'D\xc3\xa9partement du Nord'],
 ['FR', 'A1', 'D\xc3\xa9partement de la Ni\xc3\xa8vre'],
 ['FR', 'B2', 'D\xc3\xa9partement de la Moselle'],
 ['FR', 'A2', 'D\xc3\xa9partement du Morbihan'],
 ['FR', 'B2', 'D\xc3\xa9partement de la Meuse'],
 ['FR', 'B2', 'D\xc3\xa9partement de Meurthe-et-Moselle'],
 ['FR', 'B5', 'D\xc3\xa9partement de la Mayenne'],
 ['FR', 'A4', 'D\xc3\xa9partement de la Marne'],
 ['FR', '99', 'D\xc3\xa9partement de la Manche'],
 ['FR', 'B5', 'D\xc3\xa9partement de Maine-et-Loire'],
 ['FR', 'A9', 'D\xc3\xa9partement de la Loz\xc3\xa8re'],
 ['FR', '97', 'D\xc3\xa9partement du Lot-et-Garonne'],
 ['FR', 'B3', 'D\xc3\xa9partement du Lot'],
 ['FR', 'A3', 'D\xc3\xa9partement du Loir-et-Cher'],
 ['FR', 'A3', 'D\xc3\xa9partement du Loiret'],
 ['FR', 'B5', 'D\xc3\xa9partement de la Loire-Atlantique'],
 ['FR', 'B9', 'D\xc3\xa9partement de la Loire'],
 ['FR', '97', 'D\xc3\xa9partement des Landes'],
 ['FR', 'A6', 'D\xc3\xa9partement du Jura'],
 ['FR', 'B9', "D\xc3\xa9partement de l'Is\xc3\xa8re"],
 ['FR', 'A3', "D\xc3\xa9partement d'Indre-et-Loire"],
 ['FR', 'A3', "D\xc3\xa9partement de l'Indre"],
 ['FR', 'A2', "D\xc3\xa9partement d'Ille-et-Vilaine"],
 ['FR', 'A9', "D\xc3\xa9partement de l'H\xc3\xa9rault"],
 ['FR', 'A8', 'D\xc3\xa9partement des Hauts-de-Seine'],
 ['FR', 'C1', 'D\xc3\xa9partement du Haut-Rhin'],
 ['FR', 'B1', 'D\xc3\xa9partement de la Haute-Vienne'],
 ['FR', 'B3', 'D\xc3\xa9partement des Hautes-Pyr\xc3\xa9n\xc3\xa9es'],
 ['FR', 'B9', 'D\xc3\xa9partement de la Haute-Savoie'],
 ['FR', 'A6', 'D\xc3\xa9partement de la Haute-Sa\xc3\xb4ne'],
 ['FR', 'B8', 'D\xc3\xa9partement des Hautes-Alpes'],
 ['FR', 'A4', 'D\xc3\xa9partement de la Haute-Marne'],
 ['FR', '98', 'D\xc3\xa9partement de la Haute-Loire'],
 ['FR', 'B3', 'D\xc3\xa9partement de la Haute-Garonne'],
 ['FR', 'A5', 'D\xc3\xa9partement de la Haute-Corse'],
 ['FR', '97', 'D\xc3\xa9partement de la Gironde'],
 ['FR', 'B3', 'D\xc3\xa9partement du Gers'],
 ['FR', 'A9', 'D\xc3\xa9partement du Gard'],
 ['FR', 'A2', 'D\xc3\xa9partement du Finist\xc3\xa8re'],
 ['FR', 'A3', "D\xc3\xa9partement d'Eure-et-Loir"],
 ['FR', 'A7', "D\xc3\xa9partement de l'Eure"],
 ['FR', 'A8', "D\xc3\xa9partement de l'Essonne"],
 ['FR', 'B9', 'D\xc3\xa9partement de la Dr\xc3\xb4me'],
 ['FR', 'A6', 'D\xc3\xa9partement du Doubs'],
 ['FR', '97', 'D\xc3\xa9partement de la Dordogne'],
 ['FR', 'B7', 'D\xc3\xa9partement des Deux-S\xc3\xa8vres'],
 ['FR', 'B1', 'D\xc3\xa9partement de la Creuse'],
 ['FR', 'A2', "D\xc3\xa9partement des C\xc3\xb4tes-d'Armor"],
 ['FR', 'A1', "D\xc3\xa9partement de la C\xc3\xb4te-d'Or"],
 ['FR', 'A5', 'D\xc3\xa9partement de la Corse-du-Sud'],
 ['FR', 'B1', 'D\xc3\xa9partement de la Corr\xc3\xa8ze'],
 ['FR', 'A3', 'D\xc3\xa9partement du Cher'],
 ['FR', 'B7', 'D\xc3\xa9partement de la Charente-Maritime'],
 ['FR', 'B7', 'D\xc3\xa9partement de la Charente'],
 ['FR', '98', 'D\xc3\xa9partement du Cantal'],
 ['FR', '99', 'D\xc3\xa9partement du Calvados'],
 ['FR', 'B8', 'D\xc3\xa9partement des Bouches-du-Rh\xc3\xb4ne'],
 ['FR', 'A6', 'Territoire de Belfort'],
 ['FR', 'C1', 'D\xc3\xa9partement du Bas-Rhin'],
 ['FR', 'B3', "D\xc3\xa9partement de l'Aveyron"],
 ['FR', 'A9', "D\xc3\xa9partement de l'Aude"],
 ['FR', 'A4', "D\xc3\xa9partement de l'Aube"],
 ['FR', 'B3', "D\xc3\xa9partement de l'Ari\xc3\xa8ge"],
 ['FR', 'A4', 'D\xc3\xa9partement des Ardennes'],
 ['FR', 'B9', "D\xc3\xa9partement de l'Ard\xc3\xa8che"],
 ['FR', 'B8', 'D\xc3\xa9partement des Alpes-Maritimes'],
 ['FR', 'B8', 'D\xc3\xa9partement des Alpes-de-Haute-Provence'],
 ['FR', '98', "D\xc3\xa9partement de l'Allier"],
 ['FR', 'B6', "D\xc3\xa9partement de l'Aisne"],
 ['FR', 'B9', "D\xc3\xa9partement de l'Ain"],
 ['GA', '05', 'Basse-Banio Department'],
 ['GA', '05', 'Mougoutsi Department'],
 ['GA', '08', 'Ndougou Department'],
 ['GA', '04', 'Douya-Onoye Department'],
 ['GA', '04', 'Ndolou Department'],
 ['GA', '08', '\xc3\x89timbou\xc3\xa9 Department'],
 ['GA', '02', 'Plateaux Department'],
 ['GA', '02', 'Mpassa Department'],
 ['GA', '05', 'Haute-Banio Department'],
 ['GA', '03', 'Abanga-Bign\xc3\xa9 Department'],
 ['GA', '06', 'Lope Department'],
 ['GA', '07', 'Lolo Bouenguidi Department'],
 ['GA', '04', 'Ogoulou Department'],
 ['GA', '01', 'Komo Mondah District'],
 ['GA', '03', 'Ogooue et Lacs District'],
 ['GA', '08', 'Bendje District'],
 ['GA', '02', 'Passa'],
 ['GA', '08', 'Bendje'],
 ['GA', '04', 'Tsamba-Magotsi Department'],
 ['GA', '07', 'Mouloundou Department'],
 ['GA', '02', 'Leboumbi-Leyou Department'],
 ['GA', '04', 'Dola Department'],
 ['GA', '04', 'Louetsi-Wano Department'],
 ['GA', '01', 'Commune of Libreville'],
 ['GA', '01', 'Komo-Mondah Department'],
 ['GA', '01', 'Komo Department'],
 ['GA', '02', 'Lekoko Department'],
 ['GB', 'ENG', 'City of York'],
 ['GB', 'WLS', 'Wrexham'],
 ['GB', 'ENG', 'Worcestershire'],
 ['GB', 'ENG', 'Royal Borough of Windsor and Maidenhead'],
 ['GB', 'ENG', 'Wiltshire'],
 ['GB', 'ENG', 'West Sussex'],
 ['GB', 'SCT', 'West Lothian'],
 ['GB', 'SCT', 'Eilean Siar'],
 ['GB', 'ENG', 'Warwickshire'],
 ['GB', 'WLS', 'Vale of Glamorgan'],
 ['GB', 'ENG', 'Borough of Thurrock'],
 ['GB', 'ENG', 'Surrey'],
 ['GB', 'ENG', 'Suffolk'],
 ['GB', 'NIR', 'Strabane District'],
 ['GB', 'SCT', 'Stirling'],
 ['GB', 'ENG', 'Staffordshire'],
 ['GB', 'ENG', 'Somerset'],
 ['GB', 'SCT', 'Shetland Islands'],
 ['GB', 'ENG', 'Isles of Scilly'],
 ['GB', 'ENG', 'Shropshire'],
 ['GB', 'ENG', 'District of Rutland'],
 ['GB', 'SCT', 'Renfrewshire'],
 ['GB', 'WLS', 'Sir Powys'],
 ['GB', 'WLS', 'Pembrokeshire'],
 ['GB', 'ENG', 'Oxfordshire'],
 ['GB', 'SCT', 'Orkney Islands'],
 ['GB', 'NIR', 'Omagh District'],
 ['GB', 'ENG', 'Nottinghamshire'],
 ['GB', 'ENG', 'North Yorkshire'],
 ['GB', 'ENG', 'Northumberland'],
 ['GB', 'ENG', 'Borough of North Tyneside'],
 ['GB', 'NIR', 'North Down District'],
 ['GB', 'ENG', 'Northamptonshire'],
 ['GB', 'ENG', 'Norfolk'],
 ['GB', 'NIR', 'Newtownabbey District'],
 ['GB', 'NIR', 'Newry and Mourne District'],
 ['GB', 'NIR', 'Moyle District'],
 ['GB', 'SCT', 'Moray'],
 ['GB', 'SCT', 'Midlothian'],
 ['GB', 'NIR', 'Magherafelt District'],
 ['GB', 'NIR', 'City of Derry'],
 ['GB', 'NIR', 'Lisburn District'],
 ['GB', 'ENG', 'Lincolnshire'],
 ['GB', 'NIR', 'Limavady District'],
 ['GB', 'ENG', 'Leicestershire'],
 ['GB', 'NIR', 'Larne District'],
 ['GB', 'ENG', 'Lancashire'],
 ['GB', 'ENG', 'Isle of Wight'],
 ['GB', 'SCT', 'Inverclyde'],
 ['GB', 'SCT', 'Highland'],
 ['GB', 'ENG', 'Hertfordshire'],
 ['GB', 'ENG', 'Herefordshire'],
 ['GB', 'ENG', 'Hampshire'],
 ['GB', 'ENG', 'Borough of Halton'],
 ['GB', 'WLS', 'Gwynedd'],
 ['GB', 'ENG', 'Greater London'],
 ['GB', 'ENG', 'Gloucestershire'],
 ['GB', 'ENG', 'Gateshead'],
 ['GB', 'WLS', 'County of Flintshire'],
 ['GB', 'SCT', 'Fife'],
 ['GB', 'NIR', 'Fermanagh District'],
 ['GB', 'ENG', 'Essex'],
 ['GB', 'ENG', 'East Sussex'],
 ['GB', 'ENG', 'East Riding of Yorkshire'],
 ['GB', 'SCT', 'East Lothian'],
 ['GB', 'ENG', 'County Durham'],
 ['GB', 'NIR', 'Dungannon District'],
 ['GB', 'SCT', 'Dumfries and Galloway'],
 ['GB', 'NIR', 'Down District'],
 ['GB', 'ENG', 'Dorset'],
 ['GB', 'ENG', 'Devon'],
 ['GB', 'ENG', 'Derbyshire'],
 ['GB', 'WLS', 'Denbighshire'],
 ['GB', 'ENG', 'Cumbria'],
 ['GB', 'NIR', 'Craigavon District'],
 ['GB', 'ENG', 'Cornwall'],
 ['GB', 'NIR', 'Cookstown District'],
 ['GB', 'NIR', 'Coleraine District'],
 ['GB', 'SCT', 'Clackmannanshire'],
 ['GB', 'NIR', 'Castlereagh District'],
 ['GB', 'NIR', 'Carrickfergus District'],
 ['GB', 'WLS', 'Carmarthenshire'],
 ['GB', 'WLS', 'County of Ceredigion'],
 ['GB', 'ENG', 'Cambridgeshire'],
 ['GB', 'ENG', 'Buckinghamshire'],
 ['GB', 'SCT', 'The Scottish Borders'],
 ['GB', 'NIR', 'Banbridge District'],
 ['GB', 'NIR', 'Ballymoney District'],
 ['GB', 'NIR', 'Ballymena District'],
 ['GB', 'NIR', 'Armagh District'],
 ['GB', 'NIR', 'Ards District'],
 ['GB', 'NIR', 'Antrim Borough'],
 ['GB', 'SCT', 'Angus'],
 ['GB', 'WLS', 'Anglesey'],
 ['GB', 'SCT', 'Aberdeenshire'],
 ['GB', 'ENG', 'Borough of Barnsley'],
 ['GB', 'ENG', 'Bath and North East Somerset'],
 ['GB', 'ENG', 'City and Borough of Birmingham'],
 ['GB', 'ENG', 'Borough of Blackburn with Darwen'],
 ['GB', 'ENG', 'Borough of Blackpool'],
 ['GB', 'ENG', 'Borough of Bolton'],
 ['GB', 'ENG', 'Borough of Bournemouth'],
 ['GB', 'ENG', 'Borough of Bracknell Forest'],
 ['GB', 'ENG', 'City and Borough of Bradford'],
 ['GB', 'ENG', 'Borough of Brighton and Hove'],
 ['GB', 'ENG', 'City of Bristol'],
 ['GB', 'ENG', 'Borough of Bury'],
 ['GB', 'ENG', 'Borough of Calderdale'],
 ['GB', 'ENG', 'City and Borough of Coventry'],
 ['GB', 'ENG', 'Borough of Darlington'],
 ['GB', 'ENG', 'City of Derby'],
 ['GB', 'ENG', 'Borough of Doncaster'],
 ['GB', 'ENG', 'Borough of Dudley'],
 ['GB', 'ENG', 'Borough of Hartlepool'],
 ['GB', 'ENG', 'Kent'],
 ['GB', 'ENG', 'City of Kingston upon Hull'],
 ['GB', 'ENG', 'Borough of Kirklees'],
 ['GB', 'ENG', 'Borough of Knowsley'],
 ['GB', 'ENG', 'City and Borough of Leeds'],
 ['GB', 'ENG', 'City of Leicester'],
 ['GB', 'ENG', 'City and Borough of Liverpool'],
 ['GB', 'ENG', 'Borough of Luton'],
 ['GB', 'ENG', 'City and Borough of Manchester'],
 ['GB', 'ENG', 'Borough of Medway'],
 ['GB', 'ENG', 'Borough of Middlesbrough'],
 ['GB', 'ENG', 'Borough of Milton Keynes'],
 ['GB', 'ENG', 'City and Borough of Newcastle upon Tyne'],
 ['GB', 'ENG', 'North East Lincolnshire'],
 ['GB', 'ENG', 'North Lincolnshire'],
 ['GB', 'ENG', 'North Somerset'],
 ['GB', 'ENG', 'City of Nottingham'],
 ['GB', 'ENG', 'Borough of Oldham'],
 ['GB', 'ENG', 'City of Peterborough'],
 ['GB', 'ENG', 'City of Plymouth'],
 ['GB', 'ENG', 'Borough of Poole'],
 ['GB', 'ENG', 'City of Portsmouth'],
 ['GB', 'ENG', 'Borough of Reading'],
 ['GB', 'ENG', 'Borough of Redcar and Cleveland'],
 ['GB', 'ENG', 'Borough of Rochdale'],
 ['GB', 'ENG', 'Borough of Rotherham'],
 ['GB', 'ENG', 'City and Borough of Salford'],
 ['GB', 'ENG', 'Borough of Sandwell'],
 ['GB', 'ENG', 'Borough of Sefton'],
 ['GB', 'ENG', 'City and Borough of Sheffield'],
 ['GB', 'ENG', 'Slough'],
 ['GB', 'ENG', 'Borough of Solihull'],
 ['GB', 'ENG', 'City of Southampton'],
 ['GB', 'ENG', 'Borough of Southend-on-Sea'],
 ['GB', 'ENG', 'South Gloucestershire'],
 ['GB', 'ENG', 'Borough of South Tyneside'],
 ['GB', 'ENG', 'Borough of St. Helens'],
 ['GB', 'ENG', 'Borough of Stockport'],
 ['GB', 'ENG', 'Borough of Stockton-on-Tees'],
 ['GB', 'ENG', 'City of Stoke-on-Trent'],
 ['GB', 'ENG', 'City and Borough of Sunderland'],
 ['GB', 'ENG', 'Borough of Swindon'],
 ['GB', 'ENG', 'Borough of Tameside'],
 ['GB', 'ENG', 'District of Telford and Wrekin'],
 ['GB', 'ENG', 'Borough of Torbay'],
 ['GB', 'ENG', 'Borough of Trafford'],
 ['GB', 'ENG', 'City and Borough of Wakefield'],
 ['GB', 'ENG', 'Borough of Walsall'],
 ['GB', 'ENG', 'Borough of Warrington'],
 ['GB', 'ENG', 'West Berkshire'],
 ['GB', 'ENG', 'Borough of Wigan'],
 ['GB', 'ENG', 'Metropolitan Borough of Wirral'],
 ['GB', 'ENG', 'District of Wokingham'],
 ['GB', 'ENG', 'Borough of Wolverhampton'],
 ['GB', 'NIR', 'City of Belfast'],
 ['GB', 'SCT', 'Aberdeen City'],
 ['GB', 'SCT', 'Dundee City'],
 ['GB', 'SCT', 'East Ayrshire'],
 ['GB', 'SCT', 'East Dunbartonshire'],
 ['GB', 'SCT', 'East Renfrewshire'],
 ['GB', 'SCT', 'City of Edinburgh'],
 ['GB', 'SCT', 'Falkirk'],
 ['GB', 'SCT', 'Glasgow City'],
 ['GB', 'SCT', 'North Ayrshire'],
 ['GB', 'SCT', 'North Lanarkshire'],
 ['GB', 'SCT', 'Perth and Kinross'],
 ['GB', 'SCT', 'South Ayrshire'],
 ['GB', 'SCT', 'South Lanarkshire'],
 ['GB', 'SCT', 'West Dunbartonshire'],
 ['GB', 'WLS', 'Blaenau Gwent'],
 ['GB', 'WLS', 'Bridgend county borough'],
 ['GB', 'WLS', 'County Borough of Caerphilly'],
 ['GB', 'WLS', 'City and County of Cardiff'],
 ['GB', 'WLS', 'Conwy'],
 ['GB', 'WLS', 'County Borough of Merthyr Tydfil'],
 ['GB', 'WLS', 'Monmouthshire'],
 ['GB', 'WLS', 'Neath Port Talbot'],
 ['GB', 'WLS', 'City of Newport'],
 ['GB', 'WLS', 'Rhondda Cynon Taff'],
 ['GB', 'WLS', 'City and County of Swansea'],
 ['GB', 'WLS', 'County Borough of Torfaen'],
 ['GB', 'SCT', 'Argyll and Bute'],
 ['GB', 'ENG', 'Bedford'],
 ['GB', 'ENG', 'Central Bedfordshire'],
 ['GB', 'ENG', 'Cheshire East'],
 ['GB', 'ENG', 'Cheshire West and Chester'],
 ['GE', '71', 'Zugdidis Raioni'],
 ['GE', '61', 'Zestap\xe2\x80\x99onis Raioni'],
 ['GE', '00', 'Zavodskoy Rayon'],
 ['GE', '00', 'Vanis Raioni'],
 ['GE', '17', 'Dedop\xe2\x80\x99listsqaros Raioni'],
 ['GE', '00', 'Tsalkis Raioni'],
 ['GE', '00', 'Tsalenjikhis Raioni'],
 ['GE', '00', 'Ts\xe2\x80\x99ageris Raioni'],
 ['GE', '69', 'T\xe2\x80\x99ianet\xe2\x80\x99is Raioni'],
 ['GE', '00', 'T\xe2\x80\x99et\xe2\x80\x99ritsqaros Raioni'],
 ['GE', '66', 'T\xe2\x80\x99erjolis Raioni'],
 ['GE', '02', 'Sokhumis Raioni'],
 ['GE', '00', 'Sighnaghis Raioni'],
 ['GE', '71', 'Senakis Raioni'],
 ['GE', '66', 'Samtredia'],
 ['GE', '00', 'Sagarejos Raioni'],
 ['GE', '00', 'Pervomayskiy Rayon'],
 ['GE', '65', 'Ozurget\xe2\x80\x99is Raioni'],
 ['GE', '00', 'Ordzhonikidzevskiy Rayon'],
 ['GE', '39', 'Onis Raioni'],
 ['GE', '00', "Oktyabr'skiy Rayon"],
 ['GE', '69', 'Mts\xe2\x80\x99khet\xe2\x80\x99is Raioni'],
 ['GE', '00', 'Mestiis Raioni'],
 ['GE', '00', 'Baghdat\xe2\x80\x99is Raioni'],
 ['GE', '71', 'Martvilis Raioni'],
 ['GE', '00', 'Marneulis Raioni'],
 ['GE', '00', 'Lentekhis Raioni'],
 ['GE', '00', 'Leninskiy Rayon'],
 ['GE', '00', 'Akhalgoris Raioni'],
 ['GE', '00', 'Lanch\xe2\x80\x99khut\xe2\x80\x99is Raioni'],
 ['GE', '67', 'Lagodekhi'],
 ['GE', '43', 'Qvarlis Raioni'],
 ['GE', '04', 'K\xe2\x80\x99obulet\xe2\x80\x99is Raioni'],
 ['GE', '00', 'Kirovskiy Rayon'],
 ['GE', '00', 'Khonis Raioni'],
 ['GE', '00', 'Khobis Raioni'],
 ['GE', '73', 'Khashuris Raioni'],
 ['GE', '66', 'Kharagaulis Raioni'],
 ['GE', '00', 'Qazbegis Raioni'],
 ['GE', '73', 'Kaspis Raioni'],
 ['GE', '73', 'Kareli'],
 ['GE', '00', 'Kalininskiy Rayon'],
 ['GE', '00', 'Imeni Dvadtsati Shesti Komissarov Rayon'],
 ['GE', '00', 'Gurjaanis Raioni'],
 ['GE', '00', 'Goris Raioni'],
 ['GE', '00', 'Gldanskiy Rayon'],
 ['GE', '00', 'Gardabanis Raioni'],
 ['GE', '00', 'Javis Raioni'],
 ['GE', '00', 'Dushet\xe2\x80\x99is Raioni'],
 ['GE', '00', 'Dmanisis Raioni'],
 ['GE', '65', 'Ch\xe2\x80\x99okhatauris Raioni'],
 ['GE', '71', 'Ch\xe2\x80\x99khorotsqus Raioni'],
 ['GE', '13', 'Borjomis Raioni'],
 ['GE', '00', 'Bolnisis Raioni'],
 ['GE', '38', 'Ninotsmindis Raioni'],
 ['GE', '66', 'Tsqaltubo'],
 ['GE', '10', 'Aspindzis Raioni'],
 ['GE', '09', 'Ambrolauris Raioni'],
 ['GE', '08', 'Akhmetis Raioni'],
 ['GE', '07', 'Akhalts\xe2\x80\x99ikhis Raioni'],
 ['GE', '72', 'Akhalkalakis Raioni'],
 ['GE', '00', 'Adigenis Raioni'],
 ['GE', '00', 'Abasha'],
 ['GE', '14', 'K\xe2\x80\x99alak\xe2\x80\x99i Chiat\xe2\x80\x99ura'],
 ['GE',
  '00',
  'K\xe2\x80\x99alak\xe2\x80\x99i K\xe2\x80\x99ut\xe2\x80\x99aisi'],
 ['GE', '00', 'K\xe2\x80\x99alak\xe2\x80\x99i P\xe2\x80\x99ot\xe2\x80\x99i'],
 ['GE', '68', 'K\xe2\x80\x99alak\xe2\x80\x99i Rust\xe2\x80\x99avi'],
 ['GE', '66', 'K\xe2\x80\x99alak\xe2\x80\x99i Tqibuli'],
 ['GE', '66', 'Khoni'],
 ['GE', '66', 'Baghdati'],
 ['GE', '', 'Mestia'],
 ['GE', '71', 'Chkhorotsqu'],
 ['GE', '71', 'Martvili'],
 ['GE', '69', 'Dusheti'],
 ['GE', '68', 'Gardabani'],
 ['GE', '68', 'Marneuli'],
 ['GE', '67', 'Gurjaani'],
 ['GE', '67', 'Telavi'],
 ['GE', '71', 'Poti'],
 ['GE', '72', 'Adigeni'],
 ['GE', '72', 'Ninotsminda'],
 ['GE', '68', 'Tetri Tsqaro'],
 ['GE', '70', 'Tsageri'],
 ['GE', '70', 'Lentekhi'],
 ['GE', '69', 'Akhalgori'],
 ['GE', '69', 'Kazbegi'],
 ['GE', '67', 'Qvareli'],
 ['GE', '67', 'Sagarejo'],
 ['GE', '67', 'Sighnaghi'],
 ['GE', '67', 'Dedoplis Tskaro'],
 ['GE', '68', 'Tsalka'],
 ['GE', '66', 'Sachkhere'],
 ['GE', '69', 'Mtskheta'],
 ['GE', '71', 'Tsalenjikha'],
 ['GE', '65', 'Chokhatauri'],
 ['GE', '', 'Dmanisi'],
 ['GF', 'GF', 'Guyane'],
 ['GH', '00', 'Somanya District'],
 ['GH', '00', 'Keta'],
 ['GH', '00', 'Dagomba'],
 ['GH', '11', 'Nadowli'],
 ['GH', '11', 'Sissala West'],
 ['GH', '11', 'Wa East'],
 ['GH', '11', 'Wa West'],
 ['GH', '11', 'Sissala East'],
 ['GH', '11', 'Jirapa Lambussie'],
 ['GH', '06', 'Saboba Chereponi'],
 ['GH', '10', 'Talensi-Nabdam'],
 ['GH', '10', 'Garu-Tempane'],
 ['GH', '10', 'Builsa'],
 ['GH', '10', 'Bongo'],
 ['GH', '06', 'Nanumba South'],
 ['GH', '06', 'Nanumba North'],
 ['GH', '06', 'Sawla-Tuna-Kalba'],
 ['GH', '10', 'Bawku West'],
 ['GH', '06', 'Bunkpurugu-Yunyoo'],
 ['GH', '11', 'Lawra'],
 ['GH', '11', 'Jirapa'],
 ['GH', '06', 'Karaga'],
 ['GH', '06', 'Gushiegu'],
 ['GH', '06', 'Bole'],
 ['GH', '06', 'Kpandai'],
 ['GH', '06', 'East Gonja'],
 ['GH', '03', 'Atebubu'],
 ['GH', '08', 'Nkwanta North'],
 ['GH', '08', 'Nkwanta South'],
 ['GH', '03', 'Pru'],
 ['GH', '03', 'Sene'],
 ['GH', '08', 'Krachi East'],
 ['GH', '08', 'Krachi West'],
 ['GH', '03', 'Nkoranza North District'],
 ['GH', '04', 'Assin South'],
 ['GH', '04', 'Twifo Hemang Lower Denkyira'],
 ['GH', '02', 'Sekyere Afram Plains'],
 ['GH', '04', 'Upper Denkyira'],
 ['GH', '09', 'Ellembelle'],
 ['GH', '05', 'Dangme East District'],
 ['GH', '05', 'Atiwa'],
 ['GH', '06', 'Saboba'],
 ['GH', '06', 'Chereponi'],
 ['GH', '11', 'Lambussie Karni'],
 ['GH', '04', 'Abura/Asebu/Kwamankese'],
 ['GH', '01', 'Accra'],
 ['GH', '08', 'Adaklu-Anyigbe'],
 ['GH', '02', 'Adansi North'],
 ['GH', '02', 'Adansi South'],
 ['GH', '01', 'Adenta'],
 ['GH', '02', 'Afigya-Kwabre District'],
 ['GH', '04', 'Agona East'],
 ['GH', '04', 'Agona West'],
 ['GH', '02', 'Ahafo Ano North'],
 ['GH', '02', 'Ahafo Ano South'],
 ['GH', '09', 'Ahanta West'],
 ['GH', '04', 'Ajumako/Enyan/Essiam'],
 ['GH', '08', 'Akatsi District'],
 ['GH', '05', 'Akuapim North'],
 ['GH', '05', 'Akuapim South'],
 ['GH', '05', 'Akyemansa'],
 ['GH', '02', 'Amansie Central'],
 ['GH', '02', 'Amansie West'],
 ['GH', '09', 'Aowin/Suaman'],
 ['GH', '02', 'Asante Akim North'],
 ['GH', '02', 'Asante Akim South District'],
 ['GH', '01', 'Ashaiman'],
 ['GH', '04', 'Asikuma/Odoben/Brakwa'],
 ['GH', '04', 'Assin North'],
 ['GH', '03', 'Asunafo North'],
 ['GH', '03', 'Asunafo South'],
 ['GH', '05', 'Asuogyaman'],
 ['GH', '03', 'Asutifi'],
 ['GH', '02', 'Atwima Kwanwoma'],
 ['GH', '02', 'Atwima Mponua'],
 ['GH', '02', 'Atwima Nwabiagya'],
 ['GH', '04', 'Awutu Senya'],
 ['GH', '10', 'Bawku'],
 ['GH', '02', 'Bekwai'],
 ['GH', '03', 'Berekum'],
 ['GH', '09', 'Bia'],
 ['GH', '08', 'Biakoye'],
 ['GH', '09', 'Bibiani/Ahwiaso/Bekwai'],
 ['GH', '05', 'Birim Central'],
 ['GH', '05', 'Birim North'],
 ['GH', '05', 'Birim South'],
 ['GH', '10', 'Bolgatanga'],
 ['GH', '02', 'Bosome Freho'],
 ['GH', '02', 'Bosomtwe'],
 ['GH', '04', 'Cape Coast'],
 ['GH', '06', 'Central Gonja'],
 ['GH', '05', 'Dangme West District'],
 ['GH', '03', 'Dormaa'],
 ['GH', '03', 'Dormaa East new'],
 ['GH', '05', 'East Akim'],
 ['GH', '06', 'East Mamprusi'],
 ['GH', '04', 'Effutu'],
 ['GH', '02', 'Ejisu Juaben'],
 ['GH', '02', 'Ejura Sekyedumase'],
 ['GH', '05', 'Fanteakwa'],
 ['GH', '01', 'Ga East'],
 ['GH', '01', 'Ga West'],
 ['GH', '04', 'Gomoa East'],
 ['GH', '04', 'Gomoa West'],
 ['GH', '08', 'Ho'],
 ['GH', '08', 'Hohoe'],
 ['GH', '03', 'Jaman North'],
 ['GH', '03', 'Jaman South'],
 ['GH', '08', 'Jasikan'],
 ['GH', '09', 'Jomoro'],
 ['GH', '09', 'Juaboso'],
 ['GH', '08', 'Kadjebi'],
 ['GH', '10', 'Kassena Nankana'],
 ['GH', '08', 'Ketu North District'],
 ['GH', '08', 'Ketu South District'],
 ['GH', '03', 'Kintampo North Municipal District'],
 ['GH', '03', 'Kintampo South District'],
 ['GH', '04', 'Komenda/Edina/Eguafo/Abirem'],
 ['GH', '08', 'Kpando'],
 ['GH', '02', 'Kumasi'],
 ['GH', '02', 'Kwabre District'],
 ['GH', '05', 'Kwaebibirem'],
 ['GH', '05', 'Kwahu East'],
 ['GH', '05', 'Kwahu North'],
 ['GH', '05', 'Kwahu West'],
 ['GH', '05', 'Kwahu South'],
 ['GH', '01', 'Ledzekuku-Krowor'],
 ['GH', '05', 'Lower Manya Krobo'],
 ['GH', '02', 'Mampong'],
 ['GH', '04', 'Mfatseman'],
 ['GH', '09', 'Mpohor/Wassa East'],
 ['GH', '05', 'New Juaben'],
 ['GH', '03', 'Nkoranza South'],
 ['GH', '08', 'North Tongu'],
 ['GH', '09', 'Nzema East'],
 ['GH', '02', 'Obuasi'],
 ['GH', '02', 'Offinso'],
 ['GH', '02', 'Offinso North'],
 ['GH', '09', 'Prestea-Huni Valley'],
 ['GH', '06', 'Savelugu/Nanton'],
 ['GH', '09', 'Secondi Takoradi'],
 ['GH', '09', 'Sefwi Akontobra'],
 ['GH', '09', 'Sefwi-Wiawso'],
 ['GH', '02', 'Sekyere Central'],
 ['GH', '02', 'Sekyere East'],
 ['GH', '02', 'Sekyere South'],
 ['GH', '09', 'Shama new'],
 ['GH', '08', 'South Dayi'],
 ['GH', '08', 'South Tongu District'],
 ['GH', '05', 'Suhum/Kraboa/Coaltar'],
 ['GH', '03', 'Sunyani'],
 ['GH', '03', 'Sunyani West'],
 ['GH', '03', 'Tain'],
 ['GH', '06', 'Tamale'],
 ['GH', '03', 'Tano North'],
 ['GH', '03', 'Tano South'],
 ['GH', '09', 'Tarkwa Nsuaem'],
 ['GH', '03', 'Techiman Municipal District'],
 ['GH', '01', 'Tema Metropolitan District'],
 ['GH', '06', 'Tolon/Kumbungu'],
 ['GH', '04', 'Upper Denkyira East'],
 ['GH', '04', 'Upper Denkyira West'],
 ['GH', '05', 'Upper Manya Krobo'],
 ['GH', '11', 'Wa'],
 ['GH', '09', 'Wassa Amenfi East'],
 ['GH', '09', 'Wassa Amenfi West'],
 ['GH', '01', 'Weija'],
 ['GH', '03', 'Wenchi'],
 ['GH', '05', 'West Akim'],
 ['GH', '06', 'West Gonja'],
 ['GH', '06', 'West Mamprusi'],
 ['GH', '06', 'Yendi'],
 ['GH', '05', 'Yilo Krobo'],
 ['GH', '06', 'Zabzugu/Tatale'],
 ['GH', '09', 'Wassa West'],
 ['GH', '02', 'Kumasi Metropolitan District'],
 ['GM', '04', 'Wuli'],
 ['GM', '03', 'Upper Saloum'],
 ['GM', '07', 'Upper Niumi District'],
 ['GM', '07', 'Upper Baddibu'],
 ['GM', '04', 'Sandu'],
 ['GM', '03', 'Sami District'],
 ['GM', '03', 'Nianija District'],
 ['GM', '03', 'Niani'],
 ['GM', '03', 'Niamina West District'],
 ['GM', '03', 'Niamina East District'],
 ['GM', '03', 'Niamina Dankunku District'],
 ['GM', '03', 'Lower Saloum'],
 ['GM', '07', 'Lower Niumi District'],
 ['GM', '07', 'Lower Baddibu District'],
 ['GM', '05', 'Kombo South District'],
 ['GM', '05', 'Kombo North District'],
 ['GM', '05', 'Kombo East District'],
 ['GM', '05', 'Kombo Central District'],
 ['GM', '02', 'Kiang West District'],
 ['GM', '02', 'Kiang East'],
 ['GM', '02', 'Kiang Central'],
 ['GM', '04', 'Kantora'],
 ['GM', '07', 'Jokadu'],
 ['GM', '02', 'Jarra West'],
 ['GM', '02', 'Jarra East'],
 ['GM', '02', 'Jarra Central'],
 ['GM', '03', 'Fulladu West'],
 ['GM', '04', 'Fulladu East'],
 ['GM', '05', 'Foni Kansala'],
 ['GM', '05', 'Foni Jarrol'],
 ['GM', '05', 'Foni Brefet'],
 ['GM', '05', 'Foni Bondali'],
 ['GM', '05', 'Foni Bintang-Karenai'],
 ['GM', '07', 'Dappo'],
 ['GM', '07', 'Dappo'],
 ['GM', '07', 'Central Baddibu'],
 ['GM', '01', 'Kombo Saint Mary District'],
 ['GN', 'N', 'Pr\xc3\xa9fecture de Yomou'],
 ['GN', 'L', 'Tougue Prefecture'],
 ['GN', 'D', 'Telimele Prefecture'],
 ['GN', 'K', 'Siguiri Prefecture'],
 ['GN', 'M', 'Pr\xc3\xa9fecture de Pita'],
 ['GN', 'N', 'Nzerekore Prefecture'],
 ['GN', 'M', 'Mamou Prefecture'],
 ['GN', 'L', 'Mali Prefecture'],
 ['GN', 'N', 'Pr\xc3\xa9fecture de Macenta'],
 ['GN', 'L', 'Labe Prefecture'],
 ['GN', 'K', 'Pr\xc3\xa9fecture de Kouroussa'],
 ['GN', 'B', 'Koundara Prefecture'],
 ['GN', 'F', 'Pr\xc3\xa9fecture de Kissidougou'],
 ['GN', 'D', 'Pr\xc3\xa9fecture de Kindia'],
 ['GN', 'K', 'Kerouane Prefecture'],
 ['GN', 'K', 'Kankan Prefecture'],
 ['GN', 'N', 'Pr\xc3\xa9fecture de Gu\xc3\xa9k\xc3\xa9dou'],
 ['GN', 'B', 'Gaoual Prefecture'],
 ['GN', 'B', 'Pr\xc3\xa9fecture de Fria'],
 ['GN', 'D', 'Pr\xc3\xa9fecture de For\xc3\xa9cariah'],
 ['GN', 'F', 'Faranah Prefecture'],
 ['GN', 'D', 'Pr\xc3\xa9fecture de Dubr\xc3\xa9ka'],
 ['GN', 'F', 'Dinguiraye Prefecture'],
 ['GN', 'M', 'Pr\xc3\xa9fecture de Dalaba'],
 ['GN', 'F', 'Pr\xc3\xa9fecture de Dabola'],
 ['GN', 'B', 'Boke Prefecture'],
 ['GN', 'B', 'Pr\xc3\xa9fecture de Boffa'],
 ['GN', 'N', 'Beyla Prefecture'],
 ['GN', 'D', 'Pr\xc3\xa9fecture de Coyah'],
 ['GN', 'L', 'Pr\xc3\xa9fecture de Koubia'],
 ['GN', 'L', 'Lelouma Prefecture'],
 ['GN', 'N', 'Pr\xc3\xa9fecture de Lola'],
 ['GN', 'K', 'Mandiana Prefecture'],
 ['GN', '04', 'Conakry Special Zone'],
 ['GP', 'GP', 'Guadeloupe'],
 ['GR', 'ESYE22', 'Nom\xc3\xb3s Zak\xc3\xbdnthou'],
 ['GR', 'ESYE24', 'Nom\xc3\xb3s Voiot\xc3\xadas'],
 ['GR', 'ESYE14', 'Trikala'],
 ['GR', 'ESYE21', 'Nom\xc3\xb3s Thesprot\xc3\xadas'],
 ['GR', 'ESYE41', 'Nom\xc3\xb3s S\xc3\xa1mou'],
 ['GR', 'ESYE43', 'Nom\xc3\xb3s Reth\xc3\xbdmnis'],
 ['GR', 'ESYE21', 'Nom\xc3\xb3s Prev\xc3\xa9zis'],
 ['GR', 'ESYE25', 'Nom\xc3\xb3s Messin\xc3\xadas'],
 ['GR', 'ESYE14', 'Nom\xc3\xb3s Magnis\xc3\xadas'],
 ['GR', 'ESYE22', 'Lefkada'],
 ['GR', 'ESYE41', 'Nom\xc3\xb3s L\xc3\xa9svou'],
 ['GR', 'ESYE43', 'Nom\xc3\xb3s Lasith\xc3\xadou'],
 ['GR', 'ESYE14', 'Nom\xc3\xb3s Lar\xc3\xadsis'],
 ['GR', 'ESYE25', 'Nom\xc3\xb3s Lakon\xc3\xadas'],
 ['GR', 'ESYE25', 'Nom\xc3\xb3s Korinth\xc3\xadas'],
 ['GR', 'ESYE42', 'Nom\xc3\xb3s Kykl\xc3\xa1don'],
 ['GR', 'ESYE41', 'Chios'],
 ['GR', 'ESYE43', 'Nom\xc3\xb3s Chani\xc3\xa1s'],
 ['GR', 'ESYE22', 'Nom\xc3\xb3s Kefallin\xc3\xadas'],
 ['GR', 'ESYE14', 'Nom\xc3\xb3s Kardh\xc3\xadtsas'],
 ['GR', 'ESYE43', 'Nom\xc3\xb3s Irakle\xc3\xadou'],
 ['GR', 'ESYE21', 'Nom\xc3\xb3s Ioann\xc3\xadnon'],
 ['GR', 'ESYE23', 'Nom\xc3\xb3s Ile\xc3\xadas'],
 ['GR', 'ESYE24', 'Nom\xc3\xb3s Fthi\xc3\xb3tidos'],
 ['GR', 'ESYE24', 'Nom\xc3\xb3s Fok\xc3\xaddos'],
 ['GR', 'ESYE24', 'Nom\xc3\xb3s Evvo\xc3\xadas'],
 ['GR', 'ESYE24', 'Nom\xc3\xb3s Evrytan\xc3\xadas'],
 ['GR', 'ESYE42', 'Nom\xc3\xb3s Dodekan\xc3\xadsou'],
 ['GR', 'ESYE31', 'Nom\xc3\xb3s Attik\xc3\xads'],
 ['GR', 'ESYE21', 'Nom\xc3\xb3s \xc3\x81rtas'],
 ['GR', 'ESYE25', 'Nom\xc3\xb3s Arkad\xc3\xadas'],
 ['GR', 'ESYE25', 'Nom\xc3\xb3s Argol\xc3\xaddos'],
 ['GR', 'ESYE23', 'Nom\xc3\xb3s Acha\xe1\xb8\xafas'],
 ['GR', 'ESYE23', 'Nom\xc3\xb3s Aitol\xc3\xadas kai Akarnan\xc3\xadas'],
 ['GR', 'ESYE31', 'Nom\xc3\xb3s Pirai\xc3\xb3s'],
 ['GR', 'ESYE31', 'Nomarch\xc3\xada Anatolik\xc3\xads Attik\xc3\xads'],
 ['GR', 'ESYE31', 'Nomarch\xc3\xada Dytik\xc3\xads Attik\xc3\xads'],
 ['GR', 'ESYE31', 'Nomarch\xc3\xada Ath\xc3\xadnas'],
 ['GR', 'ESYE11', 'Nom\xc3\xb3s X\xc3\xa1nthis'],
 ['GR', 'ESYE12', 'Nom\xc3\xb3s Thessalon\xc3\xadkis'],
 ['GR', 'ESYE12', 'Nom\xc3\xb3s Serr\xc3\xb3n'],
 ['GR', 'ESYE11', 'Nom\xc3\xb3s Rod\xc3\xb3pis'],
 ['GR', 'ESYE12', 'Nom\xc3\xb3s Pier\xc3\xadas'],
 ['GR', 'ESYE12', 'Nom\xc3\xb3s P\xc3\xa9llis'],
 ['GR', 'ESYE13', 'Nom\xc3\xb3s Koz\xc3\xa1nis'],
 ['GR', 'ESYE12', 'Nom\xc3\xb3s Kilk\xc3\xads'],
 ['GR', 'ESYE12', 'Nom\xc3\xb3s Chalkidik\xc3\xads'],
 ['GR', 'ESYE11', 'Nom\xc3\xb3s Kav\xc3\xa1las'],
 ['GR', 'ESYE13', 'Nom\xc3\xb3s Kastori\xc3\xa1s'],
 ['GR', 'ESYE12', 'Nom\xc3\xb3s Imath\xc3\xadas'],
 ['GR', 'ESYE13', 'Nom\xc3\xb3s Greven\xc3\xb3n'],
 ['GR', 'ESYE13', 'Nom\xc3\xb3s Flor\xc3\xadnis'],
 ['GR', 'ESYE11', 'Nom\xc3\xb3s \xc3\x89vrou'],
 ['GR', 'ESYE11', 'Nom\xc3\xb3s Dr\xc3\xa1mas'],
 ['GR', 'ESYE22', 'Nom\xc3\xb3s Kerk\xc3\xbdras'],
 ['GT', '20', 'Municipio de Zunilito'],
 ['GT', '13', 'Municipio de Zunil'],
 ['GT', '03', 'Municipio de Zaragoza'],
 ['GT', '11', 'Municipio de Zapotitl\xc3\xa1n'],
 ['GT', '22', 'Municipio de Zacapa'],
 ['GT', '11', 'Municipio de Yupiltepeque'],
 ['GT', '03', 'Municipio de Yepocapa'],
 ['GT', '07', 'Municipio de Villa Nueva'],
 ['GT', '07', 'Municipio de Villa Canales'],
 ['GT', '22', 'Municipio de Usumatl\xc3\xa1n'],
 ['GT', '14', 'Municipio de Uspant\xc3\xa1n'],
 ['GT', '01', 'Municipio de Tucur\xc3\xba'],
 ['GT', '21', 'Municipio de Totonicap\xc3\xa1n'],
 ['GT', '08', 'Municipio de Todos Santos Cuchumat\xc3\xa1n'],
 ['GT', '06', 'Municipio de Tiquisate'],
 ['GT', '17', 'Municipio de Tejutla'],
 ['GT', '22', 'Muncipio de Teculut\xc3\xa1n'],
 ['GT', '08', 'Municipio de Tectit\xc3\xa1n'],
 ['GT', '03', 'Municipio de Tecp\xc3\xa1n Guatemala'],
 ['GT', '18', 'Municipio de Taxisco'],
 ['GT', '01', 'Municipio de Tamah\xc3\xba'],
 ['GT', '17', 'Municipio de Tajumulco'],
 ['GT', '01', 'Municipio de Tactic'],
 ['GT', '17', 'Municipio de Tacan\xc3\xa1'],
 ['GT', '16', 'Municipio de Sumpango'],
 ['GT', '08', 'Municipio de Soloma'],
 ['GT', '19', 'Municipio de Solol\xc3\xa1'],
 ['GT', '06', 'Municipio de Siquinal\xc3\xa1'],
 ['GT', '17', 'Municipio de Sipacapa'],
 ['GT', '17', 'Municipio de Sibinal'],
 ['GT', '13', 'Municipio de Sibilia'],
 ['GT', '01', 'Municipio de Senah\xc3\xba'],
 ['GT', '12', 'Municipio de Sayaxch\xc3\xa9'],
 ['GT', '06', 'Municipio de San Vicente Pacaya'],
 ['GT', '20', 'Municipio de Santo Tom\xc3\xa1s La Uni\xc3\xb3n'],
 ['GT', '16', 'Municipio de Santo Domingo Xenacoj'],
 ['GT', '20', 'Municipio de Santo Domingo Suchitep\xc3\xa9quez'],
 ['GT', '16', 'Municipio de Santiago Sacatep\xc3\xa9quez'],
 ['GT', '08', 'Municipio de Santiago Chimaltenango'],
 ['GT', '19', 'Municipio de Santiago Atitl\xc3\xa1n'],
 ['GT', '18', 'Municipio de Santa Rosa de Lima'],
 ['GT', '19', 'Municipio de Santa Mar\xc3\xada Visitaci\xc3\xb3n'],
 ['GT', '18', 'Municipio de Santa Mar\xc3\xada Ixhuat\xc3\xa1n'],
 ['GT', '16', 'Municipio de Santa Mar\xc3\xada de Jes\xc3\xbas'],
 ['GT', '21', 'Municipio de Santa Mar\xc3\xada Chiquimula'],
 ['GT', '19', 'Municipio de Santa Luc\xc3\xada Utatl\xc3\xa1n'],
 ['GT', '16', 'Municipio de Santa Luc\xc3\xada Milpas Altas'],
 ['GT', '21', 'Municipio de Santa Luc\xc3\xada La Reforma'],
 ['GT', '06', 'Municipio de Santa Luc\xc3\xada Cotzumalguapa'],
 ['GT', '08', 'Municipio de Santa Eulalia'],
 ['GT', '01', 'Municipio de Santa Cruz Verapaz'],
 ['GT', '18', 'Municipio de Santa Cruz Naranjo'],
 ['GT', '15', 'Municipio de Santa Cruz Mulu\xc3\xa1'],
 ['GT', '19', 'Municipio de Santa Cruz La Laguna'],
 ['GT', '14', 'Municipio de Santa Cruz del Quich\xc3\xa9'],
 ['GT', '03', 'Municipio de Santa Cruz Balany\xc3\xa1'],
 ['GT', '19', 'Municipio de Santa Clara La Laguna'],
 ['GT', '07', 'Municipio de Santa Catarina Pinula'],
 ['GT', '19', 'Municipio de Santa Catarina Palop\xc3\xb3'],
 ['GT', '11', 'Municipio de Santa Catarina Mita'],
 ['GT', '19', 'Municipio de Santa Catarina Ixtahuac\xc3\xa1n'],
 ['GT', '16', 'Municipio de Santa Catarina Barahona'],
 ['GT', '08', 'Municipio de Santa B\xc3\xa1rbara'],
 ['GT', '20', 'Municipio de Santa B\xc3\xa1rbara'],
 ['GT', '03', 'Municipio de Santa Apolonia'],
 ['GT', '08', 'Municipio de Santa Ana Huista'],
 ['GT', '12', 'Municipio de Santa Ana'],
 ['GT', '08', 'Municipio de San Sebasti\xc3\xa1n Huehuetenango'],
 ['GT', '08', 'Municipio de San Sebasti\xc3\xa1n Coat\xc3\xa1n'],
 ['GT', '15', 'Municipio de San Sebasti\xc3\xa1n'],
 ['GT', '05', 'Municipio de Sansare'],
 ['GT', '07', 'Municipio de San Raimundo'],
 ['GT', '17', 'Municipio de San Rafael Pie de La Cuesta'],
 ['GT', '08', 'Municipio de San Rafael Petzal'],
 ['GT', '18', 'Municipio de San Rafael Las Flores'],
 ['GT', '08', 'Municipio de San Rafael La Independencia'],
 ['GT', '17', 'Municipio de San Pedro Sacatep\xc3\xa9quez'],
 ['GT', '07', 'Municipio de San Pedro Sacatep\xc3\xa9quez'],
 ['GT', '10', 'Municipio de San Pedro Pinula'],
 ['GT', '08', 'Municipio de San Pedro Necta'],
 ['GT', '19', 'Municipio de San Pedro La Laguna'],
 ['GT', '14', 'Municipio de San Pedro Jocopilas'],
 ['GT', '01', 'Municipio de San Pedro Carch\xc3\xa1'],
 ['GT', '07', 'Municipio de San Pedro Ayampuc'],
 ['GT', '19', 'Municipio de San Pablo La Laguna'],
 ['GT', '20', 'Municipio de San Pablo Jocopilas'],
 ['GT', '17', 'Municipio de San Pablo'],
 ['GT', '13', 'Municipio de San Miguel Sig\xc3\xbcil\xc3\xa1'],
 ['GT', '20', 'Municipio de San Miguel Pan\xc3\xa1n'],
 ['GT', '17', 'Municipio de San Miguel Ixtahuac\xc3\xa1n'],
 ['GT', '16', 'Municipio de San Miguel Due\xc3\xb1as'],
 ['GT', '02', 'Municipio de San Miguel Chicaj'],
 ['GT', '08', 'Municipio de San Miguel Acat\xc3\xa1n'],
 ['GT', '08', 'Municipio de San Mateo Ixtat\xc3\xa1n'],
 ['GT', '13', 'Municipio de San Mateo'],
 ['GT', '15', 'Municipio de San Mart\xc3\xadn Zapotitl\xc3\xa1n'],
 ['GT', '13', 'Municipio de San Mart\xc3\xadn Sacatep\xc3\xa9quez'],
 ['GT', '03', 'Municipio de San Mart\xc3\xadn Jilotepeque'],
 ['GT', '19', 'Municipio de San Marcos La Laguna'],
 ['GT', '17', 'Municipio de San Marcos'],
 ['GT', '10', 'Municipio de San Manuel Chaparr\xc3\xb3n'],
 ['GT', '10', 'Muncipio de San Luis Jilotepeque'],
 ['GT', '12', 'Municipio de San Luis'],
 ['GT', '19', 'Municipio de San Lucas Tolim\xc3\xa1n'],
 ['GT', '16', 'Municipio de San Lucas Sacatep\xc3\xa9quez'],
 ['GT', '17', 'Municipio de San Lorenzo'],
 ['GT', '20', 'Municipio de San Lorenzo'],
 ['GT', '18', 'Municipio de San Juan Tecuaco'],
 ['GT', '07', 'Municipio de San Juan Sacatep\xc3\xa9quez'],
 ['GT', '19', 'Municipio de San Juan La Laguna'],
 ['GT', '08', 'Municipio de San Juan Ixcoy'],
 ['GT', '04', 'Municipio de San Juan Ermita'],
 ['GT', '14', 'Municipio de San Juan Cotzal'],
 ['GT', '01', 'Municipio de San Juan Chamelco'],
 ['GT', '20', 'Municipio de San Juan Bautista'],
 ['GT', '08', 'Municipio de San Juan Atit\xc3\xa1n'],
 ['GT', '03', 'Municipio de San Jos\xc3\xa9 Poaquil'],
 ['GT', '07', 'Municipio de San Jos\xc3\xa9 Pinula'],
 ['GT', '17', 'Municipio de San Jos\xc3\xa9 Ojetenam'],
 ['GT', '04', 'Municipio de San Jos\xc3\xa9 La Arada'],
 ['GT', '20', 'Municipio de San Jos\xc3\xa9 El \xc3\x8ddolo'],
 ['GT', '07', 'Municipio de San Jos\xc3\xa9 del Golfo'],
 ['GT', '19', 'Municipio de San Jos\xc3\xa9 Chacay\xc3\xa1'],
 ['GT', '11', 'Municipio de San Jos\xc3\xa9 Acatempa'],
 ['GT', '12', 'Municipio de San Jos\xc3\xa9'],
 ['GT', '06', 'Municipio de San Jos\xc3\xa9'],
 ['GT', '02', 'Municipio de San Jer\xc3\xb3nimo'],
 ['GT', '04', 'Municipio de San Jacinto'],
 ['GT', '08', 'Municipio de San Gaspar Ixchil'],
 ['GT', '20', 'Municipio de San Gabriel'],
 ['GT', '20', 'Municipio de San Francisco Zapotitl\xc3\xa1n'],
 ['GT', '13', 'Municipio de San Francisco La Uni\xc3\xb3n'],
 ['GT', '21', 'Municipio de San Francisco El Alto'],
 ['GT', '12', 'Municipio de San Francisco'],
 ['GT', '15', 'Municipio de San Felipe'],
 ['GT', '22', 'Municipio de San Diego'],
 ['GT', '01', 'Municipio de San Crist\xc3\xb3bal Verapaz'],
 ['GT', '21', 'Municipio de San Crist\xc3\xb3bal Totonicap\xc3\xa1n'],
 ['GT', '17', 'Municipio de San Crist\xc3\xb3bal Cucho'],
 ['GT', '05', 'Municipio de San Crist\xc3\xb3bal Acasaguastl\xc3\xa1n'],
 ['GT', '13', 'Municipio de San Carlos Sija'],
 ['GT', '10', 'Municipio de San Carlos Alzatate'],
 ['GT', '20', 'Municipio de San Bernardino'],
 ['GT', '12', 'Municipio de San Benito'],
 ['GT', '16', 'Municipio de San Bartolom\xc3\xa9 Milpas Altas'],
 ['GT', '14', 'Municipio de San Bartolom\xc3\xa9 Jocotenango'],
 ['GT', '21', 'Municipio de San Bartolo'],
 ['GT', '05', 'Municipio de Sanarate'],
 ['GT', '20', 'Municipio de San Antonio Suchitep\xc3\xa9quez'],
 ['GT', '17', 'Municipio de San Antonio Sacatep\xc3\xa9quez'],
 ['GT', '19', 'Municipio de San Antonio Palop\xc3\xb3'],
 ['GT', '05', 'Municipio de San Antonio La Paz'],
 ['GT', '14', 'Municipio de San Antonio Ilotenango'],
 ['GT', '08', 'Municipio de San Antonio Huista'],
 ['GT', '16', 'Municipio de San Antonio Aguas Calientes'],
 ['GT', '21', 'Municipio de San Andr\xc3\xa9s Xecul'],
 ['GT', '15', 'Municipio de San Andr\xc3\xa9s Villa Seca'],
 ['GT', '19', 'Municipio de San Andr\xc3\xa9s Semetabaj'],
 ['GT', '14', 'Municipio de San Andr\xc3\xa9s Sajcabaj\xc3\xa1'],
 ['GT', '03', 'Municipio de San Andr\xc3\xa9s Itzapa'],
 ['GT', '12', 'Municipio de San Andr\xc3\xa9s'],
 ['GT', '05', 'Municipio de San Agust\xc3\xadn Acasaguastl\xc3\xa1n'],
 ['GT', '20', 'Municipio de Samayac'],
 ['GT', '13', 'Municipio de Salcaj\xc3\xa1'],
 ['GT', '02', 'Municipio de Salam\xc3\xa1'],
 ['GT', '14', 'Municipio de Sacapulas'],
 ['GT', '22', 'Municipio de R\xc3\xado Hondo'],
 ['GT', '20', 'Municipio de R\xc3\xado Bravo'],
 ['GT', '17', 'Municipio de R\xc3\xado Blanco'],
 ['GT', '15', 'Municipio de Retalhuleu'],
 ['GT', '02', 'Municipio de Rabinal'],
 ['GT', '04', 'Municipio de Quezaltepeque'],
 ['GT', '13', 'Municipio de Quetzaltenango'],
 ['GT', '11', 'Municipio de Quesada'],
 ['GT', '02', 'Municipio de Purulh\xc3\xa1'],
 ['GT', '09', 'Municipio de Puerto Barrios'],
 ['GT', '18', 'Municipio de Pueblo Nuevo Vi\xc3\xb1as'],
 ['GT', '20', 'Municipio de Pueblo Nuevo'],
 ['GT', '12', 'Municipio de Popt\xc3\xban'],
 ['GT', '03', 'Municipio de Pochuta'],
 ['GT', '07', 'Municipio de Petapa'],
 ['GT', '03', 'Municipio de Patz\xc3\xban'],
 ['GT', '14', 'Municipio de Patzit\xc3\xa9'],
 ['GT', '03', 'Municipio de Patzic\xc3\xada'],
 ['GT', '20', 'Municipio de Patulul'],
 ['GT', '16', 'Municipio de Pastores'],
 ['GT', '11', 'Municipio de Pasaco'],
 ['GT', '03', 'Municipio de Parramos'],
 ['GT', '01', 'Municipio de Panz\xc3\xb3s'],
 ['GT', '19', 'Municipio de Panajachel'],
 ['GT', '06', 'Municipio de Pal\xc3\xadn'],
 ['GT', '13', 'Municipio de Palestina de los Altos'],
 ['GT', '07', 'Municipio de Palencia'],
 ['GT', '17', 'Municipio de Pajapita'],
 ['GT', '13', 'Municipio de Ostuncalco'],
 ['GT', '18', 'Municipio de Oratorio'],
 ['GT', '04', 'Municipio de Olopa'],
 ['GT', '13', 'Municipio de Olintepeque'],
 ['GT', '17', 'Municipio de Oc\xc3\xb3s'],
 ['GT', '15', 'Municipio de Nuevo San Carlos'],
 ['GT', '17', 'Municipio de Nuevo Progreso'],
 ['GT', '18', 'Municipio de Nueva Santa Rosa'],
 ['GT', '06', 'Municipio de Nueva Concepci\xc3\xb3n'],
 ['GT', '08', 'Municipio de Nent\xc3\xb3n'],
 ['GT', '14', 'Municipio de Nebaj'],
 ['GT', '19', 'Municipio de Nahual\xc3\xa1'],
 ['GT', '11', 'Municipio de Moyuta'],
 ['GT', '05', 'Municipio de Moraz\xc3\xa1n'],
 ['GT', '09', 'Municipio de Morales'],
 ['GT', '10', 'Municipio de Monjas'],
 ['GT', '21', 'Municipio de Momostenango'],
 ['GT', '07', 'Municipio de Mixco'],
 ['GT', '12', 'Municipio de Melchor de Mencos'],
 ['GT', '20', 'Municipio de Mazatenango'],
 ['GT', '10', 'Municipio de Mataquescuintla'],
 ['GT', '06', 'Municipio de Masagua'],
 ['GT', '08', 'Municipio de Malacatancito'],
 ['GT', '17', 'Municipio de Malacat\xc3\xa1n'],
 ['GT', '16', 'Municipio de Magdalena Milpas Altas'],
 ['GT', '09', 'Municipio de Los Amates'],
 ['GT', '09', 'Municipio de L\xc3\xadvingston'],
 ['GT', '22', 'Municipio de La Uni\xc3\xb3n'],
 ['GT', '17', 'Municipio de La Reforma'],
 ['GT', '01', 'Municipio de Lanqu\xc3\xadn'],
 ['GT', '12', 'Municipio de La Libertad'],
 ['GT', '08', 'Municipio de La Libertad'],
 ['GT', '06', 'Municipio de La Gomera'],
 ['GT', '13', 'Municipio de La Esperanza'],
 ['GT', '08', 'Municipio de La Democracia'],
 ['GT', '06', 'Municipio de La Democracia'],
 ['GT', '11', 'Municipio de Jutiapa'],
 ['GT', '14', 'Municipio de Joyabaj'],
 ['GT', '16', 'Municipio de Jocotenango'],
 ['GT', '04', 'Municipio de Jocot\xc3\xa1n'],
 ['GT', '11', 'Municipio de Jerez'],
 ['GT', '11', 'Municipio de Jalpatagua'],
 ['GT', '10', 'Municipio de Jalapa'],
 ['GT', '08', 'Municipio de Jacaltenango'],
 ['GT', '06', 'Municipio de Iztapa'],
 ['GT', '08', 'Municipio de Ixtahuac\xc3\xa1n'],
 ['GT', '17', 'Municipio de Ixchigu\xc3\xa1n'],
 ['GT', '04', 'Municipio de Ipala'],
 ['GT', '22', 'Municipio de Huit\xc3\xa9'],
 ['GT', '13', 'Municipio de Huit\xc3\xa1n'],
 ['GT', '08', 'Municipio de Huehuetenango'],
 ['GT', '18', 'Municipio de Guazacap\xc3\xa1n'],
 ['GT', '07', 'Municipio de Guatemala'],
 ['GT', '06', 'Municipio de Guanagazapa'],
 ['GT', '22', 'Municipio de Gual\xc3\xa1n'],
 ['GT', '02', 'Municipio de Granados'],
 ['GT', '13', 'Municipio de G\xc3\xa9nova'],
 ['GT', '07', 'Municipio de Fraijanes'],
 ['GT', '13', 'Municipio de Flores Costa Cuca'],
 ['GT', '12', 'Municipio de Flores'],
 ['GT', '22', 'Municipio de Estanzuela'],
 ['GT', '17', 'Municipio de Esquipulas Palo Gordo'],
 ['GT', '04', 'Municipio de Esquipulas'],
 ['GT', '06', 'Municipio de Escuintla'],
 ['GT', '17', 'Municipio de El Tumbador'],
 ['GT', '03', 'Municipio de El Tejar'],
 ['GT', '17', 'Municipio de El Rodeo'],
 ['GT', '17', 'Municipio de El Quetzal'],
 ['GT', '05', 'Municipio de El Progreso'],
 ['GT', '11', 'Municipio de El Progreso'],
 ['GT', '13', 'Municipio de El Palmar'],
 ['GT', '05', 'Municipio de El J\xc3\xadcaro'],
 ['GT', '09', 'Municipio de El Estor'],
 ['GT', '02', 'Municipio de El Chol'],
 ['GT', '15', 'Municipio de El Asintal'],
 ['GT', '11', 'Municipio de El Adelanto'],
 ['GT', '12', 'Municipio de Dolores'],
 ['GT', '20', 'Municipio de Cuyotenango'],
 ['GT', '14', 'Municipio de Cun\xc3\xa9n'],
 ['GT', '08', 'Municipio de Cuilco'],
 ['GT', '18', 'Municipio de Cuilapa'],
 ['GT', '02', 'Municipio de Cubulco'],
 ['GT', '11', 'Municipio de Conguaco'],
 ['GT', '17', 'Municipio de Concepci\xc3\xb3n Tutuapa'],
 ['GT', '04', 'Municipio de Concepci\xc3\xb3n Las Minas'],
 ['GT', '13', 'Municipio de Concepci\xc3\xb3n Chiquirichapa'],
 ['GT', '08', 'Municipio de Concepci\xc3\xb3n'],
 ['GT', '19', 'Municipio de Concepci\xc3\xb3n'],
 ['GT', '17', 'Municipio de Comitancillo'],
 ['GT', '11', 'Municipio de Comapa'],
 ['GT', '03', 'Municipio de Comalapa'],
 ['GT', '08', 'Municipio de Colotenango'],
 ['GT', '13', 'Municipio de Colomba'],
 ['GT', '01', 'Municipio de Cob\xc3\xa1n'],
 ['GT', '13', 'Municipio de Coatepeque'],
 ['GT', '16', 'Municipio de Ciudad Vieja'],
 ['GT', '07', 'Municipio de Chuarrancho'],
 ['GT', '01', 'Municipio de Chisec'],
 ['GT', '18', 'Municipio de Chiquimulilla'],
 ['GT', '04', 'Municipio de Chiquimula'],
 ['GT', '14', 'Municipio de Chinique'],
 ['GT', '07', 'Municipio de Chinautla'],
 ['GT', '03', 'Municipio de Chimaltenango'],
 ['GT', '14', 'Municipio de Chichicastenango'],
 ['GT', '14', 'Municipio de Chich\xc3\xa9'],
 ['GT', '20', 'Municipio de Chicacao'],
 ['GT', '08', 'Municipio de Chiantla'],
 ['GT', '15', 'Municipio de Champerico'],
 ['GT', '14', 'Municipio de Chajul'],
 ['GT', '01', 'Municipio de Chahal'],
 ['GT', '17', 'Municipio de Catarina'],
 ['GT', '18', 'Municipio de Casillas'],
 ['GT', '13', 'Municipio de Cantel'],
 ['GT', '14', 'Municipio de Canill\xc3\xa1'],
 ['GT', '04', 'Municipio de Camot\xc3\xa1n'],
 ['GT', '13', 'Municipio de Cajol\xc3\xa1'],
 ['GT', '01', 'Municipio de Cahab\xc3\xb3n'],
 ['GT', '13', 'Municipio de Cabric\xc3\xa1n'],
 ['GT', '22', 'Municipio de Caba\xc3\xb1as'],
 ['GT', '08', 'Municipio de Barillas'],
 ['GT', '18', 'Municipio de Barberena'],
 ['GT', '17', 'Municipio de Ayutla'],
 ['GT', '11', 'Municipio de Atescatempa'],
 ['GT', '11', 'Municipio de Asunci\xc3\xb3n Mita'],
 ['GT', '16', 'Municipio de Antigua Guatemala'],
 ['GT', '07', 'Municipio de Amatitl\xc3\xa1n'],
 ['GT', '16', 'Municipio de Alotenango'],
 ['GT', '13', 'Municipio de Almolonga'],
 ['GT', '08', 'Municipio de Aguacat\xc3\xa1n'],
 ['GT', '11', 'Municipio de Agua Blanca'],
 ['GT', '03', 'Municipio de Acatenango'],
 ['GW', '06', 'Sao Domingos'],
 ['GW', '06', 'Cacheu Sector'],
 ['GW', '07', 'Bedanda'],
 ['GW', '02', 'Fulcunda'],
 ['GW', '02', 'Buba'],
 ['GW', '05', 'Bubaque'],
 ['GW', '07', 'Quebo'],
 ['GW', '07', 'Cacine'],
 ['GW', '05', 'Caravela'],
 ['GW', '06', 'Bigene Sector'],
 ['GW', '12', 'Prabis Sector'],
 ['GW', '12', 'Quinhamel Sector'],
 ['GW', '04', 'Mansaba Sector'],
 ['GW', '04', 'Bissora Sector'],
 ['GW', '04', 'Nhacra Sector'],
 ['GW', '04', 'Farim Sector'],
 ['GW', '10', 'Sonaco Sector'],
 ['GW', '01', 'Xitole Sector'],
 ['GW', '06', 'Caio Sector'],
 ['GW', '06', 'Canchungo Sector'],
 ['GW', '06', 'Bula'],
 ['GW', '04', 'Mansoa'],
 ['GW', '01', 'Gamamundo Sector'],
 ['GW', '01', 'Galomaro Sector'],
 ['GW', '01', 'Bafata Sector'],
 ['GW', '10', 'Gabu Sector'],
 ['GW', '01', 'Contuboel Sector'],
 ['HN', '07', 'Yuscar\xc3\xa1n'],
 ['HN', '18', 'Yoro'],
 ['HN', '18', 'Yorito'],
 ['HN', '15', 'Yoc\xc3\xb3n'],
 ['HN', '07', 'Yauyupe'],
 ['HN', '12', 'Yarula'],
 ['HN', '10', 'Yamaranguila'],
 ['HN', '09', 'Wampusirpi'],
 ['HN', '13', 'Virginia'],
 ['HN', '06', 'Villanueva'],
 ['HN', '08', 'Villa de San Francisco'],
 ['HN', '04', 'Villa de San Antonio'],
 ['HN', '18', 'Victoria'],
 ['HN', '05', 'Veracruz'],
 ['HN', '08', 'Valle de \xc3\x81ngeles'],
 ['HN', '13', 'Valladolid'],
 ['HN', '07', 'Vado Ancho'],
 ['HN', '11', 'Utila'],
 ['HN', '03', 'Trujillo'],
 ['HN', '05', 'Trinidad de Cop\xc3\xa1n'],
 ['HN', '16', 'Trinidad'],
 ['HN', '13', 'Tomal\xc3\xa1'],
 ['HN', '03', 'Tocoa'],
 ['HN', '07', 'Tex\xc3\xadguat'],
 ['HN', '07', 'Teupasenti'],
 ['HN', '01', 'Tela'],
 ['HN', '08', 'Tatumbla'],
 ['HN', '13', 'Tambla'],
 ['HN', '13', 'Talgua'],
 ['HN', '08', 'Talanga'],
 ['HN', '18', 'Sulaco'],
 ['HN', '03', 'Sonaguera'],
 ['HN', '07', 'Soledad'],
 ['HN', '14', 'Sinuapa'],
 ['HN', '15', 'Silca'],
 ['HN', '04', 'Siguatepeque'],
 ['HN', '14', 'Sensenti'],
 ['HN', '03', 'Sav\xc3\xa1'],
 ['HN', '16', 'San Vicente Centenario'],
 ['HN', '12', 'Santiago Puringla'],
 ['HN', '05', 'Santa Rosa de Cop\xc3\xa1n'],
 ['HN', '03', 'Santa Rosa de Agu\xc3\xa1n'],
 ['HN', '18', 'Santa Rita'],
 ['HN', '05', 'Santa Rita'],
 ['HN', '16', 'Santa Rita'],
 ['HN', '15', 'Santa Mar\xc3\xada del Real'],
 ['HN', '12', 'Santa Mar\xc3\xada'],
 ['HN', '08', 'Santa Luc\xc3\xada'],
 ['HN', '10', 'Santa Luc\xc3\xada'],
 ['HN', '03', 'Santa Fe'],
 ['HN', '14', 'Santa Fe'],
 ['HN', '12', 'Santa Elena'],
 ['HN', '06', 'Santa Cruz de Yojoa'],
 ['HN', '13', 'Santa Cruz'],
 ['HN', '16', 'Santa B\xc3\xa1rbara'],
 ['HN', '02', 'Santa Ana de Yusguare'],
 ['HN', '12', 'Santa Ana'],
 ['HN', '08', 'Santa Ana'],
 ['HN', '13', 'San Sebasti\xc3\xa1n'],
 ['HN', '04', 'San Sebasti\xc3\xa1n'],
 ['HN', '13', 'San Rafael'],
 ['HN', '16', 'San Pedro Zacapa'],
 ['HN', '06', 'San Pedro Sula'],
 ['HN', '12', 'San Pedro de Tutule'],
 ['HN', '05', 'San Pedro'],
 ['HN', '05', 'San Nicol\xc3\xa1s'],
 ['HN', '16', 'San Nicol\xc3\xa1s'],
 ['HN', '10', 'San Miguelito'],
 ['HN', '08', 'San Miguelito'],
 ['HN', '07', 'San Mat\xc3\xadas'],
 ['HN', '10', 'San Marcos de Sierra'],
 ['HN', '02', 'San Marcos de Col\xc3\xb3n'],
 ['HN', '16', 'San Marcos'],
 ['HN', '14', 'San Marcos'],
 ['HN', '13', 'San Manuel de Colohete'],
 ['HN', '06', 'San Manuel'],
 ['HN', '16', 'San Luis'],
 ['HN', '04', 'San Luis'],
 ['HN', '07', 'San Lucas'],
 ['HN', '17', 'San Lorenzo'],
 ['HN', '13', 'San Juan Guarita'],
 ['HN', '05', 'San Juan de Opoa'],
 ['HN', '08', 'San Juan de Flores'],
 ['HN', '10', 'San Juan'],
 ['HN', '12', 'San Juan'],
 ['HN', '04', 'San Jos\xc3\xa9 del Potrero'],
 ['HN', '05', 'San Jos\xc3\xa9 de Cop\xc3\xa1n'],
 ['HN', '04', 'San Jos\xc3\xa9 de Comayagua'],
 ['HN', '16', 'San Jos\xc3\xa9 de Colinas'],
 ['HN', '12', 'San Jos\xc3\xa9'],
 ['HN', '02', 'San Jos\xc3\xa9'],
 ['HN', '14', 'San Jorge'],
 ['HN', '05', 'San Jer\xc3\xb3nimo'],
 ['HN', '04', 'San Jer\xc3\xb3nimo'],
 ['HN', '10', 'San Isidro'],
 ['HN', '02', 'San Isidro'],
 ['HN', '08', 'San Ignacio'],
 ['HN', '06', 'San Francisco de Yojoa'],
 ['HN', '16', 'San Francisco de Ojuera'],
 ['HN', '14', 'San Francisco del Valle'],
 ['HN', '15', 'San Francisco de la Paz'],
 ['HN', '17', 'San Francisco de Coray'],
 ['HN', '15', 'San Francisco de Becerra'],
 ['HN', '01', 'San Francisco'],
 ['HN', '13', 'San Francisco'],
 ['HN', '14', 'San Fernando'],
 ['HN', '15', 'San Esteban'],
 ['HN', '08', 'San Buenaventura'],
 ['HN', '08', 'San Antonio de Oriente'],
 ['HN', '12', 'San Antonio del Norte'],
 ['HN', '07', 'San Antonio de Flores'],
 ['HN', '02', 'San Antonio de Flores'],
 ['HN', '06', 'San Antonio de Cort\xc3\xa9s'],
 ['HN', '05', 'San Antonio'],
 ['HN', '10', 'San Antonio'],
 ['HN', '13', 'San Andr\xc3\xa9s'],
 ['HN', '05', 'San Agust\xc3\xadn'],
 ['HN', '15', 'Salam\xc3\xa1'],
 ['HN', '08', 'Sabanagrande'],
 ['HN', '11', 'Roat\xc3\xa1n'],
 ['HN', '08', 'Reitoca'],
 ['HN', '16', 'Quimist\xc3\xa1n'],
 ['HN', '09', 'Puerto Lempira'],
 ['HN', '16', 'Protecci\xc3\xb3n'],
 ['HN', '06', 'Potrerillos'],
 ['HN', '07', 'Potrerillos'],
 ['HN', '13', 'Piraera'],
 ['HN', '06', 'Pimienta'],
 ['HN', '16', 'Petoa'],
 ['HN', '02', 'Pespire'],
 ['HN', '07', 'Oropol\xc3\xad'],
 ['HN', '02', 'Orocuina'],
 ['HN', '08', 'Orica'],
 ['HN', '12', 'Opatoro'],
 ['HN', '06', 'Omoa'],
 ['HN', '18', 'Olanchito'],
 ['HN', '04', 'Ojos de Agua'],
 ['HN', '08', 'Ojojona'],
 ['HN', '16', 'Nuevo Celilac'],
 ['HN', '14', 'Nueva Ocotepeque'],
 ['HN', '08', 'Nueva Armenia'],
 ['HN', '05', 'Nueva Arcadia'],
 ['HN', '16', 'Naranjito'],
 ['HN', '02', 'Namasig\xc3\xbce'],
 ['HN', '17', 'Nacaome'],
 ['HN', '02', 'Morolica'],
 ['HN', '07', 'Morocel\xc3\xad'],
 ['HN', '18', 'Moraz\xc3\xa1n'],
 ['HN', '04', 'Minas de Oro'],
 ['HN', '12', 'Mercedes de Oriente'],
 ['HN', '14', 'Mercedes'],
 ['HN', '04', 'Me\xc3\xa1mbar'],
 ['HN', '10', 'Masaguara'],
 ['HN', '02', 'Marcovia'],
 ['HN', '12', 'Marcala'],
 ['HN', '08', 'Marale'],
 ['HN', '08', 'Maraita'],
 ['HN', '13', 'Mapulaca'],
 ['HN', '15', 'Manto'],
 ['HN', '15', 'Mangulile'],
 ['HN', '10', 'Magdalena'],
 ['HN', '16', 'Macuelizo'],
 ['HN', '14', 'Lucerna'],
 ['HN', '07', 'Liure'],
 ['HN', '03', 'Lim\xc3\xb3n'],
 ['HN', '08', 'Lepaterique'],
 ['HN', '13', 'Lepaera'],
 ['HN', '04', 'Lejaman\xc3\xad'],
 ['HN', '13', 'La Virtud'],
 ['HN', '08', 'La Venta'],
 ['HN', '12', 'Lauterique'],
 ['HN', '15', 'La Uni\xc3\xb3n'],
 ['HN', '13', 'La Uni\xc3\xb3n'],
 ['HN', '05', 'La Uni\xc3\xb3n'],
 ['HN', '04', 'La Trinidad'],
 ['HN', '13', 'Las Flores'],
 ['HN', '12', 'La Paz'],
 ['HN', '17', 'Langue'],
 ['HN', '01', 'La Masica'],
 ['HN', '04', 'Laman\xc3\xad'],
 ['HN', '04', 'La Libertad'],
 ['HN', '08', 'La Libertad'],
 ['HN', '14', 'La Labor'],
 ['HN', '05', 'La Jigua'],
 ['HN', '13', 'La Iguala'],
 ['HN', '15', 'La Guata'],
 ['HN', '10', 'La Esperanza'],
 ['HN', '14', 'La Encarnaci\xc3\xb3n'],
 ['HN', '01', 'La Ceiba'],
 ['HN', '13', 'La Campa'],
 ['HN', '15', 'Juticalpa'],
 ['HN', '01', 'Jutiapa'],
 ['HN', '11', 'Jos\xc3\xa9 Santos Guardiola'],
 ['HN', '18', 'Joc\xc3\xb3n'],
 ['HN', '10', 'Jes\xc3\xbas de Otoro'],
 ['HN', '15', 'Jano'],
 ['HN', '07', 'Jacaleapa'],
 ['HN', '03', 'Iriona'],
 ['HN', '10', 'Intibuc\xc3\xa1'],
 ['HN', '16', 'Ilama'],
 ['HN', '04', 'Humuya'],
 ['HN', '07', 'G\xc3\xbcinope'],
 ['HN', '15', 'Guayape'],
 ['HN', '15', 'Guarizama'],
 ['HN', '13', 'Guarita'],
 ['HN', '11', 'Guanaja'],
 ['HN', '13', 'Gualcince'],
 ['HN', '16', 'Gualala'],
 ['HN', '15', 'Gualaco'],
 ['HN', '12', 'Guajiquiro'],
 ['HN', '08', 'Guaimaca'],
 ['HN', '13', 'Gracias'],
 ['HN', '17', 'Goascor\xc3\xa1n'],
 ['HN', '14', 'Fraternidad'],
 ['HN', '05', 'Florida'],
 ['HN', '15', 'Esquipulas del Norte'],
 ['HN', '04', 'Esqu\xc3\xadas'],
 ['HN', '01', 'Esparta'],
 ['HN', '13', 'Erandique'],
 ['HN', '02', 'El Triunfo'],
 ['HN', '15', 'El Rosario'],
 ['HN', '04', 'El Rosario'],
 ['HN', '18', 'El Progreso'],
 ['HN', '01', 'El Porvenir'],
 ['HN', '08', 'El Porvenir'],
 ['HN', '05', 'El Para\xc3\xadso'],
 ['HN', '07', 'El Para\xc3\xadso'],
 ['HN', '16', 'El N\xc3\xadspero'],
 ['HN', '18', 'El Negrito'],
 ['HN', '02', 'El Corpus'],
 ['HN', '02', 'Duyure'],
 ['HN', '15', 'Dulce Nombre de Culm\xc3\xad'],
 ['HN', '05', 'Dulce Nombre'],
 ['HN', '14', 'Dolores Merend\xc3\xb3n'],
 ['HN', '05', 'Dolores'],
 ['HN', '10', 'Dolores'],
 ['HN', '07', 'Danl\xc3\xad'],
 ['HN', '08', 'Curar\xc3\xa9n'],
 ['HN', '05', 'Cucuyagua'],
 ['HN', '05', 'Corqu\xc3\xadn'],
 ['HN', '05', 'Cop\xc3\xa1n Ruinas'],
 ['HN', '15', 'Concordia'],
 ['HN', '02', 'Concepci\xc3\xb3n de Mar\xc3\xada'],
 ['HN', '16', 'Concepci\xc3\xb3n del Sur'],
 ['HN', '16', 'Concepci\xc3\xb3n del Norte'],
 ['HN', '05', 'Concepci\xc3\xb3n'],
 ['HN', '14', 'Concepci\xc3\xb3n'],
 ['HN', '10', 'Concepci\xc3\xb3n'],
 ['HN', '04', 'Comayagua'],
 ['HN', '10', 'Colomoncagua'],
 ['HN', '13', 'Cololaca'],
 ['HN', '02', 'Choluteca'],
 ['HN', '06', 'Choloma'],
 ['HN', '16', 'Chinda'],
 ['HN', '12', 'Chinacla'],
 ['HN', '08', 'Distrito Central'],
 ['HN', '16', 'Ceguaca'],
 ['HN', '08', 'Cedros'],
 ['HN', '15', 'Catacamas'],
 ['HN', '17', 'Caridad'],
 ['HN', '12', 'Cane'],
 ['HN', '13', 'Candelaria'],
 ['HN', '15', 'Campamento'],
 ['HN', '10', 'Camasca'],
 ['HN', '05', 'Caba\xc3\xb1as'],
 ['HN', '12', 'Caba\xc3\xb1as'],
 ['HN', '09', 'Brus Laguna'],
 ['HN', '14', 'Bel\xc3\xa9n Gualcho'],
 ['HN', '13', 'Bel\xc3\xa9n'],
 ['HN', '03', 'Balfate'],
 ['HN', '16', 'Azacualpa'],
 ['HN', '16', 'Atima'],
 ['HN', '18', 'Arenal'],
 ['HN', '17', 'Aramecina'],
 ['HN', '16', 'Arada'],
 ['HN', '02', 'Apacilagua'],
 ['HN', '17', 'Amapala'],
 ['HN', '08', 'Alubar\xc3\xa9n'],
 ['HN', '17', 'Alianza'],
 ['HN', '07', 'Alauca'],
 ['HN', '04', 'Ajuterique'],
 ['HN', '12', 'Aguanqueterique'],
 ['HN', '06', 'La Lima'],
 ['HN', '06', 'Puerto Cort\xc3\xa9s'],
 ['HN', '10', 'San Francisco de Opalaca'],
 ['HN', '13', 'San Marcos de Caiquin'],
 ['HN', '15', 'Patuca'],
 ['HN', '09', 'Juan Francisco Bulnes'],
 ['HN', '09', 'Villeda Morales'],
 ['HN', '09', 'Ahuas'],
 ['HN', '16', 'Nueva Frontera'],
 ['HN', '16', 'Las Vegas'],
 ['HN', '08', 'Vallecillo'],
 ['HN', '07', 'Trojes'],
 ['HN', '04', 'Las Lajas'],
 ['HN', '01', 'Arizona'],
 ['HN', '03', 'Bonito Oriental'],
 ['HN', '04', 'Taulab\xc3\xa9'],
 ['HR', '18', 'Zupanja Op\xc4\x87ina'],
 ['HR', '07', 'Zlatar-Bistrica Op\xc4\x87ina'],
 ['HR', '20', 'Zelina Op\xc4\x87ina'],
 ['HR', '20', 'Zapre\xc5\xa1ic Op\xc4\x87ina'],
 ['HR', '21', 'Zagreb Op\xc4\x87ina'],
 ['HR', '07', 'Zabok Op\xc4\x87ina'],
 ['HR', '18', 'Vukovar Op\xc4\x87ina'],
 ['HR', '15', 'Vrgorac Op\xc4\x87ina'],
 ['HR', '14', 'Vrginmost Op\xc4\x87ina'],
 ['HR', '12', 'Vrbovsko Op\xc4\x87ina'],
 ['HR', '20', 'Vrbovec Op\xc4\x87ina'],
 ['HR', '05', 'Vojnic Op\xc4\x87ina'],
 ['HR', '15', 'Vis Op\xc4\x87ina'],
 ['HR', '17', 'Virovitica Op\xc4\x87ina'],
 ['HR', '18', 'Vinkovci Op\xc4\x87ina'],
 ['HR', '20', 'Velika Gorica Op\xc4\x87ina'],
 ['HR', '16', 'Vara\xc5\xbedin Op\xc4\x87ina'],
 ['HR', '10', 'Valpovo Op\xc4\x87ina'],
 ['HR', '15', 'Trogir Op\xc4\x87ina'],
 ['HR', '15', 'Split Opcina'],
 ['HR', '05', 'Slunj Op\xc4\x87ina'],
 ['HR', '02', 'Slavonski Brod Op\xc4\x87ina'],
 ['HR', '11', 'Slavonska Po\xc5\xbeega Op\xc4\x87ina'],
 ['HR', '14', 'Sisak Op\xc4\x87ina'],
 ['HR', '15', 'Sinj Op\xc4\x87ina'],
 ['HR', '13', '\xc5\xa0ibenik Op\xc4\x87ina'],
 ['HR', '21', 'Sesvete Op\xc4\x87ina'],
 ['HR', '20', 'Samobor Op\xc4\x87ina'],
 ['HR', '04', 'Rovinj Op\xc4\x87ina'],
 ['HR', '12', 'Rijeka Op\xc4\x87ina'],
 ['HR', '04', 'Pula Op\xc4\x87ina'],
 ['HR', '04', 'Porec Op\xc4\x87ina'],
 ['HR', '17', 'Podravska Slatina Op\xc4\x87ina'],
 ['HR', '03', 'Ploce Opcina'],
 ['HR', '14', 'Petrinja Op\xc4\x87ina'],
 ['HR', '04', 'Pazin Op\xc4\x87ina'],
 ['HR', '11', 'Pakrac Op\xc4\x87ina'],
 ['HR', '05', 'Ozalj Op\xc4\x87ina'],
 ['HR', '10', 'Osijek Op\xc4\x87iina'],
 ['HR', '17', 'Orahovica Op\xc4\x87ina'],
 ['HR', '12', 'Opatija Op\xc4\x87ina'],
 ['HR', '15', 'Omi\xc5\xa1 Op\xc4\x87ina'],
 ['HR', '05', 'Ogulin Op\xc4\x87ina'],
 ['HR', '14', 'Novska Op\xc4\x87ina'],
 ['HR', '16', 'Novi Marof Op\xc4\x87ina'],
 ['HR', '02', 'Nova Gradi\xc5\xa1ka Op\xc4\x87ina'],
 ['HR', '10', 'Na\xc5\xa1ice Op\xc4\x87ina'],
 ['HR', '15', 'Makarska Op\xc4\x87ina'],
 ['HR', '16', 'Ludbreg Op\xc4\x87ina'],
 ['HR', '03', 'Lastovo Op\xc4\x87ina'],
 ['HR', '04', 'Labin Op\xc4\x87ina'],
 ['HR', '14', 'Kutina Op\xc4\x87ina'],
 ['HR', '12', 'Krk Op\xc4\x87ina'],
 ['HR', '06', 'Kri\xc5\xbeevci Op\xc4\x87ina'],
 ['HR', '07', 'Krapina Op\xc4\x87ina'],
 ['HR', '14', 'Kostajnica Op\xc4\x87ina'],
 ['HR', '03', 'Korcula Op\xc4\x87ina'],
 ['HR', '06', 'Koprivnica Op\xc4\x87ina'],
 ['HR', '07', 'Klanjec Op\xc4\x87ina'],
 ['HR', '05', 'Karlovac Op\xc4\x87ina'],
 ['HR', '20', 'Jastrebarsko Op\xc4\x87ina'],
 ['HR', '20', 'Ivanic-Grad Op\xc4\x87ina'],
 ['HR', '16', 'Ivanec Op\xc4\x87ina'],
 ['HR', '15', 'Imotski Op\xc4\x87ina'],
 ['HR', '15', 'Hvar Op\xc4\x87ina'],
 ['HR', '01', 'Grubi\xc5\xa1no Polje Op\xc4\x87ina'],
 ['HR', '14', 'Glina Op\xc4\x87ina'],
 ['HR', '01', 'Gare\xc5\xa1nica Op\xc4\x87ina'],
 ['HR', '14', 'Op\xc4\x87ina Dvor'],
 ['HR', '06', '\xc3\x90urdevac Op\xc4\x87ina'],
 ['HR', '20', 'Dugo Selo Op\xc4\x87ina'],
 ['HR', '05', 'Duga Resa Op\xc4\x87ina'],
 ['HR', '13', 'Drni\xc5\xa1 Op\xc4\x87ina'],
 ['HR', '10', 'Donji Miholjac Op\xc4\x87ina'],
 ['HR', '07', 'Donja Stubica Op\xc4\x87ina'],
 ['HR', '12', 'Op\xc4\x87ina Delnice'],
 ['HR', '01', 'Daruvar Op\xc4\x87ina'],
 ['HR', '10', '\xc3\x90akovo Op\xc4\x87ina'],
 ['HR', '12', 'Op\xc4\x87ina Crikvenica'],
 ['HR', '01', '\xc4\x8cazma Op\xc4\x87ina'],
 ['HR', '09', 'Cakovec Op\xc4\x87ina'],
 ['HR', '12', 'Cabar Op\xc4\x87ina'],
 ['HR', '04', 'Buzet Op\xc4\x87ina'],
 ['HR', '04', 'Buje Op\xc4\x87ina'],
 ['HR', '15', 'Brac Op\xc4\x87ina'],
 ['HR', '01', 'Bjelovar Op\xc4\x87ina'],
 ['HR', '19', 'Biograd Op\xc4\x87ina'],
 ['HR', '10', 'Beli Manastir Op\xc4\x87ina'],
 ['HR', '03', 'Dubrovnik'],
 ['HR', '20', 'Dubrava Op\xc4\x87ina'],
 ['HT', '10', 'Arrondissement de Valli\xc3\xa8res'],
 ['HT', '10', 'Arrondissement du Trou du Nord'],
 ['HT', '09', 'Arrondissement de Saint-Rapha\xc3\xabl'],
 ['HT', '06', 'Arrondissement de Saint-Michel'],
 ['HT', '06', 'Arrondissement de Saint-Marc'],
 ['HT', '03', 'Arrondissement de Saint-Louis du Nord'],
 ['HT', '12', 'Arrondissement de Port-Salut'],
 ['HT', '03', 'Arrondissement de Port-de-Paix'],
 ['HT', '11', 'Arrondissement de Port-au-Prince'],
 ['HT', '09', 'Arrondissement de Plaisance'],
 ['HT', '10', 'Arrondissement d\xe2\x80\x99 Ouanaminthe'],
 ['HT', '03', 'Arrondissement du M\xc3\xb4le Saint-Nicolas'],
 ['HT', '07', 'Arrondissement de Mirebalais'],
 ['HT', '14', 'Arrondissement de Mirago\xc3\xa2ne'],
 ['HT', '09', 'Arrondissement du Limb\xc3\xa9'],
 ['HT', '11', 'Arrondissement de L\xc3\xa9og\xc3\xa2ne'],
 ['HT', '07', 'Arrondissement de Lascahobas'],
 ['HT', '11', 'Arrondissement de La Gon\xc3\xa2ve'],
 ['HT', '14', 'Arrondissement du J\xc3\xa9r\xc3\xa9mie'],
 ['HT', '13', 'Arrondissement de Jacmel'],
 ['HT', '07', 'Arrondissement de Hinche'],
 ['HT', '06', 'Arrondissement de Gros Morne'],
 ['HT', '09', 'Arrondissement de la Grande Rivi\xc3\xa8re du Nord'],
 ['HT', '06', 'Arrondissement des Gona\xc3\xafves'],
 ['HT', '10', 'Arrondissement de Fort Libert\xc3\xa9'],
 ['HT', '06', 'Arrondissement de Dessalines'],
 ['HT', '11', 'Arrondissement de Croix des Bouquets'],
 ['HT', '12', 'Arrondissement des Coteaux'],
 ['HT', '14', 'Arrondissement de Corail'],
 ['HT', '12', 'Arrondissement des Chardonni\xc3\xa8res'],
 ['HT', '07', 'Arrondissement de Cerca La Source'],
 ['HT', '12', 'Arrondissement des Cayes'],
 ['HT', '09', 'Arrondissement du Cap-Ha\xc3\xaftien'],
 ['HT', '09', 'Arrondissement du Borgne'],
 ['HT', '13', 'Arrondissement de Belle-Anse'],
 ['HT', '13', 'Arrondissement de Bainet'],
 ['HT', '11', 'Arrondissement d\xe2\x80\x99 Arcahaie'],
 ['HT', '12', 'Arrondissement d\xe2\x80\x99 Aquin'],
 ['HT', '14', 'Arrondissement de l\xe2\x80\x99 Anse d\xe2\x80\x99Hainault'],
 ['HT', '15', 'Arrondissement de l\xe2\x80\x99 Anse-\xc3\xa0-Veau'],
 ['HT', '09', 'Arrondissement de l\xe2\x80\x99 Acul du Nord'],
 ['ID', '26', 'Kota Tebingtinggi'],
 ['ID', '26', 'Kabupaten Tapanuli Tengah'],
 ['ID', '00', 'Kabupaten Tapanuli Selatan'],
 ['ID', '26', 'Kabupaten Simalungun'],
 ['ID', '26', 'Kota Sibolga'],
 ['ID', '01', 'Kotamadya Sabang'],
 ['ID', '26', 'Kotamadya Pematangsiantar'],
 ['ID', '26', 'Kabupaten Nias'],
 ['ID', '26', 'Kota Medan'],
 ['ID', '01', 'Kabupaten Langkat'],
 ['ID', '26', 'Kabupaten Karo'],
 ['ID', '26', 'Kabupaten Deli Serdang'],
 ['ID', '01', 'Banda Aceh'],
 ['ID', '01', 'Kabupaten Asahan'],
 ['ID', '00', 'Kabupaten Aceh Utara'],
 ['ID', '01', 'Kabupaten Aceh Timur'],
 ['ID', '01', 'Kabupaten Aceh Tenggara'],
 ['ID', '00', 'Kabupaten Aceh Tengah'],
 ['ID', '01', 'Kabupaten Aceh Selatan'],
 ['ID', '01', 'Kabupaten Aceh Besar'],
 ['ID', '01', 'Kabupaten Aceh Barat'],
 ['ID', '10', 'Kotamadya Yogyakarta'],
 ['ID', '00', 'Kabupaten Yapen Waropen'],
 ['ID', '07', 'Kabupaten Wonosobo'],
 ['ID', '07', 'Kabupaten Wonogiri'],
 ['ID', '38', 'Kabupaten Wajo'],
 ['ID', '38', 'Kotamadya Makassar'],
 ['ID', '08', 'Kabupaten Tulungagung'],
 ['ID', '08', 'Kabupaten Tuban'],
 ['ID', '08', 'Kabupaten Trenggalek'],
 ['ID', '18', 'Kabupaten Timor Tengah Utara'],
 ['ID', '18', 'Kabupaten Timor Tengah Selatan'],
 ['ID', '07', 'Kabupaten Temanggung'],
 ['ID', '00', 'Kabupaten Teluk Cenderawasih'],
 ['ID', '07', 'Kotamadya Tegal'],
 ['ID', '07', 'Kabupaten Tegal'],
 ['ID', '30', 'Kota Tasikmalaya'],
 ['ID', '30', 'Kabupaten Tasikmalaya'],
 ['ID', '00', 'Kabupaten Tapin'],
 ['ID', '15', 'Kotamadya Bandarlampung'],
 ['ID', '00', 'Kabupaten Tanjung Jabung'],
 ['ID', '38', 'Kabupaten Tanatoraja'],
 ['ID', '00', 'Kabupaten Tanah Laut'],
 ['ID', '38', 'Kabupaten Takalar'],
 ['ID', '00', 'Kabupaten Tabalong'],
 ['ID', '07', 'Kotamadya Surakarta'],
 ['ID', '08', 'Kotamadya Surabaya'],
 ['ID', '00', 'Kabupaten Surabaya'],
 ['ID', '30', 'Kabupaten Sumedang'],
 ['ID', '18', 'Kabupaten Sumba Timur'],
 ['ID', '07', 'Kabupaten Sukoharjo'],
 ['ID', '30', 'Kotamadya Sukabumi'],
 ['ID', '30', 'Kabupaten Sukabumi'],
 ['ID', '00', 'Kabupaten Subang'],
 ['ID', '07', 'Kabupaten Sragen'],
 ['ID', '00', 'Kabupaten Sorong'],
 ['ID', '00', 'Kabupaten Sopeng'],
 ['ID', '24', 'Kotamadya Solok'],
 ['ID', '24', 'Kabupaten Solok'],
 ['ID', '38', 'Kabupaten Sinjai'],
 ['ID', '18', 'Kabupaten Sikka'],
 ['ID', '08', 'Kabupaten Sidoarjo'],
 ['ID', '00', 'Kabupaten Sidenreng-Rapang'],
 ['ID', '00', 'Kabupaten Seruyan'],
 ['ID', '33', 'Kabupaten Serang'],
 ['ID', '38', 'Kabupaten Selayar'],
 ['ID', '24', 'Kotamadya Sawahlunto'],
 ['ID', '00', 'Kabupaten Sarolangun'],
 ['ID', '31', 'Kepulauan Sangihe dan Talaud'],
 ['ID', '08', 'Kabupaten Sampang'],
 ['ID', '00', 'Kabupaten Rejang Lebong'],
 ['ID', '07', 'Kabupaten Purworejo'],
 ['ID', '30', 'Kabupaten Purwakarta'],
 ['ID', '08', 'Kabupaten Probolinggo'],
 ['ID', '21', 'Kabupaten Poso'],
 ['ID', '08', 'Kabupaten Ponorogo'],
 ['ID', '41', 'Kabupaten Polewali Mandar'],
 ['ID', '00', 'Kabupaten Pesisir Selatan'],
 ['ID', '07', 'Kabupaten Pemalang'],
 ['ID', '37', 'Kota Pekanbaru'],
 ['ID', '07', 'Kotamadya Pekalongan'],
 ['ID', '00', 'Kabupaten Pegunungan Jayawijaya'],
 ['ID', '24', 'Kotamadya Payakumbuh'],
 ['ID', '07', 'Kabupaten Pati'],
 ['ID', '08', 'Kotamadya Pasuruan'],
 ['ID', '08', 'Kabupaten Pasuruan'],
 ['ID', '38', 'Kotamadya Parepare'],
 ['ID', '00', 'Kabupaten Paniai'],
 ['ID', '00', 'Kotamadya Pangkalpinang'],
 ['ID', '38', 'Kabupaten Pangkajene dan Kepulauan'],
 ['ID', '00', 'Kabupaten Pandegelang'],
 ['ID', '08', 'Kabupaten Situbondo'],
 ['ID', '00', 'Kota administratip Palu'],
 ['ID', '00', 'Kotamadya Palangkaraya'],
 ['ID', '24', 'Kabupaten Padang Pariaman'],
 ['ID', '24', 'Kotamadya Padangpanjang'],
 ['ID', '24', 'Kotamadya Padang'],
 ['ID', '08', 'Kabupaten Pacitan'],
 ['ID', '08', 'Kabupaten Nganjuk'],
 ['ID', '00', 'Kabupaten Musi Hulu Rawas'],
 ['ID', '00', 'Kabupaten Musibanyuasin'],
 ['ID', '00', 'Kabupaten Murung Raya'],
 ['ID', '22', 'Kabupaten Muna'],
 ['ID', '00', 'Kabupaten Muaraenim'],
 ['ID', '08', 'Kotamadya Mojokerto'],
 ['ID', '08', 'Kabupaten Mojokerto'],
 ['ID', '00', 'Kabupaten Merangin'],
 ['ID', '17', 'Kotamadya Mataram'],
 ['ID', '38', 'Kabupaten Maros'],
 ['ID', '18', 'Kabupaten Manggarai'],
 ['ID', '31', 'Kotamadya Manado'],
 ['ID', '41', 'Kabupaten Mamuju'],
 ['ID', '29', 'Kabupaten Maluku Utara'],
 ['ID', '08', 'Kotamadya Malang'],
 ['ID', '08', 'Kabupaten Malang'],
 ['ID', '00', 'Kabupaten Majene'],
 ['ID', '30', 'Kabupaten Majalengka'],
 ['ID', '07', 'Kotamadya Magelang'],
 ['ID', '08', 'Kotamadya Madiun'],
 ['ID', '08', 'Kabupaten Madiun'],
 ['ID', '00', 'Kabupaten Lumajang'],
 ['ID', '17', 'Kabupaten Lombok Timur'],
 ['ID', '30', 'Kabupaten Kuningan'],
 ['ID', '07', 'Kabupaten Kudus'],
 ['ID', '22', 'Kabupaten Kolaka'],
 ['ID', '00', 'Kabupaten Klungkung'],
 ['ID', '07', 'Kabupaten Klaten'],
 ['ID', '00', 'Kabupaten Kerinci'],
 ['ID', '00', 'Kabupaten Kepulauan Riau'],
 ['ID', '22', 'Kota Administratip Kendari'],
 ['ID', '22', 'Kabupaten Kendari'],
 ['ID', '00', 'Kabupaten Katingan'],
 ['ID', '30', 'Kabupaten Karawang'],
 ['ID', '08', 'Kabupaten Jombang'],
 ['ID', '00', 'Kabupaten Jepara'],
 ['ID', '38', 'Kabupaten Jeneponto'],
 ['ID', '02', 'Kabupaten Jembrana'],
 ['ID', '08', 'Kotamadya Jember'],
 ['ID', '08', 'Kabupaten Jember'],
 ['ID', '00', 'Kabupaten Jayapura'],
 ['ID', '00', 'Kotamadya Jambi'],
 ['ID', '04', 'Kotamadya Jakarta Utara'],
 ['ID', '04', 'Kotamadya Jakarta Timur'],
 ['ID', '04', 'Kotamadya Jakarta Selatan'],
 ['ID', '04', 'Kotamadya Jakarta Pusat'],
 ['ID', '04', 'Kotamadya Jakarta Barat'],
 ['ID', '30', 'Kabupaten Indramayu'],
 ['ID', '00', 'Kabupaten Indragiri Hulu'],
 ['ID', '00', 'Kabupaten Indragiri Hilir'],
 ['ID', '00', 'Kabupaten Halmahera Tengah'],
 ['ID', '00', 'Kabupaten Gunung Mas'],
 ['ID', '00', 'Kabupaten Gunung Kidul'],
 ['ID', '07', 'Kabupaten Grobogan'],
 ['ID', '38', 'Kabupaten Gowa'],
 ['ID', '34', 'Kotamadya Gorontalo'],
 ['ID', '02', 'Kabupaten Gianyar'],
 ['ID', '21', 'Kabupaten Donggala'],
 ['ID', '02', 'Kotamayda Denpasar'],
 ['ID', '07', 'Kabupaten Demak'],
 ['ID', '30', 'Kotamadya Cirebon'],
 ['ID', '30', 'Kabupaten Cirebon'],
 ['ID', '00', 'Kota Administratip Cimahi'],
 ['ID', '22', 'Kabupaten Buton'],
 ['ID', '00', 'Kabupaten Buol Tolitoli'],
 ['ID', '38', 'Kabupaten Bulukumba'],
 ['ID', '02', 'Kabupaten Buleleng'],
 ['ID', '24', 'Kotamadya Bukittinggi'],
 ['ID', '07', 'Kabupaten Brebes'],
 ['ID', '00', 'Kabupaten Boyolali'],
 ['ID', '31', 'Kabupaten Bolaangmongondow'],
 ['ID', '08', 'Kabupaten Bojonegoro'],
 ['ID', '30', 'Kodya Bogor'],
 ['ID', '30', 'Kabupaten Bogor'],
 ['ID', '08', 'Kotamadya Blitar'],
 ['ID', '31', 'Kotamadya Bitung'],
 ['ID', '00', 'Kotamadya Binjai'],
 ['ID', '00', 'Daerah Berbahaya'],
 ['ID', '18', 'Kabupaten Belu'],
 ['ID', '30', 'Kabupaten Bekasi'],
 ['ID', '00', 'Kabupaten Batang'],
 ['ID', '38', 'Kabupaten Barru'],
 ['ID', '00', 'Kabupaten Barito Utara'],
 ['ID', '00', 'Kabupaten Barito Timur'],
 ['ID', '00', 'Kabupaten Barito Selatan'],
 ['ID', '00', 'Kabupaten Barito Kuala'],
 ['ID', '08', 'Kabupaten Banyuwangi'],
 ['ID', '07', 'Kabupaten Banyumas'],
 ['ID', '10', 'Kabupaten Bantul'],
 ['ID', '38', 'Kabupaten Bantaeng'],
 ['ID', '00', 'Kabupaten Banjarnegara'],
 ['ID', '00', 'Kotamadya Banjarmasin'],
 ['ID', '00', 'Kota Administratip Banjarbaru'],
 ['ID', '00', 'Kabupaten Banjar'],
 ['ID', '08', 'Kabupaten Bangkalan'],
 ['ID', '30', 'Kabupaten Bandung'],
 ['ID', '02', 'Kabupaten Badung'],
 ['ID', '28', 'Kota Ambon'],
 ['ID', '18', 'Kabupaten Alor'],
 ['ID', '24', 'Kabupaten Agam'],
 ['ID', '00', 'Kota Administratip Klaten'],
 ['ID', '18', 'Kotamadya Kupang'],
 ['ID', '18', 'Kabupaten Kupang'],
 ['ID', '07', 'Kabupaten Magelang'],
 ['ID', '07', 'Kabupaten Semarang'],
 ['ID', '07', 'Kotamadya Salatiga'],
 ['ID', '07', 'Kabupaten Sleman'],
 ['ID', '10', 'Kabupaten Kulonprogo'],
 ['ID', '07', 'Kabupaten Sragen'],
 ['ID', '07', 'Kabupaten Kebumen'],
 ['ID', '07', 'Kabupaten Banjarnegara'],
 ['ID', '07', 'Kabupaten Cilacap'],
 ['ID', '07', 'Kotip Purwokerto'],
 ['ID', '07', 'Kabupaten Purbalingga'],
 ['ID', '07', 'Kabupaten Wonosobo'],
 ['ID', '08', 'Kabupaten Magetan'],
 ['ID', '08', 'Kabupaten Ngawi'],
 ['ID', '07', 'Kabupaten Semarang'],
 ['ID', '30', 'Kotamadya Bandung'],
 ['ID', '07', 'Kabupaten Karanganyar'],
 ['ID', '30', 'Kabupaten Subang'],
 ['ID', '30', 'Kabupaten Cianjur'],
 ['ID', '30', 'Kotamadya Bekasi'],
 ['ID', '30', 'Kabupaten Karawang'],
 ['ID', '31', 'Kantor Bupati Minahasa Selatan'],
 ['ID', '31', 'Amurang'],
 ['ID', '01', 'Kabupaten Aceh Tamiang'],
 ['ID', '01', 'Kabupaten Aceh Barat Daya'],
 ['ID', '01', 'Kabupaten Nagan Raya'],
 ['ID', '01', 'Kabupaten Simeulue'],
 ['ID', '01', 'Kabupaten Aceh Jaya'],
 ['ID', '01', 'Kabupaten Bener Meriah'],
 ['ID', '01', 'Kabupaten Aceh Singkil'],
 ['ID', '26', 'Kabupaten Serdang Bedagai'],
 ['ID', '01', 'Kota Lhokseumawe'],
 ['ID', '37', 'Rokan Hulu'],
 ['ID', '37', 'Kampar'],
 ['ID', '26', 'Kabupaten Pakpak Bharat'],
 ['ID', '26', 'Kabupaten Tapanuli Utara'],
 ['ID', '01', 'Kabupaten Bireuen'],
 ['ID', '07', 'Kabupaten Demak'],
 ['ID', '07', 'Kabupaten Kendal'],
 ['ID', '07', 'Kabupaten Kudos'],
 ['ID', '30', 'Kotamadya Depok'],
 ['ID', '31', 'Kabupaten Minahasa'],
 ['ID', '33', 'Kotamadya Cilegon'],
 ['ID', '07', 'Kotamadya Tegal'],
 ['ID', '08', 'Kabupaten Gresik'],
 ['ID', '07', 'Kabupaten Pekalongan'],
 ['ID', '30', 'Kabupaten Bondowoso'],
 ['ID', '24', 'Kabupaten Mamuju'],
 ['ID', '31', 'Kabupaten Minahasa'],
 ['ID', '34', 'Kabupaten Gorontalo'],
 ['ID', '38', 'Kabupaten Luwu'],
 ['ID', '21', 'Kabupaten Buoltolitoli'],
 ['ID', '22', 'Kota Administratip Baubau'],
 ['ID', '21', 'Kabupaten Banggai'],
 ['ID', '38', 'Kabupaten Soppeng'],
 ['ID', '02', 'Kabupaten Klungkung'],
 ['ID', '17', 'Kebupatan Lombok Tengah'],
 ['ID', '02', 'Kabupaten Karangasem'],
 ['ID', '07', 'benteng van der wijck'],
 ['ID', '15', 'Kabupaten Lampung Selatan'],
 ['ID', '30', 'West Bandung Regency'],
 ['ID', '36', 'Kabupaten Kaimana'],
 ['ID', '36', 'Kabupaten Teluk Wondama'],
 ['ID', '36', 'Kabupaten Sorong Selatan'],
 ['ID', '28', 'Kabupaten Halmahera Selatan'],
 ['ID', '07', 'Kulon Progo'],
 ['ID', '', 'Kota Ternate'],
 ['ID', '36', 'Kota Jayapura'],
 ['ID', '36', 'Nabire'],
 ['ID', '36', 'Pegununganbintang'],
 ['ID', '38', 'Mamasa'],
 ['ID', '36', 'Kabupaten Pegunungan Bintang'],
 ['ID', '32', 'Kota Pagaralam'],
 ['ID', '32', 'Kota Prabumulih'],
 ['ID', '08', 'Kabupaten Lamongan'],
 ['ID', '01', 'Kota Langsa'],
 ['ID', '01', 'Kabupaten Gayo Lues'],
 ['ID', '01', 'Pidie'],
 ['ID', '26', 'Nias Selatan'],
 ['IE', 'L', 'Wicklow'],
 ['IE', 'L', 'Loch Garman'],
 ['IE', 'L', 'An Iarmh\xc3\xad'],
 ['IE', 'M', 'Waterford'],
 ['IE', '00', 'Tipperary South Riding'],
 ['IE', '00', 'Tipperary North Riding'],
 ['IE', 'C', 'Sligo'],
 ['IE', 'C', 'Roscommon'],
 ['IE', 'L', 'U\xc3\xadbh Fhail\xc3\xad'],
 ['IE', 'U', 'County Monaghan'],
 ['IE', 'L', 'An Mh\xc3\xad'],
 ['IE', 'C', 'Maigh Eo'],
 ['IE', 'L', 'L\xc3\xba'],
 ['IE', 'L', 'An Longfort'],
 ['IE', 'M', 'County Limerick'],
 ['IE', 'C', 'County Leitrim'],
 ['IE', 'L', 'Laois'],
 ['IE', 'L', 'Kilkenny'],
 ['IE', 'L', 'Kildare'],
 ['IE', 'M', 'Ciarra\xc3\xad'],
 ['IE', 'C', 'County Galway'],
 ['IE', 'U', 'County Donegal'],
 ['IE', 'M', 'County Cork'],
 ['IE', 'M', 'An Cl\xc3\xa1r'],
 ['IE', 'U', 'An Cabh\xc3\xa1n'],
 ['IE', 'L', 'County Carlow'],
 ['IE', '00', 'Fingal County'],
 ['IE', 'L', 'D\xc3\xban Laoghaire-Rathdown'],
 ['IE', '00', 'South Dublin'],
 ['IE', 'M', 'Waterford City'],
 ['IE', 'M', 'Limerick City'],
 ['IE', 'C', 'Galway City'],
 ['IE', 'L', 'Dublin City'],
 ['IE', '', 'Cork City'],
 ['IL', '04', 'Nefat H\xcc\xb1efa'],
 ['IL', '01', 'Nefat Ashqelon'],
 ['IL', '03', 'Nefat \xe2\x80\x98Akko'],
 ['IL', '01', 'Gaza'],
 ['IN', '20', 'Zunheboto'],
 ['IN', '00', 'Yanam'],
 ['IN', '20', 'Wokha'],
 ['IN', '26', 'West Tripura'],
 ['IN', '30', 'West Siang'],
 ['IN', '35', 'West Nim\xc4\x81r'],
 ['IN', '30', 'West Kameng'],
 ['IN', '02', 'West God\xc4\x81vari'],
 ['IN', '00', 'West District'],
 ['IN', '28', 'West Din\xc4\x81jpur'],
 ['IN', '02', 'Warangal'],
 ['IN', '02', 'Vish\xc4\x81khapatnam'],
 ['IN', '35', 'Vidisha'],
 ['IN', '36', 'V\xc4\x81r\xc4\x81nasi'],
 ['IN', '09', 'Vals\xc4\x81d'],
 ['IN', '34', 'Vaish\xc4\x81li'],
 ['IN', '09', 'Vadodara'],
 ['IN', '39', 'Uttark\xc4\x81shi'],
 ['IN', '19', 'Uttar Kannad'],
 ['IN', '30', 'Upper Subansiri'],
 ['IN', '36', 'Unn\xc4\x81o'],
 ['IN', '35', 'Ujjain'],
 ['IN', '12', 'Udhampur'],
 ['IN', '24', 'Udaipur'],
 ['IN', '28', 'Twenty-four Parganas'],
 ['IN', '19', 'Tumkur'],
 ['IN', '20', 'Tuensang District'],
 ['IN', '13', 'Trivandrum'],
 ['IN', '24', 'Tonk'],
 ['IN', '25', 'Tirunelveli'],
 ['IN', '25', 'Tiruchchir\xc4\x81ppalli'],
 ['IN', '30', 'Tir\xc4\x81p'],
 ['IN', '35', 'T\xc4\xabkamgarh'],
 ['IN', '09', 'The D\xc4\x81ngs'],
 ['IN', '25', 'Thanjavur'],
 ['IN', '39', 'Tehri-Garhw\xc4\x81l'],
 ['IN', '37', 'Surguja'],
 ['IN', '09', 'Surendranagar'],
 ['IN', '09', 'S\xc5\xabrat'],
 ['IN', '21', 'Sundargarh'],
 ['IN', '36', 'Sult\xc4\x81npur'],
 ['IN', '12', 'Sr\xc4\xabnagar'],
 ['IN', '02', 'Sr\xc4\xabk\xc4\x81kulam'],
 ['IN', '26', 'South Tripura'],
 ['IN', '00', 'South District'],
 ['IN', '25', 'South Arcot'],
 ['IN', '10', 'Son\xc4\xabpat'],
 ['IN', '11', 'Solan'],
 ['IN', '34', 'Siw\xc4\x81n'],
 ['IN', '36', 'S\xc4\xabt\xc4\x81pur'],
 ['IN', '34', 'S\xc4\xabt\xc4\x81marhi'],
 ['IN', '10', 'Sirsa'],
 ['IN', '24', 'Sirohi'],
 ['IN', '11', 'Sirmaur'],
 ['IN', '38', 'Pashchim Singhbh\xc5\xabm'],
 ['IN', '11', 'Shimla'],
 ['IN', '24', 'S\xc4\xabkar'],
 ['IN', '35', 'Sidhi'],
 ['IN', '03', 'Sibs\xc4\x81gar'],
 ['IN', '35', 'Shivpur\xc4\xab'],
 ['IN', '19', 'Shimoga'],
 ['IN', '35', 'Sh\xc4\x81j\xc4\x81pur'],
 ['IN', '36', 'Sh\xc4\x81hjah\xc4\x81npur'],
 ['IN', '35', 'Shahdol'],
 ['IN', '35', 'Seon\xc4\xab'],
 ['IN', '35', 'Sehore'],
 ['IN', '24', 'Saw\xc4\x81i M\xc4\x81dhopur'],
 ['IN', '35', 'Satna'],
 ['IN', '34', 'S\xc4\x81ran'],
 ['IN', '38', 'Santh\xc4\x81l Pargana'],
 ['IN', '23', 'Sangrur'],
 ['IN', '21', 'Sambalpur'],
 ['IN', '34', 'Samast\xc4\xabpur'],
 ['IN', '25', 'Salem'],
 ['IN', '34', 'Saharsa'],
 ['IN', '36', 'Sah\xc4\x81ranpur'],
 ['IN', '35', 'S\xc4\x81gar'],
 ['IN', '09', 'Sabar K\xc4\x81ntha'],
 ['IN', '23', 'Rupnagar'],
 ['IN', '34', 'Roht\xc4\x81s'],
 ['IN', '10', 'Rohtak'],
 ['IN', '35', 'Rewa'],
 ['IN', '35', 'Ratl\xc4\x81m'],
 ['IN', '38', 'R\xc4\x81nch\xc4\xab'],
 ['IN', '36', 'R\xc4\x81mpur'],
 ['IN', '25', 'R\xc4\x81man\xc4\x81thapuram'],
 ['IN', '37', 'R\xc4\x81j N\xc4\x81ndgaon'],
 ['IN', '09', 'R\xc4\x81jkot'],
 ['IN', '35', 'R\xc4\x81jgarh'],
 ['IN', '12', 'R\xc4\x81jauri'],
 ['IN', '35', 'Raisen'],
 ['IN', '37', 'Raipur'],
 ['IN', '37', 'Raigarh'],
 ['IN', '19', 'Raichur'],
 ['IN', '36', 'R\xc4\x81e Bareli'],
 ['IN', '13', 'Quilon'],
 ['IN', '28', 'Puruliya'],
 ['IN', '34', 'Purnia'],
 ['IN', '34', 'P\xc5\xabrba Champ\xc4\x81ran'],
 ['IN', '25', 'Pudukkottai'],
 ['IN', '36', 'Prat\xc4\x81pgarh'],
 ['IN', '02', 'Prakasam'],
 ['IN', '22', 'Puducherry'],
 ['IN', '39', 'Pithor\xc4\x81garh'],
 ['IN', '36', 'P\xc4\xabl\xc4\xabbh\xc4\xabt'],
 ['IN', '21', 'Phulab\xc4\x81ni'],
 ['IN', '20', 'Phek'],
 ['IN', '34', 'Patna'],
 ['IN', '23', 'Patiala'],
 ['IN', '34', 'Pashchim Champ\xc4\x81ran'],
 ['IN', '35', 'Panna'],
 ['IN', '24', 'P\xc4\x81li'],
 ['IN', '13', 'P\xc4\x81lgh\xc4\x81t'],
 ['IN', '38', 'Pal\xc4\x81mu'],
 ['IN', '03', 'Nowgong'],
 ['IN', '26', 'North Tripura'],
 ['IN', '00', 'North District'],
 ['IN', '03', 'Dima Hasao District'],
 ['IN', '25', 'North Arcot'],
 ['IN', '02', 'Niz\xc4\x81m\xc4\x81b\xc4\x81d'],
 ['IN', '25', 'Nilgiri'],
 ['IN', '01', 'Nicobar'],
 ['IN', '02', 'Nellore'],
 ['IN', '34', 'Naw\xc4\x81da'],
 ['IN', '35', 'Narsimhapur'],
 ['IN', '02', 'Nalgonda'],
 ['IN', '34', 'N\xc4\x81landa'],
 ['IN', '39', 'Naini T\xc4\x81l'],
 ['IN', '24', 'N\xc4\x81gaur'],
 ['IN', '28', 'Nadia'],
 ['IN', '19', 'Mysore'],
 ['IN', '34', 'Muzaffarpur'],
 ['IN', '36', 'Muzaffarnagar'],
 ['IN', '34', 'Munger'],
 ['IN', '35', 'Morena'],
 ['IN', '36', 'Mor\xc4\x81d\xc4\x81b\xc4\x81d'],
 ['IN', '20', 'Mon'],
 ['IN', '20', 'Mon'],
 ['IN', '20', 'Mokokch\xc5\xabng'],
 ['IN', '36', 'Mirz\xc4\x81pur'],
 ['IN', '36', 'Meerut'],
 ['IN', '28', 'Medin\xc4\xabpur'],
 ['IN', '02', 'Medak'],
 ['IN', '21', 'May\xc5\xabrbhanj'],
 ['IN', '36', 'Mathura'],
 ['IN', '17', 'Manipur West'],
 ['IN', '17', 'Manipur South'],
 ['IN', '17', 'Manipur North'],
 ['IN', '17', 'Manipur East'],
 ['IN', '17', 'Manipur Central'],
 ['IN', '19', 'Mandya'],
 ['IN', '35', 'Mandsaur'],
 ['IN', '35', 'Mandla'],
 ['IN', '11', 'Mandi'],
 ['IN', '28', 'M\xc4\x81ldah'],
 ['IN', '13', 'Malappuram'],
 ['IN', '36', 'Mainpuri'],
 ['IN', '09', 'Mahes\xc4\x81na'],
 ['IN', '10', 'Mahendragarh'],
 ['IN', '13', 'Mahe'],
 ['IN', '02', 'Mahb\xc5\xabbnagar'],
 ['IN', '25', 'Madurai'],
 ['IN', '25', 'Madras'],
 ['IN', '34', 'Madhubani'],
 ['IN', '23', 'Ludhiana'],
 ['IN', '36', 'Lucknow District'],
 ['IN', '30', 'Lower Subansiri'],
 ['IN', '30', 'Lohit District'],
 ['IN', '36', 'Lalitpur'],
 ['IN', '03', 'Lakhimpur'],
 ['IN', '11', 'L\xc4\x81hul and Spiti'],
 ['IN', '12', 'Lad\xc4\x81kh'],
 ['IN', '10', 'Kurukshetra'],
 ['IN', '02', 'Kurnool'],
 ['IN', '11', 'Kulu'],
 ['IN', '02', 'Krishna'],
 ['IN', '13', 'Kozhikode'],
 ['IN', '13', 'Kottayam'],
 ['IN', '24', 'Kota'],
 ['IN', '21', 'Koraput'],
 ['IN', '19', 'Kolar'],
 ['IN', '20', 'Koh\xc4\xabma'],
 ['IN', '19', 'Kodagu'],
 ['IN', '28', 'Koch Bih\xc4\x81r'],
 ['IN', '11', 'Kinnaur'],
 ['IN', '36', 'Kheri'],
 ['IN', '09', 'Kheda'],
 ['IN', '18', 'East Kh\xc4\x81si Hills'],
 ['IN', '02', 'Khammam'],
 ['IN', '21', 'Keonjhar'],
 ['IN', '12', 'Kathua'],
 ['IN', '34', 'Kathih\xc4\x81r'],
 ['IN', '10', 'Karn\xc4\x81l'],
 ['IN', '02', 'Kar\xc4\xabmnagar'],
 ['IN', '03', 'K\xc4\x81rbi \xc4\x80nglong'],
 ['IN', '22', 'K\xc4\x81raik\xc4\x81l'],
 ['IN', '23', 'Kapurthala'],
 ['IN', '36', 'K\xc4\x81npur'],
 ['IN', '25', 'Kanniyakumari'],
 ['IN', '11', 'K\xc4\x81ngra'],
 ['IN', '03', 'K\xc4\x81mr\xc5\xabp'],
 ['IN', '21', 'K\xc4\x81l\xc4\x81handi'],
 ['IN', '09', 'Kachchh'],
 ['IN', '09', 'J\xc5\xabn\xc4\x81gadh'],
 ['IN', '23', 'Jalandhar'],
 ['IN', '24', 'Jodhpur'],
 ['IN', '10', 'J\xc4\xabnd'],
 ['IN', '24', 'Jhunjhun\xc5\xabn'],
 ['IN', '35', 'Jh\xc4\x81nsi'],
 ['IN', '24', 'Jh\xc4\x81l\xc4\x81w\xc4\x81r'],
 ['IN', '35', 'Jh\xc4\x81bua'],
 ['IN', '36', 'Jaunpur'],
 ['IN', '09', 'J\xc4\x81mnagar'],
 ['IN', '12', 'Jammu'],
 ['IN', '28', 'Jalp\xc4\x81iguri'],
 ['IN', '24', 'Jalore'],
 ['IN', '36', 'J\xc4\x81laun'],
 ['IN', '24', 'Jaisalmer'],
 ['IN', '24', 'Jaipur'],
 ['IN', '18', 'Jaintia Hills'],
 ['IN', '35', 'Jabalpur'],
 ['IN', '35', 'Indore'],
 ['IN', '13', 'Idukki'],
 ['IN', '02', 'Hyder\xc4\x81b\xc4\x81d'],
 ['IN', '28', 'Hugli'],
 ['IN', '23', 'Hoshiarpur'],
 ['IN', '35', 'Hoshang\xc4\x81b\xc4\x81d'],
 ['IN', '10', 'His\xc4\x81r'],
 ['IN', '38', 'Haz\xc4\x81r\xc4\xabb\xc4\x81g'],
 ['IN', '19', 'Hassan'],
 ['IN', '36', 'Hardoi'],
 ['IN', '28', 'H\xc4\x81ora'],
 ['IN', '11', 'Ham\xc4\xabrpur'],
 ['IN', '36', 'Ham\xc4\xabrpur'],
 ['IN', '35', 'Gwalior'],
 ['IN', '10', 'Gurgaon'],
 ['IN', '23', 'Gurdaspur'],
 ['IN', '02', 'Gunt\xc5\xabr'],
 ['IN', '35', 'Guna'],
 ['IN', '19', 'Gulbarga'],
 ['IN', '36', 'Gorakhpur'],
 ['IN', '34', 'Gop\xc4\x81lganj'],
 ['IN', '36', 'Gonda'],
 ['IN', '03', 'Go\xc4\x81lp\xc4\x81ra'],
 ['IN', '38', 'Gir\xc4\xabd\xc4\xabh'],
 ['IN', '36', 'Gh\xc4\x81z\xc4\xabpur'],
 ['IN', '36', 'Gh\xc4\x81zi\xc4\x81b\xc4\x81d'],
 ['IN', '34', 'Gay\xc4\x81'],
 ['IN', '18', 'East G\xc4\x81ro Hills'],
 ['IN', '39', 'Garhw\xc4\x81l'],
 ['IN', '21', 'Ganj\xc4\x81m'],
 ['IN', '24', 'Gang\xc4\x81nagar'],
 ['IN', '09', 'G\xc4\x81ndh\xc4\xabnagar'],
 ['IN', '23', 'Ferozepur'],
 ['IN', '36', 'Fatehpur'],
 ['IN', '36', 'Farrukh\xc4\x81b\xc4\x81d'],
 ['IN', '23', 'Faridkot'],
 ['IN', '36', 'Faiz\xc4\x81b\xc4\x81d'],
 ['IN', '36', 'Et\xc4\x81wah'],
 ['IN', '36', 'Etah'],
 ['IN', '13', 'Ern\xc4\x81kulam'],
 ['IN', '30', 'East Siang'],
 ['IN', '35', 'East Nim\xc4\x81r'],
 ['IN', '30', 'East Kameng'],
 ['IN', '02', 'East God\xc4\x81vari'],
 ['IN', '00', 'East District'],
 ['IN', '37', 'Durg'],
 ['IN', '24', 'D\xc5\xabngarpur'],
 ['IN', '09', 'Diu'],
 ['IN', '03', 'Dibrugarh'],
 ['IN', '30', 'Dib\xc4\x81ng Valley'],
 ['IN', '21', 'Dhenk\xc4\x81n\xc4\x81l'],
 ['IN', '19', 'Dharwad'],
 ['IN', '25', 'Dharmapuri'],
 ['IN', '35', 'Dh\xc4\x81r'],
 ['IN', '38', 'Dh\xc4\x81nb\xc4\x81d'],
 ['IN', '35', 'Dew\xc4\x81s'],
 ['IN', '36', 'Deoria'],
 ['IN', '39', 'Dehra D\xc5\xabn'],
 ['IN', '35', 'Datia'],
 ['IN', '03', 'Darrang'],
 ['IN', '28', 'Darjiling'],
 ['IN', '34', 'Darbhanga'],
 ['IN', '35', 'Damoh'],
 ['IN', '32', 'Dam\xc4\x81n District'],
 ['IN', '19', 'Dakshin Kannad'],
 ['IN', '21', 'Cuttack'],
 ['IN', '02', 'Cuddapah'],
 ['IN', '25', 'Coimbatore'],
 ['IN', '24', 'Ch\xc5\xabru'],
 ['IN', '02', 'Chittoor'],
 ['IN', '24', 'Chittaurgarh'],
 ['IN', '19', 'Chitradurga'],
 ['IN', '19', 'Chikmagalur'],
 ['IN', '35', 'Chhindw\xc4\x81ra'],
 ['IN', '35', 'Chhatarpur'],
 ['IN', '25', 'Chengalpattu'],
 ['IN', '39', 'Chamoli'],
 ['IN', '11', 'Chamba'],
 ['IN', '13', 'Kannur'],
 ['IN', '28', 'Calcutta'],
 ['IN', '03', 'C\xc4\x81ch\xc4\x81r'],
 ['IN', '24', 'B\xc5\xabndi'],
 ['IN', '36', 'Bulandshahr'],
 ['IN', '36', 'Budaun'],
 ['IN', '28', 'B\xc4\xabrbh\xc5\xabm'],
 ['IN', '11', 'Bil\xc4\x81spur'],
 ['IN', '37', 'Bil\xc4\x81spur'],
 ['IN', '24', 'B\xc4\xabk\xc4\x81ner'],
 ['IN', '36', 'Bijnor'],
 ['IN', '19', 'Bij\xc4\x81pur'],
 ['IN', '19', 'B\xc4\xabdar'],
 ['IN', '35', 'Bhop\xc4\x81l'],
 ['IN', '34', 'Bhojpur'],
 ['IN', '10', 'Bhiwani'],
 ['IN', '35', 'Bhind'],
 ['IN', '24', 'Bh\xc4\xablw\xc4\x81ra'],
 ['IN', '09', 'Bh\xc4\x81vnagar'],
 ['IN', '23', 'Bathinda'],
 ['IN', '09', 'Bhar\xc5\xabch'],
 ['IN', '24', 'Bharatpur'],
 ['IN', '34', 'Bh\xc4\x81galpur'],
 ['IN', '35', 'Bet\xc5\xabl'],
 ['IN', '19', 'Bellary'],
 ['IN', '19', 'Belgaum'],
 ['IN', '34', 'Begusar\xc4\x81i'],
 ['IN', '36', 'Basti'],
 ['IN', '37', 'Bastar'],
 ['IN', '24', 'B\xc4\x81rmer'],
 ['IN', '36', 'Bareilly'],
 ['IN', '28', 'Barddham\xc4\x81n'],
 ['IN', '12', 'B\xc4\x81ram\xc5\xabla'],
 ['IN', '36', 'B\xc4\x81ra Banki'],
 ['IN', '24', 'B\xc4\x81nsw\xc4\x81ra'],
 ['IN', '28', 'B\xc4\x81nkur\xc4\x81'],
 ['IN', '19', 'Bangalore Urban'],
 ['IN', '19', 'Bangalore Rural'],
 ['IN', '36', 'B\xc4\x81nda'],
 ['IN', '09', 'Ban\xc4\x81s K\xc4\x81ntha'],
 ['IN', '34', 'Ballia'],
 ['IN', '21', 'B\xc4\x81leshwar'],
 ['IN', '21', 'Bal\xc4\x81ng\xc4\xabr'],
 ['IN', '35', 'B\xc4\x81l\xc4\x81gh\xc4\x81t'],
 ['IN', '36', 'Bahraich'],
 ['IN', '36', '\xc4\x80zamgarh'],
 ['IN', '34', 'Aurang\xc4\x81b\xc4\x81d'],
 ['IN', '25', 'Anna'],
 ['IN', '01', 'Andaman'],
 ['IN', '12', 'Anantn\xc4\x81g'],
 ['IN', '02', 'Anantapur'],
 ['IN', '23', 'Amritsar'],
 ['IN', '32', 'Amreli'],
 ['IN', '10', 'Amb\xc4\x81la'],
 ['IN', '24', 'Alwar'],
 ['IN', '39', 'Almora'],
 ['IN', '13', 'Alappuzha'],
 ['IN', '36', 'Allah\xc4\x81b\xc4\x81d'],
 ['IN', '36', 'Al\xc4\xabgarh'],
 ['IN', '24', 'Ajmer'],
 ['IN', '09', 'Ahmad\xc4\x81b\xc4\x81d'],
 ['IN', '36', '\xc4\x80gra'],
 ['IN', '02', '\xc4\x80dil\xc4\x81b\xc4\x81d'],
 ['IN', '25', 'Namakkal'],
 ['IN', '13', 'Wayanad'],
 ['IN', '13', 'Palakkad district'],
 ['IN', '36', 'Shrawasti'],
 ['IN', '36', 'Siddharthangar'],
 ['IN', '36', 'Kushinagar'],
 ['IN', '36', 'Kushinag'],
 ['IN', '34', 'Supaul'],
 ['IN', '34', 'Madhepura'],
 ['IN', '34', 'Araria'],
 ['IN', '31', 'Aizawl'],
 ['IN', '31', 'Lunglei'],
 ['IN', '02', 'Rangareddi'],
 ['IN', '02', 'Viziagram'],
 ['IN', '25', 'Thoothukudi'],
 ['IN', '25', 'Perambalur'],
 ['IN', '25', 'Nagapattinam'],
 ['IN', '03', 'Barpeta'],
 ['IN', '03', 'Bongaigaon'],
 ['IN', '03', 'Dhemaji'],
 ['IN', '03', 'Dhuburi'],
 ['IN', '03', 'Golaghat'],
 ['IN', '03', 'Hailakandi'],
 ['IN', '03', 'Jorhat'],
 ['IN', '03', 'Karimganj'],
 ['IN', '03', 'Kokrajhar'],
 ['IN', '03', 'Nalbari'],
 ['IN', '03', 'Tinsukia'],
 ['IN', '02', 'Vizianagaram'],
 ['IN', '35', 'Korba'],
 ['IN', '35', 'Dhamtari'],
 ['IN', '35', 'Dantewada'],
 ['IN', '35', 'Kanker'],
 ['IN', '34', 'Simdega'],
 ['IN', '34', 'Godda'],
 ['IN', '34', 'Dumka'],
 ['IN', '34', 'Latehar'],
 ['IN', '34', 'Lohardaga'],
 ['IN', '35', 'Dindori'],
 ['IN', '21', 'Jharsuguda'],
 ['IN', '21', 'Kandhamal'],
 ['IN', '21', 'Malkangiri'],
 ['IN', '21', 'Rayagada'],
 ['IN', '09', 'Anand'],
 ['IN', '34', 'Jehanabad'],
 ['IN', '34', 'Buxar'],
 ['IN', '35', 'Janjgir-Champa'],
 ['IN', '09', 'Dahod'],
 ['IN', '09', 'Godhra'],
 ['IN', '34', 'Jamtara'],
 ['IN', '34', 'Katihar'],
 ['IN', '35', 'Kawardha'],
 ['IN', '34', 'Khagaria'],
 ['IN', '34', 'Kishanganj'],
 ['IN', '19', 'Koppal'],
 ['IN', '34', 'Lakhisarai'],
 ['IN', '35', 'Mahasamund'],
 ['IN', '28', 'Murshidabad'],
 ['IN', '09', 'Patan'],
 ['IN', '34', 'Sheohar'],
 ['IN', '35', 'Sheopur'],
 ['IN', '25', 'Thiruvallur'],
 ['IN', '21', 'Bhadrak'],
 ['IN', '21', 'Jagatsinghpur'],
 ['IN', '21', 'Kendrapara'],
 ['IN', '21', 'Khordha'],
 ['IN', '21', 'Puri'],
 ['IN', '25', 'Chennai'],
 ['IN', '25', 'Vellore'],
 ['IN', '25', 'Tiruvannamalai'],
 ['IN', '25', 'Kancheepuram'],
 ['IN', '25', 'Villupuram'],
 ['IN', '25', 'Cuddalore'],
 ['IN', '25', 'Sivaganga'],
 ['IN', '25', 'Theni'],
 ['IN', '25', 'Virudhunagar'],
 ['IN', '25', 'Thiruvarur'],
 ['IN', '19', 'Davanagere'],
 ['IN', '24', 'Dausa'],
 ['IN', '24', 'Dhaulpur'],
 ['IN', '24', 'Karauli'],
 ['IN', '24', 'Baran'],
 ['IN', '24', 'Rajsamand'],
 ['IN', '11', 'Una'],
 ['IN', '38', 'Purba Singhbhum'],
 ['IN', '38', 'Bokaro'],
 ['IN', '38', 'Gumla'],
 ['IN', '18', 'Ri-Bhoi'],
 ['IN', '18', 'West Khasi Hills'],
 ['IN', '39', 'Bageshwar'],
 ['IN', '39', 'Pauri Garhwal'],
 ['IN', '39', 'Champawat'],
 ['IN', '39', 'Udham Singh Nagar'],
 ['IN', '35', 'Koriya'],
 ['IN', '35', 'Jashpur'],
 ['IN', '35', 'Raj Nandgaon'],
 ['IN', '34', 'Saraikela'],
 ['IN', '34', 'Sahibganj'],
 ['IN', '34', 'Pakur'],
 ['IN', '34', 'Garhwa'],
 ['IN', '34', 'Sheikhpura'],
 ['IN', '24', 'Hanumangarh'],
 ['IN', '36', 'Ambedkar Nagar'],
 ['IN', '36', 'Auraiya'],
 ['IN', '36', 'Balrampur'],
 ['IN', '36', 'Kanpur Dehat'],
 ['IN', '36', 'Lakhimpur Kheri'],
 ['IN', '36', 'Maharajganj'],
 ['IN', '36', 'Mau'],
 ['IN', '36', 'Sant Ravi Das Nagar'],
 ['IN', '13', 'Pattanamtitta'],
 ['IN', '25', 'Tirunelveli Kattabo'],
 ['IN', '36', 'Hathras'],
 ['IN', '36', 'Firozabad'],
 ['IN', '36', 'Kannauj'],
 ['IN', '13', 'Kollam'],
 ['IN', '13', 'Thiruvananthapuram'],
 ['IN', '31', 'Mamit'],
 ['IN', '19', 'Haveri'],
 ['IN', '19', 'Gadag'],
 ['IN', '23', 'Fatehgarh Sahib'],
 ['IN', '23', 'Muktsar'],
 ['IN', '19', 'Davanagere District'],
 ['IN', '16', 'Amravati Division'],
 ['IN', '16', 'Aurangabad Division'],
 ['IN', '16', 'Konkan Division'],
 ['IN', '16', 'Nagpur Division'],
 ['IN', '16', 'Nashik Division'],
 ['IN', '16', 'Satara Division'],
 ['IN', '16', 'Pune Division'],
 ['IN', '13', 'Thrissur District'],
 ['IN', '25', 'Ariyalur'],
 ['IN', '25', 'Krishnagiri'],
 ['IN', '25', 'Dindigul'],
 ['IN', '25', 'Erode'],
 ['IN', '25', 'Karur'],
 ['IN', '19', 'Chikkaballapur'],
 ['IN', '19', 'Bagalkot'],
 ['IN', '19', 'Chamrajnagar'],
 ['IN', '19', 'Udupi'],
 ['IN', '19', 'Ramanagara'],
 ['IN', '19', 'Yadgir'],
 ['IN', '24', 'Pratapgarh'],
 ['IN', '31', 'Kolasib district'],
 ['IN', '28', 'Dakshin Dinajpur'],
 ['IN', '20', 'Peren'],
 ['IN', '28', 'North 24 Paraganas'],
 ['IN', '28', 'South 24 Paraganas'],
 ['IN', '28', 'West Medinipur'],
 ['IN', '28', 'West Medinipur District'],
 ['IN', '28', 'East Medinipur'],
 ['IN', '28', 'Uttar Dinajpur'],
 ['IN', '28', 'South 24 Parganas'],
 ['IN', '28', 'North 24 Parganas'],
 ['IN', '29', 'South Sikkim'],
 ['IN', '29', 'West Sikkim'],
 ['IN', '29', 'East Sikkim'],
 ['IN', '07', 'Central Delhi'],
 ['IN', '07', 'North Delhi'],
 ['IN', '07', 'South Delhi'],
 ['IN', '', 'East Delhi'],
 ['IN', '', 'North East Delhi'],
 ['IN', '07', 'South West Delhi'],
 ['IN', '07', 'North West Delhi'],
 ['IN', '07', 'West Delhi'],
 ['IN', '07', 'New Delhi'],
 ['IN', '13', 'K\xc4\x81saragod District'],
 ['IQ', '08', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Z\xc4\x81kh\xc5\xab'],
 ['IQ', '18', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Tikr\xc4\xabt'],
 ['IQ', '15', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Tall \xe2\x80\x98Afar'],
 ['IQ',
  '09',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 S\xc5\xabq ash Shuy\xc5\xabkh'],
 ['IQ', '05', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Shahrb\xc4\x81z\xc4\x81r'],
 ['IQ',
  '18',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 S\xc4\x81marr\xc4\x81\xe2\x80\x99'],
 ['IQ', '05', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 R\xc4\x81niyah'],
 ['IQ',
  '14',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Qal\xe2\x80\x98at \xc5\x9e\xc4\x81li\xe1\xb8\xa9'],
 ['IQ', '05', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Pishdar'],
 ['IQ', '10', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Mandal\xc4\xab'],
 ['IQ', '11', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Makhm\xc5\xabr'],
 ['IQ', '05', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Kifr\xc4\xab'],
 ['IQ', '10', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Kh\xc4\x81naq\xc4\xabn'],
 ['IQ', '13', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Kirk\xc5\xabk'],
 ['IQ', '12', 'Qa\xe1\xb8\x91\xc4\x81 Karbal\xc4\x81\xe2\x80\x99'],
 ['IQ', '11', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Arb\xc4\xabl'],
 ['IQ', '05', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 \xe1\xb8\xa8alabchah'],
 ['IQ', '08', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Dah\xc5\xabk'],
 ['IQ', '05', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Chamchamal'],
 ['IQ', '10', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Ba\xe2\x80\x98q\xc5\xabbah'],
 ['IQ', '07', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Baghd\xc4\x81d'],
 ['IQ', '16', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Badrah'],
 ['IQ', '02', "Qa\xe1\xb8\x91\xc4\x81' az Zubayr"],
 ['IQ', '11', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 az Z\xc4\xabb\xc4\x81r'],
 ['IQ', '16', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 a\xc5\x9f \xc5\x9euwayrah'],
 ['IQ',
  '05',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 as Sulaym\xc4\x81n\xc4\xabyah'],
 ['IQ', '03', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 as Sam\xc4\x81wah'],
 ['IQ', '03', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 as Salm\xc4\x81n'],
 ['IQ', '15', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 ash Shaykh\xc4\x81n'],
 ['IQ', '09', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 ash Sha\xc5\xa3rah'],
 ['IQ', '04', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 ash Sh\xc4\x81m\xc4\xabyah'],
 ['IQ', '01', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 ar Ru\xc5\xa3bah'],
 ['IQ', '09', 'Rufai Qadha'],
 ['IQ', '01', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 ar Ram\xc4\x81d\xc4\xab'],
 ['IQ',
  '09',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 an N\xc4\x81\xc5\x9fir\xc4\xabyah'],
 ['IQ', '17', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 an Najaf'],
 ['IQ', '01', 'Anah Qadha'],
 ['IQ', '02', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Qurnah'],
 ['IQ', '06', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Musayyib'],
 ['IQ',
  '10',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Miqd\xc4\x81d\xc4\xabyah'],
 ['IQ',
  '07',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Ma\xe1\xb8\xa9m\xc5\xabd\xc4\xabyah'],
 ['IQ', '16', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al K\xc5\xabt'],
 ['IQ', '10', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Kh\xc4\x81li\xc5\x9f'],
 ['IQ',
  '07',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al K\xc4\x81z\xcc\xa7im\xc4\xabyah'],
 ['IQ', '09', 'Qa\xe1\xb8\x91\xc4\x81 al Chib\xc4\x81yish'],
 ['IQ',
  '14',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 \xe2\x80\x98Al\xc4\xab al Gharb\xc4\xab'],
 ['IQ', '12', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Hind\xc4\xabyah'],
 ['IQ', '06', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al \xe1\xb8\xa8illah'],
 ['IQ', '16', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al \xe1\xb8\xa8ayy'],
 ['IQ',
  '06',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al H\xc4\x81shim\xc4\xabyah'],
 ['IQ',
  '15',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al \xe1\xb8\xa8a\xe1\xb8\x91r'],
 ['IQ', '01', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Fall\xc5\xabjah'],
 ['IQ', '02', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Ba\xc5\x9frah'],
 ['IQ', '14', 'Qa\xe1\xb8\x91\xc4\x81 al \xe2\x80\x98Am\xc4\x81rah'],
 ['IQ', '08', 'Al \xe2\x80\x98Am\xc4\x81d\xc4\xabyah'],
 ['IQ', '04', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 \xe2\x80\x98Afak'],
 ['IQ',
  '04',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 ad D\xc4\xabw\xc4\x81n\xc4\xabyah'],
 ['IQ', '17', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Ab\xc5\xab \xc5\x9eukhayr'],
 ['IQ',
  '02',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Ab\xc5\xab al Kha\xc5\x9f\xc4\xabb'],
 ['IQ',
  '16',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 a\xc5\x9f \xc5\x9euw\xc4\xabrah'],
 ['IQ', '01', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 \xe1\xb8\xa8ad\xc4\xabthah'],
 ['IQ',
  '13',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al \xe1\xb8\xa8aw\xc4\xabjah'],
 ['IQ', '17', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al K\xc5\xabfah'],
 ['IQ', '18', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 ad Dawr'],
 ['IQ', '18', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 ash Sharq\xc4\x81\xc5\xa3'],
 ['IQ', '18', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Balad'],
 ['IQ',
  '06',
  'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al Ma\xe1\xb8\xa9\xc4\x81w\xc4\xabl'],
 ['IQ', '04', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 al \xe1\xb8\xa8amzah'],
 ['IQ', '18', 'Qa\xe1\xb8\x91\xc4\x81\xe2\x80\x99 Bayj\xc4\xab'],
 ['IR', '07', 'Khesht Va Kam\xc4\x81rej'],
 ['IR', '15', 'Mo\xe2\x80\x98ammareh'],
 ['IR', '15', 'Arvand Ken\xc4\x81r'],
 ['IR', '29', 'Shahrest\xc4\x81n-e S\xc4\xabrj\xc4\x81n'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Fas\xc4\x81'],
 ['IR', '10', 'Shahrest\xc4\x81n-e Badreh'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Na\xc5\xa3anz'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Mamasan\xc4\xab'],
 ['IR', '23', 'Delf\xc4\x81n'],
 ['IR', '33', 'Shahrest\xc4\x81n-e \xc4\x80z\xcc\x84ar Shahr'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Esk\xc5\xab'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Ahar'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Bostan\xc4\x81b\xc4\x81d'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Bon\xc4\x81b'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Tabr\xc4\xabz'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Jolf\xc4\x81'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Ch\xc4\x81r\xc4\x81v\xc4\xabm\xc4\x81q'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Shabastar'],
 ['IR', '33', 'Shahrest\xc4\x81n-e \xe2\x80\x98Ajab Sh\xc4\xabr'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Koleybar'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Mar\xc4\x81gheh'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Marand'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Malek\xc4\x81n'],
 ['IR', '33', 'Shahrest\xc4\x81n-e M\xc4\xab\xc4\x81neh'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Her\xc4\xabs'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Varzaq\xc4\x81n'],
 ['IR', '33', 'Shahrest\xc4\x81n-e Hashtr\xc5\xabd'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Or\xc5\xabm\xc4\xabyeh'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Oshnov\xc4\xabyeh'],
 ['IR', '01', 'Shahrest\xc4\x81n-e B\xc5\xabk\xc4\x81n'],
 ['IR', '01', 'Shahrest\xc4\x81n-e P\xc4\xabr\xc4\x81nshahr'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Tak\xc4\x81b'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Ch\xc4\x81ldar\xc4\x81n'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Khvoy'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Sardasht'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Salm\xc4\x81s'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Sh\xc4\x81h\xc4\xabn Dezh'],
 ['IR', '01', 'Shahrest\xc4\x81n-e M\xc4\x81k\xc5\xab'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Mah\xc4\x81b\xc4\x81d'],
 ['IR', '01', 'Shahrest\xc4\x81n-e M\xc4\xab\xc4\x81ndo\xc4\x81b'],
 ['IR', '01', 'Shahrest\xc4\x81n-e Noqdeh'],
 ['IR', '10', 'Shahrest\xc4\x81n-e \xc4\x80bad\xc4\x81n\xc4\x81n'],
 ['IR', '10', 'Shahrest\xc4\x81n-e \xc4\xaal\xc4\x81m'],
 ['IR', '10', 'Shahrest\xc4\x81n-e Eyv\xc4\x81n'],
 ['IR', '10', 'Shahrest\xc4\x81n-e Darrehshahr'],
 ['IR', '10', 'Shahrest\xc4\x81n-e Dehlor\xc4\x81n'],
 ['IR', '10', 'Shahrest\xc4\x81n-e Sh\xc4\xabrv\xc4\x81n va Chard\xc4\x81val'],
 ['IR', '10', 'Shahrest\xc4\x81n-e Mehr\xc4\x81n'],
 ['IR', '32', 'Shahrest\xc4\x81n-e Ardab\xc4\xabl'],
 ['IR', '32', 'Shahrest\xc4\x81n-e B\xc4\xableh Sav\xc4\x81r'],
 ['IR', '32', 'Shahrest\xc4\x81n-e P\xc4\x81rs\xc4\x81b\xc4\x81d'],
 ['IR', '32', 'Shahrest\xc4\x81n-e K\xc5\xabs\xcc\x84er'],
 ['IR', '32', 'Shahrest\xc4\x81n-e Garm\xc4\xab'],
 ['IR', '32', 'Shahrest\xc4\x81n-e Meshg\xc4\xabnshahr'],
 ['IR', '32', 'Shahrest\xc4\x81n-e Nam\xc4\xabn'],
 ['IR', '32', 'Shahrest\xc4\x81n-e Neyr'],
 ['IR', '28', 'Shahrest\xc4\x81n-e \xc4\x80r\xc4\x81n va B\xc4\xabdgol'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Ardest\xc4\x81n'],
 ['IR', '28', 'Shahrest\xc4\x81n-e E\xc5\x9ffa\xe1\xb8\xa9\xc4\x81n'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Barkhv\xc4\x81r va Meymeh'],
 ['IR',
  '28',
  'Shahrest\xc4\x81n-e T\xc4\xabr\xc4\x81n va K\xc4\x81r\xc5\xabn'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Ch\xc4\x81dag\xc4\x81n'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Khomeyn\xc4\xabshahr'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Khv\xc4\x81ns\xc4\x81r'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Sem\xc4\xabrom'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Sem\xc4\xabrom-e Sofl\xc3\xa1'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Shahre\xe1\xba\x95\xc4\x81'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Far\xc4\xabdan'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Far\xc4\xabd\xc5\xabnshahr'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Fal\xc4\x81varj\xc4\x81n'],
 ['IR', '28', 'Shahrest\xc4\x81n-e K\xc4\x81sh\xc4\x81n'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Golp\xc4\x81yeg\xc4\x81n'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Lanj\xc4\x81n'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Mob\xc4\x81rakeh'],
 ['IR', '28', 'Shahrest\xc4\x81n-e N\xc4\x81\xe2\x80\x99\xc4\xabn'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Najaf\xc4\x81b\xc4\x81d'],
 ['IR', '28', 'Shahrest\xc4\x81n-e Na\xc5\xa3anz'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Bandar-e B\xc5\xabshehr'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Tangest\xc4\x81n'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Jam'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Dashtest\xc4\x81n'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Dasht\xc4\xab'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Deyr'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Deylam'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Kang\xc4\x81n'],
 ['IR', '22', 'Shahrest\xc4\x81n-e Gan\xc4\x81veh'],
 ['IR', '26', 'Shahrest\xc4\x81n-e P\xc4\x81kdasht'],
 ['IR', '26', 'Shahrest\xc4\x81n-e Tehr\xc4\x81n'],
 ['IR', '26', 'Shahrest\xc4\x81n-e Dam\xc4\x81vand'],
 ['IR', '26', 'Shahrest\xc4\x81n-e Rob\xc4\x81\xc5\xa3-e Kar\xc4\xabm'],
 ['IR', '26', 'Shahrest\xc4\x81n-e Rey'],
 ['IR', '44', 'Shahrest\xc4\x81n-e Sav\xc4\x81jbol\xc4\x81gh'],
 ['IR', '26', 'Shahrest\xc4\x81n-e Shem\xc4\xabr\xc4\x81n\xc4\x81t'],
 ['IR', '26', 'Shahrest\xc4\x81n-e Shahr\xc4\xab\xc4\x81r'],
 ['IR', '26', 'Shahrest\xc4\x81n-e F\xc4\xabr\xc5\xabzk\xc5\xabh'],
 ['IR', '44', 'Shahrest\xc4\x81n-e Karaj'],
 ['IR', '44', 'Shahrest\xc4\x81n-e Naz\xcc\xa7ar\xc4\x81b\xc4\x81d'],
 ['IR', '26', 'Shahrest\xc4\x81n-e Var\xc4\x81m\xc4\xabn'],
 ['IR', '03', 'Shahrest\xc4\x81n-e Ardal'],
 ['IR', '03', 'Shahrest\xc4\x81n-e Bor\xc5\xabjen'],
 ['IR', '03', 'Shahrest\xc4\x81n-e Shahr-e Kord'],
 ['IR', '03', 'Shahrest\xc4\x81n-e F\xc4\x81res\xc4\x81n'],
 ['IR', '03', 'Shahrest\xc4\x81n-e K\xc5\xabhrang'],
 ['IR', '03', 'Shahrest\xc4\x81n-e Lordeg\xc4\x81n'],
 ['IR', '41', 'Shahrest\xc4\x81n-e B\xc4\xabrjand'],
 ['IR', '41', 'Shahrest\xc4\x81n-e Sar B\xc4\xabsheh'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Bardeskan'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Torbat-e \xe1\xb8\xa8eydar\xc4\xabyeh'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Chen\xc4\x81r\xc4\x81n'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Khal\xc4\xabl\xc4\x81b\xc4\x81d'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Dargez'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Rashtkhv\xc4\x81r'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Sabzev\xc4\x81r'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Ferdows'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Far\xc4\xabm\xc4\x81n'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Q\xc4\x81\xe2\x80\x99en\xc4\x81t'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Q\xc5\xabch\xc4\x81n'],
 ['IR', '42', 'Shahrest\xc4\x81n-e K\xc4\x81shmar'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Gan\xc4\x81b\xc4\x81d'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Mashhad'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Neysh\xc4\x81b\xc5\xabr'],
 ['IR', '43', 'Shahrest\xc4\x81n-e Esfar\xc4\x81yen'],
 ['IR', '43', 'Shahrest\xc4\x81n-e Bojn\xc5\xabrd'],
 ['IR', '43', 'Shahrest\xc4\x81n-e J\xc4\x81jarm'],
 ['IR', '43', 'Shahrest\xc4\x81n-e Sh\xc4\xabrv\xc4\x81n'],
 ['IR', '15', 'Shahrest\xc4\x81n-e \xc4\x80b\xc4\x81d\xc4\x81n'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Om\xc4\xabd\xc4\xabyeh'],
 ['IR', '15', 'Shahrest\xc4\x81n-e And\xc4\xabmeshk'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Ahv\xc4\x81z'],
 ['IR', '15', 'Shahrest\xc4\x81n-e \xc4\xaaz\xcc\x84eh'],
 ['IR', '15', 'Shahrest\xc4\x81n-e B\xc4\x81gh-e Malek'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Bandar-e M\xc4\x81hshahr'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Behbah\xc4\x81n'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Khorramshahr'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Dezf\xc5\xabl'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Dasht-e \xc4\x80z\xc4\x81deg\xc4\x81n'],
 ['IR', '15', 'Shahrest\xc4\x81n-e R\xc4\x81mhormoz'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Sh\xc4\x81deg\xc4\x81n'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Sh\xc5\xabsh'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Sh\xc5\xabshtar'],
 ['IR', '15', 'Shahrest\xc4\x81n-e L\xc4\x81l\xc4\xab'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Masjed-e Soleym\xc4\x81n'],
 ['IR', '15', 'Shahrest\xc4\x81n-e Hend\xc4\xabj\xc4\x81n'],
 ['IR', '36', 'Shahrest\xc4\x81n-e Abhar'],
 ['IR', '36', 'Shahrest\xc4\x81n-e \xc4\xaajr\xc5\xabd'],
 ['IR', '36', 'Shahrest\xc4\x81n-e Khod\xc4\x81bandeh'],
 ['IR', '36', 'Shahrest\xc4\x81n-e Khorramdarreh'],
 ['IR', '36', 'Shahrest\xc4\x81n-e \xc5\xa2\xc4\x81rem'],
 ['IR', '36', 'Shahrest\xc4\x81n-e M\xc4\x81hnesh\xc4\x81n'],
 ['IR', '25', 'Shahrest\xc4\x81n-e D\xc4\x81mgh\xc4\x81n'],
 ['IR', '25', 'Shahrest\xc4\x81n-e Semn\xc4\x81n'],
 ['IR', '25', 'Shahrest\xc4\x81n-e Sh\xc4\x81hr\xc5\xabd'],
 ['IR', '25', 'Shahrest\xc4\x81n-e Garms\xc4\x81r'],
 ['IR', '07', 'Shahrest\xc4\x81n-e \xc4\x80b\xc4\x81deh'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Arsanj\xc4\x81n'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Estahb\xc4\x81n'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Bav\xc4\x81n\xc4\x81t'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Jahrom'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Khorramb\xc4\xabd'],
 ['IR', '07', 'Shahrest\xc4\x81n-e D\xc4\x81r\xc4\x81b'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Zarr\xc4\xabndasht'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Sep\xc4\xabd\xc4\x81n'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Sh\xc4\xabr\xc4\x81z'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Far\xc4\x81shband'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Fas\xc4\x81'],
 ['IR', '07', 'Shahrest\xc4\x81n-e F\xc4\xabr\xc5\xabz\xc4\x81b\xc4\x81d'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Q\xc4\xabr va K\xc4\x81rz\xc4\xabn'],
 ['IR', '07', 'Shahrest\xc4\x81n-e K\xc4\x81zer\xc5\xabn'],
 ['IR', '07', 'Shahrest\xc4\x81n-e L\xc4\x81rest\xc4\x81n'],
 ['IR', '07', 'Shahrest\xc4\x81n-e L\xc4\x81mard'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Marvdasht'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Mamasan\xc4\xab'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Mohr'],
 ['IR', '07', 'Shahrest\xc4\x81n-e Neyr\xc4\xabz'],
 ['IR', '38', 'Shahrest\xc4\x81n-e \xc4\x80b\xc4\xabk'],
 ['IR',
  '38',
  'Shahrest\xc4\x81n-e B\xc5\xab\xe2\x80\x99\xc4\xabn Zahr\xc4\x81'],
 ['IR', '38', 'Shahrest\xc4\x81n-e T\xc4\x81kest\xc4\x81n'],
 ['IR', '38', 'Shahrest\xc4\x81n-e Qazv\xc4\xabn'],
 ['IR', '39', 'Shahrest\xc4\x81n-e Qom'],
 ['IR', '16', 'Shahrest\xc4\x81n-e B\xc4\x81neh'],
 ['IR', '16', 'Shahrest\xc4\x81n-e B\xc4\xabj\xc4\x81r'],
 ['IR', '16', 'Shahrest\xc4\x81n-e D\xc4\xabv\xc4\x81ndarreh'],
 ['IR', '16', 'Shahrest\xc4\x81n-e Sarv\xc4\x81b\xc4\x81d'],
 ['IR', '16', 'Shahrest\xc4\x81n-e Saqqez'],
 ['IR', '16', 'Shahrest\xc4\x81n-e Sanandaj'],
 ['IR', '16', 'Shahrest\xc4\x81n-e Qorveh'],
 ['IR', '16', 'Shahrest\xc4\x81n-e K\xc4\x81my\xc4\x81r\xc4\x81n'],
 ['IR', '16', 'Shahrest\xc4\x81n-e Mar\xc4\xabv\xc4\x81n'],
 ['IR', '29', 'Shahrest\xc4\x81n-e B\xc4\x81ft'],
 ['IR', '29', 'Shahrest\xc4\x81n-e Bards\xc4\xabr'],
 ['IR', '29', 'Shahrest\xc4\x81n-e Bam'],
 ['IR', '29', 'Shahrest\xc4\x81n-e J\xc4\xabroft'],
 ['IR', '29', 'Shahrest\xc4\x81n-e R\xc4\x81var'],
 ['IR', '29', 'Shahrest\xc4\x81n-e Rafsanj\xc4\x81n'],
 ['IR', '29', 'Shahrest\xc4\x81n-e Zarand'],
 ['IR', '29', 'Shahrest\xc4\x81n-e S\xc4\xabrj\xc4\x81n'],
 ['IR', '29', 'Shahrest\xc4\x81n-e Shahr-e B\xc4\x81bak'],
 ['IR', '29', 'Shahrest\xc4\x81n-e \xe2\x80\x98Anbar\xc4\x81b\xc4\x81d'],
 ['IR', '29', 'Shahrest\xc4\x81n-e Kerm\xc4\x81n'],
 ['IR', '29', 'Shahrest\xc4\x81n-e Kahn\xc5\xabj'],
 ['IR', '29', 'Shahrest\xc4\x81n-e Man\xc5\xabj\xc4\x81n'],
 ['IR', '13', 'Shahrest\xc4\x81n-e Esl\xc4\x81m\xc4\x81b\xc4\x81d-e Gharb'],
 ['IR', '13', 'Shahrest\xc4\x81n-e P\xc4\x81veh'],
 ['IR',
  '13',
  'Shahrest\xc4\x81n-e S\xcc\x84al\xc4\x81s\xcc\x84 B\xc4\x81b\xc4\x81 J\xc4\x81n\xc4\xab'],
 ['IR', '13', 'Shahrest\xc4\x81n-e Jav\xc4\x81nr\xc5\xabd'],
 ['IR', '13', 'Shahrest\xc4\x81n-e Sar Pol-e Z\xcc\x84oh\xc4\x81b'],
 ['IR', '13', 'Shahrest\xc4\x81n-e Sonqor'],
 ['IR', '13', 'Shahrest\xc4\x81n-e \xc5\x9ea\xe1\xb8\xa9neh'],
 ['IR', '13', 'Shahrest\xc4\x81n-e Qa\xc5\x9fr-e Sh\xc4\xabr\xc4\xabn'],
 ['IR', '13', 'Shahrest\xc4\x81n-e Kerm\xc4\x81nsh\xc4\x81h'],
 ['IR', '13', 'Shahrest\xc4\x81n-e Kang\xc4\x81var'],
 ['IR', '13', 'Shahrest\xc4\x81n-e G\xc4\xabl\xc4\x81n-e Gharb'],
 ['IR', '13', 'Shahrest\xc4\x81n-e Hers\xc4\xabn'],
 ['IR', '05', 'Shahrest\xc4\x81n-e B\xc5\xabyer A\xe1\xb8\xa9mad'],
 ['IR', '05', 'Shahrest\xc4\x81n-e Dan\xc4\x81'],
 ['IR', '05', 'Shahrest\xc4\x81n-e Kohg\xc4\xabl\xc5\xabyeh'],
 ['IR', '05', 'Shahrest\xc4\x81n-e Gachs\xc4\x81r\xc4\x81n'],
 ['IR', '37', 'Shahrest\xc4\x81n-e \xc4\x80z\xc4\x81dshahr'],
 ['IR', '37', 'Shahrest\xc4\x81n-e \xc4\x80q Qal\xc4\x81'],
 ['IR', '37', 'Shahrest\xc4\x81n-e Torkaman'],
 ['IR', '37', 'Shahrest\xc4\x81n-e Bandar-e Gaz'],
 ['IR', '37', 'Shahrest\xc4\x81n-e R\xc4\x81m\xc4\xab\xc4\x81n'],
 ['IR', '37', 'Shahrest\xc4\x81n-e \xe2\x80\x98Al\xc4\xab\xc4\x81b\xc4\x81d'],
 ['IR', '37', 'Shahrest\xc4\x81n-e Kord K\xc5\xaby'],
 ['IR', '37', 'Shahrest\xc4\x81n-e Kal\xc4\x81leh'],
 ['IR', '37', 'Shahrest\xc4\x81n-e Gorg\xc4\x81n'],
 ['IR', '37', 'Shahrest\xc4\x81n-e Gonbad-e K\xc4\x81v\xc5\xabs'],
 ['IR', '37', 'Shahrest\xc4\x81n-e M\xc4\xabn\xc5\xabdasht'],
 ['IR', '08', 'Shahrest\xc4\x81n-e \xc4\x80star\xc4\x81'],
 ['IR',
  '08',
  'Shahrest\xc4\x81n-e \xc4\x80st\xc4\x81neh-ye Eshraf\xc4\xabyeh'],
 ['IR', '08', 'Shahrest\xc4\x81n-e Amlash'],
 ['IR', '08', 'Shahrest\xc4\x81n-e Bandar-e Anzal\xc4\xab'],
 ['IR', '08', 'Shahrest\xc4\x81n-e Rasht'],
 ['IR', '08', 'Shahrest\xc4\x81n-e Ra\xe1\xba\x95v\xc4\x81nshahr'],
 ['IR', '08', 'Shahrest\xc4\x81n-e R\xc5\xabdb\xc4\x81r'],
 ['IR', '08', 'Shahrest\xc4\x81n-e R\xc5\xabdsar'],
 ['IR', '08', 'Shahrest\xc4\x81n-e S\xc4\xab\xc4\x81hkal'],
 ['IR', '08', 'Shahrest\xc4\x81n-e Shaft'],
 ['IR', '08', 'Shahrest\xc4\x81n-e \xc5\x9eowm\xe2\x80\x98eh Sar\xc4\x81'],
 ['IR', '08', 'Shahrest\xc4\x81n-e F\xc5\xabman'],
 ['IR', '08', 'Shahrest\xc4\x81n-e L\xc4\x81h\xc4\xabj\xc4\x81n'],
 ['IR', '08', 'Shahrest\xc4\x81n-e Langar\xc5\xabd'],
 ['IR', '08', 'Shahrest\xc4\x81n-e M\xc4\x81s\xc4\x81l'],
 ['IR', '23', 'Shahrest\xc4\x81n-e Azn\xc4\x81'],
 ['IR', '23', 'Shahrest\xc4\x81n-e Al\xc4\xabg\xc5\xabdarz'],
 ['IR', '23', 'Shahrest\xc4\x81n-e Bor\xc5\xabjerd'],
 ['IR', '23', 'Shahrest\xc4\x81n-e Pol-e Dokhtar'],
 ['IR', '23', 'Shahrest\xc4\x81n-e Khorram\xc4\x81b\xc4\x81d'],
 ['IR', '23', 'Shahrest\xc4\x81n-e Delf\xc4\x81n'],
 ['IR', '23', 'Shahrest\xc4\x81n-e Dor\xc5\xabd'],
 ['IR', '23', 'Shahrest\xc4\x81n-e Selseleh'],
 ['IR', '23', 'Shahrest\xc4\x81n-e K\xc5\xabhdasht'],
 ['IR', '35', 'Shahrest\xc4\x81n-e \xc4\x80mol'],
 ['IR', '35', 'Shahrest\xc4\x81n-e B\xc4\x81bol'],
 ['IR', '35', 'Shahrest\xc4\x81n-e B\xc4\x81bolsar'],
 ['IR', '35', 'Shahrest\xc4\x81n-e Behshahr'],
 ['IR', '35', 'Shahrest\xc4\x81n-e Tonek\xc4\x81bon'],
 ['IR', '35', 'Shahrest\xc4\x81n-e J\xc5\xabyb\xc4\x81r'],
 ['IR', '35', 'Shahrest\xc4\x81n-e Ch\xc4\x81l\xc5\xabs'],
 ['IR', '35', 'Shahrest\xc4\x81n-e R\xc4\x81msar'],
 ['IR', '35', 'Shahrest\xc4\x81n-e S\xc4\x81r\xc4\xab'],
 ['IR', '35', 'Shahrest\xc4\x81n-e Sav\xc4\x81d K\xc5\xabh'],
 ['IR', '35', 'Shahrest\xc4\x81n-e Q\xc4\x81\xe2\x80\x99emshahr'],
 ['IR',
  '35',
  'Shahrest\xc4\x81n-e Ma\xe1\xb8\xa9m\xc5\xabd\xc4\x81b\xc4\x81d'],
 ['IR', '35', 'Shahrest\xc4\x81n-e Nek\xc4\x81'],
 ['IR', '35', 'Shahrest\xc4\x81n-e N\xc5\xabr'],
 ['IR', '35', 'Shahrest\xc4\x81n-e Nowshahr'],
 ['IR', '34', 'Shahrest\xc4\x81n-e \xc4\x80sht\xc4\xab\xc4\x81n'],
 ['IR', '34', 'Shahrest\xc4\x81n-e \xc4\x80r\xc4\x81k'],
 ['IR', '34', 'Shahrest\xc4\x81n-e Tafresh'],
 ['IR', '34', 'Shahrest\xc4\x81n-e Khomeyn'],
 ['IR', '34', 'Shahrest\xc4\x81n-e Del\xc4\xabj\xc4\x81n'],
 ['IR', '34', 'Shahrest\xc4\x81n-e Zarand\xc4\xabyeh'],
 ['IR', '34', 'Shahrest\xc4\x81n-e S\xc4\x81veh'],
 ['IR', '34', 'Shahrest\xc4\x81n-e Sh\xc4\x81zand'],
 ['IR', '34', 'Shahrest\xc4\x81n-e Kom\xc4\xabj\xc4\x81n'],
 ['IR', '34', 'Shahrest\xc4\x81n-e Ma\xe1\xb8\xa9all\xc4\x81t'],
 ['IR', '11', 'Shahrest\xc4\x81n-e Ab\xc5\xab M\xc5\xabs\xc3\xa1'],
 ['IR', '11', 'Shahrest\xc4\x81n-e Bastak'],
 ['IR', '11', 'Shahrest\xc4\x81n-e Bandar \xe2\x80\x98Abb\xc4\x81s'],
 ['IR', '11', 'Shahrest\xc4\x81n-e Bandar-e Lengeh'],
 ['IR', '11', 'Shahrest\xc4\x81n-e J\xc4\x81sk'],
 ['IR',
  '11',
  'Shahrest\xc4\x81n-e \xe1\xb8\xa8\xc4\x81jj\xc4\xab\xc4\x81b\xc4\x81d'],
 ['IR', '11', 'Shahrest\xc4\x81n-e R\xc5\xabd\xc4\x81n'],
 ['IR', '11', 'Shahrest\xc4\x81n-e Qeshm'],
 ['IR', '11', 'Shahrest\xc4\x81n-e M\xc4\xabn\xc4\x81b'],
 ['IR', '09', 'Shahrest\xc4\x81n-e Asad\xc4\x81b\xc4\x81d'],
 ['IR', '09', 'Shahrest\xc4\x81n-e Bah\xc4\x81r'],
 ['IR', '09', 'Shahrest\xc4\x81n-e T\xc5\xabyserk\xc4\x81n'],
 ['IR', '09', 'Shahrest\xc4\x81n-e Razan'],
 ['IR', '09', 'Shahrest\xc4\x81n-e Kab\xc5\xabdar\xc4\x81hang'],
 ['IR', '09', 'Shahrest\xc4\x81n-e Mal\xc4\x81yer'],
 ['IR', '09', 'Shahrest\xc4\x81n-e Nah\xc4\x81vand'],
 ['IR', '09', 'Hamad\xc4\x81n'],
 ['IR', '40', 'Shahrest\xc4\x81n-e Abark\xc5\xabh'],
 ['IR', '40', 'Shahrest\xc4\x81n-e Ardak\xc4\x81n'],
 ['IR', '40', 'Shahrest\xc4\x81n-e B\xc4\x81fq'],
 ['IR', '40', 'Shahrest\xc4\x81n-e Taft'],
 ['IR', '40', 'Shahrest\xc4\x81n-e Kh\xc4\x81tem'],
 ['IR', '40', 'Shahrest\xc4\x81n-e \xc5\x9ead\xc5\xabq'],
 ['IR', '40', 'Shahrest\xc4\x81n-e \xc5\xa2abas'],
 ['IR', '40', 'Shahrest\xc4\x81n-e Mehr\xc4\xabz'],
 ['IR', '40', 'Shahrest\xc4\x81n-e Meybod'],
 ['IR', '40', 'Shahrest\xc4\x81n-e Yazd'],
 ['IR', '04', 'Shahrest\xc4\x81n-e \xc4\xaar\xc4\x81nshahr'],
 ['IR', '41', 'Shahrest\xc4\x81n-e Nahband\xc4\x81n'],
 ['IR', '42', 'Shahrest\xc4\x81n-e T\xc4\x81yb\xc4\x81d'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Torbat-e J\xc4\x81m'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Khav\xc4\x81f'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Sarakhs'],
 ['IR', '42', 'Shahrest\xc4\x81n-e Kal\xc4\x81t'],
 ['IR', '04', 'Shahrest\xc4\x81n-e \xc4\xaar\xc4\x81nshahr'],
 ['IR', '04', 'Shahrest\xc4\x81n-e Ch\xc4\x81bah\xc4\x81r'],
 ['IR', '04', 'Shahrest\xc4\x81n-e Kh\xc4\x81sh'],
 ['IR', '04', 'Shahrest\xc4\x81n-e Z\xc4\x81bol'],
 ['IR', '04', 'Shahrest\xc4\x81n-e Z\xc4\x81hed\xc4\x81n'],
 ['IR', '04', 'Shahrest\xc4\x81n-e Sar\xc4\x81v\xc4\x81n'],
 ['IR', '04', 'Shahrest\xc4\x81n-e Sarb\xc4\x81z'],
 ['IR', '04', 'Shahrest\xc4\x81n-e N\xc4\xabkshahr'],
 ['IR', '35', 'Savadkuh County'],
 ['IS', '42', 'Rang\xc3\xa1rvallahreppur'],
 ['IT', '15', 'Provincia di Trapani'],
 ['IT', '15', 'Provincia di Siracusa'],
 ['IT', '03', 'Provincia di Reggio Calabria'],
 ['IT', '15', 'Provincia di Ragusa'],
 ['IT', '15', 'Provincia di Palermo'],
 ['IT', '14', 'Provincia di Oristano'],
 ['IT', '15', 'Provincia di Messina'],
 ['IT', '15', 'Provincia di Enna'],
 ['IT', '03', 'Provincia di Cosenza'],
 ['IT', '03', 'Provincia di Catanzaro'],
 ['IT', '15', 'Provincia di Catania'],
 ['IT', '15', 'Provincia di Caltanissetta'],
 ['IT', '14', 'Provincia di Cagliari'],
 ['IT', '15', 'Provincia di Agrigento'],
 ['IT', '07', 'Provincia di Viterbo'],
 ['IT', '20', 'Provincia di Vicenza'],
 ['IT', '20', 'Provincia di Verona'],
 ['IT', '12', 'Provincia di Vercelli'],
 ['IT', '12', 'Provincia Verbano-Cusio-Ossola'],
 ['IT', '20', 'Provincia di Venezia'],
 ['IT', '09', 'Provincia di Varese'],
 ['IT', '06', 'Provincia di Udine'],
 ['IT', '06', 'Provincia di Trieste'],
 ['IT', '20', 'Provincia di Treviso'],
 ['IT', '17', 'Provincia di Trento'],
 ['IT', '12', 'Provincia di Torino'],
 ['IT', '18', 'Provincia di Terni'],
 ['IT', '01', 'Provincia di Teramo'],
 ['IT', '13', 'Provincia di Taranto'],
 ['IT', '09', 'Provincia di Sondrio'],
 ['IT', '16', 'Provincia di Siena'],
 ['IT', '08', 'Provincia di Savona'],
 ['IT', '14', 'Provincia di Sassari'],
 ['IT', '04', 'Provincia di Salerno'],
 ['IT', '20', 'Provincia di Rovigo'],
 ['IT', '07', 'Provincia di Roma'],
 ['IT', '07', 'Provincia di Rieti'],
 ['IT', '05', 'Provincia di Reggio Emilia'],
 ['IT', '05', 'Provincia di Ravenna'],
 ['IT', '02', 'Provincia di Potenza'],
 ['IT', '06', 'Provincia di Pordenone'],
 ['IT', '16', 'Provincia di Pistoia'],
 ['IT', '16', 'Provincia di Pisa'],
 ['IT', '05', 'Provincia di Piacenza'],
 ['IT', '01', 'Provincia di Pescara'],
 ['IT', '10', 'Provincia di Pesaro e Urbino'],
 ['IT', '18', 'Provincia di Perugia'],
 ['IT', '09', 'Provincia di Pavia'],
 ['IT', '05', 'Provincia di Parma'],
 ['IT', '20', 'Provincia di Padova'],
 ['IT', '14', 'Provincia di Nuoro'],
 ['IT', '12', 'Provincia di Novara'],
 ['IT', '04', 'Provincia di Napoli'],
 ['IT', '05', 'Provincia di Modena'],
 ['IT', '09', 'Provincia di Milano'],
 ['IT', '02', 'Provincia di Matera'],
 ['IT', '16', 'Provincia di Massa-Carrara'],
 ['IT', '09', 'Provincia di Mantova'],
 ['IT', '10', 'Provincia di Macerata'],
 ['IT', '16', 'Provincia di Lucca'],
 ['IT', '16', 'Provincia di Livorno'],
 ['IT', '13', 'Provincia di Lecce'],
 ['IT', '07', 'Provincia di Latina'],
 ['IT', '08', 'Provincia di La Spezia'],
 ['IT', '01', "Provincia di L'Aquila"],
 ['IT', '11', 'Provincia di Isernia'],
 ['IT', '08', 'Provincia di Imperia'],
 ['IT', '16', 'Provincia di Grosseto'],
 ['IT', '06', 'Provincia di Gorizia'],
 ['IT', '08', 'Provincia di Genova'],
 ['IT', '07', 'Provincia di Frosinone'],
 ['IT', '05', 'Provincia di Forl\xc3\xac'],
 ['IT', '13', 'Provincia di Foggia'],
 ['IT', '16', 'Provincia di Firenze'],
 ['IT', '05', 'Provincia di Ferrara'],
 ['IT', '12', 'Provincia di Cuneo'],
 ['IT', '09', 'Provincia di Cremona'],
 ['IT', '09', 'Provincia di Como'],
 ['IT', '01', 'Provincia di Chieti'],
 ['IT', '04', 'Provincia di Caserta'],
 ['IT', '11', 'Provincia di Campobasso'],
 ['IT', '13', 'Provincia di Brindisi'],
 ['IT', '09', 'Provincia di Brescia'],
 ['IT', '17', 'Provincia di Bolzano'],
 ['IT', '05', 'Provincia di Bologna'],
 ['IT', '09', 'Provincia di Bergamo'],
 ['IT', '04', 'Provincia di Benevento'],
 ['IT', '20', 'Provincia di Belluno'],
 ['IT', '13', 'Provincia di Bari'],
 ['IT', '04', 'Provincia di Avellino'],
 ['IT', '12', 'Provincia di Asti'],
 ['IT', '10', 'Province of Ascoli Piceno'],
 ['IT', '16', 'Province of Arezzo'],
 ['IT', '19', 'Provincia di Aosta'],
 ['IT', '10', 'Provincia di Ancona'],
 ['IT', '12', 'Provincia di Alessandria'],
 ['IT', '12', 'Provincia di Biella'],
 ['IT', '14', 'Provincia di Carbonia-Iglesias'],
 ['IT', '14', 'Provincia di Olbia-Tempio'],
 ['IT', '14', 'Provincia di Medio Campidano'],
 ['IT', '14', 'Provincia di Ogliastra'],
 ['IT', '05', 'Provincia di Rimini'],
 ['IT', '03', 'Provincia di Vibo-Valentia'],
 ['IT', '03', 'Provincia di Crotone'],
 ['IT', '09', 'Provincia di Lecco'],
 ['IT', '09', 'Provincia di Lodi'],
 ['IT', '16', 'Provincia di Prato'],
 ['IT', '10', 'Province of Fermo'],
 ['IT', '13', 'Provincia di Barletta - Andria - Trani'],
 ['IT', '09', 'Provincia di Monza e Brianza'],
 ['JO', '02', 'Qasabat As Salt'],
 ['JO', '17', 'Qasabat Az Zarqa'],
 ['JP', '17', 'Zents\xc5\xabji-shi'],
 ['JP', '19', 'Zama-shi'],
 ['JP', '07', 'Yukuhashi-shi'],
 ['JP', '14', 'Y\xc5\xabki-shi'],
 ['JP', '14', 'Y\xc5\xabki-gun'],
 ['JP', '00', 'Yoshiki-gun'],
 ['JP', '22', 'Yosa-gun'],
 ['JP', '41', 'Yonago-shi'],
 ['JP', '19', 'Yokosuka-shi'],
 ['JP', '19', 'Yokohama-shi'],
 ['JP', '23', 'Yokkaichi-shi'],
 ['JP', '00', 'Y\xc5\x8dkaichi-shi'],
 ['JP', '41', 'Yazu-gun'],
 ['JP', '21', 'Yatsushiro-shi'],
 ['JP', '21', 'Yatsushiro-gun'],
 ['JP', '36', 'Yatsuka-gun'],
 ['JP', '00', 'Yasu-gun'],
 ['JP', '32', 'Yao-shi'],
 ['JP', '45', 'Yanai-shi'],
 ['JP', '07', 'Yanagawa-shi'],
 ['JP', '07', 'Yame-shi'],
 ['JP', '07', 'Yame-gun'],
 ['JP', '28', 'Yamatotakada-shi'],
 ['JP', '00', 'Yamato-shi'],
 ['JP', '28', 'Yamatok\xc5\x8driyama-shi'],
 ['JP', '00', 'Yamato-gun'],
 ['JP', '46', 'Yamanashi-shi'],
 ['JP', '08', 'Yama-gun'],
 ['JP', '45', 'Yamaguchi-shi'],
 ['JP', '11', 'Yamagata-gun'],
 ['JP', '37', 'Yaizu-shi'],
 ['JP', '38', 'Yaita-shi'],
 ['JP', '07', 'Yahata-ku'],
 ['JP', '47', 'Yaeyama-gun'],
 ['JP', '00', 'Yabu-gun'],
 ['JP', '23', 'Watarai-gun'],
 ['JP', '43', 'Wakayama-shi'],
 ['JP', '15', 'Wajima-shi'],
 ['JP', '05', 'Uwajima-shi'],
 ['JP', '38', 'Utsunomiya-shi'],
 ['JP', '21', 'Uto-shi'],
 ['JP', '00', 'Uto-gun'],
 ['JP', '30', 'Usuki-shi'],
 ['JP', '00', 'Usui-gun'],
 ['JP', '30', 'Usa-shi'],
 ['JP', '00', 'Usa-gun'],
 ['JP', '47', 'Urasoe-shi'],
 ['JP', '00', 'Urawa-shi'],
 ['JP', '42', 'Uozu-shi'],
 ['JP', '00', 'Uma-gun'],
 ['JP', '22', 'Uji-shi'],
 ['JP', '00', 'Uji-gun'],
 ['JP', '00', 'Ueno-shi'],
 ['JP', '26', 'Ueda-shi'],
 ['JP', '28', 'Uda-gun'],
 ['JP', '45', 'Ube-shi'],
 ['JP', '31', 'Tsuyama-shi'],
 ['JP', '01', 'Tsushima-shi'],
 ['JP', '23', 'Tsu-shi'],
 ['JP', '46', 'Tsuru-shi'],
 ['JP', '00', 'Tsurusaki-shi'],
 ['JP', '44', 'Tsuruoka-shi'],
 ['JP', '06', 'Tsuruga-shi'],
 ['JP', '00', 'Tsuruga-gun'],
 ['JP', '00', 'Tsunan-machi'],
 ['JP', '00', 'Tsuna-gun'],
 ['JP', '00', 'Tsukui-gun'],
 ['JP', '31', 'Tsukubo-gun'],
 ['JP', '29', 'Tsubame-shi'],
 ['JP', '00', 'Toyoura-gun'],
 ['JP', '01', 'Toyota-shi'],
 ['JP', '00', 'Toyotama-gun'],
 ['JP', '11', 'Toyota-gun'],
 ['JP', '00', 'Toyosaka-shi'],
 ['JP', '13', 'Toyooka-shi'],
 ['JP', '00', 'Toyono-gun'],
 ['JP', '01', 'Toyokawa-shi'],
 ['JP', '01', 'Toyoake-shi'],
 ['JP', '42', 'Toyama-shi'],
 ['JP', '41', 'Tottori-shi'],
 ['JP', '33', 'Tosu-shi'],
 ['JP', '20', 'Tosa-shi'],
 ['JP', '20', 'Tosa-gun'],
 ['JP', '32', 'Tondabayashi-shi'],
 ['JP', '42', 'Tonami-shi'],
 ['JP', '31', 'Tomata-gun'],
 ['JP', '00', 'Tokuyama-shi'],
 ['JP', '39', 'Tokushima-shi'],
 ['JP', '34', 'Tokorozawa-shi'],
 ['JP', '01', 'Tokoname-shi'],
 ['JP', '09', 'Toki-shi'],
 ['JP', '01', 'T\xc5\x8dkai-shi'],
 ['JP', '41', 'T\xc5\x8dhaku-gun'],
 ['JP', '34', 'Toda-shi'],
 ['JP', '00', 'Tenry\xc5\xab-shi'],
 ['JP', '28', 'Tenri-shi'],
 ['JP', '04', 'Tateyama-shi'],
 ['JP', '18', 'Tarumizu-shi'],
 ['JP', '10', 'Tano-gun'],
 ['JP', '43', 'Tanabe-shi'],
 ['JP', '40', 'Tama-shi'],
 ['JP', '00', 'Tamano-shi'],
 ['JP', '21', 'Tamana-shi'],
 ['JP', '21', 'Tamana-gun'],
 ['JP', '33', 'Taku-shi'],
 ['JP', '30', 'Taketa-shi'],
 ['JP', '33', 'Takeo-shi'],
 ['JP', '00', 'Takefu-shi'],
 ['JP', '09', 'Takayama-shi'],
 ['JP', '32', 'Takatsuki-shi'],
 ['JP', '00', 'Takashima-gun'],
 ['JP', '10', 'Takasaki-shi'],
 ['JP', '13', 'Takasago-shi'],
 ['JP', '13', 'Takarazuka-shi'],
 ['JP', '42', 'Takaoka-shi'],
 ['JP', '20', 'Takaoka-gun'],
 ['JP', '17', 'Takamatsu-shi'],
 ['JP', '32', 'Takaishi-shi'],
 ['JP', '31', 'Takahashi-shi'],
 ['JP', '13', 'Taka-gun'],
 ['JP', '09', 'Tajimi-shi'],
 ['JP', '07', 'Tagawa-shi'],
 ['JP', '07', 'Tagawa-gun'],
 ['JP', '37', 'Tagata-gun'],
 ['JP', '40', 'Tachikawa-shi'],
 ['JP', '15', 'Suzu-shi'],
 ['JP', '23', 'Suzuka-shi'],
 ['JP', '00', 'Suzu-gun'],
 ['JP', '26', 'Suwa-shi'],
 ['JP', '26', 'Suwa-gun'],
 ['JP', '37', 'Susono-shi'],
 ['JP', '37', 'Sunt\xc5\x8d-gun'],
 ['JP', '00', 'Sumoto-shi'],
 ['JP', '32', 'Suita-shi'],
 ['JP', '22', 'S\xc5\x8draku-gun'],
 ['JP', '18', 'Soo-gun'],
 ['JP', '17', 'Sh\xc5\x8dzu-gun'],
 ['JP', '37', 'Shizuoka-shi'],
 ['JP', '38', 'Shioya-gun'],
 ['JP', '00', 'Shiojiri-shi'],
 ['JP', '01', 'Shinshiro-shi'],
 ['JP', '00', 'Shinnan\xe2\x80\x99y\xc5\x8d-shi'],
 ['JP', '43', 'Shing\xc5\xab-shi'],
 ['JP', '14', 'Shimotsuma-shi'],
 ['JP', '38', 'Shimotsuga-gun'],
 ['JP', '26', 'Shimotakai-gun'],
 ['JP', '00', 'Shimo-takai-gun'],
 ['JP', '45', 'Shimonoseki-shi'],
 ['JP', '42', 'Shimoniikawa-gun'],
 ['JP', '26', 'Shimominochi-gun'],
 ['JP', '26', 'Shimoina-gun'],
 ['JP', '00', 'Shimoge-gun'],
 ['JP', '37', 'Shimoda-shi'],
 ['JP', '00', 'Shimo-agata-gun'],
 ['JP', '00', 'Shimminato-shi'],
 ['JP', '00', 'Shimizu-shi'],
 ['JP', '47', 'Shimajiri-gun'],
 ['JP', '23', 'Shima-shi'],
 ['JP', '28', 'Shiki-gun'],
 ['JP', '32', 'Shij\xc5\x8dnawate-shi'],
 ['JP', '00', 'Shiga-gun'],
 ['JP', '00', 'Shida-gun'],
 ['JP', '40', 'Shibuya-ku'],
 ['JP', '00', 'Shibukawa-shi'],
 ['JP', '29', 'Shibata-shi'],
 ['JP', '32', 'Settsu-shi'],
 ['JP', '01', 'Seto-shi'],
 ['JP', '10', 'Seta-gun'],
 ['JP', '40', 'Setagaya-ku'],
 ['JP', '32', 'Sennan-gun'],
 ['JP', '00', 'Semboku-gun'],
 ['JP', '00', 'Seki-shi'],
 ['JP', '13', 'Say\xc5\x8d-gun'],
 ['JP', '34', 'Sayama-shi'],
 ['JP', '10', 'Sawa-gun'],
 ['JP', '18', 'Satsuma-gun'],
 ['JP', '14', 'Sashima-gun'],
 ['JP', '27', 'Sasebo-shi'],
 ['JP', '00', 'Sarashina-gun'],
 ['JP', '29', 'Sant\xc5\x8d-gun'],
 ['JP', '29', 'Sanj\xc5\x8d-shi'],
 ['JP', '26', 'Saku-shi'],
 ['JP', '00', 'Sakurai-shi'],
 ['JP', '44', 'Sakata-shi'],
 ['JP', '32', 'Sakai-shi'],
 ['JP', '41', 'Sakaiminato-shi'],
 ['JP', '00', 'Sakai-gun'],
 ['JP', '17', 'Sakaide-shi'],
 ['JP', '34', 'Sakado-shi'],
 ['JP', '25', 'Saito-shi'],
 ['JP', '30', 'Saiki-shi'],
 ['JP', '05', 'Saij\xc5\x8d-shi'],
 ['JP', '00', 'Saihaku-gun'],
 ['JP', '00', 'Saidaiji-shi'],
 ['JP', '33', 'Saga-shi'],
 ['JP', '00', 'Sagamihara-shi'],
 ['JP', '00', 'Saga-gun'],
 ['JP', '00', 'Saeki-gun'],
 ['JP', '29', 'Sado-shi'],
 ['JP', '00', 'Ry\xc5\x8dtsu-shi'],
 ['JP', '05', '\xc5\x8czu-shi'],
 ['JP', '38', 'Oyama-shi'],
 ['JP', '42', 'Oyabe-shi'],
 ['JP', '23', 'Owase-shi'],
 ['JP', '01', 'Owariasahi-shi'],
 ['JP', '35', '\xc5\x8ctsu-shi'],
 ['JP', '46', '\xc5\x8ctsuki-shi'],
 ['JP', '00', '\xc5\x8cta-shi'],
 ['JP', '11', '\xc5\x8ctake-shi'],
 ['JP', '40', '\xc5\x8cshima-shich\xc5\x8d'],
 ['JP', '45', '\xc5\x8cshima-gun'],
 ['JP', '32', '\xc5\x8csaka-shi'],
 ['JP', '10', '\xc5\x8cra-gun'],
 ['JP', '00', 'Ony\xc5\xab-gun'],
 ['JP', '11', 'Onomichi-shi'],
 ['JP', '07', '\xc5\x8cnoj\xc5\x8d-shi'],
 ['JP', '00', '\xc5\x8cno-gun'],
 ['JP', '07', 'Onga-gun'],
 ['JP', '07', '\xc5\x8cmuta-shi'],
 ['JP', '00', '\xc5\x8cmi-machi'],
 ['JP', '35', '\xc5\x8cmihachiman-shi'],
 ['JP', '40', '\xc5\x8cme-shi'],
 ['JP', '00', '\xc5\x8cmachi-shi'],
 ['JP', '00', '\xc5\x8ckuchi-shi'],
 ['JP', '47', 'Okinawa-shi'],
 ['JP', '36', 'Oki-gun'],
 ['JP', '00', 'Okegawa-shi'],
 ['JP', '01', 'Okazaki-shi'],
 ['JP', '26', 'Okaya-shi'],
 ['JP', '31', 'Okayama-shi'],
 ['JP', '07', '\xc5\x8ckawa-shi'],
 ['JP', '00', '\xc5\x8ckawa-gun'],
 ['JP', '29', 'Ojiya-shi'],
 ['JP', '30', '\xc5\x8cita-shi'],
 ['JP', '00', '\xc5\x8cita-gun'],
 ['JP', '06', '\xc5\x8ci-gun'],
 ['JP', '00', 'Og\xc5\x8dri-shi'],
 ['JP', '00', 'Ogi-gun'],
 ['JP', '02', 'Oga-shi'],
 ['JP', '00', 'Ogasa-gun'],
 ['JP', '09', '\xc5\x8cgaki-shi'],
 ['JP', '00', 'Oe-gun'],
 ['JP', '00', 'Odawara-shi'],
 ['JP', '36', '\xc5\x8cda-shi'],
 ['JP', '31', 'Oda-gun'],
 ['JP', '36', '\xc5\x8cchi-gun'],
 ['JP', '05', 'Ochi-gun'],
 ['JP', '01', '\xc5\x8cbu-shi'],
 ['JP', '00', 'Obata-machi'],
 ['JP', '00', 'Obama-shi'],
 ['JP', '06', 'Ny\xc5\xab-gun'],
 ['JP', '37', 'Numazu-shi'],
 ['JP', '00', 'Numakuma-gun'],
 ['JP', '01', 'Nukata-gun'],
 ['JP', '15', 'Nomi-gun'],
 ['JP', '00', 'Nogi-gun'],
 ['JP', '25', 'Nobeoka-shi'],
 ['JP', '01', 'Niwa-gun'],
 ['JP', '46', 'Nishiyatsushiro-gun'],
 ['JP', '13', 'Nishiwaki-shi'],
 ['JP', '05', 'Nishiuwa-gun'],
 ['JP', '00', 'Nishi-tonami-gun'],
 ['JP', '40', 'Nishitama-gun'],
 ['JP', '00', 'Nishi-tagawa-gun'],
 ['JP', '27', 'Nishisonogi-gun'],
 ['JP', '01', 'Nishio-shi'],
 ['JP', '44', 'Nishiokitama-gun'],
 ['JP', '13', 'Nishinomiya-shi'],
 ['JP', '43', 'Nishimuro-gun'],
 ['JP', '33', 'Nishimatsuura-gun'],
 ['JP', '00', 'Nishi-kunisaki-gun'],
 ['JP', '00', 'Nishi-kubiki-gun'],
 ['JP', '01', 'Nishikasugai-gun'],
 ['JP', '00', 'Nishi-kanbara-gun'],
 ['JP', '46', 'Nirasaki-shi'],
 ['JP', '00', 'Nima-gun'],
 ['JP', '00', 'Niiza-shi'],
 ['JP', '05', 'Niihama-shi'],
 ['JP', '29', 'Niigata-shi'],
 ['JP', '25', 'Nichinan-shi'],
 ['JP', '32', 'Neyagawa-shi'],
 ['JP', '00', 'Nei-gun'],
 ['JP', '00', 'Naze-shi'],
 ['JP', '28', 'Nara-shi'],
 ['JP', '20', 'Nankoku-shi'],
 ['JP', '30', 'Nakatsu-shi'],
 ['JP', '09', 'Nakatsugawa-shi'],
 ['JP', '00', 'Nakatado-gun'],
 ['JP', '26', 'Nakano-shi'],
 ['JP', '42', 'Nakaniikawa-gun'],
 ['JP', '00', 'Nakamura-shi'],
 ['JP', '07', 'Nakama-shi'],
 ['JP', '00', 'Naka-kubiki-gun'],
 ['JP', '00', 'Naka-kawachi-gun'],
 ['JP', '00', 'Naka-gun'],
 ['JP', '19', 'Naka-gun'],
 ['JP', '00', 'Naka-gun'],
 ['JP', '01', 'Nagoya-shi'],
 ['JP', '47', 'Nago-shi'],
 ['JP', '45', 'Nagato-shi'],
 ['JP', '27', 'Nagasaki-shi'],
 ['JP', '04', 'Nagareyama'],
 ['JP', '29', 'Nagaoka-shi'],
 ['JP', '22', 'Nagaokaky\xc5\x8d-shi'],
 ['JP', '20', 'Nagaoka-gun'],
 ['JP', '26', 'Nagano-shi'],
 ['JP', '35', 'Nagahama-shi'],
 ['JP', '00', 'Naga-gun'],
 ['JP', '00', 'Naga-gun'],
 ['JP', '23', 'Nabari-shi'],
 ['JP', '39', 'My\xc5\x8dzai-gun'],
 ['JP', '40', 'Musashino-shi'],
 ['JP', '40', 'Musashimurayama-shi'],
 ['JP', '20', 'Muroto-shi'],
 ['JP', '00', 'Muko-gun'],
 ['JP', '09', 'Motosu-gun'],
 ['JP', '35', 'Moriyama-shi'],
 ['JP', '09', 'Mizunami-shi'],
 ['JP', '11', 'Miyoshi-shi'],
 ['JP', '39', 'Miyoshi-gun'],
 ['JP', '25', 'Miyazaki-shi'],
 ['JP', '25', 'Miyakonoj\xc5\x8d-shi'],
 ['JP', '33', 'Miyaki-gun'],
 ['JP', '40', 'Miyake-shich\xc5\x8d'],
 ['JP', '19', 'Miura-shi'],
 ['JP', '19', 'Miura-gun'],
 ['JP', '00', 'Mitsuke-shi'],
 ['JP', '00', 'Mitsukaid\xc5\x8d-shi'],
 ['JP', '00', 'Mitsugi-gun'],
 ['JP', '17', 'Mitoyo-shi'],
 ['JP', '37', 'Mishima-shi'],
 ['JP', '32', 'Mishima-gun'],
 ['JP', '34', 'Misato-shi'],
 ['JP', '32', 'Minoo-shi'],
 ['JP', '09', 'Minokamo-shi'],
 ['JP', '00', 'Mino-gun'],
 ['JP', '45', 'Mine-shi'],
 ['JP', '00', 'Mine-gun'],
 ['JP', '05', 'Minamiuwa-gun'],
 ['JP', '00', 'Minami-tama-gun'],
 ['JP', '00', 'Minami-takaki-gun'],
 ['JP', '00', 'Minami-shidara-gun'],
 ['JP', '26', 'Minamisaku-gun'],
 ['JP', '34', 'Minamisaitama-gun'],
 ['JP', '25', 'Minaminaka-gun'],
 ['JP', '27', 'Minamimatsuura-gun'],
 ['JP', '46', 'Minamikoma-gun'],
 ['JP', '32', 'Minamikawachi-gun'],
 ['JP', '00', 'Minami-azumi-gun'],
 ['JP', '00', 'Minami-amabe-gun'],
 ['JP', '08', 'Minamiaizu-gun'],
 ['JP', '21', 'Minamata-shi'],
 ['JP', '11', 'Mihara-shi'],
 ['JP', '00', 'Mihara-gun'],
 ['JP', '23', 'Mie-gun'],
 ['JP', '05', 'Matsuyama-shi'],
 ['JP', '27', 'Matsuura-shi'],
 ['JP', '00', 'Matsut\xc5\x8d-shi'],
 ['JP', '23', 'Matsusaka-shi'],
 ['JP', '26', 'Matsumoto-shi'],
 ['JP', '36', 'Matsue-shi'],
 ['JP', '04', 'Matsudo-shi'],
 ['JP', '32', 'Matsubara-shi'],
 ['JP', '36', 'Masuda-shi'],
 ['JP', '17', 'Marugame-shi'],
 ['JP', '18', 'Makurazaki-shi'],
 ['JP', '22', 'Maizuru-shi'],
 ['JP', '10', 'Maebashi-shi'],
 ['JP', '40', 'Machida-shi'],
 ['JP', '22', 'Ky\xc5\x8dto-shi'],
 ['JP', '23', 'Kuwana-shi'],
 ['JP', '23', 'Kuwana-gun'],
 ['JP', '30', 'Kusu-gun'],
 ['JP', '25', 'Kushima-shi'],
 ['JP', '00', 'Kushikino-shi'],
 ['JP', '35', 'Kusatsu-shi'],
 ['JP', '07', 'Kurume-shi'],
 ['JP', '42', 'Kurobe-shi'],
 ['JP', '00', 'Kurita-gun'],
 ['JP', '11', 'Kure-shi'],
 ['JP', '07', 'Kuraten-gun'],
 ['JP', '31', 'Kurashiki-shi'],
 ['JP', '40', 'Kunitachi-shi'],
 ['JP', '31', 'Kume-gun'],
 ['JP', '23', 'Kumano-shi'],
 ['JP', '00', 'Kumano-gun'],
 ['JP', '21', 'Kumamoto-shi'],
 ['JP', '00', 'Kumage-gun'],
 ['JP', '45', 'Kuga-gun'],
 ['JP', '45', 'Kudamatsu-shi'],
 ['JP', '00', 'Koza-shi'],
 ['JP', '19', 'K\xc5\x8dza-gun'],
 ['JP', '25', 'K\xc5\x8dyu-gun'],
 ['JP', '00', 'K\xc5\x8dshoku-shi'],
 ['JP', '00', 'Koshi-gun'],
 ['JP', '34', 'Koshigaya-shi'],
 ['JP', '00', 'K\xc5\x8dnu-gun'],
 ['JP', '34', 'K\xc5\x8dnosu-shi'],
 ['JP', '01', 'K\xc5\x8dnan-shi'],
 ['JP', '26', 'Komoro-shi'],
 ['JP', '39', 'Komatsushima-shi'],
 ['JP', '15', 'Komatsu-shi'],
 ['JP', '01', 'Komaki-shi'],
 ['JP', '26', 'Komagane-shi'],
 ['JP', '40', 'Komae-shi'],
 ['JP', '40', 'Kokubunji-shi'],
 ['JP', '00', 'K\xc5\x8dka-gun'],
 ['JP', '00', 'Kojima-shi'],
 ['JP', '00', 'Kojima-gun'],
 ['JP', '14', 'Koga-shi'],
 ['JP', '40', 'Koganei-shi'],
 ['JP', '46', 'K\xc5\x8dfu-shi'],
 ['JP', '40', 'Kodaira-shi'],
 ['JP', '20', 'K\xc5\x8dchi-shi'],
 ['JP', '13', 'K\xc5\x8dbe-shi'],
 ['JP', '22', 'Kizu'],
 ['JP', '40', 'Kiyose-shi'],
 ['JP', '30', 'Kitsuki-shi'],
 ['JP', '05', 'Kitauwa-gun'],
 ['JP', '00', 'Kitanonuma-gun'],
 ['JP', '46', 'Kitatsuru-gun'],
 ['JP', '00', 'Kita-tama-gun'],
 ['JP', '01', 'Kitashitara-gun'],
 ['JP', '26', 'Kitasaku-gun'],
 ['JP', '23', 'Kitamuro-gun'],
 ['JP', '27', 'Kitamatsuura-gun'],
 ['JP', '07', 'Kitaky\xc5\xabsh\xc5\xab-shi'],
 ['JP', '00', 'Kita-kawachi-gun'],
 ['JP', '34', 'Kitakatsushika-gun'],
 ['JP', '00', 'Kitakata-shi'],
 ['JP', '29', 'Kitakambara-gun'],
 ['JP', '00', 'Kitahama-mura'],
 ['JP', '17', 'Kita-gun'],
 ['JP', '05', 'Kita-gun'],
 ['JP', '10', 'Kitagumma-gun'],
 ['JP', '26', 'Kitaazumi-gun'],
 ['JP', '00', 'Kita-amabe-gun'],
 ['JP', '00', 'Kita-aizu-gun'],
 ['JP', '34', 'Kitaadachi-gun'],
 ['JP', '32', 'Kishiwada-shi'],
 ['JP', '00', 'Kinosaki-gun'],
 ['JP', '04', 'Kimitsu-shi'],
 ['JP', '21', 'Kikuchi-shi'],
 ['JP', '21', 'Kikuchi-gun'],
 ['JP', '34', 'Kazo-shi'],
 ['JP', '19', 'Kawasaki-shi'],
 ['JP', '08', 'Kawanuma-gun'],
 ['JP', '13', 'Kawanishi-shi'],
 ['JP', '00', 'Kawakami-gun'],
 ['JP', '34', 'Kawaguchi-shi'],
 ['JP', '34', 'Kawagoe-shi'],
 ['JP', '00', 'Kawachi-shi'],
 ['JP', '32', 'Kawachinagano-shi'],
 ['JP', '38', 'Kawachi-gun'],
 ['JP', '13', 'Kawanabe-gun'],
 ['JP', '06', 'Katsuyama-shi'],
 ['JP', '39', 'Katsuura-gun'],
 ['JP', '31', 'Katsuta-gun'],
 ['JP', '32', 'Katano-shi'],
 ['JP', '07', 'Kasuya-gun'],
 ['JP', '07', 'Kasuga-shi'],
 ['JP', '01', 'Kasugai-shi'],
 ['JP', '00', 'Kashiwazaki-shi'],
 ['JP', '32', 'Kashiwara-shi'],
 ['JP', '33', 'Kashima-shi'],
 ['JP', '31', 'Kasaoka-shi'],
 ['JP', '01', 'Kariya-shi'],
 ['JP', '00', 'Kanzaki-gun'],
 ['JP', '38', 'Kanuma-shi'],
 ['JP', '10', 'Kanra-gun'],
 ['JP', '17', 'Kanonji-shi'],
 ['JP', '09', 'Kani-gun'],
 ['JP', '15', 'Kanazawa-shi'],
 ['JP', '29', 'Kamo-shi'],
 ['JP', '09', 'Kamo-gun'],
 ['JP', '37', 'Kamo-gun'],
 ['JP', '00', 'Kamo-gun'],
 ['JP', '38', 'Kamitsuga-gun'],
 ['JP', '26', 'Kamitakai-gun'],
 ['JP', '00', 'Kami-niikawa-gun'],
 ['JP', '26', 'Kamiina-gun'],
 ['JP', '00', 'Kami-gun'],
 ['JP', '00', 'Kami-fukuoka-shi'],
 ['JP', '00', 'Kami-agata-gun'],
 ['JP', '22', 'Kameoka-shi'],
 ['JP', '19', 'Kamakura-shi'],
 ['JP', '13', 'Kako-gun'],
 ['JP', '13', 'Kakogawa-shi'],
 ['JP', '09', 'Kakamigahara-shi'],
 ['JP', '32', 'Kaizuka-shi'],
 ['JP', '43', 'Kais\xc5\x8d-gun'],
 ['JP', '43', 'Kainan-shi'],
 ['JP', '39', 'Kaifu-gun'],
 ['JP', '15', 'Kahoku-gun'],
 ['JP', '07', 'Kaho-gun'],
 ['JP', '18', 'Kagoshima-shi'],
 ['JP', '17', 'Kagawa-gun'],
 ['JP', '15', 'Kaga-shi'],
 ['JP', '32', 'Kadoma-shi'],
 ['JP', '22', 'J\xc5\x8dy\xc5\x8d-shi'],
 ['JP', '29', 'J\xc5\x8detsu-shi'],
 ['JP', '00', 'J\xc5\x8dd\xc5\x8d-gun'],
 ['JP', '00', 'J\xc5\x8db\xc5\x8d-gun'],
 ['JP', '11', 'Jinseki-gun'],
 ['JP', '36', 'Izumo-shi'],
 ['JP', '32', 'Izumi-shi'],
 ['JP', '18', 'Izumi-shi'],
 ['JP', '00', 'Izumi\xc5\x8dtsu-shi'],
 ['JP', '00', 'iyo mishima'],
 ['JP', '05', 'Iyo-gun'],
 ['JP', '05', 'Iyo-shi'],
 ['JP', '00', 'Iwatsuki-shi'],
 ['JP', '37', 'Iwata-shi'],
 ['JP', '00', 'Iwata-gun'],
 ['JP', '45', 'Iwakuni-shi'],
 ['JP', '00', 'Iwai-shi'],
 ['JP', '29', 'Iwafune-gun'],
 ['JP', '07', 'Itoshima-gun'],
 ['JP', '47', 'Itoman-shi'],
 ['JP', '43', 'Ito-gun'],
 ['JP', '39', 'Itano-gun'],
 ['JP', '13', 'Itami-shi'],
 ['JP', '00', 'Ishikawa-shi'],
 ['JP', '15', 'Ishikawa-gun'],
 ['JP', '47', 'Ishigaki-shi'],
 ['JP', '23', 'Ise-shi'],
 ['JP', '10', 'Isesaki-shi'],
 ['JP', '19', 'Isehara-shi'],
 ['JP', '34', 'Iruma-shi'],
 ['JP', '34', 'Iruma-gun'],
 ['JP', '00', 'Innoshima-shi'],
 ['JP', '00', 'Innami-gun'],
 ['JP', '01', 'Inazawa-shi'],
 ['JP', '26', 'Ina-shi'],
 ['JP', '00', 'Inasa-gun'],
 ['JP', '40', 'Inagi-shi'],
 ['JP', '42', 'Imizu-shi'],
 ['JP', '28', 'Ikoma-shi'],
 ['JP', '28', 'Ikoma-gun'],
 ['JP', '27', 'Iki-shi'],
 ['JP', '32', 'Ikeda-shi'],
 ['JP', '35', 'Ika-gun'],
 ['JP', '07', 'Iizuka-shi'],
 ['JP', '26', 'Iiyama-shi'],
 ['JP', '26', 'Iida-shi'],
 ['JP', '00', 'Ihara-gun'],
 ['JP', '00', 'Ichishi-gun'],
 ['JP', '01', 'Ichinomiya-shi'],
 ['JP', '04', 'Ichikawa-shi'],
 ['JP', '18', 'Ibusuki-shi'],
 ['JP', '00', 'Ibusuki-gun'],
 ['JP', '13', 'Ibo-gun'],
 ['JP', '32', 'Ibaraki-shi'],
 ['JP', '25', 'Hy\xc5\xabga-shi'],
 ['JP', '00', 'H\xc5\x8dya-shi'],
 ['JP', '00', 'H\xc5\x8dtaku-gun'],
 ['JP', '34', 'Honj\xc5\x8d-shi'],
 ['JP', '00', 'Hondo-shi'],
 ['JP', '01', 'Hoi-gun'],
 ['JP', '45', 'H\xc5\x8dfu-shi'],
 ['JP', '21', 'Hitoyoshi-shi'],
 ['JP', '30', 'Hita-shi'],
 ['JP', '00', 'Hisai-shi'],
 ['JP', '11', 'Hiroshima-shi'],
 ['JP', '19', 'Hiratsuka-shi'],
 ['JP', '00', 'Hirata-shi'],
 ['JP', '00', 'Hirara-shi'],
 ['JP', '00', 'Hiraoka-shi'],
 ['JP', '32', 'Hirakata-shi'],
 ['JP', '00', 'Hioki-gun'],
 ['JP', '40', 'Hino-shi'],
 ['JP', '00', 'Hinokawa-gun'],
 ['JP', '41', 'Hino-gun'],
 ['JP', '42', 'Himi-shi'],
 ['JP', '13', 'Himeji-shi'],
 ['JP', '35', 'Hikone-shi'],
 ['JP', '34', 'Hiki-gun'],
 ['JP', '45', 'Hikari-shi'],
 ['JP', '00', 'Higashi-yatsushiro-gun'],
 ['JP', '40', 'Higashiyamato-shi'],
 ['JP', '00', 'Higashiyamanashi-gun'],
 ['JP', '25', 'Higashiusuki-gun'],
 ['JP', '00', 'Higashi-tonami-gun'],
 ['JP', '44', 'Higashitagawa-gun'],
 ['JP', '27', 'Higashisonigi-gun'],
 ['JP', '32', 'Higashi\xc5\x8dsaka-shi'],
 ['JP', '43', 'Higashimuro-gun'],
 ['JP', '00', 'Higashi-murayama-shi'],
 ['JP', '34', 'Higashimatsuyama-shi'],
 ['JP', '33', 'Higashimatsuura-gun'],
 ['JP', '40', 'Higashikurume-shi'],
 ['JP', '00', 'Higashi-kubiki-gun'],
 ['JP', '00', 'Higashi-katsushika-gun'],
 ['JP', '01', 'Higashi-kasugai-gun'],
 ['JP', '00', 'Higashi-kamo-gun'],
 ['JP', '29', 'Higashikambara-gun'],
 ['JP', '11', 'Higashihiroshima-shi'],
 ['JP', '26', 'Higashichikuma-gun'],
 ['JP', '43', 'Hidaka-gun'],
 ['JP', '00', 'Hiba-gun'],
 ['JP', '01', 'Hekinan-shi'],
 ['JP', '00', 'Hekikai-gun'],
 ['JP', '01', 'Hazu-gun'],
 ['JP', '34', 'Hatogaya-shi'],
 ['JP', '20', 'Hata-gun'],
 ['JP', '34', 'Hasuda-shi'],
 ['JP', '43', 'Hashimoto-shi'],
 ['JP', '09', 'Hashima-shi'],
 ['JP', '09', 'Hashima-gun'],
 ['JP', '34', 'Hann\xc5\x8d-shi'],
 ['JP', '32', 'Hannan-shi'],
 ['JP', '26', 'Hanishina-gun'],
 ['JP', '01', 'Handa-shi'],
 ['JP', '37', 'Hamana-gun'],
 ['JP', '37', 'Hamamatsu-shi'],
 ['JP', '00', 'Hamakita-shi'],
 ['JP', '36', 'Hamada-shi'],
 ['JP', '15', 'Hakui-shi'],
 ['JP', '37', 'Haibara-gun'],
 ['JP', '00', 'Haguri-gun'],
 ['JP', '45', 'Hagi-shi'],
 ['JP', '00', 'Hadano-shi'],
 ['JP', '40', 'Hachij\xc5\x8d-shich\xc5\x8d'],
 ['JP', '32', 'Habikino-shi'],
 ['JP', '34', 'Gy\xc5\x8dda-shi'],
 ['JP', '00', 'Gushikawa-shi'],
 ['JP', '00', 'Gumma-gun'],
 ['JP', '36', 'G\xc5\x8dtsu-shi'],
 ['JP', '37', 'Gotenba-shi'],
 ['JP', '00', 'Gose-shi'],
 ['JP', '29', 'Gosen-shi'],
 ['JP', '28', 'Goj\xc5\x8d-shi'],
 ['JP', '47', 'Ginowan-shi'],
 ['JP', '09', 'Gifu-shi'],
 ['JP', '35', 'Gam\xc5\x8d-gun'],
 ['JP', '01', 'Gamag\xc5\x8dri-shi'],
 ['JP', '09', 'Fuwa-gun'],
 ['JP', '04', 'Futtsu-shi'],
 ['JP', '40', 'Fussa-shi'],
 ['JP', '00', 'Fuse-shi'],
 ['JP', '04', 'Funabashi-shi'],
 ['JP', '11', 'Fukuyama-shi'],
 ['JP', '37', 'Fukuroi-shi'],
 ['JP', '07', 'Fukuoka-shi'],
 ['JP', '00', 'Fukui-shi'],
 ['JP', '00', 'Fukue-shi'],
 ['JP', '22', 'Fukuchiyama-shi'],
 ['JP', '46', 'Fujiyoshida-shi'],
 ['JP', '37', 'Fuji-shi'],
 ['JP', '19', 'Fujisawa-shi'],
 ['JP', '37', 'Fujinomiya-shi'],
 ['JP', '00', 'Fujimi-shi'],
 ['JP', '32', 'Fujiidera-shi'],
 ['JP', '37', 'Fuji-gun'],
 ['JP', '37', 'Fujieda-shi'],
 ['JP', '00', 'Fugeshi-gun'],
 ['JP', '00', 'Fuch\xc5\xab-shi'],
 ['JP', '09', 'Ena-shi'],
 ['JP', '00', 'Echi-gun'],
 ['JP', '00', 'Ebina-shi'],
 ['JP', '32', 'Dait\xc5\x8d-shi'],
 ['JP', '00', 'Ch\xc5\x8dfu-shi'],
 ['JP', '40', 'Chiyoda-ku'],
 ['JP', '01', 'Chita-shi'],
 ['JP', '01', 'Chita-gun'],
 ['JP', '01', 'Chiry\xc5\xab-shi'],
 ['JP', '26', 'Chino-shi'],
 ['JP', '07', 'Chikushi-gun'],
 ['JP', '07', 'Chikuj\xc5\x8d-gun'],
 ['JP', '07', 'Chikugo-shi'],
 ['JP', '26', 'Chiisakata-gun'],
 ['JP', '00', 'Chihaya-Akasaka-mura'],
 ['JP', '19', 'Chigasaki-shi'],
 ['JP', '34', 'Chichibu-gun'],
 ['JP', '07', 'Buzen-shi'],
 ['JP', '30', 'Bungotakada-shi'],
 ['JP', '31', 'Bizen-shi'],
 ['JP', '00', 'Bisai-shi'],
 ['JP', '00', 'Ayauta-ch\xc5\x8d'],
 ['JP', '19', 'Ayase-shi'],
 ['JP', '22', 'Ayabe-shi'],
 ['JP', '00', 'Awa-gun'],
 ['JP', '00', 'Awa-gun'],
 ['JP', '00', 'Atsumi-gun'],
 ['JP', '19', 'Atsugi-shi'],
 ['JP', '00', 'Atetsu-gun'],
 ['JP', '00', 'Atami-shi'],
 ['JP', '21', 'Aso-gun'],
 ['JP', '13', 'Ashiya-shi'],
 ['JP', '38', 'Ashikaga-shi'],
 ['JP', '19', 'Ashigarashimo-gun'],
 ['JP', '19', 'Ashigarakami-gun'],
 ['JP', '00', 'Asashina-mura'],
 ['JP', '31', 'Asakuchi-gun'],
 ['JP', '00', 'Asako-gun'],
 ['JP', '00', 'Asaka-shi'],
 ['JP', '00', 'Asaji-machi'],
 ['JP', '00', 'Asahi-mura'],
 ['JP', '00', 'Asahi-mura'],
 ['JP', '00', 'Asahi-mura'],
 ['JP', '00', 'Asahi-mura'],
 ['JP', '00', 'Asahi-mura'],
 ['JP', '00', 'Asahi-mura'],
 ['JP', '00', 'Asahi-machi'],
 ['JP', '00', 'Asahi-ch\xc5\x8d'],
 ['JP', '00', 'Arita-machi'],
 ['JP', '00', 'Arimatsu-ch\xc5\x8d'],
 ['JP', '00', 'Arikawa-ch\xc5\x8d'],
 ['JP', '00', 'Arie-machi'],
 ['JP', '43', 'Arida-shi'],
 ['JP', '43', 'Arida-gun'],
 ['JP', '00', 'Ariake-machi'],
 ['JP', '00', 'Ariake-ch\xc5\x8d'],
 ['JP', '21', 'Arao-shi'],
 ['JP', '00', 'Arakawa-mura'],
 ['JP', '00', 'Arakawa-machi'],
 ['JP', '00', 'Arai-shi'],
 ['JP', '00', 'Arai-ch\xc5\x8d'],
 ['JP', '00', 'Arachi-mura'],
 ['JP', '00', 'Aoyama-ch\xc5\x8d'],
 ['JP', '00', 'Aogashima-mura'],
 ['JP', '01', 'Anj\xc5\x8d-shi'],
 ['JP', '00', 'Ando-mura'],
 ['JP', '39', 'Anan-shi'],
 ['JP', '00', 'Anan-ch\xc5\x8d'],
 ['JP', '00', 'Anamizu-machi'],
 ['JP', '00', 'Anabuki-ch\xc5\x8d'],
 ['JP', '00', 'Ampachi-ch\xc5\x8d'],
 ['JP', '21', 'Amakusa-shi'],
 ['JP', '01', 'Ama-gun'],
 ['JP', '00', 'Amagi-ch\xc5\x8d'],
 ['JP', '13', 'Amagasaki-shi'],
 ['JP', '00', 'Ama-ch\xc5\x8d'],
 ['JP', '18', 'Akune-shi'],
 ['JP', '13', 'Ak\xc5\x8d-shi'],
 ['JP', '00', 'Akiyama-mura'],
 ['JP', '00', 'Akitsu-ch\xc5\x8d'],
 ['JP', '40', 'Akishima-shi'],
 ['JP', '20', 'Aki-shi'],
 ['JP', '00', 'Aki-machi'],
 ['JP', '11', 'Aki-gun'],
 ['JP', '20', 'Aki-gun'],
 ['JP', '13', 'Akashi-shi'],
 ['JP', '00', 'Akashina-machi'],
 ['JP', '00', 'Akasaki-ch\xc5\x8d'],
 ['JP', '00', 'Akasaka-ch\xc5\x8d'],
 ['JP', '00', 'Akaiwa-gun'],
 ['JP', '00', 'Akaike-machi'],
 ['JP', '00', 'Akagi-mura'],
 ['JP', '00', 'Akagi-ch\xc5\x8d'],
 ['JP', '00', 'Akabori-mura'],
 ['JP', '00', 'Akabane-ch\xc5\x8d'],
 ['JP', '00', 'Ajimu-machi'],
 ['JP', '00', 'Ajikata-mura'],
 ['JP', '00', 'Aji-ch\xc5\x8d'],
 ['JP', '08', 'Aizuwakamatsu-shi'],
 ['JP', '00', 'Aizu-Takada-machi'],
 ['JP', '00', 'Aizumi-ch\xc5\x8d'],
 ['JP', '00', 'Aizu-Bange-machi'],
 ['JP', '00', 'Ait\xc5\x8d-ch\xc5\x8d'],
 ['JP', '18', 'Aira-gun'],
 ['JP', '00', 'Aira-ch\xc5\x8d'],
 ['JP', '00', 'Aioi-ch\xc5\x8d'],
 ['JP', '00', 'Aino-ch\xc5\x8d'],
 ['JP', '00', 'Aikawa-machi'],
 ['JP', '00', 'Aikawa-machi'],
 ['JP', '01', 'Aichi-gun'],
 ['JP', '00', 'Aguni-son'],
 ['JP', '40', 'Adachi-ku'],
 ['JP', '00', 'Achi-mura'],
 ['JP', '05', 'Yawatahama-shi'],
 ['JP', '05', 'Imabari-shi'],
 ['JP', '12', 'Okushiri-gun'],
 ['JP', '02', 'Yuzawa-shi'],
 ['JP', '00', 'Yonezawa-shi'],
 ['JP', '02', 'Yokote-shi'],
 ['JP', '00', 'Yamagata-shi'],
 ['JP', '04', 'Yachiyo-shi'],
 ['JP', '16', 'Waga-gun'],
 ['JP', '00', 'Unakami-gun'],
 ['JP', '00', 'Tsukuba-gun'],
 ['JP', '00', 'Tsuchiura-shi'],
 ['JP', '14', 'Toride-shi'],
 ['JP', '16', 'T\xc5\x8dno-shi'],
 ['JP', '24', 'Tome-shi'],
 ['JP', '04', 'T\xc5\x8dgane-shi'],
 ['JP', '08', 'Tamura-gun'],
 ['JP', '00', 'Taga-gun'],
 ['JP', '08', 'Sukagawa-shi'],
 ['JP', '08', 'Souma-shi'],
 ['JP', '16', 'Shiwa-gun'],
 ['JP', '24', 'Shiroishi-shi'],
 ['JP', '08', 'Shirakawa-shi'],
 ['JP', '24', 'Shiogama-shi'],
 ['JP', '00', 'Shinobu-gun'],
 ['JP', '44', 'Shinj\xc5\x8d-shi'],
 ['JP', '24', 'Shibata-gun'],
 ['JP', '00', 'Sendai-shi'],
 ['JP', '02', 'Semboku-gun'],
 ['JP', '00', 'Sawara-shi'],
 ['JP', '04', 'Sambu-gun'],
 ['JP', '04', 'Sakura-shi'],
 ['JP', '00', 'Sagae-shi'],
 ['JP', '14', 'Ry\xc5\xabgasaki-shi'],
 ['JP', '38', '\xc5\x8ctawara-shi'],
 ['JP', '00', '\xc5\x8cmagari-shi'],
 ['JP', '40', 'Ogasawara-shich\xc5\x8d'],
 ['JP', '00', '\xc5\x8cfunato-shi'],
 ['JP', '08', 'Nishishirakawa-gun'],
 ['JP', '44', 'Nishimurayama-gun'],
 ['JP', '00', 'Niihari-gun'],
 ['JP', '08', 'Nihommatsu-shi'],
 ['JP', '38', 'Nasu-gun'],
 ['JP', '04', 'Narita-shi'],
 ['JP', '04', 'Narashino-shi'],
 ['JP', '44', 'Nany\xc5\x8d-shi'],
 ['JP', '00', 'Nakaminato-shi'],
 ['JP', '00', 'Naka-gun'],
 ['JP', '14', 'Naka-gun'],
 ['JP', '44', 'Murayama-shi'],
 ['JP', '24', 'Motoyoshi-gun'],
 ['JP', '16', 'Morioka-shi'],
 ['JP', '00', 'Mooka-shi'],
 ['JP', '00', 'Mon\xc5\x8d-gun'],
 ['JP', '44', 'Mogami-gun'],
 ['JP', '04', 'Mobara-shi'],
 ['JP', '00', 'Mizusawa-shi'],
 ['JP', '16', 'Miyako-shi'],
 ['JP', '24', 'Miyagi Gun'],
 ['JP', '14', 'Mito-shi'],
 ['JP', '02', 'Minamiakita-gun'],
 ['JP', '00', 'Makabe-gun'],
 ['JP', '24', 'Kurokawa-gun'],
 ['JP', '24', 'Kurihara-shi'],
 ['JP', '14', 'Kuji-gun'],
 ['JP', '08', 'K\xc5\x8driyama-shi'],
 ['JP', '16', 'Kitakami-shi'],
 ['JP', '14', 'Kitaibaraki-shi'],
 ['JP', '02', 'Kitaakita-gun'],
 ['JP', '00', 'Kimitsu-gun'],
 ['JP', '24', 'Kesennuma Shi'],
 ['JP', '16', 'Kesen-gun'],
 ['JP', '00', 'Kawabe-gun'],
 ['JP', '24', 'Katta-gun'],
 ['JP', '00', 'Katsuta-shi'],
 ['JP', '04', 'Katori-gun'],
 ['JP', '04', 'Kashiwa-shi'],
 ['JP', '14', 'Kasama-shi'],
 ['JP', '00', 'Kamogawa-shi'],
 ['JP', '00', 'Kaminoyama-shi'],
 ['JP', '16', 'Kamihei-gun'],
 ['JP', '16', 'Kamaishi-shi'],
 ['JP', '04', 'Kamagaya-shi'],
 ['JP', '00', 'Izumi-shi'],
 ['JP', '00', 'Iwanuma-shi'],
 ['JP', '00', 'Iwaki-shi'],
 ['JP', '04', 'Isumi-gun'],
 ['JP', '24', 'Ishinomaki Shi'],
 ['JP', '00', 'Ishiki-gun'],
 ['JP', '14', 'Inashiki-gun'],
 ['JP', '04', 'Ichihara-shi'],
 ['JP', '00', 'Honj\xc5\x8d-shi'],
 ['JP', '14', 'Hitachi-shi'],
 ['JP', '14', 'Hitachi\xc5\x8dta-shi'],
 ['JP', '00', 'Hiraka-gun'],
 ['JP', '44', 'Higashiokitama-gun'],
 ['JP', '44', 'Higashimurayama-gun'],
 ['JP', '16', 'Higashiiwai-gun'],
 ['JP', '14', 'Higashiibaraki-gun'],
 ['JP', '00', 'Hienuki-gun'],
 ['JP', '00', 'Haramachi-shi'],
 ['JP', '16', 'Hanamaki-shi'],
 ['JP', '38', 'Haga-gun'],
 ['JP', '00', 'Furukawa-shi'],
 ['JP', '08', 'Fukushima-shi'],
 ['JP', '00', 'Esashi-shi'],
 ['JP', '08', 'Date-gun'],
 ['JP', '04', 'Ch\xc5\x8dshi-shi'],
 ['JP', '04', 'Ch\xc5\x8dsei-gun'],
 ['JP', '04', 'Chiba-shi'],
 ['JP', '00', 'Asahi-mura'],
 ['JP', '00', 'Asahi-machi'],
 ['JP', '00', 'Ani-machi'],
 ['JP', '00', 'Ami-machi'],
 ['JP', '02', 'Akita Shi'],
 ['JP', '00', 'Akeno-machi'],
 ['JP', '00', 'Akai-mura'],
 ['JP', '00', 'Akai-mura'],
 ['JP', '04', 'Abiko-shi'],
 ['JP', '12', 'Y\xc5\xabbari-shi'],
 ['JP', '12', 'Yoichi-gun'],
 ['JP', '02', 'Yamamoto-gun'],
 ['JP', '12', 'Wakkanai-shi'],
 ['JP', '12', 'Utashinai-shi'],
 ['JP', '00', 'T\xc5\x8dya-mura'],
 ['JP', '03', 'Towada-shi'],
 ['JP', '12', 'Tomamae-gun'],
 ['JP', '12', 'Tomakomai-shi'],
 ['JP', '12', 'Teshio-gun'],
 ['JP', '12', 'Takikawa-shi'],
 ['JP', '12', 'Sunagawa-shi'],
 ['JP', '00', 'Shizunai-gun'],
 ['JP', '03', 'Shimokita-gun'],
 ['JP', '12', 'Shibetsu-shi'],
 ['JP', '00', 'Sapporo-shi'],
 ['JP', '12', 'Sapporo-shi'],
 ['JP', '03', 'Sannohe-gun'],
 ['JP', '12', 'Rumoi-shi'],
 ['JP', '12', 'Rishiri-gun'],
 ['JP', '12', 'Rebun-gun'],
 ['JP', '12', 'Otaru-shi'],
 ['JP', '00', '\xc5\x8cdate-shi'],
 ['JP', '12', 'Obihiro-shi'],
 ['JP', '02', 'Noshiro-shi'],
 ['JP', '12', 'Noboribetsu-shi'],
 ['JP', '00', 'Nishi-tsugaru-gun'],
 ['JP', '16', 'Ninohe-shi'],
 ['JP', '16', 'Ninohe-gun'],
 ['JP', '00', 'Nemuro-gun'],
 ['JP', '03', 'Mutsu-shi'],
 ['JP', '12', 'Muroran-shi'],
 ['JP', '03', 'Minamitsugaru-gun'],
 ['JP', '00', 'Kushiro-shich\xc5\x8d'],
 ['JP', '12', 'Kushiro-shi'],
 ['JP', '12', 'Kushiro-gun'],
 ['JP', '03', 'Kuroishi-shi'],
 ['JP', '16', 'Kunohe-gun'],
 ['JP', '16', 'Kuji-shi'],
 ['JP', '03', 'Kitatsugaru-gun'],
 ['JP', '12', 'Kitami-shi'],
 ['JP', '02', 'Kazuno-shi'],
 ['JP', '12', 'Kayabe-gun'],
 ['JP', '00', 'Kami-kita-gun'],
 ['JP', '03', 'Kamikita-gun'],
 ['JP', '12', 'Kamikawa-gun'],
 ['JP', '12', 'Kamiiso-gun'],
 ['JP', '00', 'Kameda-shi'],
 ['JP', '12', 'Kameda-gun'],
 ['JP', '12', 'Iwamizawa-shi'],
 ['JP', '12', 'Hiyama-gun'],
 ['JP', '03', 'Hirosaki-shi'],
 ['JP', '12', 'Hiroo-gun'],
 ['JP', '03', 'Higashitsugaru-gun'],
 ['JP', '12', 'Hakodate-shi'],
 ['JP', '03', 'Hachinohe-shi'],
 ['JP', '03', 'Goshogawara-shi'],
 ['JP', '00', 'Gonohe-machi'],
 ['JP', '12', 'Furubira-gun'],
 ['JP', '12', 'Furano-shi'],
 ['JP', '12', 'Fukagawa-shi'],
 ['JP', '12', 'Ebetsu-shi'],
 ['JP', '12', 'Date-shi'],
 ['JP', '00', 'Chitose-gun'],
 ['JP', '12', 'Bibai-shi'],
 ['JP', '12', 'Ashibetsu-shi'],
 ['JP', '12', 'Asahikawa-shi'],
 ['JP', '00', 'Arakawa-mura'],
 ['JP', '03', 'Aomori-shi'],
 ['JP', '12', 'Akabira-shi'],
 ['JP', '00', 'Ajigasawa-machi'],
 ['JP', '00', 'Aikawa-machi'],
 ['JP', '12', 'Abuta-gun'],
 ['JP', '00', 'Abashiri-shich\xc5\x8d'],
 ['JP', '12', 'Abashiri-shi'],
 ['JP', '05', 'Seiyo-shi'],
 ['JP', '05', 'Kitauwa-gun'],
 ['JP', '05', 'T\xc5\x8don-shi'],
 ['JP', '05', 'Kamiukena-gun'],
 ['JP', '14', 'Moriya-shi'],
 ['JP', '01', 'Nishikamo-gun'],
 ['JP', '01', 'Kiyosu-shi'],
 ['JP', '01', 'Aisai-shi'],
 ['JP', '01', 'Iwakura-shi'],
 ['JP', '01', 'Kitanagoya-shi'],
 ['JP', '01', 'Takahama-shi'],
 ['JP', '01', 'Toyohashi-shi'],
 ['JP', '13', 'Kanzaki-gun'],
 ['JP', '13', 'Mikata-gun'],
 ['JP', '13', 'Sumoto-shi'],
 ['JP', '13', 'Miki-shi'],
 ['JP', '13', 'Ono-shi'],
 ['JP', '13', 'Sanda-shi'],
 ['JP', '13', 'Kasai-shi'],
 ['JP', '13', 'Sasayama-shi'],
 ['JP', '13', 'Tanba-shi'],
 ['JP', '13', 'Minamiawaji-shi'],
 ['JP', '13', 'Asago-shi'],
 ['JP', '13', 'Awaji-shi'],
 ['JP', '13', 'Shis\xc5\x8d-shi'],
 ['JP', '13', 'Kat\xc5\x8d-shi'],
 ['JP', '11', 'Akitakata-shi'],
 ['JP', '11', 'Sh\xc5\x8dbara-shi'],
 ['JP', '11', 'Sera-gun'],
 ['JP', '18', 'Amami-shi'],
 ['JP', '18', 'Hioki-shi'],
 ['JP', '18', 'Ichikikushikino-shi'],
 ['JP', '18', 'Isa-shi'],
 ['JP', '18', 'Kirishima-shi'],
 ['JP', '18', 'Minamiky\xc5\xabsh\xc5\xab-shi'],
 ['JP', '18', 'Minamisatsuma-shi'],
 ['JP', '18', 'Satsumasendai-shi'],
 ['JP', '18', 'Soo-shi'],
 ['JP', '18', 'Izumi-gun'],
 ['JP', '18', 'Kagoshima-gun'],
 ['JP', '18', 'Kimotsuki-gun'],
 ['JP', '42', 'Nanto-shi'],
 ['JP', '17', 'Higashikagawa-shi'],
 ['JP', '17', 'Ayauta-gun'],
 ['JP', '33', 'Fujitsu-gun'],
 ['JP', '33', 'Imari-shi'],
 ['JP', '33', 'Kanzaki-gun'],
 ['JP', '33', 'Kanzaki-shi'],
 ['JP', '33', 'Kishima-gun'],
 ['JP', '33', 'Ureshino-shi'],
 ['JP', '32', 'Izumisano-shi'],
 ['JP', '32', '\xc5\x8csakasayama-shi'],
 ['JP', '32', 'Sennan-shi'],
 ['JP', '32', 'Toyonaka-shi'],
 ['JP', '32', 'Senboku-gun'],
 ['JP', '41', 'Kurayoshi-shi'],
 ['JP', '41', 'Iwami-gun'],
 ['JP', '36', 'Hikawa-gun'],
 ['JP', '36', 'Iishi-gun'],
 ['JP', '36', 'Nita-gun'],
 ['JP', '36', 'Kanoashi-gun'],
 ['JP', '36', 'Unnan-shi'],
 ['JP', '36', 'Yasugi-shi'],
 ['JP', '45', 'Sany\xc5\x8donoda-shi'],
 ['JP', '45', 'Sh\xc5\xabnan-shi'],
 ['JP', '35', 'Maibara-shi'],
 ['JP', '35', 'Higashiazai-gun'],
 ['JP', '35', 'Inukami-gun'],
 ['JP', '31', 'Aida-gun'],
 ['JP', '31', 'Kaga-gun'],
 ['JP', '31', 'Maniwa-gun'],
 ['JP', '31', 'Wake-gun'],
 ['JP', '31', 'Ibara-shi'],
 ['JP', '31', 'S\xc5\x8dja-shi'],
 ['JP', '31', 'Niimi-shi'],
 ['JP', '31', 'Setouchi-shi'],
 ['JP', '31', 'Akaiwa-shi'],
 ['JP', '31', 'Maniwa-shi'],
 ['JP', '31', 'Asakuchi-shi'],
 ['JP', '20', 'Sukumo-shi'],
 ['JP', '20', 'Shimanto-shi'],
 ['JP', '20', 'K\xc5\x8dnan-shi'],
 ['JP', '20', 'Kami-shi'],
 ['JP', '05', 'Shikokuch\xc5\xab\xc5\x8d-shi'],
 ['JP', '39', 'Mima-gun'],
 ['JP', '39', 'My\xc5\x8dd\xc5\x8d-gun'],
 ['JP', '39', 'Naka-gun'],
 ['JP', '39', 'Yoshinogawa-shi'],
 ['JP', '39', 'Mima-shi'],
 ['JP', '39', 'Miyoshi-shi'],
 ['JP', '39', 'Katsuura-ch\xc5\x8d'],
 ['JP', '39', 'Kamiyama-ch\xc5\x8d'],
 ['JP', '39', 'Naka-ch\xc5\x8d'],
 ['JP', '07', 'Asakura-gun'],
 ['JP', '07', 'Mii-gun'],
 ['JP', '07', 'Miyako-gun'],
 ['JP', '07', 'Mizuma-gun'],
 ['JP', '07', 'Asakura-shi'],
 ['JP', '07', 'Fukutsu-shi'],
 ['JP', '07', 'Kama-shi'],
 ['JP', '07', 'Maebaru-shi'],
 ['JP', '07', 'Miyama-shi'],
 ['JP', '07', 'Miyawa-shi'],
 ['JP', '07', 'N\xc5\x8dgata-shi'],
 ['JP', '07', 'Ukiha-shi'],
 ['JP', '43', 'Gob\xc5\x8d-shi'],
 ['JP', '43', 'Iwade-shi'],
 ['JP', '43', 'Kinokawa-shi'],
 ['JP', '28', 'Kitakatsuragi-gun'],
 ['JP', '28', 'Takaichi-gun'],
 ['JP', '28', 'Yamabe-gun'],
 ['JP', '22', 'Funai-gun'],
 ['JP', '22', 'Kuse-gun'],
 ['JP', '22', 'Otokuni-gun'],
 ['JP', '22', 'Tsuzuki-gun'],
 ['JP', '22', 'Miyazu-shi'],
 ['JP', '22', 'Muk\xc5\x8d-shi'],
 ['JP', '22', 'Yawata-shi'],
 ['JP', '22', 'Ky\xc5\x8dtango-shi'],
 ['JP', '22', 'Nantan-shi'],
 ['JP', '22', 'Ky\xc5\x8dtanabe-shi'],
 ['JP', '28', 'Katsuragi-shi'],
 ['JP', '28', 'Uda-shi'],
 ['JP', '21', 'Ashikita-gun'],
 ['JP', '21', 'Kamimashiki-gun'],
 ['JP', '21', 'Kamoto-gun'],
 ['JP', '21', 'Kuma-gun'],
 ['JP', '21', 'Shimomashiki-gun'],
 ['JP', '21', 'Yamaga-shi'],
 ['JP', '21', 'Kamiamakusa-shi'],
 ['JP', '21', 'Uki-shi'],
 ['JP', '21', 'Kou-shi'],
 ['JP', '25', 'Higashimorokata-gun'],
 ['JP', '25', 'Kitamorokata-gun'],
 ['JP', '25', 'Miyazaki-gun'],
 ['JP', '25', 'Nishimorokata-gun'],
 ['JP', '25', 'Nishiusuki-gun'],
 ['JP', '25', 'Kobayashi-shi'],
 ['JP', '30', 'Hayami-gun'],
 ['JP', '30', 'Higashikunisaki-gun'],
 ['JP', '30', 'Beppu-shi'],
 ['JP', '30', 'Bungo\xc5\x8dno-shi'],
 ['JP', '47', 'Miyako-gun'],
 ['JP', '47', 'Miyakoji-shi'],
 ['JP', '47', 'Nanj\xc5\x8d-shi'],
 ['JP', '47', 'Uruma-shi'],
 ['JP', '46', 'Minamitsuru-gun'],
 ['JP', '46', 'Nakakoma-gun'],
 ['JP', '46', 'Minami Alps-shi'],
 ['JP', '46', 'Hokuto-shi'],
 ['JP', '46', 'Fuefuki-shi'],
 ['JP', '46', 'K\xc5\x8dsh\xc5\xab-shi'],
 ['JP', '46', 'Ch\xc5\xab\xc5\x8d-shi'],
 ['JP', '26', 'Kamiminochi-gun'],
 ['JP', '26', 'Kiso-gun'],
 ['JP', '26', 'Chikuma-shi'],
 ['JP', '26', 'T\xc5\x8dmi-shi'],
 ['JP', '23', 'Inabe-gun'],
 ['JP', '23', 'Minamimuro-gun'],
 ['JP', '23', 'Taki-gun'],
 ['JP', '23', 'Inabe-shi'],
 ['JP', '23', 'Kameyama-shi'],
 ['JP', '37', 'Sh\xc5\xabchi-gun'],
 ['JP', '37', 'Izunokuni-shi'],
 ['JP', '37', 'Makinohara-shi'],
 ['JP', '37', 'Shimada-shi'],
 ['JP', '27', 'Got\xc5\x8d-shi'],
 ['JP', '27', 'Hirado-shi'],
 ['JP', '27', 'Minamishimabara-shi'],
 ['JP', '27', '\xc5\x8cmura-shi'],
 ['JP', '27', 'Saikai-shi'],
 ['JP', '27', 'Shimabara-shi'],
 ['JP', '27', 'Tsushima-shi'],
 ['JP', '27', 'Unzen-shi'],
 ['JP', '09', 'Ibi-gun'],
 ['JP', '09', '\xc5\x8cno-gun'],
 ['JP', '09', 'Y\xc5\x8dr\xc5\x8d-gun'],
 ['JP', '09', 'Guj\xc5\x8d-shi'],
 ['JP', '09', 'Hida-shi'],
 ['JP', '09', 'Mino-shi'],
 ['JP', '09', 'Mizuho-shi'],
 ['JP', '09', 'Motosu-shi'],
 ['JP', '09', 'Yamagata-shi'],
 ['JP', '12', 'Abashiri-gun'],
 ['JP', '12', 'Akan-gun'],
 ['JP', '12', 'Akkeshi-gun'],
 ['JP', '12', 'Ashoro-gun'],
 ['JP', '12', 'Esashi-gun'],
 ['JP', '12', 'Furuu-gun'],
 ['JP', '12', 'Futami-gun'],
 ['JP', '12', 'Hidaka-gun'],
 ['JP', '12', 'Horoizumi-gun'],
 ['JP', '12', 'Ishikari-gun'],
 ['JP', '12', 'Isoya-gun'],
 ['JP', '12', 'Kabato-gun'],
 ['JP', '12', 'Kasai-gun'],
 ['JP', '12', 'Kat\xc5\x8d-gun'],
 ['JP', '12', 'Kawakami-gun'],
 ['JP', '12', 'Kud\xc5\x8d-gun'],
 ['JP', '12', 'Mashike-gun'],
 ['JP', '12', 'Matsumae-gun'],
 ['JP', '12', 'Menashi-gun'],
 ['JP', '12', 'Monbetsu-gun'],
 ['JP', '12', 'Nakagawa-gun'],
 ['JP', '12', 'Nakagawa-gun'],
 ['JP', '12', 'Niikappu-gun'],
 ['JP', '12', 'Nishi-gun'],
 ['JP', '12', 'Notsuke-gun'],
 ['JP', '12', 'Rumoi-gun'],
 ['JP', '12', 'Samani-gun'],
 ['JP', '12', 'Saru-gun'],
 ['JP', '12', 'Setana-gun'],
 ['JP', '12', 'Shakotan-gun'],
 ['JP', '12', 'Shari-gun'],
 ['JP', '12', 'Shibetsu-gun'],
 ['JP', '12', 'Shimamaki-gun'],
 ['JP', '12', 'Shiranuka-gun'],
 ['JP', '12', 'Shiraoi-gun'],
 ['JP', '12', 'Sorachi-gun'],
 ['JP', '12', 'S\xc5\x8dya-gun'],
 ['JP', '12', 'Suttsu-gun'],
 ['JP', '12', 'Tokachi-gun'],
 ['JP', '12', 'Tokoro-gun'],
 ['JP', '12', 'Urukawa-gun'],
 ['JP', '12', 'Ury\xc5\xab-gun'],
 ['JP', '12', 'Usu-gun'],
 ['JP', '12', 'Yamakoshi-gun'],
 ['JP', '12', 'Y\xc5\xabbari-gun'],
 ['JP', '12', 'Y\xc5\xabfutsu-gun'],
 ['JP', '12', 'Hokuto-shi'],
 ['JP', '12', 'Ishikari-shi'],
 ['JP', '12', 'Monbetsu-shi'],
 ['JP', '12', 'Nayoro-shi'],
 ['JP', '03', 'Nakatsugaru-gun'],
 ['JP', '03', 'Hirakawa-shi'],
 ['JP', '03', 'Misawa Shi'],
 ['JP', '03', 'Tsugaru-shi'],
 ['JP', '16', 'Iwate-gun'],
 ['JP', '16', 'Nishiiwai-gun'],
 ['JP', '16', 'Shimohei-gun'],
 ['JP', '16', 'Hachimandai-shi'],
 ['JP', '16', '\xc5\x8csh\xc5\xab-shi'],
 ['JP', '16', 'Rikuzentakata-shi'],
 ['JP', '02', 'Ogachi-gun'],
 ['JP', '02', 'Daisen-shi'],
 ['JP', '02', 'Katagami-shi'],
 ['JP', '02', 'Kitaakita-shi'],
 ['JP', '02', 'Yurihonj\xc5\x8d-shi'],
 ['JP', '24', 'Igu-gun'],
 ['JP', '24', 'Kami-gun'],
 ['JP', '24', 'Oshika Gun'],
 ['JP', '24', 'T\xc5\x8dda-gun'],
 ['JP', '24', 'Watari-gun'],
 ['JP', '24', 'Higashimatshushima Shi'],
 ['JP', '24', 'Kakuda-shi'],
 ['JP', '24', '\xc5\x8csaki-shi'],
 ['JP', '44', 'Higashine-shi'],
 ['JP', '44', 'Obanazawa-shi'],
 ['JP', '44', 'Akumi-gun'],
 ['JP', '44', 'Kitamurayama-gun'],
 ['JP', '44', 'Tend\xc5\x8d-shi'],
 ['JP', '08', 'Futaba-gun'],
 ['JP', '08', 'Higashishirakawa-gun'],
 ['JP', '08', 'Ishikawa-gun'],
 ['JP', '08', 'Iwase-gun'],
 ['JP', '08', '\xc5\x8cnuma-gun'],
 ['JP', '08', 'Minamisouma-shi'],
 ['JP', '14', 'Band\xc5\x8d-shi'],
 ['JP', '14', 'Chikusei-shi'],
 ['JP', '14', 'Hitachi\xc5\x8dmiya-shi'],
 ['JP', '14', 'Hokota-shi'],
 ['JP', '14', 'Ishioka-shi'],
 ['JP', '14', 'Itako-shi'],
 ['JP', '14', 'J\xc5\x8ds\xc5\x8d-shi'],
 ['JP', '14', 'Namegata-shi'],
 ['JP', '14', 'Omitama-shi'],
 ['JP', '14', 'Takahagi-shi'],
 ['JP', '14', 'Tsukubamirai-shi'],
 ['JP', '14', 'Tsukuba-shi'],
 ['JP', '14', 'Ushiku-shi'],
 ['JP', '38', 'Nasukarasuyama-shi'],
 ['JP', '38', 'Nasushiobara-shi'],
 ['JP', '38', 'Sakura-shi'],
 ['JP', '38', 'Sano-shi'],
 ['JP', '38', 'Tochigi-shi'],
 ['JP', '10', 'Agatsuma-gun'],
 ['JP', '10', 'Tone-gun'],
 ['JP', '10', 'Annaka-shi'],
 ['JP', '10', 'Fujioka-shi'],
 ['JP', '10', 'Kiry\xc5\xab-shi'],
 ['JP', '10', 'Midoriku-shi'],
 ['JP', '10', 'Numata-shi'],
 ['JP', '10', 'Tatebayashi-shi'],
 ['JP', '34', 'Kodama-gun'],
 ['JP', '34', '\xc5\x8csato-gun'],
 ['JP', '34', 'Kitasaitama-gun'],
 ['JP', '34', 'Chichibu-shi'],
 ['JP', '34', 'Hany\xc5\xab-shi'],
 ['JP', '34', 'S\xc5\x8dka-shi'],
 ['JP', '34', 'Kuki-shi'],
 ['JP', '34', 'Kitamoto-shi'],
 ['JP', '34', 'Satte-shi'],
 ['JP', '34', 'Yoshikawa-shi'],
 ['JP', '34', 'Fujimino-shi'],
 ['JP', '04', 'Yotsukaid\xc5\x8d-shi'],
 ['JP', '04', 'Minamib\xc5\x8ds\xc5\x8d-shi'],
 ['JP', '04', 'S\xc5\x8dsa-shi'],
 ['JP', '04', 'Sanmu-shi'],
 ['JP', '04', 'Isumi-shi'],
 ['JP', '06', 'Yoshida-gun'],
 ['JP', '06', 'Nanj\xc5\x8d-gun'],
 ['JP', '06', 'Mikata-gun'],
 ['JP', '06', 'Mikatakaminaka-gun'],
 ['JP', '06', '\xc5\x8cno-shi'],
 ['JP', '06', 'Owara-shi'],
 ['JP', '06', 'Echizen-shi'],
 ['JP', '06', 'Sakai-shi'],
 ['JP', '15', 'Hakui-gun'],
 ['JP', '15', 'H\xc5\x8dsu-gun'],
 ['JP', '15', 'Kashima-gun'],
 ['JP', '15', 'Nanao-shi'],
 ['JP', '15', 'Kahoku-shi'],
 ['JP', '15', 'Hakusan-shi'],
 ['JP', '15', 'Nomi-shi'],
 ['JP', '29', 'Minamikanbara-gun'],
 ['JP', '29', 'Kita\xc5\x8dnuma-gun'],
 ['JP', '29', 'Minami\xc5\x8dnuma-gun'],
 ['JP', '29', 'Naka\xc5\x8dnuma-gun'],
 ['JP', '29', 'Kariwa-gun'],
 ['JP', '19', 'Aik\xc5\x8d-gun'],
 ['JP', '29', 'Murakami-shi'],
 ['JP', '29', 'Itoigawa-shi'],
 ['JP', '29', 'Agano-shi'],
 ['JP', '29', 'Uonuma-shi'],
 ['JP', '29', 'Minamiuonuma-shi'],
 ['JP', '29', 'Tainai-shi'],
 ['JP', '19', 'Zushi-shi'],
 ['JP', '19', 'Ebina-shi'],
 ['JP', '19', 'Minamiashigara-shi'],
 ['JP', '40', 'Bunky\xc5\x8d-ku'],
 ['JP', '40', 'Tait\xc5\x8d-ku'],
 ['JP', '40', 'Toshima-ku'],
 ['JP', '18', 'Kanoya-shi'],
 ['JP', '33', 'Karatsu-shi'],
 ['JP', '32', 'Moriguchi-shi'],
 ['JP', '37', 'It\xc5\x8d-shi'],
 ['JP', '37', 'Kakegawa-shi'],
 ['JP', '37', 'Kosai-shi'],
 ['JP', '27', 'Isahaya-shi'],
 ['JP', '12', 'Mikasa-shi'],
 ['JP', '24', 'Natori-shi'],
 ['JP', '24', 'Tagaj\xc5\x8d Shi'],
 ['JP', '14', 'Hitachinaka-shi'],
 ['JP', '14', 'Inashiki-shi'],
 ['JP', '14', 'Sakuragawa-shi'],
 ['JP', '34', 'Kumagaya-shi'],
 ['JP', '34', 'Kasukabe-shi'],
 ['JP', '34', 'Ageo-shi'],
 ['JP', '34', 'Shiki-shi'],
 ['JP', '04', 'Kisarazu-shi'],
 ['JP', '04', 'Yachimata-shi'],
 ['JP', '06', 'Sabae-shi'],
 ['JP', '40', 'Akiruno-shi'],
 ['JP', '40', 'Hachi\xc5\x8dji-shi'],
 ['JP', '40', 'Nishit\xc5\x8dky\xc5\x8d-shi'],
 ['KE', '06', 'Wajir District'],
 ['KE', '08', 'Uasin Gishu District'],
 ['KE', '08', 'Turkana District'],
 ['KE', '09', 'Trans Nzoia District'],
 ['KE', '01', 'Thika District'],
 ['KE', '03', 'Tharaka District'],
 ['KE', '02', 'Tana River District'],
 ['KE', '07', 'Siaya District'],
 ['KE', '08', 'Samburu District'],
 ['KE', '01', 'Murang\xe2\x80\x99a District'],
 ['KE', '02', 'Mombasa District'],
 ['KE', '03', 'Meru Central District'],
 ['KE', '03', 'Marsabit District'],
 ['KE', '06', 'Mandera District'],
 ['KE', '02', 'Lamu District'],
 ['KE', '08', 'Laikipia District'],
 ['KE', '02', 'Kwale District'],
 ['KE', '03', 'Kitui District'],
 ['KE', '07', 'Kisumu District'],
 ['KE', '07', 'Kisii District'],
 ['KE', '01', 'Kirinyaga District'],
 ['KE', '02', 'Kilifi District'],
 ['KE', '01', 'Kiambu District'],
 ['KE', '08', 'Kericho District'],
 ['KE', '09', 'Kakamega District'],
 ['KE', '03', 'Isiolo District'],
 ['KE', '06', 'Garissa District'],
 ['KE', '03', 'Embu District'],
 ['KE', '09', 'Busia District'],
 ['KE', '09', 'Bungoma District'],
 ['KE', '08', 'Baringo District'],
 ['KE', '07', 'Nyando District'],
 ['KE', '09', 'Teso District'],
 ['KE', '08', 'Nandi North District'],
 ['KE', '01', 'Nyandarua District'],
 ['KE', '07', 'Bondo District'],
 ['KE', '09', 'Butere/Mumias District'],
 ['KE', '09', 'Lugari District'],
 ['KE', '08', 'Mount Elgon'],
 ['KE', '09', 'Vihiga District'],
 ['KE', '02', 'Malindi District'],
 ['KE', '02', 'Lamu'],
 ['KE', '03', 'Machakos District'],
 ['KE', '03', 'Makueni District'],
 ['KE', '08', 'Marakwet District'],
 ['KE', '05', 'Nairobi District'],
 ['KE', '02', 'Taita Taveta District'],
 ['KE', '08', 'Kajiado District'],
 ['KE', '08', 'Trans Mara District'],
 ['KE', '01', 'Nyeri District'],
 ['KE', '03', 'Meru North District'],
 ['KE', '07', 'Homa Bay District'],
 ['KE', '08', 'Bomet District'],
 ['KE', '07', 'Gucha District'],
 ['KE', '03', 'Mwingi'],
 ['KE', '02', 'Kisii Central'],
 ['KE', '07', 'Migori District'],
 ['KE', '03', 'Mbeere District'],
 ['KE', '08', 'West Potok'],
 ['KE', '08', 'Keiyo'],
 ['KE', '08', 'Nakuru District'],
 ['KE', '08', 'Narok District'],
 ['KE', '01', 'Maragua District'],
 ['KE', '08', 'Buret District'],
 ['KE', '03', 'Moyale District'],
 ['KE', '03', 'Meru South District'],
 ['KE', '07', 'Suba District'],
 ['KE', '07', 'Rachuonyo District'],
 ['KE', '07', 'Nyamira District'],
 ['KE', '08', 'Koibatek District'],
 ['KE', '07', 'Kuria'],
 ['KE', '08', 'Nandi South District'],
 ['KE', '07', 'Central Kisii'],
 ['KE', '07', 'Nyamira'],
 ['KE', '03', 'Oloitokitok District'],
 ['KE', '06', 'Ijara District'],
 ['KG', '00', "Oshskaya Oblast'"],
 ['KG', '00', 'Kadamjaiskiy Raion'],
 ['KG', '06', 'Talas'],
 ['KG', '08', 'Kara-Kulzhinskiy Rayon'],
 ['KG', '02', 'Sokuluk'],
 ['KG', '02', 'Panfilov'],
 ['KG', '00', 'Naukatskiy Raion'],
 ['KG', '02', 'Moskva'],
 ['KG', '00', 'Nookenskiy Raion'],
 ['KG', '06', 'Bakay-Ata'],
 ['KG', '06', 'Kara-Buura'],
 ['KG', '02', 'Kemin'],
 ['KG', '02', 'Kant'],
 ['KG', '02', 'Ysyk-Ata'],
 ['KG', '02', 'Chuyskiy Rayon'],
 ['KG', '02', 'Alamedinskiy Rayon'],
 ['KG', '06', 'Kara Buura'],
 ['KG', '07', 'Ak-Su'],
 ['KG', '07', 'Jety-Oguz'],
 ['KG', '07', 'Issyk - Kulskaya, Kyrgyzstan'],
 ['KG', '04', 'Ak-Tala, Kyrgyzstan'],
 ['KG', '04', 'Tien Shan'],
 ['KG', '04', 'Jumgal'],
 ['KG', '02', 'Moskovsky Raion'],
 ['KG', '08', 'Uzgensky Raion'],
 ['KG', '03', 'Suzakskiy Raion'],
 ['KG', '03', 'Bazar-Korgonskiy Raion'],
 ['KG', '02', 'Ysyk-Ata'],
 ['KG', '', 'Aravan'],
 ['KG', '', 'Kara-Suu'],
 ['KG', '', 'Nookat'],
 ['KG', '', 'Suzak'],
 ['KG', '07', 'T\xc3\xbcp'],
 ['KG', '07', 'Jety-\xc3\x96g\xc3\xbcz'],
 ['KG', '03', '\xc3\x9cch-Terek'],
 ['KG', '03', 'Aksy'],
 ['KG', '03', 'Chatkal'],
 ['KG', '07', 'Tong'],
 ['KG', '07', 'Ysyk-K\xc3\xb6l'],
 ['KH', '05', 'Sr\xc5\x8fk Sto\xc5\xadng'],
 ['KH', '27', 'Sr\xc5\x8fk S\xc3\xa2mra\xc3\xb4ng'],
 ['KH', '13', 'Sr\xc5\x8fk R\xc3\xb4vi\xc4\x95ng'],
 ['KH', '04', 'Sr\xc5\x8fk \xc5\x8ed\xc5\x8fngk'],
 ['KH', '04', 'Sr\xc5\x8fk K\xc3\xb4ng P\xc4\xadsei'],
 ['KH', '05', 'Sr\xc5\x8fk K\xc3\xa2mp\xc3\xb3ng Svay'],
 ['KH', '13', 'Sr\xc5\x8fk Chh\xc3\xaab'],
 ['KH', '08', 'Sr\xc5\x8fk Batum Sak\xc3\xb4r'],
 ['KH', '27', 'Sr\xc5\x8fk B\xc3\xa2nt\xc3\xa9ay \xc3\x82mp\xc4\xadl'],
 ['KH', '03', 'Kampong Chhnang'],
 ['KH', '22', 'Phnom Penh'],
 ['KH', '05', 'Stueng Saen'],
 ['KH', '01', 'Svay Pao'],
 ['KH', '01', 'Sangkae'],
 ['KH', '01', 'Moung Ruessei'],
 ['KH', '12', 'Bakan'],
 ['KH', '12', 'Sampov Meas'],
 ['KH', '12', 'Krakor'],
 ['KH', '03', 'Baribour'],
 ['KH', '03', "Rolea B'ier"],
 ['KH', '09', 'Kracheh'],
 ['KH', '02', 'Cheung Prey'],
 ['KH', '05', 'Baray'],
 ['KH', '05', 'Santuk'],
 ['KH', '24', 'Siem Reab'],
 ['KH', '02', 'Ponhea Kraek'],
 ['KH', '02', 'Tboung Khmum'],
 ['KH', '02', 'Kampong Cham'],
 ['KH', '17', 'Stueng Traeng'],
 ['KH', '24', 'Angkor Chum'],
 ['KH', '24', 'Varin'],
 ['KH', '24', 'Svay Leu'],
 ['KH', '05', 'Strueng Saen'],
 ['KH', '05', 'Prasat Balangk'],
 ['KH', '05', 'Stroung'],
 ['KH', '13', 'Sangkom Thmei'],
 ['KI', '01', 'Abaiang'],
 ['KI', '01', 'Abemama'],
 ['KI', '01', 'Aranuka'],
 ['KI', '01', 'Arorae'],
 ['KI', '01', 'Banaba'],
 ['KI', '01', 'Beru'],
 ['KI', '03', 'Birnie'],
 ['KI', '01', 'Butaritari'],
 ['KI', '02', 'Caroline'],
 ['KI', '03', 'Enderbury'],
 ['KI', '02', 'Flint'],
 ['KI', '03', 'Kanton'],
 ['KI', '02', 'Kiritimati'],
 ['KI', '01', 'Kuria'],
 ['KI', '01', 'Maiana'],
 ['KI', '01', 'Makin'],
 ['KI', '02', 'Malden'],
 ['KI', '03', 'Manra'],
 ['KI', '01', 'Marakei'],
 ['KI', '03', 'McKean'],
 ['KI', '03', 'Nikumaroro'],
 ['KI', '01', 'Nikunau'],
 ['KI', '01', 'Nonouti'],
 ['KI', '01', 'Onotoa'],
 ['KI', '03', 'Orona'],
 ['KI', '03', 'Rawaki'],
 ['KI', '02', 'Starbuck'],
 ['KI', '01', 'Tabiteuea'],
 ['KI', '02', 'Tabuaeran'],
 ['KI', '01', 'Tamana'],
 ['KI', '01', 'Tarawa'],
 ['KI', '02', 'Teraina'],
 ['KI', '02', 'Vostok'],
 ['KP', '11', 'Yongch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '15', 'T\xc5\x8fkch\xe2\x80\x99\xc5\x8fn-si'],
 ['KP', '15', 'Kangs\xc5\x8f-guy\xc5\x8fk'],
 ['KP', '07', 'Y\xc5\x8fnt\xe2\x80\x99an-gun'],
 ['KP', '07', 'Y\xc5\x8fnsan-gun'],
 ['KP', '15', 'Ny\xc5\x8fngw\xc5\x8fn-gun'],
 ['KP', '12', 'Yongs\xc5\x8fng-guy\xc5\x8fk'],
 ['KP', '15', 'Yonggang-gun'],
 ['KP', '11', 'Ny\xc5\x8fngby\xc5\x8fn-gun'],
 ['KP', '06', 'Y\xc5\x8fnan-gun'],
 ['KP', '11', 'Y\xc5\x8fmju-gun'],
 ['KP', '12', 'Y\xc5\x8fkp\xe2\x80\x99o-guy\xc5\x8fk'],
 ['KP', '03', 'Yod\xc5\x8fk-kun'],
 ['KP', '15', 'Yangd\xc5\x8fk-kun'],
 ['KP', '09', 'W\xc5\x8fnsan-si'],
 ['KP', '07', '\xc5\xacnp\xe2\x80\x99a-gun'],
 ['KP', '11', 'Unj\xc5\x8fn-gun'],
 ['KP', '06', '\xc5\xacnch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '06', '\xc5\xacllyul-gun'],
 ['KP', '07', 'T\xe2\x80\x99osan-gun'],
 ['KP', '11', 'Tongnim-gun'],
 ['KP', '12', 'Tongdaew\xc5\x8fn-guy\xc5\x8fk'],
 ['KP', '09', 'T\xe2\x80\x99ongch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '06', 'T\xe2\x80\x99aet\xe2\x80\x99an-gun'],
 ['KP', '12', 'Taes\xc5\x8fng-guy\xc5\x8fk'],
 ['KP', '15', 'Taedong-gun'],
 ['KP', '12', 'Taedonggang-guy\xc5\x8fk'],
 ['KP', '11', 'T\xe2\x80\x99aech\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '12', 'S\xc5\xadngho-guy\xc5\x8fk'],
 ['KP', '15', 'Sunch\xe2\x80\x99\xc5\x8fn-si'],
 ['KP', '12', 'Sunan-guy\xc5\x8fk'],
 ['KP', '15', 'Sukch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '07', 'Suan-gun'],
 ['KP', '12', 'S\xc5\x8fs\xc5\x8fng-guy\xc5\x8fk'],
 ['KP', '12', 'S\xc5\x8fn\xe2\x80\x99gyo-guy\xc5\x8fk'],
 ['KP', '07', 'Songnim-si'],
 ['KP', '06', 'Songhwa-gun'],
 ['KP', '15', 'S\xc5\x8fngch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '11', 'S\xc5\x8fnch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '07', 'S\xc5\x8fh\xc5\xadng-gun'],
 ['KP', '15', 'Sinyang-gun'],
 ['KP', '06', 'Sinw\xc5\x8fn-gun'],
 ['KP', '07', 'Sinp\xe2\x80\x99y\xc5\x8fng-gun'],
 ['KP', '07', 'Sin\xe2\x80\x99gye-gun'],
 ['KP', '06', 'Sinch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '09', 'Sep\xe2\x80\x99o-gun'],
 ['KP', '07', 'Sariw\xc5\x8fn-si'],
 ['KP', '12', 'Sangw\xc5\x8fn-gun'],
 ['KP', '12', 'Sams\xc5\x8fk-kuy\xc5\x8fk'],
 ['KP', '06', 'Samch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '12', 'Sadong-guy\xc5\x8fk'],
 ['KP', '15', 'P\xe2\x80\x99y\xc5\x8fngw\xc5\x8fn-gun'],
 ['KP', '15', 'P\xe2\x80\x99y\xc5\x8fngs\xc5\x8fng-si'],
 ['KP', '07', 'P\xe2\x80\x99y\xc5\x8fngsan-gun'],
 ['KP', '09', 'P\xe2\x80\x99y\xc5\x8fnggang-gun'],
 ['KP', '12', 'P\xe2\x80\x99y\xc5\x8fngch\xe2\x80\x99\xc5\x8fn-guy\xc5\x8fk'],
 ['KP', '06', 'Pongch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '06', 'Py\xc5\x8fks\xc5\x8fng-gun'],
 ['KP', '15', 'Pukch\xe2\x80\x99ang-gun'],
 ['KP', '12', 'Pot\xe2\x80\x99onggang-guy\xc5\x8fk'],
 ['KP', '09', 'P\xc5\x8fptong-gun'],
 ['KP', '07', 'Pongsan-gun'],
 ['KP', '11', 'P\xe2\x80\x99ihy\xc5\x8fn-gun'],
 ['KP', '07', 'P\xe2\x80\x99anmun-gun'],
 ['KP', '09', 'P\xe2\x80\x99an\xe2\x80\x99gyo-gun'],
 ['KP', '11', 'Pakch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '06', 'Paech\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '06', 'Ongjin-gun'],
 ['KP', '15', 'Onch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '12', 'Nangnang-guy\xc5\x8fk'],
 ['KP', '03', 'Nagw\xc5\x8fn-gun'],
 ['KP', '15', 'Mund\xc5\x8fk-kun'],
 ['KP', '09', 'Munch\xe2\x80\x99\xc5\x8fn-si'],
 ['KP', '12', 'Moranbong-guy\xc5\x8fk'],
 ['KP', '12', 'Man\xe2\x80\x99gy\xc5\x8fngdae-kuy\xc5\x8fk'],
 ['KP', '15', 'Maengsan-gun'],
 ['KP', '11', 'Kwaksan-gun'],
 ['KP', '06', 'Kwail-gun'],
 ['KP', '11', 'Kus\xc5\x8fng-si'],
 ['KP', '03', 'K\xc5\xadmya-gun'],
 ['KP', '09', 'K\xc5\xadmgang-gun'],
 ['KP', '07', 'K\xc5\xadmch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '11', 'Kujang-gun'],
 ['KP', '03', 'Kow\xc5\x8fn-gun'],
 ['KP', '09', 'Kos\xc5\x8fng-gun'],
 ['KP', '09', 'Kosan-gun'],
 ['KP', '07', 'Koksan-gun'],
 ['KP', '09', 'Kimhwa-gun'],
 ['KP', '06', 'Kangny\xc5\x8fng-gun'],
 ['KP', '12', 'Kangnam-gun'],
 ['KP', '12', 'Kangdong-gun'],
 ['KP', '06', 'Kaes\xc5\x8fng-si'],
 ['KP', '06', 'Kaep\xe2\x80\x99ung-gun'],
 ['KP', '13', 'Kaech\xe2\x80\x99\xc5\x8fn-si'],
 ['KP', '07', 'Insan-gun'],
 ['KP', '09', 'Ich\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '12', 'Hy\xc5\x8fngjesan-guy\xc5\x8fk'],
 ['KP', '11', 'Hyangsan-gun'],
 ['KP', '07', 'Hwangju-gun'],
 ['KP', '09', 'Hoeyang-gun'],
 ['KP', '15', 'Hoech\xe2\x80\x99ang-gun'],
 ['KP', '03', 'Hamju-gun'],
 ['KP', '03', 'Hamh\xc5\xadng-si'],
 ['KP', '06', 'Haeju-si'],
 ['KP', '15', 'Ch\xc5\xadngsan-gun'],
 ['KP', '12', 'Chung-guy\xc5\x8fk'],
 ['KP', '12', 'Chunghwa-gun'],
 ['KP', '09', 'Ch\xe2\x80\x99\xc5\x8frw\xc5\x8fn-gun'],
 ['KP', '09', 'Ch\xe2\x80\x99\xc5\x8fnnae-gun'],
 ['KP', '03', 'Ch\xc5\x8fngp\xe2\x80\x99y\xc5\x8fng-gun'],
 ['KP', '15', 'Ch\xe2\x80\x99\xc5\x8fngnam-gu'],
 ['KP', '11', 'Ch\xc5\x8fngju-gun'],
 ['KP', '06', 'Ch\xe2\x80\x99\xc5\x8fngdan-gun'],
 ['KP', '11', 'Ch\xe2\x80\x99\xc5\x8flsan-gun'],
 ['KP', '06', 'Changy\xc5\x8fn-gun'],
 ['KP', '06', 'Changp\xe2\x80\x99ung-gun'],
 ['KP', '09', 'Ch\xe2\x80\x99angdo-gun'],
 ['KP', '06', 'Chaery\xc5\x8fng-gun'],
 ['KP', '15', 'Anju-si'],
 ['KP', '09', 'Anby\xc5\x8fn-gun'],
 ['KP', '06', 'Anak-kun'],
 ['KP', '15', 'Hanggu-guy\xc5\x8fk'],
 ['KP', '15', 'Waudo-guy\xc5\x8fk'],
 ['KP', '17', 'Y\xc5\x8fnsa-gun'],
 ['KP', '01', 'Yongnim-gun'],
 ['KP', '03', 'Y\xc5\x8fnggwang-gun'],
 ['KP', '01', 'Wiw\xc5\x8fn-gun'],
 ['KP', '01', 'Usi-gun'],
 ['KP', '11', 'Unsan-gun'],
 ['KP', '13', 'Unh\xc5\xadng-gun'],
 ['KP', '17', '\xc5\xacnd\xc5\x8fk-kun'],
 ['KP', '11', '\xc5\xaciju-gun'],
 ['KP', '01', 'Tongsin-gun'],
 ['KP', '11', 'Tongch\xe2\x80\x99ang-gun'],
 ['KP', '03', 'T\xc5\x8fks\xc5\x8fng-gun'],
 ['KP', '03', 'Tanch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '15', 'Taeh\xc5\xadng-gun'],
 ['KP', '13', 'Taehongdan-gun'],
 ['KP', '11', 'Taegwan-gun'],
 ['KP', '01', 'Songw\xc5\x8fn-gun'],
 ['KP', '01', 'S\xc5\x8fnggan-gun'],
 ['KP', '18', 'S\xc5\x8fnbong-gun'],
 ['KP', '11', 'Sin\xc5\xadiju-si'],
 ['KP', '03', 'Sinp\xe2\x80\x99o-si'],
 ['KP', '03', 'Sinh\xc5\xadng-gun'],
 ['KP', '01', 'Sijung-gun'],
 ['KP', '13', 'Samsu-gun'],
 ['KP', '13', 'Samjiy\xc5\x8fn-gun'],
 ['KP', '11', 'Sakchu-gun'],
 ['KP', '17', 'Saeby\xc5\x8fl-gun'],
 ['KP', '11', 'Py\xc5\x8fktong-gun'],
 ['KP', '17', 'Pury\xc5\x8fng-gun'],
 ['KP', '13', 'P\xe2\x80\x99ungs\xc5\x8f-gun'],
 ['KP', '13', 'Kimhy\xc5\x8fnggw\xc5\x8fn-gun'],
 ['KP', '03', 'Pukch\xe2\x80\x99\xc5\x8fng-gun'],
 ['KP', '00', 'Puj\xc5\x8fn-gun'],
 ['KP', '13', 'Poch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '13', 'Paegam-gun'],
 ['KP', '17', '\xc5\x8erang-gun'],
 ['KP', '17', 'Ons\xc5\x8fng-gun'],
 ['KP', '01', 'Nangnim-gun'],
 ['KP', '18', 'Najin-guy\xc5\x8fk'],
 ['KP', '17', 'Hwas\xc5\x8fng-gun'],
 ['KP', '17', 'My\xc5\x8fngch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '17', 'Musan-gun'],
 ['KP', '01', 'Manp\xe2\x80\x99o-si'],
 ['KP', '17', 'Ky\xc5\x8fngs\xc5\x8fng-gun'],
 ['KP', '01', 'Kop\xe2\x80\x99ung-gun'],
 ['KP', '13', 'Kimj\xc5\x8fngsuk-kun'],
 ['KP', '17', 'Kimch\xe2\x80\x99aek-si'],
 ['KP', '17', 'Kilchu-gun'],
 ['KP', '13', 'Kapsan-gun'],
 ['KP', '01', 'Kanggye-si'],
 ['KP', '03', 'Iw\xc5\x8fn-gun'],
 ['KP', '13', 'Hyesan-si'],
 ['KP', '01', 'Hwap\xe2\x80\x99y\xc5\x8fng-gun'],
 ['KP', '17', 'Hwadae-gun'],
 ['KP', '01', 'H\xc5\xadich\xe2\x80\x99\xc5\x8fn-si'],
 ['KP', '13', 'Kimhy\xc5\x8fngjik-kun'],
 ['KP', '03', 'Hongw\xc5\x8fn-gun'],
 ['KP', '17', 'Hoery\xc5\x8fng-si'],
 ['KP', '03', 'H\xc5\x8fch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '01', 'Chunggang-gun'],
 ['KP', '01', 'Ch\xe2\x80\x99osan-gun'],
 ['KP', '11', 'Ch\xe2\x80\x99\xc5\x8fnma-gun'],
 ['KP', '17', 'Ch\xe2\x80\x99\xc5\x8fngjin-si'],
 ['KP', '01', 'Ch\xc5\x8fnch\xe2\x80\x99\xc5\x8fn-gun'],
 ['KP', '01', 'Chas\xc5\x8fng-gun'],
 ['KP', '11', 'Ch\xe2\x80\x99angs\xc5\x8fng-gun'],
 ['KP', '03', 'Changjin-gun'],
 ['KP', '01', 'Changgang-gun'],
 ['KP', '15', '\xc5\xacnsan-gun'],
 ['KP', '15', 'Ch\xe2\x80\x99\xc5\x8fllima-guy\xc5\x8fk'],
 ['KP', '15', 'Taean-guy\xc5\x8fk'],
 ['KP', '03', 'Sudong-gu'],
 ['KP', '11', 'Sindo-gun'],
 ['KR', '00', 'Yongsan-gu'],
 ['KR', '13', 'Yongin-si'],
 ['KR', '14', 'Pohang-si'],
 ['KR', '00', 'Yeonggwang Gun'],
 ['KR', '00', 'Yeongdeungpo-gu'],
 ['KR', '05', 'Yeongdong Gun'],
 ['KR', '06', 'Yangyang-gun'],
 ['KR', '00', 'Yangsan-gun'],
 ['KR', '14', 'Gyeongju-si'],
 ['KR', '16', 'Wando-gun'],
 ['KR', '11', 'Eunpyeong-gu'],
 ['KR', '14', 'Ulleung-gun'],
 ['KR', '14', 'Uljin-gun'],
 ['KR', '00', 'Tongnae-gun'],
 ['KR', '11', 'Dongjak-gu'],
 ['KR', '06', 'Donghae-si'],
 ['KR', '13', 'Dongducheon-si'],
 ['KR', '11', 'Dongdaemun-gu'],
 ['KR', '00', 'Dobong-gu'],
 ['KR', '05', 'Tanyang-gun'],
 ['KR', '00', 'Dalseong gun'],
 ['KR', '16', 'Suncheon'],
 ['KR', '17', 'Susan'],
 ['KR', '13', 'Seongnam-si'],
 ['KR', '14', 'Seongju-gun'],
 ['KR', '00', 'Gangdong-gu'],
 ['KR', '00', 'Gangbuk-gu'],
 ['KR', '01', 'Seogwipo-si'],
 ['KR', '00', 'S\xc5\x8fdaemun-gu'],
 ['KR', '16', 'Sinan-gun'],
 ['KR', '13', 'Siheung-si'],
 ['KR', '14', 'Sangju-si'],
 ['KR', '13', 'Pyeongtaek-si'],
 ['KR', '06', 'Pyeongchang-gun'],
 ['KR', '00', 'Huyo'],
 ['KR', '01', 'Bukjeju-gun'],
 ['KR', '13', 'Bucheon-si'],
 ['KR', '05', 'Bo-eun Gun'],
 ['KR', '00', 'Boseong gun'],
 ['KR', '17', 'Honei-gun'],
 ['KR', '14', 'Bonghwa'],
 ['KR', '13', 'Pocheon-si'],
 ['KR', '13', 'Paju-si'],
 ['KR', '00', 'Okku-gun'],
 ['KR', '05', 'Ogcheon gun'],
 ['KR', '13', 'Namyangju-si'],
 ['KR', '03', 'Namwon-si'],
 ['KR', '01', 'Namjeju-gun'],
 ['KR', '16', 'Naju-gun'],
 ['KR', '00', 'Miryang-gun'],
 ['KR', '00', 'Mapo-gu'],
 ['KR', '00', 'Kwangyang-gun'],
 ['KR', '00', 'Kwangsan-gun'],
 ['KR', '00', 'Gwanak-gu'],
 ['KR', '00', 'Guro-gu'],
 ['KR', '13', 'Gimpo-si'],
 ['KR', '03', 'Gimje-si'],
 ['KR', '14', 'Gumi-si'],
 ['KR', '13', 'Goyang-si'],
 ['KR', '06', 'Kos\xc5\x8fng-gun'],
 ['KR', '20', 'Goseong gun'],
 ['KR', '14', 'Goryeong-gun'],
 ['KR', '00', 'Goheung gun'],
 ['KR', '00', 'Koesan-gun'],
 ['KR', '00', 'Geochang gun'],
 ['KR', '00', "Koch'ang-gun"],
 ['KR', '00', 'Gangseo-gu'],
 ['KR', '11', 'Gangnam-gu'],
 ['KR', '00', 'Kanghwa-gun'],
 ['KR', '11', 'Gangdong-gu'],
 ['KR', '03', 'Imsil-gun'],
 ['KR', '03', 'Iksan-si'],
 ['KR', '16', 'Hwasun-gun'],
 ['KR', '00', 'Hongseong Gun'],
 ['KR', '00', 'Habcheon gun'],
 ['KR', '00', 'Hamyang-gun'],
 ['KR', '00', 'Haman-gun'],
 ['KR', '14', 'Yeongju-si'],
 ['KR', '20', 'T\xe2\x80\x99ongy\xc5\x8fng-si'],
 ['KR', '00', 'Jung-gu'],
 ['KR', '06', 'Chuncheon-si'],
 ['KR', '06', 'Cheorwon-gun'],
 ['KR', '00', 'Tenan-gun'],
 ['KR', '00', 'Cheongyang gun'],
 ['KR', '06', 'Jeongseon-gun'],
 ['KR', '00', 'Jongno-gu'],
 ['KR', '14', 'Cheongdo-gun'],
 ['KR', '00', 'Chinyang-gun'],
 ['KR', '16', 'Chindo-gun'],
 ['KR', '14', 'Chilgok-gun'],
 ['KR', '01', 'Jeju-si'],
 ['KR', '05', 'Teisen-gun'],
 ['KR', '00', 'Changweon gun'],
 ['KR', '03', 'Jangsu-gun'],
 ['KR', '00', 'Jangseong gun'],
 ['KR', '00', 'Asan-gun'],
 ['KR', '13', 'Anyang-si'],
 ['KR', '11', 'Seongdong-gu'],
 ['KR', '11', 'Gwangjin-gu'],
 ['KR', '11', 'Jungnang-gu'],
 ['KR', '11', 'Nowon-gu'],
 ['KR', '11', 'Seongbuk-gu'],
 ['KR', '11', 'Yangcheon-gu'],
 ['KR', '11', 'Geumcheon-gu'],
 ['KR', '11', 'Seocho-gu'],
 ['KR', '11', 'Songpa-gu'],
 ['KZ', '07', 'Zelenoe A\xc5\xabdany'],
 ['KZ', '09', 'Qaraq\xc4\xabya A\xc5\xabdany'],
 ['KZ', '07', 'Orda A\xc5\xabdany'],
 ['KZ', '04', 'Oyyl A\xc5\xabdany'],
 ['KZ', '07', 'Terekti A\xc5\xabdany'],
 ['KZ', '04', 'Temir A\xc5\xabdany'],
 ['KZ', '07', 'Taypaq A\xc5\xabdany'],
 ['KZ', '07', 'Pr\xc4\xab\xc5\xabral\xe2\x80\x99e A\xc5\xabdany'],
 ['KZ', '04', 'Oktyabr\xe2\x80\x99sk A\xc5\xabdany'],
 ['KZ', '04', 'Khromta\xc5\xab A\xc5\xabdany'],
 ['KZ', '06', '\xc4\xaasatay A\xc5\xabdany'],
 ['KZ', '04', 'Mughalzhar A\xc5\xabdany'],
 ['KZ', '04', 'Mortyq A\xc5\xabdany'],
 ['KZ', '09', 'Mangghysta\xc5\xab A\xc5\xabdany'],
 ['KZ', '06', 'Makhambet A\xc5\xabdany'],
 ['KZ', '06', 'Maqat A\xc5\xabdany'],
 ['KZ', '04', 'Leninskiy Rayon'],
 ['KZ', '06', 'Qyzylqogha A\xc5\xabdany'],
 ['KZ', '04', 'Qobda A\xc5\xabdany'],
 ['KZ', '07', 'Kaztalovka A\xc5\xabdany'],
 ['KZ', '07', 'Qarat\xc3\xb6be A\xc5\xabdany'],
 ['KZ', '07', 'Tasqala A\xc5\xabdany'],
 ['KZ', '04', '\xc4\xaasatay A\xc5\xabdany'],
 ['KZ', '06', '\xc4\xaander A\xc5\xabdany'],
 ['KZ', '07', 'Zhalpaqtal A\xc5\xabdany'],
 ['KZ', '06', 'Zhylyoy A\xc5\xabdany'],
 ['KZ', '07', 'Zh\xc3\xa4nibek A\xc5\xabdany'],
 ['KZ', '07', 'Zhangaqala A\xc5\xabdany'],
 ['KZ', '07', 'Syrym A\xc5\xabdany'],
 ['KZ', '06', 'Kurmanghazy A\xc5\xabdany'],
 ['KZ', '07', 'Shyngghyrla\xc5\xab A\xc5\xabdany'],
 ['KZ', '04', 'Shalqar A\xc5\xabdany'],
 ['KZ', '07', 'Chapaev A\xc5\xabdany'],
 ['KZ', '07', 'B\xc3\xb6rili A\xc5\xabdany'],
 ['KZ', '09', 'Beyne\xc5\xab A\xc5\xabdany'],
 ['KZ', '04', 'Bayghan\xc4\xabn A\xc5\xabdany'],
 ['KZ', '06', 'Balyqshy A\xc5\xabdany'],
 ['KZ', '04', 'Algha A\xc5\xabdany'],
 ['KZ', '07', 'Aqzhayyq A\xc5\xabdany'],
 ['KZ', '04', 'Aqt\xc3\xb6be A\xc5\xabdany'],
 ['KZ', '07', 'Oral Qalasy'],
 ['KZ', '06', 'Atyra\xc5\xab Qalasy'],
 ['KZ', '09', 'Tupqaraghan A\xc5\xabdany'],
 ['KZ', '09', 'Aqta\xc5\xab Qalasy'],
 ['KZ', '09', 'Zhanga\xc3\xb6zen Qalasy'],
 ['KZ', '04', 'Aqt\xc3\xb6be Qalasy'],
 ['KZ', '15', 'Zyryanovsk A\xc5\xabdany'],
 ['KZ', '11', 'Zhelez\xc4\xabnka A\xc5\xabdany'],
 ['KZ', '15', 'Zharma A\xc5\xabdany'],
 ['KZ', '15', 'Zhangasemey A\xc5\xabdany'],
 ['KZ', '03', 'Zhangadala A\xc5\xabdany'],
 ['KZ', '12', 'Zhangaarqa A\xc5\xabdany'],
 ['KZ', '03', 'Zhaqsy A\xc5\xabdany'],
 ['KZ', '16', 'Zerendi A\xc5\xabdany'],
 ['KZ', '15', 'Zaysan A\xc5\xabdany'],
 ['KZ', '03', 'Esil A\xc5\xabdany'],
 ['KZ', '03', 'Ereymenta\xc5\xab A\xc5\xabdany'],
 ['KZ', '11', 'Aqs\xc5\xab A\xc5\xabdany'],
 ['KZ', '12', 'Qazybek B\xc4\xab A\xc5\xabdany'],
 ['KZ', '14', 'Zhangaqorghan A\xc5\xabdany'],
 ['KZ', '16', 'Vozvyshenka A\xc5\xabdany'],
 ['KZ', '16', 'Ayyrta\xc5\xab A\xc5\xabdany'],
 ['KZ', '03', 'Arshaly A\xc5\xabdany'],
 ['KZ', '16', '\xc5\xaa\xc3\xa4l\xc4\xabkhanov A\xc5\xabdany'],
 ['KZ', '01', '\xc3\x9cyghyr A\xc5\xabdany'],
 ['KZ', '11', '\xc5\xaaspenka A\xc5\xabdany'],
 ['KZ', '13', '\xc5\xaar\xc4\xabtsk\xc4\xaby A\xc5\xabdany'],
 ['KZ', '15', '\xc3\x9crzhar A\xc5\xabdany'],
 ['KZ', '12', 'Ulyta\xc5\xab A\xc5\xabdany'],
 ['KZ', '12', '\xc5\xaal\xe2\x80\x99yanov A\xc5\xabdany'],
 ['KZ', '15', 'Ulan A\xc5\xabdany'],
 ['KZ', '10', 'T\xc3\xbclkibas A\xc5\xabdany'],
 ['KZ', '10', 'T\xc3\xbcrkistan A\xc5\xabdany'],
 ['KZ', '03', 'Tsel\xc4\xabnograd A\xc5\xabdany'],
 ['KZ', '16', 'T\xc4\xabm\xc4\xabryazev A\xc5\xabdany'],
 ['KZ', '14', 'Tereng\xc3\xb6zek A\xc5\xabdany'],
 ['KZ', '12', 'Tengiz A\xc5\xabdany'],
 ['KZ', '12', 'Tel\xe2\x80\x99man A\xc5\xabdany'],
 ['KZ', '15', 'Tavr\xc4\xabya A\xc5\xabdany'],
 ['KZ', '15', 'Taskesken A\xc5\xabdany'],
 ['KZ', '15', 'Tarbaghatay A\xc5\xabdany'],
 ['KZ', '13', 'Taranovskiy Rayon'],
 ['KZ', '01', 'Talghar A\xc5\xabdany'],
 ['KZ', '01', 'Taldyqorghan A\xc5\xabdany'],
 ['KZ', '17', 'Talas A\xc5\xabdany'],
 ['KZ', '14', 'Syrdar\xc4\xabya A\xc5\xabdany'],
 ['KZ', '17', 'Sverdlov A\xc5\xabdany'],
 ['KZ', '10', 'Sozaq A\xc5\xabdany'],
 ['KZ', '16', 'Sovet A\xc5\xabdany'],
 ['KZ', '16', 'Sokolovka A\xc5\xabdany'],
 ['KZ', '03', 'Shortandy A\xc5\xabdany'],
 ['KZ', '12', 'Shet A\xc5\xabdany'],
 ['KZ', '15', 'Shemona\xc4\xabkha A\xc5\xabdany'],
 ['KZ', '16', 'Shch\xc5\xabch\xc4\xabnsk A\xc5\xabdany'],
 ['KZ', '11', 'Sharbaqty A\xc5\xabdany'],
 ['KZ', '16', 'Sergeevka A\xc5\xabdany'],
 ['KZ', '13', 'Semioz\xc3\xabrnyy Rayon'],
 ['KZ', '03', 'Sileti A\xc5\xabdany'],
 ['KZ', '10', 'Sayram A\xc5\xabdany'],
 ['KZ', '17', 'Sarys\xc5\xab A\xc5\xabdany'],
 ['KZ', '10', 'Saryaghash A\xc5\xabdany'],
 ['KZ', '01', 'Sarqan A\xc5\xabdany'],
 ['KZ', '15', 'Samarskoe A\xc5\xabdany'],
 ['KZ', '16', 'R\xc5\xabzaevka A\xc5\xabdany'],
 ['KZ', '16', 'Presnovka A\xc5\xabdany'],
 ['KZ', '11', 'Pavlodar A\xc5\xabdany'],
 ['KZ', '01', 'Panf\xc4\xablov A\xc5\xabdany'],
 ['KZ', '10', 'Maqtaaral A\xc5\xabdany'],
 ['KZ', '12', 'Osakarovka A\xc5\xabdany'],
 ['KZ', '13', 'Ordzhon\xc4\xabk\xc4\xabdze A\xc5\xabdany'],
 ['KZ', '12', 'Nura A\xc5\xabdany'],
 ['KZ', '15', 'Novosh\xc5\xabl\xe2\x80\x99ba A\xc5\xabdany'],
 ['KZ', '13', 'Na\xc5\xabryzym A\xc5\xabdany'],
 ['KZ', '01', 'Rayymbek A\xc5\xabdany'],
 ['KZ', '17', 'Moyynqum A\xc5\xabdany'],
 ['KZ', '16', 'Moskva A\xc5\xabdany'],
 ['KZ', '12', 'Molodezhnyy A\xc5\xabdany'],
 ['KZ', '12', 'M\xc4\xabch\xc5\xabr\xc4\xabn A\xc5\xabdany'],
 ['KZ', '17', 'Merke A\xc5\xabdany'],
 ['KZ', '11', 'May A\xc5\xabdany'],
 ['KZ', '15', 'Marqak\xc3\xb6l A\xc5\xabdany'],
 ['KZ', '16', 'Mamlyutka A\xc5\xabdany'],
 ['KZ', '03', 'Bulandy A\xc5\xabdany'],
 ['KZ', '15', 'Maqanshy A\xc5\xabdany'],
 ['KZ', '17', 'L\xc5\xabgovoe A\xc5\xabdany'],
 ['KZ', '16', 'Len\xc4\xabn A\xc5\xabdany'],
 ['KZ', '10', 'Qazyqurt A\xc5\xabdany'],
 ['KZ', '13', 'Len\xc4\xabn A\xc5\xabdany'],
 ['KZ', '16', 'Len\xc4\xabn A\xc5\xabdany'],
 ['KZ', '16', 'Len\xc4\xabngrad A\xc5\xabdany'],
 ['KZ', '10', 'T\xc3\xb6le B\xc4\xab A\xc5\xabdany'],
 ['KZ', '11', 'Lebyazh\xe2\x80\x99e A\xc5\xabdany'],
 ['KZ', '16', 'Qyzylt\xc5\xab A\xc5\xabdany'],
 ['KZ', '10', 'Otyrar A\xc5\xabdany'],
 ['KZ', '16', 'K\xc5\xabybyshev A\xc5\xabdany'],
 ['KZ', '13', 'Kustanayskiy Rayon'],
 ['KZ', '01', 'K\xc3\xbcrti A\xc5\xabdany'],
 ['KZ', '03', 'Qorghalzhyn A\xc5\xabdany'],
 ['KZ', '17', 'Qorday A\xc5\xabdany'],
 ['KZ', '15', 'K\xc3\xbcrshim A\xc5\xabdany'],
 ['KZ', '03', 'Egindik\xc3\xb6l A\xc5\xabdany'],
 ['KZ', '11', 'Aqtoghay A\xc5\xabdany'],
 ['KZ', '16', 'Krasnoarmeysk A\xc5\xabdany'],
 ['KZ', '13', 'Komsomol A\xc5\xabdany'],
 ['KZ', '04', 'B\xc3\xb6getk\xc3\xb6l A\xc5\xabdany'],
 ['KZ', '15', 'K\xc3\xb6kpekti A\xc5\xabdany'],
 ['KZ', '16', 'K\xc3\xb6ksheta\xc5\xab A\xc5\xabdany'],
 ['KZ', '03', 'Q\xc4\xabma A\xc5\xabdany'],
 ['KZ', '01', 'K\xc3\xb6ks\xc5\xab A\xc5\xabdany'],
 ['KZ', '10', 'K\xc4\xabrov A\xc5\xabdany'],
 ['KZ', '01', 'Kerbulaq A\xc5\xabdany'],
 ['KZ', '16', 'Kellerovka A\xc5\xabdany'],
 ['KZ', '10', 'Keles A\xc5\xabdany'],
 ['KZ', '01', 'Kegen A\xc5\xabdany'],
 ['KZ', '14', 'Qazaly A\xc5\xabdany'],
 ['KZ', '15', 'Qotanqaraghay A\xc5\xabdany'],
 ['KZ', '01', 'Qaskeleng A\xc5\xabdany'],
 ['KZ', '14', 'Qarmaqshy A\xc5\xabdany'],
 ['KZ', '12', 'Qarqaraly A\xc5\xabdany'],
 ['KZ', '01', 'Qaratal A\xc5\xabdany'],
 ['KZ', '13', 'Qaras\xc5\xab A\xc5\xabdany'],
 ['KZ', '04', '\xc3\x84yteke B\xc4\xab A\xc5\xabdany'],
 ['KZ', '01', 'Qapal A\xc5\xabdany'],
 ['KZ', '13', 'Qamysty A\xc5\xabdany'],
 ['KZ', '11', 'Kach\xc4\xabry A\xc5\xabdany'],
 ['KZ', '11', 'Ertis A\xc5\xabdany'],
 ['KZ', '04', 'Yrghyz A\xc5\xabdany'],
 ['KZ', '01', 'Ile A\xc5\xabdany'],
 ['KZ', '01', 'Gvard\xc4\xabya A\xc5\xabdany'],
 ['KZ', '15', 'Gl\xc5\xabbokoe A\xc5\xabdany'],
 ['KZ', '13', 'Fedorovka A\xc5\xabdany'],
 ['KZ', '16', '\xc4\x96ngbekshilder A\xc5\xabdany'],
 ['KZ', '01', 'Engbekshiqazaq A\xc5\xabdany'],
 ['KZ', '11', 'Ekibastuz A\xc5\xabdany'],
 ['KZ', '17', 'Zh\xc5\xabaly A\xc5\xabdany'],
 ['KZ', '12', 'Zhezdi A\xc5\xabdany'],
 ['KZ', '10', 'Zhetisay A\xc5\xabdany'],
 ['KZ', '13', 'Zhetiqara A\xc5\xabdany'],
 ['KZ', '13', 'Zhangeld\xc4\xabn A\xc5\xabdany'],
 ['KZ', '01', 'Zhambyl A\xc5\xabdany'],
 ['KZ', '17', 'Zhambyl A\xc5\xabdany'],
 ['KZ', '16', 'Zhambyl A\xc5\xabdany'],
 ['KZ', '14', 'Zhalaghash A\xc5\xabdany'],
 ['KZ', '03', 'Zharqayyng A\xc5\xabdany'],
 ['KZ', '17', 'Sh\xc5\xab A\xc5\xabdany'],
 ['KZ', '15', 'Shubarta\xc5\xab A\xc5\xabdany'],
 ['KZ', '16', 'Chkalov A\xc5\xabdany'],
 ['KZ', '16', 'Ch\xc4\xabstopol\xe2\x80\x99e A\xc5\xabdany'],
 ['KZ', '01', 'Shelek A\xc5\xabdany'],
 ['KZ', '14', 'Sh\xc4\xabeli A\xc5\xabdany'],
 ['KZ', '15', 'Shar A\xc5\xabdany'],
 ['KZ', '10', 'Shardara A\xc5\xabdany'],
 ['KZ', '01', 'B\xc3\xb6rilit\xc3\xb6be A\xc5\xabdany'],
 ['KZ', '16', 'B\xc5\xablaevo A\xc5\xabdany'],
 ['KZ', '10', 'Ordabasy A\xc5\xabdany'],
 ['KZ', '13', 'Mendykarinskiy Rayon'],
 ['KZ', '15', 'Borod\xc5\xabl\xc4\xabkha A\xc5\xabdany'],
 ['KZ', '15', '\xc3\x9clkennaryn A\xc5\xabdany'],
 ['KZ', '16', 'Besk\xc3\xb6l A\xc5\xabdany'],
 ['KZ', '15', 'Besqaraghay A\xc5\xabdany'],
 ['KZ', '11', 'Bayana\xc5\xabyl A\xc5\xabdany'],
 ['KZ', '01', 'Balqash A\xc5\xabdany'],
 ['KZ', '03', 'Sandyqta\xc5\xab A\xc5\xabdany'],
 ['KZ', '15', 'Ayak\xc3\xb6z Qalasy'],
 ['KZ', '02', 'Auezovskiy Rayon'],
 ['KZ', '03', 'Atbasar A\xc5\xabdany'],
 ['KZ', '03', 'Astrakhan A\xc5\xabdany'],
 ['KZ', '16', 'Aryqbalyq A\xc5\xabdany'],
 ['KZ', '13', 'Arqalyq A\xc5\xabdany'],
 ['KZ', '14', 'Aral A\xc5\xabdany'],
 ['KZ', '01', '\xc3\x9cygentas A\xc5\xabdany'],
 ['KZ', '13', 'Amantoghay A\xc5\xabdany'],
 ['KZ', '13', 'Amangeldi A\xc5\xabdany'],
 ['KZ', '10', 'Alghabas A\xc5\xabdany'],
 ['KZ', '03', 'Aqk\xc3\xb6l A\xc5\xabdany'],
 ['KZ', '01', 'Alak\xc3\xb6l A\xc5\xabdany'],
 ['KZ', '12', 'Aqtoghay A\xc5\xabdany'],
 ['KZ', '01', 'Aqs\xc5\xab A\xc5\xabdany'],
 ['KZ', '15', 'Aqs\xc5\xabat A\xc5\xabdany'],
 ['KZ', '12', 'Aqadyr A\xc5\xabdany'],
 ['KZ', '15', 'Abay A\xc5\xabdany'],
 ['KZ', '13', 'Altynsarinskiy Rayon'],
 ['KZ', '13', 'Qostanay Qalasy'],
 ['KZ', '13', 'Zhetiqara Qalasy'],
 ['KZ', '13', 'L\xc4\xabsakovsk Qalasy'],
 ['KZ', '13', 'R\xc5\xabdnyy Qalasy'],
 ['KZ', '13', 'Oktyabr\xe2\x80\x99 A\xc5\xabdany'],
 ['KZ', '12', 'Toqyra\xc5\xabyn A\xc5\xabdany'],
 ['KZ', '12', 'Zhezqazghan Qalasy'],
 ['KZ', '12', 'Balqash Qalasy'],
 ['KZ', '12', 'Qarazhal Qalasy'],
 ['KZ', '12', 'Qalasy S\xc3\xa4tbaev'],
 ['KZ', '16', 'K\xc3\xb6ksheta\xc5\xab Qalasy'],
 ['KZ', '16', 'Shch\xc5\xabch\xc4\xabnsk Qalasy'],
 ['KZ', '03', 'Aqmola Qalasy'],
 ['KZ', '03', 'Atbasar Qalasy'],
 ['KZ', '03', 'Stepnogorsk Qalasy'],
 ['KZ', '12', 'Qaraghandy Qalasy'],
 ['KZ', '12', 'Abay Qalasy'],
 ['KZ', '12', 'Sorang Qalasy'],
 ['KZ', '12', 'Temirta\xc5\xab Qalasy'],
 ['KZ', '12', 'Shakht\xc4\xabnsk Qalasy'],
 ['KZ', '10', 'Arys A\xc5\xabdany'],
 ['KZ', '10', 'Shymkent Qalasy'],
 ['KZ', '10', 'Arys Qalasy'],
 ['KZ', '10', 'Kenta\xc5\xab Qalasy'],
 ['KZ', '10', 'Lenger Qalasy'],
 ['KZ', '10', 'T\xc3\xbcrkistan Qalasy'],
 ['KZ', '17', 'Zhambyl Qalasy'],
 ['KZ', '17', 'Zhangatas Qalasy'],
 ['KZ', '17', 'Qarata\xc5\xab Qalasy'],
 ['KZ', '17', 'Sh\xc5\xab Qalasy'],
 ['KZ', '01', 'Qapshaghay Qalasy'],
 ['KZ', '01', 'Talghar Qalasy'],
 ['KZ', '01', 'Taldyqorghan Qalasy'],
 ['KZ', '01', 'Tekeli Qalasy'],
 ['KZ', '15', 'Semey Qalasy'],
 ['KZ', '15', '\xc3\x96skemen Qalasy'],
 ['KZ', '15', 'Zyryanovsk Qalasy'],
 ['KZ', '15', 'Len\xc4\xabnogorsk Qalasy'],
 ['KZ', '15', 'Serebryansk Qalasy'],
 ['KZ', '11', 'Pavlodar Qalasy'],
 ['KZ', '11', 'Aqs\xc5\xab Qalasy'],
 ['KZ', '11', 'Ekibastuz Qalasy'],
 ['KZ', '15', 'Abyraly A\xc5\xabdany'],
 ['LA', '22', 'Muang Houayxay'],
 ['LA', '13', 'Muang Ngeun'],
 ['LA', '14', 'Muang Xiangkhoang'],
 ['LA', '03', 'Muang Xiengkhor'],
 ['LA', '13', 'Muang Xianghon'],
 ['LA', '20', 'Muang X\xc3\xa9p\xc3\xb4n'],
 ['LA', '07', 'Muang Xai'],
 ['LA', '03', 'Muang Xam Nua'],
 ['LA', '13', 'Muang Xaignabouli'],
 ['LA', '19', 'Muang Vapi'],
 ['LA', '27', 'Muang Vangviang'],
 ['LA', '27', 'Muang Thoulakh\xc3\xb4m'],
 ['LA', '14', 'Muang Thath\xc3\xb4m'],
 ['LA', '26', 'Muang That\xc3\xa8ng'],
 ['LA', '19', 'Muang Ta-\xc3\x94y'],
 ['LA', '02', 'Muang Soukhouma'],
 ['LA', '20', 'Muang Songkhon'],
 ['LA', '16', 'Muang Sing'],
 ['LA', '19', 'Muang Saravan'],
 ['LA', '02', 'Muang Ph\xc3\xb4nthong'],
 ['LA', '27', 'Muang Ph\xc3\xb4n-H\xc3\xb4ng'],
 ['LA', '18', 'Muang Ph\xc3\xb4ngsali'],
 ['LA', '20', 'Muang Phin'],
 ['LA', '14', 'Muang P\xc3\xa8k'],
 ['LA', '02', 'Muang Pathoumphon'],
 ['LA', '02', 'Muang Pakxong'],
 ['LA', '02', 'Muang Pakx\xc3\xa9'],
 ['LA', '23', 'Muang Pakxan'],
 ['LA', '22', 'Muang Paktha'],
 ['LA', '17', 'Muang Pak-Ou'],
 ['LA', '13', 'Muang Paklay'],
 ['LA', '23', 'Muang Pakkading'],
 ['LA', '07', 'Muang Pakb\xc3\xa8ng'],
 ['LA', '20', 'Muang Nong'],
 ['LA', '17', 'Muang Ngoy'],
 ['LA', '17', 'Muang Nan'],
 ['LA', '07', 'Muang Namo'],
 ['LA', '17', 'Muang Nambak'],
 ['LA', '02', 'Muang Mounlapam\xc3\xb4k'],
 ['LA', '15', 'Muang Mahaxai'],
 ['LA', '17', 'Muang Louangphabang'],
 ['LA', '16', 'Muang Louang Namtha'],
 ['LA', '19', 'Muang Laongam'],
 ['LA', '19', 'Muang Lakhonph\xc3\xa9ng'],
 ['LA', '07', 'Muang La'],
 ['LA', '19', 'Muang Kh\xc3\xb4ngx\xc3\xa9d\xc3\xb4n'],
 ['LA', '02', 'Muang Kh\xc3\xb4ng'],
 ['LA', '15', 'Muang Thakh\xc3\xa8k'],
 ['LA', '23', 'Muang Khamkeut'],
 ['LA', '27', 'Muang Kasi'],
 ['LA', '07', 'Muang Houn'],
 ['LA', '03', 'Muang Houamuang'],
 ['LA', '13', 'Muang H\xc3\xb4ngsa'],
 ['LA', '15', 'Muang Hinboun'],
 ['LA', '20', 'Muang Champhon'],
 ['LA', '02', 'Muang Champasak'],
 ['LA', '18', 'Muang Boun Tai'],
 ['LA', '23', 'Muang Bolikhan'],
 ['LA', '07', 'Muang B\xc3\xa8ng'],
 ['LA', '02', 'Muang Bachiangchaleunsook'],
 ['LA', '26', 'Muang Dakchung'],
 ['LA', '19', 'Muang Toumlan'],
 ['LA', '26', 'Muang Laman'],
 ['LA', '01', 'Muang Xais\xc3\xa9ttha'],
 ['LA', '01', 'Muang Samakhixai'],
 ['LA', '01', 'Muang Sanamxai'],
 ['LA', '01', 'Muang Phouvong'],
 ['LA', '01', 'Muang Sanxai'],
 ['LA', '02', 'Muang Xanas\xc3\xb4mboun'],
 ['LA', '26', 'Muang Khaleum'],
 ['LA', '20', 'Muang Thapangthong'],
 ['LA', '20', 'Muang Khanthabouli'],
 ['LA', '20', 'Muang X\xc3\xb4nbouli'],
 ['LA', '19', 'Muang Samouay'],
 ['LA', '20', 'Muang Outhoumphon'],
 ['LA', '20', 'Muang Alsaphangthong'],
 ['LA', '20', 'Muang Xaibouli'],
 ['LA', '20', 'Muang Atsaphan'],
 ['LA', '20', 'Muang Vilabouli'],
 ['LA', '15', 'Muang Nongb\xc3\xb4k'],
 ['LA', '15', 'Muang Xebangfai'],
 ['LA', '15', 'Muang Xaibouathong'],
 ['LA', '15', 'Muang Boualapha'],
 ['LA', '15', 'Muang Gn\xc3\xb4mmalat'],
 ['LA', '15', 'Muang Na Kay'],
 ['LA', '23', 'Muang Viangthong'],
 ['LA', '23', 'Muang Thaphabat'],
 ['LA', '27', 'Muang Longxan'],
 ['LA', '27', 'Muang K\xc3\xa8o-Oud\xc3\xb4m'],
 ['LA', '27', 'Muang H\xc3\xb4m'],
 ['LA', '27', 'Muang Xais\xc3\xb4mboun'],
 ['LA', '27', 'Muang Phoun'],
 ['LA', '24', 'Muang Xanakham'],
 ['LA', '27', 'Muang Fuang'],
 ['LA', '13', 'Muang Bot\xc3\xa8n'],
 ['LA', '13', 'Muang K\xc3\xa9nthao'],
 ['LA', '13', 'Muang Phiang'],
 ['LA', '13', 'Muang Khop'],
 ['LA', '17', 'Muang Chomph\xc3\xa9t'],
 ['LA', '17', 'Muang Phou Khoun'],
 ['LA', '17', 'Muang Ph\xc3\xb4nxai'],
 ['LA', '17', 'Muang Pakx\xc3\xa8ng'],
 ['LA', '17', 'Muang Viangkhan'],
 ['LA', '14', 'Muang Nongh\xc3\xa8t'],
 ['LA', '14', 'Muang Phaxai'],
 ['LA', '14', 'Muang Khoun'],
 ['LA', '14', 'Muang Mok-Mai'],
 ['LA', '14', 'Muang Phou Kont'],
 ['LA', '03', 'Muang Xam-Tai'],
 ['LA', '03', 'Muang Viangxai'],
 ['LA', '03', 'Muang Viangthong'],
 ['LA', '07', 'Muang Nga'],
 ['LA', '22', 'Muang Pha Oud\xc3\xb4m'],
 ['LA', '22', 'Muang T\xc3\xb4npheung'],
 ['LA', '22', 'Muang Meung'],
 ['LA', '16', 'Muang Nal\xc3\xa8'],
 ['LA', '16', 'Muang Viangphoukha'],
 ['LA', '16', 'Muang Long'],
 ['LA', '18', 'Muang Khoa'],
 ['LA', '18', 'Muang Mai'],
 ['LA', '18', 'Muang Boun-Nua'],
 ['LA', '18', 'Muang Gnot-Ou'],
 ['LA', '24', 'Muang Chanthabouli'],
 ['LA', '24', 'Muang Sisattanak'],
 ['LA', '24', 'Muang Xais\xc3\xa9ttha'],
 ['LA', '24', 'Muang Sikh\xc3\xb4ttabong'],
 ['LA', '24', 'Muang Xaithani'],
 ['LA', '24', 'Muang Naxaythong'],
 ['LA', '24', 'Muang Sangthong'],
 ['LA', '24', 'Muang Maypakngum'],
 ['LA', '18', 'Samphanh'],
 ['LA', '20', 'Thaphalanxay'],
 ['LA', '03', 'Sopbao'],
 ['LA', '03', 'Muang Et'],
 ['LA', '20', 'Muang Xonbuly'],
 ['LA', '19', 'Muang Lao Ngam'],
 ['LA', '19', 'Muang Toomlan'],
 ['LA', '19', 'Muang Vapy'],
 ['LA', '02', 'Muang Pathoomphone'],
 ['LA', '03', 'Muang Viengthong'],
 ['LA', '03', 'Muang Viengxay'],
 ['LA', '03', 'Huameung'],
 ['LA', '01', 'Sanaxy'],
 ['LA', '26', 'Dakcheung'],
 ['LA', '15', 'Nakai'],
 ['LA', '15', 'Nhommalath'],
 ['LA', '15', 'Xaybouathong'],
 ['LA', '15', 'Xebangfai'],
 ['LA', '22', 'Khetphiset Namyu'],
 ['LB', '09', 'Caza de Zgharta'],
 ['LB', '08', 'Caza de Zahleh'],
 ['LB', '09', 'Caza de Trablous'],
 ['LB', '06', 'Caza de Tyr'],
 ['LB', '08', 'Caza de Racha\xc3\xafya'],
 ['LB', '07', 'Caza de Marjayo\xc3\xbbn'],
 ['LB', '05', 'Caza du Kesrouane'],
 ['LB', '05', 'Caza de Jbayl'],
 ['LB', '06', 'Caza de Jezz\xc3\xaene'],
 ['LB', '07', 'Caza de H\xc3\xa2sba\xc3\xafya'],
 ['LB', '09', 'Caza de B\xc3\xa9charr\xc3\xa9'],
 ['LB', '07', 'Caza de Bent Jba\xc3\xafl'],
 ['LB', '11', 'Caza de Baalbek'],
 ['LB', '05', 'Caza de Baabda'],
 ['LB', '05', 'Caza du Chouf'],
 ['LB', '07', 'Caza de Nabat\xc3\xaey\xc3\xa9'],
 ['LB', '05', 'Caza du Matn'],
 ['LB', '09', 'Caza de Koura'],
 ['LB', '11', 'Caza du Hermel'],
 ['LB', '08', 'Caza de la Beq\xc3\xa2a-Ouest'],
 ['LB', '09', 'Caza de Batroun'],
 ['LB', '05', 'Caza de Aaley'],
 ['LB', '10', 'Caza de Aakk\xc3\xa2r'],
 ['LB', '07', 'Marjayoun'],
 ['LB', '09', 'Caza de Miniy\xc3\xa9-Danniy\xc3\xa9'],
 ['LB', '06', 'Caza de Saida'],
 ['LB', '05', 'Metn District'],
 ['LK', '31', 'Vavuniya District'],
 ['LK', '37', 'Trincomalee District'],
 ['LK', '33', 'Ratnapura District'],
 ['LK', '32', 'Puttalam District'],
 ['LK', '30', 'Polonnaruwa District'],
 ['LK', '29', 'Nuwara Eliya District'],
 ['LK', '38', 'Mullaittivu District'],
 ['LK', '35', 'Monaragala District'],
 ['LK', '34', 'Matara District'],
 ['LK', '29', 'Matale District'],
 ['LK', '38', 'Mannar District'],
 ['LK', '32', 'Kurunegala District'],
 ['LK', '31', 'Kilinochchi District'],
 ['LK', '33', 'Kegalla District'],
 ['LK', '29', 'Kandy District'],
 ['LK', '36', 'Kalutara District'],
 ['LK', '38', 'Jaffna District'],
 ['LK', '34', 'Hambantota District'],
 ['LK', '36', 'Gampaha District'],
 ['LK', '34', 'Galle District'],
 ['LK', '36', 'Colombo District'],
 ['LK', '37', 'Batticaloa District'],
 ['LK', '35', 'Badulla District'],
 ['LK', '30', 'Anuradhapura District'],
 ['LK', '37', 'Ampara District'],
 ['LK', '', 'Mullattivu'],
 # ['LR', '01', 'Zota'],
 # ['LR', '09', 'Zo-Ge'],
 # ['LR', '13', 'Yederabo'],
 # ['LR', '09', 'Yawein-Mesono'],
 # ['LR', '10', 'Wedjah-Cabade'],
 # ['LR', '22', 'Webbo District'],
 # ['LR', '16', 'Webado'],
 # ['LR', '20', 'Waiglomai-Woniglomai'],
 # ['LR', '13', 'Tuobo'],
 # ['LR', '22', 'Tuobo'],
 # ['LR', '10', 'Toto'],
 # ['LR', '10', 'Topo'],
 # ['LR', '12', 'Tombe'],
 # ['LR', '14', 'Todi'],
 # ['LR', '22', 'Tienpo'],
 # ['LR', '11', 'Three B'],
 # ['LR', '11', 'Three A'],
 # ['LR', '12', 'Tewo'],
 # ['LR', '11', 'Tenor'],
 # ['LR', '19', 'Tchien'],
 # ['LR', '10', 'Tasu'],
 # ['LR', '10', 'Tarjuazon'],
 # ['LR', '13', 'Sodoke'],
 # ['LR', '10', 'Seedor'],
 # ['LR', '16', 'Sasstown'],
 # ['LR', '01', 'Sanoyie'],
 # ['LR', '09', 'Sanokole-Ma'],
 # ['LR', '09', 'Sagleipie-Ma'],
 # ['LR', '22', 'Sabo'],
 # ['LR', '13', 'Rock Town'],
 # ['LR', '18', 'Rock Cess'],
 # ['LR', '19', 'Putu'],
 # ['LR', '13', 'Po River'],
 # ['LR', '12', 'Pokpa'],
 # ['LR', '13', 'Plibo'],
 # ['LR', '13', 'Picnicess'],
 # ['LR', '13', 'Pate'],
 # ['LR', '01', 'Panta'],
 # ['LR', '22', 'Palipo'],
 # ['LR', '13', 'Nyanbo'],
 # ['LR', '01', 'Nyafokole'],
 # ['LR', '10', 'Nuohn Point'],
 # ['LR', '10', 'Numo'],
 # ['LR', '19', 'Niabo'],
 # ['LR', '13', 'Nemea'],
 # ['LR', '10', 'Nana Kru'],
 # ['LR', '10', 'Nake'],
 # ['LR', '15', 'Mecca'],
 # ['LR', '10', 'Matro'],
 # ['LR', '17', 'Mamba'],
 # ['LR', '13', 'Little Wrebo'],
 # ['LR', '10', 'Kulu'],
 # ['LR', '09', 'Keaple'],
 # ['LR', '19', 'Konobo'],
 # ['LR', '12', 'Kone'],
 # ['LR', '21', 'Komgba'],
 # ['LR', '01', 'Kokoya'],
 # ['LR', '22', 'Kitabo'],
 # ['LR', '20', 'Kisi'],
 # ['LR', '20', 'Kambo Hills'],
 # ['LR', '14', 'Kakata'],
 # ['LR', '10', 'Kabor'],
 # ['LR', '17', 'Kaba'],
 # ['LR', '10', 'Sikohn'],
 # ['LR', '10', 'Jroh'],
 # ['LR', '01', 'Jokole'],
 # ['LR', '10', 'Jeetrah'],
 # ['LR', '10', 'Jedepo'],
 # ['LR', '11', 'Jayah'],
 # ['LR', '20', 'Guma-Mendi'],
 # ['LR', '13', 'Grawa'],
 # ['LR', '13', 'Grand Cess'],
 # ['LR', '12', 'Gota Kone'],
 # ['LR', '15', 'Gola'],
 # ['LR', '21', 'Goije'],
 # ['LR', '19', 'Glio-Twabo'],
 # ['LR', '13', 'Glebo'],
 # ['LR', '11', 'Glarkon'],
 # ['LR', '20', 'Gizima-Ziema'],
 # ['LR', '01', 'Gibi'],
 # ['LR', '13', 'Gedetarbo'],
 # ['LR', '13', 'Gedabo'],
 # ['LR', '22', 'Glaro'],
 # ['LR', '09', 'Gbokole'],
 # ['LR', '19', 'Gbobo'],
 # ['LR', '09', 'Gbi-Doru'],
 # ['LR', '13', 'Gbeta Klepo'],
 # ['LR', '09', 'Gbele-Ge'],
 # ['LR', '13', 'Gbelakpo'],
 # ['LR', '22', 'Gbeapo District'],
 # ['LR', '19', 'Gbazohn'],
 # ['LR', '13', 'Gbarlobo'],
 # ['LR', '20', 'Gbandi'],
 # ['LR', '20', 'Gbalein Faala'],
 # ['LR', '12', 'Gawula'],
 # ['LR', '13', 'Garawe'],
 # ['LR', '01', 'Fuama'],
 # ['LR', '11', 'Trade Town'],
 # ['LR', '13', 'Flenipo'],
 # ['LR', '18', 'Mowe'],
 # ['LR', '11', 'Five A'],
 # ['LR', '13', 'Firestone'],
 # ['LR', '13', 'Dorobo'],
 # ['LR', '14', 'Ding'],
 # ['LR', '15', 'Dei'],
 # ['LR', '13', 'Dedabo'],
 # ['LR', '22', 'Chelepo'],
 # ['LR', '13', 'Cavalla'],
 # ['LR', '14', 'Careysburg'],
 # ['LR', '11', 'Campwood'],
 # ['LR', '10', 'Buto'],
 # ['LR', '13', 'Bua'],
 # ['LR', '21', 'Bopolu'],
 # ['LR', '20', 'Bonde-Wubomai'],
 # ['LR', '13', 'Bolobo'],
 # ['LR', '10', 'Bolo'],
 # ['LR', '21', 'Bokomu'],
 # ['LR', '19', 'Biai'],
 # ['LR', '21', 'Belle'],
 # ['LR', '13', 'Barobo'],
 # ['LR', '13', 'Barclayville'],
 # ['LR', '09', 'Do'],
 # ['LR', '20', 'Guma'],
 # ['LR', '01', 'Jorquelleh'],
 # ['LR', '01', 'Suakoko'],
 # ['LR', '01', 'Salala'],
 # ['LR', '09', 'Sanniquelleh- Mahn'],
 # ['LR', '14', 'Topee'],
 # ['LR', '14', 'Mambah-Kaba'],
 # ['LR', '14', 'Greater Monrovia'],
 # ['LR', '09', 'Saclepea-Mah'],
 # ['LR', '14', 'St. Paul River'],
 # ['LR', '11', 'District #1'],
 # ['LR', '11', 'District #2'],
 # ['LR', '11', 'District #3'],
 # ['LR', '17', 'Firestone'],
 # ['LR', '12', 'Robertsport District'],
 # ['LR', '10', 'Pyneston District'],
 # ['LR', '13', 'Pleebo/Sodeken District'],
 ['LR', '15', 'Dewoin'],
 ['LR', '15', 'Klay'],
 ['LR', '15', 'Senjeh'],
 ['LR', '15', 'Suehn_Mecca'],
 ['LR', '01', 'Fuamah'],
 ['LR', '01', 'Jorquelleh'],
 ['LR', '01', 'Kokoyah'],
 ['LR', '01', 'Panta_Kpaai'],
 ['LR', '01', 'Salala'],
 ['LR', '01', 'Sanoyea'],
 ['LR', '01', 'Suakoko'],
 ['LR', '01', 'Zota'],
 ['LR', '21', 'Belle'],
 ['LR', '21', 'Bokomu'],
 ['LR', '21', 'Bopolu'],
 ['LR', '21', 'Gbarma'],
 ['LR', '21', 'Kongbor'],
 ['LR', '11', 'Buchanan'],
 ['LR', '11', 'Campwood'],
 ['LR', '11', 'District#1'],
 ['LR', '11', 'District#2'],
 ['LR', '11', 'District#3A&B'],
 ['LR', '11', 'District#3C'],
 ['LR', '11', 'District#4'],
 ['LR', '11', 'Owengrove'],
 ['LR', '12', 'Robertsport'],
 ['LR', '12', 'Garwular'],
 ['LR', '12', 'Golakonneh'],
 ['LR', '12', 'Porkpa'],
 ['LR', '12', 'Tewor'],
 ['LR', '19', "B'Hai"],
 ['LR', '19', 'Cavalla'],
 ['LR', '19', 'Gbao'],
 ['LR', '19', 'Konobo'],
 ['LR', '19', 'Putu'],
 ['LR', '19', 'Tchien'],
 ['LR', '16', 'Barclayville'],
 ['LR', '16', 'Buah'],
 ['LR', '16', 'Dorbor'],
 ['LR', '16', 'Jraoh'],
 ['LR', '16', 'Trehn'],
 ['LR', '20', 'Foya'],
 ['LR', '20', 'Kolahun'],
 ['LR', '20', 'Salayea'],
 ['LR', '20', 'Vahun'],
 ['LR', '20', 'Voinjama'],
 ['LR', '20', 'Zorzor'],
 ['LR', '17', 'Firestone'],
 ['LR', '17', 'Gibi'],
 ['LR', '17', 'Kakata'],
 ['LR', '17', 'Mambahkaba'],
 ['LR', '13', 'Barrobofarjah'],
 ['LR', '13', 'Barrobowhojah'],
 ['LR', '13', 'Harper'],
 ['LR', '13', 'Karluway1'],
 ['LR', '13', 'Karluway2'],
 ['LR', '13', 'Pleebo'],
 ['LR', '14', 'Bushrod'],
 ['LR', '14', 'Careysburg'],
 ['LR', '14', 'Centralmonrovia'],
 ['LR', '14', 'Commonwealth'],
 ['LR', '14', 'Somaliadrive'],
 ['LR', '14', 'Stpaulriver'],
 ['LR', '14', 'Todee'],
 ['LR', '09', 'Gbehlaygeh'],
 ['LR', '09', 'Saclepeamah'],
 ['LR', '09', 'Sanniquelliemah'],
 ['LR', '09', 'Tappita'],
 ['LR', '09', 'Yarweinmensonon'],
 ['LR', '09', 'Zoegeh'],
 ['LR', '22', 'Chedepo'],
 ['LR', '22', 'Gbeapo'],
 ['LR', '22', 'Putupo'],
 ['LR', '22', 'Sarbo'],
 ['LR', '22', 'Tienpo'],
 ['LR', '22', 'Webbo'],
 ['LR', '18', 'Centralrivercess'],
 ['LR', '18', 'Doedain'],
 ['LR', '18', 'Joriver'],
 ['LR', '18', 'Jowein'],
 ['LR', '18', 'Timbo'],
 ['LR', '18', 'Yarnee'],
 ['LR', '10', 'Butaw'],
 ['LR', '10', 'Dugberiver'],
 ['LR', '10', 'Greenville'],
 ['LR', '10', 'Jeade'],
 ['LR', '10', 'Jeadepo'],
 ['LR', '10', 'Kpanyan'],
 ['LR', '10', 'Paynestown'],
 ['LR', '10', 'Tarjuwon'],
 ['LR', '10', 'Tarsue'],
 ['LS', '12', 'Khomokhoana Community'],
 ['LS', '14', 'Makhaleng Constituency'],
 ['LS', '12', 'Urban'],
 ['LS', '12', 'Hleoheng'],
 ['LS', '10', 'Mokomahatsi'],
 ['LS', '10', 'Mokhachane'],
 ['LS', '10', 'Mapoteng'],
 ['LS', '10', 'Makhoroana'],
 ['LS', '10', 'Urban'],
 ['LS', '10', 'Mamathe'],
 ['LT', '64', 'Zaras\xc5\xb3 Rajonas'],
 ['LT', '65', 'Vilnius'],
 ['LT', '65', 'Vilniaus Rajonas'],
 ['LT', '59', 'Vilkavi\xc5\xa1kio Rajonas'],
 ['LT', '56', 'Var\xc4\x97nos Rajonas'],
 ['LT', '64', 'Utenos Rajonas'],
 ['LT', '65', 'Ukmerg\xc4\x97s Rajonas'],
 ['LT', '65', 'Trak\xc5\xb3 Rajonas'],
 ['LT', '63', 'Tel\xc5\xa1i\xc5\xb3 Rajonas'],
 ['LT', '62', 'Taurag\xc4\x97s Rajonas'],
 ['LT', '65', '\xc5\xa0ven\xc4\x8dioni\xc5\xb3 Rajonas'],
 ['LT', '58', 'Skuodo Rajonas'],
 ['LT', '65', '\xc5\xa0irvint\xc5\xb3 Rajonas'],
 ['LT', '58', '\xc5\xa0ilut\xc4\x97s Rajonas'],
 ['LT', '62', '\xc5\xa0ilal\xc4\x97s Rajonas'],
 ['LT', '61', '\xc5\xa0iauli\xc5\xb3 Rajonas'],
 ['LT', '61', '\xc5\xa0iauliai'],
 ['LT', '65', '\xc5\xa0al\xc4\x8dinink\xc5\xb3 Rajonas'],
 ['LT', '59', '\xc5\xa0aki\xc5\xb3 Rajonas'],
 ['LT', '60', 'Roki\xc5\xa1kio Rajonas'],
 ['LT', '57', 'Raseini\xc5\xb3 Rajonas'],
 ['LT', '61', 'Radvili\xc5\xa1kio Rajonas'],
 ['LT', '57', 'Prien\xc5\xb3 Rajonas'],
 ['LT', '63', 'Plung\xc4\x97s Rajonas'],
 ['LT', '60', 'Pasvalio Rajonas'],
 ['LT', '60', 'Panev\xc4\x97\xc5\xbeys'],
 ['LT', '60', 'Panev\xc4\x97\xc5\xbeio Rajonas'],
 ['LT', '58', 'Palanga'],
 ['LT', '61', 'Pakruojo Rajonas'],
 ['LT', '58', 'Neringa'],
 ['LT', '64', 'Mol\xc4\x97t\xc5\xb3 Rajonas'],
 ['LT', '63', 'Ma\xc5\xbeeiki\xc5\xb3 Rajonas'],
 ['LT', '59', 'Marijampol\xc4\x97s Rajonas'],
 ['LT', '59', 'Marijampol\xc4\x97'],
 ['LT', '56', 'Lazdij\xc5\xb3 Rajonas'],
 ['LT', '60', 'Kupi\xc5\xa1kio Rajonas'],
 ['LT', '58', 'Kretingos Rajonas'],
 ['LT', '58', 'Klaip\xc4\x97dos Rajonas'],
 ['LT', '58', 'Klaip\xc4\x97da'],
 ['LT', '61', 'Kelm\xc4\x97s Rajonas'],
 ['LT', '57', 'K\xc4\x97daini\xc5\xb3 Rajonas'],
 ['LT', '57', 'Kauno Rajonas'],
 ['LT', '57', 'Kaunas'],
 ['LT', '57', 'Kai\xc5\xa1iadori\xc5\xb3 Rajonas'],
 ['LT', '62', 'Jurbarko Rajonas'],
 ['LT', '61', 'Joni\xc5\xa1kio Rajonas'],
 ['LT', '57', 'Jonavos Rajonas'],
 ['LT', '64', 'Ignalinos Rajonas'],
 ['LT', '56', 'Druskininkai'],
 ['LT', '60', 'Bir\xc5\xbe\xc5\xb3 Rajonas'],
 ['LT', '57', 'Bir\xc5\xa1tonas'],
 ['LT', '64', 'Anyk\xc5\xa1\xc4\x8di\xc5\xb3 Rajonas'],
 ['LT', '56', 'Alytus'],
 ['LT', '56', 'Alytaus Rajonas'],
 ['LT', '61', 'Akmen\xc4\x97s Rajonas'],
 ['LT', '56', 'Lazdijai'],
 ['LT', '56', 'Var\xc4\x97na'],
 ['LT', '57', 'Jonava'],
 ['LT', '57', 'Kai\xc5\xa1iadorys'],
 ['LT', '57', 'K\xc4\x97dainiai'],
 ['LT', '57', 'Prienai'],
 ['LT', '57', 'Raseiniai'],
 ['LT', '58', 'Garg\xc5\xbedai'],
 ['LT', '58', 'Kretinga'],
 ['LT', '58', 'Skuodas'],
 ['LT', '58', '\xc5\xa0ilut\xc4\x97'],
 ['LT', '59', '\xc5\xa0akiai'],
 ['LT', '59', 'Vilkavi\xc5\xa1kis'],
 ['LT', '60', 'Bir\xc5\xbeai'],
 ['LT', '60', 'Kupi\xc5\xa1kis'],
 ['LT', '60', 'Pasvalys'],
 ['LT', '60', 'Roki\xc5\xa1kis'],
 ['LT', '61', 'Naujoji Akmen\xc4\x97'],
 ['LT', '61', 'Joni\xc5\xa1kis'],
 ['LT', '61', 'Kelm\xc4\x97'],
 ['LT', '61', 'Pakruojis'],
 ['LT', '61', 'Radvili\xc5\xa1kis'],
 ['LT', '62', 'Taurag\xc4\x97'],
 ['LT', '62', 'Jurbarkas'],
 ['LT', '62', '\xc5\xa0ilal\xc4\x97'],
 ['LT', '63', 'Tel\xc5\xa1iai'],
 ['LT', '63', 'Ma\xc5\xbeeikiai'],
 ['LT', '63', 'Plung\xc4\x97'],
 ['LT', '64', 'Utena'],
 ['LT', '64', 'Visaginas'],
 ['LT', '64', 'Anyk\xc5\xa1\xc4\x8diai'],
 ['LT', '64', 'Ignalina'],
 ['LT', '64', 'Mol\xc4\x97tai'],
 ['LT', '64', 'Zarasai'],
 ['LT', '65', '\xc5\xa0al\xc4\x8dininkai'],
 ['LT', '65', '\xc5\xa0irvintos'],
 ['LT', '65', '\xc5\xa0ven\xc4\x8dionys'],
 ['LT', '65', 'Trakai'],
 ['LT', '65', 'Ukmerg\xc4\x97'],
 ['LU', '01', 'Canton de Wiltz'],
 ['LU', '01', 'Canton de Vianden'],
 ['LU', '02', 'Canton de Remich'],
 ['LU', '01', 'Canton de Redange'],
 ['LU', '03', 'Canton de Mersch'],
 ['LU', '03', 'Canton de Luxembourg'],
 ['LU', '02', 'Canton de Grevenmacher'],
 ['LU', '03', "Canton d'Esch-sur-Alzette"],
 ['LU', '02', "Canton d'Echternach"],
 ['LU', '01', 'Canton de Diekirch'],
 ['LU', '01', 'Canton de Clervaux'],
 ['LU', '03', 'Canton de Capellen'],
 ['LY', '56', 'Mutu\xc5\x9farrif\xc4\xabyat Ghad\xc4\x81mis'],
 ['MA', '55', 'Tiznit'],
 ['MA', '57', 'Tetouan'],
 ['MA', '58', 'Taza'],
 ['MA', '53', 'Tata'],
 ['MA', '55', 'Taroudannt'],
 ['MA', '58', 'Taounate'],
 ['MA', '53', 'Tan-Tan'],
 ['MA', '57', 'Tanger-Assilah'],
 ['MA', '52', 'Sidi-Kacem'],
 ['MA', '50', 'Settat Province'],
 ['MA', '49', 'Sale'],
 ['MA', '51', 'Safi'],
 ['MA', '49', 'Rabat'],
 ['MA', '54', 'Oujda-Angad'],
 ['MA', '55', 'Ouarzazate'],
 ['MA', '54', 'Nador'],
 ['MA', '57', 'Larache'],
 ['MA', '59', 'Laayoune'],
 ['MA', '50', 'Khouribga Province'],
 ['MA', '48', 'Khenifra'],
 ['MA', '49', 'Khemisset'],
 ['MA', '52', 'Kenitra Province'],
 ['MA', '55', 'Inezgane-Ait Mellou'],
 ['MA', '48', 'Ifrane'],
 ['MA', '53', 'Guelmim'],
 ['MA', '54', 'Figuig'],
 ['MA', '47', 'Essaouira'],
 ['MA', '48', 'Errachidia'],
 ['MA', '47', 'Kelaa-Des-Sraghna'],
 ['MA', '51', 'El-Jadida'],
 ['MA', '57', 'Chefchaouen Province'],
 ['MA', '46', 'Boulemane'],
 ['MA', '50', 'Benslimane'],
 ['MA', '56', 'Beni-Mellal'],
 ['MA', '56', 'Azilal Province'],
 ['MA', '58', 'Al-Hoceima'],
 ['MA', '55', 'Agadir-Ida-ou-Tnan'],
 ['MA', '49', 'Skhirate-Temara'],
 ['MA', '53', 'Assa-Zag'],
 ['MA', '53', 'Es-Semara'],
 ['MA', '48', 'Meknes'],
 ['MA', '47', 'Chichaoua'],
 ['MA', '47', 'Marrakech'],
 ['MA', '46', 'Sefrou'],
 ['MA', '54', 'Berkane-Taourirt'],
 ['MA', '54', 'Jerada'],
 ['MA', '59', 'Boujdour'],
 ['MA', '55', 'Chtouka-Ait-Baha'],
 ['MA', '47', 'Al-Haouz'],
 ['MA', '57', 'Fahs-Anjra'],
 ['MA', '45', 'Casablanca'],
 ['MA', '46', 'Moulay-Yacoub'],
 ['MA', '48', 'El-Hajeb'],
 ['MA', 'EH', 'Aousserd'],
 ['MA', 'EH', 'Oued-Ed-Dahab'],
 ['MA', '45', 'Nouaceur'],
 ['MA', '46', 'Fes'],
 ['MA', '45', 'Mohammedia'],
 ['MA', '55', 'Zagora'],
 ['MA', '45', 'Mediouna'],
 ['MA', '', 'El Kelaa'],
 ['MD', '00', 'Sovetskiy Rayon'],
 ['MD', '00', "Oktyabr'skiy Rayon"],
 ['MD', '00', 'Leninskiy Rayon'],
 ['MD', '00', 'Frunzenskiy Rayon'],
 ['MF', '00', 'Arrondissement de Saint-Martin-Saint-Barth\xc3\xa9lemy'],
 ['MG', '7670851', 'Ambatondrazaka District'],
 ['MG', '7670851', 'Amparafaravola District'],
 ['MG', '7670857', 'Brickaville'],
 ['MG', '7670856', 'Antananarivo-Atsimondrano'],
 ['MG', '7670856', 'Manjakandriana'],
 ['MG', '7670851', 'Moramanga District'],
 ['MG', '7670857', 'Vohibinany'],
 ['MG', '7670905', 'Fianarantsoa I'],
 ['MG', '7670905', 'Fianarantsoa II'],
 ['MG', '7670905', 'Ambohimahasoa'],
 ['MG', '7670904', 'Ambositra District'],
 ['MG', '7670854', 'Antsirabe II'],
 ['MG', '7670854', 'Antsirabe I District'],
 ['MG', '7670854', 'Antanifotsy'],
 ['MG', '7670854', 'Ambatolampy'],
 ['MG', '7670847', 'Antsohihy'],
 ['MG', '7670847', 'Befandriana Avaratra District'],
 ['MG', '7670847', 'Mandritsara'],
 ['MG', '7670856', 'Antananarivo-Avaradrano District'],
 ['MG', '7670856', 'Antananarivo-Renivohitra District'],
 ['MG', '7670857', 'Toamasina I'],
 ['MG', '7670857', 'Toamasina II'],
 ['MG', '7670846', 'Andapa District'],
 ['MG', '7670849', 'Marovoay District'],
 ['MG', '7670848', 'Vavatenina District'],
 ['MG', '7670848', 'Maroantsetra District'],
 ['MG', '7670848', 'Mananara Nord District'],
 ['MG', '7670910', 'Betroka District'],
 ['MG', '7670908', 'Farafangana District'],
 ['MG', '7670908', 'Vangaindrano District'],
 ['MG', '7670910', 'Amboasary District'],
 ['MG', '7670902', 'Morombe District'],
 ['MG', '7670847', 'Bealanana District'],
 ['MG', '7670913', 'Ankazoabo District'],
 ['MG', '7670854', 'Betafo District'],
 ['MG', '7670902', 'Miandrivazo District'],
 ['MG', '', 'Toliara II District'],
 ['MG', '7670913', 'Toliara I District'],
 ['MG', '7670851', 'Andilamena District'],
 ['MG', '7670851', "Anosibe An'ala District"],
 ['MG', '7670904', 'Ambatofinandrahana District'],
 ['MG', '7670904', 'Fandriana District'],
 ['MG', '7670904', 'Manandriana District'],
 ['MG', '7670902', 'Morondava District'],
 ['MG', '7670902', 'Mahabo District'],
 ['MG', '7670902', 'Manja District'],
 ['MG', '7670913', 'Beroroha District'],
 ['MG', '7670856', 'Ankazobe District'],
 ['MG', '7670856', 'Ambohidratrimo District'],
 ['MG', '7670856', 'Andramasina District'],
 ['MK', '00', 'Titov Veles Op\xc5\xa1tina'],
 ['MK', '00', 'Tetovo Op\xc5\xa1tina'],
 ['MK', '00', 'Strumica Op\xc5\xa1tina'],
 ['MK', '00', 'Radovi\xc5\xa1 Op\xc5\xa1tina'],
 ['MK', '00', 'Ohrid Op\xc5\xa1tina'],
 ['MK', '00', 'Kumanovo Op\xc5\xa1tina'],
 ['MK', '00', 'Kru\xc5\xa1evo Op\xc5\xa1tina'],
 ['MK',
  '00',
  '\xd0\x9e\xd0\xbf\xd1\x88\xd1\x82\xd0\xb8\xd0\xbd\xd0\xb0 \xe2\x80\x9e\xd0\x9a\xd1\x80\xd0\xb8\xd0\xb2\xd0\xb0 \xd0\x9f\xd0\xb0\xd0\xbb\xd0\xb0\xd0\xbd\xd0\xba\xd0\xb0\xe2\x80\x9c'],
 ['MK', '00', 'Kocani Op\xc5\xa1tina'],
 ['MK', '00', 'Gostivar Op\xc5\xa1tina'],
 ['MK', '00', 'Demir Hisar Op\xc5\xa1tina'],
 ['MK', '00', 'Delcevo Op\xc5\xa1tina'],
 ['MK', '00', 'Brod Op\xc5\xa1tina'],
 ['MK', '00', 'Kratovo Op\xc5\xa1tina'],
 ['MK', '', 'Petrovec'],
 ['MK', '', 'Blatec'],
 ['MK', '', 'Lukovo'],
 ['MK', '', 'Labunista'],
 ['ML', '04', 'Douentza Cercle'],
 ['ML', '09', 'Gourma-Rharous Cercle'],
 ['ML', '09', 'Gao Cercle'],
 ['ML', '06', 'Koutiala Cercle'],
 ['ML', '09', 'Ansongo Cercle'],
 ['ML', '01', 'Commune 3'],
 ['ML', '01', 'Commune 1'],
 ['ML', '01', 'Commune 2'],
 ['ML', '01', 'Commune 4'],
 ['ML', '01', 'Commune 5'],
 ['ML', '01', 'Commune 6'],
 ['ML', '01', 'Kati Cercle'],
 ['ML', '01', 'Dioila'],
 ['ML', '05', 'Baroueli'],
 ['ML', '05', 'Segou'],
 ['ML', '09', 'Kidal'],
 ['ML', '09', 'Tombouctou'],
 ['ML', '09', 'Dire'],
 ['ML', '03', 'Kayes Cercle'],
 ['ML', '04', 'Mopti Cercle'],
 ['ML', '04', 'Bankass Cercle'],
 ['ML', '04', 'Koro Cercle'],
 ['ML', '06', 'Bla'],
 ['ML', '05', 'ke-Macina'],
 ['ML', '05', 'Tominian'],
 ['ML', '03', 'Kita Cercle'],
 ['ML', '06', 'Bougouni Cercle'],
 ['ML', '01', 'Koulikoro'],
 ['ML', '06', 'Sikasso Cercle'],
 ['ML', '03', 'Diema Cercle'],
 ['ML', '01', 'Kolokani Cercle'],
 ['ML', '01', 'Banamba Cercle'],
 ['ML', '01', 'Nara Cercle'],
 ['ML', '03', 'Nioro Cercle'],
 ['ML', '04', 'Youwarou Cercle'],
 ['ML', '04', 'Niafunke Cercle'],
 ['ML', '04', 'Tenenkou Cercle'],
 ['ML', '04', 'Djenne Cercle'],
 ['ML', '04', 'Bandiagara Cercle'],
 ['ML', '03', 'Kenieba Cercle'],
 ['ML', '03', 'Bafoulabe Cercle'],
 ['ML', '06', 'Kolondieba Cercle'],
 ['MM', '01', 'Maungdaw District'],
 ['MM', '03', 'Labutta District'],
 ['MM', '04', 'Putao District'],
 ['MM', '04', 'Mohnyin District'],
 ['MM', '05', 'Hpa-an District'],
 ['MM', '05', 'Myawaddy District'],
 ['MM', '05', 'Kawkareik District'],
 ['MM', '06', 'Bawlakhe District'],
 ['MM', '06', 'Loikaw District'],
 ['MM', '08', 'Nyaung-U District'],
 ['MM', '08', 'Pyin Oo Lwin District'],
 ['MM', '10', 'Kale District'],
 ['MM', '10', 'Tamu District'],
 ['MM', '11', 'Kunlong District'],
 ['MM', '11', 'Kunlong District'],
 ['MM', '11', 'Taunggyi District'],
 ['MM', '11', 'Tachileik District'],
 ['MM', '11', 'Mong Hsat District'],
 ['MM', '11', 'Mong Hpayak District'],
 ['MM', '11', 'Kyaukme District'],
 ['MM', '11', 'Mu Se District'],
 ['MM', '11', 'Loilem District'],
 ['MM', '11', 'Langhko District'],
 ['MM', '11', 'Kengtung District'],
 ['MM', '11', 'Lashio District'],
 ['MM', '12', 'Kawthaung District'],
 ['MM', '13', 'Mawlamyine District'],
 ['MM', '15', 'Gangaw District'],
 ['MM', '17', 'Yangon South District'],
 ['MM', '17', 'Yangon East District'],
 ['MM', '08', 'Nay Pyi Taw District'],
 ['MN', '09', 'Songino'],
 ['MN', '01', 'Tariat Sum'],
 ['MN', '12', 'D\xc3\xb6rg\xc3\xb6n'],
 ['MN', '03', 'Bayannuur'],
 ['MN', '15', 'Yusun Tszuyl Somon'],
 ['MN', '13', 'Tarialan'],
 ['MN', '14', 'Nomgon Sum'],
 ['MN', '18', 'Bayantsogt Sum'],
 ['MN', '18', 'Bayan-\xc3\x96nj\xc3\xbc\xc3\xbcl Sum'],
 ['MN', '16', 'Bayangol'],
 ['MN', '06', 'Halhgol'],
 ['MN', '06', 'Matad'],
 ['MN', '06', 'Bayant\xc3\xbcmen'],
 ['MN', '06', 'Bulgan'],
 ['MN', '06', 'H\xc3\xb6l\xc3\xb6nbuyr'],
 ['MN', '06', 'Choybalsan'],
 ['MN', '06', 'Chuluunhoroot'],
 ['MN', '06', 'Dashbalbar'],
 ['MN', '06', 'Gurvandzagal'],
 ['MN', '06', 'Sergelen'],
 ['MN', '06', 'Tsagaan-Ovoo'],
 ['MN', '06', 'Bayandun'],
 ['MN', '06', 'Bayan-Uul'],
 ['MN', '06', 'Herlen'],
 ['MN', '17', 'Erdenetsagaan'],
 ['MN', '17', 'Dar\xc4\xadganga'],
 ['MN', '17', 'Ongon'],
 ['MN', '17', 'Naran'],
 ['MN', '17', 'Bayandelger'],
 ['MN', '17', 'Haldzan'],
 ['MN', '17', 'Uulbayan'],
 ['MN', '17', 'M\xc3\xb6nhhaan'],
 ['MN', '17', 'T\xc3\xbcmentsogt'],
 ['MN', '17', 'S\xc3\xbchbaatar'],
 ['MN', '17', 'T\xc3\xbcvshinshiree'],
 ['MN', '17', 'Asgat'],
 ['MN', '17', 'Baruun-Urt'],
 ['MN', '11', '\xc3\x96mn\xc3\xb6delger'],
 ['MN', '11', 'Darhan'],
 ['MN', '11', 'Bayanm\xc3\xb6nh'],
 ['MN', '11', 'Delgerhaan'],
 ['MN', '11', 'Jargalthaan'],
 ['MN', '11', 'Tsenhermandal'],
 ['MN', '11', 'M\xc3\xb6r\xc3\xb6n'],
 ['MN', '11', 'Herlen'],
 ['MN', '11', 'Bayanhutag'],
 ['MN', '11', 'Galshar'],
 ['MN', '11', 'Batshireet'],
 ['MN', '11', 'Binder'],
 ['MN', '11', 'Bayan-Adarga'],
 ['MN', '11', 'Dadal'],
 ['MN', '11', 'Batnorov'],
 ['MN', '11', 'Bayan-Ovoo'],
 ['MN', '11', 'Norovlin'],
 ['MN', '07', 'Dalanjargalan'],
 ['MN', '07', 'Ayrag'],
 ['MN', '07', 'Ihhet'],
 ['MN', '07', 'Altanshiree'],
 ['MN', '07', 'Delgereh'],
 ['MN', '07', 'Saynshand'],
 ['MN', '07', '\xc3\x96rg\xc3\xb6n'],
 ['MN', '07', 'Erdene'],
 ['MN', '07', 'Dzamyn \xc3\x9c\xc3\xbcd'],
 ['MN', '07', 'Ulaanbadrah'],
 ['MN', '07', 'Sayhandulaan'],
 ['MN', '07', 'Mandah'],
 ['MN', '07', 'H\xc3\xb6vsg\xc3\xb6l'],
 ['MN', '07', 'Hatanbulag'],
 ['MN', '08', 'S\xc3\xbcmber'],
 ['MN', '18', 'Bayantal'],
 ['MN', '07', 'Shiveegov\xc4\xad'],
 ['MN', '14', 'Mandal-Ovoo'],
 ['MN', '14', 'Tsogt-Ovoo'],
 ['MN', '14', 'Hanhongor'],
 ['MN', '14', 'Tsogttsetsiy'],
 ['MN', '14', 'Manlay'],
 ['MN', '14', 'Hanbogd'],
 ['MN', '14', 'Bayan-Ovoo'],
 ['MN', '14', 'H\xc3\xbcrmen'],
 ['MN', '14', 'Bayandalay'],
 ['MN', '14', 'Bulgan'],
 ['MN', '14', 'Sevrey'],
 ['MN', '14', 'Noyon'],
 ['MN', '14', 'Gurvantes'],
 ['MN', '14', 'Dalandzadgad'],
 ['MN', '08', 'Sayhan-Ovoo'],
 ['MN', '08', 'Delgerhangay'],
 ['MN', '08', 'Huld'],
 ['MN', '08', 'Luus'],
 ['MN', '08', 'Erdenedalay'],
 ['MN', '08', 'Adaatsag'],
 ['MN', '08', 'Delgertsogt'],
 ['MN', '08', 'Deren'],
 ['MN', '08', 'Tsagaandelger'],
 ['MN', '08', 'Gov\xc4\xad-Ugtaal'],
 ['MN', '08', 'Bayanjargalan'],
 ['MN', '08', 'Gurvansayhan'],
 ['MN', '08', '\xc3\x96nd\xc3\xb6rshil'],
 ['MN', '08', '\xc3\x96ldziyt'],
 ['MN', '08', 'Saintsagaan'],
 ['MN', '18', 'Delgerhaan'],
 ['MN', '18', 'B\xc3\xbcren'],
 ['MN', '18', 'Bayantsagaan'],
 ['MN', '18', 'Sergelen'],
 ['MN', '18', 'Altanbulag'],
 ['MN', '18', '\xc3\x96nd\xc3\xb6rshireet'],
 ['MN', '18', 'Erdenesant'],
 ['MN', '18', 'L\xc3\xbcn'],
 ['MN', '18', 'Bayanhangay'],
 ['MN', '18', 'Argalant'],
 ['MN', '18', 'Bayantsogt'],
 ['MN', '18', 'Ugtaal'],
 ['MN', '18', 'Dzaamar'],
 ['MN', '18', 'Tseel'],
 ['MN', '18', 'Jargalant'],
 ['MN', '18', 'S\xc3\xbcmber'],
 ['MN', '18', 'Bornuur'],
 ['MN', '18', 'Bayanchandman\xc4\xad'],
 ['MN', '18', 'Bats\xc3\xbcmber'],
 ['MN', '18', 'M\xc3\xb6ng\xc3\xb6nmor\xc4\xadt'],
 ['MN', '18', 'Bayandelger'],
 ['MN', '18', 'Erdene'],
 ['MN', '18', 'Arhust'],
 ['MN', '18', 'Bayan'],
 ['MN', '18', 'Bayanjargalan'],
 ['MN', '18', 'Dzuunmod'],
 ['MN', '18', 'Baganuur'],
 ['MN', '20', 'Bayandz\xc3\xbcrh'],
 ['MN', '23', 'Shar\xc3\xafngol'],
 ['MN', '23', 'Hongor'],
 ['MN', '23', 'Orhon'],
 ['MN', '16', 'Mandal'],
 ['MN', '16', 'Orhon'],
 ['MN', '16', 'Sayhan'],
 ['MN', '16', 'Sant'],
 ['MN', '16', 'Baruunb\xc3\xbcren'],
 ['MN', '16', 'Orhontuul'],
 ['MN', '16', 'Shaamar'],
 ['MN', '16', 'Dz\xc3\xbc\xc3\xbcnb\xc3\xbcren'],
 ['MN', '16', 'Tsagaannuur'],
 ['MN', '16', 'T\xc3\xbcshig'],
 ['MN', '16', 'S\xc3\xbchbaatar'],
 ['MN', '16', 'Altanbulag'],
 ['MN', '16', 'Y\xc3\xb6r\xc3\xb6\xc3\xb6'],
 ['MN', '16', 'H\xc3\xbcder'],
 ['MN', '16', 'Javhlant'],
 ['MN', '16', 'Hushaat'],
 ['MN', '25', 'Bayan-\xc3\x96nd\xc3\xb6r'],
 ['MN', '25', 'Jargalant'],
 ['MN', '21', 'Hangal'],
 ['MN', '21', 'Selenge'],
 ['MN', '21', 'Teshig'],
 ['MN', '21', 'Hutag-\xc3\x96nd\xc3\xb6r'],
 ['MN', '21', 'Bugat'],
 ['MN', '21', 'Bayan-Agt'],
 ['MN', '21', 'Sayhan'],
 ['MN', '21', 'Orhon'],
 ['MN', '21', 'Hishig-\xc3\x96nd\xc3\xb6r'],
 ['MN', '21', 'Mogod'],
 ['MN', '21', 'B\xc3\xbcreghangay'],
 ['MN', '21', 'Dashinchilen'],
 ['MN', '21', 'Bayannuur'],
 ['MN', '21', 'Gurvanbulag'],
 ['MN', '01', 'Rashaant'],
 ['MN', '21', 'Bulgan'],
 ['MN', '13', 'Renchinlh\xc3\xbcmbe'],
 ['MN', '13', 'Tsagaannuur'],
 ['MN', '13', 'Ulaan-Uul'],
 ['MN', '13', 'Bayandz\xc3\xbcrh'],
 ['MN', '13', 'Alag-Erdene'],
 ['MN', '13', 'Arbulag'],
 ['MN', '13', 'Tsagaan-Uul'],
 ['MN', '13', 'Tsetserleg'],
 ['MN', '13', 'M\xc3\xb6r\xc3\xb6n'],
 ['MN', '13', 'B\xc3\xbcrentogtoh'],
 ['MN', '13', 'T\xc3\xb6m\xc3\xb6rbulag'],
 ['MN', '13', 'Shine-Ider'],
 ['MN', '13', 'Galt'],
 ['MN', '13', 'Jargalant'],
 ['MN', '13', 'Tosontsengel'],
 ['MN', '13', 'Ih-Uul'],
 ['MN', '13', 'Rashaant'],
 ['MN', '13', 'T\xc3\xbcnel'],
 ['MN', '13', 'Chandman\xc4\xad-\xc3\x96nd\xc3\xb6r'],
 ['MN', '13', 'Tsagaan-\xc3\x9c\xc3\xbcr'],
 ['MN', '13', 'Erdenebulgan'],
 ['MN', '13', 'Hanh'],
 ['MN', '01', 'Tsetserleg'],
 ['MN', '01', 'Jargalant'],
 ['MN', '01', 'Erdenemandal'],
 ['MN', '01', 'Hayrhan'],
 ['MN', '01', 'Erdenebulgan'],
 ['MN', '01', 'Ihtamir'],
 ['MN', '01', '\xc3\x96nd\xc3\xb6r-Ulaan'],
 ['MN', '01', 'Chuluut'],
 ['MN', '01', 'Hangay'],
 ['MN', '01', 'Tsahir'],
 ['MN', '01', 'Bulgan'],
 ['MN', '01', 'Tsenher'],
 ['MN', '01', 'T\xc3\xbcvshr\xc3\xbc\xc3\xbcleh'],
 ['MN', '01', 'Hotont'],
 ['MN', '01', 'Hashaat'],
 ['MN', '01', '\xc3\x96giynuur'],
 ['MN', '01', 'Battsengel'],
 ['MN', '01', '\xc3\x96ldziyt'],
 ['MN', '15', 'Harhorin'],
 ['MN', '15', 'Hujirt'],
 ['MN', '15', 'Bat-\xc3\x96ldziy'],
 ['MN', '15', 'Uyanga'],
 ['MN', '15', 'Dz\xc3\xbc\xc3\xbcnbayan-Ulaan'],
 ['MN', '15', 'Taragt'],
 ['MN', '15', 'Arvayheer'],
 ['MN', '15', 'Hayrhandulaan'],
 ['MN', '15', 'Nariynteel'],
 ['MN', '15', 'Baruunbayan-Ulaan'],
 ['MN', '15', 'Guchin-Us'],
 ['MN', '15', 'Bogd'],
 ['MN', '15', 'T\xc3\xb6gr\xc3\xb6g'],
 ['MN', '15', 'Bayangol'],
 ['MN', '15', 'Sant'],
 ['MN', '15', 'Bayan-\xc3\x96nd\xc3\xb6r'],
 ['MN', '15', '\xc3\x96ldziyt'],
 ['MN', '15', 'Y\xc3\xb6s\xc3\xb6ndz\xc3\xbcyl'],
 ['MN', '15', 'B\xc3\xbcrd'],
 ['MN', '02', 'Dzag'],
 ['MN', '02', 'Gurvanbulag'],
 ['MN', '02', 'Jargalant'],
 ['MN', '02', 'Bayanbulag'],
 ['MN', '02', 'Bayantsagaan'],
 ['MN', '02', 'H\xc3\xbcreemaral'],
 ['MN', '02', 'Buutsagaan'],
 ['MN', '02', 'B\xc3\xb6mb\xc3\xb6g\xc3\xb6r'],
 ['MN', '02', 'Bayan-Ovoo'],
 ['MN', '02', 'Galuut'],
 ['MN', '02', 'Erdenetsogt'],
 ['MN', '02', 'Bayanhongor'],
 ['MN', '02', '\xc3\x96ldziyt'],
 ['MN', '02', 'Jinst'],
 ['MN', '02', 'Bogd'],
 ['MN', '02', 'Bayangov\xc4\xad'],
 ['MN', '02', 'Bayanlig'],
 ['MN', '02', 'Baatsagaan'],
 ['MN', '02', 'Bayan-\xc3\x96nd\xc3\xb6r'],
 ['MN', '02', 'Shinejinst'],
 ['MN', '10', 'H\xc3\xb6hmor\xc4\xadt'],
 ['MN', '10', 'Bayan-Uul'],
 ['MN', '10', 'Jargalan'],
 ['MN', '10', 'Tayshir'],
 ['MN', '10', 'Delger'],
 ['MN', '10', 'Sharga'],
 ['MN', '10', 'Darvi'],
 ['MN', '10', 'Tonhil'],
 ['MN', '10', 'T\xc3\xb6gr\xc3\xb6g'],
 ['MN', '10', 'Bugat'],
 ['MN', '10', 'Y\xc3\xb6s\xc3\xb6nbulag'],
 ['MN', '10', 'Haliun'],
 ['MN', '10', 'Tseel'],
 ['MN', '10', 'Altay'],
 ['MN', '10', 'Tsogt'],
 ['MN', '10', 'Biger'],
 ['MN', '10', 'Chandman\xc4\xad'],
 ['MN', '10', 'Erdene'],
 ['MN', '12', 'Erdeneb\xc3\xbcren'],
 ['MN', '12', 'Buyant'],
 ['MN', '12', 'Myangad'],
 ['MN', '12', 'Jargalant'],
 ['MN', '12', 'Hovd'],
 ['MN', '12', 'Duut'],
 ['MN', '12', 'Manhan'],
 ['MN', '12', 'Dzereg'],
 ['MN', '12', 'M\xc3\xb6nhhayrhan'],
 ['MN', '12', 'Chandman\xc4\xad'],
 ['MN', '12', 'Darvi'],
 ['MN', '12', 'Tsetseg'],
 ['MN', '12', 'M\xc3\xb6st'],
 ['MN', '12', '\xc3\x9cy\xc3\xb6nch'],
 ['MN', '12', 'Bulgan'],
 ['MN', '12', 'Altay'],
 ['MN', '03', 'Tsagaannuur'],
 ['MN', '03', 'Nogoonnuur'],
 ['MN', '03', 'Ulaanhus'],
 ['MN', '03', 'Tsengel'],
 ['MN', '03', 'Sagsay'],
 ['MN', '03', 'Bugat'],
 ['MN', '03', '\xc3\x96lgiy'],
 ['MN', '03', 'Altants\xc3\xb6gts'],
 ['MN', '03', 'Tolbo'],
 ['MN', '03', 'Altay'],
 ['MN', '03', 'Buyant'],
 ['MN', '03', 'Del\xc3\xbc\xc3\xbcn'],
 ['MN', '03', 'Bulgan'],
 ['MN', '19', 'Davst'],
 ['MN', '19', 'Sagil'],
 ['MN', '19', 'T\xc3\xbcrgen'],
 ['MN', '19', 'Tarialan'],
 ['MN', '19', 'Ulaangom'],
 ['MN', '19', 'Naranbulag'],
 ['MN', '19', '\xc3\x96lgiy'],
 ['MN', '19', '\xc3\x96mn\xc3\xb6gov\xc4\xad'],
 ['MN', '19', 'Hovd'],
 ['MN', '19', 'B\xc3\xb6hm\xc3\xb6r\xc3\xb6n'],
 ['MN', '19', 'Tes'],
 ['MN', '19', 'Dz\xc3\xbc\xc3\xbcngov\xc4\xad'],
 ['MN', '19', 'Malchin'],
 ['MN', '19', 'Dzavhan'],
 ['MN', '19', 'Hyargas'],
 ['MN', '19', 'Tsagaanhayrhan'],
 ['MN', '19', 'Baruunturuun'],
 ['MN', '19', '\xc3\x96nd\xc3\xb6rhangay'],
 ['MN', '19', 'Dz\xc3\xbc\xc3\xbcnhangay'],
 ['MN', '09', 'Bayantes'],
 ['MN', '09', 'Tes'],
 ['MN', '09', 'Asgat'],
 ['MN', '09', 'Bayanhayrhan'],
 ['MN', '09', 'T\xc3\xbcdevtey'],
 ['MN', '09', 'Tsetsen-Uul'],
 ['MN', '09', 'N\xc3\xb6mr\xc3\xb6g'],
 ['MN', '09', 'Santmargats'],
 ['MN', '09', 'Urgamal'],
 ['MN', '09', 'Dzavhanmandal'],
 ['MN', '10', 'D\xc3\xb6rv\xc3\xb6ljin'],
 ['MN', '09', 'Erdenehayrhan'],
 ['MN', '09', 'Uliastay'],
 ['MN', '09', 'Aldarhaan'],
 ['MN', '09', 'Yaruu'],
 ['MN', '09', 'Tsagaanhayrhan'],
 ['MN', '09', 'Tsagaanchuluut'],
 ['MN', '09', 'Shil\xc3\xbc\xc3\xbcstey'],
 ['MN', '09', 'Otgon'],
 ['MN', '09', 'Ider'],
 ['MN', '09', 'Telmen'],
 ['MN', '09', 'Tosontsengel'],
 ['MN', '09', 'Ih-Uul'],
 ['MN', '10', 'Altay Sum'],
 ['MN', '10', 'Bugat Sum'],
 ['MN', '03', 'Bulgan Sum'],
 ['MN', '03', 'Del\xc3\xbc\xc3\xbcn Sum'],
 ['MN', '03', 'Altay Sum'],
 ['MN', '03', 'Tolbo Sum'],
 ['MN', '03', 'Sagsay Sum'],
 ['MN', '03', 'Bugat Sum'],
 ['MN', '03', 'Altants\xc3\xb6gts Sum'],
 ['MN', '03', 'Bayannuur Sum'],
 ['MN', '03', 'Ulaanhus Sum'],
 ['MN', '03', 'Tsengel Sum'],
 ['MN', '03', 'Nogoonnuur Sum'],
 ['MN', '12', 'M\xc3\xb6nhhayrhan Sum'],
 ['MN', '12', 'Duut Sum'],
 ['MN', '12', 'Hovd Sum'],
 ['MN', '12', 'Erdeneb\xc3\xbcren Sum'],
 ['MN', '12', 'Myangad Sum'],
 ['MN', '12', 'Manhan Sum'],
 ['MN', '12', 'Dzereg Sum'],
 ['MN', '12', 'Darvi Sum'],
 ['MN', '12', 'Chandman\xc4\xad Sum'],
 ['MN', '12', 'D\xc3\xb6rg\xc3\xb6n Sum'],
 ['MN', '19', 'B\xc3\xb6hm\xc3\xb6r\xc3\xb6n Sum'],
 ['MN', '19', 'Hovd Sum'],
 ['MN', '19', '\xc3\x96mn\xc3\xb6gov\xc4\xad Sum'],
 ['MN', '19', 'Sagil Sum'],
 ['MN', '19', 'T\xc3\xbcrgen Sum'],
 ['MN', '19', 'Tarialan Sum'],
 ['MN', '03', 'Buyant Sum'],
 ['MN', '19', 'Davst Sum'],
 ['MN', '19', 'Naranbulag Sum'],
 ['MN', '19', '\xc3\x96lgiy Sum'],
 ['MN', '19', 'Dzavhan Sum'],
 ['MN', '19', 'Malchin Sum'],
 ['MN', '19', 'Tes Sum'],
 ['MN', '19', 'Tsagaanhayrhan Sum'],
 ['MN', '19', '\xc3\x96nd\xc3\xb6rhangay Sum'],
 ['MN', '19', 'Dz\xc3\xbc\xc3\xbcnhangay Sum'],
 ['MN', '19', 'Baruunturuun Sum'],
 ['MN', '19', 'Dz\xc3\xbc\xc3\xbcngov\xc4\xad Sum'],
 ['MN', '19', 'Hyargas Sum'],
 ['MN', '10', 'H\xc3\xb6hmor\xc4\xadt Sum'],
 ['MN', '10', 'Bayan-Uul Sum'],
 ['MN', '09', 'Aldarhaan Sum'],
 ['MN', '09', 'Dorvoljin Sum'],
 ['MN', '09', 'Yaruu Sum'],
 ['MN', '09', 'Dzavhanmandal Sum'],
 ['MN', '09', 'Urgamal Sum'],
 ['MN', '09', 'Santmargats Sum'],
 ['MN', '09', 'Tes Sum'],
 ['MN', '12', 'Buyant Sum'],
 ['MN', '10', 'Tonhil Sum'],
 ['MN', '10', 'Tseel Sum'],
 ['MN', '10', 'T\xc3\xb6gr\xc3\xb6g Sum'],
 ['MN', '10', 'Sharga Sum'],
 ['MN', '10', 'Darvi Sum'],
 ['MN', '12', 'Altay Sum'],
 ['MN', '12', '\xc3\x9cyench Sum'],
 ['MN', '12', 'Bulgan Sum'],
 ['MN', '12', 'Tsetseg Sum'],
 ['MN', '12', 'M\xc3\xb6st Sum'],
 ['MN', '21', 'Rashaant Sum'],
 ['MN', '21', 'Gurvanbulag Sum'],
 ['MN', '21', 'Hishig-\xc3\x96nd\xc3\xb6r Sum'],
 ['MN', '21', 'Mogod Sum'],
 ['MN', '21', 'Sayhan Sum'],
 ['MN', '21', 'Hutag-\xc3\x96nd\xc3\xb6r Sum'],
 ['MN', '21', 'Bayan-Agt Sum'],
 ['MN', '21', 'Teshig Sum'],
 ['MN', '01', 'Hashaat Sum'],
 ['MN', '01', '\xc3\x96giynuur Sum'],
 ['MN', '01', 'Tsenher Sum'],
 ['MN', '01', 'T\xc3\xb6vshr\xc3\xbc\xc3\xbcleh Sum'],
 ['MN', '01', 'Bulgan Sum'],
 ['MN', '01', '\xc3\x96ldziyt Sum'],
 ['MN', '01', 'Battsengel Sum'],
 ['MN', '01', 'Chuluut Sum'],
 ['MN', '01', 'Hangay Sum'],
 ['MN', '01', 'Tsahir Sum'],
 ['MN', '01', '\xc3\x96nd\xc3\xb6r-Ulaan Sum'],
 ['MN', '01', 'Erdenemandal Sum'],
 ['MN', '01', 'Hayrhan Sum'],
 ['MN', '01', 'Jargalant Sum'],
 ['MN', '01', 'Tsetserleg Sum'],
 ['MN', '02', 'Jargalant Sum'],
 ['MN', '02', 'Gurvanbulag Sum'],
 ['MN', '02', 'Bayanbulag Sum'],
 ['MN', '09', 'Shil\xc3\xbc\xc3\xbcstey Sum'],
 ['MN', '09', 'Tsagaanhayrhan Sum'],
 ['MN', '09', 'Ider Sum'],
 ['MN', '09', 'Tosontsengel Sum'],
 ['MN', '09', 'Ih-Uul Sum'],
 ['MN', '09', 'Erdenehayrhan Sum'],
 ['MN', '09', 'Tsetsen-Uul Sum'],
 ['MN', '09', 'T\xc3\xbcdevtey Sum'],
 ['MN', '09', 'N\xc3\xb6mr\xc3\xb6g Sum'],
 ['MN', '09', 'Telmen Sum'],
 ['MN', '09', 'Songino Sum'],
 ['MN', '09', 'Bayanhayrhan Sum'],
 ['MN', '09', 'Asgat Sum'],
 ['MN', '09', 'Bayantes Sum'],
 ['MN', '13', 'Jargalant Sum'],
 ['MN', '13', 'Galt Sum'],
 ['MN', '13', 'Shine-Ider Sum'],
 ['MN', '13', 'T\xc3\xb6m\xc3\xb6rbulag Sum'],
 ['MN', '13', 'Rashaant Sum'],
 ['MN', '13', 'Tosontsengel Sum'],
 ['MN', '13', 'Ih-Uul Sum'],
 ['MN', '13', 'Tarialan Sum'],
 ['MN', '13', 'B\xc3\xbcrentogtoh Sum'],
 ['MN', '13', 'T\xc3\xbcnel Sum'],
 ['MN', '13', 'Erdenebulgan Sum'],
 ['MN', '13', 'Tsagaan-Uul Sum'],
 ['MN', '13', 'Tsetserleg Sum'],
 ['MN', '13', 'Bayandz\xc3\xbcrh Sum'],
 ['MN', '13', 'Arbulag Sum'],
 ['MN', '13', 'Alag-Erdene Sum'],
 ['MN', '13', 'Chandman\xc4\xad-\xc3\x96nd\xc3\xb6r Sum'],
 ['MN', '13', 'Tsagaan-\xc3\x9c\xc3\xbcr Sum'],
 ['MN', '13', 'Hanh Sum'],
 ['MN', '13', 'Ulaan-Uul Sum'],
 ['MN', '13', 'Tsagaannuur Sum'],
 ['MN', '13', 'Renchinlhumbe Sum'],
 ['MN', '21', 'Selenge Sum'],
 ['MN', '14', 'Bayandalay Sum'],
 ['MN', '14', 'Noyon Sum'],
 ['MN', '14', 'Gurvantes Sum'],
 ['MN', '14', 'Sevrey Sum'],
 ['MN', '15', 'T\xc3\xb6gr\xc3\xb6g Sum'],
 ['MN', '15', 'Guchin-Us Sum'],
 ['MN', '15', 'Baruunbayan-Ulaan Sum'],
 ['MN', '15', 'Bayangol Sum'],
 ['MN', '15', 'Sant Sum'],
 ['MN', '15', 'Taragt Sum'],
 ['MN', '15', 'Hayrhandulaan Sum'],
 ['MN', '15', 'Nariynteel Sum'],
 ['MN', '15', '\xc3\x96ldziyt Sum'],
 ['MN', '15', 'Dz\xc3\xbc\xc3\xbcnbayan-Ulaan Sum'],
 ['MN', '15', 'Uyanga Sum'],
 ['MN', '15', 'Bat-\xc3\x96ldziy Sum'],
 ['MN', '15', 'Hujirt Sum'],
 ['MN', '15', 'Harhorin Sum'],
 ['MN', '15', 'B\xc3\xbcrd Sum'],
 ['MN', '02', 'Shinejinst Sum'],
 ['MN', '02', 'Bayan-\xc3\x96nd\xc3\xb6r Sum'],
 ['MN', '02', 'Bayangov\xc4\xad Sum'],
 ['MN', '02', 'Bayanlig Sum'],
 ['MN', '02', 'Bogd Sum'],
 ['MN', '02', 'Jinst Sum'],
 ['MN', '02', 'Bayantsagaan Sum'],
 ['MN', '02', 'Baatsagaan Sum'],
 ['MN', '02', '\xc3\x96ldziyt Sum'],
 ['MN', '02', 'Bayan-Ovoo Sum'],
 ['MN', '02', 'B\xc3\xb6mb\xc3\xb6g\xc3\xb6r Sum'],
 ['MN', '02', 'Buutsagaan Sum'],
 ['MN', '02', 'H\xc3\xbcreemaral Sum'],
 ['MN', '02', 'Dzag Sum'],
 ['MN', '02', 'Galuut Sum'],
 ['MN', '02', 'Erdenetsogt Sum'],
 ['MN', '01', 'Hotont Sum'],
 ['MN', '10', 'Erdene Sum'],
 ['MN', '10', 'Tsogt Sum'],
 ['MN', '10', 'Chandman\xc4\xad Sum'],
 ['MN', '10', 'Biger Sum'],
 ['MN', '10', 'Haliun Sum'],
 ['MN', '10', 'Delger Sum'],
 ['MN', '10', 'Y\xc3\xb6s\xc3\xb6nbulag Sum'],
 ['MN', '10', 'Tayshir Sum'],
 ['MN', '10', 'Jargalan Sum'],
 ['MN', '09', 'Tsagaanchuluut Sum'],
 ['MN', '09', 'Otgon Sum'],
 ['MN', '01', 'Ihtamir Sum'],
 ['MN', '17', 'M\xc3\xb6nhhaan Sum'],
 ['MN', '11', 'Batnorov Sum'],
 ['MN', '11', 'Herlen Sum'],
 ['MN', '11', 'M\xc3\xb6r\xc3\xb6n Sum'],
 ['MN', '11', 'Bayanm\xc3\xb6nh Sum'],
 ['MN', '11', 'Delgerhaan Sum'],
 ['MN', '11', 'Tsenhermandal Sum'],
 ['MN', '11', 'Jargalthaan Sum'],
 ['MN', '11', '\xc3\x96mn\xc3\xb6delger Sum'],
 ['MN', '11', 'Batshireet Sum'],
 ['MN', '11', 'Binder Sum'],
 ['MN', '11', 'Bayan-Adarga Sum'],
 ['MN', '11', 'Norovlin Sum'],
 ['MN', '11', 'Dadal Sum'],
 ['MN', '18', 'Bayan Sum'],
 ['MN', '18', 'Sergelen Sum'],
 ['MN', '18', 'Bayandelger Sum'],
 ['MN', '18', 'Erdene Sum'],
 ['MN', '18', 'M\xc3\xb6ng\xc3\xb6nmor\xc4\xadt Sum'],
 ['MN', '18', 'Altanbulag Sum'],
 ['MN', '18', '\xc3\x96nd\xc3\xb6rshireet Sum'],
 ['MN', '18', 'L\xc3\xbcn Sum'],
 ['MN', '18', 'Bayanhangay Sum'],
 ['MN', '18', 'Argalant Sum'],
 ['MN', '18', 'Bayanchandman\xc4\xad Sum'],
 ['MN', '18', 'Dzaamar Sum'],
 ['MN', '18', 'Tseel Sum'],
 ['MN', '18', 'Ugtaaltsaydam Sum'],
 ['MN', '18', 'Jargalant Sum'],
 ['MN', '18', 'Bornuur Sum'],
 ['MN', '18', 'S\xc3\xbcmber Sum'],
 ['MN', '18', 'Bats\xc3\xbcmber Sum'],
 ['MN', '16', 'Orhontuul Sum'],
 ['MN', '16', 'Baruunb\xc3\xbcren Sum'],
 ['MN', '16', 'Orhon Sum'],
 ['MN', '16', 'Sayhan Sum'],
 ['MN', '16', 'Sant Sum'],
 ['MN', '16', 'Hushaat Sum'],
 ['MN', '16', 'Dz\xc3\xbc\xc3\xbcnb\xc3\xbcren Sum'],
 ['MN', '16', 'Tsagaannuur Sum'],
 ['MN', '16', 'T\xc3\xbcshig Sum'],
 ['MN', '16', 'Shaamar Sum'],
 ['MN', '16', 'Altanbulag Sum'],
 ['MN', '16', 'Javhlant Sum'],
 ['MN', '16', 'Y\xc3\xb6r\xc3\xb6\xc3\xb6 Sum'],
 ['MN', '16', 'H\xc3\xbcder Sum'],
 ['MN', '16', 'Mandal Sum'],
 ['MN', '16', 'Bayangol Sum'],
 ['MN', '21', 'Dashinchilen Sum'],
 ['MN', '21', 'Bayannuur Sum'],
 ['MN', '21', 'B\xc3\xbcreghangay Sum'],
 ['MN', '21', 'Orhon Sum'],
 ['MN', '25', 'Jargalant Sum'],
 ['MN', '25', 'Erdenet Sum'],
 ['MN', '21', 'Hangal Sum'],
 ['MN', '21', 'Bugat Sum'],
 ['MN', '23', 'Orhon Sum'],
 ['MN', '23', 'Hongor Sum'],
 ['MN', '14', 'H\xc3\xbcrmen Sum'],
 ['MN', '14', 'Bayan-Ovoo Sum'],
 ['MN', '14', 'Hanbogd Sum'],
 ['MN', '14', 'Manlay Sum'],
 ['MN', '14', 'Tsogttsetsiy Sum'],
 ['MN', '14', 'Hanhongor Sum'],
 ['MN', '14', 'Tsogt-Ovoo Sum'],
 ['MN', '14', 'Bulgan Sum'],
 ['MN', '14', 'Mandal-Ovoo Sum'],
 ['MN', '08', '\xc3\x96ldziyt Sum'],
 ['MN', '08', 'Huld Sum'],
 ['MN', '08', 'Delgerhangay Sum'],
 ['MN', '08', 'Erdenedalay Sum'],
 ['MN', '08', 'Luus Sum'],
 ['MN', '08', 'Adaatsag Sum'],
 ['MN', '08', 'Delgertsogt Sum'],
 ['MN', '08', '\xc3\x96nd\xc3\xb6rshil Sum'],
 ['MN', '08', 'Deren Sum'],
 ['MN', '08', 'Bayanjargalan Sum'],
 ['MN', '08', 'Gov\xc4\xad-Ugtaal Sum'],
 ['MN', '08', 'Tsagaandelger Sum'],
 ['MN', '15', 'Bayan-\xc3\x96nd\xc3\xb6r Sum'],
 ['MN', '18', 'Delgerhaan Sum'],
 ['MN', '18', 'Erdenesant Sum'],
 ['MN', '18', 'B\xc3\xbcren Sum'],
 ['MN', '18', 'Bayantsagaan Sum'],
 ['MN', '18', 'Bayanjargalan Sum'],
 ['MN', '24', 'Bayantal Sum'],
 ['MN', '24', 'Bayan Sum'],
 ['MN', '24', 'S\xc3\xbcmber Sum'],
 ['MN', '11', 'Darhan Sum'],
 ['MN', '11', 'Galshar Sum'],
 ['MN', '11', 'Bayanhutag Sum'],
 ['MN', '17', 'Uulbayan Sum'],
 ['MN', '07', 'Hatanbulag Sum'],
 ['MN', '07', 'Mandah Sum'],
 ['MN', '07', 'H\xc3\xb6vsg\xc3\xb6l Sum'],
 ['MN', '07', 'Ulaanbadrah Sum'],
 ['MN', '07', 'Erdene Sum'],
 ['MN', '07', '\xc3\x96rg\xc3\xb6n Sum'],
 ['MN', '07', 'Sayhandulaan Sum'],
 ['MN', '07', 'Ayrag Sum'],
 ['MN', '07', 'Dalanjargalan Sum'],
 ['MN', '07', 'Ihhet Sum'],
 ['MN', '07', 'Altanshiree Sum'],
 ['MN', '07', 'Delgereh Sum'],
 ['MN', '08', 'Sayhan-Ovoo Sum'],
 ['MN', '17', 'T\xc3\xbcmentsogt Sum'],
 ['MN', '11', 'Bayan-Ovoo Sum'],
 ['MN', '06', 'Matad Sum'],
 ['MN', '06', 'Bayant\xc3\xbcmen Sum'],
 ['MN', '06', 'Bulgan Sum'],
 ['MN', '06', 'H\xc3\xb6l\xc3\xb6nbuyr Sum'],
 ['MN', '06', 'Tsagaan-Ovoo Sum'],
 ['MN', '06', 'Sergelen Sum'],
 ['MN', '06', 'Choybalsan Sum'],
 ['MN', '06', 'Bayan-Uul Sum'],
 ['MN', '06', 'Bayandun Sum'],
 ['MN', '06', 'Dashbalbar Sum'],
 ['MN', '06', 'Gurvanzagal Sum'],
 ['MN', '06', 'Chuluunhoroot Sum'],
 ['MN', '17', 'Bayandelger Sum'],
 ['MN', '17', 'Ongon Sum'],
 ['MN', '17', 'Naran Sum'],
 ['MN', '17', 'Dar\xc4\xadganga Sum'],
 ['MN', '17', 'Erdenetsagaan Sum'],
 ['MN', '17', 'Asgat Sum'],
 ['MN', '17', 'Haldzan Sum'],
 ['MN', '17', 'T\xc3\xbcvshinshiree Sum'],
 ['MN', '17', 'S\xc3\xbchbaatar Sum'],
 ['MN', '06', 'Halhgol Sum'],
 ['MN', '08', 'Gurvansayhan Sum'],
 ['MN', '23', 'Shar\xc3\xafngol Sum'],
 ['MN', '07', 'Saynshand Sum'],
 ['MN', '08', 'Sayntsagaan Sum'],
 ['MN', '01', 'Erdenebulgan Sum'],
 ['MN', '02', 'Bayanhongor Sum'],
 ['MN', '03', 'Tsagaannuur Sum'],
 ['MN', '03', '\xc3\x96lgiy Sum'],
 ['MN', '07', 'Dzam\xc3\xafn-\xc3\x9c\xc3\xbcd Sum'],
 ['MN', '13', 'M\xc3\xb6r\xc3\xb6n Sum'],
 ['MN', '14', 'Dalanzadgad Sum'],
 ['MN', '15', 'Arvaiheer Sum'],
 ['MN', '17', 'Baruun-Urt Sum'],
 ['MN', '01', 'Khairkhan'],
 ['MN', '01', 'Ogii nuur'],
 ['MN', '01', 'Olziit'],
 ['MN', '02', 'Olziit'],
 ['MN', '21', 'B\xc3\xbcregkhangai'],
 ['MP', '085', 'Farallon de Pajaros'],
 ['MP', '085', 'Asuncion Island'],
 ['MP', '085', 'Agrihan Island'],
 ['MP', '085', 'Pagan Island'],
 ['MP', '085', 'Alamagan Island'],
 ['MP', '085', 'Guguan Island'],
 ['MP', '085', 'Zealandia Bank'],
 ['MP', '085', 'Sarigan Island'],
 ['MP', '085', 'Anatahan Island'],
 ['MP', '085', 'Farallon de Medinilla'],
 ['MP', '085', 'Maug Islands'],
 ['MP', '120', 'Aguijan Island'],
 ['MQ', 'MQ', 'Martinique'],
 ['MR', '05', 'Aleg'],
 ['MR', '06', 'Rosso Department'],
 ['MR', '09', 'Tidjikja'],
 ['MR', '06', 'Nouakchott'],
 ['MR', '06', 'Ouad Naga'],
 ['MR', '06', 'Mederdra'],
 ['MR', '06', 'Boutilimit'],
 ['MR', '05', 'Aleg'],
 ['MR', '05', 'Bogu\xc3\xa9 Department'],
 ['MV', '53', 'Ari Atholhu Uthuruburi'],
 ['MW', 'N', 'Chitipa District'],
 ['MW', 'S', 'Zomba District'],
 ['MW', 'C', 'Salima District'],
 ['MW', 'N', 'Rumphi District'],
 ['MW', 'C', 'Ntchisi District'],
 ['MW', 'S', 'Nsanje District'],
 ['MW', 'C', 'Nkhotakota District'],
 ['MW', 'N', 'Nkhata Bay District'],
 ['MW', 'C', 'Ntcheu District'],
 ['MW', 'N', 'Mzimba District'],
 ['MW', 'S', 'Mwanza District'],
 ['MW', 'S', 'Mulanje District'],
 ['MW', 'C', 'Mchinji District'],
 ['MW', 'S', 'Mangochi District'],
 ['MW', 'S', 'Machinga District'],
 ['MW', 'C', 'Lilongwe District'],
 ['MW', 'C', 'Kasungu District'],
 ['MW', 'N', 'Karonga District'],
 ['MW', 'C', 'Dowa District'],
 ['MW', 'C', 'Dedza District'],
 ['MW', 'S', 'Thyolo District'],
 ['MW', 'S', 'Chiradzulu District'],
 ['MW', 'S', 'Chikwawa District'],
 ['MW', 'S', 'Blantyre District'],
 ['MW', 'S', 'Balaka District'],
 ['MW', 'N', 'Likoma District'],
 ['MW', 'S', 'Phalombe District'],
 ['MW', 'S', 'Neno District'],
 ['MX', '03', 'Los Cabos'],
 ['MX', '03', 'Loreto'],
 ['MX', '03', 'La Paz'],
 ['MX', '03', 'Muleg\xc3\xa9'],
 ['MX', '03', 'Comond\xc3\xba'],
 ['MX', '02', 'Ensenada'],
 ['MX', '02', 'Mexicali'],
 ['MX', '02', 'Tecate'],
 ['MX', '02', 'Tijuana'],
 ['MX', '02', 'Playas de Rosarito'],
 ['MX', '01', 'Aguascalientes'],
 ['MX', '01', 'Asientos'],
 ['MX', '01', 'Calvillo'],
 ['MX', '01', 'Cos\xc3\xado'],
 ['MX', '01', 'Jes\xc3\xbas Mar\xc3\xada'],
 ['MX', '01', 'Pabell\xc3\xb3n de Arteaga'],
 ['MX', '01', 'Rinc\xc3\xb3n de Romos'],
 ['MX', '01', 'San Jos\xc3\xa9 de Gracia'],
 ['MX', '01', 'Tepezal\xc3\xa1'],
 ['MX', '01', 'El Llano'],
 ['MX', '01', 'San Francisco de los Romo'],
 ['MX', '04', 'Calkin\xc3\xad'],
 ['MX', '04', 'Campeche'],
 ['MX', '04', 'Carmen'],
 ['MX', '04', 'Champot\xc3\xb3n'],
 ['MX', '04', 'Hecelchak\xc3\xa1n'],
 ['MX', '04', 'Palizada'],
 ['MX', '04', 'Tenabo'],
 ['MX', '04', 'Esc\xc3\xa1rcega'],
 ['MX', '04', 'Calakmul'],
 ['MX', '04', 'Candelaria'],
 ['MX', '17', 'Puente de Ixtla'],
 ['MX', '05', 'Acacoyagua'],
 ['MX', '05', 'Acala'],
 ['MX', '05', 'Acapetahua'],
 ['MX', '05', 'Aldama'],
 ['MX', '05', 'Altamirano'],
 ['MX', '05', 'Amat\xc3\xa1n'],
 ['MX', '05', 'Amatenango de la Frontera'],
 ['MX', '05', 'Amatenango del Valle'],
 ['MX', '05', '\xc3\x81ngel Albino Corzo'],
 ['MX', '05', 'Arriaga'],
 ['MX', '05', 'Bejucal de Ocampo'],
 ['MX', '05', 'Bella Vista'],
 ['MX', '05', 'Benem\xc3\xa9rito de las Am\xc3\xa9ricas'],
 ['MX', '05', 'Berrioz\xc3\xa1bal'],
 ['MX', '05', 'Bochil'],
 ['MX', '05', 'El Bosque'],
 ['MX', '05', 'Cacahoat\xc3\xa1n'],
 ['MX', '05', 'Catazaj\xc3\xa1'],
 ['MX', '05', 'Chalchihuit\xc3\xa1n'],
 ['MX', '05', 'Chamula'],
 ['MX', '05', 'Chanal'],
 ['MX', '05', 'Chapultenango'],
 ['MX', '05', 'Chenalh\xc3\xb3'],
 ['MX', '05', 'Chiapa de Corzo'],
 ['MX', '05', 'Chiapilla'],
 ['MX', '05', 'Chicoas\xc3\xa9n'],
 ['MX', '05', 'Chicomuselo'],
 ['MX', '05', 'Chil\xc3\xb3n'],
 ['MX', '05', 'Cintalapa'],
 ['MX', '05', 'Coapilla'],
 ['MX', '05', 'Comit\xc3\xa1n'],
 ['MX', '05', 'La Concordia'],
 ['MX', '05', 'Copainal\xc3\xa1'],
 ['MX', '05', 'Escuintla'],
 ['MX', '05', 'Francisco Le\xc3\xb3n'],
 ['MX', '28', 'Reynosa'],
 ['MX', '06', 'Tem\xc3\xb3sachi'],
 ['MX', '14', 'Bola\xc3\xb1os'],
 ['MX', '30', 'Huatusco'],
 ['MX', '03', 'Isla Espiritu Santo'],
 ['MX', '05', 'San Cristobal De Casas'],
 ['MX', '10', 'San Dimas'],
 ['MX', '15', 'Xonacatlan'],
 ['MX', '09', 'Naucalpan de Ju\xc3\xa1rez'],
 ['MX', '14', 'Guadalajara Metropolitan Area'],
 ['MX', '15', 'Ecatepec de Morelos'],
 ['MX', '15', 'Acolman de Nezahualc\xc3\xb3yotl'],
 ['MX', '09', '\xc3\x81lvaro Obreg\xc3\xb3n'],
 ['MX', '15', 'Amecameca'],
 ['MX', '15', 'Apaxco'],
 ['MX', '15', 'Atenco'],
 ['MX', '15', 'Atizap\xc3\xa1n de Zaragoza'],
 ['MX', '15', 'Atlautla'],
 ['MX', '15', 'Axapusco'],
 ['MX', '15', 'Ayapango'],
 ['MX', '15', 'Azcapotzalco'],
 ['MX', '09', 'Benito Ju\xc3\xa1rez'],
 ['MX', '15', 'Chalco'],
 ['MY', '00', 'Langkawi'],
 ['MY', '16', 'Bahagian Pantai Barat'],
 ['MY', '00', 'Temerluh'],
 ['MY', '01', 'Daerah Batu Pahat'],
 ['MY', '01', 'Daerah Pontian'],
 ['MY', '01', 'Daerah Kota Tinggi'],
 ['MY', '01', 'Daerah Johor Baharu'],
 ['MY', '01', 'Daerah Keluang'],
 ['MY', '01', 'Daerah Mersing'],
 ['MY', '01', 'Daerah Segamat'],
 ['MY', '01', 'Daerah Muar'],
 ['MY', '12', 'Kuala Selangor'],
 ['MY', '12', 'Klang'],
 ['MY', '16', 'Bahagian Sandakan'],
 ['MY', '16', 'Bahagian Tawau'],
 ['MY', '16', 'Bahagian Pedalaman'],
 ['MY', '02', 'Kulim'],
 ['MY', '07', 'Larut Matang & Selama'],
 ['MY', '02', 'Bandar Baharu'],
 ['MY', '02', 'Baling'],
 ['MY', '03', 'Tanah Merah'],
 ['MY', '11', 'Bahagian Kuching'],
 ['MY', '12', 'Kuala Langat'],
 ['MY', '12', 'Sepang'],
 ['MY', '00', 'Daerha Rompin'],
 ['MY', '00', 'Bera'],
 ['MY', '09', 'Selatan'],
 ['MY', '09', 'Daerah Timur Laut'],
 ['MY', '12', 'Gombak'],
 ['MY', '12', 'Hulu Selangor'],
 ['MY', '12', 'Petaling'],
 ['MY', '12', 'Hulu Langat'],
 ['MY', '12', 'Sabak Bernam'],
 ['MY', '00', 'Daerah Jerantut'],
 ['MY', '00', 'Daerah Barat Daya'],
 ['MY', '02', 'Yan'],
 ['MY', '11', 'Bahagian Sarikei'],
 ['MY', '02', 'Kubang Pasu'],
 ['MY', '02', 'Padang Terap'],
 ['MY', '00', 'Pendang'],
 ['MY', '02', 'Daerah Kota Setar'],
 ['MY', '03', 'Kota Bharu'],
 ['MY', '16', 'Bahagian Pantai Barat'],
 ['MY', '11', 'Bahagian Sri Aman'],
 ['MY', '11', 'Bahagian Sibu'],
 ['MY', '11', 'Bahagian Limbang'],
 ['MY', '11', 'Bahagian Kapit'],
 ['MY', '11', 'Bahagian Miri'],
 ['MY', '16', 'Bahagian Kudat'],
 ['MY', '11', 'Bahagian Bintulu'],
 ['MY', '11', 'Bahagian Samarahan'],
 ['MY', '02', 'Kuala Muda'],
 ['MY', '02', 'Kota Setar'],
 ['MY', '09', 'Utara'],
 ['MY', '09', 'Barat Daya'],
 ['MY', '02', 'Naga Lilit'],
 ['MY', '02', 'Bagan Sena'],
 ['MY', '02', 'Bakai'],
 ['MY', '02', 'Mahang'],
 ['MY', '03', 'Jeli'],
 ['MY', '09', 'Seberang Perai'],
 ['MZ', '00', 'Circunscri\xc3\xa7\xc3\xa3o de Mung\xc3\xa1ri'],
 ['MZ', '00', 'Circunscr\xc3\xac\xc3\xa7\xc3\xa3o de Moma'],
 ['MZ', '00', 'Distrito de Manjacaze'],
 ['MZ', '00', 'Concelho de Manica'],
 ['MZ', '00', 'Circunscri\xc3\xa7\xc3\xa3o do Govuro'],
 ['MZ', '00', 'Gorongosa District'],
 ['MZ', '00', 'Barue District'],
 ['MZ', '10', 'Gondola District'],
 ['MZ', '01', 'Pemba'],
 ['MZ', '03', 'Vilankulos District'],
 ['MZ', '04', 'Matutiune District'],
 ['MZ', '10', 'Sussundenga District'],
 ['MZ', '02', 'Chicualacuala'],
 ['MZ', '02', 'Massingir'],
 ['MZ', '03', 'Mabote'],
 ['MZ', '02', 'Massangena'],
 ['MZ', '02', 'Chigubo'],
 ['MZ', '02', 'Mabalane'],
 ['MZ', '04', 'Aeroporto'],
 ['MZ', '04', 'Distrito Municipal 1'],
 ['MZ', '04', 'Distrito Municipal 2'],
 ['MZ', '04', 'Distrito Municipal 3'],
 ['MZ', '04', 'Distrito Municipal 4'],
 ['MZ', '04', 'Distrito Municipal 5'],
 ['MZ', '07', 'Cuamba'],
 ['MZ', '06', 'Malema'],
 ['MZ', '06', 'Ribaue'],
 ['MZ', '06', 'Nampula'],
 ['MZ', '06', 'Mecuburi'],
 ['MZ', '06', 'Cidade de Nampula'],
 ['MZ', '04', 'Magude District'],
 ['MZ', '04', 'Moamba District'],
 ['MZ', '04', 'Boane District'],
 ['MZ', '05', 'Nhamatanda District'],
 ['MZ', '05', 'Chibabava District'],
 ['MZ', '05', 'Dondo District'],
 ['MZ', '09', 'Nicodala District'],
 ['MZ', '09', 'Gurue District'],
 ['MZ', '09', 'Morrumbala District'],
 ['MZ', '02', 'Xai-Xai District'],
 ['MZ', '10', 'Guro District'],
 ['MZ', '05', 'Caia District'],
 ['MZ', '02', 'Chokwe District'],
 ['MZ', '08', 'Tsangano District'],
 ['MZ', '07', 'Lichinga District'],
 ['MZ', '07', 'Majune District'],
 ['MZ', '01', 'Balama District'],
 ['MZ', '04', 'Matutu\xc3\xadne District'],
 ['MZ', '06', 'Angoche District'],
 ['MZ', '06', 'Lalaua District'],
 ['MZ', '06', 'Muecate District'],
 ['MZ', '06', 'Nacaroa District'],
 ['MZ', '07', 'Lago District'],
 ['MZ', '07', 'Ma\xc3\xbaa District'],
 ['MZ', '07', 'Mecanhelas District'],
 ['MZ', '07', 'Metarica District'],
 ['MZ', '07', 'Muembe District'],
 ['MZ', '07', 'Ngauma District'],
 ['MZ', '07', 'Nipepe District'],
 ['MZ', '05', 'Chemba District'],
 ['MZ', '05', 'Muanza District'],
 ['MZ', '05', 'Maringu\xc3\xa9 District'],
 ['MZ', '05', 'Machanga District'],
 ['MZ', '05', 'Cheringoma District'],
 ['MZ', '10', 'Machaze District'],
 ['MZ', '10', 'Macossa District'],
 ['MZ', '10', 'Tambara District'],
 ['MZ', '09', 'Gil\xc3\xa9 District'],
 ['MZ', '09', 'Lugela District'],
 ['MZ', '09', 'Maganja da Costa District'],
 ['MZ', '09', 'Milange District'],
 ['MZ', '09', 'Namarroi District'],
 ['MZ', '09', 'Nicoadala District'],
 ['MZ', '09', 'Pebane District'],
 ['MZ', '09', 'Mocuba District'],
 ['MZ', '08', 'Changara District'],
 ['MZ', '08', 'Chifunde District'],
 ['MZ', '08', 'Chiuta District'],
 ['MZ', '09', 'Inhassunge District'],
 ['MZ', '03', 'Zavala District'],
 ['MZ', '03', 'Massinga District'],
 ['MZ', '05', 'Maringue'],
 ['MZ', '05', 'Chemba'],
 ['MZ', '03', 'Funhalouro District'],
 ['MZ', '', 'Inhassoro District'],
 ['MZ', '03', 'Inharrime District'],
 ['MZ', '03', 'Jangamo District'],
 ['MZ', '03', 'Homoine District'],
 ['MZ', '03', 'Morrumbene District'],
 ['MZ', '03', 'Vilankulo District'],
 ['MZ', '08', 'Cahora Bassa District'],
 ['MZ', '01', 'Mueda District'],
 ['MZ', '01', 'Ancuabe District'],
 ['MZ', '01', 'Namuno District'],
 ['MZ', '07', "N'gauma District"],
 ['MZ', '07', 'Marrupa District'],
 ['MZ', '01', 'Montepuez District'],
 ['MZ', '04', 'Namaacha District'],
 ['NA', '06', 'Epupa Constituency'],
 ['NA', '06', 'Opuwo Constituency'],
 ['NA', '22', 'Sesfontein Constituency'],
 ['NA', '22', 'Khorixas Constituency'],
 ['NA', '22', 'Daures Constituency'],
 ['NA', '17', 'Arandis Constituency'],
 ['NA', '17', 'Swakopmund Constituency'],
 ['NA', '17', 'Walvis Bay Urban Constituency'],
 ['NA', '17', 'Walvis Bay Rural Constituency'],
 ['NA', '27', 'Gibeon Constituency'],
 ['NA', '09', 'Luderitz Constituency'],
 ['NA', '09', 'Oranjemund Constituency'],
 ['NC', '02', 'Yat\xc3\xa9'],
 ['NC', '01', 'Voh'],
 ['NC', '01', 'Touho'],
 ['NC', '02', 'Thio'],
 ['NC', '02', 'Sarram\xc3\xa9a'],
 ['NC', '01', 'Poya'],
 ['NC', '01', 'Pouembout'],
 ['NC', '01', 'Pou\xc3\xa9bo'],
 ['NC', '01', 'Pon\xc3\xa9rihouen'],
 ['NC', '01', 'Poindimi\xc3\xa9'],
 ['NC', '02', 'Pa\xc3\xafta'],
 ['NC', '03', 'Ouv\xc3\xa9a'],
 ['NC', '01', 'Ou\xc3\xa9goa'],
 ['NC', '02', 'Noum\xc3\xa9a'],
 ['NC', '02', 'Le Mont-Dore'],
 ['NC', '02', 'Moindou'],
 ['NC', '03', 'Mar\xc3\xa9'],
 ['NC', '03', 'Lifou'],
 ['NC', '01', 'Koumac'],
 ['NC', '01', 'Kaala-Gom\xc3\xa9n'],
 ['NC', '01', 'B\xc3\xa9lep'],
 ['NC', '02', 'L\xe2\x80\x99\xc3\x8ele des Pins'],
 ['NC', '01', 'Houa\xc3\xaflou'],
 ['NC', '01', 'Hiengh\xc3\xa9ne'],
 ['NC', '02', 'Farino'],
 ['NC', '02', 'Dumb\xc3\xa9a'],
 ['NC', '01', 'Canala'],
 ['NC', '02', 'Bourail'],
 ['NC', '02', 'Bouloupari'],
 ['NC', '01', 'Kon\xc3\xa9'],
 ['NC', '02', 'La Foa'],
 ['NC', '01', 'Kouaoua'],
 ['NC', '01', 'Poum'],
 ['NE', '08', 'D\xc3\xa9partement de Tillab\xc3\xa9ri'],
 ['NE', '04', 'D\xc3\xa9partement de Tessaoua'],
 ['NE', '08', 'D\xc3\xa9partement de T\xc3\xa9ra'],
 ['NE', '06', 'D\xc3\xa9partement de Tchin-Tabaraden'],
 ['NE', '07', 'D\xc3\xa9partement de T\xc3\xa2nout'],
 ['NE', '06', 'D\xc3\xa9partement de Tahoua'],
 ['NE', '08', 'D\xc3\xa9partement de Say'],
 ['NE', '08', 'D\xc3\xa9partement de Ouallam'],
 ['NE', '08', 'D\xc3\xa9partement de Niamey'],
 ['NE', '02', 'D\xc3\xa9partement de Nguigmi'],
 ['NE', '07', 'D\xc3\xa9partement de Mirria'],
 ['NE', '04', 'D\xc3\xa9partement de Mayahi'],
 ['NE', '07', 'D\xc3\xa9partement de Matameye'],
 ['NE', '04', 'D\xc3\xa9partement de Maradi'],
 ['NE', '02', 'D\xc3\xa9partement de Ma\xc3\xafn\xc3\xa9-Soroa'],
 ['NE', '07', 'D\xc3\xa9partement de Magaria'],
 ['NE', '06', 'D\xc3\xa9partement de Madaoua'],
 ['NE', '03', 'D\xc3\xa9partement de Loga'],
 ['NE', '06', 'D\xc3\xa9partement de Ke\xc3\xafta'],
 ['NE', '06', "D\xc3\xa9partement d' Ill\xc3\xa9la"],
 ['NE', '07', 'D\xc3\xa9partement de Gour\xc3\xa9'],
 ['NE', '03', 'D\xc3\xa9partement de Gaya'],
 ['NE', '08', 'D\xc3\xa9partement de Filingu\xc3\xa9'],
 ['NE', '03', 'D\xc3\xa9partement de Dosso'],
 ['NE', '03', 'D\xc3\xa9partement de Dogondoutchi'],
 ['NE', '02', 'D\xc3\xa9partement de Diffa'],
 ['NE', '04', 'D\xc3\xa9partement de Dakoro'],
 ['NE', '06', 'D\xc3\xa9partement de Bouza'],
 ['NE', '03', 'D\xc3\xa9partement du Boboye'],
 ['NE', '06', 'D\xc3\xa9partement de Birni Nkonni'],
 ['NE', '01', 'D\xc3\xa9partement de Bilma'],
 ['NE', '01', "D\xc3\xa9partement d' Agadez"],
 ['NE', '04', 'Guidan Roumdji Department'],
 ['NE', '08', 'Tillaberi Department'],
 ['NE', '08', 'Tera Department'],
 ['NE', '08', 'Kollo Department'],
 ['NG', '28', 'Owerri Division'],
 ['NG', '00', 'Jos Division'],
 ['NG', '00', 'Ekiti Division'],
 ['NG', '49', 'Nasarawa State'],
 ['NG', '05', 'Ikorodu'],
 ['NG', '28', 'Aba North'],
 ['NG', '45', 'Aba South'],
 ['NG', '45', 'Ikwuano'],
 ['NG', '45', 'Isiala-Ngwa North'],
 ['NG', '45', 'Isuikwato'],
 ['NG', '45', 'Ukwa East'],
 ['NG', '21', 'Esit Eket'],
 ['NG', '21', 'Mkpat-Enin'],
 ['NG', '21', 'Oruk Anam'],
 ['NG', '47', 'Anambra East'],
 ['NG', '25', 'Anaocha'],
 ['NG', '25', 'Awka North'],
 ['NG', '25', 'Awka South'],
 ['NG', '47', 'Ayamelum'],
 ['NG', '29', 'Tofa'],
 ['NG', '41', 'Ogori/Mangongo'],
 ['NG', '31', 'Katcha'],
 ['NG', '31', 'Magama'],
 ['NG', '31', 'Mokwa'],
 ['NG', '31', 'Rafi'],
 ['NG', '42', 'Ede North'],
 ['NG', '42', 'Egebedore'],
 ['NG', '42', 'Egbedore'],
 ['NG', '42', 'Ife Central'],
 ['NG', '42', 'Ife East'],
 ['NG', '42', 'Ife South'],
 ['NG', '42', 'Ifelodun'],
 ['NG', '42', 'Ila'],
 ['NG', '42', 'Irepodun'],
 ['NG', '42', 'Irewole'],
 ['NG', '42', 'Isokan'],
 ['NG', '42', 'Odo-Otin'],
 ['NG', '42', 'Ola-Oluwa'],
 ['NG', '42', 'Olorunda'],
 ['NG', '42', 'Oriade'],
 ['NG', '32', 'Iwajowa'],
 ['NG', '32', 'Ogo Oluwa'],
 ['NG', '32', 'Olorunsogo'],
 ['NG', '32', 'Oluyole'],
 ['NG', '32', 'Ona-Ara'],
 ['NG', '32', 'Orelope'],
 ['NG', '50', 'Ahoada West'],
 ['NG', '50', 'Akuku Toru'],
 ['NG', '', 'Andoni'],
 ['NG', '50', 'Eleme'],
 ['NG', '50', 'Etche'],
 ['NG', '50', 'Obia/Akpor'],
 ['NG', '50', 'Ogba/Egbema/Ndoni'],
 ['NG', '45', 'Omumma'],
 ['NG', '50', 'Oyigbo'],
 ['NG', '50', 'Tai'],
 ['NG', '51', 'Bodinga'],
 ['NG', '51', 'Illela'],
 ['NG', '51', 'Sokoto North'],
 ['NG', '51', 'Sokoto South'],
 ['NG', '47', 'Anambra West'],
 ['NG', '47', 'Idemili North'],
 ['NG', '25', 'Idemili South'],
 ['NG', '25', 'Njikoka'],
 ['NG', '25', 'Nnewi South'],
 ['NG', '25', 'Ogbaru'],
 ['NG', '25', 'Orumba North'],
 ['NG', '25', 'Orumba South'],
 ['NG', '25', 'Oyi'],
 ['NG', '26', 'Guma'],
 ['NG', '26', 'Gwer East'],
 ['NG', '26', 'Logo'],
 ['NG', '41', 'Ogbadibo'],
 ['NG', '26', 'Vandeikya'],
 ['NG', '29', 'Warawa'],
 ['NG', '24', 'Kankia'],
 ['NG', '24', "Mai'Adua"],
 ['NG', '24', 'Sabuwa'],
 ['NG', '36', 'Aniocha South'],
 ['NG', '37', 'Ethiope West'],
 ['NG', '37', 'Ethiope East'],
 ['NG', '37', 'Ika North East'],
 ['NG', '36', 'Ika South'],
 ['NG', '36', 'Isoko North'],
 ['NG', '36', 'Isoko South'],
 ['NG', '36', 'Ndokwa East'],
 ['NG', '36', 'Ndokwa West'],
 ['NG', '36', 'Oshimili North'],
 ['NG', '36', 'Oshimili South'],
 ['NG', '36', 'Udu'],
 ['NG', '36', 'Ughelli North'],
 ['NG', '36', 'Ughelli South'],
 ['NG', '37', 'Ukwuani'],
 ['NG', '36', 'Warri North'],
 ['NG', '36', 'Warri South'],
 ['NG', '36', 'Uvwie'],
 ['NG', '', 'Warri South-West'],
 ['NG', '28', 'Aboh-Mbaise'],
 ['NG', '28', 'Ahiuzu-Mbaise'],
 ['NG', '28', 'Ehime-Mbano'],
 ['NG', '28', 'Ihitte/Uboma'],
 ['NG', '28', 'Isiala Mbano'],
 ['NG', '28', 'Mbaitoli'],
 ['NG', '28', 'Ngor-Okp'],
 ['NG', '28', 'Njaba'],
 ['NG', '28', 'Obowo'],
 ['NG', '28', 'Ohaji/Egbema'],
 ['NG', '28', 'Okigwe'],
 ['NG', '25', 'Orsu'],
 ['NG', '28', 'Oru East'],
 ['NG', '28', 'Oru West'],
 ['NG', '28', 'Owerri West'],
 ['NG', '45', 'Ohafia'],
 ['NG', '28', 'Unuimo'],
 ['NG', '41', 'Adavi'],
 ['NG', '35', 'Fufore'],
 ['NG', '41', 'Bassa'],
 ['NG', '41', 'Ibaji'],
 ['NG', '41', 'Igalamela-Odolu'],
 ['NG', '35', 'Gombi'],
 ['NG', '41', 'Ijumu'],
 ['NG', '41', 'Kabba/Bunu'],
 ['NG', '35', 'Madagali'],
 ['NG', '41', 'Mopa-Muro'],
 ['NG', '41', 'Ofu'],
 ['NG', '41', 'Okehi'],
 ['NG', '41', 'Okene'],
 ['NG', '41', 'Olamabor'],
 ['NG', '41', 'Omala'],
 ['NG', '41', 'Yagba East'],
 ['NG', '41', 'Yagba West'],
 ['NG', '31', 'Agaie'],
 ['NG', '31', 'Agwara'],
 ['NG', '46', 'Bauchi'],
 ['NG', '31', 'Bida'],
 ['NG', '31', 'Borgu'],
 ['NG', '46', 'Bogoro'],
 ['NG', '31', 'Chanchaga'],
 ['NG', '31', 'Edati'],
 ['NG', '46', 'Darazo'],
 ['NG', '46', 'Misau'],
 ['NG', '26', 'Buruku'],
 ['NG', '26', 'Gboko'],
 ['NG', '26', 'Kwande'],
 ['NG', '47', 'Abi'],
 ['NG', '22', 'Boki'],
 ['NG', '45', 'Afikpo North'],
 ['NG', '47', 'Ikwo'],
 ['NG', '47', 'Izzi'],
 ['NG', '47', 'Enugu East'],
 ['NG', '47', 'Igbo Eze North'],
 ['NG', '25', 'Udi'],
 ['NG', '40', 'Ngaski'],
 ['NG', '40', 'Yauri'],
 ['NG', '40', 'Zuru'],
 ['NG', '31', 'Gbako'],
 ['NG', '31', 'Gurara'],
 ['NG', '49', 'Barikin Ladi'],
 ['NG', '31', 'Lavun'],
 ['NG', '49', 'Pankshin'],
 ['NG', '49', 'Shendam'],
 ['NG', '31', 'Muya'],
 ['NG', '31', 'Paikoro'],
 ['NG', '42', 'Atakumosa East'],
 ['NG', '42', 'Atakumosa West'],
 ['NG', '44', 'Bursari'],
 ['NG', '42', 'Boluwaduro'],
 ['NG', '42', 'Boripe'],
 ['NG', '44', 'Gujba'],
 ['NG', '32', 'Ibarapa East'],
 ['NG', '32', 'Ibarapa North'],
 ['NG', '44', 'Gulani'],
 ['NG', '32', 'Ido'],
 ['NG', '32', 'Kajola'],
 ['NG', '32', 'Lagelu'],
 ['NG', '32', 'Ori Ire'],
 ['NG', '32', 'Oyo East'],
 ['NG', '32', 'Oyo west'],
 ['NG', '32', 'Saki West'],
 ['NG', '32', 'Surulere'],
 ['NG', '50', 'Gokana'],
 ['NG', '50', 'Ikwerre'],
 ['NG', '50', 'Ogu/Bolo'],
 ['NG', '48', 'Isiala-Nngwa South'],
 ['NG', '45', 'Ugwunagbo'],
 ['NG', '45', 'Ukwa West'],
 ['NG', '45', 'Umuahia South'],
 ['NG', '28', 'Umu-Neochi'],
 ['NG', '21', 'Eastern Obolo'],
 ['NG', '21', 'Essien- Udim'],
 ['NG', '21', 'Nsit Atai'],
 ['NG', '21', 'Nsit Ubium'],
 ['NG', '21', 'Onna'],
 ['NG', '26', 'Agatu'],
 ['NG', '26', 'Gwer West'],
 ['NG', '26', 'Konshisha'],
 ['NG', '26', 'Ushongo'],
 ['NG', '11', 'Bwari'],
 ['NG', '31', 'Tafa'],
 ['NG', '23', 'Kagarko'],
 ['NG', '23', 'Kachia'],
 ['NG', '23', 'Chikun'],
 ['NG', '23', 'Igabi'],
 ['NG', '23', 'Kaduna South'],
 ['NG', '23', 'Makarfi'],
 ['NG', '23', 'Kaduna North'],
 ['NG', '23', 'Zaria'],
 ['NG', '23', 'Sabon Gari'],
 ['NG', '23', 'Kudan'],
 ['NG', '23', 'Ikara'],
 ['NG', '29', 'Kiru'],
 ['NG', '29', 'Bebeji'],
 ['NG', '29', 'Garum Mallam'],
 ['NG', '29', 'Kura'],
 ['NG', '29', 'Dawakin Kudu'],
 ['NG', '29', 'Kumbotso'],
 ['NG', '29', 'Fagge'],
 ['NG', '49', 'Nassarawa'],
 ['NG', '16', 'Shagamu'],
 ['NG', '05', 'Kosofe'],
 ['NG', '05', 'Shomolu'],
 ['NG', '05', 'Lagos Mainland'],
 ['NG', '05', 'Apapa'],
 ['NG', '30', 'Ifelodun'],
 ['NG', '05', 'Amuwo-Odofin'],
 ['NG', '05', 'Ojo'],
 ['NG', '05', 'Badagry'],
 ['NG', '16', 'Ikenne'],
 ['NG', '05', 'Odogbolu'],
 ['NG', '16', 'Ijebu Ode'],
 ['NG', '16', 'Ijebu East'],
 ['NG', '48', 'Odigbo'],
 ['NG', '48', 'Idanre'],
 ['NG', '37', 'Ovia South-West'],
 ['NG', '37', 'Ovia North-East'],
 ['NG', '37', 'Oredo-Edo'],
 ['NG', '37', 'Orhionmwon'],
 ['NG', '37', 'Ika North Administrative Division'],
 ['NG', '37', 'Aniocha North'],
 ['NG', '47', 'Onitsha North'],
 ['NG', '32', 'Ibadan North'],
 ['NG', '32', 'Akinyele'],
 ['NG', '32', 'Afijio'],
 ['NG', '32', 'Orire'],
 ['NG', '25', 'Ogbomosho South'],
 ['NG', '30', 'Oyun'],
 ['NG', '30', 'Ilorin West'],
 ['NG', '', 'Lagos Island'],
 ['NG', '05', 'Agege'],
 ['NG', '16', 'Obafemi Owode'],
 ['NG', '32', 'Ibadan South-West'],
 ['NG', '32', 'Ibadan South-East'],
 ['NG', '32', 'Ibadan North-East'],
 ['NG', '32', 'Irepo'],
 ['NG', '31', 'Kaiama'],
 ['NG', '40', 'Bagudo'],
 ['NG', '40', 'Koko/Besse'],
 ['NG', '51', 'Gummi'],
 ['NG', '40', 'Maiyama'],
 ['NG', '40', 'Jega'],
 ['NG', '40', 'Gwandu'],
 ['NG', '51', 'Yabo'],
 ['NG', '51', 'Wamako'],
 ['NG', '25', 'Awaka South'],
 ['NG', '25', 'Awaka North'],
 ['NG', '25', 'Oji-River'],
 ['NG', '47', 'Enugu South'],
 ['NG', '50', 'Port Harcourt'],
 ['NG', '50', 'Obio/Akpor'],
 ['NG', '28', 'Isuikwuato'],
 ['NG', '25', 'Awgu'],
 ['NG', '25', 'Nkanu'],
 ['NG', '50', 'Khana'],
 ['NG', '45', 'Obioma North'],
 ['NG', '23', 'Birnin Gwari'],
 ['NG', '23', 'Sanga'],
 ['NG', '23', 'Soba'],
 ['NG', '29', 'Minjibir'],
 ['NG', '29', 'Ungogo'],
 ['NG', '29', 'Makoda'],
 ['NG', '29', 'Kunchi'],
 ['NG', '29', 'Rimin Gado'],
 ['NG', '29', 'Rogo'],
 ['NG', '29', 'Wudil'],
 ['NG', '30', 'Asa'],
 ['NG', '30', 'Baruten'],
 ['NG', '30', 'Pategi'],
 ['NG', '29', 'Shanono'],
 ['NG', '29', 'Takai'],
 ['NG', '29', 'Bunkure'],
 ['NG', '05', 'Alimosho'],
 ['NG', '05', 'Ifako-Ijaiye'],
 ['NG', '05', 'Epe'],
 ['NG', '05', 'Ibeju-Lekki'],
 ['NG', '05', 'Ikeja'],
 ['NG', '05', 'Mushin'],
 ['NG', '05', 'Oshodi-Isolo'],
 ['NG', '49', 'Akwanga'],
 ['NG', '49', 'Lafia'],
 ['NG', '49', 'Obi'],
 ['NG', '26', 'Keana'],
 ['NG', '26', 'Makurdi'],
 ['NG', '26', 'Oturkpo'],
 ['NG', '26', 'Ohimini'],
 ['NG', '26', 'Okpokwu'],
 ['NG', '47', 'Isi-Uzo'],
 ['NG', '25', 'Dunukofia'],
 ['NG', '37', 'Uhunmwonde'],
 ['NG', '37', 'Ikpoba-Okha'],
 ['NG', '25', 'Nkanu West'],
 ['NG', '28', 'Umu-Nneochi'],
 ['NG', '45', 'Umuahia North'],
 ['NG', '45', 'Isiala-Ngwa South'],
 ['NG', '45', 'Oboma Ngwa'],
 ['NG', '23', 'Giwa'],
 ['NG', '47', 'Uzo Uwani'],
 ['NG', '05', 'Eti-Osa'],
 ['NG', '22', 'Ikom'],
 ['NG', '22', 'Ogoja'],
 ['NG', '22', 'Obubra'],
 ['NG', '22', 'Abi'],
 ['NG', '22', 'Yakuur'],
 ['NG', '22', 'Obudu'],
 ['NG', '26', 'Katsina-Ala'],
 ['NG', '05', 'Surulere'],
 ['NG', '05', 'Ajeromi-Ifelodun'],
 ['NG', '11', 'Abujamun'],
 ['NI', '13', 'Municipio de Wiwil\xc3\xad'],
 ['NI', '04', 'Municipio de Villa Sandino'],
 ['NI', '03', 'Municipio de Villa Nueva'],
 ['NI', '03', 'Municipio de Santo Tom\xc3\xa1s del Norte'],
 ['NI', '03', 'Municipio de San Pedro del Norte'],
 ['NI', '15', 'Municipio de San Juan del Sur'],
 ['NI', '01', 'Municipio de San Jos\xc3\xa9 de los Remates'],
 ['NI', '03', 'Municipio de San Francisco del Norte'],
 ['NI', '12', 'Municipio de R\xc3\xado Blanco'],
 ['NI', '18', 'Municipio de Muelle de los Bueyes'],
 ['NI', '13', 'Municipio de Ciudad Sandino'],
 ['NI', '11', 'Municipio de Catarina'],
 ['NI', '10', 'Municipio de Carlos Fonseca Amador'],
 ['NI', '01', 'Municipio de Boaco'],
 ['NI', '15', 'Municipio de Bel\xc3\xa9n'],
 ['NI', '07', 'Municipio El Cua'],
 ['NI', '07', 'Municipio de San Jos\xc3\xa9 de Bocay'],
 ['NI', '07', 'Municipio de Santa Mar\xc3\xada de Pantasma'],
 ['NI', '13', 'Wiwil\xc3\xad de Jinotega'],
 ['NI', '12', 'Municipio de Rancho Grande'],
 ['NI', '12', 'Municipio del Tuma-La Dalia'],
 ['NI', '04', 'Municipio de San Francisco de Cuapa'],
 ['NI', '16', 'Municipio de Siuna'],
 ['NI', '16', 'Municipio de Waslala'],
 ['NI', '16', 'Municipio del Tortuguero'],
 ['NI', '16', 'Municipio de Bocana de Paiwas'],
 ['NL', '15', 'Gemeente Zwolle'],
 ['NL', '11', 'Gemeente Zwijndrecht'],
 ['NL', '03', 'Gemeente Zutphen'],
 ['NL', '06', 'Gemeente Zundert'],
 ['NL', '04', 'Gemeente Zuidhorn'],
 ['NL', '11', 'Gemeente Zoeterwoude'],
 ['NL', '11', 'Gemeente Zoetermeer'],
 ['NL', '07', 'Gemeente Zijpe'],
 ['NL', '03', 'Gemeente Zevenaar'],
 ['NL', '09', 'Gemeente Zeist'],
 ['NL', '16', 'Gemeente Zeewolde'],
 ['NL', '07', 'Gemeente Zeevang'],
 ['NL', '07', 'Gemeente Zandvoort'],
 ['NL', '03', 'Gemeente Zaltbommel'],
 ['NL', '07', 'Gemeente Zaanstad'],
 ['NL', '06', 'Gemeente Woudrichem'],
 ['NL', '09', 'Gemeente Woudenberg'],
 ['NL', '09', 'Gemeente Woerden'],
 ['NL', '06', 'Gemeente Woensdrecht'],
 ['NL', '03', 'Gemeente Winterswijk'],
 ['NL', '04', 'Gemeente Winsum'],
 ['NL', '09', 'Gemeente Wijk bij Duurstede'],
 ['NL', '03', 'Gemeente Wijchen'],
 ['NL', '07', 'Gemeente Wieringermeer'],
 ['NL', '07', 'Gemeente Wieringen'],
 ['NL', '15', 'Gemeente Wierden'],
 ['NL', '11', 'Gemeente Westvoorne'],
 ['NL', '02', 'Gemeente Weststellingwerf'],
 ['NL', '03', 'Gemeente Westervoort'],
 ['NL', '06', 'Gemeente Werkendam'],
 ['NL', '07', 'Gemeente Weesp'],
 ['NL', '05', 'Gemeente Weert'],
 ['NL', '11', 'Gemeente Wassenaar'],
 ['NL', '03', 'Gemeente Wageningen'],
 ['NL', '11', 'Gemeente Waddinxveen'],
 ['NL', '06', 'Gemeente Waalwijk'],
 ['NL', '06', 'Gemeente Waalre'],
 ['NL', '06', 'Gemeente Vught'],
 ['NL', '03', 'Gemeente Voorst'],
 ['NL', '11', 'Gemeente Voorschoten'],
 ['NL', '05', 'Gemeente Voerendaal'],
 ['NL', '11', 'Gemeente Vlist'],
 ['NL', '10', 'Gemeente Vlissingen'],
 ['NL', '02', 'Gemeente Vlieland'],
 ['NL', '04', 'Gemeente Vlagtwedde'],
 ['NL', '11', 'Gemeente Vlaardingen'],
 ['NL', '09', 'Gemeente Vianen'],
 ['NL', '05', 'Gemeente Venray'],
 ['NL', '05', 'Gemeente Venlo'],
 ['NL', '07', 'Gemeente Velsen'],
 ['NL', '06', 'Gemeente Veldhoven'],
 ['NL', '06', 'Gemeente Veghel'],
 ['NL', '10', 'Gemeente Veere'],
 ['NL', '09', 'Gemeente Veenendaal'],
 ['NL', '04', 'Gemeente Veendam'],
 ['NL', '06', 'Gemeente Valkenswaard'],
 ['NL', '05', 'Gemeente Vaals'],
 ['NL', '09', 'Gemeente Utrecht'],
 ['NL', '16', 'Gemeente Urk'],
 ['NL', '07', 'Gemeente Uithoorn'],
 ['NL', '07', 'Gemeente Uitgeest'],
 ['NL', '06', 'Gemeente Uden'],
 ['NL', '03', 'Gemeente Ubbergen'],
 ['NL', '15', 'Gemeente Tubbergen'],
 ['NL', '06', 'Gemeente Tilburg'],
 ['NL', '03', 'Gemeente Tiel'],
 ['NL', '10', 'Gemeente Tholen'],
 ['NL', '07', 'Gemeente Texel'],
 ['NL', '02', 'Gemeente Terschelling'],
 ['NL', '10', 'Gemeente Terneuzen'],
 ['NL', '04', 'Gemeente Ten Boer'],
 ['NL', '11', 'Gemeente Strijen'],
 ['NL', '05', 'Gemeente Stein'],
 ['NL', '06', 'Gemeente Steenbergen'],
 ['NL', '15', 'Gemeente Staphorst'],
 ['NL', '04', 'Gemeente Stadskanaal'],
 ['NL', '11', 'Gemeente Spijkenisse'],
 ['NL', '06', 'Gemeente Son en Breugel'],
 ['NL', '06', 'Gemeente Someren'],
 ['NL', '09', 'Gemeente Soest'],
 ['NL', '02', 'Gemeente Smallingerland'],
 ['NL', '10', 'Gemeente Sluis'],
 ['NL', '04', 'Gemeente Slochteren'],
 ['NL', '11', 'Gemeente Sliedrecht'],
 ['NL', '06', 'Gemeente Sint-Oedenrode'],
 ['NL', '06', 'Gemeente Sint-Michielsgestel'],
 ['NL', '05', 'Gemeente Simpelveld'],
 ['NL', '06', "Gemeente 's-Hertogenbosch"],
 ['NL', '11', 'Gemeente \xe2\x80\x99s-Gravenhage'],
 ['NL', '11', 'Gemeente Schoonhoven'],
 ['NL', '05', 'Gemeente Schinnen'],
 ['NL', '06', 'Gemeente Schijndel'],
 ['NL', '02', 'Gemeente Schiermonnikoog'],
 ['NL', '11', 'Gemeente Schiedam'],
 ['NL', '03', 'Gemeente Scherpenzeel'],
 ['NL', '07', 'Gemeente Schermer'],
 ['NL', '07', 'Gemeente Schagen'],
 ['NL', '06', 'Gemeente Rucphen'],
 ['NL', '03', 'Gemeente Rozendaal'],
 ['NL', '11', 'Gemeente Rotterdam'],
 ['NL', '06', 'Gemeente Roosendaal'],
 ['NL', '05', 'Gemeente Roermond'],
 ['NL', '11', 'Gemeente Rijswijk'],
 ['NL', '11', 'Gemeente Ridderkerk'],
 ['NL', '09', 'Gemeente Rhenen'],
 ['NL', '03', 'Gemeente Rheden'],
 ['NL', '09', 'Gemeente Renswoude'],
 ['NL', '03', 'Gemeente Renkum'],
 ['NL', '10', 'Gemeente Reimerswaal'],
 ['NL', '15', 'Gemeente Raalte'],
 ['NL', '03', 'Gemeente Putten'],
 ['NL', '07', 'Gemeente Purmerend'],
 ['NL', '11', 'Gemeente Papendrecht'],
 ['NL', '09', 'Gemeente Oudewater'],
 ['NL', '11', 'Gemeente Ouderkerk aan den IJssel'],
 ['NL', '07', 'Gemeente Ouder-Amstel'],
 ['NL', '11', 'Gemeente Oud-Beijerland'],
 ['NL', '06', 'Gemeente Oss'],
 ['NL', '02', 'Gemeente Opsterland'],
 ['NL', '07', 'Gemeente Opmeer'],
 ['NL', '06', 'Gemeente Sint Anthonis'],
 ['NL', '07', 'Gemeente Oostzaan'],
 ['NL', '02', 'Gemeente Ooststellingwerf'],
 ['NL', '11', 'Gemeente Oostflakkee'],
 ['NL', '06', 'Gemeente Oosterhout'],
 ['NL', '02', 'Gemeente Dongeradeel'],
 ['NL', '15', 'Gemeente Ommen'],
 ['NL', '15', 'Gemeente Oldenzaal'],
 ['NL', '03', 'Gemeente Oldebroek'],
 ['NL', '06', 'Gemeente Oisterwijk'],
 ['NL', '06', 'Gemeente Oirschot'],
 ['NL', '11', 'Gemeente Oegstgeest'],
 ['NL', '05', 'Gemeente Nuth'],
 ['NL', '03', 'Gemeente Nunspeet'],
 ['NL', '06', 'Gemeente Nuenen, Gerwen en Nederwetten'],
 ['NL', '11', 'Gemeente Noordwijkerhout'],
 ['NL', '11', 'Gemeente Noordwijk'],
 ['NL', '16', 'Gemeente Noordoostpolder'],
 ['NL', '03', 'Gemeente Nijmegen'],
 ['NL', '03', 'Gemeente Nijkerk'],
 ['NL', '11', 'Gemeente Nieuw-Lekkerland'],
 ['NL', '11', 'Gemeente Nieuwkoop'],
 ['NL', '09', 'Gemeente Nieuwegein'],
 ['NL', '07', 'Gemeente Niedorp'],
 ['NL', '05', 'Gemeente Nederweert'],
 ['NL', '07', 'Gemeente Naarden'],
 ['NL', '07', 'Gemeente Muiden'],
 ['NL', '05', 'Gemeente Mook en Middelaar'],
 ['NL', '09', 'Gemeente Montfoort'],
 ['NL', '03', 'Gemeente Millingen aan de Rijn'],
 ['NL', '06', 'Gemeente Mill en Sint Hubert'],
 ['NL', '11', 'Gemeente Middelharnis'],
 ['NL', '10', 'Gemeente Middelburg'],
 ['NL', '01', 'Gemeente Meppel'],
 ['NL', '05', 'Gemeente Meerssen'],
 ['NL', '07', 'Gemeente Medemblik'],
 ['NL', '04', 'Gemeente Marum'],
 ['NL', '06', 'Gemeente Made en Drimmelen'],
 ['NL', '05', 'Gemeente Maastricht'],
 ['NL', '11', 'Gemeente Maassluis'],
 ['NL', '03', 'Gemeente Maasdriel'],
 ['NL', '15', 'Gemeente Losser'],
 ['NL', '04', 'Gemeente Loppersum'],
 ['NL', '09', 'Gemeente Lopik'],
 ['NL', '06', 'Gemeente Loon op Zand'],
 ['NL', '03', 'Gemeente Lochem'],
 ['NL', '11', 'Gemeente Lisse'],
 ['NL', '09', 'Gemeente Leusden'],
 ['NL', '02', 'Gemeente Lemsterland'],
 ['NL', '16', 'Gemeente Lelystad'],
 ['NL', '11', 'Gemeente Leiderdorp'],
 ['NL', '11', 'Gemeente Leiden'],
 ['NL', '02', 'Gemeente Leeuwarderadeel'],
 ['NL', '02', 'Gemeente Leeuwarden'],
 ['NL', '11', 'Gemeente Leerdam'],
 ['NL', '04', 'Gemeente Leek'],
 ['NL', '07', 'Gemeente Laren'],
 ['NL', '07', 'Gemeente Langedijk'],
 ['NL', '07', 'Gemeente Landsmeer'],
 ['NL', '11', 'Gemeente Krimpen aan den IJssel'],
 ['NL', '02', 'Gemeente Kollumerland en Nieuwkruisland'],
 ['NL', '05', 'Gemeente Kerkrade'],
 ['NL', '11', 'Gemeente Katwijk'],
 ['NL', '10', 'Gemeente Kapelle'],
 ['NL', '15', 'Gemeente Kampen'],
 ['NL', '09', 'Gemeente IJsselstein'],
 ['NL', '02', 'Gemeente Boarnsterhim'],
 ['NL', '10', 'Gemeente Hulst'],
 ['NL', '07', 'Gemeente Huizen'],
 ['NL', '09', 'Gemeente Houten'],
 ['NL', '07', 'Gemeente Hoorn'],
 ['NL', '04', 'Gemeente Hoogezand-Sappemeer'],
 ['NL', '01', 'Gemeente Hoogeveen'],
 ['NL', '07', 'Gemeente Hilversum'],
 ['NL', '06', 'Gemeente Hilvarenbeek'],
 ['NL', '11', 'Gemeente Hillegom'],
 ['NL', '06', 'Gemeente Heusden'],
 ['NL', '03', 'Gemeente Heumen'],
 ['NL', '02', 'Gemeente het Bildt'],
 ['NL', '15', 'Gemeente Hengelo'],
 ['NL', '11', 'Gemeente Hendrik-Ido-Ambacht'],
 ['NL', '06', 'Gemeente Helmond'],
 ['NL', '11', 'Gemeente Hellevoetsluis'],
 ['NL', '15', 'Gemeente Hellendoorn'],
 ['NL', '07', 'Gemeente Heiloo'],
 ['NL', '05', 'Gemeente Heerlen'],
 ['NL', '07', 'Gemeente Heerhugowaard'],
 ['NL', '02', 'Gemeente Heerenveen'],
 ['NL', '03', 'Gemeente Heerde'],
 ['NL', '07', 'Gemeente Heemstede'],
 ['NL', '07', 'Gemeente Heemskerk'],
 ['NL', '03', 'Gemeente Hattem'],
 ['NL', '02', 'Gemeente Harlingen'],
 ['NL', '07', 'Gemeente Harenkarspel'],
 ['NL', '04', 'Gemeente Haren'],
 ['NL', '11', 'Gemeente Hardinxveld-Giessendam'],
 ['NL', '03', 'Gemeente Harderwijk'],
 ['NL', '15', 'Gemeente Hardenberg'],
 ['NL', '07', 'Gemeente Haarlemmermeer'],
 ['NL', '07', 'Gemeente Haarlemmerliede en Spaarnwoude'],
 ['NL', '07', 'Gemeente Haarlem'],
 ['NL', '06', 'Gemeente Haaren'],
 ['NL', '15', 'Gemeente Haaksbergen'],
 ['NL', '04', 'Gemeente Grootegast'],
 ['NL', '04', 'Gemeente Groningen'],
 ['NL', '03', 'Gemeente Groesbeek'],
 ['NL', '06', 'Gemeente Grave'],
 ['NL', '07', 'Gemeente Graft-De Rijp'],
 ['NL', '11', 'Gemeente Gouda'],
 ['NL', '11', 'Gemeente Gorinchem'],
 ['NL', '06', 'Gemeente Goirle'],
 ['NL', '10', 'Gemeente Goes'],
 ['NL', '11', 'Gemeente Goedereede'],
 ['NL', '06', 'Gemeente Gilze en Rijen'],
 ['NL', '05', 'Gemeente Gennep'],
 ['NL', '03', 'Gemeente Geldermalsen'],
 ['NL', '06', 'Gemeente Geertruidenberg'],
 ['NL', '02', 'Gemeente Franekeradeel'],
 ['NL', '02', 'Gemeente Ferwerderadiel'],
 ['NL', '06', 'Gemeente Etten-Leur'],
 ['NL', '03', 'Gemeente Ermelo'],
 ['NL', '03', 'Gemeente Epe'],
 ['NL', '15', 'Gemeente Enschede'],
 ['NL', '07', 'Gemeente Enkhuizen'],
 ['NL', '01', 'Gemeente Emmen'],
 ['NL', '03', 'Gemeente Elburg'],
 ['NL', '06', 'Gemeente Eindhoven'],
 ['NL', '06', 'Gemeente Eersel'],
 ['NL', '09', 'Gemeente Eemnes'],
 ['NL', '03', 'Gemeente Ede'],
 ['NL', '07', 'Gemeente Edam-Volendam'],
 ['NL', '05', 'Gemeente Echt-Susteren'],
 ['NL', '03', 'Gemeente Duiven'],
 ['NL', '03', 'Gemeente Druten'],
 ['NL', '16', 'Gemeente Dronten'],
 ['NL', '11', 'Gemeente Dordrecht'],
 ['NL', '09', 'Gemeente Utrechtse Heuvelrug'],
 ['NL', '06', 'Gemeente Dongen'],
 ['NL', '03', 'Gemeente Doetinchem'],
 ['NL', '03', 'Gemeente Doesburg'],
 ['NL', '11', 'Gemeente Dirksland'],
 ['NL', '07', 'Gemeente Diemen'],
 ['NL', '15', 'Gemeente Deventer'],
 ['NL', '06', 'Gemeente Deurne'],
 ['NL', '07', 'Gemeente Den Helder'],
 ['NL', '04', 'Gemeente Delfzijl'],
 ['NL', '11', 'Gemeente Delft'],
 ['NL', '09', 'Gemeente De Bilt'],
 ['NL', '02', 'Gemeente Dantumadiel'],
 ['NL', '15', 'Gemeente Dalfsen'],
 ['NL', '03', 'Gemeente Culemborg'],
 ['NL', '06', 'Gemeente Cuijk'],
 ['NL', '01', 'Gemeente Coevorden'],
 ['NL', '07', 'Gemeente Castricum'],
 ['NL', '11', 'Gemeente Capelle aan den IJssel'],
 ['NL', '07', 'Gemeente Bussum'],
 ['NL', '03', 'Gemeente Buren'],
 ['NL', '09', 'Gemeente Bunschoten'],
 ['NL', '09', 'Gemeente Bunnik'],
 ['NL', '05', 'Gemeente Brunssum'],
 ['NL', '03', 'Gemeente Brummen'],
 ['NL', '07', 'Gemeente Waterland'],
 ['NL', '11', 'Gemeente Brielle'],
 ['NL', '06', 'Gemeente Breda'],
 ['NL', '06', 'Gemeente Boxtel'],
 ['NL', '06', 'Gemeente Boxmeer'],
 ['NL', '11', 'Gemeente Boskoop'],
 ['NL', '10', 'Gemeente Borsele'],
 ['NL', '15', 'Gemeente Borne'],
 ['NL', '01', 'Gemeente Borger-Odoorn'],
 ['NL', '06', 'Gemeente Boekel'],
 ['NL', '07', 'Gemeente Bloemendaal'],
 ['NL', '07', 'Gemeente Blaricum'],
 ['NL', '06', 'Gemeente Bladel en Netersel'],
 ['NL', '07', 'Gemeente Beverwijk'],
 ['NL', '03', 'Gemeente Beuningen'],
 ['NL', '06', 'Gemeente Best'],
 ['NL', '06', 'Gemeente Bergeijk'],
 ['NL', '06', 'Gemeente Bergen op Zoom'],
 ['NL', '07', 'Gemeente Bergen'],
 ['NL', '05', 'Gemeente Bergen'],
 ['NL', '11', 'Gemeente Bergambacht'],
 ['NL', '04', 'Gemeente Bellingwedde'],
 ['NL', '05', 'Gemeente Beesel'],
 ['NL', '07', 'Gemeente Beemster'],
 ['NL', '05', 'Gemeente Beek'],
 ['NL', '04', 'Gemeente Bedum'],
 ['NL', '03', 'Gemeente Barneveld'],
 ['NL', '11', 'Gemeente Barendrecht'],
 ['NL', '09', 'Gemeente Baarn'],
 ['NL', '06', 'Gemeente Baarle-Nassau'],
 ['NL', '06', 'Gemeente Asten'],
 ['NL', '01', 'Gemeente Assen'],
 ['NL', '03', 'Gemeente Arnhem'],
 ['NL', '04', 'Gemeente Appingedam'],
 ['NL', '03', 'Gemeente Apeldoorn'],
 ['NL', '07', 'Gemeente Anna Paulowna'],
 ['NL', '07', 'Gemeente Amsterdam'],
 ['NL', '07', 'Gemeente Amstelveen'],
 ['NL', '09', 'Gemeente Amersfoort'],
 ['NL', '02', 'Gemeente Ameland'],
 ['NL', '11', 'Gemeente Alphen aan den Rijn'],
 ['NL', '15', 'Gemeente Almelo'],
 ['NL', '07', 'Gemeente Alkmaar'],
 ['NL', '11', 'Gemeente Alblasserdam'],
 ['NL', '02', 'Gemeente Achtkarspelen'],
 ['NL', '03', 'Gemeente Aalten'],
 ['NL', '07', 'Gemeente Aalsmeer'],
 ['NL', '06', 'Gemeente Aalburg'],
 ['NL', '07', 'Gemeente Wijdemeren'],
 ['NL', '06', 'Gemeente Moerdijk'],
 ['NL', '07', 'Gemeente Koggenland'],
 ['NL', '11', 'Gemeente Pijnacker-Nootdorp'],
 ['NL', '03', 'Oude IJsselstreek'],
 ['NL', '11', 'Gemeente Kaag en Braassem'],
 ['NL', '05', 'Gulpen-Wittem'],
 ['NL', '05', 'Gemeente Leudal'],
 ['NL', '01', 'Gemeente De Wolden'],
 ['NL', '03', 'Oost Gelre'],
 ['NL', '04', 'Gemeente De Marne'],
 ['NL', '15', 'Gemeente Rijssen-Holten'],
 ['NL', '04', 'Gemeente Menterwolde'],
 ['NL', '06', 'Gemeente Geldrop-Mierlo'],
 ['NL', '05', 'Gemeente Horst aan de Maas'],
 ['NL', '04', 'Gemeente Pekela'],
 ['NL', '15', 'Gemeente Steenwijkerland'],
 ['NL', '03', 'Gemeente Lingewaard'],
 ['NL', '11', 'Gemeente Giessenlanden'],
 ['NL', '07', 'Gemeente Stede Broec'],
 ['NL', '01', 'Gemeente Westerveld'],
 ['NL', '11', 'Gemeente Binnenmaas'],
 ['NL', '11', 'Gemeente Bernisse'],
 ['NL', '11', 'Gemeente Albrandswaard'],
 ['NL', '03', 'Gemeente Lingewaal'],
 ['NL', '05', 'Gemeente Maasgouw'],
 ['NL', '15', 'Gemeente Twenterand'],
 ['NL', '15', 'Gemeente Olst-Wijhe'],
 ['NL', '06', 'Gemeente Alphen-Chaam'],
 ['NL', '09', 'Gemeente De Ronde Venen'],
 ['NL', '10', 'Schouwen-Duiveland'],
 ['NL', '11', 'Gemeente Leidschendam-Voorburg'],
 ['NL', '10', 'Gemeente Noord-Beveland'],
 ['NL', '07', 'Gemeente Drechterland'],
 ['NL', '05', 'Gemeente Sittard-Geleen'],
 ['NL', '03', 'Gemeente Montferland'],
 ['NL', '05', 'Landgraaf'],
 ['NL', '16', 'Gemeente Almere'],
 ['NL', '15', 'Gemeente Zwartewaterland'],
 ['NL', '11', 'Gemeente Westland'],
 ['NL', '11', 'Gemeente Midden-Delfland'],
 ['NL', '07', 'Gemeente Wormerland'],
 ['NL', '05', 'Gemeente Roerdalen'],
 ['NL', '03', 'Gemeente West Maas en Waal'],
 ['NL', '06', 'Gemeente Laarbeek'],
 ['NL', '11', 'Gemeente Zederik'],
 ['NL', '06', 'Gemeente Bernheze'],
 ['NL', '03', 'Gemeente Neder-Betuwe'],
 ['NL', '11', 'Gemeente Liesveld'],
 ['NL', '06', 'Gemeente Halderberge'],
 ['NL', '11', 'Gemeente Graafstroom'],
 ['NL', '11', 'Gemeente Rijnwoude'],
 ['NL', '03', 'Gemeente Rijnwaarden'],
 ['NL', '03', 'Gemeente Overbetuwe'],
 ['NL', '06', 'Gemeente Heeze-Leende'],
 ['NL', '04', 'Gemeente Eemsmond'],
 ['NL', '06', 'Gemeente Gemert-Bakel'],
 ['NL', '06', 'Gemeente Reusel-De Mierden'],
 ['NL', '11', 'Gemeente Nederlek'],
 ['NL', '01', 'Gemeente Tynaarlo'],
 ['NL', '06', 'Gemeente Maasdonk'],
 ['NL', '11', 'Gemeente Cromstrijen'],
 ['NL', '15', 'Gemeente Dinkelland'],
 ['NL', '03', 'Berkelland'],
 ['NL', '01', 'Gemeente Noordenveld'],
 ['NL', '06', 'Gemeente Cranendonck'],
 ['NL', '15', 'Gemeente Hof van Twente'],
 ['NL', '03', 'Gemeente Bronckhorst'],
 ['NL', '11', 'Gemeente Lansingerland'],
 ['NL', '06', 'Gemeente Landerd'],
 ['NL', '11', 'Gemeente Teylingen'],
 ['NL', '03', 'Gemeente Neerijnen'],
 ['NL', '11', 'Gemeente Korendijk'],
 ['NL', '01', 'Gemeente Aa en Hunze'],
 ['NL', '01', 'Gemeente Midden-Drenthe'],
 ['NL', '05', 'Gemeente Onderbanken'],
 ['NL', '05', 'Valkenburg aan de Geul'],
 ['NL', '02', 'Gemeente Littenseradiel'],
 ['NL', '02', 'Gemeente Gaasterl\xc3\xa2n-Sleat'],
 ['NL', '02', 'Gemeente Skarsterl\xc3\xa2n'],
 ['NL', '02', 'Gemeente Tytsjerksteradiel'],
 ['NL', '04', 'Gemeente  Oldambt'],
 ['NL', '11', 'Gemeente Zuidplas'],
 ['NL', '05', 'Gemeente Peel en Maas'],
 ['NL', '05', 'Eijsden-Margraten'],
 ['NL', '09', 'Stichtse Vecht'],
 ['NL', '02', 'Menameradiel'],
 ['NL', '02', 'S\xc3\xbbdwest Frysl\xc3\xa2n'],
 ['NL', '11', 'Bodegraven-Reeuwijk'],
 ['NO', '05', 'Tana'],
 ['NO', '18', 'Storfjord'],
 ['NO', '05', 'S\xc3\xb8r-Varanger'],
 ['NO', '18', 'Skjerv\xc3\xb8y'],
 ['NO', '18', 'Nordreisa'],
 ['NO', '05', 'Nordkapp'],
 ['NO', '05', 'Nesseby'],
 ['NO', '05', 'M\xc3\xa5s\xc3\xb8y'],
 ['NO', '18', 'Lyngen'],
 ['NO', '05', 'Loppa'],
 ['NO', '05', 'Lebesby'],
 ['NO', '05', 'Kvalsund'],
 ['NO', '18', 'Kv\xc3\xa6nangen'],
 ['NO', '05', 'Kautokeino'],
 ['NO', '18', 'Karls\xc3\xb8y'],
 ['NO', '05', 'Karasjok'],
 ['NO', '18', 'K\xc3\xa5fjord'],
 ['NO', '05', 'Hasvik'],
 ['NO', '05', 'Gamvik'],
 ['NO', '05', 'Berlev\xc3\xa5g'],
 ['NO', '05', 'B\xc3\xa5tsfjord'],
 ['NO', '05', 'Alta'],
 ['NO', '07', 'Voss'],
 ['NO', '08', 'Volda'],
 ['NO', '10', 'Vikna'],
 ['NO', '15', 'Vik'],
 ['NO', '09', 'Vevelstad'],
 ['NO', '11', 'Vestre Toten'],
 ['NO', '11', 'Vestre Slidre'],
 ['NO', '02', 'Lillesand'],
 ['NO', '01', 'Vestby'],
 ['NO', '10', 'Verran'],
 ['NO', '10', 'Verdal'],
 ['NO', '19', 'Vennesla'],
 ['NO', '02', 'Veg\xc3\xa5rshei'],
 ['NO', '09', 'Vefsn'],
 ['NO', '08', 'Vanylven'],
 ['NO', '02', 'Valle'],
 ['NO', '20', 'Re'],
 ['NO', '09', 'V\xc3\xa5gan'],
 ['NO', '11', 'V\xc3\xa5g\xc3\xa5'],
 ['NO', '09', 'V\xc3\xa6r\xc3\xb8y'],
 ['NO', '14', 'Utsira'],
 ['NO', '07', 'Ulvik'],
 ['NO', '08', 'Ulstein'],
 ['NO', '07', 'Ullensvang'],
 ['NO', '01', 'Ullensaker'],
 ['NO', '14', 'Tysv\xc3\xa6r'],
 ['NO', '07', 'Tysnes'],
 ['NO', '09', 'Tysfjord'],
 ['NO', '06', 'Tynset'],
 ['NO', '16', 'Tydal'],
 ['NO', '02', 'Tvedestrand'],
 ['NO', '06', 'Trysil'],
 ['NO', '16', 'Trondheim'],
 ['NO', '13', 'Tr\xc3\xb8gstad'],
 ['NO', '18', 'Tran\xc3\xb8y'],
 ['NO', '09', 'Tr\xc3\xa6na'],
 ['NO', '18', 'Torsken'],
 ['NO', '20', 'Tj\xc3\xb8me'],
 ['NO', '09', 'Tjeldsund'],
 ['NO', '17', 'Tinn'],
 ['NO', '08', 'Tingvoll'],
 ['NO', '14', 'Time'],
 ['NO', '08', 'Sykkylven'],
 ['NO', '07', 'Sveio'],
 ['NO', '08', 'Surnadal'],
 ['NO', '08', 'Sunndal'],
 ['NO', '07', 'Sund'],
 ['NO', '15', 'Stryn'],
 ['NO', '14', 'Strand'],
 ['NO', '08', 'Stranda'],
 ['NO', '06', 'Stor-Elvdal'],
 ['NO', '07', 'Stord'],
 ['NO', '08', 'Stordal'],
 ['NO', '20', 'Stokke'],
 ['NO', '10', 'Stj\xc3\xb8rdal'],
 ['NO', '10', 'Steinkjer'],
 ['NO', '09', 'Steigen'],
 ['NO', '06', 'Stange'],
 ['NO', '13', 'Spydeberg'],
 ['NO', '01', 'S\xc3\xb8rum'],
 ['NO', '09', 'Sortland'],
 ['NO', '18', 'S\xc3\xb8rreisa'],
 ['NO', '06', 'S\xc3\xb8r-Odal'],
 ['NO', '11', 'S\xc3\xb8r-Fron'],
 ['NO', '09', 'S\xc3\xb8rfold'],
 ['NO', '11', 'S\xc3\xb8r-Aurdal'],
 ['NO', '19', 'Audnedal'],
 ['NO', '11', 'S\xc3\xb8ndre Land'],
 ['NO', '09', 'S\xc3\xb8mna'],
 ['NO', '15', 'Solund'],
 ['NO', '14', 'Sola'],
 ['NO', '14', 'Sokndal'],
 ['NO', '19', 'S\xc3\xb8gne'],
 ['NO', '15', 'Sogndal'],
 ['NO', '16', 'Snillfjord'],
 ['NO', '10', 'Sn\xc3\xa5sa'],
 ['NO', '08', 'Sm\xc3\xb8la'],
 ['NO', '08', 'Skodje'],
 ['NO', '11', 'Skj\xc3\xa5k'],
 ['NO', '13', 'Skiptvet'],
 ['NO', '01', 'Ski'],
 ['NO', '01', 'Skedsmo'],
 ['NO', '16', 'Skaun'],
 ['NO', '18', 'Sk\xc3\xa5nland'],
 ['NO', '19', 'Sirdal'],
 ['NO', '17', 'Siljan'],
 ['NO', '04', 'Sigdal'],
 ['NO', '17', 'Seljord'],
 ['NO', '15', 'Selje'],
 ['NO', '11', 'Sel'],
 ['NO', '16', 'Selbu'],
 ['NO', '17', 'Sauherad'],
 ['NO', '14', 'Sauda'],
 ['NO', '08', 'Sand\xc3\xb8y'],
 ['NO', '07', 'Samnanger'],
 ['NO', '09', 'Saltdal'],
 ['NO', '18', 'Salangen'],
 ['NO', '13', 'Rygge'],
 ['NO', '10', 'R\xc3\xb8yrvik'],
 ['NO', '04', 'R\xc3\xb8yken'],
 ['NO', '09', 'R\xc3\xb8st'],
 ['NO', '13', 'R\xc3\xb8mskog'],
 ['NO', '04', 'Rollag'],
 ['NO', '09', 'R\xc3\xb8d\xc3\xb8y'],
 ['NO', '16', 'Roan'],
 ['NO', '16', 'Rissa'],
 ['NO', '06', 'Ringsaker'],
 ['NO', '11', 'Ringebu'],
 ['NO', '08', 'Rindal'],
 ['NO', '14', 'Rennes\xc3\xb8y'],
 ['NO', '16', 'Rennebu'],
 ['NO', '06', 'Rendalen'],
 ['NO', '14', 'Randaberg'],
 ['NO', '13', 'Rakkestad'],
 ['NO', '01', 'R\xc3\xa6lingen'],
 ['NO', '13', 'R\xc3\xa5de'],
 ['NO', '11', '\xc3\x98ystre Slidre'],
 ['NO', '11', '\xc3\x98yer'],
 ['NO', '04', '\xc3\x98vre Eiker'],
 ['NO', '10', 'Overhalla'],
 ['NO', '11', '\xc3\x98stre Toten'],
 ['NO', '16', 'Osen'],
 ['NO', '08', '\xc3\x98rsta'],
 ['NO', '08', '\xc3\x98rskog'],
 ['NO', '16', '\xc3\x98rland'],
 ['NO', '16', 'Orkdal'],
 ['NO', '01', 'Oppeg\xc3\xa5rd'],
 ['NO', '16', 'Oppdal'],
 ['NO', '09', '\xc3\x98ksnes'],
 ['NO', '07', 'Odda'],
 ['NO', '20', 'N\xc3\xb8tter\xc3\xb8y'],
 ['NO', '11', 'Nordre Land'],
 ['NO', '06', 'Nord-Odal'],
 ['NO', '11', 'Nord-Fron'],
 ['NO', '08', 'Norddal'],
 ['NO', '11', 'Nord-Aurdal'],
 ['NO', '01', 'Nittedal'],
 ['NO', '17', 'Nissedal'],
 ['NO', '08', 'Nesset'],
 ['NO', '01', 'Nesodden'],
 ['NO', '09', 'Nesna'],
 ['NO', '04', 'Nedre Eiker'],
 ['NO', '15', 'Naustdal'],
 ['NO', '01', 'Nannestad'],
 ['NO', '10', 'Namsskogan'],
 ['NO', '10', 'Namdalseid'],
 ['NO', '10', 'N\xc3\xa6r\xc3\xb8y'],
 ['NO', '10', 'Mosvik'],
 ['NO', '09', 'Moskenes'],
 ['NO', '08', 'Molde'],
 ['NO', '04', 'Modum'],
 ['NO', '07', 'Modalen'],
 ['NO', '10', 'Mer\xc3\xa5ker'],
 ['NO', '09', 'Mel\xc3\xb8y'],
 ['NO', '16', 'Melhus'],
 ['NO', '16', 'Meldal'],
 ['NO', '07', 'Meland'],
 ['NO', '07', 'Masfjorden'],
 ['NO', '16', 'Malvik'],
 ['NO', '18', 'M\xc3\xa5lselv'],
 ['NO', '19', 'Lyngdal'],
 ['NO', '15', 'Luster'],
 ['NO', '09', 'Lur\xc3\xb8y'],
 ['NO', '11', 'Lunner'],
 ['NO', '14', 'Lund'],
 ['NO', '06', 'L\xc3\xb8ten'],
 ['NO', '01', 'L\xc3\xb8renskog'],
 ['NO', '11', 'Lom'],
 ['NO', '09', 'L\xc3\xb8dingen'],
 ['NO', '07', 'Lind\xc3\xa5s'],
 ['NO', '04', 'Lier'],
 ['NO', '11', 'Lesja'],
 ['NO', '18', 'Lenvik'],
 ['NO', '10', 'Leksvik'],
 ['NO', '10', 'Leka'],
 ['NO', '09', 'Leirfjord'],
 ['NO', '15', 'Leikanger'],
 ['NO', '18', 'Lavangen'],
 ['NO', '15', 'L\xc3\xa6rdal'],
 ['NO', '14', 'Kvits\xc3\xb8y'],
 ['NO', '17', 'Kviteseid'],
 ['NO', '07', 'Kvinnherad'],
 ['NO', '19', 'Kvinesdal'],
 ['NO', '07', 'Kvam'],
 ['NO', '18', 'Kv\xc3\xa6fjord'],
 ['NO', '04', 'Kr\xc3\xb8dsherad'],
 ['NO', '17', 'Krager\xc3\xb8'],
 ['NO', '06', 'Kongsvinger'],
 ['NO', '14', 'Klepp'],
 ['NO', '16', 'Kl\xc3\xa6bu'],
 ['NO', '07', 'Jondal'],
 ['NO', '15', 'J\xc3\xb8lster'],
 ['NO', '11', 'Jevnaker'],
 ['NO', '02', 'Iveland'],
 ['NO', '10', 'Inder\xc3\xb8y'],
 ['NO', '18', 'Ibestad'],
 ['NO', '15', 'Hyllestad'],
 ['NO', '13', 'Hvaler'],
 ['NO', '04', 'Hurum'],
 ['NO', '01', 'Hurdal'],
 ['NO', '10', 'H\xc3\xb8ylandet'],
 ['NO', '15', 'H\xc3\xb8yanger'],
 ['NO', '15', 'Hornindal'],
 ['NO', '13', 'Hob\xc3\xb8l'],
 ['NO', '14', 'Hjelmeland'],
 ['NO', '17', 'Hjartdal'],
 ['NO', '16', 'Hitra'],
 ['NO', '04', 'Hemsedal'],
 ['NO', '09', 'Hemnes'],
 ['NO', '16', 'Hemne'],
 ['NO', '09', 'Hattfjelldal'],
 ['NO', '08', 'Hareid'],
 ['NO', '08', 'Haram'],
 ['NO', '09', 'Hamar\xc3\xb8y'],
 ['NO', '16', 'Holt\xc3\xa5len'],
 ['NO', '08', 'Halsa'],
 ['NO', '19', 'H\xc3\xa6gebostad'],
 ['NO', '09', 'Hadsel'],
 ['NO', '14', 'H\xc3\xa5'],
 ['NO', '15', 'Gulen'],
 ['NO', '06', 'Grue'],
 ['NO', '10', 'Grong'],
 ['NO', '18', 'Gratangen'],
 ['NO', '07', 'Granvin'],
 ['NO', '11', 'Gran'],
 ['NO', '09', 'Grane'],
 ['NO', '04', 'Gol'],
 ['NO', '15', 'Gloppen'],
 ['NO', '14', 'Gjesdal'],
 ['NO', '02', 'Gjerstad'],
 ['NO', '01', 'Gjerdrum'],
 ['NO', '08', 'Gjemnes'],
 ['NO', '08', 'Giske'],
 ['NO', '09', 'Gildesk\xc3\xa5l'],
 ['NO', '11', 'Gausdal'],
 ['NO', '15', 'Gaular'],
 ['NO', '17', 'Fyresdal'],
 ['NO', '07', 'Fusa'],
 ['NO', '10', 'Frosta'],
 ['NO', '02', 'Froland'],
 ['NO', '01', 'Frogn'],
 ['NO', '08', 'Fr\xc3\xa6na'],
 ['NO', '10', 'Fosnes'],
 ['NO', '14', 'Forsand'],
 ['NO', '15', 'F\xc3\xb8rde'],
 ['NO', '06', 'Folldal'],
 ['NO', '15', 'Flora'],
 ['NO', '04', 'Flesberg'],
 ['NO', '10', 'Flatanger'],
 ['NO', '09', 'Flakstad'],
 ['NO', '07', 'Fjell'],
 ['NO', '15', 'Fjaler'],
 ['NO', '07', 'Fitjar'],
 ['NO', '14', 'Finn\xc3\xb8y'],
 ['NO', '01', 'Fet'],
 ['NO', '07', 'Fedje'],
 ['NO', '09', 'Fauske'],
 ['NO', '02', 'Evje og Hornnes'],
 ['NO', '09', 'Evenes'],
 ['NO', '07', 'Etne'],
 ['NO', '11', 'Etnedal'],
 ['NO', '06', 'Engerdal'],
 ['NO', '01', 'Enebakk'],
 ['NO', '06', 'Elverum'],
 ['NO', '14', 'Eigersund'],
 ['NO', '01', 'Eidsvoll'],
 ['NO', '06', 'Eidskog'],
 ['NO', '13', 'Eidsberg'],
 ['NO', '07', 'Eidfjord'],
 ['NO', '18', 'Dyr\xc3\xb8y'],
 ['NO', '17', 'Drangedal'],
 ['NO', '11', 'Dovre'],
 ['NO', '09', 'D\xc3\xb8nna'],
 ['NO', '02', 'Bykle'],
 ['NO', '02', 'Bygland'],
 ['NO', '09', 'Br\xc3\xb8nn\xc3\xb8y'],
 ['NO', '15', 'Bremanger'],
 ['NO', '20', 'Horten'],
 ['NO', '07', 'B\xc3\xb8mlo'],
 ['NO', '14', 'Bokn'],
 ['NO', '16', 'Bjugn'],
 ['NO', '14', 'Bjerkreim'],
 ['NO', '18', 'Bjark\xc3\xb8y'],
 ['NO', '02', 'Birkenes'],
 ['NO', '09', 'Bindal'],
 ['NO', '07', 'Bergen'],
 ['NO', '09', 'Beiarn'],
 ['NO', '18', 'Bardu'],
 ['NO', '17', 'Bamble'],
 ['NO', '18', 'Balsfjord'],
 ['NO', '09', 'Ballangen'],
 ['NO', '15', 'Balestrand'],
 ['NO', '01', 'B\xc3\xa6rum'],
 ['NO', '07', 'Austrheim'],
 ['NO', '07', 'Austevoll'],
 ['NO', '15', 'Aurland'],
 ['NO', '08', 'Aure'],
 ['NO', '06', '\xc3\x85snes'],
 ['NO', '15', 'Askvoll'],
 ['NO', '07', 'Ask\xc3\xb8y'],
 ['NO', '13', 'Askim'],
 ['NO', '01', 'Asker'],
 ['NO', '01', '\xc3\x85s'],
 ['NO', '19', '\xc3\x85seral'],
 ['NO', '13', 'Aremark'],
 ['NO', '20', 'Andebu'],
 ['NO', '06', '\xc3\x85mot'],
 ['NO', '02', '\xc3\x85mli'],
 ['NO', '06', 'Alvdal'],
 ['NO', '09', 'Alstahaug'],
 ['NO', '04', '\xc3\x85l'],
 ['NO', '16', 'Agdenes'],
 ['NO', '16', '\xc3\x85fjord'],
 ['NO', '05', 'Hammerfest'],
 ['NO', '05', 'Vard\xc3\xb8'],
 ['NO', '05', 'Porsanger'],
 ['NO', '05', 'Vads\xc3\xb8'],
 ['NO', '18', 'Troms\xc3\xb8'],
 ['NO', '18', 'Berg'],
 ['NO', '09', 'And\xc3\xb8y'],
 ['NO', '18', 'Harstad'],
 ['NO', '09', 'B\xc3\xb8'],
 ['NO', '09', 'Narvik'],
 ['NO', '09', 'Vestv\xc3\xa5g\xc3\xb8y'],
 ['NO', '09', 'Bod\xc3\xb8'],
 ['NO', '09', 'Rana'],
 ['NO', '09', 'Her\xc3\xb8y'],
 ['NO', '09', 'Vega'],
 ['NO', '10', 'Lierne'],
 ['NO', '10', 'Namsos'],
 ['NO', '16', 'Fr\xc3\xb8ya'],
 ['NO', '10', 'Levanger'],
 ['NO', '08', 'Kristiansund'],
 ['NO', '08', 'Aver\xc3\xb8y'],
 ['NO', '08', 'Eide'],
 ['NO', '08', 'Aukra'],
 ['NO', '16', 'Midtre Gauldal'],
 ['NO', '08', 'Midsund'],
 ['NO', '08', 'Rauma'],
 ['NO', '08', 'Vestnes'],
 ['NO', '16', 'R\xc3\xb8ros'],
 ['NO', '08', 'Her\xc3\xb8y'],
 ['NO', '08', '\xc3\x85lesund'],
 ['NO', '06', 'Os'],
 ['NO', '08', 'Sula'],
 ['NO', '06', 'Tolga'],
 ['NO', '08', 'Sande'],
 ['NO', '15', 'V\xc3\xa5gs\xc3\xb8y'],
 ['NO', '15', 'Eid'],
 ['NO', '15', '\xc3\x85rdal'],
 ['NO', '11', 'Vang'],
 ['NO', '11', 'Lillehammer'],
 ['NO', '06', 'Hamar'],
 ['NO', '07', 'Vaksdal'],
 ['NO', '07', '\xc3\x98ygarden'],
 ['NO', '07', 'Rad\xc3\xb8y'],
 ['NO', '11', 'Gj\xc3\xb8vik'],
 ['NO', '06', 'V\xc3\xa5ler'],
 ['NO', '04', 'Hol'],
 ['NO', '07', 'Oster\xc3\xb8y'],
 ['NO', '04', 'Nes'],
 ['NO', '04', 'Ringerike'],
 ['NO', '04', 'Fl\xc3\xa5'],
 ['NO', '07', 'Os'],
 ['NO', '04', 'Nore og Uvdal'],
 ['NO', '01', 'Nes'],
 ['NO', '17', 'Vinje'],
 ['NO', '12', 'Oslo'],
 ['NO', '04', 'Hole'],
 ['NO', '01', 'Aurskog-H\xc3\xb8land'],
 ['NO', '17', 'Notodden'],
 ['NO', '14', 'Suldal'],
 ['NO', '14', 'Vindafjord'],
 ['NO', '04', 'Drammen'],
 ['NO', '04', 'Kongsberg'],
 ['NO', '14', 'Haugesund'],
 ['NO', '14', 'Karm\xc3\xb8y'],
 ['NO', '17', 'Tokke'],
 ['NO', '20', 'Svelvik'],
 ['NO', '20', 'Sande'],
 ['NO', '20', 'Hof'],
 ['NO', '13', 'Marker'],
 ['NO', '17', 'B\xc3\xb8'],
 ['NO', '20', 'Holmestrand'],
 ['NO', '17', 'Skien'],
 ['NO', '13', 'Moss'],
 ['NO', '13', 'V\xc3\xa5ler'],
 ['NO', '20', 'Lardal'],
 ['NO', '17', 'Nome'],
 ['NO', '13', 'Sarpsborg'],
 ['NO', '20', 'T\xc3\xb8nsberg'],
 ['NO', '20', 'Larvik'],
 ['NO', '14', 'Stavanger'],
 ['NO', '13', 'Fredrikstad'],
 ['NO', '14', 'Sandnes'],
 ['NO', '17', 'Porsgrunn'],
 ['NO', '13', 'Halden'],
 ['NO', '20', 'Sandefjord'],
 ['NO', '02', 'Ris\xc3\xb8r'],
 ['NO', '19', 'Flekkefjord'],
 ['NO', '02', 'Arendal'],
 ['NO', '19', 'Marnardal'],
 ['NO', '02', 'Grimstad'],
 ['NO', '19', 'Songdalen'],
 ['NO', '19', 'Farsund'],
 ['NO', '19', 'Lindesnes'],
 ['NO', '19', 'Kristiansand'],
 ['NO', '19', 'Mandal'],
 ['NP', 'FR', 'Set\xc4\xab Zone'],
 ['NP', 'ER', 'Sagarm\xc4\x81th\xc4\x81 Zone'],
 ['NP', 'MR', 'R\xc4\x81pt\xc4\xab Zone'],
 ['NP', 'CR', 'N\xc4\x81r\xc4\x81yan\xc4\xab Zone'],
 ['NP', 'ER', 'Mech\xc4\xab Zone'],
 ['NP', 'FR', 'Mah\xc4\x81k\xc4\x81l\xc4\xab Zone'],
 ['NP', 'WR', 'Lumbin\xc4\xab Zone'],
 ['NP', 'ER', 'Kos\xc4\xab Zone'],
 ['NP', 'MR', 'Karn\xc4\x81l\xc4\xab Zone'],
 ['NP', 'CR', 'Janakpur Zone'],
 ['NP', 'WR', 'Gandak\xc4\xab Zone'],
 ['NP', 'WR', 'Dhawal\xc4\x81giri Zone'],
 ['NP', 'MR', 'Bher\xc4\xab Zone'],
 ['NP', 'CR', 'B\xc4\x81gmat\xc4\xab Zone'],
 ['NZ', 'F6', 'Whangarei'],
 ['NZ', 'E8', 'Whakatane District'],
 ['NZ', 'G3', 'Westland District'],
 ['NZ', 'F2', 'Wairoa District'],
 ['NZ', 'E9', 'Waimate District'],
 ['NZ', 'E9', 'Timaru District'],
 ['NZ', 'G1', 'Thames-Coromandel District'],
 ['NZ', 'E8', 'Rotorua District'],
 ['NZ', 'G1', 'Otorohanga District'],
 ['NZ', 'E8', 'Opotiki District'],
 ['NZ', 'F9', 'New Plymouth District'],
 ['NZ', 'G2', 'Masterton District'],
 ['NZ', 'E8', 'Kawerau District'],
 ['NZ', 'F2', 'Hastings District'],
 ['NZ', 'F8', 'Gore District'],
 ['NZ', 'F1', 'Gisborne District'],
 ['NZ', 'G2', 'Carterton District'],
 ['NZ', 'E7', 'Auckland'],
 ['NZ', 'E9', 'Ashburton District'],
 ['NZ', 'G3', 'Buller District'],
 ['NZ', 'F2', "Central Hawke's Bay District"],
 ['NZ', 'F7', 'Central Otago District'],
 ['NZ', 'E9', 'Christchurch City'],
 ['NZ', 'F7', 'Clutha District'],
 ['NZ', 'F7', 'Dunedin City'],
 ['NZ', 'F6', 'Far North District'],
 ['NZ', 'G3', 'Grey District'],
 ['NZ', 'G1', 'Hamilton City'],
 ['NZ', 'G1', 'Hauraki District'],
 ['NZ', 'F3', 'Horowhenua District'],
 ['NZ', 'E9', 'Hurunui District'],
 ['NZ', 'F8', 'Invercargill City'],
 ['NZ', 'E9', 'Kaikoura District'],
 ['NZ', 'F6', 'Kaipara District'],
 ['NZ', 'G2', 'Kapiti Coast District'],
 ['NZ', 'G2', 'Lower Hutt City'],
 ['NZ', 'E9', 'Mackenzie District'],
 ['NZ', 'F3', 'Manawatu District'],
 ['NZ', 'F4', 'Marlborough District'],
 ['NZ', 'G1', 'Matamata-Piako District'],
 ['NZ', 'F2', 'Napier City'],
 ['NZ', 'F5', 'Nelson City'],
 ['NZ', 'F3', 'Palmerston North City'],
 ['NZ', 'G2', 'Porirua City'],
 ['NZ', 'F7', 'Queenstown-Lakes District'],
 ['NZ', 'F3', 'Ruapehu District'],
 ['NZ', 'E9', 'Selwyn District'],
 ['NZ', 'F8', 'Southland District'],
 ['NZ', 'F9', 'South Taranaki District'],
 ['NZ', 'G1', 'South Waikato District'],
 ['NZ', 'G2', 'South Wairarapa District'],
 ['NZ', 'TAS', 'Tasman District'],
 ['NZ', 'E8', 'Tauranga City'],
 ['NZ', 'G2', 'Upper Hutt City'],
 ['NZ', 'G1', 'Waikato District'],
 ['NZ', 'E9', 'Waimakariri District'],
 ['NZ', 'G1', 'Waipa District'],
 ['NZ', 'F3', 'Wanganui District'],
 ['NZ', 'G2', 'Wellington City'],
 ['NZ', 'E8', 'Western Bay of Plenty District'],
 ['PA', '09', 'Corregimiento Tubual\xc3\xa1'],
 ['PA', '07', 'Distrito Tonos\xc3\xad'],
 ['PA', '02', 'Distrito de Tol\xc3\xa9'],
 ['PA', '08', 'Distrito Taboga'],
 ['PA', '10', 'Distrito Son\xc3\xa1'],
 ['PA', '10', 'Distrito Santiago'],
 ['PA', '06', 'Distrito Santa Mar\xc3\xada'],
 ['PA', '04', 'Distrito Santa Isabel'],
 ['PA', '10', 'Distrito Santa Fe'],
 ['PA', '08', 'Distrito San Miguelito'],
 ['PA', '02', 'Distrito San Lorenzo'],
 ['PA', '10', 'Distrito San Francisco'],
 ['PA', '02', 'Distrito San F\xc3\xa9lix'],
 ['PA', '08', 'Distrito San Carlos'],
 ['PA', '10', 'Distrito R\xc3\xado de Jes\xc3\xbas'],
 ['PA', '02', 'Distrito Renacimiento'],
 ['PA', '02', 'Distrito Remedios'],
 ['PA', '09', 'Corregimiento Puerto Obald\xc3\xada'],
 ['PA', '04', 'Distrito Portobelo'],
 ['PA', '07', 'Distrito de Pocr\xc3\xad'],
 ['PA', '05', 'Distrito de Pinogana'],
 ['PA', '06', 'Distrito Pes\xc3\xa9'],
 ['PA', '03', 'Distrito Penonom\xc3\xa9'],
 ['PA', '07', 'Distrito Pedas\xc3\xad'],
 ['PA', '06', 'Distrito Parita'],
 ['PA', '08', 'Distrito de Panam\xc3\xa1'],
 ['PA', '03', 'Distrito Ol\xc3\xa1'],
 ['PA', '06', 'Distrito Oc\xc3\xba'],
 ['PA', '03', 'Distrito Nat\xc3\xa1'],
 ['PA', '10', 'Distrito Montijo'],
 ['PA', '07', 'Distrito Macaracas'],
 ['PA', '07', 'Distrito Los Santos'],
 ['PA', '06', 'Distrito Los Pozos'],
 ['PA', '07', 'Las Tablas Abajo'],
 ['PA', '07', 'Distrito Las Tablas'],
 ['PA', '10', 'Distrito Las Palmas'],
 ['PA', '06', 'Distrito Las Minas'],
 ['PA', '03', 'Distrito La Pintada'],
 ['PA', '10', 'Distrito La Mesa'],
 ['PA', '08', 'Distrito de La Chorrera'],
 ['PA', '07', 'Distrito Guarar\xc3\xa9'],
 ['PA', '02', 'Distrito Gualaca'],
 ['PA', '04', 'Distrito Donoso'],
 ['PA', '02', 'Distrito Dolega'],
 ['PA', '02', 'Distrito David'],
 ['PA', '04', 'Distrito de Col\xc3\xb3n'],
 ['PA', '06', 'Distrito de Chitr\xc3\xa9'],
 ['PA', '12', 'Distrito Chiriqu\xc3\xad Grande'],
 ['PA', '08', 'Distrito Chim\xc3\xa1n'],
 ['PA', '08', 'Distrito Chepo'],
 ['PA', '05', 'Distrito de Chepigana'],
 ['PA', '01', 'Distrito Changuinola'],
 ['PA', '08', 'Distrito Chame'],
 ['PA', '04', 'Distrito Chagres'],
 ['PA', '08', 'Distrito Capira'],
 ['PA', '10', 'Distrito Ca\xc3\xb1azas'],
 ['PA', '10', 'Distrito Calobre'],
 ['PA', '02', 'Distrito Bugaba'],
 ['PA', '02', 'Distrito Boquete'],
 ['PA', '02', 'Distrito Boquer\xc3\xb3n'],
 ['PA', '12', 'Distrito de Bocas del Toro'],
 ['PA', '02', 'Distrito de Bar\xc3\xba'],
 ['PA', '08', 'Distrito Balboa'],
 ['PA', '10', 'Distrito Atalaya'],
 ['PA', '08', 'Distrito Arraij\xc3\xa1n'],
 ['PA', '03', 'Distrito Ant\xc3\xb3n'],
 ['PA', '02', 'Distrito de Alanje'],
 ['PA', '09', 'Corregimiento Ailigand\xc3\xad'],
 ['PA', '03', 'Distrito de Aguadulce'],
 ['PE', '24', 'Provincia de Zarumilla'],
 ['PE', '02', 'Provincia de Yungay'],
 ['PE', '16', 'Provincia de Ucayali'],
 ['PE', '24', 'Provincia de Tumbes'],
 ['PE', '13', 'Provincia de Trujillo'],
 ['PE', '20', 'Provincia de Talara'],
 ['PE', '20', 'Provincia de Sullana'],
 ['PE', '02', 'Provincia de Sihuas'],
 ['PE', '13', 'Provincia de Santiago de Chuco'],
 ['PE', '06', 'Provincia de Santa Cruz'],
 ['PE', '02', 'Provincia de Santa'],
 ['PE', '06', 'Provincia de San Miguel'],
 ['PE', '22', 'Provincia de San Mart\xc3\xadn'],
 ['PE', '06', 'Provincia de San Ignacio'],
 ['PE', '01', 'Provincia de Rodr\xc3\xadguez de Mendoza'],
 ['PE', '22', 'Provincia de Rioja'],
 ['PE', '16', 'Provincia de Requena'],
 ['PE', '02', 'Provincia de Pomabamba'],
 ['PE', '20', 'Provincia de Piura'],
 ['PE', '13', 'Provincia de Pataz'],
 ['PE', '02', 'Provincia de Pallasca'],
 ['PE', '20', 'Provincia de Paita'],
 ['PE', '10', 'Provincia de Pachitea'],
 ['PE', '13', 'Provincia de Pacasmayo'],
 ['PE', '13', 'Provincia de Otuzco'],
 ['PE', '22', 'Provincia de Moyobamba'],
 ['PE', '20', 'Morropon'],
 ['PE', '16', 'Provincia de Maynas'],
 ['PE', '02', 'Provincia de Mariscal Luzuriaga'],
 ['PE', '22', 'Provincia de Mariscal C\xc3\xa1ceres'],
 ['PE', '10', 'Provincia de Mara\xc3\xb1\xc3\xb3n'],
 ['PE', '01', 'Provincia de Luya'],
 ['PE', '16', 'Provincia de Loreto'],
 ['PE', '10', 'Provincia de Leoncio Prado'],
 ['PE', '14', 'Provincia de Lambayeque'],
 ['PE', '22', 'Provincia de Lamas'],
 ['PE', '06', 'Provincia de Ja\xc3\xa9n'],
 ['PE', '02', 'Provincia de Huaylas'],
 ['PE', '02', 'Provincia de Huarmey'],
 ['PE', '02', 'Provincia de Huari'],
 ['PE', '02', 'Provincia de Huaraz'],
 ['PE', '10', 'Provincia de Hu\xc3\xa1nuco'],
 ['PE', '20', 'Provincia de Huancabamba'],
 ['PE', '10', 'Provincia de Huamal\xc3\xades'],
 ['PE', '22', 'Provincia de Huallaga'],
 ['PE', '06', 'Provincia de Hualgayoc'],
 ['PE', '14', 'Provincia de Ferre\xc3\xb1afe'],
 ['PE', '10', 'Provincia de Dos de Mayo'],
 ['PE', '06', 'Provincia de Cutervo'],
 ['PE', '02', 'Provincia de Corongo'],
 ['PE', '25', 'Provincia de Coronel Portillo'],
 ['PE', '06', 'Provincia de Contumaz\xc3\xa1'],
 ['PE', '24', 'Provincia de Contralmirante Villar'],
 ['PE', '06', 'Provincia de Chota'],
 ['PE', '14', 'Provincia de Chiclayo'],
 ['PE', '01', 'Provincia de Chachapoyas'],
 ['PE', '06', 'Provincia de Celend\xc3\xadn'],
 ['PE', '02', 'Provincia de Casma'],
 ['PE', '02', 'Provincia de Carhuaz'],
 ['PE', '06', 'Provincia de Cajamarca'],
 ['PE', '06', 'Provincia de Cajabamba'],
 ['PE', '01', 'Provincia de Bongar\xc3\xa1'],
 ['PE', '13', 'Provincia de Bol\xc3\xadvar'],
 ['PE', '01', 'Provincia de Bagua'],
 ['PE', '20', 'Provincia de Ayabaca'],
 ['PE', '02', 'Provincia de Antonio Raymondi'],
 ['PE', '16', 'Provincia de Alto Amazonas'],
 ['PE', '02', 'Provincia de Aija'],
 ['PE', '11', 'Provincia de Ica'],
 ['PE', '15', 'Provincia de Yauyos'],
 ['PE', '12', 'Provincia de Yauli'],
 ['PE', '05', 'Provincia de V\xc3\xadctor Fajardo'],
 ['PE', '08', 'Provincia de Urubamba'],
 ['PE', '09', 'Provincia de Tayacaja'],
 ['PE', '12', 'Provincia de Tarma'],
 ['PE', '23', 'Provincia de Tarata'],
 ['PE', '17', 'Provincia de Tambopata'],
 ['PE', '17', 'Provincia de Tahuaman\xc3\xba'],
 ['PE', '23', 'Provincia de Tacna'],
 ['PE', '12', 'Provincia de Satipo'],
 ['PE', '21', 'San Roman'],
 ['PE', '21', 'Provincia de Sandia'],
 ['PE', '02', 'Provincia de Recuay'],
 ['PE', '08', 'Provincia de Quispicanchis'],
 ['PE', '21', 'Provincia de Puno'],
 ['PE', '11', 'Provincia de Pisco'],
 ['PE', '08', 'Provincia de Paucartambo'],
 ['PE', '19', 'Provincia de Pasco'],
 ['PE', '08', 'Provincia de Paruro'],
 ['PE', '05', 'Provincia de Parinacochas'],
 ['PE', '11', 'Provincia de Palpa'],
 ['PE', '19', 'Provincia de Oxapampa'],
 ['PE', '11', 'Provincia de Nazca'],
 ['PE', '21', 'Provincia de Melgar'],
 ['PE', '18', 'Provincia de Mariscal Nieto'],
 ['PE', '17', 'Provincia de Man\xc3\xba'],
 ['PE', '05', 'Provincia de Lucanas'],
 ['PE', '04', 'Provincia de La Uni\xc3\xb3n'],
 ['PE', '21', 'Provincia de Lampa'],
 ['PE', '05', 'Provincia de La Mar'],
 ['PE', '08', 'Provincia de La Convenci\xc3\xb3n'],
 ['PE', '12', 'Provincia de Jun\xc3\xadn'],
 ['PE', '12', 'Provincia de Jauja'],
 ['PE', '04', 'Provincia de Islay'],
 ['PE', '18', 'Provincia de Ilo'],
 ['PE', '15', 'Provincia de Huarochir\xc3\xad'],
 ['PE', '15', 'Provincia de Huaral'],
 ['PE', '05', 'Provincia de Huanta'],
 ['PE', '12', 'Provincia de Huancayo'],
 ['PE', '09', 'Provincia de Huancavelica'],
 ['PE', '21', 'Provincia de Huancan\xc3\xa9'],
 ['PE', '05', 'Provincia de Huamanga'],
 ['PE', '03', 'Provincia de Grau'],
 ['PE', '18', 'Provincia de General S\xc3\xa1nchez Cerro'],
 ['PE', '08', 'Provincia de Espinar'],
 ['PE', '19', 'Provincia de Daniel Carri\xc3\xb3n'],
 ['PE', '08', 'Provincia de Cusco'],
 ['PE', '03', 'Provincia de Cotabambas'],
 ['PE', '04', 'Provincia de Condesuyos'],
 ['PE', '12', 'Provincia de Concepci\xc3\xb3n'],
 ['PE', '08', 'Provincia de Chumbivilcas'],
 ['PE', '21', 'Provincia de Chucuito'],
 ['PE', '11', 'Provincia de Chincha'],
 ['PE', '12', 'Chanchamayo'],
 ['PE', '04', 'Provincia de Caylloma'],
 ['PE', '09', 'Provincia de Castrovirreyna'],
 ['PE', '04', 'Provincia de Castilla'],
 ['PE', '04', 'Provincia de Caravel\xc3\xad'],
 ['PE', '21', 'Provincia de Carabaya'],
 ['PE', '15', 'Provincia de Canta'],
 ['PE', '05', 'Provincia de Cangallo'],
 ['PE', '15', 'Provincia de Ca\xc3\xb1ete'],
 ['PE', '08', 'Provincia de Canchis'],
 ['PE', '08', 'Provincia de Canas'],
 ['PE', '04', 'Provincia de Caman\xc3\xa1'],
 ['PE', '08', 'Provincia de Calca'],
 ['PE', '15', 'Provincia de Cajatambo'],
 ['PE', '02', 'Provincia de Bolognesi'],
 ['PE', '21', 'Provincia de Az\xc3\xa1ngaro'],
 ['PE', '03', 'Provincia de Aymaraes'],
 ['PE', '04', 'Provincia de Arequipa'],
 ['PE', '03', 'Provincia de Antabamba'],
 ['PE', '08', 'Provincia de Anta'],
 ['PE', '09', 'Provincia de Angaraes'],
 ['PE', '03', 'Provincia de Andahuaylas'],
 ['PE', '10', 'Provincia de Ambo'],
 ['PE', '08', 'Provincia de Acomayo'],
 ['PE', '09', 'Provincia de Acobamba'],
 ['PE', '03', 'Provincia de Abancay'],
 ['PE', '12', 'Provincia de Chupaca'],
 ['PE', '09', 'Provincia de Churcampa'],
 ['PE', '05', 'Provincia de Sucre'],
 ['PE', '05', 'Provincia de Huanca Sancos'],
 ['PE', '05', 'Provincia de Vilcas Huam\xc3\xa1n'],
 ['PE', '13', 'Sanchez Carrion'],
 ['PE', '01', 'Condorcanqui'],
 ['PE', '01', 'Utcubamba'],
 ['PE', '02', 'Asuncion'],
 ['PE', '02', 'Carlos Fermin Fitzcarrald'],
 ['PE', '02', 'Ocros'],
 ['PE', '03', 'Chincheros'],
 ['PE', '05', 'Paucar Del Sara Sara'],
 ['PE', '06', 'San Marcos'],
 ['PE', '06', 'San Pablo'],
 ['PE', '09', 'Huaytara'],
 ['PE', '10', 'Huacaybamba'],
 ['PE', '10', 'Puerto Inca'],
 ['PE', '10', 'Lauricocha'],
 ['PE', '10', 'Yarowilca'],
 ['PE', '13', 'Ascope'],
 ['PE', '13', 'Chepen'],
 ['PE', '13', 'Julcan'],
 ['PE', '13', 'Gran Chimu'],
 ['PE', '13', 'Viru'],
 ['PE', '15', 'Barranca'],
 ['PE', '15', 'Huaura'],
 ['PE', '15', 'Oyon'],
 ['PE', '16', 'Mariscal Ramon Castilla'],
 ['PE', '16', 'Datem Del Mara\xc3\xb1on'],
 ['PE', '20', 'Sechura'],
 ['PE', '21', 'El Collao'],
 ['PE', '21', 'Moho'],
 ['PE', '21', 'San Antonio De Putina'],
 ['PE', '21', 'Yunguyo'],
 ['PE', '22', 'Bellavista'],
 ['PE', '22', 'El Dorado'],
 ['PE', '22', 'Picota'],
 ['PE', '22', 'Tocache'],
 ['PE', '23', 'Candarave'],
 ['PE', '23', 'Jorge Basadre'],
 ['PE', '25', 'Atalaya'],
 ['PE', '25', 'Padre Abad'],
 ['PE', '25', 'Purus'],
 ['PE', '07', 'Callao'],
 ['PE', '15', 'Lima'],
 ['PF', '00', 'Punaauia'],
 ['PF', '00', 'Hitiaa O Te Ra'],
 ['PG', '01', 'Rigo District'],
 ['PG', '10', 'Rabaul District'],
 ['PG', '10', 'Kokopo District'],
 ['PG', '01', 'Hiri'],
 ['PG', '04', 'Afore'],
 ['PG', '17', 'Kimbe'],
 ['PG', '17', 'Bialla'],
 ['PG', '13', 'Manus'],
 ['PG', '', 'Madang'],
 ['PG', '03', 'Milne'],
 ['PH', '09', 'Province of  Zamboanga del Sur'],
 ['PH', '09', 'Province of Zamboanga del Norte'],
 ['PH', '00', 'Zamboanga City'],
 ['PH', '03', 'Province of Zambales'],
 ['PH', '00', 'Trece Martires City'],
 ['PH', '00', 'Toledo City'],
 ['PH', '14', 'Province of Tawi-Tawi'],
 ['PH', '03', 'Province of Tarlac'],
 ['PH', '10', 'Tangub City'],
 ['PH', '00', 'Tagbilaran City'],
 ['PH', '00', 'Tagaytay City'],
 ['PH', '00', 'Tacloban City'],
 ['PH', '13', 'Province of Surigao del Sur'],
 ['PH', '13', 'Province of Surigao del Norte'],
 ['PH', '00', 'Surigao City'],
 ['PH', '14', 'Province of Sulu'],
 ['PH', '12', 'Province of Sultan Kudarat'],
 ['PH', '08', 'Province of Southern Leyte'],
 ['PH', '12', 'Province of South Cotabato'],
 ['PH', '05', 'Province of Sorsogon'],
 ['PH', '07', 'Province of Siquijor'],
 ['PH', '00', 'Silay City'],
 ['PH', '00', 'San Pablo City'],
 ['PH', 'NCR', 'San Juan'],
 ['PH', '00', 'San Jose City'],
 ['PH', '00', 'San Carlos City'],
 ['PH', '00', 'San Carlos City'],
 ['PH', '08', 'Province of Samar'],
 ['PH', '00', 'Roxas City'],
 ['PH', '41', 'Province of Romblon'],
 ['PH', '40', 'Province of Rizal'],
 ['PH', '02', 'Province of Quirino'],
 ['PH', 'NCR', 'Quezon City'],
 ['PH', '40', 'Province of Quezon'],
 ['PH', '00', 'Puerto Princesa City'],
 ['PH', 'NCR', 'Pasig'],
 ['PH', 'NCR', 'Pasay City'],
 ['PH', '01', 'Province of Pangasinan'],
 ['PH', '03', 'Province of Pampanga'],
 ['PH', '00', 'Palayan City'],
 ['PH', '41', 'Province of Palawan'],
 ['PH', '00', 'Pagadian City'],
 ['PH', '00', 'Ozamis City'],
 ['PH', '00', 'Oroquieta City'],
 ['PH', '00', 'Ormoc City'],
 ['PH', '00', 'Olongapo City'],
 ['PH', '02', 'Province of Nueva Vizcaya'],
 ['PH', '03', 'Province of Nueva Ecija'],
 ['PH', '08', 'Province of Northern Samar'],
 ['PH', '12', 'Province of North Cotabato'],
 ['PH', '07', 'Province of Negros Oriental'],
 ['PH', '06', 'Province of Negros Occidental'],
 ['PH', '00', 'Naga City'],
 ['PH', '15', 'Mountain Province'],
 ['PH', '10', 'Province of Misamis Oriental'],
 ['PH', '10', 'Province of Misamis Occidental'],
 ['PH', '41', 'Province of Mindoro Oriental'],
 ['PH', '41', 'Province of Mindoro Occidental'],
 ['PH', '05', 'Province of Masbate'],
 ['PH', '41', 'Province of Marinduque'],
 ['PH', 'NCR', 'Marikina'],
 ['PH', '00', 'City of Manila'],
 ['PH', '00', 'Mandaue City'],
 ['PH', 'NCR', 'Mandaluyong'],
 ['PH', 'NCR', 'Makati City'],
 ['PH', '14', 'Province of Maguindanao'],
 ['PH', '00', 'Lipa City'],
 ['PH', '08', 'Province of Leyte'],
 ['PH', '00', 'Legaspi City'],
 ['PH', '01', 'Province of La Union'],
 ['PH', '00', 'Lapu-Lapu City'],
 ['PH', '00', 'Laoag City'],
 ['PH', '14', 'Province of Lanao del Sur'],
 ['PH', '10', 'Province of Lanao del Norte'],
 ['PH', '40', 'Province of Laguna'],
 ['PH', '00', 'La Carlota City'],
 ['PH', '02', 'Province of Isabela'],
 ['PH', '00', 'Iloilo City'],
 ['PH', '06', 'Province of Iloilo'],
 ['PH', '01', 'Province of Ilocos Sur'],
 ['PH', '01', 'Province of Ilocos Norte'],
 ['PH', '15', 'Province of Ifugao'],
 ['PH', '00', 'Gingoog City'],
 ['PH', '12', 'General Santos City'],
 ['PH', '08', 'Province of Eastern Samar'],
 ['PH', '00', 'Dumaguete City'],
 ['PH', '00', 'Dipolog City'],
 ['PH', '13', 'Dinagat'],
 ['PH', '11', 'Province of Davao Oriental'],
 ['PH', '11', 'Province of Davao del Sur'],
 ['PH', '00', 'Davao City'],
 ['PH', '11', 'Province of Davao del Norte'],
 ['PH', '00', 'Dapitan City'],
 ['PH', '00', 'Danao City'],
 ['PH', '00', 'Dagupan City'],
 ['PH', '00', 'Cotabato City'],
 ['PH', '11', 'Compostela'],
 ['PH', '00', 'Cebu City'],
 ['PH', '07', 'Province of Cebu'],
 ['PH', '00', 'Cavite City'],
 ['PH', '40', 'Province of Cavite'],
 ['PH', '05', 'Province of Catanduanes'],
 ['PH', '06', 'Province of Capiz'],
 ['PH', '00', 'Canlaon City'],
 ['PH', '10', 'Province of Camiguin'],
 ['PH', '05', 'Province of Camarines Sur'],
 ['PH', '05', 'Province of Camarines Norte'],
 ['PH', 'NCR', 'Caloocan City'],
 ['PH', '00', 'Calbayog City'],
 ['PH', '02', 'Province of Cagayan'],
 ['PH', '00', 'Cadiz City'],
 ['PH', '00', 'Cabanatuan City'],
 ['PH', '00', 'Butuan City'],
 ['PH', '03', 'Province of Bulacan'],
 ['PH', '10', 'Province of Bukidnon'],
 ['PH', '07', 'Province of Bohol'],
 ['PH', '08', 'Biliran'],
 ['PH', '15', 'Province of Benguet'],
 ['PH', '00', 'Batangas City'],
 ['PH', '40', 'Province of Batangas'],
 ['PH', '02', 'Province of Batanes'],
 ['PH', '03', 'Province of Bataan'],
 ['PH', '14', 'Province of Basilan'],
 ['PH', '00', 'Bais City'],
 ['PH', '15', 'Baguio City'],
 ['PH', '03', 'Province of Aurora'],
 ['PH', '06', 'Province of Antique'],
 ['PH', '00', 'Antipolo'],
 ['PH', '05', 'Province of Albay'],
 ['PH', '06', 'Province of Aklan'],
 ['PH', '13', 'Province of Agusan del Sur'],
 ['PH', '13', 'Province of Agusan del Norte'],
 ['PH', '15', 'Province of Abra'],
 ['PH', '00', 'Marawi City'],
 ['PH', '00', 'Chartered City of Cagayan de Oro'],
 ['PH', '00', 'City of Malaybalay'],
 ['PH', '15', 'Kalinga'],
 ['PH', '15', 'Apayao'],
 ['PH', '09', 'Province of Zamboanga Sibugay'],
 ['PH', '06', 'Province of Guimaras'],
 ['PH', '12', 'Province of Sarangani'],
 ['PK', '02', 'Zhob District'],
 ['PK', '04', 'Vih\xc4\x81ri District'],
 ['PK', '02', 'Kech District'],
 ['PK', '05', 'Thatta District'],
 ['PK', '05', 'Thar P\xc4\x81rkar District'],
 ['PK', '03', 'Sw\xc4\x81t District'],
 ['PK', '05', 'Sukkur District'],
 ['PK', '01', 'South Waz\xc4\xabrist\xc4\x81n Agency'],
 ['PK', '02', 'Sibi District'],
 ['PK', '04', 'Si\xc4\x81lkot District'],
 ['PK', '05', 'Shik\xc4\x81rpur District'],
 ['PK', '04', 'Shekh\xc5\xabpura District'],
 ['PK', '04', 'Sargodha Division'],
 ['PK', '04', 'Sargodha District'],
 ['PK', '05', 'S\xc4\x81nghar District'],
 ['PK', '04', 'S\xc4\x81h\xc4\xabw\xc4\x81l District'],
 ['PK', '04', 'R\xc4\x81walpindi Division'],
 ['PK', '04', 'R\xc4\x81walpindi District'],
 ['PK', '04', 'Rah\xc4\xabmy\xc4\x81r Kh\xc4\x81n District'],
 ['PK', '02', 'Quetta Division'],
 ['PK', '02', 'Quetta District'],
 ['PK', '06', 'Poonch District'],
 ['PK', '02', 'Pish\xc4\xabn District'],
 ['PK', '03', 'Pesh\xc4\x81war Division'],
 ['PK', '03', 'Pesh\xc4\x81war District'],
 ['PK', '02', 'Panjg\xc5\xabr District'],
 ['PK', '01', 'Orakzai Agency'],
 ['PK', '01', 'North Waz\xc4\xabrist\xc4\x81n Agency'],
 ['PK', '05', 'Naw\xc4\x81bsh\xc4\x81h District'],
 ['PK', '02', 'Nas\xc4\xabr\xc4\x81b\xc4\x81d District'],
 ['PK', '04', 'Muzaffargarh District'],
 ['PK', '06', 'Muzaffar\xc4\x81b\xc4\x81d District'],
 ['PK', '04', 'Mult\xc4\x81n Division'],
 ['PK', '04', 'Mult\xc4\x81n District'],
 ['PK', '01', 'Mohmand Agency'],
 ['PK', '06', 'Mirpur District'],
 ['PK', '04', 'Mi\xc4\x81nw\xc4\x81li District'],
 ['PK', '03', 'Mard\xc4\x81n District'],
 ['PK', '03', 'M\xc4\x81nsehra District'],
 ['PK', '03', 'Malakand Division'],
 ['PK', '03', 'Malakand Protected Area'],
 ['PK', '02', 'Makr\xc4\x81n Division'],
 ['PK', '02', 'Loralai District'],
 ['PK', '02', 'Lasbela District'],
 ['PK', '05', 'L\xc4\x81rk\xc4\x81na District'],
 ['PK', '04', 'Lahore Division'],
 ['PK', '04', 'Lahore District'],
 ['PK', '01', 'Kurram Agency'],
 ['PK', '06', 'Kotli District'],
 ['PK', '02', 'Kohlu District'],
 ['PK', '03', 'Kohist\xc4\x81n District'],
 ['PK', '03', 'Koh\xc4\x81t District'],
 ['PK', '01', 'Khyber Agency'],
 ['PK', '02', 'Khuzd\xc4\x81r District'],
 ['PK', '02', 'Kh\xc4\x81r\xc4\x81n District'],
 ['PK', '05', 'Khairpur Division'],
 ['PK', '05', 'Khairpur District'],
 ['PK', '04', 'Kas\xc5\xabr District'],
 ['PK', '05', 'Kar\xc4\x81chi District'],
 ['PK', '02', 'Khelat'],
 ['PK', '02', 'Kal\xc4\x81t District'],
 ['PK', '02', 'Kachhi District'],
 ['PK', '04', 'Jhelum District'],
 ['PK', '04', 'Jhang District'],
 ['PK', '05', 'Jacob\xc4\x81b\xc4\x81d District'],
 ['PK', '05', 'Hyder\xc4\x81b\xc4\x81d Division'],
 ['PK', '05', 'Hyder\xc4\x81b\xc4\x81d District'],
 ['PK', '07', 'Hunza-Nagar District'],
 ['PK', '03', 'Haz\xc4\x81ra Division'],
 ['PK', '02', 'Gw\xc4\x81dar District'],
 ['PK', '04', 'Gujr\xc4\x81t District'],
 ['PK', '04', 'Gujr\xc4\x81nw\xc4\x81la Division'],
 ['PK', '04', 'Gujr\xc4\x81nw\xc4\x81la District'],
 ['PK', '04', 'Faisal\xc4\x81b\xc4\x81d Division'],
 ['PK', '04', 'Faisal\xc4\x81b\xc4\x81d District'],
 ['PK', '03', 'Upper D\xc4\xabr District'],
 ['PK', '01', 'Dera Ism\xc4\x81\xc4\xabl Kh\xc4\x81n Tribal Area'],
 ['PK', '03', 'Dera Ism\xc4\x81\xc4\xabl Kh\xc4\x81n District'],
 ['PK', '04', 'Dera Gh\xc4\x81zi Kh\xc4\x81n District'],
 ['PK', '05', 'D\xc4\x81du District'],
 ['PK', '03', 'Chitr\xc4\x81l District'],
 ['PK', '02', 'Ch\xc4\x81gai District'],
 ['PK', '03', 'Buner District'],
 ['PK', '03', 'Bannu District'],
 ['PK', '07', 'Sk\xc4\x81rdu District'],
 ['PK', '01', 'B\xc4\x81jaur Agency'],
 ['PK', '04', 'Bah\xc4\x81walpur Division'],
 ['PK', '04', 'Bah\xc4\x81walpur District'],
 ['PK', '04', 'Bah\xc4\x81walnagar District'],
 ['PK', '05', 'Bad\xc4\xabn District'],
 ['PK', '04', 'Attock District'],
 ['PK', '03', 'Abbott\xc4\x81b\xc4\x81d District'],
 ['PK', '02', 'Aw\xc4\x81r\xc4\x81n District'],
 ['PK', '02', 'B\xc4\x81rkh\xc4\x81n District'],
 ['PK', '02', 'Bol\xc4\x81n District'],
 ['PK', '02', 'Dera Bugti District'],
 ['PK', '02', 'J\xc4\x81far\xc4\x81b\xc4\x81d District'],
 ['PK', '02', 'Jhal Magsi District'],
 ['PK', '02', 'Mastung District'],
 ['PK', '02', 'M\xc5\xabsa Khel District'],
 ['PK', '02', 'Nushki District'],
 ['PK', '02', 'Qila Abdull\xc4\x81h District'],
 ['PK', '02', 'Qila Saifull\xc4\x81h District'],
 ['PK', '02', 'W\xc4\x81shuk District'],
 ['PK', '02', 'Zi\xc4\x81rat District'],
 ['PK', '04', 'Toba Tek Singh District'],
 ['PK', '05', 'Naushahro F\xc4\xabroz District'],
 ['PK', '05', 'Ghotki District'],
 ['PK', '04', 'Lodhr\xc4\x81n District'],
 ['PK', '04', 'P\xc4\x81kpattan District'],
 ['PK', '04', 'Ok\xc4\x81ra District'],
 ['PK', '04', 'Kh\xc4\x81new\xc4\x81l District'],
 ['PK', '04', 'H\xc4\x81fiz\xc4\x81b\xc4\x81d District'],
 ['PK', '04', 'Mandi Bah\xc4\x81udd\xc4\xabn District'],
 ['PK', '04', 'Chakw\xc4\x81l District'],
 ['PK', '04', 'Khush\xc4\x81b District'],
 ['PK', '04', 'Bhakkar District'],
 ['PK', '04', 'Leiah District'],
 ['PK', '04', 'N\xc4\x81row\xc4\x81l District'],
 ['PK', '03', 'Lakki Marwat District'],
 ['PK', '03', 'T\xc4\x81nk District'],
 ['PK', '01', 'T\xc4\x81nk Tribal Area'],
 ['PK', '01', 'Bannu Tribal Area'],
 ['PK', '01', 'Lakki Marwat Tribal Area'],
 ['PK', '03', 'Karak District'],
 ['PK', '03', 'Hangu District'],
 ['PK', '01', 'Pesh\xc4\x81war Tribal Area'],
 ['PK', '01', 'Koh\xc4\x81t Tribal Area'],
 ['PK', '03', 'Ch\xc4\x81rsadda District'],
 ['PK', '03', 'Nowshera District'],
 ['PK', '03', 'Sh\xc4\x81ngla District'],
 ['PK', '03', 'Har\xc4\xabpur District'],
 ['PK', '03', 'Sw\xc4\x81bi District'],
 ['PK', '03', 'Lower D\xc4\xabr District'],
 ['PK', '07', 'Ghizar District'],
 ['PK', '07', 'Ghanche District'],
 ['PK', '05', 'J\xc4\x81mshoro District'],
 ['PK', '05', 'Mati\xc4\x81ri District'],
 ['PK', '04', 'Nank\xc4\x81na S\xc4\x81hib District'],
 ['PK', '06', 'Bhimbar District'],
 ['PK', '06', 'Bagh District'],
 ['PK', '04', 'Sudhnati District'],
 ['PK', '01', 'Chawkay'],
 ['PK', '03', 'Tor Ghar'],
 ['PK', '06', 'Neelum District'],
 ['PK', '03', 'Batagram'],
 ['PK', '04', 'R\xc4\x81janpur'],
 ['PK', '07', 'Astor'],
 ['PK', '06', 'Haveli'],
 ['PK', '06', 'Hatian'],
 ['PK', '02', 'Harnai'],
 ['PK', '02', 'Shir\xc4\x81ni'],
 ['PK', '07', 'Gilgit'],
 ['PK', '07', 'Diam\xc4\xabr'],
 ['PL', '83', 'Powiat b\xc4\x99dzi\xc5\x84ski'],
 ['PL', '85', 'Powiat olszty\xc5\x84ski'],
 ['PL', '77', 'Powiat miechowski'],
 ['PL', '77', 'Powiat boche\xc5\x84ski'],
 ['PL', '77', 'Powiat brzeski'],
 ['PL', '77', 'Powiat chrzanowski'],
 ['PL', '77', 'Powiat d\xc4\x85browski'],
 ['PL', '77', 'Powiat gorlicki'],
 ['PL', '77', 'Powiat krakowski'],
 ['PL', '77', 'Powiat limanowski'],
 ['PL', '77', 'Powiat my\xc5\x9blenicki'],
 ['PL', '77', 'Powiat nowos\xc4\x85decki'],
 ['PL', '77', 'Powiat nowotarski'],
 ['PL', '77', 'Powiat olkuski'],
 ['PL', '77', 'Powiat o\xc5\x9bwi\xc4\x99cimski'],
 ['PL', '77', 'Powiat proszowicki'],
 ['PL', '77', 'Powiat suski'],
 ['PL', '77', 'Powiat tarnowski'],
 ['PL', '77', 'Powiat tatrza\xc5\x84ski'],
 ['PL', '77', 'Powiat wadowicki'],
 ['PL', '77', 'Powiat wielicki'],
 ['PL', '78', 'Warszawa'],
 ['PL', '74', 'powiat \xc5\x81\xc3\xb3dzki Wschodni'],
 ['PL', '74', 'powiat \xc5\x81owicki'],
 ['PL', '75', 'Bia\xc5\x82a Podlaska'],
 ['PL', '75', 'Che\xc5\x82m'],
 ['PL', '75', 'Zamo\xc5\x9b\xc4\x87'],
 ['PL', '76', 'Powiat \xc5\xbcarski'],
 ['PL', '79', 'Powiat brzeski'],
 ['PL', '79', 'Powiat namys\xc5\x82owski'],
 ['PL', '79', 'Powiat nyski'],
 ['PL', '86', 'Powiat k\xc4\x99pi\xc5\x84ski'],
 ['PL', '75', 'Powiat bi\xc5\x82gorajski'],
 ['PL', '75', 'Powiat che\xc5\x82mski'],
 ['PL', '75', 'Powiat hrubieszowski'],
 ['PL', '75', 'Powiat janowski'],
 ['PL', '75', 'Powiat krasnostawski'],
 ['PL', '75', 'Powiat kra\xc5\x9bnicki'],
 ['PL', '75', 'Powiat lubartowski'],
 ['PL', '75', 'Powiat lubelski'],
 ['PL', '76', 'Gorz\xc3\xb3w Wielkopolski'],
 ['PL', '74', 'Piotrk\xc3\xb3w Trybunalski'],
 ['PL', '83', 'D\xc4\x85browa G\xc3\xb3rnicza'],
 ['PL', '78', 'Powiat kozienicki'],
 ['PL', '80', 'Przemy\xc5\x9bl'],
 ['PL', '87', '\xc5\x9awinouj\xc5\x9bcie'],
 ['PL', '78', 'Powiat w\xc4\x99growski'],
 ['PL', '78', 'Powiat wo\xc5\x82omi\xc5\x84ski'],
 ['PL', '78', 'Powiat wyszkowski'],
 ['PL', '85', 'Powiat ostr\xc3\xb3dzki'],
 ['PL', '87', 'Powiat koszali\xc5\x84ski'],
 ['PL', '87', 'Powiat s\xc5\x82awie\xc5\x84ski'],
 ['PL', '87', 'Powiat szczecinecki'],
 ['PL', '78', 'Powiat gr\xc3\xb3jecki'],
 ['PL', '78', 'Powiat przysuski'],
 ['PL', '78', 'Powiat sochaczewski'],
 ['PL', '78', 'Powiat \xc5\xbcyrardowski'],
 ['PL', '79', 'Powiat kluczborski'],
 ['PL', '79', 'Powiat oleski'],
 ['PL', '83', 'Powiat cz\xc4\x99stochowski'],
 ['PL', '83', 'Powiat k\xc5\x82obucki'],
 ['PL', '84', 'Powiat konecki'],
 ['PL', '84', 'Powiat w\xc5\x82oszczowski'],
 ['PL', '86', 'Powiat kaliski'],
 ['PL', '77', 'Powiat krakowski'],
 ['PL', '80', 'Powiat d\xc4\x99bicki'],
 ['PL', '80', 'Powiat jasielski'],
 ['PL', '80', 'Powiat mielecki'],
 ['PL', '81', 'Bia\xc5\x82ystok'],
 ['PL', '81', '\xc5\x81om\xc5\xbca'],
 ['PL', '80', 'Powiat kolbuszowski'],
 ['PL', '80', 'Powiat kro\xc5\x9bnie\xc5\x84ski'],
 ['PL', '80', 'Powiat leski'],
 ['PL', '80', 'Powiat \xc5\x82a\xc5\x84cucki'],
 ['PL', '80', 'Powiat przemyski'],
 ['PL', '80', 'Powiat ropczycko-s\xc4\x99dziszowski'],
 ['PL', '80', 'Powiat rzeszowski'],
 ['PL', '80', 'Powiat sanocki'],
 ['PL', '80', 'Powiat strzy\xc5\xbcowski'],
 ['PL', '85', 'Powiat braniewski'],
 ['PL', '85', 'Powiat elbl\xc4\x85ski'],
 ['PL', '82', 'Powiat ko\xc5\x9bcierski'],
 ['PL', '82', 'Powiat l\xc4\x99borski'],
 ['PL', '82', 'Powiat malborski'],
 ['PL', '82', 'Powiat pucki'],
 ['PL', '82', 'Powiat kartuski'],
 ['PL', '83', 'Rybnik'],
 ['PL', '83', 'Bielsko-Bia\xc5\x82a'],
 ['PL', '83', 'Katowice'],
 ['PL', '87', 'Powiat stargardzki'],
 ['PL', '87', 'Powiat goleniowski'],
 ['PL', '87', 'Powiat gryficki'],
 ['PL', '72', 'Jelenia G\xc3\xb3ra'],
 ['PL', '84', 'Powiat kielecki'],
 ['PL', '85', 'Powiat bartoszycki'],
 ['PL', '85', 'Powiat gi\xc5\xbcycki'],
 ['PL', '85', 'Powiat lidzbarski'],
 ['PL', '72', 'Wroc\xc5\x82aw'],
 ['PL', '86', 'Powiat obornicki'],
 ['PL', '85', 'Powiat szczycie\xc5\x84ski'],
 ['PL', '72', 'Powiat boles\xc5\x82awiecki'],
 ['PL', '72', 'Powiat dzier\xc5\xbconiowski'],
 ['PL', '72', 'Powiat g\xc5\x82ogowski'],
 ['PL', '72', 'Powiat g\xc3\xb3rowski'],
 ['PL', '83', 'Powiat cieszy\xc5\x84ski'],
 ['PL', '83', 'Powiat miko\xc5\x82owski'],
 ['PL', '83', 'Powiat myszkowski'],
 ['PL', '83', 'Powiat rybnicki'],
 ['PL', '76', 'Powiat wschowski'],
 ['PL', '73', 'Toru\xc5\x84'],
 ['PL', '73', 'Bydgoszcz'],
 ['PL', '72', 'Powiat jaworski'],
 ['PL', '72', 'Powiat jeleniog\xc3\xb3rski'],
 ['PL', '83', 'Jaworzno'],
 ['PL', '79', 'Opole'],
 ['PL', '80', 'Rzesz\xc3\xb3w'],
 ['PL', '82', 'Sopot'],
 ['PL', '72', 'Powiat k\xc5\x82odzki'],
 ['PL', '72', 'Powiat legnicki'],
 ['PL', '72', 'Powiat luba\xc5\x84ski'],
 ['PL', '77', 'Powiat nowos\xc4\x85decki'],
 ['PL', '77', 'Powiat tarnowski'],
 ['PL', '81', 'Powiat kolne\xc5\x84ski'],
 ['PL', '81', 'Powiat \xc5\x82om\xc5\xbcy\xc5\x84ski'],
 ['PL', '81', 'Powiat zambrowski'],
 ['PL', '84', 'Powiat ostrowiecki'],
 ['PL', '80', 'Powiat jaros\xc5\x82awski'],
 ['PL', '72', 'Powiat lubi\xc5\x84ski'],
 ['PL', '72', 'Powiat lw\xc3\xb3wecki'],
 ['PL', '72', 'Powiat milicki'],
 ['PL', '72', 'Powiat ole\xc5\x9bnicki'],
 ['PL', '72', 'Powiat o\xc5\x82awski'],
 ['PL', '72', 'Powiat polkowicki'],
 ['PL', '72', 'Powiat strzeli\xc5\x84ski'],
 ['PL', '72', 'Powiat \xc5\x9bredzki'],
 ['PL', '80', 'Tarnobrzeg'],
 ['PL', '87', 'Szczecin'],
 ['PL', '81', 'Powiat augustowski'],
 ['PL', '87', 'Powiat kamie\xc5\x84ski'],
 ['PL', '87', 'Powiat ko\xc5\x82obrzeski'],
 ['PL', '87', 'Powiat policki'],
 ['PL', '87', 'Powiat pyrzycki'],
 ['PL', '72', 'Powiat \xc5\x9bwidnicki'],
 ['PL', '72', 'Powiat trzebnicki'],
 ['PL', '72', 'Powiat wa\xc5\x82brzyski'],
 ['PL', '72', 'Powiat wo\xc5\x82owski'],
 ['PL', '72', 'Powiat wroc\xc5\x82awski'],
 ['PL', '72', 'Powiat z\xc4\x85bkowicki'],
 ['PL', '72', 'Powiat zgorzelecki'],
 ['PL', '72', 'Powiat z\xc5\x82otoryjski'],
 ['PL', '83', 'Powiat wodzis\xc5\x82awski'],
 ['PL', '76', 'Powiat nowosolski'],
 ['PL', '76', 'Powiat \xc5\xbcaga\xc5\x84ski'],
 ['PL', '83', 'Gliwice'],
 ['PL', '86', 'Pozna\xc5\x84'],
 ['PL', '85', 'Powiat w\xc4\x99gorzewski'],
 ['PL', '85', 'Powiat k\xc4\x99trzy\xc5\x84ski'],
 ['PL', '87', 'Powiat drawski'],
 ['PL', '86', 'Powiat pleszewski'],
 ['PL', '86', 'Kalisz'],
 ['PL', '75', 'Powiat \xc5\x82\xc4\x99czy\xc5\x84ski'],
 ['PL', '75', 'Powiat \xc5\x82ukowski'],
 ['PL', '75', 'Powiat opolski'],
 ['PL', '75', 'Powiat parczewski'],
 ['PL', '75', 'Powiat pu\xc5\x82awski'],
 ['PL', '75', 'Powiat radzy\xc5\x84ski'],
 ['PL', '75', 'Powiat rycki'],
 ['PL', '75', 'Powiat \xc5\x9bwidnicki'],
 ['PL', '75', 'Powiat tomaszowski'],
 ['PL', '75', 'Powiat w\xc5\x82odawski'],
 ['PL', '75', 'Powiat zamojski'],
 ['PL', '78', 'Powiat makowski'],
 ['PL', '78', 'Powiat piaseczy\xc5\x84ski'],
 ['PL', '78', 'Powiat mi\xc5\x84ski'],
 ['PL', '78', 'Powiat radomski'],
 ['PL', '78', 'Powiat nowodworski'],
 ['PL', '78', 'Powiat m\xc5\x82awski'],
 ['PL', '78', 'Powiat ostro\xc5\x82\xc4\x99cki'],
 ['PL', '78', 'Powiat ostrowski'],
 ['PL', '78', 'Powiat otwocki'],
 ['PL', '78', 'Powiat p\xc5\x82o\xc5\x84ski'],
 ['PL', '78', 'Powiat pruszkowski'],
 ['PL', '78', 'Powiat przasnyski'],
 ['PL', '78', 'Powiat pu\xc5\x82tuski'],
 ['PL', '78', 'Powiat soko\xc5\x82owski'],
 ['PL', '78', 'Powiat szyd\xc5\x82owiecki'],
 ['PL', '78', 'Powiat p\xc5\x82ocki'],
 ['PL', '78', 'Powiat lipski'],
 ['PL', '78', 'Powiat \xc5\x82osicki'],
 ['PL', '78', 'Powiat siedlecki'],
 ['PL', '78', 'Powiat zwole\xc5\x84ski'],
 ['PL', '80', 'Powiat le\xc5\xbcajski'],
 ['PL', '80', 'Powiat lubaczowski'],
 ['PL', '80', 'Powiat ni\xc5\xbca\xc5\x84ski'],
 ['PL', '80', 'Powiat przeworski'],
 ['PL', '80', 'Powiat stalowowolski'],
 ['PL', '81', 'Powiat siemiatycki'],
 ['PL', '84', 'Powiat opatowski'],
 ['PL', '86', 'Powiat krotoszy\xc5\x84ski'],
 ['PL', '86', 'Powiat leszczy\xc5\x84ski'],
 ['PL', '73', 'Powiat aleksandrowski'],
 ['PL', '73', 'Powiat brodnicki'],
 ['PL', '73', 'Powiat bydgoski'],
 ['PL', '73', 'Powiat che\xc5\x82mi\xc5\x84ski'],
 ['PL', '73', 'Powiat golubsko-dobrzy\xc5\x84ski'],
 ['PL', '73', 'Powiat grudzi\xc4\x85dzki'],
 ['PL', '73', 'Powiat inowroc\xc5\x82awski'],
 ['PL', '73', 'Powiat lipnowski'],
 ['PL', '73', 'Powiat mogile\xc5\x84ski'],
 ['PL', '73', 'Powiat nakielski'],
 ['PL', '73', 'Powiat radziejowski'],
 ['PL', '73', 'Powiat rypi\xc5\x84ski'],
 ['PL', '73', 'Powiat s\xc4\x99pole\xc5\x84ski'],
 ['PL', '73', 'Powiat \xc5\x9bwiecki'],
 ['PL', '73', 'Powiat toru\xc5\x84ski'],
 ['PL', '73', 'Powiat tucholski'],
 ['PL', '73', 'Powiat w\xc4\x85brzeski'],
 ['PL', '73', 'Powiat w\xc5\x82oc\xc5\x82awski'],
 ['PL', '73', 'Powiat \xc5\xbcni\xc5\x84ski'],
 ['PL', '78', 'Powiat bia\xc5\x82obrzeski'],
 ['PL', '78', 'Powiat ciechanowski'],
 ['PL', '78', 'Powiat grodziski'],
 ['PL', '78', 'Powiat legionowski'],
 ['PL', '74', 'Powiat kutnowski'],
 ['PL', '78', 'Powiat gostyni\xc5\x84ski'],
 ['PL', '78', 'Powiat sierpecki'],
 ['PL', '78', 'Powiat \xc5\xbcuromi\xc5\x84ski'],
 ['PL', '82', 'Powiat chojnicki'],
 ['PL', '82', 'Powiat cz\xc5\x82uchowski'],
 ['PL', '82', 'Powiat kwidzy\xc5\x84ski'],
 ['PL', '82', 'Powiat starogardzki'],
 ['PL', '82', 'Powiat tczewski'],
 ['PL', '85', 'Powiat dzia\xc5\x82dowski'],
 ['PL', '85', 'Powiat i\xc5\x82awski'],
 ['PL', '85', 'Powiat nowomiejski'],
 ['PL', '78', 'P\xc5\x82ock'],
 ['PL', '78', 'Siedlce'],
 ['PL', '81', 'Suwa\xc5\x82ki'],
 ['PL', '82', 'S\xc5\x82upsk'],
 ['PL', '82', 'Gdynia'],
 ['PL', '86', 'Powiat koni\xc5\x84ski'],
 ['PL', '86', 'Powiat pilski'],
 ['PL', '86', 'Powiat s\xc5\x82upecki'],
 ['PL', '86', 'Powiat w\xc4\x85growiecki'],
 ['PL', '86', 'Powiat z\xc5\x82otowski'],
 ['PL', '75', 'Powiat bialski'],
 ['PL', '83', 'Mys\xc5\x82owice'],
 ['PL', '83', 'Ruda \xc5\x9al\xc4\x85ska'],
 ['PL', '83', 'Zabrze'],
 ['PL', '83', '\xc5\xbbory'],
 ['PL', '86', 'Powiat czarnkowsko-trzcianecki'],
 ['PL', '74', 'Powiat rawski'],
 ['PL', '86', 'Powiat mi\xc4\x99dzychodzki'],
 ['PL', '86', 'Powiat nowotomyski'],
 ['PL', '86', 'Powiat wolszty\xc5\x84ski'],
 ['PL', '87', 'Powiat choszcze\xc5\x84ski'],
 ['PL', '87', 'Powiat wa\xc5\x82ecki'],
 ['PL', '83', 'Jastrz\xc4\x99bie-Zdr\xc3\xb3j'],
 ['PL', '84', 'Kielce'],
 ['PL', '86', 'Konin'],
 ['PL', '83', 'Cz\xc4\x99stochowa'],
 ['PL', '83', 'Piekary \xc5\x9al\xc4\x85skie'],
 ['PL', '73', 'W\xc5\x82oc\xc5\x82awek'],
 ['PL', '83', 'Chorz\xc3\xb3w'],
 ['PL', '72', 'Legnica'],
 ['PL', '73', 'Grudzi\xc4\x85dz'],
 ['PL', '75', 'Lublin'],
 ['PL', '82', 'Powiat gda\xc5\x84ski'],
 ['PL', '87', 'Powiat bia\xc5\x82ogardzki'],
 ['PL', '74', 'Skierniewice'],
 ['PL', '78', 'Ostro\xc5\x82\xc4\x99ka'],
 ['PL', '83', 'Sosnowiec'],
 ['PL', '80', 'Krosno'],
 ['PL', '84', 'Powiat sandomierski'],
 ['PL', '76', 'Powiat gorzowski'],
 ['PL', '76', 'Powiat mi\xc4\x99dzyrzecki'],
 ['PL', '76', 'Powiat s\xc5\x82ubicki'],
 ['PL', '76', 'Powiat strzelecko-drezdenecki'],
 ['PL', '78', 'Radom'],
 ['PL', '87', 'Koszalin'],
 ['PL', '83', 'Tychy'],
 ['PL', '83', 'Siemianowice \xc5\x9al\xc4\x85skie'],
 ['PL', '83', 'Bytom'],
 ['PL', '76', 'Powiat sul\xc4\x99ci\xc5\x84ski'],
 ['PL', '76', 'Powiat \xc5\x9bwiebodzi\xc5\x84ski'],
 ['PL', '87', 'Powiat gryfi\xc5\x84ski'],
 ['PL', '85', 'Olsztyn'],
 ['PL', '76', 'Zielona G\xc3\xb3ra'],
 ['PL', '83', '\xc5\x9awi\xc4\x99toch\xc5\x82owice'],
 ['PL', '86', 'Leszno'],
 ['PL', '86', 'Powiat pozna\xc5\x84ski'],
 ['PL', '86', 'Powiat szamotulski'],
 ['PL', '86', 'Powiat wrzesi\xc5\x84ski'],
 ['PL', '84', 'Powiat skar\xc5\xbcyski'],
 ['PL', '72', 'Powiat kamiennog\xc3\xb3rski'],
 ['PL', '84', 'Powiat starachowicki'],
 ['PL', '85', 'Powiat nidzicki'],
 ['PL', '85', 'Powiat piski'],
 ['PL', '82', 'Gda\xc5\x84sk'],
 ['PL', '76', 'Powiat zielonog\xc3\xb3rski'],
 ['PL', '86', 'Powiat turecki'],
 ['PL', '87', 'Powiat my\xc5\x9bliborski'],
 ['PL', '74', 'Powiat piotrkowski'],
 ['PL', '74', 'Powiat podd\xc4\x99bicki'],
 ['PL', '74', 'Powiat radomszcza\xc5\x84ski'],
 ['PL', '74', 'Powiat sieradzki'],
 ['PL', '74', 'Powiat be\xc5\x82chatowski'],
 ['PL', '87', 'Powiat \xc5\x9bwidwi\xc5\x84ski'],
 ['PL', '85', 'Powiat e\xc5\x82cki'],
 ['PL', '85', 'Powiat olecki'],
 ['PL', '85', 'Powiat go\xc5\x82dapski'],
 ['PL', '82', 'Powiat bytowski'],
 ['PL', '74', 'Powiat \xc5\x82aski'],
 ['PL', '74', 'Powiat \xc5\x82\xc4\x99czycki'],
 ['PL', '74', 'Powiat brzezi\xc5\x84ski'],
 ['PL', '74', 'Powiat \xc5\x82\xc3\xb3dzki wschodni'],
 ['PL', '74', 'Powiat opoczy\xc5\x84ski'],
 ['PL', '74', 'Powiat pabianicki'],
 ['PL', '74', 'Powiat paj\xc4\x99cza\xc5\x84ski'],
 ['PL', '74', 'Powiat skierniewicki'],
 ['PL', '74', 'Powiat tomaszowski'],
 ['PL', '74', 'Powiat wielu\xc5\x84ski'],
 ['PL', '74', 'Powiat wieruszowski'],
 ['PL', '74', 'Powiat zdu\xc5\x84skowolski'],
 ['PL', '74', 'Powiat zgierski'],
 ['PL', '78', 'Powiat warszawski zachodni'],
 ['PL', '76', 'Powiat kro\xc5\x9bnie\xc5\x84ski'],
 ['PL', '78', 'Powiat garwoli\xc5\x84ski'],
 ['PL', '83', 'Powiat bielski'],
 ['PL', '83', 'Powiat pszczy\xc5\x84ski'],
 ['PL', '83', 'Powiat bieru\xc5\x84sko-l\xc4\x99dzi\xc5\x84ski'],
 ['PL', '83', 'Powiat zawiercia\xc5\x84ski'],
 ['PL', '83', 'Powiat \xc5\xbcywiecki'],
 ['PL', '84', 'Powiat buski'],
 ['PL', '84', 'Powiat j\xc4\x99drzejowski'],
 ['PL', '84', 'Powiat kazimierski'],
 ['PL', '84', 'Powiat pi\xc5\x84czowski'],
 ['PL', '84', 'Powiat staszowski'],
 ['PL', '81', 'Powiat wysokomazowiecki'],
 ['PL', '86', 'Powiat ostrowski'],
 ['PL', '86', 'Powiat ostrzeszowski'],
 ['PL', '86', 'Powiat rawicki'],
 ['PL', '79', 'Powiat g\xc5\x82ubczycki'],
 ['PL', '79', 'Powiat prudnicki'],
 ['PL', '79', 'Powiat k\xc4\x99dzierzy\xc5\x84sko-kozielski'],
 ['PL', '79', 'Powiat opolski'],
 ['PL', '83', 'Powiat lubliniecki'],
 ['PL', '79', 'Powiat krapkowicki'],
 ['PL', '79', 'Powiat strzelecki'],
 ['PL', '83', 'Powiat tarnog\xc3\xb3rski'],
 ['PL', '83', 'Powiat raciborski'],
 ['PL', '83', 'Powiat gliwicki'],
 ['PL', '80', 'Powiat bieszczadzki'],
 ['PL', '80', 'Powiat brzozowski'],
 ['PL', '80', 'Powiat tarnobrzeski'],
 ['PL', '87', 'Powiat \xc5\x82obeski'],
 ['PL', '81', 'Powiat bia\xc5\x82ostocki'],
 ['PL', '81', 'Powiat bielski'],
 ['PL', '81', 'Powiat grajewski'],
 ['PL', '81', 'Powiat hajnowski'],
 ['PL', '81', 'Powiat moniecki'],
 ['PL', '81', 'Powiat sejne\xc5\x84ski'],
 ['PL', '81', 'Powiat sok\xc3\xb3lski'],
 ['PL', '81', 'Powiat suwalski'],
 ['PL', '82', 'Powiat nowodworski'],
 ['PL', '82', 'Powiat s\xc5\x82upski'],
 ['PL', '82', 'Powiat wejherowski'],
 ['PL', '82', 'Powiat sztumski'],
 ['PL', '85', 'Powiat mr\xc4\x85gowski'],
 ['PL', '86', 'Powiat gosty\xc5\x84ski'],
 ['PL', '86', 'Powiat grodziski'],
 ['PL', '86', 'Powiat jaroci\xc5\x84ski'],
 ['PL', '86', 'Powiat ko\xc5\x9bcia\xc5\x84ski'],
 ['PL', '86', 'Powiat chodzieski'],
 ['PL', '86', 'Powiat \xc5\x9bredzki'],
 ['PL', '86', 'Powiat \xc5\x9bremski'],
 ['PL', '86', 'Powiat gnie\xc5\xbanie\xc5\x84ski'],
 ['PL', '86', 'Powiat kolski'],
 ['PL', '85', 'Elbl\xc4\x85g'],
 ['PR', '005', 'Ceiba Baja Barrio'],
 ['PR', '041', 'Ceiba Barrio'],
 ['PR', '085', 'Ceiba Barrio'],
 ['PR', '145', 'Ceiba Barrio'],
 ['PR', '077', 'Ceiba Norte Barrio'],
 ['PR', '077', 'Ceiba Sur Barrio'],
 ['PR', '045', 'Cejas Barrio'],
 ['PR', '063', 'Celada Barrio'],
 ['PR', '099', 'Centro Barrio'],
 ['PR', '035', 'Cercadillo Barrio'],
 ['PR', '113', 'Cerrillos Barrio'],
 ['PR', '003', 'Cerro Gordo Barrio'],
 ['PR', '011', 'Cerro Gordo Barrio'],
 ['PR', '021', 'Cerro Gordo Barrio'],
 ['PR', '099', 'Cerro Gordo Barrio'],
 ['PR', '129', 'Cerro Gordo Barrio'],
 ['PR', '083', 'Cerrote Barrio'],
 ['PR', '083', 'Chamorro Barrio'],
 ['PR', '115', 'Charcas Barrio'],
 ['PR', '037', 'Chupacallos Barrio'],
 ['PR', '039', 'Cialitos Barrio'],
 ['PR', '027', 'Cibao Barrio'],
 ['PR', '131', 'Cibao Barrio'],
 ['PR', '047', 'Cibuco Barrio'],
 ['PR', '145', 'Cibuco Barrio'],
 ['PR', '011', 'Cidra Barrio'],
 ['PR', '131', 'Cidral Barrio'],
 ['PR', '119', 'Ci\xc3\xa9naga Alta Barrio'],
 ['PR', '119', 'Ci\xc3\xa9naga Baja Barrio'],
 ['PR', '055', 'Ci\xc3\xa9naga Barrio'],
 ['PR', '027', 'Ci\xc3\xa9nagas Barrio'],
 ['PR', '143', 'Cienegueta Barrio'],
 ['PR', '075', 'Cintrona Barrio'],
 ['PR', '073', 'Coabey Barrio'],
 ['PR', '043', 'Coamo Arriba Barrio'],
 ['PR', '115', 'Cocos Barrio'],
 ['PR', '069', 'Collores Barrio'],
 ['PR', '073', 'Collores Barrio'],
 ['PR', '075', 'Collores Barrio'],
 ['PR', '085', 'Collores Barrio'],
 ['PR', '107', 'Collores Barrio'],
 ['PR', '153', 'Collores Barrio'],
 ['PR', '059', 'Consejo Barrio'],
 ['PR', '141', 'Consejo Barrio'],
 ['PR', '135', 'Contorno Barrio'],
 ['PR', '011', 'Corcovada Barrio'],
 ['PR', '065', 'Corcovado Barrio'],
 ['PR', '039', 'Cordillera Barrio'],
 ['PR', '005', 'Corrales Barrio'],
 ['PR', '079', 'Costa Barrio'],
 ['PR', '071', 'Coto Barrio'],
 ['PR', '111', 'Coto Barrio'],
 ['PR', '113', 'Coto Laurel Barrio'],
 ['PR', '091', 'Coto Norte Barrio'],
 ['PR', '091', 'Coto Sur Barrio'],
 ['PR', '125', 'Cotu\xc3\xad Barrio'],
 ['PR', '003', 'Cruces Barrio'],
 ['PR', '117', 'Cruces Barrio'],
 ['PR', '099', 'Cruz Barrio'],
 ['PR', '113', 'Cuarto Barrio'],
 ['PR', '029', 'Cubuy Barrio'],
 ['PR', '047', 'Cuchillas Barrio'],
 ['PR', '099', 'Cuchillas Barrio'],
 ['PR', '101', 'Cuchillas Barrio'],
 ['PR', '111', 'Cuebas Barrio'],
 ['PR', '139', 'Cuevas Barrio'],
 ['PR', '035', 'Culebras Alto Barrio'],
 ['PR', '035', 'Culebras Bajo Barrio'],
 ['PR', '131', 'Culebrinas Barrio'],
 ['PR', '127', 'Cupey Barrio'],
 ['PR', '009', 'Cuy\xc3\xb3n Barrio'],
 ['PR', '043', 'Cuy\xc3\xb3n Barrio'],
 ['PR', '037', 'Daguao Barrio'],
 ['PR', '103', 'Daguao Barrio'],
 ['PR', '011', 'Dag\xc3\xbcey Barrio'],
 ['PR', '021', 'Dajaos Barrio'],
 ['PR', '107', 'Dami\xc3\xa1n Abajo Barrio'],
 ['PR', '107', 'Dami\xc3\xa1n Arriba Barrio'],
 ['PR', '053', 'Demajagua Barrio'],
 ['PR', '133', 'Descalabrado Barrio'],
 ['PR', '153', 'Diego Hern\xc3\xa1ndez Barrio'],
 ['PR', '013', 'Domingo Ru\xc3\xadz Barrio'],
 ['PR', '013', 'Dominguito Barrio'],
 ['PR', '141', 'Don Alonso Barrio'],
 ['PR', '045', 'Do\xc3\xb1a Elena Barrio'],
 ['PR', '047', 'Dos Bocas Barrio'],
 ['PR', '139', 'Dos Bocas Barrio'],
 ['PR', '125', 'Duey Alto Barrio'],
 ['PR', '125', 'Duey Bajo Barrio'],
 ['PR', '153', 'Duey Barrio'],
 ['PR', '103', 'Duque Barrio'],
 ['PR', '109', 'Egozcue Barrio'],
 ['PR', '127', 'El Cinco Barrio'],
 ['PR', '027', 'Abra Honda Barrio'],
 ['PR', '047', 'Abras Barrio'],
 ['PR', '099', 'Aceitunas Barrio'],
 ['PR', '105', 'Achiote Barrio'],
 ['PR', '001', 'Adjuntas Pueblo Barrio'],
 ['PR', '005', 'Aguacate Barrio'],
 ['PR', '151', 'Aguacate Barrio'],
 ['PR', '003', 'Aguada Barrio-Pueblo'],
 ['PR', '005', 'Aguadilla Barrio-Pueblo'],
 ['PR', '153', 'Aguas Blancas Barrio'],
 ['PR', '123', 'Aguirre Barrio'],
 ['PR', '065', 'Aibonito Barrio'],
 ['PR', '131', 'Aibonito Barrio'],
 ['PR', '107', 'Ala de la Piedra Barrio'],
 ['PR', '009', 'Algarrobo Barrio'],
 ['PR', '057', 'Algarrobo Barrio'],
 ['PR', '145', 'Algarrobo Barrio'],
 ['PR', '153', 'Algarrobo Barrio'],
 ['PR', '097', 'Algarrobos Barrio'],
 ['PR', '153', 'Alm\xc3\xa1cigo Alto Barrio'],
 ['PR', '153', 'Alm\xc3\xa1cigo Bajo Barrio'],
 ['PR', '145', 'Almirante Norte Barrio'],
 ['PR', '145', 'Almirante Sur Barrio'],
 ['PR', '083', 'Alto Sano Barrio'],
 ['PR', '131', 'Alto Sano Barrio'],
 ['PR', '075', 'Amuelas Barrio'],
 ['PR', '011', 'A\xc3\xb1asco Abajo Barrio'],
 ['PR', '011', 'A\xc3\xb1asco Arriba Barrio'],
 ['PR', '015', 'Ancones Barrio'],
 ['PR', '125', 'Ancones Barrio'],
 ['PR', '141', 'Angeles Barrio'],
 ['PR', '113', 'An\xc3\xb3n Barrio'],
 ['PR', '083', 'Anones Barrio'],
 ['PR', '105', 'Anones Barrio'],
 ['PR', '069', 'Ant\xc3\xb3n Ru\xc3\xadz Barrio'],
 ['PR', '109', 'Apeadero Barrio'],
 ['PR', '055', 'Arena Barrio'],
 ['PR', '013', 'Arenalejos Barrio'],
 ['PR', '071', 'Arenales Altos Barrio'],
 ['PR', '071', 'Arenales Bajos Barrio'],
 ['PR', '005', 'Arenales Barrio'],
 ['PR', '041', 'Arenas Barrio'],
 ['PR', '141', 'Arenas Barrio'],
 ['PR', '013', 'Arrozal Barrio'],
 ['PR', '003', 'Asomante Barrio'],
 ['PR', '009', 'Asomante Barrio'],
 ['PR', '003', 'Atalaya Barrio'],
 ['PR', '117', 'Atalaya Barrio'],
 ['PR', '131', 'Bahomamey Barrio'],
 ['PR', '007', 'Bairoa Barrio'],
 ['PR', '025', 'Bairoa Barrio'],
 ['PR', '109', 'Bajo Barrio'],
 ['PR', '091', 'Bajura Adentro Barrio'],
 ['PR', '091', 'Bajura Afuera Barrio'],
 ['PR', '023', 'Bajura Barrio'],
 ['PR', '071', 'Bajura Barrio'],
 ['PR', '143', 'Bajura Barrio'],
 ['PR', '101', 'Barahona Barrio'],
 ['PR', '153', 'Barina Barrio'],
 ['PR', '019', 'Barrancas Barrio'],
 ['PR', '031', 'Barrazas Barrio'],
 ['PR', '111', 'Barreal Barrio'],
 ['PR', '059', 'Barrero Barrio'],
 ['PR', '117', 'Barrero Barrio'],
 ['PR', '107', 'Barros Barrio'],
 ['PR', '081', 'Bartolo Barrio'],
 ['PR', '097', 'Bateyes Barrio'],
 ['PR', '107', 'Bauta Abajo Barrio'],
 ['PR', '107', 'Bauta Arriba Barrio'],
 ['PR', '041', 'Bayam\xc3\xb3n Barrio'],
 ['PR', '007', 'Bayamoncito Barrio'],
 ['PR', '065', 'Bayaney Barrio'],
 ['PR', '025', 'Beatriz Barrio'],
 ['PR', '035', 'Beatriz Barrio'],
 ['PR', '041', 'Beatriz Barrio'],
 ['PR', '071', 'Bejucos Barrio'],
 ['PR', '067', 'Benavente Barrio'],
 ['PR', '107', 'Bermejales Barrio'],
 ['PR', '059', 'Boca Barrio'],
 ['PR', '133', 'Boca Vel\xc3\xa1zquez Barrio'],
 ['PR', '023', 'Boquer\xc3\xb3n Barrio'],
 ['PR', '085', 'Boquer\xc3\xb3n Barrio'],
 ['PR', '005', 'Borinquen Barrio'],
 ['PR', '025', 'Borinquen Barrio'],
 ['PR', '107', 'Botijas Barrio'],
 ['PR', '113', 'Bucan\xc3\xa1 Barrio'],
 ['PR', '083', 'Bucarabones Barrio'],
 ['PR', '093', 'Bucarabones Barrio'],
 ['PR', '021', 'Buena Vista Barrio'],
 ['PR', '065', 'Buena Vista Barrio'],
 ['PR', '069', 'Buena Vista Barrio'],
 ['PR', '083', 'Buena Vista Barrio'],
 ['PR', '081', 'Buenos Aires Barrio'],
 ['PR', '053', 'Cabezas Barrio'],
 ['PR', '145', 'Cabo Caribe Barrio'],
 ['PR', '109', 'Cacao Alto Barrio'],
 ['PR', '109', 'Cacao Bajo Barrio'],
 ['PR', '031', 'Cacao Barrio'],
 ['PR', '115', 'Cacao Barrio'],
 ['PR', '107', 'Cacaos Barrio'],
 ['PR', '011', 'Caguabo Barrio'],
 ['PR', '141', 'Caguana Barrio'],
 ['PR', '007', 'Cag\xc3\xbcitas Barrio'],
 ['PR', '005', 'Caimital Alto Barrio'],
 ['PR', '005', 'Caimital Bajo Barrio'],
 ['PR', '057', 'Caimital Barrio'],
 ['PR', '077', 'Caimito Barrio'],
 ['PR', '127', 'Caimito Barrio'],
 ['PR', '153', 'Caimito Barrio'],
 ['PR', '125', 'Ca\xc3\xadn Alto Barrio'],
 ['PR', '125', 'Ca\xc3\xadn Bajo Barrio'],
 ['PR', '131', 'Calabazas Barrio'],
 ['PR', '151', 'Calabazas Barrio'],
 ['PR', '075', 'Callabo Barrio'],
 ['PR', '081', 'Callejones Barrio'],
 ['PR', '117', 'Calvache Barrio'],
 ['PR', '095', 'Calzada Barrio'],
 ['PR', '005', 'Camaceyes Barrio'],
 ['PR', '061', 'Camarones Barrio'],
 ['PR', '013', 'Cambalache Barrio'],
 ['PR', '151', 'Camino Nuevo Barrio'],
 ['PR', '065', 'Campo Alegre Barrio'],
 ['PR', '027', 'Camuy Arriba Barrio'],
 ['PR', '019', 'Ca\xc3\xb1ab\xc3\xb3n Barrio'],
 ['PR', '025', 'Ca\xc3\xb1ab\xc3\xb3n Barrio'],
 ['PR', '025', 'Ca\xc3\xb1aboncito Barrio'],
 ['PR', '113', 'Canas Barrio'],
 ['PR', '113', 'Canas Urbano Barrio'],
 ['PR', '079', 'Candelaria Barrio'],
 ['PR', '137', 'Candelaria Barrio'],
 ['PR', '143', 'Candelaria Barrio'],
 ['PR', '069', 'Candelero Abajo Barrio'],
 ['PR', '069', 'Candelero Arriba Barrio'],
 ['PR', '031', 'Cangrejo Arriba Barrio'],
 ['PR', '141', 'Can\xc3\xadaco Barrio'],
 ['PR', '055', 'Ca\xc3\xb1o Barrio'],
 ['PR', '029', 'Can\xc3\xb3vanas Barrio'],
 ['PR', '087', 'Can\xc3\xb3vanas Barrio'],
 ['PR', '031', 'Canovanillas Barrio'],
 ['PR', '141', 'Caonillas Abajo Barrio'],
 ['PR', '149', 'Caonillas Abajo Barrio'],
 ['PR', '141', 'Caonillas Arriba Barrio'],
 ['PR', '149', 'Caonillas Arriba Barrio'],
 ['PR', '009', 'Caonillas Barrio'],
 ['PR', '099', 'Cap\xc3\xa1 Barrio'],
 ['PR', '001', 'Cap\xc3\xa1ez Barrio'],
 ['PR', '065', 'Cap\xc3\xa1ez Barrio'],
 ['PR', '075', 'Capitanejo Barrio'],
 ['PR', '113', 'Capitanejo Barrio'],
 ['PR', '011', 'Caracol Barrio'],
 ['PR', '055', 'Carenero Barrio'],
 ['PR', '057', 'Carite Barrio'],
 ['PR', '057', 'Carmen Barrio'],
 ['PR', '139', 'Carra\xc3\xadzo Barrio'],
 ['PR', '011', 'Carreras Barrio'],
 ['PR', '013', 'Carreras Barrio'],
 ['PR', '003', 'Carrizal Barrio'],
 ['PR', '065', 'Carrizales Barrio'],
 ['PR', '031', 'Carruzos Barrio'],
 ['PR', '011', 'Casey Abajo Barrio'],
 ['PR', '011', 'Casey Arriba Barrio'],
 ['PR', '069', 'Cata\xc3\xb1o Barrio'],
 ['PR', '129', 'Cayaguas Barrio'],
 ['PR', '045', 'Cedrito Barrio'],
 ['PR', '105', 'Cedro Abajo Barrio'],
 ['PR', '105', 'Cedro Arriba Barrio'],
 ['PR', '031', 'Cedro Barrio'],
 ['PR', '035', 'Cedro Barrio'],
 ['PR', '059', 'Cedro Barrio'],
 ['PR', '005', 'Ceiba Alta Barrio'],
 ['PR', '085', 'El R\xc3\xado Barrio'],
 ['PR', '095', 'Emajagua Barrio'],
 ['PR', '075', 'Emajagual Barrio'],
 ['PR', '111', 'Encarnaci\xc3\xb3n Barrio'],
 ['PR', '131', 'Eneas Barrio'],
 ['PR', '055', 'Ensenada Barrio'],
 ['PR', '117', 'Ensenada Barrio'],
 ['PR', '013', 'Esperanza Barrio'],
 ['PR', '003', 'Espinar Barrio'],
 ['PR', '011', 'Espino Barrio'],
 ['PR', '081', 'Espino Barrio'],
 ['PR', '083', 'Espino Barrio'],
 ['PR', '129', 'Espino Barrio'],
 ['PR', '051', 'Espinosa Barrio'],
 ['PR', '143', 'Espinosa Barrio'],
 ['PR', '013', 'Factor Barrio'],
 ['PR', '035', 'Farall\xc3\xb3n Barrio'],
 ['PR', '133', 'Felicia 1 Barrio'],
 ['PR', '133', 'Felicia 2 Barrio'],
 ['PR', '049', 'Flamenco Barrio'],
 ['PR', '053', 'Florencio Barrio'],
 ['PR', '054', 'Florida Adentro Barrio'],
 ['PR', '017', 'Florida Afuera Barrio'],
 ['PR', '129', 'Florida Barrio'],
 ['PR', '147', 'Florida Barrio'],
 ['PR', '049', 'Fraile Barrio'],
 ['PR', '061', 'Frailes Barrio'],
 ['PR', '153', 'Frailes Barrio'],
 ['PR', '101', 'Fr\xc3\xa1nquez Barrio'],
 ['PR', '039', 'Front\xc3\xb3n Barrio'],
 ['PR', '083', 'Furnias Barrio'],
 ['PR', '071', 'Galateo Alto Barrio'],
 ['PR', '071', 'Galateo Bajo Barrio'],
 ['PR', '135', 'Galateo Barrio'],
 ['PR', '013', 'Garrochales Barrio'],
 ['PR', '017', 'Garrochales Barrio'],
 ['PR', '001', 'Garzas Barrio'],
 ['PR', '107', 'Gato Barrio'],
 ['PR', '127', 'Gobernador Pi\xc3\xb1ero Barrio'],
 ['PR', '131', 'Guacio Barrio'],
 ['PR', '105', 'Guadiana Barrio'],
 ['PR', '115', 'Guajataca Barrio'],
 ['PR', '131', 'Guajataca Barrio'],
 ['PR', '125', 'Guam\xc3\xa1 Barrio'],
 ['PR', '057', 'Guaman\xc3\xad Barrio'],
 ['PR', '003', 'Guan\xc3\xa1bano Barrio'],
 ['PR', '023', 'Guanajibo Barrio'],
 ['PR', '067', 'Guanajibo Barrio'],
 ['PR', '097', 'Guanajibo Barrio'],
 ['PR', '003', 'Guaniquilla Barrio'],
 ['PR', '141', 'Guaonico Barrio'],
 ['PR', '021', 'Guaraguao Abajo Barrio'],
 ['PR', '021', 'Guaraguao Arriba Barrio'],
 ['PR', '061', 'Guaraguao Barrio'],
 ['PR', '113', 'Guaraguao Barrio'],
 ['PR', '109', 'Guardarraya Barrio'],
 ['PR', '015', 'Gu\xc3\xa1simas Barrio'],
 ['PR', '131', 'Guatemala Barrio'],
 ['PR', '035', 'Guavate Barrio'],
 ['PR', '075', 'Guayabal Barrio'],
 ['PR', '003', 'Guayabo Barrio'],
 ['PR', '001', 'Guayabo Dulce Barrio'],
 ['PR', '071', 'Guayabos Barrio'],
 ['PR', '151', 'Guayabota Barrio'],
 ['PR', '037', 'Guayac\xc3\xa1n Barrio'],
 ['PR', '001', 'Guayo Barrio'],
 ['PR', '005', 'Guerrero Barrio'],
 ['PR', '071', 'Guerrero Barrio'],
 ['PR', '001', 'Guilarte Barrio'],
 ['PR', '077', 'Gurabo Abajo Barrio'],
 ['PR', '077', 'Gurabo Arriba Barrio'],
 ['PR', '119', 'Guzm\xc3\xa1n Abajo Barrio'],
 ['PR', '119', 'Guzm\xc3\xa1n Arriba Barrio'],
 ['PR', '011', 'Hatillo Barrio'],
 ['PR', '065', 'Hatillo Barrio'],
 ['PR', '013', 'Hato Abajo Barrio'],
 ['PR', '013', 'Hato Arriba Barrio'],
 ['PR', '131', 'Hato Arriba Barrio'],
 ['PR', '129', 'Hato Barrio'],
 ['PR', '061', 'Hato Nuevo Barrio'],
 ['PR', '063', 'Hato Nuevo Barrio'],
 ['PR', '149', 'Hato Puerco Abajo Barrio'],
 ['PR', '149', 'Hato Puerco Arriba Barrio'],
 ['PR', '029', 'Hato Puerco Barrio'],
 ['PR', '127', 'Hato Rey Central Barrio'],
 ['PR', '127', 'Hato Rey Norte Barrio'],
 ['PR', '127', 'Hato Rey Sur Barrio'],
 ['PR', '021', 'Hato Tejas Barrio'],
 ['PR', '013', 'Hato Viejo Barrio'],
 ['PR', '039', 'Hato Viejo Barrio'],
 ['PR', '043', 'Hayales Barrio'],
 ['PR', '019', 'Helechal Barrio'],
 ['PR', '119', 'Herreras Barrio'],
 ['PR', '051', 'Higuillar Barrio'],
 ['PR', '125', 'Hoconuco Alto Barrio'],
 ['PR', '125', 'Hoconuco Bajo Barrio'],
 ['PR', '019', 'Honduras Barrio'],
 ['PR', '041', 'Honduras Barrio'],
 ['PR', '067', 'Hormigueros Barrio'],
 ['PR', '131', 'Hoya Mala Barrio'],
 ['PR', '103', 'H\xc3\xbacares Barrio'],
 ['PR', '011', 'Humatas Barrio'],
 ['PR', '093', 'Indiera Alta Barrio'],
 ['PR', '093', 'Indiera Baja Barrio'],
 ['PR', '093', 'Indiera Fr\xc3\xada Barrio'],
 ['PR', '059', 'Indios Barrio'],
 ['PR', '097', 'Isla de Mona e Islote Monito Barrio'],
 ['PR', '013', 'Islote Barrio'],
 ['PR', '109', 'Jacaboa Barrio'],
 ['PR', '075', 'Jacaguas Barrio'],
 ['PR', '153', 'J\xc3\xa1cana Barrio'],
 ['PR', '151', 'J\xc3\xa1canas Barrio'],
 ['PR', '059', 'Jagua Pasto Barrio'],
 ['PR', '109', 'Jagual Barrio'],
 ['PR', '129', 'Jagual Barrio'],
 ['PR', '063', 'Jaguar Barrio'],
 ['PR', '039', 'Jaguas Barrio'],
 ['PR', '059', 'Jaguas Barrio'],
 ['PR', '063', 'Jaguas Barrio'],
 ['PR', '111', 'Jaguas Barrio'],
 ['PR', '003', 'Jag\xc3\xbcey Barrio'],
 ['PR', '117', 'Jag\xc3\xbcey Barrio'],
 ['PR', '007', 'Jag\xc3\xbceyes Barrio'],
 ['PR', '067', 'Jaguitas Barrio'],
 ['PR', '035', 'J\xc3\xa1jome Alto Barrio'],
 ['PR', '035', 'J\xc3\xa1jome Bajo Barrio'],
 ['PR', '133', 'Jauca 1 Barrio'],
 ['PR', '133', 'Jauca 2 Barrio'],
 ['PR', '073', 'Jauca Barrio'],
 ['PR', '073', 'Jayuya Abajo Barrio'],
 ['PR', '119', 'Jim\xc3\xa9nez Barrio'],
 ['PR', '057', 'Jobos Barrio'],
 ['PR', '071', 'Jobos Barrio'],
 ['PR', '097', 'Juan Alonso Barrio'],
 ['PR', '007', 'Juan Asencio Barrio'],
 ['PR', '001', 'Juan Gonz\xc3\xa1lez Barrio'],
 ['PR', '089', 'Juan Mart\xc3\xadn Barrio'],
 ['PR', '151', 'Juan Mart\xc3\xadn Barrio'],
 ['PR', '021', 'Juan S\xc3\xa1nchez Barrio'],
 ['PR', '131', 'Juncal Barrio'],
 ['PR', '139', 'La Gloria Barrio'],
 ['PR', '081', 'La Torre Barrio'],
 ['PR', '003', 'Lagunas Barrio'],
 ['PR', '079', 'Lajas Arriba Barrio'],
 ['PR', '079', 'Lajas Barrio'],
 ['PR', '035', 'Lapa Barrio'],
 ['PR', '123', 'Lapa Barrio'],
 ['PR', '081', 'Lares Barrio'],
 ['PR', '141', 'Las Palmas Barrio'],
 ['PR', '067', 'Lavadero Barrio'],
 ['PR', '097', 'Legu\xc3\xadsamo Barrio'],
 ['PR', '001', 'Liman\xc3\xad Barrio'],
 ['PR', '097', 'Lim\xc3\xb3n Barrio'],
 ['PR', '141', 'Lim\xc3\xb3n Barrio'],
 ['PR', '151', 'Limones Barrio'],
 ['PR', '077', 'Lirios Barrio'],
 ['PR', '095', 'Lizas Barrio'],
 ['PR', '071', 'Llanadas Barrio'],
 ['PR', '059', 'Llano Barrio'],
 ['PR', '009', 'Llanos Barrio'],
 ['PR', '079', 'Llanos Barrio'],
 ['PR', '023', 'Llanos Costa Barrio'],
 ['PR', '023', 'Llanos Tuna Barrio'],
 ['PR', '147', 'Llave Barrio'],
 ['PR', '029', 'Lomas Barrio'],
 ['PR', '075', 'Lomas Barrio'],
 ['PR', '105', 'Lomas Barrio'],
 ['PR', '043', 'Los Llanos Barrio'],
 ['PR', '069', 'Mab\xc3\xba Barrio'],
 ['PR', '059', 'Macan\xc3\xa1 Barrio'],
 ['PR', '111', 'Macan\xc3\xa1 Barrio'],
 ['PR', '057', 'Machete Barrio'],
 ['PR', '037', 'Machos Barrio'],
 ['PR', '121', 'Machuchal Barrio'],
 ['PR', '113', 'Machuelo Abajo Barrio'],
 ['PR', '113', 'Machuelo Arriba Barrio'],
 ['PR', '059', 'Magas Barrio'],
 ['PR', '131', 'Magos Barrio'],
 ['PR', '051', 'Maguayo Barrio'],
 ['PR', '047', 'Magueyes Barrio'],
 ['PR', '113', 'Magueyes Barrio'],
 ['PR', '113', 'Magueyes Urbano Barrio'],
 ['PR', '103', 'Maizales Barrio'],
 ['PR', '003', 'Mal Paso Barrio'],
 ['PR', '005', 'Maleza Alta Barrio'],
 ['PR', '005', 'Maleza Baja Barrio'],
 ['PR', '097', 'Malezas Barrio'],
 ['PR', '069', 'Mambiche Barrio'],
 ['PR', '003', 'Mamey Barrio'],
 ['PR', '061', 'Mamey Barrio'],
 ['PR', '063', 'Mamey Barrio'],
 ['PR', '077', 'Mamey Barrio'],
 ['PR', '109', 'Mamey Barrio'],
 ['PR', '051', 'Mameyal Barrio'],
 ['PR', '141', 'Mameyes Abajo Barrio'],
 ['PR', '073', 'Mameyes Arriba Barrio'],
 ['PR', '089', 'Mameyes I Barrio'],
 ['PR', '119', 'Mameyes II Barrio'],
 ['PR', '047', 'Man\xc3\xa1 Barrio'],
 ['PR', '113', 'Marag\xc3\xbcez Barrio'],
 ['PR', '083', 'Maravilla Este Barrio'],
 ['PR', '083', 'Maravilla Norte Barrio'],
 ['PR', '083', 'Maravilla Sur Barrio'],
 ['PR', '125', 'Mares\xc3\xbaa Barrio'],
 ['PR', '069', 'Mariana Barrio'],
 ['PR', '103', 'Mariana Barrio'],
 ['PR', '003', 'Mar\xc3\xadas Barrio'],
 ['PR', '011', 'Mar\xc3\xadas Barrio'],
 ['PR', '099', 'Mar\xc3\xadas Barrio'],
 ['PR', '093', 'Maricao Afuera Barrio'],
 ['PR', '143', 'Maricao Barrio'],
 ['PR', '109', 'Mar\xc3\xadn Barrio'],
 ['PR', '031', 'Mart\xc3\xadn Gonz\xc3\xa1lez Barrio'],
 ['PR', '113', 'Marue\xc3\xb1o Barrio'],
 ['PR', '063', 'Masa Barrio'],
 ['PR', '107', 'Mata de Ca\xc3\xb1as Barrio'],
 ['PR', '089', 'Mata de Pl\xc3\xa1tano Barrio'],
 ['PR', '035', 'Mat\xc3\xb3n Abajo Barrio'],
 ['PR', '035', 'Mat\xc3\xb3n Arriba Barrio'],
 ['PR', '095', 'Matuyas Alto Barrio'],
 ['PR', '095', 'Matuyas Bajo Barrio'],
 ['PR', '143', 'Mavilla Barrio'],
 ['PR', '097', 'Mayag\xc3\xbcez Arriba Barrio'],
 ['PR', '137', 'Media Luna Barrio'],
 ['PR', '087', 'Median\xc3\xada Alta Barrio'],
 ['PR', '087', 'Median\xc3\xada Baja Barrio'],
 ['PR', '027', 'Membrillo Barrio'],
 ['PR', '021', 'Minillas Barrio'],
 ['PR', '125', 'Minillas Barrio'],
 ['PR', '131', 'Mirabales Barrio'],
 ['PR', '023', 'Miradero Barrio'],
 ['PR', '097', 'Miradero Barrio'],
 ['PR', '011', 'Miraflores Barrio'],
 ['PR', '013', 'Miraflores Barrio'],
 ['PR', '081', 'Mirasol Barrio'],
 ['PR', '127', 'Monacillo Barrio'],
 ['PR', '127', 'Monacillo Urbano Barrio'],
 ['PR', '055', 'Montalva Barrio'],
 ['PR', '005', 'Monta\xc3\xb1a Barrio'],
 ['PR', '023', 'Monte Grande Barrio'],
 ['PR', '035', 'Monte Llano Barrio'],
 ['PR', '041', 'Monte Llano Barrio'],
 ['PR', '101', 'Monte Llano Barrio'],
 ['PR', '113', 'Monte Llano Barrio'],
 ['PR', '085', 'Montones Barrio'],
 ['PR', '093', 'Montoso Barrio'],
 ['PR', '097', 'Montoso Barrio'],
 ['PR', '071', 'Mora Barrio'],
 ['PR', '101', 'Morovis Norte Barrio'],
 ['PR', '101', 'Morovis Sud Barrio'],
 ['PR', '147', 'Mosquito Barrio'],
 ['PR', '135', 'Mucarabones Barrio'],
 ['PR', '007', 'Mula Barrio'],
 ['PR', '109', 'Mulas Barrio'],
 ['PR', '007', 'Mulita Barrio'],
 ['PR', '109', 'Mu\xc3\xb1oz Rivera Barrio'],
 ['PR', '083', 'Naranjales Barrio'],
 ['PR', '097', 'Naranjales Barrio'],
 ['PR', '065', 'Naranjito Barrio'],
 ['PR', '003', 'Naranjo Barrio'],
 ['PR', '045', 'Naranjo Barrio'],
 ['PR', '053', 'Naranjo Barrio'],
 ['PR', '099', 'Naranjo Barrio'],
 ['PR', '153', 'Naranjo Barrio'],
 ['PR', '063', 'Navarro Barrio'],
 ['PR', '047', 'Negros Barrio'],
 ['PR', '021', 'Nuevo Barrio'],
 ['PR', '105', 'Nuevo Barrio'],
 ['PR', '127', 'Oriente Barrio'],
 ['PR', '107', 'Orocovis Barrio'],
 ['PR', '135', 'Ort\xc3\xadz Barrio'],
 ['PR', '011', 'Ovejas Barrio'],
 ['PR', '047', 'Padilla Barrio'],
 ['PR', '021', 'P\xc3\xa1jaros Barrio'],
 ['PR', '083', 'Palma Escrita Barrio'],
 ['PR', '005', 'Palmar Barrio'],
 ['PR', '043', 'Palmarejo Barrio'],
 ['PR', '047', 'Palmarejo Barrio'],
 ['PR', '079', 'Palmarejo Barrio'],
 ['PR', '047', 'Palmarito Barrio'],
 ['PR', '017', 'Palmas Altas Barrio'],
 ['PR', '015', 'Palmas Barrio'],
 ['PR', '033', 'Palmas Barrio'],
 ['PR', '057', 'Palmas Barrio'],
 ['PR', '123', 'Palmas Barrio'],
 ['PR', '019', 'Palo Hincado Barrio'],
 ['PR', '095', 'Palo Seco Barrio'],
 ['PR', '137', 'Palo Seco Barrio'],
 ['PR', '045', 'Palomas Barrio'],
 ['PR', '047', 'Palos Blancos Barrio'],
 ['PR', '079', 'Parguera Barrio'],
 ['PR', '079', 'Par\xc3\xads Barrio'],
 ['PR', '141', 'Paso Palma Barrio'],
 ['PR', '009', 'Pasto Barrio'],
 ['PR', '043', 'Pasto Barrio'],
 ['PR', '059', 'Pasto Barrio'],
 ['PR', '101', 'Pasto Barrio'],
 ['PR', '035', 'Pasto Viejo Barrio'],
 ['PR', '023', 'Pedernales Barrio'],
 ['PR', '035', 'Pedro Avila Barrio'],
 ['PR', '043', 'Pedro Garc\xc3\xada Barrio'],
 ['PR', '001', 'Pellejas Barrio'],
 ['PR', '107', 'Pellejas Barrio'],
 ['PR', '103', 'Pe\xc3\xb1a Pobre Barrio'],
 ['PR', '131', 'Perchas 1 Barrio'],
 ['PR', '131', 'Perchas 2 Barrio'],
 ['PR', '101', 'Perchas Barrio'],
 ['PR', '039', 'Pesas Barrio'],
 ['PR', '081', 'Pezuela Barrio'],
 ['PR', '073', 'Pica Barrio'],
 ['PR', '027', 'Piedra Gorda Barrio'],
 ['PR', '035', 'Piedras Barrio'],
 ['PR', '003', 'Piedras Blancas Barrio'],
 ['PR', '131', 'Piedras Blancas Barrio'],
 ['PR', '081', 'Piletas Barrio'],
 ['PR', '011', 'Pi\xc3\xb1ales Barrio'],
 ['PR', '045', 'Pi\xc3\xb1as Barrio'],
 ['PR', '135', 'Pi\xc3\xb1as Barrio'],
 ['PR', '015', 'Pitahaya Barrio'],
 ['PR', '089', 'Pitahaya Barrio'],
 ['PR', '071', 'Planas Barrio'],
 ['PR', '009', 'Plata Barrio'],
 ['PR', '079', 'Plata Barrio'],
 ['PR', '099', 'Plata Barrio'],
 ['PR', '011', 'Playa Barrio'],
 ['PR', '059', 'Playa Barrio'],
 ['PR', '113', 'Playa Barrio'],
 ['PR', '133', 'Playa Barrio'],
 ['PR', '151', 'Playa Barrio'],
 ['PR', '049', 'Playa Sardinas I Barrio'],
 ['PR', '049', 'Playa Sardinas II Barrio'],
 ['PR', '109', 'Pollos Barrio'],
 ['PR', '001', 'Portillo Barrio'],
 ['PR', '001', 'Portugu\xc3\xa9s Barrio'],
 ['PR', '113', 'Portugu\xc3\xa9s Barrio'],
 ['PR', '113', 'Portugu\xc3\xa9s Urbano Barrio'],
 ['PR', '039', 'Pozas Barrio'],
 ['PR', '131', 'Pozas Barrio'],
 ['PR', '057', 'Pozo Hondo Barrio'],
 ['PR', '113', 'Primero Barrio'],
 ['PR', '047', 'Pueblo Barrio'],
 ['PR', '081', 'Pueblo Barrio'],
 ['PR', '099', 'Pueblo Barrio'],
 ['PR', '117', 'Pueblo Barrio'],
 ['PR', '127', 'Pueblo Barrio'],
 ['PR', '061', 'Pueblo Viejo Barrio'],
 ['PR', '027', 'Puente Barrio'],
 ['PR', '147', 'Puerto Diablo Barrio'],
 ['PR', '147', 'Puerto Ferro Barrio'],
 ['PR', '145', 'Puerto Nuevo Barrio'],
 ['PR', '147', 'Puerto Real Barrio'],
 ['PR', '027', 'Puertos Barrio'],
 ['PR', '145', 'Pugnado Adentro Barrio'],
 ['PR', '145', 'Pugnado Afuera Barrio'],
 ['PR', '043', 'Pulguillas Barrio'],
 ['PR', '147', 'Punta Arenas Barrio'],
 ['PR', '069', 'Punta Santiago Barrio'],
 ['PR', '117', 'Puntas Barrio'],
 ['PR', '083', 'Pur\xc3\xadsima Concepci\xc3\xb3n Barrio'],
 ['PR', '085', 'Quebrada Arenas Barrio'],
 ['PR', '095', 'Quebrada Arenas Barrio'],
 ['PR', '127', 'Quebrada Arenas Barrio'],
 ['PR', '129', 'Quebrada Arenas Barrio'],
 ['PR', '135', 'Quebrada Arenas Barrio'],
 ['PR', '145', 'Quebrada Arenas Barrio'],
 ['PR', '035', 'Quebrada Arriba Barrio'],
 ['PR', '109', 'Quebrada Arriba Barrio'],
 ['PR', '027', 'Quebrada Barrio'],
 ['PR', '129', 'Quebrada Barrio'],
 ['PR', '111', 'Quebrada Ceiba Barrio'],
 ['PR', '135', 'Quebrada Cruz Barrio'],
 ['PR', '053', 'Quebrada Fajardo Barrio'],
 ['PR', '019', 'Quebrada Grande Barrio'],
 ['PR', '097', 'Quebrada Grande Barrio'],
 ['PR', '139', 'Quebrada Grande Barrio'],
 ['PR', '059', 'Quebrada Honda Barrio'],
 ['PR', '129', 'Quebrada Honda Barrio'],
 ['PR', '063', 'Quebrada Infierno Barrio'],
 ['PR', '011', 'Quebrada Larga Barrio'],
 ['PR', '113', 'Quebrada Lim\xc3\xb3n Barrio'],
 ['PR', '139', 'Quebrada Negrito Barrio'],
 ['PR', '037', 'Quebrada Seca Barrio'],
 ['PR', '053', 'Quebrada Vueltas Barrio'],
 ['PR', '123', 'Quebrada Yeguas Barrio'],
 ['PR', '059', 'Quebradas Barrio'],
 ['PR', '153', 'Quebradas Barrio'],
 ['PR', '019', 'Quebradillas Barrio'],
 ['PR', '097', 'Quemado Barrio'],
 ['PR', '129', 'Quemados Barrio'],
 ['PR', '113', 'Quinto Barrio'],
 ['PR', '041', 'Rabanal Barrio'],
 ['PR', '153', 'Ranchera Barrio'],
 ['PR', '121', 'Rayo Barrio'],
 ['PR', '113', 'Real Barrio'],
 ['PR', '125', 'Retiro Barrio'],
 ['PR', '035', 'Rinc\xc3\xb3n Barrio'],
 ['PR', '041', 'Rinc\xc3\xb3n Barrio'],
 ['PR', '063', 'Rinc\xc3\xb3n Barrio'],
 ['PR', '121', 'Rinc\xc3\xb3n Barrio'],
 ['PR', '037', 'R\xc3\xado Abajo Barrio'],
 ['PR', '041', 'R\xc3\xado Abajo Barrio'],
 ['PR', '069', 'R\xc3\xado Abajo Barrio'],
 ['PR', '141', 'R\xc3\xado Abajo Barrio'],
 ['PR', '145', 'R\xc3\xado Abajo Barrio'],
 ['PR', '011', 'R\xc3\xado Arriba Barrio'],
 ['PR', '013', 'R\xc3\xado Arriba Barrio'],
 ['PR', '053', 'R\xc3\xado Arriba Barrio'],
 ['PR', '145', 'R\xc3\xado Arriba Barrio'],
 ['PR', '091', 'R\xc3\xado Arriba Poniente Barrio'],
 ['PR', '091', 'R\xc3\xado Arriba Saliente Barrio'],
 ['PR', '061', 'R\xc3\xado Barrio'],
 ['PR', '103', 'R\xc3\xado Barrio'],
 ['PR', '103', 'R\xc3\xado Blanco Barrio'],
 ['PR', '075', 'R\xc3\xado Ca\xc3\xb1as Abajo Barrio'],
 ['PR', '097', 'R\xc3\xado Ca\xc3\xb1as Abajo Barrio'],
 ['PR', '075', 'R\xc3\xado Ca\xc3\xb1as Arriba Barrio'],
 ['PR', '097', 'R\xc3\xado Ca\xc3\xb1as Arriba Barrio'],
 ['PR', '011', 'R\xc3\xado Ca\xc3\xb1as Barrio'],
 ['PR', '025', 'R\xc3\xado Ca\xc3\xb1as Barrio'],
 ['PR', '083', 'R\xc3\xado Ca\xc3\xb1as Barrio'],
 ['PR', '003', 'R\xc3\xado Grande Barrio'],
 ['PR', '073', 'R\xc3\xado Grande Barrio'],
 ['PR', '101', 'R\xc3\xado Grande Barrio'],
 ['PR', '117', 'R\xc3\xado Grande Barrio'],
 ['PR', '045', 'R\xc3\xado Hondo Barrio'],
 ['PR', '097', 'R\xc3\xado Hondo Barrio'],
 ['PR', '123', 'R\xc3\xado Jueyes Barrio'],
 ['PR', '051', 'R\xc3\xado Lajas Barrio'],
 ['PR', '135', 'R\xc3\xado Lajas Barrio'],
 ['PR', '081', 'R\xc3\xado Prieto Barrio'],
 ['PR', '153', 'R\xc3\xado Prieto Barrio'],
 ['PR', '109', 'R\xc3\xados Barrio'],
 ['PR', '009', 'Robles Barrio'],
 ['PR', '131', 'Robles Barrio'],
 ['PR', '099', 'Rocha Barrio'],
 ['PR', '141', 'Roncador Barrio'],
 ['PR', '125', 'Rosario Alto Barrio'],
 ['PR', '125', 'Rosario Bajo Barrio'],
 ['PR', '097', 'Rosario Barrio'],
 ['PR', '125', 'Rosario Pe\xc3\xb1\xc3\xb3n Barrio'],
 ['PR', '153', 'Rubias Barrio'],
 ['PR', '111', 'Rucio Barrio'],
 ['PR', '059', 'Rufina Barrio'],
 ['PR', '097', 'S\xc3\xa1balos Barrio'],
 ['PR', '031', 'Sabana Abajo Barrio'],
 ['PR', '089', 'Sabana Barrio'],
 ['PR', '107', 'Sabana Barrio'],
 ['PR', '143', 'Sabana Barrio'],
 ['PR', '125', 'Sabana Eneas Barrio'],
 ['PR', '125', 'Sabana Grande Abajo Barrio'],
 ['PR', '141', 'Sabana Grande Barrio'],
 ['PR', '013', 'Sabana Hoyos Barrio'],
 ['PR', '075', 'Sabana Llana Barrio'],
 ['PR', '127', 'Sabana Llana Norte Barrio'],
 ['PR', '127', 'Sabana Llana Sur Barrio'],
 ['PR', '137', 'Sabana Seca Barrio'],
 ['PR', '079', 'Sabana Yeguas Barrio'],
 ['PR', '097', 'Sabanetas Barrio'],
 ['PR', '113', 'Sabanetas Barrio'],
 ['PR', '037', 'Saco Barrio'],
 ['PR', '073', 'Saliente Barrio'],
 ['PR', '001', 'Saltillo Barrio'],
 ['PR', '141', 'Salto Abajo Barrio'],
 ['PR', '141', 'Salto Arriba Barrio'],
 ['PR', '041', 'Salto Barrio'],
 ['PR', '131', 'Salto Barrio'],
 ['PR', '107', 'Saltos Barrio'],
 ['PR', '031', 'San Ant\xc3\xb3n Barrio'],
 ['PR', '113', 'San Ant\xc3\xb3n Barrio'],
 ['PR', '025', 'San Antonio Barrio'],
 ['PR', '115', 'San Antonio Barrio'],
 ['PR', '043', 'San Ildefonso Barrio'],
 ['PR', '049', 'San Isidro Barrio'],
 ['PR', '115', 'San Jos\xc3\xa9 Barrio'],
 ['PR', '127', 'San Juan Antiguo Barrio'],
 ['PR', '101', 'San Lorenzo Barrio'],
 ['PR', '113', 'San Patricio Barrio'],
 ['PR', '025', 'San Salvador Barrio'],
 ['PR', '043', 'Santa Catalina Barrio'],
 ['PR', '031', 'Santa Cruz Barrio'],
 ['PR', '141', 'Santa Isabel Barrio'],
 ['PR', '021', 'Santa Olaya Barrio'],
 ['PR', '061', 'Santa Rosa Barrio'],
 ['PR', '079', 'Santa Rosa Barrio'],
 ['PR', '141', 'Santa Rosa Barrio'],
 ['PR', '013', 'Santana Barrio'],
 ['PR', '121', 'Santana Barrio'],
 ['PR', '027', 'Santiago Barrio'],
 ['PR', '103', 'Santiago y Lima Barrio'],
 ['PR', '111', 'Santo Domingo Barrio'],
 ['PR', '127', 'Santurce Barrio'],
 ['PR', '053', 'Sardinera Barrio'],
 ['PR', '113', 'Segundo Barrio'],
 ['PR', '113', 'Sexto Barrio'],
 ['PR', '153', 'Sierra Alta Barrio'],
 ['PR', '059', 'Sierra Baja Barrio'],
 ['PR', '131', 'Sonador Barrio'],
 ['PR', '007', 'Sonadora Barrio'],
 ['PR', '061', 'Sonadora Barrio'],
 ['PR', '139', 'St. Just Barrio'],
 ['PR', '041', 'Sud Barrio'],
 ['PR', '007', 'Sumidero Barrio'],
 ['PR', '035', 'Sumido Barrio'],
 ['PR', '153', 'Sus\xc3\xbaa Alta Barrio'],
 ['PR', '055', 'Sus\xc3\xbaa Baja Barrio'],
 ['PR', '153', 'Sus\xc3\xbaa Baja Barrio'],
 ['PR', '121', 'Sus\xc3\xbaa Barrio'],
 ['PR', '121', 'Tabonuco Barrio'],
 ['PR', '095', 'Talante Barrio'],
 ['PR', '111', 'Tallaboa Alta Barrio'],
 ['PR', '111', 'Tallaboa Poniente Barrio'],
 ['PR', '111', 'Tallaboa Saliente Barrio'],
 ['PR', '001', 'Tanam\xc3\xa1 Barrio'],
 ['PR', '013', 'Tanam\xc3\xa1 Barrio'],
 ['PR', '069', 'Tejas Barrio'],
 ['PR', '085', 'Tejas Barrio'],
 ['PR', '151', 'Tejas Barrio'],
 ['PR', '113', 'Tercero Barrio'],
 ['PR', '115', 'Terranova Barrio'],
 ['PR', '141', 'Tetu\xc3\xa1n Barrio'],
 ['PR', '113', 'Tibes Barrio'],
 ['PR', '091', 'Tierras Nuevas Poniente Barrio'],
 ['PR', '091', 'Tierras Nuevas Saliente Barrio'],
 ['PR', '075', 'Tijeras Barrio'],
 ['PR', '035', 'To\xc3\xadta Barrio'],
 ['PR', '041', 'To\xc3\xadta Barrio'],
 ['PR', '025', 'Tom\xc3\xa1s de Castro Barrio'],
 ['PR', '039', 'Toro Negro Barrio'],
 ['PR', '121', 'Torre Barrio'],
 ['PR', '029', 'Torrecilla Alta Barrio'],
 ['PR', '087', 'Torrecilla Alta Barrio'],
 ['PR', '087', 'Torrecilla Baja Barrio'],
 ['PR', '101', 'Torrecillas Barrio'],
 ['PR', '127', 'Tortugo Barrio'],
 ['PR', '031', 'Trujillo Bajo Barrio'],
 ['PR', '125', 'Tuna Barrio'],
 ['PR', '025', 'Turabo Barrio'],
 ['PR', '101', 'Unib\xc3\xb3n Barrio'],
 ['PR', '127', 'Universidad Barrio'],
 ['PR', '149', 'Vacas Barrio'],
 ['PR', '101', 'Vaga Barrio'],
 ['PR', '077', 'Valenciano Abajo Barrio'],
 ['PR', '077', 'Valenciano Arriba Barrio'],
 ['PR', '113', 'Vayas Barrio'],
 ['PR', '045', 'Vega Redonda Barrio'],
 ['PR', '001', 'Vegas Abajo Barrio'],
 ['PR', '035', 'Vegas Barrio'],
 ['PR', '153', 'Vegas Barrio'],
 ['PR', '073', 'Veguitas Barrio'],
 ['PR', '005', 'Victoria Barrio'],
 ['PR', '149', 'Villalba Abajo Barrio'],
 ['PR', '149', 'Villalba Arriba Barrio'],
 ['PR', '141', 'Viv\xc3\xad Abajo Barrio'],
 ['PR', '141', 'Viv\xc3\xad Arriba Barrio'],
 ['PR', '099', 'Voladoras Barrio'],
 ['PR', '001', 'Yahuecas Barrio'],
 ['PR', '015', 'Yaurel Barrio'],
 ['PR', '001', 'Yayales Barrio'],
 ['PR', '027', 'Yeguada Barrio'],
 ['PR', '145', 'Yeguada Barrio'],
 ['PR', '073', 'Zamas Barrio'],
 ['PR', '027', 'Zanja Barrio'],
 ['PR', '119', 'Zarzal Barrio'],
 ['PR', '095', 'Tumbao Barrio'],
 ['PR', '041', 'Certenejas Barrio'],
 ['PR', '001', 'Vegas Arriba'],
 ['PS', 'GZ', 'Deir Al Balah'],
 ['PS', 'GZ', 'Khan Yunis Governorate'],
 ['PT', '16', 'Crato'],
 ['PT', '22', 'Tondela'],
 ['PT', '11', 'Gouveia'],
 ['PT', '06', 'Fund\xc3\xa3o'],
 ['PT', '14', 'Lisbon'],
 ['PT', '17', 'Porto'],
 ['PT', '14', 'Loures'],
 ['PT', '16', 'Nisa'],
 ['PT', '06', 'Vila Velha de R\xc3\xb3d\xc3\xa3o'],
 ['PT', '16', 'Castelo de Vide'],
 ['PT', '16', 'Marv\xc3\xa3o'],
 ['PT', '16', 'Portalegre'],
 ['PT', '16', 'Gavi\xc3\xa3o'],
 ['PT', '16', 'Ponte de Sor'],
 ['PT', '16', 'Alter do Ch\xc3\xa3o'],
 ['PT', '16', 'Monforte'],
 ['PT', '22', 'Carregal do Sal'],
 ['PT', '19', 'Seixal'],
 ['PT', '02', '\xc3\x81gueda'],
 ['PT', '02', 'Albergaria-A-Velha'],
 ['PT', '02', 'Anadia'],
 ['PT', '02', 'Arouca'],
 ['PT', '02', 'Aveiro'],
 ['PT', '02', 'Castelo de Paiva'],
 ['PT', '02', 'Espinho'],
 ['PT', '02', 'Estarreja'],
 ['PT', '02', 'Santa Maria da Feira'],
 ['PT', '02', '\xc3\x8dlhavo'],
 ['PT', '02', 'Mealhada'],
 ['PT', '02', 'Murtosa'],
 ['PT', '02', 'Oliveira de Azem\xc3\xa9is'],
 ['PT', '02', 'Oliveira do Bairro'],
 ['PT', '02', 'Ovar'],
 ['PT', '02', 'S\xc3\xa3o Jo\xc3\xa3o da Madeira'],
 ['PT', '02', 'Sever do Vouga'],
 ['PT', '02', 'Vagos'],
 ['PT', '02', 'Vale de Cambra'],
 ['PT', '03', 'Aljustrel'],
 ['PT', '03', 'Almod\xc3\xb4var'],
 ['PT', '03', 'Alvito'],
 ['PT', '03', 'Barrancos'],
 ['PT', '03', 'Beja'],
 ['PT', '03', 'Castro Verde'],
 ['PT', '03', 'Cuba'],
 ['PT', '03', 'Ferreira do Alentejo'],
 ['PT', '03', 'M\xc3\xa9rtola'],
 ['PT', '03', 'Moura'],
 ['PT', '03', 'Odemira'],
 ['PT', '03', 'Ourique'],
 ['PT', '03', 'Serpa'],
 ['PT', '03', 'Vidigueira'],
 ['PT', '04', 'Amares'],
 ['PT', '04', 'Barcelos'],
 ['PT', '04', 'Braga'],
 ['PT', '04', 'Cabeceiras de Basto'],
 ['PT', '04', 'Celorico de Basto'],
 ['PT', '04', 'Esposende'],
 ['PT', '04', 'Fafe'],
 ['PT', '04', 'Guimar\xc3\xa3es'],
 ['PT', '04', 'P\xc3\xb3voa de Lanhoso'],
 ['PT', '04', 'Terras de Bouro'],
 ['PT', '04', 'Vieira do Minho'],
 ['PT', '04', 'Vila Nova de Famalic\xc3\xa3o'],
 ['PT', '04', 'Vila Verde'],
 ['PT', '04', 'Vizela'],
 ['PT', '05', 'Alf\xc3\xa2ndega da F\xc3\xa9'],
 ['PT', '05', 'Bragan\xc3\xa7a'],
 ['PT', '05', 'Carrazeda de Ansi\xc3\xa3es'],
 ['PT', '05', 'Freixo de Espada \xc3\x80 Cinta'],
 ['PT', '05', 'Macedo de Cavaleiros'],
 ['PT', '05', 'Miranda do Douro'],
 ['PT', '05', 'Mirandela'],
 ['PT', '05', 'Mogadouro'],
 ['PT', '05', 'Torre de Moncorvo'],
 ['PT', '05', 'Vila Flor'],
 ['PT', '05', 'Vimioso'],
 ['PT', '05', 'Vinhais'],
 ['PT', '06', 'Belmonte'],
 ['PT', '06', 'Castelo Branco'],
 ['PT', '06', 'Covilh\xc3\xa3'],
 ['PT', '06', 'Idanha-A-Nova'],
 ['PT', '06', 'Oleiros'],
 ['PT', '06', 'Penamacor'],
 ['PT', '06', 'Proen\xc3\xa7a-A-Nova'],
 ['PT', '06', 'Sert\xc3\xa3'],
 ['PT', '06', 'Vila de Rei'],
 ['PT', '07', 'Arganil'],
 ['PT', '07', 'Cantanhede'],
 ['PT', '07', 'Coimbra'],
 ['PT', '07', 'Condeixa-A-Nova'],
 ['PT', '07', 'Figueira da Foz'],
 ['PT', '07', 'G\xc3\xb3is'],
 ['PT', '07', 'Lous\xc3\xa3'],
 ['PT', '07', 'Mira'],
 ['PT', '07', 'Miranda do Corvo'],
 ['PT', '07', 'Montemor-O-Velho'],
 ['PT', '07', 'Oliveira do Hospital'],
 ['PT', '07', 'Pampilhosa da Serra'],
 ['PT', '07', 'Penacova'],
 ['PT', '07', 'Penela'],
 ['PT', '07', 'Soure'],
 ['PT', '07', 'T\xc3\xa1bua'],
 ['PT', '07', 'Vila Nova de Poiares'],
 ['PT', '08', 'Alandroal'],
 ['PT', '08', 'Arraiolos'],
 ['PT', '08', 'Borba'],
 ['PT', '08', 'Estremoz'],
 ['PT', '08', '\xc3\x89vora'],
 ['PT', '08', 'Montemor-O-Novo'],
 ['PT', '08', 'Mora'],
 ['PT', '08', 'Mour\xc3\xa3o'],
 ['PT', '08', 'Portel'],
 ['PT', '08', 'Redondo'],
 ['PT', '08', 'Reguengos de Monsaraz'],
 ['PT', '08', 'Vendas Novas'],
 ['PT', '08', 'Viana do Alentejo'],
 ['PT', '08', 'Vila Vi\xc3\xa7osa'],
 ['PT', '09', 'Albufeira'],
 ['PT', '09', 'Alcoutim'],
 ['PT', '09', 'Aljezur'],
 ['PT', '09', 'Castro Marim'],
 ['PT', '09', 'Faro'],
 ['PT', '09', 'Lagoa'],
 ['PT', '09', 'Lagos'],
 ['PT', '09', 'Loul\xc3\xa9'],
 ['PT', '09', 'Monchique'],
 ['PT', '09', 'Olh\xc3\xa3o'],
 ['PT', '09', 'Portim\xc3\xa3o'],
 ['PT', '09', 'S\xc3\xa3o Br\xc3\xa1s de Alportel'],
 ['PT', '09', 'Silves'],
 ['PT', '09', 'Tavira'],
 ['PT', '09', 'Vila do Bispo'],
 ['PT', '09', 'Vila Real de Santo Ant\xc3\xb3nio'],
 ['PT', '11', 'Aguiar da Beira'],
 ['PT', '11', 'Almeida'],
 ['PT', '11', 'Celorico da Beira'],
 ['PT', '11', 'Figueira de Castelo Rodrigo'],
 ['PT', '11', 'Fornos de Algodres'],
 ['PT', '11', 'Guarda'],
 ['PT', '11', 'Manteigas'],
 ['PT', '11', 'M\xc3\xaada'],
 ['PT', '11', 'Pinhel'],
 ['PT', '11', 'Sabugal'],
 ['PT', '11', 'Seia'],
 ['PT', '11', 'Trancoso'],
 ['PT', '11', 'Vila Nova de Foz C\xc3\xb4a'],
 ['PT', '13', 'Alcoba\xc3\xa7a'],
 ['PT', '13', 'Alvai\xc3\xa1zere'],
 ['PT', '13', 'Ansi\xc3\xa3o'],
 ['PT', '13', 'Batalha'],
 ['PT', '13', 'Bombarral'],
 ['PT', '13', 'Caldas da Rainha'],
 ['PT', '13', 'Castanheira de P\xc3\xaara'],
 ['PT', '13', 'Figueir\xc3\xb3 Dos Vinhos'],
 ['PT', '13', 'Leiria'],
 ['PT', '13', 'Marinha Grande'],
 ['PT', '13', 'Nazar\xc3\xa9'],
 ['PT', '13', '\xc3\x93bidos'],
 ['PT', '13', 'Pedr\xc3\xb3g\xc3\xa3o Grande'],
 ['PT', '13', 'Peniche'],
 ['PT', '13', 'Pombal'],
 ['PT', '13', 'Porto de M\xc3\xb3s'],
 ['PT', '14', 'Alenquer'],
 ['PT', '14', 'Arruda Dos Vinhos'],
 ['PT', '14', 'Azambuja'],
 ['PT', '14', 'Cadaval'],
 ['PT', '14', 'Cascais'],
 ['PT', '14', 'Lourinh\xc3\xa3'],
 ['PT', '14', 'Mafra'],
 ['PT', '14', 'Oeiras'],
 ['PT', '14', 'Sintra'],
 ['PT', '14', 'Sobral de Monte Agra\xc3\xa7o'],
 ['PT', '14', 'Torres Vedras'],
 ['PT', '14', 'Vila Franca de Xira'],
 ['PT', '14', 'Amadora'],
 ['PT', '14', 'Odivelas'],
 ['PT', '16', 'Arronches'],
 ['PT', '16', 'Avis'],
 ['PT', '16', 'Campo Maior'],
 ['PT', '16', 'Elvas'],
 ['PT', '16', 'Fronteira'],
 ['PT', '16', 'Sousel'],
 ['PT', '17', 'Amarante'],
 ['PT', '17', 'Bai\xc3\xa3o'],
 ['PT', '17', 'Felgueiras'],
 ['PT', '17', 'Gondomar'],
 ['PT', '17', 'Lousada'],
 ['PT', '17', 'Maia'],
 ['PT', '17', 'Marco de Canaveses'],
 ['PT', '17', 'Matosinhos'],
 ['PT', '17', 'Pa\xc3\xa7os de Ferreira'],
 ['PT', '17', 'Paredes'],
 ['PT', '17', 'Penafiel'],
 ['PT', '17', 'P\xc3\xb3voa de Varzim'],
 ['PT', '17', 'Santo Tirso'],
 ['PT', '17', 'Valongo'],
 ['PT', '17', 'Vila do Conde'],
 ['PT', '17', 'Vila Nova de Gaia'],
 ['PT', '17', 'Trofa'],
 ['PT', '18', 'Abrantes'],
 ['PT', '18', 'Alcanena'],
 ['PT', '18', 'Almeirim'],
 ['PT', '18', 'Alpiar\xc3\xa7a'],
 ['PT', '18', 'Benavente'],
 ['PT', '18', 'Cartaxo'],
 ['PT', '18', 'Chamusca'],
 ['PT', '18', 'Const\xc3\xa2ncia'],
 ['PT', '18', 'Coruche'],
 ['PT', '18', 'Entroncamento'],
 ['PT', '18', 'Ferreira do Z\xc3\xaazere'],
 ['PT', '18', 'Goleg\xc3\xa3'],
 ['PT', '18', 'Ma\xc3\xa7\xc3\xa3o'],
 ['PT', '18', 'Rio Maior'],
 ['PT', '18', 'Salvaterra de Magos'],
 ['PT', '18', 'Santar\xc3\xa9m'],
 ['PT', '18', 'Sardoal'],
 ['PT', '18', 'Tomar'],
 ['PT', '18', 'Torres Novas'],
 ['PT', '18', 'Vila Nova da Barquinha'],
 ['PT', '18', 'Our\xc3\xa9m'],
 ['PT', '19', 'Alc\xc3\xa1cer do Sal'],
 ['PT', '19', 'Alcochete'],
 ['PT', '19', 'Almada'],
 ['PT', '19', 'Barreiro'],
 ['PT', '19', 'Gr\xc3\xa2ndola'],
 ['PT', '19', 'Moita'],
 ['PT', '19', 'Montijo'],
 ['PT', '19', 'Palmela'],
 ['PT', '19', 'Santiago do Cac\xc3\xa9m'],
 ['PT', '19', 'Sesimbra'],
 ['PT', '19', 'Set\xc3\xbabal'],
 ['PT', '19', 'Sines'],
 ['PT', '20', 'Arcos de Valdevez'],
 ['PT', '20', 'Caminha'],
 ['PT', '20', 'Melga\xc3\xa7o'],
 ['PT', '20', 'Mon\xc3\xa7\xc3\xa3o'],
 ['PT', '20', 'Paredes de Coura'],
 ['PT', '20', 'Ponte da Barca'],
 ['PT', '20', 'Ponte de Lima'],
 ['PT', '20', 'Valen\xc3\xa7a'],
 ['PT', '20', 'Viana do Castelo'],
 ['PT', '20', 'Vila Nova de Cerveira'],
 ['PT', '21', 'Alij\xc3\xb3'],
 ['PT', '21', 'Boticas'],
 ['PT', '21', 'Chaves'],
 ['PT', '21', 'Mes\xc3\xa3o Frio'],
 ['PT', '21', 'Mondim de Basto'],
 ['PT', '21', 'Montalegre'],
 ['PT', '21', 'Mur\xc3\xa7a'],
 ['PT', '21', 'Peso da R\xc3\xa9gua'],
 ['PT', '21', 'Ribeira de Pena'],
 ['PT', '21', 'Sabrosa'],
 ['PT', '21', 'Santa Marta de Penagui\xc3\xa3o'],
 ['PT', '21', 'Valpa\xc3\xa7os'],
 ['PT', '21', 'Vila Pouca de Aguiar'],
 ['PT', '21', 'Vila Real'],
 ['PT', '22', 'Armamar'],
 ['PT', '22', 'Castro Daire'],
 ['PT', '22', 'Cinf\xc3\xa3es'],
 ['PT', '22', 'Lamego'],
 ['PT', '22', 'Mangualde'],
 ['PT', '22', 'Moimenta da Beira'],
 ['PT', '22', 'Mort\xc3\xa1gua'],
 ['PT', '22', 'Nelas'],
 ['PT', '22', 'Oliveira de Frades'],
 ['PT', '22', 'Penalva do Castelo'],
 ['PT', '22', 'Penedono'],
 ['PT', '22', 'Resende'],
 ['PT', '22', 'Santa Comba D\xc3\xa3o'],
 ['PT', '22', 'S\xc3\xa3o Jo\xc3\xa3o da Pesqueira'],
 ['PT', '22', 'S\xc3\xa3o Pedro do Su