# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FrontendEndpointUpdateParameters(Model):
    """Frontend endpoint used in routing rule.

    :param host_name: The host name of the frontendEndpoint. Must be a domain
     name.
    :type host_name: str
    :param session_affinity_enabled_state: Whether to allow session affinity
     on this host. Valid options are 'Enabled' or 'Disabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type session_affinity_enabled_state: str or
     ~azure.mgmt.frontdoor.models.SessionAffinityEnabledState
    :param session_affinity_ttl_seconds: UNUSED. This field will be ignored.
     The TTL to use in seconds for session affinity, if applicable.
    :type session_affinity_ttl_seconds: int
    :param web_application_firewall_policy_link: Defines the Web Application
     Firewall policy for each host (if applicable)
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'session_affinity_enabled_state': {'key': 'sessionAffinityEnabledState', 'type': 'str'},
        'session_affinity_ttl_seconds': {'key': 'sessionAffinityTtlSeconds', 'type': 'int'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(self, **kwargs):
        super(FrontendEndpointUpdateParameters, self).__init__(**kwargs)
        self.host_name = kwargs.get('host_name', None)
        self.session_affinity_enabled_state = kwargs.get('session_affinity_enabled_state', None)
        self.session_affinity_ttl_seconds = kwargs.get('session_affinity_ttl_seconds', None)
        self.web_application_firewall_policy_link = kwargs.get('web_application_firewall_policy_link', None)
