# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FrontDoorUpdateParameters(Model):
    """The properties needed to update a Front Door.

    :param friendly_name: A friendly name for the frontDoor
    :type friendly_name: str
    :param routing_rules: Routing rules associated with this Front Door.
    :type routing_rules: list[~azure.mgmt.frontdoor.models.RoutingRule]
    :param load_balancing_settings: Load balancing settings associated with
     this Front Door instance.
    :type load_balancing_settings:
     list[~azure.mgmt.frontdoor.models.LoadBalancingSettingsModel]
    :param health_probe_settings: Health probe settings associated with this
     Front Door instance.
    :type health_probe_settings:
     list[~azure.mgmt.frontdoor.models.HealthProbeSettingsModel]
    :param backend_pools: Backend pools available to routing rules.
    :type backend_pools: list[~azure.mgmt.frontdoor.models.BackendPool]
    :param frontend_endpoints: Frontend endpoints available to routing rules.
    :type frontend_endpoints:
     list[~azure.mgmt.frontdoor.models.FrontendEndpoint]
    :param enabled_state: Operational status of the Front Door load balancer.
     Permitted values are 'Enabled' or 'Disabled'. Possible values include:
     'Enabled', 'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorEnabledState
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'routing_rules': {'key': 'routingRules', 'type': '[RoutingRule]'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': '[LoadBalancingSettingsModel]'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': '[HealthProbeSettingsModel]'},
        'backend_pools': {'key': 'backendPools', 'type': '[BackendPool]'},
        'frontend_endpoints': {'key': 'frontendEndpoints', 'type': '[FrontendEndpoint]'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FrontDoorUpdateParameters, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.routing_rules = kwargs.get('routing_rules', None)
        self.load_balancing_settings = kwargs.get('load_balancing_settings', None)
        self.health_probe_settings = kwargs.get('health_probe_settings', None)
        self.backend_pools = kwargs.get('backend_pools', None)
        self.frontend_endpoints = kwargs.get('frontend_endpoints', None)
        self.enabled_state = kwargs.get('enabled_state', None)
