# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Backend(Model):
    """Backend address of a frontDoor load balancer.

    :param address: Location of the backend (IP address or FQDN)
    :type address: str
    :param http_port: The HTTP TCP port number. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The HTTPS TCP port number. Must be between 1 and 65535.
    :type https_port: int
    :param enabled_state: Whether to enable use of this backend. Permitted
     values are 'Enabled' or 'Disabled'. Possible values include: 'Enabled',
     'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorEnabledState
    :param priority: Priority to use for load balancing. Higher priorities
     will not be used for load balancing if any lower priority backend is
     healthy.
    :type priority: int
    :param weight: Weight of this endpoint for load balancing purposes.
    :type weight: int
    :param backend_host_header: The value to use as the host header sent to
     the backend. If blank or unspecified, this defaults to the incoming host.
    :type backend_host_header: str
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'backend_host_header': {'key': 'backendHostHeader', 'type': 'str'},
    }

    def __init__(self, *, address: str=None, http_port: int=None, https_port: int=None, enabled_state=None, priority: int=None, weight: int=None, backend_host_header: str=None, **kwargs) -> None:
        super(Backend, self).__init__(**kwargs)
        self.address = address
        self.http_port = http_port
        self.https_port = https_port
        self.enabled_state = enabled_state
        self.priority = priority
        self.weight = weight
        self.backend_host_header = backend_host_header
