# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class BackendPool(SubResource):
    """A backend pool is a collection of backends that can be routed to.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param backends: The set of backends for this pool
    :type backends: list[~azure.mgmt.frontdoor.models.Backend]
    :param load_balancing_settings: Load balancing settings for a backend pool
    :type load_balancing_settings: ~azure.mgmt.frontdoor.models.SubResource
    :param health_probe_settings: L7 health probe settings for a backend pool
    :type health_probe_settings: ~azure.mgmt.frontdoor.models.SubResource
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backends': {'key': 'properties.backends', 'type': '[Backend]'},
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': 'SubResource'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'SubResource'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackendPool, self).__init__(**kwargs)
        self.backends = kwargs.get('backends', None)
        self.load_balancing_settings = kwargs.get('load_balancing_settings', None)
        self.health_probe_settings = kwargs.get('health_probe_settings', None)
        self.resource_state = kwargs.get('resource_state', None)
        self.name = kwargs.get('name', None)
        self.type = None
