/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.ds.trie;

import kr.co.shineware.ds.trie.model.TrieNode;

public class TrieDictionary<V> {
    private TrieNode<V> root;
    private TrieNode<V> currentNode;
    private boolean hasChildren;

    public TrieDictionary() {
        this.setRoot(new TrieNode());
        this.hasChildren = false;
        this.currentNode = null;
    }

    public TrieNode<V> getRoot() {
        return this.root;
    }

    public void setRoot(TrieNode<V> root) {
        this.root = root;
    }

    public void put(String keys, V value) {
        this.put(keys.toCharArray(), value);
    }

    public void put(char[] keys, V value) {
        TrieNode<V> node = this.root;
        TrieNode<V>[] children = null;
        int i = 0;
        while (i < keys.length) {
            char key = keys[i];
            children = node.getChildren();
            if (children == null) {
                node.setChildren(this.initNode(key));
                node = node.getChildren()[0];
            } else {
                int idx = this.retrieveNode(children, key);
                if (idx == -1) {
                    int head = 0;
                    int tail = children.length - 1;
                    idx = 0;
                    while (head <= tail) {
                        idx = (head + tail) / 2;
                        if (((Character)children[idx].getKey()).charValue() < key) {
                            head = idx + 1;
                            continue;
                        }
                        if (((Character)children[idx].getKey()).charValue() > key) {
                            tail = idx - 1;
                            continue;
                        }
                        if (((Character)children[idx].getKey()).charValue() == key) break;
                    }
                    TrieNode[] newArray = new TrieNode[children.length + 1];
                    System.arraycopy(children, 0, newArray, 0, head);
                    newArray[head] = new TrieNode();
                    newArray[head].setKey(Character.valueOf(key));
                    System.arraycopy(children, head, newArray, head + 1, children.length - head);
                    node.setChildren(newArray);
                    idx = head;
                }
                node = node.getChildren()[idx];
            }
            ++i;
        }
        node.setValue(value);
    }

    public V get(String keys) {
        return this.get(keys.toCharArray());
    }

    public V get(char key) {
        TrieNode<V>[] children;
        this.hasChildren = false;
        if (this.currentNode == null) {
            this.currentNode = this.root;
        }
        if ((children = this.currentNode.getChildren()) == null) {
            this.hasChildren = false;
            return null;
        }
        int idx = this.retrieveNode(children, key);
        if (idx == -1) {
            this.hasChildren = false;
            return null;
        }
        this.currentNode = children[idx];
        this.hasChildren = this.currentNode.getChildren() != null;
        return this.currentNode.getValue();
    }

    public V get(char[] keys) {
        this.hasChildren = false;
        TrieNode<V> node = this.root;
        int i = 0;
        while (i < keys.length) {
            char key = keys[i];
            TrieNode<V>[] children = node.getChildren();
            if (children == null) {
                this.hasChildren = false;
                return null;
            }
            int idx = this.retrieveNode(children, key);
            if (idx == -1) {
                this.hasChildren = false;
                return null;
            }
            node = children[idx];
            ++i;
        }
        this.hasChildren = node.getChildren() != null;
        return node.getValue();
    }

    private int retrieveNode(TrieNode<V>[] children, char key) {
        int head = 0;
        int tail = children.length - 1;
        int idx = 0;
        while (head <= tail) {
            idx = (head + tail) / 2;
            if (((Character)children[idx].getKey()).charValue() < key) {
                head = idx + 1;
                continue;
            }
            if (((Character)children[idx].getKey()).charValue() > key) {
                tail = idx - 1;
                continue;
            }
            if (((Character)children[idx].getKey()).charValue() != key) continue;
            return idx;
        }
        return -1;
    }

    private TrieNode<V>[] initNode(char key) {
        TrieNode[] nodes = new TrieNode[]{new TrieNode()};
        nodes[0].setKey(Character.valueOf(key));
        return nodes;
    }

    public void save(String filename) {
        this.root.save(filename);
    }

    public void load(String filename) {
        this.root.load(filename);
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public TrieNode<V> getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(TrieNode<V> currentNode) {
        this.currentNode = currentNode;
    }
}

