/*
 * Decompiled with CFR 0.152.
 */
package py4j.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.Py4JException;
import py4j.reflection.LRUCache;
import py4j.reflection.MethodDescriptor;
import py4j.reflection.MethodInvoker;
import py4j.reflection.TypeUtil;

public class ReflectionEngine {
    public static int cacheSize = 100;
    private final Logger logger = Logger.getLogger(ReflectionEngine.class.getName());
    public static final Object RETURN_VOID = new Object();
    private static ThreadLocal<LRUCache<MethodDescriptor, MethodInvoker>> cacheHolder = new ThreadLocal<LRUCache<MethodDescriptor, MethodInvoker>>(){

        @Override
        protected LRUCache<MethodDescriptor, MethodInvoker> initialValue() {
            return new LRUCache<MethodDescriptor, MethodInvoker>(cacheSize);
        }
    };

    public Object createArray(String fqn, int[] dimensions) {
        Class<?> clazz = null;
        Object returnObject = null;
        try {
            clazz = TypeUtil.forName(fqn);
            returnObject = Array.newInstance(clazz, dimensions);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Class FQN does not exist: " + fqn, e);
            throw new Py4JException(e);
        }
        return returnObject;
    }

    private MethodInvoker getBestConstructor(List<Constructor<?>> acceptableConstructors, Class<?>[] parameters) {
        MethodInvoker lowestCost = null;
        for (Constructor<?> constructor : acceptableConstructors) {
            MethodInvoker temp = MethodInvoker.buildInvoker(constructor, parameters);
            int cost = temp.getCost();
            if (cost == -1) continue;
            if (cost == 0) {
                lowestCost = temp;
                break;
            }
            if (lowestCost != null && cost >= lowestCost.getCost()) continue;
            lowestCost = temp;
        }
        return lowestCost;
    }

    private MethodInvoker getBestMethod(List<Method> acceptableMethods, Class<?>[] parameters) {
        MethodInvoker lowestCost = null;
        for (Method method : acceptableMethods) {
            MethodInvoker temp = MethodInvoker.buildInvoker(method, parameters);
            int cost = temp.getCost();
            if (cost == -1) continue;
            if (cost == 0) {
                lowestCost = temp;
                break;
            }
            if (lowestCost != null && cost >= lowestCost.getCost()) continue;
            lowestCost = temp;
        }
        return lowestCost;
    }

    public Class<?> getClass(Class<?> clazz, String name) {
        Class<?> memberClass = null;
        try {
            for (Class<?> tempClass : clazz.getClasses()) {
                if (!tempClass.getSimpleName().equals(name)) continue;
                memberClass = tempClass;
                break;
            }
        }
        catch (Exception e) {
            memberClass = null;
        }
        return memberClass;
    }

    private Class<?>[] getClassParameters(Object[] parameters) {
        int size = parameters.length;
        Class[] classes = new Class[size];
        for (int i = 0; i < size; ++i) {
            classes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        return classes;
    }

    public MethodInvoker getConstructor(Class<?> clazz, Class<?>[] parameters) {
        MethodDescriptor mDescriptor = new MethodDescriptor(clazz.getName(), clazz, parameters);
        MethodInvoker mInvoker = null;
        List<Constructor<?>> acceptableConstructors = null;
        LRUCache<MethodDescriptor, MethodInvoker> cache = cacheHolder.get();
        mInvoker = (MethodInvoker)cache.get(mDescriptor);
        if (mInvoker == null) {
            acceptableConstructors = this.getConstructorsByLength(clazz, parameters.length);
            mInvoker = acceptableConstructors.size() == 1 ? MethodInvoker.buildInvoker(acceptableConstructors.get(0), parameters) : this.getBestConstructor(acceptableConstructors, parameters);
            if (mInvoker != null && mInvoker.getCost() != -1) {
                cache.put(mDescriptor, mInvoker);
            } else {
                String errorMessage = "Constructor " + clazz.getName() + "(" + Arrays.toString(parameters) + ") does not exist";
                this.logger.log(Level.WARNING, errorMessage);
                throw new Py4JException(errorMessage);
            }
        }
        return mInvoker;
    }

    public MethodInvoker getConstructor(String classFQN, Object[] parameters) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classFQN);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Class FQN does not exist: " + classFQN, e);
            throw new Py4JException(e);
        }
        return this.getConstructor(clazz, this.getClassParameters(parameters));
    }

    private List<Constructor<?>> getConstructorsByLength(Class<?> clazz, int length) {
        ArrayList methods = new ArrayList();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != length) continue;
            methods.add(constructor);
        }
        return methods;
    }

    public Field getField(Class<?> clazz, String name) {
        Field field = null;
        try {
            field = clazz.getField(name);
            if (!Modifier.isPublic(field.getModifiers()) && !field.isAccessible()) {
                field = null;
            }
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        catch (Exception e) {
            field = null;
        }
        return field;
    }

    public Field getField(Object obj, String name) {
        return this.getField(obj.getClass(), name);
    }

    public Field getField(String classFQN, String name) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classFQN);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Class FQN does not exist: " + classFQN, e);
            throw new Py4JException(e);
        }
        return this.getField(clazz, name);
    }

    public Object getFieldValue(Object obj, Field field) {
        Object fieldValue = null;
        try {
            fieldValue = field.get(obj);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while fetching field value of " + field, e);
            throw new Py4JException(e);
        }
        return fieldValue;
    }

    public void setFieldValue(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while setting field value of " + field, e);
            throw new Py4JException(e);
        }
    }

    public Method getMethod(Class<?> clazz, String name) {
        Method m = null;
        try {
            for (Method tempMethod : clazz.getMethods()) {
                if (!tempMethod.getName().equals(name)) continue;
                m = tempMethod;
                break;
            }
        }
        catch (Exception e) {
            m = null;
        }
        return m;
    }

    public MethodInvoker getMethod(Class<?> clazz, String name, Class<?>[] parameters) {
        MethodDescriptor mDescriptor = new MethodDescriptor(name, clazz, parameters);
        MethodInvoker mInvoker = null;
        List<Method> acceptableMethods = null;
        LRUCache<MethodDescriptor, MethodInvoker> cache = cacheHolder.get();
        mInvoker = (MethodInvoker)cache.get(mDescriptor);
        if (mInvoker == null) {
            acceptableMethods = this.getMethodsByNameAndLength(clazz, name, parameters.length);
            mInvoker = acceptableMethods.size() == 1 ? MethodInvoker.buildInvoker(acceptableMethods.get(0), parameters) : this.getBestMethod(acceptableMethods, parameters);
            if (mInvoker != null && mInvoker.getCost() != -1) {
                cache.put(mDescriptor, mInvoker);
            } else {
                String errorMessage = "Method " + name + "(" + Arrays.toString(parameters) + ") does not exist";
                this.logger.log(Level.WARNING, errorMessage);
                throw new Py4JException(errorMessage);
            }
        }
        return mInvoker;
    }

    public MethodInvoker getMethod(Object object, String name, Object[] parameters) {
        return this.getMethod(object.getClass(), name, this.getClassParameters(parameters));
    }

    public MethodInvoker getMethod(String classFQN, String name, Object[] parameters) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classFQN);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Class FQN does not exist: " + classFQN, e);
            throw new Py4JException(e);
        }
        return this.getMethod(clazz, name, this.getClassParameters(parameters));
    }

    private List<Method> getMethodsByNameAndLength(Class<?> clazz, String name, int length) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.getParameterTypes().length != length) continue;
            methods.add(method);
        }
        return methods;
    }

    public Object invoke(Object object, MethodInvoker invoker, Object[] parameters) {
        Object returnObject = null;
        returnObject = invoker.invoke(object, parameters);
        if (invoker.isVoid()) {
            returnObject = RETURN_VOID;
        }
        return returnObject;
    }
}

