
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Refund(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def createRefund(self,refund, orderId, responseFields = None):
		""" orders-orderrefunds Post CreateRefund description DOCUMENT_HERE 
		
		Args:
			| refund(refund) - Mozu.CommerceRuntime.Contracts.Refunds.Refund ApiType DOCUMENT_HERE 
			| orderId (string) - Unique identifier of the order.
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| Refund 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/refunds?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(refund).execute();
		return self.client.result();

	
		
	def resendRefundEmail(self,orderId, refundId):
		""" orders-orderrefunds Put ResendRefundEmail description DOCUMENT_HERE 
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| refundId (string) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/refunds/{refundId}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("refundId", refundId);
		self.client.withResourceUrl(url).execute();

	
	
	