
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class ProductProperty(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getProperties(self,productCode):
		""" Retrieves a list of the property attributes configured for the product specified in the request.
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
		
		Returns:
			| array of ProductProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getPropertyValueLocalizedContents(self,productCode, attributeFQN, value):
		""" Retrieves a collection of property values for localized content. This content is set by the locale code. 
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
		
		Returns:
			| array of ProductPropertyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}/values/{value}/LocalizedContent", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("productCode", productCode);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getPropertyValueLocalizedContent(self,productCode, attributeFQN, value, localeCode, responseFields = None):
		""" Retrieves the property value for localized content. This content is set by the locale code. 
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
			| localeCode (string) - Language used for the entity. Currently, only "en-US" is supported.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductPropertyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}/values/{value}/LocalizedContent/{localeCode}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getProperty(self,productCode, attributeFQN, responseFields = None):
		""" Retrieves the details of a property attribute configuration for the product specified in the request.
		
		Args:
			| productCode (string) - Merchant-created code that uniquely identifies the product such as a SKU or item number. Once created, the product code is read-only.
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addPropertyValueLocalizedContent(self,localizedContent, productCode, attributeFQN, value, responseFields = None):
		""" Adds a property value for localized content. This content is set by the locale code. 
		
		Args:
			| localizedContent(localizedContent) - Use this field to include those fields which are not included by default.
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductPropertyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}/values/{value}/LocalizedContent?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def addProperty(self,productProperty, productCode, responseFields = None):
		""" Configures a property attribute for the product specified in the request.
		
		Args:
			| productProperty(productProperty) - Details of a property defined for a product.
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(productProperty).execute();
		return self.client.result();

	
		
	def updatePropertyValueLocalizedContents(self,localizedContent, productCode, attributeFQN, value):
		""" Updates all property values for localized content. This content is set by the locale code. 
		
		Args:
			| localizedContent(array|localizedContent) - Content of the product property value in the language defined for the locale code.
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
		
		Returns:
			| array of ProductPropertyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}/values/{value}/LocalizedContent", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("productCode", productCode);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def updatePropertyValueLocalizedContent(self,localizedContent, productCode, attributeFQN, value, localeCode, responseFields = None):
		""" Updates the property value for localized content. This content is set by the locale code. 
		
		Args:
			| localizedContent(localizedContent) - Content of the product property value in the language defined for the locale code.
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
			| localeCode (string) - Language used for the entity. Currently, only "en-US" is supported.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductPropertyValueLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}/values/{value}/LocalizedContent/{localeCode}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).withBody(localizedContent).execute();
		return self.client.result();

	
		
	def updateProperty(self,productProperty, productCode, attributeFQN, responseFields = None):
		""" Update one or more details of a property attribute configuration for the product specified in the request.
		
		Args:
			| productProperty(productProperty) - Details of a property defined for a product.
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductProperty 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("productCode", productCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(productProperty).execute();
		return self.client.result();

	
		
	def deleteProperty(self,productCode, attributeFQN):
		""" Deletes the configuration of a property attribute for the product specified in the request.
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| attributeFQN (string) - The fully qualified name of the attribute, which is a user defined attribute identifier.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("productCode", productCode);
		self.client.withResourceUrl(url).execute();

	
		
	def deletePropertyValueLocalizedContent(self,productCode, attributeFQN, value, localeCode):
		""" Deletes the property value for localized content. This content is set by the locale code. 
		
		Args:
			| productCode (string) - The unique, user-defined product code of a product, used throughout Mozu to reference and associate to a product.
			| attributeFQN (string) - Fully qualified name for an attribute.
			| value (string) - The value string to create.
			| localeCode (string) - Language used for the entity. Currently, only "en-US" is supported.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/products/{productCode}/Properties/{attributeFQN}/values/{value}/LocalizedContent/{localeCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("attributeFQN", attributeFQN);
		url.formatUrl("localeCode", localeCode);
		url.formatUrl("productCode", productCode);
		url.formatUrl("value", value);
		self.client.withResourceUrl(url).execute();

	
	
	