
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Discount(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getDiscounts(self,startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" Retrieves a list of discounts according to any specified filter criteria and sort options.
		
		Args:
			| startIndex (int) - 
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - 
			| filter (string) - A set of expressions that consist of a field, operator, and value and represent search parameter syntax when filtering results of a query. Valid operators include equals (eq), does not equal (ne), greater than (gt), less than (lt), greater than or equal to (ge), less than or equal to (le), starts with (sw), or contains (cont). For example - "filter=IsDisplayed+eq+true"
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DiscountCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/discounts/?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getDiscountContent(self,discountId, responseFields = None):
		""" Retrieves the localized content specified for the specified discount.
		
		Args:
			| discountId (int) - Unique identifier of the discount. System-supplied and read only.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DiscountLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/discounts/{discountId}/content?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("discountId", discountId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getDiscount(self,discountId, responseFields = None):
		""" Retrieves the details of a single discount.
		
		Args:
			| discountId (int) - Unique identifier of the discount. System-supplied and read only.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Discount 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/discounts/{discountId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("discountId", discountId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def generateRandomCoupon(self,responseFields = None):
		""" Generates a random code for a coupon.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| string 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/discounts/generate-random-coupon?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createDiscount(self,discount, responseFields = None):
		""" Creates a new discount or coupon to apply to a product, category, order, or shipping.
		
		Args:
			| discount(discount) - Name of the discount added and applied to a shopping cart and order for a shopper's purchase. 
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Discount 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/discounts/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(discount).execute();
		return self.client.result();

	
		
	def updateDiscountContent(self,content, discountId, responseFields = None):
		""" Updates the localizable content for the specified discount or rename the discount without modifying its other properties.
		
		Args:
			| content(content) - The container for the language-specific name of the discount. A container exists for each supported language (LocaleCode). This parameter enables you to display the discount name in multiple languages yet manage it as a single discount internally.
			| discountId (int) - Unique identifier of the discount. System-supplied and read only.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DiscountLocalizedContent 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/discounts/{discountId}/content?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("discountId", discountId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(content).execute();
		return self.client.result();

	
		
	def updateDiscount(self,discount, discountId, responseFields = None):
		""" Updates one or more properties of a defined discount.
		
		Args:
			| discount(discount) - Name of the discount added and applied to a shopping cart and order for a shopper's purchase. 
			| discountId (int) - Unique identifier of the discount. System-supplied and read only.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Discount 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/discounts/{discountId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("discountId", discountId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(discount).execute();
		return self.client.result();

	
		
	def deleteDiscount(self,discountId):
		""" Deletes a discount specified by its discount ID.
		
		Args:
			| discountId (int) - Unique identifier of the discount. System-supplied and read only.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/discounts/{discountId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("discountId", discountId);
		self.client.withResourceUrl(url).execute();

	
	
	