
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class LocationType(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def getLocationTypes(self,):
		""" Retrieve a list of all location types defined for the tenant.
		
		Returns:
			| array of LocationType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/admin/locationtypes/", "GET", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getLocationType(self,locationTypeCode, responseFields = None):
		""" Retrieves the details of the location type specified in the request.
		
		Args:
			| locationTypeCode (string) - The user-defined code that identifies the location type.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| LocationType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/admin/locationtypes/{locationTypeCode}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("locationTypeCode", locationTypeCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addLocationType(self,locationType, responseFields = None):
		""" Creates a new location type based on the information specified in the request.
		
		Args:
			| locationType(locationType) - Properties of a type of physical location, such as warehouse or kiosk. Location types enable tenants to group similar locations for filtering and location usage type definition.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| LocationType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/admin/locationtypes/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(locationType).execute();
		return self.client.result();

	
		
	def updateLocationType(self,locationType, locationTypeCode, responseFields = None):
		""" Updates the name of a defined location type.
		
		Args:
			| locationType(locationType) - Properties of a type of physical location, such as warehouse or kiosk. Location types enable tenants to group similar locations for filtering and location usage type definition.
			| locationTypeCode (string) - The user-defined code that identifies the location type.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| LocationType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/admin/locationtypes/{locationTypeCode}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("locationTypeCode", locationTypeCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(locationType).execute();
		return self.client.result();

	
		
	def deleteLocationType(self,locationTypeCode):
		""" Deletes the location type specified in the request.
		
		Args:
			| locationTypeCode (string) - The user-defined code that identifies the location type.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/admin/locationtypes/{locationTypeCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("locationTypeCode", locationTypeCode);
		self.client.withResourceUrl(url).execute();

	
	
	