import time

import pandas as pd
import re

from selenium import webdriver
from bs4 import BeautifulSoup
from selenium.webdriver.common.by import By
from selenium.webdriver.support.wait import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC

from zlsrc.util.etl import est_tbs, est_meta, est_html



def f1(driver, num):
    locator = (By.XPATH, '//div[@class="morelist"]/table//tr[1]/td[2]/a')
    WebDriverWait(driver, 10).until(EC.presence_of_element_located(locator))

    cnum = driver.find_element_by_xpath('//td[@class="huifont"]').text.strip()

    cnum = re.findall('(\d+?)/', cnum)[0]

    if int(cnum) != num:
        val = driver.find_element_by_xpath('//div[@class="morelist"]/table//tr[1]/td[2]/a').get_attribute('href')[-30:]

        driver.execute_script("window.location.href='./?Paging={}'".format(num))

        locator = (By.XPATH, '//div[@class="morelist"]/table//tr[1]/td[2]/a[not(contains(@href,"%s"))]' % val)
        WebDriverWait(driver, 10).until(EC.presence_of_element_located(locator))

    data = []

    html = driver.page_source
    soup = BeautifulSoup(html, 'lxml')
    div = soup.find('div', class_='morelist').find('table')
    lis = div.find_all('tr')
    for li in lis:
        href = li.find('td', align='left').a['href']
        name = li.find('td', align='left').a['title']
        ggstart_time = li.find('td', align='right').span.get_text()

        if 'http' in href:
            href = href
        else:
            href = 'http://lc.eszggzy.cn' + href
        tmp = [name, ggstart_time,href]
        data.append(tmp)
    df = pd.DataFrame(data=data)
    df['info'] = None
    return df


def f2(driver):
    locator = (By.XPATH, '//div[@class="morelist"]/table//tr[1]/td[2]/a')
    WebDriverWait(driver, 10).until(EC.presence_of_element_located(locator))

    page = driver.find_element_by_xpath('//td[@class="huifont"]').text

    total = re.findall('/(\d+)', page)[0]
    total = int(total)

    driver.quit()
    return total


def f3(driver, url):
    driver.get(url)

    locator = (By.XPATH, '//div[@class="row mt10"]')

    WebDriverWait(driver, 10).until(EC.presence_of_all_elements_located(locator))

    before = len(driver.page_source)
    time.sleep(0.1)
    after = len(driver.page_source)
    i = 0
    while before != after:
        before = len(driver.page_source)
        time.sleep(0.1)
        after = len(driver.page_source)
        i += 1
        if i > 5: break

    page = driver.page_source

    soup = BeautifulSoup(page, 'lxml')

    div = soup.find('div', class_='row mt10')

    return div


data = [
    ###包含:招标,流标,变更
    ["gcjs_gqita_zhao_liu_bian_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070001/070001001/", ['name', 'ggstart_time', 'href', 'info'],
     f1, f2],
    ["gcjs_gqita_bian_liu_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070001/070001002/", ['name', 'ggstart_time', 'href', 'info'],
     f1, f2],
    ["gcjs_zhongbiaohx_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070001/070001003/",
     ['name', 'ggstart_time', 'href', 'info'], f1, f2],


    ##包含:招标,流标,变更
    ["zfcg_gqita_zhao_liu_bian_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070002/070002001/", ['name', 'ggstart_time', 'href', 'info'],
     f1, f2],
    ["zfcg_biangeng_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070002/070002002/", ['name', 'ggstart_time', 'href', 'info'],
     f1, f2],
    ["zfcg_zhongbiao_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070002/070002003/", ['name', 'ggstart_time', 'href', 'info'],
     f1, f2],
    ["zfcg_dyly_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070002/070002004/", ['name', 'ggstart_time', 'href', 'info'],
     f1, f2],
##包含:招标,流标,变更
    ["qsy_gqita_zhao_liu_bian_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070005/070005001/", ['name', 'ggstart_time', 'href', 'info'],
     f1, f2],
    ["qsy_biangeng_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070005/070005002/", ['name', 'ggstart_time', 'href', 'info'],
     f1, f2],
    ["qsy_zhongbiao_gg", "http://lc.eszggzy.cn/lcweb/jyxx/070005/070005003/",
     ['name', 'ggstart_time', 'href', 'info'], f1, f2],

]


def work(conp, **args):
    est_meta(conp, data=data, diqu="湖北省利川市", **args)
    est_html(conp, f=f3, **args)

if __name__ == '__main__':
    conp = ["postgres", "since2015", "192.168.3.171", "hubei", "lichuan"]

    work(conp=conp)