# PollEvBot

PollEvBot is a script that automatically answers polls from PollEverywhere. It continually checks if a specified poll "host" has any polls open. Once a poll has been opened, it submits the correct response to PollEverywhere, or a random one if the poll has no correct response.

## Dependencies

This script uses Python 3 and its standard libraries. You'll also need [Python Requests](https://github.com/requests/requests) and [BeautifulSoup](https://github.com/waylan/beautifulsoup).

## Usage

Install `PollEvBot`:
```
pip install PollEvBot
```

And connect to a poll:
```python
import PollEvBot
import time

host = 'My Favorite Teacher'
user = 'MyUW Username (@uw.edu email)'
password = 'MyUW Password'

def main():
    with PollEvBot.Poll(poll_host=host) as poll:
        poll.login_to_myUW(username=user, password=password)
        poll.connect_to_channel()
        while not poll.is_open():
            print("No polls have been opened yet.")
            time.sleep(3)
        poll.answer_poll(clear_responses=True)
```
Simple as that, really. Alternatively, you can enter your MyUW Login, Password, and the desired poll host into main.py and run it. 

## Disclaimer

I do not promote or condone the usage of this script for any purpose related to academic dishonesty, including but not limited to cheating on PollEverywhere quizzes or spoofing attendance polls. I wrote this script purely for the purpose of educating myself on cybersecurity and http protocols.
