# -*- coding: utf-8 -*-
# ┌─────────────────────────────────────────────────────┐
# │ mynify 0.1 - Droplet to compress js and css         │
# ├─────────────────────────────────────────────────────┤
# │ Copyright (c) 2012 Amadeusguo                       │
# │ http://amadeus.herokuapp.com/                       │
# │ Licensed under the MIT license.                     │
# └─────────────────────────────────────────────────────┘

import os
import sys

from meteor.compiler import jar_yui
from meteor.compiler import jar_compiler


help_msg = '''
Minify a set of files

Usage:
    meteor minify file1 file2
'''

def config(parser):
    parser.set_defaults(func=action)
    parser.add_argument('files', metavar='file', type=str, nargs='+',
                       help='list of files to be processed')

js_min_cmd = r'java -jar '+jar_compiler+' --js %s --js_output_file %s.min.js'
css_min_cmd = r'java -jar '+jar_yui+' %s -o %s.min.css'

def action(args):
    for fpath in args.files:
        fname, ftype = os.path.splitext(fpath)
        if ftype == '.js':
            os.system(js_min_cmd % (fpath, fname))
        elif ftype == '.css':
            os.system(css_min_cmd % (fpath, fname))

