import os
import sys

from meteor.compiler import Compiler
from meteor.util import copy2clipboard


help_msg = '''
Get base64 coding of a image

Usage:
    meteor inline file1 file2
    --all          It inline only resources with __inline__ by default, turn this on to inline all.
    --image        base64 Inline image as well.
    --raw          whether resources needs to be compressed
'''

def config(parser):
    parser.set_defaults(func=action)
    parser.add_argument('file', help='list of files to be processed')

def action(args):

    fpath = args.file

    if os.path.isfile(fpath):
        compiler = Compiler()
        copy2clipboard(compiler.base64image(open(fpath, 'rb').read(), fpath))
    else:
        pass
