﻿#-------------------------------------------------------------------------
# Copyright (c) Microsoft.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#--------------------------------------------------------------------------

# Warning: This code was generated by a tool.
# 
# Changes to this file may cause incorrect behavior and will be lost if the
# code is regenerated.

import json
import re
from requests import Session, Request
import time
try:
    from urllib import quote, unquote
except:
    from urllib.parse import quote, unquote
from azure.common import AzureHttpError
from azure.mgmt.common import AzureOperationResponse, OperationStatusResponse, OperationStatus, Service
from azure.mgmt.common.arm import ResourceBase, ResourceBaseExtended

class ComputeLongRunningOperationResponse(AzureOperationResponse):
    """
     The Compute service response for long-running operations.
    """
    
    def __init__(self, **kwargs):
        super(ComputeLongRunningOperationResponse, self).__init__(**kwargs)
        self._tracking_operation_id = kwargs.get('tracking_operation_id')
        self._status = kwargs.get('status')
        self._start_time = kwargs.get('start_time')
        self._end_time = kwargs.get('end_time')
        self._output = kwargs.get('output')
        self._error = kwargs.get('error')
    
    @property
    def end_time(self):
        """
         Gets the operation end time
        """
        return self._end_time
    
    @end_time.setter 
    def end_time(self, value):
        self._end_time = value
    
    @property
    def error(self):
        """
         Gets the operation error, if any occurred.
        """
        return self._error
    
    @error.setter 
    def error(self, value):
        self._error = value
    
    @property
    def output(self):
        """
         Operation output data (raw JSON)
        """
        return self._output
    
    @output.setter 
    def output(self, value):
        self._output = value
    
    @property
    def start_time(self):
        """
         Gets the operation start time
        """
        return self._start_time
    
    @start_time.setter 
    def start_time(self, value):
        self._start_time = value
    
    @property
    def status(self):
        """
         Gets the operation status.
        """
        return self._status
    
    @status.setter 
    def status(self, value):
        self._status = value
    
    @property
    def tracking_operation_id(self):
        """
         Gets the operation identifier.
        """
        return self._tracking_operation_id
    
    @tracking_operation_id.setter 
    def tracking_operation_id(self, value):
        self._tracking_operation_id = value

class AvailabilitySetGetResponse(AzureOperationResponse):
    """
     GET Availability Set operation response.
    """
    
    def __init__(self, **kwargs):
        super(AvailabilitySetGetResponse, self).__init__(**kwargs)
        self._availability_set = kwargs.get('availability_set')
    
    @property
    def availability_set(self):
        """
         Gets or sets the details of the Availability Set.
        """
        return self._availability_set
    
    @availability_set.setter 
    def availability_set(self, value):
        self._availability_set = value

class AvailabilitySetListResponse(AzureOperationResponse):
    """
     The List Availability Set operation response.
    """
    
    def __init__(self, **kwargs):
        super(AvailabilitySetListResponse, self).__init__(**kwargs)
        self._availability_sets = kwargs.get('availability_sets')
    
    @property
    def availability_sets(self):
        """
         Gets or sets the list of availability sets
        """
        return self._availability_sets
    
    @availability_sets.setter 
    def availability_sets(self, value):
        self._availability_sets = value

class VirtualMachineSizeListResponse(AzureOperationResponse):
    """
     The List Virtual Machine operation response.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineSizeListResponse, self).__init__(**kwargs)
        self._virtual_machine_sizes = kwargs.get('virtual_machine_sizes')
    
    @property
    def virtual_machine_sizes(self):
        """
         Gets or sets the list of virtual machine sizes.
        """
        return self._virtual_machine_sizes
    
    @virtual_machine_sizes.setter 
    def virtual_machine_sizes(self, value):
        self._virtual_machine_sizes = value

class AvailabilitySetCreateOrUpdateResponse(AzureOperationResponse):
    """
     The Create Availability Set operation response.
    """
    
    def __init__(self, **kwargs):
        super(AvailabilitySetCreateOrUpdateResponse, self).__init__(**kwargs)
        self._availability_set = kwargs.get('availability_set')
    
    @property
    def availability_set(self):
        """
         Gets or sets the details of the Availability Set.
        """
        return self._availability_set
    
    @availability_set.setter 
    def availability_set(self, value):
        self._availability_set = value

class AvailabilitySet(ResourceBaseExtended):
    """
     Create or update Availability Set parameters.
    """
    
    def __init__(self, **kwargs):
        super(AvailabilitySet, self).__init__(**kwargs)
        self._platform_update_domain_count = kwargs.get('platform_update_domain_count')
        self._platform_fault_domain_count = kwargs.get('platform_fault_domain_count')
        self._virtual_machines_references = kwargs.get('virtual_machines_references')
        self._statuses = kwargs.get('statuses')
    
    @property
    def platform_fault_domain_count(self):
        """
         Gets or sets Fault Domain count.
        """
        return self._platform_fault_domain_count
    
    @platform_fault_domain_count.setter 
    def platform_fault_domain_count(self, value):
        self._platform_fault_domain_count = value
    
    @property
    def platform_update_domain_count(self):
        """
         Gets or sets Update Domain count.
        """
        return self._platform_update_domain_count
    
    @platform_update_domain_count.setter 
    def platform_update_domain_count(self, value):
        self._platform_update_domain_count = value
    
    @property
    def statuses(self):
        """
         Gets or sets the resource status information.
        """
        return self._statuses
    
    @statuses.setter 
    def statuses(self, value):
        self._statuses = value
    
    @property
    def virtual_machines_references(self):
        """
         Gets or sets a list containing reference to all Virtual Machines
         created under this Availability Set.
        """
        return self._virtual_machines_references
    
    @virtual_machines_references.setter 
    def virtual_machines_references(self, value):
        self._virtual_machines_references = value

class VirtualMachineImageGetResponse(AzureOperationResponse):
    """
     The get vm image operation response.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineImageGetResponse, self).__init__(**kwargs)
        self._virtual_machine_image = kwargs.get('virtual_machine_image')
    
    @property
    def virtual_machine_image(self):
        """
         Gets the details of the Virtual Machine Image.
        """
        return self._virtual_machine_image
    
    @virtual_machine_image.setter 
    def virtual_machine_image(self, value):
        self._virtual_machine_image = value

class VirtualMachineImageListPublishersParameters(object):
    """
     Contains the parameters required to list publishers.
    """
    
    def __init__(self, **kwargs):
        self._location = kwargs.get('location')
    
    @property
    def location(self):
        """
         Location of the PIR, used for orchestration and required by CSM to
         direct request to appropriate PIR region. Example: westus, eastus.
        """
        return self._location
    
    @location.setter 
    def location(self, value):
        self._location = value

class VirtualMachineImageListOffersParameters(VirtualMachineImageListPublishersParameters):
    """
     Contains the parameters required to list offers.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineImageListOffersParameters, self).__init__(**kwargs)
        self._publisher_name = kwargs.get('publisher_name')
    
    @property
    def publisher_name(self):
        """
         Publisher identifier. For example: Microsoft.Windows or Canonical.
        """
        return self._publisher_name
    
    @publisher_name.setter 
    def publisher_name(self, value):
        self._publisher_name = value

class VirtualMachineImageListSkusParameters(VirtualMachineImageListOffersParameters):
    """
     Contains the parameters required to list skus.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineImageListSkusParameters, self).__init__(**kwargs)
        self._offer = kwargs.get('offer')
    
    @property
    def offer(self):
        """
         Unique identifier to distinguish an image. The vmImageName must be
         unique within publisher’s namespace. Example: WindowsServer2012
        """
        return self._offer
    
    @offer.setter 
    def offer(self, value):
        self._offer = value

class VirtualMachineImageListDetailsParameters(VirtualMachineImageListSkusParameters):
    """
     Contains the parameters required to list virtual machine images with
     details.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineImageListDetailsParameters, self).__init__(**kwargs)
        self._skus = kwargs.get('skus')
    
    @property
    def skus(self):
        """
         A distinct identifier for an item in image name. For example:
         DataCenter or Enterprise
        """
        return self._skus
    
    @skus.setter 
    def skus(self, value):
        self._skus = value

class VirtualMachineImageGetParameters(VirtualMachineImageListDetailsParameters):
    """
     Contains the parameters required to get a virtual machine image.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineImageGetParameters, self).__init__(**kwargs)
        self._version = kwargs.get('version')
    
    @property
    def version(self):
        """
         Unique version number that distinguish each monthly release of this
         product. The allowed characters are digit and period.Format:
         <MajorVersion>.<MinorVersion>Example: 1.0.0 or 1.1.0
        """
        return self._version
    
    @version.setter 
    def version(self, value):
        self._version = value

class VirtualMachineImageResourceList(AzureOperationResponse):
    """
     A list of virtual machine image resource information.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineImageResourceList, self).__init__(**kwargs)
        self._resources = kwargs.get('resources')
    
    @property
    def resources(self):
        """
         Gets a list of virtual machine image resources.
        """
        return self._resources
    
    @resources.setter 
    def resources(self, value):
        self._resources = value

class VirtualMachineImageListParameters(VirtualMachineImageListDetailsParameters):
    """
     Contains the parameters required to list virtual machine image versions.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineImageListParameters, self).__init__(**kwargs)
        self._filter_expression = kwargs.get('filter_expression')
    
    @property
    def filter_expression(self):
        """
         ODAta filter
         expression.https://msdn.microsoft.com/en-us/library/hh169248(v=nav.70).aspxSupported
         operatives: -eq -startswith Examples:    To list the all version that
         begin with 1.0 $filter=startswith(name, ‘1.0’)    To get the latest
         version $filter= name eq ‘latest’
        """
        return self._filter_expression
    
    @filter_expression.setter 
    def filter_expression(self, value):
        self._filter_expression = value

class VirtualMachineExtensionGetResponse(AzureOperationResponse):
    """
     The Get VM-Extension operation response.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineExtensionGetResponse, self).__init__(**kwargs)
        self._virtual_machine_extension = kwargs.get('virtual_machine_extension')
    
    @property
    def virtual_machine_extension(self):
        """
         Gets or sets details of the Virtual Machine extension.
        """
        return self._virtual_machine_extension
    
    @virtual_machine_extension.setter 
    def virtual_machine_extension(self, value):
        self._virtual_machine_extension = value

class ComputeOperationResponse(AzureOperationResponse):
    """
     The compute long running operation response.
    """
    
    def __init__(self, **kwargs):
        super(ComputeOperationResponse, self).__init__(**kwargs)
        self._azure_async_operation = kwargs.get('azure_async_operation')
    
    @property
    def azure_async_operation(self):
        """
         Gets or sets the the Azure Async Operation Uri.
        """
        return self._azure_async_operation
    
    @azure_async_operation.setter 
    def azure_async_operation(self, value):
        self._azure_async_operation = value

class VirtualMachineExtensionCreateOrUpdateResponse(ComputeOperationResponse):
    """
     The compute long running operation response.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineExtensionCreateOrUpdateResponse, self).__init__(**kwargs)
        self._virtual_machine_extension = kwargs.get('virtual_machine_extension')
    
    @property
    def virtual_machine_extension(self):
        """
         Gets or sets details of the Virtual Machine Extension.
        """
        return self._virtual_machine_extension
    
    @virtual_machine_extension.setter 
    def virtual_machine_extension(self, value):
        self._virtual_machine_extension = value

class VirtualMachineExtension(ResourceBaseExtended):
    """
     Describes a Virtual Machine Extension.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineExtension, self).__init__(**kwargs)
        self._publisher = kwargs.get('publisher')
        self._extension_type = kwargs.get('extension_type')
        self._type_handler_version = kwargs.get('type_handler_version')
        self._auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version')
        self._settings = kwargs.get('settings')
        self._protected_settings = kwargs.get('protected_settings')
        self._provisioning_state = kwargs.get('provisioning_state')
        self._instance_view = kwargs.get('instance_view')
    
    @property
    def auto_upgrade_minor_version(self):
        """
         Gets or sets whether the extension handler should be automatically
         upgraded across minor versions.
        """
        return self._auto_upgrade_minor_version
    
    @auto_upgrade_minor_version.setter 
    def auto_upgrade_minor_version(self, value):
        self._auto_upgrade_minor_version = value
    
    @property
    def extension_type(self):
        """
         Gets or sets the type of the extension handler.
        """
        return self._extension_type
    
    @extension_type.setter 
    def extension_type(self, value):
        self._extension_type = value
    
    @property
    def instance_view(self):
        """
         Gets or sets the virtual machine extension instance view.
        """
        return self._instance_view
    
    @instance_view.setter 
    def instance_view(self, value):
        self._instance_view = value
    
    @property
    def protected_settings(self):
        """
         Gets or sets Json formatted protected settings for the extension.
        """
        return self._protected_settings
    
    @protected_settings.setter 
    def protected_settings(self, value):
        self._protected_settings = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets the provisioning state, which only appears in the
         response.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def publisher(self):
        """
         Gets or sets the name of the extension handler publisher.
        """
        return self._publisher
    
    @publisher.setter 
    def publisher(self, value):
        self._publisher = value
    
    @property
    def settings(self):
        """
         Gets or sets Json formatted public settings for the extension.
        """
        return self._settings
    
    @settings.setter 
    def settings(self, value):
        self._settings = value
    
    @property
    def type_handler_version(self):
        """
         Gets or sets the type version of the extension handler.
        """
        return self._type_handler_version
    
    @type_handler_version.setter 
    def type_handler_version(self, value):
        self._type_handler_version = value

class VirtualMachineExtensionImageGetResponse(AzureOperationResponse):
    """
     The get virtual machine extension image operation response.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineExtensionImageGetResponse, self).__init__(**kwargs)
        self._virtual_machine_extension_image = kwargs.get('virtual_machine_extension_image')
    
    @property
    def virtual_machine_extension_image(self):
        """
         Gets the details of the Virtual Machine Extension Image.
        """
        return self._virtual_machine_extension_image
    
    @virtual_machine_extension_image.setter 
    def virtual_machine_extension_image(self, value):
        self._virtual_machine_extension_image = value

class VirtualMachineExtensionImageListTypesParameters(object):
    """
     Contains the parameteres required to list virtual machine extension image
     types.
    """
    
    def __init__(self, **kwargs):
        self._location = kwargs.get('location')
        self._publisher_name = kwargs.get('publisher_name')
    
    @property
    def location(self):
        """
         Location of the PIR, used for orchestration and required by CSM to
         direct request to appropriate PIR region. Example: westus, eastus.
        """
        return self._location
    
    @location.setter 
    def location(self, value):
        self._location = value
    
    @property
    def publisher_name(self):
        """
         Publisher identifier. For example: Microsoft.Windows or Canonical.
        """
        return self._publisher_name
    
    @publisher_name.setter 
    def publisher_name(self, value):
        self._publisher_name = value

class VirtualMachineExtensionImageListVersionsParameters(VirtualMachineExtensionImageListTypesParameters):
    """
     Contains the parameteres required to list virtual machine extension image
     versions.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineExtensionImageListVersionsParameters, self).__init__(**kwargs)
        self._type = kwargs.get('type')
        self._filter_expression = kwargs.get('filter_expression')
    
    @property
    def filter_expression(self):
        """
         ODAta filter
         expression.https://msdn.microsoft.com/en-us/library/hh169248(v=nav.70).aspxSupported
         operatives: -eq -startswith Examples:    To list the all version that
         begin with 1.0 $filter=startswith(name, ‘1.0’)    To get the latest
         version $filter= name eq ‘latest’
        """
        return self._filter_expression
    
    @filter_expression.setter 
    def filter_expression(self, value):
        self._filter_expression = value
    
    @property
    def type(self):
        """
         Unique (across the publisher) identifier to distinguish an extension
         for this publisher. Example: 'BGInfo' or 'VMAccess'.The allowed
         characters are uppercase or lowercase letters, digit, hypen(-),
         period (.)Dot or hyphen is not allowed the end of value. Max length
         is 64.
        """
        return self._type
    
    @type.setter 
    def type(self, value):
        self._type = value

class VirtualMachineExtensionImageGetParameters(VirtualMachineExtensionImageListVersionsParameters):
    """
     Contains the parameteres required to get a virtual machine extension image.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineExtensionImageGetParameters, self).__init__(**kwargs)
        self._version = kwargs.get('version')
    
    @property
    def version(self):
        """
         Unique version number that distinguish each monthly release of this
         product. The allowed characters are digit and period.Format:
         <MajorVersion>.<MinorVersion>Example: 1.0.0 or 1.1.0
        """
        return self._version
    
    @version.setter 
    def version(self, value):
        self._version = value

class ListUsagesResponse(AzureOperationResponse):
    """
     The List Usages operation response.
    """
    
    def __init__(self, **kwargs):
        super(ListUsagesResponse, self).__init__(**kwargs)
        self._usages = kwargs.get('usages')
    
    @property
    def usages(self):
        """
         Gets or sets the list Compute Resource Usages.
        """
        return self._usages
    
    @usages.setter 
    def usages(self, value):
        self._usages = value

class VirtualMachineCaptureParameters(object):
    """
     Capture Virtual Machine parameters.
    """
    
    def __init__(self, **kwargs):
        self._virtual_hard_disk_name_prefix = kwargs.get('virtual_hard_disk_name_prefix')
        self._destination_container_name = kwargs.get('destination_container_name')
        self._overwrite = kwargs.get('overwrite')
    
    @property
    def destination_container_name(self):
        """
         Gets or sets the destination container name.
        """
        return self._destination_container_name
    
    @destination_container_name.setter 
    def destination_container_name(self, value):
        self._destination_container_name = value
    
    @property
    def overwrite(self):
        """
         Gets or sets whether it overwrites destination VirtualHardDisk if
         true, in case of conflict.
        """
        return self._overwrite
    
    @overwrite.setter 
    def overwrite(self, value):
        self._overwrite = value
    
    @property
    def virtual_hard_disk_name_prefix(self):
        """
         Gets or sets the captured VirtualHardDisk's name prefix.
        """
        return self._virtual_hard_disk_name_prefix
    
    @virtual_hard_disk_name_prefix.setter 
    def virtual_hard_disk_name_prefix(self, value):
        self._virtual_hard_disk_name_prefix = value

class VirtualMachineCreateOrUpdateResponse(ComputeOperationResponse):
    """
     The Create Virtual Machine operation response.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineCreateOrUpdateResponse, self).__init__(**kwargs)
        self._virtual_machine = kwargs.get('virtual_machine')
    
    @property
    def virtual_machine(self):
        """
         Gets or sets details of the Virtual Machine.
        """
        return self._virtual_machine
    
    @virtual_machine.setter 
    def virtual_machine(self, value):
        self._virtual_machine = value

class VirtualMachine(ResourceBaseExtended):
    """
     Describes a Virtual Machine.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachine, self).__init__(**kwargs)
        self._plan = kwargs.get('plan')
        self._hardware_profile = kwargs.get('hardware_profile')
        self._storage_profile = kwargs.get('storage_profile')
        self._os_profile = kwargs.get('os_profile')
        self._network_profile = kwargs.get('network_profile')
        self._availability_set_reference = kwargs.get('availability_set_reference')
        self._provisioning_state = kwargs.get('provisioning_state')
        self._instance_view = kwargs.get('instance_view')
        self._extensions = kwargs.get('extensions')
    
    @property
    def availability_set_reference(self):
        """
         Gets or sets the reference Id of the availailbity set to which this
         virtual machine belongs.
        """
        return self._availability_set_reference
    
    @availability_set_reference.setter 
    def availability_set_reference(self, value):
        self._availability_set_reference = value
    
    @property
    def extensions(self):
        """
         Gets the virtual machine child extension resources.
        """
        return self._extensions
    
    @extensions.setter 
    def extensions(self, value):
        self._extensions = value
    
    @property
    def hardware_profile(self):
        """
         Gets or sets the hardware profile.
        """
        return self._hardware_profile
    
    @hardware_profile.setter 
    def hardware_profile(self, value):
        self._hardware_profile = value
    
    @property
    def instance_view(self):
        """
         Gets the virtual machine instance view.
        """
        return self._instance_view
    
    @instance_view.setter 
    def instance_view(self, value):
        self._instance_view = value
    
    @property
    def network_profile(self):
        """
         Gets or sets the network profile.
        """
        return self._network_profile
    
    @network_profile.setter 
    def network_profile(self, value):
        self._network_profile = value
    
    @property
    def os_profile(self):
        """
         Gets or sets the OS profile.
        """
        return self._os_profile
    
    @os_profile.setter 
    def os_profile(self, value):
        self._os_profile = value
    
    @property
    def plan(self):
        """
         Gets or sets the purchase plan when deploying virtual machine from VM
         Marketplace images.
        """
        return self._plan
    
    @plan.setter 
    def plan(self, value):
        self._plan = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets the provisioning state, which only appears in the
         response.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def storage_profile(self):
        """
         Gets or sets the storage profile.
        """
        return self._storage_profile
    
    @storage_profile.setter 
    def storage_profile(self, value):
        self._storage_profile = value

class VirtualMachineGetResponse(AzureOperationResponse):
    """
     The GetVM operation response.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineGetResponse, self).__init__(**kwargs)
        self._virtual_machine = kwargs.get('virtual_machine')
    
    @property
    def virtual_machine(self):
        """
         Gets or sets the details of the Virtual Machine.
        """
        return self._virtual_machine
    
    @virtual_machine.setter 
    def virtual_machine(self, value):
        self._virtual_machine = value

class VirtualMachineListResponse(AzureOperationResponse):
    """
     The List Virtual Machine operation response.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineListResponse, self).__init__(**kwargs)
        self._virtual_machines = kwargs.get('virtual_machines')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets or sets the uri to fetch the next page of VMs. Call ListNext()
         with this to fetch the next page of Virtual Machines.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def virtual_machines(self):
        """
         Gets or sets the list of virtual machines.
        """
        return self._virtual_machines
    
    @virtual_machines.setter 
    def virtual_machines(self, value):
        self._virtual_machines = value

class ListParameters(object):
    """
     Specifies the parameters to be passed to List APIs.
    """
    
    def __init__(self, **kwargs):
        pass
    
class ComputeOperationStatus(object):
    """
     The operation status.
    """
    in_progress = "InProgress"
    failed = "Failed"
    succeeded = "Succeeded"
    preempted = "Preempted"

class ApiErrorBase(object):
    """
     Api error base.
    """
    
    def __init__(self, **kwargs):
        self._code = kwargs.get('code')
        self._target = kwargs.get('target')
        self._message = kwargs.get('message')
    
    @property
    def code(self):
        """
         Gets or sets the error code.
        """
        return self._code
    
    @code.setter 
    def code(self, value):
        self._code = value
    
    @property
    def message(self):
        """
         Gets or sets the error message.
        """
        return self._message
    
    @message.setter 
    def message(self, value):
        self._message = value
    
    @property
    def target(self):
        """
         Gets or sets the target of the particular error.
        """
        return self._target
    
    @target.setter 
    def target(self, value):
        self._target = value

class ApiError(ApiErrorBase):
    """
     Api error.
    """
    
    def __init__(self, **kwargs):
        super(ApiError, self).__init__(**kwargs)
        self._details = kwargs.get('details')
        self._inner_error = kwargs.get('inner_error')
    
    @property
    def details(self):
        """
         Gets or sets the Api error details
        """
        return self._details
    
    @details.setter 
    def details(self, value):
        self._details = value
    
    @property
    def inner_error(self):
        """
         Gets or sets the Api inner error
        """
        return self._inner_error
    
    @inner_error.setter 
    def inner_error(self, value):
        self._inner_error = value

class InnerError(object):
    """
     Inner error details.
    """
    
    def __init__(self, **kwargs):
        self._exception_type = kwargs.get('exception_type')
        self._error_detail = kwargs.get('error_detail')
    
    @property
    def error_detail(self):
        """
         Gets or sets the internal error message or exception dump.
        """
        return self._error_detail
    
    @error_detail.setter 
    def error_detail(self, value):
        self._error_detail = value
    
    @property
    def exception_type(self):
        """
         Gets or sets the exception type.
        """
        return self._exception_type
    
    @exception_type.setter 
    def exception_type(self, value):
        self._exception_type = value

class VirtualMachineSize(object):
    """
     Describes the properties of a VM size.
    """
    
    def __init__(self, **kwargs):
        self._name = kwargs.get('name')
        self._number_of_cores = kwargs.get('number_of_cores')
        self._os_disk_size_in_mb = kwargs.get('os_disk_size_in_mb')
        self._resource_disk_size_in_mb = kwargs.get('resource_disk_size_in_mb')
        self._memory_in_mb = kwargs.get('memory_in_mb')
        self._max_data_disk_count = kwargs.get('max_data_disk_count')
    
    @property
    def max_data_disk_count(self):
        """
         Gets or sets the Maximum number of data disks allowed by a VM size.
        """
        return self._max_data_disk_count
    
    @max_data_disk_count.setter 
    def max_data_disk_count(self, value):
        self._max_data_disk_count = value
    
    @property
    def memory_in_mb(self):
        """
         Gets or sets the Memory size supported by a VM size.
        """
        return self._memory_in_mb
    
    @memory_in_mb.setter 
    def memory_in_mb(self, value):
        self._memory_in_mb = value
    
    @property
    def name(self):
        """
         Gets or sets the VM size name.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def number_of_cores(self):
        """
         Gets or sets the Number of cores supported by a VM size.
        """
        return self._number_of_cores
    
    @number_of_cores.setter 
    def number_of_cores(self, value):
        self._number_of_cores = value
    
    @property
    def os_disk_size_in_mb(self):
        """
         Gets or sets the OS disk size allowed by a VM size.
        """
        return self._os_disk_size_in_mb
    
    @os_disk_size_in_mb.setter 
    def os_disk_size_in_mb(self, value):
        self._os_disk_size_in_mb = value
    
    @property
    def resource_disk_size_in_mb(self):
        """
         Gets or sets the Resource disk size allowed by a VM size.
        """
        return self._resource_disk_size_in_mb
    
    @resource_disk_size_in_mb.setter 
    def resource_disk_size_in_mb(self, value):
        self._resource_disk_size_in_mb = value

class ApiEntityReference(object):
    """
     The API entity reference.
    """
    
    def __init__(self, **kwargs):
        self._reference_uri = kwargs.get('reference_uri')
    
    @property
    def reference_uri(self):
        """
         Gets or sets the relative URL in the previous Service Management API's
         namespace. For Example:
         /subscriptions/{SubcriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        return self._reference_uri
    
    @reference_uri.setter 
    def reference_uri(self, value):
        self._reference_uri = value

class VirtualMachineReference(ApiEntityReference):
    """
     Describes a virtual machine reference.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineReference, self).__init__(**kwargs)
    
class AvailabilitySetReference(ApiEntityReference):
    """
     Describes an availability set reference.
    """
    
    def __init__(self, **kwargs):
        super(AvailabilitySetReference, self).__init__(**kwargs)
    
class NetworkInterfaceReference(ApiEntityReference):
    """
     Describes a network interface reference.
    """
    
    def __init__(self, **kwargs):
        super(NetworkInterfaceReference, self).__init__(**kwargs)
        self._primary = kwargs.get('primary')
    
    @property
    def primary(self):
        """
         Gets or sets whether this is a primary NIC on a virtual machine
        """
        return self._primary
    
    @primary.setter 
    def primary(self, value):
        self._primary = value

class SourceImageReference(ApiEntityReference):
    """
     The source image reference.
    """
    
    def __init__(self, **kwargs):
        super(SourceImageReference, self).__init__(**kwargs)
    
class SourceVaultReference(ApiEntityReference):
    """
     Contains a Source Key Vault relative URL.
    """
    
    def __init__(self, **kwargs):
        super(SourceVaultReference, self).__init__(**kwargs)
    
class InstanceViewStatus(object):
    """
     Instance view status.
    """
    
    def __init__(self, **kwargs):
        self._code = kwargs.get('code')
        self._level = kwargs.get('level')
        self._display_status = kwargs.get('display_status')
        self._message = kwargs.get('message')
        self._time = kwargs.get('time')
    
    @property
    def code(self):
        """
         Gets or sets the status Code.
        """
        return self._code
    
    @code.setter 
    def code(self, value):
        self._code = value
    
    @property
    def display_status(self):
        """
         Gets or sets the short localizable label for the status.
        """
        return self._display_status
    
    @display_status.setter 
    def display_status(self, value):
        self._display_status = value
    
    @property
    def level(self):
        """
         Gets or sets the level Code.
        """
        return self._level
    
    @level.setter 
    def level(self, value):
        self._level = value
    
    @property
    def message(self):
        """
         Gets or sets the optional detailed Message, including for alerts and
         error messages.
        """
        return self._message
    
    @message.setter 
    def message(self, value):
        self._message = value
    
    @property
    def time(self):
        """
         Gets or sets the time of the status.
        """
        return self._time
    
    @time.setter 
    def time(self, value):
        self._time = value

class StatusLevelTypes(object):
    """
     The Level of the status.
    """
    info = 'Info'
    warning = 'Warning'
    error = 'Error'

class VirtualMachineImageResource(object):
    """
     Virtual machine image resource information.
    """
    
    def __init__(self, **kwargs):
        self._id = kwargs.get('id')
        self._name = kwargs.get('name')
        self._location = kwargs.get('location')
    
    @property
    def id(self):
        """
         Gets or sets the ID of the artifact.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def location(self):
        """
         Gets or sets the location of the resource.
        """
        return self._location
    
    @location.setter 
    def location(self, value):
        self._location = value
    
    @property
    def name(self):
        """
         Gets or sets the name of the resource.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value

class VirtualMachineImage(VirtualMachineImageResource):
    """
     Describes a Virtual Machine Image.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineImage, self).__init__(**kwargs)
        self._purchase_plan = kwargs.get('purchase_plan')
        self._os_disk_image = kwargs.get('os_disk_image')
        self._data_disk_images = kwargs.get('data_disk_images')
    
    @property
    def data_disk_images(self):
        return self._data_disk_images
    
    @data_disk_images.setter 
    def data_disk_images(self, value):
        self._data_disk_images = value
    
    @property
    def os_disk_image(self):
        return self._os_disk_image
    
    @os_disk_image.setter 
    def os_disk_image(self, value):
        self._os_disk_image = value
    
    @property
    def purchase_plan(self):
        return self._purchase_plan
    
    @purchase_plan.setter 
    def purchase_plan(self, value):
        self._purchase_plan = value

class PurchasePlan(object):
    """
     Used for establishing the purchase context of any 3rd Party artifact
     through MarketPlace.
    """
    
    def __init__(self, **kwargs):
        self._publisher = kwargs.get('publisher')
        self._name = kwargs.get('name')
        self._product = kwargs.get('product')
    
    @property
    def name(self):
        """
         Gets or sets the plan ID.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def product(self):
        """
         Gets or sets the product ID.
        """
        return self._product
    
    @product.setter 
    def product(self, value):
        self._product = value
    
    @property
    def publisher(self):
        """
         Gets or sets the publisher ID.
        """
        return self._publisher
    
    @publisher.setter 
    def publisher(self, value):
        self._publisher = value

class OSDiskImage(object):
    """
     Contains the os disk image information.
    """
    
    def __init__(self, **kwargs):
        self._operating_system = kwargs.get('operating_system')
    
    @property
    def operating_system(self):
        """
         Gets or sets the operating system of the osDiskImage.
        """
        return self._operating_system
    
    @operating_system.setter 
    def operating_system(self, value):
        self._operating_system = value

class OperatingSystemTypes(object):
    """
     The Operating System type.
    """
    windows = 'Windows'
    linux = 'Linux'

class DataDiskImage(object):
    """
     Contains the data disk images information.
    """
    
    def __init__(self, **kwargs):
        self._lun = kwargs.get('lun')
    
    @property
    def lun(self):
        """
         Gets the LUN number for a data disk.This value is used to identify
         data disk image inside the VMImage therefore it must be unique for
         each data disk.The allowed character for the value is digit.
        """
        return self._lun
    
    @lun.setter 
    def lun(self, value):
        self._lun = value

class VirtualMachineExtensionImage(VirtualMachineImageResource):
    """
     Describes a Virtual Machine Extension Image.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineExtensionImage, self).__init__(**kwargs)
        self._operating_system = kwargs.get('operating_system')
        self._compute_role = kwargs.get('compute_role')
        self._handler_schema = kwargs.get('handler_schema')
        self._vm_scale_set_enabled = kwargs.get('vm_scale_set_enabled')
        self._supports_multiple_extensions = kwargs.get('supports_multiple_extensions')
    
    @property
    def compute_role(self):
        """
         Gets or sets the type of role (IaaS or PaaS) this extension supports.
        """
        return self._compute_role
    
    @compute_role.setter 
    def compute_role(self, value):
        self._compute_role = value
    
    @property
    def handler_schema(self):
        """
         Gets or sets the schema defined by publisher, where extension
         consumers should provide settings in a matching schema.
        """
        return self._handler_schema
    
    @handler_schema.setter 
    def handler_schema(self, value):
        self._handler_schema = value
    
    @property
    def operating_system(self):
        """
         Gets or sets the operating system this extension supports.
        """
        return self._operating_system
    
    @operating_system.setter 
    def operating_system(self, value):
        self._operating_system = value
    
    @property
    def supports_multiple_extensions(self):
        """
         Gets or sets whether the handler can support multiple extensions.
        """
        return self._supports_multiple_extensions
    
    @supports_multiple_extensions.setter 
    def supports_multiple_extensions(self, value):
        self._supports_multiple_extensions = value
    
    @property
    def vm_scale_set_enabled(self):
        """
         Gets or sets whether the extension can be used on xRP VMScaleSets.By
         default existing extensions are usable on scalesets, but there might
         be cases where a publisher wants to explicitly indicate the extension
         is only enabled for CRP VMs but not VMSS.
        """
        return self._vm_scale_set_enabled
    
    @vm_scale_set_enabled.setter 
    def vm_scale_set_enabled(self, value):
        self._vm_scale_set_enabled = value

class ResourceInstanceView(object):
    """
     The instance view of a resource.
    """
    
    def __init__(self, **kwargs):
        self._statuses = kwargs.get('statuses')
    
    @property
    def statuses(self):
        """
         Gets or sets the resource status information.
        """
        return self._statuses
    
    @statuses.setter 
    def statuses(self, value):
        self._statuses = value

class VirtualMachineExtensionInstanceView(ResourceInstanceView):
    """
     The instance view of a virtual machine extension.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineExtensionInstanceView, self).__init__(**kwargs)
        self._name = kwargs.get('name')
        self._extension_type = kwargs.get('extension_type')
        self._type_handler_version = kwargs.get('type_handler_version')
        self._sub_statuses = kwargs.get('sub_statuses')
    
    @property
    def extension_type(self):
        """
         Gets or sets the full type of the extension handler which includes
         both publisher and type.
        """
        return self._extension_type
    
    @extension_type.setter 
    def extension_type(self, value):
        self._extension_type = value
    
    @property
    def name(self):
        """
         Gets or sets the virtual machine extension name.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def sub_statuses(self):
        """
         Gets or sets the resource status information.
        """
        return self._sub_statuses
    
    @sub_statuses.setter 
    def sub_statuses(self, value):
        self._sub_statuses = value
    
    @property
    def type_handler_version(self):
        """
         Gets or sets the type version of the extension handler.
        """
        return self._type_handler_version
    
    @type_handler_version.setter 
    def type_handler_version(self, value):
        self._type_handler_version = value

class DiskInstanceView(ResourceInstanceView):
    """
     The instance view of the disk.
    """
    
    def __init__(self, **kwargs):
        super(DiskInstanceView, self).__init__(**kwargs)
        self._name = kwargs.get('name')
    
    @property
    def name(self):
        """
         Gets or sets the disk name.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value

class VirtualMachineInstanceView(ResourceInstanceView):
    """
     The instance view of a virtual machine.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineInstanceView, self).__init__(**kwargs)
        self._platform_update_domain = kwargs.get('platform_update_domain')
        self._platform_fault_domain = kwargs.get('platform_fault_domain')
        self._remote_desktop_thumbprint = kwargs.get('remote_desktop_thumbprint')
        self._vm_agent = kwargs.get('vm_agent')
        self._disks = kwargs.get('disks')
        self._extensions = kwargs.get('extensions')
    
    @property
    def disks(self):
        """
         Gets or sets the the disks information.
        """
        return self._disks
    
    @disks.setter 
    def disks(self, value):
        self._disks = value
    
    @property
    def extensions(self):
        """
         Gets or sets the extensions information.
        """
        return self._extensions
    
    @extensions.setter 
    def extensions(self, value):
        self._extensions = value
    
    @property
    def platform_fault_domain(self):
        """
         Gets or sets the Fault Domain count.
        """
        return self._platform_fault_domain
    
    @platform_fault_domain.setter 
    def platform_fault_domain(self, value):
        self._platform_fault_domain = value
    
    @property
    def platform_update_domain(self):
        """
         Gets or sets the Update Domain count.
        """
        return self._platform_update_domain
    
    @platform_update_domain.setter 
    def platform_update_domain(self, value):
        self._platform_update_domain = value
    
    @property
    def remote_desktop_thumbprint(self):
        """
         Gets or sets the Remote desktop certificate thumbprint.
        """
        return self._remote_desktop_thumbprint
    
    @remote_desktop_thumbprint.setter 
    def remote_desktop_thumbprint(self, value):
        self._remote_desktop_thumbprint = value
    
    @property
    def vm_agent(self):
        """
         Gets or sets the VM Agent running on the virtual machine.
        """
        return self._vm_agent
    
    @vm_agent.setter 
    def vm_agent(self, value):
        self._vm_agent = value

class VirtualMachineAgentInstanceView(ResourceInstanceView):
    """
     The instance view of the VM Agent running on the virtual machine.
    """
    
    def __init__(self, **kwargs):
        super(VirtualMachineAgentInstanceView, self).__init__(**kwargs)
        self._vm_agent_version = kwargs.get('vm_agent_version')
        self._extension_handlers = kwargs.get('extension_handlers')
    
    @property
    def extension_handlers(self):
        """
         Gets or sets the virtual machine extension handler instance view.
        """
        return self._extension_handlers
    
    @extension_handlers.setter 
    def extension_handlers(self, value):
        self._extension_handlers = value
    
    @property
    def vm_agent_version(self):
        """
         Gets or sets the VM Agent full version.
        """
        return self._vm_agent_version
    
    @vm_agent_version.setter 
    def vm_agent_version(self, value):
        self._vm_agent_version = value

class VirtualMachineExtensionHandlerInstanceView(object):
    """
     The instance view of a virtual machine extension handler.
    """
    
    def __init__(self, **kwargs):
        self._type = kwargs.get('type')
        self._type_handler_version = kwargs.get('type_handler_version')
        self._status = kwargs.get('status')
    
    @property
    def status(self):
        """
         Gets or sets the extension handler status.
        """
        return self._status
    
    @status.setter 
    def status(self, value):
        self._status = value
    
    @property
    def type(self):
        """
         Gets or sets full type of the extension handler which includes both
         publisher and type.
        """
        return self._type
    
    @type.setter 
    def type(self, value):
        self._type = value
    
    @property
    def type_handler_version(self):
        """
         Gets or sets the type version of the extension handler.
        """
        return self._type_handler_version
    
    @type_handler_version.setter 
    def type_handler_version(self, value):
        self._type_handler_version = value

class Plan(object):
    """
     Plan for the resource.
    """
    
    def __init__(self, **kwargs):
        self._name = kwargs.get('name')
        self._publisher = kwargs.get('publisher')
        self._product = kwargs.get('product')
        self._promotion_code = kwargs.get('promotion_code')
    
    @property
    def name(self):
        """
         Gets or sets the plan ID.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def product(self):
        """
         Gets or sets the offer ID.
        """
        return self._product
    
    @product.setter 
    def product(self, value):
        self._product = value
    
    @property
    def promotion_code(self):
        """
         Gets or sets the promotion code.
        """
        return self._promotion_code
    
    @promotion_code.setter 
    def promotion_code(self, value):
        self._promotion_code = value
    
    @property
    def publisher(self):
        """
         Gets or sets the publisher ID.
        """
        return self._publisher
    
    @publisher.setter 
    def publisher(self, value):
        self._publisher = value

class HardwareProfile(object):
    """
     Describes a hardware profile.
    """
    
    def __init__(self, **kwargs):
        self._virtual_machine_size = kwargs.get('virtual_machine_size')
    
    @property
    def virtual_machine_size(self):
        """
         The virtual machine size name.
        """
        return self._virtual_machine_size
    
    @virtual_machine_size.setter 
    def virtual_machine_size(self, value):
        self._virtual_machine_size = value

class VirtualMachineSizeTypes(object):
    """
     The virtual machine size.
    """
    basic_a0 = 'Basic_A0'
    basic_a1 = 'Basic_A1'
    basic_a2 = 'Basic_A2'
    basic_a3 = 'Basic_A3'
    basic_a4 = 'Basic_A4'
    standard_a0 = 'Standard_A0'
    standard_a1 = 'Standard_A1'
    standard_a2 = 'Standard_A2'
    standard_a3 = 'Standard_A3'
    standard_a4 = 'Standard_A4'
    standard_a5 = 'Standard_A5'
    standard_a6 = 'Standard_A6'
    standard_a7 = 'Standard_A7'
    standard_a8 = 'Standard_A8'
    standard_a9 = 'Standard_A9'
    standard_g1 = 'Standard_G1'
    standard_g2 = 'Standard_G2'
    standard_g3 = 'Standard_G3'
    standard_g4 = 'Standard_G4'
    standard_g5 = 'Standard_G5'

class StorageProfile(object):
    """
     Describes a storage profile.
    """
    
    def __init__(self, **kwargs):
        self._image_reference = kwargs.get('image_reference')
        self._source_image = kwargs.get('source_image')
        self._os_disk = kwargs.get('os_disk')
        self._data_disks = kwargs.get('data_disks')
    
    @property
    def data_disks(self):
        """
         Gets or sets the data disks.
        """
        return self._data_disks
    
    @data_disks.setter 
    def data_disks(self, value):
        self._data_disks = value
    
    @property
    def image_reference(self):
        """
         Gets or sets the image reference.
        """
        return self._image_reference
    
    @image_reference.setter 
    def image_reference(self, value):
        self._image_reference = value
    
    @property
    def os_disk(self):
        """
         Gets or sets the OS disk.
        """
        return self._os_disk
    
    @os_disk.setter 
    def os_disk(self, value):
        self._os_disk = value
    
    @property
    def source_image(self):
        """
         Gets or sets the source image reference.
        """
        return self._source_image
    
    @source_image.setter 
    def source_image(self, value):
        self._source_image = value

class ImageReference(object):
    """
     The image reference.
    """
    
    def __init__(self, **kwargs):
        self._publisher = kwargs.get('publisher')
        self._offer = kwargs.get('offer')
        self._sku = kwargs.get('sku')
        self._version = kwargs.get('version')
    
    @property
    def offer(self):
        """
         Gets or sets the image offer.
        """
        return self._offer
    
    @offer.setter 
    def offer(self, value):
        self._offer = value
    
    @property
    def publisher(self):
        """
         Gets or sets the image publisher.
        """
        return self._publisher
    
    @publisher.setter 
    def publisher(self, value):
        self._publisher = value
    
    @property
    def sku(self):
        """
         Gets or sets the image sku.
        """
        return self._sku
    
    @sku.setter 
    def sku(self, value):
        self._sku = value
    
    @property
    def version(self):
        """
         Gets or sets the image version. The allowed formats are
         Major.Minor.Build or 'latest'. Major, Minor and Build being decimal
         numbers. Specify 'latest' to use the latest version of image.
        """
        return self._version
    
    @version.setter 
    def version(self, value):
        self._version = value

class Disk(object):
    """
     Describes a disk.
    """
    
    def __init__(self, **kwargs):
        self._name = kwargs.get('name')
        self._virtual_hard_disk = kwargs.get('virtual_hard_disk')
        self._source_image = kwargs.get('source_image')
        self._caching = kwargs.get('caching')
        self._create_option = kwargs.get('create_option')
    
    @property
    def caching(self):
        """
         Gets or sets the caching type.
        """
        return self._caching
    
    @caching.setter 
    def caching(self, value):
        self._caching = value
    
    @property
    def create_option(self):
        """
         Gets or sets the create option.
        """
        return self._create_option
    
    @create_option.setter 
    def create_option(self, value):
        self._create_option = value
    
    @property
    def name(self):
        """
         Gets or sets the disk name.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def source_image(self):
        """
         Gets or sets the Source User Image VirtualHardDisk. This
         VirtualHardDisk will be copied before using it to attach to the
         Virtual Machine.If SourceImage is provided, the destination
         VirtualHardDisk should not exist.
        """
        return self._source_image
    
    @source_image.setter 
    def source_image(self, value):
        self._source_image = value
    
    @property
    def virtual_hard_disk(self):
        """
         Gets or sets the Virtual Hard Disk.
        """
        return self._virtual_hard_disk
    
    @virtual_hard_disk.setter 
    def virtual_hard_disk(self, value):
        self._virtual_hard_disk = value

class OSDisk(Disk):
    """
     Describes an Operating System disk.
    """
    
    def __init__(self, **kwargs):
        super(OSDisk, self).__init__(**kwargs)
        self._operating_system_type = kwargs.get('operating_system_type')
    
    @property
    def operating_system_type(self):
        """
         Gets or sets the Operating System type.
        """
        return self._operating_system_type
    
    @operating_system_type.setter 
    def operating_system_type(self, value):
        self._operating_system_type = value

class DataDisk(Disk):
    """
     Describes a data disk.
    """
    
    def __init__(self, **kwargs):
        super(DataDisk, self).__init__(**kwargs)
        self._lun = kwargs.get('lun')
        self._disk_size_gb = kwargs.get('disk_size_gb')
    
    @property
    def disk_size_gb(self):
        """
         Gets or sets the disk size in GB for a blank data disk to be created.
        """
        return self._disk_size_gb
    
    @disk_size_gb.setter 
    def disk_size_gb(self, value):
        self._disk_size_gb = value
    
    @property
    def lun(self):
        """
         Gets or sets the logical unit number.
        """
        return self._lun
    
    @lun.setter 
    def lun(self, value):
        self._lun = value

class VirtualHardDisk(object):
    """
     Describes the uri of a disk.
    """
    
    def __init__(self, **kwargs):
        self._uri = kwargs.get('uri')
    
    @property
    def uri(self):
        """
         Gets or sets the virtual hard disk's uri. It should be a valid Uri to
         a virtual hard disk.
        """
        return self._uri
    
    @uri.setter 
    def uri(self, value):
        self._uri = value

class CachingTypes(object):
    """
     The caching types of OS or data disk.
    """
    none = 'None'
    read_only = 'ReadOnly'
    read_write = 'ReadWrite'

class DiskCreateOptionTypes(object):
    """
     The create options for disks.
    """
    from_image = 'fromImage'
    empty = 'empty'
    attach = 'attach'

class OSProfile(object):
    """
     Describes an OS profile.
    """
    
    def __init__(self, **kwargs):
        self._computer_name = kwargs.get('computer_name')
        self._admin_username = kwargs.get('admin_username')
        self._admin_password = kwargs.get('admin_password')
        self._custom_data = kwargs.get('custom_data')
        self._windows_configuration = kwargs.get('windows_configuration')
        self._linux_configuration = kwargs.get('linux_configuration')
        self._secrets = kwargs.get('secrets')
    
    @property
    def admin_password(self):
        """
         Gets or sets the admin user password.
        """
        return self._admin_password
    
    @admin_password.setter 
    def admin_password(self, value):
        self._admin_password = value
    
    @property
    def admin_username(self):
        """
         Gets or sets the admin user name.
        """
        return self._admin_username
    
    @admin_username.setter 
    def admin_username(self, value):
        self._admin_username = value
    
    @property
    def computer_name(self):
        """
         Gets or sets the computer name.
        """
        return self._computer_name
    
    @computer_name.setter 
    def computer_name(self, value):
        self._computer_name = value
    
    @property
    def custom_data(self):
        """
         Gets or sets a base-64 encoded string of custom data.
        """
        return self._custom_data
    
    @custom_data.setter 
    def custom_data(self, value):
        self._custom_data = value
    
    @property
    def linux_configuration(self):
        """
         Gets or sets the Linux Configuration of the OS profile.
        """
        return self._linux_configuration
    
    @linux_configuration.setter 
    def linux_configuration(self, value):
        self._linux_configuration = value
    
    @property
    def secrets(self):
        """
         Gets or sets the List of certificates for addition to the VM.
        """
        return self._secrets
    
    @secrets.setter 
    def secrets(self, value):
        self._secrets = value
    
    @property
    def windows_configuration(self):
        """
         Gets or sets the Windows Configuration of the OS profile.
        """
        return self._windows_configuration
    
    @windows_configuration.setter 
    def windows_configuration(self, value):
        self._windows_configuration = value

class WindowsConfiguration(object):
    """
     Describes Windows Configuration of the OS Profile.
    """
    
    def __init__(self, **kwargs):
        self._provision_vm_agent = kwargs.get('provision_vm_agent')
        self._enable_automatic_updates = kwargs.get('enable_automatic_updates')
        self._time_zone = kwargs.get('time_zone')
        self._additional_unattend_contents = kwargs.get('additional_unattend_contents')
        self._win_rm_configuration = kwargs.get('win_rm_configuration')
    
    @property
    def additional_unattend_contents(self):
        """
         Gets or sets the additional base-64 encoded XML formatted information
         that can be included in the Unattend.xml file.
        """
        return self._additional_unattend_contents
    
    @additional_unattend_contents.setter 
    def additional_unattend_contents(self, value):
        self._additional_unattend_contents = value
    
    @property
    def enable_automatic_updates(self):
        """
         Gets or sets whether Windows updates are automatically installed on
         the VM
        """
        return self._enable_automatic_updates
    
    @enable_automatic_updates.setter 
    def enable_automatic_updates(self, value):
        self._enable_automatic_updates = value
    
    @property
    def provision_vm_agent(self):
        """
         Gets or sets whether VM Agent should be provisioned on the Virtual
         Machine.
        """
        return self._provision_vm_agent
    
    @provision_vm_agent.setter 
    def provision_vm_agent(self, value):
        self._provision_vm_agent = value
    
    @property
    def time_zone(self):
        """
         Gets or sets the Time Zone of the VM
        """
        return self._time_zone
    
    @time_zone.setter 
    def time_zone(self, value):
        self._time_zone = value
    
    @property
    def win_rm_configuration(self):
        """
         Gets or sets the Windows Remote Management configuration of the VM
        """
        return self._win_rm_configuration
    
    @win_rm_configuration.setter 
    def win_rm_configuration(self, value):
        self._win_rm_configuration = value

class AdditionalUnattendContent(object):
    """
     Gets or sets additional XML formatted information that can be included in
     the Unattend.xml file, which is used by Windows Setup. Contents are
     defined by setting name, component name, and the pass in which the
     content is a applied.
    """
    
    def __init__(self, **kwargs):
        self._pass_name = kwargs.get('pass_name')
        self._component_name = kwargs.get('component_name')
        self._setting_name = kwargs.get('setting_name')
        self._content = kwargs.get('content')
    
    @property
    def component_name(self):
        """
         Gets or sets the component name. Currently, the only allowable value
         is Microsoft-Windows-Shell-Setup.
        """
        return self._component_name
    
    @component_name.setter 
    def component_name(self, value):
        self._component_name = value
    
    @property
    def content(self):
        """
         Gets or sets XML formatted content that is added to the unattend.xml
         file in the specified pass and component.The XML must be less than 4
         KB and must include the root element for the setting or feature that
         is being inserted.
        """
        return self._content
    
    @content.setter 
    def content(self, value):
        self._content = value
    
    @property
    def pass_name(self):
        """
         Gets or sets the pass name. Currently, the only allowable value is
         oobeSystem.
        """
        return self._pass_name
    
    @pass_name.setter 
    def pass_name(self, value):
        self._pass_name = value
    
    @property
    def setting_name(self):
        """
         Gets or sets setting name (e.g. FirstLogonCommands, AutoLogon )
        """
        return self._setting_name
    
    @setting_name.setter 
    def setting_name(self, value):
        self._setting_name = value

class PassNames(object):
    """
     Pass names supported by AdditionalUnattendContent.
    """
    oobe_system = 'oobeSystem'

class ComponentNames(object):
    """
     Component names supported by AdditionalUnattendContent.
    """
    microsoft_windows_shell_setup = 'Microsoft-Windows-Shell-Setup'

class SettingNames(object):
    """
     Setting names supported by AdditionalUnattendContent.
    """
    auto_logon = 'AutoLogon'
    first_logon_commands = 'FirstLogonCommands'

class WinRMConfiguration(object):
    """
     Describes Windows Remote Management configuration of the VM
    """
    
    def __init__(self, **kwargs):
        self._listeners = kwargs.get('listeners')
    
    @property
    def listeners(self):
        """
         Gets or sets the list of Windows Remote Management listeners
        """
        return self._listeners
    
    @listeners.setter 
    def listeners(self, value):
        self._listeners = value

class WinRMListener(object):
    """
     Describes Protocol and thumbprint of Windows Remote Management listener
    """
    
    def __init__(self, **kwargs):
        self._protocol = kwargs.get('protocol')
        self._certificate_url = kwargs.get('certificate_url')
    
    @property
    def certificate_url(self):
        """
         Gets or sets the Certificate URL in KMS for Https listeners. Should be
         null for Http listeners.
        """
        return self._certificate_url
    
    @certificate_url.setter 
    def certificate_url(self, value):
        self._certificate_url = value
    
    @property
    def protocol(self):
        """
         Gets or sets the Protocol used by WinRM listener. Currently only Http
         and Https are supported.
        """
        return self._protocol
    
    @protocol.setter 
    def protocol(self, value):
        self._protocol = value

class ProtocolTypes(object):
    """
     The Operating System type.
    """
    http = 'Http'
    https = 'Https'

class LinuxConfiguration(object):
    """
     Describes Windows Configuration of the OS Profile.
    """
    
    def __init__(self, **kwargs):
        self._disable_password_authentication = kwargs.get('disable_password_authentication')
        self._ssh_configuration = kwargs.get('ssh_configuration')
    
    @property
    def disable_password_authentication(self):
        """
         Gets or sets whether Authentication using user name and password is
         allowed or not
        """
        return self._disable_password_authentication
    
    @disable_password_authentication.setter 
    def disable_password_authentication(self, value):
        self._disable_password_authentication = value
    
    @property
    def ssh_configuration(self):
        """
         Gets or sets the SSH configuration for linux VMs
        """
        return self._ssh_configuration
    
    @ssh_configuration.setter 
    def ssh_configuration(self, value):
        self._ssh_configuration = value

class SshConfiguration(object):
    """
     SSH configuration for Linux based VMs running on Azure
    """
    
    def __init__(self, **kwargs):
        self._public_keys = kwargs.get('public_keys')
    
    @property
    def public_keys(self):
        """
         Gets or sets the list of SSH public keys used to authenticate with
         linux based VMs
        """
        return self._public_keys
    
    @public_keys.setter 
    def public_keys(self, value):
        self._public_keys = value

class SshPublicKey(object):
    """
     Contains information about SSH certificate public key and the path on the
     Linux VM where the public key is placed.
    """
    
    def __init__(self, **kwargs):
        self._path = kwargs.get('path')
        self._key_data = kwargs.get('key_data')
    
    @property
    def key_data(self):
        """
         Gets or sets Certificate public key used to authenticate with VM
         through SSH.The certificate must be in Pem format with or without
         headers.
        """
        return self._key_data
    
    @key_data.setter 
    def key_data(self, value):
        self._key_data = value
    
    @property
    def path(self):
        """
         Gets or sets the full path on the created VM where SSH public key is
         stored. If the file already exists, the specified key is appended to
         the file.
        """
        return self._path
    
    @path.setter 
    def path(self, value):
        self._path = value

class VaultSecretGroup(object):
    """
     Describes a set of certificates which are all in the same Key Vault.
    """
    
    def __init__(self, **kwargs):
        self._source_vault = kwargs.get('source_vault')
        self._vault_certificates = kwargs.get('vault_certificates')
    
    @property
    def source_vault(self):
        """
         Gets or sets the Relative URL of the Key Vault containing all of the
         certificates in VaultCertificates.
        """
        return self._source_vault
    
    @source_vault.setter 
    def source_vault(self, value):
        self._source_vault = value
    
    @property
    def vault_certificates(self):
        """
         Gets or sets the list of key vault references in SourceVault which
         contain certificates
        """
        return self._vault_certificates
    
    @vault_certificates.setter 
    def vault_certificates(self, value):
        self._vault_certificates = value

class VaultCertificate(object):
    """
     Describes a single certificate reference in a Key Vault, and where the
     certificate should reside on the VM.
    """
    
    def __init__(self, **kwargs):
        self._certificate_url = kwargs.get('certificate_url')
        self._certificate_store = kwargs.get('certificate_store')
    
    @property
    def certificate_store(self):
        """
         Gets or sets the Certificate store in LocalMachine to add the
         certificate to on Windows, leave empty on Linux.
        """
        return self._certificate_store
    
    @certificate_store.setter 
    def certificate_store(self, value):
        self._certificate_store = value
    
    @property
    def certificate_url(self):
        """
         Gets or sets the URL referencing a secret in a Key Vault which
         contains a properly formatted certificate.
        """
        return self._certificate_url
    
    @certificate_url.setter 
    def certificate_url(self, value):
        self._certificate_url = value

class ProvisioningStateTypes(object):
    """
     The provisioning state.
    """
    creating = 'Creating'
    updating = 'Updating'
    failed = 'Failed'
    succeeded = 'Succeeded'
    deleting = 'Deleting'

class Usage(object):
    """
     Describes Compute Resource Usage.
    """
    
    def __init__(self, **kwargs):
        self._unit = kwargs.get('unit')
        self._current_value = kwargs.get('current_value')
        self._limit = kwargs.get('limit')
        self._name = kwargs.get('name')
    
    @property
    def current_value(self):
        """
         Gets or sets the current value of the usage.
        """
        return self._current_value
    
    @current_value.setter 
    def current_value(self, value):
        self._current_value = value
    
    @property
    def limit(self):
        """
         Gets or sets the limit of usage.
        """
        return self._limit
    
    @limit.setter 
    def limit(self, value):
        self._limit = value
    
    @property
    def name(self):
        """
         Gets or sets the name of the type of usage.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def unit(self):
        """
         Gets or sets an enum describing the unit of measurement.
        """
        return self._unit
    
    @unit.setter 
    def unit(self, value):
        self._unit = value

class UsageUnit(object):
    """
     The usage unit.
    """
    count = "Count"

class UsageName(object):
    """
     The Usage Names.
    """
    
    def __init__(self, **kwargs):
        self._value = kwargs.get('value')
        self._localized_value = kwargs.get('localized_value')
    
    @property
    def localized_value(self):
        """
         Gets or sets a localized string describing the resource name.
        """
        return self._localized_value
    
    @localized_value.setter 
    def localized_value(self, value):
        self._localized_value = value
    
    @property
    def value(self):
        """
         Gets or sets a string describing the resource name.
        """
        return self._value
    
    @value.setter 
    def value(self, value):
        self._value = value

class NetworkProfile(object):
    """
     Describes a network profile.
    """
    
    def __init__(self, **kwargs):
        self._network_interfaces = kwargs.get('network_interfaces')
    
    @property
    def network_interfaces(self):
        """
         Gets or sets the network interfaces.
        """
        return self._network_interfaces
    
    @network_interfaces.setter 
    def network_interfaces(self, value):
        self._network_interfaces = value

class ComputeManagementClient(Service):
    """
     The Compute Management Client.
    """
    
    @property
    def api_version(self):
        """
         Gets the API version.
        """
        return self._api_version
    
    @property
    def long_running_operation_initial_timeout(self):
        """
         Gets or sets the initial timeout for Long Running Operations.
        """
        return self._long_running_operation_initial_timeout
    
    @long_running_operation_initial_timeout.setter 
    def long_running_operation_initial_timeout(self, value):
        self._long_running_operation_initial_timeout = value
    
    @property
    def long_running_operation_retry_timeout(self):
        """
         Gets or sets the retry timeout for Long Running Operations.
        """
        return self._long_running_operation_retry_timeout
    
    @long_running_operation_retry_timeout.setter 
    def long_running_operation_retry_timeout(self, value):
        self._long_running_operation_retry_timeout = value
    
    @property
    def availability_sets(self):
        """
         Operations for managing the availability sets in compute management.
        """
        return self._availability_sets
    
    @property
    def usage(self):
        """
         Operations for listing usage.
        """
        return self._usage
    
    @property
    def virtual_machine_extension_images(self):
        """
         Operations for managing the virtual machine extension images in
         compute management.
        """
        return self._virtual_machine_extension_images
    
    @property
    def virtual_machine_extensions(self):
        """
         Operations for managing the virtual machine extensions in compute
         management.
        """
        return self._virtual_machine_extensions
    
    @property
    def virtual_machine_images(self):
        """
         Operations for managing the virtual machine images in compute
         management.
        """
        return self._virtual_machine_images
    
    @property
    def virtual_machines(self):
        """
         Operations for managing the virtual machines in compute management.
        """
        return self._virtual_machines
    
    @property
    def virtual_machine_sizes(self):
        """
         Operations for listing virtual machine sizes available in a region.
        """
        return self._virtual_machine_sizes
    
    def __init__(self, credentials, **kwargs):
        super(ComputeManagementClient, self).__init__(credentials, **kwargs)
        
        if getattr(self, '_base_uri', None) is None:
            self._base_uri = 'https://management.azure.com'
        
        if getattr(self, '_api_version', None) is None:
            self._api_version = '2015-05-01-preview'
        
        if getattr(self, '_long_running_operation_initial_timeout', None) is None:
            self._long_running_operation_initial_timeout = -1
        
        if getattr(self, '_long_running_operation_retry_timeout', None) is None:
            self._long_running_operation_retry_timeout = -1
        
        self._availability_sets = AvailabilitySetOperations(self)
        self._usage = UsageOperations(self)
        self._virtual_machine_extension_images = VirtualMachineExtensionImageOperations(self)
        self._virtual_machine_extensions = VirtualMachineExtensionOperations(self)
        self._virtual_machine_images = VirtualMachineImageOperations(self)
        self._virtual_machines = VirtualMachineOperations(self)
        self._virtual_machine_sizes = VirtualMachineSizeOperations(self)
    
    def get_long_running_operation_status(self, operation_status_link):
        """
         The Get Operation Status operation returns the status of the specified
         operation. After calling an asynchronous operation, you can call
         GetLongRunningOperationStatus to determine whether the operation has
         succeeded, failed, or is still in progress.
         
         Args:
         
         operation_status_link (string): Location value returned by the Begin
         operation.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        # Validate
        if operation_status_link is None:
            raise ValueError('operation_status_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + operation_status_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        
        # Send Request
        response = self.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 202:
            response_content = body
            result = ComputeLongRunningOperationResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                operation_id_value = response_doc.get('operationId', None)
                if operation_id_value is not None:
                    operation_id_instance = operation_id_value
                    result.tracking_operation_id = operation_id_instance
                
                status_value = response_doc.get('status', None)
                if status_value is not None:
                    status_instance = status_value
                    result.status = status_instance
                
                start_time_value = response_doc.get('startTime', None)
                if start_time_value is not None:
                    start_time_instance = start_time_value
                    result.start_time = start_time_instance
                
                end_time_value = response_doc.get('endTime', None)
                if end_time_value is not None:
                    end_time_instance = end_time_value
                    result.end_time = end_time_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    output_value = properties_value.get('output', None)
                    if output_value is not None:
                        output_instance = json.dumps(output_value)
                        result.output = output_instance
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = ApiError(details=[])
                    result.error = error_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            api_error_base_instance = ApiErrorBase()
                            error_instance.details.append(api_error_base_instance)
                            
                            code_value = details_value.get('code', None)
                            if code_value is not None:
                                code_instance = code_value
                                api_error_base_instance.code = code_instance
                            
                            target_value = details_value.get('target', None)
                            if target_value is not None:
                                target_instance = target_value
                                api_error_base_instance.target = target_instance
                            
                            message_value = details_value.get('message', None)
                            if message_value is not None:
                                message_instance = message_value
                                api_error_base_instance.message = message_instance
                            
                    innererror_value = error_value.get('innererror', None)
                    if innererror_value is not None:
                        innererror_instance = InnerError()
                        error_instance.inner_error = innererror_instance
                        
                        exceptiontype_value = innererror_value.get('exceptiontype', None)
                        if exceptiontype_value is not None:
                            exceptiontype_instance = exceptiontype_value
                            innererror_instance.exception_type = exceptiontype_instance
                        
                        errordetail_value = innererror_value.get('errordetail', None)
                        if errordetail_value is not None:
                            errordetail_instance = errordetail_value
                            innererror_instance.error_detail = errordetail_instance
                        
                    code_value2 = error_value.get('code', None)
                    if code_value2 is not None:
                        code_instance2 = code_value2
                        error_instance.code = code_instance2
                    
                    target_value2 = error_value.get('target', None)
                    if target_value2 is not None:
                        target_instance2 = target_value2
                        error_instance.target = target_instance2
                    
                    message_value2 = error_value.get('message', None)
                    if message_value2 is not None:
                        message_instance2 = message_value2
                        error_instance.message = message_instance2
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class AvailabilitySetOperations(object):
    """
     Operations for managing the availability sets in compute management.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ComputeManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Compute.ComputeManagementClient.
        """
        return self._client
    
    def create_or_update(self, resource_group_name, parameters):
        """
         The operation to create or update the availability set.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         parameters (AvailabilitySet): Parameters supplied to the Create
         Availability Set operation.
         
         Returns:
         
         AvailabilitySetCreateOrUpdateResponse: The Create Availability Set
         operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/availabilitySets/'
        if parameters.name is not None:
            url = url + quote(parameters.name)
        
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        availability_set_json_value = {}
        request_doc = availability_set_json_value
        
        properties_value = {}
        availability_set_json_value['properties'] = properties_value
        
        if parameters.platform_update_domain_count is not None:
            properties_value['platformUpdateDomainCount'] = parameters.platform_update_domain_count
        
        if parameters.platform_fault_domain_count is not None:
            properties_value['platformFaultDomainCount'] = parameters.platform_fault_domain_count
        
        if parameters.virtual_machines_references is not None:
            virtual_machines_array = []
            for virtual_machines_item in parameters.virtual_machines_references:
                virtual_machine_reference_value = {}
                virtual_machines_array.append(virtual_machine_reference_value)
                
                if virtual_machines_item.reference_uri is not None:
                    virtual_machine_reference_value['id'] = virtual_machines_item.reference_uri
                
            properties_value['virtualMachines'] = virtual_machines_array
        
        if parameters.statuses is not None:
            statuses_array = []
            for statuses_item in parameters.statuses:
                instance_view_status_value = {}
                statuses_array.append(instance_view_status_value)
                
                if statuses_item.code is not None:
                    instance_view_status_value['code'] = statuses_item.code
                
                if statuses_item.level is not None:
                    instance_view_status_value['level'] = statuses_item.level
                
                if statuses_item.display_status is not None:
                    instance_view_status_value['displayStatus'] = statuses_item.display_status
                
                if statuses_item.message is not None:
                    instance_view_status_value['message'] = statuses_item.message
                
                if statuses_item.time is not None:
                    instance_view_status_value['time'] = statuses_item.time
                
            properties_value['statuses'] = statuses_array
        
        if parameters.id is not None:
            availability_set_json_value['id'] = parameters.id
        
        if parameters.name is not None:
            availability_set_json_value['name'] = parameters.name
        
        if parameters.type is not None:
            availability_set_json_value['type'] = parameters.type
        
        availability_set_json_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            availability_set_json_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = AvailabilitySetCreateOrUpdateResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                availability_set_instance = AvailabilitySet(statuses=[], tags={}, virtual_machines_references=[])
                result.availability_set = availability_set_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    platform_update_domain_count_value = properties_value2.get('platformUpdateDomainCount', None)
                    if platform_update_domain_count_value is not None:
                        platform_update_domain_count_instance = platform_update_domain_count_value
                        availability_set_instance.platform_update_domain_count = platform_update_domain_count_instance
                    
                    platform_fault_domain_count_value = properties_value2.get('platformFaultDomainCount', None)
                    if platform_fault_domain_count_value is not None:
                        platform_fault_domain_count_instance = platform_fault_domain_count_value
                        availability_set_instance.platform_fault_domain_count = platform_fault_domain_count_instance
                    
                    virtual_machines_array2 = properties_value2.get('virtualMachines', None)
                    if virtual_machines_array2 is not None:
                        for virtual_machines_value in virtual_machines_array2:
                            virtual_machine_reference_instance = VirtualMachineReference()
                            availability_set_instance.virtual_machines_references.append(virtual_machine_reference_instance)
                            
                            id_value = virtual_machines_value.get('id', None)
                            if id_value is not None:
                                id_instance = id_value
                                virtual_machine_reference_instance.reference_uri = id_instance
                            
                    statuses_array2 = properties_value2.get('statuses', None)
                    if statuses_array2 is not None:
                        for statuses_value in statuses_array2:
                            instance_view_status_instance = InstanceViewStatus()
                            availability_set_instance.statuses.append(instance_view_status_instance)
                            
                            code_value = statuses_value.get('code', None)
                            if code_value is not None:
                                code_instance = code_value
                                instance_view_status_instance.code = code_instance
                            
                            level_value = statuses_value.get('level', None)
                            if level_value is not None:
                                level_instance = level_value
                                instance_view_status_instance.level = level_instance
                            
                            display_status_value = statuses_value.get('displayStatus', None)
                            if display_status_value is not None:
                                display_status_instance = display_status_value
                                instance_view_status_instance.display_status = display_status_instance
                            
                            message_value = statuses_value.get('message', None)
                            if message_value is not None:
                                message_instance = message_value
                                instance_view_status_instance.message = message_instance
                            
                            time_value = statuses_value.get('time', None)
                            if time_value is not None:
                                time_instance = time_value
                                instance_view_status_instance.time = time_instance
                            
                id_value2 = response_doc.get('id', None)
                if id_value2 is not None:
                    id_instance2 = id_value2
                    availability_set_instance.id = id_instance2
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    availability_set_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    availability_set_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    availability_set_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        availability_set_instance.tags[tags_key2] = tags_value2
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def delete(self, resource_group_name, availability_set_name):
        """
         The operation to delete the availability set.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         availability_set_name (string): The name of the availability set.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if availability_set_name is None:
            raise ValueError('availability_set_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/availabilitySets/'
        url = url + quote(availability_set_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = AzureOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get(self, resource_group_name, availability_set_name):
        """
         The operation to get the availability set.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         availability_set_name (string): The name of the availability set.
         
         Returns:
         
         AvailabilitySetGetResponse: GET Availability Set operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if availability_set_name is None:
            raise ValueError('availability_set_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/availabilitySets/'
        url = url + quote(availability_set_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = AvailabilitySetGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                availability_set_instance = AvailabilitySet(statuses=[], tags={}, virtual_machines_references=[])
                result.availability_set = availability_set_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    platform_update_domain_count_value = properties_value.get('platformUpdateDomainCount', None)
                    if platform_update_domain_count_value is not None:
                        platform_update_domain_count_instance = platform_update_domain_count_value
                        availability_set_instance.platform_update_domain_count = platform_update_domain_count_instance
                    
                    platform_fault_domain_count_value = properties_value.get('platformFaultDomainCount', None)
                    if platform_fault_domain_count_value is not None:
                        platform_fault_domain_count_instance = platform_fault_domain_count_value
                        availability_set_instance.platform_fault_domain_count = platform_fault_domain_count_instance
                    
                    virtual_machines_array = properties_value.get('virtualMachines', None)
                    if virtual_machines_array is not None:
                        for virtual_machines_value in virtual_machines_array:
                            virtual_machine_reference_instance = VirtualMachineReference()
                            availability_set_instance.virtual_machines_references.append(virtual_machine_reference_instance)
                            
                            id_value = virtual_machines_value.get('id', None)
                            if id_value is not None:
                                id_instance = id_value
                                virtual_machine_reference_instance.reference_uri = id_instance
                            
                    statuses_array = properties_value.get('statuses', None)
                    if statuses_array is not None:
                        for statuses_value in statuses_array:
                            instance_view_status_instance = InstanceViewStatus()
                            availability_set_instance.statuses.append(instance_view_status_instance)
                            
                            code_value = statuses_value.get('code', None)
                            if code_value is not None:
                                code_instance = code_value
                                instance_view_status_instance.code = code_instance
                            
                            level_value = statuses_value.get('level', None)
                            if level_value is not None:
                                level_instance = level_value
                                instance_view_status_instance.level = level_instance
                            
                            display_status_value = statuses_value.get('displayStatus', None)
                            if display_status_value is not None:
                                display_status_instance = display_status_value
                                instance_view_status_instance.display_status = display_status_instance
                            
                            message_value = statuses_value.get('message', None)
                            if message_value is not None:
                                message_instance = message_value
                                instance_view_status_instance.message = message_instance
                            
                            time_value = statuses_value.get('time', None)
                            if time_value is not None:
                                time_instance = time_value
                                instance_view_status_instance.time = time_instance
                            
                id_value2 = response_doc.get('id', None)
                if id_value2 is not None:
                    id_instance2 = id_value2
                    availability_set_instance.id = id_instance2
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    availability_set_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    availability_set_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    availability_set_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        availability_set_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The operation to list the availability sets.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         AvailabilitySetListResponse: The List Availability Set operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/availabilitySets'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = AvailabilitySetListResponse(availability_sets=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        availability_set_json_instance = AvailabilitySet(statuses=[], tags={}, virtual_machines_references=[])
                        result.availability_sets.append(availability_set_json_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            platform_update_domain_count_value = properties_value.get('platformUpdateDomainCount', None)
                            if platform_update_domain_count_value is not None:
                                platform_update_domain_count_instance = platform_update_domain_count_value
                                availability_set_json_instance.platform_update_domain_count = platform_update_domain_count_instance
                            
                            platform_fault_domain_count_value = properties_value.get('platformFaultDomainCount', None)
                            if platform_fault_domain_count_value is not None:
                                platform_fault_domain_count_instance = platform_fault_domain_count_value
                                availability_set_json_instance.platform_fault_domain_count = platform_fault_domain_count_instance
                            
                            virtual_machines_array = properties_value.get('virtualMachines', None)
                            if virtual_machines_array is not None:
                                for virtual_machines_value in virtual_machines_array:
                                    virtual_machine_reference_instance = VirtualMachineReference()
                                    availability_set_json_instance.virtual_machines_references.append(virtual_machine_reference_instance)
                                    
                                    id_value = virtual_machines_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        virtual_machine_reference_instance.reference_uri = id_instance
                                    
                            statuses_array = properties_value.get('statuses', None)
                            if statuses_array is not None:
                                for statuses_value in statuses_array:
                                    instance_view_status_instance = InstanceViewStatus()
                                    availability_set_json_instance.statuses.append(instance_view_status_instance)
                                    
                                    code_value = statuses_value.get('code', None)
                                    if code_value is not None:
                                        code_instance = code_value
                                        instance_view_status_instance.code = code_instance
                                    
                                    level_value = statuses_value.get('level', None)
                                    if level_value is not None:
                                        level_instance = level_value
                                        instance_view_status_instance.level = level_instance
                                    
                                    display_status_value = statuses_value.get('displayStatus', None)
                                    if display_status_value is not None:
                                        display_status_instance = display_status_value
                                        instance_view_status_instance.display_status = display_status_instance
                                    
                                    message_value = statuses_value.get('message', None)
                                    if message_value is not None:
                                        message_instance = message_value
                                        instance_view_status_instance.message = message_instance
                                    
                                    time_value = statuses_value.get('time', None)
                                    if time_value is not None:
                                        time_instance = time_value
                                        instance_view_status_instance.time = time_instance
                                    
                        id_value2 = value_value.get('id', None)
                        if id_value2 is not None:
                            id_instance2 = id_value2
                            availability_set_json_instance.id = id_instance2
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            availability_set_json_instance.name = name_instance
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            availability_set_json_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            availability_set_json_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                availability_set_json_instance.tags[tags_key] = tags_value
                            
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_available_sizes(self, resource_group_name, availability_set_name):
        """
         Lists virtual-machine-sizes available to be used for an availability
         set.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         availability_set_name (string): The name of the availability set.
         
         Returns:
         
         VirtualMachineSizeListResponse: The List Virtual Machine operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if availability_set_name is None:
            raise ValueError('availability_set_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/availabilitySets/'
        url = url + quote(availability_set_name)
        url = url + '/vmSizes'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineSizeListResponse(virtual_machine_sizes=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_machine_size_instance = VirtualMachineSize()
                        result.virtual_machine_sizes.append(virtual_machine_size_instance)
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_size_instance.name = name_instance
                        
                        number_of_cores_value = value_value.get('numberOfCores', None)
                        if number_of_cores_value is not None:
                            number_of_cores_instance = number_of_cores_value
                            virtual_machine_size_instance.number_of_cores = number_of_cores_instance
                        
                        os_disk_size_in_mb_value = value_value.get('osDiskSizeInMB', None)
                        if os_disk_size_in_mb_value is not None:
                            os_disk_size_in_mb_instance = os_disk_size_in_mb_value
                            virtual_machine_size_instance.os_disk_size_in_mb = os_disk_size_in_mb_instance
                        
                        resource_disk_size_in_mb_value = value_value.get('resourceDiskSizeInMB', None)
                        if resource_disk_size_in_mb_value is not None:
                            resource_disk_size_in_mb_instance = resource_disk_size_in_mb_value
                            virtual_machine_size_instance.resource_disk_size_in_mb = resource_disk_size_in_mb_instance
                        
                        memory_in_mb_value = value_value.get('memoryInMB', None)
                        if memory_in_mb_value is not None:
                            memory_in_mb_instance = memory_in_mb_value
                            virtual_machine_size_instance.memory_in_mb = memory_in_mb_instance
                        
                        max_data_disk_count_value = value_value.get('maxDataDiskCount', None)
                        if max_data_disk_count_value is not None:
                            max_data_disk_count_instance = max_data_disk_count_value
                            virtual_machine_size_instance.max_data_disk_count = max_data_disk_count_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class UsageOperations(object):
    """
     Operations for listing usage.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ComputeManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Compute.ComputeManagementClient.
        """
        return self._client
    
    def list(self, location):
        """
         Lists compute usages for a subscription.
         
         Args:
         
         location (string): The location upon which resource usage is queried.
         
         Returns:
         
         ListUsagesResponse: The List Usages operation response.
        """
        # Validate
        if location is None:
            raise ValueError('location cannot be None.')
        
        if location is not None and len(location) > 1000:
            raise IndexError('location is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', location) is not None) == False:
            raise IndexError('location is outside the valid range.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        url = url + quote(location)
        url = url + '/usages'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ListUsagesResponse(usages=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        usage_instance = Usage()
                        result.usages.append(usage_instance)
                        
                        unit_value = value_value.get('unit', None)
                        if unit_value is not None:
                            unit_instance = unit_value
                            usage_instance.unit = unit_instance
                        
                        current_value_value = value_value.get('currentValue', None)
                        if current_value_value is not None:
                            current_value_instance = current_value_value
                            usage_instance.current_value = current_value_instance
                        
                        limit_value = value_value.get('limit', None)
                        if limit_value is not None:
                            limit_instance = limit_value
                            usage_instance.limit = limit_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = UsageName()
                            usage_instance.name = name_instance
                            
                            value_value2 = name_value.get('value', None)
                            if value_value2 is not None:
                                value_instance = value_value2
                                name_instance.value = value_instance
                            
                            localized_value_value = name_value.get('localizedValue', None)
                            if localized_value_value is not None:
                                localized_value_instance = localized_value_value
                                name_instance.localized_value = localized_value_instance
                            
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class VirtualMachineExtensionImageOperations(object):
    """
     Operations for managing the virtual machine extension images in compute
     management.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ComputeManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Compute.ComputeManagementClient.
        """
        return self._client
    
    def get(self, parameters):
        """
         Gets a virtual machine extension image.
         
         Args:
         
         parameters (VirtualMachineExtensionImageGetParameters)
         
         Returns:
         
         VirtualMachineExtensionImageGetResponse: The get virtual machine
         extension image operation response.
        """
        # Validate
        if parameters is not None:
            if parameters.location is None:
                raise ValueError('parameters.location cannot be None.')
            
            if parameters.publisher_name is None:
                raise ValueError('parameters.publisher_name cannot be None.')
            
            if parameters.type is None:
                raise ValueError('parameters.type cannot be None.')
            
            if parameters.version is None:
                raise ValueError('parameters.version cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        if parameters is not None:
            url = url + quote(parameters.location)
        
        url = url + '/publishers/'
        if parameters is not None:
            url = url + quote(parameters.publisher_name)
        
        url = url + '/artifacttypes/vmextension/types/'
        if parameters is not None:
            url = url + quote(parameters.type)
        
        url = url + '/versions/'
        if parameters is not None:
            url = url + quote(parameters.version)
        
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineExtensionImageGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_machine_extension_image_instance = VirtualMachineExtensionImage()
                result.virtual_machine_extension_image = virtual_machine_extension_image_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    operating_system_value = properties_value.get('operatingSystem', None)
                    if operating_system_value is not None:
                        operating_system_instance = operating_system_value
                        virtual_machine_extension_image_instance.operating_system = operating_system_instance
                    
                    compute_role_value = properties_value.get('computeRole', None)
                    if compute_role_value is not None:
                        compute_role_instance = compute_role_value
                        virtual_machine_extension_image_instance.compute_role = compute_role_instance
                    
                    handler_schema_value = properties_value.get('handlerSchema', None)
                    if handler_schema_value is not None:
                        handler_schema_instance = handler_schema_value
                        virtual_machine_extension_image_instance.handler_schema = handler_schema_instance
                    
                    vm_scale_set_enabled_value = properties_value.get('vmScaleSetEnabled', None)
                    if vm_scale_set_enabled_value is not None:
                        vm_scale_set_enabled_instance = vm_scale_set_enabled_value
                        virtual_machine_extension_image_instance.vm_scale_set_enabled = vm_scale_set_enabled_instance
                    
                    supports_multiple_extensions_value = properties_value.get('supportsMultipleExtensions', None)
                    if supports_multiple_extensions_value is not None:
                        supports_multiple_extensions_instance = supports_multiple_extensions_value
                        virtual_machine_extension_image_instance.supports_multiple_extensions = supports_multiple_extensions_instance
                    
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    virtual_machine_extension_image_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    virtual_machine_extension_image_instance.name = name_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_machine_extension_image_instance.location = location_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_types(self, parameters):
        """
         Gets a list of virtual machine extension image types.
         
         Args:
         
         parameters (VirtualMachineExtensionImageListTypesParameters)
         
         Returns:
         
         VirtualMachineImageResourceList: A list of virtual machine image
         resource information.
        """
        # Validate
        if parameters is not None:
            if parameters.location is None:
                raise ValueError('parameters.location cannot be None.')
            
            if parameters.publisher_name is None:
                raise ValueError('parameters.publisher_name cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        if parameters is not None:
            url = url + quote(parameters.location)
        
        url = url + '/publishers/'
        if parameters is not None:
            url = url + quote(parameters.publisher_name)
        
        url = url + '/artifacttypes/vmextension/types'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineImageResourceList(resources=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resources_array = response_doc
                if resources_array is not None:
                    for resources_value in resources_array:
                        virtual_machine_image_resource_instance = VirtualMachineImageResource()
                        result.resources.append(virtual_machine_image_resource_instance)
                        
                        id_value = resources_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            virtual_machine_image_resource_instance.id = id_instance
                        
                        name_value = resources_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_image_resource_instance.name = name_instance
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_image_resource_instance.location = location_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_versions(self, parameters):
        """
         Gets a list of virtual machine extension image versions.
         
         Args:
         
         parameters (VirtualMachineExtensionImageListVersionsParameters)
         
         Returns:
         
         VirtualMachineImageResourceList: A list of virtual machine image
         resource information.
        """
        # Validate
        if parameters is not None:
            if parameters.location is None:
                raise ValueError('parameters.location cannot be None.')
            
            if parameters.publisher_name is None:
                raise ValueError('parameters.publisher_name cannot be None.')
            
            if parameters.type is None:
                raise ValueError('parameters.type cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        if parameters is not None:
            url = url + quote(parameters.location)
        
        url = url + '/publishers/'
        if parameters is not None:
            url = url + quote(parameters.publisher_name)
        
        url = url + '/artifacttypes/vmextension/types/'
        if parameters is not None:
            url = url + quote(parameters.type)
        
        url = url + '/versions'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if parameters is not None and parameters.filter_expression is not None:
            query_parameters.append(parameters.filter_expression)
        
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineImageResourceList(resources=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resources_array = response_doc
                if resources_array is not None:
                    for resources_value in resources_array:
                        virtual_machine_image_resource_instance = VirtualMachineImageResource()
                        result.resources.append(virtual_machine_image_resource_instance)
                        
                        id_value = resources_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            virtual_machine_image_resource_instance.id = id_instance
                        
                        name_value = resources_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_image_resource_instance.name = name_instance
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_image_resource_instance.location = location_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class VirtualMachineExtensionOperations(object):
    """
     Operations for managing the virtual machine extensions in compute
     management.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ComputeManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Compute.ComputeManagementClient.
        """
        return self._client
    
    def begin_creating_or_updating(self, resource_group_name, vm_name, extension_parameters):
        """
         The operation to create or update the extension.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine where the extension
         should be create or updated.
         
         extension_parameters (VirtualMachineExtension): Parameters supplied to
         the Create Virtual Machine Extension operation.
         
         Returns:
         
         VirtualMachineExtensionCreateOrUpdateResponse: The compute long
         running operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        if extension_parameters is None:
            raise ValueError('extension_parameters cannot be None.')
        
        if extension_parameters.location is None:
            raise ValueError('extension_parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/extensions/'
        if extension_parameters.name is not None:
            url = url + quote(extension_parameters.name)
        
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        virtual_machine_extension_json_value = {}
        request_doc = virtual_machine_extension_json_value
        
        properties_value = {}
        virtual_machine_extension_json_value['properties'] = properties_value
        
        if extension_parameters.publisher is not None:
            properties_value['publisher'] = extension_parameters.publisher
        
        if extension_parameters.extension_type is not None:
            properties_value['type'] = extension_parameters.extension_type
        
        if extension_parameters.type_handler_version is not None:
            properties_value['typeHandlerVersion'] = extension_parameters.type_handler_version
        
        if extension_parameters.auto_upgrade_minor_version is not None:
            properties_value['autoUpgradeMinorVersion'] = extension_parameters.auto_upgrade_minor_version
        
        if extension_parameters.settings is not None:
            properties_value['settings'] = json.loads(extension_parameters.settings)
        
        if extension_parameters.protected_settings is not None:
            properties_value['protectedSettings'] = json.loads(extension_parameters.protected_settings)
        
        if extension_parameters.provisioning_state is not None:
            properties_value['provisioningState'] = extension_parameters.provisioning_state
        
        if extension_parameters.instance_view is not None:
            instance_view_value = {}
            properties_value['instanceView'] = instance_view_value
            
            if extension_parameters.instance_view.name is not None:
                instance_view_value['name'] = extension_parameters.instance_view.name
            
            if extension_parameters.instance_view.extension_type is not None:
                instance_view_value['type'] = extension_parameters.instance_view.extension_type
            
            if extension_parameters.instance_view.type_handler_version is not None:
                instance_view_value['typeHandlerVersion'] = extension_parameters.instance_view.type_handler_version
            
            if extension_parameters.instance_view.sub_statuses is not None:
                substatuses_array = []
                for substatuses_item in extension_parameters.instance_view.sub_statuses:
                    instance_view_status_value = {}
                    substatuses_array.append(instance_view_status_value)
                    
                    if substatuses_item.code is not None:
                        instance_view_status_value['code'] = substatuses_item.code
                    
                    if substatuses_item.level is not None:
                        instance_view_status_value['level'] = substatuses_item.level
                    
                    if substatuses_item.display_status is not None:
                        instance_view_status_value['displayStatus'] = substatuses_item.display_status
                    
                    if substatuses_item.message is not None:
                        instance_view_status_value['message'] = substatuses_item.message
                    
                    if substatuses_item.time is not None:
                        instance_view_status_value['time'] = substatuses_item.time
                    
                instance_view_value['substatuses'] = substatuses_array
            
            if extension_parameters.instance_view.statuses is not None:
                statuses_array = []
                for statuses_item in extension_parameters.instance_view.statuses:
                    instance_view_status_value2 = {}
                    statuses_array.append(instance_view_status_value2)
                    
                    if statuses_item.code is not None:
                        instance_view_status_value2['code'] = statuses_item.code
                    
                    if statuses_item.level is not None:
                        instance_view_status_value2['level'] = statuses_item.level
                    
                    if statuses_item.display_status is not None:
                        instance_view_status_value2['displayStatus'] = statuses_item.display_status
                    
                    if statuses_item.message is not None:
                        instance_view_status_value2['message'] = statuses_item.message
                    
                    if statuses_item.time is not None:
                        instance_view_status_value2['time'] = statuses_item.time
                    
                instance_view_value['statuses'] = statuses_array
            
        if extension_parameters.id is not None:
            virtual_machine_extension_json_value['id'] = extension_parameters.id
        
        if extension_parameters.name is not None:
            virtual_machine_extension_json_value['name'] = extension_parameters.name
        
        if extension_parameters.type is not None:
            virtual_machine_extension_json_value['type'] = extension_parameters.type
        
        virtual_machine_extension_json_value['location'] = extension_parameters.location
        
        if extension_parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in extension_parameters.tags:
                tags_value = extension_parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            virtual_machine_extension_json_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = VirtualMachineExtensionCreateOrUpdateResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_machine_extension_instance = VirtualMachineExtension(tags={})
                result.virtual_machine_extension = virtual_machine_extension_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    publisher_value = properties_value2.get('publisher', None)
                    if publisher_value is not None:
                        publisher_instance = publisher_value
                        virtual_machine_extension_instance.publisher = publisher_instance
                    
                    type_value = properties_value2.get('type', None)
                    if type_value is not None:
                        type_instance = type_value
                        virtual_machine_extension_instance.extension_type = type_instance
                    
                    type_handler_version_value = properties_value2.get('typeHandlerVersion', None)
                    if type_handler_version_value is not None:
                        type_handler_version_instance = type_handler_version_value
                        virtual_machine_extension_instance.type_handler_version = type_handler_version_instance
                    
                    auto_upgrade_minor_version_value = properties_value2.get('autoUpgradeMinorVersion', None)
                    if auto_upgrade_minor_version_value is not None:
                        auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                        virtual_machine_extension_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                    
                    settings_value = properties_value2.get('settings', None)
                    if settings_value is not None:
                        settings_instance = json.dumps(settings_value)
                        virtual_machine_extension_instance.settings = settings_instance
                    
                    protected_settings_value = properties_value2.get('protectedSettings', None)
                    if protected_settings_value is not None:
                        protected_settings_instance = json.dumps(protected_settings_value)
                        virtual_machine_extension_instance.protected_settings = protected_settings_instance
                    
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        virtual_machine_extension_instance.provisioning_state = provisioning_state_instance
                    
                    instance_view_value2 = properties_value2.get('instanceView', None)
                    if instance_view_value2 is not None:
                        instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                        virtual_machine_extension_instance.instance_view = instance_view_instance
                        
                        name_value = instance_view_value2.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            instance_view_instance.name = name_instance
                        
                        type_value2 = instance_view_value2.get('type', None)
                        if type_value2 is not None:
                            type_instance2 = type_value2
                            instance_view_instance.extension_type = type_instance2
                        
                        type_handler_version_value2 = instance_view_value2.get('typeHandlerVersion', None)
                        if type_handler_version_value2 is not None:
                            type_handler_version_instance2 = type_handler_version_value2
                            instance_view_instance.type_handler_version = type_handler_version_instance2
                        
                        substatuses_array2 = instance_view_value2.get('substatuses', None)
                        if substatuses_array2 is not None:
                            for substatuses_value in substatuses_array2:
                                instance_view_status_instance = InstanceViewStatus()
                                instance_view_instance.sub_statuses.append(instance_view_status_instance)
                                
                                code_value = substatuses_value.get('code', None)
                                if code_value is not None:
                                    code_instance = code_value
                                    instance_view_status_instance.code = code_instance
                                
                                level_value = substatuses_value.get('level', None)
                                if level_value is not None:
                                    level_instance = level_value
                                    instance_view_status_instance.level = level_instance
                                
                                display_status_value = substatuses_value.get('displayStatus', None)
                                if display_status_value is not None:
                                    display_status_instance = display_status_value
                                    instance_view_status_instance.display_status = display_status_instance
                                
                                message_value = substatuses_value.get('message', None)
                                if message_value is not None:
                                    message_instance = message_value
                                    instance_view_status_instance.message = message_instance
                                
                                time_value = substatuses_value.get('time', None)
                                if time_value is not None:
                                    time_instance = time_value
                                    instance_view_status_instance.time = time_instance
                                
                        statuses_array2 = instance_view_value2.get('statuses', None)
                        if statuses_array2 is not None:
                            for statuses_value in statuses_array2:
                                instance_view_status_instance2 = InstanceViewStatus()
                                instance_view_instance.statuses.append(instance_view_status_instance2)
                                
                                code_value2 = statuses_value.get('code', None)
                                if code_value2 is not None:
                                    code_instance2 = code_value2
                                    instance_view_status_instance2.code = code_instance2
                                
                                level_value2 = statuses_value.get('level', None)
                                if level_value2 is not None:
                                    level_instance2 = level_value2
                                    instance_view_status_instance2.level = level_instance2
                                
                                display_status_value2 = statuses_value.get('displayStatus', None)
                                if display_status_value2 is not None:
                                    display_status_instance2 = display_status_value2
                                    instance_view_status_instance2.display_status = display_status_instance2
                                
                                message_value2 = statuses_value.get('message', None)
                                if message_value2 is not None:
                                    message_instance2 = message_value2
                                    instance_view_status_instance2.message = message_instance2
                                
                                time_value2 = statuses_value.get('time', None)
                                if time_value2 is not None:
                                    time_instance2 = time_value2
                                    instance_view_status_instance2.time = time_instance2
                                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    virtual_machine_extension_instance.id = id_instance
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_machine_extension_instance.name = name_instance2
                
                type_value3 = response_doc.get('type', None)
                if type_value3 is not None:
                    type_instance3 = type_value3
                    virtual_machine_extension_instance.type = type_instance3
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_machine_extension_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        virtual_machine_extension_instance.tags[tags_key2] = tags_value2
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, vm_name, vm_extension_name):
        """
         The operation to delete the extension.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine where the extension
         should be deleted.
         
         vm_extension_name (string): The name of the virtual machine extension.
         
         Returns:
         
         ComputeOperationResponse: The compute long running operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        if vm_extension_name is None:
            raise ValueError('vm_extension_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/extensions/'
        url = url + quote(vm_extension_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ComputeOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, vm_name, extension_parameters):
        """
         The operation to create or update the extension.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine where the extension
         should be create or updated.
         
         extension_parameters (VirtualMachineExtension): Parameters supplied to
         the Create Virtual Machine Extension operation.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machine_extensions.begin_creating_or_updating(resource_group_name, vm_name, extension_parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, vm_name, vm_extension_name):
        """
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine where the extension
         should be deleted.
         
         vm_extension_name (string): The name of the virtual machine extension.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machine_extensions.begin_deleting(resource_group_name, vm_name, vm_extension_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, vm_name, vm_extension_name):
        """
         The operation to get the extension.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine containing the
         extension.
         
         vm_extension_name (string): The name of the virtual machine extension.
         
         Returns:
         
         VirtualMachineExtensionGetResponse: The Get VM-Extension operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        if vm_extension_name is None:
            raise ValueError('vm_extension_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/extensions/'
        url = url + quote(vm_extension_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineExtensionGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_machine_extension_instance = VirtualMachineExtension(tags={})
                result.virtual_machine_extension = virtual_machine_extension_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    publisher_value = properties_value.get('publisher', None)
                    if publisher_value is not None:
                        publisher_instance = publisher_value
                        virtual_machine_extension_instance.publisher = publisher_instance
                    
                    type_value = properties_value.get('type', None)
                    if type_value is not None:
                        type_instance = type_value
                        virtual_machine_extension_instance.extension_type = type_instance
                    
                    type_handler_version_value = properties_value.get('typeHandlerVersion', None)
                    if type_handler_version_value is not None:
                        type_handler_version_instance = type_handler_version_value
                        virtual_machine_extension_instance.type_handler_version = type_handler_version_instance
                    
                    auto_upgrade_minor_version_value = properties_value.get('autoUpgradeMinorVersion', None)
                    if auto_upgrade_minor_version_value is not None:
                        auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                        virtual_machine_extension_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                    
                    settings_value = properties_value.get('settings', None)
                    if settings_value is not None:
                        settings_instance = json.dumps(settings_value)
                        virtual_machine_extension_instance.settings = settings_instance
                    
                    protected_settings_value = properties_value.get('protectedSettings', None)
                    if protected_settings_value is not None:
                        protected_settings_instance = json.dumps(protected_settings_value)
                        virtual_machine_extension_instance.protected_settings = protected_settings_instance
                    
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        virtual_machine_extension_instance.provisioning_state = provisioning_state_instance
                    
                    instance_view_value = properties_value.get('instanceView', None)
                    if instance_view_value is not None:
                        instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                        virtual_machine_extension_instance.instance_view = instance_view_instance
                        
                        name_value = instance_view_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            instance_view_instance.name = name_instance
                        
                        type_value2 = instance_view_value.get('type', None)
                        if type_value2 is not None:
                            type_instance2 = type_value2
                            instance_view_instance.extension_type = type_instance2
                        
                        type_handler_version_value2 = instance_view_value.get('typeHandlerVersion', None)
                        if type_handler_version_value2 is not None:
                            type_handler_version_instance2 = type_handler_version_value2
                            instance_view_instance.type_handler_version = type_handler_version_instance2
                        
                        substatuses_array = instance_view_value.get('substatuses', None)
                        if substatuses_array is not None:
                            for substatuses_value in substatuses_array:
                                instance_view_status_instance = InstanceViewStatus()
                                instance_view_instance.sub_statuses.append(instance_view_status_instance)
                                
                                code_value = substatuses_value.get('code', None)
                                if code_value is not None:
                                    code_instance = code_value
                                    instance_view_status_instance.code = code_instance
                                
                                level_value = substatuses_value.get('level', None)
                                if level_value is not None:
                                    level_instance = level_value
                                    instance_view_status_instance.level = level_instance
                                
                                display_status_value = substatuses_value.get('displayStatus', None)
                                if display_status_value is not None:
                                    display_status_instance = display_status_value
                                    instance_view_status_instance.display_status = display_status_instance
                                
                                message_value = substatuses_value.get('message', None)
                                if message_value is not None:
                                    message_instance = message_value
                                    instance_view_status_instance.message = message_instance
                                
                                time_value = substatuses_value.get('time', None)
                                if time_value is not None:
                                    time_instance = time_value
                                    instance_view_status_instance.time = time_instance
                                
                        statuses_array = instance_view_value.get('statuses', None)
                        if statuses_array is not None:
                            for statuses_value in statuses_array:
                                instance_view_status_instance2 = InstanceViewStatus()
                                instance_view_instance.statuses.append(instance_view_status_instance2)
                                
                                code_value2 = statuses_value.get('code', None)
                                if code_value2 is not None:
                                    code_instance2 = code_value2
                                    instance_view_status_instance2.code = code_instance2
                                
                                level_value2 = statuses_value.get('level', None)
                                if level_value2 is not None:
                                    level_instance2 = level_value2
                                    instance_view_status_instance2.level = level_instance2
                                
                                display_status_value2 = statuses_value.get('displayStatus', None)
                                if display_status_value2 is not None:
                                    display_status_instance2 = display_status_value2
                                    instance_view_status_instance2.display_status = display_status_instance2
                                
                                message_value2 = statuses_value.get('message', None)
                                if message_value2 is not None:
                                    message_instance2 = message_value2
                                    instance_view_status_instance2.message = message_instance2
                                
                                time_value2 = statuses_value.get('time', None)
                                if time_value2 is not None:
                                    time_instance2 = time_value2
                                    instance_view_status_instance2.time = time_instance2
                                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    virtual_machine_extension_instance.id = id_instance
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_machine_extension_instance.name = name_instance2
                
                type_value3 = response_doc.get('type', None)
                if type_value3 is not None:
                    type_instance3 = type_value3
                    virtual_machine_extension_instance.type = type_instance3
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_machine_extension_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        virtual_machine_extension_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get_with_instance_view(self, resource_group_name, vm_name, vm_extension_name):
        """
         The operation to get an extension along with its instance view.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine containing the
         extension.
         
         vm_extension_name (string): The name of the virtual machine extension.
         
         Returns:
         
         VirtualMachineExtensionGetResponse: The Get VM-Extension operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        if vm_extension_name is None:
            raise ValueError('vm_extension_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/extensions/'
        url = url + quote(vm_extension_name)
        query_parameters = []
        query_parameters.append('$expand=instanceView')
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineExtensionGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_machine_extension_instance = VirtualMachineExtension(tags={})
                result.virtual_machine_extension = virtual_machine_extension_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    publisher_value = properties_value.get('publisher', None)
                    if publisher_value is not None:
                        publisher_instance = publisher_value
                        virtual_machine_extension_instance.publisher = publisher_instance
                    
                    type_value = properties_value.get('type', None)
                    if type_value is not None:
                        type_instance = type_value
                        virtual_machine_extension_instance.extension_type = type_instance
                    
                    type_handler_version_value = properties_value.get('typeHandlerVersion', None)
                    if type_handler_version_value is not None:
                        type_handler_version_instance = type_handler_version_value
                        virtual_machine_extension_instance.type_handler_version = type_handler_version_instance
                    
                    auto_upgrade_minor_version_value = properties_value.get('autoUpgradeMinorVersion', None)
                    if auto_upgrade_minor_version_value is not None:
                        auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                        virtual_machine_extension_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                    
                    settings_value = properties_value.get('settings', None)
                    if settings_value is not None:
                        settings_instance = json.dumps(settings_value)
                        virtual_machine_extension_instance.settings = settings_instance
                    
                    protected_settings_value = properties_value.get('protectedSettings', None)
                    if protected_settings_value is not None:
                        protected_settings_instance = json.dumps(protected_settings_value)
                        virtual_machine_extension_instance.protected_settings = protected_settings_instance
                    
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        virtual_machine_extension_instance.provisioning_state = provisioning_state_instance
                    
                    instance_view_value = properties_value.get('instanceView', None)
                    if instance_view_value is not None:
                        instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                        virtual_machine_extension_instance.instance_view = instance_view_instance
                        
                        name_value = instance_view_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            instance_view_instance.name = name_instance
                        
                        type_value2 = instance_view_value.get('type', None)
                        if type_value2 is not None:
                            type_instance2 = type_value2
                            instance_view_instance.extension_type = type_instance2
                        
                        type_handler_version_value2 = instance_view_value.get('typeHandlerVersion', None)
                        if type_handler_version_value2 is not None:
                            type_handler_version_instance2 = type_handler_version_value2
                            instance_view_instance.type_handler_version = type_handler_version_instance2
                        
                        substatuses_array = instance_view_value.get('substatuses', None)
                        if substatuses_array is not None:
                            for substatuses_value in substatuses_array:
                                instance_view_status_instance = InstanceViewStatus()
                                instance_view_instance.sub_statuses.append(instance_view_status_instance)
                                
                                code_value = substatuses_value.get('code', None)
                                if code_value is not None:
                                    code_instance = code_value
                                    instance_view_status_instance.code = code_instance
                                
                                level_value = substatuses_value.get('level', None)
                                if level_value is not None:
                                    level_instance = level_value
                                    instance_view_status_instance.level = level_instance
                                
                                display_status_value = substatuses_value.get('displayStatus', None)
                                if display_status_value is not None:
                                    display_status_instance = display_status_value
                                    instance_view_status_instance.display_status = display_status_instance
                                
                                message_value = substatuses_value.get('message', None)
                                if message_value is not None:
                                    message_instance = message_value
                                    instance_view_status_instance.message = message_instance
                                
                                time_value = substatuses_value.get('time', None)
                                if time_value is not None:
                                    time_instance = time_value
                                    instance_view_status_instance.time = time_instance
                                
                        statuses_array = instance_view_value.get('statuses', None)
                        if statuses_array is not None:
                            for statuses_value in statuses_array:
                                instance_view_status_instance2 = InstanceViewStatus()
                                instance_view_instance.statuses.append(instance_view_status_instance2)
                                
                                code_value2 = statuses_value.get('code', None)
                                if code_value2 is not None:
                                    code_instance2 = code_value2
                                    instance_view_status_instance2.code = code_instance2
                                
                                level_value2 = statuses_value.get('level', None)
                                if level_value2 is not None:
                                    level_instance2 = level_value2
                                    instance_view_status_instance2.level = level_instance2
                                
                                display_status_value2 = statuses_value.get('displayStatus', None)
                                if display_status_value2 is not None:
                                    display_status_instance2 = display_status_value2
                                    instance_view_status_instance2.display_status = display_status_instance2
                                
                                message_value2 = statuses_value.get('message', None)
                                if message_value2 is not None:
                                    message_instance2 = message_value2
                                    instance_view_status_instance2.message = message_instance2
                                
                                time_value2 = statuses_value.get('time', None)
                                if time_value2 is not None:
                                    time_instance2 = time_value2
                                    instance_view_status_instance2.time = time_instance2
                                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    virtual_machine_extension_instance.id = id_instance
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_machine_extension_instance.name = name_instance2
                
                type_value3 = response_doc.get('type', None)
                if type_value3 is not None:
                    type_instance3 = type_value3
                    virtual_machine_extension_instance.type = type_instance3
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_machine_extension_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        virtual_machine_extension_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class VirtualMachineImageOperations(object):
    """
     Operations for managing the virtual machine images in compute management.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ComputeManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Compute.ComputeManagementClient.
        """
        return self._client
    
    def get(self, parameters):
        """
         Gets a virtual machine image.
         
         Args:
         
         parameters (VirtualMachineImageGetParameters)
         
         Returns:
         
         VirtualMachineImageGetResponse: The get vm image operation response.
        """
        # Validate
        if parameters is not None:
            if parameters.location is None:
                raise ValueError('parameters.location cannot be None.')
            
            if parameters.offer is None:
                raise ValueError('parameters.offer cannot be None.')
            
            if parameters.publisher_name is None:
                raise ValueError('parameters.publisher_name cannot be None.')
            
            if parameters.skus is None:
                raise ValueError('parameters.skus cannot be None.')
            
            if parameters.version is None:
                raise ValueError('parameters.version cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        if parameters is not None:
            url = url + quote(parameters.location)
        
        url = url + '/publishers/'
        if parameters is not None:
            url = url + quote(parameters.publisher_name)
        
        url = url + '/artifacttypes/vmimage/offers/'
        if parameters is not None:
            url = url + quote(parameters.offer)
        
        url = url + '/skus/'
        if parameters is not None:
            url = url + quote(parameters.skus)
        
        url = url + '/versions/'
        if parameters is not None:
            url = url + quote(parameters.version)
        
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineImageGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_machine_image_instance = VirtualMachineImage(data_disk_images=[])
                result.virtual_machine_image = virtual_machine_image_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    plan_value = properties_value.get('plan', None)
                    if plan_value is not None:
                        plan_instance = PurchasePlan()
                        virtual_machine_image_instance.purchase_plan = plan_instance
                        
                        publisher_value = plan_value.get('publisher', None)
                        if publisher_value is not None:
                            publisher_instance = publisher_value
                            plan_instance.publisher = publisher_instance
                        
                        name_value = plan_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            plan_instance.name = name_instance
                        
                        product_value = plan_value.get('product', None)
                        if product_value is not None:
                            product_instance = product_value
                            plan_instance.product = product_instance
                        
                    os_disk_image_value = properties_value.get('osDiskImage', None)
                    if os_disk_image_value is not None:
                        os_disk_image_instance = OSDiskImage()
                        virtual_machine_image_instance.os_disk_image = os_disk_image_instance
                        
                        operating_system_value = os_disk_image_value.get('operatingSystem', None)
                        if operating_system_value is not None:
                            operating_system_instance = operating_system_value
                            os_disk_image_instance.operating_system = operating_system_instance
                        
                    data_disk_images_array = properties_value.get('dataDiskImages', None)
                    if data_disk_images_array is not None:
                        for data_disk_images_value in data_disk_images_array:
                            data_disk_image_instance = DataDiskImage()
                            virtual_machine_image_instance.data_disk_images.append(data_disk_image_instance)
                            
                            lun_value = data_disk_images_value.get('lun', None)
                            if lun_value is not None:
                                lun_instance = lun_value
                                data_disk_image_instance.lun = lun_instance
                            
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    virtual_machine_image_instance.id = id_instance
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_machine_image_instance.name = name_instance2
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_machine_image_instance.location = location_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, parameters):
        """
         Gets a list of virtual machine images.
         
         Args:
         
         parameters (VirtualMachineImageListParameters)
         
         Returns:
         
         VirtualMachineImageResourceList: A list of virtual machine image
         resource information.
        """
        # Validate
        if parameters is not None:
            if parameters.location is None:
                raise ValueError('parameters.location cannot be None.')
            
            if parameters.offer is None:
                raise ValueError('parameters.offer cannot be None.')
            
            if parameters.publisher_name is None:
                raise ValueError('parameters.publisher_name cannot be None.')
            
            if parameters.skus is None:
                raise ValueError('parameters.skus cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        if parameters is not None:
            url = url + quote(parameters.location)
        
        url = url + '/publishers/'
        if parameters is not None:
            url = url + quote(parameters.publisher_name)
        
        url = url + '/artifacttypes/vmimage/offers/'
        if parameters is not None:
            url = url + quote(parameters.offer)
        
        url = url + '/skus/'
        if parameters is not None:
            url = url + quote(parameters.skus)
        
        url = url + '/versions'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if parameters is not None and parameters.filter_expression is not None:
            query_parameters.append(parameters.filter_expression)
        
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineImageResourceList(resources=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resources_array = response_doc
                if resources_array is not None:
                    for resources_value in resources_array:
                        virtual_machine_image_resource_instance = VirtualMachineImageResource()
                        result.resources.append(virtual_machine_image_resource_instance)
                        
                        id_value = resources_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            virtual_machine_image_resource_instance.id = id_instance
                        
                        name_value = resources_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_image_resource_instance.name = name_instance
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_image_resource_instance.location = location_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_offers(self, parameters):
        """
         Gets a list of virtual machine image offers.
         
         Args:
         
         parameters (VirtualMachineImageListOffersParameters)
         
         Returns:
         
         VirtualMachineImageResourceList: A list of virtual machine image
         resource information.
        """
        # Validate
        if parameters is not None:
            if parameters.location is None:
                raise ValueError('parameters.location cannot be None.')
            
            if parameters.publisher_name is None:
                raise ValueError('parameters.publisher_name cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        if parameters is not None:
            url = url + quote(parameters.location)
        
        url = url + '/publishers/'
        if parameters is not None:
            url = url + quote(parameters.publisher_name)
        
        url = url + '/artifacttypes/vmimage/offers'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineImageResourceList(resources=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resources_array = response_doc
                if resources_array is not None:
                    for resources_value in resources_array:
                        virtual_machine_image_resource_instance = VirtualMachineImageResource()
                        result.resources.append(virtual_machine_image_resource_instance)
                        
                        id_value = resources_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            virtual_machine_image_resource_instance.id = id_instance
                        
                        name_value = resources_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_image_resource_instance.name = name_instance
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_image_resource_instance.location = location_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_publishers(self, parameters):
        """
         Gets a list of virtual machine image publishers.
         
         Args:
         
         parameters (VirtualMachineImageListPublishersParameters)
         
         Returns:
         
         VirtualMachineImageResourceList: A list of virtual machine image
         resource information.
        """
        # Validate
        if parameters is not None:
            if parameters.location is None:
                raise ValueError('parameters.location cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        if parameters is not None:
            url = url + quote(parameters.location)
        
        url = url + '/publishers'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineImageResourceList(resources=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resources_array = response_doc
                if resources_array is not None:
                    for resources_value in resources_array:
                        virtual_machine_image_resource_instance = VirtualMachineImageResource()
                        result.resources.append(virtual_machine_image_resource_instance)
                        
                        id_value = resources_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            virtual_machine_image_resource_instance.id = id_instance
                        
                        name_value = resources_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_image_resource_instance.name = name_instance
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_image_resource_instance.location = location_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_skus(self, parameters):
        """
         Gets a list of virtual machine image skus.
         
         Args:
         
         parameters (VirtualMachineImageListSkusParameters)
         
         Returns:
         
         VirtualMachineImageResourceList: A list of virtual machine image
         resource information.
        """
        # Validate
        if parameters is not None:
            if parameters.location is None:
                raise ValueError('parameters.location cannot be None.')
            
            if parameters.offer is None:
                raise ValueError('parameters.offer cannot be None.')
            
            if parameters.publisher_name is None:
                raise ValueError('parameters.publisher_name cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        if parameters is not None:
            url = url + quote(parameters.location)
        
        url = url + '/publishers/'
        if parameters is not None:
            url = url + quote(parameters.publisher_name)
        
        url = url + '/artifacttypes/vmimage/offers/'
        if parameters is not None:
            url = url + quote(parameters.offer)
        
        url = url + '/skus'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineImageResourceList(resources=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resources_array = response_doc
                if resources_array is not None:
                    for resources_value in resources_array:
                        virtual_machine_image_resource_instance = VirtualMachineImageResource()
                        result.resources.append(virtual_machine_image_resource_instance)
                        
                        id_value = resources_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            virtual_machine_image_resource_instance.id = id_instance
                        
                        name_value = resources_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_image_resource_instance.name = name_instance
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_image_resource_instance.location = location_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class VirtualMachineOperations(object):
    """
     Operations for managing the virtual machines in compute management.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ComputeManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Compute.ComputeManagementClient.
        """
        return self._client
    
    def begin_capturing(self, resource_group_name, vm_name, parameters):
        """
         Captures the VM by copying VirtualHardDisks of the VM and outputs a
         template that can be used to create similar VMs.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         parameters (VirtualMachineCaptureParameters): Parameters supplied to
         the Capture Virtual Machine operation.
         
         Returns:
         
         ComputeOperationResponse: The compute long running operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.destination_container_name is None:
            raise ValueError('parameters.destination_container_name cannot be None.')
        
        if parameters.overwrite is None:
            raise ValueError('parameters.overwrite cannot be None.')
        
        if parameters.virtual_hard_disk_name_prefix is None:
            raise ValueError('parameters.virtual_hard_disk_name_prefix cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/capture'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        virtual_machine_capture_parameters_value = {}
        request_doc = virtual_machine_capture_parameters_value
        
        virtual_machine_capture_parameters_value['vhdPrefix'] = parameters.virtual_hard_disk_name_prefix
        
        virtual_machine_capture_parameters_value['destinationContainerName'] = parameters.destination_container_name
        
        virtual_machine_capture_parameters_value['overwriteVhds'] = parameters.overwrite
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ComputeOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_creating_or_updating(self, resource_group_name, parameters):
        """
         The operation to create or update a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         parameters (VirtualMachine): Parameters supplied to the Create Virtual
         Machine operation.
         
         Returns:
         
         VirtualMachineCreateOrUpdateResponse: The Create Virtual Machine
         operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.extensions is not None:
            for extensions_parameter_item in parameters.extensions:
                if extensions_parameter_item.location is None:
                    raise ValueError('parameters.extensions.location cannot be None.')
                
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        if parameters.storage_profile is not None:
            if parameters.storage_profile.data_disks is not None:
                for data_disks_parameter_item in parameters.storage_profile.data_disks:
                    if data_disks_parameter_item.create_option is None:
                        raise ValueError('parameters.storage_profile.data_disks.create_option cannot be None.')
                    
                    if data_disks_parameter_item.lun is None:
                        raise ValueError('parameters.storage_profile.data_disks.lun cannot be None.')
                    
                    if data_disks_parameter_item.name is None:
                        raise ValueError('parameters.storage_profile.data_disks.name cannot be None.')
                    
                    if data_disks_parameter_item.virtual_hard_disk is None:
                        raise ValueError('parameters.storage_profile.data_disks.virtual_hard_disk cannot be None.')
                    
            if parameters.storage_profile.os_disk is not None:
                if parameters.storage_profile.os_disk.create_option is None:
                    raise ValueError('parameters.storage_profile.os_disk.create_option cannot be None.')
                
                if parameters.storage_profile.os_disk.name is None:
                    raise ValueError('parameters.storage_profile.os_disk.name cannot be None.')
                
                if parameters.storage_profile.os_disk.virtual_hard_disk is None:
                    raise ValueError('parameters.storage_profile.os_disk.virtual_hard_disk cannot be None.')
                
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        if parameters.name is not None:
            url = url + quote(parameters.name)
        
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        virtual_machine_json_value = {}
        request_doc = virtual_machine_json_value
        
        if parameters.plan is not None:
            plan_value = {}
            virtual_machine_json_value['plan'] = plan_value
            
            if parameters.plan.name is not None:
                plan_value['name'] = parameters.plan.name
            
            if parameters.plan.publisher is not None:
                plan_value['publisher'] = parameters.plan.publisher
            
            if parameters.plan.product is not None:
                plan_value['product'] = parameters.plan.product
            
            if parameters.plan.promotion_code is not None:
                plan_value['promotionCode'] = parameters.plan.promotion_code
            
        properties_value = {}
        virtual_machine_json_value['properties'] = properties_value
        
        if parameters.hardware_profile is not None:
            hardware_profile_value = {}
            properties_value['hardwareProfile'] = hardware_profile_value
            
            if parameters.hardware_profile.virtual_machine_size is not None:
                hardware_profile_value['vmSize'] = parameters.hardware_profile.virtual_machine_size
            
        if parameters.storage_profile is not None:
            storage_profile_value = {}
            properties_value['storageProfile'] = storage_profile_value
            
            if parameters.storage_profile.image_reference is not None:
                image_reference_value = {}
                storage_profile_value['imageReference'] = image_reference_value
                
                if parameters.storage_profile.image_reference.publisher is not None:
                    image_reference_value['publisher'] = parameters.storage_profile.image_reference.publisher
                
                if parameters.storage_profile.image_reference.offer is not None:
                    image_reference_value['offer'] = parameters.storage_profile.image_reference.offer
                
                if parameters.storage_profile.image_reference.sku is not None:
                    image_reference_value['sku'] = parameters.storage_profile.image_reference.sku
                
                if parameters.storage_profile.image_reference.version is not None:
                    image_reference_value['version'] = parameters.storage_profile.image_reference.version
                
            if parameters.storage_profile.source_image is not None:
                source_image_value = {}
                storage_profile_value['sourceImage'] = source_image_value
                
                if parameters.storage_profile.source_image.reference_uri is not None:
                    source_image_value['id'] = parameters.storage_profile.source_image.reference_uri
                
            if parameters.storage_profile.os_disk is not None:
                os_disk_value = {}
                storage_profile_value['osDisk'] = os_disk_value
                
                if parameters.storage_profile.os_disk.operating_system_type is not None:
                    os_disk_value['osType'] = parameters.storage_profile.os_disk.operating_system_type
                
                os_disk_value['name'] = parameters.storage_profile.os_disk.name
                
                vhd_value = {}
                os_disk_value['vhd'] = vhd_value
                
                if parameters.storage_profile.os_disk.virtual_hard_disk.uri is not None:
                    vhd_value['uri'] = parameters.storage_profile.os_disk.virtual_hard_disk.uri
                
                if parameters.storage_profile.os_disk.source_image is not None:
                    image_value = {}
                    os_disk_value['image'] = image_value
                    
                    if parameters.storage_profile.os_disk.source_image.uri is not None:
                        image_value['uri'] = parameters.storage_profile.os_disk.source_image.uri
                    
                if parameters.storage_profile.os_disk.caching is not None:
                    os_disk_value['caching'] = parameters.storage_profile.os_disk.caching
                
                os_disk_value['createOption'] = parameters.storage_profile.os_disk.create_option
            
            if parameters.storage_profile.data_disks is not None:
                data_disks_array = []
                for data_disks_item in parameters.storage_profile.data_disks:
                    data_disk_value = {}
                    data_disks_array.append(data_disk_value)
                    
                    data_disk_value['lun'] = data_disks_item.lun
                    
                    if data_disks_item.disk_size_gb is not None:
                        data_disk_value['diskSizeGB'] = data_disks_item.disk_size_gb
                    
                    data_disk_value['name'] = data_disks_item.name
                    
                    vhd_value2 = {}
                    data_disk_value['vhd'] = vhd_value2
                    
                    if data_disks_item.virtual_hard_disk.uri is not None:
                        vhd_value2['uri'] = data_disks_item.virtual_hard_disk.uri
                    
                    if data_disks_item.source_image is not None:
                        image_value2 = {}
                        data_disk_value['image'] = image_value2
                        
                        if data_disks_item.source_image.uri is not None:
                            image_value2['uri'] = data_disks_item.source_image.uri
                        
                    if data_disks_item.caching is not None:
                        data_disk_value['caching'] = data_disks_item.caching
                    
                    data_disk_value['createOption'] = data_disks_item.create_option
                
                storage_profile_value['dataDisks'] = data_disks_array
            
        if parameters.os_profile is not None:
            os_profile_value = {}
            properties_value['osProfile'] = os_profile_value
            
            if parameters.os_profile.computer_name is not None:
                os_profile_value['computerName'] = parameters.os_profile.computer_name
            
            if parameters.os_profile.admin_username is not None:
                os_profile_value['adminUsername'] = parameters.os_profile.admin_username
            
            if parameters.os_profile.admin_password is not None:
                os_profile_value['adminPassword'] = parameters.os_profile.admin_password
            
            if parameters.os_profile.custom_data is not None:
                os_profile_value['customData'] = parameters.os_profile.custom_data
            
            if parameters.os_profile.windows_configuration is not None:
                windows_configuration_value = {}
                os_profile_value['windowsConfiguration'] = windows_configuration_value
                
                if parameters.os_profile.windows_configuration.provision_vm_agent is not None:
                    windows_configuration_value['provisionVMAgent'] = parameters.os_profile.windows_configuration.provision_vm_agent
                
                if parameters.os_profile.windows_configuration.enable_automatic_updates is not None:
                    windows_configuration_value['enableAutomaticUpdates'] = parameters.os_profile.windows_configuration.enable_automatic_updates
                
                if parameters.os_profile.windows_configuration.time_zone is not None:
                    windows_configuration_value['timeZone'] = parameters.os_profile.windows_configuration.time_zone
                
                if parameters.os_profile.windows_configuration.additional_unattend_contents is not None:
                    additional_unattend_content_array = []
                    for additional_unattend_content_item in parameters.os_profile.windows_configuration.additional_unattend_contents:
                        additional_unattend_content_value = {}
                        additional_unattend_content_array.append(additional_unattend_content_value)
                        
                        if additional_unattend_content_item.pass_name is not None:
                            additional_unattend_content_value['passName'] = additional_unattend_content_item.pass_name
                        
                        if additional_unattend_content_item.component_name is not None:
                            additional_unattend_content_value['componentName'] = additional_unattend_content_item.component_name
                        
                        if additional_unattend_content_item.setting_name is not None:
                            additional_unattend_content_value['settingName'] = additional_unattend_content_item.setting_name
                        
                        if additional_unattend_content_item.content is not None:
                            additional_unattend_content_value['content'] = additional_unattend_content_item.content
                        
                    windows_configuration_value['additionalUnattendContent'] = additional_unattend_content_array
                
                if parameters.os_profile.windows_configuration.win_rm_configuration is not None:
                    win_rm_value = {}
                    windows_configuration_value['winRM'] = win_rm_value
                    
                    if parameters.os_profile.windows_configuration.win_rm_configuration.listeners is not None:
                        listeners_array = []
                        for listeners_item in parameters.os_profile.windows_configuration.win_rm_configuration.listeners:
                            win_rm_listener_value = {}
                            listeners_array.append(win_rm_listener_value)
                            
                            if listeners_item.protocol is not None:
                                win_rm_listener_value['protocol'] = listeners_item.protocol
                            
                            if listeners_item.certificate_url is not None:
                                win_rm_listener_value['certificateUrl'] = listeners_item.certificate_url
                            
                        win_rm_value['listeners'] = listeners_array
                    
            if parameters.os_profile.linux_configuration is not None:
                linux_configuration_value = {}
                os_profile_value['linuxConfiguration'] = linux_configuration_value
                
                if parameters.os_profile.linux_configuration.disable_password_authentication is not None:
                    linux_configuration_value['disablePasswordAuthentication'] = parameters.os_profile.linux_configuration.disable_password_authentication
                
                if parameters.os_profile.linux_configuration.ssh_configuration is not None:
                    ssh_value = {}
                    linux_configuration_value['ssh'] = ssh_value
                    
                    if parameters.os_profile.linux_configuration.ssh_configuration.public_keys is not None:
                        public_keys_array = []
                        for public_keys_item in parameters.os_profile.linux_configuration.ssh_configuration.public_keys:
                            ssh_public_key_value = {}
                            public_keys_array.append(ssh_public_key_value)
                            
                            if public_keys_item.path is not None:
                                ssh_public_key_value['path'] = public_keys_item.path
                            
                            if public_keys_item.key_data is not None:
                                ssh_public_key_value['keyData'] = public_keys_item.key_data
                            
                        ssh_value['publicKeys'] = public_keys_array
                    
            if parameters.os_profile.secrets is not None:
                secrets_array = []
                for secrets_item in parameters.os_profile.secrets:
                    vault_secret_group_value = {}
                    secrets_array.append(vault_secret_group_value)
                    
                    if secrets_item.source_vault is not None:
                        source_vault_value = {}
                        vault_secret_group_value['sourceVault'] = source_vault_value
                        
                        if secrets_item.source_vault.reference_uri is not None:
                            source_vault_value['id'] = secrets_item.source_vault.reference_uri
                        
                    if secrets_item.vault_certificates is not None:
                        vault_certificates_array = []
                        for vault_certificates_item in secrets_item.vault_certificates:
                            vault_certificate_value = {}
                            vault_certificates_array.append(vault_certificate_value)
                            
                            if vault_certificates_item.certificate_url is not None:
                                vault_certificate_value['certificateUrl'] = vault_certificates_item.certificate_url
                            
                            if vault_certificates_item.certificate_store is not None:
                                vault_certificate_value['certificateStore'] = vault_certificates_item.certificate_store
                            
                        vault_secret_group_value['vaultCertificates'] = vault_certificates_array
                    
                os_profile_value['secrets'] = secrets_array
            
        if parameters.network_profile is not None:
            network_profile_value = {}
            properties_value['networkProfile'] = network_profile_value
            
            if parameters.network_profile.network_interfaces is not None:
                network_interfaces_array = []
                for network_interfaces_item in parameters.network_profile.network_interfaces:
                    network_interface_reference_json_value = {}
                    network_interfaces_array.append(network_interface_reference_json_value)
                    
                    properties_value2 = {}
                    network_interface_reference_json_value['properties'] = properties_value2
                    
                    if network_interfaces_item.primary is not None:
                        properties_value2['primary'] = network_interfaces_item.primary
                    
                    if network_interfaces_item.reference_uri is not None:
                        network_interface_reference_json_value['id'] = network_interfaces_item.reference_uri
                    
                network_profile_value['networkInterfaces'] = network_interfaces_array
            
        if parameters.availability_set_reference is not None:
            availability_set_value = {}
            properties_value['availabilitySet'] = availability_set_value
            
            if parameters.availability_set_reference.reference_uri is not None:
                availability_set_value['id'] = parameters.availability_set_reference.reference_uri
            
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.instance_view is not None:
            instance_view_value = {}
            properties_value['instanceView'] = instance_view_value
            
            if parameters.instance_view.platform_update_domain is not None:
                instance_view_value['platformUpdateDomain'] = parameters.instance_view.platform_update_domain
            
            if parameters.instance_view.platform_fault_domain is not None:
                instance_view_value['platformFaultDomain'] = parameters.instance_view.platform_fault_domain
            
            if parameters.instance_view.remote_desktop_thumbprint is not None:
                instance_view_value['rdpThumbPrint'] = parameters.instance_view.remote_desktop_thumbprint
            
            if parameters.instance_view.vm_agent is not None:
                vm_agent_value = {}
                instance_view_value['vmAgent'] = vm_agent_value
                
                if parameters.instance_view.vm_agent.vm_agent_version is not None:
                    vm_agent_value['vmAgentVersion'] = parameters.instance_view.vm_agent.vm_agent_version
                
                if parameters.instance_view.vm_agent.extension_handlers is not None:
                    extension_handlers_array = []
                    for extension_handlers_item in parameters.instance_view.vm_agent.extension_handlers:
                        virtual_machine_extension_handler_instance_view_value = {}
                        extension_handlers_array.append(virtual_machine_extension_handler_instance_view_value)
                        
                        if extension_handlers_item.type is not None:
                            virtual_machine_extension_handler_instance_view_value['type'] = extension_handlers_item.type
                        
                        if extension_handlers_item.type_handler_version is not None:
                            virtual_machine_extension_handler_instance_view_value['typeHandlerVersion'] = extension_handlers_item.type_handler_version
                        
                        if extension_handlers_item.status is not None:
                            status_value = {}
                            virtual_machine_extension_handler_instance_view_value['status'] = status_value
                            
                            if extension_handlers_item.status.code is not None:
                                status_value['code'] = extension_handlers_item.status.code
                            
                            if extension_handlers_item.status.level is not None:
                                status_value['level'] = extension_handlers_item.status.level
                            
                            if extension_handlers_item.status.display_status is not None:
                                status_value['displayStatus'] = extension_handlers_item.status.display_status
                            
                            if extension_handlers_item.status.message is not None:
                                status_value['message'] = extension_handlers_item.status.message
                            
                            if extension_handlers_item.status.time is not None:
                                status_value['time'] = extension_handlers_item.status.time
                            
                    vm_agent_value['extensionHandlers'] = extension_handlers_array
                
                if parameters.instance_view.vm_agent.statuses is not None:
                    statuses_array = []
                    for statuses_item in parameters.instance_view.vm_agent.statuses:
                        instance_view_status_value = {}
                        statuses_array.append(instance_view_status_value)
                        
                        if statuses_item.code is not None:
                            instance_view_status_value['code'] = statuses_item.code
                        
                        if statuses_item.level is not None:
                            instance_view_status_value['level'] = statuses_item.level
                        
                        if statuses_item.display_status is not None:
                            instance_view_status_value['displayStatus'] = statuses_item.display_status
                        
                        if statuses_item.message is not None:
                            instance_view_status_value['message'] = statuses_item.message
                        
                        if statuses_item.time is not None:
                            instance_view_status_value['time'] = statuses_item.time
                        
                    vm_agent_value['statuses'] = statuses_array
                
            if parameters.instance_view.disks is not None:
                disks_array = []
                for disks_item in parameters.instance_view.disks:
                    disk_instance_view_value = {}
                    disks_array.append(disk_instance_view_value)
                    
                    if disks_item.name is not None:
                        disk_instance_view_value['name'] = disks_item.name
                    
                    if disks_item.statuses is not None:
                        statuses_array2 = []
                        for statuses_item2 in disks_item.statuses:
                            instance_view_status_value2 = {}
                            statuses_array2.append(instance_view_status_value2)
                            
                            if statuses_item2.code is not None:
                                instance_view_status_value2['code'] = statuses_item2.code
                            
                            if statuses_item2.level is not None:
                                instance_view_status_value2['level'] = statuses_item2.level
                            
                            if statuses_item2.display_status is not None:
                                instance_view_status_value2['displayStatus'] = statuses_item2.display_status
                            
                            if statuses_item2.message is not None:
                                instance_view_status_value2['message'] = statuses_item2.message
                            
                            if statuses_item2.time is not None:
                                instance_view_status_value2['time'] = statuses_item2.time
                            
                        disk_instance_view_value['statuses'] = statuses_array2
                    
                instance_view_value['disks'] = disks_array
            
            if parameters.instance_view.extensions is not None:
                extensions_array = []
                for extensions_item in parameters.instance_view.extensions:
                    virtual_machine_extension_instance_view_value = {}
                    extensions_array.append(virtual_machine_extension_instance_view_value)
                    
                    if extensions_item.name is not None:
                        virtual_machine_extension_instance_view_value['name'] = extensions_item.name
                    
                    if extensions_item.extension_type is not None:
                        virtual_machine_extension_instance_view_value['type'] = extensions_item.extension_type
                    
                    if extensions_item.type_handler_version is not None:
                        virtual_machine_extension_instance_view_value['typeHandlerVersion'] = extensions_item.type_handler_version
                    
                    if extensions_item.sub_statuses is not None:
                        substatuses_array = []
                        for substatuses_item in extensions_item.sub_statuses:
                            instance_view_status_value3 = {}
                            substatuses_array.append(instance_view_status_value3)
                            
                            if substatuses_item.code is not None:
                                instance_view_status_value3['code'] = substatuses_item.code
                            
                            if substatuses_item.level is not None:
                                instance_view_status_value3['level'] = substatuses_item.level
                            
                            if substatuses_item.display_status is not None:
                                instance_view_status_value3['displayStatus'] = substatuses_item.display_status
                            
                            if substatuses_item.message is not None:
                                instance_view_status_value3['message'] = substatuses_item.message
                            
                            if substatuses_item.time is not None:
                                instance_view_status_value3['time'] = substatuses_item.time
                            
                        virtual_machine_extension_instance_view_value['substatuses'] = substatuses_array
                    
                    if extensions_item.statuses is not None:
                        statuses_array3 = []
                        for statuses_item3 in extensions_item.statuses:
                            instance_view_status_value4 = {}
                            statuses_array3.append(instance_view_status_value4)
                            
                            if statuses_item3.code is not None:
                                instance_view_status_value4['code'] = statuses_item3.code
                            
                            if statuses_item3.level is not None:
                                instance_view_status_value4['level'] = statuses_item3.level
                            
                            if statuses_item3.display_status is not None:
                                instance_view_status_value4['displayStatus'] = statuses_item3.display_status
                            
                            if statuses_item3.message is not None:
                                instance_view_status_value4['message'] = statuses_item3.message
                            
                            if statuses_item3.time is not None:
                                instance_view_status_value4['time'] = statuses_item3.time
                            
                        virtual_machine_extension_instance_view_value['statuses'] = statuses_array3
                    
                instance_view_value['extensions'] = extensions_array
            
            if parameters.instance_view.statuses is not None:
                statuses_array4 = []
                for statuses_item4 in parameters.instance_view.statuses:
                    instance_view_status_value5 = {}
                    statuses_array4.append(instance_view_status_value5)
                    
                    if statuses_item4.code is not None:
                        instance_view_status_value5['code'] = statuses_item4.code
                    
                    if statuses_item4.level is not None:
                        instance_view_status_value5['level'] = statuses_item4.level
                    
                    if statuses_item4.display_status is not None:
                        instance_view_status_value5['displayStatus'] = statuses_item4.display_status
                    
                    if statuses_item4.message is not None:
                        instance_view_status_value5['message'] = statuses_item4.message
                    
                    if statuses_item4.time is not None:
                        instance_view_status_value5['time'] = statuses_item4.time
                    
                instance_view_value['statuses'] = statuses_array4
            
        if parameters.extensions is not None:
            resources_array = []
            for resources_item in parameters.extensions:
                virtual_machine_extension_json_value = {}
                resources_array.append(virtual_machine_extension_json_value)
                
                properties_value3 = {}
                virtual_machine_extension_json_value['properties'] = properties_value3
                
                if resources_item.publisher is not None:
                    properties_value3['publisher'] = resources_item.publisher
                
                if resources_item.extension_type is not None:
                    properties_value3['type'] = resources_item.extension_type
                
                if resources_item.type_handler_version is not None:
                    properties_value3['typeHandlerVersion'] = resources_item.type_handler_version
                
                if resources_item.auto_upgrade_minor_version is not None:
                    properties_value3['autoUpgradeMinorVersion'] = resources_item.auto_upgrade_minor_version
                
                if resources_item.settings is not None:
                    properties_value3['settings'] = json.loads(resources_item.settings)
                
                if resources_item.protected_settings is not None:
                    properties_value3['protectedSettings'] = json.loads(resources_item.protected_settings)
                
                if resources_item.provisioning_state is not None:
                    properties_value3['provisioningState'] = resources_item.provisioning_state
                
                if resources_item.instance_view is not None:
                    instance_view_value2 = {}
                    properties_value3['instanceView'] = instance_view_value2
                    
                    if resources_item.instance_view.name is not None:
                        instance_view_value2['name'] = resources_item.instance_view.name
                    
                    if resources_item.instance_view.extension_type is not None:
                        instance_view_value2['type'] = resources_item.instance_view.extension_type
                    
                    if resources_item.instance_view.type_handler_version is not None:
                        instance_view_value2['typeHandlerVersion'] = resources_item.instance_view.type_handler_version
                    
                    if resources_item.instance_view.sub_statuses is not None:
                        substatuses_array2 = []
                        for substatuses_item2 in resources_item.instance_view.sub_statuses:
                            instance_view_status_value6 = {}
                            substatuses_array2.append(instance_view_status_value6)
                            
                            if substatuses_item2.code is not None:
                                instance_view_status_value6['code'] = substatuses_item2.code
                            
                            if substatuses_item2.level is not None:
                                instance_view_status_value6['level'] = substatuses_item2.level
                            
                            if substatuses_item2.display_status is not None:
                                instance_view_status_value6['displayStatus'] = substatuses_item2.display_status
                            
                            if substatuses_item2.message is not None:
                                instance_view_status_value6['message'] = substatuses_item2.message
                            
                            if substatuses_item2.time is not None:
                                instance_view_status_value6['time'] = substatuses_item2.time
                            
                        instance_view_value2['substatuses'] = substatuses_array2
                    
                    if resources_item.instance_view.statuses is not None:
                        statuses_array5 = []
                        for statuses_item5 in resources_item.instance_view.statuses:
                            instance_view_status_value7 = {}
                            statuses_array5.append(instance_view_status_value7)
                            
                            if statuses_item5.code is not None:
                                instance_view_status_value7['code'] = statuses_item5.code
                            
                            if statuses_item5.level is not None:
                                instance_view_status_value7['level'] = statuses_item5.level
                            
                            if statuses_item5.display_status is not None:
                                instance_view_status_value7['displayStatus'] = statuses_item5.display_status
                            
                            if statuses_item5.message is not None:
                                instance_view_status_value7['message'] = statuses_item5.message
                            
                            if statuses_item5.time is not None:
                                instance_view_status_value7['time'] = statuses_item5.time
                            
                        instance_view_value2['statuses'] = statuses_array5
                    
                if resources_item.id is not None:
                    virtual_machine_extension_json_value['id'] = resources_item.id
                
                if resources_item.name is not None:
                    virtual_machine_extension_json_value['name'] = resources_item.name
                
                if resources_item.type is not None:
                    virtual_machine_extension_json_value['type'] = resources_item.type
                
                virtual_machine_extension_json_value['location'] = resources_item.location
                
                if resources_item.tags is not None:
                    tags_dictionary = {}
                    for tags_key in resources_item.tags:
                        tags_value = resources_item.tags[tags_key]
                        tags_dictionary[tags_key] = tags_value
                    
                    virtual_machine_extension_json_value['tags'] = tags_dictionary
                
            virtual_machine_json_value['resources'] = resources_array
        
        if parameters.id is not None:
            virtual_machine_json_value['id'] = parameters.id
        
        if parameters.name is not None:
            virtual_machine_json_value['name'] = parameters.name
        
        if parameters.type is not None:
            virtual_machine_json_value['type'] = parameters.type
        
        virtual_machine_json_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary2 = {}
            for tags_key2 in parameters.tags:
                tags_value2 = parameters.tags[tags_key2]
                tags_dictionary2[tags_key2] = tags_value2
            
            virtual_machine_json_value['tags'] = tags_dictionary2
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = VirtualMachineCreateOrUpdateResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_machine_instance = VirtualMachine(extensions=[], tags={})
                result.virtual_machine = virtual_machine_instance
                
                plan_value2 = response_doc.get('plan', None)
                if plan_value2 is not None:
                    plan_instance = Plan()
                    virtual_machine_instance.plan = plan_instance
                    
                    name_value = plan_value2.get('name', None)
                    if name_value is not None:
                        name_instance = name_value
                        plan_instance.name = name_instance
                    
                    publisher_value = plan_value2.get('publisher', None)
                    if publisher_value is not None:
                        publisher_instance = publisher_value
                        plan_instance.publisher = publisher_instance
                    
                    product_value = plan_value2.get('product', None)
                    if product_value is not None:
                        product_instance = product_value
                        plan_instance.product = product_instance
                    
                    promotion_code_value = plan_value2.get('promotionCode', None)
                    if promotion_code_value is not None:
                        promotion_code_instance = promotion_code_value
                        plan_instance.promotion_code = promotion_code_instance
                    
                properties_value4 = response_doc.get('properties', None)
                if properties_value4 is not None:
                    hardware_profile_value2 = properties_value4.get('hardwareProfile', None)
                    if hardware_profile_value2 is not None:
                        hardware_profile_instance = HardwareProfile()
                        virtual_machine_instance.hardware_profile = hardware_profile_instance
                        
                        vm_size_value = hardware_profile_value2.get('vmSize', None)
                        if vm_size_value is not None:
                            vm_size_instance = vm_size_value
                            hardware_profile_instance.virtual_machine_size = vm_size_instance
                        
                    storage_profile_value2 = properties_value4.get('storageProfile', None)
                    if storage_profile_value2 is not None:
                        storage_profile_instance = StorageProfile(data_disks=[])
                        virtual_machine_instance.storage_profile = storage_profile_instance
                        
                        image_reference_value2 = storage_profile_value2.get('imageReference', None)
                        if image_reference_value2 is not None:
                            image_reference_instance = ImageReference()
                            storage_profile_instance.image_reference = image_reference_instance
                            
                            publisher_value2 = image_reference_value2.get('publisher', None)
                            if publisher_value2 is not None:
                                publisher_instance2 = publisher_value2
                                image_reference_instance.publisher = publisher_instance2
                            
                            offer_value = image_reference_value2.get('offer', None)
                            if offer_value is not None:
                                offer_instance = offer_value
                                image_reference_instance.offer = offer_instance
                            
                            sku_value = image_reference_value2.get('sku', None)
                            if sku_value is not None:
                                sku_instance = sku_value
                                image_reference_instance.sku = sku_instance
                            
                            version_value = image_reference_value2.get('version', None)
                            if version_value is not None:
                                version_instance = version_value
                                image_reference_instance.version = version_instance
                            
                        source_image_value2 = storage_profile_value2.get('sourceImage', None)
                        if source_image_value2 is not None:
                            source_image_instance = SourceImageReference()
                            storage_profile_instance.source_image = source_image_instance
                            
                            id_value = source_image_value2.get('id', None)
                            if id_value is not None:
                                id_instance = id_value
                                source_image_instance.reference_uri = id_instance
                            
                        os_disk_value2 = storage_profile_value2.get('osDisk', None)
                        if os_disk_value2 is not None:
                            os_disk_instance = OSDisk()
                            storage_profile_instance.os_disk = os_disk_instance
                            
                            os_type_value = os_disk_value2.get('osType', None)
                            if os_type_value is not None:
                                os_type_instance = os_type_value
                                os_disk_instance.operating_system_type = os_type_instance
                            
                            name_value2 = os_disk_value2.get('name', None)
                            if name_value2 is not None:
                                name_instance2 = name_value2
                                os_disk_instance.name = name_instance2
                            
                            vhd_value3 = os_disk_value2.get('vhd', None)
                            if vhd_value3 is not None:
                                vhd_instance = VirtualHardDisk()
                                os_disk_instance.virtual_hard_disk = vhd_instance
                                
                                uri_value = vhd_value3.get('uri', None)
                                if uri_value is not None:
                                    uri_instance = uri_value
                                    vhd_instance.uri = uri_instance
                                
                            image_value3 = os_disk_value2.get('image', None)
                            if image_value3 is not None:
                                image_instance = VirtualHardDisk()
                                os_disk_instance.source_image = image_instance
                                
                                uri_value2 = image_value3.get('uri', None)
                                if uri_value2 is not None:
                                    uri_instance2 = uri_value2
                                    image_instance.uri = uri_instance2
                                
                            caching_value = os_disk_value2.get('caching', None)
                            if caching_value is not None:
                                caching_instance = caching_value
                                os_disk_instance.caching = caching_instance
                            
                            create_option_value = os_disk_value2.get('createOption', None)
                            if create_option_value is not None:
                                create_option_instance = create_option_value
                                os_disk_instance.create_option = create_option_instance
                            
                        data_disks_array2 = storage_profile_value2.get('dataDisks', None)
                        if data_disks_array2 is not None:
                            for data_disks_value in data_disks_array2:
                                data_disk_instance = DataDisk()
                                storage_profile_instance.data_disks.append(data_disk_instance)
                                
                                lun_value = data_disks_value.get('lun', None)
                                if lun_value is not None:
                                    lun_instance = lun_value
                                    data_disk_instance.lun = lun_instance
                                
                                disk_size_gb_value = data_disks_value.get('diskSizeGB', None)
                                if disk_size_gb_value is not None:
                                    disk_size_gb_instance = disk_size_gb_value
                                    data_disk_instance.disk_size_gb = disk_size_gb_instance
                                
                                name_value3 = data_disks_value.get('name', None)
                                if name_value3 is not None:
                                    name_instance3 = name_value3
                                    data_disk_instance.name = name_instance3
                                
                                vhd_value4 = data_disks_value.get('vhd', None)
                                if vhd_value4 is not None:
                                    vhd_instance2 = VirtualHardDisk()
                                    data_disk_instance.virtual_hard_disk = vhd_instance2
                                    
                                    uri_value3 = vhd_value4.get('uri', None)
                                    if uri_value3 is not None:
                                        uri_instance3 = uri_value3
                                        vhd_instance2.uri = uri_instance3
                                    
                                image_value4 = data_disks_value.get('image', None)
                                if image_value4 is not None:
                                    image_instance2 = VirtualHardDisk()
                                    data_disk_instance.source_image = image_instance2
                                    
                                    uri_value4 = image_value4.get('uri', None)
                                    if uri_value4 is not None:
                                        uri_instance4 = uri_value4
                                        image_instance2.uri = uri_instance4
                                    
                                caching_value2 = data_disks_value.get('caching', None)
                                if caching_value2 is not None:
                                    caching_instance2 = caching_value2
                                    data_disk_instance.caching = caching_instance2
                                
                                create_option_value2 = data_disks_value.get('createOption', None)
                                if create_option_value2 is not None:
                                    create_option_instance2 = create_option_value2
                                    data_disk_instance.create_option = create_option_instance2
                                
                    os_profile_value2 = properties_value4.get('osProfile', None)
                    if os_profile_value2 is not None:
                        os_profile_instance = OSProfile(secrets=[])
                        virtual_machine_instance.os_profile = os_profile_instance
                        
                        computer_name_value = os_profile_value2.get('computerName', None)
                        if computer_name_value is not None:
                            computer_name_instance = computer_name_value
                            os_profile_instance.computer_name = computer_name_instance
                        
                        admin_username_value = os_profile_value2.get('adminUsername', None)
                        if admin_username_value is not None:
                            admin_username_instance = admin_username_value
                            os_profile_instance.admin_username = admin_username_instance
                        
                        admin_password_value = os_profile_value2.get('adminPassword', None)
                        if admin_password_value is not None:
                            admin_password_instance = admin_password_value
                            os_profile_instance.admin_password = admin_password_instance
                        
                        custom_data_value = os_profile_value2.get('customData', None)
                        if custom_data_value is not None:
                            custom_data_instance = custom_data_value
                            os_profile_instance.custom_data = custom_data_instance
                        
                        windows_configuration_value2 = os_profile_value2.get('windowsConfiguration', None)
                        if windows_configuration_value2 is not None:
                            windows_configuration_instance = WindowsConfiguration(additional_unattend_contents=[])
                            os_profile_instance.windows_configuration = windows_configuration_instance
                            
                            provision_vm_agent_value = windows_configuration_value2.get('provisionVMAgent', None)
                            if provision_vm_agent_value is not None:
                                provision_vm_agent_instance = provision_vm_agent_value
                                windows_configuration_instance.provision_vm_agent = provision_vm_agent_instance
                            
                            enable_automatic_updates_value = windows_configuration_value2.get('enableAutomaticUpdates', None)
                            if enable_automatic_updates_value is not None:
                                enable_automatic_updates_instance = enable_automatic_updates_value
                                windows_configuration_instance.enable_automatic_updates = enable_automatic_updates_instance
                            
                            time_zone_value = windows_configuration_value2.get('timeZone', None)
                            if time_zone_value is not None:
                                time_zone_instance = time_zone_value
                                windows_configuration_instance.time_zone = time_zone_instance
                            
                            additional_unattend_content_array2 = windows_configuration_value2.get('additionalUnattendContent', None)
                            if additional_unattend_content_array2 is not None:
                                for additional_unattend_content_value2 in additional_unattend_content_array2:
                                    additional_unattend_content_instance = AdditionalUnattendContent()
                                    windows_configuration_instance.additional_unattend_contents.append(additional_unattend_content_instance)
                                    
                                    pass_name_value = additional_unattend_content_value2.get('passName', None)
                                    if pass_name_value is not None:
                                        pass_name_instance = pass_name_value
                                        additional_unattend_content_instance.pass_name = pass_name_instance
                                    
                                    component_name_value = additional_unattend_content_value2.get('componentName', None)
                                    if component_name_value is not None:
                                        component_name_instance = component_name_value
                                        additional_unattend_content_instance.component_name = component_name_instance
                                    
                                    setting_name_value = additional_unattend_content_value2.get('settingName', None)
                                    if setting_name_value is not None:
                                        setting_name_instance = setting_name_value
                                        additional_unattend_content_instance.setting_name = setting_name_instance
                                    
                                    content_value = additional_unattend_content_value2.get('content', None)
                                    if content_value is not None:
                                        content_instance = content_value
                                        additional_unattend_content_instance.content = content_instance
                                    
                            win_rm_value2 = windows_configuration_value2.get('winRM', None)
                            if win_rm_value2 is not None:
                                win_rm_instance = WinRMConfiguration(listeners=[])
                                windows_configuration_instance.win_rm_configuration = win_rm_instance
                                
                                listeners_array2 = win_rm_value2.get('listeners', None)
                                if listeners_array2 is not None:
                                    for listeners_value in listeners_array2:
                                        win_rm_listener_instance = WinRMListener()
                                        win_rm_instance.listeners.append(win_rm_listener_instance)
                                        
                                        protocol_value = listeners_value.get('protocol', None)
                                        if protocol_value is not None:
                                            protocol_instance = protocol_value
                                            win_rm_listener_instance.protocol = protocol_instance
                                        
                                        certificate_url_value = listeners_value.get('certificateUrl', None)
                                        if certificate_url_value is not None:
                                            certificate_url_instance = certificate_url_value
                                            win_rm_listener_instance.certificate_url = certificate_url_instance
                                        
                        linux_configuration_value2 = os_profile_value2.get('linuxConfiguration', None)
                        if linux_configuration_value2 is not None:
                            linux_configuration_instance = LinuxConfiguration()
                            os_profile_instance.linux_configuration = linux_configuration_instance
                            
                            disable_password_authentication_value = linux_configuration_value2.get('disablePasswordAuthentication', None)
                            if disable_password_authentication_value is not None:
                                disable_password_authentication_instance = disable_password_authentication_value
                                linux_configuration_instance.disable_password_authentication = disable_password_authentication_instance
                            
                            ssh_value2 = linux_configuration_value2.get('ssh', None)
                            if ssh_value2 is not None:
                                ssh_instance = SshConfiguration(public_keys=[])
                                linux_configuration_instance.ssh_configuration = ssh_instance
                                
                                public_keys_array2 = ssh_value2.get('publicKeys', None)
                                if public_keys_array2 is not None:
                                    for public_keys_value in public_keys_array2:
                                        ssh_public_key_instance = SshPublicKey()
                                        ssh_instance.public_keys.append(ssh_public_key_instance)
                                        
                                        path_value = public_keys_value.get('path', None)
                                        if path_value is not None:
                                            path_instance = path_value
                                            ssh_public_key_instance.path = path_instance
                                        
                                        key_data_value = public_keys_value.get('keyData', None)
                                        if key_data_value is not None:
                                            key_data_instance = key_data_value
                                            ssh_public_key_instance.key_data = key_data_instance
                                        
                        secrets_array2 = os_profile_value2.get('secrets', None)
                        if secrets_array2 is not None:
                            for secrets_value in secrets_array2:
                                vault_secret_group_instance = VaultSecretGroup(vault_certificates=[])
                                os_profile_instance.secrets.append(vault_secret_group_instance)
                                
                                source_vault_value2 = secrets_value.get('sourceVault', None)
                                if source_vault_value2 is not None:
                                    source_vault_instance = SourceVaultReference()
                                    vault_secret_group_instance.source_vault = source_vault_instance
                                    
                                    id_value2 = source_vault_value2.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        source_vault_instance.reference_uri = id_instance2
                                    
                                vault_certificates_array2 = secrets_value.get('vaultCertificates', None)
                                if vault_certificates_array2 is not None:
                                    for vault_certificates_value in vault_certificates_array2:
                                        vault_certificate_instance = VaultCertificate()
                                        vault_secret_group_instance.vault_certificates.append(vault_certificate_instance)
                                        
                                        certificate_url_value2 = vault_certificates_value.get('certificateUrl', None)
                                        if certificate_url_value2 is not None:
                                            certificate_url_instance2 = certificate_url_value2
                                            vault_certificate_instance.certificate_url = certificate_url_instance2
                                        
                                        certificate_store_value = vault_certificates_value.get('certificateStore', None)
                                        if certificate_store_value is not None:
                                            certificate_store_instance = certificate_store_value
                                            vault_certificate_instance.certificate_store = certificate_store_instance
                                        
                    network_profile_value2 = properties_value4.get('networkProfile', None)
                    if network_profile_value2 is not None:
                        network_profile_instance = NetworkProfile(network_interfaces=[])
                        virtual_machine_instance.network_profile = network_profile_instance
                        
                        network_interfaces_array2 = network_profile_value2.get('networkInterfaces', None)
                        if network_interfaces_array2 is not None:
                            for network_interfaces_value in network_interfaces_array2:
                                network_interface_reference_json_instance = NetworkInterfaceReference()
                                network_profile_instance.network_interfaces.append(network_interface_reference_json_instance)
                                
                                properties_value5 = network_interfaces_value.get('properties', None)
                                if properties_value5 is not None:
                                    primary_value = properties_value5.get('primary', None)
                                    if primary_value is not None:
                                        primary_instance = primary_value
                                        network_interface_reference_json_instance.primary = primary_instance
                                    
                                id_value3 = network_interfaces_value.get('id', None)
                                if id_value3 is not None:
                                    id_instance3 = id_value3
                                    network_interface_reference_json_instance.reference_uri = id_instance3
                                
                    availability_set_value2 = properties_value4.get('availabilitySet', None)
                    if availability_set_value2 is not None:
                        availability_set_instance = AvailabilitySetReference()
                        virtual_machine_instance.availability_set_reference = availability_set_instance
                        
                        id_value4 = availability_set_value2.get('id', None)
                        if id_value4 is not None:
                            id_instance4 = id_value4
                            availability_set_instance.reference_uri = id_instance4
                        
                    provisioning_state_value = properties_value4.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        virtual_machine_instance.provisioning_state = provisioning_state_instance
                    
                    instance_view_value3 = properties_value4.get('instanceView', None)
                    if instance_view_value3 is not None:
                        instance_view_instance = VirtualMachineInstanceView(disks=[], extensions=[], statuses=[])
                        virtual_machine_instance.instance_view = instance_view_instance
                        
                        platform_update_domain_value = instance_view_value3.get('platformUpdateDomain', None)
                        if platform_update_domain_value is not None:
                            platform_update_domain_instance = platform_update_domain_value
                            instance_view_instance.platform_update_domain = platform_update_domain_instance
                        
                        platform_fault_domain_value = instance_view_value3.get('platformFaultDomain', None)
                        if platform_fault_domain_value is not None:
                            platform_fault_domain_instance = platform_fault_domain_value
                            instance_view_instance.platform_fault_domain = platform_fault_domain_instance
                        
                        rdp_thumb_print_value = instance_view_value3.get('rdpThumbPrint', None)
                        if rdp_thumb_print_value is not None:
                            rdp_thumb_print_instance = rdp_thumb_print_value
                            instance_view_instance.remote_desktop_thumbprint = rdp_thumb_print_instance
                        
                        vm_agent_value2 = instance_view_value3.get('vmAgent', None)
                        if vm_agent_value2 is not None:
                            vm_agent_instance = VirtualMachineAgentInstanceView(extension_handlers=[], statuses=[])
                            instance_view_instance.vm_agent = vm_agent_instance
                            
                            vm_agent_version_value = vm_agent_value2.get('vmAgentVersion', None)
                            if vm_agent_version_value is not None:
                                vm_agent_version_instance = vm_agent_version_value
                                vm_agent_instance.vm_agent_version = vm_agent_version_instance
                            
                            extension_handlers_array2 = vm_agent_value2.get('extensionHandlers', None)
                            if extension_handlers_array2 is not None:
                                for extension_handlers_value in extension_handlers_array2:
                                    virtual_machine_extension_handler_instance_view_instance = VirtualMachineExtensionHandlerInstanceView()
                                    vm_agent_instance.extension_handlers.append(virtual_machine_extension_handler_instance_view_instance)
                                    
                                    type_value = extension_handlers_value.get('type', None)
                                    if type_value is not None:
                                        type_instance = type_value
                                        virtual_machine_extension_handler_instance_view_instance.type = type_instance
                                    
                                    type_handler_version_value = extension_handlers_value.get('typeHandlerVersion', None)
                                    if type_handler_version_value is not None:
                                        type_handler_version_instance = type_handler_version_value
                                        virtual_machine_extension_handler_instance_view_instance.type_handler_version = type_handler_version_instance
                                    
                                    status_value2 = extension_handlers_value.get('status', None)
                                    if status_value2 is not None:
                                        status_instance = InstanceViewStatus()
                                        virtual_machine_extension_handler_instance_view_instance.status = status_instance
                                        
                                        code_value = status_value2.get('code', None)
                                        if code_value is not None:
                                            code_instance = code_value
                                            status_instance.code = code_instance
                                        
                                        level_value = status_value2.get('level', None)
                                        if level_value is not None:
                                            level_instance = level_value
                                            status_instance.level = level_instance
                                        
                                        display_status_value = status_value2.get('displayStatus', None)
                                        if display_status_value is not None:
                                            display_status_instance = display_status_value
                                            status_instance.display_status = display_status_instance
                                        
                                        message_value = status_value2.get('message', None)
                                        if message_value is not None:
                                            message_instance = message_value
                                            status_instance.message = message_instance
                                        
                                        time_value = status_value2.get('time', None)
                                        if time_value is not None:
                                            time_instance = time_value
                                            status_instance.time = time_instance
                                        
                            statuses_array6 = vm_agent_value2.get('statuses', None)
                            if statuses_array6 is not None:
                                for statuses_value in statuses_array6:
                                    instance_view_status_instance = InstanceViewStatus()
                                    vm_agent_instance.statuses.append(instance_view_status_instance)
                                    
                                    code_value2 = statuses_value.get('code', None)
                                    if code_value2 is not None:
                                        code_instance2 = code_value2
                                        instance_view_status_instance.code = code_instance2
                                    
                                    level_value2 = statuses_value.get('level', None)
                                    if level_value2 is not None:
                                        level_instance2 = level_value2
                                        instance_view_status_instance.level = level_instance2
                                    
                                    display_status_value2 = statuses_value.get('displayStatus', None)
                                    if display_status_value2 is not None:
                                        display_status_instance2 = display_status_value2
                                        instance_view_status_instance.display_status = display_status_instance2
                                    
                                    message_value2 = statuses_value.get('message', None)
                                    if message_value2 is not None:
                                        message_instance2 = message_value2
                                        instance_view_status_instance.message = message_instance2
                                    
                                    time_value2 = statuses_value.get('time', None)
                                    if time_value2 is not None:
                                        time_instance2 = time_value2
                                        instance_view_status_instance.time = time_instance2
                                    
                        disks_array2 = instance_view_value3.get('disks', None)
                        if disks_array2 is not None:
                            for disks_value in disks_array2:
                                disk_instance_view_instance = DiskInstanceView(statuses=[])
                                instance_view_instance.disks.append(disk_instance_view_instance)
                                
                                name_value4 = disks_value.get('name', None)
                                if name_value4 is not None:
                                    name_instance4 = name_value4
                                    disk_instance_view_instance.name = name_instance4
                                
                                statuses_array7 = disks_value.get('statuses', None)
                                if statuses_array7 is not None:
                                    for statuses_value2 in statuses_array7:
                                        instance_view_status_instance2 = InstanceViewStatus()
                                        disk_instance_view_instance.statuses.append(instance_view_status_instance2)
                                        
                                        code_value3 = statuses_value2.get('code', None)
                                        if code_value3 is not None:
                                            code_instance3 = code_value3
                                            instance_view_status_instance2.code = code_instance3
                                        
                                        level_value3 = statuses_value2.get('level', None)
                                        if level_value3 is not None:
                                            level_instance3 = level_value3
                                            instance_view_status_instance2.level = level_instance3
                                        
                                        display_status_value3 = statuses_value2.get('displayStatus', None)
                                        if display_status_value3 is not None:
                                            display_status_instance3 = display_status_value3
                                            instance_view_status_instance2.display_status = display_status_instance3
                                        
                                        message_value3 = statuses_value2.get('message', None)
                                        if message_value3 is not None:
                                            message_instance3 = message_value3
                                            instance_view_status_instance2.message = message_instance3
                                        
                                        time_value3 = statuses_value2.get('time', None)
                                        if time_value3 is not None:
                                            time_instance3 = time_value3
                                            instance_view_status_instance2.time = time_instance3
                                        
                        extensions_array2 = instance_view_value3.get('extensions', None)
                        if extensions_array2 is not None:
                            for extensions_value in extensions_array2:
                                virtual_machine_extension_instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                instance_view_instance.extensions.append(virtual_machine_extension_instance_view_instance)
                                
                                name_value5 = extensions_value.get('name', None)
                                if name_value5 is not None:
                                    name_instance5 = name_value5
                                    virtual_machine_extension_instance_view_instance.name = name_instance5
                                
                                type_value2 = extensions_value.get('type', None)
                                if type_value2 is not None:
                                    type_instance2 = type_value2
                                    virtual_machine_extension_instance_view_instance.extension_type = type_instance2
                                
                                type_handler_version_value2 = extensions_value.get('typeHandlerVersion', None)
                                if type_handler_version_value2 is not None:
                                    type_handler_version_instance2 = type_handler_version_value2
                                    virtual_machine_extension_instance_view_instance.type_handler_version = type_handler_version_instance2
                                
                                substatuses_array3 = extensions_value.get('substatuses', None)
                                if substatuses_array3 is not None:
                                    for substatuses_value in substatuses_array3:
                                        instance_view_status_instance3 = InstanceViewStatus()
                                        virtual_machine_extension_instance_view_instance.sub_statuses.append(instance_view_status_instance3)
                                        
                                        code_value4 = substatuses_value.get('code', None)
                                        if code_value4 is not None:
                                            code_instance4 = code_value4
                                            instance_view_status_instance3.code = code_instance4
                                        
                                        level_value4 = substatuses_value.get('level', None)
                                        if level_value4 is not None:
                                            level_instance4 = level_value4
                                            instance_view_status_instance3.level = level_instance4
                                        
                                        display_status_value4 = substatuses_value.get('displayStatus', None)
                                        if display_status_value4 is not None:
                                            display_status_instance4 = display_status_value4
                                            instance_view_status_instance3.display_status = display_status_instance4
                                        
                                        message_value4 = substatuses_value.get('message', None)
                                        if message_value4 is not None:
                                            message_instance4 = message_value4
                                            instance_view_status_instance3.message = message_instance4
                                        
                                        time_value4 = substatuses_value.get('time', None)
                                        if time_value4 is not None:
                                            time_instance4 = time_value4
                                            instance_view_status_instance3.time = time_instance4
                                        
                                statuses_array8 = extensions_value.get('statuses', None)
                                if statuses_array8 is not None:
                                    for statuses_value3 in statuses_array8:
                                        instance_view_status_instance4 = InstanceViewStatus()
                                        virtual_machine_extension_instance_view_instance.statuses.append(instance_view_status_instance4)
                                        
                                        code_value5 = statuses_value3.get('code', None)
                                        if code_value5 is not None:
                                            code_instance5 = code_value5
                                            instance_view_status_instance4.code = code_instance5
                                        
                                        level_value5 = statuses_value3.get('level', None)
                                        if level_value5 is not None:
                                            level_instance5 = level_value5
                                            instance_view_status_instance4.level = level_instance5
                                        
                                        display_status_value5 = statuses_value3.get('displayStatus', None)
                                        if display_status_value5 is not None:
                                            display_status_instance5 = display_status_value5
                                            instance_view_status_instance4.display_status = display_status_instance5
                                        
                                        message_value5 = statuses_value3.get('message', None)
                                        if message_value5 is not None:
                                            message_instance5 = message_value5
                                            instance_view_status_instance4.message = message_instance5
                                        
                                        time_value5 = statuses_value3.get('time', None)
                                        if time_value5 is not None:
                                            time_instance5 = time_value5
                                            instance_view_status_instance4.time = time_instance5
                                        
                        statuses_array9 = instance_view_value3.get('statuses', None)
                        if statuses_array9 is not None:
                            for statuses_value4 in statuses_array9:
                                instance_view_status_instance5 = InstanceViewStatus()
                                instance_view_instance.statuses.append(instance_view_status_instance5)
                                
                                code_value6 = statuses_value4.get('code', None)
                                if code_value6 is not None:
                                    code_instance6 = code_value6
                                    instance_view_status_instance5.code = code_instance6
                                
                                level_value6 = statuses_value4.get('level', None)
                                if level_value6 is not None:
                                    level_instance6 = level_value6
                                    instance_view_status_instance5.level = level_instance6
                                
                                display_status_value6 = statuses_value4.get('displayStatus', None)
                                if display_status_value6 is not None:
                                    display_status_instance6 = display_status_value6
                                    instance_view_status_instance5.display_status = display_status_instance6
                                
                                message_value6 = statuses_value4.get('message', None)
                                if message_value6 is not None:
                                    message_instance6 = message_value6
                                    instance_view_status_instance5.message = message_instance6
                                
                                time_value6 = statuses_value4.get('time', None)
                                if time_value6 is not None:
                                    time_instance6 = time_value6
                                    instance_view_status_instance5.time = time_instance6
                                
                resources_array2 = response_doc.get('resources', None)
                if resources_array2 is not None:
                    virtual_machine_instance.extensions = []
                    for resources_value in resources_array2:
                        virtual_machine_extension_json_instance = VirtualMachineExtension(tags={})
                        virtual_machine_instance.extensions.append(virtual_machine_extension_json_instance)
                        
                        properties_value6 = resources_value.get('properties', None)
                        if properties_value6 is not None:
                            publisher_value3 = properties_value6.get('publisher', None)
                            if publisher_value3 is not None:
                                publisher_instance3 = publisher_value3
                                virtual_machine_extension_json_instance.publisher = publisher_instance3
                            
                            type_value3 = properties_value6.get('type', None)
                            if type_value3 is not None:
                                type_instance3 = type_value3
                                virtual_machine_extension_json_instance.extension_type = type_instance3
                            
                            type_handler_version_value3 = properties_value6.get('typeHandlerVersion', None)
                            if type_handler_version_value3 is not None:
                                type_handler_version_instance3 = type_handler_version_value3
                                virtual_machine_extension_json_instance.type_handler_version = type_handler_version_instance3
                            
                            auto_upgrade_minor_version_value = properties_value6.get('autoUpgradeMinorVersion', None)
                            if auto_upgrade_minor_version_value is not None:
                                auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                                virtual_machine_extension_json_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                            
                            settings_value = properties_value6.get('settings', None)
                            if settings_value is not None:
                                settings_instance = json.dumps(settings_value)
                                virtual_machine_extension_json_instance.settings = settings_instance
                            
                            protected_settings_value = properties_value6.get('protectedSettings', None)
                            if protected_settings_value is not None:
                                protected_settings_instance = json.dumps(protected_settings_value)
                                virtual_machine_extension_json_instance.protected_settings = protected_settings_instance
                            
                            provisioning_state_value2 = properties_value6.get('provisioningState', None)
                            if provisioning_state_value2 is not None:
                                provisioning_state_instance2 = provisioning_state_value2
                                virtual_machine_extension_json_instance.provisioning_state = provisioning_state_instance2
                            
                            instance_view_value4 = properties_value6.get('instanceView', None)
                            if instance_view_value4 is not None:
                                instance_view_instance2 = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                virtual_machine_extension_json_instance.instance_view = instance_view_instance2
                                
                                name_value6 = instance_view_value4.get('name', None)
                                if name_value6 is not None:
                                    name_instance6 = name_value6
                                    instance_view_instance2.name = name_instance6
                                
                                type_value4 = instance_view_value4.get('type', None)
                                if type_value4 is not None:
                                    type_instance4 = type_value4
                                    instance_view_instance2.extension_type = type_instance4
                                
                                type_handler_version_value4 = instance_view_value4.get('typeHandlerVersion', None)
                                if type_handler_version_value4 is not None:
                                    type_handler_version_instance4 = type_handler_version_value4
                                    instance_view_instance2.type_handler_version = type_handler_version_instance4
                                
                                substatuses_array4 = instance_view_value4.get('substatuses', None)
                                if substatuses_array4 is not None:
                                    for substatuses_value2 in substatuses_array4:
                                        instance_view_status_instance6 = InstanceViewStatus()
                                        instance_view_instance2.sub_statuses.append(instance_view_status_instance6)
                                        
                                        code_value7 = substatuses_value2.get('code', None)
                                        if code_value7 is not None:
                                            code_instance7 = code_value7
                                            instance_view_status_instance6.code = code_instance7
                                        
                                        level_value7 = substatuses_value2.get('level', None)
                                        if level_value7 is not None:
                                            level_instance7 = level_value7
                                            instance_view_status_instance6.level = level_instance7
                                        
                                        display_status_value7 = substatuses_value2.get('displayStatus', None)
                                        if display_status_value7 is not None:
                                            display_status_instance7 = display_status_value7
                                            instance_view_status_instance6.display_status = display_status_instance7
                                        
                                        message_value7 = substatuses_value2.get('message', None)
                                        if message_value7 is not None:
                                            message_instance7 = message_value7
                                            instance_view_status_instance6.message = message_instance7
                                        
                                        time_value7 = substatuses_value2.get('time', None)
                                        if time_value7 is not None:
                                            time_instance7 = time_value7
                                            instance_view_status_instance6.time = time_instance7
                                        
                                statuses_array10 = instance_view_value4.get('statuses', None)
                                if statuses_array10 is not None:
                                    for statuses_value5 in statuses_array10:
                                        instance_view_status_instance7 = InstanceViewStatus()
                                        instance_view_instance2.statuses.append(instance_view_status_instance7)
                                        
                                        code_value8 = statuses_value5.get('code', None)
                                        if code_value8 is not None:
                                            code_instance8 = code_value8
                                            instance_view_status_instance7.code = code_instance8
                                        
                                        level_value8 = statuses_value5.get('level', None)
                                        if level_value8 is not None:
                                            level_instance8 = level_value8
                                            instance_view_status_instance7.level = level_instance8
                                        
                                        display_status_value8 = statuses_value5.get('displayStatus', None)
                                        if display_status_value8 is not None:
                                            display_status_instance8 = display_status_value8
                                            instance_view_status_instance7.display_status = display_status_instance8
                                        
                                        message_value8 = statuses_value5.get('message', None)
                                        if message_value8 is not None:
                                            message_instance8 = message_value8
                                            instance_view_status_instance7.message = message_instance8
                                        
                                        time_value8 = statuses_value5.get('time', None)
                                        if time_value8 is not None:
                                            time_instance8 = time_value8
                                            instance_view_status_instance7.time = time_instance8
                                        
                        id_value5 = resources_value.get('id', None)
                        if id_value5 is not None:
                            id_instance5 = id_value5
                            virtual_machine_extension_json_instance.id = id_instance5
                        
                        name_value7 = resources_value.get('name', None)
                        if name_value7 is not None:
                            name_instance7 = name_value7
                            virtual_machine_extension_json_instance.name = name_instance7
                        
                        type_value5 = resources_value.get('type', None)
                        if type_value5 is not None:
                            type_instance5 = type_value5
                            virtual_machine_extension_json_instance.type = type_instance5
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_extension_json_instance.location = location_instance
                        
                        tags_sequence_element = resources_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key3 = property
                                tags_value3 = tags_sequence_element[property]
                                virtual_machine_extension_json_instance.tags[tags_key3] = tags_value3
                            
                id_value6 = response_doc.get('id', None)
                if id_value6 is not None:
                    id_instance6 = id_value6
                    virtual_machine_instance.id = id_instance6
                
                name_value8 = response_doc.get('name', None)
                if name_value8 is not None:
                    name_instance8 = name_value8
                    virtual_machine_instance.name = name_instance8
                
                type_value6 = response_doc.get('type', None)
                if type_value6 is not None:
                    type_instance6 = type_value6
                    virtual_machine_instance.type = type_instance6
                
                location_value2 = response_doc.get('location', None)
                if location_value2 is not None:
                    location_instance2 = location_value2
                    virtual_machine_instance.location = location_instance2
                
                tags_sequence_element2 = response_doc.get('tags', None)
                if tags_sequence_element2 is not None:
                    for property2 in tags_sequence_element2:
                        tags_key4 = property2
                        tags_value4 = tags_sequence_element2[property2]
                        virtual_machine_instance.tags[tags_key4] = tags_value4
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deallocating(self, resource_group_name, vm_name):
        """
         Shuts down the Virtual Machine and releases the compute resources. You
         are not billed for the compute resources that this Virtual Machine
         uses.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeOperationResponse: The compute long running operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/deallocate'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ComputeOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, vm_name):
        """
         The operation to delete a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeOperationResponse: The compute long running operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ComputeOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_powering_off(self, resource_group_name, vm_name):
        """
         The operation to power off (stop) a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeOperationResponse: The compute long running operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/powerOff'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ComputeOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_restarting(self, resource_group_name, vm_name):
        """
         The operation to restart a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeOperationResponse: The compute long running operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/restart'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ComputeOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_starting(self, resource_group_name, vm_name):
        """
         The operation to start a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeOperationResponse: The compute long running operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/start'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ComputeOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def capture(self, resource_group_name, vm_name, parameters):
        """
         Captures the VM by copying VirtualHardDisks of the VM and outputs a
         template that can be used to create similar VMs.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         parameters (VirtualMachineCaptureParameters): Parameters supplied to
         the Capture Virtual Machine operation.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machines.begin_capturing(resource_group_name, vm_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def create_or_update(self, resource_group_name, parameters):
        """
         The operation to create or update a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         parameters (VirtualMachine): Parameters supplied to the Create Virtual
         Machine operation.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machines.begin_creating_or_updating(resource_group_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def deallocate(self, resource_group_name, vm_name):
        """
         Shuts down the Virtual Machine and releases the compute resources. You
         are not billed for the compute resources that this Virtual Machine
         uses.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machines.begin_deallocating(resource_group_name, vm_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, vm_name):
        """
         The operation to delete a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machines.begin_deleting(resource_group_name, vm_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def generalize(self, resource_group_name, vm_name):
        """
         Sets the state of the VM as Generalized.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/generalize'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = AzureOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get(self, resource_group_name, vm_name):
        """
         The operation to get a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         VirtualMachineGetResponse: The GetVM operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_machine_instance = VirtualMachine(extensions=[], tags={})
                result.virtual_machine = virtual_machine_instance
                
                plan_value = response_doc.get('plan', None)
                if plan_value is not None:
                    plan_instance = Plan()
                    virtual_machine_instance.plan = plan_instance
                    
                    name_value = plan_value.get('name', None)
                    if name_value is not None:
                        name_instance = name_value
                        plan_instance.name = name_instance
                    
                    publisher_value = plan_value.get('publisher', None)
                    if publisher_value is not None:
                        publisher_instance = publisher_value
                        plan_instance.publisher = publisher_instance
                    
                    product_value = plan_value.get('product', None)
                    if product_value is not None:
                        product_instance = product_value
                        plan_instance.product = product_instance
                    
                    promotion_code_value = plan_value.get('promotionCode', None)
                    if promotion_code_value is not None:
                        promotion_code_instance = promotion_code_value
                        plan_instance.promotion_code = promotion_code_instance
                    
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    hardware_profile_value = properties_value.get('hardwareProfile', None)
                    if hardware_profile_value is not None:
                        hardware_profile_instance = HardwareProfile()
                        virtual_machine_instance.hardware_profile = hardware_profile_instance
                        
                        vm_size_value = hardware_profile_value.get('vmSize', None)
                        if vm_size_value is not None:
                            vm_size_instance = vm_size_value
                            hardware_profile_instance.virtual_machine_size = vm_size_instance
                        
                    storage_profile_value = properties_value.get('storageProfile', None)
                    if storage_profile_value is not None:
                        storage_profile_instance = StorageProfile(data_disks=[])
                        virtual_machine_instance.storage_profile = storage_profile_instance
                        
                        image_reference_value = storage_profile_value.get('imageReference', None)
                        if image_reference_value is not None:
                            image_reference_instance = ImageReference()
                            storage_profile_instance.image_reference = image_reference_instance
                            
                            publisher_value2 = image_reference_value.get('publisher', None)
                            if publisher_value2 is not None:
                                publisher_instance2 = publisher_value2
                                image_reference_instance.publisher = publisher_instance2
                            
                            offer_value = image_reference_value.get('offer', None)
                            if offer_value is not None:
                                offer_instance = offer_value
                                image_reference_instance.offer = offer_instance
                            
                            sku_value = image_reference_value.get('sku', None)
                            if sku_value is not None:
                                sku_instance = sku_value
                                image_reference_instance.sku = sku_instance
                            
                            version_value = image_reference_value.get('version', None)
                            if version_value is not None:
                                version_instance = version_value
                                image_reference_instance.version = version_instance
                            
                        source_image_value = storage_profile_value.get('sourceImage', None)
                        if source_image_value is not None:
                            source_image_instance = SourceImageReference()
                            storage_profile_instance.source_image = source_image_instance
                            
                            id_value = source_image_value.get('id', None)
                            if id_value is not None:
                                id_instance = id_value
                                source_image_instance.reference_uri = id_instance
                            
                        os_disk_value = storage_profile_value.get('osDisk', None)
                        if os_disk_value is not None:
                            os_disk_instance = OSDisk()
                            storage_profile_instance.os_disk = os_disk_instance
                            
                            os_type_value = os_disk_value.get('osType', None)
                            if os_type_value is not None:
                                os_type_instance = os_type_value
                                os_disk_instance.operating_system_type = os_type_instance
                            
                            name_value2 = os_disk_value.get('name', None)
                            if name_value2 is not None:
                                name_instance2 = name_value2
                                os_disk_instance.name = name_instance2
                            
                            vhd_value = os_disk_value.get('vhd', None)
                            if vhd_value is not None:
                                vhd_instance = VirtualHardDisk()
                                os_disk_instance.virtual_hard_disk = vhd_instance
                                
                                uri_value = vhd_value.get('uri', None)
                                if uri_value is not None:
                                    uri_instance = uri_value
                                    vhd_instance.uri = uri_instance
                                
                            image_value = os_disk_value.get('image', None)
                            if image_value is not None:
                                image_instance = VirtualHardDisk()
                                os_disk_instance.source_image = image_instance
                                
                                uri_value2 = image_value.get('uri', None)
                                if uri_value2 is not None:
                                    uri_instance2 = uri_value2
                                    image_instance.uri = uri_instance2
                                
                            caching_value = os_disk_value.get('caching', None)
                            if caching_value is not None:
                                caching_instance = caching_value
                                os_disk_instance.caching = caching_instance
                            
                            create_option_value = os_disk_value.get('createOption', None)
                            if create_option_value is not None:
                                create_option_instance = create_option_value
                                os_disk_instance.create_option = create_option_instance
                            
                        data_disks_array = storage_profile_value.get('dataDisks', None)
                        if data_disks_array is not None:
                            for data_disks_value in data_disks_array:
                                data_disk_instance = DataDisk()
                                storage_profile_instance.data_disks.append(data_disk_instance)
                                
                                lun_value = data_disks_value.get('lun', None)
                                if lun_value is not None:
                                    lun_instance = lun_value
                                    data_disk_instance.lun = lun_instance
                                
                                disk_size_gb_value = data_disks_value.get('diskSizeGB', None)
                                if disk_size_gb_value is not None:
                                    disk_size_gb_instance = disk_size_gb_value
                                    data_disk_instance.disk_size_gb = disk_size_gb_instance
                                
                                name_value3 = data_disks_value.get('name', None)
                                if name_value3 is not None:
                                    name_instance3 = name_value3
                                    data_disk_instance.name = name_instance3
                                
                                vhd_value2 = data_disks_value.get('vhd', None)
                                if vhd_value2 is not None:
                                    vhd_instance2 = VirtualHardDisk()
                                    data_disk_instance.virtual_hard_disk = vhd_instance2
                                    
                                    uri_value3 = vhd_value2.get('uri', None)
                                    if uri_value3 is not None:
                                        uri_instance3 = uri_value3
                                        vhd_instance2.uri = uri_instance3
                                    
                                image_value2 = data_disks_value.get('image', None)
                                if image_value2 is not None:
                                    image_instance2 = VirtualHardDisk()
                                    data_disk_instance.source_image = image_instance2
                                    
                                    uri_value4 = image_value2.get('uri', None)
                                    if uri_value4 is not None:
                                        uri_instance4 = uri_value4
                                        image_instance2.uri = uri_instance4
                                    
                                caching_value2 = data_disks_value.get('caching', None)
                                if caching_value2 is not None:
                                    caching_instance2 = caching_value2
                                    data_disk_instance.caching = caching_instance2
                                
                                create_option_value2 = data_disks_value.get('createOption', None)
                                if create_option_value2 is not None:
                                    create_option_instance2 = create_option_value2
                                    data_disk_instance.create_option = create_option_instance2
                                
                    os_profile_value = properties_value.get('osProfile', None)
                    if os_profile_value is not None:
                        os_profile_instance = OSProfile(secrets=[])
                        virtual_machine_instance.os_profile = os_profile_instance
                        
                        computer_name_value = os_profile_value.get('computerName', None)
                        if computer_name_value is not None:
                            computer_name_instance = computer_name_value
                            os_profile_instance.computer_name = computer_name_instance
                        
                        admin_username_value = os_profile_value.get('adminUsername', None)
                        if admin_username_value is not None:
                            admin_username_instance = admin_username_value
                            os_profile_instance.admin_username = admin_username_instance
                        
                        admin_password_value = os_profile_value.get('adminPassword', None)
                        if admin_password_value is not None:
                            admin_password_instance = admin_password_value
                            os_profile_instance.admin_password = admin_password_instance
                        
                        custom_data_value = os_profile_value.get('customData', None)
                        if custom_data_value is not None:
                            custom_data_instance = custom_data_value
                            os_profile_instance.custom_data = custom_data_instance
                        
                        windows_configuration_value = os_profile_value.get('windowsConfiguration', None)
                        if windows_configuration_value is not None:
                            windows_configuration_instance = WindowsConfiguration(additional_unattend_contents=[])
                            os_profile_instance.windows_configuration = windows_configuration_instance
                            
                            provision_vm_agent_value = windows_configuration_value.get('provisionVMAgent', None)
                            if provision_vm_agent_value is not None:
                                provision_vm_agent_instance = provision_vm_agent_value
                                windows_configuration_instance.provision_vm_agent = provision_vm_agent_instance
                            
                            enable_automatic_updates_value = windows_configuration_value.get('enableAutomaticUpdates', None)
                            if enable_automatic_updates_value is not None:
                                enable_automatic_updates_instance = enable_automatic_updates_value
                                windows_configuration_instance.enable_automatic_updates = enable_automatic_updates_instance
                            
                            time_zone_value = windows_configuration_value.get('timeZone', None)
                            if time_zone_value is not None:
                                time_zone_instance = time_zone_value
                                windows_configuration_instance.time_zone = time_zone_instance
                            
                            additional_unattend_content_array = windows_configuration_value.get('additionalUnattendContent', None)
                            if additional_unattend_content_array is not None:
                                for additional_unattend_content_value in additional_unattend_content_array:
                                    additional_unattend_content_instance = AdditionalUnattendContent()
                                    windows_configuration_instance.additional_unattend_contents.append(additional_unattend_content_instance)
                                    
                                    pass_name_value = additional_unattend_content_value.get('passName', None)
                                    if pass_name_value is not None:
                                        pass_name_instance = pass_name_value
                                        additional_unattend_content_instance.pass_name = pass_name_instance
                                    
                                    component_name_value = additional_unattend_content_value.get('componentName', None)
                                    if component_name_value is not None:
                                        component_name_instance = component_name_value
                                        additional_unattend_content_instance.component_name = component_name_instance
                                    
                                    setting_name_value = additional_unattend_content_value.get('settingName', None)
                                    if setting_name_value is not None:
                                        setting_name_instance = setting_name_value
                                        additional_unattend_content_instance.setting_name = setting_name_instance
                                    
                                    content_value = additional_unattend_content_value.get('content', None)
                                    if content_value is not None:
                                        content_instance = content_value
                                        additional_unattend_content_instance.content = content_instance
                                    
                            win_rm_value = windows_configuration_value.get('winRM', None)
                            if win_rm_value is not None:
                                win_rm_instance = WinRMConfiguration(listeners=[])
                                windows_configuration_instance.win_rm_configuration = win_rm_instance
                                
                                listeners_array = win_rm_value.get('listeners', None)
                                if listeners_array is not None:
                                    for listeners_value in listeners_array:
                                        win_rm_listener_instance = WinRMListener()
                                        win_rm_instance.listeners.append(win_rm_listener_instance)
                                        
                                        protocol_value = listeners_value.get('protocol', None)
                                        if protocol_value is not None:
                                            protocol_instance = protocol_value
                                            win_rm_listener_instance.protocol = protocol_instance
                                        
                                        certificate_url_value = listeners_value.get('certificateUrl', None)
                                        if certificate_url_value is not None:
                                            certificate_url_instance = certificate_url_value
                                            win_rm_listener_instance.certificate_url = certificate_url_instance
                                        
                        linux_configuration_value = os_profile_value.get('linuxConfiguration', None)
                        if linux_configuration_value is not None:
                            linux_configuration_instance = LinuxConfiguration()
                            os_profile_instance.linux_configuration = linux_configuration_instance
                            
                            disable_password_authentication_value = linux_configuration_value.get('disablePasswordAuthentication', None)
                            if disable_password_authentication_value is not None:
                                disable_password_authentication_instance = disable_password_authentication_value
                                linux_configuration_instance.disable_password_authentication = disable_password_authentication_instance
                            
                            ssh_value = linux_configuration_value.get('ssh', None)
                            if ssh_value is not None:
                                ssh_instance = SshConfiguration(public_keys=[])
                                linux_configuration_instance.ssh_configuration = ssh_instance
                                
                                public_keys_array = ssh_value.get('publicKeys', None)
                                if public_keys_array is not None:
                                    for public_keys_value in public_keys_array:
                                        ssh_public_key_instance = SshPublicKey()
                                        ssh_instance.public_keys.append(ssh_public_key_instance)
                                        
                                        path_value = public_keys_value.get('path', None)
                                        if path_value is not None:
                                            path_instance = path_value
                                            ssh_public_key_instance.path = path_instance
                                        
                                        key_data_value = public_keys_value.get('keyData', None)
                                        if key_data_value is not None:
                                            key_data_instance = key_data_value
                                            ssh_public_key_instance.key_data = key_data_instance
                                        
                        secrets_array = os_profile_value.get('secrets', None)
                        if secrets_array is not None:
                            for secrets_value in secrets_array:
                                vault_secret_group_instance = VaultSecretGroup(vault_certificates=[])
                                os_profile_instance.secrets.append(vault_secret_group_instance)
                                
                                source_vault_value = secrets_value.get('sourceVault', None)
                                if source_vault_value is not None:
                                    source_vault_instance = SourceVaultReference()
                                    vault_secret_group_instance.source_vault = source_vault_instance
                                    
                                    id_value2 = source_vault_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        source_vault_instance.reference_uri = id_instance2
                                    
                                vault_certificates_array = secrets_value.get('vaultCertificates', None)
                                if vault_certificates_array is not None:
                                    for vault_certificates_value in vault_certificates_array:
                                        vault_certificate_instance = VaultCertificate()
                                        vault_secret_group_instance.vault_certificates.append(vault_certificate_instance)
                                        
                                        certificate_url_value2 = vault_certificates_value.get('certificateUrl', None)
                                        if certificate_url_value2 is not None:
                                            certificate_url_instance2 = certificate_url_value2
                                            vault_certificate_instance.certificate_url = certificate_url_instance2
                                        
                                        certificate_store_value = vault_certificates_value.get('certificateStore', None)
                                        if certificate_store_value is not None:
                                            certificate_store_instance = certificate_store_value
                                            vault_certificate_instance.certificate_store = certificate_store_instance
                                        
                    network_profile_value = properties_value.get('networkProfile', None)
                    if network_profile_value is not None:
                        network_profile_instance = NetworkProfile(network_interfaces=[])
                        virtual_machine_instance.network_profile = network_profile_instance
                        
                        network_interfaces_array = network_profile_value.get('networkInterfaces', None)
                        if network_interfaces_array is not None:
                            for network_interfaces_value in network_interfaces_array:
                                network_interface_reference_json_instance = NetworkInterfaceReference()
                                network_profile_instance.network_interfaces.append(network_interface_reference_json_instance)
                                
                                properties_value2 = network_interfaces_value.get('properties', None)
                                if properties_value2 is not None:
                                    primary_value = properties_value2.get('primary', None)
                                    if primary_value is not None:
                                        primary_instance = primary_value
                                        network_interface_reference_json_instance.primary = primary_instance
                                    
                                id_value3 = network_interfaces_value.get('id', None)
                                if id_value3 is not None:
                                    id_instance3 = id_value3
                                    network_interface_reference_json_instance.reference_uri = id_instance3
                                
                    availability_set_value = properties_value.get('availabilitySet', None)
                    if availability_set_value is not None:
                        availability_set_instance = AvailabilitySetReference()
                        virtual_machine_instance.availability_set_reference = availability_set_instance
                        
                        id_value4 = availability_set_value.get('id', None)
                        if id_value4 is not None:
                            id_instance4 = id_value4
                            availability_set_instance.reference_uri = id_instance4
                        
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        virtual_machine_instance.provisioning_state = provisioning_state_instance
                    
                    instance_view_value = properties_value.get('instanceView', None)
                    if instance_view_value is not None:
                        instance_view_instance = VirtualMachineInstanceView(disks=[], extensions=[], statuses=[])
                        virtual_machine_instance.instance_view = instance_view_instance
                        
                        platform_update_domain_value = instance_view_value.get('platformUpdateDomain', None)
                        if platform_update_domain_value is not None:
                            platform_update_domain_instance = platform_update_domain_value
                            instance_view_instance.platform_update_domain = platform_update_domain_instance
                        
                        platform_fault_domain_value = instance_view_value.get('platformFaultDomain', None)
                        if platform_fault_domain_value is not None:
                            platform_fault_domain_instance = platform_fault_domain_value
                            instance_view_instance.platform_fault_domain = platform_fault_domain_instance
                        
                        rdp_thumb_print_value = instance_view_value.get('rdpThumbPrint', None)
                        if rdp_thumb_print_value is not None:
                            rdp_thumb_print_instance = rdp_thumb_print_value
                            instance_view_instance.remote_desktop_thumbprint = rdp_thumb_print_instance
                        
                        vm_agent_value = instance_view_value.get('vmAgent', None)
                        if vm_agent_value is not None:
                            vm_agent_instance = VirtualMachineAgentInstanceView(extension_handlers=[], statuses=[])
                            instance_view_instance.vm_agent = vm_agent_instance
                            
                            vm_agent_version_value = vm_agent_value.get('vmAgentVersion', None)
                            if vm_agent_version_value is not None:
                                vm_agent_version_instance = vm_agent_version_value
                                vm_agent_instance.vm_agent_version = vm_agent_version_instance
                            
                            extension_handlers_array = vm_agent_value.get('extensionHandlers', None)
                            if extension_handlers_array is not None:
                                for extension_handlers_value in extension_handlers_array:
                                    virtual_machine_extension_handler_instance_view_instance = VirtualMachineExtensionHandlerInstanceView()
                                    vm_agent_instance.extension_handlers.append(virtual_machine_extension_handler_instance_view_instance)
                                    
                                    type_value = extension_handlers_value.get('type', None)
                                    if type_value is not None:
                                        type_instance = type_value
                                        virtual_machine_extension_handler_instance_view_instance.type = type_instance
                                    
                                    type_handler_version_value = extension_handlers_value.get('typeHandlerVersion', None)
                                    if type_handler_version_value is not None:
                                        type_handler_version_instance = type_handler_version_value
                                        virtual_machine_extension_handler_instance_view_instance.type_handler_version = type_handler_version_instance
                                    
                                    status_value = extension_handlers_value.get('status', None)
                                    if status_value is not None:
                                        status_instance = InstanceViewStatus()
                                        virtual_machine_extension_handler_instance_view_instance.status = status_instance
                                        
                                        code_value = status_value.get('code', None)
                                        if code_value is not None:
                                            code_instance = code_value
                                            status_instance.code = code_instance
                                        
                                        level_value = status_value.get('level', None)
                                        if level_value is not None:
                                            level_instance = level_value
                                            status_instance.level = level_instance
                                        
                                        display_status_value = status_value.get('displayStatus', None)
                                        if display_status_value is not None:
                                            display_status_instance = display_status_value
                                            status_instance.display_status = display_status_instance
                                        
                                        message_value = status_value.get('message', None)
                                        if message_value is not None:
                                            message_instance = message_value
                                            status_instance.message = message_instance
                                        
                                        time_value = status_value.get('time', None)
                                        if time_value is not None:
                                            time_instance = time_value
                                            status_instance.time = time_instance
                                        
                            statuses_array = vm_agent_value.get('statuses', None)
                            if statuses_array is not None:
                                for statuses_value in statuses_array:
                                    instance_view_status_instance = InstanceViewStatus()
                                    vm_agent_instance.statuses.append(instance_view_status_instance)
                                    
                                    code_value2 = statuses_value.get('code', None)
                                    if code_value2 is not None:
                                        code_instance2 = code_value2
                                        instance_view_status_instance.code = code_instance2
                                    
                                    level_value2 = statuses_value.get('level', None)
                                    if level_value2 is not None:
                                        level_instance2 = level_value2
                                        instance_view_status_instance.level = level_instance2
                                    
                                    display_status_value2 = statuses_value.get('displayStatus', None)
                                    if display_status_value2 is not None:
                                        display_status_instance2 = display_status_value2
                                        instance_view_status_instance.display_status = display_status_instance2
                                    
                                    message_value2 = statuses_value.get('message', None)
                                    if message_value2 is not None:
                                        message_instance2 = message_value2
                                        instance_view_status_instance.message = message_instance2
                                    
                                    time_value2 = statuses_value.get('time', None)
                                    if time_value2 is not None:
                                        time_instance2 = time_value2
                                        instance_view_status_instance.time = time_instance2
                                    
                        disks_array = instance_view_value.get('disks', None)
                        if disks_array is not None:
                            for disks_value in disks_array:
                                disk_instance_view_instance = DiskInstanceView(statuses=[])
                                instance_view_instance.disks.append(disk_instance_view_instance)
                                
                                name_value4 = disks_value.get('name', None)
                                if name_value4 is not None:
                                    name_instance4 = name_value4
                                    disk_instance_view_instance.name = name_instance4
                                
                                statuses_array2 = disks_value.get('statuses', None)
                                if statuses_array2 is not None:
                                    for statuses_value2 in statuses_array2:
                                        instance_view_status_instance2 = InstanceViewStatus()
                                        disk_instance_view_instance.statuses.append(instance_view_status_instance2)
                                        
                                        code_value3 = statuses_value2.get('code', None)
                                        if code_value3 is not None:
                                            code_instance3 = code_value3
                                            instance_view_status_instance2.code = code_instance3
                                        
                                        level_value3 = statuses_value2.get('level', None)
                                        if level_value3 is not None:
                                            level_instance3 = level_value3
                                            instance_view_status_instance2.level = level_instance3
                                        
                                        display_status_value3 = statuses_value2.get('displayStatus', None)
                                        if display_status_value3 is not None:
                                            display_status_instance3 = display_status_value3
                                            instance_view_status_instance2.display_status = display_status_instance3
                                        
                                        message_value3 = statuses_value2.get('message', None)
                                        if message_value3 is not None:
                                            message_instance3 = message_value3
                                            instance_view_status_instance2.message = message_instance3
                                        
                                        time_value3 = statuses_value2.get('time', None)
                                        if time_value3 is not None:
                                            time_instance3 = time_value3
                                            instance_view_status_instance2.time = time_instance3
                                        
                        extensions_array = instance_view_value.get('extensions', None)
                        if extensions_array is not None:
                            for extensions_value in extensions_array:
                                virtual_machine_extension_instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                instance_view_instance.extensions.append(virtual_machine_extension_instance_view_instance)
                                
                                name_value5 = extensions_value.get('name', None)
                                if name_value5 is not None:
                                    name_instance5 = name_value5
                                    virtual_machine_extension_instance_view_instance.name = name_instance5
                                
                                type_value2 = extensions_value.get('type', None)
                                if type_value2 is not None:
                                    type_instance2 = type_value2
                                    virtual_machine_extension_instance_view_instance.extension_type = type_instance2
                                
                                type_handler_version_value2 = extensions_value.get('typeHandlerVersion', None)
                                if type_handler_version_value2 is not None:
                                    type_handler_version_instance2 = type_handler_version_value2
                                    virtual_machine_extension_instance_view_instance.type_handler_version = type_handler_version_instance2
                                
                                substatuses_array = extensions_value.get('substatuses', None)
                                if substatuses_array is not None:
                                    for substatuses_value in substatuses_array:
                                        instance_view_status_instance3 = InstanceViewStatus()
                                        virtual_machine_extension_instance_view_instance.sub_statuses.append(instance_view_status_instance3)
                                        
                                        code_value4 = substatuses_value.get('code', None)
                                        if code_value4 is not None:
                                            code_instance4 = code_value4
                                            instance_view_status_instance3.code = code_instance4
                                        
                                        level_value4 = substatuses_value.get('level', None)
                                        if level_value4 is not None:
                                            level_instance4 = level_value4
                                            instance_view_status_instance3.level = level_instance4
                                        
                                        display_status_value4 = substatuses_value.get('displayStatus', None)
                                        if display_status_value4 is not None:
                                            display_status_instance4 = display_status_value4
                                            instance_view_status_instance3.display_status = display_status_instance4
                                        
                                        message_value4 = substatuses_value.get('message', None)
                                        if message_value4 is not None:
                                            message_instance4 = message_value4
                                            instance_view_status_instance3.message = message_instance4
                                        
                                        time_value4 = substatuses_value.get('time', None)
                                        if time_value4 is not None:
                                            time_instance4 = time_value4
                                            instance_view_status_instance3.time = time_instance4
                                        
                                statuses_array3 = extensions_value.get('statuses', None)
                                if statuses_array3 is not None:
                                    for statuses_value3 in statuses_array3:
                                        instance_view_status_instance4 = InstanceViewStatus()
                                        virtual_machine_extension_instance_view_instance.statuses.append(instance_view_status_instance4)
                                        
                                        code_value5 = statuses_value3.get('code', None)
                                        if code_value5 is not None:
                                            code_instance5 = code_value5
                                            instance_view_status_instance4.code = code_instance5
                                        
                                        level_value5 = statuses_value3.get('level', None)
                                        if level_value5 is not None:
                                            level_instance5 = level_value5
                                            instance_view_status_instance4.level = level_instance5
                                        
                                        display_status_value5 = statuses_value3.get('displayStatus', None)
                                        if display_status_value5 is not None:
                                            display_status_instance5 = display_status_value5
                                            instance_view_status_instance4.display_status = display_status_instance5
                                        
                                        message_value5 = statuses_value3.get('message', None)
                                        if message_value5 is not None:
                                            message_instance5 = message_value5
                                            instance_view_status_instance4.message = message_instance5
                                        
                                        time_value5 = statuses_value3.get('time', None)
                                        if time_value5 is not None:
                                            time_instance5 = time_value5
                                            instance_view_status_instance4.time = time_instance5
                                        
                        statuses_array4 = instance_view_value.get('statuses', None)
                        if statuses_array4 is not None:
                            for statuses_value4 in statuses_array4:
                                instance_view_status_instance5 = InstanceViewStatus()
                                instance_view_instance.statuses.append(instance_view_status_instance5)
                                
                                code_value6 = statuses_value4.get('code', None)
                                if code_value6 is not None:
                                    code_instance6 = code_value6
                                    instance_view_status_instance5.code = code_instance6
                                
                                level_value6 = statuses_value4.get('level', None)
                                if level_value6 is not None:
                                    level_instance6 = level_value6
                                    instance_view_status_instance5.level = level_instance6
                                
                                display_status_value6 = statuses_value4.get('displayStatus', None)
                                if display_status_value6 is not None:
                                    display_status_instance6 = display_status_value6
                                    instance_view_status_instance5.display_status = display_status_instance6
                                
                                message_value6 = statuses_value4.get('message', None)
                                if message_value6 is not None:
                                    message_instance6 = message_value6
                                    instance_view_status_instance5.message = message_instance6
                                
                                time_value6 = statuses_value4.get('time', None)
                                if time_value6 is not None:
                                    time_instance6 = time_value6
                                    instance_view_status_instance5.time = time_instance6
                                
                resources_array = response_doc.get('resources', None)
                if resources_array is not None:
                    virtual_machine_instance.extensions = []
                    for resources_value in resources_array:
                        virtual_machine_extension_json_instance = VirtualMachineExtension(tags={})
                        virtual_machine_instance.extensions.append(virtual_machine_extension_json_instance)
                        
                        properties_value3 = resources_value.get('properties', None)
                        if properties_value3 is not None:
                            publisher_value3 = properties_value3.get('publisher', None)
                            if publisher_value3 is not None:
                                publisher_instance3 = publisher_value3
                                virtual_machine_extension_json_instance.publisher = publisher_instance3
                            
                            type_value3 = properties_value3.get('type', None)
                            if type_value3 is not None:
                                type_instance3 = type_value3
                                virtual_machine_extension_json_instance.extension_type = type_instance3
                            
                            type_handler_version_value3 = properties_value3.get('typeHandlerVersion', None)
                            if type_handler_version_value3 is not None:
                                type_handler_version_instance3 = type_handler_version_value3
                                virtual_machine_extension_json_instance.type_handler_version = type_handler_version_instance3
                            
                            auto_upgrade_minor_version_value = properties_value3.get('autoUpgradeMinorVersion', None)
                            if auto_upgrade_minor_version_value is not None:
                                auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                                virtual_machine_extension_json_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                            
                            settings_value = properties_value3.get('settings', None)
                            if settings_value is not None:
                                settings_instance = json.dumps(settings_value)
                                virtual_machine_extension_json_instance.settings = settings_instance
                            
                            protected_settings_value = properties_value3.get('protectedSettings', None)
                            if protected_settings_value is not None:
                                protected_settings_instance = json.dumps(protected_settings_value)
                                virtual_machine_extension_json_instance.protected_settings = protected_settings_instance
                            
                            provisioning_state_value2 = properties_value3.get('provisioningState', None)
                            if provisioning_state_value2 is not None:
                                provisioning_state_instance2 = provisioning_state_value2
                                virtual_machine_extension_json_instance.provisioning_state = provisioning_state_instance2
                            
                            instance_view_value2 = properties_value3.get('instanceView', None)
                            if instance_view_value2 is not None:
                                instance_view_instance2 = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                virtual_machine_extension_json_instance.instance_view = instance_view_instance2
                                
                                name_value6 = instance_view_value2.get('name', None)
                                if name_value6 is not None:
                                    name_instance6 = name_value6
                                    instance_view_instance2.name = name_instance6
                                
                                type_value4 = instance_view_value2.get('type', None)
                                if type_value4 is not None:
                                    type_instance4 = type_value4
                                    instance_view_instance2.extension_type = type_instance4
                                
                                type_handler_version_value4 = instance_view_value2.get('typeHandlerVersion', None)
                                if type_handler_version_value4 is not None:
                                    type_handler_version_instance4 = type_handler_version_value4
                                    instance_view_instance2.type_handler_version = type_handler_version_instance4
                                
                                substatuses_array2 = instance_view_value2.get('substatuses', None)
                                if substatuses_array2 is not None:
                                    for substatuses_value2 in substatuses_array2:
                                        instance_view_status_instance6 = InstanceViewStatus()
                                        instance_view_instance2.sub_statuses.append(instance_view_status_instance6)
                                        
                                        code_value7 = substatuses_value2.get('code', None)
                                        if code_value7 is not None:
                                            code_instance7 = code_value7
                                            instance_view_status_instance6.code = code_instance7
                                        
                                        level_value7 = substatuses_value2.get('level', None)
                                        if level_value7 is not None:
                                            level_instance7 = level_value7
                                            instance_view_status_instance6.level = level_instance7
                                        
                                        display_status_value7 = substatuses_value2.get('displayStatus', None)
                                        if display_status_value7 is not None:
                                            display_status_instance7 = display_status_value7
                                            instance_view_status_instance6.display_status = display_status_instance7
                                        
                                        message_value7 = substatuses_value2.get('message', None)
                                        if message_value7 is not None:
                                            message_instance7 = message_value7
                                            instance_view_status_instance6.message = message_instance7
                                        
                                        time_value7 = substatuses_value2.get('time', None)
                                        if time_value7 is not None:
                                            time_instance7 = time_value7
                                            instance_view_status_instance6.time = time_instance7
                                        
                                statuses_array5 = instance_view_value2.get('statuses', None)
                                if statuses_array5 is not None:
                                    for statuses_value5 in statuses_array5:
                                        instance_view_status_instance7 = InstanceViewStatus()
                                        instance_view_instance2.statuses.append(instance_view_status_instance7)
                                        
                                        code_value8 = statuses_value5.get('code', None)
                                        if code_value8 is not None:
                                            code_instance8 = code_value8
                                            instance_view_status_instance7.code = code_instance8
                                        
                                        level_value8 = statuses_value5.get('level', None)
                                        if level_value8 is not None:
                                            level_instance8 = level_value8
                                            instance_view_status_instance7.level = level_instance8
                                        
                                        display_status_value8 = statuses_value5.get('displayStatus', None)
                                        if display_status_value8 is not None:
                                            display_status_instance8 = display_status_value8
                                            instance_view_status_instance7.display_status = display_status_instance8
                                        
                                        message_value8 = statuses_value5.get('message', None)
                                        if message_value8 is not None:
                                            message_instance8 = message_value8
                                            instance_view_status_instance7.message = message_instance8
                                        
                                        time_value8 = statuses_value5.get('time', None)
                                        if time_value8 is not None:
                                            time_instance8 = time_value8
                                            instance_view_status_instance7.time = time_instance8
                                        
                        id_value5 = resources_value.get('id', None)
                        if id_value5 is not None:
                            id_instance5 = id_value5
                            virtual_machine_extension_json_instance.id = id_instance5
                        
                        name_value7 = resources_value.get('name', None)
                        if name_value7 is not None:
                            name_instance7 = name_value7
                            virtual_machine_extension_json_instance.name = name_instance7
                        
                        type_value5 = resources_value.get('type', None)
                        if type_value5 is not None:
                            type_instance5 = type_value5
                            virtual_machine_extension_json_instance.type = type_instance5
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_extension_json_instance.location = location_instance
                        
                        tags_sequence_element = resources_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                virtual_machine_extension_json_instance.tags[tags_key] = tags_value
                            
                id_value6 = response_doc.get('id', None)
                if id_value6 is not None:
                    id_instance6 = id_value6
                    virtual_machine_instance.id = id_instance6
                
                name_value8 = response_doc.get('name', None)
                if name_value8 is not None:
                    name_instance8 = name_value8
                    virtual_machine_instance.name = name_instance8
                
                type_value6 = response_doc.get('type', None)
                if type_value6 is not None:
                    type_instance6 = type_value6
                    virtual_machine_instance.type = type_instance6
                
                location_value2 = response_doc.get('location', None)
                if location_value2 is not None:
                    location_instance2 = location_value2
                    virtual_machine_instance.location = location_instance2
                
                tags_sequence_element2 = response_doc.get('tags', None)
                if tags_sequence_element2 is not None:
                    for property2 in tags_sequence_element2:
                        tags_key2 = property2
                        tags_value2 = tags_sequence_element2[property2]
                        virtual_machine_instance.tags[tags_key2] = tags_value2
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get_with_instance_view(self, resource_group_name, vm_name):
        """
         The operation to get a virtual machine along with its instance view.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         VirtualMachineGetResponse: The GetVM operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        query_parameters = []
        query_parameters.append('$expand=instanceView')
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_machine_instance = VirtualMachine(extensions=[], tags={})
                result.virtual_machine = virtual_machine_instance
                
                plan_value = response_doc.get('plan', None)
                if plan_value is not None:
                    plan_instance = Plan()
                    virtual_machine_instance.plan = plan_instance
                    
                    name_value = plan_value.get('name', None)
                    if name_value is not None:
                        name_instance = name_value
                        plan_instance.name = name_instance
                    
                    publisher_value = plan_value.get('publisher', None)
                    if publisher_value is not None:
                        publisher_instance = publisher_value
                        plan_instance.publisher = publisher_instance
                    
                    product_value = plan_value.get('product', None)
                    if product_value is not None:
                        product_instance = product_value
                        plan_instance.product = product_instance
                    
                    promotion_code_value = plan_value.get('promotionCode', None)
                    if promotion_code_value is not None:
                        promotion_code_instance = promotion_code_value
                        plan_instance.promotion_code = promotion_code_instance
                    
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    hardware_profile_value = properties_value.get('hardwareProfile', None)
                    if hardware_profile_value is not None:
                        hardware_profile_instance = HardwareProfile()
                        virtual_machine_instance.hardware_profile = hardware_profile_instance
                        
                        vm_size_value = hardware_profile_value.get('vmSize', None)
                        if vm_size_value is not None:
                            vm_size_instance = vm_size_value
                            hardware_profile_instance.virtual_machine_size = vm_size_instance
                        
                    storage_profile_value = properties_value.get('storageProfile', None)
                    if storage_profile_value is not None:
                        storage_profile_instance = StorageProfile(data_disks=[])
                        virtual_machine_instance.storage_profile = storage_profile_instance
                        
                        image_reference_value = storage_profile_value.get('imageReference', None)
                        if image_reference_value is not None:
                            image_reference_instance = ImageReference()
                            storage_profile_instance.image_reference = image_reference_instance
                            
                            publisher_value2 = image_reference_value.get('publisher', None)
                            if publisher_value2 is not None:
                                publisher_instance2 = publisher_value2
                                image_reference_instance.publisher = publisher_instance2
                            
                            offer_value = image_reference_value.get('offer', None)
                            if offer_value is not None:
                                offer_instance = offer_value
                                image_reference_instance.offer = offer_instance
                            
                            sku_value = image_reference_value.get('sku', None)
                            if sku_value is not None:
                                sku_instance = sku_value
                                image_reference_instance.sku = sku_instance
                            
                            version_value = image_reference_value.get('version', None)
                            if version_value is not None:
                                version_instance = version_value
                                image_reference_instance.version = version_instance
                            
                        source_image_value = storage_profile_value.get('sourceImage', None)
                        if source_image_value is not None:
                            source_image_instance = SourceImageReference()
                            storage_profile_instance.source_image = source_image_instance
                            
                            id_value = source_image_value.get('id', None)
                            if id_value is not None:
                                id_instance = id_value
                                source_image_instance.reference_uri = id_instance
                            
                        os_disk_value = storage_profile_value.get('osDisk', None)
                        if os_disk_value is not None:
                            os_disk_instance = OSDisk()
                            storage_profile_instance.os_disk = os_disk_instance
                            
                            os_type_value = os_disk_value.get('osType', None)
                            if os_type_value is not None:
                                os_type_instance = os_type_value
                                os_disk_instance.operating_system_type = os_type_instance
                            
                            name_value2 = os_disk_value.get('name', None)
                            if name_value2 is not None:
                                name_instance2 = name_value2
                                os_disk_instance.name = name_instance2
                            
                            vhd_value = os_disk_value.get('vhd', None)
                            if vhd_value is not None:
                                vhd_instance = VirtualHardDisk()
                                os_disk_instance.virtual_hard_disk = vhd_instance
                                
                                uri_value = vhd_value.get('uri', None)
                                if uri_value is not None:
                                    uri_instance = uri_value
                                    vhd_instance.uri = uri_instance
                                
                            image_value = os_disk_value.get('image', None)
                            if image_value is not None:
                                image_instance = VirtualHardDisk()
                                os_disk_instance.source_image = image_instance
                                
                                uri_value2 = image_value.get('uri', None)
                                if uri_value2 is not None:
                                    uri_instance2 = uri_value2
                                    image_instance.uri = uri_instance2
                                
                            caching_value = os_disk_value.get('caching', None)
                            if caching_value is not None:
                                caching_instance = caching_value
                                os_disk_instance.caching = caching_instance
                            
                            create_option_value = os_disk_value.get('createOption', None)
                            if create_option_value is not None:
                                create_option_instance = create_option_value
                                os_disk_instance.create_option = create_option_instance
                            
                        data_disks_array = storage_profile_value.get('dataDisks', None)
                        if data_disks_array is not None:
                            for data_disks_value in data_disks_array:
                                data_disk_instance = DataDisk()
                                storage_profile_instance.data_disks.append(data_disk_instance)
                                
                                lun_value = data_disks_value.get('lun', None)
                                if lun_value is not None:
                                    lun_instance = lun_value
                                    data_disk_instance.lun = lun_instance
                                
                                disk_size_gb_value = data_disks_value.get('diskSizeGB', None)
                                if disk_size_gb_value is not None:
                                    disk_size_gb_instance = disk_size_gb_value
                                    data_disk_instance.disk_size_gb = disk_size_gb_instance
                                
                                name_value3 = data_disks_value.get('name', None)
                                if name_value3 is not None:
                                    name_instance3 = name_value3
                                    data_disk_instance.name = name_instance3
                                
                                vhd_value2 = data_disks_value.get('vhd', None)
                                if vhd_value2 is not None:
                                    vhd_instance2 = VirtualHardDisk()
                                    data_disk_instance.virtual_hard_disk = vhd_instance2
                                    
                                    uri_value3 = vhd_value2.get('uri', None)
                                    if uri_value3 is not None:
                                        uri_instance3 = uri_value3
                                        vhd_instance2.uri = uri_instance3
                                    
                                image_value2 = data_disks_value.get('image', None)
                                if image_value2 is not None:
                                    image_instance2 = VirtualHardDisk()
                                    data_disk_instance.source_image = image_instance2
                                    
                                    uri_value4 = image_value2.get('uri', None)
                                    if uri_value4 is not None:
                                        uri_instance4 = uri_value4
                                        image_instance2.uri = uri_instance4
                                    
                                caching_value2 = data_disks_value.get('caching', None)
                                if caching_value2 is not None:
                                    caching_instance2 = caching_value2
                                    data_disk_instance.caching = caching_instance2
                                
                                create_option_value2 = data_disks_value.get('createOption', None)
                                if create_option_value2 is not None:
                                    create_option_instance2 = create_option_value2
                                    data_disk_instance.create_option = create_option_instance2
                                
                    os_profile_value = properties_value.get('osProfile', None)
                    if os_profile_value is not None:
                        os_profile_instance = OSProfile(secrets=[])
                        virtual_machine_instance.os_profile = os_profile_instance
                        
                        computer_name_value = os_profile_value.get('computerName', None)
                        if computer_name_value is not None:
                            computer_name_instance = computer_name_value
                            os_profile_instance.computer_name = computer_name_instance
                        
                        admin_username_value = os_profile_value.get('adminUsername', None)
                        if admin_username_value is not None:
                            admin_username_instance = admin_username_value
                            os_profile_instance.admin_username = admin_username_instance
                        
                        admin_password_value = os_profile_value.get('adminPassword', None)
                        if admin_password_value is not None:
                            admin_password_instance = admin_password_value
                            os_profile_instance.admin_password = admin_password_instance
                        
                        custom_data_value = os_profile_value.get('customData', None)
                        if custom_data_value is not None:
                            custom_data_instance = custom_data_value
                            os_profile_instance.custom_data = custom_data_instance
                        
                        windows_configuration_value = os_profile_value.get('windowsConfiguration', None)
                        if windows_configuration_value is not None:
                            windows_configuration_instance = WindowsConfiguration(additional_unattend_contents=[])
                            os_profile_instance.windows_configuration = windows_configuration_instance
                            
                            provision_vm_agent_value = windows_configuration_value.get('provisionVMAgent', None)
                            if provision_vm_agent_value is not None:
                                provision_vm_agent_instance = provision_vm_agent_value
                                windows_configuration_instance.provision_vm_agent = provision_vm_agent_instance
                            
                            enable_automatic_updates_value = windows_configuration_value.get('enableAutomaticUpdates', None)
                            if enable_automatic_updates_value is not None:
                                enable_automatic_updates_instance = enable_automatic_updates_value
                                windows_configuration_instance.enable_automatic_updates = enable_automatic_updates_instance
                            
                            time_zone_value = windows_configuration_value.get('timeZone', None)
                            if time_zone_value is not None:
                                time_zone_instance = time_zone_value
                                windows_configuration_instance.time_zone = time_zone_instance
                            
                            additional_unattend_content_array = windows_configuration_value.get('additionalUnattendContent', None)
                            if additional_unattend_content_array is not None:
                                for additional_unattend_content_value in additional_unattend_content_array:
                                    additional_unattend_content_instance = AdditionalUnattendContent()
                                    windows_configuration_instance.additional_unattend_contents.append(additional_unattend_content_instance)
                                    
                                    pass_name_value = additional_unattend_content_value.get('passName', None)
                                    if pass_name_value is not None:
                                        pass_name_instance = pass_name_value
                                        additional_unattend_content_instance.pass_name = pass_name_instance
                                    
                                    component_name_value = additional_unattend_content_value.get('componentName', None)
                                    if component_name_value is not None:
                                        component_name_instance = component_name_value
                                        additional_unattend_content_instance.component_name = component_name_instance
                                    
                                    setting_name_value = additional_unattend_content_value.get('settingName', None)
                                    if setting_name_value is not None:
                                        setting_name_instance = setting_name_value
                                        additional_unattend_content_instance.setting_name = setting_name_instance
                                    
                                    content_value = additional_unattend_content_value.get('content', None)
                                    if content_value is not None:
                                        content_instance = content_value
                                        additional_unattend_content_instance.content = content_instance
                                    
                            win_rm_value = windows_configuration_value.get('winRM', None)
                            if win_rm_value is not None:
                                win_rm_instance = WinRMConfiguration(listeners=[])
                                windows_configuration_instance.win_rm_configuration = win_rm_instance
                                
                                listeners_array = win_rm_value.get('listeners', None)
                                if listeners_array is not None:
                                    for listeners_value in listeners_array:
                                        win_rm_listener_instance = WinRMListener()
                                        win_rm_instance.listeners.append(win_rm_listener_instance)
                                        
                                        protocol_value = listeners_value.get('protocol', None)
                                        if protocol_value is not None:
                                            protocol_instance = protocol_value
                                            win_rm_listener_instance.protocol = protocol_instance
                                        
                                        certificate_url_value = listeners_value.get('certificateUrl', None)
                                        if certificate_url_value is not None:
                                            certificate_url_instance = certificate_url_value
                                            win_rm_listener_instance.certificate_url = certificate_url_instance
                                        
                        linux_configuration_value = os_profile_value.get('linuxConfiguration', None)
                        if linux_configuration_value is not None:
                            linux_configuration_instance = LinuxConfiguration()
                            os_profile_instance.linux_configuration = linux_configuration_instance
                            
                            disable_password_authentication_value = linux_configuration_value.get('disablePasswordAuthentication', None)
                            if disable_password_authentication_value is not None:
                                disable_password_authentication_instance = disable_password_authentication_value
                                linux_configuration_instance.disable_password_authentication = disable_password_authentication_instance
                            
                            ssh_value = linux_configuration_value.get('ssh', None)
                            if ssh_value is not None:
                                ssh_instance = SshConfiguration(public_keys=[])
                                linux_configuration_instance.ssh_configuration = ssh_instance
                                
                                public_keys_array = ssh_value.get('publicKeys', None)
                                if public_keys_array is not None:
                                    for public_keys_value in public_keys_array:
                                        ssh_public_key_instance = SshPublicKey()
                                        ssh_instance.public_keys.append(ssh_public_key_instance)
                                        
                                        path_value = public_keys_value.get('path', None)
                                        if path_value is not None:
                                            path_instance = path_value
                                            ssh_public_key_instance.path = path_instance
                                        
                                        key_data_value = public_keys_value.get('keyData', None)
                                        if key_data_value is not None:
                                            key_data_instance = key_data_value
                                            ssh_public_key_instance.key_data = key_data_instance
                                        
                        secrets_array = os_profile_value.get('secrets', None)
                        if secrets_array is not None:
                            for secrets_value in secrets_array:
                                vault_secret_group_instance = VaultSecretGroup(vault_certificates=[])
                                os_profile_instance.secrets.append(vault_secret_group_instance)
                                
                                source_vault_value = secrets_value.get('sourceVault', None)
                                if source_vault_value is not None:
                                    source_vault_instance = SourceVaultReference()
                                    vault_secret_group_instance.source_vault = source_vault_instance
                                    
                                    id_value2 = source_vault_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        source_vault_instance.reference_uri = id_instance2
                                    
                                vault_certificates_array = secrets_value.get('vaultCertificates', None)
                                if vault_certificates_array is not None:
                                    for vault_certificates_value in vault_certificates_array:
                                        vault_certificate_instance = VaultCertificate()
                                        vault_secret_group_instance.vault_certificates.append(vault_certificate_instance)
                                        
                                        certificate_url_value2 = vault_certificates_value.get('certificateUrl', None)
                                        if certificate_url_value2 is not None:
                                            certificate_url_instance2 = certificate_url_value2
                                            vault_certificate_instance.certificate_url = certificate_url_instance2
                                        
                                        certificate_store_value = vault_certificates_value.get('certificateStore', None)
                                        if certificate_store_value is not None:
                                            certificate_store_instance = certificate_store_value
                                            vault_certificate_instance.certificate_store = certificate_store_instance
                                        
                    network_profile_value = properties_value.get('networkProfile', None)
                    if network_profile_value is not None:
                        network_profile_instance = NetworkProfile(network_interfaces=[])
                        virtual_machine_instance.network_profile = network_profile_instance
                        
                        network_interfaces_array = network_profile_value.get('networkInterfaces', None)
                        if network_interfaces_array is not None:
                            for network_interfaces_value in network_interfaces_array:
                                network_interface_reference_json_instance = NetworkInterfaceReference()
                                network_profile_instance.network_interfaces.append(network_interface_reference_json_instance)
                                
                                properties_value2 = network_interfaces_value.get('properties', None)
                                if properties_value2 is not None:
                                    primary_value = properties_value2.get('primary', None)
                                    if primary_value is not None:
                                        primary_instance = primary_value
                                        network_interface_reference_json_instance.primary = primary_instance
                                    
                                id_value3 = network_interfaces_value.get('id', None)
                                if id_value3 is not None:
                                    id_instance3 = id_value3
                                    network_interface_reference_json_instance.reference_uri = id_instance3
                                
                    availability_set_value = properties_value.get('availabilitySet', None)
                    if availability_set_value is not None:
                        availability_set_instance = AvailabilitySetReference()
                        virtual_machine_instance.availability_set_reference = availability_set_instance
                        
                        id_value4 = availability_set_value.get('id', None)
                        if id_value4 is not None:
                            id_instance4 = id_value4
                            availability_set_instance.reference_uri = id_instance4
                        
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        virtual_machine_instance.provisioning_state = provisioning_state_instance
                    
                    instance_view_value = properties_value.get('instanceView', None)
                    if instance_view_value is not None:
                        instance_view_instance = VirtualMachineInstanceView(disks=[], extensions=[], statuses=[])
                        virtual_machine_instance.instance_view = instance_view_instance
                        
                        platform_update_domain_value = instance_view_value.get('platformUpdateDomain', None)
                        if platform_update_domain_value is not None:
                            platform_update_domain_instance = platform_update_domain_value
                            instance_view_instance.platform_update_domain = platform_update_domain_instance
                        
                        platform_fault_domain_value = instance_view_value.get('platformFaultDomain', None)
                        if platform_fault_domain_value is not None:
                            platform_fault_domain_instance = platform_fault_domain_value
                            instance_view_instance.platform_fault_domain = platform_fault_domain_instance
                        
                        rdp_thumb_print_value = instance_view_value.get('rdpThumbPrint', None)
                        if rdp_thumb_print_value is not None:
                            rdp_thumb_print_instance = rdp_thumb_print_value
                            instance_view_instance.remote_desktop_thumbprint = rdp_thumb_print_instance
                        
                        vm_agent_value = instance_view_value.get('vmAgent', None)
                        if vm_agent_value is not None:
                            vm_agent_instance = VirtualMachineAgentInstanceView(extension_handlers=[], statuses=[])
                            instance_view_instance.vm_agent = vm_agent_instance
                            
                            vm_agent_version_value = vm_agent_value.get('vmAgentVersion', None)
                            if vm_agent_version_value is not None:
                                vm_agent_version_instance = vm_agent_version_value
                                vm_agent_instance.vm_agent_version = vm_agent_version_instance
                            
                            extension_handlers_array = vm_agent_value.get('extensionHandlers', None)
                            if extension_handlers_array is not None:
                                for extension_handlers_value in extension_handlers_array:
                                    virtual_machine_extension_handler_instance_view_instance = VirtualMachineExtensionHandlerInstanceView()
                                    vm_agent_instance.extension_handlers.append(virtual_machine_extension_handler_instance_view_instance)
                                    
                                    type_value = extension_handlers_value.get('type', None)
                                    if type_value is not None:
                                        type_instance = type_value
                                        virtual_machine_extension_handler_instance_view_instance.type = type_instance
                                    
                                    type_handler_version_value = extension_handlers_value.get('typeHandlerVersion', None)
                                    if type_handler_version_value is not None:
                                        type_handler_version_instance = type_handler_version_value
                                        virtual_machine_extension_handler_instance_view_instance.type_handler_version = type_handler_version_instance
                                    
                                    status_value = extension_handlers_value.get('status', None)
                                    if status_value is not None:
                                        status_instance = InstanceViewStatus()
                                        virtual_machine_extension_handler_instance_view_instance.status = status_instance
                                        
                                        code_value = status_value.get('code', None)
                                        if code_value is not None:
                                            code_instance = code_value
                                            status_instance.code = code_instance
                                        
                                        level_value = status_value.get('level', None)
                                        if level_value is not None:
                                            level_instance = level_value
                                            status_instance.level = level_instance
                                        
                                        display_status_value = status_value.get('displayStatus', None)
                                        if display_status_value is not None:
                                            display_status_instance = display_status_value
                                            status_instance.display_status = display_status_instance
                                        
                                        message_value = status_value.get('message', None)
                                        if message_value is not None:
                                            message_instance = message_value
                                            status_instance.message = message_instance
                                        
                                        time_value = status_value.get('time', None)
                                        if time_value is not None:
                                            time_instance = time_value
                                            status_instance.time = time_instance
                                        
                            statuses_array = vm_agent_value.get('statuses', None)
                            if statuses_array is not None:
                                for statuses_value in statuses_array:
                                    instance_view_status_instance = InstanceViewStatus()
                                    vm_agent_instance.statuses.append(instance_view_status_instance)
                                    
                                    code_value2 = statuses_value.get('code', None)
                                    if code_value2 is not None:
                                        code_instance2 = code_value2
                                        instance_view_status_instance.code = code_instance2
                                    
                                    level_value2 = statuses_value.get('level', None)
                                    if level_value2 is not None:
                                        level_instance2 = level_value2
                                        instance_view_status_instance.level = level_instance2
                                    
                                    display_status_value2 = statuses_value.get('displayStatus', None)
                                    if display_status_value2 is not None:
                                        display_status_instance2 = display_status_value2
                                        instance_view_status_instance.display_status = display_status_instance2
                                    
                                    message_value2 = statuses_value.get('message', None)
                                    if message_value2 is not None:
                                        message_instance2 = message_value2
                                        instance_view_status_instance.message = message_instance2
                                    
                                    time_value2 = statuses_value.get('time', None)
                                    if time_value2 is not None:
                                        time_instance2 = time_value2
                                        instance_view_status_instance.time = time_instance2
                                    
                        disks_array = instance_view_value.get('disks', None)
                        if disks_array is not None:
                            for disks_value in disks_array:
                                disk_instance_view_instance = DiskInstanceView(statuses=[])
                                instance_view_instance.disks.append(disk_instance_view_instance)
                                
                                name_value4 = disks_value.get('name', None)
                                if name_value4 is not None:
                                    name_instance4 = name_value4
                                    disk_instance_view_instance.name = name_instance4
                                
                                statuses_array2 = disks_value.get('statuses', None)
                                if statuses_array2 is not None:
                                    for statuses_value2 in statuses_array2:
                                        instance_view_status_instance2 = InstanceViewStatus()
                                        disk_instance_view_instance.statuses.append(instance_view_status_instance2)
                                        
                                        code_value3 = statuses_value2.get('code', None)
                                        if code_value3 is not None:
                                            code_instance3 = code_value3
                                            instance_view_status_instance2.code = code_instance3
                                        
                                        level_value3 = statuses_value2.get('level', None)
                                        if level_value3 is not None:
                                            level_instance3 = level_value3
                                            instance_view_status_instance2.level = level_instance3
                                        
                                        display_status_value3 = statuses_value2.get('displayStatus', None)
                                        if display_status_value3 is not None:
                                            display_status_instance3 = display_status_value3
                                            instance_view_status_instance2.display_status = display_status_instance3
                                        
                                        message_value3 = statuses_value2.get('message', None)
                                        if message_value3 is not None:
                                            message_instance3 = message_value3
                                            instance_view_status_instance2.message = message_instance3
                                        
                                        time_value3 = statuses_value2.get('time', None)
                                        if time_value3 is not None:
                                            time_instance3 = time_value3
                                            instance_view_status_instance2.time = time_instance3
                                        
                        extensions_array = instance_view_value.get('extensions', None)
                        if extensions_array is not None:
                            for extensions_value in extensions_array:
                                virtual_machine_extension_instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                instance_view_instance.extensions.append(virtual_machine_extension_instance_view_instance)
                                
                                name_value5 = extensions_value.get('name', None)
                                if name_value5 is not None:
                                    name_instance5 = name_value5
                                    virtual_machine_extension_instance_view_instance.name = name_instance5
                                
                                type_value2 = extensions_value.get('type', None)
                                if type_value2 is not None:
                                    type_instance2 = type_value2
                                    virtual_machine_extension_instance_view_instance.extension_type = type_instance2
                                
                                type_handler_version_value2 = extensions_value.get('typeHandlerVersion', None)
                                if type_handler_version_value2 is not None:
                                    type_handler_version_instance2 = type_handler_version_value2
                                    virtual_machine_extension_instance_view_instance.type_handler_version = type_handler_version_instance2
                                
                                substatuses_array = extensions_value.get('substatuses', None)
                                if substatuses_array is not None:
                                    for substatuses_value in substatuses_array:
                                        instance_view_status_instance3 = InstanceViewStatus()
                                        virtual_machine_extension_instance_view_instance.sub_statuses.append(instance_view_status_instance3)
                                        
                                        code_value4 = substatuses_value.get('code', None)
                                        if code_value4 is not None:
                                            code_instance4 = code_value4
                                            instance_view_status_instance3.code = code_instance4
                                        
                                        level_value4 = substatuses_value.get('level', None)
                                        if level_value4 is not None:
                                            level_instance4 = level_value4
                                            instance_view_status_instance3.level = level_instance4
                                        
                                        display_status_value4 = substatuses_value.get('displayStatus', None)
                                        if display_status_value4 is not None:
                                            display_status_instance4 = display_status_value4
                                            instance_view_status_instance3.display_status = display_status_instance4
                                        
                                        message_value4 = substatuses_value.get('message', None)
                                        if message_value4 is not None:
                                            message_instance4 = message_value4
                                            instance_view_status_instance3.message = message_instance4
                                        
                                        time_value4 = substatuses_value.get('time', None)
                                        if time_value4 is not None:
                                            time_instance4 = time_value4
                                            instance_view_status_instance3.time = time_instance4
                                        
                                statuses_array3 = extensions_value.get('statuses', None)
                                if statuses_array3 is not None:
                                    for statuses_value3 in statuses_array3:
                                        instance_view_status_instance4 = InstanceViewStatus()
                                        virtual_machine_extension_instance_view_instance.statuses.append(instance_view_status_instance4)
                                        
                                        code_value5 = statuses_value3.get('code', None)
                                        if code_value5 is not None:
                                            code_instance5 = code_value5
                                            instance_view_status_instance4.code = code_instance5
                                        
                                        level_value5 = statuses_value3.get('level', None)
                                        if level_value5 is not None:
                                            level_instance5 = level_value5
                                            instance_view_status_instance4.level = level_instance5
                                        
                                        display_status_value5 = statuses_value3.get('displayStatus', None)
                                        if display_status_value5 is not None:
                                            display_status_instance5 = display_status_value5
                                            instance_view_status_instance4.display_status = display_status_instance5
                                        
                                        message_value5 = statuses_value3.get('message', None)
                                        if message_value5 is not None:
                                            message_instance5 = message_value5
                                            instance_view_status_instance4.message = message_instance5
                                        
                                        time_value5 = statuses_value3.get('time', None)
                                        if time_value5 is not None:
                                            time_instance5 = time_value5
                                            instance_view_status_instance4.time = time_instance5
                                        
                        statuses_array4 = instance_view_value.get('statuses', None)
                        if statuses_array4 is not None:
                            for statuses_value4 in statuses_array4:
                                instance_view_status_instance5 = InstanceViewStatus()
                                instance_view_instance.statuses.append(instance_view_status_instance5)
                                
                                code_value6 = statuses_value4.get('code', None)
                                if code_value6 is not None:
                                    code_instance6 = code_value6
                                    instance_view_status_instance5.code = code_instance6
                                
                                level_value6 = statuses_value4.get('level', None)
                                if level_value6 is not None:
                                    level_instance6 = level_value6
                                    instance_view_status_instance5.level = level_instance6
                                
                                display_status_value6 = statuses_value4.get('displayStatus', None)
                                if display_status_value6 is not None:
                                    display_status_instance6 = display_status_value6
                                    instance_view_status_instance5.display_status = display_status_instance6
                                
                                message_value6 = statuses_value4.get('message', None)
                                if message_value6 is not None:
                                    message_instance6 = message_value6
                                    instance_view_status_instance5.message = message_instance6
                                
                                time_value6 = statuses_value4.get('time', None)
                                if time_value6 is not None:
                                    time_instance6 = time_value6
                                    instance_view_status_instance5.time = time_instance6
                                
                resources_array = response_doc.get('resources', None)
                if resources_array is not None:
                    virtual_machine_instance.extensions = []
                    for resources_value in resources_array:
                        virtual_machine_extension_json_instance = VirtualMachineExtension(tags={})
                        virtual_machine_instance.extensions.append(virtual_machine_extension_json_instance)
                        
                        properties_value3 = resources_value.get('properties', None)
                        if properties_value3 is not None:
                            publisher_value3 = properties_value3.get('publisher', None)
                            if publisher_value3 is not None:
                                publisher_instance3 = publisher_value3
                                virtual_machine_extension_json_instance.publisher = publisher_instance3
                            
                            type_value3 = properties_value3.get('type', None)
                            if type_value3 is not None:
                                type_instance3 = type_value3
                                virtual_machine_extension_json_instance.extension_type = type_instance3
                            
                            type_handler_version_value3 = properties_value3.get('typeHandlerVersion', None)
                            if type_handler_version_value3 is not None:
                                type_handler_version_instance3 = type_handler_version_value3
                                virtual_machine_extension_json_instance.type_handler_version = type_handler_version_instance3
                            
                            auto_upgrade_minor_version_value = properties_value3.get('autoUpgradeMinorVersion', None)
                            if auto_upgrade_minor_version_value is not None:
                                auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                                virtual_machine_extension_json_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                            
                            settings_value = properties_value3.get('settings', None)
                            if settings_value is not None:
                                settings_instance = json.dumps(settings_value)
                                virtual_machine_extension_json_instance.settings = settings_instance
                            
                            protected_settings_value = properties_value3.get('protectedSettings', None)
                            if protected_settings_value is not None:
                                protected_settings_instance = json.dumps(protected_settings_value)
                                virtual_machine_extension_json_instance.protected_settings = protected_settings_instance
                            
                            provisioning_state_value2 = properties_value3.get('provisioningState', None)
                            if provisioning_state_value2 is not None:
                                provisioning_state_instance2 = provisioning_state_value2
                                virtual_machine_extension_json_instance.provisioning_state = provisioning_state_instance2
                            
                            instance_view_value2 = properties_value3.get('instanceView', None)
                            if instance_view_value2 is not None:
                                instance_view_instance2 = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                virtual_machine_extension_json_instance.instance_view = instance_view_instance2
                                
                                name_value6 = instance_view_value2.get('name', None)
                                if name_value6 is not None:
                                    name_instance6 = name_value6
                                    instance_view_instance2.name = name_instance6
                                
                                type_value4 = instance_view_value2.get('type', None)
                                if type_value4 is not None:
                                    type_instance4 = type_value4
                                    instance_view_instance2.extension_type = type_instance4
                                
                                type_handler_version_value4 = instance_view_value2.get('typeHandlerVersion', None)
                                if type_handler_version_value4 is not None:
                                    type_handler_version_instance4 = type_handler_version_value4
                                    instance_view_instance2.type_handler_version = type_handler_version_instance4
                                
                                substatuses_array2 = instance_view_value2.get('substatuses', None)
                                if substatuses_array2 is not None:
                                    for substatuses_value2 in substatuses_array2:
                                        instance_view_status_instance6 = InstanceViewStatus()
                                        instance_view_instance2.sub_statuses.append(instance_view_status_instance6)
                                        
                                        code_value7 = substatuses_value2.get('code', None)
                                        if code_value7 is not None:
                                            code_instance7 = code_value7
                                            instance_view_status_instance6.code = code_instance7
                                        
                                        level_value7 = substatuses_value2.get('level', None)
                                        if level_value7 is not None:
                                            level_instance7 = level_value7
                                            instance_view_status_instance6.level = level_instance7
                                        
                                        display_status_value7 = substatuses_value2.get('displayStatus', None)
                                        if display_status_value7 is not None:
                                            display_status_instance7 = display_status_value7
                                            instance_view_status_instance6.display_status = display_status_instance7
                                        
                                        message_value7 = substatuses_value2.get('message', None)
                                        if message_value7 is not None:
                                            message_instance7 = message_value7
                                            instance_view_status_instance6.message = message_instance7
                                        
                                        time_value7 = substatuses_value2.get('time', None)
                                        if time_value7 is not None:
                                            time_instance7 = time_value7
                                            instance_view_status_instance6.time = time_instance7
                                        
                                statuses_array5 = instance_view_value2.get('statuses', None)
                                if statuses_array5 is not None:
                                    for statuses_value5 in statuses_array5:
                                        instance_view_status_instance7 = InstanceViewStatus()
                                        instance_view_instance2.statuses.append(instance_view_status_instance7)
                                        
                                        code_value8 = statuses_value5.get('code', None)
                                        if code_value8 is not None:
                                            code_instance8 = code_value8
                                            instance_view_status_instance7.code = code_instance8
                                        
                                        level_value8 = statuses_value5.get('level', None)
                                        if level_value8 is not None:
                                            level_instance8 = level_value8
                                            instance_view_status_instance7.level = level_instance8
                                        
                                        display_status_value8 = statuses_value5.get('displayStatus', None)
                                        if display_status_value8 is not None:
                                            display_status_instance8 = display_status_value8
                                            instance_view_status_instance7.display_status = display_status_instance8
                                        
                                        message_value8 = statuses_value5.get('message', None)
                                        if message_value8 is not None:
                                            message_instance8 = message_value8
                                            instance_view_status_instance7.message = message_instance8
                                        
                                        time_value8 = statuses_value5.get('time', None)
                                        if time_value8 is not None:
                                            time_instance8 = time_value8
                                            instance_view_status_instance7.time = time_instance8
                                        
                        id_value5 = resources_value.get('id', None)
                        if id_value5 is not None:
                            id_instance5 = id_value5
                            virtual_machine_extension_json_instance.id = id_instance5
                        
                        name_value7 = resources_value.get('name', None)
                        if name_value7 is not None:
                            name_instance7 = name_value7
                            virtual_machine_extension_json_instance.name = name_instance7
                        
                        type_value5 = resources_value.get('type', None)
                        if type_value5 is not None:
                            type_instance5 = type_value5
                            virtual_machine_extension_json_instance.type = type_instance5
                        
                        location_value = resources_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_machine_extension_json_instance.location = location_instance
                        
                        tags_sequence_element = resources_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                virtual_machine_extension_json_instance.tags[tags_key] = tags_value
                            
                id_value6 = response_doc.get('id', None)
                if id_value6 is not None:
                    id_instance6 = id_value6
                    virtual_machine_instance.id = id_instance6
                
                name_value8 = response_doc.get('name', None)
                if name_value8 is not None:
                    name_instance8 = name_value8
                    virtual_machine_instance.name = name_instance8
                
                type_value6 = response_doc.get('type', None)
                if type_value6 is not None:
                    type_instance6 = type_value6
                    virtual_machine_instance.type = type_instance6
                
                location_value2 = response_doc.get('location', None)
                if location_value2 is not None:
                    location_instance2 = location_value2
                    virtual_machine_instance.location = location_instance2
                
                tags_sequence_element2 = response_doc.get('tags', None)
                if tags_sequence_element2 is not None:
                    for property2 in tags_sequence_element2:
                        tags_key2 = property2
                        tags_value2 = tags_sequence_element2[property2]
                        virtual_machine_instance.tags[tags_key2] = tags_value2
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The operation to list virtual machines under a resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         VirtualMachineListResponse: The List Virtual Machine operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineListResponse(virtual_machines=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_machine_json_instance = VirtualMachine(extensions=[], tags={})
                        result.virtual_machines.append(virtual_machine_json_instance)
                        
                        plan_value = value_value.get('plan', None)
                        if plan_value is not None:
                            plan_instance = Plan()
                            virtual_machine_json_instance.plan = plan_instance
                            
                            name_value = plan_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                plan_instance.name = name_instance
                            
                            publisher_value = plan_value.get('publisher', None)
                            if publisher_value is not None:
                                publisher_instance = publisher_value
                                plan_instance.publisher = publisher_instance
                            
                            product_value = plan_value.get('product', None)
                            if product_value is not None:
                                product_instance = product_value
                                plan_instance.product = product_instance
                            
                            promotion_code_value = plan_value.get('promotionCode', None)
                            if promotion_code_value is not None:
                                promotion_code_instance = promotion_code_value
                                plan_instance.promotion_code = promotion_code_instance
                            
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            hardware_profile_value = properties_value.get('hardwareProfile', None)
                            if hardware_profile_value is not None:
                                hardware_profile_instance = HardwareProfile()
                                virtual_machine_json_instance.hardware_profile = hardware_profile_instance
                                
                                vm_size_value = hardware_profile_value.get('vmSize', None)
                                if vm_size_value is not None:
                                    vm_size_instance = vm_size_value
                                    hardware_profile_instance.virtual_machine_size = vm_size_instance
                                
                            storage_profile_value = properties_value.get('storageProfile', None)
                            if storage_profile_value is not None:
                                storage_profile_instance = StorageProfile(data_disks=[])
                                virtual_machine_json_instance.storage_profile = storage_profile_instance
                                
                                image_reference_value = storage_profile_value.get('imageReference', None)
                                if image_reference_value is not None:
                                    image_reference_instance = ImageReference()
                                    storage_profile_instance.image_reference = image_reference_instance
                                    
                                    publisher_value2 = image_reference_value.get('publisher', None)
                                    if publisher_value2 is not None:
                                        publisher_instance2 = publisher_value2
                                        image_reference_instance.publisher = publisher_instance2
                                    
                                    offer_value = image_reference_value.get('offer', None)
                                    if offer_value is not None:
                                        offer_instance = offer_value
                                        image_reference_instance.offer = offer_instance
                                    
                                    sku_value = image_reference_value.get('sku', None)
                                    if sku_value is not None:
                                        sku_instance = sku_value
                                        image_reference_instance.sku = sku_instance
                                    
                                    version_value = image_reference_value.get('version', None)
                                    if version_value is not None:
                                        version_instance = version_value
                                        image_reference_instance.version = version_instance
                                    
                                source_image_value = storage_profile_value.get('sourceImage', None)
                                if source_image_value is not None:
                                    source_image_instance = SourceImageReference()
                                    storage_profile_instance.source_image = source_image_instance
                                    
                                    id_value = source_image_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        source_image_instance.reference_uri = id_instance
                                    
                                os_disk_value = storage_profile_value.get('osDisk', None)
                                if os_disk_value is not None:
                                    os_disk_instance = OSDisk()
                                    storage_profile_instance.os_disk = os_disk_instance
                                    
                                    os_type_value = os_disk_value.get('osType', None)
                                    if os_type_value is not None:
                                        os_type_instance = os_type_value
                                        os_disk_instance.operating_system_type = os_type_instance
                                    
                                    name_value2 = os_disk_value.get('name', None)
                                    if name_value2 is not None:
                                        name_instance2 = name_value2
                                        os_disk_instance.name = name_instance2
                                    
                                    vhd_value = os_disk_value.get('vhd', None)
                                    if vhd_value is not None:
                                        vhd_instance = VirtualHardDisk()
                                        os_disk_instance.virtual_hard_disk = vhd_instance
                                        
                                        uri_value = vhd_value.get('uri', None)
                                        if uri_value is not None:
                                            uri_instance = uri_value
                                            vhd_instance.uri = uri_instance
                                        
                                    image_value = os_disk_value.get('image', None)
                                    if image_value is not None:
                                        image_instance = VirtualHardDisk()
                                        os_disk_instance.source_image = image_instance
                                        
                                        uri_value2 = image_value.get('uri', None)
                                        if uri_value2 is not None:
                                            uri_instance2 = uri_value2
                                            image_instance.uri = uri_instance2
                                        
                                    caching_value = os_disk_value.get('caching', None)
                                    if caching_value is not None:
                                        caching_instance = caching_value
                                        os_disk_instance.caching = caching_instance
                                    
                                    create_option_value = os_disk_value.get('createOption', None)
                                    if create_option_value is not None:
                                        create_option_instance = create_option_value
                                        os_disk_instance.create_option = create_option_instance
                                    
                                data_disks_array = storage_profile_value.get('dataDisks', None)
                                if data_disks_array is not None:
                                    for data_disks_value in data_disks_array:
                                        data_disk_instance = DataDisk()
                                        storage_profile_instance.data_disks.append(data_disk_instance)
                                        
                                        lun_value = data_disks_value.get('lun', None)
                                        if lun_value is not None:
                                            lun_instance = lun_value
                                            data_disk_instance.lun = lun_instance
                                        
                                        disk_size_gb_value = data_disks_value.get('diskSizeGB', None)
                                        if disk_size_gb_value is not None:
                                            disk_size_gb_instance = disk_size_gb_value
                                            data_disk_instance.disk_size_gb = disk_size_gb_instance
                                        
                                        name_value3 = data_disks_value.get('name', None)
                                        if name_value3 is not None:
                                            name_instance3 = name_value3
                                            data_disk_instance.name = name_instance3
                                        
                                        vhd_value2 = data_disks_value.get('vhd', None)
                                        if vhd_value2 is not None:
                                            vhd_instance2 = VirtualHardDisk()
                                            data_disk_instance.virtual_hard_disk = vhd_instance2
                                            
                                            uri_value3 = vhd_value2.get('uri', None)
                                            if uri_value3 is not None:
                                                uri_instance3 = uri_value3
                                                vhd_instance2.uri = uri_instance3
                                            
                                        image_value2 = data_disks_value.get('image', None)
                                        if image_value2 is not None:
                                            image_instance2 = VirtualHardDisk()
                                            data_disk_instance.source_image = image_instance2
                                            
                                            uri_value4 = image_value2.get('uri', None)
                                            if uri_value4 is not None:
                                                uri_instance4 = uri_value4
                                                image_instance2.uri = uri_instance4
                                            
                                        caching_value2 = data_disks_value.get('caching', None)
                                        if caching_value2 is not None:
                                            caching_instance2 = caching_value2
                                            data_disk_instance.caching = caching_instance2
                                        
                                        create_option_value2 = data_disks_value.get('createOption', None)
                                        if create_option_value2 is not None:
                                            create_option_instance2 = create_option_value2
                                            data_disk_instance.create_option = create_option_instance2
                                        
                            os_profile_value = properties_value.get('osProfile', None)
                            if os_profile_value is not None:
                                os_profile_instance = OSProfile(secrets=[])
                                virtual_machine_json_instance.os_profile = os_profile_instance
                                
                                computer_name_value = os_profile_value.get('computerName', None)
                                if computer_name_value is not None:
                                    computer_name_instance = computer_name_value
                                    os_profile_instance.computer_name = computer_name_instance
                                
                                admin_username_value = os_profile_value.get('adminUsername', None)
                                if admin_username_value is not None:
                                    admin_username_instance = admin_username_value
                                    os_profile_instance.admin_username = admin_username_instance
                                
                                admin_password_value = os_profile_value.get('adminPassword', None)
                                if admin_password_value is not None:
                                    admin_password_instance = admin_password_value
                                    os_profile_instance.admin_password = admin_password_instance
                                
                                custom_data_value = os_profile_value.get('customData', None)
                                if custom_data_value is not None:
                                    custom_data_instance = custom_data_value
                                    os_profile_instance.custom_data = custom_data_instance
                                
                                windows_configuration_value = os_profile_value.get('windowsConfiguration', None)
                                if windows_configuration_value is not None:
                                    windows_configuration_instance = WindowsConfiguration(additional_unattend_contents=[])
                                    os_profile_instance.windows_configuration = windows_configuration_instance
                                    
                                    provision_vm_agent_value = windows_configuration_value.get('provisionVMAgent', None)
                                    if provision_vm_agent_value is not None:
                                        provision_vm_agent_instance = provision_vm_agent_value
                                        windows_configuration_instance.provision_vm_agent = provision_vm_agent_instance
                                    
                                    enable_automatic_updates_value = windows_configuration_value.get('enableAutomaticUpdates', None)
                                    if enable_automatic_updates_value is not None:
                                        enable_automatic_updates_instance = enable_automatic_updates_value
                                        windows_configuration_instance.enable_automatic_updates = enable_automatic_updates_instance
                                    
                                    time_zone_value = windows_configuration_value.get('timeZone', None)
                                    if time_zone_value is not None:
                                        time_zone_instance = time_zone_value
                                        windows_configuration_instance.time_zone = time_zone_instance
                                    
                                    additional_unattend_content_array = windows_configuration_value.get('additionalUnattendContent', None)
                                    if additional_unattend_content_array is not None:
                                        for additional_unattend_content_value in additional_unattend_content_array:
                                            additional_unattend_content_instance = AdditionalUnattendContent()
                                            windows_configuration_instance.additional_unattend_contents.append(additional_unattend_content_instance)
                                            
                                            pass_name_value = additional_unattend_content_value.get('passName', None)
                                            if pass_name_value is not None:
                                                pass_name_instance = pass_name_value
                                                additional_unattend_content_instance.pass_name = pass_name_instance
                                            
                                            component_name_value = additional_unattend_content_value.get('componentName', None)
                                            if component_name_value is not None:
                                                component_name_instance = component_name_value
                                                additional_unattend_content_instance.component_name = component_name_instance
                                            
                                            setting_name_value = additional_unattend_content_value.get('settingName', None)
                                            if setting_name_value is not None:
                                                setting_name_instance = setting_name_value
                                                additional_unattend_content_instance.setting_name = setting_name_instance
                                            
                                            content_value = additional_unattend_content_value.get('content', None)
                                            if content_value is not None:
                                                content_instance = content_value
                                                additional_unattend_content_instance.content = content_instance
                                            
                                    win_rm_value = windows_configuration_value.get('winRM', None)
                                    if win_rm_value is not None:
                                        win_rm_instance = WinRMConfiguration(listeners=[])
                                        windows_configuration_instance.win_rm_configuration = win_rm_instance
                                        
                                        listeners_array = win_rm_value.get('listeners', None)
                                        if listeners_array is not None:
                                            for listeners_value in listeners_array:
                                                win_rm_listener_instance = WinRMListener()
                                                win_rm_instance.listeners.append(win_rm_listener_instance)
                                                
                                                protocol_value = listeners_value.get('protocol', None)
                                                if protocol_value is not None:
                                                    protocol_instance = protocol_value
                                                    win_rm_listener_instance.protocol = protocol_instance
                                                
                                                certificate_url_value = listeners_value.get('certificateUrl', None)
                                                if certificate_url_value is not None:
                                                    certificate_url_instance = certificate_url_value
                                                    win_rm_listener_instance.certificate_url = certificate_url_instance
                                                
                                linux_configuration_value = os_profile_value.get('linuxConfiguration', None)
                                if linux_configuration_value is not None:
                                    linux_configuration_instance = LinuxConfiguration()
                                    os_profile_instance.linux_configuration = linux_configuration_instance
                                    
                                    disable_password_authentication_value = linux_configuration_value.get('disablePasswordAuthentication', None)
                                    if disable_password_authentication_value is not None:
                                        disable_password_authentication_instance = disable_password_authentication_value
                                        linux_configuration_instance.disable_password_authentication = disable_password_authentication_instance
                                    
                                    ssh_value = linux_configuration_value.get('ssh', None)
                                    if ssh_value is not None:
                                        ssh_instance = SshConfiguration(public_keys=[])
                                        linux_configuration_instance.ssh_configuration = ssh_instance
                                        
                                        public_keys_array = ssh_value.get('publicKeys', None)
                                        if public_keys_array is not None:
                                            for public_keys_value in public_keys_array:
                                                ssh_public_key_instance = SshPublicKey()
                                                ssh_instance.public_keys.append(ssh_public_key_instance)
                                                
                                                path_value = public_keys_value.get('path', None)
                                                if path_value is not None:
                                                    path_instance = path_value
                                                    ssh_public_key_instance.path = path_instance
                                                
                                                key_data_value = public_keys_value.get('keyData', None)
                                                if key_data_value is not None:
                                                    key_data_instance = key_data_value
                                                    ssh_public_key_instance.key_data = key_data_instance
                                                
                                secrets_array = os_profile_value.get('secrets', None)
                                if secrets_array is not None:
                                    for secrets_value in secrets_array:
                                        vault_secret_group_instance = VaultSecretGroup(vault_certificates=[])
                                        os_profile_instance.secrets.append(vault_secret_group_instance)
                                        
                                        source_vault_value = secrets_value.get('sourceVault', None)
                                        if source_vault_value is not None:
                                            source_vault_instance = SourceVaultReference()
                                            vault_secret_group_instance.source_vault = source_vault_instance
                                            
                                            id_value2 = source_vault_value.get('id', None)
                                            if id_value2 is not None:
                                                id_instance2 = id_value2
                                                source_vault_instance.reference_uri = id_instance2
                                            
                                        vault_certificates_array = secrets_value.get('vaultCertificates', None)
                                        if vault_certificates_array is not None:
                                            for vault_certificates_value in vault_certificates_array:
                                                vault_certificate_instance = VaultCertificate()
                                                vault_secret_group_instance.vault_certificates.append(vault_certificate_instance)
                                                
                                                certificate_url_value2 = vault_certificates_value.get('certificateUrl', None)
                                                if certificate_url_value2 is not None:
                                                    certificate_url_instance2 = certificate_url_value2
                                                    vault_certificate_instance.certificate_url = certificate_url_instance2
                                                
                                                certificate_store_value = vault_certificates_value.get('certificateStore', None)
                                                if certificate_store_value is not None:
                                                    certificate_store_instance = certificate_store_value
                                                    vault_certificate_instance.certificate_store = certificate_store_instance
                                                
                            network_profile_value = properties_value.get('networkProfile', None)
                            if network_profile_value is not None:
                                network_profile_instance = NetworkProfile(network_interfaces=[])
                                virtual_machine_json_instance.network_profile = network_profile_instance
                                
                                network_interfaces_array = network_profile_value.get('networkInterfaces', None)
                                if network_interfaces_array is not None:
                                    for network_interfaces_value in network_interfaces_array:
                                        network_interface_reference_json_instance = NetworkInterfaceReference()
                                        network_profile_instance.network_interfaces.append(network_interface_reference_json_instance)
                                        
                                        properties_value2 = network_interfaces_value.get('properties', None)
                                        if properties_value2 is not None:
                                            primary_value = properties_value2.get('primary', None)
                                            if primary_value is not None:
                                                primary_instance = primary_value
                                                network_interface_reference_json_instance.primary = primary_instance
                                            
                                        id_value3 = network_interfaces_value.get('id', None)
                                        if id_value3 is not None:
                                            id_instance3 = id_value3
                                            network_interface_reference_json_instance.reference_uri = id_instance3
                                        
                            availability_set_value = properties_value.get('availabilitySet', None)
                            if availability_set_value is not None:
                                availability_set_instance = AvailabilitySetReference()
                                virtual_machine_json_instance.availability_set_reference = availability_set_instance
                                
                                id_value4 = availability_set_value.get('id', None)
                                if id_value4 is not None:
                                    id_instance4 = id_value4
                                    availability_set_instance.reference_uri = id_instance4
                                
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                virtual_machine_json_instance.provisioning_state = provisioning_state_instance
                            
                            instance_view_value = properties_value.get('instanceView', None)
                            if instance_view_value is not None:
                                instance_view_instance = VirtualMachineInstanceView(disks=[], extensions=[], statuses=[])
                                virtual_machine_json_instance.instance_view = instance_view_instance
                                
                                platform_update_domain_value = instance_view_value.get('platformUpdateDomain', None)
                                if platform_update_domain_value is not None:
                                    platform_update_domain_instance = platform_update_domain_value
                                    instance_view_instance.platform_update_domain = platform_update_domain_instance
                                
                                platform_fault_domain_value = instance_view_value.get('platformFaultDomain', None)
                                if platform_fault_domain_value is not None:
                                    platform_fault_domain_instance = platform_fault_domain_value
                                    instance_view_instance.platform_fault_domain = platform_fault_domain_instance
                                
                                rdp_thumb_print_value = instance_view_value.get('rdpThumbPrint', None)
                                if rdp_thumb_print_value is not None:
                                    rdp_thumb_print_instance = rdp_thumb_print_value
                                    instance_view_instance.remote_desktop_thumbprint = rdp_thumb_print_instance
                                
                                vm_agent_value = instance_view_value.get('vmAgent', None)
                                if vm_agent_value is not None:
                                    vm_agent_instance = VirtualMachineAgentInstanceView(extension_handlers=[], statuses=[])
                                    instance_view_instance.vm_agent = vm_agent_instance
                                    
                                    vm_agent_version_value = vm_agent_value.get('vmAgentVersion', None)
                                    if vm_agent_version_value is not None:
                                        vm_agent_version_instance = vm_agent_version_value
                                        vm_agent_instance.vm_agent_version = vm_agent_version_instance
                                    
                                    extension_handlers_array = vm_agent_value.get('extensionHandlers', None)
                                    if extension_handlers_array is not None:
                                        for extension_handlers_value in extension_handlers_array:
                                            virtual_machine_extension_handler_instance_view_instance = VirtualMachineExtensionHandlerInstanceView()
                                            vm_agent_instance.extension_handlers.append(virtual_machine_extension_handler_instance_view_instance)
                                            
                                            type_value = extension_handlers_value.get('type', None)
                                            if type_value is not None:
                                                type_instance = type_value
                                                virtual_machine_extension_handler_instance_view_instance.type = type_instance
                                            
                                            type_handler_version_value = extension_handlers_value.get('typeHandlerVersion', None)
                                            if type_handler_version_value is not None:
                                                type_handler_version_instance = type_handler_version_value
                                                virtual_machine_extension_handler_instance_view_instance.type_handler_version = type_handler_version_instance
                                            
                                            status_value = extension_handlers_value.get('status', None)
                                            if status_value is not None:
                                                status_instance = InstanceViewStatus()
                                                virtual_machine_extension_handler_instance_view_instance.status = status_instance
                                                
                                                code_value = status_value.get('code', None)
                                                if code_value is not None:
                                                    code_instance = code_value
                                                    status_instance.code = code_instance
                                                
                                                level_value = status_value.get('level', None)
                                                if level_value is not None:
                                                    level_instance = level_value
                                                    status_instance.level = level_instance
                                                
                                                display_status_value = status_value.get('displayStatus', None)
                                                if display_status_value is not None:
                                                    display_status_instance = display_status_value
                                                    status_instance.display_status = display_status_instance
                                                
                                                message_value = status_value.get('message', None)
                                                if message_value is not None:
                                                    message_instance = message_value
                                                    status_instance.message = message_instance
                                                
                                                time_value = status_value.get('time', None)
                                                if time_value is not None:
                                                    time_instance = time_value
                                                    status_instance.time = time_instance
                                                
                                    statuses_array = vm_agent_value.get('statuses', None)
                                    if statuses_array is not None:
                                        for statuses_value in statuses_array:
                                            instance_view_status_instance = InstanceViewStatus()
                                            vm_agent_instance.statuses.append(instance_view_status_instance)
                                            
                                            code_value2 = statuses_value.get('code', None)
                                            if code_value2 is not None:
                                                code_instance2 = code_value2
                                                instance_view_status_instance.code = code_instance2
                                            
                                            level_value2 = statuses_value.get('level', None)
                                            if level_value2 is not None:
                                                level_instance2 = level_value2
                                                instance_view_status_instance.level = level_instance2
                                            
                                            display_status_value2 = statuses_value.get('displayStatus', None)
                                            if display_status_value2 is not None:
                                                display_status_instance2 = display_status_value2
                                                instance_view_status_instance.display_status = display_status_instance2
                                            
                                            message_value2 = statuses_value.get('message', None)
                                            if message_value2 is not None:
                                                message_instance2 = message_value2
                                                instance_view_status_instance.message = message_instance2
                                            
                                            time_value2 = statuses_value.get('time', None)
                                            if time_value2 is not None:
                                                time_instance2 = time_value2
                                                instance_view_status_instance.time = time_instance2
                                            
                                disks_array = instance_view_value.get('disks', None)
                                if disks_array is not None:
                                    for disks_value in disks_array:
                                        disk_instance_view_instance = DiskInstanceView(statuses=[])
                                        instance_view_instance.disks.append(disk_instance_view_instance)
                                        
                                        name_value4 = disks_value.get('name', None)
                                        if name_value4 is not None:
                                            name_instance4 = name_value4
                                            disk_instance_view_instance.name = name_instance4
                                        
                                        statuses_array2 = disks_value.get('statuses', None)
                                        if statuses_array2 is not None:
                                            for statuses_value2 in statuses_array2:
                                                instance_view_status_instance2 = InstanceViewStatus()
                                                disk_instance_view_instance.statuses.append(instance_view_status_instance2)
                                                
                                                code_value3 = statuses_value2.get('code', None)
                                                if code_value3 is not None:
                                                    code_instance3 = code_value3
                                                    instance_view_status_instance2.code = code_instance3
                                                
                                                level_value3 = statuses_value2.get('level', None)
                                                if level_value3 is not None:
                                                    level_instance3 = level_value3
                                                    instance_view_status_instance2.level = level_instance3
                                                
                                                display_status_value3 = statuses_value2.get('displayStatus', None)
                                                if display_status_value3 is not None:
                                                    display_status_instance3 = display_status_value3
                                                    instance_view_status_instance2.display_status = display_status_instance3
                                                
                                                message_value3 = statuses_value2.get('message', None)
                                                if message_value3 is not None:
                                                    message_instance3 = message_value3
                                                    instance_view_status_instance2.message = message_instance3
                                                
                                                time_value3 = statuses_value2.get('time', None)
                                                if time_value3 is not None:
                                                    time_instance3 = time_value3
                                                    instance_view_status_instance2.time = time_instance3
                                                
                                extensions_array = instance_view_value.get('extensions', None)
                                if extensions_array is not None:
                                    for extensions_value in extensions_array:
                                        virtual_machine_extension_instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                        instance_view_instance.extensions.append(virtual_machine_extension_instance_view_instance)
                                        
                                        name_value5 = extensions_value.get('name', None)
                                        if name_value5 is not None:
                                            name_instance5 = name_value5
                                            virtual_machine_extension_instance_view_instance.name = name_instance5
                                        
                                        type_value2 = extensions_value.get('type', None)
                                        if type_value2 is not None:
                                            type_instance2 = type_value2
                                            virtual_machine_extension_instance_view_instance.extension_type = type_instance2
                                        
                                        type_handler_version_value2 = extensions_value.get('typeHandlerVersion', None)
                                        if type_handler_version_value2 is not None:
                                            type_handler_version_instance2 = type_handler_version_value2
                                            virtual_machine_extension_instance_view_instance.type_handler_version = type_handler_version_instance2
                                        
                                        substatuses_array = extensions_value.get('substatuses', None)
                                        if substatuses_array is not None:
                                            for substatuses_value in substatuses_array:
                                                instance_view_status_instance3 = InstanceViewStatus()
                                                virtual_machine_extension_instance_view_instance.sub_statuses.append(instance_view_status_instance3)
                                                
                                                code_value4 = substatuses_value.get('code', None)
                                                if code_value4 is not None:
                                                    code_instance4 = code_value4
                                                    instance_view_status_instance3.code = code_instance4
                                                
                                                level_value4 = substatuses_value.get('level', None)
                                                if level_value4 is not None:
                                                    level_instance4 = level_value4
                                                    instance_view_status_instance3.level = level_instance4
                                                
                                                display_status_value4 = substatuses_value.get('displayStatus', None)
                                                if display_status_value4 is not None:
                                                    display_status_instance4 = display_status_value4
                                                    instance_view_status_instance3.display_status = display_status_instance4
                                                
                                                message_value4 = substatuses_value.get('message', None)
                                                if message_value4 is not None:
                                                    message_instance4 = message_value4
                                                    instance_view_status_instance3.message = message_instance4
                                                
                                                time_value4 = substatuses_value.get('time', None)
                                                if time_value4 is not None:
                                                    time_instance4 = time_value4
                                                    instance_view_status_instance3.time = time_instance4
                                                
                                        statuses_array3 = extensions_value.get('statuses', None)
                                        if statuses_array3 is not None:
                                            for statuses_value3 in statuses_array3:
                                                instance_view_status_instance4 = InstanceViewStatus()
                                                virtual_machine_extension_instance_view_instance.statuses.append(instance_view_status_instance4)
                                                
                                                code_value5 = statuses_value3.get('code', None)
                                                if code_value5 is not None:
                                                    code_instance5 = code_value5
                                                    instance_view_status_instance4.code = code_instance5
                                                
                                                level_value5 = statuses_value3.get('level', None)
                                                if level_value5 is not None:
                                                    level_instance5 = level_value5
                                                    instance_view_status_instance4.level = level_instance5
                                                
                                                display_status_value5 = statuses_value3.get('displayStatus', None)
                                                if display_status_value5 is not None:
                                                    display_status_instance5 = display_status_value5
                                                    instance_view_status_instance4.display_status = display_status_instance5
                                                
                                                message_value5 = statuses_value3.get('message', None)
                                                if message_value5 is not None:
                                                    message_instance5 = message_value5
                                                    instance_view_status_instance4.message = message_instance5
                                                
                                                time_value5 = statuses_value3.get('time', None)
                                                if time_value5 is not None:
                                                    time_instance5 = time_value5
                                                    instance_view_status_instance4.time = time_instance5
                                                
                                statuses_array4 = instance_view_value.get('statuses', None)
                                if statuses_array4 is not None:
                                    for statuses_value4 in statuses_array4:
                                        instance_view_status_instance5 = InstanceViewStatus()
                                        instance_view_instance.statuses.append(instance_view_status_instance5)
                                        
                                        code_value6 = statuses_value4.get('code', None)
                                        if code_value6 is not None:
                                            code_instance6 = code_value6
                                            instance_view_status_instance5.code = code_instance6
                                        
                                        level_value6 = statuses_value4.get('level', None)
                                        if level_value6 is not None:
                                            level_instance6 = level_value6
                                            instance_view_status_instance5.level = level_instance6
                                        
                                        display_status_value6 = statuses_value4.get('displayStatus', None)
                                        if display_status_value6 is not None:
                                            display_status_instance6 = display_status_value6
                                            instance_view_status_instance5.display_status = display_status_instance6
                                        
                                        message_value6 = statuses_value4.get('message', None)
                                        if message_value6 is not None:
                                            message_instance6 = message_value6
                                            instance_view_status_instance5.message = message_instance6
                                        
                                        time_value6 = statuses_value4.get('time', None)
                                        if time_value6 is not None:
                                            time_instance6 = time_value6
                                            instance_view_status_instance5.time = time_instance6
                                        
                        resources_array = value_value.get('resources', None)
                        if resources_array is not None:
                            virtual_machine_json_instance.extensions = []
                            for resources_value in resources_array:
                                virtual_machine_extension_json_instance = VirtualMachineExtension(tags={})
                                virtual_machine_json_instance.extensions.append(virtual_machine_extension_json_instance)
                                
                                properties_value3 = resources_value.get('properties', None)
                                if properties_value3 is not None:
                                    publisher_value3 = properties_value3.get('publisher', None)
                                    if publisher_value3 is not None:
                                        publisher_instance3 = publisher_value3
                                        virtual_machine_extension_json_instance.publisher = publisher_instance3
                                    
                                    type_value3 = properties_value3.get('type', None)
                                    if type_value3 is not None:
                                        type_instance3 = type_value3
                                        virtual_machine_extension_json_instance.extension_type = type_instance3
                                    
                                    type_handler_version_value3 = properties_value3.get('typeHandlerVersion', None)
                                    if type_handler_version_value3 is not None:
                                        type_handler_version_instance3 = type_handler_version_value3
                                        virtual_machine_extension_json_instance.type_handler_version = type_handler_version_instance3
                                    
                                    auto_upgrade_minor_version_value = properties_value3.get('autoUpgradeMinorVersion', None)
                                    if auto_upgrade_minor_version_value is not None:
                                        auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                                        virtual_machine_extension_json_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                                    
                                    settings_value = properties_value3.get('settings', None)
                                    if settings_value is not None:
                                        settings_instance = json.dumps(settings_value)
                                        virtual_machine_extension_json_instance.settings = settings_instance
                                    
                                    protected_settings_value = properties_value3.get('protectedSettings', None)
                                    if protected_settings_value is not None:
                                        protected_settings_instance = json.dumps(protected_settings_value)
                                        virtual_machine_extension_json_instance.protected_settings = protected_settings_instance
                                    
                                    provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                    if provisioning_state_value2 is not None:
                                        provisioning_state_instance2 = provisioning_state_value2
                                        virtual_machine_extension_json_instance.provisioning_state = provisioning_state_instance2
                                    
                                    instance_view_value2 = properties_value3.get('instanceView', None)
                                    if instance_view_value2 is not None:
                                        instance_view_instance2 = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                        virtual_machine_extension_json_instance.instance_view = instance_view_instance2
                                        
                                        name_value6 = instance_view_value2.get('name', None)
                                        if name_value6 is not None:
                                            name_instance6 = name_value6
                                            instance_view_instance2.name = name_instance6
                                        
                                        type_value4 = instance_view_value2.get('type', None)
                                        if type_value4 is not None:
                                            type_instance4 = type_value4
                                            instance_view_instance2.extension_type = type_instance4
                                        
                                        type_handler_version_value4 = instance_view_value2.get('typeHandlerVersion', None)
                                        if type_handler_version_value4 is not None:
                                            type_handler_version_instance4 = type_handler_version_value4
                                            instance_view_instance2.type_handler_version = type_handler_version_instance4
                                        
                                        substatuses_array2 = instance_view_value2.get('substatuses', None)
                                        if substatuses_array2 is not None:
                                            for substatuses_value2 in substatuses_array2:
                                                instance_view_status_instance6 = InstanceViewStatus()
                                                instance_view_instance2.sub_statuses.append(instance_view_status_instance6)
                                                
                                                code_value7 = substatuses_value2.get('code', None)
                                                if code_value7 is not None:
                                                    code_instance7 = code_value7
                                                    instance_view_status_instance6.code = code_instance7
                                                
                                                level_value7 = substatuses_value2.get('level', None)
                                                if level_value7 is not None:
                                                    level_instance7 = level_value7
                                                    instance_view_status_instance6.level = level_instance7
                                                
                                                display_status_value7 = substatuses_value2.get('displayStatus', None)
                                                if display_status_value7 is not None:
                                                    display_status_instance7 = display_status_value7
                                                    instance_view_status_instance6.display_status = display_status_instance7
                                                
                                                message_value7 = substatuses_value2.get('message', None)
                                                if message_value7 is not None:
                                                    message_instance7 = message_value7
                                                    instance_view_status_instance6.message = message_instance7
                                                
                                                time_value7 = substatuses_value2.get('time', None)
                                                if time_value7 is not None:
                                                    time_instance7 = time_value7
                                                    instance_view_status_instance6.time = time_instance7
                                                
                                        statuses_array5 = instance_view_value2.get('statuses', None)
                                        if statuses_array5 is not None:
                                            for statuses_value5 in statuses_array5:
                                                instance_view_status_instance7 = InstanceViewStatus()
                                                instance_view_instance2.statuses.append(instance_view_status_instance7)
                                                
                                                code_value8 = statuses_value5.get('code', None)
                                                if code_value8 is not None:
                                                    code_instance8 = code_value8
                                                    instance_view_status_instance7.code = code_instance8
                                                
                                                level_value8 = statuses_value5.get('level', None)
                                                if level_value8 is not None:
                                                    level_instance8 = level_value8
                                                    instance_view_status_instance7.level = level_instance8
                                                
                                                display_status_value8 = statuses_value5.get('displayStatus', None)
                                                if display_status_value8 is not None:
                                                    display_status_instance8 = display_status_value8
                                                    instance_view_status_instance7.display_status = display_status_instance8
                                                
                                                message_value8 = statuses_value5.get('message', None)
                                                if message_value8 is not None:
                                                    message_instance8 = message_value8
                                                    instance_view_status_instance7.message = message_instance8
                                                
                                                time_value8 = statuses_value5.get('time', None)
                                                if time_value8 is not None:
                                                    time_instance8 = time_value8
                                                    instance_view_status_instance7.time = time_instance8
                                                
                                id_value5 = resources_value.get('id', None)
                                if id_value5 is not None:
                                    id_instance5 = id_value5
                                    virtual_machine_extension_json_instance.id = id_instance5
                                
                                name_value7 = resources_value.get('name', None)
                                if name_value7 is not None:
                                    name_instance7 = name_value7
                                    virtual_machine_extension_json_instance.name = name_instance7
                                
                                type_value5 = resources_value.get('type', None)
                                if type_value5 is not None:
                                    type_instance5 = type_value5
                                    virtual_machine_extension_json_instance.type = type_instance5
                                
                                location_value = resources_value.get('location', None)
                                if location_value is not None:
                                    location_instance = location_value
                                    virtual_machine_extension_json_instance.location = location_instance
                                
                                tags_sequence_element = resources_value.get('tags', None)
                                if tags_sequence_element is not None:
                                    for property in tags_sequence_element:
                                        tags_key = property
                                        tags_value = tags_sequence_element[property]
                                        virtual_machine_extension_json_instance.tags[tags_key] = tags_value
                                    
                        id_value6 = value_value.get('id', None)
                        if id_value6 is not None:
                            id_instance6 = id_value6
                            virtual_machine_json_instance.id = id_instance6
                        
                        name_value8 = value_value.get('name', None)
                        if name_value8 is not None:
                            name_instance8 = name_value8
                            virtual_machine_json_instance.name = name_instance8
                        
                        type_value6 = value_value.get('type', None)
                        if type_value6 is not None:
                            type_instance6 = type_value6
                            virtual_machine_json_instance.type = type_instance6
                        
                        location_value2 = value_value.get('location', None)
                        if location_value2 is not None:
                            location_instance2 = location_value2
                            virtual_machine_json_instance.location = location_instance2
                        
                        tags_sequence_element2 = value_value.get('tags', None)
                        if tags_sequence_element2 is not None:
                            for property2 in tags_sequence_element2:
                                tags_key2 = property2
                                tags_value2 = tags_sequence_element2[property2]
                                virtual_machine_json_instance.tags[tags_key2] = tags_value2
                            
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_all(self, parameters):
        """
         Gets the list of Virtual Machines in the subscription. Use nextLink
         property in the response to get the next page of Virtual Machines. Do
         this till nextLink is not null to fetch all the Virtual Machines.
         
         Args:
         
         parameters (ListParameters)
         
         Returns:
         
         VirtualMachineListResponse: The List Virtual Machine operation
         response.
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineListResponse(virtual_machines=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_machine_json_instance = VirtualMachine(extensions=[], tags={})
                        result.virtual_machines.append(virtual_machine_json_instance)
                        
                        plan_value = value_value.get('plan', None)
                        if plan_value is not None:
                            plan_instance = Plan()
                            virtual_machine_json_instance.plan = plan_instance
                            
                            name_value = plan_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                plan_instance.name = name_instance
                            
                            publisher_value = plan_value.get('publisher', None)
                            if publisher_value is not None:
                                publisher_instance = publisher_value
                                plan_instance.publisher = publisher_instance
                            
                            product_value = plan_value.get('product', None)
                            if product_value is not None:
                                product_instance = product_value
                                plan_instance.product = product_instance
                            
                            promotion_code_value = plan_value.get('promotionCode', None)
                            if promotion_code_value is not None:
                                promotion_code_instance = promotion_code_value
                                plan_instance.promotion_code = promotion_code_instance
                            
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            hardware_profile_value = properties_value.get('hardwareProfile', None)
                            if hardware_profile_value is not None:
                                hardware_profile_instance = HardwareProfile()
                                virtual_machine_json_instance.hardware_profile = hardware_profile_instance
                                
                                vm_size_value = hardware_profile_value.get('vmSize', None)
                                if vm_size_value is not None:
                                    vm_size_instance = vm_size_value
                                    hardware_profile_instance.virtual_machine_size = vm_size_instance
                                
                            storage_profile_value = properties_value.get('storageProfile', None)
                            if storage_profile_value is not None:
                                storage_profile_instance = StorageProfile(data_disks=[])
                                virtual_machine_json_instance.storage_profile = storage_profile_instance
                                
                                image_reference_value = storage_profile_value.get('imageReference', None)
                                if image_reference_value is not None:
                                    image_reference_instance = ImageReference()
                                    storage_profile_instance.image_reference = image_reference_instance
                                    
                                    publisher_value2 = image_reference_value.get('publisher', None)
                                    if publisher_value2 is not None:
                                        publisher_instance2 = publisher_value2
                                        image_reference_instance.publisher = publisher_instance2
                                    
                                    offer_value = image_reference_value.get('offer', None)
                                    if offer_value is not None:
                                        offer_instance = offer_value
                                        image_reference_instance.offer = offer_instance
                                    
                                    sku_value = image_reference_value.get('sku', None)
                                    if sku_value is not None:
                                        sku_instance = sku_value
                                        image_reference_instance.sku = sku_instance
                                    
                                    version_value = image_reference_value.get('version', None)
                                    if version_value is not None:
                                        version_instance = version_value
                                        image_reference_instance.version = version_instance
                                    
                                source_image_value = storage_profile_value.get('sourceImage', None)
                                if source_image_value is not None:
                                    source_image_instance = SourceImageReference()
                                    storage_profile_instance.source_image = source_image_instance
                                    
                                    id_value = source_image_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        source_image_instance.reference_uri = id_instance
                                    
                                os_disk_value = storage_profile_value.get('osDisk', None)
                                if os_disk_value is not None:
                                    os_disk_instance = OSDisk()
                                    storage_profile_instance.os_disk = os_disk_instance
                                    
                                    os_type_value = os_disk_value.get('osType', None)
                                    if os_type_value is not None:
                                        os_type_instance = os_type_value
                                        os_disk_instance.operating_system_type = os_type_instance
                                    
                                    name_value2 = os_disk_value.get('name', None)
                                    if name_value2 is not None:
                                        name_instance2 = name_value2
                                        os_disk_instance.name = name_instance2
                                    
                                    vhd_value = os_disk_value.get('vhd', None)
                                    if vhd_value is not None:
                                        vhd_instance = VirtualHardDisk()
                                        os_disk_instance.virtual_hard_disk = vhd_instance
                                        
                                        uri_value = vhd_value.get('uri', None)
                                        if uri_value is not None:
                                            uri_instance = uri_value
                                            vhd_instance.uri = uri_instance
                                        
                                    image_value = os_disk_value.get('image', None)
                                    if image_value is not None:
                                        image_instance = VirtualHardDisk()
                                        os_disk_instance.source_image = image_instance
                                        
                                        uri_value2 = image_value.get('uri', None)
                                        if uri_value2 is not None:
                                            uri_instance2 = uri_value2
                                            image_instance.uri = uri_instance2
                                        
                                    caching_value = os_disk_value.get('caching', None)
                                    if caching_value is not None:
                                        caching_instance = caching_value
                                        os_disk_instance.caching = caching_instance
                                    
                                    create_option_value = os_disk_value.get('createOption', None)
                                    if create_option_value is not None:
                                        create_option_instance = create_option_value
                                        os_disk_instance.create_option = create_option_instance
                                    
                                data_disks_array = storage_profile_value.get('dataDisks', None)
                                if data_disks_array is not None:
                                    for data_disks_value in data_disks_array:
                                        data_disk_instance = DataDisk()
                                        storage_profile_instance.data_disks.append(data_disk_instance)
                                        
                                        lun_value = data_disks_value.get('lun', None)
                                        if lun_value is not None:
                                            lun_instance = lun_value
                                            data_disk_instance.lun = lun_instance
                                        
                                        disk_size_gb_value = data_disks_value.get('diskSizeGB', None)
                                        if disk_size_gb_value is not None:
                                            disk_size_gb_instance = disk_size_gb_value
                                            data_disk_instance.disk_size_gb = disk_size_gb_instance
                                        
                                        name_value3 = data_disks_value.get('name', None)
                                        if name_value3 is not None:
                                            name_instance3 = name_value3
                                            data_disk_instance.name = name_instance3
                                        
                                        vhd_value2 = data_disks_value.get('vhd', None)
                                        if vhd_value2 is not None:
                                            vhd_instance2 = VirtualHardDisk()
                                            data_disk_instance.virtual_hard_disk = vhd_instance2
                                            
                                            uri_value3 = vhd_value2.get('uri', None)
                                            if uri_value3 is not None:
                                                uri_instance3 = uri_value3
                                                vhd_instance2.uri = uri_instance3
                                            
                                        image_value2 = data_disks_value.get('image', None)
                                        if image_value2 is not None:
                                            image_instance2 = VirtualHardDisk()
                                            data_disk_instance.source_image = image_instance2
                                            
                                            uri_value4 = image_value2.get('uri', None)
                                            if uri_value4 is not None:
                                                uri_instance4 = uri_value4
                                                image_instance2.uri = uri_instance4
                                            
                                        caching_value2 = data_disks_value.get('caching', None)
                                        if caching_value2 is not None:
                                            caching_instance2 = caching_value2
                                            data_disk_instance.caching = caching_instance2
                                        
                                        create_option_value2 = data_disks_value.get('createOption', None)
                                        if create_option_value2 is not None:
                                            create_option_instance2 = create_option_value2
                                            data_disk_instance.create_option = create_option_instance2
                                        
                            os_profile_value = properties_value.get('osProfile', None)
                            if os_profile_value is not None:
                                os_profile_instance = OSProfile(secrets=[])
                                virtual_machine_json_instance.os_profile = os_profile_instance
                                
                                computer_name_value = os_profile_value.get('computerName', None)
                                if computer_name_value is not None:
                                    computer_name_instance = computer_name_value
                                    os_profile_instance.computer_name = computer_name_instance
                                
                                admin_username_value = os_profile_value.get('adminUsername', None)
                                if admin_username_value is not None:
                                    admin_username_instance = admin_username_value
                                    os_profile_instance.admin_username = admin_username_instance
                                
                                admin_password_value = os_profile_value.get('adminPassword', None)
                                if admin_password_value is not None:
                                    admin_password_instance = admin_password_value
                                    os_profile_instance.admin_password = admin_password_instance
                                
                                custom_data_value = os_profile_value.get('customData', None)
                                if custom_data_value is not None:
                                    custom_data_instance = custom_data_value
                                    os_profile_instance.custom_data = custom_data_instance
                                
                                windows_configuration_value = os_profile_value.get('windowsConfiguration', None)
                                if windows_configuration_value is not None:
                                    windows_configuration_instance = WindowsConfiguration(additional_unattend_contents=[])
                                    os_profile_instance.windows_configuration = windows_configuration_instance
                                    
                                    provision_vm_agent_value = windows_configuration_value.get('provisionVMAgent', None)
                                    if provision_vm_agent_value is not None:
                                        provision_vm_agent_instance = provision_vm_agent_value
                                        windows_configuration_instance.provision_vm_agent = provision_vm_agent_instance
                                    
                                    enable_automatic_updates_value = windows_configuration_value.get('enableAutomaticUpdates', None)
                                    if enable_automatic_updates_value is not None:
                                        enable_automatic_updates_instance = enable_automatic_updates_value
                                        windows_configuration_instance.enable_automatic_updates = enable_automatic_updates_instance
                                    
                                    time_zone_value = windows_configuration_value.get('timeZone', None)
                                    if time_zone_value is not None:
                                        time_zone_instance = time_zone_value
                                        windows_configuration_instance.time_zone = time_zone_instance
                                    
                                    additional_unattend_content_array = windows_configuration_value.get('additionalUnattendContent', None)
                                    if additional_unattend_content_array is not None:
                                        for additional_unattend_content_value in additional_unattend_content_array:
                                            additional_unattend_content_instance = AdditionalUnattendContent()
                                            windows_configuration_instance.additional_unattend_contents.append(additional_unattend_content_instance)
                                            
                                            pass_name_value = additional_unattend_content_value.get('passName', None)
                                            if pass_name_value is not None:
                                                pass_name_instance = pass_name_value
                                                additional_unattend_content_instance.pass_name = pass_name_instance
                                            
                                            component_name_value = additional_unattend_content_value.get('componentName', None)
                                            if component_name_value is not None:
                                                component_name_instance = component_name_value
                                                additional_unattend_content_instance.component_name = component_name_instance
                                            
                                            setting_name_value = additional_unattend_content_value.get('settingName', None)
                                            if setting_name_value is not None:
                                                setting_name_instance = setting_name_value
                                                additional_unattend_content_instance.setting_name = setting_name_instance
                                            
                                            content_value = additional_unattend_content_value.get('content', None)
                                            if content_value is not None:
                                                content_instance = content_value
                                                additional_unattend_content_instance.content = content_instance
                                            
                                    win_rm_value = windows_configuration_value.get('winRM', None)
                                    if win_rm_value is not None:
                                        win_rm_instance = WinRMConfiguration(listeners=[])
                                        windows_configuration_instance.win_rm_configuration = win_rm_instance
                                        
                                        listeners_array = win_rm_value.get('listeners', None)
                                        if listeners_array is not None:
                                            for listeners_value in listeners_array:
                                                win_rm_listener_instance = WinRMListener()
                                                win_rm_instance.listeners.append(win_rm_listener_instance)
                                                
                                                protocol_value = listeners_value.get('protocol', None)
                                                if protocol_value is not None:
                                                    protocol_instance = protocol_value
                                                    win_rm_listener_instance.protocol = protocol_instance
                                                
                                                certificate_url_value = listeners_value.get('certificateUrl', None)
                                                if certificate_url_value is not None:
                                                    certificate_url_instance = certificate_url_value
                                                    win_rm_listener_instance.certificate_url = certificate_url_instance
                                                
                                linux_configuration_value = os_profile_value.get('linuxConfiguration', None)
                                if linux_configuration_value is not None:
                                    linux_configuration_instance = LinuxConfiguration()
                                    os_profile_instance.linux_configuration = linux_configuration_instance
                                    
                                    disable_password_authentication_value = linux_configuration_value.get('disablePasswordAuthentication', None)
                                    if disable_password_authentication_value is not None:
                                        disable_password_authentication_instance = disable_password_authentication_value
                                        linux_configuration_instance.disable_password_authentication = disable_password_authentication_instance
                                    
                                    ssh_value = linux_configuration_value.get('ssh', None)
                                    if ssh_value is not None:
                                        ssh_instance = SshConfiguration(public_keys=[])
                                        linux_configuration_instance.ssh_configuration = ssh_instance
                                        
                                        public_keys_array = ssh_value.get('publicKeys', None)
                                        if public_keys_array is not None:
                                            for public_keys_value in public_keys_array:
                                                ssh_public_key_instance = SshPublicKey()
                                                ssh_instance.public_keys.append(ssh_public_key_instance)
                                                
                                                path_value = public_keys_value.get('path', None)
                                                if path_value is not None:
                                                    path_instance = path_value
                                                    ssh_public_key_instance.path = path_instance
                                                
                                                key_data_value = public_keys_value.get('keyData', None)
                                                if key_data_value is not None:
                                                    key_data_instance = key_data_value
                                                    ssh_public_key_instance.key_data = key_data_instance
                                                
                                secrets_array = os_profile_value.get('secrets', None)
                                if secrets_array is not None:
                                    for secrets_value in secrets_array:
                                        vault_secret_group_instance = VaultSecretGroup(vault_certificates=[])
                                        os_profile_instance.secrets.append(vault_secret_group_instance)
                                        
                                        source_vault_value = secrets_value.get('sourceVault', None)
                                        if source_vault_value is not None:
                                            source_vault_instance = SourceVaultReference()
                                            vault_secret_group_instance.source_vault = source_vault_instance
                                            
                                            id_value2 = source_vault_value.get('id', None)
                                            if id_value2 is not None:
                                                id_instance2 = id_value2
                                                source_vault_instance.reference_uri = id_instance2
                                            
                                        vault_certificates_array = secrets_value.get('vaultCertificates', None)
                                        if vault_certificates_array is not None:
                                            for vault_certificates_value in vault_certificates_array:
                                                vault_certificate_instance = VaultCertificate()
                                                vault_secret_group_instance.vault_certificates.append(vault_certificate_instance)
                                                
                                                certificate_url_value2 = vault_certificates_value.get('certificateUrl', None)
                                                if certificate_url_value2 is not None:
                                                    certificate_url_instance2 = certificate_url_value2
                                                    vault_certificate_instance.certificate_url = certificate_url_instance2
                                                
                                                certificate_store_value = vault_certificates_value.get('certificateStore', None)
                                                if certificate_store_value is not None:
                                                    certificate_store_instance = certificate_store_value
                                                    vault_certificate_instance.certificate_store = certificate_store_instance
                                                
                            network_profile_value = properties_value.get('networkProfile', None)
                            if network_profile_value is not None:
                                network_profile_instance = NetworkProfile(network_interfaces=[])
                                virtual_machine_json_instance.network_profile = network_profile_instance
                                
                                network_interfaces_array = network_profile_value.get('networkInterfaces', None)
                                if network_interfaces_array is not None:
                                    for network_interfaces_value in network_interfaces_array:
                                        network_interface_reference_json_instance = NetworkInterfaceReference()
                                        network_profile_instance.network_interfaces.append(network_interface_reference_json_instance)
                                        
                                        properties_value2 = network_interfaces_value.get('properties', None)
                                        if properties_value2 is not None:
                                            primary_value = properties_value2.get('primary', None)
                                            if primary_value is not None:
                                                primary_instance = primary_value
                                                network_interface_reference_json_instance.primary = primary_instance
                                            
                                        id_value3 = network_interfaces_value.get('id', None)
                                        if id_value3 is not None:
                                            id_instance3 = id_value3
                                            network_interface_reference_json_instance.reference_uri = id_instance3
                                        
                            availability_set_value = properties_value.get('availabilitySet', None)
                            if availability_set_value is not None:
                                availability_set_instance = AvailabilitySetReference()
                                virtual_machine_json_instance.availability_set_reference = availability_set_instance
                                
                                id_value4 = availability_set_value.get('id', None)
                                if id_value4 is not None:
                                    id_instance4 = id_value4
                                    availability_set_instance.reference_uri = id_instance4
                                
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                virtual_machine_json_instance.provisioning_state = provisioning_state_instance
                            
                            instance_view_value = properties_value.get('instanceView', None)
                            if instance_view_value is not None:
                                instance_view_instance = VirtualMachineInstanceView(disks=[], extensions=[], statuses=[])
                                virtual_machine_json_instance.instance_view = instance_view_instance
                                
                                platform_update_domain_value = instance_view_value.get('platformUpdateDomain', None)
                                if platform_update_domain_value is not None:
                                    platform_update_domain_instance = platform_update_domain_value
                                    instance_view_instance.platform_update_domain = platform_update_domain_instance
                                
                                platform_fault_domain_value = instance_view_value.get('platformFaultDomain', None)
                                if platform_fault_domain_value is not None:
                                    platform_fault_domain_instance = platform_fault_domain_value
                                    instance_view_instance.platform_fault_domain = platform_fault_domain_instance
                                
                                rdp_thumb_print_value = instance_view_value.get('rdpThumbPrint', None)
                                if rdp_thumb_print_value is not None:
                                    rdp_thumb_print_instance = rdp_thumb_print_value
                                    instance_view_instance.remote_desktop_thumbprint = rdp_thumb_print_instance
                                
                                vm_agent_value = instance_view_value.get('vmAgent', None)
                                if vm_agent_value is not None:
                                    vm_agent_instance = VirtualMachineAgentInstanceView(extension_handlers=[], statuses=[])
                                    instance_view_instance.vm_agent = vm_agent_instance
                                    
                                    vm_agent_version_value = vm_agent_value.get('vmAgentVersion', None)
                                    if vm_agent_version_value is not None:
                                        vm_agent_version_instance = vm_agent_version_value
                                        vm_agent_instance.vm_agent_version = vm_agent_version_instance
                                    
                                    extension_handlers_array = vm_agent_value.get('extensionHandlers', None)
                                    if extension_handlers_array is not None:
                                        for extension_handlers_value in extension_handlers_array:
                                            virtual_machine_extension_handler_instance_view_instance = VirtualMachineExtensionHandlerInstanceView()
                                            vm_agent_instance.extension_handlers.append(virtual_machine_extension_handler_instance_view_instance)
                                            
                                            type_value = extension_handlers_value.get('type', None)
                                            if type_value is not None:
                                                type_instance = type_value
                                                virtual_machine_extension_handler_instance_view_instance.type = type_instance
                                            
                                            type_handler_version_value = extension_handlers_value.get('typeHandlerVersion', None)
                                            if type_handler_version_value is not None:
                                                type_handler_version_instance = type_handler_version_value
                                                virtual_machine_extension_handler_instance_view_instance.type_handler_version = type_handler_version_instance
                                            
                                            status_value = extension_handlers_value.get('status', None)
                                            if status_value is not None:
                                                status_instance = InstanceViewStatus()
                                                virtual_machine_extension_handler_instance_view_instance.status = status_instance
                                                
                                                code_value = status_value.get('code', None)
                                                if code_value is not None:
                                                    code_instance = code_value
                                                    status_instance.code = code_instance
                                                
                                                level_value = status_value.get('level', None)
                                                if level_value is not None:
                                                    level_instance = level_value
                                                    status_instance.level = level_instance
                                                
                                                display_status_value = status_value.get('displayStatus', None)
                                                if display_status_value is not None:
                                                    display_status_instance = display_status_value
                                                    status_instance.display_status = display_status_instance
                                                
                                                message_value = status_value.get('message', None)
                                                if message_value is not None:
                                                    message_instance = message_value
                                                    status_instance.message = message_instance
                                                
                                                time_value = status_value.get('time', None)
                                                if time_value is not None:
                                                    time_instance = time_value
                                                    status_instance.time = time_instance
                                                
                                    statuses_array = vm_agent_value.get('statuses', None)
                                    if statuses_array is not None:
                                        for statuses_value in statuses_array:
                                            instance_view_status_instance = InstanceViewStatus()
                                            vm_agent_instance.statuses.append(instance_view_status_instance)
                                            
                                            code_value2 = statuses_value.get('code', None)
                                            if code_value2 is not None:
                                                code_instance2 = code_value2
                                                instance_view_status_instance.code = code_instance2
                                            
                                            level_value2 = statuses_value.get('level', None)
                                            if level_value2 is not None:
                                                level_instance2 = level_value2
                                                instance_view_status_instance.level = level_instance2
                                            
                                            display_status_value2 = statuses_value.get('displayStatus', None)
                                            if display_status_value2 is not None:
                                                display_status_instance2 = display_status_value2
                                                instance_view_status_instance.display_status = display_status_instance2
                                            
                                            message_value2 = statuses_value.get('message', None)
                                            if message_value2 is not None:
                                                message_instance2 = message_value2
                                                instance_view_status_instance.message = message_instance2
                                            
                                            time_value2 = statuses_value.get('time', None)
                                            if time_value2 is not None:
                                                time_instance2 = time_value2
                                                instance_view_status_instance.time = time_instance2
                                            
                                disks_array = instance_view_value.get('disks', None)
                                if disks_array is not None:
                                    for disks_value in disks_array:
                                        disk_instance_view_instance = DiskInstanceView(statuses=[])
                                        instance_view_instance.disks.append(disk_instance_view_instance)
                                        
                                        name_value4 = disks_value.get('name', None)
                                        if name_value4 is not None:
                                            name_instance4 = name_value4
                                            disk_instance_view_instance.name = name_instance4
                                        
                                        statuses_array2 = disks_value.get('statuses', None)
                                        if statuses_array2 is not None:
                                            for statuses_value2 in statuses_array2:
                                                instance_view_status_instance2 = InstanceViewStatus()
                                                disk_instance_view_instance.statuses.append(instance_view_status_instance2)
                                                
                                                code_value3 = statuses_value2.get('code', None)
                                                if code_value3 is not None:
                                                    code_instance3 = code_value3
                                                    instance_view_status_instance2.code = code_instance3
                                                
                                                level_value3 = statuses_value2.get('level', None)
                                                if level_value3 is not None:
                                                    level_instance3 = level_value3
                                                    instance_view_status_instance2.level = level_instance3
                                                
                                                display_status_value3 = statuses_value2.get('displayStatus', None)
                                                if display_status_value3 is not None:
                                                    display_status_instance3 = display_status_value3
                                                    instance_view_status_instance2.display_status = display_status_instance3
                                                
                                                message_value3 = statuses_value2.get('message', None)
                                                if message_value3 is not None:
                                                    message_instance3 = message_value3
                                                    instance_view_status_instance2.message = message_instance3
                                                
                                                time_value3 = statuses_value2.get('time', None)
                                                if time_value3 is not None:
                                                    time_instance3 = time_value3
                                                    instance_view_status_instance2.time = time_instance3
                                                
                                extensions_array = instance_view_value.get('extensions', None)
                                if extensions_array is not None:
                                    for extensions_value in extensions_array:
                                        virtual_machine_extension_instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                        instance_view_instance.extensions.append(virtual_machine_extension_instance_view_instance)
                                        
                                        name_value5 = extensions_value.get('name', None)
                                        if name_value5 is not None:
                                            name_instance5 = name_value5
                                            virtual_machine_extension_instance_view_instance.name = name_instance5
                                        
                                        type_value2 = extensions_value.get('type', None)
                                        if type_value2 is not None:
                                            type_instance2 = type_value2
                                            virtual_machine_extension_instance_view_instance.extension_type = type_instance2
                                        
                                        type_handler_version_value2 = extensions_value.get('typeHandlerVersion', None)
                                        if type_handler_version_value2 is not None:
                                            type_handler_version_instance2 = type_handler_version_value2
                                            virtual_machine_extension_instance_view_instance.type_handler_version = type_handler_version_instance2
                                        
                                        substatuses_array = extensions_value.get('substatuses', None)
                                        if substatuses_array is not None:
                                            for substatuses_value in substatuses_array:
                                                instance_view_status_instance3 = InstanceViewStatus()
                                                virtual_machine_extension_instance_view_instance.sub_statuses.append(instance_view_status_instance3)
                                                
                                                code_value4 = substatuses_value.get('code', None)
                                                if code_value4 is not None:
                                                    code_instance4 = code_value4
                                                    instance_view_status_instance3.code = code_instance4
                                                
                                                level_value4 = substatuses_value.get('level', None)
                                                if level_value4 is not None:
                                                    level_instance4 = level_value4
                                                    instance_view_status_instance3.level = level_instance4
                                                
                                                display_status_value4 = substatuses_value.get('displayStatus', None)
                                                if display_status_value4 is not None:
                                                    display_status_instance4 = display_status_value4
                                                    instance_view_status_instance3.display_status = display_status_instance4
                                                
                                                message_value4 = substatuses_value.get('message', None)
                                                if message_value4 is not None:
                                                    message_instance4 = message_value4
                                                    instance_view_status_instance3.message = message_instance4
                                                
                                                time_value4 = substatuses_value.get('time', None)
                                                if time_value4 is not None:
                                                    time_instance4 = time_value4
                                                    instance_view_status_instance3.time = time_instance4
                                                
                                        statuses_array3 = extensions_value.get('statuses', None)
                                        if statuses_array3 is not None:
                                            for statuses_value3 in statuses_array3:
                                                instance_view_status_instance4 = InstanceViewStatus()
                                                virtual_machine_extension_instance_view_instance.statuses.append(instance_view_status_instance4)
                                                
                                                code_value5 = statuses_value3.get('code', None)
                                                if code_value5 is not None:
                                                    code_instance5 = code_value5
                                                    instance_view_status_instance4.code = code_instance5
                                                
                                                level_value5 = statuses_value3.get('level', None)
                                                if level_value5 is not None:
                                                    level_instance5 = level_value5
                                                    instance_view_status_instance4.level = level_instance5
                                                
                                                display_status_value5 = statuses_value3.get('displayStatus', None)
                                                if display_status_value5 is not None:
                                                    display_status_instance5 = display_status_value5
                                                    instance_view_status_instance4.display_status = display_status_instance5
                                                
                                                message_value5 = statuses_value3.get('message', None)
                                                if message_value5 is not None:
                                                    message_instance5 = message_value5
                                                    instance_view_status_instance4.message = message_instance5
                                                
                                                time_value5 = statuses_value3.get('time', None)
                                                if time_value5 is not None:
                                                    time_instance5 = time_value5
                                                    instance_view_status_instance4.time = time_instance5
                                                
                                statuses_array4 = instance_view_value.get('statuses', None)
                                if statuses_array4 is not None:
                                    for statuses_value4 in statuses_array4:
                                        instance_view_status_instance5 = InstanceViewStatus()
                                        instance_view_instance.statuses.append(instance_view_status_instance5)
                                        
                                        code_value6 = statuses_value4.get('code', None)
                                        if code_value6 is not None:
                                            code_instance6 = code_value6
                                            instance_view_status_instance5.code = code_instance6
                                        
                                        level_value6 = statuses_value4.get('level', None)
                                        if level_value6 is not None:
                                            level_instance6 = level_value6
                                            instance_view_status_instance5.level = level_instance6
                                        
                                        display_status_value6 = statuses_value4.get('displayStatus', None)
                                        if display_status_value6 is not None:
                                            display_status_instance6 = display_status_value6
                                            instance_view_status_instance5.display_status = display_status_instance6
                                        
                                        message_value6 = statuses_value4.get('message', None)
                                        if message_value6 is not None:
                                            message_instance6 = message_value6
                                            instance_view_status_instance5.message = message_instance6
                                        
                                        time_value6 = statuses_value4.get('time', None)
                                        if time_value6 is not None:
                                            time_instance6 = time_value6
                                            instance_view_status_instance5.time = time_instance6
                                        
                        resources_array = value_value.get('resources', None)
                        if resources_array is not None:
                            virtual_machine_json_instance.extensions = []
                            for resources_value in resources_array:
                                virtual_machine_extension_json_instance = VirtualMachineExtension(tags={})
                                virtual_machine_json_instance.extensions.append(virtual_machine_extension_json_instance)
                                
                                properties_value3 = resources_value.get('properties', None)
                                if properties_value3 is not None:
                                    publisher_value3 = properties_value3.get('publisher', None)
                                    if publisher_value3 is not None:
                                        publisher_instance3 = publisher_value3
                                        virtual_machine_extension_json_instance.publisher = publisher_instance3
                                    
                                    type_value3 = properties_value3.get('type', None)
                                    if type_value3 is not None:
                                        type_instance3 = type_value3
                                        virtual_machine_extension_json_instance.extension_type = type_instance3
                                    
                                    type_handler_version_value3 = properties_value3.get('typeHandlerVersion', None)
                                    if type_handler_version_value3 is not None:
                                        type_handler_version_instance3 = type_handler_version_value3
                                        virtual_machine_extension_json_instance.type_handler_version = type_handler_version_instance3
                                    
                                    auto_upgrade_minor_version_value = properties_value3.get('autoUpgradeMinorVersion', None)
                                    if auto_upgrade_minor_version_value is not None:
                                        auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                                        virtual_machine_extension_json_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                                    
                                    settings_value = properties_value3.get('settings', None)
                                    if settings_value is not None:
                                        settings_instance = json.dumps(settings_value)
                                        virtual_machine_extension_json_instance.settings = settings_instance
                                    
                                    protected_settings_value = properties_value3.get('protectedSettings', None)
                                    if protected_settings_value is not None:
                                        protected_settings_instance = json.dumps(protected_settings_value)
                                        virtual_machine_extension_json_instance.protected_settings = protected_settings_instance
                                    
                                    provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                    if provisioning_state_value2 is not None:
                                        provisioning_state_instance2 = provisioning_state_value2
                                        virtual_machine_extension_json_instance.provisioning_state = provisioning_state_instance2
                                    
                                    instance_view_value2 = properties_value3.get('instanceView', None)
                                    if instance_view_value2 is not None:
                                        instance_view_instance2 = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                        virtual_machine_extension_json_instance.instance_view = instance_view_instance2
                                        
                                        name_value6 = instance_view_value2.get('name', None)
                                        if name_value6 is not None:
                                            name_instance6 = name_value6
                                            instance_view_instance2.name = name_instance6
                                        
                                        type_value4 = instance_view_value2.get('type', None)
                                        if type_value4 is not None:
                                            type_instance4 = type_value4
                                            instance_view_instance2.extension_type = type_instance4
                                        
                                        type_handler_version_value4 = instance_view_value2.get('typeHandlerVersion', None)
                                        if type_handler_version_value4 is not None:
                                            type_handler_version_instance4 = type_handler_version_value4
                                            instance_view_instance2.type_handler_version = type_handler_version_instance4
                                        
                                        substatuses_array2 = instance_view_value2.get('substatuses', None)
                                        if substatuses_array2 is not None:
                                            for substatuses_value2 in substatuses_array2:
                                                instance_view_status_instance6 = InstanceViewStatus()
                                                instance_view_instance2.sub_statuses.append(instance_view_status_instance6)
                                                
                                                code_value7 = substatuses_value2.get('code', None)
                                                if code_value7 is not None:
                                                    code_instance7 = code_value7
                                                    instance_view_status_instance6.code = code_instance7
                                                
                                                level_value7 = substatuses_value2.get('level', None)
                                                if level_value7 is not None:
                                                    level_instance7 = level_value7
                                                    instance_view_status_instance6.level = level_instance7
                                                
                                                display_status_value7 = substatuses_value2.get('displayStatus', None)
                                                if display_status_value7 is not None:
                                                    display_status_instance7 = display_status_value7
                                                    instance_view_status_instance6.display_status = display_status_instance7
                                                
                                                message_value7 = substatuses_value2.get('message', None)
                                                if message_value7 is not None:
                                                    message_instance7 = message_value7
                                                    instance_view_status_instance6.message = message_instance7
                                                
                                                time_value7 = substatuses_value2.get('time', None)
                                                if time_value7 is not None:
                                                    time_instance7 = time_value7
                                                    instance_view_status_instance6.time = time_instance7
                                                
                                        statuses_array5 = instance_view_value2.get('statuses', None)
                                        if statuses_array5 is not None:
                                            for statuses_value5 in statuses_array5:
                                                instance_view_status_instance7 = InstanceViewStatus()
                                                instance_view_instance2.statuses.append(instance_view_status_instance7)
                                                
                                                code_value8 = statuses_value5.get('code', None)
                                                if code_value8 is not None:
                                                    code_instance8 = code_value8
                                                    instance_view_status_instance7.code = code_instance8
                                                
                                                level_value8 = statuses_value5.get('level', None)
                                                if level_value8 is not None:
                                                    level_instance8 = level_value8
                                                    instance_view_status_instance7.level = level_instance8
                                                
                                                display_status_value8 = statuses_value5.get('displayStatus', None)
                                                if display_status_value8 is not None:
                                                    display_status_instance8 = display_status_value8
                                                    instance_view_status_instance7.display_status = display_status_instance8
                                                
                                                message_value8 = statuses_value5.get('message', None)
                                                if message_value8 is not None:
                                                    message_instance8 = message_value8
                                                    instance_view_status_instance7.message = message_instance8
                                                
                                                time_value8 = statuses_value5.get('time', None)
                                                if time_value8 is not None:
                                                    time_instance8 = time_value8
                                                    instance_view_status_instance7.time = time_instance8
                                                
                                id_value5 = resources_value.get('id', None)
                                if id_value5 is not None:
                                    id_instance5 = id_value5
                                    virtual_machine_extension_json_instance.id = id_instance5
                                
                                name_value7 = resources_value.get('name', None)
                                if name_value7 is not None:
                                    name_instance7 = name_value7
                                    virtual_machine_extension_json_instance.name = name_instance7
                                
                                type_value5 = resources_value.get('type', None)
                                if type_value5 is not None:
                                    type_instance5 = type_value5
                                    virtual_machine_extension_json_instance.type = type_instance5
                                
                                location_value = resources_value.get('location', None)
                                if location_value is not None:
                                    location_instance = location_value
                                    virtual_machine_extension_json_instance.location = location_instance
                                
                                tags_sequence_element = resources_value.get('tags', None)
                                if tags_sequence_element is not None:
                                    for property in tags_sequence_element:
                                        tags_key = property
                                        tags_value = tags_sequence_element[property]
                                        virtual_machine_extension_json_instance.tags[tags_key] = tags_value
                                    
                        id_value6 = value_value.get('id', None)
                        if id_value6 is not None:
                            id_instance6 = id_value6
                            virtual_machine_json_instance.id = id_instance6
                        
                        name_value8 = value_value.get('name', None)
                        if name_value8 is not None:
                            name_instance8 = name_value8
                            virtual_machine_json_instance.name = name_instance8
                        
                        type_value6 = value_value.get('type', None)
                        if type_value6 is not None:
                            type_instance6 = type_value6
                            virtual_machine_json_instance.type = type_instance6
                        
                        location_value2 = value_value.get('location', None)
                        if location_value2 is not None:
                            location_instance2 = location_value2
                            virtual_machine_json_instance.location = location_instance2
                        
                        tags_sequence_element2 = value_value.get('tags', None)
                        if tags_sequence_element2 is not None:
                            for property2 in tags_sequence_element2:
                                tags_key2 = property2
                                tags_value2 = tags_sequence_element2[property2]
                                virtual_machine_json_instance.tags[tags_key2] = tags_value2
                            
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_available_sizes(self, resource_group_name, vm_name):
        """
         Lists virtual-machine-sizes available to be used for a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         VirtualMachineSizeListResponse: The List Virtual Machine operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if vm_name is None:
            raise ValueError('vm_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/'
        url = url + 'virtualMachines'
        url = url + '/'
        url = url + quote(vm_name)
        url = url + '/vmSizes'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineSizeListResponse(virtual_machine_sizes=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_machine_size_instance = VirtualMachineSize()
                        result.virtual_machine_sizes.append(virtual_machine_size_instance)
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_size_instance.name = name_instance
                        
                        number_of_cores_value = value_value.get('numberOfCores', None)
                        if number_of_cores_value is not None:
                            number_of_cores_instance = number_of_cores_value
                            virtual_machine_size_instance.number_of_cores = number_of_cores_instance
                        
                        os_disk_size_in_mb_value = value_value.get('osDiskSizeInMB', None)
                        if os_disk_size_in_mb_value is not None:
                            os_disk_size_in_mb_instance = os_disk_size_in_mb_value
                            virtual_machine_size_instance.os_disk_size_in_mb = os_disk_size_in_mb_instance
                        
                        resource_disk_size_in_mb_value = value_value.get('resourceDiskSizeInMB', None)
                        if resource_disk_size_in_mb_value is not None:
                            resource_disk_size_in_mb_instance = resource_disk_size_in_mb_value
                            virtual_machine_size_instance.resource_disk_size_in_mb = resource_disk_size_in_mb_instance
                        
                        memory_in_mb_value = value_value.get('memoryInMB', None)
                        if memory_in_mb_value is not None:
                            memory_in_mb_instance = memory_in_mb_value
                            virtual_machine_size_instance.memory_in_mb = memory_in_mb_instance
                        
                        max_data_disk_count_value = value_value.get('maxDataDiskCount', None)
                        if max_data_disk_count_value is not None:
                            max_data_disk_count_instance = max_data_disk_count_value
                            virtual_machine_size_instance.max_data_disk_count = max_data_disk_count_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_next(self, next_link):
        """
         Gets the next page of Virtual Machines. NextLink is obtained by making
         a ListAll() callwhich fetches the first page of Virtual Machines and
         a link to fetch the next page.
         
         Args:
         
         next_link (string): NextLink from the previous successful call to
         ListVirtualMachines operation.
         
         Returns:
         
         VirtualMachineListResponse: The List Virtual Machine operation
         response.
        """
        # Validate
        if next_link is None:
            raise ValueError('next_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + next_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineListResponse(virtual_machines=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_machine_json_instance = VirtualMachine(extensions=[], tags={})
                        result.virtual_machines.append(virtual_machine_json_instance)
                        
                        plan_value = value_value.get('plan', None)
                        if plan_value is not None:
                            plan_instance = Plan()
                            virtual_machine_json_instance.plan = plan_instance
                            
                            name_value = plan_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                plan_instance.name = name_instance
                            
                            publisher_value = plan_value.get('publisher', None)
                            if publisher_value is not None:
                                publisher_instance = publisher_value
                                plan_instance.publisher = publisher_instance
                            
                            product_value = plan_value.get('product', None)
                            if product_value is not None:
                                product_instance = product_value
                                plan_instance.product = product_instance
                            
                            promotion_code_value = plan_value.get('promotionCode', None)
                            if promotion_code_value is not None:
                                promotion_code_instance = promotion_code_value
                                plan_instance.promotion_code = promotion_code_instance
                            
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            hardware_profile_value = properties_value.get('hardwareProfile', None)
                            if hardware_profile_value is not None:
                                hardware_profile_instance = HardwareProfile()
                                virtual_machine_json_instance.hardware_profile = hardware_profile_instance
                                
                                vm_size_value = hardware_profile_value.get('vmSize', None)
                                if vm_size_value is not None:
                                    vm_size_instance = vm_size_value
                                    hardware_profile_instance.virtual_machine_size = vm_size_instance
                                
                            storage_profile_value = properties_value.get('storageProfile', None)
                            if storage_profile_value is not None:
                                storage_profile_instance = StorageProfile(data_disks=[])
                                virtual_machine_json_instance.storage_profile = storage_profile_instance
                                
                                image_reference_value = storage_profile_value.get('imageReference', None)
                                if image_reference_value is not None:
                                    image_reference_instance = ImageReference()
                                    storage_profile_instance.image_reference = image_reference_instance
                                    
                                    publisher_value2 = image_reference_value.get('publisher', None)
                                    if publisher_value2 is not None:
                                        publisher_instance2 = publisher_value2
                                        image_reference_instance.publisher = publisher_instance2
                                    
                                    offer_value = image_reference_value.get('offer', None)
                                    if offer_value is not None:
                                        offer_instance = offer_value
                                        image_reference_instance.offer = offer_instance
                                    
                                    sku_value = image_reference_value.get('sku', None)
                                    if sku_value is not None:
                                        sku_instance = sku_value
                                        image_reference_instance.sku = sku_instance
                                    
                                    version_value = image_reference_value.get('version', None)
                                    if version_value is not None:
                                        version_instance = version_value
                                        image_reference_instance.version = version_instance
                                    
                                source_image_value = storage_profile_value.get('sourceImage', None)
                                if source_image_value is not None:
                                    source_image_instance = SourceImageReference()
                                    storage_profile_instance.source_image = source_image_instance
                                    
                                    id_value = source_image_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        source_image_instance.reference_uri = id_instance
                                    
                                os_disk_value = storage_profile_value.get('osDisk', None)
                                if os_disk_value is not None:
                                    os_disk_instance = OSDisk()
                                    storage_profile_instance.os_disk = os_disk_instance
                                    
                                    os_type_value = os_disk_value.get('osType', None)
                                    if os_type_value is not None:
                                        os_type_instance = os_type_value
                                        os_disk_instance.operating_system_type = os_type_instance
                                    
                                    name_value2 = os_disk_value.get('name', None)
                                    if name_value2 is not None:
                                        name_instance2 = name_value2
                                        os_disk_instance.name = name_instance2
                                    
                                    vhd_value = os_disk_value.get('vhd', None)
                                    if vhd_value is not None:
                                        vhd_instance = VirtualHardDisk()
                                        os_disk_instance.virtual_hard_disk = vhd_instance
                                        
                                        uri_value = vhd_value.get('uri', None)
                                        if uri_value is not None:
                                            uri_instance = uri_value
                                            vhd_instance.uri = uri_instance
                                        
                                    image_value = os_disk_value.get('image', None)
                                    if image_value is not None:
                                        image_instance = VirtualHardDisk()
                                        os_disk_instance.source_image = image_instance
                                        
                                        uri_value2 = image_value.get('uri', None)
                                        if uri_value2 is not None:
                                            uri_instance2 = uri_value2
                                            image_instance.uri = uri_instance2
                                        
                                    caching_value = os_disk_value.get('caching', None)
                                    if caching_value is not None:
                                        caching_instance = caching_value
                                        os_disk_instance.caching = caching_instance
                                    
                                    create_option_value = os_disk_value.get('createOption', None)
                                    if create_option_value is not None:
                                        create_option_instance = create_option_value
                                        os_disk_instance.create_option = create_option_instance
                                    
                                data_disks_array = storage_profile_value.get('dataDisks', None)
                                if data_disks_array is not None:
                                    for data_disks_value in data_disks_array:
                                        data_disk_instance = DataDisk()
                                        storage_profile_instance.data_disks.append(data_disk_instance)
                                        
                                        lun_value = data_disks_value.get('lun', None)
                                        if lun_value is not None:
                                            lun_instance = lun_value
                                            data_disk_instance.lun = lun_instance
                                        
                                        disk_size_gb_value = data_disks_value.get('diskSizeGB', None)
                                        if disk_size_gb_value is not None:
                                            disk_size_gb_instance = disk_size_gb_value
                                            data_disk_instance.disk_size_gb = disk_size_gb_instance
                                        
                                        name_value3 = data_disks_value.get('name', None)
                                        if name_value3 is not None:
                                            name_instance3 = name_value3
                                            data_disk_instance.name = name_instance3
                                        
                                        vhd_value2 = data_disks_value.get('vhd', None)
                                        if vhd_value2 is not None:
                                            vhd_instance2 = VirtualHardDisk()
                                            data_disk_instance.virtual_hard_disk = vhd_instance2
                                            
                                            uri_value3 = vhd_value2.get('uri', None)
                                            if uri_value3 is not None:
                                                uri_instance3 = uri_value3
                                                vhd_instance2.uri = uri_instance3
                                            
                                        image_value2 = data_disks_value.get('image', None)
                                        if image_value2 is not None:
                                            image_instance2 = VirtualHardDisk()
                                            data_disk_instance.source_image = image_instance2
                                            
                                            uri_value4 = image_value2.get('uri', None)
                                            if uri_value4 is not None:
                                                uri_instance4 = uri_value4
                                                image_instance2.uri = uri_instance4
                                            
                                        caching_value2 = data_disks_value.get('caching', None)
                                        if caching_value2 is not None:
                                            caching_instance2 = caching_value2
                                            data_disk_instance.caching = caching_instance2
                                        
                                        create_option_value2 = data_disks_value.get('createOption', None)
                                        if create_option_value2 is not None:
                                            create_option_instance2 = create_option_value2
                                            data_disk_instance.create_option = create_option_instance2
                                        
                            os_profile_value = properties_value.get('osProfile', None)
                            if os_profile_value is not None:
                                os_profile_instance = OSProfile(secrets=[])
                                virtual_machine_json_instance.os_profile = os_profile_instance
                                
                                computer_name_value = os_profile_value.get('computerName', None)
                                if computer_name_value is not None:
                                    computer_name_instance = computer_name_value
                                    os_profile_instance.computer_name = computer_name_instance
                                
                                admin_username_value = os_profile_value.get('adminUsername', None)
                                if admin_username_value is not None:
                                    admin_username_instance = admin_username_value
                                    os_profile_instance.admin_username = admin_username_instance
                                
                                admin_password_value = os_profile_value.get('adminPassword', None)
                                if admin_password_value is not None:
                                    admin_password_instance = admin_password_value
                                    os_profile_instance.admin_password = admin_password_instance
                                
                                custom_data_value = os_profile_value.get('customData', None)
                                if custom_data_value is not None:
                                    custom_data_instance = custom_data_value
                                    os_profile_instance.custom_data = custom_data_instance
                                
                                windows_configuration_value = os_profile_value.get('windowsConfiguration', None)
                                if windows_configuration_value is not None:
                                    windows_configuration_instance = WindowsConfiguration(additional_unattend_contents=[])
                                    os_profile_instance.windows_configuration = windows_configuration_instance
                                    
                                    provision_vm_agent_value = windows_configuration_value.get('provisionVMAgent', None)
                                    if provision_vm_agent_value is not None:
                                        provision_vm_agent_instance = provision_vm_agent_value
                                        windows_configuration_instance.provision_vm_agent = provision_vm_agent_instance
                                    
                                    enable_automatic_updates_value = windows_configuration_value.get('enableAutomaticUpdates', None)
                                    if enable_automatic_updates_value is not None:
                                        enable_automatic_updates_instance = enable_automatic_updates_value
                                        windows_configuration_instance.enable_automatic_updates = enable_automatic_updates_instance
                                    
                                    time_zone_value = windows_configuration_value.get('timeZone', None)
                                    if time_zone_value is not None:
                                        time_zone_instance = time_zone_value
                                        windows_configuration_instance.time_zone = time_zone_instance
                                    
                                    additional_unattend_content_array = windows_configuration_value.get('additionalUnattendContent', None)
                                    if additional_unattend_content_array is not None:
                                        for additional_unattend_content_value in additional_unattend_content_array:
                                            additional_unattend_content_instance = AdditionalUnattendContent()
                                            windows_configuration_instance.additional_unattend_contents.append(additional_unattend_content_instance)
                                            
                                            pass_name_value = additional_unattend_content_value.get('passName', None)
                                            if pass_name_value is not None:
                                                pass_name_instance = pass_name_value
                                                additional_unattend_content_instance.pass_name = pass_name_instance
                                            
                                            component_name_value = additional_unattend_content_value.get('componentName', None)
                                            if component_name_value is not None:
                                                component_name_instance = component_name_value
                                                additional_unattend_content_instance.component_name = component_name_instance
                                            
                                            setting_name_value = additional_unattend_content_value.get('settingName', None)
                                            if setting_name_value is not None:
                                                setting_name_instance = setting_name_value
                                                additional_unattend_content_instance.setting_name = setting_name_instance
                                            
                                            content_value = additional_unattend_content_value.get('content', None)
                                            if content_value is not None:
                                                content_instance = content_value
                                                additional_unattend_content_instance.content = content_instance
                                            
                                    win_rm_value = windows_configuration_value.get('winRM', None)
                                    if win_rm_value is not None:
                                        win_rm_instance = WinRMConfiguration(listeners=[])
                                        windows_configuration_instance.win_rm_configuration = win_rm_instance
                                        
                                        listeners_array = win_rm_value.get('listeners', None)
                                        if listeners_array is not None:
                                            for listeners_value in listeners_array:
                                                win_rm_listener_instance = WinRMListener()
                                                win_rm_instance.listeners.append(win_rm_listener_instance)
                                                
                                                protocol_value = listeners_value.get('protocol', None)
                                                if protocol_value is not None:
                                                    protocol_instance = protocol_value
                                                    win_rm_listener_instance.protocol = protocol_instance
                                                
                                                certificate_url_value = listeners_value.get('certificateUrl', None)
                                                if certificate_url_value is not None:
                                                    certificate_url_instance = certificate_url_value
                                                    win_rm_listener_instance.certificate_url = certificate_url_instance
                                                
                                linux_configuration_value = os_profile_value.get('linuxConfiguration', None)
                                if linux_configuration_value is not None:
                                    linux_configuration_instance = LinuxConfiguration()
                                    os_profile_instance.linux_configuration = linux_configuration_instance
                                    
                                    disable_password_authentication_value = linux_configuration_value.get('disablePasswordAuthentication', None)
                                    if disable_password_authentication_value is not None:
                                        disable_password_authentication_instance = disable_password_authentication_value
                                        linux_configuration_instance.disable_password_authentication = disable_password_authentication_instance
                                    
                                    ssh_value = linux_configuration_value.get('ssh', None)
                                    if ssh_value is not None:
                                        ssh_instance = SshConfiguration(public_keys=[])
                                        linux_configuration_instance.ssh_configuration = ssh_instance
                                        
                                        public_keys_array = ssh_value.get('publicKeys', None)
                                        if public_keys_array is not None:
                                            for public_keys_value in public_keys_array:
                                                ssh_public_key_instance = SshPublicKey()
                                                ssh_instance.public_keys.append(ssh_public_key_instance)
                                                
                                                path_value = public_keys_value.get('path', None)
                                                if path_value is not None:
                                                    path_instance = path_value
                                                    ssh_public_key_instance.path = path_instance
                                                
                                                key_data_value = public_keys_value.get('keyData', None)
                                                if key_data_value is not None:
                                                    key_data_instance = key_data_value
                                                    ssh_public_key_instance.key_data = key_data_instance
                                                
                                secrets_array = os_profile_value.get('secrets', None)
                                if secrets_array is not None:
                                    for secrets_value in secrets_array:
                                        vault_secret_group_instance = VaultSecretGroup(vault_certificates=[])
                                        os_profile_instance.secrets.append(vault_secret_group_instance)
                                        
                                        source_vault_value = secrets_value.get('sourceVault', None)
                                        if source_vault_value is not None:
                                            source_vault_instance = SourceVaultReference()
                                            vault_secret_group_instance.source_vault = source_vault_instance
                                            
                                            id_value2 = source_vault_value.get('id', None)
                                            if id_value2 is not None:
                                                id_instance2 = id_value2
                                                source_vault_instance.reference_uri = id_instance2
                                            
                                        vault_certificates_array = secrets_value.get('vaultCertificates', None)
                                        if vault_certificates_array is not None:
                                            for vault_certificates_value in vault_certificates_array:
                                                vault_certificate_instance = VaultCertificate()
                                                vault_secret_group_instance.vault_certificates.append(vault_certificate_instance)
                                                
                                                certificate_url_value2 = vault_certificates_value.get('certificateUrl', None)
                                                if certificate_url_value2 is not None:
                                                    certificate_url_instance2 = certificate_url_value2
                                                    vault_certificate_instance.certificate_url = certificate_url_instance2
                                                
                                                certificate_store_value = vault_certificates_value.get('certificateStore', None)
                                                if certificate_store_value is not None:
                                                    certificate_store_instance = certificate_store_value
                                                    vault_certificate_instance.certificate_store = certificate_store_instance
                                                
                            network_profile_value = properties_value.get('networkProfile', None)
                            if network_profile_value is not None:
                                network_profile_instance = NetworkProfile(network_interfaces=[])
                                virtual_machine_json_instance.network_profile = network_profile_instance
                                
                                network_interfaces_array = network_profile_value.get('networkInterfaces', None)
                                if network_interfaces_array is not None:
                                    for network_interfaces_value in network_interfaces_array:
                                        network_interface_reference_json_instance = NetworkInterfaceReference()
                                        network_profile_instance.network_interfaces.append(network_interface_reference_json_instance)
                                        
                                        properties_value2 = network_interfaces_value.get('properties', None)
                                        if properties_value2 is not None:
                                            primary_value = properties_value2.get('primary', None)
                                            if primary_value is not None:
                                                primary_instance = primary_value
                                                network_interface_reference_json_instance.primary = primary_instance
                                            
                                        id_value3 = network_interfaces_value.get('id', None)
                                        if id_value3 is not None:
                                            id_instance3 = id_value3
                                            network_interface_reference_json_instance.reference_uri = id_instance3
                                        
                            availability_set_value = properties_value.get('availabilitySet', None)
                            if availability_set_value is not None:
                                availability_set_instance = AvailabilitySetReference()
                                virtual_machine_json_instance.availability_set_reference = availability_set_instance
                                
                                id_value4 = availability_set_value.get('id', None)
                                if id_value4 is not None:
                                    id_instance4 = id_value4
                                    availability_set_instance.reference_uri = id_instance4
                                
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                virtual_machine_json_instance.provisioning_state = provisioning_state_instance
                            
                            instance_view_value = properties_value.get('instanceView', None)
                            if instance_view_value is not None:
                                instance_view_instance = VirtualMachineInstanceView(disks=[], extensions=[], statuses=[])
                                virtual_machine_json_instance.instance_view = instance_view_instance
                                
                                platform_update_domain_value = instance_view_value.get('platformUpdateDomain', None)
                                if platform_update_domain_value is not None:
                                    platform_update_domain_instance = platform_update_domain_value
                                    instance_view_instance.platform_update_domain = platform_update_domain_instance
                                
                                platform_fault_domain_value = instance_view_value.get('platformFaultDomain', None)
                                if platform_fault_domain_value is not None:
                                    platform_fault_domain_instance = platform_fault_domain_value
                                    instance_view_instance.platform_fault_domain = platform_fault_domain_instance
                                
                                rdp_thumb_print_value = instance_view_value.get('rdpThumbPrint', None)
                                if rdp_thumb_print_value is not None:
                                    rdp_thumb_print_instance = rdp_thumb_print_value
                                    instance_view_instance.remote_desktop_thumbprint = rdp_thumb_print_instance
                                
                                vm_agent_value = instance_view_value.get('vmAgent', None)
                                if vm_agent_value is not None:
                                    vm_agent_instance = VirtualMachineAgentInstanceView(extension_handlers=[], statuses=[])
                                    instance_view_instance.vm_agent = vm_agent_instance
                                    
                                    vm_agent_version_value = vm_agent_value.get('vmAgentVersion', None)
                                    if vm_agent_version_value is not None:
                                        vm_agent_version_instance = vm_agent_version_value
                                        vm_agent_instance.vm_agent_version = vm_agent_version_instance
                                    
                                    extension_handlers_array = vm_agent_value.get('extensionHandlers', None)
                                    if extension_handlers_array is not None:
                                        for extension_handlers_value in extension_handlers_array:
                                            virtual_machine_extension_handler_instance_view_instance = VirtualMachineExtensionHandlerInstanceView()
                                            vm_agent_instance.extension_handlers.append(virtual_machine_extension_handler_instance_view_instance)
                                            
                                            type_value = extension_handlers_value.get('type', None)
                                            if type_value is not None:
                                                type_instance = type_value
                                                virtual_machine_extension_handler_instance_view_instance.type = type_instance
                                            
                                            type_handler_version_value = extension_handlers_value.get('typeHandlerVersion', None)
                                            if type_handler_version_value is not None:
                                                type_handler_version_instance = type_handler_version_value
                                                virtual_machine_extension_handler_instance_view_instance.type_handler_version = type_handler_version_instance
                                            
                                            status_value = extension_handlers_value.get('status', None)
                                            if status_value is not None:
                                                status_instance = InstanceViewStatus()
                                                virtual_machine_extension_handler_instance_view_instance.status = status_instance
                                                
                                                code_value = status_value.get('code', None)
                                                if code_value is not None:
                                                    code_instance = code_value
                                                    status_instance.code = code_instance
                                                
                                                level_value = status_value.get('level', None)
                                                if level_value is not None:
                                                    level_instance = level_value
                                                    status_instance.level = level_instance
                                                
                                                display_status_value = status_value.get('displayStatus', None)
                                                if display_status_value is not None:
                                                    display_status_instance = display_status_value
                                                    status_instance.display_status = display_status_instance
                                                
                                                message_value = status_value.get('message', None)
                                                if message_value is not None:
                                                    message_instance = message_value
                                                    status_instance.message = message_instance
                                                
                                                time_value = status_value.get('time', None)
                                                if time_value is not None:
                                                    time_instance = time_value
                                                    status_instance.time = time_instance
                                                
                                    statuses_array = vm_agent_value.get('statuses', None)
                                    if statuses_array is not None:
                                        for statuses_value in statuses_array:
                                            instance_view_status_instance = InstanceViewStatus()
                                            vm_agent_instance.statuses.append(instance_view_status_instance)
                                            
                                            code_value2 = statuses_value.get('code', None)
                                            if code_value2 is not None:
                                                code_instance2 = code_value2
                                                instance_view_status_instance.code = code_instance2
                                            
                                            level_value2 = statuses_value.get('level', None)
                                            if level_value2 is not None:
                                                level_instance2 = level_value2
                                                instance_view_status_instance.level = level_instance2
                                            
                                            display_status_value2 = statuses_value.get('displayStatus', None)
                                            if display_status_value2 is not None:
                                                display_status_instance2 = display_status_value2
                                                instance_view_status_instance.display_status = display_status_instance2
                                            
                                            message_value2 = statuses_value.get('message', None)
                                            if message_value2 is not None:
                                                message_instance2 = message_value2
                                                instance_view_status_instance.message = message_instance2
                                            
                                            time_value2 = statuses_value.get('time', None)
                                            if time_value2 is not None:
                                                time_instance2 = time_value2
                                                instance_view_status_instance.time = time_instance2
                                            
                                disks_array = instance_view_value.get('disks', None)
                                if disks_array is not None:
                                    for disks_value in disks_array:
                                        disk_instance_view_instance = DiskInstanceView(statuses=[])
                                        instance_view_instance.disks.append(disk_instance_view_instance)
                                        
                                        name_value4 = disks_value.get('name', None)
                                        if name_value4 is not None:
                                            name_instance4 = name_value4
                                            disk_instance_view_instance.name = name_instance4
                                        
                                        statuses_array2 = disks_value.get('statuses', None)
                                        if statuses_array2 is not None:
                                            for statuses_value2 in statuses_array2:
                                                instance_view_status_instance2 = InstanceViewStatus()
                                                disk_instance_view_instance.statuses.append(instance_view_status_instance2)
                                                
                                                code_value3 = statuses_value2.get('code', None)
                                                if code_value3 is not None:
                                                    code_instance3 = code_value3
                                                    instance_view_status_instance2.code = code_instance3
                                                
                                                level_value3 = statuses_value2.get('level', None)
                                                if level_value3 is not None:
                                                    level_instance3 = level_value3
                                                    instance_view_status_instance2.level = level_instance3
                                                
                                                display_status_value3 = statuses_value2.get('displayStatus', None)
                                                if display_status_value3 is not None:
                                                    display_status_instance3 = display_status_value3
                                                    instance_view_status_instance2.display_status = display_status_instance3
                                                
                                                message_value3 = statuses_value2.get('message', None)
                                                if message_value3 is not None:
                                                    message_instance3 = message_value3
                                                    instance_view_status_instance2.message = message_instance3
                                                
                                                time_value3 = statuses_value2.get('time', None)
                                                if time_value3 is not None:
                                                    time_instance3 = time_value3
                                                    instance_view_status_instance2.time = time_instance3
                                                
                                extensions_array = instance_view_value.get('extensions', None)
                                if extensions_array is not None:
                                    for extensions_value in extensions_array:
                                        virtual_machine_extension_instance_view_instance = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                        instance_view_instance.extensions.append(virtual_machine_extension_instance_view_instance)
                                        
                                        name_value5 = extensions_value.get('name', None)
                                        if name_value5 is not None:
                                            name_instance5 = name_value5
                                            virtual_machine_extension_instance_view_instance.name = name_instance5
                                        
                                        type_value2 = extensions_value.get('type', None)
                                        if type_value2 is not None:
                                            type_instance2 = type_value2
                                            virtual_machine_extension_instance_view_instance.extension_type = type_instance2
                                        
                                        type_handler_version_value2 = extensions_value.get('typeHandlerVersion', None)
                                        if type_handler_version_value2 is not None:
                                            type_handler_version_instance2 = type_handler_version_value2
                                            virtual_machine_extension_instance_view_instance.type_handler_version = type_handler_version_instance2
                                        
                                        substatuses_array = extensions_value.get('substatuses', None)
                                        if substatuses_array is not None:
                                            for substatuses_value in substatuses_array:
                                                instance_view_status_instance3 = InstanceViewStatus()
                                                virtual_machine_extension_instance_view_instance.sub_statuses.append(instance_view_status_instance3)
                                                
                                                code_value4 = substatuses_value.get('code', None)
                                                if code_value4 is not None:
                                                    code_instance4 = code_value4
                                                    instance_view_status_instance3.code = code_instance4
                                                
                                                level_value4 = substatuses_value.get('level', None)
                                                if level_value4 is not None:
                                                    level_instance4 = level_value4
                                                    instance_view_status_instance3.level = level_instance4
                                                
                                                display_status_value4 = substatuses_value.get('displayStatus', None)
                                                if display_status_value4 is not None:
                                                    display_status_instance4 = display_status_value4
                                                    instance_view_status_instance3.display_status = display_status_instance4
                                                
                                                message_value4 = substatuses_value.get('message', None)
                                                if message_value4 is not None:
                                                    message_instance4 = message_value4
                                                    instance_view_status_instance3.message = message_instance4
                                                
                                                time_value4 = substatuses_value.get('time', None)
                                                if time_value4 is not None:
                                                    time_instance4 = time_value4
                                                    instance_view_status_instance3.time = time_instance4
                                                
                                        statuses_array3 = extensions_value.get('statuses', None)
                                        if statuses_array3 is not None:
                                            for statuses_value3 in statuses_array3:
                                                instance_view_status_instance4 = InstanceViewStatus()
                                                virtual_machine_extension_instance_view_instance.statuses.append(instance_view_status_instance4)
                                                
                                                code_value5 = statuses_value3.get('code', None)
                                                if code_value5 is not None:
                                                    code_instance5 = code_value5
                                                    instance_view_status_instance4.code = code_instance5
                                                
                                                level_value5 = statuses_value3.get('level', None)
                                                if level_value5 is not None:
                                                    level_instance5 = level_value5
                                                    instance_view_status_instance4.level = level_instance5
                                                
                                                display_status_value5 = statuses_value3.get('displayStatus', None)
                                                if display_status_value5 is not None:
                                                    display_status_instance5 = display_status_value5
                                                    instance_view_status_instance4.display_status = display_status_instance5
                                                
                                                message_value5 = statuses_value3.get('message', None)
                                                if message_value5 is not None:
                                                    message_instance5 = message_value5
                                                    instance_view_status_instance4.message = message_instance5
                                                
                                                time_value5 = statuses_value3.get('time', None)
                                                if time_value5 is not None:
                                                    time_instance5 = time_value5
                                                    instance_view_status_instance4.time = time_instance5
                                                
                                statuses_array4 = instance_view_value.get('statuses', None)
                                if statuses_array4 is not None:
                                    for statuses_value4 in statuses_array4:
                                        instance_view_status_instance5 = InstanceViewStatus()
                                        instance_view_instance.statuses.append(instance_view_status_instance5)
                                        
                                        code_value6 = statuses_value4.get('code', None)
                                        if code_value6 is not None:
                                            code_instance6 = code_value6
                                            instance_view_status_instance5.code = code_instance6
                                        
                                        level_value6 = statuses_value4.get('level', None)
                                        if level_value6 is not None:
                                            level_instance6 = level_value6
                                            instance_view_status_instance5.level = level_instance6
                                        
                                        display_status_value6 = statuses_value4.get('displayStatus', None)
                                        if display_status_value6 is not None:
                                            display_status_instance6 = display_status_value6
                                            instance_view_status_instance5.display_status = display_status_instance6
                                        
                                        message_value6 = statuses_value4.get('message', None)
                                        if message_value6 is not None:
                                            message_instance6 = message_value6
                                            instance_view_status_instance5.message = message_instance6
                                        
                                        time_value6 = statuses_value4.get('time', None)
                                        if time_value6 is not None:
                                            time_instance6 = time_value6
                                            instance_view_status_instance5.time = time_instance6
                                        
                        resources_array = value_value.get('resources', None)
                        if resources_array is not None:
                            virtual_machine_json_instance.extensions = []
                            for resources_value in resources_array:
                                virtual_machine_extension_json_instance = VirtualMachineExtension(tags={})
                                virtual_machine_json_instance.extensions.append(virtual_machine_extension_json_instance)
                                
                                properties_value3 = resources_value.get('properties', None)
                                if properties_value3 is not None:
                                    publisher_value3 = properties_value3.get('publisher', None)
                                    if publisher_value3 is not None:
                                        publisher_instance3 = publisher_value3
                                        virtual_machine_extension_json_instance.publisher = publisher_instance3
                                    
                                    type_value3 = properties_value3.get('type', None)
                                    if type_value3 is not None:
                                        type_instance3 = type_value3
                                        virtual_machine_extension_json_instance.extension_type = type_instance3
                                    
                                    type_handler_version_value3 = properties_value3.get('typeHandlerVersion', None)
                                    if type_handler_version_value3 is not None:
                                        type_handler_version_instance3 = type_handler_version_value3
                                        virtual_machine_extension_json_instance.type_handler_version = type_handler_version_instance3
                                    
                                    auto_upgrade_minor_version_value = properties_value3.get('autoUpgradeMinorVersion', None)
                                    if auto_upgrade_minor_version_value is not None:
                                        auto_upgrade_minor_version_instance = auto_upgrade_minor_version_value
                                        virtual_machine_extension_json_instance.auto_upgrade_minor_version = auto_upgrade_minor_version_instance
                                    
                                    settings_value = properties_value3.get('settings', None)
                                    if settings_value is not None:
                                        settings_instance = json.dumps(settings_value)
                                        virtual_machine_extension_json_instance.settings = settings_instance
                                    
                                    protected_settings_value = properties_value3.get('protectedSettings', None)
                                    if protected_settings_value is not None:
                                        protected_settings_instance = json.dumps(protected_settings_value)
                                        virtual_machine_extension_json_instance.protected_settings = protected_settings_instance
                                    
                                    provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                    if provisioning_state_value2 is not None:
                                        provisioning_state_instance2 = provisioning_state_value2
                                        virtual_machine_extension_json_instance.provisioning_state = provisioning_state_instance2
                                    
                                    instance_view_value2 = properties_value3.get('instanceView', None)
                                    if instance_view_value2 is not None:
                                        instance_view_instance2 = VirtualMachineExtensionInstanceView(statuses=[], sub_statuses=[])
                                        virtual_machine_extension_json_instance.instance_view = instance_view_instance2
                                        
                                        name_value6 = instance_view_value2.get('name', None)
                                        if name_value6 is not None:
                                            name_instance6 = name_value6
                                            instance_view_instance2.name = name_instance6
                                        
                                        type_value4 = instance_view_value2.get('type', None)
                                        if type_value4 is not None:
                                            type_instance4 = type_value4
                                            instance_view_instance2.extension_type = type_instance4
                                        
                                        type_handler_version_value4 = instance_view_value2.get('typeHandlerVersion', None)
                                        if type_handler_version_value4 is not None:
                                            type_handler_version_instance4 = type_handler_version_value4
                                            instance_view_instance2.type_handler_version = type_handler_version_instance4
                                        
                                        substatuses_array2 = instance_view_value2.get('substatuses', None)
                                        if substatuses_array2 is not None:
                                            for substatuses_value2 in substatuses_array2:
                                                instance_view_status_instance6 = InstanceViewStatus()
                                                instance_view_instance2.sub_statuses.append(instance_view_status_instance6)
                                                
                                                code_value7 = substatuses_value2.get('code', None)
                                                if code_value7 is not None:
                                                    code_instance7 = code_value7
                                                    instance_view_status_instance6.code = code_instance7
                                                
                                                level_value7 = substatuses_value2.get('level', None)
                                                if level_value7 is not None:
                                                    level_instance7 = level_value7
                                                    instance_view_status_instance6.level = level_instance7
                                                
                                                display_status_value7 = substatuses_value2.get('displayStatus', None)
                                                if display_status_value7 is not None:
                                                    display_status_instance7 = display_status_value7
                                                    instance_view_status_instance6.display_status = display_status_instance7
                                                
                                                message_value7 = substatuses_value2.get('message', None)
                                                if message_value7 is not None:
                                                    message_instance7 = message_value7
                                                    instance_view_status_instance6.message = message_instance7
                                                
                                                time_value7 = substatuses_value2.get('time', None)
                                                if time_value7 is not None:
                                                    time_instance7 = time_value7
                                                    instance_view_status_instance6.time = time_instance7
                                                
                                        statuses_array5 = instance_view_value2.get('statuses', None)
                                        if statuses_array5 is not None:
                                            for statuses_value5 in statuses_array5:
                                                instance_view_status_instance7 = InstanceViewStatus()
                                                instance_view_instance2.statuses.append(instance_view_status_instance7)
                                                
                                                code_value8 = statuses_value5.get('code', None)
                                                if code_value8 is not None:
                                                    code_instance8 = code_value8
                                                    instance_view_status_instance7.code = code_instance8
                                                
                                                level_value8 = statuses_value5.get('level', None)
                                                if level_value8 is not None:
                                                    level_instance8 = level_value8
                                                    instance_view_status_instance7.level = level_instance8
                                                
                                                display_status_value8 = statuses_value5.get('displayStatus', None)
                                                if display_status_value8 is not None:
                                                    display_status_instance8 = display_status_value8
                                                    instance_view_status_instance7.display_status = display_status_instance8
                                                
                                                message_value8 = statuses_value5.get('message', None)
                                                if message_value8 is not None:
                                                    message_instance8 = message_value8
                                                    instance_view_status_instance7.message = message_instance8
                                                
                                                time_value8 = statuses_value5.get('time', None)
                                                if time_value8 is not None:
                                                    time_instance8 = time_value8
                                                    instance_view_status_instance7.time = time_instance8
                                                
                                id_value5 = resources_value.get('id', None)
                                if id_value5 is not None:
                                    id_instance5 = id_value5
                                    virtual_machine_extension_json_instance.id = id_instance5
                                
                                name_value7 = resources_value.get('name', None)
                                if name_value7 is not None:
                                    name_instance7 = name_value7
                                    virtual_machine_extension_json_instance.name = name_instance7
                                
                                type_value5 = resources_value.get('type', None)
                                if type_value5 is not None:
                                    type_instance5 = type_value5
                                    virtual_machine_extension_json_instance.type = type_instance5
                                
                                location_value = resources_value.get('location', None)
                                if location_value is not None:
                                    location_instance = location_value
                                    virtual_machine_extension_json_instance.location = location_instance
                                
                                tags_sequence_element = resources_value.get('tags', None)
                                if tags_sequence_element is not None:
                                    for property in tags_sequence_element:
                                        tags_key = property
                                        tags_value = tags_sequence_element[property]
                                        virtual_machine_extension_json_instance.tags[tags_key] = tags_value
                                    
                        id_value6 = value_value.get('id', None)
                        if id_value6 is not None:
                            id_instance6 = id_value6
                            virtual_machine_json_instance.id = id_instance6
                        
                        name_value8 = value_value.get('name', None)
                        if name_value8 is not None:
                            name_instance8 = name_value8
                            virtual_machine_json_instance.name = name_instance8
                        
                        type_value6 = value_value.get('type', None)
                        if type_value6 is not None:
                            type_instance6 = type_value6
                            virtual_machine_json_instance.type = type_instance6
                        
                        location_value2 = value_value.get('location', None)
                        if location_value2 is not None:
                            location_instance2 = location_value2
                            virtual_machine_json_instance.location = location_instance2
                        
                        tags_sequence_element2 = value_value.get('tags', None)
                        if tags_sequence_element2 is not None:
                            for property2 in tags_sequence_element2:
                                tags_key2 = property2
                                tags_value2 = tags_sequence_element2[property2]
                                virtual_machine_json_instance.tags[tags_key2] = tags_value2
                            
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def power_off(self, resource_group_name, vm_name):
        """
         The operation to power off (stop) a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machines.begin_powering_off(resource_group_name, vm_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def restart(self, resource_group_name, vm_name):
        """
         The operation to restart a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machines.begin_restarting(resource_group_name, vm_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def start(self, resource_group_name, vm_name):
        """
         The operation to start a virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         vm_name (string): The name of the virtual machine.
         
         Returns:
         
         ComputeLongRunningOperationResponse: The Compute service response for
         long-running operations.
        """
        client2 = self.client
        
        response = client2.virtual_machines.begin_starting(resource_group_name, vm_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = 30
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != ComputeOperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = 30
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
class VirtualMachineSizeOperations(object):
    """
     Operations for listing virtual machine sizes available in a region.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ComputeManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Compute.ComputeManagementClient.
        """
        return self._client
    
    def list(self, location):
        """
         Lists virtual-machine-sizes available in a location for a subscription.
         
         Args:
         
         location (string): The location upon which virtual-machine-sizes is
         queried.
         
         Returns:
         
         VirtualMachineSizeListResponse: The List Virtual Machine operation
         response.
        """
        # Validate
        if location is None:
            raise ValueError('location cannot be None.')
        
        if location is not None and len(location) > 1000:
            raise IndexError('location is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', location) is not None) == False:
            raise IndexError('location is outside the valid range.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Compute'
        url = url + '/locations/'
        url = url + quote(location)
        url = url + '/vmSizes'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualMachineSizeListResponse(virtual_machine_sizes=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_machine_size_instance = VirtualMachineSize()
                        result.virtual_machine_sizes.append(virtual_machine_size_instance)
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            virtual_machine_size_instance.name = name_instance
                        
                        number_of_cores_value = value_value.get('numberOfCores', None)
                        if number_of_cores_value is not None:
                            number_of_cores_instance = number_of_cores_value
                            virtual_machine_size_instance.number_of_cores = number_of_cores_instance
                        
                        os_disk_size_in_mb_value = value_value.get('osDiskSizeInMB', None)
                        if os_disk_size_in_mb_value is not None:
                            os_disk_size_in_mb_instance = os_disk_size_in_mb_value
                            virtual_machine_size_instance.os_disk_size_in_mb = os_disk_size_in_mb_instance
                        
                        resource_disk_size_in_mb_value = value_value.get('resourceDiskSizeInMB', None)
                        if resource_disk_size_in_mb_value is not None:
                            resource_disk_size_in_mb_instance = resource_disk_size_in_mb_value
                            virtual_machine_size_instance.resource_disk_size_in_mb = resource_disk_size_in_mb_instance
                        
                        memory_in_mb_value = value_value.get('memoryInMB', None)
                        if memory_in_mb_value is not None:
                            memory_in_mb_instance = memory_in_mb_value
                            virtual_machine_size_instance.memory_in_mb = memory_in_mb_instance
                        
                        max_data_disk_count_value = value_value.get('maxDataDiskCount', None)
                        if max_data_disk_count_value is not None:
                            max_data_disk_count_instance = max_data_disk_count_value
                            virtual_machine_size_instance.max_data_disk_count = max_data_disk_count_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
