from subprocess import Popen
import os
class tsp:
    def __init__(self, points=None):
        self.points = points if points else []
    def solve(self, filename='_tmp_'):
        with open('%s.dat' % filename, 'w') as fp:
            fp.write('TYPE : TSP\nDIMENSION : %d\n' % len(self.points))
            fp.write('EDGE_WEIGHT_TYPE : EUC_2D\nNODE_COORD_SECTION\n')
            for i, (x, y) in enumerate(self.points):
                fp.write('%d %g %g\n' % (i, x, y))
            fp.write('EOF\n')
        prc = Popen('concorde %s.dat' % filename)
        prc.wait()
        with open('%s.sol' % filename) as fp:
            ll = (''.join(fp)).split()
        self.result = [int(s) for s in ll[1:]]
        for s in ('%s.dat', '%s.sol'): os.remove(s % filename)
