from setuptools import setup

version = '0.0.1'
name = 'tsp'
short_description = '`tsp` is a package for Traveling Salesman Problem.'
long_description = """\
`tsp` is a package for Traveling Salesman Problem.
Using Concorde.
http://www.math.uwaterloo.ca/tsp/concorde/
::

   t = tsp([(0,0), (0,1), (1,0), (1,1)])
   t.solve()
   print(t.result)
   >>>
   [0, 1, 3, 2]

Requirements
------------
* Python 2 or Python 3
* concorde

Features
--------
* nothing

Setup
-----
::

   $ pip install tsp
   or
   $ easy_install tsp

History
-------
0.0.1 (2015-10-2)
~~~~~~~~~~~~~~~~~~
* first release

"""

classifiers = [
   "Development Status :: 1 - Planning",
   "License :: OSI Approved :: Python Software Foundation License",
   "Programming Language :: Python",
   "Topic :: Software Development",
]

setup(
    name=name,
    version=version,
    description=short_description,
    long_description=long_description,
    classifiers=classifiers,
    py_modules=['tsp'],
    keywords=['tsp',],
    author='Saito Tsutomu',
    author_email='tsutomu@kke.co.jp',
    url='https://pypi.python.org/pypi/tsp',
    license='PSFL',
)