#!-*- coding:utf-8 -*-

#The MIT License
#
#Copyright (c) 2008 rubyu (http://d.hatena.ne.jp/ruby-U/)
#
#Permission is hereby granted, free of charge, to any person obtaining a copy
#of this software and associated documentation files (the "Software"), to deal
#in the Software without restriction, including without limitation the rights
#to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#copies of the Software, and to permit persons to whom the Software is
#furnished to do so, subject to the following conditions:
#
#The above copyright notice and this permission notice shall be included in
#all copies or substantial portions of the Software.
#
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
#THE SOFTWARE.

import re

dics = {}
dics["html_140"] = [
    ["000000","f0f8ff","008b8b","ffffe0","ff7f50","696969","e6e6fa","008080","fafad2",
	"ff6347","808080","b0c4de","2f4f4f","fffacd","ff4500","a9a9a9","778899","006400",
	"f5deb3","ff0000","c0c0c0","708090","008000","deb887","dc143c","d3d3d3","4682b4",
	"228b22","d2b48c","c71585","dcdcdc","4169e1","2e8b57","f0e68c","ff1493","f5f5f5",
	"191970","3cb371","ffff00","ff69b4","ffffff","000080","66cdaa","ffd700","db7093",
	"fffafa","00008b","8fbc8f","ffa500","ffc0cb","f8f8ff","0000cd","7fffd4","f4a460",
	"ffb6c1","fffaf0","0000ff","98fb98","ff8c00","d8bfd8","faf0e6","1e90ff","90ee90",
	"daa520","ff00ff","faebd7","6495ed","00ff7f","cd853f","ff00ff","ffefd5","00bfff",
	"00fa9a","b8860b","ee82ee","ffebcd","87cefa","7cfc00","d2691e","dda0dd","ffe4c4",
	"87ceeb","7fff00","a0522d","da70d6","ffe4b5","add8e6","adff2f","8b4513","ba55d3",
	"ffdead","b0e0e6","00ff00","800000","9932cc","ffdab9","afeeee","32cd32","8b0000",
	"9400d3","ffe4e1","e0ffff","9acd32","a52a2a","8b008b","fff0f5","00ffff","556b2f",
	"b22222","800080","fff5ee","00ffff","6b8e23","cd5c5c","4b0082","fdf5e6","40e0d0",
	"808000","bc8f8f","483d8b","fffff0","48d1cc","bdb76b","e9967a","8a2be2","f0fff0",
	"00ced1","eee8aa","f08080","9370db","f5fffa","20b2aa","fff8dc","fa8072","6a5acd",
	"f0ffff","5f9ea0","f5f5dc","ffa07a","7b68ee"],{
"alphabet":[{"black": 0,"aliceblue": 1,"darkcyan": 2,"lightyellow": 3,"coral": 4,
    "dimgray": 5,"lavender": 6,"teal": 7,"lightgoldenrodyellow": 8,"tomato": 9,
    "gray": 10,"lightsteelblue": 11,"darkslategray": 12,"lemonchiffon": 13,
    "orangered": 14,"darkgray": 15,"lightslategray": 16,"darkgreen": 17,"wheat": 18,
    "red": 19,"silver": 20,"slategray": 21,"green": 22,"burlywood": 23,"crimson": 24,
    "lightgrey": 25,"steelblue": 26,"forestgreen": 27,"tan": 28,"mediumvioletred": 29,
    "gainsboro": 30,"royalblue": 31,"seagreen": 32,"khaki": 33,"deeppink": 34,
    "whitesmoke": 35,"midnightblue": 36,"mediumseagreen": 37,"yellow": 38,
    "hotpink": 39,"white": 40,"navy": 41,"mediumaquamarine": 42,"gold": 43,
    "palevioletred": 44,"snow": 45,"darkblue": 46,"darkseagreen": 47,"orange": 48,
    "pink": 49,"ghostwhite": 50,"mediumblue": 51,"aquamarine": 52,"sandybrown": 53,
	"lightpink": 54,"floralwhite": 55,"blue": 56,"palegreen": 57,"darkorange": 58,
    "thistle": 59,"linen": 60,"dodgerblue": 61,"lightgreen": 62,"goldenrod": 63,
    "magenta": 64,"antiquewhite": 65,"cornflowerblue": 66,"springgreen": 67,"peru": 68,
    "fuchsia": 69,"papayawhip": 70,"deepskyblue": 71,"mediumspringgreen": 72,
    "darkgoldenrod": 73,"violet": 74,"blanchedalmond": 75,"lightskyblue": 76,
    "lawngreen": 77,"chocolate": 78,"plum": 79,"bisque": 80,"skyblue": 81,
    "chartreuse": 82,"sienna": 83,"orchid": 84,"moccasin": 85,"lightblue": 86,
    "greenyellow": 87,"saddlebrown": 88,"mediumorchid": 89,"navajowhite": 90,
    "powderblue": 91,"lime": 92,"maroon": 93,"darkorchid": 94,"peachpuff": 95,
	"paleturquoise": 96,"limegreen": 97,"darkred": 98,"darkviolet": 99,
    "mistyrose": 100,"lightcyan": 101,"yellowgreen": 102,"brown": 103,
    "darkmagenta": 104,"lavenderblush": 105,"cyan": 106,"darkolivegreen": 107,
	"firebrick": 108,"purple": 109,"seashell": 110,"aqua": 111,"olivedrab": 112,
    "indianred": 113,"indigo": 114,"oldlace": 115,"turquoise": 116,"olive": 117,
    "rosybrown": 118,"darkslateblue": 119,"ivory": 120,"mediumturquoise": 121,
    "darkkhaki": 122,"darksalmon": 123,"blueviolet": 124,"honeydew": 125,
    "darkturquoise": 126,"palegoldenrod": 127,"lightcoral": 128,"mediumpurple": 129,
    "mintcream": 130,"lightseagreen": 131,"cornsilk": 132,"salmon": 133,"slateblue": 134,
    "azure": 135,"cadetblue": 136,"beige": 137,"lightsalmon": 138,"mediumslateblue": 139}],
"katakana":[{u"ブラック": 0,u"アリスブルー": 1,u"ダークシアン": 2,u"ライトイエロー": 3,
	u"コーラル": 4,u"ディムグレイ": 5,u"ラベンダー": 6,u"テール": 7,
	u"ライトゴールデンロッドイエロー": 8,u"トマト": 9,u"グレイ": 10,u"ライトスチールブルー": 11,
	u"ダークステートグレイ": 12,u"レモンシフォン": 13,u"オレンジレッド": 14,u"ダークグレイ": 15,
	u"ライトステートグレイ": 16,u"ダークグリーン": 17,u"ウィート": 18,u"レッド": 19,
	u"シルバー": 20,u"ステートグレイ": 21,u"グリーン": 22,u"バーリーウッド": 23,
	u"クリムゾン": 24,u"ライトグレイ": 25,u"スチールブルー": 26,u"フォレストグリーン": 27,
	u"タン": 28,u"ミディアムバイオレットレッド": 29,u"ゲインズボロー": 30,u"ロイヤルブルー": 31,
	u"シーグリーン": 32,u"カーキー": 33,u"ディープピンク": 34,u"ホワイトスモーク": 35,
	u"ミッドナイトブルー": 36,u"ミディアムシーグリーン": 37,u"イエロー": 38,u"ホットピンク": 39,
	u"ホワイト": 40,u"ネイビー": 41,u"ミディアムアクアマリン": 42,u"ゴールド": 43,
	u"ペールバイオレットレッド": 44,u"スノウ": 45,u"ダークブルー": 46,u"ダークシーグリーン": 47,
	u"オレンジ": 48,u"ピンク": 49,u"ゴーストホワイト": 50,u"ミディアムブルー": 51,
	u"アクアマリン": 52,u"サンディブラウン": 53,u"ライトピンク": 54,u"フローラルホワイト": 55,
	u"ブルー": 56,u"ペールグリーン": 57,u"ダークオレンジ": 58,u"シスル": 59,
	u"リネン": 60,u"ドジャーブルー": 61,u"ライトグリーン": 62,u"ゴールデンロッド": 63,
	u"マゼンダ": 64,u"アンティークホワイト": 65,u"コーンフラワーブルー": 66,u"スプリンググリーン": 67,
	u"ペール": 68,u"フクシャ": 69,u"パパイヤホイップ": 70,u"ディープスカイブルー": 71,
	u"ミディアムスプリンググリーン": 72,u"ダークゴールデンロッド": 73,u"バイオレット": 74,u"ブランチアーモンド": 75,
	u"ライトスカイブルー": 76,u"ラワングリーン": 77,u"チョコレート": 78,u"プラム": 79,
	u"ビスク": 80,u"スカイブルー": 81,u"シャトルーズ": 82,u"シェンナ": 83,
	u"オーキッド": 84,u"モカシン": 85,u"ライトブルー": 86,u"グリーンイエロー": 87,
	u"サドルブラウン": 88,u"ミディアムオーキッド": 89,u"ナバホホワイト": 90,u"パウダーブルー": 91,
	u"ライム": 92,u"マルーン": 93,u"ダークオーキッド": 94,u"ピーチパフ": 95,
	u"ペールターゴイス": 96,u"ライムグリーン": 97,u"ダークレッド": 98,u"ダークバイオレット": 99,
	u"ミスティローズ": 100,u"ライトシアン": 101,u"イエローグリーン": 102,u"ブラウン": 103,
	u"ダークマゼンダ": 104,u"ラベンダーブラシ": 105,u"シアン": 106,u"ダークオリーブグリーン": 107,
	u"ファイアブリック": 108,u"パープル": 109,u"シーシェル": 110,u"アクア": 111,
	u"オリーブドラブ": 112,u"インディアンレッド": 113,u"インディゴ": 114,u"オールドレース": 115,
	u"ターゴイス": 116,u"オリーブ": 117,u"ロージーブラウン": 118,u"ダークステートブルー": 119,
	u"アイボリー": 120,u"ミディアムターゴイス": 121,u"ダークカーキ": 122,u"ダークサーモン": 123,
	u"ブルーバイオレット": 124,u"ハニーデュー": 125,u"ダークターゴイス": 126,u"ペールゴールデンロッド": 127,
	u"ライトコーラル": 128,u"ミディアムパープル": 129,u"ミントクリーム": 130,u"ライトシーグリーン": 131,
	u"コーンシルク": 132,u"サーモン": 133,u"ステートブルー": 134,u"アズール": 135,
	u"カデットブルー": 136,u"ベージュ": 137,u"ライトサーモン": 138,u"ミディアムステートブルー": 139}]
}]
dics["jpTraditional_465_shoku"] = [["7b6c3e","8a3b00","dccb18","683f36","664032",
	"e9e4d4","f3f3f3","eae5e3","74325c","16160e"],{
"hiragana":[{u"こくぼうしょく": 0,u"かっしょく": 1,u"りょくおうしょく": 2,u"せっかっしょく": 3,u"ちゃかっしょく": 4,
	u"かいはくしょく": 5,u"にゅうはくしょく": 6,u"そしょく": 7,u"あんこうしょく": 8,u"あんこくしょく": 9}],
"kanji":[{
	u"国防色": 0,u"褐色": 1,u"緑黄色": 2,u"赤褐色": 3,u"茶褐色": 4,u"灰白色": 5,u"乳白色": 6,
    u"素色": 7,u"暗紅色": 8,u"暗黒色": 9}]
}]
dics["jpTraditional_465_iro"] = [
    ["fef4f4","96514d","006e54","deb068","d3a243","38b48b","bf794e","f6bfbc",
	"bc763c","d0af4c","f5b1aa","efab93","b77b57","767c6b","f2a0a1","cc7eb1",
	"cca6bf","f09199","f4b3c2","eebbcb","a86f4c","946243","5b7e91","c8c2c6",
	"917347","426579","e5abbe","726250","a69abd","9d896c","a89dac","e198b4",
	"94846a","d8a373","95859c","cd5e3c","d6c6af","4d4c61","c97586","c37854",
	"bfa46f","c38743","9e9478","eaedf7","634950","c39143","e8ecef","bf783a",
	"dcd3b2","bce2e8","b55233","a19361","8f8667","abced8","e95295","a0d8ef",
	"e7609e","9f563a","89c3eb","d4dcd6","d0576b","84a2d4","a69425","d3cbc6",
	"e9546b","965042","c8c2be","965036","938b4b","698aab","95483f","008899",
	"00a3af","8f2e14","726d40","8a3319","928c36","59b9c6","887f7a","2ca9e1",
	"d7cf3a","38a1db","c5c56a","d3381c","c3d825","2792c3","8c6450","762f07",
	"e0ebaf","752100","d8e698","6c3524","c7dc68","6f514c","b7282e","4c6cb3",
	"7b8d42","3e62ad","69821b","1e50a2","543f32","554738","b0ca71","f8f4e6",
	"640125","b9d08b","ede4cd","f8b862","839b5c","165e83","f6ad49","cee4ae",
	"ebe1a9","f08300","a8c97f","223a70","fffffc","e4dc8a","ec6d51","f7fcfe",
	"ed6d3d","fbfaf5","a8bf93","ec6800","769164","fff1cf","ee7800","bbc8e6",
	"fddea5","bbbcde","fce2c4","8491c3","fde8d0","eb6101","e49e61","4d5aaf",
	"e45e32","f4dda5","a3a3a2","f1bf99","dd7a56","5654a2","9ea1a3","f1bf99",
	"db8449","efcd9a","68699b","949495","efcd9a","ffd900","867ba9","ffd900",
	"47885e","dbd0e6","7d7d7d","7b7c7d","e0c38c","ffec47","68be8d","7058a3",
	"727171","fef263","f7b977","fcd575","007b43","674196","f19072","fbd26b",
	"9079ad","524e4d","f19072","f5e56b","92b5a9","ee836f","eec362","7ebea5",
	"ebd842","7ebeab","522f60","2b2b2b","383c3c","ffdb4f","fbca4d","3b7960",
	"180614","fcc800","f8b500","000b00","fabf14","475950","bb5548","005243",
	"55295b"],{
"hiragana":[{u"さくらいろ": 0,u"あずきいろ": 1,u"もえぎいろ": 2,u"あめいろ": 3,u"きくちばいろ": 4,
	u"ひすいいろ": 5,u"らくだいろ": 6,u"にじいろ": 7,u"つちいろ": 8,u"からしいろ": 9,
	u"さんごいろ": 10,u"ししいろ": 11,u"はじいろ": 12,u"やまばといろ": 13,u"こうばいいろ": 14,
	u"あやめいろ": 15,u"べにふじいろ": 16,u"ももいろ": 17,u"ときいろ": 18,u"なでしこいろ": 19,
	u"くるみいろ": 20,u"しぶかみいろ": 21,u"ますはないろ": 22,u"かすみいろ": 23,u"くちばいろ": 24,
	u"のしめはないろ": 25,u"せきちくいろ": 26,u"かばちゃいろ": 27,u"はしたいろ": 28,u"うつぶしいろ": 29,
	u"うすいろ": 30,u"ももはないろ": 31,u"なまかべいろ": 32,u"きゃらいろ": 33,u"はとばいろ": 34,
	u"かばいろ": 35,u"あまいろ": 36,u"かちいろ": 37,u"ちょうしゅんいろ": 38,u"かわらけいろ": 39,
	u"はしばみいろ": 40,u"きつねいろ": 41,u"あくいろ": 42,u"しろすみれいろ": 43,u"こきいろ": 44,
	u"おうどいろ": 45,u"しらはないろ": 46,u"こはくいろ": 47,u"すないろ": 48,u"みずいろ": 49,
	u"れんがいろ": 50,u"あぶらいろ": 51,u"りきゅういろ": 52,u"ひそくいろ": 53,u"つつじいろ": 54,
	u"そらいろ": 55,u"ぼたんいろ": 56,u"かきしぶいろ": 57,u"わすれなぐさいろ": 58,u"そばきりいろ": 59,
	u"いまよういろ": 60,u"あおふじいろ": 61,u"なたねゆいろ": 62,u"かれのいろ": 63,u"ばらいろ": 64,
	u"ちゃいろ": 65,u"うるみいろ": 66,u"ひわだいろ": 67,u"ねぎしいろ": 68,u"うすはないろ": 69,
	u"とびいろ": 70,u"なんどいろ": 71,u"あさぎいろ": 72,u"べんがらいろ": 73,u"みるいろ": 74,
	u"あかさびいろ": 75,u"うぐいすいろ": 76,u"しんばしいろ": 77,u"すすいろ": 78,
	u"ひわいろ": 80,u"つゆくさいろ": 81,u"まっちゃいろ": 82,u"ひいろ": 83,u"わかくさいろ": 84,
	u"はなだいろ": 85,u"せんちゃいろ": 86,u"わかめいろ": 88,u"しゃくどういろ": 89,
	u"わかないろ": 90,u"さびいろ": 91,u"わかなえいろ": 92,u"すすたけいろ": 93,u"あかねいろ": 94,
	u"ぐんじょういろ": 95,u"くさいろ": 96,u"かきつばたいろ": 97,u"こけいろ": 98,u"るりいろ": 99,
	u"けんぽういろ": 100,u"くりいろ": 101,u"なえいろ": 102,u"ぞうげいろ": 103,u"えびいろ": 104,
	u"わかばいろ": 105,u"ねりいろ": 106,u"かんぞういろ": 107,u"まつばいろ": 108,u"あいいろ": 109,
	u"こうじいろ": 110,u"なつむしいろ": 111,u"むしぐりいろ": 112,u"みかんいろ": 113,u"やなぎいろ": 114,
	u"こんいろ": 115,u"ごふんいろ": 116,u"かれくさいろ": 117,u"えんたんいろ": 118,u"うのはないろ": 119,
	u"かきいろ": 120,u"きなりいろ": 121,u"わさびいろ": 122,u"にんじんいろ": 123,u"おいたけいろ": 124,
	u"とりのこいろ": 125,u"だいだいいろ": 126,u"あわふじいろ": 127,u"はちみついろ": 128,u"ふじいろ": 129,
	u"はだいろ": 130,u"べにかけそらいろ": 131,u"うすたまごいろ": 132,u"しゅいろ": 133,u"こむぎいろ": 134,
	u"はないろ": 135,u"にいろ": 136,u"とのこいろ": 137,u"うすずみいろ": 138,u"にくいろ": 139,
	u"にっけいいろ": 140,u"ききょういろ": 141,u"すずいろ": 142,u"ひといろ": 143,u"あかくちばいろ": 144,
	u"ちょうじいろ": 145,u"べにかけはないろ": 146,u"ねずみいろ": 147,u"こういろ": 148,u"たんぽぽいろ": 149,
	u"しおんいろ": 150,u"きいろ": 151,u"ろくしょういろ": 152,u"しらふじいろ": 153,u"はいいろ": 154,
	u"なまりいろ": 155,u"かれいろ": 156,u"なのはないろ": 157,u"わかたけいろ": 158,u"すみれいろ": 159,
	u"にびいろ": 160,u"きはだいろ": 161,u"あんずいろ": 162,u"たまごいろ": 163,u"ときわいろ": 164,
	u"しょうぶいろ": 165,u"しののめいろ": 166,u"はなばいろ": 167,u"りんどういろ": 168,u"けしずみいろ": 169,
	u"あけぼのいろ": 170,u"かりやすいろ": 171,u"ちぐさいろ": 172,u"さんごしゅいろ": 173,u"とうもろこしいろ": 174,
	u"せいじいろ": 175,u"かなりあいろ": 176,u"あおたけいろ": 177,u"ぶどういろ": 178,u"ろういろ": 179,
	u"ようかんいろ": 180,u"きくちなしいろ": 181,u"くちなしいろ": 182,u"とくさいろ": 183,u"からすばいろ": 184,
	u"ひまわりいろ": 185,u"やまぶきいろ": 186,u"ぬればいろ": 187,u"うこんいろ": 188,u"かわいろ": 189,
	u"べにかばいろ": 190,u"てついろ": 191,u"くわのみいろ": 192},{u"あまいろ": 79,u"くりいろ": 87}],
"kanji":[{u"桜色": 0,u"小豆色": 1,u"萌葱色": 2,u"飴色": 3,u"黄朽葉色": 4,u"翡翠色": 5,u"駱駝色": 6,
	u"虹色": 7,u"土色": 8,u"芥子色": 9,u"珊瑚色": 10,u"宍色": 11,u"櫨色": 12,u"山鳩色": 13,
	u"紅梅色": 14,u"菖蒲色": 15,u"紅藤色": 16,u"桃色": 17,u"鴇色": 18,u"撫子色": 19,u"胡桃色": 20,
	u"渋紙色": 21,u"舛花色": 22,u"霞色": 23,u"朽葉色": 24,u"熨斗目花色": 25,u"石竹色": 26,u"樺茶色": 27,
	u"半色": 28,u"空五倍子色": 29,u"薄色": 30,u"桃花色": 31,u"生壁色": 32,u"伽羅色": 33,u"鳩羽色": 34,
	u"樺色": 35,u"亜麻色": 36,u"褐色": 37,u"長春色": 38,u"土器色": 39,u"榛色": 40,u"狐色": 41,
	u"灰汁色": 42,u"白菫色": 43,u"濃色": 44,u"黄土色": 45,u"白花色": 46,u"琥珀色": 47,u"砂色": 48,
	u"水色": 49,u"煉瓦色": 50,u"油色": 51,u"利休色": 52,u"秘色色": 53,u"躑躅色": 54,u"空色": 55,
	u"牡丹色": 56,u"柿渋色": 57,u"勿忘草色": 58,u"蕎麦切色": 59,u"今様色": 60,u"青藤色": 61,u"菜種油色": 62,
	u"枯野色": 63,u"薔薇色": 64,u"茶色": 65,u"潤色": 66,u"檜皮色": 67,u"根岸色": 68,u"薄花色": 69,
	u"鳶色": 70,u"納戸色": 71,u"浅葱色": 72,u"弁柄色": 73,u"海松色": 74,u"赤錆色": 75,u"鶯色": 76,
	u"新橋色": 77,u"煤色": 78,u"天色": 79,u"鶸色": 80,u"露草色": 81,u"抹茶色": 82,u"緋色": 83,
	u"若草色": 84,u"縹色": 85,u"煎茶色": 86,u"栗色": 87,u"若芽色": 88,u"赤銅色": 89,u"若菜色": 90,
	u"錆色": 91,u"若苗色": 92,u"煤竹色": 93,u"茜色": 94,u"群青色": 95,u"草色": 96,u"杜若色": 97,
	u"苔色": 98,u"瑠璃色": 99,u"憲法色": 100,u"涅色": 101,u"苗色": 102,u"象牙色": 103,
	u"若葉色": 105,u"練色": 106,u"萱草色": 107,u"松葉色": 108,u"藍色": 109,u"柑子色": 110,u"夏虫色": 111,
	u"蒸栗色": 112,u"蜜柑色": 113,u"柳色": 114,u"紺色": 115,u"胡粉色": 116,u"枯草色": 117,u"鉛丹色": 118,
	u"卯の花色": 119,u"柿色": 120,u"生成り色": 121,u"山葵色": 122,u"人参色": 123,u"老竹色": 124,u"鳥の子色": 125,
	u"橙色": 126,u"淡藤色": 127,u"蜂蜜色": 128,u"藤色": 129,u"肌色": 130,u"紅掛空色": 131,u"薄卵色": 132,
	u"朱色": 133,u"小麦色": 134,u"花色": 135,u"丹色": 136,u"砥粉色": 137,u"薄墨色": 138,u"肉色": 139,
	u"肉桂色": 140,u"桔梗色": 141,u"錫色": 142,u"人色": 143,u"赤朽葉色": 144,u"丁子色": 145,u"紅掛花色": 146,
	u"鼠色": 147,u"香色": 148,u"蒲公英色": 149,u"紫苑色": 150,u"黄色": 151,u"緑青色": 152,u"白藤色": 153,
	u"灰色": 154,u"鉛色": 155,u"枯色": 156,u"菜の花色": 157,u"若竹色": 158,u"菫色": 159,u"鈍色": 160,
	u"黄檗色": 161,u"杏色": 162,u"卵色": 163,u"常磐色": 164,u"東雲色": 166,u"花葉色": 167,
	u"竜胆色": 168,u"消炭色": 169,u"曙色": 170,u"刈安色": 171,u"千草色": 172,u"珊瑚朱色": 173,u"玉蜀黍色": 174,
	u"青磁色": 175,u"金糸雀色": 176,u"青竹色": 177,u"葡萄色": 178,u"蝋色": 179,u"羊羹色": 180,u"黄支子色": 181,
	u"支子色": 182,u"木賊色": 183,u"烏羽色": 184,u"向日葵色": 185,u"山吹色": 186,u"濡羽色": 187,u"鬱金色": 188,
	u"革色": 189,u"紅樺色": 190,u"鉄色": 191,u"桑の実色": 192},{u"菖蒲色": 165},{u"葡萄色": 104}]
}];
dics["jpTraditional_465_cya"] = [
    ["8d6449","c89932","b98c46","8b968d","43676b","5a544b","56564b","1f3134",
	"ae7c4f","555647","ad7e4e","494a41","6b6f59","474b42","956f29","8c7042",
	"e09e87","cd8c5c","716246","a59564","715c1f","bb5535","aa4f37","9f563a",
	"887938","6a5d21","918754","98623c","b3ada0","8c8861","954e2a","a1a46d",
	"b4866b","a16d5d","773c30","783c1d","9f6f55","765c47","6f4b3e","a73836",
	"6d3c32","583822","6c2c2f","f39800","ddbb99","e17b34","474a4d","ca8269",
	"241a08"],{
"hiragana":[{u"やまぶきちゃ": 1,u"まめがらちゃ": 3,u"おめしちゃ": 4,
	u"みるちゃ": 5,u"あいみるちゃ": 6,u"ももしおちゃ": 7,u"びわちゃ": 8,u"あいこびちゃ": 9,
	u"しかんちゃ": 10,u"いわいちゃ": 12,u"せんさいちゃ": 13,u"くわちゃ": 14,
	u"ろこうちゃ": 15,u"ときがらちゃ": 16,u"えどちゃ": 17,u"こびちゃ": 18,u"りきゅうちゃ": 19,
	u"うぐいすちゃ": 20,u"あかちゃ": 21,u"すずめちゃ": 22,u"だんじゅうろうちゃ": 23,u"ばいこうちゃ": 24,
	u"りかんちゃ": 25,u"きみるちゃ": 26,u"はいちゃ": 27,u"りきゅうしろちゃ": 28,u"ひわちゃ": 29,
	u"かきちゃ": 30,u"やなぎちゃ": 31,u"ちょうじちゃ": 32,u"そうでんからちゃ": 33,
	u"からちゃ": 35,u"とのちゃ": 36,u"きがらちゃ": 37,u"こげちゃ": 38,u"べにえびちゃ": 39,
	u"くりかわちゃ": 40,u"くろちゃ": 41,u"えびちゃ": 42,u"きんちゃ": 43,u"しらちゃ": 44,
	u"きちゃ": 45,u"あいすみちゃ": 46,u"えんしゅうちゃ": 47,u"けんぽうくろちゃ": 48},
    {u"からちゃ": 0,u"きがらちゃ": 2,u"せんさいちゃ": 11,u"えびちゃ": 34}],
"kanji":[{u"枯茶": 0,u"山吹茶": 1,u"黄唐茶": 2,u"豆がら茶": 3,u"御召茶": 4,u"海松茶": 5,u"藍海松茶": 6,
	u"百入茶": 7,u"枇杷茶": 8,u"藍媚茶": 9,u"芝翫茶": 10,u"千歳茶": 11,u"岩井茶": 12,u"仙斎茶": 13,
	u"桑茶": 14,u"路考茶": 15,u"ときがら茶": 16,u"江戸茶": 17,u"媚茶": 18,u"利休茶": 19,u"鶯茶": 20,
	u"赤茶": 21,u"雀茶": 22,u"団十郎茶": 23,u"梅幸茶": 24,u"璃寛茶": 25,u"黄海松茶": 26,u"灰茶": 27,
	u"利休白茶": 28,u"鶸茶": 29,u"柿茶": 30,u"柳茶": 31,u"丁子茶": 32,u"宗伝唐茶": 33,u"海老茶": 34,
	u"唐茶": 35,u"砺茶": 36,u"黄枯茶": 37,u"焦茶": 38,u"紅海老茶": 39,u"栗皮茶": 40,u"黒茶": 41,
	u"葡萄茶": 42,u"金茶": 43,u"白茶": 44,u"黄茶": 45,u"藍墨茶": 46,u"遠州茶": 47,u"憲法黒茶": 48}]
}];
dics["jpTraditional_465"] = [
    ["e6b422","895b8a","fdeff2","d9a62e","00a381","824880","e9dfe5","915c8b",
	"e4d2d8","00a497","9d5b8b","80aba9","7a4171","5c9291","bc64a4","f5b199",
	"b79b5b","6e7955","478384","b44c97","aa4c8f","b68d4c","888e7e","80989b",
	"f0908d","ad7d4c","2c4f54","ee827c","ad7d4c","c4a3bf","47585c","e7e7eb",
	"485859","dcd6d9","ae7c58","6c848d","d3cfd9","e8d3c7","53727d","d3ccd6",
	"e8d3d1","333631","e6cde3","5b6356","a6a5c4","4c6473","e597b2","455765",
	"44617b","9790a4","e4ab9b","897858","393f4c","9e8b8e","393e4f","d69090",
	"cbb994","203744","95949a","d4acad","cb8347","71686c","eaf4fc","705b67",
	"c099a0","b88884","5f414b","b48a76","ebf6f7","4f455c","a86965","c7b370",
	"c1e4e9","5a5359","a25768","bb5520","594255","ec6d71","a2d7dd","524748",
	"eb6ea5","513743","e6eae3","9a493f","d4dcda","c85179","83ccd2","ada250",
	"84b9cb","e95464","c85554","a99e93","c53d43","a58f86","e83929","2a83a2",
	"928178","e60033","e2041b","d7003a","852e19","b28c6e","c9171e","7b4741",
	"0095d9","0094c8","ce5242","b8d200","d9333f","007bbb","856859","b94047",
	"5383c3","ba2636","ba2636","5a79ba","99ab4e","544a47","9e3d3f","a22041",
	"aacf53","507ea4","a22041","19448e","433d3c","164a84","432f2f","3f312b",
	"274a78","302833","82ae46","2a4073","ffffff","f2f2b0","9ba88d","192f60",
	"f8e58c","ee7948","c8d5bb","1c305c","f8fbf8","c1d8ac","0f2350","d7a98c",
	"ec6800","17184b","f2c9ac","0d0015","f3f3f2","d6e9ca","eb6238","93ca76",
	"e5e4e6","ea5506","93b881","dcdddd","ea5506","badcad","8491c3","dddcd6",
	"f9c89b","97a791","4d5aaf","c0c6c9","f7bd8f","98d98e","afafb0","f6b894",
	"88cb7f","4a488e","adadad","69b076","4d4398","6b7b6e","bed2c3","706caa",
	"9fa0a0","d66a35","93b69c","a6c8b2","888084","f0cfa0","edd3a1","ffea00",
	"316745","a59aca","f3bf88","3eb370","674598","595857","595455","bed3ca",
	"745399","65318e","eb9b6f","e0815e","028760","493759","2b2b2b","df7163",
	"2e2930","d57c6b","2f5d50","884898","281a14","d0826c","3a5b52","c0a2c7",
	"460e44","250d00","f7c114","00552e","ab6953","e6b422"],{
"hiragana":[{u"こがね": 0,u"こだいむらさき": 1,u"うすざくら": 2,u"はじぞめ": 3,u"はなろくしょう": 4,
	u"なすこん": 5,u"さくらねず": 6,u"ふたあい": 7,u"ときねず": 8,u"あおみどり": 9,
	u"きょうむらさき": 10,u"みずあさぎ": 11,u"えびぞめ": 12,u"さびあさぎ": 13,u"わかむらさき": 14,
	u"いっこんぞめ": 15,u"くわぞめ": 16,u"きくじん": 17,u"せいへき": 18,u"べにむらさき": 19,
	u"うめむらさき": 20,u"きつるばみ": 21,u"りきゅうねずみ": 22,u"みなとねずみ": 23,u"うすべに": 24,
	u"ちょうじぞめ": 25,u"こうらいなんど": 26,u"じんざもみ": 27,u"こうぞめ": 28,u"あさむらさき": 29,
	u"さびねず": 30,u"むらさきすいしょう": 31,u"さびてつおなんど": 32,u"うすうめねず": 33,u"こがれこう": 34,
	u"あいねず": 35,u"あかつきねず": 36,u"はいうめ": 37,u"さびおなんど": 38,u"ぼたんねず": 39,
	u"はいざくら": 40,u"くろみどり": 41,u"あわべにふじ": 42,u"やなぎすすたけ": 43,u"ふじねず": 44,
	u"おめしおなんど": 45,u"うすこうばい": 46,u"てつおなんど": 47,u"こんねず": 48,u"うすねず": 49,
	u"みずがき": 50,u"ひごすすたけ": 51,u"あいてつ": 52,u"はとばねずみ": 53,u"あおかち": 54,
	u"あらぞめ": 55,u"しろつるばみ": 56,u"かちかえし": 57,u"ききょうねず": 58,u"うすがき": 59,
	u"べにうこん": 60,u"むらさきねず": 61,u"げっぱく": 62,u"ぶどうねずみ": 63,u"うめねず": 64,
	u"ときあさぎ": 65,u"むらさきとび": 66,u"うめぞめ": 67,u"あいじろ": 68,u"こいねず": 69,
	u"すおうこう": 70,u"もくらんじき": 71,u"しらあい": 72,u"ふじすすたけ": 73,u"あさすおう": 74,
	u"たいしゃ": 75,u"けしむらさき": 76,u"まそお": 77,u"かめのぞき": 78,u"べにけしねずみ": 79,
	u"あかむらさき": 80,u"にせむらさき": 81,u"はいきみどり": 82,u"べにとび": 83,u"うすくもねず": 84,
	u"なかべに": 85,u"びゃくぐん": 86,u"あおくちば": 87,u"あさはなだ": 88,u"からくれない": 89,
	u"ぎんしゅ": 90,u"ちゃねずみ": 91,u"あかべに": 92,u"くるみぞめ": 93,u"べにひ": 94,
	u"はなあさぎ": 95,u"えどねず": 96,u"あか": 97,u"しょうじょうひ": 98,u"くれない": 99,
	u"くりうめ": 100,u"ふしぞめ": 101,u"こきひ": 102,u"べにひはだ": 103,u"あお": 104,
	u"うすあい": 105,u"あかに": 106,u"きみどり": 107,u"べにあか": 108,u"こんぺき": 109,
	u"ぎんすすだけ": 110,u"えんじ": 111,u"うすぐんじょう": 112,u"あけ": 113,u"あけ": 114,
	u"うすはなざくら": 115,u"あおに": 116,u"くろつるばみ": 117,u"すおう": 118,u"しんく": 119,
	u"もえぎ": 120,u"うすはなだ": 121,u"こいくれない": 122,u"るりこん": 123,u"びんろうじぞめ": 124,
	u"こんるり": 125,u"くろとび": 126,u"あかすみ": 127,u"せいらん": 128,u"くろべに": 129,
	u"ひわもえぎ": 130,u"こきはなだ": 131,u"しろ": 132,u"おみなえし": 133,u"あおしろつるばみ": 134,
	u"こんじょう": 135,u"たんこう": 136,u"おうに": 137,u"やなぎねず": 138,u"とめこん": 139,
	u"はくじ": 140,u"うらはやなぎ": 141,u"こいあい": 142,u"あかしろつるばみ": 143,u"きあか": 144,
	u"てつこん": 145,u"あらいがき": 146,u"しっこく": 147,u"しろねり": 148,u"びゃくろく": 149,
	u"てりがき": 150,u"しらうめねず": 152,u"あかだいだい": 153,u"やなぎぞめ": 154,
	u"しろねず": 155,u"きんあか": 156,u"うすもえぎ": 157,u"べにみどり": 158,u"きぬねず": 159,
	u"ゆうおう": 160,u"ふかがわねずみ": 161,u"こんききょう": 162,u"はいあお": 163,u"しゃれがき": 164,
	u"わかみどり": 165,u"ぎんねず": 166,u"あかこう": 167,u"あさみどり": 168,u"こんあい": 169,
	u"うすにび": 170,u"うすみどり": 171,u"べにききょう": 172,u"あおにび": 173,u"せいじねず": 174,
	u"ふじなんど": 175,u"すねずみ": 176,u"こうろぜん": 177,u"うすあお": 178,u"さびせいじ": 179,
	u"げんじねず": 180,u"うすき": 182,u"ちゅうき": 183,u"ちとせみどり": 184,
	u"ふじむらさき": 185,u"うすこう": 186,u"みどり": 187,u"あおむらさき": 188,u"すみ": 189,
	u"どぶねずみ": 190,u"ちぐさねず": 191,u"えどむらさき": 192,u"ほんむらさき": 193,u"こきくちなし": 194,
	u"そひ": 195,u"ときわみどり": 196,u"ふかむらさき": 197,u"くろ": 198,u"うすきひ": 199,
	u"しこく": 200,u"まそほ": 201,u"びろうど": 202,u"むらさき": 203,u"てつぐろ": 204,
	u"あらいしゅ": 205,u"むしあお": 206,u"うすぶどう": 207,u"しこん": 208,u"こくたん": 209,
	u"とうおう": 210,u"ふかみどり": 211,u"そほ": 212,u"こんじき": 213},
    {u"うすもえぎ": 151,u"うすこう": 181}],
"kanji":[{u"黄金": 0,u"古代紫": 1,u"薄桜": 2,u"櫨染": 3,u"花緑青": 4,u"茄子紺": 5,u"桜鼠": 6,
	u"二藍": 7,u"鴇鼠": 8,u"青緑": 9,u"京紫": 10,u"水浅葱": 11,u"蒲葡": 12,u"錆浅葱": 13,
	u"若紫": 14,u"一斤染": 15,u"桑染": 16,u"麹塵": 17,u"青碧": 18,u"紅紫": 19,u"梅紫": 20,
	u"黄橡": 21,u"利休鼠": 22,u"湊鼠": 23,u"薄紅": 24,u"丁字染": 25,u"高麗納戸": 26,u"甚三紅": 27,
	u"香染": 28,u"浅紫": 29,u"錆鼠": 30,u"紫水晶": 31,u"錆鉄御納戸": 32,u"薄梅鼠": 33,u"焦香": 34,
	u"藍鼠": 35,u"暁鼠": 36,u"灰梅": 37,u"錆御納戸": 38,u"牡丹鼠": 39,u"灰桜": 40,u"黒緑": 41,
	u"淡紅藤": 42,u"柳煤竹": 43,u"藤鼠": 44,u"御召御納戸": 45,u"薄紅梅": 46,u"鉄御納戸": 47,u"紺鼠": 48,
	u"薄鼠": 49,u"水柿": 50,u"肥後煤竹": 51,u"藍鉄": 52,u"鳩羽鼠": 53,u"青褐": 54,u"退紅": 55,
	u"白橡": 56,u"褐返": 57,u"桔梗鼠": 58,u"薄柿": 59,u"紅鬱金": 60,u"紫鼠": 61,u"月白": 62,
	u"葡萄鼠": 63,u"梅鼠": 64,u"鴇浅葱": 65,u"紫鳶": 66,u"梅染": 67,u"藍白": 68,u"濃鼠": 69,
	u"蘇芳香": 70,u"木蘭色": 71,u"白藍": 72,u"藤煤竹": 73,u"浅蘇芳": 74,u"代赭": 75,u"滅紫": 76,
	u"真朱": 77,u"瓶覗": 78,u"紅消鼠": 79,u"赤紫": 80,u"似せ紫": 81,u"灰黄緑": 82,u"紅鳶": 83,
	u"薄雲鼠": 84,u"中紅": 85,u"白群": 86,u"青朽葉": 87,u"浅縹": 88,u"韓紅": 89,u"銀朱": 90,
	u"茶鼠": 91,u"赤紅": 92,u"胡桃染": 93,u"紅緋": 94,u"花浅葱": 95,u"江戸鼠": 96,u"赤": 97,
	u"猩々緋": 98,u"紅": 99,u"栗梅": 100,u"柴染": 101,u"深緋": 102,u"紅檜皮": 103,u"青": 104,
	u"薄藍": 105,u"赤丹": 106,u"黄緑": 107,u"紅赤": 108,u"紺碧": 109,u"銀煤竹": 110,u"臙脂": 111,
	u"薄群青": 112,u"緋": 113,u"朱": 114,u"薄花桜": 115,u"青丹": 116,u"黒橡": 117,u"蘇芳": 118,
	u"真紅": 119,u"萌黄": 120,u"薄縹": 121,u"濃紅": 122,u"瑠璃紺": 123,u"檳榔子染": 124,u"紺瑠璃": 125,
	u"黒鳶": 126,u"赤墨": 127,u"青藍": 128,u"黒紅": 129,u"鶸萌黄": 130,u"深縹": 131,u"白": 132,
	u"女郎花": 133,u"青白橡": 134,u"紺青": 135,u"淡黄": 136,u"黄丹": 137,u"柳鼠": 138,u"留紺": 139,
	u"白磁": 140,u"裏葉柳": 141,u"濃藍": 142,u"赤白橡": 143,u"黄赤": 144,u"鉄紺": 145,u"洗柿": 146,
	u"漆黒": 147,u"白練": 148,u"白緑": 149,u"照柿": 150,u"淡萌黄": 151,u"白梅鼠": 152,u"赤橙": 153,
	u"柳染": 154,u"白鼠": 155,u"金赤": 156,u"薄萌葱": 157,u"紅碧": 158,u"絹鼠": 159,u"雄黄": 160,
	u"深川鼠": 161,u"紺桔梗": 162,u"灰青": 163,u"洒落柿": 164,u"若緑": 165,u"銀鼠": 166,u"赤香": 167,
	u"浅緑": 168,u"紺藍": 169,u"薄鈍": 170,u"薄緑": 171,u"紅桔梗": 172,u"青鈍": 173,u"青磁鼠": 174,
	u"藤納戸": 175,u"素鼠": 176,u"黄櫨染": 177,u"薄青": 178,u"錆青磁": 179,u"源氏鼠": 180,u"薄香": 181,
	u"浅黄": 182,u"中黄": 183,u"千歳緑": 184,u"藤紫": 185,u"淡香": 186,u"緑": 187,u"青紫": 188,
	u"墨": 189,u"丼鼠": 190,u"千草鼠": 191,u"江戸紫": 192,u"本紫": 193,u"深支子": 194,u"纁": 195,
	u"常磐緑": 196,u"深紫": 197,u"黒": 198,u"浅緋": 199,u"紫黒": 200,u"真赭": 201,u"天鵞絨": 202,
	u"紫": 203,u"鉄黒": 204,u"洗朱": 205,u"虫襖": 206,u"薄葡萄": 207,u"紫紺": 208,u"黒壇": 209,
	u"藤黄": 210,u"深緑": 211,u"赭": 212,u"金色": 213}]
}]

def getColorCode(name, strict=False):
    if not strict:
        ret = getColorCode(name, True)
        if ret:
            return ret
		#looseな対処
        if re.search(r'\w' ,name):
            return ""
        ret = getColorCode(name + u"色", True)
        if ret:
            return ret
        ret = getColorCode(name + u"茶", True)
        if ret:
            return ret
        ret = getColorCode(name + u"ちゃ", True)
        if ret:
            return ret
        ret = getColorCode(name + u"しょく", True)
        if ret:
            return ret
        ret = getColorCode(name + u"いろ", True)
        if ret:
            return ret
        
        return ""

    if not name:
        return ""

    for i in dics:
        dic = dics[i]
        cats = dic[1]
        for j in cats: #category
            cat = cats[j]
            for k in cat: #array each
                if k.has_key(name):
                    n = k[name]
                    return "#" + dic[0][n]
    return ""

if '__main__' == __name__:
    print '= colors selftest ='
    tests = [
                [u'darkcyan',     '#008b8b'],
                [u'テール',        '#008080'],
                [u"りょくおうしょく",   '#dccb18'],
                [u"暗黒色",        '#16160e'],
                [u"らくだいろ",      '#bf794e'],
                [u"あまいろ",       '#d6c6af'],
                [u"肌色",         '#fce2c4'],
                [u"葡萄色",        '#522f60'],
                [u"えどちゃ",       '#cd8c5c'],
                [u"からちゃ",       '#783c1d'],
                [u"遠州茶",        '#ca8269'],
                [u"さびてつおなんど", '#485859'],
                [u"赭",           '#ab6953']
            ]
    for t in tests:
        name    = t[0]
        correct = t[1]
        res     = getColorCode( name )
        str = name + ': '
        if correct == res:
            print str + ' -> OK.'
        else: 
            print str + ' -> NG.'
    print '= end ='