# Issue 41 - Inconsistency in broadcasting behaviour leads to occasional crashes

def test_issue041():
  from pygeode.axis import Lat
  lat1 = Lat([-89.312782, -88.422554, -87.527069, -86.630394, -85.733276, -84.83593, -83.938469, -83.040932, -82.143341, -81.24572, -80.348076, -79.450409, -78.552734, -77.655045, -76.757347, -75.859634, -74.961929, -74.064209, -73.166489, -72.268768, -71.37104, -70.473312, -69.575577, -68.677841, -67.780106, -66.88237, -65.984634, -65.086891, -64.189156, -63.291412, -62.393669, -61.49593, -60.598183, -59.700439, -58.802696, -57.904949, -57.007202, -56.109459, -55.211712, -54.313965, -53.416218, -52.518467, -51.62072, -50.722973, -49.825222, -48.927475, -48.029724, -47.131973, -46.234226, -45.336475, -44.438725, -43.540974, -42.643227, -41.745476, -40.847725, -39.949974, -39.052223, -38.154472, -37.256721, -36.358971, -35.461216, -34.563465, -33.665714, -32.767963, -31.870213, -30.97246, -30.074709, -29.176956, -28.279203, -27.381453, -26.4837, -25.585949, -24.688196, -23.790443, -22.892691, -21.99494, -21.097187, -20.199434, -19.301682, -18.403931, -17.506178, -16.608425, -15.710672, -14.81292, -13.915167, -13.017414, -12.119662, -11.22191, -10.324157, -9.426404, -8.5286512, -7.6308985, -6.7331457, -5.835393, -4.9376402, -4.0398874, -3.1421347, -2.2443819, -1.3466291, -0.44887638, 0.44887638, 1.3466291, 2.2443819, 3.1421347, 4.0398874, 4.9376402, 5.835393, 6.7331457, 7.6308985, 8.5286512, 9.426404, 10.324157, 11.22191, 12.119662, 13.017414, 13.915167, 14.81292, 15.710672, 16.608425, 17.506178, 18.403931, 19.301682, 20.199434, 21.097187, 21.99494, 22.892691, 23.790443, 24.688196, 25.585949, 26.4837, 27.381453, 28.279203, 29.176956, 30.074709, 30.97246, 31.870213, 32.767963, 33.665714, 34.563465, 35.461216, 36.358971, 37.256721, 38.154472, 39.052223, 39.949974, 40.847725, 41.745476, 42.643227, 43.540974, 44.438725, 45.336475, 46.234226, 47.131973, 48.029724, 48.927475, 49.825222, 50.722973, 51.62072, 52.518467, 53.416218, 54.313965, 55.211712, 56.109459, 57.007202, 57.904949, 58.802696, 59.700439, 60.598183, 61.49593, 62.393669, 63.291412, 64.189156, 65.086891, 65.984634, 66.88237, 67.780106, 68.677841, 69.575577, 70.473312, 71.37104, 72.268768, 73.166489, 74.064209, 74.961929, 75.859634, 76.757347, 77.655045, 78.552734, 79.450409, 80.348076, 81.24572, 82.143341, 83.040932, 83.938469, 84.83593, 85.733276, 86.630394, 87.527069, 88.422554, 89.312782])

  lat2 = Lat([-89.312729, -88.422562, -87.5271, -86.630417, -85.733269, -84.83593, -83.938477, -83.040947, -82.143349, -81.245728, -80.348076, -79.450424, -78.552734, -77.655045, -76.757347, -75.859642, -74.961922, -74.064217, -73.166489, -72.268768, -71.371048, -70.473312, -69.575584, -68.677849, -67.780121, -66.882385, -65.984642, -65.086906, -64.189156, -63.291428, -62.393681, -61.495934, -60.598186, -59.700439, -58.802692, -57.904949, -57.007202, -56.109455, -55.211723, -54.313976, -53.416229, -52.518471, -51.620724, -50.722977, -49.82523, -48.927471, -48.029724, -47.131977, -46.23423, -45.336483, -44.43874, -43.540977, -42.64323, -41.745472, -40.847725, -39.949978, -39.052219, -38.154472, -37.256725, -36.358978, -35.46122, -34.563473, -33.665726, -32.767967, -31.87022, -30.97246, -30.074713, -29.176968, -28.279207, -27.38146, -26.4837, -25.585955, -24.688194, -23.790447, -22.892694, -21.994942, -21.097187, -20.199442, -19.301687, -18.403929, -17.506182, -16.608421, -15.710675, -14.812915, -13.915169, -13.017415, -12.119669, -11.221909, -10.324162, -9.4264088, -8.528656, -7.6308961, -6.7331495, -5.8353963, -4.9376431, -4.0398898, -3.1421297, -2.2443833, -1.3466369, -0.44887677, 0.44886965, 1.3466365, 2.2443829, 3.1421294, 4.0398893, 4.9376426, 5.8353958, 6.7331491, 7.6308956, 8.528656, 9.4264088, 10.324156, 11.221909, 12.119662, 13.017415, 13.915169, 14.812915, 15.710675, 16.608421, 17.506182, 18.403927, 19.301682, 20.199434, 21.097187, 21.99494, 22.892687, 23.790447, 24.6882, 25.585953, 26.483707, 27.381453, 28.279207, 29.17696, 30.074707, 30.97246, 31.87022, 32.767963, 33.665718, 34.563469, 35.461216, 36.358971, 37.256721, 38.154469, 39.052219, 39.94997, 40.847725, 41.745476, 42.643227, 43.540977, 44.438732, 45.336475, 46.23423, 47.131981, 48.029728, 48.927475, 49.825222, 50.722973, 51.620724, 52.518471, 53.416222, 54.313969, 55.211716, 56.109459, 57.007206, 57.904949, 58.802696, 59.700439, 60.59819, 61.49593, 62.393677, 63.291424, 64.189156, 65.086899, 65.984634, 66.882378, 67.780121, 68.677849, 69.575584, 70.473312, 71.371048, 72.268776, 73.166489, 74.064217, 74.961922, 75.859634, 76.757347, 77.655037, 78.552734, 79.450417, 80.348076, 81.24572, 82.143349, 83.040939, 83.938477, 84.83593, 85.733269, 86.630409, 87.527092, 88.422562, 89.312721])

  # Verify that the latitudes *don't* map properly.
  try:
    data = lat1*lat2
    # Whoops, that shouldn't have worked!
    raise Exception ("Broadcasted something that shouldn't have been broadcasted!")
  except ValueError: pass # Didn't work (that's good!)

