/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.sikuli.basics.Debug;
import org.sikuli.guide.GlobalMouseMotionListener;
import org.sikuli.guide.GlobalMouseMotionTracker;
import org.sikuli.guide.Guide;
import org.sikuli.guide.SxAnchor;
import org.sikuli.guide.SxCircle;
import org.sikuli.guide.SxClickable;
import org.sikuli.guide.SxFlag;
import org.sikuli.guide.SxImage;
import org.sikuli.guide.Transition;
import org.sikuli.guide.Visual;
import org.sikuli.script.Env;
import org.sikuli.script.Location;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;

public class SxMagnet
implements Transition,
GlobalMouseMotionListener {
    Guide guide;
    GlobalMouseMotionTracker mouseTracker;
    private SxClickable lastClickedClickable;
    ArrayList<SxAnchor> targets = new ArrayList();
    ArrayList<Link> links = new ArrayList();
    SxCircle selection;
    int anchoredCount = 0;
    Transition.TransitionListener token;

    public SxMagnet(Guide guide) {
        this.guide = guide;
        this.mouseTracker = GlobalMouseMotionTracker.getInstance();
        this.mouseTracker.addListener(this);
        guide.addComponent(new SxClickable(), 0);
    }

    void attractTarget(SxAnchor a, Point targetLocation) {
        try {
            Pattern pattern = a.getPattern();
            SxImage img = new SxImage(pattern.getBImage());
            SxClickable clickable = new SxClickable();
            clickable.setLocationRelativeToComponent(img, Visual.Layout.OVER);
            this.guide.addToFront(clickable);
            clickable.clickPoint = a.getCenter();
            Link link = new Link();
            link.image = img;
            link.anchor = a;
            this.links.add(link);
            img.setShadowDefault();
            img.setActualLocation(a.getActualLocation());
            Dimension currentSize = a.getActualSize();
            Dimension targetSize = new Dimension(currentSize);
            targetSize.width = (int)((double)targetSize.width * 1.5);
            targetSize.height = (int)((double)targetSize.height * 1.5);
            img.addResizeAnimation(currentSize, targetSize);
            Point currentLocation = new Point(a.getActualLocation());
            targetLocation.x -= targetSize.width / 2;
            targetLocation.y -= targetSize.height / 2;
            img.addMoveAnimation(currentLocation, targetLocation);
            this.guide.addToFront(img);
            img.startAnimation();
            this.guide.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void allTargetAnchored() {
        double theta = 0.0;
        double dtheta = Math.PI * 2 / (double)this.targets.size();
        Location mouseLocation = Env.getMouseLocation();
        int x = mouseLocation.x;
        int y = mouseLocation.y;
        int radius = 50;
        Region r = new Region(mouseLocation.x - radius, mouseLocation.y - radius, radius * 2, radius * 2);
        SxCircle c = new SxCircle(r);
        this.guide.addToFront(c);
        this.selection = new SxCircle();
        this.guide.addToFront(this.selection);
        Collections.sort(this.targets, new Comparator<SxAnchor>(){

            @Override
            public int compare(SxAnchor a, SxAnchor b) {
                return b.getX() - a.getX();
            }
        });
        for (SxAnchor target : this.targets) {
            int px = (int)((double)x + (double)radius * Math.cos(theta));
            int py = (int)((double)y + (double)radius * Math.sin(theta));
            theta += dtheta;
            this.attractTarget(target, new Point(px, py));
        }
    }

    public void addTarget(Pattern pattern) {
        SxAnchor a = new SxAnchor(pattern);
        this.guide.addToFront(a);
        this.targets.add(a);
        SxFlag f = new SxFlag("Flag");
        f.setLocationRelativeToComponent(a, Visual.Layout.LEFT);
        this.guide.addToFront(f);
        a.addListener(new SxAnchor.AnchorListener(){

            @Override
            public void anchored() {
                Debug.info("[Magnet] pattern anchored", new Object[0]);
                ++SxMagnet.this.anchoredCount;
                if (SxMagnet.this.anchoredCount == SxMagnet.this.targets.size()) {
                    SxMagnet.this.allTargetAnchored();
                }
            }

            @Override
            public void found(SxAnchor source) {
            }
        });
    }

    @Override
    public String waitForTransition(Transition.TransitionListener token) {
        this.token = token;
        this.mouseTracker.start();
        return "Next";
    }

    @Override
    public void globalMouseMoved(int x, int y) {
        Point p = new Point(x, y);
        for (Link link : this.links) {
            if (!link.image.getActualBounds().contains(p) || this.selection == null) continue;
            this.selection.setMargin(5, 5, 5, 5);
            this.selection.setLocationRelativeToComponent(link.anchor, Visual.Layout.OVER);
            this.guide.repaint();
        }
    }

    @Override
    public void globalMouseIdled(int x, int y) {
    }

    class Link {
        SxImage image;
        SxAnchor anchor;

        Link() {
        }
    }
}

