#!/usr/bin/python
# -*- coding: utf-8 -*-

import gpxpy
from gpxpy.geo import get_line_equation_coefficients as get_cof
import datetime

def add_time_to_seg(seg):
	for i, pt in enumerate(seg.points):
		if pt.time == None:
			pt.time = seg.points[i - 1].time + datetime.timedelta(seconds=10)
def add_time_to_trk(trk):
	for seg in trk.segments:
		add_time_to_seg(seg)

#若四點連線相交，則傳回交點，若無，則傳回False
def iscross(pa1, pa2, pb1, pb2):
	cofs_a = get_cof(pa1, pa2)
	cofs_b = get_cof(pb1, pb2)
	is_a1 = pa1.latitude * cofs_b[0] + pa1.longitude * cofs_b[1] + cofs_b[2]
	is_a2 = pa2.latitude * cofs_b[0] + pa2.longitude * cofs_b[1] + cofs_b[2]
	is_b1 = pb1.latitude * cofs_a[0] + pb1.longitude * cofs_a[1] + cofs_a[2]
	is_b2 = pb2.latitude * cofs_a[0] + pb2.longitude * cofs_a[1] + cofs_a[2]
	if is_a1 * is_a2 <= 0 and is_b1 * is_b2 <= 0:
		try:
			long = (cofs_a[0] * cofs_b[2] - cofs_a[2] * cofs_b[0]) / (cofs_a[1] * cofs_b[0] - cofs_a[0] * cofs_b[1])
			long = float('%.6f' % long)
			lati = (-cofs_a[1] * long - cofs_a[2]) / cofs_a[0]
			lati = float('%.6f' % lati)
			return gpxpy.gpx.GPXTrackPoint(lati, long)
		except: print("線段斜率相同", pa1, "to", pa2, pb1, "to", pb2)
	else: 
		return False

#取得兩航段的所有交點
def getsegcross(sa, sb, limit=None):
	nodes = []
	for i in range(len(sa.points) - 1):
		pa1 = sa.points[i]
		pa2 = sa.points[i + 1]
		for j in range(len(sb.points) - 1):
			pb1 = sb.points[j]
			pb2 = sb.points[j + 1]
			if iscross(pa1, pa2, pb1, pb2):
				nodes.append(iscross(pa1, pa2, pb1, pb2))
				if limit != None and len(nodes) > limit:
					return tuple(nodes)
	if nodes: 
		return tuple(nodes)
	else: 
		return False		
		
#取得兩航跡的所有交點
def gettrackcross(ta, tb):
	nodes = []
	for seg_a in ta.segments:
		for seg_b in tb.segments:
			if getsegcross(seg_a, seg_b):
				nodes += getsegcross(seg_a, seg_b)
	if nodes:
		return nodes
	else:
		return False

def is_pt_equal(pt1, pt2):
	if pt1.latitude == pt2.latitude and pt1.longitude == pt2.longitude:
		return True
	else: return False		

#複製航段，時間差參考原航段，可設定開始時間
def clone_seg(seg, time_start=None):
	seg2 = seg.clone()
	if time_start == None:
		return seg2
	time_deltas = []
	for i, pt in enumerate(seg.points[:-1], 0):
		time_deltas.append(seg.points[i + 1].time - pt.time)
	seg2.remove_time()		
	
	seg2.points[0].time = time_start
	for i, time_delta in enumerate(time_deltas, 1):
		seg2.points[i].time = seg2.points[i - 1].time + time_delta
	return seg2
	
#複製航段並將方向顚倒，時間差參考原航段，可設定開始時間
def reverse_seg(seg, time_start=None):
	seg2 = gpxpy.gpx.GPXTrackSegment()
	seg2.points = seg.clone().points[::-1]
	time_deltas = []
	for i, pt in enumerate(seg.points[:-1], 0):
		time_deltas.insert(0, seg.points[i + 1].time - pt.time)
	seg2.remove_time()
	time_start = seg.clone().points[0].time if time_start == None else time_start
	
	seg2.points[0].time = time_start
	for i, time_delta in enumerate(time_deltas, 1):
		seg2.points[i].time = seg2.points[i - 1].time + time_delta
	return seg2

#取得該航段的折返航段，時間差參考原航段，可設定開始時間
def run_suicide(seg, reverse=False, time_start=None):
	seg = reverse_seg(seg) if reverse else seg.clone()
	seg1 = clone_seg(seg, time_start)
	seg.points = seg.points[:-1]
	time_for_reverse = seg1.points[-1].time + (seg1.points[-1].time - seg1.points[-2].time)
	seg2 = reverse_seg(seg, time_for_reverse)
	seg1.join(seg2)
	return seg1

#將新點加入航段中，並對新點賦予時間
def addnodes(seg, ns):
	for i, pt in enumerate(seg.points[1:], 0):
		cofs = get_cof(seg.points[i], seg.points[i + 1])
		for j, n in enumerate(ns, 1):
			if abs(n.latitude * cofs[0] + n.longitude * cofs[1] + cofs[2]) < 0.000001 and not is_pt_equal(n, seg.points[i]) and not is_pt_equal(n, seg.points[i + 1]):
				try:
					time_dif = datetime.timedelta(seconds = seg.points[i].time_difference(seg.points[i + 1]))
				except:
					time_dif = datetime.timedelta(seconds = 10)
				ratio = seg.points[i].distance_2d(n) / seg.points[i].distance_2d(seg.points[i + 1])
				seg.points.insert(i + 1, gpxpy.gpx.GPXTrackPoint(n.latitude, n.longitude))
				seg.points[i + 1].time = seg.points[i].time
				seg.points[i + 1].adjust_time(time_dif * ratio)		
	return seg

#結合兩航段
def combine_segs(s1, s2):
	sa = s1.clone()
	sb = s2.clone()
	(sa, sb) = (sb, sa) if sa.get_points_no() < sb.get_points_no() else (sa, sb)
	cross_nodes = getsegcross(sa, sb, limit=10)
	if not cross_nodes:
		print("航段未相交")
		return False
	sa = addnodes(sa, cross_nodes)
	sb = addnodes(sb, cross_nodes)
	sa1, sa2, sb1, sb2 = None, None, None, None
	for pa, i in sa.walk():
		if is_pt_equal(pa, cross_nodes[-1]):
			sa1, sa2 = sa.split(i)
	for pb, i in sb.walk():
		if is_pt_equal(pb, cross_nodes[-1]):
			sb1, sb2 = sb.split(i)
	time_delta_1 = sb2.points[0].time - sb1.points[-1].time
	time_delta_2 = sa2.points[0].time - sa1.points[-1].time
	
	sa1.join(run_suicide(sb2, time_start=sa1.points[-1].time + time_delta_1))
	sa1.join(run_suicide(sb1, reverse=True, time_start=sa1.points[-1].time + time_delta_1))
	sa1.join(clone_seg(sa2, sa1.points[-1].time + time_delta_2))
	return sa1
