import os 
import gpxpy

def makefile(gpx, gpx_name=""):
	from tkinter import Tk
	from tkinter.filedialog import asksaveasfilename
	Tk().withdraw()
	filename = asksaveasfilename(initialdir = os.getcwd(), initialfile = gpx_name + "_new.gpx", defaultextension=".gpx")
	
	with open(filename, "w", encoding="utf-8") as f:
		
		#印出<xml>標籤
		f.write('<?xml version="1.0" encoding="UTF-8" standalone="no" ?>\n')
		f.write('<gpx xmlns="http://www.topografix.com/GPX/1/1" creator="MapSource 6.10.2" version="1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd">\n\n')
		
		#印出<metadata>標籤
		f.write('\t<metadata>\n')
		f.write('\t\t<link href="http://www.garmin.com">\n')
		f.write('\t\t\t<text>Garmin International</text>\n')
		f.write('\t\t</link>\n')
		f.write('\t</metadata>\n\n')
		
		content = ""
		for waypoint in gpx.waypoints:
			content += waypoint.to_xml()
		for route in gpx.routes:
			content += route.to_xml()			
		for track in gpx.tracks:
			text = track.to_xml().replace("<type/>\n", "").replace("<desc/>\n", "")
			content += text
		content += ("</gpx>")
		f.write(content)
	return True