# -*- coding: utf-8 -*-

################################################################
# zopyx.plone.smashdocs
# (C) 2016,  Andreas Jung, www.zopyx.com, Tuebingen, Germany
################################################################


from zope import schema
from zope.interface import implements
from plone.dexterity.content import Container
from plone.supermodel import model

from .i18n import MessageFactory as _


class ISmashDocument(model.Schema):

    creator_id = schema.TextLine(
        title=_(u'Smashdocs creator id'),
        default=None,
        readonly=True,
        required=False
    )

    document_id = schema.TextLine(
        title=_(u'Smashdocs document id'),
        default=None,
        readonly=True,
        required=False
    )

    group_id = schema.TextLine(
        title=_(u'Smashdocs group id'),
        default=u'default',
        required=False
    )


class SmashDocument(Container):
    implements(ISmashDocument)
