# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RepairTaskUpdateHealthPolicyDescription(Model):
    """Describes a request to update the health policy of a repair task.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.
    .

    :param task_id: The ID of the repair task to be updated.
    :type task_id: str
    :param version: The current version number of the repair task. If
     non-zero, then the request will only succeed if this value matches the
     actual current value of the repair task. If zero, then no version check is
     performed.
    :type version: str
    :param perform_preparing_health_check: A boolean indicating if health
     check is to be performed in the Preparing stage of the repair task. If not
     specified the existing value should not be altered. Otherwise, specify the
     desired new value.
    :type perform_preparing_health_check: bool
    :param perform_restoring_health_check: A boolean indicating if health
     check is to be performed in the Restoring stage of the repair task. If not
     specified the existing value should not be altered. Otherwise, specify the
     desired new value.
    :type perform_restoring_health_check: bool
    """

    _validation = {
        'task_id': {'required': True},
    }

    _attribute_map = {
        'task_id': {'key': 'TaskId', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'perform_preparing_health_check': {'key': 'PerformPreparingHealthCheck', 'type': 'bool'},
        'perform_restoring_health_check': {'key': 'PerformRestoringHealthCheck', 'type': 'bool'},
    }

    def __init__(self, task_id, version=None, perform_preparing_health_check=None, perform_restoring_health_check=None):
        super(RepairTaskUpdateHealthPolicyDescription, self).__init__()
        self.task_id = task_id
        self.version = version
        self.perform_preparing_health_check = perform_preparing_health_check
        self.perform_restoring_health_check = perform_restoring_health_check
