# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RepairTaskHistory(Model):
    """A record of the times when the repair task entered each state.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.
    .

    :param created_utc_timestamp: The time when the repair task entered the
     Created state.
    :type created_utc_timestamp: datetime
    :param claimed_utc_timestamp: The time when the repair task entered the
     Claimed state.
    :type claimed_utc_timestamp: datetime
    :param preparing_utc_timestamp: The time when the repair task entered the
     Preparing state.
    :type preparing_utc_timestamp: datetime
    :param approved_utc_timestamp: The time when the repair task entered the
     Approved state
    :type approved_utc_timestamp: datetime
    :param executing_utc_timestamp: The time when the repair task entered the
     Executing state
    :type executing_utc_timestamp: datetime
    :param restoring_utc_timestamp: The time when the repair task entered the
     Restoring state
    :type restoring_utc_timestamp: datetime
    :param completed_utc_timestamp: The time when the repair task entered the
     Completed state
    :type completed_utc_timestamp: datetime
    :param preparing_health_check_start_utc_timestamp: The time when the
     repair task started the health check in the Preparing state.
    :type preparing_health_check_start_utc_timestamp: datetime
    :param preparing_health_check_end_utc_timestamp: The time when the repair
     task completed the health check in the Preparing state.
    :type preparing_health_check_end_utc_timestamp: datetime
    :param restoring_health_check_start_utc_timestamp: The time when the
     repair task started the health check in the Restoring state.
    :type restoring_health_check_start_utc_timestamp: datetime
    :param restoring_health_check_end_utc_timestamp: The time when the repair
     task completed the health check in the Restoring state.
    :type restoring_health_check_end_utc_timestamp: datetime
    """

    _attribute_map = {
        'created_utc_timestamp': {'key': 'CreatedUtcTimestamp', 'type': 'iso-8601'},
        'claimed_utc_timestamp': {'key': 'ClaimedUtcTimestamp', 'type': 'iso-8601'},
        'preparing_utc_timestamp': {'key': 'PreparingUtcTimestamp', 'type': 'iso-8601'},
        'approved_utc_timestamp': {'key': 'ApprovedUtcTimestamp', 'type': 'iso-8601'},
        'executing_utc_timestamp': {'key': 'ExecutingUtcTimestamp', 'type': 'iso-8601'},
        'restoring_utc_timestamp': {'key': 'RestoringUtcTimestamp', 'type': 'iso-8601'},
        'completed_utc_timestamp': {'key': 'CompletedUtcTimestamp', 'type': 'iso-8601'},
        'preparing_health_check_start_utc_timestamp': {'key': 'PreparingHealthCheckStartUtcTimestamp', 'type': 'iso-8601'},
        'preparing_health_check_end_utc_timestamp': {'key': 'PreparingHealthCheckEndUtcTimestamp', 'type': 'iso-8601'},
        'restoring_health_check_start_utc_timestamp': {'key': 'RestoringHealthCheckStartUtcTimestamp', 'type': 'iso-8601'},
        'restoring_health_check_end_utc_timestamp': {'key': 'RestoringHealthCheckEndUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, created_utc_timestamp=None, claimed_utc_timestamp=None, preparing_utc_timestamp=None, approved_utc_timestamp=None, executing_utc_timestamp=None, restoring_utc_timestamp=None, completed_utc_timestamp=None, preparing_health_check_start_utc_timestamp=None, preparing_health_check_end_utc_timestamp=None, restoring_health_check_start_utc_timestamp=None, restoring_health_check_end_utc_timestamp=None):
        super(RepairTaskHistory, self).__init__()
        self.created_utc_timestamp = created_utc_timestamp
        self.claimed_utc_timestamp = claimed_utc_timestamp
        self.preparing_utc_timestamp = preparing_utc_timestamp
        self.approved_utc_timestamp = approved_utc_timestamp
        self.executing_utc_timestamp = executing_utc_timestamp
        self.restoring_utc_timestamp = restoring_utc_timestamp
        self.completed_utc_timestamp = completed_utc_timestamp
        self.preparing_health_check_start_utc_timestamp = preparing_health_check_start_utc_timestamp
        self.preparing_health_check_end_utc_timestamp = preparing_health_check_end_utc_timestamp
        self.restoring_health_check_start_utc_timestamp = restoring_health_check_start_utc_timestamp
        self.restoring_health_check_end_utc_timestamp = restoring_health_check_end_utc_timestamp
