"""
    MoinMoin - rTorrent Scripting / Configuration Parser
  
    Copyright (c) 2011 The PyroScope Project <pyroscope.project@gmail.com>
    @license: GNU GPL.
"""
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

from MoinMoin.parser._ParserBase import ParserBase

Dependencies = ['user']

class Parser(ParserBase):

    parsername = "rtorrent.rc"
    extensions = ['.rc',]
    Dependencies = Dependencies

    def setupRules(self):
        ParserBase.setupRules(self)

        self.addRule("Comment","^ *#.*$")

        path_chars = r"[-~a-zA-Z0-9_./]+"
        self.addRule("String", '/'.join([path_chars]*2)) # a file system path
        self.addRule("Char", r'[$]')
        self.addRule("Number", r"[0-9]+[kKmMgG]?")
        self.addRule("ID", "[a-z_][0-9a-z_.]*=?")
        self.addRule("SPChar", r'(?:\\?[(){}"\\]|[,=\\])')

        self.addConstant([
            "argument.0",
            "argument.1",
            "argument.2",
            "argument.3",
            "event.download.closed",
            "event.download.erased",
            "event.download.finished",
            "event.download.hash_done",
            "event.download.hash_failed",
            "event.download.hash_final_failed",
            "event.download.hash_queued",
            "event.download.hash_removed",
            "event.download.inserted",
            "event.download.inserted_new",
            "event.download.inserted_session",
            "event.download.opened",
            "event.download.paused",
            "event.download.resumed",
            "simple",
            "private",
            "value",
        ])

        reserved = [
            "d.save_session",
            "max_open_sockets",
            "max_open_files",
            "umask",

            "system.get_cwd",
            "system.set_cwd",
            "system.set_umask",
            "set_max_open_sockets",
            "set_key_layout",
            "on_close",
            "on_erase",
            "on_finished",
            "on_hash_queued",
            "on_hash_removed",
            "on_insert",
            "on_open",
            "on_start",
            "on_stop",
            "get_safe_free_diskspace",
            "get_key_layout",
            "enable_trackers",
            "d.set_peer_exchange",
            "d.add_peer",
            "call_download",

            "system.listMethods",
            "system.methodExist",
            "system.methodHelp",
            "system.methodSignature",
            "system.multicall",
            "system.shutdown",
            "system.capabilities",
            "system.getCapabilities",
            "add_peer",
            "and",
            "bind",
            "branch",
            "cat",
            "check_hash",
            "close_low_diskspace",
            "close_untied",
            "connection_leech",
            "connection_seed",
            "convert.date",
            "convert.elapsed_time",
            "convert.gm_date",
            "convert.gm_time",
            "convert.kb",
            "convert.mb",
            "convert.throttle",
            "convert.time",
            "convert.xb",
            "create_link",
            "d.base_filename",
            "d.base_path",
            "d.bitfield",
            "d.bytes_done",
            "d.check_hash",
            "d.chunk_size",
            "d.chunks_hashed",
            "d.close",
            "d.complete",
            "d.completed_bytes",
            "d.completed_chunks",
            "d.connection_current",
            "d.connection_current.set",
            "d.connection_leech",
            "d.connection_seed",
            "d.create_link",
            "d.creation_date",
            "d.custom",
            "d.custom.set",
            "d.custom1",
            "d.custom1.set",
            "d.custom2",
            "d.custom2.set",
            "d.custom3",
            "d.custom3.set",
            "d.custom4",
            "d.custom4.set",
            "d.custom5",
            "d.custom5.set",
            "d.custom_throw",
            "d.delete_link",
            "d.delete_tied",
            "d.directory",
            "d.directory.set",
            "d.directory_base",
            "d.directory_base.set",
            "d.down.rate",
            "d.down.total",
            "d.erase",
            "d.free_diskspace",
            "d.get_base_filename",
            "d.get_base_path",
            "d.get_bitfield",
            "d.get_bytes_done",
            "d.get_chunk_size",
            "d.get_chunks_hashed",
            "d.get_complete",
            "d.get_completed_bytes",
            "d.get_completed_chunks",
            "d.get_connection_current",
            "d.get_connection_leech",
            "d.get_connection_seed",
            "d.get_creation_date",
            "d.get_custom",
            "d.get_custom1",
            "d.get_custom2",
            "d.get_custom3",
            "d.get_custom4",
            "d.get_custom5",
            "d.get_custom_throw",
            "d.get_directory",
            "d.get_directory_base",
            "d.get_down_rate",
            "d.get_down_total",
            "d.get_free_diskspace",
            "d.get_hash",
            "d.get_hashing",
            "d.get_hashing_failed",
            "d.get_ignore_commands",
            "d.get_left_bytes",
            "d.get_loaded_file",
            "d.get_local_id",
            "d.get_local_id_html",
            "d.get_max_file_size",
            "d.get_max_size_pex",
            "d.get_message",
            "d.get_mode",
            "d.get_name",
            "d.get_peer_exchange",
            "d.get_peers_accounted",
            "d.get_peers_complete",
            "d.get_peers_connected",
            "d.get_peers_max",
            "d.get_peers_min",
            "d.get_peers_not_connected",
            "d.get_priority",
            "d.get_priority_str",
            "d.get_ratio",
            "d.get_size_bytes",
            "d.get_size_chunks",
            "d.get_size_files",
            "d.get_size_pex",
            "d.get_skip_rate",
            "d.get_skip_total",
            "d.get_state",
            "d.get_state_changed",
            "d.get_state_counter",
            "d.get_throttle_name",
            "d.get_tied_to_file",
            "d.get_tracker_focus",
            "d.get_tracker_numwant",
            "d.get_tracker_size",
            "d.get_up_rate",
            "d.get_up_total",
            "d.get_uploads_max",
            "d.hash",
            "d.hashing",
            "d.hashing_failed",
            "d.hashing_failed.set",
            "d.ignore_commands",
            "d.ignore_commands.set",
            "d.initialize_logs",
            "d.is_active",
            "d.is_hash_checked",
            "d.is_hash_checking",
            "d.is_multi_file",
            "d.is_open",
            "d.is_pex_active",
            "d.is_private",
            "d.left_bytes",
            "d.load_date",
            "d.loaded_file",
            "d.local_id",
            "d.local_id_html",
            "d.max_file_size",
            "d.max_file_size.set",
            "d.max_size_pex",
            "d.message",
            "d.message.set",
            "d.mode",
            "d.multicall",
            "d.multicall2",
            "d.name",
            "d.open",
            "d.pause",
            "d.peer_exchange",
            "d.peer_exchange.set",
            "d.peers_accounted",
            "d.peers_complete",
            "d.peers_connected",
            "d.peers_max",
            "d.peers_max.set",
            "d.peers_min",
            "d.peers_min.set",
            "d.peers_not_connected",
            "d.priority",
            "d.priority.set",
            "d.priority_str",
            "d.ratio",
            "d.resume",
            "d.save_full_session",
            "d.save_resume",
            "d.set_connection_current",
            "d.set_custom",
            "d.set_custom1",
            "d.set_custom2",
            "d.set_custom3",
            "d.set_custom4",
            "d.set_custom5",
            "d.set_directory",
            "d.set_directory_base",
            "d.set_hashing_failed",
            "d.set_ignore_commands",
            "d.set_max_file_size",
            "d.set_message",
            "d.set_peers_max",
            "d.set_peers_min",
            "d.set_priority",
            "d.set_throttle_name",
            "d.set_tied_to_file",
            "d.set_tracker_numwant",
            "d.set_uploads_max",
            "d.size_bytes",
            "d.size_chunks",
            "d.size_files",
            "d.size_pex",
            "d.skip.rate",
            "d.skip.total",
            "d.start",
            "d.state",
            "d.state_changed",
            "d.state_counter",
            "d.stop",
            "d.throttle_name",
            "d.throttle_name.set",
            "d.tied_to_file",
            "d.tied_to_file.set",
            "d.tracker_focus",
            "d.tracker_numwant",
            "d.tracker_numwant.set",
            "d.tracker_size",
            "d.try_close",
            "d.try_start",
            "d.try_stop",
            "d.up.rate",
            "d.up.total",
            "d.update_priorities",
            "d.uploads_max",
            "d.uploads_max.set",
            "d.views",
            "d.views.has",
            "d.views.push_back",
            "d.views.push_back_unique",
            "d.views.remove",
            "delete_link",
            "delete_tied",
            "dht",
            "dht.add_node",
            "dht.mode.set",
            "dht.port",
            "dht.port.set",
            "dht.statistics",
            "dht.throttle.name",
            "dht.throttle.name.set",
            "dht_add_node",
            "dht_port",
            "dht_statistics",
            "directory",
            "directory.default",
            "directory.default.set",
            "download_list",
            "download_rate",
            "encoding.add",
            "encoding_list",
            "encryption",
            "equal",
            "execute",
            "execute.capture",
            "execute.capture_nothrow",
            "execute.nothrow",
            "execute.raw",
            "execute.raw_nothrow",
            "execute.throw",
            "execute2",
            "execute_capture",
            "execute_capture_nothrow",
            "execute_nothrow",
            "execute_raw",
            "execute_raw_nothrow",
            "execute_throw",
            "f.completed_chunks",
            "f.frozen_path",
            "f.get_completed_chunks",
            "f.get_frozen_path",
            "f.get_last_touched",
            "f.get_match_depth_next",
            "f.get_match_depth_prev",
            "f.get_offset",
            "f.get_path",
            "f.get_path_components",
            "f.get_path_depth",
            "f.get_priority",
            "f.get_range_first",
            "f.get_range_second",
            "f.get_size_bytes",
            "f.get_size_chunks",
            "f.is_create_queued",
            "f.is_created",
            "f.is_open",
            "f.is_resize_queued",
            "f.last_touched",
            "f.match_depth_next",
            "f.match_depth_prev",
            "f.multicall",
            "f.offset",
            "f.path",
            "f.path_components",
            "f.path_depth",
            "f.priority",
            "f.priority.set",
            "f.range_first",
            "f.range_second",
            "f.set_create_queued",
            "f.set_priority",
            "f.set_resize_queued",
            "f.size_bytes",
            "f.size_chunks",
            "f.unset_create_queued",
            "f.unset_resize_queued",
            "false",
            "fi.filename_last",
            "fi.get_filename_last",
            "fi.is_file",
            "get_bind",
            "get_check_hash",
            "get_connection_leech",
            "get_connection_seed",
            "get_dht_port",
            "get_dht_throttle",
            "get_directory",
            "get_down_rate",
            "get_down_total",
            "get_download_rate",
            "get_handshake_log",
            "get_hash_interval",
            "get_hash_max_tries",
            "get_hash_read_ahead",
            "get_http_cacert",
            "get_http_capath",
            "get_http_proxy",
            "get_ip",
            "get_log.tracker",
            "get_max_downloads_div",
            "get_max_downloads_global",
            "get_max_file_size",
            "get_max_memory_usage",
            "get_max_open_files",
            "get_max_open_http",
            "get_max_open_sockets",
            "get_max_peers",
            "get_max_peers_seed",
            "get_max_uploads",
            "get_max_uploads_div",
            "get_max_uploads_global",
            "get_memory_usage",
            "get_min_peers",
            "get_min_peers_seed",
            "get_name",
            "get_peer_exchange",
            "get_port_open",
            "get_port_random",
            "get_port_range",
            "get_preload_min_size",
            "get_preload_required_rate",
            "get_preload_type",
            "get_proxy_address",
            "get_receive_buffer_size",
            "get_safe_sync",
            "get_scgi_dont_route",
            "get_send_buffer_size",
            "get_session",
            "get_session_lock",
            "get_session_on_completion",
            "get_split_file_size",
            "get_split_suffix",
            "get_stats_not_preloaded",
            "get_stats_preloaded",
            "get_throttle_down_max",
            "get_throttle_down_rate",
            "get_throttle_up_max",
            "get_throttle_up_rate",
            "get_timeout_safe_sync",
            "get_timeout_sync",
            "get_tracker_numwant",
            "get_up_rate",
            "get_up_total",
            "get_upload_rate",
            "get_use_udp_trackers",
            "get_xmlrpc_size_limit",
            "greater",
            "group.insert",
            "group.insert_persistent_view",
            "group.seeding.ratio.command",
            "group.seeding.ratio.disable",
            "group.seeding.ratio.enable",
            "group.seeding.ratio.max",
            "group.seeding.ratio.max.set",
            "group.seeding.ratio.min",
            "group.seeding.ratio.min.set",
            "group.seeding.ratio.upload",
            "group.seeding.ratio.upload.set",
            "group.seeding.view",
            "group.seeding.view.set",
            "group2.seeding.ratio.max",
            "group2.seeding.ratio.max.set",
            "group2.seeding.ratio.min",
            "group2.seeding.ratio.min.set",
            "group2.seeding.ratio.upload",
            "group2.seeding.ratio.upload.set",
            "group2.seeding.view",
            "group2.seeding.view.set",
            "hash_interval",
            "hash_max_tries",
            "hash_read_ahead",
            "http_cacert",
            "http_capath",
            "http_proxy",
            "if",
            "import",
            "ip",
            "key_layout",
            "keys.layout",
            "keys.layout.set",
            "less",
            "load",
            "load.normal",
            "load.raw",
            "load.raw_start",
            "load.raw_verbose",
            "load.start",
            "load.start_verbose",
            "load.verbose",
            "load_raw",
            "load_raw_start",
            "load_raw_verbose",
            "load_start",
            "load_start_verbose",
            "load_verbose",
            "log.execute",
            "log.handshake",
            "log.handshake.set",
            "log.tracker",
            "log.tracker.set",
            "log.vmmap.dump",
            "log.xmlrpc",
            "max_downloads_div",
            "max_downloads_global",
            "max_memory_usage",
            "max_peers",
            "max_peers_seed",
            "max_uploads",
            "max_uploads_div",
            "max_uploads_global",
            "method.erase",
            "method.get",
            "method.has_key",
            "method.insert",
            "method.insert.c_simple",
            "method.insert.s_c_simple",
            "method.insert.simple",
            "method.insert.value",
            "method.list_keys",
            "method.redirect",
            "method.set",
            "method.set_key",
            "method.use_deprecated",
            "method.use_deprecated.set",
            "method.use_intermediate",
            "method.use_intermediate.set",
            "min_peers",
            "min_peers_seed",
            "network.bind_address",
            "network.bind_address.set",
            "network.http.cacert",
            "network.http.cacert.set",
            "network.http.capath",
            "network.http.capath.set",
            "network.http.max_open",
            "network.http.max_open.set",
            "network.http.proxy_address",
            "network.http.proxy_address.set",
            "network.local_address",
            "network.local_address.set",
            "network.max_open_files",
            "network.max_open_files.set",
            "network.max_open_sockets",
            "network.max_open_sockets.set",
            "network.port_open",
            "network.port_open.set",
            "network.port_random",
            "network.port_random.set",
            "network.port_range",
            "network.port_range.set",
            "network.proxy_address",
            "network.proxy_address.set",
            "network.receive_buffer.size",
            "network.receive_buffer.size.set",
            "network.scgi.dont_route",
            "network.scgi.dont_route.set",
            "network.scgi.open_local",
            "network.scgi.open_port",
            "network.send_buffer.size",
            "network.send_buffer.size.set",
            "network.tos.set",
            "network.xmlrpc.dialect.set",
            "network.xmlrpc.size_limit",
            "network.xmlrpc.size_limit.set",
            "not",
            "on_ratio",
            "or",
            "p.address",
            "p.banned",
            "p.banned.set",
            "p.call_target",
            "p.client_version",
            "p.completed_percent",
            "p.disconnect",
            "p.disconnect_delayed",
            "p.down_rate",
            "p.down_total",
            "p.get_address",
            "p.get_client_version",
            "p.get_completed_percent",
            "p.get_down_rate",
            "p.get_down_total",
            "p.get_id",
            "p.get_id_html",
            "p.get_options_str",
            "p.get_peer_rate",
            "p.get_peer_total",
            "p.get_port",
            "p.get_up_rate",
            "p.get_up_total",
            "p.id",
            "p.id_html",
            "p.is_encrypted",
            "p.is_incoming",
            "p.is_obfuscated",
            "p.is_snubbed",
            "p.multicall",
            "p.options_str",
            "p.peer_rate",
            "p.peer_total",
            "p.port",
            "p.snubbed",
            "p.snubbed.set",
            "p.up_rate",
            "p.up_total",
            "peer_exchange",
            "pieces.hash.on_completion",
            "pieces.hash.on_completion.set",
            "pieces.memory.current",
            "pieces.memory.max",
            "pieces.memory.max.set",
            "pieces.preload.min_rate",
            "pieces.preload.min_rate.set",
            "pieces.preload.min_size",
            "pieces.preload.min_size.set",
            "pieces.preload.type",
            "pieces.preload.type.set",
            "pieces.stats_not_preloaded",
            "pieces.stats_preloaded",
            "pieces.sync.always_safe",
            "pieces.sync.always_safe.set",
            "pieces.sync.safe_free_diskspace",
            "pieces.sync.timeout",
            "pieces.sync.timeout.set",
            "pieces.sync.timeout_safe",
            "pieces.sync.timeout_safe.set",
            "port_open",
            "port_random",
            "port_range",
            "print",
            "protocol.connection.leech",
            "protocol.connection.leech.set",
            "protocol.connection.seed",
            "protocol.connection.seed.set",
            "protocol.encryption.set",
            "protocol.pex",
            "protocol.pex.set",
            "proxy_address",
            "ratio.disable",
            "ratio.enable",
            "ratio.max",
            "ratio.max.set",
            "ratio.min",
            "ratio.min.set",
            "ratio.upload",
            "ratio.upload.set",
            "remove_untied",
            "scgi_dont_route",
            "scgi_local",
            "scgi_port",
            "schedule",
            "schedule2",
            "schedule_remove",
            "schedule_remove2",
            "scheduler.max_active",
            "scheduler.max_active.set",
            "scheduler.simple.added",
            "scheduler.simple.removed",
            "scheduler.simple.update",
            "session",
            "session.name",
            "session.name.set",
            "session.on_completion",
            "session.on_completion.set",
            "session.path",
            "session.path.set",
            "session.save",
            "session.use_lock",
            "session.use_lock.set",
            "session_save",
            "set_bind",
            "set_check_hash",
            "set_connection_leech",
            "set_connection_seed",
            "set_dht_port",
            "set_dht_throttle",
            "set_directory",
            "set_download_rate",
            "set_handshake_log",
            "set_hash_interval",
            "set_hash_max_tries",
            "set_hash_read_ahead",
            "set_http_cacert",
            "set_http_capath",
            "set_http_proxy",
            "set_ip",
            "set_log.tracker",
            "set_max_downloads_div",
            "set_max_downloads_global",
            "set_max_file_size",
            "set_max_memory_usage",
            "set_max_open_files",
            "set_max_open_http",
            "set_max_peers",
            "set_max_peers_seed",
            "set_max_uploads",
            "set_max_uploads_div",
            "set_max_uploads_global",
            "set_min_peers",
            "set_min_peers_seed",
            "set_name",
            "set_peer_exchange",
            "set_port_open",
            "set_port_random",
            "set_port_range",
            "set_preload_min_size",
            "set_preload_required_rate",
            "set_preload_type",
            "set_proxy_address",
            "set_receive_buffer_size",
            "set_safe_sync",
            "set_scgi_dont_route",
            "set_send_buffer_size",
            "set_session",
            "set_session_lock",
            "set_session_on_completion",
            "set_split_file_size",
            "set_split_suffix",
            "set_timeout_safe_sync",
            "set_timeout_sync",
            "set_tracker_numwant",
            "set_upload_rate",
            "set_use_udp_trackers",
            "set_xmlrpc_dialect",
            "set_xmlrpc_size_limit",
            "start_tied",
            "stop_untied",
            "system.client_version",
            "system.cwd",
            "system.cwd.set",
            "system.file.allocate",
            "system.file.allocate.set",
            "system.file.max_size",
            "system.file.max_size.set",
            "system.file.split_size",
            "system.file.split_size.set",
            "system.file.split_suffix",
            "system.file.split_suffix.set",
            "system.file_allocate",
            "system.file_allocate.set",
            "system.file_status_cache.prune",
            "system.file_status_cache.size",
            "system.files.closed_counter",
            "system.files.failed_counter",
            "system.files.opened_counter",
            "system.hash.interval",
            "system.hash.interval.set",
            "system.hash.max_tries",
            "system.hash.max_tries.set",
            "system.hash.read_ahead",
            "system.hash.read_ahead.set",
            "system.hostname",
            "system.library_version",
            "system.method.erase",
            "system.method.get",
            "system.method.has_key",
            "system.method.insert",
            "system.method.list_keys",
            "system.method.set",
            "system.method.set_key",
            "system.pid",
            "system.time",
            "system.time_seconds",
            "system.time_usec",
            "system.umask.set",
            "t.disable",
            "t.enable",
            "t.get_group",
            "t.get_id",
            "t.get_min_interval",
            "t.get_normal_interval",
            "t.get_scrape_complete",
            "t.get_scrape_downloaded",
            "t.get_scrape_incomplete",
            "t.get_scrape_time_last",
            "t.get_type",
            "t.get_url",
            "t.group",
            "t.id",
            "t.is_enabled",
            "t.is_enabled.set",
            "t.is_open",
            "t.min_interval",
            "t.multicall",
            "t.normal_interval",
            "t.scrape_complete",
            "t.scrape_downloaded",
            "t.scrape_incomplete",
            "t.scrape_time_last",
            "t.set_enabled",
            "t.type",
            "t.url",
            "test.method.simple",
            "test.thread_locking",
            "throttle.down",
            "throttle.down.max",
            "throttle.down.rate",
            "throttle.global_down.max_rate",
            "throttle.global_down.max_rate.set",
            "throttle.global_down.max_rate.set_kb",
            "throttle.global_down.rate",
            "throttle.global_down.total",
            "throttle.global_up.max_rate",
            "throttle.global_up.max_rate.set",
            "throttle.global_up.max_rate.set_kb",
            "throttle.global_up.rate",
            "throttle.global_up.total",
            "throttle.ip",
            "throttle.max_downloads.div",
            "throttle.max_downloads.div.set",
            "throttle.max_downloads.global",
            "throttle.max_downloads.global.set",
            "throttle.max_peers.normal",
            "throttle.max_peers.normal.set",
            "throttle.max_peers.seed",
            "throttle.max_peers.seed.set",
            "throttle.max_uploads",
            "throttle.max_uploads.div",
            "throttle.max_uploads.div.set",
            "throttle.max_uploads.global",
            "throttle.max_uploads.global.set",
            "throttle.max_uploads.set",
            "throttle.min_peers.normal",
            "throttle.min_peers.normal.set",
            "throttle.min_peers.seed",
            "throttle.min_peers.seed.set",
            "throttle.unchoked_downloads",
            "throttle.unchoked_uploads",
            "throttle.up",
            "throttle.up.max",
            "throttle.up.rate",
            "throttle_down",
            "throttle_ip",
            "throttle_up",
            "to_date",
            "to_elapsed_time",
            "to_gm_date",
            "to_gm_time",
            "to_kb",
            "to_mb",
            "to_throttle",
            "to_time",
            "to_xb",
            "tracker_numwant",
            "trackers.disable",
            "trackers.enable",
            "trackers.numwant",
            "trackers.numwant.set",
            "trackers.use_udp",
            "trackers.use_udp.set",
            "try_import",
            "ui.current_view.set",
            "ui.unfocus_download",
            "upload_rate",
            "use_udp_trackers",
            "view.add",
            "view.event_added",
            "view.event_removed",
            "view.filter",
            "view.filter_download",
            "view.filter_on",
            "view.list",
            "view.persistent",
            "view.set",
            "view.set_not_visible",
            "view.set_visible",
            "view.size",
            "view.size_not_visible",
            "view.sort",
            "view.sort_current",
            "view.sort_new",
            "view_add",
            "view_filter",
            "view_filter_on",
            "view_list",
            "view_set",
            "view_sort",
            "view_sort_current",
            "view_sort_new",
            "xmlrpc_dialect",
            "xmlrpc_size_limit",

            # 0.8.7 => 0.8.8
            "d.down.choke_heuristics",
            "d.down.choke_heuristics.leech",
            "d.down.choke_heuristics.seed",
            "d.down.choke_heuristics.set",
            "d.group",
            "d.group.set",
            "d.up.choke_heuristics",
            "d.up.choke_heuristics.leech",
            "d.up.choke_heuristics.seed",
            "d.up.choke_heuristics.set",
            "file.append",
            "ip_tables.add_address",
            "ip_tables.get",
            "ip_tables.insert_table",
            "ipv4_filter.add_address",
            "ipv4_filter.get",
            "ipv4_filter.load",
            "ipv4_filter.size_data",
            "log.libtorrent",
            "network.http.ssl_verify_peer",
            "network.http.ssl_verify_peer.set",
            "network.open_sockets",
            "p.is_preferred",
            "p.is_unwanted",
            "pieces.hash.queue_size",
            "pieces.memory.block_count",
            "pieces.memory.sync_queue",
            "pieces.stats.total_size",
            "pieces.sync.queue_size",
            "protocol.choke_heuristics.down.leech",
            "protocol.choke_heuristics.down.leech.set",
            "protocol.choke_heuristics.down.seed",
            "protocol.choke_heuristics.down.seed.set",
            "protocol.choke_heuristics.up.leech",
            "protocol.choke_heuristics.up.leech.set",
            "protocol.choke_heuristics.up.seed",
            "protocol.choke_heuristics.up.seed.set",
            "view.filter_all",
        ]
        self.addReserved([i+'=' for i in reserved] + reserved)

