# Copyright (c) 2004 gocept. All rights reserved.
# See also LICENSE.txt
# $Id: config.py 236779 2011-04-01 05:51:02Z nilo $

PROJECTNAME = "ATCountryWidget"
SKINS_DIR = 'skins'
GLOBALS = globals()
INSTALL_DEMO_TYPE = False

COUNTRIES = {
    'AF':'Afghanistan',
    'AL':'Albania',
    'DZ':'Algeria ',
    'AS':'American Samoa',
    'AD':'Andorra ',
    'AO':'Angola',
    'AI':'Anguilla',
    'AQ':'Antarctica',
    'AG':'Antigua And Barbuda ',
    'AR':'Argentina ',
    'AM':'Armenia ',
    'AW':'Aruba ',
    'AU':'Australia ',
    'AT':'Austria ',
    'AZ':'Azerbaijan',
    'BS':'Bahamas ',
    'BH':'Bahrain ',
    'BD':'Bangladesh',
    'BB':'Barbados',
    'BY':'Belarus ',
    'BE':'Belgium ',
    'BZ':'Belize',
    'BJ':'Benin ',
    'BM':'Bermuda ',
    'BT':'Bhutan',
    'BO':'Bolivia ',
    'BA':'Bosnia And Herzegowina',
    'BW':'Botswana',
    'BV':'Bouvet Island ',
    'BR':'Brazil',
    'IO':'British Indian Ocean Territory',
    'BN':'Brunei Darussalam ',
    'BG':'Bulgaria',
    'BF':'Burkina Faso',
    'BI':'Burundi ',
    'KH':'Cambodia',
    'CM':'Cameroon',
    'CA':'Canada',
    'CV':'Cape Verde',
    'KY':'Cayman Islands',
    'CF':'Central African Republic',
    'TD':'Chad',
    'CL':'Chile ',
    'CN':'China ',
    'CX':'Christmas Island',
    'CC':'Cocos (Keeling) Islands ',
    'CO':'Colombia',
    'KM':'Comoros ',
    'CD':'Congo, Democratic Republic Of (Was Zaire) ',
    'CG':'Congo, People\'s Republic Of ',
    'CK':'Cook Islands',
    'CR':'Costa Rica',
    'CI':'Cote D\'ivoire ',
    'HR':'Croatia (Local Name: Hrvatska)',
    'CU':'Cuba',
    'CY':'Cyprus',
    'CZ':'Czech Republic',
    'DK':'Denmark ',
    'DJ':'Djibouti',
    'DM':'Dominica',
    'DO':'Dominican Republic',
    'EC':'Ecuador ',
    'EG':'Egypt ',
    'SV':'El Salvador ',
    'GQ':'Equatorial Guinea ',
    'ER':'Eritrea ',
    'EE':'Estonia ',
    'ET':'Ethiopia',
    'FK':'Falkland Islands (Malvinas) ',
    'FO':'Faroe Islands ',
    'FJ':'Fiji',
    'FI':'Finland ',
    'FR':'France',
    'FX':'France, Metropolitan',
    'GF':'French Guiana ',
    'PF':'French Polynesia',
    'TF':'French Southern Territories ',
    'GA':'Gabon ',
    'GM':'Gambia',
    'GE':'Georgia ',
    'DE':'Germany ',
    'GH':'Ghana ',
    'GI':'Gibraltar ',
    'GR':'Greece',
    'GL':'Greenland ',
    'GD':'Grenada ',
    'GP':'Guadeloupe',
    'GU':'Guam',
    'GT':'Guatemala ',
    'GN':'Guinea',
    'GW':'Guinea-Bissau ',
    'GY':'Guyana',
    'HT':'Haiti ',
    'HM':'Heard And Mc Donald Islands ',
    'HN':'Honduras',
    'HK':'Hong Kong ',
    'HU':'Hungary ',
    'IS':'Iceland ',
    'IN':'India ',
    'ID':'Indonesia ',
    'IR':'Iran (Islamic Republic Of)',
    'IQ':'Iraq',
    'IE':'Ireland ',
    'IL':'Israel',
    'IT':'Italy ',
    'JM':'Jamaica ',
    'JP':'Japan ',
    'JO':'Jordan',
    'KZ':'Kazakhstan',
    'KE':'Kenya ',
    'KI':'Kiribati',
    'KP':'Korea, Democratic People\'s Republic Of',
    'KR':'Korea, Republic Of',
    'KW':'Kuwait',
    'KG':'Kyrgyzstan',
    'LA':'Lao People\'s Democratic Republic',
    'LV':'Latvia',
    'LB':'Lebanon ',
    'LS':'Lesotho ',
    'LR':'Liberia ',
    'LY':'Libyan Arab Jamahiriya',
    'LI':'Liechtenstein ',
    'LT':'Lithuania ',
    'LU':'Luxembourg',
    'MO':'Macau ',
    'MK':'Macedonia, The Former Yugoslav Republic Of',
    'MG':'Madagascar',
    'MW':'Malawi',
    'MY':'Malaysia',
    'MV':'Maldives',
    'ML':'Mali',
    'MT':'Malta ',
    'MH':'Marshall Islands',
    'MQ':'Martinique',
    'MR':'Mauritania',
    'MU':'Mauritius ',
    'YT':'Mayotte ',
    'MX':'Mexico',
    'FM':'Micronesia, Federated States Of ',
    'MD':'Moldova, Republic Of',
    'MC':'Monaco',
    'MN':'Mongolia',
    'MS':'Montserrat',
    'MA':'Morocco ',
    'MZ':'Mozambique',
    'MM':'Myanmar ',
    'NA':'Namibia ',
    'NR':'Nauru ',
    'NP':'Nepal ',
    'NL':'Netherlands ',
    'AN':'Netherlands Antilles',
    'NC':'New Caledonia ',
    'NZ':'New Zealand ',
    'NI':'Nicaragua ',
    'NE':'Niger ',
    'NG':'Nigeria ',
    'NU':'Niue',
    'NF':'Norfolk Island',
    'MP':'Northern Mariana Islands',
    'NO':'Norway',
    'OM':'Oman',
    'PK':'Pakistan',
    'PW':'Palau ',
    'PS':'Palestinian Territory, Occupied ',
    'PA':'Panama',
    'PG':'Papua New Guinea',
    'PY':'Paraguay',
    'PE':'Peru',
    'PH':'Philippines ',
    'PN':'Pitcairn',
    'PL':'Poland',
    'PT':'Portugal',
    'PR':'Puerto Rico ',
    'QA':'Qatar ',
    'RE':'Reunion ',
    'RO':'Romania ',
    'RU':'Russian Federation',
    'RW':'Rwanda',
    'KN':'Saint Kitts And Nevis ',
    'LC':'Saint Lucia ',
    'VC':'Saint Vincent And The Grenadines',
    'WS':'Samoa ',
    'SM':'San Marino',
    'ST':'Sao Tome And Principe ',
    'SA':'Saudi Arabia',
    'SN':'Senegal ',
    'SC':'Seychelles',
    'SL':'Sierra Leone',
    'SG':'Singapore ',
    'SK':'Slovakia (Slovak Republic)',
    'SI':'Slovenia',
    'SB':'Solomon Islands ',
    'SO':'Somalia ',
    'ZA':'South Africa',
    'GS':'South Georgia And The South Sandwich Islands',
    'ES':'Spain ',
    'LK':'Sri Lanka ',
    'SH':'St. Helena',
    'PM':'St. Pierre And Miquelon ',
    'SD':'Sudan ',
    'SR':'Suriname',
    'SJ':'Svalbard And Jan Mayen Islands',
    'SZ':'Swaziland ',
    'SE':'Sweden',
    'CH':'Switzerland ',
    'SY':'Syrian Arab Republic',
    'TW':'Taiwan',
    'TJ':'Tajikistan',
    'TZ':'Tanzania, United Republic Of',
    'TH':'Thailand',
    'TL':'Timor-Leste',
    'TG':'Togo',
    'TK':'Tokelau ',
    'TO':'Tonga ',
    'TT':'Trinidad And Tobago ',
    'TN':'Tunisia ',
    'TR':'Turkey',
    'TM':'Turkmenistan',
    'TC':'Turks And Caicos Islands',
    'TV':'Tuvalu',
    'UG':'Uganda',
    'UA':'Ukraine ',
    'AE':'United Arab Emirates',
    'GB':'United Kingdom',
    'US':'United States ',
    'UM':'United States Minor Outlying Islands',
    'UY':'Uruguay ',
    'UZ':'Uzbekistan',
    'VU':'Vanuatu ',
    'VA':'Vatican City State (Holy See) ',
    'VE':'Venezuela ',
    'VN':'Viet Nam',
    'VG':'Virgin Islands (British)',
    'VI':'Virgin Islands (U.S.) ',
    'WF':'Wallis And Futuna Islands ',
    'EH':'Western Sahara',
    'YE':'Yemen ',
    'RS':'Serbia',
    'ZM':'Zambia',
    'ZW':'Zimbabwe',
}

# Mapping from 3 letter ISO language codes to 2 letter ISO language codes
LANGUAGES_MAP_3_2 = {
 'AAR': 'AA',
 'ABK': 'AB',
 'AFR': 'AF',
 'ALB': 'SQ',
 'AMH': 'AM',
 'ARA': 'AR',
 'ARM': 'HY',
 'ASM': 'AS',
 'AYM': 'AY',
 'AZE': 'AZ',
 'BAK': 'BA',
 'BAQ': 'EU',
 'BEL': 'BE',
 'BEN': 'BN',
 'BIH': 'BH',
 'BIS': 'BI',
 'BOD': 'BO',
 'BRE': 'BE',
 'BUL': 'BG',
 'BUR': 'MY',
 'CAT': 'CA',
 'CES': 'CS',
 'CHI': 'ZH',
 'COS': 'CO',
 'CYM': 'CY',
 'CZE': 'CS',
 'DAN': 'DA',
 'DEU': 'DE',
 'DUT': 'NL',
 'DZO': 'DZ',
 'ELL': 'EL',
 'ENG': 'EN',
 'EPO': 'EO',
 'ESL': 'ES',
 'EST': 'ET',
 'EUS': 'EU',
 'FAO': 'FO',
 'FAS': 'FA',
 'FIJ': 'FJ',
 'FIN': 'FI',
 'FRA': 'FR',
 'FRE': 'FR',
 'FRY': 'FY',
 'GAI': 'GA',
 'GEO': 'KA',
#'GER': 'DE',      # reverse mapping doesn't work :/  DEU - DE - GER 
 'GLG': 'GL',
 'GRE': 'EL',
 'GRN': 'GN',
 'GUJ': 'GU',
 'HAU': 'HA',
 'HEB': 'HE',
 'HIN': 'HI',
 'HUN': 'HU',
 'HYE': 'HY',
 'ICE': 'IS',
 'IKU': 'IU',
 'INA': 'IA',
 'IND': 'ID',
 'IPK': 'IK',
 'IRI': 'GA',
 'ISL': 'IS',
 'ITA': 'IT',
 'JAV': 'JV',
 'JAW': 'JW',
 'JPN': 'JA',
 'KAL': 'KL',
 'KAN': 'KN',
 'KAS': 'KS',
 'KAT': 'KA',
 'KAZ': 'KK',
 'KHM': 'KM',
 'KIN': 'RW',
 'KIR': 'KY',
 'KOR': 'KO',
 'KUR': 'KU',
 'LAO': 'LO',
 'LAT': 'LA',
 'LAV': 'LV',
 'LIN': 'LN',
 'LIT': 'LT',
 'MAC': 'MK',
 'MAK': 'MK',
 'MAO': 'MI',
 'MAR': 'MR',
 'MAY': 'MS',
 'MLG': 'MG',
 'MLT': 'ML',
 'MOL': 'MO',
 'MON': 'MN',
 'MRI': 'MI',
 'MSA': 'MS',
 'MYA': 'MY',
 'NAU': 'NA',
 'NEP': 'NE',
 'NLA': 'NL',
 'NOR': 'NO',
 'OCI': 'OC',
 'ORI': 'OR',
 'ORM': 'OM',
 'PAN': 'PA',
 'PER': 'FA',
 'POL': 'PL',
 'POR': 'PT',
 'PUS': 'PS',
 'QUE': 'QU',
 'ROH': 'RM',
 'RON': 'RO',
 'RUM': 'RO',
 'RUN': 'RN',
 'RUS': 'RU',
 'SAG': 'SG',
 'SAN': 'SA',
 'SCR': 'SH',
 'SIN': 'SI',
 'SLK': 'SK',
 'SLO': 'SK',
 'SLV': 'SL',
 'SMO': 'SM',
 'SNA': 'SN',
 'SND': 'SD',
 'SOM': 'SO',
 'SOT': 'ST',
 'SPA': 'ES',
 'SQI': 'SQ',
 'SSW': 'SS',
 'SUN': 'SU',
 'SVE': 'SV',
 'SWA': 'SW',
 'SWE': 'SV',
 'TAM': 'TA',
 'TAT': 'TT',
 'TEL': 'TE',
 'TGK': 'TG',
 'TGL': 'TL',
 'THA': 'TH',
 'TIB': 'BO',
 'TIR': 'TI',
 'TOG': 'TO',
 'TSN': 'TN',
 'TSO': 'TS',
 'TUK': 'TK',
 'TUR': 'TR',
 'TWI': 'TW',
 'UIG': 'UG',
 'UKR': 'UK',
 'URD': 'UR',
 'UZB': 'UZ',
 'VIE': 'VI',
 'VOL': 'VO',
 'WEL': 'CY',
 'WOL': 'WO',
 'XHO': 'XH',
 'YID': 'YI',
 'YOR': 'YO',
 'ZHA': 'ZA',
 'ZHO': 'ZH',
 'ZUL': 'ZU'}

LANGUAGES_MAP_2_3 = dict([(l2, l3) for (l3, l2) in LANGUAGES_MAP_3_2.items()])

LANGUAGES = {
"AA": "Afar",
"AB": "Abkhazian",
"AF": "Afrikaans",
"AM": "Amharic",
"AR": "Arabic",
"AS": "Assamese",
"AY": "Aymara",
"AZ": "Azerbaijani",
"BA": "Bashkir",
"BE": "Byelorussian",
"BG": "Bulgarian",
"BH": "Bihari",
"BI": "Bislama",
"BN": "Bengali" "Bangla",
"BO": "Tibetan",
"BR": "Breton",
"CA": "Catalan",
"CO": "Corsican",
"CS": "Czech",
"CY": "Welsh",
"DA": "Danish",
"DE": "German",
"DZ": "Bhutani",
"EL": "Greek",
"EN": "English" "American",
"EO": "Esperanto",
"ES": "Spanish",
"ET": "Estonian",
"EU": "Basque",
"FA": "Persian",
"FI": "Finnish",
"FJ": "Fiji",
"FO": "Faeroese",
"FR": "French",
"FY": "Frisian",
"GA": "Irish",
"GD": "Gaelic" "Scots Gaelic",
"GL": "Galician",
"GN": "Guarani",
"GU": "Gujarati",
"HA": "Hausa",
"HI": "Hindi",
"HR": "Croatian",
"HU": "Hungarian",
"HY": "Armenian",
"IA": "Interlingua",
"IE": "Interlingue",
"IK": "Inupiak",
"IN": "Indonesian",
"IS": "Icelandic",
"IT": "Italian",
"IW": "Hebrew",
"JA": "Japanese",
"JI": "Yiddish",
"JW": "Javanese",
"KA": "Georgian",
"KK": "Kazakh",
"KL": "Greenlandic",
"KM": "Cambodian",
"KN": "Kannada",
"KO": "Korean",
"KS": "Kashmiri",
"KU": "Kurdish",
"KY": "Kirghiz",
"LA": "Latin",
"LN": "Lingala",
"LO": "Laothian",
"LT": "Lithuanian",
"LV": "Latvian" "Lettish",
"MG": "Malagasy",
"MI": "Maori",
"MK": "Macedonian",
"ML": "Malayalam",
"MN": "Mongolian",
"MO": "Moldavian",
"MR": "Marathi",
"MS": "Malay",
"MT": "Maltese",
"MY": "Burmese",
"NA": "Nauru",
"NE": "Nepali",
"NL": "Dutch",
"NO": "Norwegian",
"OC": "Occitan",
"OM": "Oromo" "Afan",
"OR": "Oriya",
"PA": "Punjabi",
"PL": "Polish",
"PS": "Pashto" "Pushto",
"PT": "Portuguese",
"QU": "Quechua",
"RM": "Rhaeto-Romance",
"RN": "Kirundi",
"RO": "Romanian",
"RU": "Russian",
"RW": "Kinyarwanda",
"SA": "Sanskrit",
"SD": "Sindhi",
"SG": "Sangro",
"SH": "Serbo-Croatian",
"SI": "Singhalese",
"SK": "Slovak",
"SL": "Slovenian",
"SM": "Samoan",
"SN": "Shona",
"SO": "Somali",
"SQ": "Albanian",
"SR": "Serbian",
"SS": "Siswati",
"ST": "Sesotho",
"SU": "Sudanese",
"SV": "Swedish",
"SW": "Swahili",
"TA": "Tamil",
"TE": "Tegulu",
"TG": "Tajik",
"TH": "Thai",
"TI": "Tigrinya",
"TK": "Turkmen",
"TL": "Tagalog",
"TN": "Setswana",
"TO": "Tonga",
"TR": "Turkish",
"TS": "Tsonga",
"TT": "Tatar",
"TW": "Twi",
"UK": "Ukrainian",
"UR": "Urdu",
"UZ": "Uzbek",
"VI": "Vietnamese",
"VO": "Volapuk",
"WO": "Wolof",
"XH": "Xhosa",
"YO": "Yoruba",
"ZH": "Chinese",
"ZU": "Zulu",
}

LANGUAGE_LIST = LANGUAGES.items()
LANGUAGE_LIST.sort(lambda x,y:cmp(x[1], y[1]))

        
# Zope Permissions
access_contents_information = 'Access contents information'
manage_properties = 'Manage properties'


