#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
    Module shcs.util
"""

import logging
import time
import os
import sys
import traceback
import flask.config
from flask import abort
from werkzeug.exceptions import HTTPException

LEVEL = {
    "DEBUG": logging.DEBUG,
    "INFO": logging.INFO,
    "WARNING": logging.WARNING,
    "ERROR": logging.ERROR,
    "CRITICAL":logging.CRITICAL,
}

from functools import wraps
from flask import g, request, redirect, url_for

class Trace():

    def __init__(self, app):
        self._app = app
        
    def trace(self,f):
        @wraps(f)
        def decorated_function(*args, **kwargs):
            start_time = time.time()  
            try:
                ERROR = False
                res = f(*args, **kwargs)
            except HTTPException as e:
                res = e
            except Exception as e:
                self._app.logger.error(e.__class__.__name__)
                ERROR = True
                exc_type, exc_value, exc_traceback = sys.exc_info()
                for line in traceback.format_exc().splitlines():
                    self._app.logger.error(line)
            interval = time.time() - start_time 
            self._app.logger.debug('call %s: time: %s' % (f.__name__, interval))
            if ERROR:
                abort(500)
            return res
        return decorated_function


class Config(flask.config.Config):

    def __init__(self, config):
        flask.config.Config.__init__(self, config.root_path)
        for key in config.keys():
            self[key] = config[key]
  
    def from_env(self, namespace):
        for key in os.environ:
            if key.startswith(namespace) and key.isupper():
                try:
                    self[key] = int(os.environ.get(key))
                except:
                    self[key] = os.environ.get(key)
        
class ConfigShcs(Config):


    def complete(self):
        self['SECRET_KEY'] = getattr(self, 'SECRET_KEY', 'secret_key')
        self['USERS'] = getattr(self, 'USERS', [])
        for key in [ key for key in self.keys() if key.startswith('SHCS_USER_')]:
            self['USERS'].append({'id': len(self['USERS']), 'username': self[key].split(':')[0], 'password': self[key].split(':')[1]})
        if not len(self['USERS']):
            self['USERS'] = [{'id':0, 'username':'guest','password':'guest'}]
