#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
    Module shcs.login
"""
import os
from flask_autodoc import Autodoc

class Doc():

    def __init__(self, app, base_url="/"):
        if base_url[-1] != "/":
            base_url = base_url + "/"
        self.doc = Autodoc(app)
        try:
            from docutils import core
            RESTIFY=True
        except:
            RESTIFY = False
        
        def rsttohtml(rst):
            if not rst: rst=""
            if RESTIFY:
                return core.publish_parts(rst, writer_name='html')['html_body']
            return '<div class="document">%s</div>' % rst

        @app.route('%sdoc' % base_url)
        def doc():
            return app.doc.html(template='myautodoc.html', rsttohtml=rsttohtml)

