# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServicePrincipalBase(Model):
    """Active Directory service principal common properties shared among GET, POST
    and PATCH.

    :param account_enabled: whether or not the service principal account is
     enabled
    :type account_enabled: str
    :param app_role_assignment_required: Specifies whether an
     AppRoleAssignment to a user or group is required before Azure AD will
     issue a user or access token to the application.
    :type app_role_assignment_required: bool
    :param key_credentials: The collection of key credentials associated with
     the service principal.
    :type key_credentials: list[~azure.graphrbac.models.KeyCredential]
    :param password_credentials: The collection of password credentials
     associated with the service principal.
    :type password_credentials:
     list[~azure.graphrbac.models.PasswordCredential]
    :param service_principal_type: the type of the service principal
    :type service_principal_type: str
    :param tags: Optional list of tags that you can apply to your service
     principals. Not nullable.
    :type tags: list[str]
    """

    _attribute_map = {
        'account_enabled': {'key': 'accountEnabled', 'type': 'str'},
        'app_role_assignment_required': {'key': 'appRoleAssignmentRequired', 'type': 'bool'},
        'key_credentials': {'key': 'keyCredentials', 'type': '[KeyCredential]'},
        'password_credentials': {'key': 'passwordCredentials', 'type': '[PasswordCredential]'},
        'service_principal_type': {'key': 'servicePrincipalType', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
    }

    def __init__(self, *, account_enabled: str=None, app_role_assignment_required: bool=None, key_credentials=None, password_credentials=None, service_principal_type: str=None, tags=None, **kwargs) -> None:
        super(ServicePrincipalBase, self).__init__(**kwargs)
        self.account_enabled = account_enabled
        self.app_role_assignment_required = app_role_assignment_required
        self.key_credentials = key_credentials
        self.password_credentials = password_credentials
        self.service_principal_type = service_principal_type
        self.tags = tags
