import io
import importlib
import os
from fstree import TYPE_FILE, TYPE_DIR

zipfile = importlib.import_module('zipfile')

class Mixin(object):
    def _fake_zipfile_ZipFile(self, file, mode="r", compression=zipfile.ZIP_STORED, allowZip64=False):
        path = file
        if self._flip_backslashes:
            path = path.replace('\\', '/')

        if mode.startswith('r'):
            filenode = self._find_or_raise(path, TYPE_FILE)
            io_obj = filenode.get_exist_io(io.BytesIO)
            io_obj.seek(0)

            res = zipfile.ZipFile(io_obj, mode=mode, compression=compression, allowZip64=allowZip64)
            return res

        elif mode.startswith('a'):
            filenodes = self.find(path, TYPE_FILE)
            if not filenodes:
                # the file doesn't exist yet but the parent directory should.
                dirpath = os.path.dirname(path)
                self._find_or_raise(dirpath, TYPE_DIR)
                filenode = self.add_file(path)
            else:
                filenode = filenodes[0]

            io_obj = filenode.get_exist_io(io.BytesIO)

            res = zipfile.ZipFile(io_obj, mode=mode, compression=compression, allowZip64=allowZip64)
            return res

        elif mode.startswith('w'):
            nodes = self.find(path, TYPE_FILE)
            filenode = nodes[0] if nodes else self.add_file(path)
            io_obj = filenode.create_new_io(io.BytesIO)

            res = zipfile.ZipFile(io_obj, mode=mode, compression=compression, allowZip64=allowZip64)
            return res

        else:
            msg = "Mode string must begin with one of 'r', 'w' or 'a', not '{}'.".format(mode)
            raise ValueError(msg)

