# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2018, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


from .datatypes import DATATYPES_STRUCTS

FIELDS = {
    'ABS_1': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DISCHARGE_CARE_PROVIDER', 'HL70010', -1),
    'ABS_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSFER_MEDICAL_SERVICE_CODE', 'HL70069', -1),
    'ABS_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SEVERITY_OF_ILLNESS_CODE', 'HL70421', -1),
    'ABS_4': ('leaf', None, 'DTM', 'DATE_TIME_OF_ATTESTATION', None, -1),
    'ABS_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ATTESTED_BY', None, -1),
    'ABS_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRIAGE_CODE', 'HL70422', -1),
    'ABS_7': ('leaf', None, 'DTM', 'ABSTRACT_COMPLETION_DATE_TIME', None, -1),
    'ABS_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ABSTRACTED_BY', None, -1),
    'ABS_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CASE_CATEGORY_CODE', 'HL70423', -1),
    'ABS_10': ('leaf', None, 'ID', 'CAESARIAN_SECTION_INDICATOR', 'HL70136', -1),
    'ABS_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GESTATION_CATEGORY_CODE', 'HL70424', -1),
    'ABS_12': ('leaf', None, 'NM', 'GESTATION_PERIOD_WEEKS', None, -1),
    'ABS_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NEWBORN_CODE', 'HL70425', -1),
    'ABS_14': ('leaf', None, 'ID', 'STILLBORN_INDICATOR', 'HL70136', -1),
    'ACC_1': ('leaf', None, 'DTM', 'ACCIDENT_DATE_TIME', None, -1),
    'ACC_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACCIDENT_CODE', 'HL70050', -1),
    'ACC_3': ('leaf', None, 'ST', 'ACCIDENT_LOCATION', None, -1),
    'ACC_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AUTO_ACCIDENT_STATE', 'HL70347', -1),
    'ACC_5': ('leaf', None, 'ID', 'ACCIDENT_JOB_RELATED_INDICATOR', 'HL70136', -1),
    'ACC_6': ('leaf', None, 'ID', 'ACCIDENT_DEATH_INDICATOR', 'HL70136', -1),
    'ACC_7': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY', None, -1),
    'ACC_8': ('leaf', None, 'ST', 'ACCIDENT_DESCRIPTION', None, -1),
    'ACC_9': ('leaf', None, 'ST', 'BROUGHT_IN_BY', None, -1),
    'ACC_10': ('leaf', None, 'ID', 'POLICE_NOTIFIED_INDICATOR', 'HL70136', -1),
    'ACC_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ACCIDENT_ADDRESS', None, -1),
    'ACC_12': ('leaf', None, 'NM', 'DEGREE_OF_PATIENT_LIABILITY', None, -1),
    'ACC_13': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ACCIDENT_IDENTIFIER', None, -1),
    'ADD_1': ('leaf', None, 'ST', 'ADDENDUM_CONTINUATION_POINTER', None, -1),
    'ADJ_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_ADJUSTMENT_NUMBER', None, -1),
    'ADJ_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PAYER_ADJUSTMENT_NUMBER', None, -1),
    'ADJ_3': ('leaf', None, 'SI', 'ADJUSTMENT_SEQUENCE_NUMBER', None, -1),
    'ADJ_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADJUSTMENT_CATEGORY', 'HL70564', -1),
    'ADJ_5': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'ADJUSTMENT_AMOUNT', None, -1),
    'ADJ_6': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'ADJUSTMENT_QUANTITY', 'HL70560', -1),
    'ADJ_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADJUSTMENT_REASON_PA', 'HL70565', -1),
    'ADJ_8': ('leaf', None, 'ST', 'ADJUSTMENT_DESCRIPTION', None, -1),
    'ADJ_9': ('leaf', None, 'NM', 'ORIGINAL_VALUE', None, -1),
    'ADJ_10': ('leaf', None, 'NM', 'SUBSTITUTE_VALUE', None, -1),
    'ADJ_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADJUSTMENT_ACTION', 'HL70569', -1),
    'ADJ_12': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_ADJUSTMENT_NUMBER_CROSS_REFERENCE', None, -1),
    'ADJ_13': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_PRODUCT_SERVICE_LINE_ITEM_NUMBER_CROSS_REFERENCE',
               None, -1),
    'ADJ_14': ('leaf', None, 'DTM', 'ADJUSTMENT_DATE', None, -1),
    'ADJ_15': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'RESPONSIBLE_ORGANIZATION', None, -1),
    'AFF_1': ('leaf', None, 'SI', 'SET_ID_AFF', None, -1),
    'AFF_2': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PROFESSIONAL_ORGANIZATION', None, -1),
    'AFF_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PROFESSIONAL_ORGANIZATION_ADDRESS', None, -1),
    'AFF_4': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'PROFESSIONAL_ORGANIZATION_AFFILIATION_DATE_RANGE', None, -1),
    'AFF_5': ('leaf', None, 'ST', 'PROFESSIONAL_AFFILIATION_ADDITIONAL_INFORMATION', None, -1),
    'AIG_1': ('leaf', None, 'SI', 'SET_ID_AIG', None, -1),
    'AIG_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'AIG_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RESOURCE_ID', None, -1),
    'AIG_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RESOURCE_TYPE', None, -1),
    'AIG_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RESOURCE_GROUP', None, -1),
    'AIG_6': ('leaf', None, 'NM', 'RESOURCE_QUANTITY', None, -1),
    'AIG_7': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'RESOURCE_QUANTITY_UNITS', None, -1),
    'AIG_8': ('leaf', None, 'DTM', 'START_DATE_TIME', None, -1),
    'AIG_9': ('leaf', None, 'NM', 'START_DATE_TIME_OFFSET', None, -1),
    'AIG_10': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'START_DATE_TIME_OFFSET_UNITS', None, -1),
    'AIG_11': ('leaf', None, 'NM', 'DURATION', None, -1),
    'AIG_12': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DURATION_UNITS', None, -1),
    'AIG_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLOW_SUBSTITUTION_CODE', 'HL70279', -1),
    'AIG_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'AIL_1': ('leaf', None, 'SI', 'SET_ID_AIL', None, -1),
    'AIL_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'AIL_3': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'LOCATION_RESOURCE_ID', None, -1),
    'AIL_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_TYPE_AIL', 'HL70305', -1),
    'AIL_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_GROUP', None, -1),
    'AIL_6': ('leaf', None, 'DTM', 'START_DATE_TIME', None, -1),
    'AIL_7': ('leaf', None, 'NM', 'START_DATE_TIME_OFFSET', None, -1),
    'AIL_8': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'START_DATE_TIME_OFFSET_UNITS', None, -1),
    'AIL_9': ('leaf', None, 'NM', 'DURATION', None, -1),
    'AIL_10': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DURATION_UNITS', None, -1),
    'AIL_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLOW_SUBSTITUTION_CODE', 'HL70279', -1),
    'AIL_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'AIP_1': ('leaf', None, 'SI', 'SET_ID_AIP', None, -1),
    'AIP_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'AIP_3': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PERSONNEL_RESOURCE_ID', None, -1),
    'AIP_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RESOURCE_TYPE', 'HL70182', -1),
    'AIP_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RESOURCE_GROUP', None, -1),
    'AIP_6': ('leaf', None, 'DTM', 'START_DATE_TIME', None, -1),
    'AIP_7': ('leaf', None, 'NM', 'START_DATE_TIME_OFFSET', None, -1),
    'AIP_8': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'START_DATE_TIME_OFFSET_UNITS', None, -1),
    'AIP_9': ('leaf', None, 'NM', 'DURATION', None, -1),
    'AIP_10': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DURATION_UNITS', None, -1),
    'AIP_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLOW_SUBSTITUTION_CODE', 'HL70279', -1),
    'AIP_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'AIS_1': ('leaf', None, 'SI', 'SET_ID_AIS', None, -1),
    'AIS_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'AIS_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNIVERSAL_SERVICE_IDENTIFIER', None, -1),
    'AIS_4': ('leaf', None, 'DTM', 'START_DATE_TIME', None, -1),
    'AIS_5': ('leaf', None, 'NM', 'START_DATE_TIME_OFFSET', None, -1),
    'AIS_6': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'START_DATE_TIME_OFFSET_UNITS', None, -1),
    'AIS_7': ('leaf', None, 'NM', 'DURATION', None, -1),
    'AIS_8': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DURATION_UNITS', None, -1),
    'AIS_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLOW_SUBSTITUTION_CODE', 'HL70279', -1),
    'AIS_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'AIS_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PLACER_SUPPLEMENTAL_SERVICE_INFORMATION', 'HL70411', -1),
    'AIS_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FILLER_SUPPLEMENTAL_SERVICE_INFORMATION', 'HL70411', -1),
    'AL1_1': ('leaf', None, 'SI', 'SET_ID_AL1', None, -1),
    'AL1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGEN_TYPE_CODE', 'HL70127', -1),
    'AL1_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGEN_CODE_MNEMONIC_DESCRIPTION', None, -1),
    'AL1_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGY_SEVERITY_CODE', 'HL70128', -1),
    'AL1_5': ('leaf', None, 'ST', 'ALLERGY_REACTION_CODE', None, -1),
    'APR_1': ('sequence', DATATYPES_STRUCTS['SCV'], 'SCV', 'TIME_SELECTION_CRITERIA', 'HL70294', -1),
    'APR_2': ('sequence', DATATYPES_STRUCTS['SCV'], 'SCV', 'RESOURCE_SELECTION_CRITERIA', 'HL70294', -1),
    'APR_3': ('sequence', DATATYPES_STRUCTS['SCV'], 'SCV', 'LOCATION_SELECTION_CRITERIA', 'HL70294', -1),
    'APR_4': ('leaf', None, 'NM', 'SLOT_SPACING_CRITERIA', None, -1),
    'APR_5': ('sequence', DATATYPES_STRUCTS['SCV'], 'SCV', 'FILLER_OVERRIDE_CRITERIA', None, -1),
    'ARQ_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_APPOINTMENT_ID', None, -1),
    'ARQ_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_APPOINTMENT_ID', None, -1),
    'ARQ_3': ('leaf', None, 'NM', 'OCCURRENCE_NUMBER', None, -1),
    'ARQ_4': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'PLACER_GROUP_NUMBER', None, -1),
    'ARQ_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SCHEDULE_ID', None, -1),
    'ARQ_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUEST_EVENT_REASON', None, -1),
    'ARQ_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPOINTMENT_REASON', 'HL70276', -1),
    'ARQ_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPOINTMENT_TYPE', 'HL70277', -1),
    'ARQ_9': ('leaf', None, 'NM', 'APPOINTMENT_DURATION', None, -1),
    'ARQ_10': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'APPOINTMENT_DURATION_UNITS', None, -1),
    'ARQ_11': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'REQUESTED_START_DATE_TIME_RANGE', None, -1),
    'ARQ_12': ('leaf', None, 'ST', 'PRIORITY_ARQ', None, -1),
    'ARQ_13': ('sequence', DATATYPES_STRUCTS['RI'], 'RI', 'REPEATING_INTERVAL', None, -1),
    'ARQ_14': ('leaf', None, 'ST', 'REPEATING_INTERVAL_DURATION', None, -1),
    'ARQ_15': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PLACER_CONTACT_PERSON', None, -1),
    'ARQ_16': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PLACER_CONTACT_PHONE_NUMBER', None, -1),
    'ARQ_17': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PLACER_CONTACT_ADDRESS', None, -1),
    'ARQ_18': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PLACER_CONTACT_LOCATION', None, -1),
    'ARQ_19': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY_PERSON', None, -1),
    'ARQ_20': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ENTERED_BY_PHONE_NUMBER', None, -1),
    'ARQ_21': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ENTERED_BY_LOCATION', None, -1),
    'ARQ_22': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_PLACER_APPOINTMENT_ID', None, -1),
    'ARQ_23': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_FILLER_APPOINTMENT_ID', None, -1),
    'ARQ_24': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_ORDER_NUMBER', None, -1),
    'ARQ_25': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'ARV_1': ('leaf', None, 'SI', 'SET_ID', None, -1),
    'ARV_2': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'ACCESS_RESTRICTION_ACTION_CODE', 'HL70206', -1),
    'ARV_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACCESS_RESTRICTION_VALUE', 'HL70717', -1),
    'ARV_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACCESS_RESTRICTION_REASON', 'HL70719', -1),
    'ARV_5': ('leaf', None, 'ST', 'SPECIAL_ACCESS_RESTRICTION_INSTRUCTIONS', None, -1),
    'ARV_6': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'ACCESS_RESTRICTION_DATE_RANGE', None, -1),
    'AUT_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AUTHORIZING_PAYOR_PLAN_ID', 'HL70072', -1),
    'AUT_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AUTHORIZING_PAYOR_COMPANY_ID', 'HL70285', -1),
    'AUT_3': ('leaf', None, 'ST', 'AUTHORIZING_PAYOR_COMPANY_NAME', None, -1),
    'AUT_4': ('leaf', None, 'DTM', 'AUTHORIZATION_EFFECTIVE_DATE', None, -1),
    'AUT_5': ('leaf', None, 'DTM', 'AUTHORIZATION_EXPIRATION_DATE', None, -1),
    'AUT_6': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'AUTHORIZATION_IDENTIFIER', None, -1),
    'AUT_7': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'REIMBURSEMENT_LIMIT', None, -1),
    'AUT_8': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'REQUESTED_NUMBER_OF_TREATMENTS', None, -1),
    'AUT_9': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'AUTHORIZED_NUMBER_OF_TREATMENTS', None, -1),
    'AUT_10': ('leaf', None, 'DTM', 'PROCESS_DATE', None, -1),
    'AUT_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_DISCIPLINE_S', None, -1),
    'AUT_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AUTHORIZED_DISCIPLINE_S', None, -1),
    'AUT_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AUTHORIZATION_REFERRAL_TYPE', None, -1),
    'AUT_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPROVAL_STATUS', None, -1),
    'AUT_15': ('leaf', None, 'DTM', 'PLANNED_TREATMENT_STOP_DATE', None, -1),
    'AUT_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CLINICAL_SERVICE', None, -1),
    'AUT_17': ('leaf', None, 'ST', 'REASON_TEXT', None, -1),
    'AUT_18': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NUMBER_OF_AUTHORIZED_TREATMENTS_UNITS', None, -1),
    'AUT_19': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NUMBER_OF_USED_TREATMENTS_UNITS', None, -1),
    'AUT_20': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NUMBER_OF_SCHEDULE_TREATMENTS_UNITS', None, -1),
    'AUT_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ENCOUNTER_TYPE', None, -1),
    'AUT_22': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'REMAINING_BENEFIT_AMOUNT', None, -1),
    'AUT_23': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'AUTHORIZED_PROVIDER', None, -1),
    'AUT_24': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'AUTHORIZED_HEALTH_PROFESSIONAL', None, -1),
    'AUT_25': ('leaf', None, 'ST', 'SOURCE_TEXT', None, -1),
    'AUT_26': ('leaf', None, 'DTM', 'SOURCE_DATE', None, -1),
    'AUT_27': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'SOURCE_PHONE', None, -1),
    'AUT_28': ('leaf', None, 'ST', 'COMMENT', None, -1),
    'AUT_29': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'BHS_1': ('leaf', None, 'ST', 'BATCH_FIELD_SEPARATOR', None, -1),
    'BHS_2': ('leaf', None, 'ST', 'BATCH_ENCODING_CHARACTERS', None, -1),
    'BHS_3': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'BATCH_SENDING_APPLICATION', None, -1),
    'BHS_4': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'BATCH_SENDING_FACILITY', None, -1),
    'BHS_5': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'BATCH_RECEIVING_APPLICATION', None, -1),
    'BHS_6': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'BATCH_RECEIVING_FACILITY', None, -1),
    'BHS_7': ('leaf', None, 'DTM', 'BATCH_CREATION_DATE_TIME', None, -1),
    'BHS_8': ('leaf', None, 'ST', 'BATCH_SECURITY', None, -1),
    'BHS_9': ('leaf', None, 'ST', 'BATCH_NAME_ID_TYPE', None, -1),
    'BHS_10': ('leaf', None, 'ST', 'BATCH_COMMENT', None, -1),
    'BHS_11': ('leaf', None, 'ST', 'BATCH_CONTROL_ID', None, -1),
    'BHS_12': ('leaf', None, 'ST', 'REFERENCE_BATCH_CONTROL_ID', None, -1),
    'BHS_13': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'BATCH_SENDING_NETWORK_ADDRESS', None, -1),
    'BHS_14': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'BATCH_RECEIVING_NETWORK_ADDRESS', None, -1),
    'BLC_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BLOOD_PRODUCT_CODE', 'HL70426', -1),
    'BLC_2': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'BLOOD_AMOUNT', None, -1),
    'BLG_1': ('sequence', DATATYPES_STRUCTS['CCD'], 'CCD', 'WHEN_TO_CHARGE', 'HL70100', -1),
    'BLG_2': ('leaf', None, 'ID', 'CHARGE_TYPE', 'HL70122', -1),
    'BLG_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ACCOUNT_ID', None, -1),
    'BLG_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CHARGE_TYPE_REASON', 'HL70475', -1),
    'BPO_1': ('leaf', None, 'SI', 'SET_ID_BPO', None, -1),
    'BPO_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_UNIVERSAL_SERVICE_IDENTIFIER', 'HL79999', -1),
    'BPO_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_PROCESSING_REQUIREMENTS', 'HL70508', -1),
    'BPO_4': ('leaf', None, 'NM', 'BP_QUANTITY', None, -1),
    'BPO_5': ('leaf', None, 'NM', 'BP_AMOUNT', None, -1),
    'BPO_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_UNITS', 'HL79999', -1),
    'BPO_7': ('leaf', None, 'DTM', 'BP_INTENDED_USE_DATE_TIME', None, -1),
    'BPO_8': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'BP_INTENDED_DISPENSE_FROM_LOCATION', None, -1),
    'BPO_9': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'BP_INTENDED_DISPENSE_FROM_ADDRESS', None, -1),
    'BPO_10': ('leaf', None, 'DTM', 'BP_REQUESTED_DISPENSE_DATE_TIME', None, -1),
    'BPO_11': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'BP_REQUESTED_DISPENSE_TO_LOCATION', None, -1),
    'BPO_12': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'BP_REQUESTED_DISPENSE_TO_ADDRESS', None, -1),
    'BPO_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_INDICATION_FOR_USE', 'HL70509', -1),
    'BPO_14': ('leaf', None, 'ID', 'BP_INFORMED_CONSENT_INDICATOR', 'HL70136', -1),
    'BPX_1': ('leaf', None, 'SI', 'SET_ID_BPX', None, -1),
    'BPX_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_DISPENSE_STATUS', 'HL70510', -1),
    'BPX_3': ('leaf', None, 'ID', 'BP_STATUS', 'HL70511', -1),
    'BPX_4': ('leaf', None, 'DTM', 'BP_DATE_TIME_OF_STATUS', None, -1),
    'BPX_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'BC_DONATION_ID', None, -1),
    'BPX_6': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'BC_COMPONENT', 'HL79999', -1),
    'BPX_7': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'BC_DONATION_TYPE_INTENDED_USE', 'HL79999', -1),
    'BPX_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CP_COMMERCIAL_PRODUCT', 'HL70512', -1),
    'BPX_9': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'CP_MANUFACTURER', None, -1),
    'BPX_10': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'CP_LOT_NUMBER', None, -1),
    'BPX_11': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'BP_BLOOD_GROUP', 'HL79999', -1),
    'BPX_12': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'BC_SPECIAL_TESTING', 'HL79999', -1),
    'BPX_13': ('leaf', None, 'DTM', 'BP_EXPIRATION_DATE_TIME', None, -1),
    'BPX_14': ('leaf', None, 'NM', 'BP_QUANTITY', None, -1),
    'BPX_15': ('leaf', None, 'NM', 'BP_AMOUNT', None, -1),
    'BPX_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_UNITS', 'HL79999', -1),
    'BPX_17': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'BP_UNIQUE_ID', None, -1),
    'BPX_18': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'BP_ACTUAL_DISPENSED_TO_LOCATION', None, -1),
    'BPX_19': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'BP_ACTUAL_DISPENSED_TO_ADDRESS', None, -1),
    'BPX_20': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'BP_DISPENSED_TO_RECEIVER', None, -1),
    'BPX_21': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'BP_DISPENSING_INDIVIDUAL', None, -1),
    'BTS_1': ('leaf', None, 'ST', 'BATCH_MESSAGE_COUNT', None, -1),
    'BTS_2': ('leaf', None, 'ST', 'BATCH_COMMENT', None, -1),
    'BTS_3': ('leaf', None, 'NM', 'BATCH_TOTALS', None, -1),
    'BTX_1': ('leaf', None, 'SI', 'SET_ID_BTX', None, -1),
    'BTX_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'BC_DONATION_ID', None, -1),
    'BTX_3': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'BC_COMPONENT', 'HL79999', -1),
    'BTX_4': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'BC_BLOOD_GROUP', 'HL79999', -1),
    'BTX_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CP_COMMERCIAL_PRODUCT', 'HL70512', -1),
    'BTX_6': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'CP_MANUFACTURER', None, -1),
    'BTX_7': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'CP_LOT_NUMBER', None, -1),
    'BTX_8': ('leaf', None, 'NM', 'BP_QUANTITY', None, -1),
    'BTX_9': ('leaf', None, 'NM', 'BP_AMOUNT', None, -1),
    'BTX_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_UNITS', 'HL79999', -1),
    'BTX_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_TRANSFUSION_DISPOSITION_STATUS', 'HL70513', -1),
    'BTX_12': ('leaf', None, 'ID', 'BP_MESSAGE_STATUS', 'HL70511', -1),
    'BTX_13': ('leaf', None, 'DTM', 'BP_DATE_TIME_OF_STATUS', None, -1),
    'BTX_14': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'BP_TRANSFUSION_ADMINISTRATOR', None, -1),
    'BTX_15': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'BP_TRANSFUSION_VERIFIER', None, -1),
    'BTX_16': ('leaf', None, 'DTM', 'BP_TRANSFUSION_START_DATE_TIME_OF_STATUS', None, -1),
    'BTX_17': ('leaf', None, 'DTM', 'BP_TRANSFUSION_END_DATE_TIME_OF_STATUS', None, -1),
    'BTX_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_ADVERSE_REACTION_TYPE', 'HL70514', -1),
    'BTX_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BP_TRANSFUSION_INTERRUPTED_REASON', 'HL70515', -1),
    'BTX_20': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'BP_UNIQUE_ID', None, -1),
    'BUI_1': ('leaf', None, 'SI', 'SET_ID_BUI', None, -1),
    'BUI_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'BLOOD_UNIT_IDENTIFIER', None, -1),
    'BUI_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BLOOD_UNIT_TYPE', 'HL70566', -1),
    'BUI_4': ('leaf', None, 'NM', 'BLOOD_UNIT_WEIGHT', None, -1),
    'BUI_5': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'WEIGHT_UNITS', 'HL70929', -1),
    'BUI_6': ('leaf', None, 'NM', 'BLOOD_UNIT_VOLUME', None, -1),
    'BUI_7': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'VOLUME_UNITS', 'HL70930', -1),
    'BUI_8': ('leaf', None, 'ST', 'CONTAINER_CATALOG_NUMBER', None, -1),
    'BUI_9': ('leaf', None, 'ST', 'CONTAINER_LOT_NUMBER', None, -1),
    'BUI_10': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'CONTAINER_MANUFACTURER', None, -1),
    'BUI_11': ('sequence', DATATYPES_STRUCTS['NR'], 'NR', 'TRANSPORT_TEMPERATURE', None, -1),
    'BUI_12': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'TRANSPORT_TEMPERATURE_UNITS', 'HL70931', -1),
    'CDM_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_KEY_VALUE_CDM', None, -1),
    'CDM_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CHARGE_CODE_ALIAS', 'HL70132', -1),
    'CDM_3': ('leaf', None, 'ST', 'CHARGE_DESCRIPTION_SHORT', None, -1),
    'CDM_4': ('leaf', None, 'ST', 'CHARGE_DESCRIPTION_LONG', None, -1),
    'CDM_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DESCRIPTION_OVERRIDE_INDICATOR', 'HL70268', -1),
    'CDM_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EXPLODING_CHARGES', 'HL70132', -1),
    'CDM_7': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE', 'HL70088', -1),
    'CDM_8': ('leaf', None, 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183', -1),
    'CDM_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVENTORY_NUMBER', 'HL70463', -1),
    'CDM_10': ('leaf', None, 'NM', 'RESOURCE_LOAD', None, -1),
    'CDM_11': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'CONTRACT_NUMBER', None, -1),
    'CDM_12': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'CONTRACT_ORGANIZATION', None, -1),
    'CDM_13': ('leaf', None, 'ID', 'ROOM_FEE_INDICATOR', 'HL70136', -1),
    'CDO_1': ('leaf', None, 'SI', 'SET_ID_CDO', None, -1),
    'CDO_2': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'CDO_3': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'CUMULATIVE_DOSAGE_LIMIT', None, -1),
    'CDO_4': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'CUMULATIVE_DOSAGE_LIMIT_TIME_INTERVAL', 'HL70924', -1),
    'CER_1': ('leaf', None, 'SI', 'SET_ID_CER', None, -1),
    'CER_2': ('leaf', None, 'ST', 'SERIAL_NUMBER', None, -1),
    'CER_3': ('leaf', None, 'ST', 'VERSION', None, -1),
    'CER_4': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'GRANTING_AUTHORITY', None, -1),
    'CER_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ISSUING_AUTHORITY', None, -1),
    'CER_6': ('sequence', DATATYPES_STRUCTS['ED'], 'ED', 'SIGNATURE', None, -1),
    'CER_7': ('leaf', None, 'ID', 'GRANTING_COUNTRY', 'HL70399', -1),
    'CER_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GRANTING_STATE_PROVINCE', 'HL70347', -1),
    'CER_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GRANTING_COUNTY_PARISH', 'HL70289', -1),
    'CER_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CERTIFICATE_TYPE', None, -1),
    'CER_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CERTIFICATE_DOMAIN', None, -1),
    'CER_12': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SUBJECT_ID', None, -1),
    'CER_13': ('leaf', None, 'ST', 'SUBJECT_NAME', None, -1),
    'CER_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBJECT_DIRECTORY_ATTRIBUTE_EXTENSION', None, -1),
    'CER_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBJECT_PUBLIC_KEY_INFO', None, -1),
    'CER_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AUTHORITY_KEY_IDENTIFIER', None, -1),
    'CER_17': ('leaf', None, 'ID', 'BASIC_CONSTRAINT', 'HL70136', -1),
    'CER_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CRL_DISTRIBUTION_POINT', None, -1),
    'CER_19': ('leaf', None, 'ID', 'JURISDICTION_COUNTRY', 'HL70399', -1),
    'CER_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'JURISDICTION_STATE_PROVINCE', 'HL70347', -1),
    'CER_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'JURISDICTION_COUNTY_PARISH', 'HL70289', -1),
    'CER_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'JURISDICTION_BREADTH', 'HL70547', -1),
    'CER_23': ('leaf', None, 'DTM', 'GRANTING_DATE', None, -1),
    'CER_24': ('leaf', None, 'DTM', 'ISSUING_DATE', None, -1),
    'CER_25': ('leaf', None, 'DTM', 'ACTIVATION_DATE', None, -1),
    'CER_26': ('leaf', None, 'DTM', 'INACTIVATION_DATE', None, -1),
    'CER_27': ('leaf', None, 'DTM', 'EXPIRATION_DATE', None, -1),
    'CER_28': ('leaf', None, 'DTM', 'RENEWAL_DATE', None, -1),
    'CER_29': ('leaf', None, 'DTM', 'REVOCATION_DATE', None, -1),
    'CER_30': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REVOCATION_REASON_CODE', None, -1),
    'CER_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CERTIFICATE_STATUS_CODE', 'HL70536', -1),
    'CM0_1': ('leaf', None, 'SI', 'SET_ID_CM0', None, -1),
    'CM0_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SPONSOR_STUDY_ID', None, -1),
    'CM0_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ALTERNATE_STUDY_ID', None, -1),
    'CM0_4': ('leaf', None, 'ST', 'TITLE_OF_STUDY', None, -1),
    'CM0_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CHAIRMAN_OF_STUDY', None, -1),
    'CM0_6': ('leaf', None, 'DT', 'LAST_IRB_APPROVAL_DATE', None, -1),
    'CM0_7': ('leaf', None, 'NM', 'TOTAL_ACCRUAL_TO_DATE', None, -1),
    'CM0_8': ('leaf', None, 'DT', 'LAST_ACCRUAL_DATE', None, -1),
    'CM0_9': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CONTACT_FOR_STUDY', None, -1),
    'CM0_10': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_S_TELEPHONE_NUMBER', None, -1),
    'CM0_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'CONTACT_S_ADDRESS', None, -1),
    'CM1_1': ('leaf', None, 'SI', 'SET_ID_CM1', None, -1),
    'CM1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDY_PHASE_IDENTIFIER', None, -1),
    'CM1_3': ('leaf', None, 'ST', 'DESCRIPTION_OF_STUDY_PHASE', None, -1),
    'CM2_1': ('leaf', None, 'SI', 'SET_ID_CM2', None, -1),
    'CM2_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SCHEDULED_TIME_POINT', None, -1),
    'CM2_3': ('leaf', None, 'ST', 'DESCRIPTION_OF_TIME_POINT', None, -1),
    'CM2_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EVENTS_SCHEDULED_THIS_TIME_POINT', None, -1),
    'CNS_1': ('leaf', None, 'NM', 'STARTING_NOTIFICATION_REFERENCE_NUMBER', None, -1),
    'CNS_2': ('leaf', None, 'NM', 'ENDING_NOTIFICATION_REFERENCE_NUMBER', None, -1),
    'CNS_3': ('leaf', None, 'DTM', 'STARTING_NOTIFICATION_DATE_TIME', None, -1),
    'CNS_4': ('leaf', None, 'DTM', 'ENDING_NOTIFICATION_DATE_TIME', None, -1),
    'CNS_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STARTING_NOTIFICATION_CODE', 'HL79999', -1),
    'CNS_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ENDING_NOTIFICATION_CODE', 'HL79999', -1),
    'CON_1': ('leaf', None, 'SI', 'SET_ID_CON', None, -1),
    'CON_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONSENT_TYPE', 'HL70496', -1),
    'CON_3': ('leaf', None, 'ST', 'CONSENT_FORM_ID_AND_VERSION', None, -1),
    'CON_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'CONSENT_FORM_NUMBER', None, -1),
    'CON_5': ('leaf', None, 'FT', 'CONSENT_TEXT', None, -1),
    'CON_6': ('leaf', None, 'FT', 'SUBJECT_SPECIFIC_CONSENT_TEXT', None, -1),
    'CON_7': ('leaf', None, 'FT', 'CONSENT_BACKGROUND_INFORMATION', None, -1),
    'CON_8': ('leaf', None, 'FT', 'SUBJECT_SPECIFIC_CONSENT_BACKGROUND_TEXT', None, -1),
    'CON_9': ('leaf', None, 'FT', 'CONSENTER_IMPOSED_LIMITATIONS', None, -1),
    'CON_10': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'CONSENT_MODE', 'HL70497', -1),
    'CON_11': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'CONSENT_STATUS', 'HL70498', -1),
    'CON_12': ('leaf', None, 'DTM', 'CONSENT_DISCUSSION_DATE_TIME', None, -1),
    'CON_13': ('leaf', None, 'DTM', 'CONSENT_DECISION_DATE_TIME', None, -1),
    'CON_14': ('leaf', None, 'DTM', 'CONSENT_EFFECTIVE_DATE_TIME', None, -1),
    'CON_15': ('leaf', None, 'DTM', 'CONSENT_END_DATE_TIME', None, -1),
    'CON_16': ('leaf', None, 'ID', 'SUBJECT_COMPETENCE_INDICATOR', 'HL70136', -1),
    'CON_17': ('leaf', None, 'ID', 'TRANSLATOR_ASSISTANCE_INDICATOR', 'HL70136', -1),
    'CON_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LANGUAGE_TRANSLATED_TO', 'HL70296', -1),
    'CON_19': ('leaf', None, 'ID', 'INFORMATIONAL_MATERIAL_SUPPLIED_INDICATOR', 'HL70136', -1),
    'CON_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONSENT_BYPASS_REASON', 'HL70499', -1),
    'CON_21': ('leaf', None, 'ID', 'CONSENT_DISCLOSURE_LEVEL', 'HL70500', -1),
    'CON_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONSENT_NON_DISCLOSURE_REASON', 'HL70501', -1),
    'CON_23': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NON_SUBJECT_CONSENTER_REASON', 'HL70502', -1),
    'CON_24': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'CONSENTER_ID', None, -1),
    'CON_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELATIONSHIP_TO_SUBJECT', 'HL70548', -1),
    'CSP_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDY_PHASE_IDENTIFIER', None, -1),
    'CSP_2': ('leaf', None, 'DTM', 'DATE_TIME_STUDY_PHASE_BEGAN', None, -1),
    'CSP_3': ('leaf', None, 'DTM', 'DATE_TIME_STUDY_PHASE_ENDED', None, -1),
    'CSP_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDY_PHASE_EVALUABILITY', 'HL79999', -1),
    'CSR_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SPONSOR_STUDY_ID', None, -1),
    'CSR_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ALTERNATE_STUDY_ID', None, -1),
    'CSR_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INSTITUTION_REGISTERING_THE_PATIENT', 'HL79999', -1),
    'CSR_4': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'SPONSOR_PATIENT_ID', None, -1),
    'CSR_5': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ALTERNATE_PATIENT_ID_CSR', None, -1),
    'CSR_6': ('leaf', None, 'DTM', 'DATE_TIME_OF_PATIENT_STUDY_REGISTRATION', None, -1),
    'CSR_7': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PERSON_PERFORMING_STUDY_REGISTRATION', None, -1),
    'CSR_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'STUDY_AUTHORIZING_PROVIDER', None, -1),
    'CSR_9': ('leaf', None, 'DTM', 'DATE_TIME_PATIENT_STUDY_CONSENT_SIGNED', None, -1),
    'CSR_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_STUDY_ELIGIBILITY_STATUS', 'HL79999', -1),
    'CSR_11': ('leaf', None, 'DTM', 'STUDY_RANDOMIZATION_DATE_TIME', None, -1),
    'CSR_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RANDOMIZED_STUDY_ARM', 'HL79999', -1),
    'CSR_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STRATUM_FOR_STUDY_RANDOMIZATION', 'HL79999', -1),
    'CSR_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_EVALUABILITY_STATUS', 'HL79999', -1),
    'CSR_15': ('leaf', None, 'DTM', 'DATE_TIME_ENDED_STUDY', None, -1),
    'CSR_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REASON_ENDED_STUDY', 'HL79999', -1),
    'CSS_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDY_SCHEDULED_TIME_POINT', 'HL79999', -1),
    'CSS_2': ('leaf', None, 'DTM', 'STUDY_SCHEDULED_PATIENT_TIME_POINT', None, -1),
    'CSS_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDY_QUALITY_CONTROL_CODES', 'HL79999', -1),
    'CTD_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTACT_ROLE', 'HL70131', -1),
    'CTD_2': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'CONTACT_NAME', None, -1),
    'CTD_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'CONTACT_ADDRESS', None, -1),
    'CTD_4': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'CONTACT_LOCATION', None, -1),
    'CTD_5': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_COMMUNICATION_INFORMATION', None, -1),
    'CTD_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185', -1),
    'CTD_7': ('sequence', DATATYPES_STRUCTS['PLN'], 'PLN', 'CONTACT_IDENTIFIERS', 'HL70338', -1),
    'CTI_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SPONSOR_STUDY_ID', None, -1),
    'CTI_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDY_PHASE_IDENTIFIER', None, -1),
    'CTI_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDY_SCHEDULED_TIME_POINT', 'HL79999', -1),
    'DB1_1': ('leaf', None, 'SI', 'SET_ID_DB1', None, -1),
    'DB1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISABLED_PERSON_CODE', 'HL70334', -1),
    'DB1_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'DISABLED_PERSON_IDENTIFIER', None, -1),
    'DB1_4': ('leaf', None, 'ID', 'DISABILITY_INDICATOR', 'HL70136', -1),
    'DB1_5': ('leaf', None, 'DT', 'DISABILITY_START_DATE', None, -1),
    'DB1_6': ('leaf', None, 'DT', 'DISABILITY_END_DATE', None, -1),
    'DB1_7': ('leaf', None, 'DT', 'DISABILITY_RETURN_TO_WORK_DATE', None, -1),
    'DB1_8': ('leaf', None, 'DT', 'DISABILITY_UNABLE_TO_WORK_DATE', None, -1),
    'DG1_1': ('leaf', None, 'SI', 'SET_ID_DG1', None, -1),
    'DG1_2': ('leaf', None, 'WD', 'DIAGNOSIS_CODING_METHOD', None, -1),
    'DG1_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DIAGNOSIS_CODE_DG1', 'HL70051', -1),
    'DG1_4': ('leaf', None, 'WD', 'DIAGNOSIS_DESCRIPTION', None, -1),
    'DG1_5': ('leaf', None, 'DTM', 'DIAGNOSIS_DATE_TIME', None, -1),
    'DG1_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DIAGNOSIS_TYPE', 'HL70052', -1),
    'DG1_15': ('leaf', None, 'NM', 'DIAGNOSIS_PRIORITY', 'HL70359', -1),
    'DG1_16': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DIAGNOSING_CLINICIAN', None, -1),
    'DG1_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DIAGNOSIS_CLASSIFICATION', 'HL70228', -1),
    'DG1_18': ('leaf', None, 'ID', 'CONFIDENTIAL_INDICATOR', 'HL70136', -1),
    'DG1_19': ('leaf', None, 'DTM', 'ATTESTATION_DATE_TIME', None, -1),
    'DG1_20': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'DIAGNOSIS_IDENTIFIER', None, -1),
    'DG1_21': ('leaf', None, 'ID', 'DIAGNOSIS_ACTION_CODE', 'HL70206', -1),
    'DG1_22': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_DIAGNOSIS', None, -1),
    'DG1_23': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DRG_CCL_VALUE_CODE', 'HL70728', -1),
    'DG1_24': ('leaf', None, 'ID', 'DRG_GROUPING_USAGE', 'HL70136', -1),
    'DG1_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DRG_DIAGNOSIS_DETERMINATION_STATUS', 'HL70731', -1),
    'DG1_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRESENT_ON_ADMISSION_POA_INDICATOR', 'HL70895', -1),
    'DMI_1': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DIAGNOSTIC_RELATED_GROUP', 'HL70055', -1),
    'DMI_2': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'MAJOR_DIAGNOSTIC_CATEGORY', 'HL70118', -1),
    'DMI_3': ('sequence', DATATYPES_STRUCTS['NR'], 'NR', 'LOWER_AND_UPPER_TRIM_POINTS', None, -1),
    'DMI_4': ('leaf', None, 'NM', 'AVERAGE_LENGTH_OF_STAY', None, -1),
    'DMI_5': ('leaf', None, 'NM', 'RELATIVE_WEIGHT', None, -1),
    'DON_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'DONATION_IDENTIFICATION_NUMBER_DIN', None, -1),
    'DON_2': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DONATION_TYPE', None, -1),
    'DON_3': ('leaf', None, 'DTM', 'PHLEBOTOMY_START_DATE_TIME', None, -1),
    'DON_4': ('leaf', None, 'DTM', 'PHLEBOTOMY_END_DATE_TIME', None, -1),
    'DON_5': ('leaf', None, 'NM', 'DONATION_DURATION', None, -1),
    'DON_6': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DONATION_DURATION_UNITS', 'HL70932', -1),
    'DON_7': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'INTENDED_PROCEDURE_TYPE', 'HL70933', -1),
    'DON_8': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'ACTUAL_PROCEDURE_TYPE', 'HL70933', -1),
    'DON_9': ('leaf', None, 'ID', 'DONOR_ELIGIBILITY_FLAG', 'HL70136', -1),
    'DON_10': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DONOR_ELIGIBILITY_PROCEDURE_TYPE', 'HL70933', -1),
    'DON_11': ('leaf', None, 'DTM', 'DONOR_ELIGIBILITY_DATE', None, -1),
    'DON_12': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCESS_INTERRUPTION', 'HL70923', -1),
    'DON_13': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCESS_INTERRUPTION_REASON', 'HL70935', -1),
    'DON_14': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PHLEBOTOMY_ISSUE', 'HL70925', -1),
    'DON_15': ('leaf', None, 'ID', 'INTENDED_RECIPIENT_BLOOD_RELATIVE', 'HL70136', -1),
    'DON_16': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'INTENDED_RECIPIENT_NAME', None, -1),
    'DON_17': ('leaf', None, 'DTM', 'INTENDED_RECIPIENT_DOB', None, -1),
    'DON_18': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INTENDED_RECIPIENT_FACILITY', None, -1),
    'DON_19': ('leaf', None, 'DTM', 'INTENDED_RECIPIENT_PROCEDURE_DATE', None, -1),
    'DON_20': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'INTENDED_RECIPIENT_ORDERING_PROVIDER', None, -1),
    'DON_21': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PHLEBOTOMY_STATUS', 'HL70926', -1),
    'DON_22': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'ARM_STICK', 'HL70927', -1),
    'DON_23': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'BLEED_START_PHLEBOTOMIST', None, -1),
    'DON_24': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'BLEED_END_PHLEBOTOMIST', None, -1),
    'DON_25': ('leaf', None, 'ST', 'APHAERESIS_TYPE_MACHINE', None, -1),
    'DON_26': ('leaf', None, 'ST', 'APHAERESIS_MACHINE_SERIAL_NUMBER', None, -1),
    'DON_27': ('leaf', None, 'ID', 'DONOR_REACTION', 'HL70136', -1),
    'DON_28': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'FINAL_REVIEW_STAFF_ID', None, -1),
    'DON_29': ('leaf', None, 'DTM', 'FINAL_REVIEW_DATE_TIME', None, -1),
    'DON_30': ('leaf', None, 'NM', 'NUMBER_OF_TUBES_COLLECTED', None, -1),
    'DON_31': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'DONATION_SAMPLE_IDENTIFIER', None, -1),
    'DON_32': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DONATION_ACCEPT_STAFF', None, -1),
    'DON_33': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DONATION_MATERIAL_REVIEW_STAFF', None, -1),
    'DRG_1': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DIAGNOSTIC_RELATED_GROUP', 'HL70055', -1),
    'DRG_2': ('leaf', None, 'DTM', 'DRG_ASSIGNED_DATE_TIME', None, -1),
    'DRG_3': ('leaf', None, 'ID', 'DRG_APPROVAL_INDICATOR', 'HL70136', -1),
    'DRG_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DRG_GROUPER_REVIEW_CODE', 'HL70056', -1),
    'DRG_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OUTLIER_TYPE', 'HL70083', -1),
    'DRG_6': ('leaf', None, 'NM', 'OUTLIER_DAYS', None, -1),
    'DRG_7': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'OUTLIER_COST', None, -1),
    'DRG_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DRG_PAYOR', 'HL70229', -1),
    'DRG_9': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'OUTLIER_REIMBURSEMENT', None, -1),
    'DRG_10': ('leaf', None, 'ID', 'CONFIDENTIAL_INDICATOR', 'HL70136', -1),
    'DRG_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DRG_TRANSFER_TYPE', 'HL70415', -1),
    'DRG_12': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'NAME_OF_CODER', None, -1),
    'DRG_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GROUPER_STATUS', 'HL70734', -1),
    'DRG_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PCCL_VALUE_CODE', 'HL70728', -1),
    'DRG_15': ('leaf', None, 'NM', 'EFFECTIVE_WEIGHT', None, -1),
    'DRG_16': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'MONETARY_AMOUNT', None, -1),
    'DRG_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_PATIENT', 'HL70739', -1),
    'DRG_18': ('leaf', None, 'ST', 'GROUPER_SOFTWARE_NAME', None, -1),
    'DRG_19': ('leaf', None, 'ST', 'GROUPER_SOFTWARE_VERSION', None, -1),
    'DRG_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_FINANCIAL_CALCULATION', 'HL70742', -1),
    'DRG_21': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'RELATIVE_DISCOUNT_SURCHARGE', None, -1),
    'DRG_22': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'BASIC_CHARGE', None, -1),
    'DRG_23': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'TOTAL_CHARGE', None, -1),
    'DRG_24': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'DISCOUNT_SURCHARGE', None, -1),
    'DRG_25': ('leaf', None, 'NM', 'CALCULATED_DAYS', None, -1),
    'DRG_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_GENDER', 'HL70749', -1),
    'DRG_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_AGE', 'HL70749', -1),
    'DRG_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_LENGTH_OF_STAY', 'HL70749', -1),
    'DRG_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_SAME_DAY_FLAG', 'HL70749', -1),
    'DRG_30': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_SEPARATION_MODE', 'HL70749', -1),
    'DRG_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_WEIGHT_AT_BIRTH', 'HL70755', -1),
    'DRG_32': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_RESPIRATION_MINUTES', 'HL70757', -1),
    'DRG_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STATUS_ADMISSION', 'HL70759', -1),
    'DSC_1': ('leaf', None, 'ST', 'CONTINUATION_POINTER', None, -1),
    'DSC_2': ('leaf', None, 'ID', 'CONTINUATION_STYLE', 'HL70398', -1),
    'DSP_1': ('leaf', None, 'SI', 'SET_ID_DSP', None, -1),
    'DSP_2': ('leaf', None, 'SI', 'DISPLAY_LEVEL', None, -1),
    'DSP_3': ('leaf', None, 'TX', 'DATA_LINE', None, -1),
    'DSP_4': ('leaf', None, 'ST', 'LOGICAL_BREAK_POINT', None, -1),
    'DSP_5': ('leaf', None, 'TX', 'RESULT_ID', None, -1),
    'ECD_1': ('leaf', None, 'NM', 'REFERENCE_COMMAND_NUMBER', None, -1),
    'ECD_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REMOTE_CONTROL_COMMAND', 'HL70368', -1),
    'ECD_3': ('leaf', None, 'ID', 'RESPONSE_REQUIRED', 'HL70136', -1),
    'ECD_4': ('leaf', None, 'WD', 'REQUESTED_COMPLETION_TIME', None, -1),
    'ECD_5': ('leaf', None, 'TX', 'PARAMETERS', None, -1),
    'ECR_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COMMAND_RESPONSE', 'HL70387', -1),
    'ECR_2': ('leaf', None, 'DTM', 'DATE_TIME_COMPLETED', None, -1),
    'ECR_3': ('leaf', None, 'TX', 'COMMAND_RESPONSE_PARAMETERS', None, -1),
    'EDU_1': ('leaf', None, 'SI', 'SET_ID_EDU', None, -1),
    'EDU_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACADEMIC_DEGREE', 'HL70360', -1),
    'EDU_3': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'ACADEMIC_DEGREE_PROGRAM_DATE_RANGE', None, -1),
    'EDU_4': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'ACADEMIC_DEGREE_PROGRAM_PARTICIPATION_DATE_RANGE', None, -1),
    'EDU_5': ('leaf', None, 'DT', 'ACADEMIC_DEGREE_GRANTED_DATE', None, -1),
    'EDU_6': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'SCHOOL', None, -1),
    'EDU_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SCHOOL_TYPE_CODE', 'HL70402', -1),
    'EDU_8': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'SCHOOL_ADDRESS', None, -1),
    'EDU_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MAJOR_FIELD_OF_STUDY', None, -1),
    'EQP_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EVENT_TYPE', 'HL70450', -1),
    'EQP_2': ('leaf', None, 'ST', 'FILE_NAME', None, -1),
    'EQP_3': ('leaf', None, 'DTM', 'START_DATE_TIME', None, -1),
    'EQP_4': ('leaf', None, 'DTM', 'END_DATE_TIME', None, -1),
    'EQP_5': ('leaf', None, 'FT', 'TRANSACTION_DATA', None, -1),
    'EQU_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EQUIPMENT_INSTANCE_IDENTIFIER', None, -1),
    'EQU_2': ('leaf', None, 'DTM', 'EVENT_DATE_TIME', None, -1),
    'EQU_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EQUIPMENT_STATE', 'HL70365', -1),
    'EQU_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCAL_REMOTE_CONTROL_STATE', 'HL70366', -1),
    'EQU_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALERT_LEVEL', 'HL70367', -1),
    'ERR_2': ('sequence', DATATYPES_STRUCTS['ERL'], 'ERL', 'ERROR_LOCATION', None, -1),
    'ERR_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HL7_ERROR_CODE', 'HL70357', -1),
    'ERR_4': ('leaf', None, 'ID', 'SEVERITY', 'HL70516', -1),
    'ERR_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPLICATION_ERROR_CODE', 'HL70533', -1),
    'ERR_6': ('leaf', None, 'ST', 'APPLICATION_ERROR_PARAMETER', None, -1),
    'ERR_7': ('leaf', None, 'TX', 'DIAGNOSTIC_INFORMATION', None, -1),
    'ERR_8': ('leaf', None, 'TX', 'USER_MESSAGE', None, -1),
    'ERR_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INFORM_PERSON_INDICATOR', 'HL70517', -1),
    'ERR_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OVERRIDE_TYPE', 'HL70518', -1),
    'ERR_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OVERRIDE_REASON_CODE', 'HL70519', -1),
    'ERR_12': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'HELP_DESK_CONTACT_POINT', None, -1),
    'EVN_2': ('leaf', None, 'DTM', 'RECORDED_DATE_TIME', None, -1),
    'EVN_3': ('leaf', None, 'DTM', 'DATE_TIME_PLANNED_EVENT', None, -1),
    'EVN_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EVENT_REASON_CODE', 'HL70062', -1),
    'EVN_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'OPERATOR_ID', 'HL70188', -1),
    'EVN_6': ('leaf', None, 'DTM', 'EVENT_OCCURRED', None, -1),
    'EVN_7': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'EVENT_FACILITY', None, -1),
    'FAC_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FACILITY_ID_FAC', None, -1),
    'FAC_2': ('leaf', None, 'ID', 'FACILITY_TYPE', 'HL70331', -1),
    'FAC_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'FACILITY_ADDRESS', None, -1),
    'FAC_4': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'FACILITY_TELECOMMUNICATION', None, -1),
    'FAC_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CONTACT_PERSON', None, -1),
    'FAC_6': ('leaf', None, 'ST', 'CONTACT_TITLE', None, -1),
    'FAC_7': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'CONTACT_ADDRESS', None, -1),
    'FAC_8': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_TELECOMMUNICATION', None, -1),
    'FAC_9': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'SIGNATURE_AUTHORITY', None, -1),
    'FAC_10': ('leaf', None, 'ST', 'SIGNATURE_AUTHORITY_TITLE', None, -1),
    'FAC_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'SIGNATURE_AUTHORITY_ADDRESS', None, -1),
    'FAC_12': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'SIGNATURE_AUTHORITY_TELECOMMUNICATION', None, -1),
    'FHS_1': ('leaf', None, 'ST', 'FILE_FIELD_SEPARATOR', None, -1),
    'FHS_2': ('leaf', None, 'ST', 'FILE_ENCODING_CHARACTERS', None, -1),
    'FHS_3': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'FILE_SENDING_APPLICATION', None, -1),
    'FHS_4': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'FILE_SENDING_FACILITY', None, -1),
    'FHS_5': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'FILE_RECEIVING_APPLICATION', None, -1),
    'FHS_6': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'FILE_RECEIVING_FACILITY', None, -1),
    'FHS_7': ('leaf', None, 'DTM', 'FILE_CREATION_DATE_TIME', None, -1),
    'FHS_8': ('leaf', None, 'ST', 'FILE_SECURITY', None, -1),
    'FHS_9': ('leaf', None, 'ST', 'FILE_NAME_ID', None, -1),
    'FHS_10': ('leaf', None, 'ST', 'FILE_HEADER_COMMENT', None, -1),
    'FHS_11': ('leaf', None, 'ST', 'FILE_CONTROL_ID', None, -1),
    'FHS_12': ('leaf', None, 'ST', 'REFERENCE_FILE_CONTROL_ID', None, -1),
    'FHS_13': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'FILE_SENDING_NETWORK_ADDRESS', None, -1),
    'FHS_14': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'FILE_RECEIVING_NETWORK_ADDRESS', None, -1),
    'FT1_1': ('leaf', None, 'SI', 'SET_ID_FT1', None, -1),
    'FT1_2': ('leaf', None, 'ST', 'TRANSACTION_ID', None, -1),
    'FT1_3': ('leaf', None, 'ST', 'TRANSACTION_BATCH_ID', None, -1),
    'FT1_4': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'TRANSACTION_DATE', None, -1),
    'FT1_5': ('leaf', None, 'DTM', 'TRANSACTION_POSTING_DATE', None, -1),
    'FT1_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSACTION_TYPE', 'HL70017', -1),
    'FT1_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSACTION_CODE', 'HL70132', -1),
    'FT1_10': ('leaf', None, 'NM', 'TRANSACTION_QUANTITY', None, -1),
    'FT1_11': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TRANSACTION_AMOUNT_EXTENDED', None, -1),
    'FT1_12': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TRANSACTION_AMOUNT_UNIT', None, -1),
    'FT1_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DEPARTMENT_CODE', 'HL70049', -1),
    'FT1_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HEALTH_PLAN_ID', 'HL70072', -1),
    'FT1_15': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'INSURANCE_AMOUNT', None, -1),
    'FT1_16': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ASSIGNED_PATIENT_LOCATION', None, -1),
    'FT1_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FEE_SCHEDULE', 'HL70024', -1),
    'FT1_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_TYPE', 'HL70018', -1),
    'FT1_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DIAGNOSIS_CODE_FT1', 'HL70051', -1),
    'FT1_20': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PERFORMED_BY_CODE', 'HL70084', -1),
    'FT1_21': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERED_BY_CODE', None, -1),
    'FT1_22': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'UNIT_COST', None, -1),
    'FT1_23': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'FT1_24': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY_CODE', None, -1),
    'FT1_25': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE', 'HL70088', -1),
    'FT1_26': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE_MODIFIER', 'HL70340', -1),
    'FT1_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADVANCED_BENEFICIARY_NOTICE_CODE', 'HL70339', -1),
    'FT1_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MEDICALLY_NECESSARY_DUPLICATE_PROCEDURE_REASON',
               'HL70476', -1),
    'FT1_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NDC_CODE', 'HL70549', -1),
    'FT1_30': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PAYMENT_REFERENCE_ID', None, -1),
    'FT1_31': ('leaf', None, 'SI', 'TRANSACTION_REFERENCE_KEY', None, -1),
    'FT1_32': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PERFORMING_FACILITY', None, -1),
    'FT1_33': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORDERING_FACILITY', None, -1),
    'FT1_34': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_NUMBER', None, -1),
    'FT1_35': ('leaf', None, 'ST', 'MODEL_NUMBER', None, -1),
    'FT1_36': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIAL_PROCESSING_CODE', None, -1),
    'FT1_37': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CLINIC_CODE', None, -1),
    'FT1_38': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'REFERRAL_NUMBER', None, -1),
    'FT1_39': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'AUTHORIZATION_NUMBER', None, -1),
    'FT1_40': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SERVICE_PROVIDER_TAXONOMY_CODE', None, -1),
    'FT1_41': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REVENUE_CODE', 'HL70456', -1),
    'FT1_42': ('leaf', None, 'ST', 'PRESCRIPTION_NUMBER', None, -1),
    'FT1_43': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NDC_QTY_AND_UOM', None, -1),
    'FTS_1': ('leaf', None, 'NM', 'FILE_BATCH_COUNT', None, -1),
    'FTS_2': ('leaf', None, 'ST', 'FILE_TRAILER_COMMENT', None, -1),
    'GOL_1': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'GOL_2': ('leaf', None, 'DTM', 'ACTION_DATE_TIME', None, -1),
    'GOL_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GOAL_ID', None, -1),
    'GOL_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'GOAL_INSTANCE_ID', None, -1),
    'GOL_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EPISODE_OF_CARE_ID', None, -1),
    'GOL_6': ('leaf', None, 'NM', 'GOAL_LIST_PRIORITY', None, -1),
    'GOL_7': ('leaf', None, 'DTM', 'GOAL_ESTABLISHED_DATE_TIME', None, -1),
    'GOL_8': ('leaf', None, 'DTM', 'EXPECTED_GOAL_ACHIEVE_DATE_TIME', None, -1),
    'GOL_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GOAL_CLASSIFICATION', None, -1),
    'GOL_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GOAL_MANAGEMENT_DISCIPLINE', None, -1),
    'GOL_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CURRENT_GOAL_REVIEW_STATUS', None, -1),
    'GOL_12': ('leaf', None, 'DTM', 'CURRENT_GOAL_REVIEW_DATE_TIME', None, -1),
    'GOL_13': ('leaf', None, 'DTM', 'NEXT_GOAL_REVIEW_DATE_TIME', None, -1),
    'GOL_14': ('leaf', None, 'DTM', 'PREVIOUS_GOAL_REVIEW_DATE_TIME', None, -1),
    'GOL_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GOAL_EVALUATION', None, -1),
    'GOL_17': ('leaf', None, 'ST', 'GOAL_EVALUATION_COMMENT', None, -1),
    'GOL_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GOAL_LIFE_CYCLE_STATUS', None, -1),
    'GOL_19': ('leaf', None, 'DTM', 'GOAL_LIFE_CYCLE_STATUS_DATE_TIME', None, -1),
    'GOL_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GOAL_TARGET_TYPE', None, -1),
    'GOL_21': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'GOAL_TARGET_NAME', None, -1),
    'GOL_22': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'MOOD_CODE', 'HL70725', -1),
    'GP1_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TYPE_OF_BILL_CODE', 'HL70455', -1),
    'GP1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REVENUE_CODE', 'HL70456', -1),
    'GP1_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OVERALL_CLAIM_DISPOSITION_CODE', 'HL70457', -1),
    'GP1_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OCE_EDITS_PER_VISIT_CODE', 'HL70458', -1),
    'GP1_5': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'OUTLIER_COST', None, -1),
    'GP2_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REVENUE_CODE', 'HL70456', -1),
    'GP2_2': ('leaf', None, 'NM', 'NUMBER_OF_SERVICE_UNITS', None, -1),
    'GP2_3': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'CHARGE', None, -1),
    'GP2_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REIMBURSEMENT_ACTION_CODE', 'HL70459', -1),
    'GP2_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DENIAL_OR_REJECTION_CODE', 'HL70460', -1),
    'GP2_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OCE_EDIT_CODE', 'HL70458', -1),
    'GP2_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AMBULATORY_PAYMENT_CLASSIFICATION_CODE', 'HL70466', -1),
    'GP2_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MODIFIER_EDIT_CODE', 'HL70467', -1),
    'GP2_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PAYMENT_ADJUSTMENT_CODE', 'HL70468', -1),
    'GP2_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PACKAGING_STATUS_CODE', 'HL70469', -1),
    'GP2_11': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'EXPECTED_CMS_PAYMENT_AMOUNT', None, -1),
    'GP2_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REIMBURSEMENT_TYPE_CODE', 'HL70470', -1),
    'GP2_13': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'CO_PAY_AMOUNT', None, -1),
    'GP2_14': ('leaf', None, 'NM', 'PAY_RATE_PER_SERVICE_UNIT', None, -1),
    'GT1_1': ('leaf', None, 'SI', 'SET_ID_GT1', None, -1),
    'GT1_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'GUARANTOR_NUMBER', None, -1),
    'GT1_3': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'GUARANTOR_NAME', None, -1),
    'GT1_4': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'GUARANTOR_SPOUSE_NAME', None, -1),
    'GT1_5': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'GUARANTOR_ADDRESS', None, -1),
    'GT1_6': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'GUARANTOR_PH_NUM_HOME', None, -1),
    'GT1_7': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'GUARANTOR_PH_NUM_BUSINESS', None, -1),
    'GT1_8': ('leaf', None, 'DTM', 'GUARANTOR_DATE_TIME_OF_BIRTH', None, -1),
    'GT1_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_ADMINISTRATIVE_SEX', 'HL70001', -1),
    'GT1_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_TYPE', 'HL70068', -1),
    'GT1_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_RELATIONSHIP', 'HL70063', -1),
    'GT1_12': ('leaf', None, 'ST', 'GUARANTOR_SSN', None, -1),
    'GT1_13': ('leaf', None, 'DT', 'GUARANTOR_DATE_BEGIN', None, -1),
    'GT1_14': ('leaf', None, 'DT', 'GUARANTOR_DATE_END', None, -1),
    'GT1_15': ('leaf', None, 'NM', 'GUARANTOR_PRIORITY', None, -1),
    'GT1_16': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'GUARANTOR_EMPLOYER_NAME', None, -1),
    'GT1_17': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'GUARANTOR_EMPLOYER_ADDRESS', None, -1),
    'GT1_18': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'GUARANTOR_EMPLOYER_PHONE_NUMBER', None, -1),
    'GT1_19': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'GUARANTOR_EMPLOYEE_ID_NUMBER', None, -1),
    'GT1_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_EMPLOYMENT_STATUS', 'HL70066', -1),
    'GT1_21': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'GUARANTOR_ORGANIZATION_NAME', None, -1),
    'GT1_22': ('leaf', None, 'ID', 'GUARANTOR_BILLING_HOLD_FLAG', 'HL70136', -1),
    'GT1_23': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_CREDIT_RATING_CODE', 'HL70341', -1),
    'GT1_24': ('leaf', None, 'DTM', 'GUARANTOR_DEATH_DATE_AND_TIME', None, -1),
    'GT1_25': ('leaf', None, 'ID', 'GUARANTOR_DEATH_FLAG', 'HL70136', -1),
    'GT1_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_CHARGE_ADJUSTMENT_CODE', 'HL70218', -1),
    'GT1_27': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'GUARANTOR_HOUSEHOLD_ANNUAL_INCOME', None, -1),
    'GT1_28': ('leaf', None, 'NM', 'GUARANTOR_HOUSEHOLD_SIZE', None, -1),
    'GT1_29': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'GUARANTOR_EMPLOYER_ID_NUMBER', None, -1),
    'GT1_30': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_MARITAL_STATUS_CODE', 'HL70002', -1),
    'GT1_31': ('leaf', None, 'DT', 'GUARANTOR_HIRE_EFFECTIVE_DATE', None, -1),
    'GT1_32': ('leaf', None, 'DT', 'EMPLOYMENT_STOP_DATE', None, -1),
    'GT1_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_DEPENDENCY', 'HL70223', -1),
    'GT1_34': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AMBULATORY_STATUS', 'HL70009', -1),
    'GT1_35': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CITIZENSHIP', 'HL70171', -1),
    'GT1_36': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_LANGUAGE', 'HL70296', -1),
    'GT1_37': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_ARRANGEMENT', 'HL70220', -1),
    'GT1_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PUBLICITY_CODE', 'HL70215', -1),
    'GT1_39': ('leaf', None, 'ID', 'PROTECTION_INDICATOR', 'HL70136', -1),
    'GT1_40': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDENT_INDICATOR', 'HL70231', -1),
    'GT1_41': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELIGION', 'HL70006', -1),
    'GT1_42': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'GT1_43': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NATIONALITY', 'HL70212', -1),
    'GT1_44': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ETHNIC_GROUP', 'HL70189', -1),
    'GT1_45': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'CONTACT_PERSON_S_NAME', None, -1),
    'GT1_46': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_PERSON_S_TELEPHONE_NUMBER', None, -1),
    'GT1_47': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTACT_REASON', 'HL70222', -1),
    'GT1_48': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTACT_RELATIONSHIP', 'HL70063', -1),
    'GT1_49': ('leaf', None, 'ST', 'JOB_TITLE', None, -1),
    'GT1_50': ('sequence', DATATYPES_STRUCTS['JCC'], 'JCC', 'JOB_CODE_CLASS', None, -1),
    'GT1_51': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'GUARANTOR_EMPLOYER_S_ORGANIZATION_NAME', None, -1),
    'GT1_52': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HANDICAP', 'HL70295', -1),
    'GT1_53': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'JOB_STATUS', 'HL70311', -1),
    'GT1_54': ('sequence', DATATYPES_STRUCTS['FC'], 'FC', 'GUARANTOR_FINANCIAL_CLASS', None, -1),
    'GT1_55': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_RACE', 'HL70005', -1),
    'GT1_56': ('leaf', None, 'ST', 'GUARANTOR_BIRTH_PLACE', None, -1),
    'GT1_57': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VIP_INDICATOR', 'HL70099', -1),
    'IAM_1': ('leaf', None, 'SI', 'SET_ID_IAM', None, -1),
    'IAM_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGEN_TYPE_CODE', 'HL70127', -1),
    'IAM_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGEN_CODE_MNEMONIC_DESCRIPTION', None, -1),
    'IAM_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGY_SEVERITY_CODE', 'HL70128', -1),
    'IAM_5': ('leaf', None, 'ST', 'ALLERGY_REACTION_CODE', None, -1),
    'IAM_6': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'ALLERGY_ACTION_CODE', 'HL70206', -1),
    'IAM_7': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ALLERGY_UNIQUE_IDENTIFIER', None, -1),
    'IAM_8': ('leaf', None, 'ST', 'ACTION_REASON', None, -1),
    'IAM_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SENSITIVITY_TO_CAUSATIVE_AGENT_CODE', 'HL70436', -1),
    'IAM_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGEN_GROUP_CODE_MNEMONIC_DESCRIPTION', None, -1),
    'IAM_11': ('leaf', None, 'DT', 'ONSET_DATE', None, -1),
    'IAM_12': ('leaf', None, 'ST', 'ONSET_DATE_TEXT', None, -1),
    'IAM_13': ('leaf', None, 'DTM', 'REPORTED_DATE_TIME', None, -1),
    'IAM_14': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'REPORTED_BY', None, -1),
    'IAM_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELATIONSHIP_TO_PATIENT_CODE', 'HL70063', -1),
    'IAM_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALERT_DEVICE_CODE', 'HL70437', -1),
    'IAM_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGY_CLINICAL_STATUS_CODE', 'HL70438', -1),
    'IAM_18': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'STATUSED_BY_PERSON', None, -1),
    'IAM_19': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'STATUSED_BY_ORGANIZATION', None, -1),
    'IAM_20': ('leaf', None, 'DTM', 'STATUSED_AT_DATE_TIME', None, -1),
    'IAM_21': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'INACTIVATED_BY_PERSON', None, -1),
    'IAM_22': ('leaf', None, 'DTM', 'INACTIVATED_DATE_TIME', None, -1),
    'IAM_23': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'INITIALLY_RECORDED_BY_PERSON', None, -1),
    'IAM_24': ('leaf', None, 'DTM', 'INITIALLY_RECORDED_DATE_TIME', None, -1),
    'IAM_25': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'MODIFIED_BY_PERSON', None, -1),
    'IAM_26': ('leaf', None, 'DTM', 'MODIFIED_DATE_TIME', None, -1),
    'IAM_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CLINICIAN_IDENTIFIED_CODE', None, -1),
    'IAM_28': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INITIALLY_RECORDED_BY_ORGANIZATION', None, -1),
    'IAM_29': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'MODIFIED_BY_ORGANIZATION', None, -1),
    'IAM_30': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INACTIVATED_BY_ORGANIZATION', None, -1),
    'IAR_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGY_REACTION_CODE', None, -1),
    'IAR_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALLERGY_SEVERITY_CODE', 'HL70128', -1),
    'IAR_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SENSITIVITY_TO_CAUSATIVE_AGENT_CODE', 'HL70436', -1),
    'IAR_4': ('leaf', None, 'ST', 'MANAGEMENT', None, -1),
    'IIM_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_KEY_VALUE_IIM', None, -1),
    'IIM_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SERVICE_ITEM_CODE', None, -1),
    'IIM_3': ('leaf', None, 'ST', 'INVENTORY_LOT_NUMBER', None, -1),
    'IIM_4': ('leaf', None, 'DTM', 'INVENTORY_EXPIRATION_DATE', None, -1),
    'IIM_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVENTORY_MANUFACTURER_NAME', None, -1),
    'IIM_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVENTORY_LOCATION', None, -1),
    'IIM_7': ('leaf', None, 'DTM', 'INVENTORY_RECEIVED_DATE', None, -1),
    'IIM_8': ('leaf', None, 'NM', 'INVENTORY_RECEIVED_QUANTITY', None, -1),
    'IIM_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVENTORY_RECEIVED_QUANTITY_UNIT', None, -1),
    'IIM_10': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'INVENTORY_RECEIVED_ITEM_COST', None, -1),
    'IIM_11': ('leaf', None, 'DTM', 'INVENTORY_ON_HAND_DATE', None, -1),
    'IIM_12': ('leaf', None, 'NM', 'INVENTORY_ON_HAND_QUANTITY', None, -1),
    'IIM_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVENTORY_ON_HAND_QUANTITY_UNIT', None, -1),
    'IIM_14': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE', 'HL70088', -1),
    'IIM_15': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE_MODIFIER', 'HL70340', -1),
    'ILT_1': ('leaf', None, 'SI', 'SET_ID_ILT', None, -1),
    'ILT_2': ('leaf', None, 'ST', 'INVENTORY_LOT_NUMBER', None, -1),
    'ILT_3': ('leaf', None, 'DTM', 'INVENTORY_EXPIRATION_DATE', None, -1),
    'ILT_4': ('leaf', None, 'DTM', 'INVENTORY_RECEIVED_DATE', None, -1),
    'ILT_5': ('leaf', None, 'NM', 'INVENTORY_RECEIVED_QUANTITY', None, -1),
    'ILT_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVENTORY_RECEIVED_QUANTITY_UNIT', None, -1),
    'ILT_7': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'INVENTORY_RECEIVED_ITEM_COST', None, -1),
    'ILT_8': ('leaf', None, 'DTM', 'INVENTORY_ON_HAND_DATE', None, -1),
    'ILT_9': ('leaf', None, 'NM', 'INVENTORY_ON_HAND_QUANTITY', None, -1),
    'ILT_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVENTORY_ON_HAND_QUANTITY_UNIT', None, -1),
    'IN1_1': ('leaf', None, 'SI', 'SET_ID_IN1', None, -1),
    'IN1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HEALTH_PLAN_ID', 'HL70072', -1),
    'IN1_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'INSURANCE_COMPANY_ID', None, -1),
    'IN1_4': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INSURANCE_COMPANY_NAME', None, -1),
    'IN1_5': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'INSURANCE_COMPANY_ADDRESS', None, -1),
    'IN1_6': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'INSURANCE_CO_CONTACT_PERSON', None, -1),
    'IN1_7': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURANCE_CO_PHONE_NUMBER', None, -1),
    'IN1_8': ('leaf', None, 'ST', 'GROUP_NUMBER', None, -1),
    'IN1_9': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'GROUP_NAME', None, -1),
    'IN1_10': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'INSURED_S_GROUP_EMP_ID', None, -1),
    'IN1_11': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INSURED_S_GROUP_EMP_NAME', None, -1),
    'IN1_12': ('leaf', None, 'DT', 'PLAN_EFFECTIVE_DATE', None, -1),
    'IN1_13': ('leaf', None, 'DT', 'PLAN_EXPIRATION_DATE', None, -1),
    'IN1_14': ('sequence', DATATYPES_STRUCTS['AUI'], 'AUI', 'AUTHORIZATION_INFORMATION', None, -1),
    'IN1_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PLAN_TYPE', 'HL70086', -1),
    'IN1_16': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'NAME_OF_INSURED', None, -1),
    'IN1_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INSURED_S_RELATIONSHIP_TO_PATIENT', 'HL70063', -1),
    'IN1_18': ('leaf', None, 'DTM', 'INSURED_S_DATE_OF_BIRTH', None, -1),
    'IN1_19': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'INSURED_S_ADDRESS', None, -1),
    'IN1_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ASSIGNMENT_OF_BENEFITS', 'HL70135', -1),
    'IN1_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COORDINATION_OF_BENEFITS', 'HL70173', -1),
    'IN1_22': ('leaf', None, 'ST', 'COORD_OF_BEN_PRIORITY', None, -1),
    'IN1_23': ('leaf', None, 'ID', 'NOTICE_OF_ADMISSION_FLAG', 'HL70136', -1),
    'IN1_24': ('leaf', None, 'DT', 'NOTICE_OF_ADMISSION_DATE', None, -1),
    'IN1_25': ('leaf', None, 'ID', 'REPORT_OF_ELIGIBILITY_FLAG', 'HL70136', -1),
    'IN1_26': ('leaf', None, 'DT', 'REPORT_OF_ELIGIBILITY_DATE', None, -1),
    'IN1_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELEASE_INFORMATION_CODE', 'HL70093', -1),
    'IN1_28': ('leaf', None, 'ST', 'PRE_ADMIT_CERT_PAC', None, -1),
    'IN1_29': ('leaf', None, 'DTM', 'VERIFICATION_DATE_TIME', None, -1),
    'IN1_30': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'VERIFICATION_BY', None, -1),
    'IN1_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TYPE_OF_AGREEMENT_CODE', 'HL70098', -1),
    'IN1_32': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BILLING_STATUS', 'HL70022', -1),
    'IN1_33': ('leaf', None, 'NM', 'LIFETIME_RESERVE_DAYS', None, -1),
    'IN1_34': ('leaf', None, 'NM', 'DELAY_BEFORE_L_R_DAY', None, -1),
    'IN1_35': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COMPANY_PLAN_CODE', 'HL70042', -1),
    'IN1_36': ('leaf', None, 'ST', 'POLICY_NUMBER', None, -1),
    'IN1_37': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'POLICY_DEDUCTIBLE', None, -1),
    'IN1_39': ('leaf', None, 'NM', 'POLICY_LIMIT_DAYS', None, -1),
    'IN1_42': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INSURED_S_EMPLOYMENT_STATUS', 'HL70066', -1),
    'IN1_43': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INSURED_S_ADMINISTRATIVE_SEX', 'HL70001', -1),
    'IN1_44': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'INSURED_S_EMPLOYER_S_ADDRESS', None, -1),
    'IN1_45': ('leaf', None, 'ST', 'VERIFICATION_STATUS', None, -1),
    'IN1_46': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIOR_INSURANCE_PLAN_ID', 'HL70072', -1),
    'IN1_47': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COVERAGE_TYPE', 'HL70309', -1),
    'IN1_48': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HANDICAP', 'HL70295', -1),
    'IN1_49': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'INSURED_S_ID_NUMBER', None, -1),
    'IN1_50': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SIGNATURE_CODE', 'HL70535', -1),
    'IN1_51': ('leaf', None, 'DT', 'SIGNATURE_CODE_DATE', None, -1),
    'IN1_52': ('leaf', None, 'ST', 'INSURED_S_BIRTH_PLACE', None, -1),
    'IN1_53': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VIP_INDICATOR', 'HL70099', -1),
    'IN1_54': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'EXTERNAL_HEALTH_PLAN_IDENTIFIERS', None, -1),
    'IN1_55': ('leaf', None, 'ID', 'INSURANCE_ACTION_CODE', 'HL70206', -1),
    'IN2_1': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'INSURED_S_EMPLOYEE_ID', None, -1),
    'IN2_2': ('leaf', None, 'ST', 'INSURED_S_SOCIAL_SECURITY_NUMBER', None, -1),
    'IN2_3': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'INSURED_S_EMPLOYER_S_NAME_AND_ID', None, -1),
    'IN2_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EMPLOYER_INFORMATION_DATA', 'HL70139', -1),
    'IN2_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MAIL_CLAIM_PARTY', 'HL70137', -1),
    'IN2_6': ('leaf', None, 'ST', 'MEDICARE_HEALTH_INS_CARD_NUMBER', None, -1),
    'IN2_7': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MEDICAID_CASE_NAME', None, -1),
    'IN2_8': ('leaf', None, 'ST', 'MEDICAID_CASE_NUMBER', None, -1),
    'IN2_9': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MILITARY_SPONSOR_NAME', None, -1),
    'IN2_10': ('leaf', None, 'ST', 'MILITARY_ID_NUMBER', None, -1),
    'IN2_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DEPENDENT_OF_MILITARY_RECIPIENT', 'HL70342', -1),
    'IN2_12': ('leaf', None, 'ST', 'MILITARY_ORGANIZATION', None, -1),
    'IN2_13': ('leaf', None, 'ST', 'MILITARY_STATION', None, -1),
    'IN2_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MILITARY_SERVICE', 'HL70140', -1),
    'IN2_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MILITARY_RANK_GRADE', 'HL70141', -1),
    'IN2_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MILITARY_STATUS', 'HL70142', -1),
    'IN2_17': ('leaf', None, 'DT', 'MILITARY_RETIRE_DATE', None, -1),
    'IN2_18': ('leaf', None, 'ID', 'MILITARY_NON_AVAIL_CERT_ON_FILE', 'HL70136', -1),
    'IN2_19': ('leaf', None, 'ID', 'BABY_COVERAGE', 'HL70136', -1),
    'IN2_20': ('leaf', None, 'ID', 'COMBINE_BABY_BILL', 'HL70136', -1),
    'IN2_21': ('leaf', None, 'ST', 'BLOOD_DEDUCTIBLE', None, -1),
    'IN2_22': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'SPECIAL_COVERAGE_APPROVAL_NAME', None, -1),
    'IN2_23': ('leaf', None, 'ST', 'SPECIAL_COVERAGE_APPROVAL_TITLE', None, -1),
    'IN2_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NON_COVERED_INSURANCE_CODE', 'HL70143', -1),
    'IN2_25': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PAYOR_ID', None, -1),
    'IN2_26': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PAYOR_SUBSCRIBER_ID', None, -1),
    'IN2_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ELIGIBILITY_SOURCE', 'HL70144', -1),
    'IN2_28': ('sequence', DATATYPES_STRUCTS['RMC'], 'RMC', 'ROOM_COVERAGE_TYPE_AMOUNT', None, -1),
    'IN2_29': ('sequence', DATATYPES_STRUCTS['PTA'], 'PTA', 'POLICY_TYPE_AMOUNT', None, -1),
    'IN2_30': ('sequence', DATATYPES_STRUCTS['DDI'], 'DDI', 'DAILY_DEDUCTIBLE', None, -1),
    'IN2_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_DEPENDENCY', 'HL70223', -1),
    'IN2_32': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AMBULATORY_STATUS', 'HL70009', -1),
    'IN2_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CITIZENSHIP', 'HL70171', -1),
    'IN2_34': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_LANGUAGE', 'HL70296', -1),
    'IN2_35': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_ARRANGEMENT', 'HL70220', -1),
    'IN2_36': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PUBLICITY_CODE', 'HL70215', -1),
    'IN2_37': ('leaf', None, 'ID', 'PROTECTION_INDICATOR', 'HL70136', -1),
    'IN2_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDENT_INDICATOR', 'HL70231', -1),
    'IN2_39': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELIGION', 'HL70006', -1),
    'IN2_40': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'IN2_41': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NATIONALITY', 'HL70212', -1),
    'IN2_42': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ETHNIC_GROUP', 'HL70189', -1),
    'IN2_43': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MARITAL_STATUS', 'HL70002', -1),
    'IN2_44': ('leaf', None, 'DT', 'INSURED_S_EMPLOYMENT_START_DATE', None, -1),
    'IN2_45': ('leaf', None, 'DT', 'EMPLOYMENT_STOP_DATE', None, -1),
    'IN2_46': ('leaf', None, 'ST', 'JOB_TITLE', None, -1),
    'IN2_47': ('sequence', DATATYPES_STRUCTS['JCC'], 'JCC', 'JOB_CODE_CLASS', None, -1),
    'IN2_48': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'JOB_STATUS', 'HL70311', -1),
    'IN2_49': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'EMPLOYER_CONTACT_PERSON_NAME', None, -1),
    'IN2_50': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'EMPLOYER_CONTACT_PERSON_PHONE_NUMBER', None, -1),
    'IN2_51': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EMPLOYER_CONTACT_REASON', 'HL70222', -1),
    'IN2_52': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'INSURED_S_CONTACT_PERSON_S_NAME', None, -1),
    'IN2_53': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURED_S_CONTACT_PERSON_PHONE_NUMBER', None, -1),
    'IN2_54': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INSURED_S_CONTACT_PERSON_REASON', 'HL70222', -1),
    'IN2_55': ('leaf', None, 'DT', 'RELATIONSHIP_TO_THE_PATIENT_START_DATE', None, -1),
    'IN2_56': ('leaf', None, 'DT', 'RELATIONSHIP_TO_THE_PATIENT_STOP_DATE', None, -1),
    'IN2_57': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INSURANCE_CO_CONTACT_REASON', 'HL70232', -1),
    'IN2_58': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURANCE_CO_CONTACT_PHONE_NUMBER', None, -1),
    'IN2_59': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'POLICY_SCOPE', 'HL70312', -1),
    'IN2_60': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'POLICY_SOURCE', 'HL70313', -1),
    'IN2_61': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PATIENT_MEMBER_NUMBER', None, -1),
    'IN2_62': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GUARANTOR_S_RELATIONSHIP_TO_INSURED', 'HL70063', -1),
    'IN2_63': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURED_S_PHONE_NUMBER_HOME', None, -1),
    'IN2_64': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'INSURED_S_EMPLOYER_PHONE_NUMBER', None, -1),
    'IN2_65': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MILITARY_HANDICAPPED_PROGRAM', 'HL70343', -1),
    'IN2_66': ('leaf', None, 'ID', 'SUSPEND_FLAG', 'HL70136', -1),
    'IN2_67': ('leaf', None, 'ID', 'COPAY_LIMIT_FLAG', 'HL70136', -1),
    'IN2_68': ('leaf', None, 'ID', 'STOPLOSS_LIMIT_FLAG', 'HL70136', -1),
    'IN2_69': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INSURED_ORGANIZATION_NAME_AND_ID', None, -1),
    'IN2_70': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'INSURED_EMPLOYER_ORGANIZATION_NAME_AND_ID', None, -1),
    'IN2_71': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RACE', 'HL70005', -1),
    'IN2_72': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_S_RELATIONSHIP_TO_INSURED', 'HL70344', -1),
    'IN3_1': ('leaf', None, 'SI', 'SET_ID_IN3', None, -1),
    'IN3_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'CERTIFICATION_NUMBER', None, -1),
    'IN3_3': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CERTIFIED_BY', None, -1),
    'IN3_4': ('leaf', None, 'ID', 'CERTIFICATION_REQUIRED', 'HL70136', -1),
    'IN3_5': ('sequence', DATATYPES_STRUCTS['MOP'], 'MOP', 'PENALTY', None, -1),
    'IN3_6': ('leaf', None, 'DTM', 'CERTIFICATION_DATE_TIME', None, -1),
    'IN3_7': ('leaf', None, 'DTM', 'CERTIFICATION_MODIFY_DATE_TIME', None, -1),
    'IN3_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'OPERATOR', None, -1),
    'IN3_9': ('leaf', None, 'DT', 'CERTIFICATION_BEGIN_DATE', None, -1),
    'IN3_10': ('leaf', None, 'DT', 'CERTIFICATION_END_DATE', None, -1),
    'IN3_11': ('sequence', DATATYPES_STRUCTS['DTN'], 'DTN', 'DAYS', None, -1),
    'IN3_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NON_CONCUR_CODE_DESCRIPTION', 'HL70233', -1),
    'IN3_13': ('leaf', None, 'DTM', 'NON_CONCUR_EFFECTIVE_DATE_TIME', None, -1),
    'IN3_14': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PHYSICIAN_REVIEWER', 'HL70010', -1),
    'IN3_15': ('leaf', None, 'ST', 'CERTIFICATION_CONTACT', None, -1),
    'IN3_16': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CERTIFICATION_CONTACT_PHONE_NUMBER', None, -1),
    'IN3_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPEAL_REASON', 'HL70345', -1),
    'IN3_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CERTIFICATION_AGENCY', 'HL70346', -1),
    'IN3_19': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CERTIFICATION_AGENCY_PHONE_NUMBER', None, -1),
    'IN3_20': ('sequence', DATATYPES_STRUCTS['ICD'], 'ICD', 'PRE_CERTIFICATION_REQUIREMENT', 'HL70136', -1),
    'IN3_21': ('leaf', None, 'ST', 'CASE_MANAGER', None, -1),
    'IN3_22': ('leaf', None, 'DT', 'SECOND_OPINION_DATE', None, -1),
    'IN3_23': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SECOND_OPINION_STATUS', 'HL70151', -1),
    'IN3_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SECOND_OPINION_DOCUMENTATION_RECEIVED', 'HL70152', -1),
    'IN3_25': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'SECOND_OPINION_PHYSICIAN', 'HL70010', -1),
    'IN3_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CERTIFICATION_TYPE', 'HL70921', -1),
    'IN3_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CERTIFICATION_CATEGORY', 'HL70922', -1),
    'INV_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBSTANCE_IDENTIFIER', 'HL70451', -1),
    'INV_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBSTANCE_STATUS', 'HL70383', -1),
    'INV_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBSTANCE_TYPE', 'HL70384', -1),
    'INV_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVENTORY_CONTAINER_IDENTIFIER', 'HL79999', -1),
    'INV_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTAINER_CARRIER_IDENTIFIER', 'HL79999', -1),
    'INV_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'POSITION_ON_CARRIER', 'HL79999', -1),
    'INV_7': ('leaf', None, 'NM', 'INITIAL_QUANTITY', None, -1),
    'INV_8': ('leaf', None, 'NM', 'CURRENT_QUANTITY', None, -1),
    'INV_9': ('leaf', None, 'NM', 'AVAILABLE_QUANTITY', None, -1),
    'INV_10': ('leaf', None, 'NM', 'CONSUMPTION_QUANTITY', None, -1),
    'INV_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'QUANTITY_UNITS', 'HL79999', -1),
    'INV_12': ('leaf', None, 'DTM', 'EXPIRATION_DATE_TIME', None, -1),
    'INV_13': ('leaf', None, 'DTM', 'FIRST_USED_DATE_TIME', None, -1),
    'INV_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TEST_FLUID_IDENTIFIER_S', 'HL79999', -1),
    'INV_16': ('leaf', None, 'ST', 'MANUFACTURER_LOT_NUMBER', None, -1),
    'INV_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MANUFACTURER_IDENTIFIER', 'HL70385', -1),
    'INV_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUPPLIER_IDENTIFIER', 'HL70386', -1),
    'INV_19': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'ON_BOARD_STABILITY_TIME', None, -1),
    'INV_20': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TARGET_VALUE', None, -1),
    'IPC_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ACCESSION_IDENTIFIER', None, -1),
    'IPC_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'REQUESTED_PROCEDURE_ID', None, -1),
    'IPC_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'STUDY_INSTANCE_UID', None, -1),
    'IPC_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SCHEDULED_PROCEDURE_STEP_ID', None, -1),
    'IPC_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MODALITY', 'HL79999', -1),
    'IPC_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROTOCOL_CODE', 'HL79999', -1),
    'IPC_7': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SCHEDULED_STATION_NAME', None, -1),
    'IPC_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SCHEDULED_PROCEDURE_STEP_LOCATION', 'HL79999', -1),
    'IPC_9': ('leaf', None, 'ST', 'SCHEDULED_STATION_AE_TITLE', None, -1),
    'IPR_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'IPR_IDENTIFIER', None, -1),
    'IPR_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_CROSS_REFERENCE_IDENTIFIER', None, -1),
    'IPR_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PAYER_CROSS_REFERENCE_IDENTIFIER', None, -1),
    'IPR_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'IPR_STATUS', 'HL70571', -1),
    'IPR_5': ('leaf', None, 'DTM', 'IPR_DATE_TIME', None, -1),
    'IPR_6': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'ADJUDICATED_PAID_AMOUNT', None, -1),
    'IPR_7': ('leaf', None, 'DTM', 'EXPECTED_PAYMENT_DATE_TIME', None, -1),
    'IPR_8': ('leaf', None, 'ST', 'IPR_CHECKSUM', None, -1),
    'ISD_1': ('leaf', None, 'NM', 'REFERENCE_INTERACTION_NUMBER', None, -1),
    'ISD_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INTERACTION_TYPE_IDENTIFIER', 'HL70368', -1),
    'ISD_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INTERACTION_ACTIVE_STATE', 'HL70387', -1),
    'ITM_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ITEM_IDENTIFIER', None, -1),
    'ITM_2': ('leaf', None, 'ST', 'ITEM_DESCRIPTION', None, -1),
    'ITM_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_STATUS', 'HL70776', -1),
    'ITM_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_TYPE', 'HL70778', -1),
    'ITM_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_CATEGORY', None, -1),
    'ITM_6': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'SUBJECT_TO_EXPIRATION_INDICATOR', 'HL70532', -1),
    'ITM_7': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'MANUFACTURER_IDENTIFIER', None, -1),
    'ITM_8': ('leaf', None, 'ST', 'MANUFACTURER_NAME', None, -1),
    'ITM_9': ('leaf', None, 'ST', 'MANUFACTURER_CATALOG_NUMBER', None, -1),
    'ITM_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MANUFACTURER_LABELER_IDENTIFICATION_CODE', None, -1),
    'ITM_11': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PATIENT_CHARGEABLE_INDICATOR', 'HL70532', -1),
    'ITM_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSACTION_CODE', 'HL70132', -1),
    'ITM_13': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TRANSACTION_AMOUNT_UNIT', None, -1),
    'ITM_14': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'STOCKED_ITEM_INDICATOR', 'HL70532', -1),
    'ITM_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUPPLY_RISK_CODES', 'HL70871', -1),
    'ITM_16': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'APPROVING_REGULATORY_AGENCY', 'HL70790', -1),
    'ITM_17': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'LATEX_INDICATOR', 'HL70532', -1),
    'ITM_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RULING_ACT', 'HL70793', -1),
    'ITM_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_NATURAL_ACCOUNT_CODE', 'HL70320', -1),
    'ITM_20': ('leaf', None, 'NM', 'APPROVED_TO_BUY_QUANTITY', None, -1),
    'ITM_21': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'APPROVED_TO_BUY_PRICE', None, -1),
    'ITM_22': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'TAXABLE_ITEM_INDICATOR', 'HL70532', -1),
    'ITM_23': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'FREIGHT_CHARGE_INDICATOR', 'HL70532', -1),
    'ITM_24': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'ITEM_SET_INDICATOR', 'HL70532', -1),
    'ITM_25': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ITEM_SET_IDENTIFIER', None, -1),
    'ITM_26': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'TRACK_DEPARTMENT_USAGE_INDICATOR', 'HL70532', -1),
    'ITM_27': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE', 'HL70088', -1),
    'ITM_28': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE_MODIFIER', 'HL70340', -1),
    'ITM_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIAL_HANDLING_CODE', 'HL70376', -1),
    'ITM_30': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'HAZARDOUS_INDICATOR', 'HL70532', -1),
    'ITM_31': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'STERILE_INDICATOR', 'HL70532', -1),
    'ITM_32': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'MATERIAL_DATA_SAFETY_SHEET_NUMBER', None, -1),
    'ITM_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNITED_NATIONS_STANDARD_PRODUCTS_AND_SERVICES_CODE_UNSPSC',
               'HL70396', -1),
    'IVC_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_INVOICE_NUMBER', None, -1),
    'IVC_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PAYER_INVOICE_NUMBER', None, -1),
    'IVC_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'CONTRACT_AGREEMENT_NUMBER', None, -1),
    'IVC_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVOICE_CONTROL', 'HL70553', -1),
    'IVC_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVOICE_REASON', 'HL70554', -1),
    'IVC_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INVOICE_TYPE', 'HL70555', -1),
    'IVC_7': ('leaf', None, 'DTM', 'INVOICE_DATE_TIME', None, -1),
    'IVC_8': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'INVOICE_AMOUNT', None, -1),
    'IVC_9': ('leaf', None, 'ST', 'PAYMENT_TERMS', None, -1),
    'IVC_10': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PROVIDER_ORGANIZATION', None, -1),
    'IVC_11': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PAYER_ORGANIZATION', None, -1),
    'IVC_12': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ATTENTION', None, -1),
    'IVC_13': ('leaf', None, 'ID', 'LAST_INVOICE_INDICATOR', 'HL70136', -1),
    'IVC_14': ('leaf', None, 'DTM', 'INVOICE_BOOKING_PERIOD', None, -1),
    'IVC_15': ('leaf', None, 'ST', 'ORIGIN', None, -1),
    'IVC_16': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'INVOICE_FIXED_AMOUNT', None, -1),
    'IVC_17': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'SPECIAL_COSTS', None, -1),
    'IVC_18': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'AMOUNT_FOR_DOCTORS_TREATMENT', None, -1),
    'IVC_19': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'RESPONSIBLE_PHYSICIAN', None, -1),
    'IVC_20': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'COST_CENTER', None, -1),
    'IVC_21': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'INVOICE_PREPAID_AMOUNT', None, -1),
    'IVC_22': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TOTAL_INVOICE_AMOUNT_WITHOUT_PREPAID_AMOUNT', None, -1),
    'IVC_23': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TOTAL_AMOUNT_OF_VAT', None, -1),
    'IVC_24': ('leaf', None, 'NM', 'VAT_RATES_APPLIED', None, -1),
    'IVC_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BENEFIT_GROUP', 'HL70556', -1),
    'IVC_26': ('leaf', None, 'ST', 'PROVIDER_TAX_ID', None, -1),
    'IVC_27': ('leaf', None, 'ST', 'PAYER_TAX_ID', None, -1),
    'IVC_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROVIDER_TAX_STATUS', 'HL70572', -1),
    'IVC_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PAYER_TAX_STATUS', 'HL70572', -1),
    'IVC_30': ('leaf', None, 'ST', 'SALES_TAX_ID', None, -1),
    'IVT_1': ('leaf', None, 'SI', 'SET_ID_IVT', None, -1),
    'IVT_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'INVENTORY_LOCATION_IDENTIFIER', None, -1),
    'IVT_3': ('leaf', None, 'ST', 'INVENTORY_LOCATION_NAME', None, -1),
    'IVT_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SOURCE_LOCATION_IDENTIFIER', None, -1),
    'IVT_5': ('leaf', None, 'ST', 'SOURCE_LOCATION_NAME', None, -1),
    'IVT_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_STATUS', 'HL70625', -1),
    'IVT_7': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'BIN_LOCATION_IDENTIFIER', None, -1),
    'IVT_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORDER_PACKAGING', 'HL70818', -1),
    'IVT_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ISSUE_PACKAGING', None, -1),
    'IVT_10': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'DEFAULT_INVENTORY_ASSET_ACCOUNT', None, -1),
    'IVT_11': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PATIENT_CHARGEABLE_INDICATOR', 'HL70532', -1),
    'IVT_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSACTION_CODE', 'HL70132', -1),
    'IVT_13': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TRANSACTION_AMOUNT_UNIT', None, -1),
    'IVT_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_IMPORTANCE_CODE', 'HL70634', -1),
    'IVT_15': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'STOCKED_ITEM_INDICATOR', 'HL70532', -1),
    'IVT_16': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'CONSIGNMENT_ITEM_INDICATOR', 'HL70532', -1),
    'IVT_17': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'REUSABLE_ITEM_INDICATOR', 'HL70532', -1),
    'IVT_18': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'REUSABLE_COST', None, -1),
    'IVT_19': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SUBSTITUTE_ITEM_IDENTIFIER', None, -1),
    'IVT_20': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'LATEX_FREE_SUBSTITUTE_ITEM_IDENTIFIER', None, -1),
    'IVT_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RECOMMENDED_REORDER_THEORY', 'HL70642', -1),
    'IVT_22': ('leaf', None, 'NM', 'RECOMMENDED_SAFETY_STOCK_DAYS', None, -1),
    'IVT_23': ('leaf', None, 'NM', 'RECOMMENDED_MAXIMUM_DAYS_INVENTORY', None, -1),
    'IVT_24': ('leaf', None, 'NM', 'RECOMMENDED_ORDER_POINT', None, -1),
    'IVT_25': ('leaf', None, 'NM', 'RECOMMENDED_ORDER_AMOUNT', None, -1),
    'IVT_26': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'OPERATING_ROOM_PAR_LEVEL_INDICATOR', 'HL70532', -1),
    'LAN_1': ('leaf', None, 'SI', 'SET_ID_LAN', None, -1),
    'LAN_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LANGUAGE_CODE', 'HL70296', -1),
    'LAN_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LANGUAGE_ABILITY_CODE', 'HL70403', -1),
    'LAN_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LANGUAGE_PROFICIENCY_CODE', 'HL70404', -1),
    'LCC_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LCC', None, -1),
    'LCC_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_DEPARTMENT', 'HL70264', -1),
    'LCC_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACCOMMODATION_TYPE', 'HL70129', -1),
    'LCC_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CHARGE_CODE', 'HL70132', -1),
    'LCH_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LCH', None, -1),
    'LCH_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'LCH_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SEGMENT_UNIQUE_KEY', None, -1),
    'LCH_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_CHARACTERISTIC_ID', 'HL70324', -1),
    'LCH_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_CHARACTERISTIC_VALUE_LCH', 'HL70136', -1),
    'LDP_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LDP', None, -1),
    'LDP_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_DEPARTMENT', 'HL70264', -1),
    'LDP_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_SERVICE', 'HL70069', -1),
    'LDP_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIALTY_TYPE', 'HL70265', -1),
    'LDP_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VALID_PATIENT_CLASSES', 'HL70004', -1),
    'LDP_6': ('leaf', None, 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183', -1),
    'LDP_7': ('leaf', None, 'DTM', 'ACTIVATION_DATE_LDP', None, -1),
    'LDP_8': ('leaf', None, 'DTM', 'INACTIVATION_DATE_LDP', None, -1),
    'LDP_9': ('leaf', None, 'ST', 'INACTIVATED_REASON', None, -1),
    'LDP_10': ('sequence', DATATYPES_STRUCTS['VH'], 'VH', 'VISITING_HOURS', 'HL70267', -1),
    'LDP_11': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_PHONE', None, -1),
    'LDP_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_COST_CENTER', 'HL70462', -1),
    'LOC_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LOC', None, -1),
    'LOC_2': ('leaf', None, 'ST', 'LOCATION_DESCRIPTION', None, -1),
    'LOC_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_TYPE_LOC', 'HL70260', -1),
    'LOC_4': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORGANIZATION_NAME_LOC', None, -1),
    'LOC_5': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'LOCATION_ADDRESS', None, -1),
    'LOC_6': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'LOCATION_PHONE', None, -1),
    'LOC_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LICENSE_NUMBER', 'HL70461', -1),
    'LOC_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_EQUIPMENT', 'HL70261', -1),
    'LOC_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_SERVICE_CODE', 'HL70442', -1),
    'LRL_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIMARY_KEY_VALUE_LRL', None, -1),
    'LRL_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'LRL_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SEGMENT_UNIQUE_KEY', None, -1),
    'LRL_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION_RELATIONSHIP_ID', 'HL70325', -1),
    'LRL_5': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORGANIZATIONAL_LOCATION_RELATIONSHIP_VALUE', None, -1),
    'LRL_6': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PATIENT_LOCATION_RELATIONSHIP_VALUE', None, -1),
    'MFA_1': ('leaf', None, 'ID', 'RECORD_LEVEL_EVENT_CODE', 'HL70180', -1),
    'MFA_2': ('leaf', None, 'ST', 'MFN_CONTROL_ID', None, -1),
    'MFA_3': ('leaf', None, 'DTM', 'EVENT_COMPLETION_DATE_TIME', None, -1),
    'MFA_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MFN_RECORD_LEVEL_ERROR_RETURN', 'HL70181', -1),
    'MFA_5': ('leaf', None, 'varies', 'PRIMARY_KEY_VALUE_MFA', 'HL79999', -1),
    'MFA_6': ('leaf', None, 'ID', 'PRIMARY_KEY_VALUE_TYPE_MFA', 'HL70355', -1),
    'MFE_1': ('leaf', None, 'ID', 'RECORD_LEVEL_EVENT_CODE', 'HL70180', -1),
    'MFE_2': ('leaf', None, 'ST', 'MFN_CONTROL_ID', None, -1),
    'MFE_3': ('leaf', None, 'DTM', 'EFFECTIVE_DATE_TIME', None, -1),
    'MFE_4': ('leaf', None, 'varies', 'PRIMARY_KEY_VALUE_MFE', 'HL79999', -1),
    'MFE_5': ('leaf', None, 'ID', 'PRIMARY_KEY_VALUE_TYPE', 'HL70355', -1),
    'MFE_6': ('leaf', None, 'DTM', 'ENTERED_DATE_TIME', None, -1),
    'MFE_7': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY', None, -1),
    'MFI_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MASTER_FILE_IDENTIFIER', 'HL70175', -1),
    'MFI_2': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'MASTER_FILE_APPLICATION_IDENTIFIER', 'HL70361', -1),
    'MFI_3': ('leaf', None, 'ID', 'FILE_LEVEL_EVENT_CODE', 'HL70178', -1),
    'MFI_4': ('leaf', None, 'DTM', 'ENTERED_DATE_TIME', None, -1),
    'MFI_5': ('leaf', None, 'DTM', 'EFFECTIVE_DATE_TIME', None, -1),
    'MFI_6': ('leaf', None, 'ID', 'RESPONSE_LEVEL_CODE', 'HL70179', -1),
    'MRG_1': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_PATIENT_IDENTIFIER_LIST', 'HL70061', -1),
    'MRG_2': ('leaf', None, 'WD', 'PRIOR_ALTERNATE_PATIENT_ID', None, -1),
    'MRG_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_PATIENT_ACCOUNT_NUMBER', 'HL70061', -1),
    'MRG_4': ('leaf', None, 'WD', 'PRIOR_PATIENT_ID', None, -1),
    'MRG_5': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_VISIT_NUMBER', 'HL70061', -1),
    'MRG_6': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRIOR_ALTERNATE_VISIT_ID', 'HL70061', -1),
    'MRG_7': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PRIOR_PATIENT_NAME', 'HL70200', -1),
    'MSA_1': ('leaf', None, 'ID', 'ACKNOWLEDGMENT_CODE', 'HL70008', -1),
    'MSA_2': ('leaf', None, 'ST', 'MESSAGE_CONTROL_ID', None, -1),
    'MSA_3': ('leaf', None, 'WD', 'TEXT_MESSAGE', None, -1),
    'MSA_4': ('leaf', None, 'NM', 'EXPECTED_SEQUENCE_NUMBER', None, -1),
    'MSA_5': ('leaf', None, 'WD', 'DELAYED_ACKNOWLEDGMENT_TYPE', None, -1),
    'MSA_6': ('leaf', None, 'WD', 'ERROR_CONDITION', None, -1),
    'MSA_7': ('leaf', None, 'NM', 'MESSAGE_WAITING_NUMBER', None, -1),
    'MSA_8': ('leaf', None, 'ID', 'MESSAGE_WAITING_PRIORITY', 'HL70520', -1),
    'MSH_1': ('leaf', None, 'ST', 'FIELD_SEPARATOR', None, -1),
    'MSH_2': ('leaf', None, 'ST', 'ENCODING_CHARACTERS', None, -1),
    'MSH_3': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'SENDING_APPLICATION', 'HL70361', -1),
    'MSH_4': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'SENDING_FACILITY', 'HL70362', -1),
    'MSH_5': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'RECEIVING_APPLICATION', 'HL70361', -1),
    'MSH_6': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'RECEIVING_FACILITY', 'HL70362', -1),
    'MSH_7': ('leaf', None, 'DTM', 'DATE_TIME_OF_MESSAGE', None, -1),
    'MSH_8': ('leaf', None, 'ST', 'SECURITY', None, -1),
    'MSH_9': ('sequence', DATATYPES_STRUCTS['MSG'], 'MSG', 'MESSAGE_TYPE', None, -1),
    'MSH_10': ('leaf', None, 'ST', 'MESSAGE_CONTROL_ID', None, -1),
    'MSH_11': ('sequence', DATATYPES_STRUCTS['PT'], 'PT', 'PROCESSING_ID', None, -1),
    'MSH_12': ('sequence', DATATYPES_STRUCTS['VID'], 'VID', 'VERSION_ID', None, -1),
    'MSH_13': ('leaf', None, 'NM', 'SEQUENCE_NUMBER', None, -1),
    'MSH_14': ('leaf', None, 'ST', 'CONTINUATION_POINTER', None, -1),
    'MSH_15': ('leaf', None, 'ID', 'ACCEPT_ACKNOWLEDGMENT_TYPE', 'HL70155', -1),
    'MSH_16': ('leaf', None, 'ID', 'APPLICATION_ACKNOWLEDGMENT_TYPE', 'HL70155', -1),
    'MSH_17': ('leaf', None, 'ID', 'COUNTRY_CODE', 'HL70399', -1),
    'MSH_18': ('leaf', None, 'ID', 'CHARACTER_SET', 'HL70211', -1),
    'MSH_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRINCIPAL_LANGUAGE_OF_MESSAGE', None, -1),
    'MSH_20': ('leaf', None, 'ID', 'ALTERNATE_CHARACTER_SET_HANDLING_SCHEME', 'HL70356', -1),
    'MSH_21': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'MESSAGE_PROFILE_IDENTIFIER', None, -1),
    'MSH_22': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'SENDING_RESPONSIBLE_ORGANIZATION', None, -1),
    'MSH_23': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'RECEIVING_RESPONSIBLE_ORGANIZATION', None, -1),
    'MSH_24': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'SENDING_NETWORK_ADDRESS', None, -1),
    'MSH_25': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'RECEIVING_NETWORK_ADDRESS', None, -1),
    'NCK_1': ('leaf', None, 'DTM', 'SYSTEM_DATE_TIME', None, -1),
    'NDS_1': ('leaf', None, 'NM', 'NOTIFICATION_REFERENCE_NUMBER', None, -1),
    'NDS_2': ('leaf', None, 'DTM', 'NOTIFICATION_DATE_TIME', None, -1),
    'NDS_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NOTIFICATION_ALERT_SEVERITY', 'HL70367', -1),
    'NDS_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NOTIFICATION_CODE', 'HL79999', -1),
    'NK1_1': ('leaf', None, 'SI', 'SET_ID_NK1', None, -1),
    'NK1_2': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'NAME', 'HL70200', -1),
    'NK1_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELATIONSHIP', 'HL70063', -1),
    'NK1_4': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ADDRESS', None, -1),
    'NK1_5': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE_NUMBER', None, -1),
    'NK1_6': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'BUSINESS_PHONE_NUMBER', None, -1),
    'NK1_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTACT_ROLE', 'HL70131', -1),
    'NK1_8': ('leaf', None, 'DT', 'START_DATE', None, -1),
    'NK1_9': ('leaf', None, 'DT', 'END_DATE', None, -1),
    'NK1_10': ('leaf', None, 'ST', 'NEXT_OF_KIN_ASSOCIATED_PARTIES_JOB_TITLE', None, -1),
    'NK1_11': ('sequence', DATATYPES_STRUCTS['JCC'], 'JCC', 'NEXT_OF_KIN_ASSOCIATED_PARTIES_JOB_CODE_CLASS', None, -1),
    'NK1_12': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'NEXT_OF_KIN_ASSOCIATED_PARTIES_EMPLOYEE_NUMBER', None, -1),
    'NK1_13': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORGANIZATION_NAME_NK1', None, -1),
    'NK1_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MARITAL_STATUS', 'HL70002', -1),
    'NK1_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATIVE_SEX', 'HL70001', -1),
    'NK1_16': ('leaf', None, 'DTM', 'DATE_TIME_OF_BIRTH', None, -1),
    'NK1_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_DEPENDENCY', 'HL70223', -1),
    'NK1_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AMBULATORY_STATUS', 'HL70009', -1),
    'NK1_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CITIZENSHIP', 'HL70171', -1),
    'NK1_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_LANGUAGE', 'HL70296', -1),
    'NK1_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_ARRANGEMENT', 'HL70220', -1),
    'NK1_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PUBLICITY_CODE', 'HL70215', -1),
    'NK1_23': ('leaf', None, 'ID', 'PROTECTION_INDICATOR', 'HL70136', -1),
    'NK1_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDENT_INDICATOR', 'HL70231', -1),
    'NK1_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELIGION', 'HL70006', -1),
    'NK1_26': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'NK1_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NATIONALITY', 'HL70212', -1),
    'NK1_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ETHNIC_GROUP', 'HL70189', -1),
    'NK1_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTACT_REASON', 'HL70222', -1),
    'NK1_30': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'CONTACT_PERSON_S_NAME', None, -1),
    'NK1_31': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_PERSON_S_TELEPHONE_NUMBER', None, -1),
    'NK1_32': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'CONTACT_PERSON_S_ADDRESS', None, -1),
    'NK1_33': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'NEXT_OF_KIN_ASSOCIATED_PARTY_S_IDENTIFIERS', None, -1),
    'NK1_34': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'JOB_STATUS', 'HL70311', -1),
    'NK1_35': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RACE', 'HL70005', -1),
    'NK1_36': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HANDICAP', 'HL70295', -1),
    'NK1_37': ('leaf', None, 'ST', 'CONTACT_PERSON_SOCIAL_SECURITY_NUMBER', None, -1),
    'NK1_38': ('leaf', None, 'ST', 'NEXT_OF_KIN_BIRTH_PLACE', None, -1),
    'NK1_39': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VIP_INDICATOR', 'HL70099', -1),
    'NK1_40': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'NEXT_OF_KIN_TELECOMMUNICATION_INFORMATION', None, -1),
    'NK1_41': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CONTACT_PERSON_S_TELECOMMUNICATION_INFORMATION', None, -1),
    'NPU_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'BED_LOCATION', None, -1),
    'NPU_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BED_STATUS', 'HL70116', -1),
    'NSC_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPLICATION_CHANGE_TYPE', 'HL70409', -1),
    'NSC_2': ('leaf', None, 'ST', 'CURRENT_CPU', None, -1),
    'NSC_3': ('leaf', None, 'ST', 'CURRENT_FILESERVER', None, -1),
    'NSC_4': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'CURRENT_APPLICATION', 'HL70361', -1),
    'NSC_5': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'CURRENT_FACILITY', 'HL70362', -1),
    'NSC_6': ('leaf', None, 'ST', 'NEW_CPU', None, -1),
    'NSC_7': ('leaf', None, 'ST', 'NEW_FILESERVER', None, -1),
    'NSC_8': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'NEW_APPLICATION', 'HL70361', -1),
    'NSC_9': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'NEW_FACILITY', 'HL70362', -1),
    'NST_1': ('leaf', None, 'ID', 'STATISTICS_AVAILABLE', 'HL70136', -1),
    'NST_2': ('leaf', None, 'ST', 'SOURCE_IDENTIFIER', None, -1),
    'NST_3': ('leaf', None, 'ID', 'SOURCE_TYPE', 'HL70332', -1),
    'NST_4': ('leaf', None, 'DTM', 'STATISTICS_START', None, -1),
    'NST_5': ('leaf', None, 'DTM', 'STATISTICS_END', None, -1),
    'NST_6': ('leaf', None, 'NM', 'RECEIVE_CHARACTER_COUNT', None, -1),
    'NST_7': ('leaf', None, 'NM', 'SEND_CHARACTER_COUNT', None, -1),
    'NST_8': ('leaf', None, 'NM', 'MESSAGES_RECEIVED', None, -1),
    'NST_9': ('leaf', None, 'NM', 'MESSAGES_SENT', None, -1),
    'NST_10': ('leaf', None, 'NM', 'CHECKSUM_ERRORS_RECEIVED', None, -1),
    'NST_11': ('leaf', None, 'NM', 'LENGTH_ERRORS_RECEIVED', None, -1),
    'NST_12': ('leaf', None, 'NM', 'OTHER_ERRORS_RECEIVED', None, -1),
    'NST_13': ('leaf', None, 'NM', 'CONNECT_TIMEOUTS', None, -1),
    'NST_14': ('leaf', None, 'NM', 'RECEIVE_TIMEOUTS', None, -1),
    'NST_15': ('leaf', None, 'NM', 'APPLICATION_CONTROL_LEVEL_ERRORS', None, -1),
    'NTE_1': ('leaf', None, 'SI', 'SET_ID_NTE', None, -1),
    'NTE_2': ('leaf', None, 'ID', 'SOURCE_OF_COMMENT', 'HL70105', -1),
    'NTE_3': ('leaf', None, 'FT', 'COMMENT', None, -1),
    'NTE_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COMMENT_TYPE', 'HL70364', -1),
    'NTE_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY', None, -1),
    'NTE_6': ('leaf', None, 'DTM', 'ENTERED_DATE_TIME', None, -1),
    'NTE_7': ('leaf', None, 'DTM', 'EFFECTIVE_START_DATE', None, -1),
    'NTE_8': ('leaf', None, 'DTM', 'EXPIRATION_DATE', None, -1),
    'OBR_1': ('leaf', None, 'SI', 'SET_ID_OBR', None, -1),
    'OBR_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_ORDER_NUMBER', None, -1),
    'OBR_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'OBR_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNIVERSAL_SERVICE_IDENTIFIER', None, -1),
    'OBR_5': ('leaf', None, 'WD', 'PRIORITY', None, -1),
    'OBR_6': ('leaf', None, 'WD', 'REQUESTED_DATE_TIME', None, -1),
    'OBR_7': ('leaf', None, 'DTM', 'OBSERVATION_DATE_TIME', None, -1),
    'OBR_8': ('leaf', None, 'DTM', 'OBSERVATION_END_DATE_TIME', None, -1),
    'OBR_9': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'COLLECTION_VOLUME', None, -1),
    'OBR_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'COLLECTOR_IDENTIFIER', None, -1),
    'OBR_11': ('leaf', None, 'ID', 'SPECIMEN_ACTION_CODE', 'HL70065', -1),
    'OBR_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DANGER_CODE', 'HL79999', -1),
    'OBR_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELEVANT_CLINICAL_INFORMATION', 'HL70916', -1),
    'OBR_16': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERING_PROVIDER', None, -1),
    'OBR_17': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ORDER_CALLBACK_PHONE_NUMBER', None, -1),
    'OBR_18': ('leaf', None, 'ST', 'PLACER_FIELD_1', None, -1),
    'OBR_19': ('leaf', None, 'ST', 'PLACER_FIELD_2', None, -1),
    'OBR_20': ('leaf', None, 'ST', 'FILLER_FIELD_1', None, -1),
    'OBR_21': ('leaf', None, 'ST', 'FILLER_FIELD_2', None, -1),
    'OBR_22': ('leaf', None, 'DTM', 'RESULTS_RPT_STATUS_CHNG_DATE_TIME', None, -1),
    'OBR_23': ('sequence', DATATYPES_STRUCTS['MOC'], 'MOC', 'CHARGE_TO_PRACTICE', None, -1),
    'OBR_24': ('leaf', None, 'ID', 'DIAGNOSTIC_SERV_SECT_ID', 'HL70074', -1),
    'OBR_25': ('leaf', None, 'ID', 'RESULT_STATUS', 'HL70123', -1),
    'OBR_26': ('sequence', DATATYPES_STRUCTS['PRL'], 'PRL', 'PARENT_RESULT', None, -1),
    'OBR_28': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'RESULT_COPIES_TO', None, -1),
    'OBR_29': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'PARENT_RESULTS_OBSERVATION_IDENTIFIER', None, -1),
    'OBR_30': ('leaf', None, 'ID', 'TRANSPORTATION_MODE', 'HL70124', -1),
    'OBR_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REASON_FOR_STUDY', 'HL79999', -1),
    'OBR_32': ('sequence', DATATYPES_STRUCTS['NDL'], 'NDL', 'PRINCIPAL_RESULT_INTERPRETER', None, -1),
    'OBR_33': ('sequence', DATATYPES_STRUCTS['NDL'], 'NDL', 'ASSISTANT_RESULT_INTERPRETER', None, -1),
    'OBR_34': ('sequence', DATATYPES_STRUCTS['NDL'], 'NDL', 'TECHNICIAN', None, -1),
    'OBR_35': ('sequence', DATATYPES_STRUCTS['NDL'], 'NDL', 'TRANSCRIPTIONIST', None, -1),
    'OBR_36': ('leaf', None, 'DTM', 'SCHEDULED_DATE_TIME', None, -1),
    'OBR_37': ('leaf', None, 'NM', 'NUMBER_OF_SAMPLE_CONTAINERS', None, -1),
    'OBR_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSPORT_LOGISTICS_OF_COLLECTED_SAMPLE', 'HL79999', -1),
    'OBR_39': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COLLECTOR_S_COMMENT', 'HL79999', -1),
    'OBR_40': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSPORT_ARRANGEMENT_RESPONSIBILITY', 'HL79999', -1),
    'OBR_41': ('leaf', None, 'ID', 'TRANSPORT_ARRANGED', 'HL70224', -1),
    'OBR_42': ('leaf', None, 'ID', 'ESCORT_REQUIRED', 'HL70225', -1),
    'OBR_43': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PLANNED_PATIENT_TRANSPORT_COMMENT', 'HL79999', -1),
    'OBR_44': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE', 'HL70088', -1),
    'OBR_45': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE_MODIFIER', 'HL70340', -1),
    'OBR_46': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PLACER_SUPPLEMENTAL_SERVICE_INFORMATION', 'HL70411', -1),
    'OBR_47': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FILLER_SUPPLEMENTAL_SERVICE_INFORMATION', 'HL70411', -1),
    'OBR_48': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MEDICALLY_NECESSARY_DUPLICATE_PROCEDURE_REASON',
               'HL70476', -1),
    'OBR_49': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RESULT_HANDLING', 'HL70507', -1),
    'OBR_50': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PARENT_UNIVERSAL_SERVICE_IDENTIFIER', None, -1),
    'OBR_51': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'OBSERVATION_GROUP_ID', None, -1),
    'OBR_52': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_OBSERVATION_GROUP_ID', None, -1),
    'OBR_53': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ALTERNATE_PLACER_ORDER_NUMBER', None, -1),
    'OBR_54': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'PARENT_ORDER', None, -1),
    'OBX_1': ('leaf', None, 'SI', 'SET_ID_OBX', None, -1),
    'OBX_2': ('leaf', None, 'ID', 'VALUE_TYPE', 'HL70125', -1),
    'OBX_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OBSERVATION_IDENTIFIER', 'HL79999', -1),
    'OBX_4': ('leaf', None, 'ST', 'OBSERVATION_SUB_ID', None, -1),
    'OBX_5': ('leaf', None, 'varies', 'OBSERVATION_VALUE', None, -1),
    'OBX_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNITS', 'HL79999', -1),
    'OBX_7': ('leaf', None, 'ST', 'REFERENCES_RANGE', None, -1),
    'OBX_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INTERPRETATION_CODES', 'HL70078', -1),
    'OBX_9': ('leaf', None, 'NM', 'PROBABILITY', None, -1),
    'OBX_10': ('leaf', None, 'ID', 'NATURE_OF_ABNORMAL_TEST', 'HL70080', -1),
    'OBX_11': ('leaf', None, 'ID', 'OBSERVATION_RESULT_STATUS', 'HL70085', -1),
    'OBX_12': ('leaf', None, 'DTM', 'EFFECTIVE_DATE_OF_REFERENCE_RANGE', None, -1),
    'OBX_13': ('leaf', None, 'ST', 'USER_DEFINED_ACCESS_CHECKS', None, -1),
    'OBX_14': ('leaf', None, 'DTM', 'DATE_TIME_OF_THE_OBSERVATION', None, -1),
    'OBX_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCER_S_ID', 'HL79999', -1),
    'OBX_16': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'RESPONSIBLE_OBSERVER', None, -1),
    'OBX_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OBSERVATION_METHOD', 'HL79999', -1),
    'OBX_18': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EQUIPMENT_INSTANCE_IDENTIFIER', None, -1),
    'OBX_19': ('leaf', None, 'DTM', 'DATE_TIME_OF_THE_ANALYSIS', None, -1),
    'OBX_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OBSERVATION_SITE', 'HL70163', -1),
    'OBX_21': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'OBSERVATION_INSTANCE_IDENTIFIER', None, -1),
    'OBX_22': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'MOOD_CODE', 'HL70725', -1),
    'OBX_23': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PERFORMING_ORGANIZATION_NAME', None, -1),
    'OBX_24': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PERFORMING_ORGANIZATION_ADDRESS', None, -1),
    'OBX_25': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PERFORMING_ORGANIZATION_MEDICAL_DIRECTOR', None, -1),
    'OBX_26': ('leaf', None, 'ID', 'PATIENT_RESULTS_RELEASE_CATEGORY', 'HL70909', -1),
    'OBX_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ROOT_CAUSE', 'HL70914', -1),
    'OBX_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCAL_PROCESS_CONTROL', 'HL70915', -1),
    'OBX_29': ('leaf', None, 'ID', 'OBSERVATION_TYPE', 'HL70936', -1),
    'ODS_1': ('leaf', None, 'ID', 'TYPE', 'HL70159', -1),
    'ODS_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SERVICE_PERIOD', 'HL79999', -1),
    'ODS_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DIET_SUPPLEMENT_OR_PREFERENCE_CODE', 'HL79999', -1),
    'ODS_4': ('leaf', None, 'ST', 'TEXT_INSTRUCTION', None, -1),
    'ODT_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRAY_TYPE', 'HL70160', -1),
    'ODT_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SERVICE_PERIOD', 'HL79999', -1),
    'ODT_3': ('leaf', None, 'ST', 'TEXT_INSTRUCTION', None, -1),
    'OM1_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCER_S_SERVICE_TEST_OBSERVATION_ID', 'HL79999', -1),
    'OM1_3': ('leaf', None, 'ID', 'PERMITTED_DATA_TYPES', 'HL70125', -1),
    'OM1_4': ('leaf', None, 'ID', 'SPECIMEN_REQUIRED', 'HL70136', -1),
    'OM1_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCER_ID', 'HL79999', -1),
    'OM1_6': ('leaf', None, 'TX', 'OBSERVATION_DESCRIPTION', None, -1),
    'OM1_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OTHER_SERVICE_TEST_OBSERVATION_IDS_FOR_THE_OBSERVATION',
              'HL79999', -1),
    'OM1_8': ('leaf', None, 'ST', 'OTHER_NAMES', None, -1),
    'OM1_9': ('leaf', None, 'ST', 'PREFERRED_REPORT_NAME_FOR_THE_OBSERVATION', None, -1),
    'OM1_10': ('leaf', None, 'ST', 'PREFERRED_SHORT_NAME_OR_MNEMONIC_FOR_THE_OBSERVATION', None, -1),
    'OM1_11': ('leaf', None, 'ST', 'PREFERRED_LONG_NAME_FOR_THE_OBSERVATION', None, -1),
    'OM1_12': ('leaf', None, 'ID', 'ORDERABILITY', 'HL70136', -1),
    'OM1_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'IDENTITY_OF_INSTRUMENT_USED_TO_PERFORM_THIS_STUDY',
               'HL79999', -1),
    'OM1_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CODED_REPRESENTATION_OF_METHOD', 'HL79999', -1),
    'OM1_15': ('leaf', None, 'ID', 'PORTABLE_DEVICE_INDICATOR', 'HL70136', -1),
    'OM1_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OBSERVATION_PRODUCING_DEPARTMENT_SECTION', 'HL79999', -1),
    'OM1_17': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'TELEPHONE_NUMBER_OF_SECTION', None, -1),
    'OM1_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NATURE_OF_SERVICE_TEST_OBSERVATION', 'HL70174', -1),
    'OM1_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REPORT_SUBHEADER', 'HL79999', -1),
    'OM1_20': ('leaf', None, 'ST', 'REPORT_DISPLAY_ORDER', None, -1),
    'OM1_21': ('leaf', None, 'DTM', 'DATE_TIME_STAMP_FOR_ANY_CHANGE_IN_DEFINITION_FOR_THE_OBSERVATION', None, -1),
    'OM1_22': ('leaf', None, 'DTM', 'EFFECTIVE_DATE_TIME_OF_CHANGE', None, -1),
    'OM1_23': ('leaf', None, 'NM', 'TYPICAL_TURN_AROUND_TIME', None, -1),
    'OM1_24': ('leaf', None, 'NM', 'PROCESSING_TIME', None, -1),
    'OM1_25': ('leaf', None, 'ID', 'PROCESSING_PRIORITY', 'HL70168', -1),
    'OM1_26': ('leaf', None, 'ID', 'REPORTING_PRIORITY', 'HL70169', -1),
    'OM1_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OUTSIDE_SITE_S_WHERE_OBSERVATION_MAY_BE_PERFORMED',
               'HL79999', -1),
    'OM1_28': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ADDRESS_OF_OUTSIDE_SITE_S', None, -1),
    'OM1_29': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE_NUMBER_OF_OUTSIDE_SITE', None, -1),
    'OM1_30': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONFIDENTIALITY_CODE', 'HL70177', -1),
    'OM1_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OBSERVATIONS_REQUIRED_TO_INTERPRET_THIS_OBSERVATION',
               'HL79999', -1),
    'OM1_32': ('leaf', None, 'TX', 'INTERPRETATION_OF_OBSERVATIONS', None, -1),
    'OM1_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTRAINDICATIONS_TO_OBSERVATIONS', 'HL79999', -1),
    'OM1_34': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REFLEX_TESTS_OBSERVATIONS', 'HL79999', -1),
    'OM1_35': ('leaf', None, 'TX', 'RULES_THAT_TRIGGER_REFLEX_TESTING', None, -1),
    'OM1_36': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FIXED_CANNED_MESSAGE', 'HL79999', -1),
    'OM1_37': ('leaf', None, 'TX', 'PATIENT_PREPARATION', None, -1),
    'OM1_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROCEDURE_MEDICATION', 'HL79999', -1),
    'OM1_39': ('leaf', None, 'TX', 'FACTORS_THAT_MAY_AFFECT_THE_OBSERVATION', None, -1),
    'OM1_40': ('leaf', None, 'ST', 'SERVICE_TEST_OBSERVATION_PERFORMANCE_SCHEDULE', None, -1),
    'OM1_41': ('leaf', None, 'TX', 'DESCRIPTION_OF_TEST_METHODS', None, -1),
    'OM1_42': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'KIND_OF_QUANTITY_OBSERVED', 'HL70254', -1),
    'OM1_43': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'POINT_VERSUS_INTERVAL', 'HL70255', -1),
    'OM1_44': ('leaf', None, 'TX', 'CHALLENGE_INFORMATION', 'HL70256', -1),
    'OM1_45': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELATIONSHIP_MODIFIER', 'HL70258', -1),
    'OM1_46': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TARGET_ANATOMIC_SITE_OF_TEST', 'HL79999', -1),
    'OM1_47': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MODALITY_OF_IMAGING_MEASUREMENT', 'HL70910', -1),
    'OM1_48': ('leaf', None, 'ID', 'EXCLUSIVE_TEST', 'HL70919', -1),
    'OM1_49': ('leaf', None, 'ID', 'DIAGNOSTIC_SERV_SECT_ID', 'HL70074', -1),
    'OM1_50': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TAXONOMIC_CLASSIFICATION_CODE', None, -1),
    'OM1_51': ('leaf', None, 'ST', 'OTHER_NAMES', None, -1),
    'OM1_52': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REPLACEMENT_PRODUCER_S_SERVICE_TEST_OBSERVATION_ID',
               'HL79999', -1),
    'OM1_53': ('leaf', None, 'TX', 'PRIOR_RESUTS_INSTRUCTIONS', None, -1),
    'OM1_54': ('leaf', None, 'TX', 'SPECIAL_INSTRUCTIONS', None, -1),
    'OM1_55': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TEST_CATEGORY', None, -1),
    'OM2_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM2_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNITS_OF_MEASURE', 'HL79999', -1),
    'OM2_3': ('leaf', None, 'NM', 'RANGE_OF_DECIMAL_PRECISION', None, -1),
    'OM2_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CORRESPONDING_SI_UNITS_OF_MEASURE', 'HL79999', -1),
    'OM2_5': ('leaf', None, 'TX', 'SI_CONVERSION_FACTOR', None, -1),
    'OM2_6': ('sequence', DATATYPES_STRUCTS['RFR'], 'RFR',
              'REFERENCE_NORMAL_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS', None, -1),
    'OM2_7': ('sequence', DATATYPES_STRUCTS['RFR'], 'RFR', 'CRITICAL_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS',
              None, -1),
    'OM2_8': ('sequence', DATATYPES_STRUCTS['RFR'], 'RFR', 'ABSOLUTE_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS',
              None, -1),
    'OM2_9': ('sequence', DATATYPES_STRUCTS['DLT'], 'DLT', 'DELTA_CHECK_CRITERIA', None, -1),
    'OM2_10': ('leaf', None, 'NM', 'MINIMUM_MEANINGFUL_INCREMENTS', None, -1),
    'OM3_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM3_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PREFERRED_CODING_SYSTEM', 'HL79999', -1),
    'OM3_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VALID_CODED_ANSWERS', 'HL79999', -1),
    'OM3_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NORMAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS',
              'HL79999', -1),
    'OM3_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ABNORMAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS',
              'HL79999', -1),
    'OM3_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CRITICAL_TEXT_CODES_FOR_CATEGORICAL_OBSERVATIONS',
              'HL79999', -1),
    'OM3_7': ('leaf', None, 'ID', 'VALUE_TYPE', 'HL70125', -1),
    'OM4_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM4_2': ('leaf', None, 'ID', 'DERIVED_SPECIMEN', 'HL70170', -1),
    'OM4_3': ('leaf', None, 'TX', 'CONTAINER_DESCRIPTION', None, -1),
    'OM4_4': ('leaf', None, 'NM', 'CONTAINER_VOLUME', None, -1),
    'OM4_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTAINER_UNITS', 'HL79999', -1),
    'OM4_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN', 'HL79999', -1),
    'OM4_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADDITIVE', 'HL70371', -1),
    'OM4_8': ('leaf', None, 'TX', 'PREPARATION', None, -1),
    'OM4_9': ('leaf', None, 'TX', 'SPECIAL_HANDLING_REQUIREMENTS', None, -1),
    'OM4_10': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NORMAL_COLLECTION_VOLUME', None, -1),
    'OM4_11': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'MINIMUM_COLLECTION_VOLUME', None, -1),
    'OM4_12': ('leaf', None, 'TX', 'SPECIMEN_REQUIREMENTS', None, -1),
    'OM4_13': ('leaf', None, 'ID', 'SPECIMEN_PRIORITIES', 'HL70027', -1),
    'OM4_14': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'SPECIMEN_RETENTION_TIME', None, -1),
    'OM4_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_HANDLING_CODE', 'HL70376', -1),
    'OM4_16': ('leaf', None, 'ID', 'SPECIMEN_PREFERENCE', 'HL70920', -1),
    'OM4_17': ('leaf', None, 'NM', 'PREFERRED_SPECIMEN_ATTRIBTURE_SEQUENCE_ID', None, -1),
    'OM4_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TAXONOMIC_CLASSIFICATION_CODE', None, -1),
    'OM5_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM5_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TEST_OBSERVATIONS_INCLUDED_WITHIN_AN_ORDERED_TEST_BATTERY',
              'HL79999', -1),
    'OM5_3': ('leaf', None, 'ST', 'OBSERVATION_ID_SUFFIXES', None, -1),
    'OM6_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM6_2': ('leaf', None, 'TX', 'DERIVATION_RULE', None, -1),
    'OM7_1': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM7_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNIVERSAL_SERVICE_IDENTIFIER', None, -1),
    'OM7_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CATEGORY_IDENTIFIER', 'HL70412', -1),
    'OM7_4': ('leaf', None, 'TX', 'CATEGORY_DESCRIPTION', None, -1),
    'OM7_5': ('leaf', None, 'ST', 'CATEGORY_SYNONYM', None, -1),
    'OM7_6': ('leaf', None, 'DTM', 'EFFECTIVE_TEST_SERVICE_START_DATE_TIME', None, -1),
    'OM7_7': ('leaf', None, 'DTM', 'EFFECTIVE_TEST_SERVICE_END_DATE_TIME', None, -1),
    'OM7_8': ('leaf', None, 'NM', 'TEST_SERVICE_DEFAULT_DURATION_QUANTITY', None, -1),
    'OM7_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TEST_SERVICE_DEFAULT_DURATION_UNITS', 'HL79999', -1),
    'OM7_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TEST_SERVICE_DEFAULT_FREQUENCY', None, -1),
    'OM7_11': ('leaf', None, 'ID', 'CONSENT_INDICATOR', 'HL70136', -1),
    'OM7_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONSENT_IDENTIFIER', 'HL70413', -1),
    'OM7_13': ('leaf', None, 'DTM', 'CONSENT_EFFECTIVE_START_DATE_TIME', None, -1),
    'OM7_14': ('leaf', None, 'DTM', 'CONSENT_EFFECTIVE_END_DATE_TIME', None, -1),
    'OM7_15': ('leaf', None, 'NM', 'CONSENT_INTERVAL_QUANTITY', None, -1),
    'OM7_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONSENT_INTERVAL_UNITS', 'HL70414', -1),
    'OM7_17': ('leaf', None, 'NM', 'CONSENT_WAITING_PERIOD_QUANTITY', None, -1),
    'OM7_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONSENT_WAITING_PERIOD_UNITS', 'HL70414', -1),
    'OM7_19': ('leaf', None, 'DTM', 'EFFECTIVE_DATE_TIME_OF_CHANGE', None, -1),
    'OM7_20': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY', None, -1),
    'OM7_21': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ORDERABLE_AT_LOCATION', None, -1),
    'OM7_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FORMULARY_STATUS', 'HL70473', -1),
    'OM7_23': ('leaf', None, 'ID', 'SPECIAL_ORDER_INDICATOR', 'HL70136', -1),
    'OM7_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_KEY_VALUE_CDM', None, -1),
    'ORC_1': ('leaf', None, 'ID', 'ORDER_CONTROL', 'HL70119', -1),
    'ORC_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_ORDER_NUMBER', None, -1),
    'ORC_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'ORC_4': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'PLACER_GROUP_NUMBER', None, -1),
    'ORC_5': ('leaf', None, 'ID', 'ORDER_STATUS', 'HL70038', -1),
    'ORC_6': ('leaf', None, 'ID', 'RESPONSE_FLAG', 'HL70121', -1),
    'ORC_7': ('leaf', None, 'WD', 'QUANTITY_TIMING', None, -1),
    'ORC_8': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'PARENT_ORDER', None, -1),
    'ORC_9': ('leaf', None, 'DTM', 'DATE_TIME_OF_TRANSACTION', None, -1),
    'ORC_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY', None, -1),
    'ORC_11': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'VERIFIED_BY', None, -1),
    'ORC_12': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERING_PROVIDER', None, -1),
    'ORC_13': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ENTERER_S_LOCATION', None, -1),
    'ORC_14': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'CALL_BACK_PHONE_NUMBER', None, -1),
    'ORC_15': ('leaf', None, 'DTM', 'ORDER_EFFECTIVE_DATE_TIME', None, -1),
    'ORC_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORDER_CONTROL_CODE_REASON', 'HL79999', -1),
    'ORC_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ENTERING_ORGANIZATION', 'HL79999', -1),
    'ORC_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ENTERING_DEVICE', 'HL79999', -1),
    'ORC_19': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ACTION_BY', None, -1),
    'ORC_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADVANCED_BENEFICIARY_NOTICE_CODE', 'HL70339', -1),
    'ORC_21': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORDERING_FACILITY_NAME', None, -1),
    'ORC_22': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ORDERING_FACILITY_ADDRESS', None, -1),
    'ORC_23': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ORDERING_FACILITY_PHONE_NUMBER', None, -1),
    'ORC_24': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ORDERING_PROVIDER_ADDRESS', None, -1),
    'ORC_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORDER_STATUS_MODIFIER', 'HL79999', -1),
    'ORC_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADVANCED_BENEFICIARY_NOTICE_OVERRIDE_REASON',
               'HL70552', -1),
    'ORC_27': ('leaf', None, 'DTM', 'FILLER_S_EXPECTED_AVAILABILITY_DATE_TIME', None, -1),
    'ORC_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONFIDENTIALITY_CODE', 'HL70177', -1),
    'ORC_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORDER_TYPE', 'HL70482', -1),
    'ORC_30': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'ENTERER_AUTHORIZATION_MODE', 'HL70483', -1),
    'ORC_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PARENT_UNIVERSAL_SERVICE_IDENTIFIER', None, -1),
    'ORC_32': ('leaf', None, 'DT', 'ADVANCED_BENEFICIARY_NOTICE_DATE', None, -1),
    'ORC_33': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ALTERNATE_PLACER_ORDER_NUMBER', None, -1),
    'ORC_34': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORDER_WORKFLOW_PROFILE', 'HL70934', -1),
    'ORG_1': ('leaf', None, 'SI', 'SET_ID_ORG', None, -1),
    'ORG_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORGANIZATION_UNIT_CODE', 'HL70405', -1),
    'ORG_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORGANIZATION_UNIT_TYPE_CODE', 'HL70474', -1),
    'ORG_4': ('leaf', None, 'ID', 'PRIMARY_ORG_UNIT_INDICATOR', 'HL70136', -1),
    'ORG_5': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PRACTITIONER_ORG_UNIT_IDENTIFIER', None, -1),
    'ORG_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HEALTH_CARE_PROVIDER_TYPE_CODE', 'HL70452', -1),
    'ORG_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HEALTH_CARE_PROVIDER_CLASSIFICATION_CODE', 'HL70453', -1),
    'ORG_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HEALTH_CARE_PROVIDER_AREA_OF_SPECIALIZATION_CODE',
              'HL70454', -1),
    'ORG_9': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'EFFECTIVE_DATE_RANGE', None, -1),
    'ORG_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EMPLOYMENT_STATUS_CODE', 'HL70066', -1),
    'ORG_11': ('leaf', None, 'ID', 'BOARD_APPROVAL_INDICATOR', 'HL70136', -1),
    'ORG_12': ('leaf', None, 'ID', 'PRIMARY_CARE_PHYSICIAN_INDICATOR', 'HL70136', -1),
    'ORG_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COST_CENTER_CODE', 'HL70539', -1),
    'OVR_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BUSINESS_RULE_OVERRIDE_TYPE', 'HL70518', -1),
    'OVR_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BUSINESS_RULE_OVERRIDE_CODE', 'HL70521', -1),
    'OVR_3': ('leaf', None, 'TX', 'OVERRIDE_COMMENTS', None, -1),
    'OVR_4': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'OVERRIDE_ENTERED_BY', None, -1),
    'OVR_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'OVERRIDE_AUTHORIZED_BY', None, -1),
    'PAC_1': ('leaf', None, 'SI', 'SET_ID_PAC', None, -1),
    'PAC_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PACKAGE_ID', None, -1),
    'PAC_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_PACKAGE_ID', None, -1),
    'PAC_4': ('sequence', DATATYPES_STRUCTS['NA'], 'NA', 'POSITION_IN_PARENT_PACKAGE', None, -1),
    'PAC_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PACKAGE_TYPE', 'HL70908', -1),
    'PAC_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PACKAGE_CONDITION', 'HL70544', -1),
    'PAC_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PACKAGE_HANDLING_CODE', 'HL70376', -1),
    'PAC_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PACKAGE_RISK_CODE', 'HL70489', -1),
    'PCE_1': ('leaf', None, 'SI', 'SET_ID_PCE', None, -1),
    'PCE_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'COST_CENTER_ACCOUNT_NUMBER', 'HL70319', -1),
    'PCE_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSACTION_CODE', 'HL70132', -1),
    'PCE_4': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TRANSACTION_AMOUNT_UNIT', None, -1),
    'PCR_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'IMPLICATED_PRODUCT', 'HL79999', -1),
    'PCR_2': ('leaf', None, 'IS', 'GENERIC_PRODUCT', 'HL70249', -1),
    'PCR_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_CLASS', 'HL79999', -1),
    'PCR_4': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DURATION_OF_THERAPY', None, -1),
    'PCR_5': ('leaf', None, 'DTM', 'PRODUCT_MANUFACTURE_DATE', None, -1),
    'PCR_6': ('leaf', None, 'DTM', 'PRODUCT_EXPIRATION_DATE', None, -1),
    'PCR_7': ('leaf', None, 'DTM', 'PRODUCT_IMPLANTATION_DATE', None, -1),
    'PCR_8': ('leaf', None, 'DTM', 'PRODUCT_EXPLANTATION_DATE', None, -1),
    'PCR_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SINGLE_USE_DEVICE', 'HL70244', -1),
    'PCR_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INDICATION_FOR_PRODUCT_USE', 'HL79999', -1),
    'PCR_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_PROBLEM', 'HL70245', -1),
    'PCR_12': ('leaf', None, 'ST', 'PRODUCT_SERIAL_LOT_NUMBER', None, -1),
    'PCR_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_AVAILABLE_FOR_INSPECTION', 'HL70246', -1),
    'PCR_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_EVALUATION_PERFORMED', 'HL79999', -1),
    'PCR_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_EVALUATION_STATUS', 'HL70247', -1),
    'PCR_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_EVALUATION_RESULTS', 'HL79999', -1),
    'PCR_17': ('leaf', None, 'ID', 'EVALUATED_PRODUCT_SOURCE', 'HL70248', -1),
    'PCR_18': ('leaf', None, 'DTM', 'DATE_PRODUCT_RETURNED_TO_MANUFACTURER', None, -1),
    'PCR_19': ('leaf', None, 'ID', 'DEVICE_OPERATOR_QUALIFICATIONS', 'HL70242', -1),
    'PCR_20': ('leaf', None, 'ID', 'RELATEDNESS_ASSESSMENT', 'HL70250', -1),
    'PCR_21': ('leaf', None, 'ID', 'ACTION_TAKEN_IN_RESPONSE_TO_THE_EVENT', 'HL70251', -1),
    'PCR_22': ('leaf', None, 'ID', 'EVENT_CAUSALITY_OBSERVATIONS', 'HL70252', -1),
    'PCR_23': ('leaf', None, 'ID', 'INDIRECT_EXPOSURE_MECHANISM', 'HL70253', -1),
    'PD1_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_DEPENDENCY', 'HL70223', -1),
    'PD1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_ARRANGEMENT', 'HL70220', -1),
    'PD1_3': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PATIENT_PRIMARY_FACILITY', 'HL70204', -1),
    'PD1_4': ('leaf', None, 'WD', 'PATIENT_PRIMARY_CARE_PROVIDER_NAME_AND_ID_NO', None, -1),
    'PD1_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STUDENT_INDICATOR', 'HL70231', -1),
    'PD1_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HANDICAP', 'HL70295', -1),
    'PD1_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_WILL_CODE', 'HL70315', -1),
    'PD1_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORGAN_DONOR_CODE', 'HL70316', -1),
    'PD1_9': ('leaf', None, 'ID', 'SEPARATE_BILL', 'HL70136', -1),
    'PD1_10': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'DUPLICATE_PATIENT', None, -1),
    'PD1_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PUBLICITY_CODE', 'HL70215', -1),
    'PD1_12': ('leaf', None, 'ID', 'PROTECTION_INDICATOR', 'HL70136', -1),
    'PD1_13': ('leaf', None, 'DT', 'PROTECTION_INDICATOR_EFFECTIVE_DATE', None, -1),
    'PD1_14': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PLACE_OF_WORSHIP', None, -1),
    'PD1_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADVANCE_DIRECTIVE_CODE', 'HL70435', -1),
    'PD1_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'IMMUNIZATION_REGISTRY_STATUS', 'HL70441', -1),
    'PD1_17': ('leaf', None, 'DT', 'IMMUNIZATION_REGISTRY_STATUS_EFFECTIVE_DATE', None, -1),
    'PD1_18': ('leaf', None, 'DT', 'PUBLICITY_CODE_EFFECTIVE_DATE', None, -1),
    'PD1_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MILITARY_BRANCH', 'HL70140', -1),
    'PD1_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MILITARY_RANK_GRADE', 'HL70141', -1),
    'PD1_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MILITARY_STATUS', 'HL70142', -1),
    'PD1_22': ('leaf', None, 'DT', 'ADVANCE_DIRECTIVE_LAST_VERIFIED_DATE', None, -1),
    'PDA_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DEATH_CAUSE_CODE', None, -1),
    'PDA_2': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'DEATH_LOCATION', None, -1),
    'PDA_3': ('leaf', None, 'ID', 'DEATH_CERTIFIED_INDICATOR', 'HL70136', -1),
    'PDA_4': ('leaf', None, 'DTM', 'DEATH_CERTIFICATE_SIGNED_DATE_TIME', None, -1),
    'PDA_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DEATH_CERTIFIED_BY', None, -1),
    'PDA_6': ('leaf', None, 'ID', 'AUTOPSY_INDICATOR', 'HL70136', -1),
    'PDA_7': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'AUTOPSY_START_AND_END_DATE_TIME', None, -1),
    'PDA_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'AUTOPSY_PERFORMED_BY', None, -1),
    'PDA_9': ('leaf', None, 'ID', 'CORONER_INDICATOR', 'HL70136', -1),
    'PDC_1': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'MANUFACTURER_DISTRIBUTOR', None, -1),
    'PDC_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COUNTRY', 'HL79999', -1),
    'PDC_3': ('leaf', None, 'ST', 'BRAND_NAME', None, -1),
    'PDC_4': ('leaf', None, 'ST', 'DEVICE_FAMILY_NAME', None, -1),
    'PDC_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GENERIC_NAME', 'HL79999', -1),
    'PDC_6': ('leaf', None, 'ST', 'MODEL_IDENTIFIER', None, -1),
    'PDC_7': ('leaf', None, 'ST', 'CATALOGUE_IDENTIFIER', None, -1),
    'PDC_8': ('leaf', None, 'ST', 'OTHER_IDENTIFIER', None, -1),
    'PDC_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_CODE', 'HL79999', -1),
    'PDC_10': ('leaf', None, 'ID', 'MARKETING_BASIS', 'HL70330', -1),
    'PDC_11': ('leaf', None, 'ST', 'MARKETING_APPROVAL_ID', None, -1),
    'PDC_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'LABELED_SHELF_LIFE', None, -1),
    'PDC_13': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'EXPECTED_SHELF_LIFE', None, -1),
    'PDC_14': ('leaf', None, 'DTM', 'DATE_FIRST_MARKETED', None, -1),
    'PDC_15': ('leaf', None, 'DTM', 'DATE_LAST_MARKETED', None, -1),
    'PEO_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EVENT_IDENTIFIERS_USED', 'HL79999', -1),
    'PEO_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EVENT_SYMPTOM_DIAGNOSIS_CODE', 'HL79999', -1),
    'PEO_3': ('leaf', None, 'DTM', 'EVENT_ONSET_DATE_TIME', None, -1),
    'PEO_4': ('leaf', None, 'DTM', 'EVENT_EXACERBATION_DATE_TIME', None, -1),
    'PEO_5': ('leaf', None, 'DTM', 'EVENT_IMPROVED_DATE_TIME', None, -1),
    'PEO_6': ('leaf', None, 'DTM', 'EVENT_ENDED_DATA_TIME', None, -1),
    'PEO_7': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'EVENT_LOCATION_OCCURRED_ADDRESS', None, -1),
    'PEO_8': ('leaf', None, 'ID', 'EVENT_QUALIFICATION', 'HL70237', -1),
    'PEO_9': ('leaf', None, 'ID', 'EVENT_SERIOUS', 'HL70238', -1),
    'PEO_10': ('leaf', None, 'ID', 'EVENT_EXPECTED', 'HL70239', -1),
    'PEO_11': ('leaf', None, 'ID', 'EVENT_OUTCOME', 'HL70240', -1),
    'PEO_12': ('leaf', None, 'ID', 'PATIENT_OUTCOME', 'HL70241', -1),
    'PEO_13': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_OTHERS', None, -1),
    'PEO_14': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_ORIGINAL_REPORTER', None, -1),
    'PEO_15': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_PATIENT', None, -1),
    'PEO_16': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_PRACTITIONER', None, -1),
    'PEO_17': ('leaf', None, 'FT', 'EVENT_DESCRIPTION_FROM_AUTOPSY', None, -1),
    'PEO_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CAUSE_OF_DEATH', 'HL79999', -1),
    'PEO_19': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PRIMARY_OBSERVER_NAME', None, -1),
    'PEO_20': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PRIMARY_OBSERVER_ADDRESS', None, -1),
    'PEO_21': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PRIMARY_OBSERVER_TELEPHONE', None, -1),
    'PEO_22': ('leaf', None, 'ID', 'PRIMARY_OBSERVER_S_QUALIFICATION', 'HL70242', -1),
    'PEO_23': ('leaf', None, 'ID', 'CONFIRMATION_PROVIDED_BY', 'HL70242', -1),
    'PEO_24': ('leaf', None, 'DTM', 'PRIMARY_OBSERVER_AWARE_DATE_TIME', None, -1),
    'PEO_25': ('leaf', None, 'ID', 'PRIMARY_OBSERVER_S_IDENTITY_MAY_BE_DIVULGED', 'HL70243', -1),
    'PES_1': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'SENDER_ORGANIZATION_NAME', None, -1),
    'PES_2': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'SENDER_INDIVIDUAL_NAME', None, -1),
    'PES_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'SENDER_ADDRESS', None, -1),
    'PES_4': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'SENDER_TELEPHONE', None, -1),
    'PES_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SENDER_EVENT_IDENTIFIER', None, -1),
    'PES_6': ('leaf', None, 'NM', 'SENDER_SEQUENCE_NUMBER', None, -1),
    'PES_7': ('leaf', None, 'FT', 'SENDER_EVENT_DESCRIPTION', None, -1),
    'PES_8': ('leaf', None, 'FT', 'SENDER_COMMENT', None, -1),
    'PES_9': ('leaf', None, 'DTM', 'SENDER_AWARE_DATE_TIME', None, -1),
    'PES_10': ('leaf', None, 'DTM', 'EVENT_REPORT_DATE', None, -1),
    'PES_11': ('leaf', None, 'ID', 'EVENT_REPORT_TIMING_TYPE', 'HL70234', -1),
    'PES_12': ('leaf', None, 'ID', 'EVENT_REPORT_SOURCE', 'HL70235', -1),
    'PES_13': ('leaf', None, 'ID', 'EVENT_REPORTED_TO', 'HL70236', -1),
    'PID_1': ('leaf', None, 'SI', 'SET_ID_PID', None, -1),
    'PID_2': ('leaf', None, 'WD', 'PATIENT_ID', None, -1),
    'PID_3': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PATIENT_IDENTIFIER_LIST', None, -1),
    'PID_4': ('leaf', None, 'WD', 'ALTERNATE_PATIENT_ID', None, -1),
    'PID_5': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PATIENT_NAME', 'HL70200', -1),
    'PID_6': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'PID_7': ('leaf', None, 'DTM', 'DATE_TIME_OF_BIRTH', None, -1),
    'PID_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATIVE_SEX', 'HL70001', -1),
    'PID_9': ('leaf', None, 'WD', 'PATIENT_ALIAS', None, -1),
    'PID_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RACE', 'HL70005', -1),
    'PID_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PATIENT_ADDRESS', None, -1),
    'PID_12': ('leaf', None, 'WD', 'COUNTY_CODE', None, -1),
    'PID_13': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE_NUMBER_HOME', None, -1),
    'PID_14': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE_NUMBER_BUSINESS', None, -1),
    'PID_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_LANGUAGE', 'HL70296', -1),
    'PID_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MARITAL_STATUS', 'HL70002', -1),
    'PID_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELIGION', 'HL70006', -1),
    'PID_18': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PATIENT_ACCOUNT_NUMBER', None, -1),
    'PID_19': ('leaf', None, 'WD', 'SSN_NUMBER', None, -1),
    'PID_20': ('leaf', None, 'WD', 'DRIVERS_LICENSE_NUMBER', None, -1),
    'PID_21': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'MOTHER_S_IDENTIFIER', None, -1),
    'PID_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ETHNIC_GROUP', 'HL70189', -1),
    'PID_23': ('leaf', None, 'ST', 'BIRTH_PLACE', None, -1),
    'PID_24': ('leaf', None, 'ID', 'MULTIPLE_BIRTH_INDICATOR', 'HL70136', -1),
    'PID_25': ('leaf', None, 'NM', 'BIRTH_ORDER', None, -1),
    'PID_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CITIZENSHIP', 'HL70171', -1),
    'PID_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VETERANS_MILITARY_STATUS', 'HL70172', -1),
    'PID_29': ('leaf', None, 'DTM', 'PATIENT_DEATH_DATE_AND_TIME', None, -1),
    'PID_30': ('leaf', None, 'ID', 'PATIENT_DEATH_INDICATOR', 'HL70136', -1),
    'PID_31': ('leaf', None, 'ID', 'IDENTITY_UNKNOWN_INDICATOR', 'HL70136', -1),
    'PID_32': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'IDENTITY_RELIABILITY_CODE', 'HL70445', -1),
    'PID_33': ('leaf', None, 'DTM', 'LAST_UPDATE_DATE_TIME', None, -1),
    'PID_34': ('sequence', DATATYPES_STRUCTS['HD'], 'HD', 'LAST_UPDATE_FACILITY', None, -1),
    'PID_35': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TAXONOMIC_CLASSIFICATION_CODE', None, -1),
    'PID_36': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BREED_CODE', 'HL70447', -1),
    'PID_37': ('leaf', None, 'ST', 'STRAIN', None, -1),
    'PID_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCTION_CLASS_CODE', 'HL70429', -1),
    'PID_39': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRIBAL_CITIZENSHIP', 'HL70171', -1),
    'PID_40': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PATIENT_TELECOMMUNICATION_INFORMATION', None, -1),
    'PKG_1': ('leaf', None, 'SI', 'SET_ID_PKG', None, -1),
    'PKG_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PACKAGING_UNITS', 'HL70818', -1),
    'PKG_3': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DEFAULT_ORDER_UNIT_OF_MEASURE_INDICATOR', 'HL70532', -1),
    'PKG_4': ('leaf', None, 'NM', 'PACKAGE_QUANTITY', None, -1),
    'PKG_5': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PRICE', None, -1),
    'PKG_6': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'FUTURE_ITEM_PRICE', None, -1),
    'PKG_7': ('leaf', None, 'DTM', 'FUTURE_ITEM_PRICE_EFFECTIVE_DATE', None, -1),
    'PKG_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GLOBAL_TRADE_ITEM_NUMBER', None, -1),
    'PMT_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PAYMENT_REMITTANCE_ADVICE_NUMBER', None, -1),
    'PMT_2': ('leaf', None, 'DTM', 'PAYMENT_REMITTANCE_EFFECTIVE_DATE_TIME', None, -1),
    'PMT_3': ('leaf', None, 'DTM', 'PAYMENT_REMITTANCE_EXPIRATION_DATE_TIME', None, -1),
    'PMT_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PAYMENT_METHOD', 'HL70570', -1),
    'PMT_5': ('leaf', None, 'DTM', 'PAYMENT_REMITTANCE_DATE_TIME', None, -1),
    'PMT_6': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PAYMENT_REMITTANCE_AMOUNT', None, -1),
    'PMT_7': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'CHECK_NUMBER', None, -1),
    'PMT_8': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PAYEE_BANK_IDENTIFICATION', None, -1),
    'PMT_9': ('leaf', None, 'ST', 'PAYEE_TRANSIT_NUMBER', None, -1),
    'PMT_10': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PAYEE_BANK_ACCOUNT_ID', None, -1),
    'PMT_11': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PAYMENT_ORGANIZATION', None, -1),
    'PMT_12': ('leaf', None, 'ST', 'ESR_CODE_LINE', None, -1),
    'PR1_1': ('leaf', None, 'SI', 'SET_ID_PR1', None, -1),
    'PR1_2': ('leaf', None, 'WD', 'PROCEDURE_CODING_METHOD', None, -1),
    'PR1_3': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE', 'HL70088', -1),
    'PR1_4': ('leaf', None, 'WD', 'PROCEDURE_DESCRIPTION', None, -1),
    'PR1_5': ('leaf', None, 'DTM', 'PROCEDURE_DATE_TIME', None, -1),
    'PR1_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROCEDURE_FUNCTIONAL_TYPE', 'HL70230', -1),
    'PR1_7': ('leaf', None, 'NM', 'PROCEDURE_MINUTES', None, -1),
    'PR1_8': ('leaf', None, 'WD', 'ANESTHESIOLOGIST', None, -1),
    'PR1_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ANESTHESIA_CODE', 'HL70019', -1),
    'PR1_10': ('leaf', None, 'NM', 'ANESTHESIA_MINUTES', None, -1),
    'PR1_11': ('leaf', None, 'WD', 'SURGEON', None, -1),
    'PR1_12': ('leaf', None, 'WD', 'PROCEDURE_PRACTITIONER', None, -1),
    'PR1_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONSENT_CODE', 'HL70059', -1),
    'PR1_14': ('leaf', None, 'NM', 'PROCEDURE_PRIORITY', 'HL70418', -1),
    'PR1_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ASSOCIATED_DIAGNOSIS_CODE', 'HL70051', -1),
    'PR1_16': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE_MODIFIER', 'HL70340', -1),
    'PR1_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROCEDURE_DRG_TYPE', 'HL70416', -1),
    'PR1_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TISSUE_TYPE_CODE', 'HL70417', -1),
    'PR1_19': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROCEDURE_IDENTIFIER', None, -1),
    'PR1_20': ('leaf', None, 'ID', 'PROCEDURE_ACTION_CODE', 'HL70206', -1),
    'PR1_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DRG_PROCEDURE_DETERMINATION_STATUS', 'HL70761', -1),
    'PR1_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DRG_PROCEDURE_RELEVANCE', 'HL70763', -1),
    'PR1_23': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'TREATING_ORGANIZATIONAL_UNIT', None, -1),
    'PR1_24': ('leaf', None, 'ID', 'RESPIRATORY_WITHIN_SURGERY', 'HL70136', -1),
    'PR1_25': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_PROCEDURE_ID', None, -1),
    'PRA_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_KEY_VALUE_PRA', 'HL79999', -1),
    'PRA_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRACTITIONER_GROUP', 'HL70358', -1),
    'PRA_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRACTITIONER_CATEGORY', 'HL70186', -1),
    'PRA_4': ('leaf', None, 'ID', 'PROVIDER_BILLING', 'HL70187', -1),
    'PRA_5': ('sequence', DATATYPES_STRUCTS['SPD'], 'SPD', 'SPECIALTY', 'HL70337', -1),
    'PRA_6': ('sequence', DATATYPES_STRUCTS['PLN'], 'PLN', 'PRACTITIONER_ID_NUMBERS', 'HL70338', -1),
    'PRA_7': ('sequence', DATATYPES_STRUCTS['PIP'], 'PIP', 'PRIVILEGES', None, -1),
    'PRA_8': ('leaf', None, 'DT', 'DATE_ENTERED_PRACTICE', None, -1),
    'PRA_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INSTITUTION', 'HL70537', -1),
    'PRA_10': ('leaf', None, 'DT', 'DATE_LEFT_PRACTICE', None, -1),
    'PRA_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GOVERNMENT_REIMBURSEMENT_BILLING_ELIGIBILITY',
               'HL70401', -1),
    'PRA_12': ('leaf', None, 'SI', 'SET_ID_PRA', None, -1),
    'PRB_1': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'PRB_2': ('leaf', None, 'DTM', 'ACTION_DATE_TIME', None, -1),
    'PRB_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_ID', None, -1),
    'PRB_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROBLEM_INSTANCE_ID', None, -1),
    'PRB_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EPISODE_OF_CARE_ID', None, -1),
    'PRB_6': ('leaf', None, 'NM', 'PROBLEM_LIST_PRIORITY', None, -1),
    'PRB_7': ('leaf', None, 'DTM', 'PROBLEM_ESTABLISHED_DATE_TIME', None, -1),
    'PRB_8': ('leaf', None, 'DTM', 'ANTICIPATED_PROBLEM_RESOLUTION_DATE_TIME', None, -1),
    'PRB_9': ('leaf', None, 'DTM', 'ACTUAL_PROBLEM_RESOLUTION_DATE_TIME', None, -1),
    'PRB_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_CLASSIFICATION', None, -1),
    'PRB_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_MANAGEMENT_DISCIPLINE', None, -1),
    'PRB_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_PERSISTENCE', None, -1),
    'PRB_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_CONFIRMATION_STATUS', None, -1),
    'PRB_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_LIFE_CYCLE_STATUS', None, -1),
    'PRB_15': ('leaf', None, 'DTM', 'PROBLEM_LIFE_CYCLE_STATUS_DATE_TIME', None, -1),
    'PRB_16': ('leaf', None, 'DTM', 'PROBLEM_DATE_OF_ONSET', None, -1),
    'PRB_17': ('leaf', None, 'ST', 'PROBLEM_ONSET_TEXT', None, -1),
    'PRB_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_RANKING', None, -1),
    'PRB_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CERTAINTY_OF_PROBLEM', None, -1),
    'PRB_20': ('leaf', None, 'NM', 'PROBABILITY_OF_PROBLEM_0_1', None, -1),
    'PRB_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INDIVIDUAL_AWARENESS_OF_PROBLEM', None, -1),
    'PRB_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_PROGNOSIS', None, -1),
    'PRB_23': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INDIVIDUAL_AWARENESS_OF_PROGNOSIS', None, -1),
    'PRB_24': ('leaf', None, 'ST', 'FAMILY_SIGNIFICANT_OTHER_AWARENESS_OF_PROBLEM_PROGNOSIS', None, -1),
    'PRB_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SECURITY_SENSITIVITY', None, -1),
    'PRB_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_SEVERITY', 'HL70836', -1),
    'PRB_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROBLEM_PERSPECTIVE', 'HL70838', -1),
    'PRB_28': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'MOOD_CODE', 'HL70725', -1),
    'PRC_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_KEY_VALUE_PRC', 'HL70132', -1),
    'PRC_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FACILITY_ID_PRC', 'HL70464', -1),
    'PRC_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DEPARTMENT', 'HL70184', -1),
    'PRC_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VALID_PATIENT_CLASSES', 'HL70004', -1),
    'PRC_5': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PRICE', None, -1),
    'PRC_6': ('leaf', None, 'ST', 'FORMULA', None, -1),
    'PRC_7': ('leaf', None, 'NM', 'MINIMUM_QUANTITY', None, -1),
    'PRC_8': ('leaf', None, 'NM', 'MAXIMUM_QUANTITY', None, -1),
    'PRC_9': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'MINIMUM_PRICE', None, -1),
    'PRC_10': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'MAXIMUM_PRICE', None, -1),
    'PRC_11': ('leaf', None, 'DTM', 'EFFECTIVE_START_DATE', None, -1),
    'PRC_12': ('leaf', None, 'DTM', 'EFFECTIVE_END_DATE', None, -1),
    'PRC_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRICE_OVERRIDE_FLAG', 'HL70268', -1),
    'PRC_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BILLING_CATEGORY', 'HL70293', -1),
    'PRC_15': ('leaf', None, 'ID', 'CHARGEABLE_FLAG', 'HL70136', -1),
    'PRC_16': ('leaf', None, 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183', -1),
    'PRC_17': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'COST', None, -1),
    'PRC_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CHARGE_ON_INDICATOR', 'HL70269', -1),
    'PRD_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROVIDER_ROLE', 'HL70286', -1),
    'PRD_2': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PROVIDER_NAME', None, -1),
    'PRD_3': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PROVIDER_ADDRESS', None, -1),
    'PRD_4': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PROVIDER_LOCATION', None, -1),
    'PRD_5': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PROVIDER_COMMUNICATION_INFORMATION', None, -1),
    'PRD_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185', -1),
    'PRD_7': ('sequence', DATATYPES_STRUCTS['PLN'], 'PLN', 'PROVIDER_IDENTIFIERS', 'HL70338', -1),
    'PRD_8': ('leaf', None, 'DTM', 'EFFECTIVE_START_DATE_OF_PROVIDER_ROLE', None, -1),
    'PRD_9': ('leaf', None, 'DTM', 'EFFECTIVE_END_DATE_OF_PROVIDER_ROLE', None, -1),
    'PRD_10': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PROVIDER_ORGANIZATION_NAME_AND_IDENTIFIER', None, -1),
    'PRD_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PROVIDER_ORGANIZATION_ADDRESS', None, -1),
    'PRD_12': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PROVIDER_ORGANIZATION_LOCATION_INFORMATION', None, -1),
    'PRD_13': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PROVIDER_ORGANIZATION_COMMUNICATION_INFORMATION', None,
               -1),
    'PRD_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROVIDER_ORGANIZATION_METHOD_OF_CONTACT', 'HL70185', -1),
    'PRT_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARTICIPATION_INSTANCE_ID', None, -1),
    'PRT_2': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'PRT_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACTION_REASON', None, -1),
    'PRT_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PARTICIPATION', 'HL70912', -1),
    'PRT_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PARTICIPATION_PERSON', None, -1),
    'PRT_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PARTICIPATION_PERSON_PROVIDER_TYPE', None, -1),
    'PRT_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PARTICIPANT_ORGANIZATION_UNIT_TYPE', 'HL70406', -1),
    'PRT_8': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PARTICIPATION_ORGANIZATION', None, -1),
    'PRT_9': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PARTICIPANT_LOCATION', None, -1),
    'PRT_10': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARTICIPATION_DEVICE', None, -1),
    'PRT_11': ('leaf', None, 'DTM', 'PARTICIPATION_BEGIN_DATE_TIME_ARRIVAL_TIME', None, -1),
    'PRT_12': ('leaf', None, 'DTM', 'PARTICIPATION_END_DATE_TIME_DEPARTURE_TIME', None, -1),
    'PRT_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PARTICIPATION_QUALITATIVE_DURATION', None, -1),
    'PRT_14': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PARTICIPATION_ADDRESS', None, -1),
    'PRT_15': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PARTICIPANT_TELECOMMUNICATION_ADDRESS', None, -1),
    'PSG_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_PRODUCT_SERVICE_GROUP_NUMBER', None, -1),
    'PSG_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PAYER_PRODUCT_SERVICE_GROUP_NUMBER', None, -1),
    'PSG_3': ('leaf', None, 'SI', 'PRODUCT_SERVICE_GROUP_SEQUENCE_NUMBER', None, -1),
    'PSG_4': ('leaf', None, 'ID', 'ADJUDICATE_AS_GROUP', 'HL70136', -1),
    'PSG_5': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PRODUCT_SERVICE_GROUP_BILLED_AMOUNT', None, -1),
    'PSG_6': ('leaf', None, 'ST', 'PRODUCT_SERVICE_GROUP_DESCRIPTION', None, -1),
    'PSH_1': ('leaf', None, 'ST', 'REPORT_TYPE', None, -1),
    'PSH_2': ('leaf', None, 'ST', 'REPORT_FORM_IDENTIFIER', None, -1),
    'PSH_3': ('leaf', None, 'DTM', 'REPORT_DATE', None, -1),
    'PSH_4': ('leaf', None, 'DTM', 'REPORT_INTERVAL_START_DATE', None, -1),
    'PSH_5': ('leaf', None, 'DTM', 'REPORT_INTERVAL_END_DATE', None, -1),
    'PSH_6': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_MANUFACTURED', None, -1),
    'PSH_7': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_DISTRIBUTED', None, -1),
    'PSH_8': ('leaf', None, 'ID', 'QUANTITY_DISTRIBUTED_METHOD', 'HL70329', -1),
    'PSH_9': ('leaf', None, 'FT', 'QUANTITY_DISTRIBUTED_COMMENT', None, -1),
    'PSH_10': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_IN_USE', None, -1),
    'PSH_11': ('leaf', None, 'ID', 'QUANTITY_IN_USE_METHOD', 'HL70329', -1),
    'PSH_12': ('leaf', None, 'FT', 'QUANTITY_IN_USE_COMMENT', None, -1),
    'PSH_13': ('leaf', None, 'NM', 'NUMBER_OF_PRODUCT_EXPERIENCE_REPORTS_FILED_BY_FACILITY', None, -1),
    'PSH_14': ('leaf', None, 'NM', 'NUMBER_OF_PRODUCT_EXPERIENCE_REPORTS_FILED_BY_DISTRIBUTOR', None, -1),
    'PSL_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_PRODUCT_SERVICE_LINE_ITEM_NUMBER', None, -1),
    'PSL_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PAYER_PRODUCT_SERVICE_LINE_ITEM_NUMBER', None, -1),
    'PSL_3': ('leaf', None, 'SI', 'PRODUCT_SERVICE_LINE_ITEM_SEQUENCE_NUMBER', None, -1),
    'PSL_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_TRACKING_ID', None, -1),
    'PSL_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PAYER_TRACKING_ID', None, -1),
    'PSL_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_SERVICE_LINE_ITEM_STATUS', 'HL70559', -1),
    'PSL_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_SERVICE_CODE', 'HL70879', -1),
    'PSL_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_SERVICE_CODE_MODIFIER', 'HL70880', -1),
    'PSL_9': ('leaf', None, 'ST', 'PRODUCT_SERVICE_CODE_DESCRIPTION', None, -1),
    'PSL_10': ('leaf', None, 'DTM', 'PRODUCT_SERVICE_EFFECTIVE_DATE', None, -1),
    'PSL_11': ('leaf', None, 'DTM', 'PRODUCT_SERVICE_EXPIRATION_DATE', None, -1),
    'PSL_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'PRODUCT_SERVICE_QUANTITY', 'HL70560', -1),
    'PSL_13': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PRODUCT_SERVICE_UNIT_COST', None, -1),
    'PSL_14': ('leaf', None, 'NM', 'NUMBER_OF_ITEMS_PER_UNIT', None, -1),
    'PSL_15': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PRODUCT_SERVICE_GROSS_AMOUNT', None, -1),
    'PSL_16': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PRODUCT_SERVICE_BILLED_AMOUNT', None, -1),
    'PSL_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRODUCT_SERVICE_CLARIFICATION_CODE_TYPE', 'HL70561', -1),
    'PSL_18': ('leaf', None, 'ST', 'PRODUCT_SERVICE_CLARIFICATION_CODE_VALUE', None, -1),
    'PSL_19': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'HEALTH_DOCUMENT_REFERENCE_IDENTIFIER', None, -1),
    'PSL_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROCESSING_CONSIDERATION_CODE', 'HL70562', -1),
    'PSL_21': ('leaf', None, 'ID', 'RESTRICTED_DISCLOSURE_INDICATOR', 'HL70532', -1),
    'PSL_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELATED_PRODUCT_SERVICE_CODE_INDICATOR', 'HL70879', -1),
    'PSL_23': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'PRODUCT_SERVICE_AMOUNT_FOR_PHYSICIAN', None, -1),
    'PSL_24': ('leaf', None, 'NM', 'PRODUCT_SERVICE_COST_FACTOR', None, -1),
    'PSL_25': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'COST_CENTER', None, -1),
    'PSL_26': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'BILLING_PERIOD', None, -1),
    'PSL_27': ('leaf', None, 'NM', 'DAYS_WITHOUT_BILLING', None, -1),
    'PSL_28': ('leaf', None, 'NM', 'SESSION_NO', None, -1),
    'PSL_29': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'EXECUTING_PHYSICIAN_ID', None, -1),
    'PSL_30': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'RESPONSIBLE_PHYSICIAN_ID', None, -1),
    'PSL_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ROLE_EXECUTING_PHYSICIAN', 'HL70881', -1),
    'PSL_32': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MEDICAL_ROLE_EXECUTING_PHYSICIAN', 'HL70882', -1),
    'PSL_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SIDE_OF_BODY', 'HL70894', -1),
    'PSL_34': ('leaf', None, 'NM', 'NUMBER_OF_TP_S_PP', None, -1),
    'PSL_35': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TP_VALUE_PP', None, -1),
    'PSL_36': ('leaf', None, 'NM', 'INTERNAL_SCALING_FACTOR_PP', None, -1),
    'PSL_37': ('leaf', None, 'NM', 'EXTERNAL_SCALING_FACTOR_PP', None, -1),
    'PSL_38': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'AMOUNT_PP', None, -1),
    'PSL_39': ('leaf', None, 'NM', 'NUMBER_OF_TP_S_TECHNICAL_PART', None, -1),
    'PSL_40': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TP_VALUE_TECHNICAL_PART', None, -1),
    'PSL_41': ('leaf', None, 'NM', 'INTERNAL_SCALING_FACTOR_TECHNICAL_PART', None, -1),
    'PSL_42': ('leaf', None, 'NM', 'EXTERNAL_SCALING_FACTOR_TECHNICAL_PART', None, -1),
    'PSL_43': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'AMOUNT_TECHNICAL_PART', None, -1),
    'PSL_44': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'TOTAL_AMOUNT_PROFESSIONAL_PART_TECHNICAL_PART', None, -1),
    'PSL_45': ('leaf', None, 'NM', 'VAT_RATE', None, -1),
    'PSL_46': ('leaf', None, 'ID', 'MAIN_SERVICE', None, -1),
    'PSL_47': ('leaf', None, 'ID', 'VALIDATION', 'HL70136', -1),
    'PSL_48': ('leaf', None, 'ST', 'COMMENT', None, -1),
    'PSS_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PROVIDER_PRODUCT_SERVICE_SECTION_NUMBER', None, -1),
    'PSS_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PAYER_PRODUCT_SERVICE_SECTION_NUMBER', None, -1),
    'PSS_3': ('leaf', None, 'SI', 'PRODUCT_SERVICE_SECTION_SEQUENCE_NUMBER', None, -1),
    'PSS_4': ('sequence', DATATYPES_STRUCTS['CP'], 'CP', 'BILLED_AMOUNT', None, -1),
    'PSS_5': ('leaf', None, 'ST', 'SECTION_DESCRIPTION_OR_HEADING', None, -1),
    'PTH_1': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'PTH_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATHWAY_ID', None, -1),
    'PTH_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PATHWAY_INSTANCE_ID', None, -1),
    'PTH_4': ('leaf', None, 'DTM', 'PATHWAY_ESTABLISHED_DATE_TIME', None, -1),
    'PTH_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATHWAY_LIFE_CYCLE_STATUS', None, -1),
    'PTH_6': ('leaf', None, 'DTM', 'CHANGE_PATHWAY_LIFE_CYCLE_STATUS_DATE_TIME', None, -1),
    'PTH_7': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'MOOD_CODE', 'HL70725', -1),
    'PV1_1': ('leaf', None, 'SI', 'SET_ID_PV1', None, -1),
    'PV1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_CLASS', 'HL70004', -1),
    'PV1_3': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ASSIGNED_PATIENT_LOCATION', None, -1),
    'PV1_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMISSION_TYPE', 'HL70007', -1),
    'PV1_5': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PREADMIT_NUMBER', None, -1),
    'PV1_6': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIOR_PATIENT_LOCATION', None, -1),
    'PV1_7': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ATTENDING_DOCTOR', 'HL70010', -1),
    'PV1_8': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'REFERRING_DOCTOR', 'HL70010', -1),
    'PV1_9': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'CONSULTING_DOCTOR', None, -1),
    'PV1_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HOSPITAL_SERVICE', 'HL70069', -1),
    'PV1_11': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'TEMPORARY_LOCATION', None, -1),
    'PV1_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PREADMIT_TEST_INDICATOR', 'HL70087', -1),
    'PV1_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RE_ADMISSION_INDICATOR', 'HL70092', -1),
    'PV1_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMIT_SOURCE', 'HL70023', -1),
    'PV1_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'AMBULATORY_STATUS', 'HL70009', -1),
    'PV1_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VIP_INDICATOR', 'HL70099', -1),
    'PV1_17': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ADMITTING_DOCTOR', 'HL70010', -1),
    'PV1_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_TYPE', 'HL70018', -1),
    'PV1_19': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'VISIT_NUMBER', None, -1),
    'PV1_20': ('sequence', DATATYPES_STRUCTS['FC'], 'FC', 'FINANCIAL_CLASS', 'HL70064', -1),
    'PV1_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CHARGE_PRICE_INDICATOR', 'HL70032', -1),
    'PV1_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COURTESY_CODE', 'HL70045', -1),
    'PV1_23': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CREDIT_RATING', 'HL70046', -1),
    'PV1_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTRACT_CODE', 'HL70044', -1),
    'PV1_25': ('leaf', None, 'DT', 'CONTRACT_EFFECTIVE_DATE', None, -1),
    'PV1_26': ('leaf', None, 'NM', 'CONTRACT_AMOUNT', None, -1),
    'PV1_27': ('leaf', None, 'NM', 'CONTRACT_PERIOD', None, -1),
    'PV1_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INTEREST_CODE', 'HL70073', -1),
    'PV1_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSFER_TO_BAD_DEBT_CODE', 'HL70110', -1),
    'PV1_30': ('leaf', None, 'DT', 'TRANSFER_TO_BAD_DEBT_DATE', None, -1),
    'PV1_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BAD_DEBT_AGENCY_CODE', 'HL70021', -1),
    'PV1_32': ('leaf', None, 'NM', 'BAD_DEBT_TRANSFER_AMOUNT', None, -1),
    'PV1_33': ('leaf', None, 'NM', 'BAD_DEBT_RECOVERY_AMOUNT', None, -1),
    'PV1_34': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DELETE_ACCOUNT_INDICATOR', 'HL70111', -1),
    'PV1_35': ('leaf', None, 'DT', 'DELETE_ACCOUNT_DATE', None, -1),
    'PV1_36': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISCHARGE_DISPOSITION', 'HL70112', -1),
    'PV1_37': ('sequence', DATATYPES_STRUCTS['DLD'], 'DLD', 'DISCHARGED_TO_LOCATION', 'HL70113', -1),
    'PV1_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DIET_TYPE', 'HL70114', -1),
    'PV1_39': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SERVICING_FACILITY', 'HL70115', -1),
    'PV1_41': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACCOUNT_STATUS', 'HL70117', -1),
    'PV1_42': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PENDING_LOCATION', None, -1),
    'PV1_43': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIOR_TEMPORARY_LOCATION', None, -1),
    'PV1_44': ('leaf', None, 'DTM', 'ADMIT_DATE_TIME', None, -1),
    'PV1_45': ('leaf', None, 'DTM', 'DISCHARGE_DATE_TIME', None, -1),
    'PV1_46': ('leaf', None, 'NM', 'CURRENT_PATIENT_BALANCE', None, -1),
    'PV1_47': ('leaf', None, 'NM', 'TOTAL_CHARGES', None, -1),
    'PV1_48': ('leaf', None, 'NM', 'TOTAL_ADJUSTMENTS', None, -1),
    'PV1_49': ('leaf', None, 'NM', 'TOTAL_PAYMENTS', None, -1),
    'PV1_50': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ALTERNATE_VISIT_ID', 'HL70203', -1),
    'PV1_51': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VISIT_INDICATOR', 'HL70326', -1),
    'PV1_53': ('leaf', None, 'ST', 'SERVICE_EPISODE_DESCRIPTION', None, -1),
    'PV1_54': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'SERVICE_EPISODE_IDENTIFIER', None, -1),
    'PV2_1': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PRIOR_PENDING_LOCATION', None, -1),
    'PV2_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACCOMMODATION_CODE', 'HL70129', -1),
    'PV2_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMIT_REASON', None, -1),
    'PV2_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRANSFER_REASON', None, -1),
    'PV2_5': ('leaf', None, 'ST', 'PATIENT_VALUABLES', None, -1),
    'PV2_6': ('leaf', None, 'ST', 'PATIENT_VALUABLES_LOCATION', None, -1),
    'PV2_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VISIT_USER_CODE', 'HL70130', -1),
    'PV2_8': ('leaf', None, 'DTM', 'EXPECTED_ADMIT_DATE_TIME', None, -1),
    'PV2_9': ('leaf', None, 'DTM', 'EXPECTED_DISCHARGE_DATE_TIME', None, -1),
    'PV2_10': ('leaf', None, 'NM', 'ESTIMATED_LENGTH_OF_INPATIENT_STAY', None, -1),
    'PV2_11': ('leaf', None, 'NM', 'ACTUAL_LENGTH_OF_INPATIENT_STAY', None, -1),
    'PV2_12': ('leaf', None, 'ST', 'VISIT_DESCRIPTION', None, -1),
    'PV2_13': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'REFERRAL_SOURCE_CODE', None, -1),
    'PV2_14': ('leaf', None, 'DT', 'PREVIOUS_SERVICE_DATE', None, -1),
    'PV2_15': ('leaf', None, 'ID', 'EMPLOYMENT_ILLNESS_RELATED_INDICATOR', 'HL70136', -1),
    'PV2_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PURGE_STATUS_CODE', 'HL70213', -1),
    'PV2_17': ('leaf', None, 'DT', 'PURGE_STATUS_DATE', None, -1),
    'PV2_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIAL_PROGRAM_CODE', 'HL70214', -1),
    'PV2_19': ('leaf', None, 'ID', 'RETENTION_INDICATOR', 'HL70136', -1),
    'PV2_20': ('leaf', None, 'NM', 'EXPECTED_NUMBER_OF_INSURANCE_PLANS', None, -1),
    'PV2_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VISIT_PUBLICITY_CODE', 'HL70215', -1),
    'PV2_22': ('leaf', None, 'ID', 'VISIT_PROTECTION_INDICATOR', 'HL70136', -1),
    'PV2_23': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'CLINIC_ORGANIZATION_NAME', None, -1),
    'PV2_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_STATUS_CODE', 'HL70216', -1),
    'PV2_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VISIT_PRIORITY_CODE', 'HL70217', -1),
    'PV2_26': ('leaf', None, 'DT', 'PREVIOUS_TREATMENT_DATE', None, -1),
    'PV2_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EXPECTED_DISCHARGE_DISPOSITION', 'HL70112', -1),
    'PV2_28': ('leaf', None, 'DT', 'SIGNATURE_ON_FILE_DATE', None, -1),
    'PV2_29': ('leaf', None, 'DT', 'FIRST_SIMILAR_ILLNESS_DATE', None, -1),
    'PV2_30': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_CHARGE_ADJUSTMENT_CODE', 'HL70218', -1),
    'PV2_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RECURRING_SERVICE_CODE', 'HL70219', -1),
    'PV2_32': ('leaf', None, 'ID', 'BILLING_MEDIA_CODE', 'HL70136', -1),
    'PV2_33': ('leaf', None, 'DTM', 'EXPECTED_SURGERY_DATE_AND_TIME', None, -1),
    'PV2_34': ('leaf', None, 'ID', 'MILITARY_PARTNERSHIP_CODE', 'HL70136', -1),
    'PV2_35': ('leaf', None, 'ID', 'MILITARY_NON_AVAILABILITY_CODE', 'HL70136', -1),
    'PV2_36': ('leaf', None, 'ID', 'NEWBORN_BABY_INDICATOR', 'HL70136', -1),
    'PV2_37': ('leaf', None, 'ID', 'BABY_DETAINED_INDICATOR', 'HL70136', -1),
    'PV2_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MODE_OF_ARRIVAL_CODE', 'HL70430', -1),
    'PV2_39': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RECREATIONAL_DRUG_USE_CODE', 'HL70431', -1),
    'PV2_40': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMISSION_LEVEL_OF_CARE_CODE', 'HL70432', -1),
    'PV2_41': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRECAUTION_CODE', 'HL70433', -1),
    'PV2_42': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PATIENT_CONDITION_CODE', 'HL70434', -1),
    'PV2_43': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIVING_WILL_CODE', 'HL70315', -1),
    'PV2_44': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORGAN_DONOR_CODE', 'HL70316', -1),
    'PV2_45': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADVANCE_DIRECTIVE_CODE', 'HL70435', -1),
    'PV2_46': ('leaf', None, 'DT', 'PATIENT_STATUS_EFFECTIVE_DATE', None, -1),
    'PV2_47': ('leaf', None, 'DTM', 'EXPECTED_LOA_RETURN_DATE_TIME', None, -1),
    'PV2_48': ('leaf', None, 'DTM', 'EXPECTED_PRE_ADMISSION_TESTING_DATE_TIME', None, -1),
    'PV2_49': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'NOTIFY_CLERGY_CODE', 'HL70534', -1),
    'PV2_50': ('leaf', None, 'DT', 'ADVANCE_DIRECTIVE_LAST_VERIFIED_DATE', None, -1),
    'PYE_1': ('leaf', None, 'SI', 'SET_ID_PYE', None, -1),
    'PYE_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PAYEE_TYPE', 'HL70557', -1),
    'PYE_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PAYEE_RELATIONSHIP_TO_INVOICE_PATIENT', 'HL70558', -1),
    'PYE_4': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'PAYEE_IDENTIFICATION_LIST', None, -1),
    'PYE_5': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'PAYEE_PERSON_NAME', None, -1),
    'PYE_6': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PAYEE_ADDRESS', None, -1),
    'PYE_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PAYMENT_METHOD', 'HL70570', -1),
    'QAK_1': ('leaf', None, 'ST', 'QUERY_TAG', None, -1),
    'QAK_2': ('leaf', None, 'ID', 'QUERY_RESPONSE_STATUS', 'HL70208', -1),
    'QAK_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MESSAGE_QUERY_NAME', 'HL70471', -1),
    'QAK_4': ('leaf', None, 'NM', 'HIT_COUNT_TOTAL', None, -1),
    'QAK_5': ('leaf', None, 'NM', 'THIS_PAYLOAD', None, -1),
    'QAK_6': ('leaf', None, 'NM', 'HITS_REMAINING', None, -1),
    'QID_1': ('leaf', None, 'ST', 'QUERY_TAG', None, -1),
    'QID_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MESSAGE_QUERY_NAME', 'HL70471', -1),
    'QPD_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MESSAGE_QUERY_NAME', 'HL70471', -1),
    'QPD_2': ('leaf', None, 'ST', 'QUERY_TAG', None, -1),
    'QPD_3': ('leaf', None, 'varies', 'USER_PARAMETERS_IN_SUCCESSIVE_FIELDS', None, -1),
    'QRI_1': ('leaf', None, 'NM', 'CANDIDATE_CONFIDENCE', None, -1),
    'QRI_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MATCH_REASON_CODE', 'HL70392', -1),
    'QRI_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ALGORITHM_DESCRIPTOR', 'HL70393', -1),
    'RCP_1': ('leaf', None, 'ID', 'QUERY_PRIORITY', 'HL70091', -1),
    'RCP_2': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_LIMITED_REQUEST', 'HL70126', -1),
    'RCP_3': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'RESPONSE_MODALITY', 'HL70394', -1),
    'RCP_4': ('leaf', None, 'DTM', 'EXECUTION_AND_DELIVERY_TIME', None, -1),
    'RCP_5': ('leaf', None, 'ID', 'MODIFY_INDICATOR', 'HL70395', -1),
    'RCP_6': ('sequence', DATATYPES_STRUCTS['SRT'], 'SRT', 'SORT_BY_FIELD', None, -1),
    'RCP_7': ('leaf', None, 'ID', 'SEGMENT_GROUP_INCLUSION', 'HL70391', -1),
    'RDF_1': ('leaf', None, 'NM', 'NUMBER_OF_COLUMNS_PER_ROW', None, -1),
    'RDF_2': ('sequence', DATATYPES_STRUCTS['RCD'], 'RCD', 'COLUMN_DESCRIPTION', 'HL70440', -1),
    'RDT_1': ('leaf', None, 'varies', 'COLUMN_VALUE', None, -1),
    'REL_1': ('leaf', None, 'SI', 'SET_ID_REL', None, -1),
    'REL_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELATIONSHIP_TYPE', None, -1),
    'REL_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'THIS_RELATIONSHIP_INSTANCE_IDENTIFIER', None, -1),
    'REL_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SOURCE_INFORMATION_INSTANCE_IDENTIFIER', None, -1),
    'REL_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'TARGET_INFORMATION_INSTANCE_IDENTIFIER', None, -1),
    'REL_6': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ASSERTING_ENTITY_INSTANCE_ID', None, -1),
    'REL_7': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ASSERTING_PERSON', None, -1),
    'REL_8': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ASSERTING_ORGANIZATION', None, -1),
    'REL_9': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ASSERTOR_ADDRESS', None, -1),
    'REL_10': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ASSERTOR_CONTACT', None, -1),
    'REL_11': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'ASSERTION_DATE_RANGE', None, -1),
    'REL_12': ('leaf', None, 'ID', 'NEGATION_INDICATOR', 'HL70136', -1),
    'REL_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CERTAINTY_OF_RELATIONSHIP', None, -1),
    'REL_14': ('leaf', None, 'NM', 'PRIORITY_NO', None, -1),
    'REL_15': ('leaf', None, 'NM', 'PRIORITY_SEQUENCE_NO_REL_PREFERENCE_FOR_CONSIDERATION', None, -1),
    'REL_16': ('leaf', None, 'ID', 'SEPARABILITY_INDICATOR', 'HL70136', -1),
    'RF1_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REFERRAL_STATUS', 'HL70283', -1),
    'RF1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REFERRAL_PRIORITY', 'HL70280', -1),
    'RF1_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REFERRAL_TYPE', 'HL70281', -1),
    'RF1_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REFERRAL_DISPOSITION', 'HL70282', -1),
    'RF1_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REFERRAL_CATEGORY', 'HL70284', -1),
    'RF1_6': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ORIGINATING_REFERRAL_IDENTIFIER', None, -1),
    'RF1_7': ('leaf', None, 'DTM', 'EFFECTIVE_DATE', None, -1),
    'RF1_8': ('leaf', None, 'DTM', 'EXPIRATION_DATE', None, -1),
    'RF1_9': ('leaf', None, 'DTM', 'PROCESS_DATE', None, -1),
    'RF1_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REFERRAL_REASON', 'HL70336', -1),
    'RF1_11': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EXTERNAL_REFERRAL_IDENTIFIER', None, -1),
    'RF1_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REFERRAL_DOCUMENTATION_COMPLETION_STATUS', 'HL70865', -1),
    'RF1_13': ('leaf', None, 'DTM', 'PLANNED_TREATMENT_STOP_DATE', None, -1),
    'RF1_14': ('leaf', None, 'ST', 'REFERRAL_REASON_TEXT', None, -1),
    'RF1_15': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NUMBER_OF_AUTHORIZED_TREATMENTS_UNITS', None, -1),
    'RF1_16': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NUMBER_OF_USED_TREATMENTS_UNITS', None, -1),
    'RF1_17': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NUMBER_OF_SCHEDULE_TREATMENTS_UNITS', None, -1),
    'RF1_18': ('sequence', DATATYPES_STRUCTS['MO'], 'MO', 'REMAINING_BENEFIT_AMOUNT', None, -1),
    'RF1_19': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'AUTHORIZED_PROVIDER', None, -1),
    'RF1_20': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'AUTHORIZED_HEALTH_PROFESSIONAL', None, -1),
    'RF1_21': ('leaf', None, 'ST', 'SOURCE_TEXT', None, -1),
    'RF1_22': ('leaf', None, 'DTM', 'SOURCE_DATE', None, -1),
    'RF1_23': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'SOURCE_PHONE', None, -1),
    'RF1_24': ('leaf', None, 'ST', 'COMMENT', None, -1),
    'RF1_25': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'RFI_1': ('leaf', None, 'DTM', 'REQUEST_DATE', None, -1),
    'RFI_2': ('leaf', None, 'DTM', 'RESPONSE_DUE_DATE', None, -1),
    'RFI_3': ('leaf', None, 'ID', 'PATIENT_CONSENT', 'HL70136', -1),
    'RFI_4': ('leaf', None, 'DTM', 'DATE_ADDITIONAL_INFORMATION_WAS_SUBMITTED', None, -1),
    'RGS_1': ('leaf', None, 'SI', 'SET_ID_RGS', None, -1),
    'RGS_2': ('leaf', None, 'ID', 'SEGMENT_ACTION_CODE', 'HL70206', -1),
    'RGS_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RESOURCE_GROUP_ID', None, -1),
    'RMI_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RISK_MANAGEMENT_INCIDENT_CODE', 'HL70427', -1),
    'RMI_2': ('leaf', None, 'DTM', 'DATE_TIME_INCIDENT', None, -1),
    'RMI_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INCIDENT_TYPE_CODE', 'HL70428', -1),
    'ROL_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ROLE_INSTANCE_ID', None, -1),
    'ROL_2': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'ROL_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ROLE_ROL', 'HL70443', -1),
    'ROL_4': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ROLE_PERSON', None, -1),
    'ROL_5': ('leaf', None, 'DTM', 'ROLE_BEGIN_DATE_TIME', None, -1),
    'ROL_6': ('leaf', None, 'DTM', 'ROLE_END_DATE_TIME', None, -1),
    'ROL_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ROLE_DURATION', None, -1),
    'ROL_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ROLE_ACTION_REASON', None, -1),
    'ROL_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROVIDER_TYPE', None, -1),
    'ROL_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ORGANIZATION_UNIT_TYPE', 'HL70406', -1),
    'ROL_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'OFFICE_HOME_ADDRESS_BIRTHPLACE', None, -1),
    'ROL_12': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE', None, -1),
    'ROL_13': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PERSON_S_LOCATION', None, -1),
    'ROL_14': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'ORGANIZATION', None, -1),
    'RQ1_1': ('leaf', None, 'ST', 'ANTICIPATED_PRICE', None, -1),
    'RQ1_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MANUFACTURER_IDENTIFIER', 'HL70385', -1),
    'RQ1_3': ('leaf', None, 'ST', 'MANUFACTURER_S_CATALOG', None, -1),
    'RQ1_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VENDOR_ID', 'HL79999', -1),
    'RQ1_5': ('leaf', None, 'ST', 'VENDOR_CATALOG', None, -1),
    'RQ1_6': ('leaf', None, 'ID', 'TAXABLE', 'HL70136', -1),
    'RQ1_7': ('leaf', None, 'ID', 'SUBSTITUTE_ALLOWED', 'HL70136', -1),
    'RQD_1': ('leaf', None, 'SI', 'REQUISITION_LINE_NUMBER', None, -1),
    'RQD_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_CODE_INTERNAL', 'HL79999', -1),
    'RQD_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_CODE_EXTERNAL', 'HL79999', -1),
    'RQD_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HOSPITAL_ITEM_CODE', 'HL79999', -1),
    'RQD_5': ('leaf', None, 'NM', 'REQUISITION_QUANTITY', None, -1),
    'RQD_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUISITION_UNIT_OF_MEASURE', 'HL79999', -1),
    'RQD_7': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'COST_CENTER_ACCOUNT_NUMBER', 'HL70319', -1),
    'RQD_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ITEM_NATURAL_ACCOUNT_CODE', 'HL70320', -1),
    'RQD_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DELIVER_TO_ID', 'HL79999', -1),
    'RQD_10': ('leaf', None, 'DT', 'DATE_NEEDED', None, -1),
    'RXA_1': ('leaf', None, 'NM', 'GIVE_SUB_ID_COUNTER', None, -1),
    'RXA_2': ('leaf', None, 'NM', 'ADMINISTRATION_SUB_ID_COUNTER', None, -1),
    'RXA_3': ('leaf', None, 'DTM', 'DATE_TIME_START_OF_ADMINISTRATION', None, -1),
    'RXA_4': ('leaf', None, 'DTM', 'DATE_TIME_END_OF_ADMINISTRATION', None, -1),
    'RXA_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTERED_CODE', 'HL70292', -1),
    'RXA_6': ('leaf', None, 'NM', 'ADMINISTERED_AMOUNT', None, -1),
    'RXA_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTERED_UNITS', 'HL79999', -1),
    'RXA_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTERED_DOSAGE_FORM', 'HL79999', -1),
    'RXA_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATION_NOTES', 'HL79999', -1),
    'RXA_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ADMINISTERING_PROVIDER', None, -1),
    'RXA_12': ('leaf', None, 'ST', 'ADMINISTERED_PER_TIME_UNIT', None, -1),
    'RXA_13': ('leaf', None, 'NM', 'ADMINISTERED_STRENGTH', None, -1),
    'RXA_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTERED_STRENGTH_UNITS', 'HL79999', -1),
    'RXA_15': ('leaf', None, 'ST', 'SUBSTANCE_LOT_NUMBER', None, -1),
    'RXA_16': ('leaf', None, 'DTM', 'SUBSTANCE_EXPIRATION_DATE', None, -1),
    'RXA_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBSTANCE_MANUFACTURER_NAME', None, -1),
    'RXA_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBSTANCE_TREATMENT_REFUSAL_REASON', 'HL79999', -1),
    'RXA_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INDICATION', 'HL79999', -1),
    'RXA_20': ('leaf', None, 'ID', 'COMPLETION_STATUS', 'HL70322', -1),
    'RXA_21': ('leaf', None, 'ID', 'ACTION_CODE_RXA', 'HL70206', -1),
    'RXA_22': ('leaf', None, 'DTM', 'SYSTEM_ENTRY_DATE_TIME', None, -1),
    'RXA_23': ('leaf', None, 'NM', 'ADMINISTERED_DRUG_STRENGTH_VOLUME', None, -1),
    'RXA_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTERED_DRUG_STRENGTH_VOLUME_UNITS', 'HL79999', -1),
    'RXA_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTERED_BARCODE_IDENTIFIER', 'HL79999', -1),
    'RXA_26': ('leaf', None, 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480', -1),
    'RXA_27': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ADMINISTER_AT', None, -1),
    'RXA_28': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'ADMINISTERED_AT_ADDRESS', None, -1),
    'RXA_29': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ADMINISTERED_TAG_IDENTIFIER', None, -1),
    'RXC_1': ('leaf', None, 'ID', 'RX_COMPONENT_TYPE', 'HL70166', -1),
    'RXC_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COMPONENT_CODE', 'HL79999', -1),
    'RXC_3': ('leaf', None, 'NM', 'COMPONENT_AMOUNT', None, -1),
    'RXC_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COMPONENT_UNITS', 'HL79999', -1),
    'RXC_5': ('leaf', None, 'NM', 'COMPONENT_STRENGTH', None, -1),
    'RXC_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COMPONENT_STRENGTH_UNITS', 'HL79999', -1),
    'RXC_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUPPLEMENTARY_CODE', 'HL79999', -1),
    'RXC_8': ('leaf', None, 'NM', 'COMPONENT_DRUG_STRENGTH_VOLUME', None, -1),
    'RXC_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COMPONENT_DRUG_STRENGTH_VOLUME_UNITS', 'HL79999', -1),
    'RXC_10': ('leaf', None, 'NM', 'DISPENSE_AMOUNT', None, -1),
    'RXC_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_UNITS', 'HL79999', -1),
    'RXD_1': ('leaf', None, 'NM', 'DISPENSE_SUB_ID_COUNTER', None, -1),
    'RXD_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_GIVE_CODE', 'HL70292', -1),
    'RXD_3': ('leaf', None, 'DTM', 'DATE_TIME_DISPENSED', None, -1),
    'RXD_4': ('leaf', None, 'NM', 'ACTUAL_DISPENSE_AMOUNT', None, -1),
    'RXD_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACTUAL_DISPENSE_UNITS', 'HL79999', -1),
    'RXD_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACTUAL_DOSAGE_FORM', 'HL79999', -1),
    'RXD_7': ('leaf', None, 'ST', 'PRESCRIPTION_NUMBER', None, -1),
    'RXD_8': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_REMAINING', None, -1),
    'RXD_9': ('leaf', None, 'ST', 'DISPENSE_NOTES', None, -1),
    'RXD_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DISPENSING_PROVIDER', None, -1),
    'RXD_11': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXD_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DAILY_DOSE', None, -1),
    'RXD_14': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136', -1),
    'RXD_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIAL_DISPENSING_INSTRUCTIONS', 'HL79999', -1),
    'RXD_16': ('leaf', None, 'NM', 'ACTUAL_STRENGTH', None, -1),
    'RXD_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACTUAL_STRENGTH_UNIT', 'HL79999', -1),
    'RXD_18': ('leaf', None, 'ST', 'SUBSTANCE_LOT_NUMBER', None, -1),
    'RXD_19': ('leaf', None, 'DTM', 'SUBSTANCE_EXPIRATION_DATE', None, -1),
    'RXD_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBSTANCE_MANUFACTURER_NAME', None, -1),
    'RXD_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INDICATION', 'HL79999', -1),
    'RXD_22': ('leaf', None, 'NM', 'DISPENSE_PACKAGE_SIZE', None, -1),
    'RXD_23': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_PACKAGE_SIZE_UNIT', 'HL79999', -1),
    'RXD_24': ('leaf', None, 'ID', 'DISPENSE_PACKAGE_METHOD', 'HL70321', -1),
    'RXD_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUPPLEMENTARY_CODE', 'HL79999', -1),
    'RXD_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INITIATING_LOCATION', 'HL79999', -1),
    'RXD_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PACKAGING_ASSEMBLY_LOCATION', 'HL79999', -1),
    'RXD_28': ('leaf', None, 'NM', 'ACTUAL_DRUG_STRENGTH_VOLUME', None, -1),
    'RXD_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ACTUAL_DRUG_STRENGTH_VOLUME_UNITS', 'HL79999', -1),
    'RXD_30': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_TO_PHARMACY', 'HL79999', -1),
    'RXD_31': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'DISPENSE_TO_PHARMACY_ADDRESS', None, -1),
    'RXD_32': ('leaf', None, 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480', -1),
    'RXD_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_TYPE', 'HL70484', -1),
    'RXD_34': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHARMACY_PHONE_NUMBER', None, -1),
    'RXD_35': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'DISPENSE_TAG_IDENTIFIER', None, -1),
    'RXE_1': ('leaf', None, 'WD', 'QUANTITY_TIMING', None, -1),
    'RXE_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_CODE', 'HL70292', -1),
    'RXE_3': ('leaf', None, 'NM', 'GIVE_AMOUNT_MINIMUM', None, -1),
    'RXE_4': ('leaf', None, 'NM', 'GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXE_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_UNITS', 'HL79999', -1),
    'RXE_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_DOSAGE_FORM', 'HL79999', -1),
    'RXE_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', 'HL79999', -1),
    'RXE_8': ('leaf', None, 'WD', 'DELIVER_TO_LOCATION', None, -1),
    'RXE_9': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXE_10': ('leaf', None, 'NM', 'DISPENSE_AMOUNT', None, -1),
    'RXE_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_UNITS', 'HL79999', -1),
    'RXE_12': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS', None, -1),
    'RXE_13': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERING_PROVIDER_S_DEA_NUMBER', None, -1),
    'RXE_14': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PHARMACIST_TREATMENT_SUPPLIER_S_VERIFIER_ID', None, -1),
    'RXE_15': ('leaf', None, 'ST', 'PRESCRIPTION_NUMBER', None, -1),
    'RXE_16': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_REMAINING', None, -1),
    'RXE_17': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_DOSES_DISPENSED', None, -1),
    'RXE_18': ('leaf', None, 'DTM', 'D_T_OF_MOST_RECENT_REFILL_OR_DOSE_DISPENSED', None, -1),
    'RXE_19': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DAILY_DOSE', None, -1),
    'RXE_20': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136', -1),
    'RXE_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIAL_DISPENSING_INSTRUCTIONS', 'HL79999', -1),
    'RXE_22': ('leaf', None, 'ST', 'GIVE_PER_TIME_UNIT', None, -1),
    'RXE_23': ('leaf', None, 'ST', 'GIVE_RATE_AMOUNT', None, -1),
    'RXE_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_RATE_UNITS', 'HL79999', -1),
    'RXE_25': ('leaf', None, 'NM', 'GIVE_STRENGTH', None, -1),
    'RXE_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_STRENGTH_UNITS', 'HL79999', -1),
    'RXE_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_INDICATION', 'HL79999', -1),
    'RXE_28': ('leaf', None, 'NM', 'DISPENSE_PACKAGE_SIZE', None, -1),
    'RXE_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_PACKAGE_SIZE_UNIT', 'HL79999', -1),
    'RXE_30': ('leaf', None, 'ID', 'DISPENSE_PACKAGE_METHOD', 'HL70321', -1),
    'RXE_31': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUPPLEMENTARY_CODE', 'HL79999', -1),
    'RXE_32': ('leaf', None, 'DTM', 'ORIGINAL_ORDER_DATE_TIME', None, -1),
    'RXE_33': ('leaf', None, 'NM', 'GIVE_DRUG_STRENGTH_VOLUME', None, -1),
    'RXE_34': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_DRUG_STRENGTH_VOLUME_UNITS', 'HL79999', -1),
    'RXE_35': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTROLLED_SUBSTANCE_SCHEDULE', 'HL70477', -1),
    'RXE_36': ('leaf', None, 'ID', 'FORMULARY_STATUS', 'HL70478', -1),
    'RXE_37': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PHARMACEUTICAL_SUBSTANCE_ALTERNATIVE', 'HL79999', -1),
    'RXE_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PHARMACY_OF_MOST_RECENT_FILL', 'HL79999', -1),
    'RXE_39': ('leaf', None, 'NM', 'INITIAL_DISPENSE_AMOUNT', None, -1),
    'RXE_40': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSING_PHARMACY', 'HL79999', -1),
    'RXE_41': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'DISPENSING_PHARMACY_ADDRESS', None, -1),
    'RXE_42': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'DELIVER_TO_PATIENT_LOCATION', None, -1),
    'RXE_43': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'DELIVER_TO_ADDRESS', None, -1),
    'RXE_44': ('leaf', None, 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480', -1),
    'RXE_45': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHARMACY_PHONE_NUMBER', None, -1),
    'RXG_1': ('leaf', None, 'NM', 'GIVE_SUB_ID_COUNTER', None, -1),
    'RXG_2': ('leaf', None, 'NM', 'DISPENSE_SUB_ID_COUNTER', None, -1),
    'RXG_3': ('leaf', None, 'WD', 'QUANTITY_TIMING', None, -1),
    'RXG_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_CODE', 'HL70292', -1),
    'RXG_5': ('leaf', None, 'NM', 'GIVE_AMOUNT_MINIMUM', None, -1),
    'RXG_6': ('leaf', None, 'NM', 'GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXG_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_UNITS', 'HL79999', -1),
    'RXG_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_DOSAGE_FORM', 'HL79999', -1),
    'RXG_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATION_NOTES', 'HL79999', -1),
    'RXG_10': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXG_12': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136', -1),
    'RXG_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIAL_ADMINISTRATION_INSTRUCTIONS', 'HL79999', -1),
    'RXG_14': ('leaf', None, 'ST', 'GIVE_PER_TIME_UNIT', None, -1),
    'RXG_15': ('leaf', None, 'ST', 'GIVE_RATE_AMOUNT', None, -1),
    'RXG_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_RATE_UNITS', 'HL79999', -1),
    'RXG_17': ('leaf', None, 'NM', 'GIVE_STRENGTH', None, -1),
    'RXG_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_STRENGTH_UNITS', 'HL79999', -1),
    'RXG_19': ('leaf', None, 'ST', 'SUBSTANCE_LOT_NUMBER', None, -1),
    'RXG_20': ('leaf', None, 'DTM', 'SUBSTANCE_EXPIRATION_DATE', None, -1),
    'RXG_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBSTANCE_MANUFACTURER_NAME', None, -1),
    'RXG_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INDICATION', 'HL79999', -1),
    'RXG_23': ('leaf', None, 'NM', 'GIVE_DRUG_STRENGTH_VOLUME', None, -1),
    'RXG_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_DRUG_STRENGTH_VOLUME_UNITS', 'HL79999', -1),
    'RXG_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GIVE_BARCODE_IDENTIFIER', 'HL79999', -1),
    'RXG_26': ('leaf', None, 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480', -1),
    'RXG_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_TO_PHARMACY', 'HL79999', -1),
    'RXG_28': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'DISPENSE_TO_PHARMACY_ADDRESS', None, -1),
    'RXG_29': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'DELIVER_TO_PATIENT_LOCATION', None, -1),
    'RXG_30': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'DELIVER_TO_ADDRESS', None, -1),
    'RXG_31': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'GIVE_TAG_IDENTIFIER', None, -1),
    'RXG_32': ('leaf', None, 'NM', 'DISPENSE_AMOUNT', None, -1),
    'RXG_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSE_UNITS', 'HL79999', -1),
    'RXO_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_GIVE_CODE', 'HL79999', -1),
    'RXO_2': ('leaf', None, 'NM', 'REQUESTED_GIVE_AMOUNT_MINIMUM', None, -1),
    'RXO_3': ('leaf', None, 'NM', 'REQUESTED_GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXO_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_GIVE_UNITS', 'HL79999', -1),
    'RXO_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_DOSAGE_FORM', 'HL79999', -1),
    'RXO_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROVIDER_S_PHARMACY_TREATMENT_INSTRUCTIONS', 'HL79999', -1),
    'RXO_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', 'HL79999', -1),
    'RXO_8': ('leaf', None, 'WD', 'DELIVER_TO_LOCATION', None, -1),
    'RXO_9': ('leaf', None, 'ID', 'ALLOW_SUBSTITUTIONS', 'HL70161', -1),
    'RXO_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_DISPENSE_CODE', 'HL79999', -1),
    'RXO_11': ('leaf', None, 'NM', 'REQUESTED_DISPENSE_AMOUNT', None, -1),
    'RXO_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_DISPENSE_UNITS', 'HL79999', -1),
    'RXO_13': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS', None, -1),
    'RXO_14': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORDERING_PROVIDER_S_DEA_NUMBER', None, -1),
    'RXO_15': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PHARMACIST_TREATMENT_SUPPLIER_S_VERIFIER_ID', None, -1),
    'RXO_16': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', 'HL70136', -1),
    'RXO_17': ('leaf', None, 'ST', 'REQUESTED_GIVE_PER_TIME_UNIT', None, -1),
    'RXO_18': ('leaf', None, 'NM', 'REQUESTED_GIVE_STRENGTH', None, -1),
    'RXO_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_GIVE_STRENGTH_UNITS', 'HL79999', -1),
    'RXO_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INDICATION', 'HL79999', -1),
    'RXO_21': ('leaf', None, 'ST', 'REQUESTED_GIVE_RATE_AMOUNT', None, -1),
    'RXO_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_GIVE_RATE_UNITS', 'HL79999', -1),
    'RXO_23': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DAILY_DOSE', None, -1),
    'RXO_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUPPLEMENTARY_CODE', 'HL79999', -1),
    'RXO_25': ('leaf', None, 'NM', 'REQUESTED_DRUG_STRENGTH_VOLUME', None, -1),
    'RXO_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'REQUESTED_DRUG_STRENGTH_VOLUME_UNITS', 'HL79999', -1),
    'RXO_27': ('leaf', None, 'ID', 'PHARMACY_ORDER_TYPE', 'HL70480', -1),
    'RXO_28': ('leaf', None, 'NM', 'DISPENSING_INTERVAL', None, -1),
    'RXO_29': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'MEDICATION_INSTANCE_IDENTIFIER', None, -1),
    'RXO_30': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SEGMENT_INSTANCE_IDENTIFIER', None, -1),
    'RXO_31': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'MOOD_CODE', 'HL70725', -1),
    'RXO_32': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DISPENSING_PHARMACY', 'HL79999', -1),
    'RXO_33': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'DISPENSING_PHARMACY_ADDRESS', None, -1),
    'RXO_34': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'DELIVER_TO_PATIENT_LOCATION', None, -1),
    'RXO_35': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'DELIVER_TO_ADDRESS', None, -1),
    'RXO_36': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHARMACY_PHONE_NUMBER', None, -1),
    'RXR_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ROUTE', 'HL70162', -1),
    'RXR_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATION_SITE', 'HL70550', -1),
    'RXR_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATION_DEVICE', 'HL70164', -1),
    'RXR_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATION_METHOD', 'HL70165', -1),
    'RXR_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ROUTING_INSTRUCTION', 'HL79999', -1),
    'RXR_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATION_SITE_MODIFIER', 'HL70495', -1),
    'RXV_1': ('leaf', None, 'SI', 'SET_ID_RXV', None, -1),
    'RXV_2': ('leaf', None, 'ID', 'BOLUS_TYPE', 'HL70917', -1),
    'RXV_3': ('leaf', None, 'NM', 'BOLUS_DOSE_AMOUNT', None, -1),
    'RXV_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BOLUS_DOSE_AMOUNT_UNITS', 'HL79999', -1),
    'RXV_5': ('leaf', None, 'NM', 'BOLUS_DOSE_VOLUME', None, -1),
    'RXV_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BOLUS_DOSE_VOLUME_UNITS', 'HL79999', -1),
    'RXV_7': ('leaf', None, 'ID', 'PCA_TYPE', 'HL70918', -1),
    'RXV_8': ('leaf', None, 'NM', 'PCA_DOSE_AMOUNT', None, -1),
    'RXV_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PCA_DOSE_AMOUNT_UNITS', 'HL79999', -1),
    'RXV_10': ('leaf', None, 'NM', 'PCA_DOSE_AMOUNT_VOLUME', None, -1),
    'RXV_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PCA_DOSE_AMOUNT_VOLUME_UNITS', 'HL79999', -1),
    'RXV_12': ('leaf', None, 'NM', 'MAX_DOSE_AMOUNT', None, -1),
    'RXV_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MAX_DOSE_AMOUNT_UNITS', 'HL79999', -1),
    'RXV_14': ('leaf', None, 'NM', 'MAX_DOSE_AMOUNT_VOLUME', None, -1),
    'RXV_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MAX_DOSE_AMOUNT_VOLUME_UNITS', 'HL79999', -1),
    'RXV_16': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'MAX_DOSE_PER_TIME', None, -1),
    'RXV_17': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'LOCKOUT_INTERVAL', None, -1),
    'RXV_18': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SYRINGE_MANUFACTURER', None, -1),
    'RXV_19': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SYRINGE_MODEL_NUMBER', None, -1),
    'RXV_20': ('leaf', None, 'NM', 'SYRINGE_SIZE', None, -1),
    'RXV_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SYRINGE_SIZE_UNITS', None, -1),
    'RXV_22': ('leaf', None, 'ID', 'ACTION_CODE', 'HL70206', -1),
    'SAC_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EXTERNAL_ACCESSION_IDENTIFIER', None, -1),
    'SAC_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ACCESSION_IDENTIFIER', None, -1),
    'SAC_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'CONTAINER_IDENTIFIER', None, -1),
    'SAC_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PRIMARY_PARENT_CONTAINER_IDENTIFIER', None, -1),
    'SAC_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EQUIPMENT_CONTAINER_IDENTIFIER', None, -1),
    'SAC_6': ('leaf', None, 'WD', 'SPECIMEN_SOURCE', None, -1),
    'SAC_7': ('leaf', None, 'DTM', 'REGISTRATION_DATE_TIME', None, -1),
    'SAC_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTAINER_STATUS', 'HL70370', -1),
    'SAC_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CARRIER_TYPE', 'HL70378', -1),
    'SAC_10': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'CARRIER_IDENTIFIER', None, -1),
    'SAC_11': ('sequence', DATATYPES_STRUCTS['NA'], 'NA', 'POSITION_IN_CARRIER', None, -1),
    'SAC_12': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TRAY_TYPE_SAC', 'HL70379', -1),
    'SAC_13': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'TRAY_IDENTIFIER', None, -1),
    'SAC_14': ('sequence', DATATYPES_STRUCTS['NA'], 'NA', 'POSITION_IN_TRAY', None, -1),
    'SAC_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOCATION', 'HL79999', -1),
    'SAC_16': ('leaf', None, 'NM', 'CONTAINER_HEIGHT', None, -1),
    'SAC_17': ('leaf', None, 'NM', 'CONTAINER_DIAMETER', None, -1),
    'SAC_18': ('leaf', None, 'NM', 'BARRIER_DELTA', None, -1),
    'SAC_19': ('leaf', None, 'NM', 'BOTTOM_DELTA', None, -1),
    'SAC_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTAINER_HEIGHT_DIAMETER_DELTA_UNITS', 'HL79999', -1),
    'SAC_21': ('leaf', None, 'NM', 'CONTAINER_VOLUME', None, -1),
    'SAC_22': ('leaf', None, 'NM', 'AVAILABLE_SPECIMEN_VOLUME', None, -1),
    'SAC_23': ('leaf', None, 'NM', 'INITIAL_SPECIMEN_VOLUME', None, -1),
    'SAC_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VOLUME_UNITS', 'HL79999', -1),
    'SAC_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SEPARATOR_TYPE', 'HL70380', -1),
    'SAC_26': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CAP_TYPE', 'HL70381', -1),
    'SAC_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADDITIVE', 'HL70371', -1),
    'SAC_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_COMPONENT', 'HL70372', -1),
    'SAC_29': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'DILUTION_FACTOR', None, -1),
    'SAC_30': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TREATMENT', 'HL70373', -1),
    'SAC_31': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'TEMPERATURE', None, -1),
    'SAC_32': ('leaf', None, 'NM', 'HEMOLYSIS_INDEX', None, -1),
    'SAC_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HEMOLYSIS_INDEX_UNITS', 'HL79999', -1),
    'SAC_34': ('leaf', None, 'NM', 'LIPEMIA_INDEX', None, -1),
    'SAC_35': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LIPEMIA_INDEX_UNITS', 'HL79999', -1),
    'SAC_36': ('leaf', None, 'NM', 'ICTERUS_INDEX', None, -1),
    'SAC_37': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ICTERUS_INDEX_UNITS', 'HL79999', -1),
    'SAC_38': ('leaf', None, 'NM', 'FIBRIN_INDEX', None, -1),
    'SAC_39': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FIBRIN_INDEX_UNITS', 'HL79999', -1),
    'SAC_40': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SYSTEM_INDUCED_CONTAMINANTS', 'HL70374', -1),
    'SAC_41': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DRUG_INTERFERENCE', 'HL70382', -1),
    'SAC_42': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ARTIFICIAL_BLOOD', 'HL70375', -1),
    'SAC_43': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIAL_HANDLING_CODE', 'HL70376', -1),
    'SAC_44': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'OTHER_ENVIRONMENTAL_FACTORS', 'HL70377', -1),
    'SCD_1': ('leaf', None, 'TM', 'CYCLE_START_TIME', None, -1),
    'SCD_2': ('leaf', None, 'NM', 'CYCLE_COUNT', None, -1),
    'SCD_3': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TEMP_MAX', None, -1),
    'SCD_4': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TEMP_MIN', None, -1),
    'SCD_5': ('leaf', None, 'NM', 'LOAD_NUMBER', None, -1),
    'SCD_6': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'CONDITION_TIME', None, -1),
    'SCD_7': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'STERILIZE_TIME', None, -1),
    'SCD_8': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'EXHAUST_TIME', None, -1),
    'SCD_9': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_CYCLE_TIME', None, -1),
    'SCD_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DEVICE_STATUS', 'HL70682', -1),
    'SCD_11': ('leaf', None, 'DTM', 'CYCLE_START_DATE_TIME', None, -1),
    'SCD_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'DRY_TIME', None, -1),
    'SCD_13': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'LEAK_RATE', None, -1),
    'SCD_14': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'CONTROL_TEMPERATURE', None, -1),
    'SCD_15': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'STERILIZER_TEMPERATURE', None, -1),
    'SCD_16': ('leaf', None, 'TM', 'CYCLE_COMPLETE_TIME', None, -1),
    'SCD_17': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'UNDER_TEMPERATURE', None, -1),
    'SCD_18': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'OVER_TEMPERATURE', None, -1),
    'SCD_19': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'ABORT_CYCLE', 'HL70532', -1),
    'SCD_20': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'ALARM', 'HL70532', -1),
    'SCD_21': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'LONG_IN_CHARGE_PHASE', 'HL70532', -1),
    'SCD_22': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'LONG_IN_EXHAUST_PHASE', 'HL70532', -1),
    'SCD_23': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'LONG_IN_FAST_EXHAUST_PHASE', 'HL70532', -1),
    'SCD_24': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'RESET', 'HL70532', -1),
    'SCD_25': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'OPERATOR_UNLOAD', None, -1),
    'SCD_26': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'DOOR_OPEN', 'HL70532', -1),
    'SCD_27': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'READING_FAILURE', 'HL70532', -1),
    'SCD_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CYCLE_TYPE', 'HL70702', -1),
    'SCD_29': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'THERMAL_RINSE_TIME', None, -1),
    'SCD_30': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'WASH_TIME', None, -1),
    'SCD_31': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'INJECTION_RATE', None, -1),
    'SCD_32': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PROCEDURE_CODE', 'HL70088', -1),
    'SCD_33': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'PATIENT_IDENTIFIER_LIST', None, -1),
    'SCD_34': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ATTENDING_DOCTOR', 'HL70010', -1),
    'SCD_35': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'DILUTION_FACTOR', None, -1),
    'SCD_36': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'FILL_TIME', None, -1),
    'SCD_37': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'INLET_TEMPERATURE', None, -1),
    'SCH_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_APPOINTMENT_ID', None, -1),
    'SCH_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_APPOINTMENT_ID', None, -1),
    'SCH_3': ('leaf', None, 'NM', 'OCCURRENCE_NUMBER', None, -1),
    'SCH_4': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'PLACER_GROUP_NUMBER', None, -1),
    'SCH_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SCHEDULE_ID', None, -1),
    'SCH_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EVENT_REASON', None, -1),
    'SCH_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPOINTMENT_REASON', 'HL70276', -1),
    'SCH_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPOINTMENT_TYPE', 'HL70277', -1),
    'SCH_10': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'APPOINTMENT_DURATION_UNITS', None, -1),
    'SCH_12': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PLACER_CONTACT_PERSON', None, -1),
    'SCH_13': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PLACER_CONTACT_PHONE_NUMBER', None, -1),
    'SCH_14': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'PLACER_CONTACT_ADDRESS', None, -1),
    'SCH_15': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'PLACER_CONTACT_LOCATION', None, -1),
    'SCH_16': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'FILLER_CONTACT_PERSON', None, -1),
    'SCH_17': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'FILLER_CONTACT_PHONE_NUMBER', None, -1),
    'SCH_18': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'FILLER_CONTACT_ADDRESS', None, -1),
    'SCH_19': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'FILLER_CONTACT_LOCATION', None, -1),
    'SCH_20': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ENTERED_BY_PERSON', None, -1),
    'SCH_21': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'ENTERED_BY_PHONE_NUMBER', None, -1),
    'SCH_22': ('sequence', DATATYPES_STRUCTS['PL'], 'PL', 'ENTERED_BY_LOCATION', None, -1),
    'SCH_23': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_PLACER_APPOINTMENT_ID', None, -1),
    'SCH_24': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_FILLER_APPOINTMENT_ID', None, -1),
    'SCH_25': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FILLER_STATUS_CODE', 'HL70278', -1),
    'SCH_26': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_ORDER_NUMBER', None, -1),
    'SCH_27': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'SCP_1': ('leaf', None, 'NM', 'NUMBER_OF_DECONTAMINATION_STERILIZATION_DEVICES', None, -1),
    'SCP_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LABOR_CALCULATION_TYPE', 'HL70651', -1),
    'SCP_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DATE_FORMAT', 'HL70653', -1),
    'SCP_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'DEVICE_NUMBER', None, -1),
    'SCP_5': ('leaf', None, 'ST', 'DEVICE_NAME', None, -1),
    'SCP_6': ('leaf', None, 'ST', 'DEVICE_MODEL_NAME', None, -1),
    'SCP_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DEVICE_TYPE', 'HL70657', -1),
    'SCP_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOT_CONTROL', 'HL70659', -1),
    'SDD_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'LOT_NUMBER', None, -1),
    'SDD_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'DEVICE_NUMBER', None, -1),
    'SDD_3': ('leaf', None, 'ST', 'DEVICE_NAME', None, -1),
    'SDD_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DEVICE_DATA_STATE', 'HL70667', -1),
    'SDD_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'LOAD_STATUS', 'HL70669', -1),
    'SDD_6': ('leaf', None, 'NM', 'CONTROL_CODE', None, -1),
    'SDD_7': ('leaf', None, 'ST', 'OPERATOR_NAME', None, -1),
    'SFT_1': ('sequence', DATATYPES_STRUCTS['XON'], 'XON', 'SOFTWARE_VENDOR_ORGANIZATION', None, -1),
    'SFT_2': ('leaf', None, 'ST', 'SOFTWARE_CERTIFIED_VERSION_OR_RELEASE_NUMBER', None, -1),
    'SFT_3': ('leaf', None, 'ST', 'SOFTWARE_PRODUCT_NAME', None, -1),
    'SFT_4': ('leaf', None, 'ST', 'SOFTWARE_BINARY_ID', None, -1),
    'SFT_5': ('leaf', None, 'TX', 'SOFTWARE_PRODUCT_INFORMATION', None, -1),
    'SFT_6': ('leaf', None, 'DTM', 'SOFTWARE_INSTALL_DATE', None, -1),
    'SGH_1': ('leaf', None, 'SI', 'SET_ID_SGH', None, -1),
    'SGH_2': ('leaf', None, 'ST', 'SEGMENT_GROUP_NAME', None, -1),
    'SGT_1': ('leaf', None, 'SI', 'SET_ID_SGT', None, -1),
    'SGT_2': ('leaf', None, 'ST', 'SEGMENT_GROUP_NAME', None, -1),
    'SHP_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SHIPMENT_ID', None, -1),
    'SHP_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'INTERNAL_SHIPMENT_ID', None, -1),
    'SHP_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SHIPMENT_STATUS', 'HL70905', -1),
    'SHP_4': ('leaf', None, 'DTM', 'SHIPMENT_STATUS_DATE_TIME', None, -1),
    'SHP_5': ('leaf', None, 'TX', 'SHIPMENT_STATUS_REASON', None, -1),
    'SHP_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SHIPMENT_PRIORITY', 'HL70906', -1),
    'SHP_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SHIPMENT_CONFIDENTIALITY', 'HL70907', -1),
    'SHP_8': ('leaf', None, 'NM', 'NUMBER_OF_PACKAGES_IN_SHIPMENT', None, -1),
    'SHP_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SHIPMENT_CONDITION', 'HL70544', -1),
    'SHP_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SHIPMENT_HANDLING_CODE', 'HL70376', -1),
    'SHP_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SHIPMENT_RISK_CODE', 'HL70489', -1),
    'SID_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'APPLICATION_METHOD_IDENTIFIER', 'HL79999', -1),
    'SID_2': ('leaf', None, 'ST', 'SUBSTANCE_LOT_NUMBER', None, -1),
    'SID_3': ('leaf', None, 'ST', 'SUBSTANCE_CONTAINER_IDENTIFIER', None, -1),
    'SID_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SUBSTANCE_MANUFACTURER_IDENTIFIER', 'HL70385', -1),
    'SLT_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'DEVICE_NUMBER', None, -1),
    'SLT_2': ('leaf', None, 'ST', 'DEVICE_NAME', None, -1),
    'SLT_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'LOT_NUMBER', None, -1),
    'SLT_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'ITEM_IDENTIFIER', None, -1),
    'SLT_5': ('leaf', None, 'ST', 'BAR_CODE', None, -1),
    'SPM_1': ('leaf', None, 'SI', 'SET_ID_SPM', None, -1),
    'SPM_2': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'SPECIMEN_ID', None, -1),
    'SPM_3': ('sequence', DATATYPES_STRUCTS['EIP'], 'EIP', 'SPECIMEN_PARENT_IDS', None, -1),
    'SPM_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_TYPE', 'HL70487', -1),
    'SPM_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_TYPE_MODIFIER', 'HL70541', -1),
    'SPM_6': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_ADDITIVES', 'HL70371', -1),
    'SPM_7': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_COLLECTION_METHOD', 'HL70488', -1),
    'SPM_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_SOURCE_SITE', 'HL79999', -1),
    'SPM_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_SOURCE_SITE_MODIFIER', 'HL70542', -1),
    'SPM_10': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_COLLECTION_SITE', 'HL70543', -1),
    'SPM_11': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_ROLE', 'HL70369', -1),
    'SPM_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'SPECIMEN_COLLECTION_AMOUNT', None, -1),
    'SPM_13': ('leaf', None, 'NM', 'GROUPED_SPECIMEN_COUNT', None, -1),
    'SPM_14': ('leaf', None, 'ST', 'SPECIMEN_DESCRIPTION', None, -1),
    'SPM_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_HANDLING_CODE', 'HL70376', -1),
    'SPM_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_RISK_CODE', 'HL70489', -1),
    'SPM_17': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'SPECIMEN_COLLECTION_DATE_TIME', None, -1),
    'SPM_18': ('leaf', None, 'DTM', 'SPECIMEN_RECEIVED_DATE_TIME', None, -1),
    'SPM_19': ('leaf', None, 'DTM', 'SPECIMEN_EXPIRATION_DATE_TIME', None, -1),
    'SPM_20': ('leaf', None, 'ID', 'SPECIMEN_AVAILABILITY', 'HL70136', -1),
    'SPM_21': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_REJECT_REASON', 'HL70490', -1),
    'SPM_22': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_QUALITY', 'HL70491', -1),
    'SPM_23': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_APPROPRIATENESS', 'HL70492', -1),
    'SPM_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_CONDITION', 'HL70493', -1),
    'SPM_25': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'SPECIMEN_CURRENT_QUANTITY', None, -1),
    'SPM_26': ('leaf', None, 'NM', 'NUMBER_OF_SPECIMEN_CONTAINERS', None, -1),
    'SPM_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTAINER_TYPE', 'HL79999', -1),
    'SPM_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONTAINER_CONDITION', 'HL70544', -1),
    'SPM_29': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'SPECIMEN_CHILD_ROLE', 'HL70494', -1),
    'SPM_30': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'ACCESSION_ID', None, -1),
    'SPM_31': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'OTHER_SPECIMEN_ID', None, -1),
    'SPM_32': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'SHIPMENT_ID', None, -1),
    'STF_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIMARY_KEY_VALUE_STF', 'HL79999', -1),
    'STF_2': ('sequence', DATATYPES_STRUCTS['CX'], 'CX', 'STAFF_IDENTIFIER_LIST', 'HL70061', -1),
    'STF_3': ('sequence', DATATYPES_STRUCTS['XPN'], 'XPN', 'STAFF_NAME', None, -1),
    'STF_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STAFF_TYPE', 'HL70182', -1),
    'STF_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ADMINISTRATIVE_SEX', 'HL70001', -1),
    'STF_6': ('leaf', None, 'DTM', 'DATE_TIME_OF_BIRTH', None, -1),
    'STF_7': ('leaf', None, 'ID', 'ACTIVE_INACTIVE_FLAG', 'HL70183', -1),
    'STF_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DEPARTMENT', 'HL70184', -1),
    'STF_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'HOSPITAL_SERVICE_STF', 'HL70069', -1),
    'STF_10': ('sequence', DATATYPES_STRUCTS['XTN'], 'XTN', 'PHONE', None, -1),
    'STF_11': ('sequence', DATATYPES_STRUCTS['XAD'], 'XAD', 'OFFICE_HOME_ADDRESS_BIRTHPLACE', None, -1),
    'STF_12': ('sequence', DATATYPES_STRUCTS['DIN'], 'DIN', 'INSTITUTION_ACTIVATION_DATE', 'HL70537', -1),
    'STF_13': ('sequence', DATATYPES_STRUCTS['DIN'], 'DIN', 'INSTITUTION_INACTIVATION_DATE', 'HL70537', -1),
    'STF_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'BACKUP_PERSON_ID', None, -1),
    'STF_15': ('leaf', None, 'ST', 'E_MAIL_ADDRESS', None, -1),
    'STF_16': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185', -1),
    'STF_17': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MARITAL_STATUS', 'HL70002', -1),
    'STF_18': ('leaf', None, 'ST', 'JOB_TITLE', None, -1),
    'STF_19': ('sequence', DATATYPES_STRUCTS['JCC'], 'JCC', 'JOB_CODE_CLASS', None, -1),
    'STF_20': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'EMPLOYMENT_STATUS_CODE', 'HL70066', -1),
    'STF_21': ('leaf', None, 'ID', 'ADDITIONAL_INSURED_ON_AUTO', 'HL70136', -1),
    'STF_22': ('sequence', DATATYPES_STRUCTS['DLN'], 'DLN', 'DRIVER_S_LICENSE_NUMBER_STAFF', None, -1),
    'STF_23': ('leaf', None, 'ID', 'COPY_AUTO_INS', 'HL70136', -1),
    'STF_24': ('leaf', None, 'DT', 'AUTO_INS_EXPIRES', None, -1),
    'STF_25': ('leaf', None, 'DT', 'DATE_LAST_DMV_REVIEW', None, -1),
    'STF_26': ('leaf', None, 'DT', 'DATE_NEXT_DMV_REVIEW', None, -1),
    'STF_27': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RACE', 'HL70005', -1),
    'STF_28': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ETHNIC_GROUP', 'HL70189', -1),
    'STF_29': ('leaf', None, 'ID', 'RE_ACTIVATION_APPROVAL_INDICATOR', 'HL70136', -1),
    'STF_30': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CITIZENSHIP', 'HL70171', -1),
    'STF_31': ('leaf', None, 'DTM', 'DATE_TIME_OF_DEATH', None, -1),
    'STF_32': ('leaf', None, 'ID', 'DEATH_INDICATOR', 'HL70136', -1),
    'STF_33': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INSTITUTION_RELATIONSHIP_TYPE_CODE', 'HL70538', -1),
    'STF_34': ('sequence', DATATYPES_STRUCTS['DR'], 'DR', 'INSTITUTION_RELATIONSHIP_PERIOD', None, -1),
    'STF_35': ('leaf', None, 'DT', 'EXPECTED_RETURN_DATE', None, -1),
    'STF_36': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'COST_CENTER_CODE', 'HL70539', -1),
    'STF_37': ('leaf', None, 'ID', 'GENERIC_CLASSIFICATION_INDICATOR', 'HL70136', -1),
    'STF_38': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'INACTIVE_REASON_CODE', 'HL70540', -1),
    'STF_39': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'GENERIC_RESOURCE_TYPE_OR_CATEGORY', 'HL70771', -1),
    'STF_40': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'RELIGION', 'HL70006', -1),
    'STF_41': ('sequence', DATATYPES_STRUCTS['ED'], 'ED', 'SIGNATURE', None, -1),
    'STZ_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STERILIZATION_TYPE', 'HL70806', -1),
    'STZ_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'STERILIZATION_CYCLE', 'HL70702', -1),
    'STZ_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MAINTENANCE_CYCLE', 'HL70809', -1),
    'STZ_4': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'MAINTENANCE_TYPE', 'HL70811', -1),
    'TCC_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNIVERSAL_SERVICE_IDENTIFIER', None, -1),
    'TCC_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'EQUIPMENT_TEST_APPLICATION_IDENTIFIER', None, -1),
    'TCC_3': ('leaf', None, 'WD', 'SPECIMEN_SOURCE', None, -1),
    'TCC_4': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'AUTO_DILUTION_FACTOR_DEFAULT', None, -1),
    'TCC_5': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'RERUN_DILUTION_FACTOR_DEFAULT', None, -1),
    'TCC_6': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'PRE_DILUTION_FACTOR_DEFAULT', None, -1),
    'TCC_7': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'ENDOGENOUS_CONTENT_OF_PRE_DILUTION_DILUENT', None, -1),
    'TCC_8': ('leaf', None, 'NM', 'INVENTORY_LIMITS_WARNING_LEVEL', None, -1),
    'TCC_9': ('leaf', None, 'ID', 'AUTOMATIC_RERUN_ALLOWED', 'HL70136', -1),
    'TCC_10': ('leaf', None, 'ID', 'AUTOMATIC_REPEAT_ALLOWED', 'HL70136', -1),
    'TCC_11': ('leaf', None, 'ID', 'AUTOMATIC_REFLEX_ALLOWED', 'HL70136', -1),
    'TCC_12': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'EQUIPMENT_DYNAMIC_RANGE', None, -1),
    'TCC_13': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNITS', 'HL79999', -1),
    'TCC_14': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PROCESSING_TYPE', 'HL70388', -1),
    'TCC_15': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'TEST_CRITICALITY', None, -1),
    'TCD_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'UNIVERSAL_SERVICE_IDENTIFIER', None, -1),
    'TCD_2': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'AUTO_DILUTION_FACTOR', None, -1),
    'TCD_3': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'RERUN_DILUTION_FACTOR', None, -1),
    'TCD_4': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'PRE_DILUTION_FACTOR', None, -1),
    'TCD_5': ('sequence', DATATYPES_STRUCTS['SN'], 'SN', 'ENDOGENOUS_CONTENT_OF_PRE_DILUTION_DILUENT', None, -1),
    'TCD_6': ('leaf', None, 'ID', 'AUTOMATIC_REPEAT_ALLOWED', 'HL70136', -1),
    'TCD_7': ('leaf', None, 'ID', 'REFLEX_ALLOWED', 'HL70136', -1),
    'TCD_8': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'ANALYTE_REPEAT_STATUS', 'HL70389', -1),
    'TQ1_1': ('sequence', None, 'SI', 'SET_ID_TQ1', None, -1),
    'TQ1_2': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY', None, -1),
    'TQ1_3': ('sequence', DATATYPES_STRUCTS['RPT'], 'RPT', 'REPEAT_PATTERN', None, -1),
    'TQ1_4': ('leaf', None, 'TM', 'EXPLICIT_TIME', None, -1),
    'TQ1_5': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'RELATIVE_TIME_AND_UNITS', None, -1),
    'TQ1_6': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'SERVICE_DURATION', None, -1),
    'TQ1_7': ('leaf', None, 'DTM', 'START_DATE_TIME', None, -1),
    'TQ1_8': ('leaf', None, 'DTM', 'END_DATE_TIME', None, -1),
    'TQ1_9': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'PRIORITY', 'HL70485', -1),
    'TQ1_10': ('leaf', None, 'TX', 'CONDITION_TEXT', None, -1),
    'TQ1_11': ('leaf', None, 'TX', 'TEXT_INSTRUCTION', None, -1),
    'TQ1_12': ('leaf', None, 'ID', 'CONJUNCTION', 'HL70472', -1),
    'TQ1_13': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'OCCURRENCE_DURATION', None, -1),
    'TQ1_14': ('leaf', None, 'NM', 'TOTAL_OCCURRENCES', None, -1),
    'TQ2_1': ('leaf', None, 'SI', 'SET_ID_TQ2', None, -1),
    'TQ2_2': ('leaf', None, 'ID', 'SEQUENCE_RESULTS_FLAG', 'HL70503', -1),
    'TQ2_3': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'RELATED_PLACER_NUMBER', None, -1),
    'TQ2_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'RELATED_FILLER_NUMBER', None, -1),
    'TQ2_5': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'RELATED_PLACER_GROUP_NUMBER', None, -1),
    'TQ2_6': ('leaf', None, 'ID', 'SEQUENCE_CONDITION_CODE', 'HL70504', -1),
    'TQ2_7': ('leaf', None, 'ID', 'CYCLIC_ENTRY_EXIT_INDICATOR', 'HL70505', -1),
    'TQ2_8': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'SEQUENCE_CONDITION_TIME_INTERVAL', None, -1),
    'TQ2_9': ('leaf', None, 'NM', 'CYCLIC_GROUP_MAXIMUM_NUMBER_OF_REPEATS', None, -1),
    'TQ2_10': ('leaf', None, 'ID', 'SPECIAL_SERVICE_REQUEST_RELATIONSHIP', 'HL70506', -1),
    'TXA_1': ('leaf', None, 'SI', 'SET_ID_TXA', None, -1),
    'TXA_2': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'DOCUMENT_TYPE', 'HL70270', -1),
    'TXA_3': ('leaf', None, 'ID', 'DOCUMENT_CONTENT_PRESENTATION', 'HL70191', -1),
    'TXA_4': ('leaf', None, 'DTM', 'ACTIVITY_DATE_TIME', None, -1),
    'TXA_5': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'PRIMARY_ACTIVITY_PROVIDER_CODE_NAME', None, -1),
    'TXA_6': ('leaf', None, 'DTM', 'ORIGINATION_DATE_TIME', None, -1),
    'TXA_7': ('leaf', None, 'DTM', 'TRANSCRIPTION_DATE_TIME', None, -1),
    'TXA_8': ('leaf', None, 'DTM', 'EDIT_DATE_TIME', None, -1),
    'TXA_9': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ORIGINATOR_CODE_NAME', None, -1),
    'TXA_10': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'ASSIGNED_DOCUMENT_AUTHENTICATOR', None, -1),
    'TXA_11': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'TRANSCRIPTIONIST_CODE_NAME', None, -1),
    'TXA_12': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'UNIQUE_DOCUMENT_NUMBER', None, -1),
    'TXA_13': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PARENT_DOCUMENT_NUMBER', None, -1),
    'TXA_14': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'PLACER_ORDER_NUMBER', None, -1),
    'TXA_15': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'FILLER_ORDER_NUMBER', None, -1),
    'TXA_16': ('leaf', None, 'ST', 'UNIQUE_DOCUMENT_FILE_NAME', None, -1),
    'TXA_17': ('leaf', None, 'ID', 'DOCUMENT_COMPLETION_STATUS', 'HL70271', -1),
    'TXA_18': ('leaf', None, 'ID', 'DOCUMENT_CONFIDENTIALITY_STATUS', 'HL70272', -1),
    'TXA_19': ('leaf', None, 'ID', 'DOCUMENT_AVAILABILITY_STATUS', 'HL70273', -1),
    'TXA_20': ('leaf', None, 'ID', 'DOCUMENT_STORAGE_STATUS', 'HL70275', -1),
    'TXA_21': ('leaf', None, 'ST', 'DOCUMENT_CHANGE_REASON', None, -1),
    'TXA_22': ('sequence', DATATYPES_STRUCTS['PPN'], 'PPN', 'AUTHENTICATION_PERSON_TIME_STAMP_SET', None, -1),
    'TXA_23': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'DISTRIBUTED_COPIES_CODE_AND_NAME_OF_RECIPIENT_S',
               None, -1),
    'TXA_24': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'FOLDER_ASSIGNMENT', None, -1),
    'TXA_25': ('leaf', None, 'ST', 'DOCUMENT_TITLE', None, -1),
    'TXA_26': ('leaf', None, 'DTM', 'AGREED_DUE_DATE_TIME', None, -1),
    'UAC_1': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'USER_AUTHENTICATION_CREDENTIAL_TYPE_CODE', 'HL70615', -1),
    'UAC_2': ('sequence', DATATYPES_STRUCTS['ED'], 'ED', 'USER_AUTHENTICATION_CREDENTIAL', None, -1),
    'UB1_1': ('leaf', None, 'SI', 'SET_ID_UB1', None, -1),
    'UB1_2': ('leaf', None, 'WD', 'BLOOD_DEDUCTIBLE', None, -1),
    'UB1_3': ('leaf', None, 'WD', 'BLOOD_FURNISHED_PINTS', None, -1),
    'UB1_4': ('leaf', None, 'WD', 'BLOOD_REPLACED_PINTS', None, -1),
    'UB1_5': ('leaf', None, 'WD', 'BLOOD_NOT_REPLACED_PINTS', None, -1),
    'UB1_6': ('leaf', None, 'WD', 'CO_INSURANCE_DAYS', None, -1),
    'UB1_7': ('leaf', None, 'WD', 'CONDITION_CODE', 'HL70043', -1),
    'UB1_8': ('leaf', None, 'WD', 'COVERED_DAYS', None, -1),
    'UB1_9': ('leaf', None, 'WD', 'NON_COVERED_DAYS', None, -1),
    'UB1_10': ('leaf', None, 'WD', 'VALUE_AMOUNT_CODE', None, -1),
    'UB1_11': ('leaf', None, 'WD', 'NUMBER_OF_GRACE_DAYS', None, -1),
    'UB1_12': ('leaf', None, 'WD', 'SPECIAL_PROGRAM_INDICATOR', 'HL70348', -1),
    'UB1_13': ('leaf', None, 'WD', 'PSRO_UR_APPROVAL_INDICATOR', 'HL70349', -1),
    'UB1_14': ('leaf', None, 'WD', 'PSRO_UR_APPROVED_STAY_FM', None, -1),
    'UB1_15': ('leaf', None, 'WD', 'PSRO_UR_APPROVED_STAY_TO', None, -1),
    'UB1_16': ('leaf', None, 'WD', 'OCCURRENCE', None, -1),
    'UB1_17': ('leaf', None, 'WD', 'OCCURRENCE_SPAN', 'HL70351', -1),
    'UB1_18': ('leaf', None, 'WD', 'OCCUR_SPAN_START_DATE', None, -1),
    'UB1_19': ('leaf', None, 'WD', 'OCCUR_SPAN_END_DATE', None, -1),
    'UB1_20': ('leaf', None, 'WD', 'UB_82_LOCATOR_2', None, -1),
    'UB1_21': ('leaf', None, 'WD', 'UB_82_LOCATOR_9', None, -1),
    'UB1_22': ('leaf', None, 'WD', 'UB_82_LOCATOR_27', None, -1),
    'UB1_23': ('leaf', None, 'WD', 'UB_82_LOCATOR_45', None, -1),
    'UB2_1': ('leaf', None, 'SI', 'SET_ID_UB2', None, -1),
    'UB2_2': ('leaf', None, 'ST', 'CO_INSURANCE_DAYS_9', None, -1),
    'UB2_3': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'CONDITION_CODE_24_30', 'HL70043', -1),
    'UB2_4': ('leaf', None, 'ST', 'COVERED_DAYS_7', None, -1),
    'UB2_5': ('leaf', None, 'ST', 'NON_COVERED_DAYS_8', None, -1),
    'UB2_6': ('sequence', DATATYPES_STRUCTS['UVC'], 'UVC', 'VALUE_AMOUNT_CODE_39_41', None, -1),
    'UB2_7': ('sequence', DATATYPES_STRUCTS['OCD'], 'OCD', 'OCCURRENCE_CODE_DATE_32_35', None, -1),
    'UB2_8': ('sequence', DATATYPES_STRUCTS['OSP'], 'OSP', 'OCCURRENCE_SPAN_CODE_DATES_36', None, -1),
    'UB2_9': ('leaf', None, 'ST', 'UNIFORM_BILLING_LOCATOR_2_STATE', None, -1),
    'UB2_10': ('leaf', None, 'ST', 'UNIFORM_BILLING_LOCATOR_11_STATE', None, -1),
    'UB2_11': ('leaf', None, 'ST', 'UNIFORM_BILLING_LOCATOR_31_NATIONAL', None, -1),
    'UB2_12': ('leaf', None, 'ST', 'DOCUMENT_CONTROL_NUMBER', None, -1),
    'UB2_13': ('leaf', None, 'ST', 'UNIFORM_BILLING_LOCATOR_49_NATIONAL', None, -1),
    'UB2_14': ('leaf', None, 'ST', 'UNIFORM_BILLING_LOCATOR_56_STATE', None, -1),
    'UB2_15': ('leaf', None, 'ST', 'UNIFORM_BILLING_LOCATOR_57_SATIONAL', None, -1),
    'UB2_16': ('leaf', None, 'ST', 'UNIFORM_BILLING_LOCATOR_78_STATE', None, -1),
    'UB2_17': ('leaf', None, 'NM', 'SPECIAL_VISIT_COUNT', None, -1),
    'VAR_1': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'VARIANCE_INSTANCE_ID', None, -1),
    'VAR_2': ('leaf', None, 'DTM', 'DOCUMENTED_DATE_TIME', None, -1),
    'VAR_3': ('leaf', None, 'DTM', 'STATED_VARIANCE_DATE_TIME', None, -1),
    'VAR_4': ('sequence', DATATYPES_STRUCTS['XCN'], 'XCN', 'VARIANCE_ORIGINATOR', None, -1),
    'VAR_5': ('sequence', DATATYPES_STRUCTS['CWE'], 'CWE', 'VARIANCE_CLASSIFICATION', None, -1),
    'VAR_6': ('leaf', None, 'ST', 'VARIANCE_DESCRIPTION', None, -1),
    'VND_1': ('leaf', None, 'SI', 'SET_ID_VND', None, -1),
    'VND_2': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'VENDOR_IDENTIFIER', None, -1),
    'VND_3': ('leaf', None, 'ST', 'VENDOR_NAME', None, -1),
    'VND_4': ('sequence', DATATYPES_STRUCTS['EI'], 'EI', 'VENDOR_CATALOG_NUMBER', None, -1),
    'VND_5': ('sequence', DATATYPES_STRUCTS['CNE'], 'CNE', 'PRIMARY_VENDOR_INDICATOR', 'HL70532', -1),
}
