from .groups import GROUPS
from .segments import SEGMENTS

MESSAGES = {
    'ACK': ('sequence',
            (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
             ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
             ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),)),
    'ADR_A19': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('ADR_A19_QUERY_RESPONSE', GROUPS['ADR_A19_QUERY_RESPONSE'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'ADT_A01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A01_INSURANCE', GROUPS['ADT_A01_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A04_INSURANCE', GROUPS['ADT_A04_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A05_INSURANCE', GROUPS['ADT_A05_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A06_INSURANCE', GROUPS['ADT_A06_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A07_INSURANCE', GROUPS['ADT_A07_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A08_INSURANCE', GROUPS['ADT_A08_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),)),
    'ADT_A10': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),)),
    'ADT_A11': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),)),
    'ADT_A12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),)),
    'ADT_A13': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A13_INSURANCE', GROUPS['ADT_A13_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A14': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A14_INSURANCE', GROUPS['ADT_A14_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A15': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),)),
    'ADT_A16': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),)),
    'ADT_A17': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A18': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),)),
    'ADT_A20': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('NPU', SEGMENTS['NPU'], (1, 1), 'SEG'),)),
    'ADT_A21': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A22': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A23': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A24': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),)),
    'ADT_A25': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A26': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A27': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A28': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A28_INSURANCE', GROUPS['ADT_A28_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A29': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A30': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (1, 1), 'SEG'),)),
    'ADT_A31': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('PR1', SEGMENTS['PR1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A31_INSURANCE', GROUPS['ADT_A31_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A32': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A33': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A34': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (1, 1), 'SEG'),)),
    'ADT_A35': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (1, 1), 'SEG'),)),
    'ADT_A36': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (1, 1), 'SEG'),)),
    'ADT_A37': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),)),
    'BAR_P01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('BAR_P01_VISIT', GROUPS['BAR_P01_VISIT'], (1, -1), 'GRP'),)),
    'BAR_P02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('BAR_P02_PATIENT', GROUPS['BAR_P02_PATIENT'], (1, -1), 'GRP'),)),
    'DFT_P03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('FT1', SEGMENTS['FT1'], (1, -1), 'SEG'),)),
    'DSR_P04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'DSR_Q01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'DSR_Q03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'DSR_R03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'MFD_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFA', SEGMENTS['MFA'], (0, -1), 'SEG'),)),
    'MFD_M02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFA', SEGMENTS['MFA'], (0, -1), 'SEG'),)),
    'MFD_M03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFA', SEGMENTS['MFA'], (0, -1), 'SEG'),)),
    'MFK_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFA', SEGMENTS['MFA'], (0, -1), 'SEG'),)),
    'MFK_M02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFA', SEGMENTS['MFA'], (0, -1), 'SEG'),)),
    'MFK_M03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFA', SEGMENTS['MFA'], (0, -1), 'SEG'),)),
    'MFN_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M01_MF', GROUPS['MFN_M01_MF'], (1, -1), 'GRP'),)),
    'MFN_M02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M02_MF_STAFF', GROUPS['MFN_M02_MF_STAFF'], (1, -1), 'GRP'),)),
    'MFN_M03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M03_MF_TEST', GROUPS['MFN_M03_MF_TEST'], (1, -1), 'GRP'),)),
    'MFQ_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'MFQ_M02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'MFQ_M03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'MFR_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFR_M01_MF', GROUPS['MFR_M01_MF'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'MFR_M02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFR_M02_MF_STAFF', GROUPS['MFR_M02_MF_STAFF'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'MFR_M03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFR_M03_MF_TEST', GROUPS['MFR_M03_MF_TEST'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'NMD_N01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 (
                 'NMD_N01_CLOCK_AND_STATS_WITH_NOTES', GROUPS['NMD_N01_CLOCK_AND_STATS_WITH_NOTES'], (1, -1), 'GRP'),)),
    'NMQ_N02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NMQ_N02_QRY_WITH_DETAIL', GROUPS['NMQ_N02_QRY_WITH_DETAIL'], (0, 1), 'GRP'),
                 ('NMQ_N02_CLOCK_AND_STATISTICS', GROUPS['NMQ_N02_CLOCK_AND_STATISTICS'], (1, -1), 'GRP'),)),
    'NMR_N02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (0, 1), 'SEG'),
                 ('NMR_N02_CLOCK_AND_STATS_WITH_NOTES_ALT', GROUPS['NMR_N02_CLOCK_AND_STATS_WITH_NOTES_ALT'], (1, -1),
                  'GRP'),)),
    'ORF_R04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ORF_R04_QUERY_RESPONSE', GROUPS['ORF_R04_QUERY_RESPONSE'], (1, -1), 'GRP'),
                 ('ORF_R04_ORDER', GROUPS['ORF_R04_ORDER'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'ORM_O01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORM_O01_PATIENT', GROUPS['ORM_O01_PATIENT'], (0, 1), 'GRP'),
                 ('ORM_O01_ORDER', GROUPS['ORM_O01_ORDER'], (1, -1), 'GRP'),)),
    'ORR_O02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORR_O02_PATIENT', GROUPS['ORR_O02_PATIENT'], (0, 1), 'GRP'),)),
    'ORU_R01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('ORU_R01_PATIENT_RESULT', GROUPS['ORU_R01_PATIENT_RESULT'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QRY_A19': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),)),
    'QRY_P04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QRY_Q01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QRY_Q02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QRY_R02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('QRD', SEGMENTS['QRD'], (1, 1), 'SEG'),
                 ('QRF', SEGMENTS['QRF'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'UDM_Q05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('URD', SEGMENTS['URD'], (1, 1), 'SEG'),
                 ('URS', SEGMENTS['URS'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (1, 1), 'SEG'),)),
}
