from .datatypes import DATATYPES_STRUCTS

FIELDS = {
    'ACC_1': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ACCIDENT_DATE_TIME', None, -1),
    'ACC_2': ('leaf', None, 'ID', 'ACCIDENT_CODE', 'HL70050', -1),
    'ACC_3': ('leaf', None, 'ST', 'ACCIDENT_LOCATION', None, -1),
    'ADD_1': ('leaf', None, 'ST', 'ADDENDUM_CONTINUATION_POINTER', None, -1),
    'AL1_1': ('leaf', None, 'SI', 'SET_ID_ALLERGY', None, -1),
    'AL1_2': ('leaf', None, 'ID', 'ALLERGY_TYPE', 'HL70127', -1),
    'AL1_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ALLERGY_CODE_MNEMONIC_DESCRIPTION', None, -1),
    'AL1_4': ('leaf', None, 'ID', 'ALLERGY_SEVERITY', 'HL70128', -1),
    'AL1_5': ('leaf', None, 'ST', 'ALLERGY_REACTION', None, -1),
    'AL1_6': ('leaf', None, 'DT', 'IDENTIFICATION_DATE', None, -1),
    'BHS_1': ('leaf', None, 'ST', 'BATCH_FIELD_SEPARATOR', None, -1),
    'BHS_2': ('leaf', None, 'ST', 'BATCH_ENCODING_CHARACTERS', None, -1),
    'BHS_3': ('leaf', None, 'ST', 'BATCH_SENDING_APPLICATION', None, -1),
    'BHS_4': ('leaf', None, 'ST', 'BATCH_SENDING_FACILITY', None, -1),
    'BHS_5': ('leaf', None, 'ST', 'BATCH_RECEIVING_APPLICATION', None, -1),
    'BHS_6': ('leaf', None, 'ST', 'BATCH_RECEIVING_FACILITY', None, -1),
    'BHS_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'BATCH_CREATION_DATE_TIME', None, -1),
    'BHS_8': ('leaf', None, 'ST', 'BATCH_SECURITY', None, -1),
    'BHS_9': ('leaf', None, 'ST', 'BATCH_NAME_ID_TYPE', None, -1),
    'BHS_10': ('leaf', None, 'ST', 'BATCH_COMMENT', None, -1),
    'BHS_11': ('leaf', None, 'ST', 'BATCH_CONTROL_ID', None, -1),
    'BHS_12': ('leaf', None, 'ST', 'REFERENCE_BATCH_CONTROL_ID', None, -1),
    'BLG_1': ('sequence', DATATYPES_STRUCTS['CM_CCD'], 'CM_CCD', 'WHEN_TO_CHARGE', 'HL70100', -1),
    'BLG_2': ('leaf', None, 'ID', 'CHARGE_TYPE', 'HL70122', -1),
    'BLG_3': ('sequence', DATATYPES_STRUCTS['CK_ACCOUNT_NO'], 'CK_ACCOUNT_NO', 'ACCOUNT_ID', None, -1),
    'BTS_1': ('leaf', None, 'ST', 'BATCH_MESSAGE_COUNT', None, -1),
    'BTS_2': ('leaf', None, 'ST', 'BATCH_COMMENT', None, -1),
    'BTS_3': ('sequence', DATATYPES_STRUCTS['CM_BATCH_TOTAL'], 'CM_BATCH_TOTAL', 'BATCH_TOTALS', None, -1),
    'DG1_1': ('leaf', None, 'SI', 'SET_ID_DIAGNOSIS', None, -1),
    'DG1_2': ('leaf', None, 'ID', 'DIAGNOSIS_CODING_METHOD', 'HL70053', -1),
    'DG1_3': ('leaf', None, 'ID', 'DIAGNOSIS_CODE', 'HL70051', -1),
    'DG1_4': ('leaf', None, 'ST', 'DIAGNOSIS_DESCRIPTION', None, -1),
    'DG1_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DIAGNOSIS_DATE_TIME', None, -1),
    'DG1_6': ('leaf', None, 'ID', 'DIAGNOSIS_DRG_TYPE', 'HL70052', -1),
    'DG1_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MAJOR_DIAGNOSTIC_CATEGORY', 'HL70118', -1),
    'DG1_8': ('leaf', None, 'ID', 'DIAGNOSTIC_RELATED_GROUP', 'HL70055', -1),
    'DG1_9': ('leaf', None, 'ID', 'DRG_APPROVAL_INDICATOR', None, -1),
    'DG1_10': ('leaf', None, 'ID', 'DRG_GROUPER_REVIEW_CODE', 'HL70056', -1),
    'DG1_11': ('leaf', None, 'ID', 'OUTLIER_TYPE', 'HL70083', -1),
    'DG1_12': ('leaf', None, 'NM', 'OUTLIER_DAYS', None, -1),
    'DG1_13': ('leaf', None, 'NM', 'OUTLIER_COST', None, -1),
    'DG1_14': ('leaf', None, 'ST', 'GROUPER_VERSION_AND_TYPE', None, -1),
    'DG1_15': ('leaf', None, 'NM', 'DIAGNOSIS_DRG_PRIORITY', None, -1),
    'DG1_16': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'DIAGNOSING_CLINICIAN', None, -1),
    'DSC_1': ('leaf', None, 'ST', 'CONTINUATION_POINTER', None, -1),
    'DSP_1': ('leaf', None, 'SI', 'SET_ID_DISPLAY_DATA', None, -1),
    'DSP_2': ('leaf', None, 'SI', 'DISPLAY_LEVEL', None, -1),
    'DSP_3': ('leaf', None, 'TX', 'DATA_LINE', None, -1),
    'DSP_4': ('leaf', None, 'ST', 'LOGICAL_BREAK_POINT', None, -1),
    'DSP_5': ('leaf', None, 'TX', 'RESULT_ID', None, -1),
    'ERR_1': ('sequence', DATATYPES_STRUCTS['CM_ELD'], 'CM_ELD', 'ERROR_CODE_AND_LOCATION', 'HL70060', -1),
    'EVN_1': ('leaf', None, 'ID', 'EVENT_TYPE_CODE', 'HL70003', -1),
    'EVN_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_EVENT', None, -1),
    'EVN_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_PLANNED_EVENT', None, -1),
    'EVN_4': ('leaf', None, 'ID', 'EVENT_REASON_CODE', 'HL70062', -1),
    'EVN_5': ('leaf', None, 'ID', 'OPERATOR_ID', 'HL70188', -1),
    'FHS_1': ('leaf', None, 'ST', 'FILE_FIELD_SEPARATOR', None, -1),
    'FHS_2': ('leaf', None, 'ST', 'FILE_ENCODING_CHARACTERS', None, -1),
    'FHS_3': ('leaf', None, 'ST', 'FILE_SENDING_APPLICATION', None, -1),
    'FHS_4': ('leaf', None, 'ST', 'FILE_SENDING_FACILITY', None, -1),
    'FHS_5': ('leaf', None, 'ST', 'FILE_RECEIVING_APPLICATION', None, -1),
    'FHS_6': ('leaf', None, 'ST', 'FILE_RECEIVING_FACILITY', None, -1),
    'FHS_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'FILE_CREATION_DATE_TIME', None, -1),
    'FHS_8': ('leaf', None, 'ST', 'FILE_SECURITY', None, -1),
    'FHS_9': ('leaf', None, 'ST', 'FILE_NAME_ID', None, -1),
    'FHS_10': ('leaf', None, 'ST', 'FILE_HEADER_COMMENT', None, -1),
    'FHS_11': ('leaf', None, 'ST', 'FILE_CONTROL_ID', None, -1),
    'FHS_12': ('leaf', None, 'ST', 'REFERENCE_FILE_CONTROL_ID', None, -1),
    'FT1_1': ('leaf', None, 'SI', 'SET_ID_FINANCIAL_TRANSACTION', None, -1),
    'FT1_2': ('leaf', None, 'ST', 'TRANSACTION_ID', None, -1),
    'FT1_3': ('leaf', None, 'ST', 'TRANSACTION_BATCH_ID', None, -1),
    'FT1_4': ('leaf', None, 'DT', 'TRANSACTION_DATE', None, -1),
    'FT1_5': ('leaf', None, 'DT', 'TRANSACTION_POSTING_DATE', None, -1),
    'FT1_6': ('leaf', None, 'ID', 'TRANSACTION_TYPE', 'HL70017', -1),
    'FT1_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TRANSACTION_CODE', 'HL70132', -1),
    'FT1_8': ('leaf', None, 'ST', 'TRANSACTION_DESCRIPTION', None, -1),
    'FT1_9': ('leaf', None, 'ST', 'TRANSACTION_DESCRIPTION_ALTERNATE', None, -1),
    'FT1_10': ('leaf', None, 'NM', 'TRANSACTION_QUANTITY', None, -1),
    'FT1_11': ('leaf', None, 'NM', 'TRANSACTION_AMOUNT_EXTENDED', None, -1),
    'FT1_12': ('leaf', None, 'NM', 'TRANSACTION_AMOUNT_UNIT', None, -1),
    'FT1_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DEPARTMENT_CODE', 'HL70049', -1),
    'FT1_14': ('leaf', None, 'ID', 'INSURANCE_PLAN_ID', 'HL70072', -1),
    'FT1_15': ('leaf', None, 'NM', 'INSURANCE_AMOUNT', None, -1),
    'FT1_16': ('sequence', DATATYPES_STRUCTS['CM_INTERNAL_LOCATION'], 'CM_INTERNAL_LOCATION',
               'ASSIGNED_PATIENT_LOCATION', 'HL70079', -1),
    'FT1_17': ('leaf', None, 'ID', 'FEE_SCHEDULE', 'HL70024', -1),
    'FT1_18': ('leaf', None, 'ID', 'PATIENT_TYPE', 'HL70018', -1),
    'FT1_19': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DIAGNOSIS_CODE', 'HL70051', -1),
    'FT1_20': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'PERFORMED_BY_CODE', 'HL70084', -1),
    'FT1_21': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ORDERED_BY_CODE', None, -1),
    'FT1_22': ('leaf', None, 'NM', 'UNIT_COST', None, -1),
    'FT1_23': ('sequence', DATATYPES_STRUCTS['CM_FILLER'], 'CM_FILLER', 'FILLER_ORDER_NUMBER', None, -1),
    'FTS_1': ('leaf', None, 'NM', 'FILE_BATCH_COUNT', None, -1),
    'FTS_2': ('leaf', None, 'ST', 'FILE_TRAILER_COMMENT', None, -1),
    'GT1_1': ('leaf', None, 'SI', 'SET_ID_GUARANTOR', None, -1),
    'GT1_2': ('sequence', DATATYPES_STRUCTS['CK'], 'CK', 'GUARANTOR_NUMBER', None, -1),
    'GT1_3': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'GUARANTOR_NAME', None, -1),
    'GT1_4': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'GUARANTOR_SPOUSE_NAME', None, -1),
    'GT1_5': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'GUARANTOR_ADDRESS', None, -1),
    'GT1_6': ('leaf', None, 'TN', 'GUARANTOR_PHONE_NUMBER_HOME', None, -1),
    'GT1_7': ('leaf', None, 'TN', 'GUARANTOR_PHONE_NUMBER_BUSINESS', None, -1),
    'GT1_8': ('leaf', None, 'DT', 'GUARANTOR_DATE_OF_BIRTH', None, -1),
    'GT1_9': ('leaf', None, 'ID', 'GUARANTOR_SEX', 'HL70001', -1),
    'GT1_10': ('leaf', None, 'ID', 'GUARANTOR_TYPE', 'HL70068', -1),
    'GT1_11': ('leaf', None, 'ID', 'GUARANTOR_RELATIONSHIP', 'HL70063', -1),
    'GT1_12': ('leaf', None, 'ST', 'GUARANTOR_SOCIAL_SECURITY_NUMBER', None, -1),
    'GT1_13': ('leaf', None, 'DT', 'GUARANTOR_DATE_BEGIN', None, -1),
    'GT1_14': ('leaf', None, 'DT', 'GUARANTOR_DATE_END', None, -1),
    'GT1_15': ('leaf', None, 'NM', 'GUARANTOR_PRIORITY', None, -1),
    'GT1_16': ('leaf', None, 'ST', 'GUARANTOR_EMPLOYER_NAME', None, -1),
    'GT1_17': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'GUARANTOR_EMPLOYER_ADDRESS', None, -1),
    'GT1_18': ('leaf', None, 'TN', 'GUARANTOR_EMPLOY_PHONE_NUMBER', None, -1),
    'GT1_19': ('leaf', None, 'ST', 'GUARANTOR_EMPLOYEE_ID_NUMBER', None, -1),
    'GT1_20': ('leaf', None, 'ID', 'GUARANTOR_EMPLOYMENT_STATUS', 'HL70066', -1),
    'GT1_21': ('leaf', None, 'ST', 'GUARANTOR_ORGANIZATION', None, -1),
    'IN1_1': ('leaf', None, 'SI', 'SET_ID_INSURANCE', None, -1),
    'IN1_2': ('leaf', None, 'ID', 'INSURANCE_PLAN_ID', 'HL70072', -1),
    'IN1_3': ('leaf', None, 'ST', 'INSURANCE_COMPANY_ID', None, -1),
    'IN1_4': ('leaf', None, 'ST', 'INSURANCE_COMPANY_NAME', None, -1),
    'IN1_5': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'INSURANCE_COMPANY_ADDRESS', None, -1),
    'IN1_6': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'INSURANCE_COMPANY_CONTACT_PERS', None, -1),
    'IN1_7': ('leaf', None, 'TN', 'INSURANCE_COMPANY_PHONE_NUMBER', None, -1),
    'IN1_8': ('leaf', None, 'ST', 'GROUP_NUMBER', None, -1),
    'IN1_9': ('leaf', None, 'ST', 'GROUP_NAME', None, -1),
    'IN1_10': ('leaf', None, 'ST', 'INSURED_S_GROUP_EMPLOYER_ID', None, -1),
    'IN1_11': ('leaf', None, 'ST', 'INSURED_S_GROUP_EMPLOYER_NAME', None, -1),
    'IN1_12': ('leaf', None, 'DT', 'PLAN_EFFECTIVE_DATE', None, -1),
    'IN1_13': ('leaf', None, 'DT', 'PLAN_EXPIRATION_DATE', None, -1),
    'IN1_14': ('sequence', DATATYPES_STRUCTS['CM_AUI'], 'CM_AUI', 'AUTHORIZATION_INFORMATION', None, -1),
    'IN1_15': ('leaf', None, 'ID', 'PLAN_TYPE', 'HL70086', -1),
    'IN1_16': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'NAME_OF_INSURED', None, -1),
    'IN1_17': ('leaf', None, 'ID', 'INSURED_S_RELATIONSHIP_TO_PATIENT', 'HL70063', -1),
    'IN1_18': ('leaf', None, 'DT', 'INSURED_S_DATE_OF_BIRTH', None, -1),
    'IN1_19': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'INSURED_S_ADDRESS', None, -1),
    'IN1_20': ('leaf', None, 'ID', 'ASSIGNMENT_OF_BENEFITS', 'HL70135', -1),
    'IN1_21': ('leaf', None, 'ID', 'COORDINATION_OF_BENEFITS', 'HL70173', -1),
    'IN1_22': ('leaf', None, 'ST', 'COORDINATION_OF_BENEFITS_PRIORITY', None, -1),
    'IN1_23': ('leaf', None, 'ID', 'NOTICE_OF_ADMISSION_CODE', 'HL70136', -1),
    'IN1_24': ('leaf', None, 'DT', 'NOTICE_OF_ADMISSION_DATE', None, -1),
    'IN1_25': ('leaf', None, 'ID', 'REPORT_OF_ELIGIBILITY_CODE', None, -1),
    'IN1_26': ('leaf', None, 'DT', 'REPORT_OF_ELIGIBILITY_DATE', None, -1),
    'IN1_27': ('leaf', None, 'ID', 'RELEASE_INFORMATION_CODE', 'HL70093', -1),
    'IN1_28': ('leaf', None, 'ST', 'PRE_ADMIT_CERTIFICATION_PAC', None, -1),
    'IN1_29': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'VERIFICATION_DATE_TIME', None, -1),
    'IN1_30': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'VERIFICATION_BY', None, -1),
    'IN1_31': ('leaf', None, 'ID', 'TYPE_OF_AGREEMENT_CODE', 'HL70098', -1),
    'IN1_32': ('leaf', None, 'ID', 'BILLING_STATUS', 'HL70022', -1),
    'IN1_33': ('leaf', None, 'NM', 'LIFETIME_RESERVE_DAYS', None, -1),
    'IN1_34': ('leaf', None, 'NM', 'DELAY_BEFORE_LIFETIME_RESERVE_DAYS', None, -1),
    'IN1_35': ('leaf', None, 'ID', 'COMPANY_PLAN_CODE', 'HL70042', -1),
    'IN1_36': ('leaf', None, 'ST', 'POLICY_NUMBER', None, -1),
    'IN1_37': ('leaf', None, 'NM', 'POLICY_DEDUCTIBLE', None, -1),
    'IN1_38': ('leaf', None, 'NM', 'POLICY_LIMIT_AMOUNT', None, -1),
    'IN1_39': ('leaf', None, 'NM', 'POLICY_LIMIT_DAYS', None, -1),
    'IN1_40': ('leaf', None, 'NM', 'ROOM_RATE_SEMI_PRIVATE', None, -1),
    'IN1_41': ('leaf', None, 'NM', 'ROOM_RATE_PRIVATE', None, -1),
    'IN1_42': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'INSURED_S_EMPLOYMENT_STATUS', 'HL70066', -1),
    'IN1_43': ('leaf', None, 'ID', 'INSURED_S_SEX', 'HL70001', -1),
    'IN1_44': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'INSURED_S_EMPLOYER_ADDRESS', None, -1),
    'IN1_45': ('leaf', None, 'ST', 'VERIFICATION_STATUS', None, -1),
    'IN1_46': ('leaf', None, 'ID', 'PRIOR_INSURANCE_PLAN_ID', 'HL70072', -1),
    'IN2_1': ('leaf', None, 'ST', 'INSURED_S_EMPLOYEE_ID', None, -1),
    'IN2_2': ('leaf', None, 'ST', 'INSURED_S_SOCIAL_SECURITY_NUMBER', None, -1),
    'IN2_3': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'INSURED_S_EMPLOYER_NAME', None, -1),
    'IN2_4': ('leaf', None, 'ID', 'EMPLOYER_INFORMATION_DATA', 'HL70139', -1),
    'IN2_5': ('leaf', None, 'ID', 'MAIL_CLAIM_PARTY', 'HL70137', -1),
    'IN2_6': ('leaf', None, 'NM', 'MEDICARE_HEALTH_INSURANCE_CARD_NUMBER', None, -1),
    'IN2_7': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'MEDICAID_CASE_NAME', None, -1),
    'IN2_8': ('leaf', None, 'NM', 'MEDICAID_CASE_NUMBER', None, -1),
    'IN2_9': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'CHAMPUS_SPONSOR_NAME', None, -1),
    'IN2_10': ('leaf', None, 'NM', 'CHAMPUS_ID_NUMBER', None, -1),
    'IN2_11': ('leaf', None, 'ID', 'DEPENDENT_OF_CHAMPUS_RECIPIENT', None, -1),
    'IN2_12': ('leaf', None, 'ST', 'CHAMPUS_ORGANIZATION', None, -1),
    'IN2_13': ('leaf', None, 'ST', 'CHAMPUS_STATION', None, -1),
    'IN2_14': ('leaf', None, 'ID', 'CHAMPUS_SERVICE', 'HL70140', -1),
    'IN2_15': ('leaf', None, 'ID', 'CHAMPUS_RANK_GRADE', 'HL70141', -1),
    'IN2_16': ('leaf', None, 'ID', 'CHAMPUS_STATUS', 'HL70142', -1),
    'IN2_17': ('leaf', None, 'DT', 'CHAMPUS_RETIRE_DATE', None, -1),
    'IN2_18': ('leaf', None, 'ID', 'CHAMPUS_NON_AVAILABILITY_CERTIFICATION_ON_FILE', 'HL70136', -1),
    'IN2_19': ('leaf', None, 'ID', 'BABY_COVERAGE', 'HL70136', -1),
    'IN2_20': ('leaf', None, 'ID', 'COMBINE_BABY_BILL', 'HL70136', -1),
    'IN2_21': ('leaf', None, 'NM', 'BLOOD_DEDUCTIBLE', None, -1),
    'IN2_22': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'SPECIAL_COVERAGE_APPROVAL_NAME', None, -1),
    'IN2_23': ('leaf', None, 'ST', 'SPECIAL_COVERAGE_APPROVAL_TITLE', None, -1),
    'IN2_24': ('leaf', None, 'ID', 'NON_COVERED_INSURANCE_CODE', 'HL70143', -1),
    'IN2_25': ('leaf', None, 'ST', 'PAYOR_ID', None, -1),
    'IN2_26': ('leaf', None, 'ST', 'PAYOR_SUBSCRIBER_ID', None, -1),
    'IN2_27': ('leaf', None, 'ID', 'ELIGIBILITY_SOURCE', 'HL70144', -1),
    'IN2_28': ('sequence', DATATYPES_STRUCTS['CM_RMC'], 'CM_RMC', 'ROOM_COVERAGE_TYPE_AMOUNT', 'HL70145', -1),
    'IN2_29': ('sequence', DATATYPES_STRUCTS['CM_PTA'], 'CM_PTA', 'POLICY_TYPE_AMOUNT', 'HL70147', -1),
    'IN2_30': ('sequence', DATATYPES_STRUCTS['CM_DDI'], 'CM_DDI', 'DAILY_DEDUCTIBLE', None, -1),
    'IN3_1': ('leaf', None, 'SI', 'SET_ID_INSURANCE_CERTIFICATION', None, -1),
    'IN3_2': ('leaf', None, 'ST', 'CERTIFICATION_NUMBER', None, -1),
    'IN3_3': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'CERTIFIED_BY', None, -1),
    'IN3_4': ('leaf', None, 'ID', 'CERTIFICATION_REQUIRED', 'HL70136', -1),
    'IN3_5': ('sequence', DATATYPES_STRUCTS['CM_PEN'], 'CM_PEN', 'PENALTY', 'HL70148', -1),
    'IN3_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'CERTIFICATION_DATE_TIME', None, -1),
    'IN3_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'CERTIFICATION_MODIFY_DATE_TIME', None, -1),
    'IN3_8': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'OPERATOR', None, -1),
    'IN3_9': ('leaf', None, 'DT', 'CERTIFICATION_BEGIN_DATE', None, -1),
    'IN3_10': ('leaf', None, 'DT', 'CERTIFICATION_END_DATE', None, -1),
    'IN3_11': ('sequence', DATATYPES_STRUCTS['CM_DTN'], 'CM_DTN', 'DAYS', 'HL70149', -1),
    'IN3_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'NON_CONCUR_CODE_DESCRIPTION', None, -1),
    'IN3_13': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'NON_CONCUR_EFFECTIVE_DATE_TIME', None, -1),
    'IN3_14': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'PHYSICIAN_REVIEWER', None, -1),
    'IN3_15': ('leaf', None, 'ST', 'CERTIFICATION_CONTACT', None, -1),
    'IN3_16': ('leaf', None, 'TN', 'CERTIFICATION_CONTACT_PHONE_NUMBER', None, -1),
    'IN3_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'APPEAL_REASON', None, -1),
    'IN3_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CERTIFICATION_AGENCY', None, -1),
    'IN3_19': ('leaf', None, 'TN', 'CERTIFICATION_AGENCY_PHONE_NUMBER', None, -1),
    'IN3_20': ('sequence', DATATYPES_STRUCTS['CM_PCF'], 'CM_PCF', 'PRE_CERTIFICATION_REQUIRED_WINDOW', 'HL70150', -1),
    'IN3_21': ('leaf', None, 'ST', 'CASE_MANAGER', None, -1),
    'IN3_22': ('leaf', None, 'DT', 'SECOND_OPINION_DATE', None, -1),
    'IN3_23': ('leaf', None, 'ID', 'SECOND_OPINION_STATUS', 'HL70151', -1),
    'IN3_24': ('leaf', None, 'ID', 'SECOND_OPINION_DOCUMENTATION_RECEIVED', 'HL70152', -1),
    'IN3_25': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'SECOND_OPINION_PRACTITIONER', None, -1),
    'MFA_1': ('leaf', None, 'ID', 'RECORD_LEVEL_EVENT_CODE', 'HL70180', -1),
    'MFA_2': ('leaf', None, 'ST', 'MFN_CONTROL_ID', None, -1),
    'MFA_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EVENT_COMPLETION_DATE_TIME', None, -1),
    'MFA_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ERROR_RETURN_CODE_AND_OR_TEXT', 'HL70181', -1),
    'MFA_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_KEY_VALUE', None, -1),
    'MFE_1': ('leaf', None, 'ID', 'RECORD_LEVEL_EVENT_CODE', 'HL70180', -1),
    'MFE_2': ('leaf', None, 'ST', 'MFN_CONTROL_ID', None, -1),
    'MFE_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_DATE_TIME', None, -1),
    'MFE_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRIMARY_KEY_VALUE', None, -1),
    'MFI_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MASTER_FILE_IDENTIFIER', 'HL70175', -1),
    'MFI_2': ('leaf', None, 'ID', 'MASTER_FILE_APPLICATION_IDENTIFIER', 'HL70176', -1),
    'MFI_3': ('leaf', None, 'ID', 'FILE_LEVEL_EVENT_CODE', 'HL70178', -1),
    'MFI_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ENTERED_DATE_TIME', None, -1),
    'MFI_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_DATE_TIME', None, -1),
    'MFI_6': ('leaf', None, 'ID', 'RESPONSE_LEVEL_CODE', 'HL70179', -1),
    'MRG_1': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID'], 'CM_PAT_ID', 'PRIOR_PATIENT_ID_INTERNAL', None, -1),
    'MRG_2': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID'], 'CM_PAT_ID', 'PRIOR_ALTERNATE_PATIENT_ID', None, -1),
    'MRG_3': ('sequence', DATATYPES_STRUCTS['CK_ACCOUNT_NO'], 'CK_ACCOUNT_NO',
              'PRIOR_PATIENT_ACCOUNT_NUMBER', None, -1),
    'MRG_4': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID'], 'CM_PAT_ID', 'PRIOR_PATIENT_ID_EXTERNAL', None, -1),
    'MSA_1': ('leaf', None, 'ID', 'ACKNOWLEDGEMENT_CODE', 'HL70008', -1),
    'MSA_2': ('leaf', None, 'ST', 'MESSAGE_CONTROL_ID', None, -1),
    'MSA_3': ('leaf', None, 'ST', 'TEXT_MESSAGE', None, -1),
    'MSA_4': ('leaf', None, 'NM', 'EXPECTED_SEQUENCE_NUMBER', None, -1),
    'MSA_5': ('leaf', None, 'ID', 'DELAYED_ACKNOWLEDGEMENT_TYPE', 'HL70102', -1),
    'MSA_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ERROR_CONDITION', None, -1),
    'MSH_1': ('leaf', None, 'ST', 'FIELD_SEPARATOR', None, -1),
    'MSH_2': ('leaf', None, 'ST', 'ENCODING_CHARACTERS', None, -1),
    'MSH_3': ('leaf', None, 'ST', 'SENDING_APPLICATION', None, -1),
    'MSH_4': ('leaf', None, 'ST', 'SENDING_FACILITY', None, -1),
    'MSH_5': ('leaf', None, 'ST', 'RECEIVING_APPLICATION', None, -1),
    'MSH_6': ('leaf', None, 'ST', 'RECEIVING_FACILITY', None, -1),
    'MSH_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_MESSAGE', None, -1),
    'MSH_8': ('leaf', None, 'ST', 'SECURITY', None, -1),
    'MSH_9': ('sequence', DATATYPES_STRUCTS['CM_MSG'], 'CM_MSG', 'MESSAGE_TYPE', 'HL70076', -1),
    'MSH_10': ('leaf', None, 'ST', 'MESSAGE_CONTROL_ID', None, -1),
    'MSH_11': ('leaf', None, 'ID', 'PROCESSING_ID', 'HL70103', -1),
    'MSH_12': ('leaf', None, 'ID', 'VERSION_ID', 'HL70104', -1),
    'MSH_13': ('leaf', None, 'NM', 'SEQUENCE_NUMBER', None, -1),
    'MSH_14': ('leaf', None, 'ST', 'CONTINUATION_POINTER', None, -1),
    'MSH_15': ('leaf', None, 'ID', 'ACCEPT_ACKNOWLEDGEMENT_TYPE', 'HL70155', -1),
    'MSH_16': ('leaf', None, 'ID', 'APPLICATION_ACKNOWLEDGEMENT_TYPE', 'HL70155', -1),
    'MSH_17': ('leaf', None, 'ID', 'COUNTRY_CODE', None, -1),
    'NCK_1': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SYSTEM_DATE_TIME', None, -1),
    'NK1_1': ('leaf', None, 'SI', 'SET_ID_NEXT_OF_KIN', None, -1),
    'NK1_2': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'NAME', None, -1),
    'NK1_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'RELATIONSHIP', 'HL70063', -1),
    'NK1_4': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'ADDRESS', None, -1),
    'NK1_5': ('leaf', None, 'TN', 'PHONE_NUMBER', None, -1),
    'NK1_6': ('leaf', None, 'TN', 'BUSINESS_PHONE_NUMBER', None, -1),
    'NK1_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTACT_ROLE', 'HL70131', -1),
    'NK1_8': ('leaf', None, 'DT', 'START_DATE', None, -1),
    'NK1_9': ('leaf', None, 'DT', 'END_DATE', None, -1),
    'NK1_10': ('leaf', None, 'ST', 'NEXT_OF_KIN', None, -1),
    'NK1_11': ('sequence', DATATYPES_STRUCTS['CM_JOB_CODE'], 'CM_JOB_CODE', 'NEXT_OF_KIN_JOB_CODE_CLASS', None, -1),
    'NK1_12': ('leaf', None, 'ST', 'NEXT_OF_KIN_EMPLOYEE_NUMBER', None, -1),
    'NK1_13': ('leaf', None, 'ST', 'ORGANIZATION_NAME', None, -1),
    'NPU_1': ('sequence', DATATYPES_STRUCTS['CM_INTERNAL_LOCATION'], 'CM_INTERNAL_LOCATION',
              'BED_LOCATION', 'HL70079', -1),
    'NPU_2': ('leaf', None, 'ID', 'BED_STATUS', 'HL70116', -1),
    'NSC_1': ('leaf', None, 'ID', 'NETWORK_CHANGE_TYPE', None, -1),
    'NSC_2': ('leaf', None, 'ST', 'CURRENT_CPU', None, -1),
    'NSC_3': ('leaf', None, 'ST', 'CURRENT_FILESERVER', None, -1),
    'NSC_4': ('leaf', None, 'ST', 'CURRENT_APPLICATION', None, -1),
    'NSC_5': ('leaf', None, 'ST', 'CURRENT_FACILITY', None, -1),
    'NSC_6': ('leaf', None, 'ST', 'NEW_CPU', None, -1),
    'NSC_7': ('leaf', None, 'ST', 'NEW_FILESERVER', None, -1),
    'NSC_8': ('leaf', None, 'ST', 'NEW_APPLICATION', None, -1),
    'NSC_9': ('leaf', None, 'ST', 'NEW_FACILITY', None, -1),
    'NST_1': ('leaf', None, 'ID', 'STATISTICS_AVAILABLE', 'HL70136', -1),
    'NST_2': ('leaf', None, 'ST', 'SOURCE_IDENTIFIER', None, -1),
    'NST_3': ('leaf', None, 'ID', 'SOURCE_TYPE', None, -1),
    'NST_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'STATISTICS_START', None, -1),
    'NST_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'STATISTICS_END', None, -1),
    'NST_6': ('leaf', None, 'NM', 'RECEIVE_CHARACTER_COUNT', None, -1),
    'NST_7': ('leaf', None, 'NM', 'SEND_CHARACTER_COUNT', None, -1),
    'NST_8': ('leaf', None, 'NM', 'MESSAGE_RECEIVED', None, -1),
    'NST_9': ('leaf', None, 'NM', 'MESSAGE_SENT', None, -1),
    'NST_10': ('leaf', None, 'NM', 'CHECKSUM_ERRORS_RECEIVED', None, -1),
    'NST_11': ('leaf', None, 'NM', 'LENGTH_ERRORS_RECEIVED', None, -1),
    'NST_12': ('leaf', None, 'NM', 'OTHER_ERRORS_RECEIVED', None, -1),
    'NST_13': ('leaf', None, 'NM', 'CONNECT_TIMEOUTS', None, -1),
    'NST_14': ('leaf', None, 'NM', 'RECEIVE_TIMEOUTS', None, -1),
    'NST_15': ('leaf', None, 'NM', 'NETWORK_ERRORS', None, -1),
    'NTE_1': ('leaf', None, 'SI', 'SET_ID_NOTES_AND_COMMENTS', None, -1),
    'NTE_2': ('leaf', None, 'ID', 'SOURCE_OF_COMMENT', 'HL70105', -1),
    'NTE_3': ('leaf', None, 'FT', 'COMMENT', None, -1),
    'OBR_1': ('leaf', None, 'SI', 'SET_ID_OBSERVATION_REQUEST', None, -1),
    'OBR_2': ('sequence', DATATYPES_STRUCTS['CM_PLACER'], 'CM_PLACER', 'PLACER_ORDER_NUMBER', None, -1),
    'OBR_3': ('sequence', DATATYPES_STRUCTS['CM_FILLER'], 'CM_FILLER', 'FILLER_ORDER_NUMBER', None, -1),
    'OBR_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'UNIVERSAL_SERVICE_ID', None, -1),
    'OBR_5': ('leaf', None, 'ID', 'PRIORITY_NOT_USED', None, -1),
    'OBR_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'REQUESTED_DATE_TIME_NOT_USED', None, -1),
    'OBR_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'OBSERVATION_DATE_TIME', None, -1),
    'OBR_8': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'OBSERVATION_END_DATE_TIME', None, -1),
    'OBR_9': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'COLLECTION_VOLUME', None, -1),
    'OBR_10': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'COLLECTOR_IDENTIFIER', None, -1),
    'OBR_11': ('leaf', None, 'ID', 'SPECIMEN_ACTION_CODE', 'HL70065', -1),
    'OBR_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DANGER_CODE', None, -1),
    'OBR_13': ('leaf', None, 'ST', 'RELEVANT_CLINICAL_INFORMATION', None, -1),
    'OBR_14': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SPECIMEN_RECEIVED_DATE_TIME', None, -1),
    'OBR_15': ('sequence', DATATYPES_STRUCTS['CM_SPS'], 'CM_SPS', 'SPECIMEN_SOURCE', 'HL70070', -1),
    'OBR_16': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ORDERING_PROVIDER', None, -1),
    'OBR_17': ('leaf', None, 'TN', 'ORDER_CALLBACK_PHONE_NUMBER', None, -1),
    'OBR_18': ('leaf', None, 'ST', 'PLACER_FIELD_1', None, -1),
    'OBR_19': ('leaf', None, 'ST', 'PLACER_FIELD_2', None, -1),
    'OBR_20': ('leaf', None, 'ST', 'FILLER_FIELD_1', None, -1),
    'OBR_21': ('leaf', None, 'ST', 'FILLER_FIELD_2', None, -1),
    'OBR_22': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'RESULTS_REPORT_STATUS_CHANGE_DATE_TIME', None, -1),
    'OBR_23': ('sequence', DATATYPES_STRUCTS['CM_MOC'], 'CM_MOC', 'CHARGE_TO_PRACTICE', None, -1),
    'OBR_24': ('leaf', None, 'ID', 'DIAGNOSTIC_SERVICE_SECTION_ID', 'HL70074', -1),
    'OBR_25': ('leaf', None, 'ID', 'RESULT_STATUS', 'HL70123', -1),
    'OBR_26': ('sequence', DATATYPES_STRUCTS['CM_PARENT_RESULT'], 'CM_PARENT_RESULT', 'PARENT_RESULT', None, -1),
    'OBR_27': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'QUANTITY_TIMING', None, -1),
    'OBR_28': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'RESULT_COPIES_TO', None, -1),
    'OBR_29': ('sequence', DATATYPES_STRUCTS['CM_EIP'], 'CM_EIP', 'PARENT_NUMBER', None, -1),
    'OBR_30': ('leaf', None, 'ID', 'TRANSPORTATION_MODE', 'HL70124', -1),
    'OBR_31': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REASON_FOR_STUDY', None, -1),
    'OBR_32': ('sequence', DATATYPES_STRUCTS['CM_NDL'], 'CM_NDL', 'PRINCIPAL_RESULT_INTERPRETER', None, -1),
    'OBR_33': ('sequence', DATATYPES_STRUCTS['CM_NDL'], 'CM_NDL', 'ASSISTANT_RESULT_INTERPRETER', None, -1),
    'OBR_34': ('sequence', DATATYPES_STRUCTS['CM_NDL'], 'CM_NDL', 'TECHNICIAN', None, -1),
    'OBR_35': ('sequence', DATATYPES_STRUCTS['CM_NDL'], 'CM_NDL', 'TRANSCRIPTIONIST', None, -1),
    'OBR_36': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'SCHEDULED_DATE_TIME', None, -1),
    'OBX_1': ('leaf', None, 'SI', 'SET_ID_OBSERVATIONAL_SIMPLE', None, -1),
    'OBX_2': ('leaf', None, 'ID', 'VALUE_TYPE', 'HL70125', -1),
    'OBX_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OBSERVATION_IDENTIFIER', None, -1),
    'OBX_4': ('leaf', None, 'ST', 'OBSERVATION_SUB_ID', None, -1),
    'OBX_5': ('sequence', None, 'varies', 'OBSERVATION_VALUE', None, -1),
    'OBX_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'UNITS', None, -1),
    'OBX_7': ('leaf', None, 'ST', 'REFERENCES_RANGE', None, -1),
    'OBX_8': ('leaf', None, 'ID', 'ABNORMAL_FLAGS', 'HL70078', -1),
    'OBX_9': ('leaf', None, 'NM', 'PROBABILITY', None, -1),
    'OBX_10': ('leaf', None, 'ID', 'NATURE_OF_ABNORMAL_TEST', 'HL70080', -1),
    'OBX_11': ('leaf', None, 'ID', 'OBSERVATION_RESULT_STATUS', 'HL70085', -1),
    'OBX_12': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_DATE_LAST_OBSERVATION_NORMAL_VALUES', None, -1),
    'OBX_13': ('leaf', None, 'ST', 'USER_DEFINED_ACCESS_CHECKS', None, -1),
    'OBX_14': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_THE_OBSERVATION', None, -1),
    'OBX_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCER_S_ID', None, -1),
    'OBX_16': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'RESPONSIBLE_OBSERVER', None, -1),
    'ODS_1': ('leaf', None, 'ID', 'TYPE', 'HL70159', -1),
    'ODS_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SERVICE_PERIOD', None, -1),
    'ODS_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DIET_SUPPLEMENT_OR_PREFERENCE_CODE', None, -1),
    'ODS_4': ('leaf', None, 'ST', 'TEXT_INSTRUCTION', None, -1),
    'ODT_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TRAY_TYPE', 'HL70160', -1),
    'ODT_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SERVICE_PERIOD', None, -1),
    'ODT_3': ('leaf', None, 'ST', 'TEXT_INSTRUCTION', None, -1),
    'OM1_1': ('leaf', None, 'ST', 'SEGMENT_TYPE_ID', None, -1),
    'OM1_2': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM1_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCER_S_TEST_OBSERVATION_ID', None, -1),
    'OM1_4': ('leaf', None, 'ID', 'PERMITTED_DATA_TYPES', 'HL70125', -1),
    'OM1_5': ('leaf', None, 'ID', 'SPECIMEN_REQUIRED', 'HL70136', -1),
    'OM1_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRODUCER_ID', None, -1),
    'OM1_7': ('leaf', None, 'TX', 'OBSERVATION_DESCRIPTION', None, -1),
    'OM1_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'OTHER_TEST_OBSERVATION_IDS_FOR_THE_OBSERVATION', None, -1),
    'OM1_9': ('leaf', None, 'ST', 'OTHER_NAMES', None, -1),
    'OM1_10': ('leaf', None, 'ST', 'PREFERRED_REPORT_NAME_FOR_THE_OBSERVATION', None, -1),
    'OM1_11': ('leaf', None, 'ST', 'PREFERRED_SHORT_NAME_OR_MNEMONIC_FOR_OBSERVATION', None, -1),
    'OM1_12': ('leaf', None, 'ST', 'PREFERRED_LONG_NAME_FOR_THE_OBSERVATION', None, -1),
    'OM1_13': ('leaf', None, 'ID', 'ORDERABILITY', 'HL70136', -1),
    'OM1_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE',
               'IDENTITY_OF_INSTRUMENT_USED_TO_PERFORM_THIS_STUDY', None, -1),
    'OM1_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CODED_REPRESENTATION_OF_METHOD', None, -1),
    'OM1_16': ('leaf', None, 'ID', 'PORTABLE', 'HL70136', -1),
    'OM1_17': ('leaf', None, 'ID', 'OBSERVATION_PRODUCING_DEPARTMENT_SECTION', None, -1),
    'OM1_18': ('leaf', None, 'TN', 'TELEPHONE_NUMBER_OF_SECTION', None, -1),
    'OM1_19': ('leaf', None, 'ID', 'NATURE_OF_TEST_OBSERVATION', 'HL70174', -1),
    'OM1_20': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REPORT_SUBHEADER', None, -1),
    'OM1_21': ('leaf', None, 'ST', 'REPORT_DISPLAY_ORDER', None, -1),
    'OM1_22': ('sequence', DATATYPES_STRUCTS['TS'], 'TS',
               'DATE_TIME_STAMP_FOR_ANY_CHANGE_IN_DEFINITION_FOR_OBS', None, -1),
    'OM1_23': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'EFFECTIVE_DATE_TIME_OF_CHANGE', None, -1),
    'OM1_24': ('leaf', None, 'NM', 'TYPICAL_TURN_AROUND_TIME', None, -1),
    'OM1_25': ('leaf', None, 'NM', 'PROCESSING_TIME', None, -1),
    'OM1_26': ('leaf', None, 'ID', 'PROCESSING_PRIORITY', 'HL70168', -1),
    'OM1_27': ('leaf', None, 'ID', 'REPORTING_PRIORITY', 'HL70169', -1),
    'OM1_28': ('sequence', DATATYPES_STRUCTS['CE'], 'CE',
               'OUTSIDE_SITE_S_WHERE_OBSERVATION_MAY_BE_PERFORMED', None, -1),
    'OM1_29': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'ADDRESS_OF_OUTSIDE_SITE_S', None, -1),
    'OM1_30': ('leaf', None, 'TN', 'PHONE_NUMBER_OF_OUTSIDE_SITE', None, -1),
    'OM1_31': ('leaf', None, 'ID', 'CONFIDENTIALITY_CODE', 'HL70177', -1),
    'OM1_32': ('sequence', DATATYPES_STRUCTS['CE'], 'CE',
               'OBSERVATIONS_REQUIRED_TO_INTERPRET_THE_OBSERVATION', None, -1),
    'OM1_33': ('leaf', None, 'TX', 'INTERPRETATION_OF_OBSERVATIONS', None, -1),
    'OM1_34': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTRAINDICATIONS_TO_OBSERVATIONS', None, -1),
    'OM1_35': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REFLEX_TESTS_OBSERVATIONS', None, -1),
    'OM1_36': ('leaf', None, 'ST', 'RULES_THAT_TRIGGER_REFLEX_TESTING', None, -1),
    'OM1_37': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'FIXED_CANNED_MESSAGE', None, -1),
    'OM1_38': ('leaf', None, 'TX', 'PATIENT_PREPARATION', None, -1),
    'OM1_39': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROCEDURE_MEDICATION', None, -1),
    'OM1_40': ('leaf', None, 'TX', 'FACTORS_THAT_MAY_AFFECT_THE_OBSERVATION', None, -1),
    'OM1_41': ('leaf', None, 'ST', 'TEST_OBSERVATION_PERFORMANCE_SCHEDULE', None, -1),
    'OM1_42': ('leaf', None, 'TX', 'DESCRIPTION_OF_TEST_METHODS', None, -1),
    'OM2_1': ('leaf', None, 'ST', 'SEGMENT_TYPE_ID', None, -1),
    'OM2_2': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM2_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'UNITS_OF_MEASURE', None, -1),
    'OM2_4': ('leaf', None, 'NM', 'RANGE_OF_DECIMAL_PRECISION', None, -1),
    'OM2_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CORRESPONDING_SI_UNITS_OF_MEASURE', None, -1),
    'OM2_6': ('leaf', None, 'TX', 'SI_CONVERSION_FACTOR', None, -1),
    'OM2_7': ('sequence', DATATYPES_STRUCTS['CM_RFR'], 'CM_RFR',
              'REFERENCE_NORMAL_RANGE_ORDINAL_CONTINUOUS_OBSERVATIONS', None, -1),
    'OM2_8': ('sequence', DATATYPES_STRUCTS['CM_RANGE'], 'CM_RANGE',
              'CRITICAL_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS', None, -1),
    'OM2_9': ('sequence', DATATYPES_STRUCTS['CM_ABS_RANGE'], 'CM_ABS_RANGE',
              'ABSOLUTE_RANGE_FOR_ORDINAL_AND_CONTINUOUS_OBSERVATIONS', None, -1),
    'OM2_10': ('sequence', DATATYPES_STRUCTS['CM_DLT'], 'CM_DLT', 'DELTA_CHECK_CRITERIA', None, -1),
    'OM2_11': ('leaf', None, 'NM', 'MINIMUM_MEANINGFUL_INCREMENTS', None, -1),
    'OM3_1': ('leaf', None, 'ST', 'SEGMENT_TYPE_ID', None, -1),
    'OM3_2': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM3_3': ('leaf', None, 'ID', 'PREFERRED_CODING_SYSTEM', None, -1),
    'OM3_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'VALID_CODED_ANSWERS', None, -1),
    'OM3_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'NORMAL_TEST_CODES_FOR_CATEGORICAL_OBSERVATIONS', None, -1),
    'OM3_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ABNORMAL_TEST_CODES_FOR_CATEGORICAL_OBSERVATIONS', None, -1),
    'OM3_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CRITICAL_TEST_CODES_FOR_CATEGORICAL_OBSERVATIONS', None, -1),
    'OM3_8': ('leaf', None, 'ID', 'DATA_TYPE', None, -1),
    'OM4_1': ('leaf', None, 'ST', 'SEGMENT_TYPE_ID', None, -1),
    'OM4_2': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM4_3': ('leaf', None, 'ID', 'DERIVED_SPECIMEN', 'HL70170', -1),
    'OM4_4': ('leaf', None, 'TX', 'CONTAINER_DESCRIPTION', None, -1),
    'OM4_5': ('leaf', None, 'NM', 'CONTAINER_VOLUME', None, -1),
    'OM4_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'CONTAINER_UNITS', None, -1),
    'OM4_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SPECIMEN', None, -1),
    'OM4_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADDITIVE', None, -1),
    'OM4_9': ('leaf', None, 'TX', 'PREPARATION', None, -1),
    'OM4_10': ('leaf', None, 'TX', 'SPECIAL_HANDLING_REQUIREMENTS', None, -1),
    'OM4_11': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'NORMAL_COLLECTION_VOLUME', None, -1),
    'OM4_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'MINIMUM_COLLECTION_VOLUME', None, -1),
    'OM4_13': ('leaf', None, 'TX', 'SPECIMEN_REQUIREMENTS', None, -1),
    'OM4_14': ('leaf', None, 'ID', 'SPECIMEN_PRIORITIES', 'HL70027', -1),
    'OM4_15': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'SPECIMEN_RETENTION_TIME', None, -1),
    'OM5_1': ('leaf', None, 'ST', 'SEGMENT_TYPE_ID', None, -1),
    'OM5_2': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM5_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE',
              'TESTS_OBSERVATIONS_INCLUDED_WITHIN_AN_ORDERED_TEST_BATTERY', None, -1),
    'OM5_4': ('leaf', None, 'ST', 'OBSERVATION_ID_SUFFIXES', None, -1),
    'OM6_1': ('leaf', None, 'ST', 'SEGMENT_TYPE_ID', None, -1),
    'OM6_2': ('leaf', None, 'NM', 'SEQUENCE_NUMBER_TEST_OBSERVATION_MASTER_FILE', None, -1),
    'OM6_3': ('leaf', None, 'TX', 'DERIVATION_RULE', None, -1),
    'ORC_1': ('leaf', None, 'ID', 'ORDER_CONTROL', 'HL70119', -1),
    'ORC_2': ('sequence', DATATYPES_STRUCTS['CM_PLACER'], 'CM_PLACER', 'PLACER_ORDER_NUMBER', None, -1),
    'ORC_3': ('sequence', DATATYPES_STRUCTS['CM_FILLER'], 'CM_FILLER', 'FILLER_ORDER_NUMBER', None, -1),
    'ORC_4': ('sequence', DATATYPES_STRUCTS['CM_GROUP_ID'], 'CM_GROUP_ID', 'PLACER_GROUP_NUMBER', None, -1),
    'ORC_5': ('leaf', None, 'ID', 'ORDER_STATUS', 'HL70038', -1),
    'ORC_6': ('leaf', None, 'ID', 'RESPONSE_FLAG', 'HL70121', -1),
    'ORC_7': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'QUANTITY_TIMING', None, -1),
    'ORC_8': ('sequence', DATATYPES_STRUCTS['CM_EIP'], 'CM_EIP', 'PARENT', None, -1),
    'ORC_9': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_OF_TRANSACTION', None, -1),
    'ORC_10': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ENTERED_BY', None, -1),
    'ORC_11': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'VERIFIED_BY', None, -1),
    'ORC_12': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ORDERING_PROVIDER', None, -1),
    'ORC_13': ('sequence', DATATYPES_STRUCTS['CM_PARENT_RESULT'], 'CM_PARENT_RESULT', 'ENTERER_S_LOCATION', None, -1),
    'ORC_14': ('leaf', None, 'TN', 'CALL_BACK_PHONE_NUMBER', None, -1),
    'ORC_15': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ORDER_EFFECTIVE_DATE_TIME', None, -1),
    'ORC_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ORDER_CONTROL_CODE_REASON', None, -1),
    'ORC_17': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ENTERING_ORGANIZATION', None, -1),
    'ORC_18': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ENTERING_DEVICE', None, -1),
    'ORC_19': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ACTION_BY', None, -1),
    'PID_1': ('leaf', None, 'SI', 'SET_ID_PATIENT_ID', None, -1),
    'PID_2': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID'], 'CM_PAT_ID', 'PATIENT_ID_EXTERNAL_ID', None, -1),
    'PID_3': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID'], 'CM_PAT_ID', 'PATIENT_ID_INTERNAL_ID', None, -1),
    'PID_4': ('leaf', None, 'ST', 'ALTERNATE_PATIENT_ID', None, -1),
    'PID_5': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'PATIENT_NAME', None, -1),
    'PID_6': ('leaf', None, 'ST', 'MOTHER_S_MAIDEN_NAME', None, -1),
    'PID_7': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_OF_BIRTH', None, -1),
    'PID_8': ('leaf', None, 'ID', 'SEX', 'HL70001', -1),
    'PID_9': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'PATIENT_ALIAS', None, -1),
    'PID_10': ('leaf', None, 'ID', 'RACE', 'HL70005', -1),
    'PID_11': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'PATIENT_ADDRESS', None, -1),
    'PID_12': ('leaf', None, 'ID', 'COUNTY_CODE', None, -1),
    'PID_13': ('leaf', None, 'TN', 'PHONE_NUMBER_HOME', None, -1),
    'PID_14': ('leaf', None, 'TN', 'PHONE_NUMBER_BUSINESS', None, -1),
    'PID_15': ('leaf', None, 'ST', 'LANGUAGE_PATIENT', None, -1),
    'PID_16': ('leaf', None, 'ID', 'MARITAL_STATUS', 'HL70002', -1),
    'PID_17': ('leaf', None, 'ID', 'RELIGION', 'HL70006', -1),
    'PID_18': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID'], 'CM_PAT_ID', 'PATIENT_ACCOUNT_NUMBER', None, -1),
    'PID_19': ('leaf', None, 'ST', 'SOCIAL_SECURITY_NUMBER_PATIENT', None, -1),
    'PID_20': ('sequence', DATATYPES_STRUCTS['CM_LICENSE_NO'], 'CM_LICENSE_NO',
               'DRIVER_S_LICENSE_NUMBER_PATIENT', None, -1),
    'PID_21': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID'], 'CM_PAT_ID', 'MOTHER_S_IDENTIFIER', None, -1),
    'PID_22': ('leaf', None, 'ID', 'ETHNIC_GROUP', 'HL70189', -1),
    'PID_23': ('leaf', None, 'ST', 'BIRTH_PLACE', None, -1),
    'PID_24': ('leaf', None, 'ID', 'MULTIPLE_BIRTH_INDICATOR', None, -1),
    'PID_25': ('leaf', None, 'NM', 'BIRTH_ORDER', None, -1),
    'PID_26': ('leaf', None, 'ID', 'CITIZENSHIP', 'HL70171', -1),
    'PID_27': ('leaf', None, 'ST', 'VETERANS_MILITARY_STATUS', None, -1),
    'PR1_1': ('leaf', None, 'SI', 'SET_ID_PROCEDURE', None, -1),
    'PR1_2': ('leaf', None, 'ID', 'PROCEDURE_CODING_METHOD', 'HL70089', -1),
    'PR1_3': ('leaf', None, 'ID', 'PROCEDURE_CODE', 'HL70088', -1),
    'PR1_4': ('leaf', None, 'ST', 'PROCEDURE_DESCRIPTION', None, -1),
    'PR1_5': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'PROCEDURE_DATE_TIME', None, -1),
    'PR1_6': ('leaf', None, 'ID', 'PROCEDURE_TYPE', 'HL70090', -1),
    'PR1_7': ('leaf', None, 'NM', 'PROCEDURE_MINUTES', None, -1),
    'PR1_8': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ANESTHESIOLOGIST', 'HL70010', -1),
    'PR1_9': ('leaf', None, 'ID', 'ANESTHESIA_CODE', 'HL70019', -1),
    'PR1_10': ('leaf', None, 'NM', 'ANESTHESIA_MINUTES', None, -1),
    'PR1_11': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'SURGEON', 'HL70010', -1),
    'PR1_12': ('sequence', DATATYPES_STRUCTS['CM_PRACTITIONER'], 'CM_PRACTITIONER',
               'PROCEDURE_PRACTITIONER', 'HL70010', -1),
    'PR1_13': ('leaf', None, 'ID', 'CONSENT_CODE', 'HL70059', -1),
    'PR1_14': ('leaf', None, 'NM', 'PROCEDURE_PRIORITY', None, -1),
    'PRA_1': ('leaf', None, 'ST', 'PRA_PRIMARY_KEY_VALUE', None, -1),
    'PRA_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PRACTITIONER_GROUP', None, -1),
    'PRA_3': ('leaf', None, 'ID', 'PRACTITIONER_CATEGORY', 'HL70186', -1),
    'PRA_4': ('leaf', None, 'ID', 'PROVIDER_BILLING', 'HL70187', -1),
    'PRA_5': ('sequence', DATATYPES_STRUCTS['CM_SPD'], 'CM_SPD', 'SPECIALTY', None, -1),
    'PRA_6': ('sequence', DATATYPES_STRUCTS['CM_PLN'], 'CM_PLN', 'PRACTITIONER_ID_NUMBERS', None, -1),
    'PRA_7': ('sequence', DATATYPES_STRUCTS['CM_PIP'], 'CM_PIP', 'PRIVILEGES', None, -1),
    'PV1_1': ('leaf', None, 'SI', 'SET_ID_PATIENT_VISIT', None, -1),
    'PV1_2': ('leaf', None, 'ID', 'PATIENT_CLASS', 'HL70004', -1),
    'PV1_3': ('sequence', DATATYPES_STRUCTS['CM_INTERNAL_LOCATION'], 'CM_INTERNAL_LOCATION',
              'ASSIGNED_PATIENT_LOCATION', 'HL70079', -1),
    'PV1_4': ('leaf', None, 'ID', 'ADMISSION_TYPE', 'HL70007', -1),
    'PV1_5': ('leaf', None, 'ST', 'PREADMIT_NUMBER', None, -1),
    'PV1_6': ('sequence', DATATYPES_STRUCTS['CM_INTERNAL_LOCATION'], 'CM_INTERNAL_LOCATION',
              'PRIOR_PATIENT_LOCATION', None, -1),
    'PV1_7': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ATTENDING_DOCTOR', 'HL70010', -1),
    'PV1_8': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'REFERRING_DOCTOR', 'HL70010', -1),
    'PV1_9': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'CONSULTING_DOCTOR', 'HL70010', -1),
    'PV1_10': ('leaf', None, 'ID', 'HOSPITAL_SERVICE', 'HL70069', -1),
    'PV1_11': ('sequence', DATATYPES_STRUCTS['CM_INTERNAL_LOCATION'], 'CM_INTERNAL_LOCATION',
               'TEMPORARY_LOCATION', 'HL70079', -1),
    'PV1_12': ('leaf', None, 'ID', 'PREADMIT_TEST_INDICATOR', 'HL70087', -1),
    'PV1_13': ('leaf', None, 'ID', 'READMISSION_INDICATOR', 'HL70092', -1),
    'PV1_14': ('leaf', None, 'ID', 'ADMIT_SOURCE', 'HL70023', -1),
    'PV1_15': ('leaf', None, 'ID', 'AMBULATORY_STATUS', 'HL70009', -1),
    'PV1_16': ('leaf', None, 'ID', 'VIP_INDICATOR', 'HL70099', -1),
    'PV1_17': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ADMITTING_DOCTOR', 'HL70010', -1),
    'PV1_18': ('leaf', None, 'ID', 'PATIENT_TYPE', 'HL70018', -1),
    'PV1_19': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID'], 'CM_PAT_ID', 'VISIT_NUMBER', None, -1),
    'PV1_20': ('sequence', DATATYPES_STRUCTS['CM_FINANCE'], 'CM_FINANCE', 'FINANCIAL_CLASS', 'HL70064', -1),
    'PV1_21': ('leaf', None, 'ID', 'CHARGE_PRICE_INDICATOR', 'HL70032', -1),
    'PV1_22': ('leaf', None, 'ID', 'COURTESY_CODE', 'HL70045', -1),
    'PV1_23': ('leaf', None, 'ID', 'CREDIT_RATING', 'HL70046', -1),
    'PV1_24': ('leaf', None, 'ID', 'CONTRACT_CODE', 'HL70044', -1),
    'PV1_25': ('leaf', None, 'DT', 'CONTRACT_EFFECTIVE_DATE', None, -1),
    'PV1_26': ('leaf', None, 'NM', 'CONTRACT_AMOUNT', None, -1),
    'PV1_27': ('leaf', None, 'NM', 'CONTRACT_PERIOD', None, -1),
    'PV1_28': ('leaf', None, 'ID', 'INTEREST_CODE', 'HL70073', -1),
    'PV1_29': ('leaf', None, 'ID', 'TRANSFER_TO_BAD_DEBT_CODE', 'HL70110', -1),
    'PV1_30': ('leaf', None, 'DT', 'TRANSFER_TO_BAD_DEBT_DATE', None, -1),
    'PV1_31': ('leaf', None, 'ID', 'BAD_DEBT_AGENCY_CODE', 'HL70021', -1),
    'PV1_32': ('leaf', None, 'NM', 'BAD_DEBT_TRANSFER_AMOUNT', None, -1),
    'PV1_33': ('leaf', None, 'NM', 'BAD_DEBT_RECOVERY_AMOUNT', None, -1),
    'PV1_34': ('leaf', None, 'ID', 'DELETE_ACCOUNT_INDICATOR', 'HL70111', -1),
    'PV1_35': ('leaf', None, 'DT', 'DELETE_ACCOUNT_DATE', None, -1),
    'PV1_36': ('leaf', None, 'ID', 'DISCHARGE_DISPOSITION', 'HL70112', -1),
    'PV1_37': ('sequence', DATATYPES_STRUCTS['CM_DLD'], 'CM_DLD', 'DISCHARGED_TO_LOCATION', 'HL70113', -1),
    'PV1_38': ('leaf', None, 'ID', 'DIET_TYPE', 'HL70114', -1),
    'PV1_39': ('leaf', None, 'ID', 'SERVICING_FACILITY', 'HL70115', -1),
    'PV1_40': ('leaf', None, 'ID', 'BED_STATUS', 'HL70116', -1),
    'PV1_41': ('leaf', None, 'ID', 'ACCOUNT_STATUS', 'HL70117', -1),
    'PV1_42': ('sequence', DATATYPES_STRUCTS['CM_INTERNAL_LOCATION'], 'CM_INTERNAL_LOCATION',
               'PENDING_LOCATION', None, -1),
    'PV1_43': ('sequence', DATATYPES_STRUCTS['CM_INTERNAL_LOCATION'], 'CM_INTERNAL_LOCATION',
               'PRIOR_TEMPORARY_LOCATION', None, -1),
    'PV1_44': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'ADMIT_DATE_TIME', None, -1),
    'PV1_45': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DISCHARGE_DATE_TIME', None, -1),
    'PV1_46': ('leaf', None, 'NM', 'CURRENT_PATIENT_BALANCE', None, -1),
    'PV1_47': ('leaf', None, 'NM', 'TOTAL_CHARGES', None, -1),
    'PV1_48': ('leaf', None, 'NM', 'TOTAL_ADJUSTMENTS', None, -1),
    'PV1_49': ('leaf', None, 'NM', 'TOTAL_PAYMENTS', None, -1),
    'PV1_50': ('sequence', DATATYPES_STRUCTS['CM_PAT_ID_0192'], 'CM_PAT_ID_0192', 'ALTERNATE_VISIT_ID', None, -1),
    'PV2_1': ('sequence', DATATYPES_STRUCTS['CM_INTERNAL_LOCATION'], 'CM_INTERNAL_LOCATION',
              'PRIOR_PENDING_LOCATION', None, -1),
    'PV2_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACCOMMODATION_CODE', 'HL70129', -1),
    'PV2_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMIT_REASON', None, -1),
    'PV2_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'TRANSFER_REASON', None, -1),
    'PV2_5': ('leaf', None, 'ST', 'PATIENT_VALUABLES', None, -1),
    'PV2_6': ('leaf', None, 'ST', 'PATIENT_VALUABLES_LOCATION', None, -1),
    'PV2_7': ('leaf', None, 'ID', 'VISIT_USER_CODE', 'HL70130', -1),
    'PV2_8': ('leaf', None, 'DT', 'EXPECTED_ADMIT_DATE', None, -1),
    'PV2_9': ('leaf', None, 'DT', 'EXPECTED_DISCHARGE_DATE', None, -1),
    'QRD_1': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'QUERY_DATE_TIME', None, -1),
    'QRD_2': ('leaf', None, 'ID', 'QUERY_FORMAT_CODE', 'HL70106', -1),
    'QRD_3': ('leaf', None, 'ID', 'QUERY_PRIORITY', 'HL70091', -1),
    'QRD_4': ('leaf', None, 'ST', 'QUERY_ID', None, -1),
    'QRD_5': ('leaf', None, 'ID', 'DEFERRED_RESPONSE_TYPE', 'HL70107', -1),
    'QRD_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DEFERRED_RESPONSE_DATE_TIME', None, -1),
    'QRD_7': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'QUANTITY_LIMITED_REQUEST', 'HL70126', -1),
    'QRD_8': ('leaf', None, 'ST', 'WHO_SUBJECT_FILTER', None, -1),
    'QRD_9': ('leaf', None, 'ID', 'WHAT_SUBJECT_FILTER', 'HL70048', -1),
    'QRD_10': ('leaf', None, 'ST', 'WHAT_DEPARTMENT_DATA_CODE', None, -1),
    'QRD_11': ('sequence', DATATYPES_STRUCTS['CM_VR'], 'CM_VR', 'WHAT_DATA_CODE_VALUE_QUALIFIER', None, -1),
    'QRD_12': ('leaf', None, 'ID', 'QUERY_RESULTS_LEVEL', 'HL70108', -1),
    'QRF_1': ('leaf', None, 'ST', 'WHERE_SUBJECT_FILTER', None, -1),
    'QRF_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'WHEN_DATA_START_DATE_TIME', None, -1),
    'QRF_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'WHEN_DATA_END_DATE_TIME', None, -1),
    'QRF_4': ('leaf', None, 'ST', 'WHAT_USER_QUALIFIER', None, -1),
    'QRF_5': ('leaf', None, 'ST', 'OTHER_QRY_SUBJECT_FILTER', None, -1),
    'QRF_6': ('leaf', None, 'ID', 'WHICH_DATE_TIME_QUALIFIER', 'HL70156', -1),
    'QRF_7': ('leaf', None, 'ID', 'WHICH_DATE_TIME_STATUS_QUALIFIER', 'HL70157', -1),
    'QRF_8': ('leaf', None, 'ID', 'DATE_TIME_SELECTION_QUALIFIER', 'HL70158', -1),
    'RQ1_1': ('leaf', None, 'SI', 'ANTICIPATED_PRICE', None, -1),
    'RQ1_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'MANUFACTURER_ID', None, -1),
    'RQ1_3': ('leaf', None, 'ST', 'MANUFACTURER_S_CATALOG', None, -1),
    'RQ1_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'VENDOR_ID', None, -1),
    'RQ1_5': ('leaf', None, 'ST', 'VENDOR_CATALOG', None, -1),
    'RQ1_6': ('leaf', None, 'ID', 'TAXABLE', 'HL70136', -1),
    'RQ1_7': ('leaf', None, 'ID', 'SUBSTITUTE_ALLOWED', 'HL70136', -1),
    'RQD_1': ('leaf', None, 'SI', 'REQUISITION_LINE_NUMBER', None, -1),
    'RQD_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ITEM_CODE_INTERNAL', None, -1),
    'RQD_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ITEM_CODE_EXTERNAL', None, -1),
    'RQD_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'HOSPITAL_ITEM_CODE', None, -1),
    'RQD_5': ('leaf', None, 'NM', 'REQUISITION_QUANTITY', None, -1),
    'RQD_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUISITION_UNIT_OF_MEASURE', None, -1),
    'RQD_7': ('leaf', None, 'ID', 'DEPARTMENT_COST_CENTER', None, -1),
    'RQD_8': ('leaf', None, 'ID', 'ITEM_NATURAL_ACCOUNT_CODE', None, -1),
    'RQD_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DELIVER_TO_ID', None, -1),
    'RQD_10': ('leaf', None, 'DT', 'DATE_NEEDED', None, -1),
    'RXA_1': ('leaf', None, 'NM', 'GIVE_SUB_ID_COUNTER', None, -1),
    'RXA_2': ('leaf', None, 'NM', 'ADMINISTRATION_SUB_ID_COUNTER', None, -1),
    'RXA_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_START_OF_ADMINISTRATION', None, -1),
    'RXA_4': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_END_OF_ADMINISTRATION', None, -1),
    'RXA_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTERED_CODE', None, -1),
    'RXA_6': ('leaf', None, 'NM', 'ADMINISTERED_AMOUNT', None, -1),
    'RXA_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTERED_UNITS', None, -1),
    'RXA_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTERED_DOSAGE_FORM', None, -1),
    'RXA_9': ('leaf', None, 'ST', 'ADMINISTRATION_NOTES', None, -1),
    'RXA_10': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ADMINISTERING_PROVIDER', None, -1),
    'RXA_11': ('sequence', DATATYPES_STRUCTS['CM_LA1'], 'CM_LA1', 'ADMINISTERED_AT_LOCATION', None, -1),
    'RXA_12': ('leaf', None, 'ST', 'ADMINISTERED_PER_TIME_UNIT', None, -1),
    'RXC_1': ('leaf', None, 'ID', 'RX_COMPONENT_TYPE', 'HL70166', -1),
    'RXC_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'COMPONENT_CODE', None, -1),
    'RXC_3': ('leaf', None, 'NM', 'COMPONENT_AMOUNT', None, -1),
    'RXC_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'COMPONENT_UNITS', None, -1),
    'RXD_1': ('leaf', None, 'NM', 'DISPENSE_SUB_ID_COUNTER', None, -1),
    'RXD_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DISPENSE_GIVE_CODE', None, -1),
    'RXD_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_TIME_DISPENSED', None, -1),
    'RXD_4': ('leaf', None, 'NM', 'ACTUAL_DISPENSE_AMOUNT', None, -1),
    'RXD_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACTUAL_DISPENSE_UNITS', None, -1),
    'RXD_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ACTUAL_DOSAGE_FORM', None, -1),
    'RXD_7': ('leaf', None, 'ST', 'PRESCRIPTION_NUMBER', None, -1),
    'RXD_8': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_REMAINING', None, -1),
    'RXD_9': ('leaf', None, 'ST', 'DISPENSE_NOTES', None, -1),
    'RXD_10': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'DISPENSING_PROVIDER', None, -1),
    'RXD_11': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXD_12': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DAILY_DOSE', None, -1),
    'RXD_13': ('sequence', DATATYPES_STRUCTS['CM_LA1'], 'CM_LA1', 'DELIVER_TO_LOCATION', None, -1),
    'RXD_14': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', None, -1),
    'RXD_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PHARMACY_SPECIAL_DISPENSING_INSTRUCTIONS', None, -1),
    'RXE_1': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'QUANTITY_TIMING', None, -1),
    'RXE_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_CODE', None, -1),
    'RXE_3': ('leaf', None, 'NM', 'GIVE_AMOUNT_MINIMUM', None, -1),
    'RXE_4': ('leaf', None, 'NM', 'GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXE_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_UNITS', None, -1),
    'RXE_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_DOSAGE_FORM', None, -1),
    'RXE_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', None, -1),
    'RXE_8': ('sequence', DATATYPES_STRUCTS['CM_LA1'], 'CM_LA1', 'DELIVER_TO_LOCATION', None, -1),
    'RXE_9': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXE_10': ('leaf', None, 'NM', 'DISPENSE_AMOUNT', None, -1),
    'RXE_11': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DISPENSE_UNITS', None, -1),
    'RXE_12': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS', None, -1),
    'RXE_13': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ORDERING_PROVIDER_S_DEA_NUMBER', None, -1),
    'RXE_14': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'PHARMACIST_VERIFIER_ID', None, -1),
    'RXE_15': ('leaf', None, 'ST', 'PRESCRIPTION_NUMBER', None, -1),
    'RXE_16': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_REMAINING', None, -1),
    'RXE_17': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS_DOSES_DISPENSED', None, -1),
    'RXE_18': ('sequence', DATATYPES_STRUCTS['TS'], 'TS',
               'DATE_TIME_OF_MOST_RECENT_REFILL_OR_DOSE_DISPENSED', None, -1),
    'RXE_19': ('sequence', DATATYPES_STRUCTS['CQ'], 'CQ', 'TOTAL_DAILY_DOSE', None, -1),
    'RXE_20': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', None, -1),
    'RXE_21': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PHARMACY_SPECIAL_DISPENSING_INSTRUCTIONS', None, -1),
    'RXE_22': ('leaf', None, 'ST', 'GIVE_PER_TIME_UNIT', None, -1),
    'RXE_23': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_RATE_AMOUNT', None, -1),
    'RXE_24': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_RATE_UNITS', None, -1),
    'RXG_1': ('leaf', None, 'NM', 'GIVE_SUB_ID_COUNTER', None, -1),
    'RXG_2': ('leaf', None, 'NM', 'DISPENSE_SUB_ID_COUNTER', None, -1),
    'RXG_3': ('sequence', DATATYPES_STRUCTS['TQ'], 'TQ', 'QUANTITY_TIMING', None, -1),
    'RXG_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_CODE', None, -1),
    'RXG_5': ('leaf', None, 'NM', 'GIVE_AMOUNT_MINIMUM', None, -1),
    'RXG_6': ('leaf', None, 'NM', 'GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXG_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_UNITS', None, -1),
    'RXG_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_DOSAGE_FORM', None, -1),
    'RXG_9': ('leaf', None, 'ST', 'ADMINISTRATION_NOTES', None, -1),
    'RXG_10': ('leaf', None, 'ID', 'SUBSTITUTION_STATUS', 'HL70167', -1),
    'RXG_11': ('sequence', DATATYPES_STRUCTS['CM_LA1'], 'CM_LA1', 'DELIVER_TO_LOCATION', None, -1),
    'RXG_12': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', None, -1),
    'RXG_13': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PHARMACY_SPECIAL_ADMINISTRATION_INSTRUCTIONS', None, -1),
    'RXG_14': ('leaf', None, 'ST', 'GIVE_PER_TIME_UNIT', None, -1),
    'RXG_15': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_RATE_AMOUNT', None, -1),
    'RXG_16': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'GIVE_RATE_UNITS', None, -1),
    'RXO_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_GIVE_CODE', None, -1),
    'RXO_2': ('leaf', None, 'NM', 'REQUESTED_GIVE_AMOUNT_MINIMUM', None, -1),
    'RXO_3': ('leaf', None, 'NM', 'REQUESTED_GIVE_AMOUNT_MAXIMUM', None, -1),
    'RXO_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_GIVE_UNITS', None, -1),
    'RXO_5': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_DOSAGE_FORM', None, -1),
    'RXO_6': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROVIDER_S_PHARMACY_INSTRUCTIONS', None, -1),
    'RXO_7': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'PROVIDER_S_ADMINISTRATION_INSTRUCTIONS', None, -1),
    'RXO_8': ('sequence', DATATYPES_STRUCTS['CM_LA1'], 'CM_LA1', 'DELIVER_TO_LOCATION', None, -1),
    'RXO_9': ('leaf', None, 'ID', 'ALLOW_SUBSTITUTIONS', 'HL70161', -1),
    'RXO_10': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_DISPENSE_CODE', None, -1),
    'RXO_11': ('leaf', None, 'NM', 'REQUESTED_DISPENSE_AMOUNT', None, -1),
    'RXO_12': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'REQUESTED_DISPENSE_UNITS', None, -1),
    'RXO_13': ('leaf', None, 'NM', 'NUMBER_OF_REFILLS', None, -1),
    'RXO_14': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'ORDERING_PROVIDER_S_DEA_NUMBER', None, -1),
    'RXO_15': ('sequence', DATATYPES_STRUCTS['CN'], 'CN', 'PHARMACIST_VERIFIER_ID', None, -1),
    'RXO_16': ('leaf', None, 'ID', 'NEEDS_HUMAN_REVIEW', None, -1),
    'RXO_17': ('leaf', None, 'ST', 'REQUESTED_GIVE_PER_TIME_UNIT', None, -1),
    'RXR_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ROUTE', 'HL70162', -1),
    'RXR_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SITE', 'HL70163', -1),
    'RXR_3': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTRATION_DEVICE', 'HL70164', -1),
    'RXR_4': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'ADMINISTRATION_METHOD', 'HL70165', -1),
    'STF_1': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STF_PRIMARY_KEY_VALUE', None, -1),
    'STF_2': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'STAFF_ID_CODE', None, -1),
    'STF_3': ('sequence', DATATYPES_STRUCTS['PN'], 'PN', 'STAFF_NAME', None, -1),
    'STF_4': ('leaf', None, 'ID', 'STAFF_TYPE', 'HL70182', -1),
    'STF_5': ('leaf', None, 'ID', 'SEX', 'HL70001', -1),
    'STF_6': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'DATE_OF_BIRTH', None, -1),
    'STF_7': ('leaf', None, 'ID', 'ACTIVE_INACTIVE', 'HL70183', -1),
    'STF_8': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'DEPARTMENT', 'HL70184', -1),
    'STF_9': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'SERVICE', None, -1),
    'STF_10': ('leaf', None, 'TN', 'PHONE', None, -1),
    'STF_11': ('sequence', DATATYPES_STRUCTS['AD'], 'AD', 'OFFICE_HOME_ADDRESS', None, -1),
    'STF_12': ('sequence', DATATYPES_STRUCTS['CM_DIN'], 'CM_DIN', 'ACTIVATION_DATE', None, -1),
    'STF_13': ('sequence', DATATYPES_STRUCTS['CM_DIN'], 'CM_DIN', 'INACTIVATION_DATE', None, -1),
    'STF_14': ('sequence', DATATYPES_STRUCTS['CE'], 'CE', 'BACKUP_PERSON_ID', None, -1),
    'STF_15': ('leaf', None, 'ST', 'E_MAIL_ADDRESS', None, -1),
    'STF_16': ('leaf', None, 'ID', 'PREFERRED_METHOD_OF_CONTACT', 'HL70185', -1),
    'UB1_1': ('leaf', None, 'SI', 'SET_ID_UB82', None, -1),
    'UB1_2': ('leaf', None, 'NM', 'BLOOD_DEDUCTIBLE_43', 'HL70136', -1),
    'UB1_3': ('leaf', None, 'NM', 'BLOOD_FURNISHED_PINTS_OF_40', None, -1),
    'UB1_4': ('leaf', None, 'NM', 'BLOOD_REPLACED_PINTS_41', None, -1),
    'UB1_5': ('leaf', None, 'NM', 'BLOOD_NOT_REPLACED_PINTS_42', None, -1),
    'UB1_6': ('leaf', None, 'NM', 'CO_INSURANCE_DAYS_25', None, -1),
    'UB1_7': ('leaf', None, 'ID', 'CONDITION_CODE_35_39', 'HL70043', -1),
    'UB1_8': ('leaf', None, 'NM', 'COVERED_DAYS_23', None, -1),
    'UB1_9': ('leaf', None, 'NM', 'NON_COVERED_DAYS_24', None, -1),
    'UB1_10': ('sequence', DATATYPES_STRUCTS['CM_UVC'], 'CM_UVC', 'VALUE_AMOUNT_AND_CODE_46_49', 'HL70153', -1),
    'UB1_11': ('leaf', None, 'NM', 'NUMBER_OF_GRACE_DAYS_90', None, -1),
    'UB1_12': ('leaf', None, 'ID', 'SPECIAL_PROGRAM_INDICATOR_44', None, -1),
    'UB1_13': ('leaf', None, 'ID', 'PSRO_UR_APPROVAL_INDICATOR_87', None, -1),
    'UB1_14': ('leaf', None, 'DT', 'PSRO_UR_APPROVED_STAY_FROM_88', None, -1),
    'UB1_15': ('leaf', None, 'DT', 'PSRO_UR_APPROVED_STAY_TO_89', None, -1),
    'UB1_16': ('sequence', DATATYPES_STRUCTS['CM_OCD'], 'CM_OCD', 'OCCURRENCE_28_32', None, -1),
    'UB1_17': ('leaf', None, 'ID', 'OCCURRENCE_SPAN_33', None, -1),
    'UB1_18': ('leaf', None, 'DT', 'OCCURRENCE_SPAN_START_DATE_33', None, -1),
    'UB1_19': ('leaf', None, 'DT', 'OCCURRENCE_SPAN_END_DATE_33', None, -1),
    'UB1_20': ('leaf', None, 'ST', 'UB_82_LOCATOR_2', None, -1),
    'UB1_21': ('leaf', None, 'ST', 'UB_82_LOCATOR_9', None, -1),
    'UB1_22': ('leaf', None, 'ST', 'UB_82_LOCATOR_27', None, -1),
    'UB1_23': ('leaf', None, 'ST', 'UB_82_LOCATOR_45', None, -1),
    'UB2_1': ('leaf', None, 'SI', 'SET_ID_UB92', None, -1),
    'UB2_2': ('leaf', None, 'ST', 'CO_INSURANCE_DAYS_9', None, -1),
    'UB2_3': ('leaf', None, 'ID', 'CONDITION_CODE_24_30', 'HL70043', -1),
    'UB2_4': ('leaf', None, 'ST', 'COVERED_DAYS_7', None, -1),
    'UB2_5': ('leaf', None, 'ST', 'NON_COVERED_DAYS_8', None, -1),
    'UB2_6': ('sequence', DATATYPES_STRUCTS['CM_UVC'], 'CM_UVC', 'VALUE_AMOUNT_AND_CODE_39_41', None, -1),
    'UB2_7': ('sequence', DATATYPES_STRUCTS['CM_OCD'], 'CM_OCD', 'OCCURRENCE_CODE_AND_DATE_32_35', None, -1),
    'UB2_8': ('sequence', DATATYPES_STRUCTS['CM_OSP'], 'CM_OSP', 'OCCURRENCE_SPAN_CODE_DATES_36', None, -1),
    'UB2_9': ('leaf', None, 'ST', 'UB92_LOCATOR_2_STATE', None, -1),
    'UB2_10': ('leaf', None, 'ST', 'UB92_LOCATOR_11_STATE', None, -1),
    'UB2_11': ('leaf', None, 'ST', 'UB92_LOCATOR_31_NATIONAL', None, -1),
    'UB2_12': ('leaf', None, 'ST', 'DOCUMENT_CONTROL_NUMBER_37', None, -1),
    'UB2_13': ('leaf', None, 'ST', 'UB92_LOCATOR_49_NATIONAL', None, -1),
    'UB2_14': ('leaf', None, 'ST', 'UB92_LOCATOR_56_STATE', None, -1),
    'UB2_15': ('leaf', None, 'ST', 'UB92_LOCATOR_57_NATIONAL', None, -1),
    'UB2_16': ('leaf', None, 'ST', 'UB92_LOCATOR_78_STATE', None, -1),
    'URD_1': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'R_U_DATE_TIME', None, -1),
    'URD_2': ('leaf', None, 'ID', 'REPORT_PRIORITY', 'HL70109', -1),
    'URD_3': ('leaf', None, 'ST', 'R_U_WHO_SUBJECT_DEFINITION', None, -1),
    'URD_4': ('leaf', None, 'ID', 'R_U_WHAT_SUBJECT_DEFINITION', 'HL70048', -1),
    'URD_5': ('leaf', None, 'ST', 'R_U_WHAT_DEPARTMENT_CODE', None, -1),
    'URD_6': ('leaf', None, 'ST', 'R_U_DISPLAY_PRINT_LOCATIONS', None, -1),
    'URD_7': ('leaf', None, 'ID', 'R_U_RESULTS_LEVEL', 'HL70108', -1),
    'URS_1': ('leaf', None, 'ST', 'R_U_WHERE_SUBJECT_DEFINITION', None, -1),
    'URS_2': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'R_U_WHEN_DATA_START_DATE_TIME', None, -1),
    'URS_3': ('sequence', DATATYPES_STRUCTS['TS'], 'TS', 'R_U_WHEN_DATA_END_DATE_TIME', None, -1),
    'URS_4': ('leaf', None, 'ST', 'R_U_WHAT_USER_QUALIFIER', None, -1),
    'URS_5': ('leaf', None, 'ST', 'R_U_OTHER_RESULTS_SUBJECT_DEFINITION', None, -1),
    'URS_6': ('leaf', None, 'ID', 'R_U_WHICH_DATE_TIME_QUALIFIER', 'HL70156', -1),
    'URS_7': ('leaf', None, 'ID', 'R_U_WHICH_DATE_TIME_STATUS_QUALIFIER', 'HL70157', -1),
    'URS_8': ('leaf', None, 'ID', 'R_U_DATE_TIME_SELECTION_QUALIFIER', 'HL70158', -1),
}
