# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .tracked_resource import TrackedResource


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict
    :param location: Resource location.
    :type location: str
    :ivar kind: Kind of sql server.  This is metadata used for the Azure
     portal experience.
    :vartype kind: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the
     server.
    :vartype fully_qualified_domain_name: str
    :param version: The version of the server. Possible values include: '2.0',
     '12.0'
    :type version: str or :class:`ServerVersion
     <azure.mgmt.sql.models.ServerVersion>`
    :param administrator_login: Administrator username for the server. Can
     only be specified when the server is being created (and is required for
     creation).
    :type administrator_login: str
    :param administrator_login_password: The administrator login password
     (required for server creation).
    :type administrator_login_password: str
    :ivar external_administrator_sid: The ID of the Active Azure Directory
     object with admin permissions on this server. Legacy parameter, always
     null. To check for Active Directory admin, query
     .../servers/{serverName}/administrators.
    :vartype external_administrator_sid: str
    :ivar external_administrator_login: The display name of the Azure Active
     Directory object with admin permissions on this server. Legacy parameter,
     always null. To check for Active Directory admin, query
     .../servers/{serverName}/administrators
    :vartype external_administrator_login: str
    :ivar state: The state of the server. Possible values include: 'Ready',
     'Disabled'
    :vartype state: str or :class:`ServerState
     <azure.mgmt.sql.models.ServerState>`
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'external_administrator_sid': {'readonly': True},
        'external_administrator_login': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'external_administrator_sid': {'key': 'properties.externalAdministratorSid', 'type': 'str'},
        'external_administrator_login': {'key': 'properties.externalAdministratorLogin', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'ServerState'},
    }

    def __init__(self, location, tags=None, version=None, administrator_login=None, administrator_login_password=None):
        super(Server, self).__init__(tags=tags, location=location)
        self.kind = None
        self.fully_qualified_domain_name = None
        self.version = version
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.external_administrator_sid = None
        self.external_administrator_login = None
        self.state = None
