# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PropertyDescription(Model):
    """Description of a Service Fabric property.

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param custom_type_id: The property's custom type id. Using this property,
     the user is able to tag the type of the value of the property.
    :type custom_type_id: str
    :param value: Required. Describes a Service Fabric property value.
    :type value: ~azure.servicefabric.models.PropertyValue
    """

    _validation = {
        'property_name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'custom_type_id': {'key': 'CustomTypeId', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'PropertyValue'},
    }

    def __init__(self, *, property_name: str, value, custom_type_id: str=None, **kwargs) -> None:
        super(PropertyDescription, self).__init__(**kwargs)
        self.property_name = property_name
        self.custom_type_id = custom_type_id
        self.value = value
