# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationDescription(Model):
    """Describes a Service Fabric application.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the application, including the
     'fabric:' URI scheme.
    :type name: str
    :param type_name: Required. The application type name as defined in the
     application manifest.
    :type type_name: str
    :param type_version: Required. The version of the application type as
     defined in the application manifest.
    :type type_version: str
    :param parameter_list: List of application parameters with overridden
     values from their default values specified in the application manifest.
    :type parameter_list:
     list[~azure.servicefabric.models.ApplicationParameter]
    :param application_capacity: Describes capacity information for services
     of this application. This description can be used for describing the
     following.
     - Reserving the capacity for the services on the nodes
     - Limiting the total number of nodes that services of this application can
     run on
     - Limiting the custom capacity metrics to limit the total consumption of
     this metric by the services of this application
    :type application_capacity:
     ~azure.servicefabric.models.ApplicationCapacityDescription
    """

    _validation = {
        'name': {'required': True},
        'type_name': {'required': True},
        'type_version': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'type_version': {'key': 'TypeVersion', 'type': 'str'},
        'parameter_list': {'key': 'ParameterList', 'type': '[ApplicationParameter]'},
        'application_capacity': {'key': 'ApplicationCapacity', 'type': 'ApplicationCapacityDescription'},
    }

    def __init__(self, **kwargs):
        super(ApplicationDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type_name = kwargs.get('type_name', None)
        self.type_version = kwargs.get('type_version', None)
        self.parameter_list = kwargs.get('parameter_list', None)
        self.application_capacity = kwargs.get('application_capacity', None)
