#This file is part of Higgins. The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license
#terms.

from collections import defaultdict
import yaml
import logging
import os

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger('higgins')

DOT_DIR = '.hn'
CONFIG_FILE = os.path.join(DOT_DIR, 'config.yaml')
BUILD_DIR = os.path.join(DOT_DIR, 'builds')
TEMPLATE_DIR = os.path.join(DOT_DIR, 'template')
STATIC_DIR = os.path.join(DOT_DIR, 'static')
DB_URI = 'sqlite:///' + DOT_DIR + '/db.sqlite'
CONFIG = None


def read_config(config_file=None, cli_args=None):
    global CONFIG, CONFIG_FILE, CLI_ARGS

    if cli_args.debug:
        logger.setLevel(logging.DEBUG)
        logger.debug('logging level set to debug')

    CLI_ARGS = cli_args

    if config_file is not None:
        CONFIG_FILE = config_file

    action = cli_args.action and cli_args.action[0]
    if not os.path.exists(CONFIG_FILE):
        if action != 'init':
            logger.error('Config file "%s" not found' % CONFIG_FILE)
            exit()
        else:
            content = {}
    else:
        logger.debug('Load config file "%s"' % CONFIG_FILE)
        with open(CONFIG_FILE) as fh:
            content = yaml.load(fh) or {}

    # Handle project inheritance
    by_depth = defaultdict(list)
    for key in content:
        by_depth[key.count('.')].append(key)

    for depth in sorted(by_depth)[1:]:
        for key in by_depth[depth]:
            parts = key.split('.')
            root = '.'.join(parts[:depth])
            parent = content.get(root, {})
            new_value = parent.copy()
            new_value.update(content[key])
            content[key] = new_value

    CONFIG = content

def save(data):
    with open(CONFIG_FILE, 'w') as fh:
        fh.write(data)


def get(name, default=None):
    return CONFIG.get(name, default)


def cli(name):
    return getattr(CLI_ARGS, name)
