# -*- coding: utf-8 -*-
import json
import os
from ast import literal_eval


class ConfiguracaoErro(Exception):
    pass


def obter_variavel(nome):
    try:
        return os.environ['PAGADOR_{}'.format(nome)]
    except KeyError:
        raise ConfiguracaoErro(u'A chave PAGADOR_{} nao foi encontrada no ambiente e e obrigatoria. Use export PAGADOR_{}=VALOR para adiciona-la ao seu ambiente.'.format(nome, nome))

API_URL = os.environ['API_URL']
SECURE_API_URL = os.environ['SECURE_API_URL']
CHAVE_API_PEDIDO = os.environ['CHAVE_API_PEDIDO']
CHAVE_API_PLATAFORMA = os.environ['CHAVE_API_PLATAFORMA']
ENVIRONMENT = os.environ['ENVIRONMENT']

DEBUG = obter_variavel('DEBUG') == 'True'

REQUEST_BASE_TIMEOUT = literal_eval(obter_variavel('REQUEST_BASE_TIMEOUT'))
EXTENSOES = json.loads(obter_variavel('EXTENSOES'))
INSTALAR_REDIRECT_URL = '{}{}'.format(API_URL, obter_variavel('INSTALAR_REDIRECT_URL'))
INSTALAR_REDIRECT_URL_SEGURA = '{}{}'.format(SECURE_API_URL, obter_variavel('INSTALAR_REDIRECT_URL'))
NOTIFICACAO_URL = '{}{}'.format(API_URL, obter_variavel('NOTIFICACAO_URL'))
NOTIFICACAO_URL_SEGURA = '{}{}'.format(SECURE_API_URL, obter_variavel('NOTIFICACAO_URL'))

API_PEDIDO = '{}{}'.format(API_URL, obter_variavel('API_PEDIDO'))
AUTENTICACAO_API_PEDIDO = obter_variavel('AUTENTICACAO_API_PEDIDO').format(CHAVE_API_PEDIDO)

GRAVA_EVIDENCIA = obter_variavel('GRAVA_EVIDENCIA')
EVIDENCIA_URL = '{}{}'.format(API_URL, obter_variavel('EVIDENCIA_URL'))
EVIDENCIA_USA_AUTENTICACAO_HEADER = obter_variavel('EVIDENCIA_USA_AUTENTICACAO_HEADER')
EVIDENCIA_AUTENTICACAO = obter_variavel('EVIDENCIA_AUTENTICACAO').format(CHAVE_API_PLATAFORMA)

PAYPAL_VERSION = obter_variavel('PAYPAL_VERSION')
