#!/usr/bin/env python
"""
Copyright 2012 GroupDocs.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from .models import *
from groupdocs.FileStream import FileStream
from groupdocs.ApiClient import ApiException

class SignatureApi(object):

    def __init__(self, apiClient):
        self.apiClient = apiClient
        self.__basePath = "https://api.groupdocs.com/v2.0"

    @property
    def basePath(self):
        return self.__basePath
    
    @basePath.setter
    def basePath(self, value):
        self.__basePath = value

    
    def GetSignatureTemplateRecipients(self, userId, templateGuid, **kwargs):
        """Get template recipients

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            
        Returns: SignatureTemplateRecipientsResponse
        """
        if( userId == None or templateGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureTemplateRecipients" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/recipients'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateRecipientsResponse')
        return responseObject
        
        
    def DeleteSignatureTemplateRecipient(self, userId, templateGuid, recipientGuid, **kwargs):
        """Remove recipient from template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or templateGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureTemplateRecipient" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/recipients/{recipientGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def ModifySignatureTemplateRecipient(self, userId, templateGuid, recipientGuid, nickname, roleGuid, **kwargs):
        """Update template recipient

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            recipientGuid, str: Recipient GUID (required)
            nickname, str: Nickname of the recipient (required)
            roleGuid, str: Role GUID (required)
            order, str: Display order of the recipient (optional)
            
        Returns: SignatureTemplateRecipientResponse
        """
        if( userId == None or templateGuid == None or recipientGuid == None or nickname == None or roleGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'recipientGuid', 'nickname', 'roleGuid', 'order']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureTemplateRecipient" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/recipient/{recipientGuid}?nickname={nickname}&role={roleGuid}&order={order}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('nickname' in params):
            queryParams['nickname'] = self.apiClient.toPathValue(params['nickname'])
        if ('roleGuid' in params):
            queryParams['role'] = self.apiClient.toPathValue(params['roleGuid'])
        if ('order' in params):
            queryParams['order'] = self.apiClient.toPathValue(params['order'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateRecipientResponse')
        return responseObject
        
        
    def AddSignatureTemplateDocument(self, userId, templateGuid, documentGuid, **kwargs):
        """Add document to template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            documentGuid, str: Document GUID (required)
            order, int: Display order of the document (optional)
            parseFields, bool: Try to parse fields in document (optional)
            
        Returns: SignatureTemplateDocumentResponse
        """
        if( userId == None or templateGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'documentGuid', 'order', 'parseFields']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddSignatureTemplateDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/document/{documentGuid}?parseFields={parseFields}&order={order}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('order' in params):
            queryParams['order'] = self.apiClient.toPathValue(params['order'])
        if ('parseFields' in params):
            queryParams['parseFields'] = self.apiClient.toPathValue(params['parseFields'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateDocumentResponse')
        return responseObject
        
        
    def GetSignatureTemplateDocuments(self, userId, templateGuid, **kwargs):
        """Get documents in template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            
        Returns: SignatureTemplateDocumentsResponse
        """
        if( userId == None or templateGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureTemplateDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/documents'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateDocumentsResponse')
        return responseObject
        
        
    def DeleteSignatureTemplateDocument(self, userId, templateGuid, documentGuid, **kwargs):
        """Remove document from template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            documentGuid, str: Document GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or templateGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'documentGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureTemplateDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def AddSignatureTemplateField(self, userId, templateGuid, documentGuid, recipientGuid, fieldGuid, **kwargs):
        """Add signature template field

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            documentGuid, str: Document GUID (required)
            recipientGuid, str: Recipient GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureTemplateFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureTemplateFieldResponse
        """
        if( userId == None or templateGuid == None or documentGuid == None or recipientGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'documentGuid', 'recipientGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddSignatureTemplateField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}/recipient/{recipientGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateFieldResponse')
        return responseObject
        
        
    def AssignSignatureTemplateField(self, userId, templateGuid, documentGuid, fieldGuid, **kwargs):
        """Assign signature template field

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            documentGuid, str: Document GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureTemplateAssignFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureTemplateFieldResponse
        """
        if( userId == None or templateGuid == None or documentGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'documentGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AssignSignatureTemplateField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateFieldResponse')
        return responseObject
        
        
    def ModifySignatureTemplateField(self, userId, templateGuid, documentGuid, fieldGuid, **kwargs):
        """Modify signature template field

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            documentGuid, str: Document GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureTemplateFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureTemplateFieldResponse
        """
        if( userId == None or templateGuid == None or documentGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'documentGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureTemplateField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateFieldResponse')
        return responseObject
        
        
    def DeleteSignatureTemplateFieldLocation(self, userId, templateGuid, fieldGuid, locationGuid, **kwargs):
        """Delete signature template field location

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            fieldGuid, str: Field GUID (required)
            locationGuid, str: Field location GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or templateGuid == None or fieldGuid == None or locationGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'fieldGuid', 'locationGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureTemplateFieldLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/fields/{fieldGuid}/locations/{locationGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        if ('locationGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['locationGuid']))
            resourcePath = resourcePath.replace('{' + 'locationGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def ModifySignatureTemplateFieldLocation(self, userId, templateGuid, documentGuid, recipientGuid, fieldGuid, locationGuid, **kwargs):
        """Modify signature template field location

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            documentGuid, str: Document GUID (required)
            recipientGuid, str: Recipient GUID (required)
            fieldGuid, str: Field GUID (required)
            locationGuid, str: Field location GUID (required)
            body, SignatureTemplateFieldLocationSettingsInfo: Settings of the field location (optional)
            
        Returns: SignatureTemplateFieldResponse
        """
        if( userId == None or templateGuid == None or documentGuid == None or recipientGuid == None or fieldGuid == None or locationGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'documentGuid', 'recipientGuid', 'fieldGuid', 'locationGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureTemplateFieldLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/documents/{documentGuid}/recipient/{recipientGuid}/fields/{fieldGuid}/locations/{locationGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        if ('locationGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['locationGuid']))
            resourcePath = resourcePath.replace('{' + 'locationGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateFieldResponse')
        return responseObject
        
        
    def GetSignatureTemplateFields(self, userId, templateGuid, **kwargs):
        """Get template fields

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            documentGuid, str: Document GUID (optional)
            recipientGuid, str: Recipient GUID (optional)
            
        Returns: SignatureTemplateFieldsResponse
        """
        if( userId == None or templateGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'documentGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureTemplateFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/fields?document={documentGuid}&recipient={recipientGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('documentGuid' in params):
            queryParams['document'] = self.apiClient.toPathValue(params['documentGuid'])
        if ('recipientGuid' in params):
            queryParams['recipient'] = self.apiClient.toPathValue(params['recipientGuid'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateFieldsResponse')
        return responseObject
        
        
    def DeleteSignatureTemplateField(self, userId, templateGuid, fieldGuid, **kwargs):
        """Delete signature template field

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            fieldGuid, str: Field GUID (required)
            
        Returns: SignatureTemplateResponse
        """
        if( userId == None or templateGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'fieldGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureTemplateField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/fields/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateResponse')
        return responseObject
        
        
    def GetSignatureTemplateResources(self, userId, **kwargs):
        """Get template resources

        Args:
            userId, str: User GUID (required)
            
        Returns: SignatureTemplateResourcesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureTemplateResources" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/resources'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateResourcesResponse')
        return responseObject
        
        
    def RenameSignatureTemplateDocument(self, userId, templateGuid, documentGuid, **kwargs):
        """Rename signature template document

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            documentGuid, str: Template Document GUID (required)
            newName, str: New name of the document (optional)
            
        Returns: SignatureTemplateDocumentResponse
        """
        if( userId == None or templateGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'documentGuid', 'newName']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RenameSignatureTemplateDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/document/{documentGuid}?newName={newName}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('newName' in params):
            queryParams['newName'] = self.apiClient.toPathValue(params['newName'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateDocumentResponse')
        return responseObject
        
        
    def GetContacts(self, userId, **kwargs):
        """Get contacts

        Args:
            userId, str: User GUID (required)
            page, int: Page number (optional)
            records, int: Records count to be returned (optional)
            firstName, str: Filter by firstName (optional)
            lastName, str: Filter by lastName (optional)
            email, str: Filter by email (optional)
            
        Returns: SignatureContactsResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'page', 'records', 'firstName', 'lastName', 'email']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetContacts" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/contacts?firstName={firstName}&lastName={lastName}&email={email}&records={records}&page={page}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('page' in params):
            queryParams['page'] = self.apiClient.toPathValue(params['page'])
        if ('records' in params):
            queryParams['records'] = self.apiClient.toPathValue(params['records'])
        if ('firstName' in params):
            queryParams['firstName'] = self.apiClient.toPathValue(params['firstName'])
        if ('lastName' in params):
            queryParams['lastName'] = self.apiClient.toPathValue(params['lastName'])
        if ('email' in params):
            queryParams['email'] = self.apiClient.toPathValue(params['email'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureContactsResponse')
        return responseObject
        
        
    def AddContact(self, userId, body, **kwargs):
        """Add contact

        Args:
            userId, str: User GUID (required)
            body, SignatureContactSettingsInfo: Contact data (required)
            
        Returns: SignatureContactResponse
        """
        if( userId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddContact" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/contact'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureContactResponse')
        return responseObject
        
        
    def ModifyContact(self, userId, contactGuid, **kwargs):
        """Update contact

        Args:
            userId, str: User GUID (required)
            contactGuid, str: Contact GUID (required)
            body, SignatureContactSettingsInfo: Contact data (optional)
            
        Returns: SignatureContactResponse
        """
        if( userId == None or contactGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'contactGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifyContact" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/contacts/{contactGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('contactGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['contactGuid']))
            resourcePath = resourcePath.replace('{' + 'contactGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureContactResponse')
        return responseObject
        
        
    def DeleteContact(self, userId, contactGuid, **kwargs):
        """Delete contact

        Args:
            userId, str: User GUID (required)
            contactGuid, str: Contact GUID (required)
            
        Returns: SignatureContactResponse
        """
        if( userId == None or contactGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'contactGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteContact" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/contacts/{contactGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('contactGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['contactGuid']))
            resourcePath = resourcePath.replace('{' + 'contactGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureContactResponse')
        return responseObject
        
        
    def ImportContacts(self, userId, **kwargs):
        """Import contacts

        Args:
            userId, str: User GUID (required)
            body, List[SignatureContactSettingsInfo]: Array of SignatureContactSettingsInfo (optional)
            
        Returns: SignatureContactsImportResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ImportContacts" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/contacts'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureContactsImportResponse')
        return responseObject
        
        
    def AddContactIntegration(self, userId, **kwargs):
        """Add Contact Integration Authorization

        Args:
            userId, str: User GUID (required)
            body, SignatureContactIntegrationSettings: Authorization settings (optional)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddContactIntegration" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/integration'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def SignDocument(self, userId, **kwargs):
        """Sign document

        Args:
            userId, str: User GUID (required)
            body, SignatureSignDocumentSettingsInfo: Settings of the signing document (optional)
            
        Returns: SignatureSignDocumentResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SignDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/sign'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureSignDocumentResponse')
        return responseObject
        
        
    def GetSignDocumentStatus(self, userId, jobGuid, **kwargs):
        """Get sign documents status

        Args:
            userId, str: User GUID (required)
            jobGuid, str: Job GUID (required)
            
        Returns: SignatureSignDocumentStatusResponse
        """
        if( userId == None or jobGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'jobGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignDocumentStatus" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/documents/{jobGuid}/status'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['jobGuid']))
            resourcePath = resourcePath.replace('{' + 'jobGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureSignDocumentStatusResponse')
        return responseObject
        
        
    def ArchiveSignatureEnvelope(self, userId, envelopeGuid, **kwargs):
        """Archive envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ArchiveSignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/archive'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetEnvelopeAuditLogs(self, userId, envelopeGuid, **kwargs):
        """Get envelope audit logs

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureEnvelopeAuditLogsResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetEnvelopeAuditLogs" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/logs'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeAuditLogsResponse')
        return responseObject
        
        
    def CreateSignatureEnvelope(self, userId, **kwargs):
        """Create signature envelope

        Args:
            userId, str: User GUID (required)
            name, str: Envelope name (optional)
            templateGuid, str: A templateGuid of the template which will be used to created the new envelope (optional)
            envelopeGuid, str: A envelopeGuid of the envelope which will be used to created the new envelope (optional)
            documentGuid, str: A documentGuid of the document which will be added to the new created envelope (optional)
            parseFields, bool: Try to parse fields in document (optional)
            body, SignatureEnvelopeSettingsInfo: Settings of the new envelope (optional)
            
        Returns: SignatureEnvelopeResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'name', 'templateGuid', 'envelopeGuid', 'documentGuid', 'parseFields', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateSignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelope?name={name}&templateId={templateGuid}&envelopeId={envelopeGuid}&documentId={documentGuid}&parseFields={parseFields}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('templateGuid' in params):
            queryParams['templateId'] = self.apiClient.toPathValue(params['templateGuid'])
        if ('envelopeGuid' in params):
            queryParams['envelopeId'] = self.apiClient.toPathValue(params['envelopeGuid'])
        if ('documentGuid' in params):
            queryParams['documentId'] = self.apiClient.toPathValue(params['documentGuid'])
        if ('parseFields' in params):
            queryParams['parseFields'] = self.apiClient.toPathValue(params['parseFields'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeResponse')
        return responseObject
        
        
    def DeclineEnvelope(self, userId, envelopeGuid, recipientGuid, **kwargs):
        """Decline envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeclineEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/recipient/{recipientGuid}/decline'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def DelegateEnvelopeRecipient(self, userId, envelopeGuid, recipientGuid, recipientEmail, recipientFirstName, recipientLastName, **kwargs):
        """Delegate envelope recipient

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            recipientEmail, str: Delegated recipient email (required)
            recipientFirstName, str: Delegated recipient first name (required)
            recipientLastName, str: Delegated recipient last name (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None or recipientGuid == None or recipientEmail == None or recipientFirstName == None or recipientLastName == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'recipientGuid', 'recipientEmail', 'recipientFirstName', 'recipientLastName']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DelegateEnvelopeRecipient" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/recipient/{recipientGuid}/delegate?email={recipientEmail}&firstname={recipientFirstName}&lastname={recipientLastName}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('recipientEmail' in params):
            queryParams['email'] = self.apiClient.toPathValue(params['recipientEmail'])
        if ('recipientFirstName' in params):
            queryParams['firstname'] = self.apiClient.toPathValue(params['recipientFirstName'])
        if ('recipientLastName' in params):
            queryParams['lastname'] = self.apiClient.toPathValue(params['recipientLastName'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def DeleteSignatureEnvelope(self, userId, envelopeGuid, **kwargs):
        """Delete signature envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def AddSignatureEnvelopeDocument(self, userId, envelopeGuid, documentGuid, **kwargs):
        """Add document in envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            order, int: Document order (optional)
            parseFields, bool: Try to parse fields in document (optional)
            
        Returns: SignatureEnvelopeDocumentResponse
        """
        if( userId == None or envelopeGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid', 'order', 'parseFields']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddSignatureEnvelopeDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/document/{documentGuid}?parseFields={parseFields}&order={order}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('order' in params):
            queryParams['order'] = self.apiClient.toPathValue(params['order'])
        if ('parseFields' in params):
            queryParams['parseFields'] = self.apiClient.toPathValue(params['parseFields'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeDocumentResponse')
        return responseObject
        
        
    def GetSignedEnvelopeDocument(self, userId, envelopeGuid, documentGuid, **kwargs):
        """Get signed envelope document

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            
        Returns: stream
        """
        if( userId == None or envelopeGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignedEnvelopeDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/document/{documentGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def DeleteSignatureEnvelopeDocument(self, userId, envelopeGuid, documentGuid, **kwargs):
        """Delete document from envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureEnvelopeDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetSignatureEnvelopeDocuments(self, userId, envelopeGuid, **kwargs):
        """Get documents in envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureEnvelopeDocumentsResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureEnvelopeDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/documents'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeDocumentsResponse')
        return responseObject
        
        
    def GetSignedEnvelopeDocuments(self, userId, envelopeGuid, **kwargs):
        """Get signed envelope documents

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: stream
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignedEnvelopeDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/documents/get'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def AddSignatureEnvelopeField(self, userId, envelopeGuid, documentGuid, recipientGuid, fieldGuid, **kwargs):
        """Add signature field for document in envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            recipientGuid, str: Recipient GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureEnvelopeFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureEnvelopeFieldsResponse
        """
        if( userId == None or envelopeGuid == None or documentGuid == None or recipientGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid', 'recipientGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddSignatureEnvelopeField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeFieldsResponse')
        return responseObject
        
        
    def AssignSignatureEnvelopeField(self, userId, envelopeGuid, documentGuid, fieldGuid, **kwargs):
        """Assign signature envelope field

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureEnvelopeAssignFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureEnvelopeFieldResponse
        """
        if( userId == None or envelopeGuid == None or documentGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AssignSignatureEnvelopeField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeFieldResponse')
        return responseObject
        
        
    def FillEnvelopeField(self, userId, envelopeGuid, documentGuid, recipientGuid, fieldGuid, **kwargs):
        """Fill envelope field

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            recipientGuid, str: Recipient GUID (required)
            fieldGuid, str: Field GUID (required)
            signatureGuid, str: SignatureId GUID (optional)
            body, stream: Data to be placed in field (optional)
            
        Returns: SignatureEnvelopeFieldResponse
        """
        if( userId == None or envelopeGuid == None or documentGuid == None or recipientGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid', 'recipientGuid', 'fieldGuid', 'signatureGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method FillEnvelopeField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/field/{fieldGuid}?signatureId={signatureGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('signatureGuid' in params):
            queryParams['signatureId'] = self.apiClient.toPathValue(params['signatureGuid'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeFieldResponse')
        return responseObject
        
        
    def ModifySignatureEnvelopeFieldLocation(self, userId, envelopeGuid, documentGuid, recipientGuid, fieldGuid, locationGuid, **kwargs):
        """Modify signature envelope field location

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            recipientGuid, str: Recipient GUID (required)
            fieldGuid, str: Field GUID (required)
            locationGuid, str: Field location GUID (required)
            body, SignatureEnvelopeFieldLocationSettingsInfo: Settings of the field location (optional)
            
        Returns: SignatureEnvelopeFieldResponse
        """
        if( userId == None or envelopeGuid == None or documentGuid == None or recipientGuid == None or fieldGuid == None or locationGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid', 'recipientGuid', 'fieldGuid', 'locationGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureEnvelopeFieldLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/fields/{fieldGuid}/locations/{locationGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        if ('locationGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['locationGuid']))
            resourcePath = resourcePath.replace('{' + 'locationGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeFieldResponse')
        return responseObject
        
        
    def DeleteSignatureEnvelopeFieldLocation(self, userId, envelopeGuid, fieldGuid, locationGuid, **kwargs):
        """Remove signature envelope field location

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            fieldGuid, str: Field GUID (required)
            locationGuid, str: Field location GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None or fieldGuid == None or locationGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'fieldGuid', 'locationGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureEnvelopeFieldLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/fields/{fieldGuid}/locations/{locationGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        if ('locationGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['locationGuid']))
            resourcePath = resourcePath.replace('{' + 'locationGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def ModifySignatureEnvelopeField(self, userId, envelopeGuid, documentGuid, fieldGuid, **kwargs):
        """Modify signature envelope field

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureEnvelopeFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureEnvelopeFieldResponse
        """
        if( userId == None or envelopeGuid == None or documentGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureEnvelopeField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/documents/{documentGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeFieldResponse')
        return responseObject
        
        
    def DeleteSignatureEnvelopeField(self, userId, envelopeGuid, fieldGuid, **kwargs):
        """Delete signature envelope field

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            fieldGuid, str: Field GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'fieldGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureEnvelopeField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/fields/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetSignatureEnvelopeFields(self, userId, envelopeGuid, **kwargs):
        """Get signature field for document in envelope per recipient

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (optional)
            recipientGuid, str: Recipient GUID (optional)
            
        Returns: SignatureEnvelopeFieldsResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureEnvelopeFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/fields?document={documentGuid}&recipient={recipientGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('documentGuid' in params):
            queryParams['document'] = self.apiClient.toPathValue(params['documentGuid'])
        if ('recipientGuid' in params):
            queryParams['recipient'] = self.apiClient.toPathValue(params['recipientGuid'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeFieldsResponse')
        return responseObject
        
        
    def GetSignatureEnvelope(self, userId, envelopeGuid, **kwargs):
        """Get signature envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureEnvelopeResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeResponse')
        return responseObject
        
        
    def ModifySignatureEnvelope(self, userId, envelopeGuid, **kwargs):
        """Modify signature envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            body, SignatureEnvelopeSettingsInfo: Settings of the envelope (optional)
            
        Returns: SignatureEnvelopeResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeResponse')
        return responseObject
        
        
    def AddSignatureEnvelopeRecipient(self, userId, envelopeGuid, recipientEmail, recipientFirstName, recipientLastName, roleGuid, **kwargs):
        """Add signature envelope recipient

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            recipientEmail, str: Recipient email (required)
            recipientFirstName, str: Recipient first name (required)
            recipientLastName, str: Recipient last name (required)
            roleGuid, str: Recipient role GUID (required)
            order, int: Recipient order (optional)
            
        Returns: SignatureEnvelopeRecipientResponse
        """
        if( userId == None or envelopeGuid == None or recipientEmail == None or recipientFirstName == None or recipientLastName == None or roleGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'recipientEmail', 'recipientFirstName', 'recipientLastName', 'roleGuid', 'order']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddSignatureEnvelopeRecipient" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/recipient?email={recipientEmail}&firstname={recipientFirstName}&lastname={recipientLastName}&role={roleGuid}&order={order}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('recipientEmail' in params):
            queryParams['email'] = self.apiClient.toPathValue(params['recipientEmail'])
        if ('recipientFirstName' in params):
            queryParams['firstname'] = self.apiClient.toPathValue(params['recipientFirstName'])
        if ('recipientLastName' in params):
            queryParams['lastname'] = self.apiClient.toPathValue(params['recipientLastName'])
        if ('roleGuid' in params):
            queryParams['role'] = self.apiClient.toPathValue(params['roleGuid'])
        if ('order' in params):
            queryParams['order'] = self.apiClient.toPathValue(params['order'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeRecipientResponse')
        return responseObject
        
        
    def ModifySignatureEnvelopeRecipient(self, userId, envelopeGuid, recipientGuid, recipientEmail, recipientFirstName, recipientLastName, roleGuid, **kwargs):
        """Modify signature envelope recipient

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            recipientEmail, str: Recipient email (required)
            recipientFirstName, str: Recipient first name (required)
            recipientLastName, str: Recipient last name (required)
            roleGuid, str: Recipient role GUID (required)
            order, int: Recipient order (optional)
            
        Returns: SignatureEnvelopeRecipientResponse
        """
        if( userId == None or envelopeGuid == None or recipientGuid == None or recipientEmail == None or recipientFirstName == None or recipientLastName == None or roleGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'recipientGuid', 'recipientEmail', 'recipientFirstName', 'recipientLastName', 'roleGuid', 'order']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureEnvelopeRecipient" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/recipient/{recipientGuid}?email={recipientEmail}&firstname={recipientFirstName}&lastname={recipientLastName}&role={roleGuid}&order={order}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('recipientEmail' in params):
            queryParams['email'] = self.apiClient.toPathValue(params['recipientEmail'])
        if ('recipientFirstName' in params):
            queryParams['firstname'] = self.apiClient.toPathValue(params['recipientFirstName'])
        if ('recipientLastName' in params):
            queryParams['lastname'] = self.apiClient.toPathValue(params['recipientLastName'])
        if ('roleGuid' in params):
            queryParams['role'] = self.apiClient.toPathValue(params['roleGuid'])
        if ('order' in params):
            queryParams['order'] = self.apiClient.toPathValue(params['order'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeRecipientResponse')
        return responseObject
        
        
    def DeleteSignatureEnvelopeRecipient(self, userId, envelopeGuid, recipientGuid, **kwargs):
        """Delete signature envelope recipient

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureEnvelopeRecipient" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/recipients/{recipientGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetSignatureEnvelopeRecipients(self, userId, envelopeGuid, **kwargs):
        """Get signature envelope recipients

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureEnvelopeRecipientsResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureEnvelopeRecipients" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/recipients'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeRecipientsResponse')
        return responseObject
        
        
    def RenameSignatureEnvelope(self, userId, envelopeGuid, name, **kwargs):
        """Rename signature envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            name, str: New envelope name (required)
            
        Returns: SignatureEnvelopeResponse
        """
        if( userId == None or envelopeGuid == None or name == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'name']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RenameSignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}?name={name}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeResponse')
        return responseObject
        
        
    def RestartExpiredSignatureEnvelope(self, userId, envelopeGuid, **kwargs):
        """Restart expired envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RestartExpiredSignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/restart'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def SignatureEnvelopeSend(self, userId, envelopeGuid, **kwargs):
        """Send envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            body, WebhookInfo: Webhook Callback Url (optional)
            
        Returns: SignatureEnvelopeSendResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SignatureEnvelopeSend" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/send'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeSendResponse')
        return responseObject
        
        
    def SignEnvelope(self, userId, envelopeGuid, recipientGuid, **kwargs):
        """Sign envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SignEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/recipient/{recipientGuid}/sign'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetSignatureEnvelopes(self, userId, **kwargs):
        """Get signature envelopes

        Args:
            userId, str: User GUID (required)
            statusId, int: Filter envelopes by statusId (optional)
            page, int: Show records for page number (optional)
            records, int: Show records count (optional)
            originalDocumentMD5, str: Filter envelopes by original document md5 checksum (optional)
            recipientEmail, str: Filter envelopes by recipient email (optional)
            datetime, str: Filter envelopes by date (optional)
            name, str: Filter envelopes by name (optional)
            
        Returns: SignatureEnvelopesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'statusId', 'page', 'records', 'originalDocumentMD5', 'recipientEmail', 'datetime', 'name']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureEnvelopes" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes?statusId={statusId}&records={records}&page={page}&document={originalDocumentMD5}&recipient={recipientEmail}&date={date}&name={name}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('statusId' in params):
            queryParams['statusId'] = self.apiClient.toPathValue(params['statusId'])
        if ('page' in params):
            queryParams['page'] = self.apiClient.toPathValue(params['page'])
        if ('records' in params):
            queryParams['records'] = self.apiClient.toPathValue(params['records'])
        if ('originalDocumentMD5' in params):
            queryParams['document'] = self.apiClient.toPathValue(params['originalDocumentMD5'])
        if ('recipientEmail' in params):
            queryParams['recipient'] = self.apiClient.toPathValue(params['recipientEmail'])
        if ('datetime' in params):
            queryParams['date'] = self.apiClient.toPathValue(params['datetime'])
        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopesResponse')
        return responseObject
        
        
    def GetSignatureEnvelopeResources(self, userId, **kwargs):
        """Get envelope resources

        Args:
            userId, str: User GUID (required)
            statusIds, str: Envelope status identifier - comma separated list (optional)
            
        Returns: SignatureEnvelopeResourcesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'statusIds']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureEnvelopeResources" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/resources?statusIds={statusIds}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('statusIds' in params):
            queryParams['statusIds'] = self.apiClient.toPathValue(params['statusIds'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeResourcesResponse')
        return responseObject
        
        
    def GetRecipientSignatureEnvelopes(self, userId, **kwargs):
        """Get signature envelopes where the user is recipient

        Args:
            userId, str: User GUID (required)
            statusId, str: Filter envelopes by statusId (optional)
            page, int: Show records for page number (optional)
            records, int: Show records count (optional)
            
        Returns: SignatureEnvelopesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'statusId', 'page', 'records']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetRecipientSignatureEnvelopes" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/recipient?statusId={statusId}&records={records}&page={page}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('statusId' in params):
            queryParams['statusId'] = self.apiClient.toPathValue(params['statusId'])
        if ('page' in params):
            queryParams['page'] = self.apiClient.toPathValue(params['page'])
        if ('records' in params):
            queryParams['records'] = self.apiClient.toPathValue(params['records'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopesResponse')
        return responseObject
        
        
    def RenameSignatureEnvelopeDocument(self, userId, envelopeGuid, documentGuid, **kwargs):
        """Rename signature envelope document

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            newName, str: New name of the document (optional)
            
        Returns: SignatureEnvelopeDocumentResponse
        """
        if( userId == None or envelopeGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid', 'documentGuid', 'newName']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RenameSignatureEnvelopeDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/document/{documentGuid}?newName={newName}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('newName' in params):
            queryParams['newName'] = self.apiClient.toPathValue(params['newName'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeDocumentResponse')
        return responseObject
        
        
    def CancelSignatureEnvelope(self, userId, envelopeGuid, **kwargs):
        """Cancel envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CancelSignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/cancel'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def RetrySignEnvelope(self, userId, envelopeGuid, **kwargs):
        """Retry sign envelope

        Args:
            userId, str: User GUID (required)
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RetrySignEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/envelopes/{envelopeGuid}/retry'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetFieldsList(self, userId, **kwargs):
        """Get signature fields

        Args:
            userId, str: User GUID (required)
            fieldGuid, str: Filter fields by id (optional)
            
        Returns: SignatureFieldsResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fieldGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetFieldsList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/fields?id={fieldGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('fieldGuid' in params):
            queryParams['id'] = self.apiClient.toPathValue(params['fieldGuid'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFieldsResponse')
        return responseObject
        
        
    def CreateSignatureField(self, userId, **kwargs):
        """Create signature field

        Args:
            userId, str: User GUID (required)
            body, SignatureFieldSettingsInfo: Settings of the new field (optional)
            
        Returns: SignatureFieldResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateSignatureField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/field'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFieldResponse')
        return responseObject
        
        
    def ModifySignatureField(self, userId, fieldGuid, **kwargs):
        """Modify signature field

        Args:
            userId, str: User GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureFieldResponse
        """
        if( userId == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/fields/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFieldResponse')
        return responseObject
        
        
    def DeleteSignatureField(self, userId, fieldGuid, **kwargs):
        """Delete signature field

        Args:
            userId, str: User GUID (required)
            fieldGuid, str: Field GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fieldGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/fields/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def ArchiveSignatureForm(self, userId, formGuid, **kwargs):
        """Archive signature form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ArchiveSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/archive'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def CompleteSignatureForm(self, userId, formGuid, **kwargs):
        """Complete signature form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CompleteSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/complete'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def CreateSignatureForm(self, userId, **kwargs):
        """Create signature form

        Args:
            userId, str: User GUID (required)
            name, str: Form name (optional)
            templateGuid, str: A templateGuid of the template which will be used to created the new form (optional)
            assemblyGuid, str: A guid of the assembly which will be used to created the new form (optional)
            formGuid, str: A formGuid of the form which will be used to created the new form (optional)
            body, SignatureFormSettingsInfo: Settings of the new form (optional)
            
        Returns: SignatureFormResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'name', 'templateGuid', 'assemblyGuid', 'formGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/form?name={name}&templateId={templateGuid}&assemblyId={assemblyGuid}&formId={formGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('templateGuid' in params):
            queryParams['templateId'] = self.apiClient.toPathValue(params['templateGuid'])
        if ('assemblyGuid' in params):
            queryParams['assemblyId'] = self.apiClient.toPathValue(params['assemblyGuid'])
        if ('formGuid' in params):
            queryParams['formId'] = self.apiClient.toPathValue(params['formGuid'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormResponse')
        return responseObject
        
        
    def DeleteSignatureForm(self, userId, formGuid, **kwargs):
        """Delete signature form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def AddSignatureFormDocument(self, userId, formGuid, documentGuid, **kwargs):
        """Add document in form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            documentGuid, str: Document GUID (required)
            order, int: Document order (optional)
            parseFields, bool: Try to parse fields in document (optional)
            
        Returns: SignatureFormDocumentResponse
        """
        if( userId == None or formGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'documentGuid', 'order', 'parseFields']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddSignatureFormDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/document/{documentGuid}?parseFields={parseFields}&order={order}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('order' in params):
            queryParams['order'] = self.apiClient.toPathValue(params['order'])
        if ('parseFields' in params):
            queryParams['parseFields'] = self.apiClient.toPathValue(params['parseFields'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormDocumentResponse')
        return responseObject
        
        
    def DeleteSignatureFormDocument(self, userId, formGuid, documentGuid, **kwargs):
        """Delete document from form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            documentGuid, str: Document GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or formGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'documentGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureFormDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/documents/{documentGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetSignatureFormDocuments(self, userId, formGuid, **kwargs):
        """Get documents in form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            
        Returns: SignatureFormDocumentsResponse
        """
        if( userId == None or formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureFormDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/documents'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormDocumentsResponse')
        return responseObject
        
        
    def AddSignatureFormField(self, userId, formGuid, documentGuid, fieldGuid, **kwargs):
        """Add signature field for document in form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            documentGuid, str: Document GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureFormFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureFormFieldResponse
        """
        if( userId == None or formGuid == None or documentGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'documentGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddSignatureFormField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/documents/{documentGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormFieldResponse')
        return responseObject
        
        
    def ModifySignatureFormFieldLocation(self, userId, formGuid, documentGuid, fieldGuid, locationGuid, **kwargs):
        """Modify signature form field location

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            documentGuid, str: Document GUID (required)
            fieldGuid, str: Field GUID (required)
            locationGuid, str: Field location GUID (required)
            body, SignatureFormFieldLocationSettingsInfo: Settings of the field location (optional)
            
        Returns: SignatureFormFieldResponse
        """
        if( userId == None or formGuid == None or documentGuid == None or fieldGuid == None or locationGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'documentGuid', 'fieldGuid', 'locationGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureFormFieldLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/documents/{documentGuid}/fields/{fieldGuid}/locations/{locationGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        if ('locationGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['locationGuid']))
            resourcePath = resourcePath.replace('{' + 'locationGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormFieldResponse')
        return responseObject
        
        
    def DeleteSignatureFormFieldLocation(self, userId, formGuid, fieldGuid, locationGuid, **kwargs):
        """Remove signature form field location

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            fieldGuid, str: Field GUID (required)
            locationGuid, str: Field location GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or formGuid == None or fieldGuid == None or locationGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'fieldGuid', 'locationGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureFormFieldLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/fields/{fieldGuid}/locations/{locationGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        if ('locationGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['locationGuid']))
            resourcePath = resourcePath.replace('{' + 'locationGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def ModifySignatureFormField(self, userId, formGuid, documentGuid, fieldGuid, **kwargs):
        """Modify signature form field

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            documentGuid, str: Document GUID (required)
            fieldGuid, str: Field GUID (required)
            body, SignatureFormFieldSettingsInfo: Settings of the field (optional)
            
        Returns: SignatureFormFieldResponse
        """
        if( userId == None or formGuid == None or documentGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'documentGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureFormField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/documents/{documentGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormFieldResponse')
        return responseObject
        
        
    def DeleteSignatureFormField(self, userId, formGuid, fieldGuid, **kwargs):
        """Delete signature form field

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            fieldGuid, str: Field GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or formGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'fieldGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureFormField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/fields/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetSignatureFormFields(self, userId, formGuid, documentGuid, **kwargs):
        """Get form fields for document in form per participant

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            documentGuid, str: Document GUID (required)
            
        Returns: SignatureFormFieldsResponse
        """
        if( userId == None or formGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'documentGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureFormFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/documents/{documentGuid}/fields'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormFieldsResponse')
        return responseObject
        
        
    def GetSignatureForm(self, userId, formGuid, **kwargs):
        """Get signature form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            
        Returns: SignatureFormResponse
        """
        if( userId == None or formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormResponse')
        return responseObject
        
        
    def ModifySignatureForm(self, userId, formGuid, **kwargs):
        """Modify signature form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            body, SignatureFormSettingsInfo: Settings of the form (optional)
            
        Returns: SignatureFormResponse
        """
        if( userId == None or formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormResponse')
        return responseObject
        
        
    def PublishSignatureForm(self, userId, formGuid, **kwargs):
        """Publish signature form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            body, WebhookInfo: Webhook Callback Url (optional)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublishSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/publish'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def RenameSignatureForm(self, userId, formGuid, name, **kwargs):
        """Rename signature form

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            name, str: New form name (required)
            
        Returns: SignatureFormResponse
        """
        if( userId == None or formGuid == None or name == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'name']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RenameSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}?new_name={name}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('name' in params):
            queryParams['new_name'] = self.apiClient.toPathValue(params['name'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormResponse')
        return responseObject
        
        
    def UpdateSignatureFormFromTemplate(self, userId, formGuid, templateGuid, **kwargs):
        """Add signature form fields from template

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            templateGuid, str: Template GUID (required)
            
        Returns: SignatureFormResponse
        """
        if( userId == None or formGuid == None or templateGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'templateGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateSignatureFormFromTemplate" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/templates/{templateGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormResponse')
        return responseObject
        
        
    def GetSignatureForms(self, userId, **kwargs):
        """Get signature forms

        Args:
            userId, str: User GUID (required)
            statusId, int: Filter forms by statusId (optional)
            page, int: Show records for page number (optional)
            records, int: Show records count (optional)
            originalDocumentMD5, str: Filter forms by original document MD5 (optional)
            datetime, str: Filter forms by date (optional)
            name, str: Filter forms by name (optional)
            
        Returns: SignatureFormsResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'statusId', 'page', 'records', 'originalDocumentMD5', 'datetime', 'name']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureForms" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms?statusId={statusId}&records={records}&page={page}&document={originalDocumentMD5}&date={date}&name={name}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('statusId' in params):
            queryParams['statusId'] = self.apiClient.toPathValue(params['statusId'])
        if ('page' in params):
            queryParams['page'] = self.apiClient.toPathValue(params['page'])
        if ('records' in params):
            queryParams['records'] = self.apiClient.toPathValue(params['records'])
        if ('originalDocumentMD5' in params):
            queryParams['document'] = self.apiClient.toPathValue(params['originalDocumentMD5'])
        if ('datetime' in params):
            queryParams['date'] = self.apiClient.toPathValue(params['datetime'])
        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormsResponse')
        return responseObject
        
        
    def GetSignatureFormResources(self, userId, statusIds, **kwargs):
        """Get form resources

        Args:
            userId, str: User GUID (required)
            statusIds, str: Form status identifier - comma separated list (required)
            
        Returns: SignatureFormResourcesResponse
        """
        if( userId == None or statusIds == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'statusIds']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureFormResources" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/resources?statusIds={statusIds}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('statusIds' in params):
            queryParams['statusIds'] = self.apiClient.toPathValue(params['statusIds'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormResourcesResponse')
        return responseObject
        
        
    def GetSignedFormDocuments(self, userId, formGuid, **kwargs):
        """Get signed form documents

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            
        Returns: stream
        """
        if( userId == None or formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignedFormDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/documents/get'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def RenameSignatureFormDocument(self, userId, formGuid, documentGuid, **kwargs):
        """Rename signature form document

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            documentGuid, str: Form Document GUID (required)
            newName, str: New name of the document (optional)
            
        Returns: SignatureFormDocumentResponse
        """
        if( userId == None or formGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'documentGuid', 'newName']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RenameSignatureFormDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/document/{documentGuid}?newName={newName}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('newName' in params):
            queryParams['newName'] = self.apiClient.toPathValue(params['newName'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormDocumentResponse')
        return responseObject
        
        
    def ModifySignatureFormDocument(self, userId, formGuid, documentGuid, **kwargs):
        """Modify signature form document

        Args:
            userId, str: User GUID (required)
            formGuid, str: Form GUID (required)
            documentGuid, str: Form Document GUID (required)
            body, SignatureFormDocumentSettingsInfo: Settings of the document (optional)
            
        Returns: SignatureFormDocumentResponse
        """
        if( userId == None or formGuid == None or documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'formGuid', 'documentGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureFormDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/forms/{formGuid}/document/{documentGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormDocumentResponse')
        return responseObject
        
        
    def GetSignaturePredefinedLists(self, userId, **kwargs):
        """Get user predefined lists

        Args:
            userId, str: User GUID (required)
            
        Returns: SignaturePredefinedListsResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignaturePredefinedLists" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/lists'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignaturePredefinedListsResponse')
        return responseObject
        
        
    def AddPredefinedList(self, userId, body, **kwargs):
        """Add predefined list

        Args:
            userId, str: User GUID (required)
            body, SignaturePredefinedListSettingsInfo: List data (required)
            
        Returns: SignaturePredefinedListResponse
        """
        if( userId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddPredefinedList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/list'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignaturePredefinedListResponse')
        return responseObject
        
        
    def DeletePredefinedList(self, userId, listGuid, **kwargs):
        """Delete predefined list

        Args:
            userId, str: User GUID (required)
            listGuid, str: List GUID (required)
            
        Returns: SignaturePredefinedListResponse
        """
        if( userId == None or listGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'listGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeletePredefinedList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/lists/{listGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('listGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['listGuid']))
            resourcePath = resourcePath.replace('{' + 'listGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignaturePredefinedListResponse')
        return responseObject
        
        
    def GetRolesList(self, userId, **kwargs):
        """Get signature roles

        Args:
            userId, str: User GUID (required)
            roleGuid, str: Filter roles by GUID (optional)
            
        Returns: SignatureRolesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'roleGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetRolesList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/roles?id={roleGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('roleGuid' in params):
            queryParams['id'] = self.apiClient.toPathValue(params['roleGuid'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureRolesResponse')
        return responseObject
        
        
    def CreateSignature(self, userId, name, **kwargs):
        """Create user signature

        Args:
            userId, str: User GUID (required)
            name, str: Signature name (required)
            body, SignatureSignatureSettingsInfo: Settings of the signature (optional)
            
        Returns: SignatureSignatureResponse
        """
        if( userId == None or name == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'name', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateSignature" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/signature?name={name}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureSignatureResponse')
        return responseObject
        
        
    def DeleteSignature(self, userId, signatureGuid, **kwargs):
        """Delete user signature

        Args:
            userId, str: User GUID (required)
            signatureGuid, str: Signature GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or signatureGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'signatureGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignature" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/signatures/{signatureGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('signatureGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['signatureGuid']))
            resourcePath = resourcePath.replace('{' + 'signatureGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def GetSignatures(self, userId, **kwargs):
        """Get user signatures

        Args:
            userId, str: User GUID (required)
            page, int: Show records for page number (optional)
            records, int: Show records count (optional)
            name, str: Filter by signature name (optional)
            
        Returns: SignatureSignaturesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'page', 'records', 'name']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatures" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/signatures?records={records}&page={page}&name={name}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('page' in params):
            queryParams['page'] = self.apiClient.toPathValue(params['page'])
        if ('records' in params):
            queryParams['records'] = self.apiClient.toPathValue(params['records'])
        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureSignaturesResponse')
        return responseObject
        
        
    def GetSignatureTemplates(self, userId, **kwargs):
        """Get templates

        Args:
            userId, str: User GUID (required)
            page, int: Page number (optional)
            records, int: Records count (optional)
            documentGuid, str: Fitler templates by document originalMD5 (optional)
            recipientName, str: Filter templates by recipient nickname (optional)
            name, str: Filter templates by signatureTemplate name (optional)
            
        Returns: SignatureTemplatesResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'page', 'records', 'documentGuid', 'recipientName', 'name']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureTemplates" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates?records={records}&page={page}&documentGuid={documentGuid}&recipientName={recipientName}&name={name}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('page' in params):
            queryParams['page'] = self.apiClient.toPathValue(params['page'])
        if ('records' in params):
            queryParams['records'] = self.apiClient.toPathValue(params['records'])
        if ('documentGuid' in params):
            queryParams['documentGuid'] = self.apiClient.toPathValue(params['documentGuid'])
        if ('recipientName' in params):
            queryParams['recipientName'] = self.apiClient.toPathValue(params['recipientName'])
        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplatesResponse')
        return responseObject
        
        
    def GetSignatureTemplate(self, userId, templateGuid, **kwargs):
        """Get template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            
        Returns: SignatureTemplateResponse
        """
        if( userId == None or templateGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureTemplate" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateResponse')
        return responseObject
        
        
    def CreateSignatureTemplate(self, userId, **kwargs):
        """Create template

        Args:
            userId, str: User GUID (required)
            name, str: Template name (optional)
            templateGuid, str: Template GUID of the template that will be used to create the new template (optional)
            envelopeGuid, str: Envelope GUID of the envelope that will be used to create the new template (optional)
            body, SignatureTemplateSettingsInfo: Settings of the template (optional)
            
        Returns: SignatureTemplateResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'name', 'templateGuid', 'envelopeGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateSignatureTemplate" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/template?name={name}&templateId={templateGuid}&envelopeId={envelopeGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('templateGuid' in params):
            queryParams['templateId'] = self.apiClient.toPathValue(params['templateGuid'])
        if ('envelopeGuid' in params):
            queryParams['envelopeId'] = self.apiClient.toPathValue(params['envelopeGuid'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateResponse')
        return responseObject
        
        
    def ModifySignatureTemplate(self, userId, templateGuid, **kwargs):
        """Modify template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            body, SignatureTemplateSettingsInfo: Settings of the template (optional)
            
        Returns: SignatureTemplateResponse
        """
        if( userId == None or templateGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ModifySignatureTemplate" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateResponse')
        return responseObject
        
        
    def RenameSignatureTemplate(self, userId, templateGuid, name, **kwargs):
        """Rename template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            name, str: New template name (required)
            
        Returns: SignatureTemplateResponse
        """
        if( userId == None or templateGuid == None or name == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'name']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RenameSignatureTemplate" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}?name={name}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('name' in params):
            queryParams['name'] = self.apiClient.toPathValue(params['name'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateResponse')
        return responseObject
        
        
    def DeleteSignatureTemplate(self, userId, templateGuid, **kwargs):
        """Delete template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( userId == None or templateGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteSignatureTemplate" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def AddSignatureTemplateRecipient(self, userId, templateGuid, nickname, roleGuid, **kwargs):
        """Add recipient to the template

        Args:
            userId, str: User GUID (required)
            templateGuid, str: Template GUID (required)
            nickname, str: Nickname of the recipient (required)
            roleGuid, str: Role GUID (required)
            order, int: Display order of the recipient (optional)
            
        Returns: SignatureTemplateRecipientResponse
        """
        if( userId == None or templateGuid == None or nickname == None or roleGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'templateGuid', 'nickname', 'roleGuid', 'order']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddSignatureTemplateRecipient" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/{userId}/templates/{templateGuid}/recipient?nickname={nickname}&role={roleGuid}&order={order}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('nickname' in params):
            queryParams['nickname'] = self.apiClient.toPathValue(params['nickname'])
        if ('roleGuid' in params):
            queryParams['role'] = self.apiClient.toPathValue(params['roleGuid'])
        if ('order' in params):
            queryParams['order'] = self.apiClient.toPathValue(params['order'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('templateGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['templateGuid']))
            resourcePath = resourcePath.replace('{' + 'templateGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureTemplateRecipientResponse')
        return responseObject
        
        
    def PublicFillEnvelopeField(self, envelopeGuid, documentGuid, recipientGuid, fieldGuid, **kwargs):
        """Fill envelope field

        Args:
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            recipientGuid, str: Recipient GUID (required)
            fieldGuid, str: Field GUID (required)
            body, str: Data to be placed in field (optional)
            
        Returns: SignatureEnvelopeFieldResponse
        """
        if( envelopeGuid == None or documentGuid == None or recipientGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['envelopeGuid', 'documentGuid', 'recipientGuid', 'fieldGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicFillEnvelopeField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/envelopes/{envelopeGuid}/documents/{documentGuid}/recipient/{recipientGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeFieldResponse')
        return responseObject
        
        
    def PublicSignEnvelope(self, envelopeGuid, recipientGuid, **kwargs):
        """Sign envelope

        Args:
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: SignatureStatusResponse
        """
        if( envelopeGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['envelopeGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicSignEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/envelopes/{envelopeGuid}/recipient/{recipientGuid}/sign'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def PublicGetEnvelopeDocuments(self, envelopeGuid, recipientGuid, **kwargs):
        """Get documents in envelope

        Args:
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: SignatureEnvelopeDocumentsResponse
        """
        if( envelopeGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['envelopeGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetEnvelopeDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/envelopes/{envelopeGuid}/recipient/{recipientGuid}/documents'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeDocumentsResponse')
        return responseObject
        
        
    def PublicGetEnvelopeRecipients(self, envelopeGuid, **kwargs):
        """Get signature envelope recipients

        Args:
            envelopeGuid, str: Envelope GUID (required)
            
        Returns: SignatureEnvelopeRecipientsResponse
        """
        if( envelopeGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['envelopeGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetEnvelopeRecipients" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/envelopes/{envelopeGuid}/recipients'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeRecipientsResponse')
        return responseObject
        
        
    def PublicGetSignatureEnvelopeFields(self, envelopeGuid, documentGuid, recipientGuid, **kwargs):
        """Get signature field for document in envelope per recipient

        Args:
            envelopeGuid, str: Envelope GUID (required)
            documentGuid, str: Document GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: SignatureEnvelopeFieldsResponse
        """
        if( envelopeGuid == None or documentGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['envelopeGuid', 'documentGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetSignatureEnvelopeFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/envelopes/{envelopeGuid}/fields?document={documentGuid}&recipient={recipientGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('documentGuid' in params):
            queryParams['document'] = self.apiClient.toPathValue(params['documentGuid'])
        if ('recipientGuid' in params):
            queryParams['recipient'] = self.apiClient.toPathValue(params['recipientGuid'])
        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeFieldsResponse')
        return responseObject
        
        
    def PublicGetSignatureEnvelope(self, envelopeGuid, recipientGuid, **kwargs):
        """Get signature envelope

        Args:
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: SignatureEnvelopeResponse
        """
        if( envelopeGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['envelopeGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetSignatureEnvelope" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/envelopes/{envelopeGuid}/recipient/{recipientGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureEnvelopeResponse')
        return responseObject
        
        
    def PublicGetSignedEnvelopeDocuments(self, envelopeGuid, recipientGuid, **kwargs):
        """Get signed envelope documents

        Args:
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            
        Returns: stream
        """
        if( envelopeGuid == None or recipientGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['envelopeGuid', 'recipientGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetSignedEnvelopeDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/envelopes/{envelopeGuid}/recipient/{recipientGuid}/documents/get'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def PublicFillSignatureForm(self, formGuid, **kwargs):
        """Fill signature form

        Args:
            formGuid, str: Form GUID (required)
            
        Returns: SignatureFormParticipantResponse
        """
        if( formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicFillSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/forms/{formGuid}/fill'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormParticipantResponse')
        return responseObject
        
        
    def PublicFillFormField(self, formGuid, documentGuid, fieldGuid, authSignature, participantIdId, **kwargs):
        """Fill form field

        Args:
            formGuid, str: Form GUID (required)
            documentGuid, str: Document GUID (required)
            fieldGuid, str: Field GUID (required)
            authSignature, str: Authentication signature (required)
            body, str: Data to be placed in field (optional)
            participantIdId, str: Participant GUID (required)
            
        Returns: SignatureFormFieldResponse
        """
        if( formGuid == None or documentGuid == None or fieldGuid == None or authSignature == None or participantIdId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['formGuid', 'documentGuid', 'fieldGuid', 'authSignature', 'body', 'participantIdId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicFillFormField" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/forms/{formGuid}/documents/{documentGuid}/participant/{participantGuid}/field/{fieldGuid}?participantAuthSignature={authSignature}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('authSignature' in params):
            queryParams['participantAuthSignature'] = self.apiClient.toPathValue(params['authSignature'])
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        if ('participantIdId' in params):
            replacement = str(self.apiClient.toPathValue(params['participantIdId']))
            resourcePath = resourcePath.replace('{' + 'participantIdId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormFieldResponse')
        return responseObject
        
        
    def PublicSignForm(self, formGuid, participantGuid, authSignature, **kwargs):
        """Sign Form

        Args:
            formGuid, str: Form GUID (required)
            participantGuid, str: Participant GUID (required)
            authSignature, str: Authentication signature (required)
            
        Returns: SignatureStatusResponse
        """
        if( formGuid == None or participantGuid == None or authSignature == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['formGuid', 'participantGuid', 'authSignature']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicSignForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/forms/{formGuid}/participant/{participantGuid}/sign?participantAuthSignature={authSignature}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('authSignature' in params):
            queryParams['participantAuthSignature'] = self.apiClient.toPathValue(params['authSignature'])
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('participantGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['participantGuid']))
            resourcePath = resourcePath.replace('{' + 'participantGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureStatusResponse')
        return responseObject
        
        
    def PublicGetSignatureForm(self, formGuid, **kwargs):
        """Get signature form

        Args:
            formGuid, str: Form GUID (required)
            
        Returns: SignatureFormResponse
        """
        if( formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetSignatureForm" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/forms/{formGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormResponse')
        return responseObject
        
        
    def PublicGetSignatureFormDocuments(self, formGuid, **kwargs):
        """Get documents in form

        Args:
            formGuid, str: Form GUID (required)
            
        Returns: SignatureFormDocumentsResponse
        """
        if( formGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['formGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetSignatureFormDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/forms/{formGuid}/documents'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormDocumentsResponse')
        return responseObject
        
        
    def PublicGetSignatureFormFields(self, formGuid, documentGuid, participantGuid, **kwargs):
        """Get form fields for document in form per participant

        Args:
            formGuid, str: Form GUID (required)
            documentGuid, str: Document GUID (required)
            participantGuid, str: Participant GUID (required)
            
        Returns: SignatureFormFieldsResponse
        """
        if( formGuid == None or documentGuid == None or participantGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['formGuid', 'documentGuid', 'participantGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetSignatureFormFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/forms/{formGuid}/fields?document={documentGuid}&participant={participantGuid}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('documentGuid' in params):
            queryParams['document'] = self.apiClient.toPathValue(params['documentGuid'])
        if ('participantGuid' in params):
            queryParams['participant'] = self.apiClient.toPathValue(params['participantGuid'])
        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormFieldsResponse')
        return responseObject
        
        
    def PublicGetSignedFormDocuments(self, formGuid, participantGuid, **kwargs):
        """Get signed form documents

        Args:
            formGuid, str: Form GUID (required)
            participantGuid, str: Participant GUID (required)
            
        Returns: stream
        """
        if( formGuid == None or participantGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['formGuid', 'participantGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetSignedFormDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/forms/{formGuid}/participant/{participantGuid}/documents/get'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('participantGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['participantGuid']))
            resourcePath = resourcePath.replace('{' + 'participantGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def GetSignatureFormParticipant(self, formGuid, participantGuid, **kwargs):
        """Get signature form participant

        Args:
            formGuid, str: Form GUID (required)
            participantGuid, str: Participant GUID (required)
            
        Returns: SignatureFormParticipantResponse
        """
        if( formGuid == None or participantGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['formGuid', 'participantGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureFormParticipant" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/forms/{formGuid}/participants/{participantGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('formGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['formGuid']))
            resourcePath = resourcePath.replace('{' + 'formGuid' + '}',
                                                replacement)
        if ('participantGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['participantGuid']))
            resourcePath = resourcePath.replace('{' + 'participantGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureFormParticipantResponse')
        return responseObject
        
        
    def PublicSignDocument(self, documentGuid, **kwargs):
        """Sign document

        Args:
            documentGuid, str: Document GUID (required)
            body, PublicSignatureSignDocumentSignerSettingsInfo: Settings of the signing document (optional)
            
        Returns: SignatureSignDocumentResponse
        """
        if( documentGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['documentGuid', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicSignDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/documents/{documentGuid}/sign'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('documentGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['documentGuid']))
            resourcePath = resourcePath.replace('{' + 'documentGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureSignDocumentResponse')
        return responseObject
        
        
    def PublicVerifyDocument(self, body, **kwargs):
        """Verify

        Args:
            body, stream: Document to verify (required)
            
        Returns: SignatureVerifyDocumentResponse
        """
        if( body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicVerifyDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/verify'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureVerifyDocumentResponse')
        return responseObject
        
        
    def PublicGetSignDocumentStatus(self, jobGuid, **kwargs):
        """Get signed document status

        Args:
            jobGuid, str: Job GUID (required)
            
        Returns: SignatureSignDocumentStatusResponse
        """
        if( jobGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['jobGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method PublicGetSignDocumentStatus" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/documents/{jobGuid}/status'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('jobGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['jobGuid']))
            resourcePath = resourcePath.replace('{' + 'jobGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SignatureSignDocumentStatusResponse')
        return responseObject
        
        
    def GetSignatureEnvelopeFieldData(self, envelopeGuid, recipientGuid, fieldGuid, **kwargs):
        """Get signed envelope field data

        Args:
            envelopeGuid, str: Envelope GUID (required)
            recipientGuid, str: Recipient GUID (required)
            fieldGuid, str: Field GUID (required)
            
        Returns: stream
        """
        if( envelopeGuid == None or recipientGuid == None or fieldGuid == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['envelopeGuid', 'recipientGuid', 'fieldGuid']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSignatureEnvelopeFieldData" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/signature/public/envelopes/{envelopeGuid}/fields/recipient/{recipientGuid}/field/{fieldGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('envelopeGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['envelopeGuid']))
            resourcePath = resourcePath.replace('{' + 'envelopeGuid' + '}',
                                                replacement)
        if ('recipientGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['recipientGuid']))
            resourcePath = resourcePath.replace('{' + 'recipientGuid' + '}',
                                                replacement)
        if ('fieldGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['fieldGuid']))
            resourcePath = resourcePath.replace('{' + 'fieldGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    


