#This file is part of Higgins. The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license
#terms.

from collections import defaultdict
import yaml
import logging
import os

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger('higgins')

DOT_DIR = '.hn'
CONFIG_FILE = os.path.join(DOT_DIR, 'config.yaml')
BUILD_DIR = os.path.join(DOT_DIR, 'builds')
TEMPLATE_DIR = os.path.join(DOT_DIR, 'template')
STATIC_DIR = os.path.join(DOT_DIR, 'static')
DB_URI = 'sqlite:///' + DOT_DIR + '/db.sqlite'
CONFIG = None


def read_config(config_file=None, cli_args=None):
    global CONFIG, CONFIG_FILE, CLI_ARGS

    if cli_args.debug:
        logger.setLevel(logging.DEBUG)
        logger.debug('logging level set to debug')

    CLI_ARGS = cli_args

    if config_file is not None:
        CONFIG_FILE = config_file

    action = cli_args.action and cli_args.action[0]
    if not os.path.exists(CONFIG_FILE):
        if action != 'init':
            logger.error('Config file "%s" not found' % CONFIG_FILE)
            exit()
        else:
            content = {}
    else:
        logger.debug('Load config file "%s"' % CONFIG_FILE)
        with open(CONFIG_FILE) as fh:
            content = yaml.load(fh) or {}

    # Track parent-child relations
    p2c = defaultdict(list)
    for key, value in content.iteritems():
        p2c[value.get('extend')].append(key)

    # Recursively update projects
    children = p2c.get(None)
    while children:
        parents = []
        for key in children:
            # curent child becomes new parent
            parents.append(key)
            cvals = content[key]
            pkey = cvals.get('extend')
            if pkey:
                # update parent values with the child ones
                pvals = content.get(pkey, {}).copy()
                pvals.update(cvals)
                content[key] = pvals

        children = []
        for p in parents:
            children.extend(p2c.get(p, []))

    CONFIG = content


def save(data):
    with open(CONFIG_FILE, 'w') as fh:
        fh.write(data)


def get(name, default=None):
    return CONFIG.get(name, default)


def cli(name):
    return getattr(CLI_ARGS, name)
