#This file is part of Higgins. The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license
#terms.

import argparse
import logging

from . import db
from . import action
from . import config
from .utils import UserException

def parse_args(enforce_action=False):
    parser = argparse.ArgumentParser(description='Higgins CLI')
    if enforce_action:
        parser.add_argument('action', help='init, trigger, build or serve',
                            nargs=1)
    parser.add_argument('--host', help='Host to listen to')
    parser.add_argument('--port', help='Port to listen to', type=int)
    parser.add_argument('--debug', help='Enable debug mode',
                        action='store_true')
    parser.add_argument('--sql-debug', help='Log SQL queries',
                        action='store_true')
    parser.add_argument('--monitor', const=600, nargs='?',
                        help='Monitor repositories and launch builds '\
                        '(timeout in seconds)',
                        type=int)
    return parser.parse_args()

def main():
    args = parse_args(True)

    cli_action = args.action[0]
    if not hasattr(action, 'do_' + cli_action):
        exit('Unkown action "%s"' % cli_action)

    # Init config
    config.read_config(cli_args=args)

    if args.sql_debug:
        logging.getLogger('sqlalchemy.engine').setLevel(logging.INFO)

    # Initialize context
    db.Context(config.DB_URI, echo=False)
    # Execute action
    try:
        res = getattr(action, 'do_' + cli_action)()
    except UserException, e:
        logging.error(e)


if __name__ == '__main__':
    main()
