﻿# 
# Copyright (c) Microsoft and contributors.  All rights reserved.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# 
# See the License for the specific language governing permissions and
# limitations under the License.
# 

# Warning: This code was generated by a tool.
# 
# Changes to this file may cause incorrect behavior and will be lost if the
# code is regenerated.

from datetime import datetime
import json
from requests import Session, Request
import time
import uuid
try:
    from urllib import quote, unquote
except:
    from urllib.parse import quote, unquote
from azure.common import AzureHttpError
from azure.mgmt.common import AzureOperationResponse, OperationStatusResponse, OperationStatus, Service
from azure.mgmt.common.arm import ResourceBase, ResourceBaseExtended

class StorageAccountCreateResponse(AzureOperationResponse):
    """
     The Create storage account operation response.
    """
    
    def __init__(self, **kwargs):
        super(StorageAccountCreateResponse, self).__init__(**kwargs)
        self._storage_account = kwargs.get('storage_account')
        self._operation_status_link = kwargs.get('operation_status_link')
        self._retry_after = kwargs.get('retry_after')
        self._status = kwargs.get('status')
    
    @property
    def operation_status_link(self):
        """
         Gets the URL where the status of the create operation can be checked.
        """
        return self._operation_status_link
    
    @operation_status_link.setter 
    def operation_status_link(self, value):
        self._operation_status_link = value
    
    @property
    def retry_after(self):
        """
         Gets the delay that the client should use when checking for the status
         of the operation. This delay is specified in seconds as an integer;
         min 5 seconds, max 900 seconds (15 minutes). The storage resource
         provider will return 25 seconds initially.
        """
        return self._retry_after
    
    @retry_after.setter 
    def retry_after(self, value):
        self._retry_after = value
    
    @property
    def status(self):
        """
         Gets the status of the create request.
        """
        return self._status
    
    @status.setter 
    def status(self, value):
        self._status = value
    
    @property
    def storage_account(self):
        """
         Gets the storage account with the created properties populated.
        """
        return self._storage_account
    
    @storage_account.setter 
    def storage_account(self, value):
        self._storage_account = value

class CheckNameAvailabilityResponse(AzureOperationResponse):
    """
     The CheckNameAvailability operation response.
    """
    
    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self._name_available = kwargs.get('name_available')
        self._reason = kwargs.get('reason')
        self._message = kwargs.get('message')
    
    @property
    def message(self):
        """
         Gets an error message explaining the Reason value in more detail.
        """
        return self._message
    
    @message.setter 
    def message(self, value):
        self._message = value
    
    @property
    def name_available(self):
        """
         Gets a boolean value that indicates whether the name is available for
         you to use. If true, the name is available. If false, the name has
         already been taken or invalid and cannot be used.
        """
        return self._name_available
    
    @name_available.setter 
    def name_available(self, value):
        self._name_available = value
    
    @property
    def reason(self):
        """
         Gets the reason that a storage account name could not be used. The
         Reason element is only returned if NameAvailable is false.
        """
        return self._reason
    
    @reason.setter 
    def reason(self, value):
        self._reason = value

class StorageAccountCreateParameters(object):
    """
     The parameters to provide for the account.
    """
    
    def __init__(self, **kwargs):
        self._account_type = kwargs.get('account_type')
        self._location = kwargs.get('location')
        self._tags = kwargs.get('tags')
    
    @property
    def account_type(self):
        """
         Gets or sets the account type.
        """
        return self._account_type
    
    @account_type.setter 
    def account_type(self, value):
        self._account_type = value
    
    @property
    def location(self):
        """
         Gets or sets the location of the resource. This will be one of the
         supported and registered Azure Geo Regions (e.g. West US, East US,
         Southeast Asia, etc.). The geo region of a resource cannot be changed
         once it is created.
        """
        return self._location
    
    @location.setter 
    def location(self, value):
        self._location = value
    
    @property
    def tags(self):
        """
         Gets or sets a list of key value pairs that describe the resource.
         These tags can be used in viewing and grouping this resource (across
         resource groups). A maximum of 15 tags can be provided for a
         resource. Each tag must have a key no greater than 128 characters and
         value no greater than 256 characters.
        """
        return self._tags
    
    @tags.setter 
    def tags(self, value):
        self._tags = value

class StorageAccountGetPropertiesResponse(AzureOperationResponse):
    """
     The Get storage account operation response.
    """
    
    def __init__(self, **kwargs):
        super(StorageAccountGetPropertiesResponse, self).__init__(**kwargs)
        self._storage_account = kwargs.get('storage_account')
    
    @property
    def storage_account(self):
        """
         Gets the returned storage account.
        """
        return self._storage_account
    
    @storage_account.setter 
    def storage_account(self, value):
        self._storage_account = value

class StorageAccountListKeysResponse(AzureOperationResponse):
    """
     The ListKeys operation response.
    """
    
    def __init__(self, **kwargs):
        super(StorageAccountListKeysResponse, self).__init__(**kwargs)
        self._storage_account_keys = kwargs.get('storage_account_keys')
    
    @property
    def storage_account_keys(self):
        """
         Gets the access keys for the storage account.
        """
        return self._storage_account_keys
    
    @storage_account_keys.setter 
    def storage_account_keys(self, value):
        self._storage_account_keys = value

class StorageAccountListResponse(AzureOperationResponse):
    """
     The list storage accounts operation response.
    """
    
    def __init__(self, **kwargs):
        super(StorageAccountListResponse, self).__init__(**kwargs)
        self._storage_accounts = kwargs.get('storage_accounts')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets the link to the next set of results. Currently this will always
         be empty as the API does not support pagination.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def storage_accounts(self):
        """
         Gets the list of storage accounts and their properties.
        """
        return self._storage_accounts
    
    @storage_accounts.setter 
    def storage_accounts(self, value):
        self._storage_accounts = value

class StorageAccountUpdateResponse(AzureOperationResponse):
    """
     The Update storage account operation response.
    """
    
    def __init__(self, **kwargs):
        super(StorageAccountUpdateResponse, self).__init__(**kwargs)
        self._storage_account = kwargs.get('storage_account')
    
    @property
    def storage_account(self):
        """
         Gets the storage account with the updated properties populated.
        """
        return self._storage_account
    
    @storage_account.setter 
    def storage_account(self, value):
        self._storage_account = value

class StorageAccountUpdateParameters(object):
    """
     The parameters to update on the account.
    """
    
    def __init__(self, **kwargs):
        self._account_type = kwargs.get('account_type')
        self._custom_domain = kwargs.get('custom_domain')
        self._tags = kwargs.get('tags')
    
    @property
    def account_type(self):
        """
         Gets or sets the account type. Note that StandardZRS and PremiumLRS
         accounts cannot be changed to other account types, and other account
         types cannot be changed to StandardZRS or PremiumLRS.
        """
        return self._account_type
    
    @account_type.setter 
    def account_type(self, value):
        self._account_type = value
    
    @property
    def custom_domain(self):
        """
         User domain assigned to the storage account. Name is the CNAME source.
         Only one custom domain is supported per storage account at this time.
         To clear the existing custom domain, use an empty string for the
         custom domain name property.
        """
        return self._custom_domain
    
    @custom_domain.setter 
    def custom_domain(self, value):
        self._custom_domain = value
    
    @property
    def tags(self):
        """
         Gets or sets a list of key value pairs that describe the resource.
         These tags can be used in viewing and grouping this resource (across
         resource groups). A maximum of 15 tags can be provided for a
         resource. Each tag must have a key no greater than 128 characters and
         value no greater than 256 characters. This is a full replace so all
         the existing tags will be replaced on Update.
        """
        return self._tags
    
    @tags.setter 
    def tags(self, value):
        self._tags = value

class StorageAccountRegenerateKeyResponse(AzureOperationResponse):
    """
     The RegenerateKey operation response.
    """
    
    def __init__(self, **kwargs):
        super(StorageAccountRegenerateKeyResponse, self).__init__(**kwargs)
        self._storage_account_keys = kwargs.get('storage_account_keys')
    
    @property
    def storage_account_keys(self):
        """
         Gets the access keys associated with the storage account, one of which
         mayhave been regenerated by this operation.
        """
        return self._storage_account_keys
    
    @storage_account_keys.setter 
    def storage_account_keys(self, value):
        self._storage_account_keys = value

class KeyName(object):
    """
     The key names.
    """
    key1 = "key1"
    key2 = "key2"

class StorageAccount(ResourceBaseExtended):
    """
     The storage account.
    """
    
    def __init__(self, **kwargs):
        super(StorageAccount, self).__init__(**kwargs)
        self._provisioning_state = kwargs.get('provisioning_state')
        self._account_type = kwargs.get('account_type')
        self._primary_endpoints = kwargs.get('primary_endpoints')
        self._primary_location = kwargs.get('primary_location')
        self._status_of_primary = kwargs.get('status_of_primary')
        self._last_geo_failover_time = kwargs.get('last_geo_failover_time')
        self._secondary_endpoints = kwargs.get('secondary_endpoints')
        self._secondary_location = kwargs.get('secondary_location')
        self._status_of_secondary = kwargs.get('status_of_secondary')
        self._creation_time = kwargs.get('creation_time')
        self._custom_domain = kwargs.get('custom_domain')
    
    @property
    def account_type(self):
        """
         Gets the type of the storage account.
        """
        return self._account_type
    
    @account_type.setter 
    def account_type(self, value):
        self._account_type = value
    
    @property
    def creation_time(self):
        """
         Gets the creation date and time of the storage account in UTC.
        """
        return self._creation_time
    
    @creation_time.setter 
    def creation_time(self, value):
        self._creation_time = value
    
    @property
    def custom_domain(self):
        """
         Gets the user assigned custom domain assigned to this storage account.
        """
        return self._custom_domain
    
    @custom_domain.setter 
    def custom_domain(self, value):
        self._custom_domain = value
    
    @property
    def last_geo_failover_time(self):
        """
         Gets the timestamp of the most recent instance of a failover to the
         secondary location. Only the most recent timestamp is retained. This
         element is not returned if there has never been a failover instance.
         Only available if the accountType is StandardGRS or StandardRAGRS.
        """
        return self._last_geo_failover_time
    
    @last_geo_failover_time.setter 
    def last_geo_failover_time(self, value):
        self._last_geo_failover_time = value
    
    @property
    def primary_endpoints(self):
        """
         Gets the URLs that are used to perform a retrieval of a public blob,
         queue or table object.Note that StandardZRS and PremiumLRS accounts
         only return the blob endpoint.
        """
        return self._primary_endpoints
    
    @primary_endpoints.setter 
    def primary_endpoints(self, value):
        self._primary_endpoints = value
    
    @property
    def primary_location(self):
        """
         Gets the location of the primary for the storage account.
        """
        return self._primary_location
    
    @primary_location.setter 
    def primary_location(self, value):
        self._primary_location = value
    
    @property
    def provisioning_state(self):
        """
         Gets the status of the storage account at the time the operation was
         called.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def secondary_endpoints(self):
        """
         Gets the URLs that are used to perform a retrieval of a public blob,
         queue or table object from the secondary location of the storage
         account. Only available if the accountType is StandardRAGRS.
        """
        return self._secondary_endpoints
    
    @secondary_endpoints.setter 
    def secondary_endpoints(self, value):
        self._secondary_endpoints = value
    
    @property
    def secondary_location(self):
        """
         Gets the location of the geo replicated secondary for the storage
         account. Only available if the accountType is StandardGRS or
         StandardRAGRS.
        """
        return self._secondary_location
    
    @secondary_location.setter 
    def secondary_location(self, value):
        self._secondary_location = value
    
    @property
    def status_of_primary(self):
        """
         Gets the status indicating whether the primary location of the storage
         account is available or unavailable.
        """
        return self._status_of_primary
    
    @status_of_primary.setter 
    def status_of_primary(self, value):
        self._status_of_primary = value
    
    @property
    def status_of_secondary(self):
        """
         Gets the status indicating whether the secondary location of the
         storage account is available or unavailable. Only available if the
         accountType is StandardGRS or StandardRAGRS.
        """
        return self._status_of_secondary
    
    @status_of_secondary.setter 
    def status_of_secondary(self, value):
        self._status_of_secondary = value

class ProvisioningState(object):
    creating = "Creating"
    resolving_dns = "ResolvingDNS"
    succeeded = "Succeeded"

class AccountType(object):
    standard_lrs = "Standard_LRS"
    standard_zrs = "Standard_ZRS"
    standard_grs = "Standard_GRS"
    standard_ragrs = "Standard_RAGRS"
    premium_lrs = "Premium_LRS"

class Endpoints(object):
    """
     The URIs that are used to perform a retrieval of a public blob, queue or
     table object.
    """
    
    def __init__(self, **kwargs):
        self._blob = kwargs.get('blob')
        self._queue = kwargs.get('queue')
        self._table = kwargs.get('table')
    
    @property
    def blob(self):
        """
         Gets the blob endpoint.
        """
        return self._blob
    
    @blob.setter 
    def blob(self, value):
        self._blob = value
    
    @property
    def queue(self):
        """
         Gets the queue endpoint.
        """
        return self._queue
    
    @queue.setter 
    def queue(self, value):
        self._queue = value
    
    @property
    def table(self):
        """
         Gets the table endpoint.
        """
        return self._table
    
    @table.setter 
    def table(self, value):
        self._table = value

class AccountStatus(object):
    available = "Available"
    unavailable = "Unavailable"

class CustomDomain(object):
    """
     The custom domain assigned to this storage account. This can be set via
     Update.
    """
    
    def __init__(self, **kwargs):
        self._name = kwargs.get('name')
        self._use_sub_domain = kwargs.get('use_sub_domain')
    
    @property
    def name(self):
        """
         Gets or sets the custom domain name. Name is the CNAME source.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def use_sub_domain(self):
        """
         Indicates whether indirect CName validation is enabled. Default value
         is false. This should only be set on updates
        """
        return self._use_sub_domain
    
    @use_sub_domain.setter 
    def use_sub_domain(self, value):
        self._use_sub_domain = value

class Reason(object):
    account_name_invalid = "AccountNameInvalid"
    already_exists = "AlreadyExists"

class StorageAccountKeys(object):
    """
     The access keys for the storage account.
    """
    
    def __init__(self, **kwargs):
        self._key1 = kwargs.get('key1')
        self._key2 = kwargs.get('key2')
    
    @property
    def key1(self):
        """
         Gets the value of key 1.
        """
        return self._key1
    
    @key1.setter 
    def key1(self, value):
        self._key1 = value
    
    @property
    def key2(self):
        """
         Gets the value of key 2.
        """
        return self._key2
    
    @key2.setter 
    def key2(self, value):
        self._key2 = value

class StorageManagementClient(Service):
    """
     The Storage Management Client.
    """
    
    @property
    def api_version(self):
        """
         Gets the API version.
        """
        return self._api_version
    
    @property
    def long_running_operation_initial_timeout(self):
        """
         Gets or sets the initial timeout for Long Running Operations.
        """
        return self._long_running_operation_initial_timeout
    
    @long_running_operation_initial_timeout.setter 
    def long_running_operation_initial_timeout(self, value):
        self._long_running_operation_initial_timeout = value
    
    @property
    def long_running_operation_retry_timeout(self):
        """
         Gets or sets the retry timeout for Long Running Operations.
        """
        return self._long_running_operation_retry_timeout
    
    @long_running_operation_retry_timeout.setter 
    def long_running_operation_retry_timeout(self, value):
        self._long_running_operation_retry_timeout = value
    
    @property
    def storage_accounts(self):
        """
         Operations for managing storage accounts.
        """
        return self._storage_accounts
    
    def __init__(self, credentials, **kwargs):
        super(StorageManagementClient, self).__init__(credentials, **kwargs)
        
        if getattr(self, '_base_uri', None) is None:
            self._base_uri = 'https://management.azure.com/'
        
        if getattr(self, '_api_version', None) is None:
            self._api_version = '2015-05-01-preview'
        
        if getattr(self, '_long_running_operation_initial_timeout', None) is None:
            self._long_running_operation_initial_timeout = -1
        
        if getattr(self, '_long_running_operation_retry_timeout', None) is None:
            self._long_running_operation_retry_timeout = -1
        
        self._storage_accounts = StorageAccountOperations(self)
    
    def parse_account_type(self, value):
        """
         Parse enum values for type AccountType.
         
         Args:
         
         value (string): The value to parse.
         
         Returns:
         
         AccountType: The enum value.
        """
        if 'Standard_LRS'.lower() == value.lower():
            return AccountType.StandardLRS
        
        if 'Standard_ZRS'.lower() == value.lower():
            return AccountType.StandardZRS
        
        if 'Standard_GRS'.lower() == value.lower():
            return AccountType.StandardGRS
        
        if 'Standard_RAGRS'.lower() == value.lower():
            return AccountType.StandardRAGRS
        
        if 'Premium_LRS'.lower() == value.lower():
            return AccountType.PremiumLRS
        
        raise IndexError('value is outside the valid range.')
    
    def account_type_to_string(self, value):
        """
         Convert an enum of type AccountType to a string.
         
         Args:
         
         value (AccountType): The value to convert to a string.
         
         Returns:
         
         string: The enum value as a string.
        """
        if value == AccountType.StandardLRS:
            return 'Standard_LRS'
        
        if value == AccountType.StandardZRS:
            return 'Standard_ZRS'
        
        if value == AccountType.StandardGRS:
            return 'Standard_GRS'
        
        if value == AccountType.StandardRAGRS:
            return 'Standard_RAGRS'
        
        if value == AccountType.PremiumLRS:
            return 'Premium_LRS'
        
        raise IndexError('value is outside the valid range.')
    
    def parse_key_name(self, value):
        """
         Parse enum values for type KeyName.
         
         Args:
         
         value (string): The value to parse.
         
         Returns:
         
         KeyName: The enum value.
        """
        if 'key1'.lower() == value.lower():
            return KeyName.Key1
        
        if 'key2'.lower() == value.lower():
            return KeyName.Key2
        
        raise IndexError('value is outside the valid range.')
    
    def key_name_to_string(self, value):
        """
         Convert an enum of type KeyName to a string.
         
         Args:
         
         value (KeyName): The value to convert to a string.
         
         Returns:
         
         string: The enum value as a string.
        """
        if value == KeyName.Key1:
            return 'key1'
        
        if value == KeyName.Key2:
            return 'key2'
        
        raise IndexError('value is outside the valid range.')
    
    def get_create_operation_status(self, operation_status_link):
        """
         The Get Create Operation Status operation returns the status of the
         specified create operation. After calling the asynchronous Begin
         Create operation, you can call Get Create Operation Status to
         determine whether the operation has succeeded, failed, or is still in
         progress.
         
         Args:
         
         operation_status_link (string): The URL where the status of the
         long-running create operation can be checked.
         
         Returns:
         
         StorageAccountCreateResponse: The Create storage account operation
         response.
        """
        # Validate
        if operation_status_link is None:
            raise ValueError('operation_status_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + operation_status_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Send Request
        response = self.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 500:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 202 or status_code == 500:
            response_content = body
            result = StorageAccountCreateResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                storage_account_instance = StorageAccount(tags={})
                result.storage_account = storage_account_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    storage_account_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    storage_account_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    storage_account_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    storage_account_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        storage_account_instance.tags[tags_key] = tags_value
                    
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        storage_account_instance.provisioning_state = provisioning_state_instance
                    
                    account_type_value = properties_value.get('accountType', None)
                    if account_type_value is not None:
                        account_type_instance = account_type_value
                        storage_account_instance.account_type = account_type_instance
                    
                    primary_endpoints_value = properties_value.get('primaryEndpoints', None)
                    if primary_endpoints_value is not None:
                        primary_endpoints_instance = Endpoints()
                        storage_account_instance.primary_endpoints = primary_endpoints_instance
                        
                        blob_value = primary_endpoints_value.get('blob', None)
                        if blob_value is not None:
                            blob_instance = blob_value
                            primary_endpoints_instance.blob = blob_instance
                        
                        queue_value = primary_endpoints_value.get('queue', None)
                        if queue_value is not None:
                            queue_instance = queue_value
                            primary_endpoints_instance.queue = queue_instance
                        
                        table_value = primary_endpoints_value.get('table', None)
                        if table_value is not None:
                            table_instance = table_value
                            primary_endpoints_instance.table = table_instance
                        
                    primary_location_value = properties_value.get('primaryLocation', None)
                    if primary_location_value is not None:
                        primary_location_instance = primary_location_value
                        storage_account_instance.primary_location = primary_location_instance
                    
                    status_of_primary_value = properties_value.get('statusOfPrimary', None)
                    if status_of_primary_value is not None:
                        status_of_primary_instance = status_of_primary_value
                        storage_account_instance.status_of_primary = status_of_primary_instance
                    
                    last_geo_failover_time_value = properties_value.get('lastGeoFailoverTime', None)
                    if last_geo_failover_time_value is not None:
                        last_geo_failover_time_instance = last_geo_failover_time_value
                        storage_account_instance.last_geo_failover_time = last_geo_failover_time_instance
                    
                    secondary_location_value = properties_value.get('secondaryLocation', None)
                    if secondary_location_value is not None:
                        secondary_location_instance = secondary_location_value
                        storage_account_instance.secondary_location = secondary_location_instance
                    
                    status_of_secondary_value = properties_value.get('statusOfSecondary', None)
                    if status_of_secondary_value is not None:
                        status_of_secondary_instance = status_of_secondary_value
                        storage_account_instance.status_of_secondary = status_of_secondary_instance
                    
                    creation_time_value = properties_value.get('creationTime', None)
                    if creation_time_value is not None:
                        creation_time_instance = creation_time_value
                        storage_account_instance.creation_time = creation_time_instance
                    
                    custom_domain_value = properties_value.get('customDomain', None)
                    if custom_domain_value is not None:
                        custom_domain_instance = CustomDomain()
                        storage_account_instance.custom_domain = custom_domain_instance
                        
                        name_value2 = custom_domain_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            custom_domain_instance.name = name_instance2
                        
                        use_sub_domain_value = custom_domain_value.get('useSubDomain', None)
                        if use_sub_domain_value is not None:
                            use_sub_domain_instance = use_sub_domain_value
                            custom_domain_instance.use_sub_domain = use_sub_domain_instance
                        
                    secondary_endpoints_value = properties_value.get('secondaryEndpoints', None)
                    if secondary_endpoints_value is not None:
                        secondary_endpoints_instance = Endpoints()
                        storage_account_instance.secondary_endpoints = secondary_endpoints_instance
                        
                        blob_value2 = secondary_endpoints_value.get('blob', None)
                        if blob_value2 is not None:
                            blob_instance2 = blob_value2
                            secondary_endpoints_instance.blob = blob_instance2
                        
                        queue_value2 = secondary_endpoints_value.get('queue', None)
                        if queue_value2 is not None:
                            queue_instance2 = queue_value2
                            secondary_endpoints_instance.queue = queue_instance2
                        
                        table_value2 = secondary_endpoints_value.get('table', None)
                        if table_value2 is not None:
                            table_instance2 = table_value2
                            secondary_endpoints_instance.table = table_instance2
                        
        result.status_code = status_code
        result.retry_after = int(response.headers.get('retryafter', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        if status_code == 409:
            result.status = OperationStatus.Failed
        
        if status_code == 500:
            result.status = OperationStatus.InProgress
        
        if status_code == 202:
            result.status = OperationStatus.InProgress
        
        if status_code == 200:
            result.status = OperationStatus.Succeeded
        
        return result
    
class StorageAccountOperations(object):
    """
     Operations for managing storage accounts.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [StorageManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Storage.StorageManagementClient.
        """
        return self._client
    
    def begin_create(self, resource_group_name, account_name, parameters):
        """
         Asynchronously creates a new storage account with the specified
         parameters. Existing accounts cannot be updated with this API and
         should instead use the Update Storage Account API. If an account is
         already created and subsequent PUT request is issued with exact same
         set of properties, then HTTP 200 would be returned.
         
         Args:
         
         resource_group_name (string): The name of the resource group within
         the user’s subscription.
         
         account_name (string): The name of the storage account within the
         specified resource group. Storage account names must be between 3 and
         24 characters in length and use numbers and lower-case letters only.
         
         parameters (StorageAccountCreateParameters): The parameters to provide
         for the created account.
         
         Returns:
         
         StorageAccountCreateResponse: The Create storage account operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if account_name is None:
            raise ValueError('account_name cannot be None.')
        
        if len(account_name) < 3:
            raise IndexError('account_name is outside the valid range.')
        
        if len(account_name) > 24:
            raise IndexError('account_name is outside the valid range.')
        
        for account_name_char in account_name:
            if account_name_char.islower() == False and account_name_char.isdigit() == False:
                raise IndexError('account_name is outside the valid range.')
            
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.account_type is None:
            raise ValueError('parameters.account_type cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/Microsoft.Storage/storageAccounts/'
        url = url + quote(account_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        storage_account_create_parameters_json_value = {}
        request_doc = storage_account_create_parameters_json_value
        
        storage_account_create_parameters_json_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            storage_account_create_parameters_json_value['tags'] = tags_dictionary
        
        properties_value = {}
        storage_account_create_parameters_json_value['properties'] = properties_value
        
        properties_value['accountType'] = str(parameters.account_type) if parameters.account_type is not None else 'StandardLRS'
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 202:
            response_content = body
            result = StorageAccountCreateResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                storage_account_instance = StorageAccount(tags={})
                result.storage_account = storage_account_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    storage_account_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    storage_account_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    storage_account_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    storage_account_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        storage_account_instance.tags[tags_key2] = tags_value2
                    
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        storage_account_instance.provisioning_state = provisioning_state_instance
                    
                    account_type_value = properties_value2.get('accountType', None)
                    if account_type_value is not None:
                        account_type_instance = account_type_value
                        storage_account_instance.account_type = account_type_instance
                    
                    primary_endpoints_value = properties_value2.get('primaryEndpoints', None)
                    if primary_endpoints_value is not None:
                        primary_endpoints_instance = Endpoints()
                        storage_account_instance.primary_endpoints = primary_endpoints_instance
                        
                        blob_value = primary_endpoints_value.get('blob', None)
                        if blob_value is not None:
                            blob_instance = blob_value
                            primary_endpoints_instance.blob = blob_instance
                        
                        queue_value = primary_endpoints_value.get('queue', None)
                        if queue_value is not None:
                            queue_instance = queue_value
                            primary_endpoints_instance.queue = queue_instance
                        
                        table_value = primary_endpoints_value.get('table', None)
                        if table_value is not None:
                            table_instance = table_value
                            primary_endpoints_instance.table = table_instance
                        
                    primary_location_value = properties_value2.get('primaryLocation', None)
                    if primary_location_value is not None:
                        primary_location_instance = primary_location_value
                        storage_account_instance.primary_location = primary_location_instance
                    
                    status_of_primary_value = properties_value2.get('statusOfPrimary', None)
                    if status_of_primary_value is not None:
                        status_of_primary_instance = status_of_primary_value
                        storage_account_instance.status_of_primary = status_of_primary_instance
                    
                    last_geo_failover_time_value = properties_value2.get('lastGeoFailoverTime', None)
                    if last_geo_failover_time_value is not None:
                        last_geo_failover_time_instance = last_geo_failover_time_value
                        storage_account_instance.last_geo_failover_time = last_geo_failover_time_instance
                    
                    secondary_location_value = properties_value2.get('secondaryLocation', None)
                    if secondary_location_value is not None:
                        secondary_location_instance = secondary_location_value
                        storage_account_instance.secondary_location = secondary_location_instance
                    
                    status_of_secondary_value = properties_value2.get('statusOfSecondary', None)
                    if status_of_secondary_value is not None:
                        status_of_secondary_instance = status_of_secondary_value
                        storage_account_instance.status_of_secondary = status_of_secondary_instance
                    
                    creation_time_value = properties_value2.get('creationTime', None)
                    if creation_time_value is not None:
                        creation_time_instance = creation_time_value
                        storage_account_instance.creation_time = creation_time_instance
                    
                    custom_domain_value = properties_value2.get('customDomain', None)
                    if custom_domain_value is not None:
                        custom_domain_instance = CustomDomain()
                        storage_account_instance.custom_domain = custom_domain_instance
                        
                        name_value2 = custom_domain_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            custom_domain_instance.name = name_instance2
                        
                        use_sub_domain_value = custom_domain_value.get('useSubDomain', None)
                        if use_sub_domain_value is not None:
                            use_sub_domain_instance = use_sub_domain_value
                            custom_domain_instance.use_sub_domain = use_sub_domain_instance
                        
                    secondary_endpoints_value = properties_value2.get('secondaryEndpoints', None)
                    if secondary_endpoints_value is not None:
                        secondary_endpoints_instance = Endpoints()
                        storage_account_instance.secondary_endpoints = secondary_endpoints_instance
                        
                        blob_value2 = secondary_endpoints_value.get('blob', None)
                        if blob_value2 is not None:
                            blob_instance2 = blob_value2
                            secondary_endpoints_instance.blob = blob_instance2
                        
                        queue_value2 = secondary_endpoints_value.get('queue', None)
                        if queue_value2 is not None:
                            queue_instance2 = queue_value2
                            secondary_endpoints_instance.queue = queue_instance2
                        
                        table_value2 = secondary_endpoints_value.get('table', None)
                        if table_value2 is not None:
                            table_instance2 = table_value2
                            secondary_endpoints_instance.table = table_instance2
                        
        result.status_code = status_code
        result.operation_status_link = response.headers.get('location')
        result.retry_after = int(response.headers.get('retryafter', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        if status_code == 409 or status_code == 400:
            result.status = OperationStatus.Failed
        
        if status_code == 200:
            result.status = OperationStatus.Succeeded
        
        return result
    
    def check_name_availability(self, account_name):
        """
         Checks that account name is valid and is not in use.
         
         Args:
         
         account_name (string): The name of the storage account within the
         specified resource group. Storage account names must be between 3 and
         24 characters in length and use numbers and lower-case letters only.
         
         Returns:
         
         CheckNameAvailabilityResponse: The CheckNameAvailability operation
         response.
        """
        # Validate
        if account_name is None:
            raise ValueError('account_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/Microsoft.Storage/checkNameAvailability'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        storage_account_check_name_availability_parameters_value = {}
        request_doc = storage_account_check_name_availability_parameters_value
        
        storage_account_check_name_availability_parameters_value['name'] = account_name
        
        storage_account_check_name_availability_parameters_value['type'] = 'Microsoft.Storage/storageAccounts'
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = CheckNameAvailabilityResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                name_available_value = response_doc.get('nameAvailable', None)
                if name_available_value is not None:
                    name_available_instance = name_available_value
                    result.name_available = name_available_instance
                
                reason_value = response_doc.get('reason', None)
                if reason_value is not None:
                    reason_instance = reason_value
                    result.reason = reason_instance
                
                message_value = response_doc.get('message', None)
                if message_value is not None:
                    message_instance = message_value
                    result.message = message_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create(self, resource_group_name, account_name, parameters):
        """
         Asynchronously creates a new storage account with the specified
         parameters. Existing accounts cannot be updated with this API and
         should instead use the Update Storage Account API. If an account is
         already created and subsequent create request is issued with exact
         same set of properties, the request succeeds.The max number of
         storage accounts that can be created per subscription is limited to
         20.
         
         Args:
         
         resource_group_name (string): The name of the resource group within
         the user’s subscription.
         
         account_name (string): The name of the storage account within the
         specified resource group. Storage account names must be between 3 and
         24 characters in length and use numbers and lower-case letters only.
         
         parameters (StorageAccountCreateParameters): The parameters to provide
         for the created account.
         
         Returns:
         
         StorageAccountCreateResponse: The Create storage account operation
         response.
        """
        client2 = self.client
        
        response = client2.storage_accounts.begin_create(resource_group_name, account_name, parameters)
        if response.status == OperationStatus.succeeded:
            return response
        
        result = client2.get_create_operation_status(response.operation_status_link)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 25
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_create_operation_status(response.operation_status_link)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 25
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, account_name):
        """
         Deletes a storage account in Microsoft Azure.
         
         Args:
         
         resource_group_name (string): The name of the resource group within
         the user’s subscription.
         
         account_name (string): The name of the storage account within the
         specified resource group. Storage account names must be between 3 and
         24 characters in length and use numbers and lower-case letters only.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if account_name is None:
            raise ValueError('account_name cannot be None.')
        
        if len(account_name) < 3:
            raise IndexError('account_name is outside the valid range.')
        
        if len(account_name) > 24:
            raise IndexError('account_name is outside the valid range.')
        
        for account_name_char in account_name:
            if account_name_char.islower() == False and account_name_char.isdigit() == False:
                raise IndexError('account_name is outside the valid range.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/Microsoft.Storage/storageAccounts/'
        url = url + quote(account_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = AzureOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get_properties(self, resource_group_name, account_name):
        """
         Returns the properties for the specified storage account including but
         not limited to name, account type, location, and account status. The
         ListKeys operation should be used to retrieve storage keys.
         
         Args:
         
         resource_group_name (string): The name of the resource group within
         the user’s subscription.
         
         account_name (string): The name of the storage account within the
         specified resource group. Storage account names must be between 3 and
         24 characters in length and use numbers and lower-case letters only.
         
         Returns:
         
         StorageAccountGetPropertiesResponse: The Get storage account operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if account_name is None:
            raise ValueError('account_name cannot be None.')
        
        if len(account_name) < 3:
            raise IndexError('account_name is outside the valid range.')
        
        if len(account_name) > 24:
            raise IndexError('account_name is outside the valid range.')
        
        for account_name_char in account_name:
            if account_name_char.islower() == False and account_name_char.isdigit() == False:
                raise IndexError('account_name is outside the valid range.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/Microsoft.Storage/storageAccounts/'
        url = url + quote(account_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = StorageAccountGetPropertiesResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                storage_account_instance = StorageAccount(tags={})
                result.storage_account = storage_account_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    storage_account_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    storage_account_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    storage_account_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    storage_account_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        storage_account_instance.tags[tags_key] = tags_value
                    
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        storage_account_instance.provisioning_state = provisioning_state_instance
                    
                    account_type_value = properties_value.get('accountType', None)
                    if account_type_value is not None:
                        account_type_instance = account_type_value
                        storage_account_instance.account_type = account_type_instance
                    
                    primary_endpoints_value = properties_value.get('primaryEndpoints', None)
                    if primary_endpoints_value is not None:
                        primary_endpoints_instance = Endpoints()
                        storage_account_instance.primary_endpoints = primary_endpoints_instance
                        
                        blob_value = primary_endpoints_value.get('blob', None)
                        if blob_value is not None:
                            blob_instance = blob_value
                            primary_endpoints_instance.blob = blob_instance
                        
                        queue_value = primary_endpoints_value.get('queue', None)
                        if queue_value is not None:
                            queue_instance = queue_value
                            primary_endpoints_instance.queue = queue_instance
                        
                        table_value = primary_endpoints_value.get('table', None)
                        if table_value is not None:
                            table_instance = table_value
                            primary_endpoints_instance.table = table_instance
                        
                    primary_location_value = properties_value.get('primaryLocation', None)
                    if primary_location_value is not None:
                        primary_location_instance = primary_location_value
                        storage_account_instance.primary_location = primary_location_instance
                    
                    status_of_primary_value = properties_value.get('statusOfPrimary', None)
                    if status_of_primary_value is not None:
                        status_of_primary_instance = status_of_primary_value
                        storage_account_instance.status_of_primary = status_of_primary_instance
                    
                    last_geo_failover_time_value = properties_value.get('lastGeoFailoverTime', None)
                    if last_geo_failover_time_value is not None:
                        last_geo_failover_time_instance = last_geo_failover_time_value
                        storage_account_instance.last_geo_failover_time = last_geo_failover_time_instance
                    
                    secondary_location_value = properties_value.get('secondaryLocation', None)
                    if secondary_location_value is not None:
                        secondary_location_instance = secondary_location_value
                        storage_account_instance.secondary_location = secondary_location_instance
                    
                    status_of_secondary_value = properties_value.get('statusOfSecondary', None)
                    if status_of_secondary_value is not None:
                        status_of_secondary_instance = status_of_secondary_value
                        storage_account_instance.status_of_secondary = status_of_secondary_instance
                    
                    creation_time_value = properties_value.get('creationTime', None)
                    if creation_time_value is not None:
                        creation_time_instance = creation_time_value
                        storage_account_instance.creation_time = creation_time_instance
                    
                    custom_domain_value = properties_value.get('customDomain', None)
                    if custom_domain_value is not None:
                        custom_domain_instance = CustomDomain()
                        storage_account_instance.custom_domain = custom_domain_instance
                        
                        name_value2 = custom_domain_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            custom_domain_instance.name = name_instance2
                        
                        use_sub_domain_value = custom_domain_value.get('useSubDomain', None)
                        if use_sub_domain_value is not None:
                            use_sub_domain_instance = use_sub_domain_value
                            custom_domain_instance.use_sub_domain = use_sub_domain_instance
                        
                    secondary_endpoints_value = properties_value.get('secondaryEndpoints', None)
                    if secondary_endpoints_value is not None:
                        secondary_endpoints_instance = Endpoints()
                        storage_account_instance.secondary_endpoints = secondary_endpoints_instance
                        
                        blob_value2 = secondary_endpoints_value.get('blob', None)
                        if blob_value2 is not None:
                            blob_instance2 = blob_value2
                            secondary_endpoints_instance.blob = blob_instance2
                        
                        queue_value2 = secondary_endpoints_value.get('queue', None)
                        if queue_value2 is not None:
                            queue_instance2 = queue_value2
                            secondary_endpoints_instance.queue = queue_instance2
                        
                        table_value2 = secondary_endpoints_value.get('table', None)
                        if table_value2 is not None:
                            table_instance2 = table_value2
                            secondary_endpoints_instance.table = table_instance2
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self):
        """
         Lists all the storage accounts available under the subscription. Note
         that storage keys are not returned; use the ListKeys operation for
         this.
         
         Returns:
         
         StorageAccountListResponse: The list storage accounts operation
         response.
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/Microsoft.Storage/storageAccounts'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = StorageAccountListResponse(storage_accounts=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        storage_account_json_instance = StorageAccount(tags={})
                        result.storage_accounts.append(storage_account_json_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            storage_account_json_instance.id = id_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            storage_account_json_instance.name = name_instance
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            storage_account_json_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            storage_account_json_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                storage_account_json_instance.tags[tags_key] = tags_value
                            
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                storage_account_json_instance.provisioning_state = provisioning_state_instance
                            
                            account_type_value = properties_value.get('accountType', None)
                            if account_type_value is not None:
                                account_type_instance = account_type_value
                                storage_account_json_instance.account_type = account_type_instance
                            
                            primary_endpoints_value = properties_value.get('primaryEndpoints', None)
                            if primary_endpoints_value is not None:
                                primary_endpoints_instance = Endpoints()
                                storage_account_json_instance.primary_endpoints = primary_endpoints_instance
                                
                                blob_value = primary_endpoints_value.get('blob', None)
                                if blob_value is not None:
                                    blob_instance = blob_value
                                    primary_endpoints_instance.blob = blob_instance
                                
                                queue_value = primary_endpoints_value.get('queue', None)
                                if queue_value is not None:
                                    queue_instance = queue_value
                                    primary_endpoints_instance.queue = queue_instance
                                
                                table_value = primary_endpoints_value.get('table', None)
                                if table_value is not None:
                                    table_instance = table_value
                                    primary_endpoints_instance.table = table_instance
                                
                            primary_location_value = properties_value.get('primaryLocation', None)
                            if primary_location_value is not None:
                                primary_location_instance = primary_location_value
                                storage_account_json_instance.primary_location = primary_location_instance
                            
                            status_of_primary_value = properties_value.get('statusOfPrimary', None)
                            if status_of_primary_value is not None:
                                status_of_primary_instance = status_of_primary_value
                                storage_account_json_instance.status_of_primary = status_of_primary_instance
                            
                            last_geo_failover_time_value = properties_value.get('lastGeoFailoverTime', None)
                            if last_geo_failover_time_value is not None:
                                last_geo_failover_time_instance = last_geo_failover_time_value
                                storage_account_json_instance.last_geo_failover_time = last_geo_failover_time_instance
                            
                            secondary_location_value = properties_value.get('secondaryLocation', None)
                            if secondary_location_value is not None:
                                secondary_location_instance = secondary_location_value
                                storage_account_json_instance.secondary_location = secondary_location_instance
                            
                            status_of_secondary_value = properties_value.get('statusOfSecondary', None)
                            if status_of_secondary_value is not None:
                                status_of_secondary_instance = status_of_secondary_value
                                storage_account_json_instance.status_of_secondary = status_of_secondary_instance
                            
                            creation_time_value = properties_value.get('creationTime', None)
                            if creation_time_value is not None:
                                creation_time_instance = creation_time_value
                                storage_account_json_instance.creation_time = creation_time_instance
                            
                            custom_domain_value = properties_value.get('customDomain', None)
                            if custom_domain_value is not None:
                                custom_domain_instance = CustomDomain()
                                storage_account_json_instance.custom_domain = custom_domain_instance
                                
                                name_value2 = custom_domain_value.get('name', None)
                                if name_value2 is not None:
                                    name_instance2 = name_value2
                                    custom_domain_instance.name = name_instance2
                                
                                use_sub_domain_value = custom_domain_value.get('useSubDomain', None)
                                if use_sub_domain_value is not None:
                                    use_sub_domain_instance = use_sub_domain_value
                                    custom_domain_instance.use_sub_domain = use_sub_domain_instance
                                
                            secondary_endpoints_value = properties_value.get('secondaryEndpoints', None)
                            if secondary_endpoints_value is not None:
                                secondary_endpoints_instance = Endpoints()
                                storage_account_json_instance.secondary_endpoints = secondary_endpoints_instance
                                
                                blob_value2 = secondary_endpoints_value.get('blob', None)
                                if blob_value2 is not None:
                                    blob_instance2 = blob_value2
                                    secondary_endpoints_instance.blob = blob_instance2
                                
                                queue_value2 = secondary_endpoints_value.get('queue', None)
                                if queue_value2 is not None:
                                    queue_instance2 = queue_value2
                                    secondary_endpoints_instance.queue = queue_instance2
                                
                                table_value2 = secondary_endpoints_value.get('table', None)
                                if table_value2 is not None:
                                    table_instance2 = table_value2
                                    secondary_endpoints_instance.table = table_instance2
                                
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_by_resource_group(self, resource_group_name):
        """
         Lists all the storage accounts available under the given resource
         group. Note that storage keys are not returned; use the ListKeys
         operation for this.
         
         Args:
         
         resource_group_name (string): The name of the resource group within
         the user’s subscription.
         
         Returns:
         
         StorageAccountListResponse: The list storage accounts operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/Microsoft.Storage/storageAccounts'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = StorageAccountListResponse(storage_accounts=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        storage_account_json_instance = StorageAccount(tags={})
                        result.storage_accounts.append(storage_account_json_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            storage_account_json_instance.id = id_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            storage_account_json_instance.name = name_instance
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            storage_account_json_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            storage_account_json_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                storage_account_json_instance.tags[tags_key] = tags_value
                            
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                storage_account_json_instance.provisioning_state = provisioning_state_instance
                            
                            account_type_value = properties_value.get('accountType', None)
                            if account_type_value is not None:
                                account_type_instance = account_type_value
                                storage_account_json_instance.account_type = account_type_instance
                            
                            primary_endpoints_value = properties_value.get('primaryEndpoints', None)
                            if primary_endpoints_value is not None:
                                primary_endpoints_instance = Endpoints()
                                storage_account_json_instance.primary_endpoints = primary_endpoints_instance
                                
                                blob_value = primary_endpoints_value.get('blob', None)
                                if blob_value is not None:
                                    blob_instance = blob_value
                                    primary_endpoints_instance.blob = blob_instance
                                
                                queue_value = primary_endpoints_value.get('queue', None)
                                if queue_value is not None:
                                    queue_instance = queue_value
                                    primary_endpoints_instance.queue = queue_instance
                                
                                table_value = primary_endpoints_value.get('table', None)
                                if table_value is not None:
                                    table_instance = table_value
                                    primary_endpoints_instance.table = table_instance
                                
                            primary_location_value = properties_value.get('primaryLocation', None)
                            if primary_location_value is not None:
                                primary_location_instance = primary_location_value
                                storage_account_json_instance.primary_location = primary_location_instance
                            
                            status_of_primary_value = properties_value.get('statusOfPrimary', None)
                            if status_of_primary_value is not None:
                                status_of_primary_instance = status_of_primary_value
                                storage_account_json_instance.status_of_primary = status_of_primary_instance
                            
                            last_geo_failover_time_value = properties_value.get('lastGeoFailoverTime', None)
                            if last_geo_failover_time_value is not None:
                                last_geo_failover_time_instance = last_geo_failover_time_value
                                storage_account_json_instance.last_geo_failover_time = last_geo_failover_time_instance
                            
                            secondary_location_value = properties_value.get('secondaryLocation', None)
                            if secondary_location_value is not None:
                                secondary_location_instance = secondary_location_value
                                storage_account_json_instance.secondary_location = secondary_location_instance
                            
                            status_of_secondary_value = properties_value.get('statusOfSecondary', None)
                            if status_of_secondary_value is not None:
                                status_of_secondary_instance = status_of_secondary_value
                                storage_account_json_instance.status_of_secondary = status_of_secondary_instance
                            
                            creation_time_value = properties_value.get('creationTime', None)
                            if creation_time_value is not None:
                                creation_time_instance = creation_time_value
                                storage_account_json_instance.creation_time = creation_time_instance
                            
                            custom_domain_value = properties_value.get('customDomain', None)
                            if custom_domain_value is not None:
                                custom_domain_instance = CustomDomain()
                                storage_account_json_instance.custom_domain = custom_domain_instance
                                
                                name_value2 = custom_domain_value.get('name', None)
                                if name_value2 is not None:
                                    name_instance2 = name_value2
                                    custom_domain_instance.name = name_instance2
                                
                                use_sub_domain_value = custom_domain_value.get('useSubDomain', None)
                                if use_sub_domain_value is not None:
                                    use_sub_domain_instance = use_sub_domain_value
                                    custom_domain_instance.use_sub_domain = use_sub_domain_instance
                                
                            secondary_endpoints_value = properties_value.get('secondaryEndpoints', None)
                            if secondary_endpoints_value is not None:
                                secondary_endpoints_instance = Endpoints()
                                storage_account_json_instance.secondary_endpoints = secondary_endpoints_instance
                                
                                blob_value2 = secondary_endpoints_value.get('blob', None)
                                if blob_value2 is not None:
                                    blob_instance2 = blob_value2
                                    secondary_endpoints_instance.blob = blob_instance2
                                
                                queue_value2 = secondary_endpoints_value.get('queue', None)
                                if queue_value2 is not None:
                                    queue_instance2 = queue_value2
                                    secondary_endpoints_instance.queue = queue_instance2
                                
                                table_value2 = secondary_endpoints_value.get('table', None)
                                if table_value2 is not None:
                                    table_instance2 = table_value2
                                    secondary_endpoints_instance.table = table_instance2
                                
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_keys(self, resource_group_name, account_name):
        """
         Lists the access keys for the specified storage account.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         account_name (string): The name of the storage account.
         
         Returns:
         
         StorageAccountListKeysResponse: The ListKeys operation response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if account_name is None:
            raise ValueError('account_name cannot be None.')
        
        if len(account_name) < 3:
            raise IndexError('account_name is outside the valid range.')
        
        if len(account_name) > 24:
            raise IndexError('account_name is outside the valid range.')
        
        for account_name_char in account_name:
            if account_name_char.islower() == False and account_name_char.isdigit() == False:
                raise IndexError('account_name is outside the valid range.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/Microsoft.Storage/storageAccounts/'
        url = url + quote(account_name)
        url = url + '/listKeys'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = StorageAccountListKeysResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                storage_account_keys_instance = StorageAccountKeys()
                result.storage_account_keys = storage_account_keys_instance
                
                key1_value = response_doc.get('key1', None)
                if key1_value is not None:
                    key1_instance = key1_value
                    storage_account_keys_instance.key1 = key1_instance
                
                key2_value = response_doc.get('key2', None)
                if key2_value is not None:
                    key2_instance = key2_value
                    storage_account_keys_instance.key2 = key2_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def regenerate_key(self, resource_group_name, account_name, regenerate_key):
        """
         Regenerates the access keys for the specified storage account.
         
         Args:
         
         resource_group_name (string): The name of the resource group within
         the user’s subscription.
         
         account_name (string): The name of the storage account within the
         specified resource group. Storage account names must be between 3 and
         24 characters in length and use numbers and lower-case letters only.
         
         regenerate_key (KeyName): Specifies name of the key which should be
         regenerated.
         
         Returns:
         
         StorageAccountRegenerateKeyResponse: The RegenerateKey operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if account_name is None:
            raise ValueError('account_name cannot be None.')
        
        if len(account_name) < 3:
            raise IndexError('account_name is outside the valid range.')
        
        if len(account_name) > 24:
            raise IndexError('account_name is outside the valid range.')
        
        for account_name_char in account_name:
            if account_name_char.islower() == False and account_name_char.isdigit() == False:
                raise IndexError('account_name is outside the valid range.')
            
        if regenerate_key is None:
            raise ValueError('regenerate_key cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/Microsoft.Storage/storageAccounts/'
        url = url + quote(account_name)
        url = url + '/regenerateKey'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        storage_account_regenerate_key_parameters_value = {}
        request_doc = storage_account_regenerate_key_parameters_value
        
        storage_account_regenerate_key_parameters_value['keyName'] = str(regenerate_key) if regenerate_key is not None else 'Key1'
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = StorageAccountRegenerateKeyResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                storage_account_keys_instance = StorageAccountKeys()
                result.storage_account_keys = storage_account_keys_instance
                
                key1_value = response_doc.get('key1', None)
                if key1_value is not None:
                    key1_instance = key1_value
                    storage_account_keys_instance.key1 = key1_instance
                
                key2_value = response_doc.get('key2', None)
                if key2_value is not None:
                    key2_instance = key2_value
                    storage_account_keys_instance.key2 = key2_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def update(self, resource_group_name, account_name, parameters):
        """
         Updates the account type or tags for a storage account. It can also be
         used to add a custom domain (note that custom domains cannot be added
         via the Create operation). Only one custom domain is supported per
         storage account. This API can only be used to update one of tags,
         accountType, or customDomain per call. To update multiple of these
         properties, call the API multiple times with one change per call.
         This call does not change the storage keys for the account. If you
         want to change storage account keys, use the RegenerateKey operation.
         The location and name of the storage account cannot be changed after
         creation.
         
         Args:
         
         resource_group_name (string): The name of the resource group within
         the user’s subscription.
         
         account_name (string): The name of the storage account within the
         specified resource group. Storage account names must be between 3 and
         24 characters in length and use numbers and lower-case letters only.
         
         parameters (StorageAccountUpdateParameters): The parameters to update
         on the account. Note that only one property can be changed at a time
         using this API.
         
         Returns:
         
         StorageAccountUpdateResponse: The Update storage account operation
         response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if account_name is None:
            raise ValueError('account_name cannot be None.')
        
        if len(account_name) < 3:
            raise IndexError('account_name is outside the valid range.')
        
        if len(account_name) > 24:
            raise IndexError('account_name is outside the valid range.')
        
        for account_name_char in account_name:
            if account_name_char.islower() == False and account_name_char.isdigit() == False:
                raise IndexError('account_name is outside the valid range.')
            
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.custom_domain is not None:
            if parameters.custom_domain.name is None:
                raise ValueError('parameters.custom_domain.name cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/Microsoft.Storage/storageAccounts/'
        url = url + quote(account_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PATCH'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        http_request.headers['x-ms-client-request-id'] = str(uuid.uuid4())
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        storage_account_update_parameters_json_value = {}
        request_doc = storage_account_update_parameters_json_value
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            storage_account_update_parameters_json_value['tags'] = tags_dictionary
        
        properties_value = {}
        storage_account_update_parameters_json_value['properties'] = properties_value
        
        if parameters.account_type is not None:
            properties_value['accountType'] = str(parameters.account_type) if parameters.account_type is not None else 'StandardLRS'
        
        if parameters.custom_domain is not None:
            custom_domain_value = {}
            properties_value['customDomain'] = custom_domain_value
            
            custom_domain_value['name'] = parameters.custom_domain.name
            
            if parameters.custom_domain.use_sub_domain is not None:
                custom_domain_value['useSubDomain'] = parameters.custom_domain.use_sub_domain
            
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = StorageAccountUpdateResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                storage_account_instance = StorageAccount(tags={})
                result.storage_account = storage_account_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    storage_account_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    storage_account_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    storage_account_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    storage_account_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        storage_account_instance.tags[tags_key2] = tags_value2
                    
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        storage_account_instance.provisioning_state = provisioning_state_instance
                    
                    account_type_value = properties_value2.get('accountType', None)
                    if account_type_value is not None:
                        account_type_instance = account_type_value
                        storage_account_instance.account_type = account_type_instance
                    
                    primary_endpoints_value = properties_value2.get('primaryEndpoints', None)
                    if primary_endpoints_value is not None:
                        primary_endpoints_instance = Endpoints()
                        storage_account_instance.primary_endpoints = primary_endpoints_instance
                        
                        blob_value = primary_endpoints_value.get('blob', None)
                        if blob_value is not None:
                            blob_instance = blob_value
                            primary_endpoints_instance.blob = blob_instance
                        
                        queue_value = primary_endpoints_value.get('queue', None)
                        if queue_value is not None:
                            queue_instance = queue_value
                            primary_endpoints_instance.queue = queue_instance
                        
                        table_value = primary_endpoints_value.get('table', None)
                        if table_value is not None:
                            table_instance = table_value
                            primary_endpoints_instance.table = table_instance
                        
                    primary_location_value = properties_value2.get('primaryLocation', None)
                    if primary_location_value is not None:
                        primary_location_instance = primary_location_value
                        storage_account_instance.primary_location = primary_location_instance
                    
                    status_of_primary_value = properties_value2.get('statusOfPrimary', None)
                    if status_of_primary_value is not None:
                        status_of_primary_instance = status_of_primary_value
                        storage_account_instance.status_of_primary = status_of_primary_instance
                    
                    last_geo_failover_time_value = properties_value2.get('lastGeoFailoverTime', None)
                    if last_geo_failover_time_value is not None:
                        last_geo_failover_time_instance = last_geo_failover_time_value
                        storage_account_instance.last_geo_failover_time = last_geo_failover_time_instance
                    
                    secondary_location_value = properties_value2.get('secondaryLocation', None)
                    if secondary_location_value is not None:
                        secondary_location_instance = secondary_location_value
                        storage_account_instance.secondary_location = secondary_location_instance
                    
                    status_of_secondary_value = properties_value2.get('statusOfSecondary', None)
                    if status_of_secondary_value is not None:
                        status_of_secondary_instance = status_of_secondary_value
                        storage_account_instance.status_of_secondary = status_of_secondary_instance
                    
                    creation_time_value = properties_value2.get('creationTime', None)
                    if creation_time_value is not None:
                        creation_time_instance = creation_time_value
                        storage_account_instance.creation_time = creation_time_instance
                    
                    custom_domain_value2 = properties_value2.get('customDomain', None)
                    if custom_domain_value2 is not None:
                        custom_domain_instance = CustomDomain()
                        storage_account_instance.custom_domain = custom_domain_instance
                        
                        name_value2 = custom_domain_value2.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            custom_domain_instance.name = name_instance2
                        
                        use_sub_domain_value = custom_domain_value2.get('useSubDomain', None)
                        if use_sub_domain_value is not None:
                            use_sub_domain_instance = use_sub_domain_value
                            custom_domain_instance.use_sub_domain = use_sub_domain_instance
                        
                    secondary_endpoints_value = properties_value2.get('secondaryEndpoints', None)
                    if secondary_endpoints_value is not None:
                        secondary_endpoints_instance = Endpoints()
                        storage_account_instance.secondary_endpoints = secondary_endpoints_instance
                        
                        blob_value2 = secondary_endpoints_value.get('blob', None)
                        if blob_value2 is not None:
                            blob_instance2 = blob_value2
                            secondary_endpoints_instance.blob = blob_instance2
                        
                        queue_value2 = secondary_endpoints_value.get('queue', None)
                        if queue_value2 is not None:
                            queue_instance2 = queue_value2
                            secondary_endpoints_instance.queue = queue_instance2
                        
                        table_value2 = secondary_endpoints_value.get('table', None)
                        if table_value2 is not None:
                            table_instance2 = table_value2
                            secondary_endpoints_instance.table = table_instance2
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
