
from django.utils.translation import ugettext_lazy as _

APPROVED = object()
DECLINED = object()

AS2805 = (
	("00", _("Approved or completed successfully"), APPROVED),
	("01", _("Refer to card issuer"), DECLINED),
	("02", _("Refer to card issuer's special conditions"), None),
	("03", _("Invalid merchant"), None),
	("04", _("Pick-up card"), DECLINED),
	("05", _("Do not honour"), DECLINED),
	("06", _("Error"), None),
	("07", _("Pick-up cart, special condition"), DECLINED),
	("08", _("Honour with identification"), APPROVED),
	("09", _("Request in progress"), None),
	("10", _("Approved for partial amount"), APPROVED),
	("11", _("Approved VIP"), APPROVED),
	("12", _("Invalid transaction (check card expiry, CVV)"), None),
	("13", _("Invalid amount"), None),
	("14", _("Invalid card number (no such number)"), DECLINED),
	("15", _("No such issuer"), DECLINED),
	("16", _("Approved, update Track 3"), APPROVED),
	("17", _("Customer cancellation"), None),
	("18", _("Customer dispute"), None),
	("19", _("Re-enter transaction"), DECLINED),
	("20", _("Invalid response"), None),
	("21", _("No action taken"), None),
	("22", _("Suspended malfunction"), None),
	("23", _("Unacceptable transaction fee"), DECLINED),
	("24", _("File update not supported by received"), None),
	("25", _("Unabled to locate record on file"), None),
	("26", _("Duplicate file update record, old record replaced"), None),
	("27", _("File update field edit error"), None),
	("28", _("File update file locked out"), None),
	("29", _("File update not successful, contact acquirer"), None),
	("30", _("Format error"), None),
	("31", _("Bank not supported by switch"), DECLINED),
	("32", _("Completed partially"), None),
	("33", _("Expired card"), DECLINED),
	("34", _("Suspected fraud"), DECLINED),
	("35", _("Card acceptor contact acquirer"), DECLINED),
	("36", _("Restricted card"), DECLINED),
	("37", _("Card acceptor call acquirer security"), DECLINED),
	("38", _("Allowable PIN tries exceeded"), DECLINED),
	("39", _("No credit account"), DECLINED),
	("40", _("Request function not supported"), DECLINED),
	("41", _("Lost card"), DECLINED),
	("42", _("No universal account"), DECLINED),
	("43", _("Stolen card, pick up"), DECLINED),
	("44", _("No investment account"), DECLINED),
	("45", _("Reserved for ISO use"), None),
	("46", _("Reserved for ISO use"), None),
	("47", _("Reserved for ISO use"), None),
	("48", _("Reserved for ISO use"), None),
	("49", _("Reserved for ISO use"), None),
	("50", _("Reserved for ISO use"), None),
	("51", _("Insufficient funds"), DECLINED),
	("52", _("No cheque account"), DECLINED),
	("53", _("No savings account"), DECLINED),
	("54", _("Expired card"), DECLINED),
	("55", _("Incorrect PIN"), DECLINED),
	("56", _("No card record"), None),
	("57", _("Transaction not permitted to cardholder"), DECLINED),
	("58", _("Transaction not permitted to terminal"), DECLINED),
	("59", _("Suspected fraud"), DECLINED),
	("60", _("Card acceptor contact acquirer"), DECLINED),
	("61", _("Exceeds withdrawal amount limits"), DECLINED),
	("62", _("Restricted card"), DECLINED),
	("63", _("Security violation"), None),
	("64", _("Original amount incorrect"), DECLINED),
	("65", _("Exceeds withdrawal frequency limit"), DECLINED),
	("66", _("Card acceptor call acquirer's security department"), DECLINED),
	("67", _("Hard capture (requires that card be picked up at ATM)"), DECLINED),
	("68", _("Response received too late"), None),
	("69", _("Reserved for ISO use"), None),
	("70", _("Reserved for ISO use"), None),
	("71", _("Reserved for ISO use"), None),
	("72", _("Reserved for ISO use"), None),
	("73", _("Reserved for ISO use"), None),
	("74", _("Reserved for ISO use"), None),
	("75", _("Allowable number of PIN tries exceeded"), DECLINED),
	("76", _("Reserved for private use"), None),
	("77", _("Transaction Approved [ANZ] / Reserved for private use"), APPROVED),
	("78", _("Reserved for private use"), None),
	("79", _("Reserved for private use"), None),
	("80", _("Reserved for private use"), None),
	("81", _("Reserved for private use"), None),
	("82", _("Reserved for private use"), None),
	("83", _("Reserved for private use"), None),
	("84", _("Reserved for private use"), None),
	("85", _("Reserved for private use"), None),
	("86", _("Reserved for private use"), None),
	("87", _("Reserved for private use"), None),
	("88", _("Reserved for private use"), None),
	("89", _("Reserved for private use"), None),
	("90", _("Cut-off is in process (Switch ending a day's business and starting the next. The transaction can be sent again in a few minutes)"), None),
	("91", _("Issuer or switch is inoperative"), DECLINED),
	("92", _("Financial institution or intermediate network facility cannot be found for routing"), DECLINED),
	("93", _("Transaction cannot be completed. Violation of law"), DECLINED),
	("94", _("Duplicate transmission"), None),
	("95", _("Reconcile error"), None),
	("96", _("System malfunction"), None),
	("97", _("Advises that reconciliation totals have been reset"), None),
	("98", _("MAC error"), DECLINED),
	("99", _("Reserved for national use"), None),
)

AS2805_DESCRIPTION = dict([(code, description) for code, description, __ in AS2805])
AS2805_RESULT = dict([(code, result) for code, __, result in AS2805])

