# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationGatewayOnDemandProbe(Model):
    """Details of on demand test probe request.

    :param protocol: The protocol used for the probe. Possible values include:
     'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is
     sent to <Protocol>://<host>:<port><path>
    :type path: str
    :param timeout: The probe timeout in seconds. Probe marked as failed if
     valid response is not received with this timeout period. Acceptable values
     are from 1 second to 86400 seconds.
    :type timeout: int
    :param pick_host_name_from_backend_http_settings: Whether the host header
     should be picked from the backend http settings. Default value is false.
    :type pick_host_name_from_backend_http_settings: bool
    :param match: Criterion for classifying a healthy probe response.
    :type match:
     ~azure.mgmt.network.v2019_02_01.models.ApplicationGatewayProbeHealthResponseMatch
    :param backend_pool_name: Name of backend pool of application gateway to
     which probe request will be sent.
    :type backend_pool_name: str
    :param backend_http_setting_name: Name of backend http setting of
     application gateway to be used for test probe
    :type backend_http_setting_name: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'pick_host_name_from_backend_http_settings': {'key': 'pickHostNameFromBackendHttpSettings', 'type': 'bool'},
        'match': {'key': 'match', 'type': 'ApplicationGatewayProbeHealthResponseMatch'},
        'backend_pool_name': {'key': 'backendPoolName', 'type': 'str'},
        'backend_http_setting_name': {'key': 'backendHttpSettingName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayOnDemandProbe, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', None)
        self.host = kwargs.get('host', None)
        self.path = kwargs.get('path', None)
        self.timeout = kwargs.get('timeout', None)
        self.pick_host_name_from_backend_http_settings = kwargs.get('pick_host_name_from_backend_http_settings', None)
        self.match = kwargs.get('match', None)
        self.backend_pool_name = kwargs.get('backend_pool_name', None)
        self.backend_http_setting_name = kwargs.get('backend_http_setting_name', None)
