(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(["underscore", "jquery", "common/has_properties", "common/collection", "numeral"], function(_, $, HasProperties, Collection, Numeral) {
    var BooleanFormatter, BooleanFormatters, CellFormatter, CellFormatterCollection, NumberFormatter, NumberFormatters, StringFormatter, StringFormatters, _ref, _ref1, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7;
    CellFormatter = (function(_super) {
      __extends(CellFormatter, _super);

      function CellFormatter() {
        _ref = CellFormatter.__super__.constructor.apply(this, arguments);
        return _ref;
      }

      CellFormatter.prototype.format = function(row, cell, value, columnDef, dataContext) {
        if (value === null) {
          return "";
        } else {
          return (value + "").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
        }
      };

      return CellFormatter;

    })(HasProperties);
    CellFormatterCollection = (function(_super) {
      __extends(CellFormatterCollection, _super);

      function CellFormatterCollection() {
        _ref1 = CellFormatterCollection.__super__.constructor.apply(this, arguments);
        return _ref1;
      }

      CellFormatterCollection.prototype.formatterDefaults = {};

      CellFormatterCollection.prototype.defaults = function() {
        return _.extend({}, CellFormatterCollection.__super__.defaults.call(this), this.formatterDefaults);
      };

      return CellFormatterCollection;

    })(Collection);
    StringFormatter = (function(_super) {
      __extends(StringFormatter, _super);

      function StringFormatter() {
        _ref2 = StringFormatter.__super__.constructor.apply(this, arguments);
        return _ref2;
      }

      StringFormatter.prototype.type = 'StringFormatter';

      StringFormatter.prototype.format = function(row, cell, value, columnDef, dataContext) {
        var font_style, text, text_align, text_color;
        text = StringFormatter.__super__.format.call(this, row, cell, value, columnDef, dataContext);
        font_style = this.get("font_style");
        text_align = this.get("text_align");
        text_color = this.get("text_color");
        if ((font_style != null) || (text_align != null) || (text_color != null)) {
          text = $("<span>" + text + "</span>");
          switch (font_style) {
            case "bold":
              text = text.css("font-weight", "bold");
              break;
            case "italic":
              text = text.css("font-style", "italic");
          }
          if (text_align != null) {
            text = text.css("text-align", text_align);
          }
          if (text_color != null) {
            text = text.css("color", text_color);
          }
          text = text.prop('outerHTML');
        }
        return text;
      };

      return StringFormatter;

    })(CellFormatter);
    StringFormatters = (function(_super) {
      __extends(StringFormatters, _super);

      function StringFormatters() {
        _ref3 = StringFormatters.__super__.constructor.apply(this, arguments);
        return _ref3;
      }

      StringFormatters.prototype.model = StringFormatter;

      StringFormatters.prototype.formatterDefaults = {
        font_style: null,
        text_align: null,
        text_color: null
      };

      return StringFormatters;

    })(CellFormatterCollection);
    NumberFormatter = (function(_super) {
      __extends(NumberFormatter, _super);

      function NumberFormatter() {
        _ref4 = NumberFormatter.__super__.constructor.apply(this, arguments);
        return _ref4;
      }

      NumberFormatter.prototype.type = 'NumberFormatter';

      NumberFormatter.prototype.format = function(row, cell, value, columnDef, dataContext) {
        Numeral.language(this.get("language"));
        value = Numeral(value).format(this.get("format"));
        return NumberFormatter.__super__.format.call(this, row, cell, value, columnDef, dataContext);
      };

      return NumberFormatter;

    })(StringFormatter);
    NumberFormatters = (function(_super) {
      __extends(NumberFormatters, _super);

      function NumberFormatters() {
        _ref5 = NumberFormatters.__super__.constructor.apply(this, arguments);
        return _ref5;
      }

      NumberFormatters.prototype.model = NumberFormatter;

      NumberFormatters.prototype.formatterDefaults = {
        font_style: null,
        text_align: null,
        text_color: null,
        format: '0,0',
        language: 'en'
      };

      return NumberFormatters;

    })(CellFormatterCollection);
    BooleanFormatter = (function(_super) {
      __extends(BooleanFormatter, _super);

      function BooleanFormatter() {
        _ref6 = BooleanFormatter.__super__.constructor.apply(this, arguments);
        return _ref6;
      }

      BooleanFormatter.prototype.type = 'BooleanFormatter';

      BooleanFormatter.prototype.format = function(row, cell, value, columnDef, dataContext) {
        if (!!value) {
          return $('<i>').addClass(this.get("icon")).html();
        } else {
          return "";
        }
      };

      return BooleanFormatter;

    })(CellFormatter);
    BooleanFormatters = (function(_super) {
      __extends(BooleanFormatters, _super);

      function BooleanFormatters() {
        _ref7 = BooleanFormatters.__super__.constructor.apply(this, arguments);
        return _ref7;
      }

      BooleanFormatters.prototype.model = BooleanFormatter;

      BooleanFormatters.prototype.formatterDefaults = {
        icon: 'check'
      };

      return BooleanFormatters;

    })(CellFormatterCollection);
    return {
      String: {
        Model: StringFormatter,
        Collection: new StringFormatters()
      },
      Number: {
        Model: NumberFormatter,
        Collection: new NumberFormatters()
      },
      Boolean: {
        Model: BooleanFormatter,
        Collection: new BooleanFormatters()
      }
    };
  });

}).call(this);

/*
//@ sourceMappingURL=cell_formatters.js.map
*/