# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

try:
    from .network_interface_tap_configuration_py3 import NetworkInterfaceTapConfiguration
    from .sub_resource_py3 import SubResource
    from .application_security_group_py3 import ApplicationSecurityGroup
    from .security_rule_py3 import SecurityRule
    from .endpoint_service_py3 import EndpointService
    from .interface_endpoint_py3 import InterfaceEndpoint
    from .network_interface_dns_settings_py3 import NetworkInterfaceDnsSettings
    from .network_interface_py3 import NetworkInterface
    from .network_security_group_py3 import NetworkSecurityGroup
    from .route_py3 import Route
    from .route_table_py3 import RouteTable
    from .service_endpoint_properties_format_py3 import ServiceEndpointPropertiesFormat
    from .service_endpoint_policy_definition_py3 import ServiceEndpointPolicyDefinition
    from .service_endpoint_policy_py3 import ServiceEndpointPolicy
    from .public_ip_address_sku_py3 import PublicIPAddressSku
    from .public_ip_address_dns_settings_py3 import PublicIPAddressDnsSettings
    from .ip_tag_py3 import IpTag
    from .public_ip_address_py3 import PublicIPAddress
    from .ip_configuration_py3 import IPConfiguration
    from .ip_configuration_profile_py3 import IPConfigurationProfile
    from .resource_navigation_link_py3 import ResourceNavigationLink
    from .service_association_link_py3 import ServiceAssociationLink
    from .delegation_py3 import Delegation
    from .subnet_py3 import Subnet
    from .frontend_ip_configuration_py3 import FrontendIPConfiguration
    from .virtual_network_tap_py3 import VirtualNetworkTap
    from .backend_address_pool_py3 import BackendAddressPool
    from .inbound_nat_rule_py3 import InboundNatRule
    from .network_interface_ip_configuration_py3 import NetworkInterfaceIPConfiguration
    from .application_gateway_backend_address_py3 import ApplicationGatewayBackendAddress
    from .application_gateway_backend_address_pool_py3 import ApplicationGatewayBackendAddressPool
    from .application_gateway_connection_draining_py3 import ApplicationGatewayConnectionDraining
    from .application_gateway_backend_http_settings_py3 import ApplicationGatewayBackendHttpSettings
    from .application_gateway_backend_health_server_py3 import ApplicationGatewayBackendHealthServer
    from .application_gateway_backend_health_http_settings_py3 import ApplicationGatewayBackendHealthHttpSettings
    from .application_gateway_backend_health_pool_py3 import ApplicationGatewayBackendHealthPool
    from .application_gateway_backend_health_py3 import ApplicationGatewayBackendHealth
    from .application_gateway_sku_py3 import ApplicationGatewaySku
    from .application_gateway_ssl_policy_py3 import ApplicationGatewaySslPolicy
    from .application_gateway_ip_configuration_py3 import ApplicationGatewayIPConfiguration
    from .application_gateway_authentication_certificate_py3 import ApplicationGatewayAuthenticationCertificate
    from .application_gateway_trusted_root_certificate_py3 import ApplicationGatewayTrustedRootCertificate
    from .application_gateway_ssl_certificate_py3 import ApplicationGatewaySslCertificate
    from .application_gateway_frontend_ip_configuration_py3 import ApplicationGatewayFrontendIPConfiguration
    from .application_gateway_frontend_port_py3 import ApplicationGatewayFrontendPort
    from .application_gateway_http_listener_py3 import ApplicationGatewayHttpListener
    from .application_gateway_path_rule_py3 import ApplicationGatewayPathRule
    from .application_gateway_probe_health_response_match_py3 import ApplicationGatewayProbeHealthResponseMatch
    from .application_gateway_probe_py3 import ApplicationGatewayProbe
    from .application_gateway_request_routing_rule_py3 import ApplicationGatewayRequestRoutingRule
    from .application_gateway_redirect_configuration_py3 import ApplicationGatewayRedirectConfiguration
    from .application_gateway_url_path_map_py3 import ApplicationGatewayUrlPathMap
    from .application_gateway_firewall_disabled_rule_group_py3 import ApplicationGatewayFirewallDisabledRuleGroup
    from .application_gateway_web_application_firewall_configuration_py3 import ApplicationGatewayWebApplicationFirewallConfiguration
    from .application_gateway_autoscale_configuration_py3 import ApplicationGatewayAutoscaleConfiguration
    from .application_gateway_py3 import ApplicationGateway
    from .application_gateway_firewall_rule_py3 import ApplicationGatewayFirewallRule
    from .application_gateway_firewall_rule_group_py3 import ApplicationGatewayFirewallRuleGroup
    from .application_gateway_firewall_rule_set_py3 import ApplicationGatewayFirewallRuleSet
    from .application_gateway_available_waf_rule_sets_result_py3 import ApplicationGatewayAvailableWafRuleSetsResult
    from .application_gateway_available_ssl_options_py3 import ApplicationGatewayAvailableSslOptions
    from .application_gateway_ssl_predefined_policy_py3 import ApplicationGatewaySslPredefinedPolicy
    from .resource_py3 import Resource
    from .tags_object_py3 import TagsObject
    from .available_delegation_py3 import AvailableDelegation
    from .azure_firewall_ip_configuration_py3 import AzureFirewallIPConfiguration
    from .azure_firewall_rc_action_py3 import AzureFirewallRCAction
    from .azure_firewall_application_rule_protocol_py3 import AzureFirewallApplicationRuleProtocol
    from .azure_firewall_application_rule_py3 import AzureFirewallApplicationRule
    from .azure_firewall_application_rule_collection_py3 import AzureFirewallApplicationRuleCollection
    from .azure_firewall_nat_rc_action_py3 import AzureFirewallNatRCAction
    from .azure_firewall_nat_rule_py3 import AzureFirewallNatRule
    from .azure_firewall_nat_rule_collection_py3 import AzureFirewallNatRuleCollection
    from .azure_firewall_network_rule_py3 import AzureFirewallNetworkRule
    from .azure_firewall_network_rule_collection_py3 import AzureFirewallNetworkRuleCollection
    from .azure_firewall_py3 import AzureFirewall
    from .azure_firewall_fqdn_tag_py3 import AzureFirewallFqdnTag
    from .dns_name_availability_result_py3 import DnsNameAvailabilityResult
    from .ddos_protection_plan_py3 import DdosProtectionPlan
    from .endpoint_service_result_py3 import EndpointServiceResult
    from .express_route_circuit_authorization_py3 import ExpressRouteCircuitAuthorization
    from .express_route_circuit_peering_config_py3 import ExpressRouteCircuitPeeringConfig
    from .route_filter_rule_py3 import RouteFilterRule
    from .express_route_circuit_stats_py3 import ExpressRouteCircuitStats
    from .express_route_connection_id_py3 import ExpressRouteConnectionId
    from .express_route_circuit_connection_py3 import ExpressRouteCircuitConnection
    from .express_route_circuit_peering_py3 import ExpressRouteCircuitPeering
    from .route_filter_py3 import RouteFilter
    from .ipv6_express_route_circuit_peering_config_py3 import Ipv6ExpressRouteCircuitPeeringConfig
    from .express_route_circuit_sku_py3 import ExpressRouteCircuitSku
    from .express_route_circuit_service_provider_properties_py3 import ExpressRouteCircuitServiceProviderProperties
    from .express_route_circuit_py3 import ExpressRouteCircuit
    from .express_route_circuit_arp_table_py3 import ExpressRouteCircuitArpTable
    from .express_route_circuits_arp_table_list_result_py3 import ExpressRouteCircuitsArpTableListResult
    from .express_route_circuit_routes_table_py3 import ExpressRouteCircuitRoutesTable
    from .express_route_circuits_routes_table_list_result_py3 import ExpressRouteCircuitsRoutesTableListResult
    from .express_route_circuit_routes_table_summary_py3 import ExpressRouteCircuitRoutesTableSummary
    from .express_route_circuits_routes_table_summary_list_result_py3 import ExpressRouteCircuitsRoutesTableSummaryListResult
    from .express_route_service_provider_bandwidths_offered_py3 import ExpressRouteServiceProviderBandwidthsOffered
    from .express_route_service_provider_py3 import ExpressRouteServiceProvider
    from .express_route_cross_connection_routes_table_summary_py3 import ExpressRouteCrossConnectionRoutesTableSummary
    from .express_route_cross_connections_routes_table_summary_list_result_py3 import ExpressRouteCrossConnectionsRoutesTableSummaryListResult
    from .express_route_circuit_reference_py3 import ExpressRouteCircuitReference
    from .express_route_cross_connection_peering_py3 import ExpressRouteCrossConnectionPeering
    from .express_route_cross_connection_py3 import ExpressRouteCrossConnection
    from .virtual_hub_id_py3 import VirtualHubId
    from .express_route_circuit_peering_id_py3 import ExpressRouteCircuitPeeringId
    from .express_route_gateway_properties_auto_scale_configuration_bounds_py3 import ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
    from .express_route_gateway_properties_auto_scale_configuration_py3 import ExpressRouteGatewayPropertiesAutoScaleConfiguration
    from .express_route_connection_py3 import ExpressRouteConnection
    from .express_route_gateway_py3 import ExpressRouteGateway
    from .express_route_gateway_list_py3 import ExpressRouteGatewayList
    from .express_route_connection_list_py3 import ExpressRouteConnectionList
    from .load_balancer_sku_py3 import LoadBalancerSku
    from .load_balancing_rule_py3 import LoadBalancingRule
    from .probe_py3 import Probe
    from .inbound_nat_pool_py3 import InboundNatPool
    from .outbound_rule_py3 import OutboundRule
    from .load_balancer_py3 import LoadBalancer
    from .error_details_py3 import ErrorDetails
    from .error_py3 import Error, ErrorException
    from .azure_async_operation_result_py3 import AzureAsyncOperationResult
    from .effective_network_security_group_association_py3 import EffectiveNetworkSecurityGroupAssociation
    from .effective_network_security_rule_py3 import EffectiveNetworkSecurityRule
    from .effective_network_security_group_py3 import EffectiveNetworkSecurityGroup
    from .effective_network_security_group_list_result_py3 import EffectiveNetworkSecurityGroupListResult
    from .effective_route_py3 import EffectiveRoute
    from .effective_route_list_result_py3 import EffectiveRouteListResult
    from .container_network_interface_configuration_py3 import ContainerNetworkInterfaceConfiguration
    from .container_py3 import Container
    from .container_network_interface_ip_configuration_py3 import ContainerNetworkInterfaceIpConfiguration
    from .container_network_interface_py3 import ContainerNetworkInterface
    from .network_profile_py3 import NetworkProfile
    from .error_response_py3 import ErrorResponse, ErrorResponseException
    from .network_watcher_py3 import NetworkWatcher
    from .topology_parameters_py3 import TopologyParameters
    from .topology_association_py3 import TopologyAssociation
    from .topology_resource_py3 import TopologyResource
    from .topology_py3 import Topology
    from .verification_ip_flow_parameters_py3 import VerificationIPFlowParameters
    from .verification_ip_flow_result_py3 import VerificationIPFlowResult
    from .next_hop_parameters_py3 import NextHopParameters
    from .next_hop_result_py3 import NextHopResult
    from .security_group_view_parameters_py3 import SecurityGroupViewParameters
    from .network_interface_association_py3 import NetworkInterfaceAssociation
    from .subnet_association_py3 import SubnetAssociation
    from .security_rule_associations_py3 import SecurityRuleAssociations
    from .security_group_network_interface_py3 import SecurityGroupNetworkInterface
    from .security_group_view_result_py3 import SecurityGroupViewResult
    from .packet_capture_storage_location_py3 import PacketCaptureStorageLocation
    from .packet_capture_filter_py3 import PacketCaptureFilter
    from .packet_capture_parameters_py3 import PacketCaptureParameters
    from .packet_capture_py3 import PacketCapture
    from .packet_capture_result_py3 import PacketCaptureResult
    from .packet_capture_query_status_result_py3 import PacketCaptureQueryStatusResult
    from .troubleshooting_parameters_py3 import TroubleshootingParameters
    from .query_troubleshooting_parameters_py3 import QueryTroubleshootingParameters
    from .troubleshooting_recommended_actions_py3 import TroubleshootingRecommendedActions
    from .troubleshooting_details_py3 import TroubleshootingDetails
    from .troubleshooting_result_py3 import TroubleshootingResult
    from .retention_policy_parameters_py3 import RetentionPolicyParameters
    from .flow_log_status_parameters_py3 import FlowLogStatusParameters
    from .traffic_analytics_configuration_properties_py3 import TrafficAnalyticsConfigurationProperties
    from .traffic_analytics_properties_py3 import TrafficAnalyticsProperties
    from .flow_log_information_py3 import FlowLogInformation
    from .connectivity_source_py3 import ConnectivitySource
    from .connectivity_destination_py3 import ConnectivityDestination
    from .http_header_py3 import HTTPHeader
    from .http_configuration_py3 import HTTPConfiguration
    from .protocol_configuration_py3 import ProtocolConfiguration
    from .connectivity_parameters_py3 import ConnectivityParameters
    from .connectivity_issue_py3 import ConnectivityIssue
    from .connectivity_hop_py3 import ConnectivityHop
    from .connectivity_information_py3 import ConnectivityInformation
    from .azure_reachability_report_location_py3 import AzureReachabilityReportLocation
    from .azure_reachability_report_parameters_py3 import AzureReachabilityReportParameters
    from .azure_reachability_report_latency_info_py3 import AzureReachabilityReportLatencyInfo
    from .azure_reachability_report_item_py3 import AzureReachabilityReportItem
    from .azure_reachability_report_py3 import AzureReachabilityReport
    from .available_providers_list_parameters_py3 import AvailableProvidersListParameters
    from .available_providers_list_city_py3 import AvailableProvidersListCity
    from .available_providers_list_state_py3 import AvailableProvidersListState
    from .available_providers_list_country_py3 import AvailableProvidersListCountry
    from .available_providers_list_py3 import AvailableProvidersList
    from .connection_monitor_source_py3 import ConnectionMonitorSource
    from .connection_monitor_destination_py3 import ConnectionMonitorDestination
    from .connection_monitor_parameters_py3 import ConnectionMonitorParameters
    from .connection_monitor_py3 import ConnectionMonitor
    from .connection_monitor_result_py3 import ConnectionMonitorResult
    from .connection_state_snapshot_py3 import ConnectionStateSnapshot
    from .connection_monitor_query_result_py3 import ConnectionMonitorQueryResult
    from .traffic_query_py3 import TrafficQuery
    from .network_configuration_diagnostic_parameters_py3 import NetworkConfigurationDiagnosticParameters
    from .matched_rule_py3 import MatchedRule
    from .network_security_rules_evaluation_result_py3 import NetworkSecurityRulesEvaluationResult
    from .evaluated_network_security_group_py3 import EvaluatedNetworkSecurityGroup
    from .network_security_group_result_py3 import NetworkSecurityGroupResult
    from .network_configuration_diagnostic_result_py3 import NetworkConfigurationDiagnosticResult
    from .network_configuration_diagnostic_response_py3 import NetworkConfigurationDiagnosticResponse
    from .operation_display_py3 import OperationDisplay
    from .availability_py3 import Availability
    from .dimension_py3 import Dimension
    from .metric_specification_py3 import MetricSpecification
    from .log_specification_py3 import LogSpecification
    from .operation_properties_format_service_specification_py3 import OperationPropertiesFormatServiceSpecification
    from .operation_py3 import Operation
    from .public_ip_prefix_sku_py3 import PublicIPPrefixSku
    from .referenced_public_ip_address_py3 import ReferencedPublicIpAddress
    from .public_ip_prefix_py3 import PublicIPPrefix
    from .patch_route_filter_rule_py3 import PatchRouteFilterRule
    from .patch_route_filter_py3 import PatchRouteFilter
    from .bgp_community_py3 import BGPCommunity
    from .bgp_service_community_py3 import BgpServiceCommunity
    from .usage_name_py3 import UsageName
    from .usage_py3 import Usage
    from .address_space_py3 import AddressSpace
    from .virtual_network_peering_py3 import VirtualNetworkPeering
    from .dhcp_options_py3 import DhcpOptions
    from .virtual_network_py3 import VirtualNetwork
    from .ip_address_availability_result_py3 import IPAddressAvailabilityResult
    from .virtual_network_usage_name_py3 import VirtualNetworkUsageName
    from .virtual_network_usage_py3 import VirtualNetworkUsage
    from .virtual_network_gateway_ip_configuration_py3 import VirtualNetworkGatewayIPConfiguration
    from .virtual_network_gateway_sku_py3 import VirtualNetworkGatewaySku
    from .vpn_client_root_certificate_py3 import VpnClientRootCertificate
    from .vpn_client_revoked_certificate_py3 import VpnClientRevokedCertificate
    from .ipsec_policy_py3 import IpsecPolicy
    from .vpn_client_configuration_py3 import VpnClientConfiguration
    from .bgp_settings_py3 import BgpSettings
    from .bgp_peer_status_py3 import BgpPeerStatus
    from .gateway_route_py3 import GatewayRoute
    from .virtual_network_gateway_py3 import VirtualNetworkGateway
    from .vpn_client_parameters_py3 import VpnClientParameters
    from .bgp_peer_status_list_result_py3 import BgpPeerStatusListResult
    from .gateway_route_list_result_py3 import GatewayRouteListResult
    from .tunnel_connection_health_py3 import TunnelConnectionHealth
    from .local_network_gateway_py3 import LocalNetworkGateway
    from .virtual_network_gateway_connection_py3 import VirtualNetworkGatewayConnection
    from .connection_reset_shared_key_py3 import ConnectionResetSharedKey
    from .connection_shared_key_py3 import ConnectionSharedKey
    from .vpn_client_ipsec_parameters_py3 import VpnClientIPsecParameters
    from .virtual_network_connection_gateway_reference_py3 import VirtualNetworkConnectionGatewayReference
    from .virtual_network_gateway_connection_list_entity_py3 import VirtualNetworkGatewayConnectionListEntity
    from .vpn_device_script_parameters_py3 import VpnDeviceScriptParameters
    from .p2_svpn_server_config_vpn_client_root_certificate_py3 import P2SVpnServerConfigVpnClientRootCertificate
    from .p2_svpn_server_config_vpn_client_revoked_certificate_py3 import P2SVpnServerConfigVpnClientRevokedCertificate
    from .p2_svpn_server_config_radius_server_root_certificate_py3 import P2SVpnServerConfigRadiusServerRootCertificate
    from .p2_svpn_server_config_radius_client_root_certificate_py3 import P2SVpnServerConfigRadiusClientRootCertificate
    from .p2_svpn_server_configuration_py3 import P2SVpnServerConfiguration
    from .virtual_wan_py3 import VirtualWAN
    from .device_properties_py3 import DeviceProperties
    from .vpn_site_py3 import VpnSite
    from .get_vpn_sites_configuration_request_py3 import GetVpnSitesConfigurationRequest
    from .hub_virtual_network_connection_py3 import HubVirtualNetworkConnection
    from .virtual_hub_route_py3 import VirtualHubRoute
    from .virtual_hub_route_table_py3 import VirtualHubRouteTable
    from .virtual_hub_py3 import VirtualHub
    from .vpn_connection_py3 import VpnConnection
    from .vpn_gateway_py3 import VpnGateway
    from .vpn_site_id_py3 import VpnSiteId
    from .virtual_wan_security_provider_py3 import VirtualWanSecurityProvider
    from .virtual_wan_security_providers_py3 import VirtualWanSecurityProviders
    from .vpn_client_connection_health_py3 import VpnClientConnectionHealth
    from .p2_svpn_gateway_py3 import P2SVpnGateway
    from .p2_svpn_profile_parameters_py3 import P2SVpnProfileParameters
    from .vpn_profile_response_py3 import VpnProfileResponse
except (SyntaxError, ImportError):
    from .network_interface_tap_configuration import NetworkInterfaceTapConfiguration
    from .sub_resource import SubResource
    from .application_security_group import ApplicationSecurityGroup
    from .security_rule import SecurityRule
    from .endpoint_service import EndpointService
    from .interface_endpoint import InterfaceEndpoint
    from .network_interface_dns_settings import NetworkInterfaceDnsSettings
    from .network_interface import NetworkInterface
    from .network_security_group import NetworkSecurityGroup
    from .route import Route
    from .route_table import RouteTable
    from .service_endpoint_properties_format import ServiceEndpointPropertiesFormat
    from .service_endpoint_policy_definition import ServiceEndpointPolicyDefinition
    from .service_endpoint_policy import ServiceEndpointPolicy
    from .public_ip_address_sku import PublicIPAddressSku
    from .public_ip_address_dns_settings import PublicIPAddressDnsSettings
    from .ip_tag import IpTag
    from .public_ip_address import PublicIPAddress
    from .ip_configuration import IPConfiguration
    from .ip_configuration_profile import IPConfigurationProfile
    from .resource_navigation_link import ResourceNavigationLink
    from .service_association_link import ServiceAssociationLink
    from .delegation import Delegation
    from .subnet import Subnet
    from .frontend_ip_configuration import FrontendIPConfiguration
    from .virtual_network_tap import VirtualNetworkTap
    from .backend_address_pool import BackendAddressPool
    from .inbound_nat_rule import InboundNatRule
    from .network_interface_ip_configuration import NetworkInterfaceIPConfiguration
    from .application_gateway_backend_address import ApplicationGatewayBackendAddress
    from .application_gateway_backend_address_pool import ApplicationGatewayBackendAddressPool
    from .application_gateway_connection_draining import ApplicationGatewayConnectionDraining
    from .application_gateway_backend_http_settings import ApplicationGatewayBackendHttpSettings
    from .application_gateway_backend_health_server import ApplicationGatewayBackendHealthServer
    from .application_gateway_backend_health_http_settings import ApplicationGatewayBackendHealthHttpSettings
    from .application_gateway_backend_health_pool import ApplicationGatewayBackendHealthPool
    from .application_gateway_backend_health import ApplicationGatewayBackendHealth
    from .application_gateway_sku import ApplicationGatewaySku
    from .application_gateway_ssl_policy import ApplicationGatewaySslPolicy
    from .application_gateway_ip_configuration import ApplicationGatewayIPConfiguration
    from .application_gateway_authentication_certificate import ApplicationGatewayAuthenticationCertificate
    from .application_gateway_trusted_root_certificate import ApplicationGatewayTrustedRootCertificate
    from .application_gateway_ssl_certificate import ApplicationGatewaySslCertificate
    from .application_gateway_frontend_ip_configuration import ApplicationGatewayFrontendIPConfiguration
    from .application_gateway_frontend_port import ApplicationGatewayFrontendPort
    from .application_gateway_http_listener import ApplicationGatewayHttpListener
    from .application_gateway_path_rule import ApplicationGatewayPathRule
    from .application_gateway_probe_health_response_match import ApplicationGatewayProbeHealthResponseMatch
    from .application_gateway_probe import ApplicationGatewayProbe
    from .application_gateway_request_routing_rule import ApplicationGatewayRequestRoutingRule
    from .application_gateway_redirect_configuration import ApplicationGatewayRedirectConfiguration
    from .application_gateway_url_path_map import ApplicationGatewayUrlPathMap
    from .application_gateway_firewall_disabled_rule_group import ApplicationGatewayFirewallDisabledRuleGroup
    from .application_gateway_web_application_firewall_configuration import ApplicationGatewayWebApplicationFirewallConfiguration
    from .application_gateway_autoscale_configuration import ApplicationGatewayAutoscaleConfiguration
    from .application_gateway import ApplicationGateway
    from .application_gateway_firewall_rule import ApplicationGatewayFirewallRule
    from .application_gateway_firewall_rule_group import ApplicationGatewayFirewallRuleGroup
    from .application_gateway_firewall_rule_set import ApplicationGatewayFirewallRuleSet
    from .application_gateway_available_waf_rule_sets_result import ApplicationGatewayAvailableWafRuleSetsResult
    from .application_gateway_available_ssl_options import ApplicationGatewayAvailableSslOptions
    from .application_gateway_ssl_predefined_policy import ApplicationGatewaySslPredefinedPolicy
    from .resource import Resource
    from .tags_object import TagsObject
    from .available_delegation import AvailableDelegation
    from .azure_firewall_ip_configuration import AzureFirewallIPConfiguration
    from .azure_firewall_rc_action import AzureFirewallRCAction
    from .azure_firewall_application_rule_protocol import AzureFirewallApplicationRuleProtocol
    from .azure_firewall_application_rule import AzureFirewallApplicationRule
    from .azure_firewall_application_rule_collection import AzureFirewallApplicationRuleCollection
    from .azure_firewall_nat_rc_action import AzureFirewallNatRCAction
    from .azure_firewall_nat_rule import AzureFirewallNatRule
    from .azure_firewall_nat_rule_collection import AzureFirewallNatRuleCollection
    from .azure_firewall_network_rule import AzureFirewallNetworkRule
    from .azure_firewall_network_rule_collection import AzureFirewallNetworkRuleCollection
    from .azure_firewall import AzureFirewall
    from .azure_firewall_fqdn_tag import AzureFirewallFqdnTag
    from .dns_name_availability_result import DnsNameAvailabilityResult
    from .ddos_protection_plan import DdosProtectionPlan
    from .endpoint_service_result import EndpointServiceResult
    from .express_route_circuit_authorization import ExpressRouteCircuitAuthorization
    from .express_route_circuit_peering_config import ExpressRouteCircuitPeeringConfig
    from .route_filter_rule import RouteFilterRule
    from .express_route_circuit_stats import ExpressRouteCircuitStats
    from .express_route_connection_id import ExpressRouteConnectionId
    from .express_route_circuit_connection import ExpressRouteCircuitConnection
    from .express_route_circuit_peering import ExpressRouteCircuitPeering
    from .route_filter import RouteFilter
    from .ipv6_express_route_circuit_peering_config import Ipv6ExpressRouteCircuitPeeringConfig
    from .express_route_circuit_sku import ExpressRouteCircuitSku
    from .express_route_circuit_service_provider_properties import ExpressRouteCircuitServiceProviderProperties
    from .express_route_circuit import ExpressRouteCircuit
    from .express_route_circuit_arp_table import ExpressRouteCircuitArpTable
    from .express_route_circuits_arp_table_list_result import ExpressRouteCircuitsArpTableListResult
    from .express_route_circuit_routes_table import ExpressRouteCircuitRoutesTable
    from .express_route_circuits_routes_table_list_result import ExpressRouteCircuitsRoutesTableListResult
    from .express_route_circuit_routes_table_summary import ExpressRouteCircuitRoutesTableSummary
    from .express_route_circuits_routes_table_summary_list_result import ExpressRouteCircuitsRoutesTableSummaryListResult
    from .express_route_service_provider_bandwidths_offered import ExpressRouteServiceProviderBandwidthsOffered
    from .express_route_service_provider import ExpressRouteServiceProvider
    from .express_route_cross_connection_routes_table_summary import ExpressRouteCrossConnectionRoutesTableSummary
    from .express_route_cross_connections_routes_table_summary_list_result import ExpressRouteCrossConnectionsRoutesTableSummaryListResult
    from .express_route_circuit_reference import ExpressRouteCircuitReference
    from .express_route_cross_connection_peering import ExpressRouteCrossConnectionPeering
    from .express_route_cross_connection import ExpressRouteCrossConnection
    from .virtual_hub_id import VirtualHubId
    from .express_route_circuit_peering_id import ExpressRouteCircuitPeeringId
    from .express_route_gateway_properties_auto_scale_configuration_bounds import ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
    from .express_route_gateway_properties_auto_scale_configuration import ExpressRouteGatewayPropertiesAutoScaleConfiguration
    from .express_route_connection import ExpressRouteConnection
    from .express_route_gateway import ExpressRouteGateway
    from .express_route_gateway_list import ExpressRouteGatewayList
    from .express_route_connection_list import ExpressRouteConnectionList
    from .load_balancer_sku import LoadBalancerSku
    from .load_balancing_rule import LoadBalancingRule
    from .probe import Probe
    from .inbound_nat_pool import InboundNatPool
    from .outbound_rule import OutboundRule
    from .load_balancer import LoadBalancer
    from .error_details import ErrorDetails
    from .error import Error, ErrorException
    from .azure_async_operation_result import AzureAsyncOperationResult
    from .effective_network_security_group_association import EffectiveNetworkSecurityGroupAssociation
    from .effective_network_security_rule import EffectiveNetworkSecurityRule
    from .effective_network_security_group import EffectiveNetworkSecurityGroup
    from .effective_network_security_group_list_result import EffectiveNetworkSecurityGroupListResult
    from .effective_route import EffectiveRoute
    from .effective_route_list_result import EffectiveRouteListResult
    from .container_network_interface_configuration import ContainerNetworkInterfaceConfiguration
    from .container import Container
    from .container_network_interface_ip_configuration import ContainerNetworkInterfaceIpConfiguration
    from .container_network_interface import ContainerNetworkInterface
    from .network_profile import NetworkProfile
    from .error_response import ErrorResponse, ErrorResponseException
    from .network_watcher import NetworkWatcher
    from .topology_parameters import TopologyParameters
    from .topology_association import TopologyAssociation
    from .topology_resource import TopologyResource
    from .topology import Topology
    from .verification_ip_flow_parameters import VerificationIPFlowParameters
    from .verification_ip_flow_result import VerificationIPFlowResult
    from .next_hop_parameters import NextHopParameters
    from .next_hop_result import NextHopResult
    from .security_group_view_parameters import SecurityGroupViewParameters
    from .network_interface_association import NetworkInterfaceAssociation
    from .subnet_association import SubnetAssociation
    from .security_rule_associations import SecurityRuleAssociations
    from .security_group_network_interface import SecurityGroupNetworkInterface
    from .security_group_view_result import SecurityGroupViewResult
    from .packet_capture_storage_location import PacketCaptureStorageLocation
    from .packet_capture_filter import PacketCaptureFilter
    from .packet_capture_parameters import PacketCaptureParameters
    from .packet_capture import PacketCapture
    from .packet_capture_result import PacketCaptureResult
    from .packet_capture_query_status_result import PacketCaptureQueryStatusResult
    from .troubleshooting_parameters import TroubleshootingParameters
    from .query_troubleshooting_parameters import QueryTroubleshootingParameters
    from .troubleshooting_recommended_actions import TroubleshootingRecommendedActions
    from .troubleshooting_details import TroubleshootingDetails
    from .troubleshooting_result import TroubleshootingResult
    from .retention_policy_parameters import RetentionPolicyParameters
    from .flow_log_status_parameters import FlowLogStatusParameters
    from .traffic_analytics_configuration_properties import TrafficAnalyticsConfigurationProperties
    from .traffic_analytics_properties import TrafficAnalyticsProperties
    from .flow_log_information import FlowLogInformation
    from .connectivity_source import ConnectivitySource
    from .connectivity_destination import ConnectivityDestination
    from .http_header import HTTPHeader
    from .http_configuration import HTTPConfiguration
    from .protocol_configuration import ProtocolConfiguration
    from .connectivity_parameters import ConnectivityParameters
    from .connectivity_issue import ConnectivityIssue
    from .connectivity_hop import ConnectivityHop
    from .connectivity_information import ConnectivityInformation
    from .azure_reachability_report_location import AzureReachabilityReportLocation
    from .azure_reachability_report_parameters import AzureReachabilityReportParameters
    from .azure_reachability_report_latency_info import AzureReachabilityReportLatencyInfo
    from .azure_reachability_report_item import AzureReachabilityReportItem
    from .azure_reachability_report import AzureReachabilityReport
    from .available_providers_list_parameters import AvailableProvidersListParameters
    from .available_providers_list_city import AvailableProvidersListCity
    from .available_providers_list_state import AvailableProvidersListState
    from .available_providers_list_country import AvailableProvidersListCountry
    from .available_providers_list import AvailableProvidersList
    from .connection_monitor_source import ConnectionMonitorSource
    from .connection_monitor_destination import ConnectionMonitorDestination
    from .connection_monitor_parameters import ConnectionMonitorParameters
    from .connection_monitor import ConnectionMonitor
    from .connection_monitor_result import ConnectionMonitorResult
    from .connection_state_snapshot import ConnectionStateSnapshot
    from .connection_monitor_query_result import ConnectionMonitorQueryResult
    from .traffic_query import TrafficQuery
    from .network_configuration_diagnostic_parameters import NetworkConfigurationDiagnosticParameters
    from .matched_rule import MatchedRule
    from .network_security_rules_evaluation_result import NetworkSecurityRulesEvaluationResult
    from .evaluated_network_security_group import EvaluatedNetworkSecurityGroup
    from .network_security_group_result import NetworkSecurityGroupResult
    from .network_configuration_diagnostic_result import NetworkConfigurationDiagnosticResult
    from .network_configuration_diagnostic_response import NetworkConfigurationDiagnosticResponse
    from .operation_display import OperationDisplay
    from .availability import Availability
    from .dimension import Dimension
    from .metric_specification import MetricSpecification
    from .log_specification import LogSpecification
    from .operation_properties_format_service_specification import OperationPropertiesFormatServiceSpecification
    from .operation import Operation
    from .public_ip_prefix_sku import PublicIPPrefixSku
    from .referenced_public_ip_address import ReferencedPublicIpAddress
    from .public_ip_prefix import PublicIPPrefix
    from .patch_route_filter_rule import PatchRouteFilterRule
    from .patch_route_filter import PatchRouteFilter
    from .bgp_community import BGPCommunity
    from .bgp_service_community import BgpServiceCommunity
    from .usage_name import UsageName
    from .usage import Usage
    from .address_space import AddressSpace
    from .virtual_network_peering import VirtualNetworkPeering
    from .dhcp_options import DhcpOptions
    from .virtual_network import VirtualNetwork
    from .ip_address_availability_result import IPAddressAvailabilityResult
    from .virtual_network_usage_name import VirtualNetworkUsageName
    from .virtual_network_usage import VirtualNetworkUsage
    from .virtual_network_gateway_ip_configuration import VirtualNetworkGatewayIPConfiguration
    from .virtual_network_gateway_sku import VirtualNetworkGatewaySku
    from .vpn_client_root_certificate import VpnClientRootCertificate
    from .vpn_client_revoked_certificate import VpnClientRevokedCertificate
    from .ipsec_policy import IpsecPolicy
    from .vpn_client_configuration import VpnClientConfiguration
    from .bgp_settings import BgpSettings
    from .bgp_peer_status import BgpPeerStatus
    from .gateway_route import GatewayRoute
    from .virtual_network_gateway import VirtualNetworkGateway
    from .vpn_client_parameters import VpnClientParameters
    from .bgp_peer_status_list_result import BgpPeerStatusListResult
    from .gateway_route_list_result import GatewayRouteListResult
    from .tunnel_connection_health import TunnelConnectionHealth
    from .local_network_gateway import LocalNetworkGateway
    from .virtual_network_gateway_connection import VirtualNetworkGatewayConnection
    from .connection_reset_shared_key import ConnectionResetSharedKey
    from .connection_shared_key import ConnectionSharedKey
    from .vpn_client_ipsec_parameters import VpnClientIPsecParameters
    from .virtual_network_connection_gateway_reference import VirtualNetworkConnectionGatewayReference
    from .virtual_network_gateway_connection_list_entity import VirtualNetworkGatewayConnectionListEntity
    from .vpn_device_script_parameters import VpnDeviceScriptParameters
    from .p2_svpn_server_config_vpn_client_root_certificate import P2SVpnServerConfigVpnClientRootCertificate
    from .p2_svpn_server_config_vpn_client_revoked_certificate import P2SVpnServerConfigVpnClientRevokedCertificate
    from .p2_svpn_server_config_radius_server_root_certificate import P2SVpnServerConfigRadiusServerRootCertificate
    from .p2_svpn_server_config_radius_client_root_certificate import P2SVpnServerConfigRadiusClientRootCertificate
    from .p2_svpn_server_configuration import P2SVpnServerConfiguration
    from .virtual_wan import VirtualWAN
    from .device_properties import DeviceProperties
    from .vpn_site import VpnSite
    from .get_vpn_sites_configuration_request import GetVpnSitesConfigurationRequest
    from .hub_virtual_network_connection import HubVirtualNetworkConnection
    from .virtual_hub_route import VirtualHubRoute
    from .virtual_hub_route_table import VirtualHubRouteTable
    from .virtual_hub import VirtualHub
    from .vpn_connection import VpnConnection
    from .vpn_gateway import VpnGateway
    from .vpn_site_id import VpnSiteId
    from .virtual_wan_security_provider import VirtualWanSecurityProvider
    from .virtual_wan_security_providers import VirtualWanSecurityProviders
    from .vpn_client_connection_health import VpnClientConnectionHealth
    from .p2_svpn_gateway import P2SVpnGateway
    from .p2_svpn_profile_parameters import P2SVpnProfileParameters
    from .vpn_profile_response import VpnProfileResponse
from .application_gateway_paged import ApplicationGatewayPaged
from .application_gateway_ssl_predefined_policy_paged import ApplicationGatewaySslPredefinedPolicyPaged
from .application_security_group_paged import ApplicationSecurityGroupPaged
from .available_delegation_paged import AvailableDelegationPaged
from .azure_firewall_paged import AzureFirewallPaged
from .azure_firewall_fqdn_tag_paged import AzureFirewallFqdnTagPaged
from .ddos_protection_plan_paged import DdosProtectionPlanPaged
from .endpoint_service_result_paged import EndpointServiceResultPaged
from .express_route_circuit_authorization_paged import ExpressRouteCircuitAuthorizationPaged
from .express_route_circuit_peering_paged import ExpressRouteCircuitPeeringPaged
from .express_route_circuit_paged import ExpressRouteCircuitPaged
from .express_route_service_provider_paged import ExpressRouteServiceProviderPaged
from .express_route_cross_connection_paged import ExpressRouteCrossConnectionPaged
from .express_route_cross_connection_peering_paged import ExpressRouteCrossConnectionPeeringPaged
from .interface_endpoint_paged import InterfaceEndpointPaged
from .load_balancer_paged import LoadBalancerPaged
from .backend_address_pool_paged import BackendAddressPoolPaged
from .frontend_ip_configuration_paged import FrontendIPConfigurationPaged
from .inbound_nat_rule_paged import InboundNatRulePaged
from .load_balancing_rule_paged import LoadBalancingRulePaged
from .network_interface_paged import NetworkInterfacePaged
from .probe_paged import ProbePaged
from .network_interface_ip_configuration_paged import NetworkInterfaceIPConfigurationPaged
from .network_interface_tap_configuration_paged import NetworkInterfaceTapConfigurationPaged
from .network_profile_paged import NetworkProfilePaged
from .network_security_group_paged import NetworkSecurityGroupPaged
from .security_rule_paged import SecurityRulePaged
from .network_watcher_paged import NetworkWatcherPaged
from .packet_capture_result_paged import PacketCaptureResultPaged
from .connection_monitor_result_paged import ConnectionMonitorResultPaged
from .operation_paged import OperationPaged
from .public_ip_address_paged import PublicIPAddressPaged
from .public_ip_prefix_paged import PublicIPPrefixPaged
from .route_filter_paged import RouteFilterPaged
from .route_filter_rule_paged import RouteFilterRulePaged
from .route_table_paged import RouteTablePaged
from .route_paged import RoutePaged
from .bgp_service_community_paged import BgpServiceCommunityPaged
from .service_endpoint_policy_paged import ServiceEndpointPolicyPaged
from .service_endpoint_policy_definition_paged import ServiceEndpointPolicyDefinitionPaged
from .usage_paged import UsagePaged
from .virtual_network_paged import VirtualNetworkPaged
from .virtual_network_usage_paged import VirtualNetworkUsagePaged
from .subnet_paged import SubnetPaged
from .virtual_network_peering_paged import VirtualNetworkPeeringPaged
from .virtual_network_tap_paged import VirtualNetworkTapPaged
from .virtual_network_gateway_paged import VirtualNetworkGatewayPaged
from .virtual_network_gateway_connection_list_entity_paged import VirtualNetworkGatewayConnectionListEntityPaged
from .virtual_network_gateway_connection_paged import VirtualNetworkGatewayConnectionPaged
from .local_network_gateway_paged import LocalNetworkGatewayPaged
from .virtual_wan_paged import VirtualWANPaged
from .vpn_site_paged import VpnSitePaged
from .virtual_hub_paged import VirtualHubPaged
from .hub_virtual_network_connection_paged import HubVirtualNetworkConnectionPaged
from .vpn_gateway_paged import VpnGatewayPaged
from .vpn_connection_paged import VpnConnectionPaged
from .p2_svpn_server_configuration_paged import P2SVpnServerConfigurationPaged
from .p2_svpn_gateway_paged import P2SVpnGatewayPaged
from .network_management_client_enums import (
    IPAllocationMethod,
    SecurityRuleProtocol,
    SecurityRuleAccess,
    SecurityRuleDirection,
    RouteNextHopType,
    PublicIPAddressSkuName,
    IPVersion,
    TransportProtocol,
    ApplicationGatewayProtocol,
    ApplicationGatewayCookieBasedAffinity,
    ApplicationGatewayBackendHealthServerHealth,
    ApplicationGatewaySkuName,
    ApplicationGatewayTier,
    ApplicationGatewaySslProtocol,
    ApplicationGatewaySslPolicyType,
    ApplicationGatewaySslPolicyName,
    ApplicationGatewaySslCipherSuite,
    ApplicationGatewayRequestRoutingRuleType,
    ApplicationGatewayRedirectType,
    ApplicationGatewayOperationalState,
    ApplicationGatewayFirewallMode,
    ProvisioningState,
    AzureFirewallRCActionType,
    AzureFirewallApplicationRuleProtocolType,
    AzureFirewallNatRCActionType,
    AzureFirewallNetworkRuleProtocol,
    AuthorizationUseStatus,
    ExpressRouteCircuitPeeringAdvertisedPublicPrefixState,
    Access,
    ExpressRoutePeeringType,
    ExpressRoutePeeringState,
    CircuitConnectionStatus,
    ExpressRouteCircuitPeeringState,
    ExpressRouteCircuitSkuTier,
    ExpressRouteCircuitSkuFamily,
    ServiceProviderProvisioningState,
    LoadBalancerSkuName,
    LoadDistribution,
    ProbeProtocol,
    NetworkOperationStatus,
    EffectiveSecurityRuleProtocol,
    EffectiveRouteSource,
    EffectiveRouteState,
    AssociationType,
    Direction,
    IpFlowProtocol,
    NextHopType,
    PcProtocol,
    PcStatus,
    PcError,
    Protocol,
    HTTPMethod,
    Origin,
    Severity,
    IssueType,
    ConnectionStatus,
    ConnectionMonitorSourceStatus,
    ConnectionState,
    EvaluationState,
    PublicIPPrefixSkuName,
    VirtualNetworkPeeringState,
    VirtualNetworkGatewayType,
    VpnType,
    VirtualNetworkGatewaySkuName,
    VirtualNetworkGatewaySkuTier,
    VpnClientProtocol,
    IpsecEncryption,
    IpsecIntegrity,
    IkeEncryption,
    IkeIntegrity,
    DhGroup,
    PfsGroup,
    BgpPeerState,
    ProcessorArchitecture,
    AuthenticationMethod,
    VirtualNetworkGatewayConnectionStatus,
    VirtualNetworkGatewayConnectionType,
    VirtualNetworkGatewayConnectionProtocol,
    OfficeTrafficCategory,
    VpnGatewayTunnelingProtocol,
    VpnConnectionStatus,
    VirtualWanSecurityProviderType,
    TunnelConnectionStatus,
    HubVirtualNetworkConnectionStatus,
)

__all__ = [
    'NetworkInterfaceTapConfiguration',
    'SubResource',
    'ApplicationSecurityGroup',
    'SecurityRule',
    'EndpointService',
    'InterfaceEndpoint',
    'NetworkInterfaceDnsSettings',
    'NetworkInterface',
    'NetworkSecurityGroup',
    'Route',
    'RouteTable',
    'ServiceEndpointPropertiesFormat',
    'ServiceEndpointPolicyDefinition',
    'ServiceEndpointPolicy',
    'PublicIPAddressSku',
    'PublicIPAddressDnsSettings',
    'IpTag',
    'PublicIPAddress',
    'IPConfiguration',
    'IPConfigurationProfile',
    'ResourceNavigationLink',
    'ServiceAssociationLink',
    'Delegation',
    'Subnet',
    'FrontendIPConfiguration',
    'VirtualNetworkTap',
    'BackendAddressPool',
    'InboundNatRule',
    'NetworkInterfaceIPConfiguration',
    'ApplicationGatewayBackendAddress',
    'ApplicationGatewayBackendAddressPool',
    'ApplicationGatewayConnectionDraining',
    'ApplicationGatewayBackendHttpSettings',
    'ApplicationGatewayBackendHealthServer',
    'ApplicationGatewayBackendHealthHttpSettings',
    'ApplicationGatewayBackendHealthPool',
    'ApplicationGatewayBackendHealth',
    'ApplicationGatewaySku',
    'ApplicationGatewaySslPolicy',
    'ApplicationGatewayIPConfiguration',
    'ApplicationGatewayAuthenticationCertificate',
    'ApplicationGatewayTrustedRootCertificate',
    'ApplicationGatewaySslCertificate',
    'ApplicationGatewayFrontendIPConfiguration',
    'ApplicationGatewayFrontendPort',
    'ApplicationGatewayHttpListener',
    'ApplicationGatewayPathRule',
    'ApplicationGatewayProbeHealthResponseMatch',
    'ApplicationGatewayProbe',
    'ApplicationGatewayRequestRoutingRule',
    'ApplicationGatewayRedirectConfiguration',
    'ApplicationGatewayUrlPathMap',
    'ApplicationGatewayFirewallDisabledRuleGroup',
    'ApplicationGatewayWebApplicationFirewallConfiguration',
    'ApplicationGatewayAutoscaleConfiguration',
    'ApplicationGateway',
    'ApplicationGatewayFirewallRule',
    'ApplicationGatewayFirewallRuleGroup',
    'ApplicationGatewayFirewallRuleSet',
    'ApplicationGatewayAvailableWafRuleSetsResult',
    'ApplicationGatewayAvailableSslOptions',
    'ApplicationGatewaySslPredefinedPolicy',
    'Resource',
    'TagsObject',
    'AvailableDelegation',
    'AzureFirewallIPConfiguration',
    'AzureFirewallRCAction',
    'AzureFirewallApplicationRuleProtocol',
    'AzureFirewallApplicationRule',
    'AzureFirewallApplicationRuleCollection',
    'AzureFirewallNatRCAction',
    'AzureFirewallNatRule',
    'AzureFirewallNatRuleCollection',
    'AzureFirewallNetworkRule',
    'AzureFirewallNetworkRuleCollection',
    'AzureFirewall',
    'AzureFirewallFqdnTag',
    'DnsNameAvailabilityResult',
    'DdosProtectionPlan',
    'EndpointServiceResult',
    'ExpressRouteCircuitAuthorization',
    'ExpressRouteCircuitPeeringConfig',
    'RouteFilterRule',
    'ExpressRouteCircuitStats',
    'ExpressRouteConnectionId',
    'ExpressRouteCircuitConnection',
    'ExpressRouteCircuitPeering',
    'RouteFilter',
    'Ipv6ExpressRouteCircuitPeeringConfig',
    'ExpressRouteCircuitSku',
    'ExpressRouteCircuitServiceProviderProperties',
    'ExpressRouteCircuit',
    'ExpressRouteCircuitArpTable',
    'ExpressRouteCircuitsArpTableListResult',
    'ExpressRouteCircuitRoutesTable',
    'ExpressRouteCircuitsRoutesTableListResult',
    'ExpressRouteCircuitRoutesTableSummary',
    'ExpressRouteCircuitsRoutesTableSummaryListResult',
    'ExpressRouteServiceProviderBandwidthsOffered',
    'ExpressRouteServiceProvider',
    'ExpressRouteCrossConnectionRoutesTableSummary',
    'ExpressRouteCrossConnectionsRoutesTableSummaryListResult',
    'ExpressRouteCircuitReference',
    'ExpressRouteCrossConnectionPeering',
    'ExpressRouteCrossConnection',
    'VirtualHubId',
    'ExpressRouteCircuitPeeringId',
    'ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds',
    'ExpressRouteGatewayPropertiesAutoScaleConfiguration',
    'ExpressRouteConnection',
    'ExpressRouteGateway',
    'ExpressRouteGatewayList',
    'ExpressRouteConnectionList',
    'LoadBalancerSku',
    'LoadBalancingRule',
    'Probe',
    'InboundNatPool',
    'OutboundRule',
    'LoadBalancer',
    'ErrorDetails',
    'Error', 'ErrorException',
    'AzureAsyncOperationResult',
    'EffectiveNetworkSecurityGroupAssociation',
    'EffectiveNetworkSecurityRule',
    'EffectiveNetworkSecurityGroup',
    'EffectiveNetworkSecurityGroupListResult',
    'EffectiveRoute',
    'EffectiveRouteListResult',
    'ContainerNetworkInterfaceConfiguration',
    'Container',
    'ContainerNetworkInterfaceIpConfiguration',
    'ContainerNetworkInterface',
    'NetworkProfile',
    'ErrorResponse', 'ErrorResponseException',
    'NetworkWatcher',
    'TopologyParameters',
    'TopologyAssociation',
    'TopologyResource',
    'Topology',
    'VerificationIPFlowParameters',
    'VerificationIPFlowResult',
    'NextHopParameters',
    'NextHopResult',
    'SecurityGroupViewParameters',
    'NetworkInterfaceAssociation',
    'SubnetAssociation',
    'SecurityRuleAssociations',
    'SecurityGroupNetworkInterface',
    'SecurityGroupViewResult',
    'PacketCaptureStorageLocation',
    'PacketCaptureFilter',
    'PacketCaptureParameters',
    'PacketCapture',
    'PacketCaptureResult',
    'PacketCaptureQueryStatusResult',
    'TroubleshootingParameters',
    'QueryTroubleshootingParameters',
    'TroubleshootingRecommendedActions',
    'TroubleshootingDetails',
    'TroubleshootingResult',
    'RetentionPolicyParameters',
    'FlowLogStatusParameters',
    'TrafficAnalyticsConfigurationProperties',
    'TrafficAnalyticsProperties',
    'FlowLogInformation',
    'ConnectivitySource',
    'ConnectivityDestination',
    'HTTPHeader',
    'HTTPConfiguration',
    'ProtocolConfiguration',
    'ConnectivityParameters',
    'ConnectivityIssue',
    'ConnectivityHop',
    'ConnectivityInformation',
    'AzureReachabilityReportLocation',
    'AzureReachabilityReportParameters',
    'AzureReachabilityReportLatencyInfo',
    'AzureReachabilityReportItem',
    'AzureReachabilityReport',
    'AvailableProvidersListParameters',
    'AvailableProvidersListCity',
    'AvailableProvidersListState',
    'AvailableProvidersListCountry',
    'AvailableProvidersList',
    'ConnectionMonitorSource',
    'ConnectionMonitorDestination',
    'ConnectionMonitorParameters',
    'ConnectionMonitor',
    'ConnectionMonitorResult',
    'ConnectionStateSnapshot',
    'ConnectionMonitorQueryResult',
    'TrafficQuery',
    'NetworkConfigurationDiagnosticParameters',
    'MatchedRule',
    'NetworkSecurityRulesEvaluationResult',
    'EvaluatedNetworkSecurityGroup',
    'NetworkSecurityGroupResult',
    'NetworkConfigurationDiagnosticResult',
    'NetworkConfigurationDiagnosticResponse',
    'OperationDisplay',
    'Availability',
    'Dimension',
    'MetricSpecification',
    'LogSpecification',
    'OperationPropertiesFormatServiceSpecification',
    'Operation',
    'PublicIPPrefixSku',
    'ReferencedPublicIpAddress',
    'PublicIPPrefix',
    'PatchRouteFilterRule',
    'PatchRouteFilter',
    'BGPCommunity',
    'BgpServiceCommunity',
    'UsageName',
    'Usage',
    'AddressSpace',
    'VirtualNetworkPeering',
    'DhcpOptions',
    'VirtualNetwork',
    'IPAddressAvailabilityResult',
    'VirtualNetworkUsageName',
    'VirtualNetworkUsage',
    'VirtualNetworkGatewayIPConfiguration',
    'VirtualNetworkGatewaySku',
    'VpnClientRootCertificate',
    'VpnClientRevokedCertificate',
    'IpsecPolicy',
    'VpnClientConfiguration',
    'BgpSettings',
    'BgpPeerStatus',
    'GatewayRoute',
    'VirtualNetworkGateway',
    'VpnClientParameters',
    'BgpPeerStatusListResult',
    'GatewayRouteListResult',
    'TunnelConnectionHealth',
    'LocalNetworkGateway',
    'VirtualNetworkGatewayConnection',
    'ConnectionResetSharedKey',
    'ConnectionSharedKey',
    'VpnClientIPsecParameters',
    'VirtualNetworkConnectionGatewayReference',
    'VirtualNetworkGatewayConnectionListEntity',
    'VpnDeviceScriptParameters',
    'P2SVpnServerConfigVpnClientRootCertificate',
    'P2SVpnServerConfigVpnClientRevokedCertificate',
    'P2SVpnServerConfigRadiusServerRootCertificate',
    'P2SVpnServerConfigRadiusClientRootCertificate',
    'P2SVpnServerConfiguration',
    'VirtualWAN',
    'DeviceProperties',
    'VpnSite',
    'GetVpnSitesConfigurationRequest',
    'HubVirtualNetworkConnection',
    'VirtualHubRoute',
    'VirtualHubRouteTable',
    'VirtualHub',
    'VpnConnection',
    'VpnGateway',
    'VpnSiteId',
    'VirtualWanSecurityProvider',
    'VirtualWanSecurityProviders',
    'VpnClientConnectionHealth',
    'P2SVpnGateway',
    'P2SVpnProfileParameters',
    'VpnProfileResponse',
    'ApplicationGatewayPaged',
    'ApplicationGatewaySslPredefinedPolicyPaged',
    'ApplicationSecurityGroupPaged',
    'AvailableDelegationPaged',
    'AzureFirewallPaged',
    'AzureFirewallFqdnTagPaged',
    'DdosProtectionPlanPaged',
    'EndpointServiceResultPaged',
    'ExpressRouteCircuitAuthorizationPaged',
    'ExpressRouteCircuitPeeringPaged',
    'ExpressRouteCircuitPaged',
    'ExpressRouteServiceProviderPaged',
    'ExpressRouteCrossConnectionPaged',
    'ExpressRouteCrossConnectionPeeringPaged',
    'InterfaceEndpointPaged',
    'LoadBalancerPaged',
    'BackendAddressPoolPaged',
    'FrontendIPConfigurationPaged',
    'InboundNatRulePaged',
    'LoadBalancingRulePaged',
    'NetworkInterfacePaged',
    'ProbePaged',
    'NetworkInterfaceIPConfigurationPaged',
    'NetworkInterfaceTapConfigurationPaged',
    'NetworkProfilePaged',
    'NetworkSecurityGroupPaged',
    'SecurityRulePaged',
    'NetworkWatcherPaged',
    'PacketCaptureResultPaged',
    'ConnectionMonitorResultPaged',
    'OperationPaged',
    'PublicIPAddressPaged',
    'PublicIPPrefixPaged',
    'RouteFilterPaged',
    'RouteFilterRulePaged',
    'RouteTablePaged',
    'RoutePaged',
    'BgpServiceCommunityPaged',
    'ServiceEndpointPolicyPaged',
    'ServiceEndpointPolicyDefinitionPaged',
    'UsagePaged',
    'VirtualNetworkPaged',
    'VirtualNetworkUsagePaged',
    'SubnetPaged',
    'VirtualNetworkPeeringPaged',
    'VirtualNetworkTapPaged',
    'VirtualNetworkGatewayPaged',
    'VirtualNetworkGatewayConnectionListEntityPaged',
    'VirtualNetworkGatewayConnectionPaged',
    'LocalNetworkGatewayPaged',
    'VirtualWANPaged',
    'VpnSitePaged',
    'VirtualHubPaged',
    'HubVirtualNetworkConnectionPaged',
    'VpnGatewayPaged',
    'VpnConnectionPaged',
    'P2SVpnServerConfigurationPaged',
    'P2SVpnGatewayPaged',
    'IPAllocationMethod',
    'SecurityRuleProtocol',
    'SecurityRuleAccess',
    'SecurityRuleDirection',
    'RouteNextHopType',
    'PublicIPAddressSkuName',
    'IPVersion',
    'TransportProtocol',
    'ApplicationGatewayProtocol',
    'ApplicationGatewayCookieBasedAffinity',
    'ApplicationGatewayBackendHealthServerHealth',
    'ApplicationGatewaySkuName',
    'ApplicationGatewayTier',
    'ApplicationGatewaySslProtocol',
    'ApplicationGatewaySslPolicyType',
    'ApplicationGatewaySslPolicyName',
    'ApplicationGatewaySslCipherSuite',
    'ApplicationGatewayRequestRoutingRuleType',
    'ApplicationGatewayRedirectType',
    'ApplicationGatewayOperationalState',
    'ApplicationGatewayFirewallMode',
    'ProvisioningState',
    'AzureFirewallRCActionType',
    'AzureFirewallApplicationRuleProtocolType',
    'AzureFirewallNatRCActionType',
    'AzureFirewallNetworkRuleProtocol',
    'AuthorizationUseStatus',
    'ExpressRouteCircuitPeeringAdvertisedPublicPrefixState',
    'Access',
    'ExpressRoutePeeringType',
    'ExpressRoutePeeringState',
    'CircuitConnectionStatus',
    'ExpressRouteCircuitPeeringState',
    'ExpressRouteCircuitSkuTier',
    'ExpressRouteCircuitSkuFamily',
    'ServiceProviderProvisioningState',
    'LoadBalancerSkuName',
    'LoadDistribution',
    'ProbeProtocol',
    'NetworkOperationStatus',
    'EffectiveSecurityRuleProtocol',
    'EffectiveRouteSource',
    'EffectiveRouteState',
    'AssociationType',
    'Direction',
    'IpFlowProtocol',
    'NextHopType',
    'PcProtocol',
    'PcStatus',
    'PcError',
    'Protocol',
    'HTTPMethod',
    'Origin',
    'Severity',
    'IssueType',
    'ConnectionStatus',
    'ConnectionMonitorSourceStatus',
    'ConnectionState',
    'EvaluationState',
    'PublicIPPrefixSkuName',
    'VirtualNetworkPeeringState',
    'VirtualNetworkGatewayType',
    'VpnType',
    'VirtualNetworkGatewaySkuName',
    'VirtualNetworkGatewaySkuTier',
    'VpnClientProtocol',
    'IpsecEncryption',
    'IpsecIntegrity',
    'IkeEncryption',
    'IkeIntegrity',
    'DhGroup',
    'PfsGroup',
    'BgpPeerState',
    'ProcessorArchitecture',
    'AuthenticationMethod',
    'VirtualNetworkGatewayConnectionStatus',
    'VirtualNetworkGatewayConnectionType',
    'VirtualNetworkGatewayConnectionProtocol',
    'OfficeTrafficCategory',
    'VpnGatewayTunnelingProtocol',
    'VpnConnectionStatus',
    'VirtualWanSecurityProviderType',
    'TunnelConnectionStatus',
    'HubVirtualNetworkConnectionStatus',
]
