*** Settings ***

Resource  plone/app/robotframework/selenium.robot
Resource  plone/app/robotframework/keywords.robot
Resource  plone/app/robotframework/saucelabs.robot
Resource  plone/app/robotframework/annotate.robot
Resource  plone/app/robotframework/speak.robot

Library  Remote  ${PLONE_URL}/RobotRemote

Test Setup  Open SauceLabs test browser
Test Teardown  Run keywords  Report test status  Close all browsers

*** Keywords ***

Add fading numbered dot
    [Arguments]  ${locator}  ${number}
    ${dot} =  Add numbered dot  ${locator}  ${number}  display=none
    Update element style  ${dot}  -moz-transform  scale(4)
    Update element style  ${dot}  display  block
    Update element style  ${dot}  -moz-transition  all 1s
    Update element style  ${dot}  -moz-transform  scale(1)
    Sleep  1s
    [return]  ${dot}

Add spoken note
    [Arguments]  ${locator}  ${message}  ${position}=${EMPTY}
    ${note} =  Add note  ${locator}  ${message}
    ...        display=none  position=${position}
    Speak  ${message}
    Update element style  ${note}  opacity  0
    Update element style  ${note}  display  block
    Update element style  ${note}  -moz-transition  opacity 1s
    Update element style  ${note}  opacity  1
    Sleep  2s
    [return]  ${note}

*** Test cases ***

Introducing Mr. Roboto
    Go to  ${PLONE_URL}
    Sleep  1s

    Update element style  visual-portal-wrapper  -moz-transition  all 2s
    Update element style  visual-portal-wrapper  -moz-transform  rotate(180deg) scale(0)
    Update element style  visual-portal-wrapper  margin-top  50%
    Sleep  3s

    Speak  Don't be afaid.
    Sleep  2s

    Speak  I am now controlling the transmission.
    Sleep  4s

    Speak  I am mister roboto
    Sleep  2s

    Update element style  visual-portal-wrapper  -moz-transform  scale(1) rotate(0deg)
    Update element style  visual-portal-wrapper  margin-top  0%

    Speak  Welcome to Plone
    Sleep  2s

    Enable autologin as  Site Administrator
    Set autologin username   Mr. Roboto

    Go to  ${PLONE_URL}
    Sleep  0.5s

    ${dot} =  Add fading numbered dot  user-name  1
    ${note} =  Add spoken note  user-name  This is me.  position=bottom
    Remove elements  ${dot}  ${note}

    ${dot} =  Add fading numbered dot  portaltab-index_html  2
    ${note} =  Add spoken note  portaltab-index_html  This is my home,
    ...        position=bottom
    Remove elements  ${dot}  ${note}

    ${dot} =  Add fading numbered dot  content  3
    ${note} =  Add spoken note  portal-footer  and here's all my stuff.
    ...        position=top
    Remove elements  ${dot}  ${note}

    ${dot} =  Add fading numbered dot  portal-logo  4
    ${note} =  Add spoken note  portal-logo  Plone is my best friend,
    ...        position=bottom
    Remove elements  ${dot}  ${note}


    Speak  but I love you all.
    Sleep  2s
    Speak  Please, don't break my builds.
    Sleep  4s
    Speak  'asta la vistaa.
    Sleep  3s

    ${dot} =  Add dot  jquery=#user-name
    Sleep  0.5s
    Click element  css=#user-name
    Sleep  0.5s
    Remove element  ${dot}
    Add dot  jquery=#personaltools-logout
    Sleep  0.5s
    Disable autologin
    Click link  Log out
    Sleep  4s
