/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Random;

public class WebSocketFrame {
    private static Charset utf8 = Charset.forName("utf-8");
    private boolean fin = true;
    private Opcode opcode = Opcode.TEXT;
    private boolean mask = true;
    private byte[] maskingKey = new byte[4];
    private byte[] payload;

    public WebSocketFrame(String payload) {
        this(payload.getBytes(utf8));
    }

    public WebSocketFrame(byte[] payload) {
        new Random().nextBytes(this.maskingKey);
        this.payload = payload;
    }

    public boolean isFin() {
        return this.fin;
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public void setOpcode(Opcode opcode) {
        this.opcode = opcode;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void setMask(boolean mask) {
        this.mask = mask;
    }

    public byte[] getMaskingKey() {
        return this.maskingKey;
    }

    public void setMaskingKey(byte[] maskingKey) {
        this.maskingKey = maskingKey;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public byte[] encode() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int b1 = this.opcode.getCode();
        if (this.fin) {
            b1 |= 0x80;
        }
        bos.write(b1);
        int len = this.payload.length;
        if (len <= 125) {
            bos.write(this.maskBit(len));
        } else if (len <= 65535) {
            bos.write(this.maskBit(126));
            bos.write(len >> 8);
            bos.write(len);
        } else {
            bos.write(this.maskBit(127));
            bos.write(0);
            bos.write(0);
            bos.write(0);
            bos.write(0);
            for (int i = 3; i >= 0; --i) {
                bos.write(len >> i * 8);
            }
        }
        try {
            if (this.mask) {
                bos.write(this.maskingKey);
                byte[] masked = new byte[this.payload.length];
                for (int i = 0; i < this.payload.length; ++i) {
                    masked[i] = (byte)(this.payload[i] ^ this.maskingKey[i % 4]);
                }
                bos.write(masked);
            } else {
                bos.write(this.payload);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    private int maskBit(int b) {
        return this.mask ? b | 0x80 : b;
    }

    public static enum Opcode {
        CONTINUATION(0),
        TEXT(1),
        BINARY(2),
        CLOSE(8),
        PING(9),
        PONG(10);

        private int code;

        private Opcode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

